package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VoiceIdentityRegister invokes the green.VoiceIdentityRegister API synchronously
func (client *Client) VoiceIdentityRegister(request *VoiceIdentityRegisterRequest) (response *VoiceIdentityRegisterResponse, err error) {
	response = CreateVoiceIdentityRegisterResponse()
	err = client.DoAction(request, response)
	return
}

// VoiceIdentityRegisterWithChan invokes the green.VoiceIdentityRegister API asynchronously
func (client *Client) VoiceIdentityRegisterWithChan(request *VoiceIdentityRegisterRequest) (<-chan *VoiceIdentityRegisterResponse, <-chan error) {
	responseChan := make(chan *VoiceIdentityRegisterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VoiceIdentityRegister(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VoiceIdentityRegisterWithCallback invokes the green.VoiceIdentityRegister API asynchronously
func (client *Client) VoiceIdentityRegisterWithCallback(request *VoiceIdentityRegisterRequest, callback func(response *VoiceIdentityRegisterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VoiceIdentityRegisterResponse
		var err error
		defer close(result)
		response, err = client.VoiceIdentityRegister(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VoiceIdentityRegisterRequest is the request struct for api VoiceIdentityRegister
type VoiceIdentityRegisterRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// VoiceIdentityRegisterResponse is the response struct for api VoiceIdentityRegister
type VoiceIdentityRegisterResponse struct {
	*responses.BaseResponse
}

// CreateVoiceIdentityRegisterRequest creates a request to invoke VoiceIdentityRegister API
func CreateVoiceIdentityRegisterRequest() (request *VoiceIdentityRegisterRequest) {
	request = &VoiceIdentityRegisterRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "VoiceIdentityRegister", "/green/voice/auth/register", "", "")
	request.Method = requests.POST
	return
}

// CreateVoiceIdentityRegisterResponse creates a response to parse from VoiceIdentityRegister response
func CreateVoiceIdentityRegisterResponse() (response *VoiceIdentityRegisterResponse) {
	response = &VoiceIdentityRegisterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
