package idrsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDetections invokes the idrsservice.ListDetections API synchronously
func (client *Client) ListDetections(request *ListDetectionsRequest) (response *ListDetectionsResponse, err error) {
	response = CreateListDetectionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDetectionsWithChan invokes the idrsservice.ListDetections API asynchronously
func (client *Client) ListDetectionsWithChan(request *ListDetectionsRequest) (<-chan *ListDetectionsResponse, <-chan error) {
	responseChan := make(chan *ListDetectionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDetections(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDetectionsWithCallback invokes the idrsservice.ListDetections API asynchronously
func (client *Client) ListDetectionsWithCallback(request *ListDetectionsRequest, callback func(response *ListDetectionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDetectionsResponse
		var err error
		defer close(result)
		response, err = client.ListDetections(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDetectionsRequest is the request struct for api ListDetections
type ListDetectionsRequest struct {
	*requests.RpcRequest
	CreateDateTo   string           `position:"Query" name:"CreateDateTo"`
	DepartmentId   string           `position:"Query" name:"DepartmentId"`
	RecordingType  string           `position:"Query" name:"RecordingType"`
	CreateDateFrom string           `position:"Query" name:"CreateDateFrom"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	PageIndex      requests.Integer `position:"Query" name:"PageIndex"`
	RuleId         string           `position:"Query" name:"RuleId"`
}

// ListDetectionsResponse is the response struct for api ListDetections
type ListDetectionsResponse struct {
	*responses.BaseResponse
	Code      string       `json:"Code" xml:"Code"`
	Message   string       `json:"Message" xml:"Message"`
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Data      Data         `json:"Data" xml:"Data"`
	Errors    []ErrorsItem `json:"Errors" xml:"Errors"`
}

// CreateListDetectionsRequest creates a request to invoke ListDetections API
func CreateListDetectionsRequest() (request *ListDetectionsRequest) {
	request = &ListDetectionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idrsservice", "2020-06-30", "ListDetections", "idrsservice", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDetectionsResponse creates a response to parse from ListDetections response
func CreateListDetectionsResponse() (response *ListDetectionsResponse) {
	response = &ListDetectionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
