package ledgerdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AcceptMember invokes the ledgerdb.AcceptMember API synchronously
// api document: https://help.aliyun.com/api/ledgerdb/acceptmember.html
func (client *Client) AcceptMember(request *AcceptMemberRequest) (response *AcceptMemberResponse, err error) {
	response = CreateAcceptMemberResponse()
	err = client.DoAction(request, response)
	return
}

// AcceptMemberWithChan invokes the ledgerdb.AcceptMember API asynchronously
// api document: https://help.aliyun.com/api/ledgerdb/acceptmember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AcceptMemberWithChan(request *AcceptMemberRequest) (<-chan *AcceptMemberResponse, <-chan error) {
	responseChan := make(chan *AcceptMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AcceptMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AcceptMemberWithCallback invokes the ledgerdb.AcceptMember API asynchronously
// api document: https://help.aliyun.com/api/ledgerdb/acceptmember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AcceptMemberWithCallback(request *AcceptMemberRequest, callback func(response *AcceptMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AcceptMemberResponse
		var err error
		defer close(result)
		response, err = client.AcceptMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AcceptMemberRequest is the request struct for api AcceptMember
type AcceptMemberRequest struct {
	*requests.RpcRequest
	PublicKey string `position:"Body" name:"PublicKey"`
	KeyType   string `position:"Body" name:"KeyType"`
	LedgerId  string `position:"Body" name:"LedgerId"`
}

// AcceptMemberResponse is the response struct for api AcceptMember
type AcceptMemberResponse struct {
	*responses.BaseResponse
	MemberId  string `json:"MemberId" xml:"MemberId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAcceptMemberRequest creates a request to invoke AcceptMember API
func CreateAcceptMemberRequest() (request *AcceptMemberRequest) {
	request = &AcceptMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ledgerdb", "2019-11-22", "AcceptMember", "ledgerdb", "openAPI")
	return
}

// CreateAcceptMemberResponse creates a response to parse from AcceptMember response
func CreateAcceptMemberResponse() (response *AcceptMemberResponse) {
	response = &AcceptMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
