package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeForbidPushStreamRoomList invokes the live.DescribeForbidPushStreamRoomList API synchronously
func (client *Client) DescribeForbidPushStreamRoomList(request *DescribeForbidPushStreamRoomListRequest) (response *DescribeForbidPushStreamRoomListResponse, err error) {
	response = CreateDescribeForbidPushStreamRoomListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeForbidPushStreamRoomListWithChan invokes the live.DescribeForbidPushStreamRoomList API asynchronously
func (client *Client) DescribeForbidPushStreamRoomListWithChan(request *DescribeForbidPushStreamRoomListRequest) (<-chan *DescribeForbidPushStreamRoomListResponse, <-chan error) {
	responseChan := make(chan *DescribeForbidPushStreamRoomListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeForbidPushStreamRoomList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeForbidPushStreamRoomListWithCallback invokes the live.DescribeForbidPushStreamRoomList API asynchronously
func (client *Client) DescribeForbidPushStreamRoomListWithCallback(request *DescribeForbidPushStreamRoomListRequest, callback func(response *DescribeForbidPushStreamRoomListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeForbidPushStreamRoomListResponse
		var err error
		defer close(result)
		response, err = client.DescribeForbidPushStreamRoomList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeForbidPushStreamRoomListRequest is the request struct for api DescribeForbidPushStreamRoomList
type DescribeForbidPushStreamRoomListRequest struct {
	*requests.RpcRequest
	PageNum  requests.Integer `position:"Query" name:"PageNum"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
	Order    string           `position:"Query" name:"Order"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	AppId    string           `position:"Query" name:"AppId"`
}

// DescribeForbidPushStreamRoomListResponse is the response struct for api DescribeForbidPushStreamRoomList
type DescribeForbidPushStreamRoomListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TotalNum  int    `json:"TotalNum" xml:"TotalNum"`
	TotalPage int    `json:"TotalPage" xml:"TotalPage"`
	RoomList  []Room `json:"RoomList" xml:"RoomList"`
}

// CreateDescribeForbidPushStreamRoomListRequest creates a request to invoke DescribeForbidPushStreamRoomList API
func CreateDescribeForbidPushStreamRoomListRequest() (request *DescribeForbidPushStreamRoomListRequest) {
	request = &DescribeForbidPushStreamRoomListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeForbidPushStreamRoomList", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeForbidPushStreamRoomListResponse creates a response to parse from DescribeForbidPushStreamRoomList response
func CreateDescribeForbidPushStreamRoomListResponse() (response *DescribeForbidPushStreamRoomListResponse) {
	response = &DescribeForbidPushStreamRoomListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
