package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLiveStreamWatermarkRule invokes the live.UpdateLiveStreamWatermarkRule API synchronously
func (client *Client) UpdateLiveStreamWatermarkRule(request *UpdateLiveStreamWatermarkRuleRequest) (response *UpdateLiveStreamWatermarkRuleResponse, err error) {
	response = CreateUpdateLiveStreamWatermarkRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLiveStreamWatermarkRuleWithChan invokes the live.UpdateLiveStreamWatermarkRule API asynchronously
func (client *Client) UpdateLiveStreamWatermarkRuleWithChan(request *UpdateLiveStreamWatermarkRuleRequest) (<-chan *UpdateLiveStreamWatermarkRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateLiveStreamWatermarkRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLiveStreamWatermarkRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLiveStreamWatermarkRuleWithCallback invokes the live.UpdateLiveStreamWatermarkRule API asynchronously
func (client *Client) UpdateLiveStreamWatermarkRuleWithCallback(request *UpdateLiveStreamWatermarkRuleRequest, callback func(response *UpdateLiveStreamWatermarkRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLiveStreamWatermarkRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateLiveStreamWatermarkRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLiveStreamWatermarkRuleRequest is the request struct for api UpdateLiveStreamWatermarkRule
type UpdateLiveStreamWatermarkRuleRequest struct {
	*requests.RpcRequest
	Description string           `position:"Query" name:"Description"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	TemplateId  string           `position:"Query" name:"TemplateId"`
	Name        string           `position:"Query" name:"Name"`
	RuleId      string           `position:"Query" name:"RuleId"`
}

// UpdateLiveStreamWatermarkRuleResponse is the response struct for api UpdateLiveStreamWatermarkRule
type UpdateLiveStreamWatermarkRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLiveStreamWatermarkRuleRequest creates a request to invoke UpdateLiveStreamWatermarkRule API
func CreateUpdateLiveStreamWatermarkRuleRequest() (request *UpdateLiveStreamWatermarkRuleRequest) {
	request = &UpdateLiveStreamWatermarkRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "UpdateLiveStreamWatermarkRule", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLiveStreamWatermarkRuleResponse creates a response to parse from UpdateLiveStreamWatermarkRule response
func CreateUpdateLiveStreamWatermarkRuleResponse() (response *UpdateLiveStreamWatermarkRuleResponse) {
	response = &UpdateLiveStreamWatermarkRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
