package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryGatewayRegion invokes the mse.QueryGatewayRegion API synchronously
func (client *Client) QueryGatewayRegion(request *QueryGatewayRegionRequest) (response *QueryGatewayRegionResponse, err error) {
	response = CreateQueryGatewayRegionResponse()
	err = client.DoAction(request, response)
	return
}

// QueryGatewayRegionWithChan invokes the mse.QueryGatewayRegion API asynchronously
func (client *Client) QueryGatewayRegionWithChan(request *QueryGatewayRegionRequest) (<-chan *QueryGatewayRegionResponse, <-chan error) {
	responseChan := make(chan *QueryGatewayRegionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryGatewayRegion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryGatewayRegionWithCallback invokes the mse.QueryGatewayRegion API asynchronously
func (client *Client) QueryGatewayRegionWithCallback(request *QueryGatewayRegionRequest, callback func(response *QueryGatewayRegionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryGatewayRegionResponse
		var err error
		defer close(result)
		response, err = client.QueryGatewayRegion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryGatewayRegionRequest is the request struct for api QueryGatewayRegion
type QueryGatewayRegionRequest struct {
	*requests.RpcRequest
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
}

// QueryGatewayRegionResponse is the response struct for api QueryGatewayRegion
type QueryGatewayRegionResponse struct {
	*responses.BaseResponse
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	Code           int      `json:"Code" xml:"Code"`
	Success        bool     `json:"Success" xml:"Success"`
	Data           []string `json:"Data" xml:"Data"`
}

// CreateQueryGatewayRegionRequest creates a request to invoke QueryGatewayRegion API
func CreateQueryGatewayRegionRequest() (request *QueryGatewayRegionRequest) {
	request = &QueryGatewayRegionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "QueryGatewayRegion", "", "")
	request.Method = requests.GET
	return
}

// CreateQueryGatewayRegionResponse creates a response to parse from QueryGatewayRegion response
func CreateQueryGatewayRegionResponse() (response *QueryGatewayRegionResponse) {
	response = &QueryGatewayRegionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
