package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEncryptionKeyList invokes the r_kvstore.DescribeEncryptionKeyList API synchronously
func (client *Client) DescribeEncryptionKeyList(request *DescribeEncryptionKeyListRequest) (response *DescribeEncryptionKeyListResponse, err error) {
	response = CreateDescribeEncryptionKeyListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEncryptionKeyListWithChan invokes the r_kvstore.DescribeEncryptionKeyList API asynchronously
func (client *Client) DescribeEncryptionKeyListWithChan(request *DescribeEncryptionKeyListRequest) (<-chan *DescribeEncryptionKeyListResponse, <-chan error) {
	responseChan := make(chan *DescribeEncryptionKeyListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEncryptionKeyList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEncryptionKeyListWithCallback invokes the r_kvstore.DescribeEncryptionKeyList API asynchronously
func (client *Client) DescribeEncryptionKeyListWithCallback(request *DescribeEncryptionKeyListRequest, callback func(response *DescribeEncryptionKeyListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEncryptionKeyListResponse
		var err error
		defer close(result)
		response, err = client.DescribeEncryptionKeyList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEncryptionKeyListRequest is the request struct for api DescribeEncryptionKeyList
type DescribeEncryptionKeyListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// DescribeEncryptionKeyListResponse is the response struct for api DescribeEncryptionKeyList
type DescribeEncryptionKeyListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	KeyIds    KeyIds `json:"KeyIds" xml:"KeyIds"`
}

// CreateDescribeEncryptionKeyListRequest creates a request to invoke DescribeEncryptionKeyList API
func CreateDescribeEncryptionKeyListRequest() (request *DescribeEncryptionKeyListRequest) {
	request = &DescribeEncryptionKeyListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "DescribeEncryptionKeyList", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEncryptionKeyListResponse creates a response to parse from DescribeEncryptionKeyList response
func CreateDescribeEncryptionKeyListResponse() (response *DescribeEncryptionKeyListResponse) {
	response = &DescribeEncryptionKeyListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
