package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBInstanceMetrics invokes the rds.ModifyDBInstanceMetrics API synchronously
func (client *Client) ModifyDBInstanceMetrics(request *ModifyDBInstanceMetricsRequest) (response *ModifyDBInstanceMetricsResponse, err error) {
	response = CreateModifyDBInstanceMetricsResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBInstanceMetricsWithChan invokes the rds.ModifyDBInstanceMetrics API asynchronously
func (client *Client) ModifyDBInstanceMetricsWithChan(request *ModifyDBInstanceMetricsRequest) (<-chan *ModifyDBInstanceMetricsResponse, <-chan error) {
	responseChan := make(chan *ModifyDBInstanceMetricsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBInstanceMetrics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBInstanceMetricsWithCallback invokes the rds.ModifyDBInstanceMetrics API asynchronously
func (client *Client) ModifyDBInstanceMetricsWithCallback(request *ModifyDBInstanceMetricsRequest, callback func(response *ModifyDBInstanceMetricsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBInstanceMetricsResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBInstanceMetrics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBInstanceMetricsRequest is the request struct for api ModifyDBInstanceMetrics
type ModifyDBInstanceMetricsRequest struct {
	*requests.RpcRequest
	DBInstanceName       string           `position:"Query" name:"DBInstanceName"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	MetricsConfig        string           `position:"Query" name:"MetricsConfig"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Scope                string           `position:"Query" name:"Scope"`
}

// ModifyDBInstanceMetricsResponse is the response struct for api ModifyDBInstanceMetrics
type ModifyDBInstanceMetricsResponse struct {
	*responses.BaseResponse
	DBInstanceId string `json:"DBInstanceId" xml:"DBInstanceId"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Scope        string `json:"Scope" xml:"Scope"`
}

// CreateModifyDBInstanceMetricsRequest creates a request to invoke ModifyDBInstanceMetrics API
func CreateModifyDBInstanceMetricsRequest() (request *ModifyDBInstanceMetricsRequest) {
	request = &ModifyDBInstanceMetricsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "ModifyDBInstanceMetrics", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDBInstanceMetricsResponse creates a response to parse from ModifyDBInstanceMetrics response
func CreateModifyDBInstanceMetricsResponse() (response *ModifyDBInstanceMetricsResponse) {
	response = &ModifyDBInstanceMetricsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
