package reid

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFootwearEvent invokes the reid.GetFootwearEvent API synchronously
// api document: https://help.aliyun.com/api/reid/getfootwearevent.html
func (client *Client) GetFootwearEvent(request *GetFootwearEventRequest) (response *GetFootwearEventResponse, err error) {
	response = CreateGetFootwearEventResponse()
	err = client.DoAction(request, response)
	return
}

// GetFootwearEventWithChan invokes the reid.GetFootwearEvent API asynchronously
// api document: https://help.aliyun.com/api/reid/getfootwearevent.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetFootwearEventWithChan(request *GetFootwearEventRequest) (<-chan *GetFootwearEventResponse, <-chan error) {
	responseChan := make(chan *GetFootwearEventResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFootwearEvent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFootwearEventWithCallback invokes the reid.GetFootwearEvent API asynchronously
// api document: https://help.aliyun.com/api/reid/getfootwearevent.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetFootwearEventWithCallback(request *GetFootwearEventRequest, callback func(response *GetFootwearEventResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFootwearEventResponse
		var err error
		defer close(result)
		response, err = client.GetFootwearEvent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFootwearEventRequest is the request struct for api GetFootwearEvent
type GetFootwearEventRequest struct {
	*requests.RpcRequest
	Date    string           `position:"Body" name:"Date"`
	StoreId requests.Integer `position:"Body" name:"StoreId"`
}

// GetFootwearEventResponse is the response struct for api GetFootwearEvent
type GetFootwearEventResponse struct {
	*responses.BaseResponse
	ErrorCode         string            `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage      string            `json:"ErrorMessage" xml:"ErrorMessage"`
	Message           string            `json:"Message" xml:"Message"`
	Code              string            `json:"Code" xml:"Code"`
	DynamicCode       string            `json:"DynamicCode" xml:"DynamicCode"`
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	Success           bool              `json:"Success" xml:"Success"`
	DynamicMessage    string            `json:"DynamicMessage" xml:"DynamicMessage"`
	FootwearEventList FootwearEventList `json:"FootwearEventList" xml:"FootwearEventList"`
}

// CreateGetFootwearEventRequest creates a request to invoke GetFootwearEvent API
func CreateGetFootwearEventRequest() (request *GetFootwearEventRequest) {
	request = &GetFootwearEventRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("reid", "2019-09-28", "GetFootwearEvent", "1.1.8.2", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetFootwearEventResponse creates a response to parse from GetFootwearEvent response
func CreateGetFootwearEventResponse() (response *GetFootwearEventResponse) {
	response = &GetFootwearEventResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
