package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDeployConfig invokes the retailcloud.CreateDeployConfig API synchronously
func (client *Client) CreateDeployConfig(request *CreateDeployConfigRequest) (response *CreateDeployConfigResponse, err error) {
	response = CreateCreateDeployConfigResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDeployConfigWithChan invokes the retailcloud.CreateDeployConfig API asynchronously
func (client *Client) CreateDeployConfigWithChan(request *CreateDeployConfigRequest) (<-chan *CreateDeployConfigResponse, <-chan error) {
	responseChan := make(chan *CreateDeployConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDeployConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDeployConfigWithCallback invokes the retailcloud.CreateDeployConfig API asynchronously
func (client *Client) CreateDeployConfigWithCallback(request *CreateDeployConfigRequest, callback func(response *CreateDeployConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDeployConfigResponse
		var err error
		defer close(result)
		response, err = client.CreateDeployConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDeployConfigRequest is the request struct for api CreateDeployConfig
type CreateDeployConfigRequest struct {
	*requests.RpcRequest
	CodePath      string           `position:"Query" name:"CodePath"`
	ConfigMapList *[]string        `position:"Query" name:"ConfigMapList"  type:"Repeated"`
	AppId         requests.Integer `position:"Query" name:"AppId"`
	ConfigMap     string           `position:"Query" name:"ConfigMap"`
	StatefulSet   string           `position:"Query" name:"StatefulSet"`
	EnvType       string           `position:"Query" name:"EnvType"`
	Name          string           `position:"Query" name:"Name"`
	SecretList    *[]string        `position:"Query" name:"SecretList"  type:"Repeated"`
	CronJob       string           `position:"Query" name:"CronJob"`
	Deployment    string           `position:"Query" name:"Deployment"`
}

// CreateDeployConfigResponse is the response struct for api CreateDeployConfig
type CreateDeployConfigResponse struct {
	*responses.BaseResponse
	Code       int    `json:"Code" xml:"Code"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	ErrMessage string `json:"ErrMessage" xml:"ErrMessage"`
	Result     Result `json:"Result" xml:"Result"`
}

// CreateCreateDeployConfigRequest creates a request to invoke CreateDeployConfig API
func CreateCreateDeployConfigRequest() (request *CreateDeployConfigRequest) {
	request = &CreateDeployConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "CreateDeployConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDeployConfigResponse creates a response to parse from CreateDeployConfig response
func CreateCreateDeployConfigResponse() (response *CreateDeployConfigResponse) {
	response = &CreateDeployConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
