package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteElasticGatewayPrivateZone invokes the sgw.DeleteElasticGatewayPrivateZone API synchronously
func (client *Client) DeleteElasticGatewayPrivateZone(request *DeleteElasticGatewayPrivateZoneRequest) (response *DeleteElasticGatewayPrivateZoneResponse, err error) {
	response = CreateDeleteElasticGatewayPrivateZoneResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteElasticGatewayPrivateZoneWithChan invokes the sgw.DeleteElasticGatewayPrivateZone API asynchronously
func (client *Client) DeleteElasticGatewayPrivateZoneWithChan(request *DeleteElasticGatewayPrivateZoneRequest) (<-chan *DeleteElasticGatewayPrivateZoneResponse, <-chan error) {
	responseChan := make(chan *DeleteElasticGatewayPrivateZoneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteElasticGatewayPrivateZone(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteElasticGatewayPrivateZoneWithCallback invokes the sgw.DeleteElasticGatewayPrivateZone API asynchronously
func (client *Client) DeleteElasticGatewayPrivateZoneWithCallback(request *DeleteElasticGatewayPrivateZoneRequest, callback func(response *DeleteElasticGatewayPrivateZoneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteElasticGatewayPrivateZoneResponse
		var err error
		defer close(result)
		response, err = client.DeleteElasticGatewayPrivateZone(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteElasticGatewayPrivateZoneRequest is the request struct for api DeleteElasticGatewayPrivateZone
type DeleteElasticGatewayPrivateZoneRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// DeleteElasticGatewayPrivateZoneResponse is the response struct for api DeleteElasticGatewayPrivateZone
type DeleteElasticGatewayPrivateZoneResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateDeleteElasticGatewayPrivateZoneRequest creates a request to invoke DeleteElasticGatewayPrivateZone API
func CreateDeleteElasticGatewayPrivateZoneRequest() (request *DeleteElasticGatewayPrivateZoneRequest) {
	request = &DeleteElasticGatewayPrivateZoneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DeleteElasticGatewayPrivateZone", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteElasticGatewayPrivateZoneResponse creates a response to parse from DeleteElasticGatewayPrivateZone response
func CreateDeleteElasticGatewayPrivateZoneResponse() (response *DeleteElasticGatewayPrivateZoneResponse) {
	response = &DeleteElasticGatewayPrivateZoneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
