package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReportGatewayInfo invokes the sgw.ReportGatewayInfo API synchronously
func (client *Client) ReportGatewayInfo(request *ReportGatewayInfoRequest) (response *ReportGatewayInfoResponse, err error) {
	response = CreateReportGatewayInfoResponse()
	err = client.DoAction(request, response)
	return
}

// ReportGatewayInfoWithChan invokes the sgw.ReportGatewayInfo API asynchronously
func (client *Client) ReportGatewayInfoWithChan(request *ReportGatewayInfoRequest) (<-chan *ReportGatewayInfoResponse, <-chan error) {
	responseChan := make(chan *ReportGatewayInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReportGatewayInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReportGatewayInfoWithCallback invokes the sgw.ReportGatewayInfo API asynchronously
func (client *Client) ReportGatewayInfoWithCallback(request *ReportGatewayInfoRequest, callback func(response *ReportGatewayInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReportGatewayInfoResponse
		var err error
		defer close(result)
		response, err = client.ReportGatewayInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReportGatewayInfoRequest is the request struct for api ReportGatewayInfo
type ReportGatewayInfoRequest struct {
	*requests.RpcRequest
	ClientUUID    string           `position:"Query" name:"ClientUUID"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	GatewayStatus string           `position:"Query" name:"GatewayStatus"`
	Time          requests.Integer `position:"Query" name:"Time"`
	GatewayId     string           `position:"Query" name:"GatewayId"`
	Info          string           `position:"Query" name:"Info"`
}

// ReportGatewayInfoResponse is the response struct for api ReportGatewayInfo
type ReportGatewayInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateReportGatewayInfoRequest creates a request to invoke ReportGatewayInfo API
func CreateReportGatewayInfoRequest() (request *ReportGatewayInfoRequest) {
	request = &ReportGatewayInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "ReportGatewayInfo", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReportGatewayInfoResponse creates a response to parse from ReportGatewayInfo response
func CreateReportGatewayInfoResponse() (response *ReportGatewayInfoResponse) {
	response = &ReportGatewayInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
