package smarthosting

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListManagedHosts invokes the smarthosting.ListManagedHosts API synchronously
// api document: https://help.aliyun.com/api/smarthosting/listmanagedhosts.html
func (client *Client) ListManagedHosts(request *ListManagedHostsRequest) (response *ListManagedHostsResponse, err error) {
	response = CreateListManagedHostsResponse()
	err = client.DoAction(request, response)
	return
}

// ListManagedHostsWithChan invokes the smarthosting.ListManagedHosts API asynchronously
// api document: https://help.aliyun.com/api/smarthosting/listmanagedhosts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListManagedHostsWithChan(request *ListManagedHostsRequest) (<-chan *ListManagedHostsResponse, <-chan error) {
	responseChan := make(chan *ListManagedHostsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListManagedHosts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListManagedHostsWithCallback invokes the smarthosting.ListManagedHosts API asynchronously
// api document: https://help.aliyun.com/api/smarthosting/listmanagedhosts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListManagedHostsWithCallback(request *ListManagedHostsRequest, callback func(response *ListManagedHostsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListManagedHostsResponse
		var err error
		defer close(result)
		response, err = client.ListManagedHosts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListManagedHostsRequest is the request struct for api ListManagedHosts
type ListManagedHostsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId       requests.Integer       `position:"Query" name:"ResourceOwnerId"`
	HostType              string                 `position:"Query" name:"HostType"`
	Mode                  string                 `position:"Query" name:"Mode"`
	ResourceGroupId       string                 `position:"Query" name:"ResourceGroupId"`
	NextToken             string                 `position:"Query" name:"NextToken"`
	Tag                   *[]ListManagedHostsTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceOwnerAccount  string                 `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount          string                 `position:"Query" name:"OwnerAccount"`
	ManagedHostId         *[]string              `position:"Query" name:"ManagedHostId"  type:"Repeated"`
	OwnerId               requests.Integer       `position:"Query" name:"OwnerId"`
	ManagedPrivateSpaceId string                 `position:"Query" name:"ManagedPrivateSpaceId"`
	ZoneId                string                 `position:"Query" name:"ZoneId"`
	MaxResults            requests.Integer       `position:"Query" name:"MaxResults"`
	ManagedHostName       string                 `position:"Query" name:"ManagedHostName"`
	Status                string                 `position:"Query" name:"Status"`
}

// ListManagedHostsTag is a repeated param struct in ListManagedHostsRequest
type ListManagedHostsTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// ListManagedHostsResponse is the response struct for api ListManagedHosts
type ListManagedHostsResponse struct {
	*responses.BaseResponse
	NextToken       string                            `json:"NextToken" xml:"NextToken"`
	PageSize        int                               `json:"PageSize" xml:"PageSize"`
	RequestId       string                            `json:"RequestId" xml:"RequestId"`
	TotalCount      int                               `json:"TotalCount" xml:"TotalCount"`
	ManagedHostSets ManagedHostSetsInListManagedHosts `json:"ManagedHostSets" xml:"ManagedHostSets"`
}

// CreateListManagedHostsRequest creates a request to invoke ListManagedHosts API
func CreateListManagedHostsRequest() (request *ListManagedHostsRequest) {
	request = &ListManagedHostsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SmartHosting", "2020-08-01", "ListManagedHosts", "smarthosting", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListManagedHostsResponse creates a response to parse from ListManagedHosts response
func CreateListManagedHostsResponse() (response *ListManagedHostsResponse) {
	response = &ListManagedHostsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
