package teslamaxcompute

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetQuotaHistoryInfo invokes the teslamaxcompute.GetQuotaHistoryInfo API synchronously
// api document: https://help.aliyun.com/api/teslamaxcompute/getquotahistoryinfo.html
func (client *Client) GetQuotaHistoryInfo(request *GetQuotaHistoryInfoRequest) (response *GetQuotaHistoryInfoResponse, err error) {
	response = CreateGetQuotaHistoryInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetQuotaHistoryInfoWithChan invokes the teslamaxcompute.GetQuotaHistoryInfo API asynchronously
// api document: https://help.aliyun.com/api/teslamaxcompute/getquotahistoryinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetQuotaHistoryInfoWithChan(request *GetQuotaHistoryInfoRequest) (<-chan *GetQuotaHistoryInfoResponse, <-chan error) {
	responseChan := make(chan *GetQuotaHistoryInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetQuotaHistoryInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetQuotaHistoryInfoWithCallback invokes the teslamaxcompute.GetQuotaHistoryInfo API asynchronously
// api document: https://help.aliyun.com/api/teslamaxcompute/getquotahistoryinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetQuotaHistoryInfoWithCallback(request *GetQuotaHistoryInfoRequest, callback func(response *GetQuotaHistoryInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetQuotaHistoryInfoResponse
		var err error
		defer close(result)
		response, err = client.GetQuotaHistoryInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetQuotaHistoryInfoRequest is the request struct for api GetQuotaHistoryInfo
type GetQuotaHistoryInfoRequest struct {
	*requests.RpcRequest
	Cluster   string           `position:"Query" name:"Cluster"`
	EndTime   requests.Integer `position:"Query" name:"EndTime"`
	StartTime requests.Integer `position:"Query" name:"StartTime"`
	Region    string           `position:"Query" name:"Region"`
	QuotaName string           `position:"Query" name:"QuotaName"`
}

// GetQuotaHistoryInfoResponse is the response struct for api GetQuotaHistoryInfo
type GetQuotaHistoryInfoResponse struct {
	*responses.BaseResponse
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetQuotaHistoryInfoRequest creates a request to invoke GetQuotaHistoryInfo API
func CreateGetQuotaHistoryInfoRequest() (request *GetQuotaHistoryInfoRequest) {
	request = &GetQuotaHistoryInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("TeslaMaxCompute", "2018-01-04", "GetQuotaHistoryInfo", "teslamaxcompute", "openAPI")
	return
}

// CreateGetQuotaHistoryInfoResponse creates a response to parse from GetQuotaHistoryInfo response
func CreateGetQuotaHistoryInfoResponse() (response *GetQuotaHistoryInfoResponse) {
	response = &GetQuotaHistoryInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
