package uis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDroppedIpList invokes the uis.GetDroppedIpList API synchronously
// api document: https://help.aliyun.com/api/uis/getdroppediplist.html
func (client *Client) GetDroppedIpList(request *GetDroppedIpListRequest) (response *GetDroppedIpListResponse, err error) {
	response = CreateGetDroppedIpListResponse()
	err = client.DoAction(request, response)
	return
}

// GetDroppedIpListWithChan invokes the uis.GetDroppedIpList API asynchronously
// api document: https://help.aliyun.com/api/uis/getdroppediplist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetDroppedIpListWithChan(request *GetDroppedIpListRequest) (<-chan *GetDroppedIpListResponse, <-chan error) {
	responseChan := make(chan *GetDroppedIpListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDroppedIpList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDroppedIpListWithCallback invokes the uis.GetDroppedIpList API asynchronously
// api document: https://help.aliyun.com/api/uis/getdroppediplist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetDroppedIpListWithCallback(request *GetDroppedIpListRequest, callback func(response *GetDroppedIpListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDroppedIpListResponse
		var err error
		defer close(result)
		response, err = client.GetDroppedIpList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDroppedIpListRequest is the request struct for api GetDroppedIpList
type GetDroppedIpListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	UisId                string           `position:"Query" name:"UisId"`
	ChartDate            string           `position:"Query" name:"ChartDate"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// GetDroppedIpListResponse is the response struct for api GetDroppedIpList
type GetDroppedIpListResponse struct {
	*responses.BaseResponse
	RequestId        string `json:"RequestId" xml:"RequestId"`
	DroppedIpListUrl string `json:"DroppedIpListUrl" xml:"DroppedIpListUrl"`
}

// CreateGetDroppedIpListRequest creates a request to invoke GetDroppedIpList API
func CreateGetDroppedIpListRequest() (request *GetDroppedIpListRequest) {
	request = &GetDroppedIpListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Uis", "2018-08-21", "GetDroppedIpList", "uis", "openAPI")
	return
}

// CreateGetDroppedIpListResponse creates a response to parse from GetDroppedIpList response
func CreateGetDroppedIpListResponse() (response *GetDroppedIpListResponse) {
	response = &GetDroppedIpListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
