package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateIpsecServer invokes the vpc.CreateIpsecServer API synchronously
func (client *Client) CreateIpsecServer(request *CreateIpsecServerRequest) (response *CreateIpsecServerResponse, err error) {
	response = CreateCreateIpsecServerResponse()
	err = client.DoAction(request, response)
	return
}

// CreateIpsecServerWithChan invokes the vpc.CreateIpsecServer API asynchronously
func (client *Client) CreateIpsecServerWithChan(request *CreateIpsecServerRequest) (<-chan *CreateIpsecServerResponse, <-chan error) {
	responseChan := make(chan *CreateIpsecServerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateIpsecServer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateIpsecServerWithCallback invokes the vpc.CreateIpsecServer API asynchronously
func (client *Client) CreateIpsecServerWithCallback(request *CreateIpsecServerRequest, callback func(response *CreateIpsecServerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateIpsecServerResponse
		var err error
		defer close(result)
		response, err = client.CreateIpsecServer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateIpsecServerRequest is the request struct for api CreateIpsecServer
type CreateIpsecServerRequest struct {
	*requests.RpcRequest
	IkeConfig              string           `position:"Query" name:"IkeConfig"`
	ResourceOwnerId        requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken            string           `position:"Query" name:"ClientToken"`
	IpsecConfig            string           `position:"Query" name:"IpsecConfig"`
	Psk                    string           `position:"Query" name:"Psk"`
	LocalSubnet            string           `position:"Query" name:"LocalSubnet"`
	IDaaSInstanceId        string           `position:"Query" name:"IDaaSInstanceId"`
	EffectImmediately      requests.Boolean `position:"Query" name:"EffectImmediately"`
	ClientIpPool           string           `position:"Query" name:"ClientIpPool"`
	DryRun                 string           `position:"Query" name:"DryRun"`
	VpnGatewayId           string           `position:"Query" name:"VpnGatewayId"`
	CallerBid              string           `position:"Query" name:"callerBid"`
	PskEnabled             requests.Boolean `position:"Query" name:"PskEnabled"`
	MultiFactorAuthEnabled requests.Boolean `position:"Query" name:"MultiFactorAuthEnabled"`
	IpSecServerName        string           `position:"Query" name:"IpSecServerName"`
}

// CreateIpsecServerResponse is the response struct for api CreateIpsecServer
type CreateIpsecServerResponse struct {
	*responses.BaseResponse
	CreationTime    string `json:"CreationTime" xml:"CreationTime"`
	IpsecServerId   string `json:"IpsecServerId" xml:"IpsecServerId"`
	RequestId       string `json:"RequestId" xml:"RequestId"`
	IpsecServerName string `json:"IpsecServerName" xml:"IpsecServerName"`
	VpnGatewayId    string `json:"VpnGatewayId" xml:"VpnGatewayId"`
	RegionId        string `json:"RegionId" xml:"RegionId"`
}

// CreateCreateIpsecServerRequest creates a request to invoke CreateIpsecServer API
func CreateCreateIpsecServerRequest() (request *CreateIpsecServerRequest) {
	request = &CreateIpsecServerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CreateIpsecServer", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateIpsecServerResponse creates a response to parse from CreateIpsecServer response
func CreateCreateIpsecServerResponse() (response *CreateIpsecServerResponse) {
	response = &CreateIpsecServerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
