package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopAppEnv invokes the webplus.StopAppEnv API synchronously
// api document: https://help.aliyun.com/api/webplus/stopappenv.html
func (client *Client) StopAppEnv(request *StopAppEnvRequest) (response *StopAppEnvResponse, err error) {
	response = CreateStopAppEnvResponse()
	err = client.DoAction(request, response)
	return
}

// StopAppEnvWithChan invokes the webplus.StopAppEnv API asynchronously
// api document: https://help.aliyun.com/api/webplus/stopappenv.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StopAppEnvWithChan(request *StopAppEnvRequest) (<-chan *StopAppEnvResponse, <-chan error) {
	responseChan := make(chan *StopAppEnvResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopAppEnv(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopAppEnvWithCallback invokes the webplus.StopAppEnv API asynchronously
// api document: https://help.aliyun.com/api/webplus/stopappenv.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StopAppEnvWithCallback(request *StopAppEnvRequest, callback func(response *StopAppEnvResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopAppEnvResponse
		var err error
		defer close(result)
		response, err = client.StopAppEnv(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopAppEnvRequest is the request struct for api StopAppEnv
type StopAppEnvRequest struct {
	*requests.RoaRequest
	EnvId string `position:"Body" name:"EnvId"`
}

// StopAppEnvResponse is the response struct for api StopAppEnv
type StopAppEnvResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Code      string    `json:"Code" xml:"Code"`
	Message   string    `json:"Message" xml:"Message"`
	EnvChange EnvChange `json:"EnvChange" xml:"EnvChange"`
}

// CreateStopAppEnvRequest creates a request to invoke StopAppEnv API
func CreateStopAppEnvRequest() (request *StopAppEnvRequest) {
	request = &StopAppEnvRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "StopAppEnv", "/pop/v1/wam/appEnv/stop", "", "")
	request.Method = requests.POST
	return
}

// CreateStopAppEnvResponse creates a response to parse from StopAppEnv response
func CreateStopAppEnvResponse() (response *StopAppEnvResponse) {
	response = &StopAppEnvResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
