/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.ddl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryComplexName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySemanticUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;

public class SQLQueryObjectDataModel
extends SQLQueryRowsSourceModel
implements SQLQuerySymbolDefinition {
    private static final Log log = Log.getLog(SQLQueryObjectDataModel.class);
    @NotNull
    private final SQLQueryComplexName name;
    @NotNull
    private DBSObjectType objectType;
    @NotNull
    private Set<DBSObjectType> objectContainerTypes;
    @Nullable
    private DBSObject object = null;
    private SQLQuerySymbolOrigin objectNameOrigin = null;

    public SQLQueryObjectDataModel(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryComplexName name, @NotNull DBSObjectType objectTypes, @NotNull Set<DBSObjectType> objectContainerTypes) {
        super(syntaxNode, new SQLQueryNodeModel[0]);
        this.name = name;
        this.objectType = objectTypes;
        this.objectContainerTypes = objectContainerTypes;
    }

    @NotNull
    public DBSObjectType getObjectType() {
        return this.objectType;
    }

    @NotNull
    public SQLQueryComplexName getName() {
        return this.name;
    }

    @Nullable
    public DBSObject getObject() {
        return this.object;
    }

    @Nullable
    public SQLQuerySymbolOrigin getObjectNameOrigin() {
        return this.objectNameOrigin;
    }

    @Override
    @NotNull
    public SQLQuerySymbolClass getSymbolClass() {
        return this.object instanceof DBSTable || this.object instanceof DBSView ? SQLQuerySymbolClass.TABLE : (this.object != null ? SQLQuerySymbolClass.OBJECT : SQLQuerySymbolClass.ERROR);
    }

    @Override
    protected SQLQueryRowsSourceContext resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        HashSet<DBSObjectType> scopeMemberTypes = new HashSet<DBSObjectType>();
        scopeMemberTypes.addAll(this.objectContainerTypes);
        scopeMemberTypes.add(this.objectType);
        this.objectNameOrigin = new SQLQuerySymbolOrigin.DbObjectRef(context, scopeMemberTypes, false);
        List<? extends DBSObject> candidates = context.getConnectionInfo().findRealObjects(statistics.getMonitor(), this.objectType, this.name.stringParts);
        if (candidates.isEmpty()) {
            SQLQuerySemanticUtils.performPartialResolution(context, statistics, this.name, this.objectNameOrigin, scopeMemberTypes, SQLQuerySymbolClass.ERROR);
            statistics.appendError(this.getSyntaxNode(), "Object " + this.name.getNameString() + " not found in the database");
            return context.resetAsUnresolved();
        }
        if (candidates.size() > 1) {
            statistics.appendError(this.name.syntaxNode, "Object name " + this.name.getNameString() + " is ambiguous");
            this.name.parts.forEach(p -> p.getSymbol().setSymbolClass(SQLQuerySymbolClass.ERROR));
            return context.resetAsUnresolved();
        }
        this.object = candidates.getFirst();
        SQLQuerySemanticUtils.setNamePartsDefinition(this.name, this.object, this.objectNameOrigin);
        if (!this.objectType.getTypeClass().isAssignableFrom(this.object.getClass())) {
            statistics.appendError(this.getSyntaxNode(), SQLQuerySemanticUtils.getObjectTypeName(this.object) + " found while expecting " + this.objectType.getTypeName());
        }
        return context.reset();
    }

    @Override
    protected SQLQueryRowsDataContext resolveRowDataImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        return this.getRowsSources().makeEmptyTuple();
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitObjectReference(this, arg);
    }
}

