/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Database;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Commit;
import net.sf.jsqlparser.statement.RollbackStatement;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.alter.sequence.AlterSequence;
import net.sf.jsqlparser.statement.create.function.CreateFunction;
import net.sf.jsqlparser.statement.create.index.CreateIndex;
import net.sf.jsqlparser.statement.create.procedure.CreateProcedure;
import net.sf.jsqlparser.statement.create.schema.CreateSchema;
import net.sf.jsqlparser.statement.create.sequence.CreateSequence;
import net.sf.jsqlparser.statement.create.synonym.CreateSynonym;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.view.AlterView;
import net.sf.jsqlparser.statement.create.view.CreateView;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.merge.Merge;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.update.Update;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.model.sql.SQLQueryType;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLSelectItem;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.utils.CommonUtils;

public class SQLQuery
implements SQLScriptElement {
    private static final Pattern QUERY_TITLE_PATTERN = Pattern.compile("^\\s*(?:--|//|/\\*)\\s*(?:name|title)\\s*:\\s*(.+)$", 10);
    @Nullable
    private final DBPDataSource dataSource;
    @NotNull
    private String originalText;
    private Boolean isEndsWithDelimiter = null;
    @NotNull
    private String text;
    private int offset;
    private int length;
    private Object data;
    private int resultsOffset = -1;
    private int resultsMaxRows = -1;
    @Nullable
    private List<SQLQueryParameter> parameters;
    private Throwable parseError;
    private boolean parsed = false;
    @NotNull
    private SQLQueryType type;
    private Statement statement;
    private SingleTableMeta singleTableMeta;
    private SingleTableMeta rawSingleTableMetadata;
    private List<SQLSelectItem> selectItems;
    private String queryTitle;
    private String extraErrorMessage;
    private final List<String> allSelectEntitiesNames = new ArrayList<String>();

    public SQLQuery(@Nullable DBPDataSource dataSource, @NotNull String text) {
        this(dataSource, text, 0, text.length());
    }

    public SQLQuery(@Nullable DBPDataSource dataSource, @NotNull String text, @NotNull SQLQuery sourceQuery) {
        this(dataSource, text, sourceQuery, true);
    }

    public SQLQuery(@Nullable DBPDataSource dataSource, @NotNull String text, @NotNull SQLQuery sourceQuery, boolean preserveOriginal) {
        this(dataSource, text, sourceQuery.offset, sourceQuery.length);
        if (preserveOriginal) {
            this.originalText = sourceQuery.originalText;
        }
        this.parameters = sourceQuery.parameters;
        this.data = sourceQuery.data;
    }

    public SQLQuery(@Nullable DBPDataSource dataSource, @NotNull String text, int offset, int length) {
        this.dataSource = dataSource;
        this.originalText = this.text = text;
        this.offset = offset;
        this.length = length;
        this.type = SQLQueryType.UNKNOWN;
        this.queryTitle = null;
        Matcher matcher = QUERY_TITLE_PATTERN.matcher(text);
        if (matcher.find()) {
            this.queryTitle = matcher.group(1).trim();
        }
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    private void parseQuery() {
        if (this.parsed) {
            return;
        }
        this.parsed = true;
        try {
            if (CommonUtils.isEmpty((String)this.text)) {
                this.statement = null;
                this.parseError = new DBException("Empty query");
                return;
            }
            this.statement = SQLSemanticProcessor.parseQuery(this.dataSource == null ? null : this.dataSource.getSQLDialect(), this.text);
            Statement statement = this.statement;
            if (statement instanceof PlainSelect) {
                List items;
                PlainSelect plainSelect = (PlainSelect)statement;
                this.type = SQLQueryType.SELECT;
                FromItem fromItem = plainSelect.getFromItem();
                if (fromItem instanceof ParenthesedSelect) {
                    ParenthesedSelect ps = (ParenthesedSelect)fromItem;
                    if (this.isPotentiallySingleSourceSelect(plainSelect) && ps.getPlainSelect() != null && this.isPotentiallySingleSourceSelect(ps.getPlainSelect())) {
                        plainSelect = ps.getPlainSelect();
                        fromItem = plainSelect.getFromItem();
                    }
                }
                if (fromItem instanceof Table) {
                    Table fromTable = (Table)fromItem;
                    if (this.isPotentiallySingleSourceSelect(plainSelect)) {
                        boolean hasSubSelects = false;
                        boolean hasDirectSelects = false;
                        for (SelectItem si : plainSelect.getSelectItems()) {
                            if (si.getExpression() instanceof ParenthesedSelect) {
                                hasSubSelects = true;
                                continue;
                            }
                            if (!(si.getExpression() instanceof Column)) continue;
                            hasDirectSelects = true;
                        }
                        if (hasDirectSelects || !hasSubSelects) {
                            this.fillSingleSource(fromTable);
                        }
                    }
                }
                if (!CommonUtils.isEmpty((Collection)plainSelect.getJoins()) && fromItem instanceof Table) {
                    this.createTargetName(plainSelect, (Table)fromItem);
                }
                if (!(items = CommonUtils.safeList((List)plainSelect.getSelectItems()).stream().filter(this::isValidSelectItem).map(item -> new SQLSelectItem(this, (SelectItem<?>)item)).collect(Collectors.toList())).isEmpty()) {
                    this.selectItems = items;
                }
            } else {
                Statement statement2 = this.statement;
                if (statement2 instanceof Insert) {
                    Insert insert = (Insert)statement2;
                    this.type = SQLQueryType.INSERT;
                    this.fillSingleSource(insert.getTable());
                } else {
                    Statement statement3 = this.statement;
                    if (statement3 instanceof Update) {
                        Update update = (Update)statement3;
                        this.type = SQLQueryType.UPDATE;
                        Table table = update.getTable();
                        if (table != null) {
                            this.fillSingleSource(table);
                        }
                    } else {
                        Statement statement4 = this.statement;
                        if (statement4 instanceof Delete) {
                            Delete delete = (Delete)statement4;
                            this.type = SQLQueryType.DELETE;
                            if (delete.getTable() != null) {
                                this.fillSingleSource(delete.getTable());
                            } else {
                                List tables = delete.getTables();
                                if (tables != null && tables.size() == 1) {
                                    this.fillSingleSource((Table)tables.get(0));
                                }
                            }
                        } else {
                            this.type = this.statement instanceof Alter || this.statement instanceof CreateTable || this.statement instanceof CreateView || this.statement instanceof Drop || this.statement instanceof CreateIndex ? SQLQueryType.DDL : (this.statement instanceof Merge ? SQLQueryType.MERGE : (this.statement instanceof Commit ? SQLQueryType.COMMIT : (this.statement instanceof RollbackStatement ? SQLQueryType.ROLLBACK : SQLQueryType.UNKNOWN)));
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            this.type = SQLQueryType.UNKNOWN;
            this.parseError = e;
        }
    }

    private boolean isValidSelectItem(@NotNull SelectItem<?> item) {
        String name;
        Expression expr;
        if (this.dataSource != null && (expr = item.getExpression()) instanceof Column && CommonUtils.isNotEmpty((String)(name = CommonUtils.trim((String)((Column)expr).getColumnName())))) {
            String[] stringArray = this.dataSource.getSQLDialect().getSingleLineComments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String comment = stringArray[n2];
                if (name.startsWith(comment)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private boolean isPotentiallySingleSourceSelect(PlainSelect plainSelect) {
        return CommonUtils.isEmpty((Collection)plainSelect.getJoins()) && (plainSelect.getGroupBy() == null || CommonUtils.isEmpty((Collection)plainSelect.getGroupBy().getGroupByExpressionList())) && CommonUtils.isEmpty((Collection)plainSelect.getIntoTables());
    }

    private void fillSingleSource(Table fromItem) {
        this.rawSingleTableMetadata = this.createOriginalSourceTableMetaData(fromItem);
        this.singleTableMeta = this.createUnquotedTableMetaData(this.rawSingleTableMetadata);
    }

    SingleTableMeta createTableMetaData(Table fromItem) {
        return this.createUnquotedTableMetaData(this.createOriginalSourceTableMetaData(fromItem));
    }

    private SingleTableMeta createOriginalSourceTableMetaData(Table fromItem) {
        Database database = fromItem.getDatabase();
        String catalogName = database == null ? null : database.getDatabaseName();
        String schemaName = fromItem.getSchemaName();
        String tableName = fromItem.getName();
        return new SingleTableMeta(catalogName, schemaName, tableName);
    }

    private SingleTableMeta createUnquotedTableMetaData(SingleTableMeta tableMeta) {
        return new SingleTableMeta(this.unquoteIdentifier(tableMeta.getCatalogName()), this.unquoteIdentifier(tableMeta.getSchemaName()), this.unquoteIdentifier(tableMeta.getEntityName()));
    }

    private String unquoteIdentifier(String name) {
        if (name == null) {
            return null;
        }
        return this.dataSource == null ? DBUtils.getUnQuotedIdentifier(name, "\"") : DBUtils.getUnQuotedIdentifier(this.dataSource, name);
    }

    public boolean isPlainSelect() {
        this.parseQuery();
        Statement statement = this.statement;
        if (statement instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)statement;
            return CommonUtils.isEmpty((Collection)plainSelect.getIntoTables()) && plainSelect.getLimit() == null && plainSelect.getTop() == null && plainSelect.getForMode() == null;
        }
        return false;
    }

    public SQLSelectItem getSelectItem(String name) {
        if (this.selectItems == null) {
            return null;
        }
        for (SQLSelectItem item : this.selectItems) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    public int getSelectItemCount() {
        return this.selectItems == null ? 0 : this.selectItems.size();
    }

    public SQLSelectItem getSelectItem(int index) {
        return this.selectItems == null || this.selectItems.size() <= index ? null : this.selectItems.get(index);
    }

    public int getSelectItemAsteriskIndex() {
        if (this.selectItems != null) {
            int i = 0;
            while (i < this.selectItems.size()) {
                SQLSelectItem item = this.selectItems.get(i);
                if (item.getName().contains("*")) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private void createTargetName(@NotNull PlainSelect plainSelect, @NotNull Table fromItem) {
        String fromItemName = fromItem.getName();
        if (CommonUtils.isNotEmpty((String)fromItemName)) {
            this.allSelectEntitiesNames.add(fromItemName);
        }
        List joins = plainSelect.getJoins();
        for (Join join : joins) {
            String name;
            FromItem rightItem = join.getRightItem();
            if (!(rightItem instanceof Table) || !CommonUtils.isNotEmpty((String)(name = ((Table)rightItem).getName()))) continue;
            this.allSelectEntitiesNames.add(name);
        }
    }

    @NotNull
    public List<String> getAllSelectEntitiesNames() {
        return this.allSelectEntitiesNames;
    }

    @Override
    @NotNull
    public String getOriginalText() {
        return this.originalText;
    }

    public void setOriginalText(@NotNull String originalText) {
        this.originalText = originalText;
    }

    @Override
    @NotNull
    public String getText() {
        return this.text;
    }

    public void setText(@NotNull String text) {
        this.text = text;
    }

    public String getQueryTitle() {
        return this.queryTitle;
    }

    @Nullable
    public Statement getStatement() {
        this.parseQuery();
        return this.statement;
    }

    public Throwable getParseError() {
        return this.parseError;
    }

    @Nullable
    public List<SQLQueryParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    public Boolean isEndsWithDelimiter() {
        return this.isEndsWithDelimiter;
    }

    public void setEndsWithDelimiter(boolean value) {
        this.isEndsWithDelimiter = value;
    }

    @NotNull
    public SQLQueryType getType() {
        this.parseQuery();
        return this.type;
    }

    public DBCEntityMetaData getEntityMetadata(boolean raw) {
        this.parseQuery();
        return raw ? this.rawSingleTableMetadata : this.singleTableMeta;
    }

    public void setParameters(@Nullable List<SQLQueryParameter> parameters) {
        this.parameters = parameters;
    }

    @Override
    public void reset() {
        this.text = this.originalText;
        if (this.parameters != null) {
            this.setParameters(this.parameters);
        }
    }

    public String toString() {
        return this.text;
    }

    public String getExtraErrorMessage() {
        return this.extraErrorMessage;
    }

    public void addExtraErrorMessage(String extraErrorMessage) {
        this.extraErrorMessage = CommonUtils.isEmpty((String)this.extraErrorMessage) ? extraErrorMessage : this.extraErrorMessage + System.lineSeparator() + extraErrorMessage;
    }

    public void setResultSetLimit(int rowOffset, int maxRows) {
        this.resultsOffset = rowOffset;
        this.resultsMaxRows = maxRows;
    }

    public int getResultsOffset() {
        return this.resultsOffset;
    }

    public int getResultsMaxRows() {
        return this.resultsMaxRows;
    }

    public boolean isDeleteUpdateDangerous() {
        this.parseQuery();
        if (this.statement == null) {
            return false;
        }
        Statement statement = this.statement;
        if (statement instanceof Delete) {
            Delete delete = (Delete)statement;
            return delete.getWhere() == null;
        }
        Statement statement2 = this.statement;
        if (statement2 instanceof Update) {
            Update update = (Update)statement2;
            return update.getWhere() == null;
        }
        return false;
    }

    public boolean isDropTableDangerous() {
        this.parseQuery();
        return this.statement != null && this.statement instanceof Drop && ((Drop)this.statement).getName() != null && ((Drop)this.statement).getType().equalsIgnoreCase("table");
    }

    public boolean isModifying() {
        if (this.getType() == SQLQueryType.UNKNOWN) {
            return false;
        }
        Statement statement = this.statement;
        if (statement instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)statement;
            return plainSelect.getForMode() != null || plainSelect.getIntoTables() != null;
        }
        return true;
    }

    public boolean isMutatingStatement() {
        this.parseQuery();
        return this.statement != null && (this.statement instanceof Drop || this.statement instanceof Delete || this.statement instanceof Update || this.statement instanceof Insert || this.statement instanceof CreateTable || this.statement instanceof CreateIndex || this.statement instanceof CreateView || this.statement instanceof CreateFunction || this.statement instanceof CreateProcedure || this.statement instanceof CreateSchema || this.statement instanceof CreateSequence || this.statement instanceof CreateSynonym || this.statement instanceof Alter || this.statement instanceof AlterView || this.statement instanceof AlterSequence);
    }

    public boolean equals(Object obj) {
        return obj instanceof SQLQuery && this.text.equals(((SQLQuery)obj).text);
    }

    private static class SingleTableMeta
    implements DBCEntityMetaData {
        private final String catalogName;
        private final String schemaName;
        private final String tableName;

        private SingleTableMeta(String catalogName, String schemaName, @NotNull String tableName) {
            this.catalogName = catalogName;
            this.schemaName = schemaName;
            this.tableName = tableName;
        }

        @Override
        @Nullable
        public String getCatalogName() {
            return this.catalogName;
        }

        @Override
        @Nullable
        public String getSchemaName() {
            return this.schemaName;
        }

        @Override
        @NotNull
        public String getEntityName() {
            return this.tableName;
        }

        @Override
        @NotNull
        public List<? extends DBCAttributeMetaData> getAttributes() {
            return Collections.emptyList();
        }

        public String toString() {
            return DBUtils.getSimpleQualifiedName(this.catalogName, this.schemaName, this.tableName);
        }

        public int hashCode() {
            return (this.catalogName == null ? 1 : this.catalogName.hashCode()) * (this.schemaName == null ? 2 : this.schemaName.hashCode()) * this.tableName.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void md2;
            if (!(obj instanceof SingleTableMeta)) {
                return false;
            }
            SingleTableMeta singleTableMeta = (SingleTableMeta)obj;
            return CommonUtils.equalObjects((Object)this.catalogName, (Object)md2.catalogName) && CommonUtils.equalObjects((Object)this.schemaName, (Object)md2.schemaName) && CommonUtils.equalObjects((Object)this.tableName, (Object)md2.tableName);
        }
    }
}

