/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.List;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;

public abstract class AbstractTokenizer
implements Tokenizer {
    protected List<String> stringToken;
    protected List<String> ignorableCharacter;
    protected List<String> ignorableStmt;
    protected char ONE_LINE_COMMENT_CHAR = (char)35;
    private boolean downcaseString = true;

    public void tokenize(SourceCode tokens, Tokens tokenEntries) {
        List code = tokens.getCode();
        for (int i = 0; i < code.size(); ++i) {
            String currentLine = (String)code.get(i);
            int loc = 0;
            while (loc < currentLine.length()) {
                StringBuffer token = new StringBuffer();
                loc = this.getTokenFromLine(currentLine, token, loc);
                if (token.length() <= 0 || this.isIgnorableString(token.toString())) continue;
                if (this.downcaseString) {
                    token = new StringBuffer(token.toString().toLowerCase());
                }
                tokenEntries.add(new TokenEntry(token.toString(), tokens.getFileName(), i + 1));
            }
        }
        tokenEntries.add(TokenEntry.getEOF());
    }

    private int getTokenFromLine(String line, StringBuffer token, int loc) {
        int j = loc;
        while (j < line.length()) {
            char tok = line.charAt(j);
            if (!Character.isWhitespace(tok) && !this.ignoreCharacter(tok)) {
                if (this.isComment(tok)) {
                    if (token.length() > 0) {
                        return j;
                    }
                    return this.getCommentToken(line, token, loc);
                }
                if (this.isString(tok)) {
                    if (token.length() > 0) {
                        return j;
                    }
                    return this.parseString(line, token, j, tok);
                }
                token.append(tok);
            } else if (token.length() > 0) {
                return j;
            }
            loc = j++;
        }
        return loc + 1;
    }

    private int parseString(String line, StringBuffer token, int loc, char stringType) {
        boolean escaped = false;
        boolean done = false;
        char tok = ' ';
        while (loc < line.length() && !done) {
            tok = line.charAt(loc);
            if (escaped && tok == stringType) {
                escaped = false;
            } else if (tok == stringType && token.length() > 0) {
                done = true;
            } else {
                escaped = tok == '\\';
            }
            token.append(tok);
            ++loc;
        }
        return loc + 1;
    }

    private boolean ignoreCharacter(char tok) {
        return this.ignorableCharacter.contains("" + tok);
    }

    private boolean isString(char tok) {
        return this.stringToken.contains("" + tok);
    }

    private boolean isComment(char tok) {
        return tok == this.ONE_LINE_COMMENT_CHAR;
    }

    private int getCommentToken(String line, StringBuffer token, int loc) {
        while (loc < line.length()) {
            token.append(line.charAt(loc++));
        }
        return loc;
    }

    private boolean isIgnorableString(String token) {
        return this.ignorableStmt.contains(token);
    }
}

