/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.gaussdb.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.gaussdb.model.GaussDBDatabase;
import org.jkiss.dbeaver.ext.gaussdb.model.GaussDBPackage;
import org.jkiss.dbeaver.ext.gaussdb.model.GaussDBSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class GaussDBPackageManager
extends SQLObjectEditor<GaussDBPackage, GaussDBDatabase>
implements DBEObjectRenamer<GaussDBPackage> {
    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 4L;
    }

    public DBSObjectCache<? extends DBSObject, GaussDBPackage> getObjectsCache(GaussDBPackage object) {
        return object.getSchema().packageCache;
    }

    public void renameObject(DBECommandContext commandContext, GaussDBPackage object, Map<String, Object> options, String newName) throws DBException {
        SQLObjectEditor.ObjectRenameCommand command = new SQLObjectEditor.ObjectRenameCommand((SQLObjectEditor)this, (DBSObject)object, ModelMessages.model_jdbc_rename_object, options, newName);
        commandContext.addCommand((DBECommand)command, (DBECommandReflector)new SQLObjectEditor.RenameObjectReflector((SQLObjectEditor)this), true);
    }

    public boolean canCreateObject(@NotNull Object container) {
        return true;
    }

    public boolean canDeleteObject(@NotNull GaussDBPackage object) {
        return true;
    }

    protected GaussDBPackage createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        GaussDBSchema schema = (GaussDBSchema)((Object)container);
        return new GaussDBPackage(schema, monitor, "NewPackage");
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) throws DBException {
        GaussDBPackage pack = (GaussDBPackage)command.getObject();
        this.createOrReplaceProcedureQuery(actions, pack);
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) throws DBException {
        if (command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) {
            this.createOrReplaceProcedureQuery(actionList, (GaussDBPackage)command.getObject());
        }
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) throws DBException {
        GaussDBPackage pack = (GaussDBPackage)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop package", "DROP PACKAGE " + pack.getName()));
    }

    private void createOrReplaceProcedureQuery(List<DBEPersistAction> actionList, GaussDBPackage pack) throws DBException {
        Object body;
        Object header = pack.getObjectDefinitionText().trim();
        if (!((String)header).endsWith(";")) {
            header = (String)header + ";";
        }
        if (!CommonUtils.isEmpty((String)header)) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Create package header", (String)header));
        }
        if (!CommonUtils.isEmpty((String)(body = pack.getExtendedDefinitionText()))) {
            if (!((String)(body = ((String)body).trim())).endsWith(";")) {
                body = (String)body + ";";
            }
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Create package body", (String)body));
        } else {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Drop package header", "DROP PACKAGE BODY " + pack.getName(), DBEPersistAction.ActionType.OPTIONAL));
        }
    }
}

