/*
 * Copyright (C) 2004 Valery Reznic <valery_reznic@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <errno.h>

/* 
 * In my first implementation I guest all exec* functions invoke execve
 * so, it'll enougth overrite only execve.
 * It's incorrect.
 *  1) There is fexecve function (at least under linux)
 *  2) Not all unixes use execve for other exec* implementation.
 * To be on the safe side I'll trap all exec*, and all _exec*
 * ( like on Solaris) and fexecve and _fexecve.
 * I hope it's all.
 */

#define NO_EXEC errno = EACCES; return -1

int execve(const char *path, char *const argv[], char * const env[])
{
	NO_EXEC;
}

int _execve(const char *path, char *const argv[], char * const env[])
{
	NO_EXEC;
}
/******/
int fexecve(int fd, char *const argv[], char * const env[])
{
	NO_EXEC;
}

int _fexecve(int fd, char *const argv[], char * const env[])
{
	NO_EXEC;
}
/******/
int execv(const char *path, char *const argv[])
{
	NO_EXEC;
}

int _execv(const char *path, char *const argv[])
{
	NO_EXEC;
}
/******/
int execle(const char *path, const char *arg, ...)
{
	NO_EXEC;
}

int _execle(const char *path, const char *arg, ...)
{
	NO_EXEC;
}
/******/
int execl(const char *path, const char *arg, ...)
{
	NO_EXEC;
}

int _execl(const char *path, const char *arg, ...)
{
	NO_EXEC;
}
/******/
int execvp(const char *path, char *const argv[])
{
	NO_EXEC;
}

int _execvp(const char *path, char *const argv[])
{
	NO_EXEC;
}
/******/
int execlp(const char *path, const char *arg, ...)
{
	NO_EXEC;
}

int _execlp(const char *path, const char *arg, ...)
{
	NO_EXEC;
}

