// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddCustomAttributes = "AddCustomAttributes"

// AddCustomAttributesRequest generates a "aws/request.Request" representing the
// client's request for the AddCustomAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddCustomAttributes for more information on using the AddCustomAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddCustomAttributesRequest method.
//    req, resp := client.AddCustomAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AddCustomAttributes
func (c *CognitoIdentityProvider) AddCustomAttributesRequest(input *AddCustomAttributesInput) (req *request.Request, output *AddCustomAttributesOutput) {
	op := &request.Operation{
		Name:       opAddCustomAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddCustomAttributesInput{}
	}

	output = &AddCustomAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddCustomAttributes API operation for Amazon Cognito Identity Provider.
//
// Adds additional user attributes to the user pool schema.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AddCustomAttributes for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserImportInProgressException
//   This exception is thrown when you're trying to modify a user pool while a
//   user import job is in progress for that pool.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AddCustomAttributes
func (c *CognitoIdentityProvider) AddCustomAttributes(input *AddCustomAttributesInput) (*AddCustomAttributesOutput, error) {
	req, out := c.AddCustomAttributesRequest(input)
	return out, req.Send()
}

// AddCustomAttributesWithContext is the same as AddCustomAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See AddCustomAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AddCustomAttributesWithContext(ctx aws.Context, input *AddCustomAttributesInput, opts ...request.Option) (*AddCustomAttributesOutput, error) {
	req, out := c.AddCustomAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminAddUserToGroup = "AdminAddUserToGroup"

// AdminAddUserToGroupRequest generates a "aws/request.Request" representing the
// client's request for the AdminAddUserToGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminAddUserToGroup for more information on using the AdminAddUserToGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminAddUserToGroupRequest method.
//    req, resp := client.AdminAddUserToGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminAddUserToGroup
func (c *CognitoIdentityProvider) AdminAddUserToGroupRequest(input *AdminAddUserToGroupInput) (req *request.Request, output *AdminAddUserToGroupOutput) {
	op := &request.Operation{
		Name:       opAdminAddUserToGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminAddUserToGroupInput{}
	}

	output = &AdminAddUserToGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminAddUserToGroup API operation for Amazon Cognito Identity Provider.
//
// Adds the specified user to the specified group.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminAddUserToGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminAddUserToGroup
func (c *CognitoIdentityProvider) AdminAddUserToGroup(input *AdminAddUserToGroupInput) (*AdminAddUserToGroupOutput, error) {
	req, out := c.AdminAddUserToGroupRequest(input)
	return out, req.Send()
}

// AdminAddUserToGroupWithContext is the same as AdminAddUserToGroup with the addition of
// the ability to pass a context and additional request options.
//
// See AdminAddUserToGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminAddUserToGroupWithContext(ctx aws.Context, input *AdminAddUserToGroupInput, opts ...request.Option) (*AdminAddUserToGroupOutput, error) {
	req, out := c.AdminAddUserToGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminConfirmSignUp = "AdminConfirmSignUp"

// AdminConfirmSignUpRequest generates a "aws/request.Request" representing the
// client's request for the AdminConfirmSignUp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminConfirmSignUp for more information on using the AdminConfirmSignUp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminConfirmSignUpRequest method.
//    req, resp := client.AdminConfirmSignUpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminConfirmSignUp
func (c *CognitoIdentityProvider) AdminConfirmSignUpRequest(input *AdminConfirmSignUpInput) (req *request.Request, output *AdminConfirmSignUpOutput) {
	op := &request.Operation{
		Name:       opAdminConfirmSignUp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminConfirmSignUpInput{}
	}

	output = &AdminConfirmSignUpOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminConfirmSignUp API operation for Amazon Cognito Identity Provider.
//
// Confirms user registration as an admin without using a confirmation code.
// Works on any user.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminConfirmSignUp for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * UnexpectedLambdaException
//   This exception is thrown when Amazon Cognito encounters an unexpected exception
//   with Lambda.
//
//   * UserLambdaValidationException
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the Lambda service.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyFailedAttemptsException
//   This exception is thrown when the user has made too many failed attempts
//   for a given action, such as sign-in.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when Amazon Cognito encounters an invalid Lambda
//   response.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested Amazon
//   Web Services resource.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminConfirmSignUp
func (c *CognitoIdentityProvider) AdminConfirmSignUp(input *AdminConfirmSignUpInput) (*AdminConfirmSignUpOutput, error) {
	req, out := c.AdminConfirmSignUpRequest(input)
	return out, req.Send()
}

// AdminConfirmSignUpWithContext is the same as AdminConfirmSignUp with the addition of
// the ability to pass a context and additional request options.
//
// See AdminConfirmSignUp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminConfirmSignUpWithContext(ctx aws.Context, input *AdminConfirmSignUpInput, opts ...request.Option) (*AdminConfirmSignUpOutput, error) {
	req, out := c.AdminConfirmSignUpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminCreateUser = "AdminCreateUser"

// AdminCreateUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminCreateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminCreateUser for more information on using the AdminCreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminCreateUserRequest method.
//    req, resp := client.AdminCreateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminCreateUser
func (c *CognitoIdentityProvider) AdminCreateUserRequest(input *AdminCreateUserInput) (req *request.Request, output *AdminCreateUserOutput) {
	op := &request.Operation{
		Name:       opAdminCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminCreateUserInput{}
	}

	output = &AdminCreateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminCreateUser API operation for Amazon Cognito Identity Provider.
//
// Creates a new user in the specified user pool.
//
// If MessageAction isn't set, the default is to send a welcome message via
// email or phone (SMS).
//
// This action might generate an SMS text message. Starting June 1, 2021, US
// telecom carriers require you to register an origination phone number before
// you can send SMS messages to US phone numbers. If you use SMS text messages
// in Amazon Cognito, you must register a phone number with Amazon Pinpoint
// (https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the
// registered number automatically. Otherwise, Amazon Cognito users who must
// receive SMS messages might not be able to sign up, activate their accounts,
// or sign in.
//
// If you have never used SMS text messages with Amazon Cognito or any other
// Amazon Web Service, Amazon Simple Notification Service might place your account
// in the SMS sandbox. In sandbox mode (https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)
// , you can send messages only to verified phone numbers. After you test your
// app while in the sandbox environment, you can move out of the sandbox and
// into production. For more information, see SMS message settings for Amazon
// Cognito user pools (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html)
// in the Amazon Cognito Developer Guide.
//
// This message is based on a template that you configured in your call to create
// or update a user pool. This template includes your custom sign-up instructions
// and placeholders for user name and temporary password.
//
// Alternatively, you can call AdminCreateUser with SUPPRESS for the MessageAction
// parameter, and Amazon Cognito won't send any email.
//
// In either case, the user will be in the FORCE_CHANGE_PASSWORD state until
// they sign in and change their password.
//
// AdminCreateUser requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminCreateUser for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UsernameExistsException
//   This exception is thrown when Amazon Cognito encounters a user name that
//   already exists in the user pool.
//
//   * InvalidPasswordException
//   This exception is thrown when Amazon Cognito encounters an invalid password.
//
//   * CodeDeliveryFailureException
//   This exception is thrown when a verification code fails to deliver successfully.
//
//   * UnexpectedLambdaException
//   This exception is thrown when Amazon Cognito encounters an unexpected exception
//   with Lambda.
//
//   * UserLambdaValidationException
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the Lambda service.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when Amazon Cognito encounters an invalid Lambda
//   response.
//
//   * PreconditionNotMetException
//   This exception is thrown when a precondition is not met.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration doesn't
//   have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is not valid for the
//   role provided for SMS configuration. This can happen if you don't trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UnsupportedUserStateException
//   The request failed because the user is in an unsupported state.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminCreateUser
func (c *CognitoIdentityProvider) AdminCreateUser(input *AdminCreateUserInput) (*AdminCreateUserOutput, error) {
	req, out := c.AdminCreateUserRequest(input)
	return out, req.Send()
}

// AdminCreateUserWithContext is the same as AdminCreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See AdminCreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminCreateUserWithContext(ctx aws.Context, input *AdminCreateUserInput, opts ...request.Option) (*AdminCreateUserOutput, error) {
	req, out := c.AdminCreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminDeleteUser = "AdminDeleteUser"

// AdminDeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminDeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminDeleteUser for more information on using the AdminDeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminDeleteUserRequest method.
//    req, resp := client.AdminDeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUser
func (c *CognitoIdentityProvider) AdminDeleteUserRequest(input *AdminDeleteUserInput) (req *request.Request, output *AdminDeleteUserOutput) {
	op := &request.Operation{
		Name:       opAdminDeleteUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminDeleteUserInput{}
	}

	output = &AdminDeleteUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminDeleteUser API operation for Amazon Cognito Identity Provider.
//
// Deletes a user as an administrator. Works on any user.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminDeleteUser for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUser
func (c *CognitoIdentityProvider) AdminDeleteUser(input *AdminDeleteUserInput) (*AdminDeleteUserOutput, error) {
	req, out := c.AdminDeleteUserRequest(input)
	return out, req.Send()
}

// AdminDeleteUserWithContext is the same as AdminDeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See AdminDeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminDeleteUserWithContext(ctx aws.Context, input *AdminDeleteUserInput, opts ...request.Option) (*AdminDeleteUserOutput, error) {
	req, out := c.AdminDeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminDeleteUserAttributes = "AdminDeleteUserAttributes"

// AdminDeleteUserAttributesRequest generates a "aws/request.Request" representing the
// client's request for the AdminDeleteUserAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminDeleteUserAttributes for more information on using the AdminDeleteUserAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminDeleteUserAttributesRequest method.
//    req, resp := client.AdminDeleteUserAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUserAttributes
func (c *CognitoIdentityProvider) AdminDeleteUserAttributesRequest(input *AdminDeleteUserAttributesInput) (req *request.Request, output *AdminDeleteUserAttributesOutput) {
	op := &request.Operation{
		Name:       opAdminDeleteUserAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminDeleteUserAttributesInput{}
	}

	output = &AdminDeleteUserAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminDeleteUserAttributes API operation for Amazon Cognito Identity Provider.
//
// Deletes the user attributes in a user pool as an administrator. Works on
// any user.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminDeleteUserAttributes for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUserAttributes
func (c *CognitoIdentityProvider) AdminDeleteUserAttributes(input *AdminDeleteUserAttributesInput) (*AdminDeleteUserAttributesOutput, error) {
	req, out := c.AdminDeleteUserAttributesRequest(input)
	return out, req.Send()
}

// AdminDeleteUserAttributesWithContext is the same as AdminDeleteUserAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See AdminDeleteUserAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminDeleteUserAttributesWithContext(ctx aws.Context, input *AdminDeleteUserAttributesInput, opts ...request.Option) (*AdminDeleteUserAttributesOutput, error) {
	req, out := c.AdminDeleteUserAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminDisableProviderForUser = "AdminDisableProviderForUser"

// AdminDisableProviderForUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminDisableProviderForUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminDisableProviderForUser for more information on using the AdminDisableProviderForUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminDisableProviderForUserRequest method.
//    req, resp := client.AdminDisableProviderForUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableProviderForUser
func (c *CognitoIdentityProvider) AdminDisableProviderForUserRequest(input *AdminDisableProviderForUserInput) (req *request.Request, output *AdminDisableProviderForUserOutput) {
	op := &request.Operation{
		Name:       opAdminDisableProviderForUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminDisableProviderForUserInput{}
	}

	output = &AdminDisableProviderForUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminDisableProviderForUser API operation for Amazon Cognito Identity Provider.
//
// Prevents the user from signing in with the specified external (SAML or social)
// identity provider. If the user that you want to deactivate is a Amazon Cognito
// user pools native username + password user, they can't use their password
// to sign in. If the user to deactivate is a linked external identity provider
// (IdP) user, any link between that user and an existing user is removed. When
// the external user signs in again, and the user is no longer attached to the
// previously linked DestinationUser, the user must create a new user account.
// See AdminLinkProviderForUser (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html).
//
// This action is enabled only for admin access and requires developer credentials.
//
// The ProviderName must match the value specified when creating an IdP for
// the pool.
//
// To deactivate a native username + password user, the ProviderName value must
// be Cognito and the ProviderAttributeName must be Cognito_Subject. The ProviderAttributeValue
// must be the name that is used in the user pool for the user.
//
// The ProviderAttributeName must always be Cognito_Subject for social identity
// providers. The ProviderAttributeValue must always be the exact subject that
// was used when the user was originally linked as a source user.
//
// For de-linking a SAML identity, there are two scenarios. If the linked identity
// has not yet been used to sign in, the ProviderAttributeName and ProviderAttributeValue
// must be the same values that were used for the SourceUser when the identities
// were originally linked using AdminLinkProviderForUser call. (If the linking
// was done with ProviderAttributeName set to Cognito_Subject, the same applies
// here). However, if the user has already signed in, the ProviderAttributeName
// must be Cognito_Subject and ProviderAttributeValue must be the subject of
// the SAML assertion.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminDisableProviderForUser for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * AliasExistsException
//   This exception is thrown when a user tries to confirm the account with an
//   email or phone number that has already been supplied as an alias from a different
//   account. This exception tells user that an account with this email or phone
//   already exists.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableProviderForUser
func (c *CognitoIdentityProvider) AdminDisableProviderForUser(input *AdminDisableProviderForUserInput) (*AdminDisableProviderForUserOutput, error) {
	req, out := c.AdminDisableProviderForUserRequest(input)
	return out, req.Send()
}

// AdminDisableProviderForUserWithContext is the same as AdminDisableProviderForUser with the addition of
// the ability to pass a context and additional request options.
//
// See AdminDisableProviderForUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminDisableProviderForUserWithContext(ctx aws.Context, input *AdminDisableProviderForUserInput, opts ...request.Option) (*AdminDisableProviderForUserOutput, error) {
	req, out := c.AdminDisableProviderForUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminDisableUser = "AdminDisableUser"

// AdminDisableUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminDisableUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminDisableUser for more information on using the AdminDisableUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminDisableUserRequest method.
//    req, resp := client.AdminDisableUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableUser
func (c *CognitoIdentityProvider) AdminDisableUserRequest(input *AdminDisableUserInput) (req *request.Request, output *AdminDisableUserOutput) {
	op := &request.Operation{
		Name:       opAdminDisableUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminDisableUserInput{}
	}

	output = &AdminDisableUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminDisableUser API operation for Amazon Cognito Identity Provider.
//
// Disables the specified user.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminDisableUser for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableUser
func (c *CognitoIdentityProvider) AdminDisableUser(input *AdminDisableUserInput) (*AdminDisableUserOutput, error) {
	req, out := c.AdminDisableUserRequest(input)
	return out, req.Send()
}

// AdminDisableUserWithContext is the same as AdminDisableUser with the addition of
// the ability to pass a context and additional request options.
//
// See AdminDisableUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminDisableUserWithContext(ctx aws.Context, input *AdminDisableUserInput, opts ...request.Option) (*AdminDisableUserOutput, error) {
	req, out := c.AdminDisableUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminEnableUser = "AdminEnableUser"

// AdminEnableUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminEnableUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminEnableUser for more information on using the AdminEnableUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminEnableUserRequest method.
//    req, resp := client.AdminEnableUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminEnableUser
func (c *CognitoIdentityProvider) AdminEnableUserRequest(input *AdminEnableUserInput) (req *request.Request, output *AdminEnableUserOutput) {
	op := &request.Operation{
		Name:       opAdminEnableUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminEnableUserInput{}
	}

	output = &AdminEnableUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminEnableUser API operation for Amazon Cognito Identity Provider.
//
// Enables the specified user as an administrator. Works on any user.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminEnableUser for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminEnableUser
func (c *CognitoIdentityProvider) AdminEnableUser(input *AdminEnableUserInput) (*AdminEnableUserOutput, error) {
	req, out := c.AdminEnableUserRequest(input)
	return out, req.Send()
}

// AdminEnableUserWithContext is the same as AdminEnableUser with the addition of
// the ability to pass a context and additional request options.
//
// See AdminEnableUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminEnableUserWithContext(ctx aws.Context, input *AdminEnableUserInput, opts ...request.Option) (*AdminEnableUserOutput, error) {
	req, out := c.AdminEnableUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminForgetDevice = "AdminForgetDevice"

// AdminForgetDeviceRequest generates a "aws/request.Request" representing the
// client's request for the AdminForgetDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminForgetDevice for more information on using the AdminForgetDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminForgetDeviceRequest method.
//    req, resp := client.AdminForgetDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminForgetDevice
func (c *CognitoIdentityProvider) AdminForgetDeviceRequest(input *AdminForgetDeviceInput) (req *request.Request, output *AdminForgetDeviceOutput) {
	op := &request.Operation{
		Name:       opAdminForgetDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminForgetDeviceInput{}
	}

	output = &AdminForgetDeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminForgetDevice API operation for Amazon Cognito Identity Provider.
//
// Forgets the device, as an administrator.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminForgetDevice for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is not valid.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminForgetDevice
func (c *CognitoIdentityProvider) AdminForgetDevice(input *AdminForgetDeviceInput) (*AdminForgetDeviceOutput, error) {
	req, out := c.AdminForgetDeviceRequest(input)
	return out, req.Send()
}

// AdminForgetDeviceWithContext is the same as AdminForgetDevice with the addition of
// the ability to pass a context and additional request options.
//
// See AdminForgetDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminForgetDeviceWithContext(ctx aws.Context, input *AdminForgetDeviceInput, opts ...request.Option) (*AdminForgetDeviceOutput, error) {
	req, out := c.AdminForgetDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminGetDevice = "AdminGetDevice"

// AdminGetDeviceRequest generates a "aws/request.Request" representing the
// client's request for the AdminGetDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminGetDevice for more information on using the AdminGetDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminGetDeviceRequest method.
//    req, resp := client.AdminGetDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetDevice
func (c *CognitoIdentityProvider) AdminGetDeviceRequest(input *AdminGetDeviceInput) (req *request.Request, output *AdminGetDeviceOutput) {
	op := &request.Operation{
		Name:       opAdminGetDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminGetDeviceInput{}
	}

	output = &AdminGetDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminGetDevice API operation for Amazon Cognito Identity Provider.
//
// Gets the device, as an administrator.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminGetDevice for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is not valid.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetDevice
func (c *CognitoIdentityProvider) AdminGetDevice(input *AdminGetDeviceInput) (*AdminGetDeviceOutput, error) {
	req, out := c.AdminGetDeviceRequest(input)
	return out, req.Send()
}

// AdminGetDeviceWithContext is the same as AdminGetDevice with the addition of
// the ability to pass a context and additional request options.
//
// See AdminGetDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminGetDeviceWithContext(ctx aws.Context, input *AdminGetDeviceInput, opts ...request.Option) (*AdminGetDeviceOutput, error) {
	req, out := c.AdminGetDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminGetUser = "AdminGetUser"

// AdminGetUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminGetUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminGetUser for more information on using the AdminGetUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminGetUserRequest method.
//    req, resp := client.AdminGetUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetUser
func (c *CognitoIdentityProvider) AdminGetUserRequest(input *AdminGetUserInput) (req *request.Request, output *AdminGetUserOutput) {
	op := &request.Operation{
		Name:       opAdminGetUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminGetUserInput{}
	}

	output = &AdminGetUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminGetUser API operation for Amazon Cognito Identity Provider.
//
// Gets the specified user by user name in a user pool as an administrator.
// Works on any user.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminGetUser for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetUser
func (c *CognitoIdentityProvider) AdminGetUser(input *AdminGetUserInput) (*AdminGetUserOutput, error) {
	req, out := c.AdminGetUserRequest(input)
	return out, req.Send()
}

// AdminGetUserWithContext is the same as AdminGetUser with the addition of
// the ability to pass a context and additional request options.
//
// See AdminGetUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminGetUserWithContext(ctx aws.Context, input *AdminGetUserInput, opts ...request.Option) (*AdminGetUserOutput, error) {
	req, out := c.AdminGetUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminInitiateAuth = "AdminInitiateAuth"

// AdminInitiateAuthRequest generates a "aws/request.Request" representing the
// client's request for the AdminInitiateAuth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminInitiateAuth for more information on using the AdminInitiateAuth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminInitiateAuthRequest method.
//    req, resp := client.AdminInitiateAuthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminInitiateAuth
func (c *CognitoIdentityProvider) AdminInitiateAuthRequest(input *AdminInitiateAuthInput) (req *request.Request, output *AdminInitiateAuthOutput) {
	op := &request.Operation{
		Name:       opAdminInitiateAuth,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminInitiateAuthInput{}
	}

	output = &AdminInitiateAuthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminInitiateAuth API operation for Amazon Cognito Identity Provider.
//
// Initiates the authentication flow, as an administrator.
//
// This action might generate an SMS text message. Starting June 1, 2021, US
// telecom carriers require you to register an origination phone number before
// you can send SMS messages to US phone numbers. If you use SMS text messages
// in Amazon Cognito, you must register a phone number with Amazon Pinpoint
// (https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the
// registered number automatically. Otherwise, Amazon Cognito users who must
// receive SMS messages might not be able to sign up, activate their accounts,
// or sign in.
//
// If you have never used SMS text messages with Amazon Cognito or any other
// Amazon Web Service, Amazon Simple Notification Service might place your account
// in the SMS sandbox. In sandbox mode (https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)
// , you can send messages only to verified phone numbers. After you test your
// app while in the sandbox environment, you can move out of the sandbox and
// into production. For more information, see SMS message settings for Amazon
// Cognito user pools (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html)
// in the Amazon Cognito Developer Guide.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminInitiateAuth for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * UnexpectedLambdaException
//   This exception is thrown when Amazon Cognito encounters an unexpected exception
//   with Lambda.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is not valid.
//
//   * UserLambdaValidationException
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the Lambda service.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when Amazon Cognito encounters an invalid Lambda
//   response.
//
//   * MFAMethodNotFoundException
//   This exception is thrown when Amazon Cognito can't find a multi-factor authentication
//   (MFA) method.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration doesn't
//   have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is not valid for the
//   role provided for SMS configuration. This can happen if you don't trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminInitiateAuth
func (c *CognitoIdentityProvider) AdminInitiateAuth(input *AdminInitiateAuthInput) (*AdminInitiateAuthOutput, error) {
	req, out := c.AdminInitiateAuthRequest(input)
	return out, req.Send()
}

// AdminInitiateAuthWithContext is the same as AdminInitiateAuth with the addition of
// the ability to pass a context and additional request options.
//
// See AdminInitiateAuth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminInitiateAuthWithContext(ctx aws.Context, input *AdminInitiateAuthInput, opts ...request.Option) (*AdminInitiateAuthOutput, error) {
	req, out := c.AdminInitiateAuthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminLinkProviderForUser = "AdminLinkProviderForUser"

// AdminLinkProviderForUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminLinkProviderForUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminLinkProviderForUser for more information on using the AdminLinkProviderForUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminLinkProviderForUserRequest method.
//    req, resp := client.AdminLinkProviderForUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminLinkProviderForUser
func (c *CognitoIdentityProvider) AdminLinkProviderForUserRequest(input *AdminLinkProviderForUserInput) (req *request.Request, output *AdminLinkProviderForUserOutput) {
	op := &request.Operation{
		Name:       opAdminLinkProviderForUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminLinkProviderForUserInput{}
	}

	output = &AdminLinkProviderForUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminLinkProviderForUser API operation for Amazon Cognito Identity Provider.
//
// Links an existing user account in a user pool (DestinationUser) to an identity
// from an external identity provider (SourceUser) based on a specified attribute
// name and value from the external identity provider. This allows you to create
// a link from the existing user account to an external federated user identity
// that has not yet been used to sign in. You can then use the federated user
// identity to sign in as the existing user account.
//
// For example, if there is an existing user with a username and password, this
// API links that user to a federated user identity. When the user signs in
// with a federated user identity, they sign in as the existing user account.
//
// The maximum number of federated identities linked to a user is 5.
//
// Because this API allows a user with an external federated identity to sign
// in as an existing user in the user pool, it is critical that it only be used
// with external identity providers and provider attributes that have been trusted
// by the application owner.
//
// This action is administrative and requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminLinkProviderForUser for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * AliasExistsException
//   This exception is thrown when a user tries to confirm the account with an
//   email or phone number that has already been supplied as an alias from a different
//   account. This exception tells user that an account with this email or phone
//   already exists.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested Amazon
//   Web Services resource.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminLinkProviderForUser
func (c *CognitoIdentityProvider) AdminLinkProviderForUser(input *AdminLinkProviderForUserInput) (*AdminLinkProviderForUserOutput, error) {
	req, out := c.AdminLinkProviderForUserRequest(input)
	return out, req.Send()
}

// AdminLinkProviderForUserWithContext is the same as AdminLinkProviderForUser with the addition of
// the ability to pass a context and additional request options.
//
// See AdminLinkProviderForUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminLinkProviderForUserWithContext(ctx aws.Context, input *AdminLinkProviderForUserInput, opts ...request.Option) (*AdminLinkProviderForUserOutput, error) {
	req, out := c.AdminLinkProviderForUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminListDevices = "AdminListDevices"

// AdminListDevicesRequest generates a "aws/request.Request" representing the
// client's request for the AdminListDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminListDevices for more information on using the AdminListDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminListDevicesRequest method.
//    req, resp := client.AdminListDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListDevices
func (c *CognitoIdentityProvider) AdminListDevicesRequest(input *AdminListDevicesInput) (req *request.Request, output *AdminListDevicesOutput) {
	op := &request.Operation{
		Name:       opAdminListDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminListDevicesInput{}
	}

	output = &AdminListDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminListDevices API operation for Amazon Cognito Identity Provider.
//
// Lists devices, as an administrator.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminListDevices for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is not valid.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListDevices
func (c *CognitoIdentityProvider) AdminListDevices(input *AdminListDevicesInput) (*AdminListDevicesOutput, error) {
	req, out := c.AdminListDevicesRequest(input)
	return out, req.Send()
}

// AdminListDevicesWithContext is the same as AdminListDevices with the addition of
// the ability to pass a context and additional request options.
//
// See AdminListDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminListDevicesWithContext(ctx aws.Context, input *AdminListDevicesInput, opts ...request.Option) (*AdminListDevicesOutput, error) {
	req, out := c.AdminListDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminListGroupsForUser = "AdminListGroupsForUser"

// AdminListGroupsForUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminListGroupsForUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminListGroupsForUser for more information on using the AdminListGroupsForUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminListGroupsForUserRequest method.
//    req, resp := client.AdminListGroupsForUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListGroupsForUser
func (c *CognitoIdentityProvider) AdminListGroupsForUserRequest(input *AdminListGroupsForUserInput) (req *request.Request, output *AdminListGroupsForUserOutput) {
	op := &request.Operation{
		Name:       opAdminListGroupsForUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &AdminListGroupsForUserInput{}
	}

	output = &AdminListGroupsForUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminListGroupsForUser API operation for Amazon Cognito Identity Provider.
//
// Lists the groups that the user belongs to.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminListGroupsForUser for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListGroupsForUser
func (c *CognitoIdentityProvider) AdminListGroupsForUser(input *AdminListGroupsForUserInput) (*AdminListGroupsForUserOutput, error) {
	req, out := c.AdminListGroupsForUserRequest(input)
	return out, req.Send()
}

// AdminListGroupsForUserWithContext is the same as AdminListGroupsForUser with the addition of
// the ability to pass a context and additional request options.
//
// See AdminListGroupsForUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminListGroupsForUserWithContext(ctx aws.Context, input *AdminListGroupsForUserInput, opts ...request.Option) (*AdminListGroupsForUserOutput, error) {
	req, out := c.AdminListGroupsForUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// AdminListGroupsForUserPages iterates over the pages of a AdminListGroupsForUser operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See AdminListGroupsForUser method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a AdminListGroupsForUser operation.
//    pageNum := 0
//    err := client.AdminListGroupsForUserPages(params,
//        func(page *cognitoidentityprovider.AdminListGroupsForUserOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CognitoIdentityProvider) AdminListGroupsForUserPages(input *AdminListGroupsForUserInput, fn func(*AdminListGroupsForUserOutput, bool) bool) error {
	return c.AdminListGroupsForUserPagesWithContext(aws.BackgroundContext(), input, fn)
}

// AdminListGroupsForUserPagesWithContext same as AdminListGroupsForUserPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminListGroupsForUserPagesWithContext(ctx aws.Context, input *AdminListGroupsForUserInput, fn func(*AdminListGroupsForUserOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *AdminListGroupsForUserInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.AdminListGroupsForUserRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*AdminListGroupsForUserOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opAdminListUserAuthEvents = "AdminListUserAuthEvents"

// AdminListUserAuthEventsRequest generates a "aws/request.Request" representing the
// client's request for the AdminListUserAuthEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminListUserAuthEvents for more information on using the AdminListUserAuthEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminListUserAuthEventsRequest method.
//    req, resp := client.AdminListUserAuthEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListUserAuthEvents
func (c *CognitoIdentityProvider) AdminListUserAuthEventsRequest(input *AdminListUserAuthEventsInput) (req *request.Request, output *AdminListUserAuthEventsOutput) {
	op := &request.Operation{
		Name:       opAdminListUserAuthEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &AdminListUserAuthEventsInput{}
	}

	output = &AdminListUserAuthEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminListUserAuthEvents API operation for Amazon Cognito Identity Provider.
//
// A history of user activity and any risks detected as part of Amazon Cognito
// advanced security.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminListUserAuthEvents for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserPoolAddOnNotEnabledException
//   This exception is thrown when user pool add-ons aren't enabled.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListUserAuthEvents
func (c *CognitoIdentityProvider) AdminListUserAuthEvents(input *AdminListUserAuthEventsInput) (*AdminListUserAuthEventsOutput, error) {
	req, out := c.AdminListUserAuthEventsRequest(input)
	return out, req.Send()
}

// AdminListUserAuthEventsWithContext is the same as AdminListUserAuthEvents with the addition of
// the ability to pass a context and additional request options.
//
// See AdminListUserAuthEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminListUserAuthEventsWithContext(ctx aws.Context, input *AdminListUserAuthEventsInput, opts ...request.Option) (*AdminListUserAuthEventsOutput, error) {
	req, out := c.AdminListUserAuthEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// AdminListUserAuthEventsPages iterates over the pages of a AdminListUserAuthEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See AdminListUserAuthEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a AdminListUserAuthEvents operation.
//    pageNum := 0
//    err := client.AdminListUserAuthEventsPages(params,
//        func(page *cognitoidentityprovider.AdminListUserAuthEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CognitoIdentityProvider) AdminListUserAuthEventsPages(input *AdminListUserAuthEventsInput, fn func(*AdminListUserAuthEventsOutput, bool) bool) error {
	return c.AdminListUserAuthEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// AdminListUserAuthEventsPagesWithContext same as AdminListUserAuthEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminListUserAuthEventsPagesWithContext(ctx aws.Context, input *AdminListUserAuthEventsInput, fn func(*AdminListUserAuthEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *AdminListUserAuthEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.AdminListUserAuthEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*AdminListUserAuthEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opAdminRemoveUserFromGroup = "AdminRemoveUserFromGroup"

// AdminRemoveUserFromGroupRequest generates a "aws/request.Request" representing the
// client's request for the AdminRemoveUserFromGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminRemoveUserFromGroup for more information on using the AdminRemoveUserFromGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminRemoveUserFromGroupRequest method.
//    req, resp := client.AdminRemoveUserFromGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRemoveUserFromGroup
func (c *CognitoIdentityProvider) AdminRemoveUserFromGroupRequest(input *AdminRemoveUserFromGroupInput) (req *request.Request, output *AdminRemoveUserFromGroupOutput) {
	op := &request.Operation{
		Name:       opAdminRemoveUserFromGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminRemoveUserFromGroupInput{}
	}

	output = &AdminRemoveUserFromGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminRemoveUserFromGroup API operation for Amazon Cognito Identity Provider.
//
// Removes the specified user from the specified group.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminRemoveUserFromGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRemoveUserFromGroup
func (c *CognitoIdentityProvider) AdminRemoveUserFromGroup(input *AdminRemoveUserFromGroupInput) (*AdminRemoveUserFromGroupOutput, error) {
	req, out := c.AdminRemoveUserFromGroupRequest(input)
	return out, req.Send()
}

// AdminRemoveUserFromGroupWithContext is the same as AdminRemoveUserFromGroup with the addition of
// the ability to pass a context and additional request options.
//
// See AdminRemoveUserFromGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminRemoveUserFromGroupWithContext(ctx aws.Context, input *AdminRemoveUserFromGroupInput, opts ...request.Option) (*AdminRemoveUserFromGroupOutput, error) {
	req, out := c.AdminRemoveUserFromGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminResetUserPassword = "AdminResetUserPassword"

// AdminResetUserPasswordRequest generates a "aws/request.Request" representing the
// client's request for the AdminResetUserPassword operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminResetUserPassword for more information on using the AdminResetUserPassword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminResetUserPasswordRequest method.
//    req, resp := client.AdminResetUserPasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminResetUserPassword
func (c *CognitoIdentityProvider) AdminResetUserPasswordRequest(input *AdminResetUserPasswordInput) (req *request.Request, output *AdminResetUserPasswordOutput) {
	op := &request.Operation{
		Name:       opAdminResetUserPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminResetUserPasswordInput{}
	}

	output = &AdminResetUserPasswordOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminResetUserPassword API operation for Amazon Cognito Identity Provider.
//
// Resets the specified user's password in a user pool as an administrator.
// Works on any user.
//
// When a developer calls this API, the current password is invalidated, so
// it must be changed. If a user tries to sign in after the API is called, the
// app will get a PasswordResetRequiredException exception back and should direct
// the user down the flow to reset the password, which is the same as the forgot
// password flow. In addition, if the user pool has phone verification selected
// and a verified phone number exists for the user, or if email verification
// is selected and a verified email exists for the user, calling this API will
// also result in sending a message to the end user with the code to change
// their password.
//
// This action might generate an SMS text message. Starting June 1, 2021, US
// telecom carriers require you to register an origination phone number before
// you can send SMS messages to US phone numbers. If you use SMS text messages
// in Amazon Cognito, you must register a phone number with Amazon Pinpoint
// (https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the
// registered number automatically. Otherwise, Amazon Cognito users who must
// receive SMS messages might not be able to sign up, activate their accounts,
// or sign in.
//
// If you have never used SMS text messages with Amazon Cognito or any other
// Amazon Web Service, Amazon Simple Notification Service might place your account
// in the SMS sandbox. In sandbox mode (https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)
// , you can send messages only to verified phone numbers. After you test your
// app while in the sandbox environment, you can move out of the sandbox and
// into production. For more information, see SMS message settings for Amazon
// Cognito user pools (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html)
// in the Amazon Cognito Developer Guide.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminResetUserPassword for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * UnexpectedLambdaException
//   This exception is thrown when Amazon Cognito encounters an unexpected exception
//   with Lambda.
//
//   * UserLambdaValidationException
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the Lambda service.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when Amazon Cognito encounters an invalid Lambda
//   response.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested Amazon
//   Web Services resource.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration doesn't
//   have permission to publish using Amazon SNS.
//
//   * InvalidEmailRoleAccessPolicyException
//   This exception is thrown when Amazon Cognito isn't allowed to use your email
//   identity. HTTP status code: 400.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is not valid for the
//   role provided for SMS configuration. This can happen if you don't trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminResetUserPassword
func (c *CognitoIdentityProvider) AdminResetUserPassword(input *AdminResetUserPasswordInput) (*AdminResetUserPasswordOutput, error) {
	req, out := c.AdminResetUserPasswordRequest(input)
	return out, req.Send()
}

// AdminResetUserPasswordWithContext is the same as AdminResetUserPassword with the addition of
// the ability to pass a context and additional request options.
//
// See AdminResetUserPassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminResetUserPasswordWithContext(ctx aws.Context, input *AdminResetUserPasswordInput, opts ...request.Option) (*AdminResetUserPasswordOutput, error) {
	req, out := c.AdminResetUserPasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminRespondToAuthChallenge = "AdminRespondToAuthChallenge"

// AdminRespondToAuthChallengeRequest generates a "aws/request.Request" representing the
// client's request for the AdminRespondToAuthChallenge operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminRespondToAuthChallenge for more information on using the AdminRespondToAuthChallenge
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminRespondToAuthChallengeRequest method.
//    req, resp := client.AdminRespondToAuthChallengeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRespondToAuthChallenge
func (c *CognitoIdentityProvider) AdminRespondToAuthChallengeRequest(input *AdminRespondToAuthChallengeInput) (req *request.Request, output *AdminRespondToAuthChallengeOutput) {
	op := &request.Operation{
		Name:       opAdminRespondToAuthChallenge,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminRespondToAuthChallengeInput{}
	}

	output = &AdminRespondToAuthChallengeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdminRespondToAuthChallenge API operation for Amazon Cognito Identity Provider.
//
// Responds to an authentication challenge, as an administrator.
//
// This action might generate an SMS text message. Starting June 1, 2021, US
// telecom carriers require you to register an origination phone number before
// you can send SMS messages to US phone numbers. If you use SMS text messages
// in Amazon Cognito, you must register a phone number with Amazon Pinpoint
// (https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the
// registered number automatically. Otherwise, Amazon Cognito users who must
// receive SMS messages might not be able to sign up, activate their accounts,
// or sign in.
//
// If you have never used SMS text messages with Amazon Cognito or any other
// Amazon Web Service, Amazon Simple Notification Service might place your account
// in the SMS sandbox. In sandbox mode (https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)
// , you can send messages only to verified phone numbers. After you test your
// app while in the sandbox environment, you can move out of the sandbox and
// into production. For more information, see SMS message settings for Amazon
// Cognito user pools (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html)
// in the Amazon Cognito Developer Guide.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminRespondToAuthChallenge for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * CodeMismatchException
//   This exception is thrown if the provided code doesn't match what the server
//   was expecting.
//
//   * ExpiredCodeException
//   This exception is thrown if a code has expired.
//
//   * UnexpectedLambdaException
//   This exception is thrown when Amazon Cognito encounters an unexpected exception
//   with Lambda.
//
//   * InvalidPasswordException
//   This exception is thrown when Amazon Cognito encounters an invalid password.
//
//   * UserLambdaValidationException
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the Lambda service.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when Amazon Cognito encounters an invalid Lambda
//   response.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is not valid.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * MFAMethodNotFoundException
//   This exception is thrown when Amazon Cognito can't find a multi-factor authentication
//   (MFA) method.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration doesn't
//   have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is not valid for the
//   role provided for SMS configuration. This can happen if you don't trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * AliasExistsException
//   This exception is thrown when a user tries to confirm the account with an
//   email or phone number that has already been supplied as an alias from a different
//   account. This exception tells user that an account with this email or phone
//   already exists.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * SoftwareTokenMFANotFoundException
//   This exception is thrown when the software token time-based one-time password
//   (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRespondToAuthChallenge
func (c *CognitoIdentityProvider) AdminRespondToAuthChallenge(input *AdminRespondToAuthChallengeInput) (*AdminRespondToAuthChallengeOutput, error) {
	req, out := c.AdminRespondToAuthChallengeRequest(input)
	return out, req.Send()
}

// AdminRespondToAuthChallengeWithContext is the same as AdminRespondToAuthChallenge with the addition of
// the ability to pass a context and additional request options.
//
// See AdminRespondToAuthChallenge for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminRespondToAuthChallengeWithContext(ctx aws.Context, input *AdminRespondToAuthChallengeInput, opts ...request.Option) (*AdminRespondToAuthChallengeOutput, error) {
	req, out := c.AdminRespondToAuthChallengeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminSetUserMFAPreference = "AdminSetUserMFAPreference"

// AdminSetUserMFAPreferenceRequest generates a "aws/request.Request" representing the
// client's request for the AdminSetUserMFAPreference operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminSetUserMFAPreference for more information on using the AdminSetUserMFAPreference
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminSetUserMFAPreferenceRequest method.
//    req, resp := client.AdminSetUserMFAPreferenceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserMFAPreference
func (c *CognitoIdentityProvider) AdminSetUserMFAPreferenceRequest(input *AdminSetUserMFAPreferenceInput) (req *request.Request, output *AdminSetUserMFAPreferenceOutput) {
	op := &request.Operation{
		Name:       opAdminSetUserMFAPreference,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminSetUserMFAPreferenceInput{}
	}

	output = &AdminSetUserMFAPreferenceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminSetUserMFAPreference API operation for Amazon Cognito Identity Provider.
//
// The user's multi-factor authentication (MFA) preference, including which
// MFA options are activated, and if any are preferred. Only one factor can
// be set as preferred. The preferred MFA factor will be used to authenticate
// a user if multiple factors are activated. If multiple options are activated
// and no preference is set, a challenge to choose an MFA option will be returned
// during sign-in.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminSetUserMFAPreference for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserMFAPreference
func (c *CognitoIdentityProvider) AdminSetUserMFAPreference(input *AdminSetUserMFAPreferenceInput) (*AdminSetUserMFAPreferenceOutput, error) {
	req, out := c.AdminSetUserMFAPreferenceRequest(input)
	return out, req.Send()
}

// AdminSetUserMFAPreferenceWithContext is the same as AdminSetUserMFAPreference with the addition of
// the ability to pass a context and additional request options.
//
// See AdminSetUserMFAPreference for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminSetUserMFAPreferenceWithContext(ctx aws.Context, input *AdminSetUserMFAPreferenceInput, opts ...request.Option) (*AdminSetUserMFAPreferenceOutput, error) {
	req, out := c.AdminSetUserMFAPreferenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminSetUserPassword = "AdminSetUserPassword"

// AdminSetUserPasswordRequest generates a "aws/request.Request" representing the
// client's request for the AdminSetUserPassword operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminSetUserPassword for more information on using the AdminSetUserPassword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminSetUserPasswordRequest method.
//    req, resp := client.AdminSetUserPasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserPassword
func (c *CognitoIdentityProvider) AdminSetUserPasswordRequest(input *AdminSetUserPasswordInput) (req *request.Request, output *AdminSetUserPasswordOutput) {
	op := &request.Operation{
		Name:       opAdminSetUserPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminSetUserPasswordInput{}
	}

	output = &AdminSetUserPasswordOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminSetUserPassword API operation for Amazon Cognito Identity Provider.
//
// Sets the specified user's password in a user pool as an administrator. Works
// on any user.
//
// The password can be temporary or permanent. If it is temporary, the user
// status enters the FORCE_CHANGE_PASSWORD state. When the user next tries to
// sign in, the InitiateAuth/AdminInitiateAuth response will contain the NEW_PASSWORD_REQUIRED
// challenge. If the user doesn't sign in before it expires, the user won't
// be able to sign in, and an administrator must reset their password.
//
// Once the user has set a new password, or the password is permanent, the user
// status is set to Confirmed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminSetUserPassword for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * InvalidPasswordException
//   This exception is thrown when Amazon Cognito encounters an invalid password.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserPassword
func (c *CognitoIdentityProvider) AdminSetUserPassword(input *AdminSetUserPasswordInput) (*AdminSetUserPasswordOutput, error) {
	req, out := c.AdminSetUserPasswordRequest(input)
	return out, req.Send()
}

// AdminSetUserPasswordWithContext is the same as AdminSetUserPassword with the addition of
// the ability to pass a context and additional request options.
//
// See AdminSetUserPassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminSetUserPasswordWithContext(ctx aws.Context, input *AdminSetUserPasswordInput, opts ...request.Option) (*AdminSetUserPasswordOutput, error) {
	req, out := c.AdminSetUserPasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminSetUserSettings = "AdminSetUserSettings"

// AdminSetUserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the AdminSetUserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminSetUserSettings for more information on using the AdminSetUserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminSetUserSettingsRequest method.
//    req, resp := client.AdminSetUserSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserSettings
func (c *CognitoIdentityProvider) AdminSetUserSettingsRequest(input *AdminSetUserSettingsInput) (req *request.Request, output *AdminSetUserSettingsOutput) {
	op := &request.Operation{
		Name:       opAdminSetUserSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminSetUserSettingsInput{}
	}

	output = &AdminSetUserSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminSetUserSettings API operation for Amazon Cognito Identity Provider.
//
// This action is no longer supported. You can use it to configure only SMS
// MFA. You can't use it to configure time-based one-time password (TOTP) software
// token MFA. To configure either type of MFA, use AdminSetUserMFAPreference
// (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserMFAPreference.html)
// instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminSetUserSettings for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserSettings
func (c *CognitoIdentityProvider) AdminSetUserSettings(input *AdminSetUserSettingsInput) (*AdminSetUserSettingsOutput, error) {
	req, out := c.AdminSetUserSettingsRequest(input)
	return out, req.Send()
}

// AdminSetUserSettingsWithContext is the same as AdminSetUserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See AdminSetUserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminSetUserSettingsWithContext(ctx aws.Context, input *AdminSetUserSettingsInput, opts ...request.Option) (*AdminSetUserSettingsOutput, error) {
	req, out := c.AdminSetUserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminUpdateAuthEventFeedback = "AdminUpdateAuthEventFeedback"

// AdminUpdateAuthEventFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the AdminUpdateAuthEventFeedback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminUpdateAuthEventFeedback for more information on using the AdminUpdateAuthEventFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminUpdateAuthEventFeedbackRequest method.
//    req, resp := client.AdminUpdateAuthEventFeedbackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateAuthEventFeedback
func (c *CognitoIdentityProvider) AdminUpdateAuthEventFeedbackRequest(input *AdminUpdateAuthEventFeedbackInput) (req *request.Request, output *AdminUpdateAuthEventFeedbackOutput) {
	op := &request.Operation{
		Name:       opAdminUpdateAuthEventFeedback,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminUpdateAuthEventFeedbackInput{}
	}

	output = &AdminUpdateAuthEventFeedbackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminUpdateAuthEventFeedback API operation for Amazon Cognito Identity Provider.
//
// Provides feedback for an authentication event indicating if it was from a
// valid user. This feedback is used for improving the risk evaluation decision
// for the user pool as part of Amazon Cognito advanced security.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminUpdateAuthEventFeedback for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserPoolAddOnNotEnabledException
//   This exception is thrown when user pool add-ons aren't enabled.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateAuthEventFeedback
func (c *CognitoIdentityProvider) AdminUpdateAuthEventFeedback(input *AdminUpdateAuthEventFeedbackInput) (*AdminUpdateAuthEventFeedbackOutput, error) {
	req, out := c.AdminUpdateAuthEventFeedbackRequest(input)
	return out, req.Send()
}

// AdminUpdateAuthEventFeedbackWithContext is the same as AdminUpdateAuthEventFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See AdminUpdateAuthEventFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminUpdateAuthEventFeedbackWithContext(ctx aws.Context, input *AdminUpdateAuthEventFeedbackInput, opts ...request.Option) (*AdminUpdateAuthEventFeedbackOutput, error) {
	req, out := c.AdminUpdateAuthEventFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminUpdateDeviceStatus = "AdminUpdateDeviceStatus"

// AdminUpdateDeviceStatusRequest generates a "aws/request.Request" representing the
// client's request for the AdminUpdateDeviceStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminUpdateDeviceStatus for more information on using the AdminUpdateDeviceStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminUpdateDeviceStatusRequest method.
//    req, resp := client.AdminUpdateDeviceStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateDeviceStatus
func (c *CognitoIdentityProvider) AdminUpdateDeviceStatusRequest(input *AdminUpdateDeviceStatusInput) (req *request.Request, output *AdminUpdateDeviceStatusOutput) {
	op := &request.Operation{
		Name:       opAdminUpdateDeviceStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminUpdateDeviceStatusInput{}
	}

	output = &AdminUpdateDeviceStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminUpdateDeviceStatus API operation for Amazon Cognito Identity Provider.
//
// Updates the device status as an administrator.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminUpdateDeviceStatus for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is not valid.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateDeviceStatus
func (c *CognitoIdentityProvider) AdminUpdateDeviceStatus(input *AdminUpdateDeviceStatusInput) (*AdminUpdateDeviceStatusOutput, error) {
	req, out := c.AdminUpdateDeviceStatusRequest(input)
	return out, req.Send()
}

// AdminUpdateDeviceStatusWithContext is the same as AdminUpdateDeviceStatus with the addition of
// the ability to pass a context and additional request options.
//
// See AdminUpdateDeviceStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminUpdateDeviceStatusWithContext(ctx aws.Context, input *AdminUpdateDeviceStatusInput, opts ...request.Option) (*AdminUpdateDeviceStatusOutput, error) {
	req, out := c.AdminUpdateDeviceStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminUpdateUserAttributes = "AdminUpdateUserAttributes"

// AdminUpdateUserAttributesRequest generates a "aws/request.Request" representing the
// client's request for the AdminUpdateUserAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminUpdateUserAttributes for more information on using the AdminUpdateUserAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminUpdateUserAttributesRequest method.
//    req, resp := client.AdminUpdateUserAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateUserAttributes
func (c *CognitoIdentityProvider) AdminUpdateUserAttributesRequest(input *AdminUpdateUserAttributesInput) (req *request.Request, output *AdminUpdateUserAttributesOutput) {
	op := &request.Operation{
		Name:       opAdminUpdateUserAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminUpdateUserAttributesInput{}
	}

	output = &AdminUpdateUserAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminUpdateUserAttributes API operation for Amazon Cognito Identity Provider.
//
// Updates the specified user's attributes, including developer attributes,
// as an administrator. Works on any user.
//
// For custom attributes, you must prepend the custom: prefix to the attribute
// name.
//
// In addition to updating user attributes, this API can also be used to mark
// phone and email as verified.
//
// This action might generate an SMS text message. Starting June 1, 2021, US
// telecom carriers require you to register an origination phone number before
// you can send SMS messages to US phone numbers. If you use SMS text messages
// in Amazon Cognito, you must register a phone number with Amazon Pinpoint
// (https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the
// registered number automatically. Otherwise, Amazon Cognito users who must
// receive SMS messages might not be able to sign up, activate their accounts,
// or sign in.
//
// If you have never used SMS text messages with Amazon Cognito or any other
// Amazon Web Service, Amazon Simple Notification Service might place your account
// in the SMS sandbox. In sandbox mode (https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)
// , you can send messages only to verified phone numbers. After you test your
// app while in the sandbox environment, you can move out of the sandbox and
// into production. For more information, see SMS message settings for Amazon
// Cognito user pools (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html)
// in the Amazon Cognito Developer Guide.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminUpdateUserAttributes for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * UnexpectedLambdaException
//   This exception is thrown when Amazon Cognito encounters an unexpected exception
//   with Lambda.
//
//   * UserLambdaValidationException
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the Lambda service.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when Amazon Cognito encounters an invalid Lambda
//   response.
//
//   * AliasExistsException
//   This exception is thrown when a user tries to confirm the account with an
//   email or phone number that has already been supplied as an alias from a different
//   account. This exception tells user that an account with this email or phone
//   already exists.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration doesn't
//   have permission to publish using Amazon SNS.
//
//   * InvalidEmailRoleAccessPolicyException
//   This exception is thrown when Amazon Cognito isn't allowed to use your email
//   identity. HTTP status code: 400.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is not valid for the
//   role provided for SMS configuration. This can happen if you don't trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateUserAttributes
func (c *CognitoIdentityProvider) AdminUpdateUserAttributes(input *AdminUpdateUserAttributesInput) (*AdminUpdateUserAttributesOutput, error) {
	req, out := c.AdminUpdateUserAttributesRequest(input)
	return out, req.Send()
}

// AdminUpdateUserAttributesWithContext is the same as AdminUpdateUserAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See AdminUpdateUserAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminUpdateUserAttributesWithContext(ctx aws.Context, input *AdminUpdateUserAttributesInput, opts ...request.Option) (*AdminUpdateUserAttributesOutput, error) {
	req, out := c.AdminUpdateUserAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdminUserGlobalSignOut = "AdminUserGlobalSignOut"

// AdminUserGlobalSignOutRequest generates a "aws/request.Request" representing the
// client's request for the AdminUserGlobalSignOut operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdminUserGlobalSignOut for more information on using the AdminUserGlobalSignOut
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AdminUserGlobalSignOutRequest method.
//    req, resp := client.AdminUserGlobalSignOutRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUserGlobalSignOut
func (c *CognitoIdentityProvider) AdminUserGlobalSignOutRequest(input *AdminUserGlobalSignOutInput) (req *request.Request, output *AdminUserGlobalSignOutOutput) {
	op := &request.Operation{
		Name:       opAdminUserGlobalSignOut,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminUserGlobalSignOutInput{}
	}

	output = &AdminUserGlobalSignOutOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AdminUserGlobalSignOut API operation for Amazon Cognito Identity Provider.
//
// Signs out users from all devices, as an administrator. It also invalidates
// all refresh tokens issued to a user. The user's current access and Id tokens
// remain valid until their expiry. Access and Id tokens expire one hour after
// they're issued.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminUserGlobalSignOut for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUserGlobalSignOut
func (c *CognitoIdentityProvider) AdminUserGlobalSignOut(input *AdminUserGlobalSignOutInput) (*AdminUserGlobalSignOutOutput, error) {
	req, out := c.AdminUserGlobalSignOutRequest(input)
	return out, req.Send()
}

// AdminUserGlobalSignOutWithContext is the same as AdminUserGlobalSignOut with the addition of
// the ability to pass a context and additional request options.
//
// See AdminUserGlobalSignOut for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AdminUserGlobalSignOutWithContext(ctx aws.Context, input *AdminUserGlobalSignOutInput, opts ...request.Option) (*AdminUserGlobalSignOutOutput, error) {
	req, out := c.AdminUserGlobalSignOutRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateSoftwareToken = "AssociateSoftwareToken"

// AssociateSoftwareTokenRequest generates a "aws/request.Request" representing the
// client's request for the AssociateSoftwareToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateSoftwareToken for more information on using the AssociateSoftwareToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateSoftwareTokenRequest method.
//    req, resp := client.AssociateSoftwareTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AssociateSoftwareToken
func (c *CognitoIdentityProvider) AssociateSoftwareTokenRequest(input *AssociateSoftwareTokenInput) (req *request.Request, output *AssociateSoftwareTokenOutput) {
	op := &request.Operation{
		Name:       opAssociateSoftwareToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateSoftwareTokenInput{}
	}

	output = &AssociateSoftwareTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateSoftwareToken API operation for Amazon Cognito Identity Provider.
//
// Returns a unique generated shared secret key code for the user account. The
// request takes an access token or a session string, but not both.
//
// Calling AssociateSoftwareToken immediately disassociates the existing software
// token from the user account. If the user doesn't subsequently verify the
// software token, their account is set up to authenticate without MFA. If MFA
// config is set to Optional at the user pool level, the user can then log in
// without MFA. However, if MFA is set to Required for the user pool, the user
// is asked to set up a new software token MFA during sign-in.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AssociateSoftwareToken for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   This exception is thrown if two or more modifications are happening concurrently.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * SoftwareTokenMFANotFoundException
//   This exception is thrown when the software token time-based one-time password
//   (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AssociateSoftwareToken
func (c *CognitoIdentityProvider) AssociateSoftwareToken(input *AssociateSoftwareTokenInput) (*AssociateSoftwareTokenOutput, error) {
	req, out := c.AssociateSoftwareTokenRequest(input)
	return out, req.Send()
}

// AssociateSoftwareTokenWithContext is the same as AssociateSoftwareToken with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateSoftwareToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) AssociateSoftwareTokenWithContext(ctx aws.Context, input *AssociateSoftwareTokenInput, opts ...request.Option) (*AssociateSoftwareTokenOutput, error) {
	req, out := c.AssociateSoftwareTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opChangePassword = "ChangePassword"

// ChangePasswordRequest generates a "aws/request.Request" representing the
// client's request for the ChangePassword operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ChangePassword for more information on using the ChangePassword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ChangePasswordRequest method.
//    req, resp := client.ChangePasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ChangePassword
func (c *CognitoIdentityProvider) ChangePasswordRequest(input *ChangePasswordInput) (req *request.Request, output *ChangePasswordOutput) {
	op := &request.Operation{
		Name:       opChangePassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ChangePasswordInput{}
	}

	output = &ChangePasswordOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ChangePassword API operation for Amazon Cognito Identity Provider.
//
// Changes the password for a specified user in a user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ChangePassword for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * InvalidPasswordException
//   This exception is thrown when Amazon Cognito encounters an invalid password.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested Amazon
//   Web Services resource.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ChangePassword
func (c *CognitoIdentityProvider) ChangePassword(input *ChangePasswordInput) (*ChangePasswordOutput, error) {
	req, out := c.ChangePasswordRequest(input)
	return out, req.Send()
}

// ChangePasswordWithContext is the same as ChangePassword with the addition of
// the ability to pass a context and additional request options.
//
// See ChangePassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ChangePasswordWithContext(ctx aws.Context, input *ChangePasswordInput, opts ...request.Option) (*ChangePasswordOutput, error) {
	req, out := c.ChangePasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConfirmDevice = "ConfirmDevice"

// ConfirmDeviceRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfirmDevice for more information on using the ConfirmDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ConfirmDeviceRequest method.
//    req, resp := client.ConfirmDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmDevice
func (c *CognitoIdentityProvider) ConfirmDeviceRequest(input *ConfirmDeviceInput) (req *request.Request, output *ConfirmDeviceOutput) {
	op := &request.Operation{
		Name:       opConfirmDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmDeviceInput{}
	}

	output = &ConfirmDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfirmDevice API operation for Amazon Cognito Identity Provider.
//
// Confirms tracking of the device. This API call is the call that begins device
// tracking.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ConfirmDevice for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InvalidPasswordException
//   This exception is thrown when Amazon Cognito encounters an invalid password.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when Amazon Cognito encounters an invalid Lambda
//   response.
//
//   * UsernameExistsException
//   This exception is thrown when Amazon Cognito encounters a user name that
//   already exists in the user pool.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is not valid.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmDevice
func (c *CognitoIdentityProvider) ConfirmDevice(input *ConfirmDeviceInput) (*ConfirmDeviceOutput, error) {
	req, out := c.ConfirmDeviceRequest(input)
	return out, req.Send()
}

// ConfirmDeviceWithContext is the same as ConfirmDevice with the addition of
// the ability to pass a context and additional request options.
//
// See ConfirmDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ConfirmDeviceWithContext(ctx aws.Context, input *ConfirmDeviceInput, opts ...request.Option) (*ConfirmDeviceOutput, error) {
	req, out := c.ConfirmDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConfirmForgotPassword = "ConfirmForgotPassword"

// ConfirmForgotPasswordRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmForgotPassword operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfirmForgotPassword for more information on using the ConfirmForgotPassword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ConfirmForgotPasswordRequest method.
//    req, resp := client.ConfirmForgotPasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmForgotPassword
func (c *CognitoIdentityProvider) ConfirmForgotPasswordRequest(input *ConfirmForgotPasswordInput) (req *request.Request, output *ConfirmForgotPasswordOutput) {
	op := &request.Operation{
		Name:       opConfirmForgotPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmForgotPasswordInput{}
	}

	output = &ConfirmForgotPasswordOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ConfirmForgotPassword API operation for Amazon Cognito Identity Provider.
//
// Allows a user to enter a confirmation code to reset a forgotten password.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ConfirmForgotPassword for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * UnexpectedLambdaException
//   This exception is thrown when Amazon Cognito encounters an unexpected exception
//   with Lambda.
//
//   * UserLambdaValidationException
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the Lambda service.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * InvalidPasswordException
//   This exception is thrown when Amazon Cognito encounters an invalid password.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * CodeMismatchException
//   This exception is thrown if the provided code doesn't match what the server
//   was expecting.
//
//   * ExpiredCodeException
//   This exception is thrown if a code has expired.
//
//   * TooManyFailedAttemptsException
//   This exception is thrown when the user has made too many failed attempts
//   for a given action, such as sign-in.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when Amazon Cognito encounters an invalid Lambda
//   response.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested Amazon
//   Web Services resource.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmForgotPassword
func (c *CognitoIdentityProvider) ConfirmForgotPassword(input *ConfirmForgotPasswordInput) (*ConfirmForgotPasswordOutput, error) {
	req, out := c.ConfirmForgotPasswordRequest(input)
	return out, req.Send()
}

// ConfirmForgotPasswordWithContext is the same as ConfirmForgotPassword with the addition of
// the ability to pass a context and additional request options.
//
// See ConfirmForgotPassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ConfirmForgotPasswordWithContext(ctx aws.Context, input *ConfirmForgotPasswordInput, opts ...request.Option) (*ConfirmForgotPasswordOutput, error) {
	req, out := c.ConfirmForgotPasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConfirmSignUp = "ConfirmSignUp"

// ConfirmSignUpRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmSignUp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfirmSignUp for more information on using the ConfirmSignUp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ConfirmSignUpRequest method.
//    req, resp := client.ConfirmSignUpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmSignUp
func (c *CognitoIdentityProvider) ConfirmSignUpRequest(input *ConfirmSignUpInput) (req *request.Request, output *ConfirmSignUpOutput) {
	op := &request.Operation{
		Name:       opConfirmSignUp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmSignUpInput{}
	}

	output = &ConfirmSignUpOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ConfirmSignUp API operation for Amazon Cognito Identity Provider.
//
// Confirms registration of a user and handles the existing alias from a previous
// user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ConfirmSignUp for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * UnexpectedLambdaException
//   This exception is thrown when Amazon Cognito encounters an unexpected exception
//   with Lambda.
//
//   * UserLambdaValidationException
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the Lambda service.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyFailedAttemptsException
//   This exception is thrown when the user has made too many failed attempts
//   for a given action, such as sign-in.
//
//   * CodeMismatchException
//   This exception is thrown if the provided code doesn't match what the server
//   was expecting.
//
//   * ExpiredCodeException
//   This exception is thrown if a code has expired.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when Amazon Cognito encounters an invalid Lambda
//   response.
//
//   * AliasExistsException
//   This exception is thrown when a user tries to confirm the account with an
//   email or phone number that has already been supplied as an alias from a different
//   account. This exception tells user that an account with this email or phone
//   already exists.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested Amazon
//   Web Services resource.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmSignUp
func (c *CognitoIdentityProvider) ConfirmSignUp(input *ConfirmSignUpInput) (*ConfirmSignUpOutput, error) {
	req, out := c.ConfirmSignUpRequest(input)
	return out, req.Send()
}

// ConfirmSignUpWithContext is the same as ConfirmSignUp with the addition of
// the ability to pass a context and additional request options.
//
// See ConfirmSignUp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ConfirmSignUpWithContext(ctx aws.Context, input *ConfirmSignUpInput, opts ...request.Option) (*ConfirmSignUpOutput, error) {
	req, out := c.ConfirmSignUpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroup = "CreateGroup"

// CreateGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroup for more information on using the CreateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGroupRequest method.
//    req, resp := client.CreateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateGroup
func (c *CognitoIdentityProvider) CreateGroupRequest(input *CreateGroupInput) (req *request.Request, output *CreateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGroupInput{}
	}

	output = &CreateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroup API operation for Amazon Cognito Identity Provider.
//
// Creates a new group in the specified user pool.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation CreateGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * GroupExistsException
//   This exception is thrown when Amazon Cognito encounters a group that already
//   exists in the user pool.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested Amazon
//   Web Services resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateGroup
func (c *CognitoIdentityProvider) CreateGroup(input *CreateGroupInput) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	return out, req.Send()
}

// CreateGroupWithContext is the same as CreateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) CreateGroupWithContext(ctx aws.Context, input *CreateGroupInput, opts ...request.Option) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIdentityProvider = "CreateIdentityProvider"

// CreateIdentityProviderRequest generates a "aws/request.Request" representing the
// client's request for the CreateIdentityProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIdentityProvider for more information on using the CreateIdentityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIdentityProviderRequest method.
//    req, resp := client.CreateIdentityProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateIdentityProvider
func (c *CognitoIdentityProvider) CreateIdentityProviderRequest(input *CreateIdentityProviderInput) (req *request.Request, output *CreateIdentityProviderOutput) {
	op := &request.Operation{
		Name:       opCreateIdentityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIdentityProviderInput{}
	}

	output = &CreateIdentityProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIdentityProvider API operation for Amazon Cognito Identity Provider.
//
// Creates an identity provider for a user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation CreateIdentityProvider for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * DuplicateProviderException
//   This exception is thrown when the provider is already supported by the user
//   pool.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested Amazon
//   Web Services resource.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateIdentityProvider
func (c *CognitoIdentityProvider) CreateIdentityProvider(input *CreateIdentityProviderInput) (*CreateIdentityProviderOutput, error) {
	req, out := c.CreateIdentityProviderRequest(input)
	return out, req.Send()
}

// CreateIdentityProviderWithContext is the same as CreateIdentityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIdentityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) CreateIdentityProviderWithContext(ctx aws.Context, input *CreateIdentityProviderInput, opts ...request.Option) (*CreateIdentityProviderOutput, error) {
	req, out := c.CreateIdentityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResourceServer = "CreateResourceServer"

// CreateResourceServerRequest generates a "aws/request.Request" representing the
// client's request for the CreateResourceServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResourceServer for more information on using the CreateResourceServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResourceServerRequest method.
//    req, resp := client.CreateResourceServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateResourceServer
func (c *CognitoIdentityProvider) CreateResourceServerRequest(input *CreateResourceServerInput) (req *request.Request, output *CreateResourceServerOutput) {
	op := &request.Operation{
		Name:       opCreateResourceServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResourceServerInput{}
	}

	output = &CreateResourceServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResourceServer API operation for Amazon Cognito Identity Provider.
//
// Creates a new OAuth2.0 resource server and defines custom scopes within it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation CreateResourceServer for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested Amazon
//   Web Services resource.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateResourceServer
func (c *CognitoIdentityProvider) CreateResourceServer(input *CreateResourceServerInput) (*CreateResourceServerOutput, error) {
	req, out := c.CreateResourceServerRequest(input)
	return out, req.Send()
}

// CreateResourceServerWithContext is the same as CreateResourceServer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourceServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) CreateResourceServerWithContext(ctx aws.Context, input *CreateResourceServerInput, opts ...request.Option) (*CreateResourceServerOutput, error) {
	req, out := c.CreateResourceServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUserImportJob = "CreateUserImportJob"

// CreateUserImportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUserImportJob for more information on using the CreateUserImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserImportJobRequest method.
//    req, resp := client.CreateUserImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserImportJob
func (c *CognitoIdentityProvider) CreateUserImportJobRequest(input *CreateUserImportJobInput) (req *request.Request, output *CreateUserImportJobOutput) {
	op := &request.Operation{
		Name:       opCreateUserImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserImportJobInput{}
	}

	output = &CreateUserImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUserImportJob API operation for Amazon Cognito Identity Provider.
//
// Creates the user import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation CreateUserImportJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * PreconditionNotMetException
//   This exception is thrown when a precondition is not met.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested Amazon
//   Web Services resource.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserImportJob
func (c *CognitoIdentityProvider) CreateUserImportJob(input *CreateUserImportJobInput) (*CreateUserImportJobOutput, error) {
	req, out := c.CreateUserImportJobRequest(input)
	return out, req.Send()
}

// CreateUserImportJobWithContext is the same as CreateUserImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) CreateUserImportJobWithContext(ctx aws.Context, input *CreateUserImportJobInput, opts ...request.Option) (*CreateUserImportJobOutput, error) {
	req, out := c.CreateUserImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUserPool = "CreateUserPool"

// CreateUserPoolRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUserPool for more information on using the CreateUserPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserPoolRequest method.
//    req, resp := client.CreateUserPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPool
func (c *CognitoIdentityProvider) CreateUserPoolRequest(input *CreateUserPoolInput) (req *request.Request, output *CreateUserPoolOutput) {
	op := &request.Operation{
		Name:       opCreateUserPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserPoolInput{}
	}

	output = &CreateUserPoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUserPool API operation for Amazon Cognito Identity Provider.
//
// Creates a new Amazon Cognito user pool and sets the password policy for the
// pool.
//
// This action might generate an SMS text message. Starting June 1, 2021, US
// telecom carriers require you to register an origination phone number before
// you can send SMS messages to US phone numbers. If you use SMS text messages
// in Amazon Cognito, you must register a phone number with Amazon Pinpoint
// (https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the
// registered number automatically. Otherwise, Amazon Cognito users who must
// receive SMS messages might not be able to sign up, activate their accounts,
// or sign in.
//
// If you have never used SMS text messages with Amazon Cognito or any other
// Amazon Web Service, Amazon Simple Notification Service might place your account
// in the SMS sandbox. In sandbox mode (https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)
// , you can send messages only to verified phone numbers. After you test your
// app while in the sandbox environment, you can move out of the sandbox and
// into production. For more information, see SMS message settings for Amazon
// Cognito user pools (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html)
// in the Amazon Cognito Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation CreateUserPool for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested Amazon
//   Web Services resource.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration doesn't
//   have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is not valid for the
//   role provided for SMS configuration. This can happen if you don't trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * InvalidEmailRoleAccessPolicyException
//   This exception is thrown when Amazon Cognito isn't allowed to use your email
//   identity. HTTP status code: 400.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserPoolTaggingException
//   This exception is thrown when a user pool tag can't be set or updated.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPool
func (c *CognitoIdentityProvider) CreateUserPool(input *CreateUserPoolInput) (*CreateUserPoolOutput, error) {
	req, out := c.CreateUserPoolRequest(input)
	return out, req.Send()
}

// CreateUserPoolWithContext is the same as CreateUserPool with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) CreateUserPoolWithContext(ctx aws.Context, input *CreateUserPoolInput, opts ...request.Option) (*CreateUserPoolOutput, error) {
	req, out := c.CreateUserPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUserPoolClient = "CreateUserPoolClient"

// CreateUserPoolClientRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserPoolClient operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUserPoolClient for more information on using the CreateUserPoolClient
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserPoolClientRequest method.
//    req, resp := client.CreateUserPoolClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolClient
func (c *CognitoIdentityProvider) CreateUserPoolClientRequest(input *CreateUserPoolClientInput) (req *request.Request, output *CreateUserPoolClientOutput) {
	op := &request.Operation{
		Name:       opCreateUserPoolClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserPoolClientInput{}
	}

	output = &CreateUserPoolClientOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUserPoolClient API operation for Amazon Cognito Identity Provider.
//
// Creates the user pool client.
//
// When you create a new user pool client, token revocation is automatically
// activated. For more information about revoking tokens, see RevokeToken (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation CreateUserPoolClient for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested Amazon
//   Web Services resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * ScopeDoesNotExistException
//   This exception is thrown when the specified scope doesn't exist.
//
//   * InvalidOAuthFlowException
//   This exception is thrown when the specified OAuth flow is not valid.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolClient
func (c *CognitoIdentityProvider) CreateUserPoolClient(input *CreateUserPoolClientInput) (*CreateUserPoolClientOutput, error) {
	req, out := c.CreateUserPoolClientRequest(input)
	return out, req.Send()
}

// CreateUserPoolClientWithContext is the same as CreateUserPoolClient with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserPoolClient for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) CreateUserPoolClientWithContext(ctx aws.Context, input *CreateUserPoolClientInput, opts ...request.Option) (*CreateUserPoolClientOutput, error) {
	req, out := c.CreateUserPoolClientRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUserPoolDomain = "CreateUserPoolDomain"

// CreateUserPoolDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserPoolDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUserPoolDomain for more information on using the CreateUserPoolDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserPoolDomainRequest method.
//    req, resp := client.CreateUserPoolDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolDomain
func (c *CognitoIdentityProvider) CreateUserPoolDomainRequest(input *CreateUserPoolDomainInput) (req *request.Request, output *CreateUserPoolDomainOutput) {
	op := &request.Operation{
		Name:       opCreateUserPoolDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserPoolDomainInput{}
	}

	output = &CreateUserPoolDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUserPoolDomain API operation for Amazon Cognito Identity Provider.
//
// Creates a new domain for a user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation CreateUserPoolDomain for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested Amazon
//   Web Services resource.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolDomain
func (c *CognitoIdentityProvider) CreateUserPoolDomain(input *CreateUserPoolDomainInput) (*CreateUserPoolDomainOutput, error) {
	req, out := c.CreateUserPoolDomainRequest(input)
	return out, req.Send()
}

// CreateUserPoolDomainWithContext is the same as CreateUserPoolDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserPoolDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) CreateUserPoolDomainWithContext(ctx aws.Context, input *CreateUserPoolDomainInput, opts ...request.Option) (*CreateUserPoolDomainOutput, error) {
	req, out := c.CreateUserPoolDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroup = "DeleteGroup"

// DeleteGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroup for more information on using the DeleteGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGroupRequest method.
//    req, resp := client.DeleteGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteGroup
func (c *CognitoIdentityProvider) DeleteGroupRequest(input *DeleteGroupInput) (req *request.Request, output *DeleteGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGroupInput{}
	}

	output = &DeleteGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGroup API operation for Amazon Cognito Identity Provider.
//
// Deletes a group.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteGroup for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteGroup
func (c *CognitoIdentityProvider) DeleteGroup(input *DeleteGroupInput) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	return out, req.Send()
}

// DeleteGroupWithContext is the same as DeleteGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DeleteGroupWithContext(ctx aws.Context, input *DeleteGroupInput, opts ...request.Option) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIdentityProvider = "DeleteIdentityProvider"

// DeleteIdentityProviderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIdentityProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIdentityProvider for more information on using the DeleteIdentityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIdentityProviderRequest method.
//    req, resp := client.DeleteIdentityProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteIdentityProvider
func (c *CognitoIdentityProvider) DeleteIdentityProviderRequest(input *DeleteIdentityProviderInput) (req *request.Request, output *DeleteIdentityProviderOutput) {
	op := &request.Operation{
		Name:       opDeleteIdentityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIdentityProviderInput{}
	}

	output = &DeleteIdentityProviderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIdentityProvider API operation for Amazon Cognito Identity Provider.
//
// Deletes an identity provider for a user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteIdentityProvider for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * UnsupportedIdentityProviderException
//   This exception is thrown when the specified identifier isn't supported.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteIdentityProvider
func (c *CognitoIdentityProvider) DeleteIdentityProvider(input *DeleteIdentityProviderInput) (*DeleteIdentityProviderOutput, error) {
	req, out := c.DeleteIdentityProviderRequest(input)
	return out, req.Send()
}

// DeleteIdentityProviderWithContext is the same as DeleteIdentityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIdentityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DeleteIdentityProviderWithContext(ctx aws.Context, input *DeleteIdentityProviderInput, opts ...request.Option) (*DeleteIdentityProviderOutput, error) {
	req, out := c.DeleteIdentityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourceServer = "DeleteResourceServer"

// DeleteResourceServerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourceServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourceServer for more information on using the DeleteResourceServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResourceServerRequest method.
//    req, resp := client.DeleteResourceServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteResourceServer
func (c *CognitoIdentityProvider) DeleteResourceServerRequest(input *DeleteResourceServerInput) (req *request.Request, output *DeleteResourceServerOutput) {
	op := &request.Operation{
		Name:       opDeleteResourceServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourceServerInput{}
	}

	output = &DeleteResourceServerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourceServer API operation for Amazon Cognito Identity Provider.
//
// Deletes a resource server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteResourceServer for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteResourceServer
func (c *CognitoIdentityProvider) DeleteResourceServer(input *DeleteResourceServerInput) (*DeleteResourceServerOutput, error) {
	req, out := c.DeleteResourceServerRequest(input)
	return out, req.Send()
}

// DeleteResourceServerWithContext is the same as DeleteResourceServer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourceServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DeleteResourceServerWithContext(ctx aws.Context, input *DeleteResourceServerInput, opts ...request.Option) (*DeleteResourceServerOutput, error) {
	req, out := c.DeleteResourceServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserRequest method.
//    req, resp := client.DeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUser
func (c *CognitoIdentityProvider) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUser API operation for Amazon Cognito Identity Provider.
//
// Allows a user to delete himself or herself.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteUser for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUser
func (c *CognitoIdentityProvider) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserAttributes = "DeleteUserAttributes"

// DeleteUserAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserAttributes for more information on using the DeleteUserAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserAttributesRequest method.
//    req, resp := client.DeleteUserAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserAttributes
func (c *CognitoIdentityProvider) DeleteUserAttributesRequest(input *DeleteUserAttributesInput) (req *request.Request, output *DeleteUserAttributesOutput) {
	op := &request.Operation{
		Name:       opDeleteUserAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserAttributesInput{}
	}

	output = &DeleteUserAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUserAttributes API operation for Amazon Cognito Identity Provider.
//
// Deletes the attributes for a user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteUserAttributes for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserAttributes
func (c *CognitoIdentityProvider) DeleteUserAttributes(input *DeleteUserAttributesInput) (*DeleteUserAttributesOutput, error) {
	req, out := c.DeleteUserAttributesRequest(input)
	return out, req.Send()
}

// DeleteUserAttributesWithContext is the same as DeleteUserAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DeleteUserAttributesWithContext(ctx aws.Context, input *DeleteUserAttributesInput, opts ...request.Option) (*DeleteUserAttributesOutput, error) {
	req, out := c.DeleteUserAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserPool = "DeleteUserPool"

// DeleteUserPoolRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserPool for more information on using the DeleteUserPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserPoolRequest method.
//    req, resp := client.DeleteUserPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPool
func (c *CognitoIdentityProvider) DeleteUserPoolRequest(input *DeleteUserPoolInput) (req *request.Request, output *DeleteUserPoolOutput) {
	op := &request.Operation{
		Name:       opDeleteUserPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserPoolInput{}
	}

	output = &DeleteUserPoolOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUserPool API operation for Amazon Cognito Identity Provider.
//
// Deletes the specified Amazon Cognito user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteUserPool for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserImportInProgressException
//   This exception is thrown when you're trying to modify a user pool while a
//   user import job is in progress for that pool.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPool
func (c *CognitoIdentityProvider) DeleteUserPool(input *DeleteUserPoolInput) (*DeleteUserPoolOutput, error) {
	req, out := c.DeleteUserPoolRequest(input)
	return out, req.Send()
}

// DeleteUserPoolWithContext is the same as DeleteUserPool with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DeleteUserPoolWithContext(ctx aws.Context, input *DeleteUserPoolInput, opts ...request.Option) (*DeleteUserPoolOutput, error) {
	req, out := c.DeleteUserPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserPoolClient = "DeleteUserPoolClient"

// DeleteUserPoolClientRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserPoolClient operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserPoolClient for more information on using the DeleteUserPoolClient
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserPoolClientRequest method.
//    req, resp := client.DeleteUserPoolClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolClient
func (c *CognitoIdentityProvider) DeleteUserPoolClientRequest(input *DeleteUserPoolClientInput) (req *request.Request, output *DeleteUserPoolClientOutput) {
	op := &request.Operation{
		Name:       opDeleteUserPoolClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserPoolClientInput{}
	}

	output = &DeleteUserPoolClientOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUserPoolClient API operation for Amazon Cognito Identity Provider.
//
// Allows the developer to delete the user pool client.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteUserPoolClient for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolClient
func (c *CognitoIdentityProvider) DeleteUserPoolClient(input *DeleteUserPoolClientInput) (*DeleteUserPoolClientOutput, error) {
	req, out := c.DeleteUserPoolClientRequest(input)
	return out, req.Send()
}

// DeleteUserPoolClientWithContext is the same as DeleteUserPoolClient with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserPoolClient for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DeleteUserPoolClientWithContext(ctx aws.Context, input *DeleteUserPoolClientInput, opts ...request.Option) (*DeleteUserPoolClientOutput, error) {
	req, out := c.DeleteUserPoolClientRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserPoolDomain = "DeleteUserPoolDomain"

// DeleteUserPoolDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserPoolDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserPoolDomain for more information on using the DeleteUserPoolDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserPoolDomainRequest method.
//    req, resp := client.DeleteUserPoolDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolDomain
func (c *CognitoIdentityProvider) DeleteUserPoolDomainRequest(input *DeleteUserPoolDomainInput) (req *request.Request, output *DeleteUserPoolDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteUserPoolDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserPoolDomainInput{}
	}

	output = &DeleteUserPoolDomainOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUserPoolDomain API operation for Amazon Cognito Identity Provider.
//
// Deletes a domain for a user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteUserPoolDomain for usage and error information.
//
// Returned Error Types:
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolDomain
func (c *CognitoIdentityProvider) DeleteUserPoolDomain(input *DeleteUserPoolDomainInput) (*DeleteUserPoolDomainOutput, error) {
	req, out := c.DeleteUserPoolDomainRequest(input)
	return out, req.Send()
}

// DeleteUserPoolDomainWithContext is the same as DeleteUserPoolDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserPoolDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DeleteUserPoolDomainWithContext(ctx aws.Context, input *DeleteUserPoolDomainInput, opts ...request.Option) (*DeleteUserPoolDomainOutput, error) {
	req, out := c.DeleteUserPoolDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIdentityProvider = "DescribeIdentityProvider"

// DescribeIdentityProviderRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIdentityProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIdentityProvider for more information on using the DescribeIdentityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIdentityProviderRequest method.
//    req, resp := client.DescribeIdentityProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeIdentityProvider
func (c *CognitoIdentityProvider) DescribeIdentityProviderRequest(input *DescribeIdentityProviderInput) (req *request.Request, output *DescribeIdentityProviderOutput) {
	op := &request.Operation{
		Name:       opDescribeIdentityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIdentityProviderInput{}
	}

	output = &DescribeIdentityProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIdentityProvider API operation for Amazon Cognito Identity Provider.
//
// Gets information about a specific identity provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DescribeIdentityProvider for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeIdentityProvider
func (c *CognitoIdentityProvider) DescribeIdentityProvider(input *DescribeIdentityProviderInput) (*DescribeIdentityProviderOutput, error) {
	req, out := c.DescribeIdentityProviderRequest(input)
	return out, req.Send()
}

// DescribeIdentityProviderWithContext is the same as DescribeIdentityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIdentityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DescribeIdentityProviderWithContext(ctx aws.Context, input *DescribeIdentityProviderInput, opts ...request.Option) (*DescribeIdentityProviderOutput, error) {
	req, out := c.DescribeIdentityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeResourceServer = "DescribeResourceServer"

// DescribeResourceServerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeResourceServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeResourceServer for more information on using the DescribeResourceServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeResourceServerRequest method.
//    req, resp := client.DescribeResourceServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeResourceServer
func (c *CognitoIdentityProvider) DescribeResourceServerRequest(input *DescribeResourceServerInput) (req *request.Request, output *DescribeResourceServerOutput) {
	op := &request.Operation{
		Name:       opDescribeResourceServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeResourceServerInput{}
	}

	output = &DescribeResourceServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeResourceServer API operation for Amazon Cognito Identity Provider.
//
// Describes a resource server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DescribeResourceServer for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeResourceServer
func (c *CognitoIdentityProvider) DescribeResourceServer(input *DescribeResourceServerInput) (*DescribeResourceServerOutput, error) {
	req, out := c.DescribeResourceServerRequest(input)
	return out, req.Send()
}

// DescribeResourceServerWithContext is the same as DescribeResourceServer with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeResourceServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DescribeResourceServerWithContext(ctx aws.Context, input *DescribeResourceServerInput, opts ...request.Option) (*DescribeResourceServerOutput, error) {
	req, out := c.DescribeResourceServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRiskConfiguration = "DescribeRiskConfiguration"

// DescribeRiskConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRiskConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRiskConfiguration for more information on using the DescribeRiskConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRiskConfigurationRequest method.
//    req, resp := client.DescribeRiskConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeRiskConfiguration
func (c *CognitoIdentityProvider) DescribeRiskConfigurationRequest(input *DescribeRiskConfigurationInput) (req *request.Request, output *DescribeRiskConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeRiskConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRiskConfigurationInput{}
	}

	output = &DescribeRiskConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRiskConfiguration API operation for Amazon Cognito Identity Provider.
//
// Describes the risk configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DescribeRiskConfiguration for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserPoolAddOnNotEnabledException
//   This exception is thrown when user pool add-ons aren't enabled.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeRiskConfiguration
func (c *CognitoIdentityProvider) DescribeRiskConfiguration(input *DescribeRiskConfigurationInput) (*DescribeRiskConfigurationOutput, error) {
	req, out := c.DescribeRiskConfigurationRequest(input)
	return out, req.Send()
}

// DescribeRiskConfigurationWithContext is the same as DescribeRiskConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRiskConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DescribeRiskConfigurationWithContext(ctx aws.Context, input *DescribeRiskConfigurationInput, opts ...request.Option) (*DescribeRiskConfigurationOutput, error) {
	req, out := c.DescribeRiskConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserImportJob = "DescribeUserImportJob"

// DescribeUserImportJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUserImportJob for more information on using the DescribeUserImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserImportJobRequest method.
//    req, resp := client.DescribeUserImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserImportJob
func (c *CognitoIdentityProvider) DescribeUserImportJobRequest(input *DescribeUserImportJobInput) (req *request.Request, output *DescribeUserImportJobOutput) {
	op := &request.Operation{
		Name:       opDescribeUserImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserImportJobInput{}
	}

	output = &DescribeUserImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserImportJob API operation for Amazon Cognito Identity Provider.
//
// Describes the user import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DescribeUserImportJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserImportJob
func (c *CognitoIdentityProvider) DescribeUserImportJob(input *DescribeUserImportJobInput) (*DescribeUserImportJobOutput, error) {
	req, out := c.DescribeUserImportJobRequest(input)
	return out, req.Send()
}

// DescribeUserImportJobWithContext is the same as DescribeUserImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DescribeUserImportJobWithContext(ctx aws.Context, input *DescribeUserImportJobInput, opts ...request.Option) (*DescribeUserImportJobOutput, error) {
	req, out := c.DescribeUserImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserPool = "DescribeUserPool"

// DescribeUserPoolRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUserPool for more information on using the DescribeUserPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserPoolRequest method.
//    req, resp := client.DescribeUserPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPool
func (c *CognitoIdentityProvider) DescribeUserPoolRequest(input *DescribeUserPoolInput) (req *request.Request, output *DescribeUserPoolOutput) {
	op := &request.Operation{
		Name:       opDescribeUserPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserPoolInput{}
	}

	output = &DescribeUserPoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserPool API operation for Amazon Cognito Identity Provider.
//
// Returns the configuration information and metadata of the specified user
// pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DescribeUserPool for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserPoolTaggingException
//   This exception is thrown when a user pool tag can't be set or updated.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPool
func (c *CognitoIdentityProvider) DescribeUserPool(input *DescribeUserPoolInput) (*DescribeUserPoolOutput, error) {
	req, out := c.DescribeUserPoolRequest(input)
	return out, req.Send()
}

// DescribeUserPoolWithContext is the same as DescribeUserPool with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DescribeUserPoolWithContext(ctx aws.Context, input *DescribeUserPoolInput, opts ...request.Option) (*DescribeUserPoolOutput, error) {
	req, out := c.DescribeUserPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserPoolClient = "DescribeUserPoolClient"

// DescribeUserPoolClientRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserPoolClient operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUserPoolClient for more information on using the DescribeUserPoolClient
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserPoolClientRequest method.
//    req, resp := client.DescribeUserPoolClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolClient
func (c *CognitoIdentityProvider) DescribeUserPoolClientRequest(input *DescribeUserPoolClientInput) (req *request.Request, output *DescribeUserPoolClientOutput) {
	op := &request.Operation{
		Name:       opDescribeUserPoolClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserPoolClientInput{}
	}

	output = &DescribeUserPoolClientOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserPoolClient API operation for Amazon Cognito Identity Provider.
//
// Client method for returning the configuration information and metadata of
// the specified user pool app client.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DescribeUserPoolClient for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolClient
func (c *CognitoIdentityProvider) DescribeUserPoolClient(input *DescribeUserPoolClientInput) (*DescribeUserPoolClientOutput, error) {
	req, out := c.DescribeUserPoolClientRequest(input)
	return out, req.Send()
}

// DescribeUserPoolClientWithContext is the same as DescribeUserPoolClient with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserPoolClient for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DescribeUserPoolClientWithContext(ctx aws.Context, input *DescribeUserPoolClientInput, opts ...request.Option) (*DescribeUserPoolClientOutput, error) {
	req, out := c.DescribeUserPoolClientRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserPoolDomain = "DescribeUserPoolDomain"

// DescribeUserPoolDomainRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserPoolDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUserPoolDomain for more information on using the DescribeUserPoolDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserPoolDomainRequest method.
//    req, resp := client.DescribeUserPoolDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolDomain
func (c *CognitoIdentityProvider) DescribeUserPoolDomainRequest(input *DescribeUserPoolDomainInput) (req *request.Request, output *DescribeUserPoolDomainOutput) {
	op := &request.Operation{
		Name:       opDescribeUserPoolDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserPoolDomainInput{}
	}

	output = &DescribeUserPoolDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserPoolDomain API operation for Amazon Cognito Identity Provider.
//
// Gets information about a domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DescribeUserPoolDomain for usage and error information.
//
// Returned Error Types:
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolDomain
func (c *CognitoIdentityProvider) DescribeUserPoolDomain(input *DescribeUserPoolDomainInput) (*DescribeUserPoolDomainOutput, error) {
	req, out := c.DescribeUserPoolDomainRequest(input)
	return out, req.Send()
}

// DescribeUserPoolDomainWithContext is the same as DescribeUserPoolDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserPoolDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) DescribeUserPoolDomainWithContext(ctx aws.Context, input *DescribeUserPoolDomainInput, opts ...request.Option) (*DescribeUserPoolDomainOutput, error) {
	req, out := c.DescribeUserPoolDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opForgetDevice = "ForgetDevice"

// ForgetDeviceRequest generates a "aws/request.Request" representing the
// client's request for the ForgetDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ForgetDevice for more information on using the ForgetDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ForgetDeviceRequest method.
//    req, resp := client.ForgetDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgetDevice
func (c *CognitoIdentityProvider) ForgetDeviceRequest(input *ForgetDeviceInput) (req *request.Request, output *ForgetDeviceOutput) {
	op := &request.Operation{
		Name:       opForgetDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ForgetDeviceInput{}
	}

	output = &ForgetDeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ForgetDevice API operation for Amazon Cognito Identity Provider.
//
// Forgets the specified device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ForgetDevice for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is not valid.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgetDevice
func (c *CognitoIdentityProvider) ForgetDevice(input *ForgetDeviceInput) (*ForgetDeviceOutput, error) {
	req, out := c.ForgetDeviceRequest(input)
	return out, req.Send()
}

// ForgetDeviceWithContext is the same as ForgetDevice with the addition of
// the ability to pass a context and additional request options.
//
// See ForgetDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ForgetDeviceWithContext(ctx aws.Context, input *ForgetDeviceInput, opts ...request.Option) (*ForgetDeviceOutput, error) {
	req, out := c.ForgetDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opForgotPassword = "ForgotPassword"

// ForgotPasswordRequest generates a "aws/request.Request" representing the
// client's request for the ForgotPassword operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ForgotPassword for more information on using the ForgotPassword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ForgotPasswordRequest method.
//    req, resp := client.ForgotPasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgotPassword
func (c *CognitoIdentityProvider) ForgotPasswordRequest(input *ForgotPasswordInput) (req *request.Request, output *ForgotPasswordOutput) {
	op := &request.Operation{
		Name:       opForgotPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ForgotPasswordInput{}
	}

	output = &ForgotPasswordOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// ForgotPassword API operation for Amazon Cognito Identity Provider.
//
// Calling this API causes a message to be sent to the end user with a confirmation
// code that is required to change the user's password. For the Username parameter,
// you can use the username or user alias. The method used to send the confirmation
// code is sent according to the specified AccountRecoverySetting. For more
// information, see Recovering User Accounts (https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-recover-a-user-account.html)
// in the Amazon Cognito Developer Guide. If neither a verified phone number
// nor a verified email exists, an InvalidParameterException is thrown. To use
// the confirmation code for resetting the password, call ConfirmForgotPassword
// (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmForgotPassword.html).
//
// This action might generate an SMS text message. Starting June 1, 2021, US
// telecom carriers require you to register an origination phone number before
// you can send SMS messages to US phone numbers. If you use SMS text messages
// in Amazon Cognito, you must register a phone number with Amazon Pinpoint
// (https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the
// registered number automatically. Otherwise, Amazon Cognito users who must
// receive SMS messages might not be able to sign up, activate their accounts,
// or sign in.
//
// If you have never used SMS text messages with Amazon Cognito or any other
// Amazon Web Service, Amazon Simple Notification Service might place your account
// in the SMS sandbox. In sandbox mode (https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)
// , you can send messages only to verified phone numbers. After you test your
// app while in the sandbox environment, you can move out of the sandbox and
// into production. For more information, see SMS message settings for Amazon
// Cognito user pools (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html)
// in the Amazon Cognito Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ForgotPassword for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * UnexpectedLambdaException
//   This exception is thrown when Amazon Cognito encounters an unexpected exception
//   with Lambda.
//
//   * UserLambdaValidationException
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the Lambda service.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when Amazon Cognito encounters an invalid Lambda
//   response.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested Amazon
//   Web Services resource.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration doesn't
//   have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is not valid for the
//   role provided for SMS configuration. This can happen if you don't trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * InvalidEmailRoleAccessPolicyException
//   This exception is thrown when Amazon Cognito isn't allowed to use your email
//   identity. HTTP status code: 400.
//
//   * CodeDeliveryFailureException
//   This exception is thrown when a verification code fails to deliver successfully.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgotPassword
func (c *CognitoIdentityProvider) ForgotPassword(input *ForgotPasswordInput) (*ForgotPasswordOutput, error) {
	req, out := c.ForgotPasswordRequest(input)
	return out, req.Send()
}

// ForgotPasswordWithContext is the same as ForgotPassword with the addition of
// the ability to pass a context and additional request options.
//
// See ForgotPassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ForgotPasswordWithContext(ctx aws.Context, input *ForgotPasswordInput, opts ...request.Option) (*ForgotPasswordOutput, error) {
	req, out := c.ForgotPasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCSVHeader = "GetCSVHeader"

// GetCSVHeaderRequest generates a "aws/request.Request" representing the
// client's request for the GetCSVHeader operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCSVHeader for more information on using the GetCSVHeader
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCSVHeaderRequest method.
//    req, resp := client.GetCSVHeaderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetCSVHeader
func (c *CognitoIdentityProvider) GetCSVHeaderRequest(input *GetCSVHeaderInput) (req *request.Request, output *GetCSVHeaderOutput) {
	op := &request.Operation{
		Name:       opGetCSVHeader,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCSVHeaderInput{}
	}

	output = &GetCSVHeaderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCSVHeader API operation for Amazon Cognito Identity Provider.
//
// Gets the header information for the comma-separated value (CSV) file to be
// used as input for the user import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetCSVHeader for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetCSVHeader
func (c *CognitoIdentityProvider) GetCSVHeader(input *GetCSVHeaderInput) (*GetCSVHeaderOutput, error) {
	req, out := c.GetCSVHeaderRequest(input)
	return out, req.Send()
}

// GetCSVHeaderWithContext is the same as GetCSVHeader with the addition of
// the ability to pass a context and additional request options.
//
// See GetCSVHeader for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GetCSVHeaderWithContext(ctx aws.Context, input *GetCSVHeaderInput, opts ...request.Option) (*GetCSVHeaderOutput, error) {
	req, out := c.GetCSVHeaderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDevice = "GetDevice"

// GetDeviceRequest generates a "aws/request.Request" representing the
// client's request for the GetDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDevice for more information on using the GetDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeviceRequest method.
//    req, resp := client.GetDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetDevice
func (c *CognitoIdentityProvider) GetDeviceRequest(input *GetDeviceInput) (req *request.Request, output *GetDeviceOutput) {
	op := &request.Operation{
		Name:       opGetDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeviceInput{}
	}

	output = &GetDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDevice API operation for Amazon Cognito Identity Provider.
//
// Gets the device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetDevice for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is not valid.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetDevice
func (c *CognitoIdentityProvider) GetDevice(input *GetDeviceInput) (*GetDeviceOutput, error) {
	req, out := c.GetDeviceRequest(input)
	return out, req.Send()
}

// GetDeviceWithContext is the same as GetDevice with the addition of
// the ability to pass a context and additional request options.
//
// See GetDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GetDeviceWithContext(ctx aws.Context, input *GetDeviceInput, opts ...request.Option) (*GetDeviceOutput, error) {
	req, out := c.GetDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroup = "GetGroup"

// GetGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroup for more information on using the GetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGroupRequest method.
//    req, resp := client.GetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetGroup
func (c *CognitoIdentityProvider) GetGroupRequest(input *GetGroupInput) (req *request.Request, output *GetGroupOutput) {
	op := &request.Operation{
		Name:       opGetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetGroupInput{}
	}

	output = &GetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroup API operation for Amazon Cognito Identity Provider.
//
// Gets a group.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetGroup for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetGroup
func (c *CognitoIdentityProvider) GetGroup(input *GetGroupInput) (*GetGroupOutput, error) {
	req, out := c.GetGroupRequest(input)
	return out, req.Send()
}

// GetGroupWithContext is the same as GetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GetGroupWithContext(ctx aws.Context, input *GetGroupInput, opts ...request.Option) (*GetGroupOutput, error) {
	req, out := c.GetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdentityProviderByIdentifier = "GetIdentityProviderByIdentifier"

// GetIdentityProviderByIdentifierRequest generates a "aws/request.Request" representing the
// client's request for the GetIdentityProviderByIdentifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIdentityProviderByIdentifier for more information on using the GetIdentityProviderByIdentifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIdentityProviderByIdentifierRequest method.
//    req, resp := client.GetIdentityProviderByIdentifierRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetIdentityProviderByIdentifier
func (c *CognitoIdentityProvider) GetIdentityProviderByIdentifierRequest(input *GetIdentityProviderByIdentifierInput) (req *request.Request, output *GetIdentityProviderByIdentifierOutput) {
	op := &request.Operation{
		Name:       opGetIdentityProviderByIdentifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityProviderByIdentifierInput{}
	}

	output = &GetIdentityProviderByIdentifierOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdentityProviderByIdentifier API operation for Amazon Cognito Identity Provider.
//
// Gets the specified identity provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetIdentityProviderByIdentifier for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetIdentityProviderByIdentifier
func (c *CognitoIdentityProvider) GetIdentityProviderByIdentifier(input *GetIdentityProviderByIdentifierInput) (*GetIdentityProviderByIdentifierOutput, error) {
	req, out := c.GetIdentityProviderByIdentifierRequest(input)
	return out, req.Send()
}

// GetIdentityProviderByIdentifierWithContext is the same as GetIdentityProviderByIdentifier with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdentityProviderByIdentifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GetIdentityProviderByIdentifierWithContext(ctx aws.Context, input *GetIdentityProviderByIdentifierInput, opts ...request.Option) (*GetIdentityProviderByIdentifierOutput, error) {
	req, out := c.GetIdentityProviderByIdentifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSigningCertificate = "GetSigningCertificate"

// GetSigningCertificateRequest generates a "aws/request.Request" representing the
// client's request for the GetSigningCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSigningCertificate for more information on using the GetSigningCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSigningCertificateRequest method.
//    req, resp := client.GetSigningCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetSigningCertificate
func (c *CognitoIdentityProvider) GetSigningCertificateRequest(input *GetSigningCertificateInput) (req *request.Request, output *GetSigningCertificateOutput) {
	op := &request.Operation{
		Name:       opGetSigningCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSigningCertificateInput{}
	}

	output = &GetSigningCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSigningCertificate API operation for Amazon Cognito Identity Provider.
//
// This method takes a user pool ID, and returns the signing certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetSigningCertificate for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetSigningCertificate
func (c *CognitoIdentityProvider) GetSigningCertificate(input *GetSigningCertificateInput) (*GetSigningCertificateOutput, error) {
	req, out := c.GetSigningCertificateRequest(input)
	return out, req.Send()
}

// GetSigningCertificateWithContext is the same as GetSigningCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See GetSigningCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GetSigningCertificateWithContext(ctx aws.Context, input *GetSigningCertificateInput, opts ...request.Option) (*GetSigningCertificateOutput, error) {
	req, out := c.GetSigningCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUICustomization = "GetUICustomization"

// GetUICustomizationRequest generates a "aws/request.Request" representing the
// client's request for the GetUICustomization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUICustomization for more information on using the GetUICustomization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUICustomizationRequest method.
//    req, resp := client.GetUICustomizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUICustomization
func (c *CognitoIdentityProvider) GetUICustomizationRequest(input *GetUICustomizationInput) (req *request.Request, output *GetUICustomizationOutput) {
	op := &request.Operation{
		Name:       opGetUICustomization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUICustomizationInput{}
	}

	output = &GetUICustomizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUICustomization API operation for Amazon Cognito Identity Provider.
//
// Gets the user interface (UI) Customization information for a particular app
// client's app UI, if any such information exists for the client. If nothing
// is set for the particular client, but there is an existing pool level customization
// (the app clientId is ALL), then that information is returned. If nothing
// is present, then an empty shape is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetUICustomization for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUICustomization
func (c *CognitoIdentityProvider) GetUICustomization(input *GetUICustomizationInput) (*GetUICustomizationOutput, error) {
	req, out := c.GetUICustomizationRequest(input)
	return out, req.Send()
}

// GetUICustomizationWithContext is the same as GetUICustomization with the addition of
// the ability to pass a context and additional request options.
//
// See GetUICustomization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GetUICustomizationWithContext(ctx aws.Context, input *GetUICustomizationInput, opts ...request.Option) (*GetUICustomizationOutput, error) {
	req, out := c.GetUICustomizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUser = "GetUser"

// GetUserRequest generates a "aws/request.Request" representing the
// client's request for the GetUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUser for more information on using the GetUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUserRequest method.
//    req, resp := client.GetUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUser
func (c *CognitoIdentityProvider) GetUserRequest(input *GetUserInput) (req *request.Request, output *GetUserOutput) {
	op := &request.Operation{
		Name:       opGetUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUserInput{}
	}

	output = &GetUserOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// GetUser API operation for Amazon Cognito Identity Provider.
//
// Gets the user attributes and metadata for a user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetUser for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUser
func (c *CognitoIdentityProvider) GetUser(input *GetUserInput) (*GetUserOutput, error) {
	req, out := c.GetUserRequest(input)
	return out, req.Send()
}

// GetUserWithContext is the same as GetUser with the addition of
// the ability to pass a context and additional request options.
//
// See GetUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GetUserWithContext(ctx aws.Context, input *GetUserInput, opts ...request.Option) (*GetUserOutput, error) {
	req, out := c.GetUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUserAttributeVerificationCode = "GetUserAttributeVerificationCode"

// GetUserAttributeVerificationCodeRequest generates a "aws/request.Request" representing the
// client's request for the GetUserAttributeVerificationCode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUserAttributeVerificationCode for more information on using the GetUserAttributeVerificationCode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUserAttributeVerificationCodeRequest method.
//    req, resp := client.GetUserAttributeVerificationCodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserAttributeVerificationCode
func (c *CognitoIdentityProvider) GetUserAttributeVerificationCodeRequest(input *GetUserAttributeVerificationCodeInput) (req *request.Request, output *GetUserAttributeVerificationCodeOutput) {
	op := &request.Operation{
		Name:       opGetUserAttributeVerificationCode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUserAttributeVerificationCodeInput{}
	}

	output = &GetUserAttributeVerificationCodeOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// GetUserAttributeVerificationCode API operation for Amazon Cognito Identity Provider.
//
// Gets the user attribute verification code for the specified attribute name.
//
// This action might generate an SMS text message. Starting June 1, 2021, US
// telecom carriers require you to register an origination phone number before
// you can send SMS messages to US phone numbers. If you use SMS text messages
// in Amazon Cognito, you must register a phone number with Amazon Pinpoint
// (https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the
// registered number automatically. Otherwise, Amazon Cognito users who must
// receive SMS messages might not be able to sign up, activate their accounts,
// or sign in.
//
// If you have never used SMS text messages with Amazon Cognito or any other
// Amazon Web Service, Amazon Simple Notification Service might place your account
// in the SMS sandbox. In sandbox mode (https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)
// , you can send messages only to verified phone numbers. After you test your
// app while in the sandbox environment, you can move out of the sandbox and
// into production. For more information, see SMS message settings for Amazon
// Cognito user pools (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html)
// in the Amazon Cognito Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetUserAttributeVerificationCode for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UnexpectedLambdaException
//   This exception is thrown when Amazon Cognito encounters an unexpected exception
//   with Lambda.
//
//   * UserLambdaValidationException
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the Lambda service.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when Amazon Cognito encounters an invalid Lambda
//   response.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration doesn't
//   have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is not valid for the
//   role provided for SMS configuration. This can happen if you don't trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * InvalidEmailRoleAccessPolicyException
//   This exception is thrown when Amazon Cognito isn't allowed to use your email
//   identity. HTTP status code: 400.
//
//   * CodeDeliveryFailureException
//   This exception is thrown when a verification code fails to deliver successfully.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested Amazon
//   Web Services resource.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserAttributeVerificationCode
func (c *CognitoIdentityProvider) GetUserAttributeVerificationCode(input *GetUserAttributeVerificationCodeInput) (*GetUserAttributeVerificationCodeOutput, error) {
	req, out := c.GetUserAttributeVerificationCodeRequest(input)
	return out, req.Send()
}

// GetUserAttributeVerificationCodeWithContext is the same as GetUserAttributeVerificationCode with the addition of
// the ability to pass a context and additional request options.
//
// See GetUserAttributeVerificationCode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GetUserAttributeVerificationCodeWithContext(ctx aws.Context, input *GetUserAttributeVerificationCodeInput, opts ...request.Option) (*GetUserAttributeVerificationCodeOutput, error) {
	req, out := c.GetUserAttributeVerificationCodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUserPoolMfaConfig = "GetUserPoolMfaConfig"

// GetUserPoolMfaConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetUserPoolMfaConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUserPoolMfaConfig for more information on using the GetUserPoolMfaConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUserPoolMfaConfigRequest method.
//    req, resp := client.GetUserPoolMfaConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserPoolMfaConfig
func (c *CognitoIdentityProvider) GetUserPoolMfaConfigRequest(input *GetUserPoolMfaConfigInput) (req *request.Request, output *GetUserPoolMfaConfigOutput) {
	op := &request.Operation{
		Name:       opGetUserPoolMfaConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUserPoolMfaConfigInput{}
	}

	output = &GetUserPoolMfaConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUserPoolMfaConfig API operation for Amazon Cognito Identity Provider.
//
// Gets the user pool multi-factor authentication (MFA) configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetUserPoolMfaConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserPoolMfaConfig
func (c *CognitoIdentityProvider) GetUserPoolMfaConfig(input *GetUserPoolMfaConfigInput) (*GetUserPoolMfaConfigOutput, error) {
	req, out := c.GetUserPoolMfaConfigRequest(input)
	return out, req.Send()
}

// GetUserPoolMfaConfigWithContext is the same as GetUserPoolMfaConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetUserPoolMfaConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GetUserPoolMfaConfigWithContext(ctx aws.Context, input *GetUserPoolMfaConfigInput, opts ...request.Option) (*GetUserPoolMfaConfigOutput, error) {
	req, out := c.GetUserPoolMfaConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGlobalSignOut = "GlobalSignOut"

// GlobalSignOutRequest generates a "aws/request.Request" representing the
// client's request for the GlobalSignOut operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GlobalSignOut for more information on using the GlobalSignOut
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GlobalSignOutRequest method.
//    req, resp := client.GlobalSignOutRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GlobalSignOut
func (c *CognitoIdentityProvider) GlobalSignOutRequest(input *GlobalSignOutInput) (req *request.Request, output *GlobalSignOutOutput) {
	op := &request.Operation{
		Name:       opGlobalSignOut,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GlobalSignOutInput{}
	}

	output = &GlobalSignOutOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// GlobalSignOut API operation for Amazon Cognito Identity Provider.
//
// Signs out users from all devices. It also invalidates all refresh tokens
// issued to a user. The user's current access and ID tokens remain valid until
// their expiry. Access and Id tokens expire one hour after they're issued.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GlobalSignOut for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GlobalSignOut
func (c *CognitoIdentityProvider) GlobalSignOut(input *GlobalSignOutInput) (*GlobalSignOutOutput, error) {
	req, out := c.GlobalSignOutRequest(input)
	return out, req.Send()
}

// GlobalSignOutWithContext is the same as GlobalSignOut with the addition of
// the ability to pass a context and additional request options.
//
// See GlobalSignOut for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) GlobalSignOutWithContext(ctx aws.Context, input *GlobalSignOutInput, opts ...request.Option) (*GlobalSignOutOutput, error) {
	req, out := c.GlobalSignOutRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInitiateAuth = "InitiateAuth"

// InitiateAuthRequest generates a "aws/request.Request" representing the
// client's request for the InitiateAuth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InitiateAuth for more information on using the InitiateAuth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InitiateAuthRequest method.
//    req, resp := client.InitiateAuthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/InitiateAuth
func (c *CognitoIdentityProvider) InitiateAuthRequest(input *InitiateAuthInput) (req *request.Request, output *InitiateAuthOutput) {
	op := &request.Operation{
		Name:       opInitiateAuth,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &InitiateAuthInput{}
	}

	output = &InitiateAuthOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// InitiateAuth API operation for Amazon Cognito Identity Provider.
//
// Initiates the authentication flow.
//
// This action might generate an SMS text message. Starting June 1, 2021, US
// telecom carriers require you to register an origination phone number before
// you can send SMS messages to US phone numbers. If you use SMS text messages
// in Amazon Cognito, you must register a phone number with Amazon Pinpoint
// (https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the
// registered number automatically. Otherwise, Amazon Cognito users who must
// receive SMS messages might not be able to sign up, activate their accounts,
// or sign in.
//
// If you have never used SMS text messages with Amazon Cognito or any other
// Amazon Web Service, Amazon Simple Notification Service might place your account
// in the SMS sandbox. In sandbox mode (https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)
// , you can send messages only to verified phone numbers. After you test your
// app while in the sandbox environment, you can move out of the sandbox and
// into production. For more information, see SMS message settings for Amazon
// Cognito user pools (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html)
// in the Amazon Cognito Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation InitiateAuth for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * UnexpectedLambdaException
//   This exception is thrown when Amazon Cognito encounters an unexpected exception
//   with Lambda.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is not valid.
//
//   * UserLambdaValidationException
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the Lambda service.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when Amazon Cognito encounters an invalid Lambda
//   response.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration doesn't
//   have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is not valid for the
//   role provided for SMS configuration. This can happen if you don't trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/InitiateAuth
func (c *CognitoIdentityProvider) InitiateAuth(input *InitiateAuthInput) (*InitiateAuthOutput, error) {
	req, out := c.InitiateAuthRequest(input)
	return out, req.Send()
}

// InitiateAuthWithContext is the same as InitiateAuth with the addition of
// the ability to pass a context and additional request options.
//
// See InitiateAuth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) InitiateAuthWithContext(ctx aws.Context, input *InitiateAuthInput, opts ...request.Option) (*InitiateAuthOutput, error) {
	req, out := c.InitiateAuthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDevices = "ListDevices"

// ListDevicesRequest generates a "aws/request.Request" representing the
// client's request for the ListDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDevices for more information on using the ListDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDevicesRequest method.
//    req, resp := client.ListDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListDevices
func (c *CognitoIdentityProvider) ListDevicesRequest(input *ListDevicesInput) (req *request.Request, output *ListDevicesOutput) {
	op := &request.Operation{
		Name:       opListDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDevicesInput{}
	}

	output = &ListDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDevices API operation for Amazon Cognito Identity Provider.
//
// Lists the devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListDevices for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is not valid.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListDevices
func (c *CognitoIdentityProvider) ListDevices(input *ListDevicesInput) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	return out, req.Send()
}

// ListDevicesWithContext is the same as ListDevices with the addition of
// the ability to pass a context and additional request options.
//
// See ListDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListDevicesWithContext(ctx aws.Context, input *ListDevicesInput, opts ...request.Option) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroups = "ListGroups"

// ListGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroups for more information on using the ListGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupsRequest method.
//    req, resp := client.ListGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListGroups
func (c *CognitoIdentityProvider) ListGroupsRequest(input *ListGroupsInput) (req *request.Request, output *ListGroupsOutput) {
	op := &request.Operation{
		Name:       opListGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGroupsInput{}
	}

	output = &ListGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroups API operation for Amazon Cognito Identity Provider.
//
// Lists the groups associated with a user pool.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListGroups for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListGroups
func (c *CognitoIdentityProvider) ListGroups(input *ListGroupsInput) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	return out, req.Send()
}

// ListGroupsWithContext is the same as ListGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListGroupsWithContext(ctx aws.Context, input *ListGroupsInput, opts ...request.Option) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGroupsPages iterates over the pages of a ListGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGroups operation.
//    pageNum := 0
//    err := client.ListGroupsPages(params,
//        func(page *cognitoidentityprovider.ListGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CognitoIdentityProvider) ListGroupsPages(input *ListGroupsInput, fn func(*ListGroupsOutput, bool) bool) error {
	return c.ListGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGroupsPagesWithContext same as ListGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListGroupsPagesWithContext(ctx aws.Context, input *ListGroupsInput, fn func(*ListGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIdentityProviders = "ListIdentityProviders"

// ListIdentityProvidersRequest generates a "aws/request.Request" representing the
// client's request for the ListIdentityProviders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIdentityProviders for more information on using the ListIdentityProviders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIdentityProvidersRequest method.
//    req, resp := client.ListIdentityProvidersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProviders
func (c *CognitoIdentityProvider) ListIdentityProvidersRequest(input *ListIdentityProvidersInput) (req *request.Request, output *ListIdentityProvidersOutput) {
	op := &request.Operation{
		Name:       opListIdentityProviders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIdentityProvidersInput{}
	}

	output = &ListIdentityProvidersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdentityProviders API operation for Amazon Cognito Identity Provider.
//
// Lists information about all identity providers for a user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListIdentityProviders for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProviders
func (c *CognitoIdentityProvider) ListIdentityProviders(input *ListIdentityProvidersInput) (*ListIdentityProvidersOutput, error) {
	req, out := c.ListIdentityProvidersRequest(input)
	return out, req.Send()
}

// ListIdentityProvidersWithContext is the same as ListIdentityProviders with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdentityProviders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListIdentityProvidersWithContext(ctx aws.Context, input *ListIdentityProvidersInput, opts ...request.Option) (*ListIdentityProvidersOutput, error) {
	req, out := c.ListIdentityProvidersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIdentityProvidersPages iterates over the pages of a ListIdentityProviders operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIdentityProviders method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListIdentityProviders operation.
//    pageNum := 0
//    err := client.ListIdentityProvidersPages(params,
//        func(page *cognitoidentityprovider.ListIdentityProvidersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CognitoIdentityProvider) ListIdentityProvidersPages(input *ListIdentityProvidersInput, fn func(*ListIdentityProvidersOutput, bool) bool) error {
	return c.ListIdentityProvidersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIdentityProvidersPagesWithContext same as ListIdentityProvidersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListIdentityProvidersPagesWithContext(ctx aws.Context, input *ListIdentityProvidersInput, fn func(*ListIdentityProvidersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIdentityProvidersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIdentityProvidersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIdentityProvidersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResourceServers = "ListResourceServers"

// ListResourceServersRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceServers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceServers for more information on using the ListResourceServers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourceServersRequest method.
//    req, resp := client.ListResourceServersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListResourceServers
func (c *CognitoIdentityProvider) ListResourceServersRequest(input *ListResourceServersInput) (req *request.Request, output *ListResourceServersOutput) {
	op := &request.Operation{
		Name:       opListResourceServers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourceServersInput{}
	}

	output = &ListResourceServersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceServers API operation for Amazon Cognito Identity Provider.
//
// Lists the resource servers for a user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListResourceServers for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListResourceServers
func (c *CognitoIdentityProvider) ListResourceServers(input *ListResourceServersInput) (*ListResourceServersOutput, error) {
	req, out := c.ListResourceServersRequest(input)
	return out, req.Send()
}

// ListResourceServersWithContext is the same as ListResourceServers with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceServers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListResourceServersWithContext(ctx aws.Context, input *ListResourceServersInput, opts ...request.Option) (*ListResourceServersOutput, error) {
	req, out := c.ListResourceServersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourceServersPages iterates over the pages of a ListResourceServers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResourceServers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResourceServers operation.
//    pageNum := 0
//    err := client.ListResourceServersPages(params,
//        func(page *cognitoidentityprovider.ListResourceServersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CognitoIdentityProvider) ListResourceServersPages(input *ListResourceServersInput, fn func(*ListResourceServersOutput, bool) bool) error {
	return c.ListResourceServersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourceServersPagesWithContext same as ListResourceServersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListResourceServersPagesWithContext(ctx aws.Context, input *ListResourceServersInput, fn func(*ListResourceServersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourceServersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourceServersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourceServersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListTagsForResource
func (c *CognitoIdentityProvider) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Cognito Identity Provider.
//
// Lists the tags that are assigned to an Amazon Cognito user pool.
//
// A tag is a label that you can apply to user pools to categorize and manage
// them in different ways, such as by purpose, owner, environment, or other
// criteria.
//
// You can use this action up to 10 times per second, per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListTagsForResource
func (c *CognitoIdentityProvider) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUserImportJobs = "ListUserImportJobs"

// ListUserImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserImportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserImportJobs for more information on using the ListUserImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUserImportJobsRequest method.
//    req, resp := client.ListUserImportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserImportJobs
func (c *CognitoIdentityProvider) ListUserImportJobsRequest(input *ListUserImportJobsInput) (req *request.Request, output *ListUserImportJobsOutput) {
	op := &request.Operation{
		Name:       opListUserImportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListUserImportJobsInput{}
	}

	output = &ListUserImportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserImportJobs API operation for Amazon Cognito Identity Provider.
//
// Lists the user import jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListUserImportJobs for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserImportJobs
func (c *CognitoIdentityProvider) ListUserImportJobs(input *ListUserImportJobsInput) (*ListUserImportJobsOutput, error) {
	req, out := c.ListUserImportJobsRequest(input)
	return out, req.Send()
}

// ListUserImportJobsWithContext is the same as ListUserImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListUserImportJobsWithContext(ctx aws.Context, input *ListUserImportJobsInput, opts ...request.Option) (*ListUserImportJobsOutput, error) {
	req, out := c.ListUserImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUserPoolClients = "ListUserPoolClients"

// ListUserPoolClientsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserPoolClients operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserPoolClients for more information on using the ListUserPoolClients
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUserPoolClientsRequest method.
//    req, resp := client.ListUserPoolClientsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPoolClients
func (c *CognitoIdentityProvider) ListUserPoolClientsRequest(input *ListUserPoolClientsInput) (req *request.Request, output *ListUserPoolClientsOutput) {
	op := &request.Operation{
		Name:       opListUserPoolClients,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUserPoolClientsInput{}
	}

	output = &ListUserPoolClientsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserPoolClients API operation for Amazon Cognito Identity Provider.
//
// Lists the clients that have been created for the specified user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListUserPoolClients for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPoolClients
func (c *CognitoIdentityProvider) ListUserPoolClients(input *ListUserPoolClientsInput) (*ListUserPoolClientsOutput, error) {
	req, out := c.ListUserPoolClientsRequest(input)
	return out, req.Send()
}

// ListUserPoolClientsWithContext is the same as ListUserPoolClients with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserPoolClients for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListUserPoolClientsWithContext(ctx aws.Context, input *ListUserPoolClientsInput, opts ...request.Option) (*ListUserPoolClientsOutput, error) {
	req, out := c.ListUserPoolClientsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUserPoolClientsPages iterates over the pages of a ListUserPoolClients operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUserPoolClients method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUserPoolClients operation.
//    pageNum := 0
//    err := client.ListUserPoolClientsPages(params,
//        func(page *cognitoidentityprovider.ListUserPoolClientsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CognitoIdentityProvider) ListUserPoolClientsPages(input *ListUserPoolClientsInput, fn func(*ListUserPoolClientsOutput, bool) bool) error {
	return c.ListUserPoolClientsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUserPoolClientsPagesWithContext same as ListUserPoolClientsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListUserPoolClientsPagesWithContext(ctx aws.Context, input *ListUserPoolClientsInput, fn func(*ListUserPoolClientsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUserPoolClientsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUserPoolClientsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUserPoolClientsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUserPools = "ListUserPools"

// ListUserPoolsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserPools operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserPools for more information on using the ListUserPools
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUserPoolsRequest method.
//    req, resp := client.ListUserPoolsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPools
func (c *CognitoIdentityProvider) ListUserPoolsRequest(input *ListUserPoolsInput) (req *request.Request, output *ListUserPoolsOutput) {
	op := &request.Operation{
		Name:       opListUserPools,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUserPoolsInput{}
	}

	output = &ListUserPoolsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserPools API operation for Amazon Cognito Identity Provider.
//
// Lists the user pools associated with an Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListUserPools for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPools
func (c *CognitoIdentityProvider) ListUserPools(input *ListUserPoolsInput) (*ListUserPoolsOutput, error) {
	req, out := c.ListUserPoolsRequest(input)
	return out, req.Send()
}

// ListUserPoolsWithContext is the same as ListUserPools with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserPools for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListUserPoolsWithContext(ctx aws.Context, input *ListUserPoolsInput, opts ...request.Option) (*ListUserPoolsOutput, error) {
	req, out := c.ListUserPoolsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUserPoolsPages iterates over the pages of a ListUserPools operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUserPools method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUserPools operation.
//    pageNum := 0
//    err := client.ListUserPoolsPages(params,
//        func(page *cognitoidentityprovider.ListUserPoolsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CognitoIdentityProvider) ListUserPoolsPages(input *ListUserPoolsInput, fn func(*ListUserPoolsOutput, bool) bool) error {
	return c.ListUserPoolsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUserPoolsPagesWithContext same as ListUserPoolsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListUserPoolsPagesWithContext(ctx aws.Context, input *ListUserPoolsInput, fn func(*ListUserPoolsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUserPoolsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUserPoolsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUserPoolsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUsersRequest method.
//    req, resp := client.ListUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsers
func (c *CognitoIdentityProvider) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"PaginationToken"},
			OutputTokens:    []string{"PaginationToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for Amazon Cognito Identity Provider.
//
// Lists the users in the Amazon Cognito user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListUsers for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsers
func (c *CognitoIdentityProvider) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUsersPages iterates over the pages of a ListUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUsers operation.
//    pageNum := 0
//    err := client.ListUsersPages(params,
//        func(page *cognitoidentityprovider.ListUsersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CognitoIdentityProvider) ListUsersPages(input *ListUsersInput, fn func(*ListUsersOutput, bool) bool) error {
	return c.ListUsersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUsersPagesWithContext same as ListUsersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListUsersPagesWithContext(ctx aws.Context, input *ListUsersInput, fn func(*ListUsersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUsersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUsersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUsersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUsersInGroup = "ListUsersInGroup"

// ListUsersInGroupRequest generates a "aws/request.Request" representing the
// client's request for the ListUsersInGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsersInGroup for more information on using the ListUsersInGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUsersInGroupRequest method.
//    req, resp := client.ListUsersInGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsersInGroup
func (c *CognitoIdentityProvider) ListUsersInGroupRequest(input *ListUsersInGroupInput) (req *request.Request, output *ListUsersInGroupOutput) {
	op := &request.Operation{
		Name:       opListUsersInGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUsersInGroupInput{}
	}

	output = &ListUsersInGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsersInGroup API operation for Amazon Cognito Identity Provider.
//
// Lists the users in the specified group.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListUsersInGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsersInGroup
func (c *CognitoIdentityProvider) ListUsersInGroup(input *ListUsersInGroupInput) (*ListUsersInGroupOutput, error) {
	req, out := c.ListUsersInGroupRequest(input)
	return out, req.Send()
}

// ListUsersInGroupWithContext is the same as ListUsersInGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsersInGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListUsersInGroupWithContext(ctx aws.Context, input *ListUsersInGroupInput, opts ...request.Option) (*ListUsersInGroupOutput, error) {
	req, out := c.ListUsersInGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUsersInGroupPages iterates over the pages of a ListUsersInGroup operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUsersInGroup method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUsersInGroup operation.
//    pageNum := 0
//    err := client.ListUsersInGroupPages(params,
//        func(page *cognitoidentityprovider.ListUsersInGroupOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CognitoIdentityProvider) ListUsersInGroupPages(input *ListUsersInGroupInput, fn func(*ListUsersInGroupOutput, bool) bool) error {
	return c.ListUsersInGroupPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUsersInGroupPagesWithContext same as ListUsersInGroupPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ListUsersInGroupPagesWithContext(ctx aws.Context, input *ListUsersInGroupInput, fn func(*ListUsersInGroupOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUsersInGroupInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUsersInGroupRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUsersInGroupOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opResendConfirmationCode = "ResendConfirmationCode"

// ResendConfirmationCodeRequest generates a "aws/request.Request" representing the
// client's request for the ResendConfirmationCode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResendConfirmationCode for more information on using the ResendConfirmationCode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResendConfirmationCodeRequest method.
//    req, resp := client.ResendConfirmationCodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ResendConfirmationCode
func (c *CognitoIdentityProvider) ResendConfirmationCodeRequest(input *ResendConfirmationCodeInput) (req *request.Request, output *ResendConfirmationCodeOutput) {
	op := &request.Operation{
		Name:       opResendConfirmationCode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResendConfirmationCodeInput{}
	}

	output = &ResendConfirmationCodeOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// ResendConfirmationCode API operation for Amazon Cognito Identity Provider.
//
// Resends the confirmation (for confirmation of registration) to a specific
// user in the user pool.
//
// This action might generate an SMS text message. Starting June 1, 2021, US
// telecom carriers require you to register an origination phone number before
// you can send SMS messages to US phone numbers. If you use SMS text messages
// in Amazon Cognito, you must register a phone number with Amazon Pinpoint
// (https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the
// registered number automatically. Otherwise, Amazon Cognito users who must
// receive SMS messages might not be able to sign up, activate their accounts,
// or sign in.
//
// If you have never used SMS text messages with Amazon Cognito or any other
// Amazon Web Service, Amazon Simple Notification Service might place your account
// in the SMS sandbox. In sandbox mode (https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)
// , you can send messages only to verified phone numbers. After you test your
// app while in the sandbox environment, you can move out of the sandbox and
// into production. For more information, see SMS message settings for Amazon
// Cognito user pools (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html)
// in the Amazon Cognito Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ResendConfirmationCode for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * UnexpectedLambdaException
//   This exception is thrown when Amazon Cognito encounters an unexpected exception
//   with Lambda.
//
//   * UserLambdaValidationException
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the Lambda service.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when Amazon Cognito encounters an invalid Lambda
//   response.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested Amazon
//   Web Services resource.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration doesn't
//   have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is not valid for the
//   role provided for SMS configuration. This can happen if you don't trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * InvalidEmailRoleAccessPolicyException
//   This exception is thrown when Amazon Cognito isn't allowed to use your email
//   identity. HTTP status code: 400.
//
//   * CodeDeliveryFailureException
//   This exception is thrown when a verification code fails to deliver successfully.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ResendConfirmationCode
func (c *CognitoIdentityProvider) ResendConfirmationCode(input *ResendConfirmationCodeInput) (*ResendConfirmationCodeOutput, error) {
	req, out := c.ResendConfirmationCodeRequest(input)
	return out, req.Send()
}

// ResendConfirmationCodeWithContext is the same as ResendConfirmationCode with the addition of
// the ability to pass a context and additional request options.
//
// See ResendConfirmationCode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) ResendConfirmationCodeWithContext(ctx aws.Context, input *ResendConfirmationCodeInput, opts ...request.Option) (*ResendConfirmationCodeOutput, error) {
	req, out := c.ResendConfirmationCodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRespondToAuthChallenge = "RespondToAuthChallenge"

// RespondToAuthChallengeRequest generates a "aws/request.Request" representing the
// client's request for the RespondToAuthChallenge operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RespondToAuthChallenge for more information on using the RespondToAuthChallenge
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RespondToAuthChallengeRequest method.
//    req, resp := client.RespondToAuthChallengeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RespondToAuthChallenge
func (c *CognitoIdentityProvider) RespondToAuthChallengeRequest(input *RespondToAuthChallengeInput) (req *request.Request, output *RespondToAuthChallengeOutput) {
	op := &request.Operation{
		Name:       opRespondToAuthChallenge,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RespondToAuthChallengeInput{}
	}

	output = &RespondToAuthChallengeOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// RespondToAuthChallenge API operation for Amazon Cognito Identity Provider.
//
// Responds to the authentication challenge.
//
// This action might generate an SMS text message. Starting June 1, 2021, US
// telecom carriers require you to register an origination phone number before
// you can send SMS messages to US phone numbers. If you use SMS text messages
// in Amazon Cognito, you must register a phone number with Amazon Pinpoint
// (https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the
// registered number automatically. Otherwise, Amazon Cognito users who must
// receive SMS messages might not be able to sign up, activate their accounts,
// or sign in.
//
// If you have never used SMS text messages with Amazon Cognito or any other
// Amazon Web Service, Amazon Simple Notification Service might place your account
// in the SMS sandbox. In sandbox mode (https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)
// , you can send messages only to verified phone numbers. After you test your
// app while in the sandbox environment, you can move out of the sandbox and
// into production. For more information, see SMS message settings for Amazon
// Cognito user pools (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html)
// in the Amazon Cognito Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation RespondToAuthChallenge for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * CodeMismatchException
//   This exception is thrown if the provided code doesn't match what the server
//   was expecting.
//
//   * ExpiredCodeException
//   This exception is thrown if a code has expired.
//
//   * UnexpectedLambdaException
//   This exception is thrown when Amazon Cognito encounters an unexpected exception
//   with Lambda.
//
//   * UserLambdaValidationException
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the Lambda service.
//
//   * InvalidPasswordException
//   This exception is thrown when Amazon Cognito encounters an invalid password.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when Amazon Cognito encounters an invalid Lambda
//   response.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is not valid.
//
//   * MFAMethodNotFoundException
//   This exception is thrown when Amazon Cognito can't find a multi-factor authentication
//   (MFA) method.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration doesn't
//   have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is not valid for the
//   role provided for SMS configuration. This can happen if you don't trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * AliasExistsException
//   This exception is thrown when a user tries to confirm the account with an
//   email or phone number that has already been supplied as an alias from a different
//   account. This exception tells user that an account with this email or phone
//   already exists.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * SoftwareTokenMFANotFoundException
//   This exception is thrown when the software token time-based one-time password
//   (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RespondToAuthChallenge
func (c *CognitoIdentityProvider) RespondToAuthChallenge(input *RespondToAuthChallengeInput) (*RespondToAuthChallengeOutput, error) {
	req, out := c.RespondToAuthChallengeRequest(input)
	return out, req.Send()
}

// RespondToAuthChallengeWithContext is the same as RespondToAuthChallenge with the addition of
// the ability to pass a context and additional request options.
//
// See RespondToAuthChallenge for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) RespondToAuthChallengeWithContext(ctx aws.Context, input *RespondToAuthChallengeInput, opts ...request.Option) (*RespondToAuthChallengeOutput, error) {
	req, out := c.RespondToAuthChallengeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeToken = "RevokeToken"

// RevokeTokenRequest generates a "aws/request.Request" representing the
// client's request for the RevokeToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeToken for more information on using the RevokeToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokeTokenRequest method.
//    req, resp := client.RevokeTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RevokeToken
func (c *CognitoIdentityProvider) RevokeTokenRequest(input *RevokeTokenInput) (req *request.Request, output *RevokeTokenOutput) {
	op := &request.Operation{
		Name:       opRevokeToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeTokenInput{}
	}

	output = &RevokeTokenOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RevokeToken API operation for Amazon Cognito Identity Provider.
//
// Revokes all of the access tokens generated by the specified refresh token.
// After the token is revoked, you can't use the revoked token to access Amazon
// Cognito authenticated APIs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation RevokeToken for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * UnauthorizedException
//   Exception that is thrown when the request isn't authorized. This can happen
//   due to an invalid access token in the request.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * UnsupportedOperationException
//   Exception that is thrown when you attempt to perform an operation that isn't
//   enabled for the user pool client.
//
//   * UnsupportedTokenTypeException
//   Exception that is thrown when an unsupported token is passed to an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RevokeToken
func (c *CognitoIdentityProvider) RevokeToken(input *RevokeTokenInput) (*RevokeTokenOutput, error) {
	req, out := c.RevokeTokenRequest(input)
	return out, req.Send()
}

// RevokeTokenWithContext is the same as RevokeToken with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) RevokeTokenWithContext(ctx aws.Context, input *RevokeTokenInput, opts ...request.Option) (*RevokeTokenOutput, error) {
	req, out := c.RevokeTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetRiskConfiguration = "SetRiskConfiguration"

// SetRiskConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the SetRiskConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetRiskConfiguration for more information on using the SetRiskConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetRiskConfigurationRequest method.
//    req, resp := client.SetRiskConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetRiskConfiguration
func (c *CognitoIdentityProvider) SetRiskConfigurationRequest(input *SetRiskConfigurationInput) (req *request.Request, output *SetRiskConfigurationOutput) {
	op := &request.Operation{
		Name:       opSetRiskConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetRiskConfigurationInput{}
	}

	output = &SetRiskConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetRiskConfiguration API operation for Amazon Cognito Identity Provider.
//
// Configures actions on detected risks. To delete the risk configuration for
// UserPoolId or ClientId, pass null values for all four configuration types.
//
// To activate Amazon Cognito advanced security features, update the user pool
// to include the UserPoolAddOns keyAdvancedSecurityMode.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation SetRiskConfiguration for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserPoolAddOnNotEnabledException
//   This exception is thrown when user pool add-ons aren't enabled.
//
//   * CodeDeliveryFailureException
//   This exception is thrown when a verification code fails to deliver successfully.
//
//   * InvalidEmailRoleAccessPolicyException
//   This exception is thrown when Amazon Cognito isn't allowed to use your email
//   identity. HTTP status code: 400.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetRiskConfiguration
func (c *CognitoIdentityProvider) SetRiskConfiguration(input *SetRiskConfigurationInput) (*SetRiskConfigurationOutput, error) {
	req, out := c.SetRiskConfigurationRequest(input)
	return out, req.Send()
}

// SetRiskConfigurationWithContext is the same as SetRiskConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See SetRiskConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) SetRiskConfigurationWithContext(ctx aws.Context, input *SetRiskConfigurationInput, opts ...request.Option) (*SetRiskConfigurationOutput, error) {
	req, out := c.SetRiskConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetUICustomization = "SetUICustomization"

// SetUICustomizationRequest generates a "aws/request.Request" representing the
// client's request for the SetUICustomization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetUICustomization for more information on using the SetUICustomization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetUICustomizationRequest method.
//    req, resp := client.SetUICustomizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUICustomization
func (c *CognitoIdentityProvider) SetUICustomizationRequest(input *SetUICustomizationInput) (req *request.Request, output *SetUICustomizationOutput) {
	op := &request.Operation{
		Name:       opSetUICustomization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetUICustomizationInput{}
	}

	output = &SetUICustomizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetUICustomization API operation for Amazon Cognito Identity Provider.
//
// Sets the user interface (UI) customization information for a user pool's
// built-in app UI.
//
// You can specify app UI customization settings for a single client (with a
// specific clientId) or for all clients (by setting the clientId to ALL). If
// you specify ALL, the default configuration is used for every client that
// has no previously set UI customization. If you specify UI customization settings
// for a particular client, it will no longer return to the ALL configuration.
//
// To use this API, your user pool must have a domain associated with it. Otherwise,
// there is no place to host the app's pages, and the service will throw an
// error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation SetUICustomization for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUICustomization
func (c *CognitoIdentityProvider) SetUICustomization(input *SetUICustomizationInput) (*SetUICustomizationOutput, error) {
	req, out := c.SetUICustomizationRequest(input)
	return out, req.Send()
}

// SetUICustomizationWithContext is the same as SetUICustomization with the addition of
// the ability to pass a context and additional request options.
//
// See SetUICustomization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) SetUICustomizationWithContext(ctx aws.Context, input *SetUICustomizationInput, opts ...request.Option) (*SetUICustomizationOutput, error) {
	req, out := c.SetUICustomizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetUserMFAPreference = "SetUserMFAPreference"

// SetUserMFAPreferenceRequest generates a "aws/request.Request" representing the
// client's request for the SetUserMFAPreference operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetUserMFAPreference for more information on using the SetUserMFAPreference
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetUserMFAPreferenceRequest method.
//    req, resp := client.SetUserMFAPreferenceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserMFAPreference
func (c *CognitoIdentityProvider) SetUserMFAPreferenceRequest(input *SetUserMFAPreferenceInput) (req *request.Request, output *SetUserMFAPreferenceOutput) {
	op := &request.Operation{
		Name:       opSetUserMFAPreference,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetUserMFAPreferenceInput{}
	}

	output = &SetUserMFAPreferenceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetUserMFAPreference API operation for Amazon Cognito Identity Provider.
//
// Set the user's multi-factor authentication (MFA) method preference, including
// which MFA factors are activated and if any are preferred. Only one factor
// can be set as preferred. The preferred MFA factor will be used to authenticate
// a user if multiple factors are activated. If multiple options are activated
// and no preference is set, a challenge to choose an MFA option will be returned
// during sign-in. If an MFA type is activated for a user, the user will be
// prompted for MFA during all sign-in attempts unless device tracking is turned
// on and the device has been trusted. If you want MFA to be applied selectively
// based on the assessed risk level of sign-in attempts, deactivate MFA for
// users and turn on Adaptive Authentication for the user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation SetUserMFAPreference for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserMFAPreference
func (c *CognitoIdentityProvider) SetUserMFAPreference(input *SetUserMFAPreferenceInput) (*SetUserMFAPreferenceOutput, error) {
	req, out := c.SetUserMFAPreferenceRequest(input)
	return out, req.Send()
}

// SetUserMFAPreferenceWithContext is the same as SetUserMFAPreference with the addition of
// the ability to pass a context and additional request options.
//
// See SetUserMFAPreference for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) SetUserMFAPreferenceWithContext(ctx aws.Context, input *SetUserMFAPreferenceInput, opts ...request.Option) (*SetUserMFAPreferenceOutput, error) {
	req, out := c.SetUserMFAPreferenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetUserPoolMfaConfig = "SetUserPoolMfaConfig"

// SetUserPoolMfaConfigRequest generates a "aws/request.Request" representing the
// client's request for the SetUserPoolMfaConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetUserPoolMfaConfig for more information on using the SetUserPoolMfaConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetUserPoolMfaConfigRequest method.
//    req, resp := client.SetUserPoolMfaConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserPoolMfaConfig
func (c *CognitoIdentityProvider) SetUserPoolMfaConfigRequest(input *SetUserPoolMfaConfigInput) (req *request.Request, output *SetUserPoolMfaConfigOutput) {
	op := &request.Operation{
		Name:       opSetUserPoolMfaConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetUserPoolMfaConfigInput{}
	}

	output = &SetUserPoolMfaConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetUserPoolMfaConfig API operation for Amazon Cognito Identity Provider.
//
// Sets the user pool multi-factor authentication (MFA) configuration.
//
// This action might generate an SMS text message. Starting June 1, 2021, US
// telecom carriers require you to register an origination phone number before
// you can send SMS messages to US phone numbers. If you use SMS text messages
// in Amazon Cognito, you must register a phone number with Amazon Pinpoint
// (https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the
// registered number automatically. Otherwise, Amazon Cognito users who must
// receive SMS messages might not be able to sign up, activate their accounts,
// or sign in.
//
// If you have never used SMS text messages with Amazon Cognito or any other
// Amazon Web Service, Amazon Simple Notification Service might place your account
// in the SMS sandbox. In sandbox mode (https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)
// , you can send messages only to verified phone numbers. After you test your
// app while in the sandbox environment, you can move out of the sandbox and
// into production. For more information, see SMS message settings for Amazon
// Cognito user pools (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html)
// in the Amazon Cognito Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation SetUserPoolMfaConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration doesn't
//   have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is not valid for the
//   role provided for SMS configuration. This can happen if you don't trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserPoolMfaConfig
func (c *CognitoIdentityProvider) SetUserPoolMfaConfig(input *SetUserPoolMfaConfigInput) (*SetUserPoolMfaConfigOutput, error) {
	req, out := c.SetUserPoolMfaConfigRequest(input)
	return out, req.Send()
}

// SetUserPoolMfaConfigWithContext is the same as SetUserPoolMfaConfig with the addition of
// the ability to pass a context and additional request options.
//
// See SetUserPoolMfaConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) SetUserPoolMfaConfigWithContext(ctx aws.Context, input *SetUserPoolMfaConfigInput, opts ...request.Option) (*SetUserPoolMfaConfigOutput, error) {
	req, out := c.SetUserPoolMfaConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetUserSettings = "SetUserSettings"

// SetUserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the SetUserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetUserSettings for more information on using the SetUserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetUserSettingsRequest method.
//    req, resp := client.SetUserSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserSettings
func (c *CognitoIdentityProvider) SetUserSettingsRequest(input *SetUserSettingsInput) (req *request.Request, output *SetUserSettingsOutput) {
	op := &request.Operation{
		Name:       opSetUserSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetUserSettingsInput{}
	}

	output = &SetUserSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetUserSettings API operation for Amazon Cognito Identity Provider.
//
// This action is no longer supported. You can use it to configure only SMS
// MFA. You can't use it to configure time-based one-time password (TOTP) software
// token MFA. To configure either type of MFA, use SetUserMFAPreference (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserMFAPreference.html)
// instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation SetUserSettings for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserSettings
func (c *CognitoIdentityProvider) SetUserSettings(input *SetUserSettingsInput) (*SetUserSettingsOutput, error) {
	req, out := c.SetUserSettingsRequest(input)
	return out, req.Send()
}

// SetUserSettingsWithContext is the same as SetUserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See SetUserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) SetUserSettingsWithContext(ctx aws.Context, input *SetUserSettingsInput, opts ...request.Option) (*SetUserSettingsOutput, error) {
	req, out := c.SetUserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSignUp = "SignUp"

// SignUpRequest generates a "aws/request.Request" representing the
// client's request for the SignUp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SignUp for more information on using the SignUp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SignUpRequest method.
//    req, resp := client.SignUpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SignUp
func (c *CognitoIdentityProvider) SignUpRequest(input *SignUpInput) (req *request.Request, output *SignUpOutput) {
	op := &request.Operation{
		Name:       opSignUp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SignUpInput{}
	}

	output = &SignUpOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// SignUp API operation for Amazon Cognito Identity Provider.
//
// Registers the user in the specified user pool and creates a user name, password,
// and user attributes.
//
// This action might generate an SMS text message. Starting June 1, 2021, US
// telecom carriers require you to register an origination phone number before
// you can send SMS messages to US phone numbers. If you use SMS text messages
// in Amazon Cognito, you must register a phone number with Amazon Pinpoint
// (https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the
// registered number automatically. Otherwise, Amazon Cognito users who must
// receive SMS messages might not be able to sign up, activate their accounts,
// or sign in.
//
// If you have never used SMS text messages with Amazon Cognito or any other
// Amazon Web Service, Amazon Simple Notification Service might place your account
// in the SMS sandbox. In sandbox mode (https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)
// , you can send messages only to verified phone numbers. After you test your
// app while in the sandbox environment, you can move out of the sandbox and
// into production. For more information, see SMS message settings for Amazon
// Cognito user pools (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html)
// in the Amazon Cognito Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation SignUp for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * UnexpectedLambdaException
//   This exception is thrown when Amazon Cognito encounters an unexpected exception
//   with Lambda.
//
//   * UserLambdaValidationException
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the Lambda service.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InvalidPasswordException
//   This exception is thrown when Amazon Cognito encounters an invalid password.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when Amazon Cognito encounters an invalid Lambda
//   response.
//
//   * UsernameExistsException
//   This exception is thrown when Amazon Cognito encounters a user name that
//   already exists in the user pool.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration doesn't
//   have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is not valid for the
//   role provided for SMS configuration. This can happen if you don't trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * InvalidEmailRoleAccessPolicyException
//   This exception is thrown when Amazon Cognito isn't allowed to use your email
//   identity. HTTP status code: 400.
//
//   * CodeDeliveryFailureException
//   This exception is thrown when a verification code fails to deliver successfully.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SignUp
func (c *CognitoIdentityProvider) SignUp(input *SignUpInput) (*SignUpOutput, error) {
	req, out := c.SignUpRequest(input)
	return out, req.Send()
}

// SignUpWithContext is the same as SignUp with the addition of
// the ability to pass a context and additional request options.
//
// See SignUp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) SignUpWithContext(ctx aws.Context, input *SignUpInput, opts ...request.Option) (*SignUpOutput, error) {
	req, out := c.SignUpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartUserImportJob = "StartUserImportJob"

// StartUserImportJobRequest generates a "aws/request.Request" representing the
// client's request for the StartUserImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartUserImportJob for more information on using the StartUserImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartUserImportJobRequest method.
//    req, resp := client.StartUserImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StartUserImportJob
func (c *CognitoIdentityProvider) StartUserImportJobRequest(input *StartUserImportJobInput) (req *request.Request, output *StartUserImportJobOutput) {
	op := &request.Operation{
		Name:       opStartUserImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartUserImportJobInput{}
	}

	output = &StartUserImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartUserImportJob API operation for Amazon Cognito Identity Provider.
//
// Starts the user import.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation StartUserImportJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * PreconditionNotMetException
//   This exception is thrown when a precondition is not met.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StartUserImportJob
func (c *CognitoIdentityProvider) StartUserImportJob(input *StartUserImportJobInput) (*StartUserImportJobOutput, error) {
	req, out := c.StartUserImportJobRequest(input)
	return out, req.Send()
}

// StartUserImportJobWithContext is the same as StartUserImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartUserImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) StartUserImportJobWithContext(ctx aws.Context, input *StartUserImportJobInput, opts ...request.Option) (*StartUserImportJobOutput, error) {
	req, out := c.StartUserImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopUserImportJob = "StopUserImportJob"

// StopUserImportJobRequest generates a "aws/request.Request" representing the
// client's request for the StopUserImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopUserImportJob for more information on using the StopUserImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopUserImportJobRequest method.
//    req, resp := client.StopUserImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StopUserImportJob
func (c *CognitoIdentityProvider) StopUserImportJobRequest(input *StopUserImportJobInput) (req *request.Request, output *StopUserImportJobOutput) {
	op := &request.Operation{
		Name:       opStopUserImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopUserImportJobInput{}
	}

	output = &StopUserImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopUserImportJob API operation for Amazon Cognito Identity Provider.
//
// Stops the user import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation StopUserImportJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * PreconditionNotMetException
//   This exception is thrown when a precondition is not met.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StopUserImportJob
func (c *CognitoIdentityProvider) StopUserImportJob(input *StopUserImportJobInput) (*StopUserImportJobOutput, error) {
	req, out := c.StopUserImportJobRequest(input)
	return out, req.Send()
}

// StopUserImportJobWithContext is the same as StopUserImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopUserImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) StopUserImportJobWithContext(ctx aws.Context, input *StopUserImportJobInput, opts ...request.Option) (*StopUserImportJobOutput, error) {
	req, out := c.StopUserImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/TagResource
func (c *CognitoIdentityProvider) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Cognito Identity Provider.
//
// Assigns a set of tags to an Amazon Cognito user pool. A tag is a label that
// you can use to categorize and manage user pools in different ways, such as
// by purpose, owner, environment, or other criteria.
//
// Each tag consists of a key and value, both of which you define. A key is
// a general category for more specific values. For example, if you have two
// versions of a user pool, one for testing and another for production, you
// might assign an Environment tag key to both user pools. The value of this
// key might be Test for one user pool, and Production for the other.
//
// Tags are useful for cost tracking and access control. You can activate your
// tags so that they appear on the Billing and Cost Management console, where
// you can track the costs associated with your user pools. In an Identity and
// Access Management policy, you can constrain permissions for user pools based
// on specific tags or tag values.
//
// You can use this action up to 5 times per second, per account. A user pool
// can have as many as 50 tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/TagResource
func (c *CognitoIdentityProvider) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UntagResource
func (c *CognitoIdentityProvider) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Cognito Identity Provider.
//
// Removes the specified tags from an Amazon Cognito user pool. You can use
// this action up to 5 times per second, per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UntagResource
func (c *CognitoIdentityProvider) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAuthEventFeedback = "UpdateAuthEventFeedback"

// UpdateAuthEventFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAuthEventFeedback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAuthEventFeedback for more information on using the UpdateAuthEventFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAuthEventFeedbackRequest method.
//    req, resp := client.UpdateAuthEventFeedbackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateAuthEventFeedback
func (c *CognitoIdentityProvider) UpdateAuthEventFeedbackRequest(input *UpdateAuthEventFeedbackInput) (req *request.Request, output *UpdateAuthEventFeedbackOutput) {
	op := &request.Operation{
		Name:       opUpdateAuthEventFeedback,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAuthEventFeedbackInput{}
	}

	output = &UpdateAuthEventFeedbackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateAuthEventFeedback API operation for Amazon Cognito Identity Provider.
//
// Provides the feedback for an authentication event, whether it was from a
// valid user or not. This feedback is used for improving the risk evaluation
// decision for the user pool as part of Amazon Cognito advanced security.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateAuthEventFeedback for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserPoolAddOnNotEnabledException
//   This exception is thrown when user pool add-ons aren't enabled.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateAuthEventFeedback
func (c *CognitoIdentityProvider) UpdateAuthEventFeedback(input *UpdateAuthEventFeedbackInput) (*UpdateAuthEventFeedbackOutput, error) {
	req, out := c.UpdateAuthEventFeedbackRequest(input)
	return out, req.Send()
}

// UpdateAuthEventFeedbackWithContext is the same as UpdateAuthEventFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAuthEventFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) UpdateAuthEventFeedbackWithContext(ctx aws.Context, input *UpdateAuthEventFeedbackInput, opts ...request.Option) (*UpdateAuthEventFeedbackOutput, error) {
	req, out := c.UpdateAuthEventFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDeviceStatus = "UpdateDeviceStatus"

// UpdateDeviceStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDeviceStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDeviceStatus for more information on using the UpdateDeviceStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDeviceStatusRequest method.
//    req, resp := client.UpdateDeviceStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateDeviceStatus
func (c *CognitoIdentityProvider) UpdateDeviceStatusRequest(input *UpdateDeviceStatusInput) (req *request.Request, output *UpdateDeviceStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateDeviceStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDeviceStatusInput{}
	}

	output = &UpdateDeviceStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDeviceStatus API operation for Amazon Cognito Identity Provider.
//
// Updates the device status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateDeviceStatus for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is not valid.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateDeviceStatus
func (c *CognitoIdentityProvider) UpdateDeviceStatus(input *UpdateDeviceStatusInput) (*UpdateDeviceStatusOutput, error) {
	req, out := c.UpdateDeviceStatusRequest(input)
	return out, req.Send()
}

// UpdateDeviceStatusWithContext is the same as UpdateDeviceStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDeviceStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) UpdateDeviceStatusWithContext(ctx aws.Context, input *UpdateDeviceStatusInput, opts ...request.Option) (*UpdateDeviceStatusOutput, error) {
	req, out := c.UpdateDeviceStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGroup = "UpdateGroup"

// UpdateGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGroup for more information on using the UpdateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGroupRequest method.
//    req, resp := client.UpdateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateGroup
func (c *CognitoIdentityProvider) UpdateGroupRequest(input *UpdateGroupInput) (req *request.Request, output *UpdateGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGroupInput{}
	}

	output = &UpdateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGroup API operation for Amazon Cognito Identity Provider.
//
// Updates the specified group with the specified attributes.
//
// Calling this action requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateGroup for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateGroup
func (c *CognitoIdentityProvider) UpdateGroup(input *UpdateGroupInput) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	return out, req.Send()
}

// UpdateGroupWithContext is the same as UpdateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) UpdateGroupWithContext(ctx aws.Context, input *UpdateGroupInput, opts ...request.Option) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIdentityProvider = "UpdateIdentityProvider"

// UpdateIdentityProviderRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIdentityProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIdentityProvider for more information on using the UpdateIdentityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIdentityProviderRequest method.
//    req, resp := client.UpdateIdentityProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateIdentityProvider
func (c *CognitoIdentityProvider) UpdateIdentityProviderRequest(input *UpdateIdentityProviderInput) (req *request.Request, output *UpdateIdentityProviderOutput) {
	op := &request.Operation{
		Name:       opUpdateIdentityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateIdentityProviderInput{}
	}

	output = &UpdateIdentityProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIdentityProvider API operation for Amazon Cognito Identity Provider.
//
// Updates identity provider information for a user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateIdentityProvider for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * UnsupportedIdentityProviderException
//   This exception is thrown when the specified identifier isn't supported.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateIdentityProvider
func (c *CognitoIdentityProvider) UpdateIdentityProvider(input *UpdateIdentityProviderInput) (*UpdateIdentityProviderOutput, error) {
	req, out := c.UpdateIdentityProviderRequest(input)
	return out, req.Send()
}

// UpdateIdentityProviderWithContext is the same as UpdateIdentityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIdentityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) UpdateIdentityProviderWithContext(ctx aws.Context, input *UpdateIdentityProviderInput, opts ...request.Option) (*UpdateIdentityProviderOutput, error) {
	req, out := c.UpdateIdentityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResourceServer = "UpdateResourceServer"

// UpdateResourceServerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResourceServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResourceServer for more information on using the UpdateResourceServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateResourceServerRequest method.
//    req, resp := client.UpdateResourceServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateResourceServer
func (c *CognitoIdentityProvider) UpdateResourceServerRequest(input *UpdateResourceServerInput) (req *request.Request, output *UpdateResourceServerOutput) {
	op := &request.Operation{
		Name:       opUpdateResourceServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateResourceServerInput{}
	}

	output = &UpdateResourceServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResourceServer API operation for Amazon Cognito Identity Provider.
//
// Updates the name and scopes of resource server. All other fields are read-only.
//
// If you don't provide a value for an attribute, it is set to the default value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateResourceServer for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateResourceServer
func (c *CognitoIdentityProvider) UpdateResourceServer(input *UpdateResourceServerInput) (*UpdateResourceServerOutput, error) {
	req, out := c.UpdateResourceServerRequest(input)
	return out, req.Send()
}

// UpdateResourceServerWithContext is the same as UpdateResourceServer with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResourceServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) UpdateResourceServerWithContext(ctx aws.Context, input *UpdateResourceServerInput, opts ...request.Option) (*UpdateResourceServerOutput, error) {
	req, out := c.UpdateResourceServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserAttributes = "UpdateUserAttributes"

// UpdateUserAttributesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserAttributes for more information on using the UpdateUserAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserAttributesRequest method.
//    req, resp := client.UpdateUserAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserAttributes
func (c *CognitoIdentityProvider) UpdateUserAttributesRequest(input *UpdateUserAttributesInput) (req *request.Request, output *UpdateUserAttributesOutput) {
	op := &request.Operation{
		Name:       opUpdateUserAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserAttributesInput{}
	}

	output = &UpdateUserAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	return
}

// UpdateUserAttributes API operation for Amazon Cognito Identity Provider.
//
// Allows a user to update a specific attribute (one at a time).
//
// This action might generate an SMS text message. Starting June 1, 2021, US
// telecom carriers require you to register an origination phone number before
// you can send SMS messages to US phone numbers. If you use SMS text messages
// in Amazon Cognito, you must register a phone number with Amazon Pinpoint
// (https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the
// registered number automatically. Otherwise, Amazon Cognito users who must
// receive SMS messages might not be able to sign up, activate their accounts,
// or sign in.
//
// If you have never used SMS text messages with Amazon Cognito or any other
// Amazon Web Service, Amazon Simple Notification Service might place your account
// in the SMS sandbox. In sandbox mode (https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)
// , you can send messages only to verified phone numbers. After you test your
// app while in the sandbox environment, you can move out of the sandbox and
// into production. For more information, see SMS message settings for Amazon
// Cognito user pools (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html)
// in the Amazon Cognito Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateUserAttributes for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * CodeMismatchException
//   This exception is thrown if the provided code doesn't match what the server
//   was expecting.
//
//   * ExpiredCodeException
//   This exception is thrown if a code has expired.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UnexpectedLambdaException
//   This exception is thrown when Amazon Cognito encounters an unexpected exception
//   with Lambda.
//
//   * UserLambdaValidationException
//   This exception is thrown when the Amazon Cognito service encounters a user
//   validation exception with the Lambda service.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when Amazon Cognito encounters an invalid Lambda
//   response.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * AliasExistsException
//   This exception is thrown when a user tries to confirm the account with an
//   email or phone number that has already been supplied as an alias from a different
//   account. This exception tells user that an account with this email or phone
//   already exists.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration doesn't
//   have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is not valid for the
//   role provided for SMS configuration. This can happen if you don't trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * InvalidEmailRoleAccessPolicyException
//   This exception is thrown when Amazon Cognito isn't allowed to use your email
//   identity. HTTP status code: 400.
//
//   * CodeDeliveryFailureException
//   This exception is thrown when a verification code fails to deliver successfully.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserAttributes
func (c *CognitoIdentityProvider) UpdateUserAttributes(input *UpdateUserAttributesInput) (*UpdateUserAttributesOutput, error) {
	req, out := c.UpdateUserAttributesRequest(input)
	return out, req.Send()
}

// UpdateUserAttributesWithContext is the same as UpdateUserAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) UpdateUserAttributesWithContext(ctx aws.Context, input *UpdateUserAttributesInput, opts ...request.Option) (*UpdateUserAttributesOutput, error) {
	req, out := c.UpdateUserAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserPool = "UpdateUserPool"

// UpdateUserPoolRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserPool for more information on using the UpdateUserPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserPoolRequest method.
//    req, resp := client.UpdateUserPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPool
func (c *CognitoIdentityProvider) UpdateUserPoolRequest(input *UpdateUserPoolInput) (req *request.Request, output *UpdateUserPoolOutput) {
	op := &request.Operation{
		Name:       opUpdateUserPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserPoolInput{}
	}

	output = &UpdateUserPoolOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserPool API operation for Amazon Cognito Identity Provider.
//
// Updates the specified user pool with the specified attributes. You can get
// a list of the current user pool settings using DescribeUserPool (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html).
// If you don't provide a value for an attribute, it will be set to the default
// value.
//
// This action might generate an SMS text message. Starting June 1, 2021, US
// telecom carriers require you to register an origination phone number before
// you can send SMS messages to US phone numbers. If you use SMS text messages
// in Amazon Cognito, you must register a phone number with Amazon Pinpoint
// (https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the
// registered number automatically. Otherwise, Amazon Cognito users who must
// receive SMS messages might not be able to sign up, activate their accounts,
// or sign in.
//
// If you have never used SMS text messages with Amazon Cognito or any other
// Amazon Web Service, Amazon Simple Notification Service might place your account
// in the SMS sandbox. In sandbox mode (https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)
// , you can send messages only to verified phone numbers. After you test your
// app while in the sandbox environment, you can move out of the sandbox and
// into production. For more information, see SMS message settings for Amazon
// Cognito user pools (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html)
// in the Amazon Cognito Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateUserPool for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ConcurrentModificationException
//   This exception is thrown if two or more modifications are happening concurrently.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * UserImportInProgressException
//   This exception is thrown when you're trying to modify a user pool while a
//   user import job is in progress for that pool.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration doesn't
//   have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is not valid for the
//   role provided for SMS configuration. This can happen if you don't trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * UserPoolTaggingException
//   This exception is thrown when a user pool tag can't be set or updated.
//
//   * InvalidEmailRoleAccessPolicyException
//   This exception is thrown when Amazon Cognito isn't allowed to use your email
//   identity. HTTP status code: 400.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPool
func (c *CognitoIdentityProvider) UpdateUserPool(input *UpdateUserPoolInput) (*UpdateUserPoolOutput, error) {
	req, out := c.UpdateUserPoolRequest(input)
	return out, req.Send()
}

// UpdateUserPoolWithContext is the same as UpdateUserPool with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) UpdateUserPoolWithContext(ctx aws.Context, input *UpdateUserPoolInput, opts ...request.Option) (*UpdateUserPoolOutput, error) {
	req, out := c.UpdateUserPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserPoolClient = "UpdateUserPoolClient"

// UpdateUserPoolClientRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserPoolClient operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserPoolClient for more information on using the UpdateUserPoolClient
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserPoolClientRequest method.
//    req, resp := client.UpdateUserPoolClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolClient
func (c *CognitoIdentityProvider) UpdateUserPoolClientRequest(input *UpdateUserPoolClientInput) (req *request.Request, output *UpdateUserPoolClientOutput) {
	op := &request.Operation{
		Name:       opUpdateUserPoolClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserPoolClientInput{}
	}

	output = &UpdateUserPoolClientOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUserPoolClient API operation for Amazon Cognito Identity Provider.
//
// Updates the specified user pool app client with the specified attributes.
// You can get a list of the current user pool app client settings using DescribeUserPoolClient
// (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolClient.html).
//
// If you don't provide a value for an attribute, it will be set to the default
// value.
//
// You can also use this operation to enable token revocation for user pool
// clients. For more information about revoking tokens, see RevokeToken (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateUserPoolClient for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ConcurrentModificationException
//   This exception is thrown if two or more modifications are happening concurrently.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * ScopeDoesNotExistException
//   This exception is thrown when the specified scope doesn't exist.
//
//   * InvalidOAuthFlowException
//   This exception is thrown when the specified OAuth flow is not valid.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolClient
func (c *CognitoIdentityProvider) UpdateUserPoolClient(input *UpdateUserPoolClientInput) (*UpdateUserPoolClientOutput, error) {
	req, out := c.UpdateUserPoolClientRequest(input)
	return out, req.Send()
}

// UpdateUserPoolClientWithContext is the same as UpdateUserPoolClient with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserPoolClient for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) UpdateUserPoolClientWithContext(ctx aws.Context, input *UpdateUserPoolClientInput, opts ...request.Option) (*UpdateUserPoolClientOutput, error) {
	req, out := c.UpdateUserPoolClientRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserPoolDomain = "UpdateUserPoolDomain"

// UpdateUserPoolDomainRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserPoolDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserPoolDomain for more information on using the UpdateUserPoolDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserPoolDomainRequest method.
//    req, resp := client.UpdateUserPoolDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolDomain
func (c *CognitoIdentityProvider) UpdateUserPoolDomainRequest(input *UpdateUserPoolDomainInput) (req *request.Request, output *UpdateUserPoolDomainOutput) {
	op := &request.Operation{
		Name:       opUpdateUserPoolDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserPoolDomainInput{}
	}

	output = &UpdateUserPoolDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUserPoolDomain API operation for Amazon Cognito Identity Provider.
//
// Updates the Secure Sockets Layer (SSL) certificate for the custom domain
// for your user pool.
//
// You can use this operation to provide the Amazon Resource Name (ARN) of a
// new certificate to Amazon Cognito. You can't use it to change the domain
// for a user pool.
//
// A custom domain is used to host the Amazon Cognito hosted UI, which provides
// sign-up and sign-in pages for your application. When you set up a custom
// domain, you provide a certificate that you manage with Certificate Manager
// (ACM). When necessary, you can use this operation to change the certificate
// that you applied to your custom domain.
//
// Usually, this is unnecessary following routine certificate renewal with ACM.
// When you renew your existing certificate in ACM, the ARN for your certificate
// remains the same, and your custom domain uses the new certificate automatically.
//
// However, if you replace your existing certificate with a new one, ACM gives
// the new certificate a new ARN. To apply the new certificate to your custom
// domain, you must provide this ARN to Amazon Cognito.
//
// When you add your new certificate in ACM, you must choose US East (N. Virginia)
// as the Amazon Web Services Region.
//
// After you submit your request, Amazon Cognito requires up to 1 hour to distribute
// your new certificate to your custom domain.
//
// For more information about adding a custom domain to your user pool, see
// Using Your Own Domain for the Hosted UI (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateUserPoolDomain for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolDomain
func (c *CognitoIdentityProvider) UpdateUserPoolDomain(input *UpdateUserPoolDomainInput) (*UpdateUserPoolDomainOutput, error) {
	req, out := c.UpdateUserPoolDomainRequest(input)
	return out, req.Send()
}

// UpdateUserPoolDomainWithContext is the same as UpdateUserPoolDomain with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserPoolDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) UpdateUserPoolDomainWithContext(ctx aws.Context, input *UpdateUserPoolDomainInput, opts ...request.Option) (*UpdateUserPoolDomainOutput, error) {
	req, out := c.UpdateUserPoolDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVerifySoftwareToken = "VerifySoftwareToken"

// VerifySoftwareTokenRequest generates a "aws/request.Request" representing the
// client's request for the VerifySoftwareToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See VerifySoftwareToken for more information on using the VerifySoftwareToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the VerifySoftwareTokenRequest method.
//    req, resp := client.VerifySoftwareTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifySoftwareToken
func (c *CognitoIdentityProvider) VerifySoftwareTokenRequest(input *VerifySoftwareTokenInput) (req *request.Request, output *VerifySoftwareTokenOutput) {
	op := &request.Operation{
		Name:       opVerifySoftwareToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifySoftwareTokenInput{}
	}

	output = &VerifySoftwareTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// VerifySoftwareToken API operation for Amazon Cognito Identity Provider.
//
// Use this API to register a user's entered time-based one-time password (TOTP)
// code and mark the user's software token MFA status as "verified" if successful.
// The request takes an access token or a session string, but not both.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation VerifySoftwareToken for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is not valid.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * EnableSoftwareTokenMFAException
//   This exception is thrown when there is a code mismatch and the service fails
//   to configure the software token TOTP multi-factor authentication (MFA).
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * SoftwareTokenMFANotFoundException
//   This exception is thrown when the software token time-based one-time password
//   (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.
//
//   * CodeMismatchException
//   This exception is thrown if the provided code doesn't match what the server
//   was expecting.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifySoftwareToken
func (c *CognitoIdentityProvider) VerifySoftwareToken(input *VerifySoftwareTokenInput) (*VerifySoftwareTokenOutput, error) {
	req, out := c.VerifySoftwareTokenRequest(input)
	return out, req.Send()
}

// VerifySoftwareTokenWithContext is the same as VerifySoftwareToken with the addition of
// the ability to pass a context and additional request options.
//
// See VerifySoftwareToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) VerifySoftwareTokenWithContext(ctx aws.Context, input *VerifySoftwareTokenInput, opts ...request.Option) (*VerifySoftwareTokenOutput, error) {
	req, out := c.VerifySoftwareTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVerifyUserAttribute = "VerifyUserAttribute"

// VerifyUserAttributeRequest generates a "aws/request.Request" representing the
// client's request for the VerifyUserAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See VerifyUserAttribute for more information on using the VerifyUserAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the VerifyUserAttributeRequest method.
//    req, resp := client.VerifyUserAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifyUserAttribute
func (c *CognitoIdentityProvider) VerifyUserAttributeRequest(input *VerifyUserAttributeInput) (req *request.Request, output *VerifyUserAttributeOutput) {
	op := &request.Operation{
		Name:       opVerifyUserAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyUserAttributeInput{}
	}

	output = &VerifyUserAttributeOutput{}
	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// VerifyUserAttribute API operation for Amazon Cognito Identity Provider.
//
// Verifies the specified user attributes in the user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation VerifyUserAttribute for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service can't find the requested
//   resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * CodeMismatchException
//   This exception is thrown if the provided code doesn't match what the server
//   was expecting.
//
//   * ExpiredCodeException
//   This exception is thrown if a code has expired.
//
//   * NotAuthorizedException
//   This exception is thrown when a user isn't authorized.
//
//   * TooManyRequestsException
//   This exception is thrown when the user has made too many requests for a given
//   operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested Amazon
//   Web Services resource.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user isn't found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user isn't confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifyUserAttribute
func (c *CognitoIdentityProvider) VerifyUserAttribute(input *VerifyUserAttributeInput) (*VerifyUserAttributeOutput, error) {
	req, out := c.VerifyUserAttributeRequest(input)
	return out, req.Send()
}

// VerifyUserAttributeWithContext is the same as VerifyUserAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See VerifyUserAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentityProvider) VerifyUserAttributeWithContext(ctx aws.Context, input *VerifyUserAttributeInput, opts ...request.Option) (*VerifyUserAttributeOutput, error) {
	req, out := c.VerifyUserAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The data type for AccountRecoverySetting.
type AccountRecoverySettingType struct {
	_ struct{} `type:"structure"`

	// The list of RecoveryOptionTypes.
	RecoveryMechanisms []*RecoveryOptionType `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountRecoverySettingType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountRecoverySettingType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountRecoverySettingType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccountRecoverySettingType"}
	if s.RecoveryMechanisms != nil && len(s.RecoveryMechanisms) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecoveryMechanisms", 1))
	}
	if s.RecoveryMechanisms != nil {
		for i, v := range s.RecoveryMechanisms {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RecoveryMechanisms", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecoveryMechanisms sets the RecoveryMechanisms field's value.
func (s *AccountRecoverySettingType) SetRecoveryMechanisms(v []*RecoveryOptionType) *AccountRecoverySettingType {
	s.RecoveryMechanisms = v
	return s
}

// Account takeover action type.
type AccountTakeoverActionType struct {
	_ struct{} `type:"structure"`

	// The action to take in response to the account takeover action. Valid values
	// are:
	//
	//    * BLOCK Choosing this action will block the request.
	//
	//    * MFA_IF_CONFIGURED Present an MFA challenge if user has configured it,
	//    else allow the request.
	//
	//    * MFA_REQUIRED Present an MFA challenge if user has configured it, else
	//    block the request.
	//
	//    * NO_ACTION Allow the user to sign in.
	//
	// EventAction is a required field
	EventAction *string `type:"string" required:"true" enum:"AccountTakeoverEventActionType"`

	// Flag specifying whether to send a notification.
	//
	// Notify is a required field
	Notify *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountTakeoverActionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountTakeoverActionType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountTakeoverActionType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccountTakeoverActionType"}
	if s.EventAction == nil {
		invalidParams.Add(request.NewErrParamRequired("EventAction"))
	}
	if s.Notify == nil {
		invalidParams.Add(request.NewErrParamRequired("Notify"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventAction sets the EventAction field's value.
func (s *AccountTakeoverActionType) SetEventAction(v string) *AccountTakeoverActionType {
	s.EventAction = &v
	return s
}

// SetNotify sets the Notify field's value.
func (s *AccountTakeoverActionType) SetNotify(v bool) *AccountTakeoverActionType {
	s.Notify = &v
	return s
}

// Account takeover actions type.
type AccountTakeoverActionsType struct {
	_ struct{} `type:"structure"`

	// Action to take for a high risk.
	HighAction *AccountTakeoverActionType `type:"structure"`

	// Action to take for a low risk.
	LowAction *AccountTakeoverActionType `type:"structure"`

	// Action to take for a medium risk.
	MediumAction *AccountTakeoverActionType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountTakeoverActionsType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountTakeoverActionsType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountTakeoverActionsType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccountTakeoverActionsType"}
	if s.HighAction != nil {
		if err := s.HighAction.Validate(); err != nil {
			invalidParams.AddNested("HighAction", err.(request.ErrInvalidParams))
		}
	}
	if s.LowAction != nil {
		if err := s.LowAction.Validate(); err != nil {
			invalidParams.AddNested("LowAction", err.(request.ErrInvalidParams))
		}
	}
	if s.MediumAction != nil {
		if err := s.MediumAction.Validate(); err != nil {
			invalidParams.AddNested("MediumAction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHighAction sets the HighAction field's value.
func (s *AccountTakeoverActionsType) SetHighAction(v *AccountTakeoverActionType) *AccountTakeoverActionsType {
	s.HighAction = v
	return s
}

// SetLowAction sets the LowAction field's value.
func (s *AccountTakeoverActionsType) SetLowAction(v *AccountTakeoverActionType) *AccountTakeoverActionsType {
	s.LowAction = v
	return s
}

// SetMediumAction sets the MediumAction field's value.
func (s *AccountTakeoverActionsType) SetMediumAction(v *AccountTakeoverActionType) *AccountTakeoverActionsType {
	s.MediumAction = v
	return s
}

// Configuration for mitigation actions and notification for different levels
// of risk detected for a potential account takeover.
type AccountTakeoverRiskConfigurationType struct {
	_ struct{} `type:"structure"`

	// Account takeover risk configuration actions.
	//
	// Actions is a required field
	Actions *AccountTakeoverActionsType `type:"structure" required:"true"`

	// The notify configuration used to construct email notifications.
	NotifyConfiguration *NotifyConfigurationType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountTakeoverRiskConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountTakeoverRiskConfigurationType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountTakeoverRiskConfigurationType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccountTakeoverRiskConfigurationType"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil {
		if err := s.Actions.Validate(); err != nil {
			invalidParams.AddNested("Actions", err.(request.ErrInvalidParams))
		}
	}
	if s.NotifyConfiguration != nil {
		if err := s.NotifyConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NotifyConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *AccountTakeoverRiskConfigurationType) SetActions(v *AccountTakeoverActionsType) *AccountTakeoverRiskConfigurationType {
	s.Actions = v
	return s
}

// SetNotifyConfiguration sets the NotifyConfiguration field's value.
func (s *AccountTakeoverRiskConfigurationType) SetNotifyConfiguration(v *NotifyConfigurationType) *AccountTakeoverRiskConfigurationType {
	s.NotifyConfiguration = v
	return s
}

// Represents the request to add custom attributes.
type AddCustomAttributesInput struct {
	_ struct{} `type:"structure"`

	// An array of custom attributes, such as Mutable and Name.
	//
	// CustomAttributes is a required field
	CustomAttributes []*SchemaAttributeType `min:"1" type:"list" required:"true"`

	// The user pool ID for the user pool where you want to add custom attributes.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddCustomAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddCustomAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddCustomAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddCustomAttributesInput"}
	if s.CustomAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomAttributes"))
	}
	if s.CustomAttributes != nil && len(s.CustomAttributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomAttributes", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.CustomAttributes != nil {
		for i, v := range s.CustomAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomAttributes sets the CustomAttributes field's value.
func (s *AddCustomAttributesInput) SetCustomAttributes(v []*SchemaAttributeType) *AddCustomAttributesInput {
	s.CustomAttributes = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AddCustomAttributesInput) SetUserPoolId(v string) *AddCustomAttributesInput {
	s.UserPoolId = &v
	return s
}

// Represents the response from the server for the request to add custom attributes.
type AddCustomAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddCustomAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddCustomAttributesOutput) GoString() string {
	return s.String()
}

type AdminAddUserToGroupInput struct {
	_ struct{} `type:"structure"`

	// The group name.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The username for the user.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminAddUserToGroupInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminAddUserToGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminAddUserToGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminAddUserToGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminAddUserToGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *AdminAddUserToGroupInput) SetGroupName(v string) *AdminAddUserToGroupInput {
	s.GroupName = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminAddUserToGroupInput) SetUserPoolId(v string) *AdminAddUserToGroupInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminAddUserToGroupInput) SetUsername(v string) *AdminAddUserToGroupInput {
	s.Username = &v
	return s
}

type AdminAddUserToGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminAddUserToGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminAddUserToGroupOutput) GoString() string {
	return s.String()
}

// Represents the request to confirm user registration.
type AdminConfirmSignUpInput struct {
	_ struct{} `type:"structure"`

	// A map of custom key-value pairs that you can provide as input for any custom
	// workflows that this action triggers.
	//
	// If your user pool configuration includes triggers, the AdminConfirmSignUp
	// API action invokes the Lambda function that is specified for the post confirmation
	// trigger. When Amazon Cognito invokes this function, it passes a JSON payload,
	// which the function receives as input. In this payload, the clientMetadata
	// attribute provides the data that you assigned to the ClientMetadata parameter
	// in your AdminConfirmSignUp request. In your function code in Lambda, you
	// can process the ClientMetadata value to enhance your workflow for your specific
	// needs.
	//
	// For more information, see Customizing user pool Workflows with Lambda Triggers
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
	// in the Amazon Cognito Developer Guide.
	//
	// When you use the ClientMetadata parameter, remember that Amazon Cognito won't
	// do the following:
	//
	//    * Store the ClientMetadata value. This data is available only to Lambda
	//    triggers that are assigned to a user pool to support custom workflows.
	//    If your user pool configuration doesn't include triggers, the ClientMetadata
	//    parameter serves no purpose.
	//
	//    * Validate the ClientMetadata value.
	//
	//    * Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide
	//    sensitive information.
	ClientMetadata map[string]*string `type:"map"`

	// The user pool ID for which you want to confirm user registration.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name for which you want to confirm user registration.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminConfirmSignUpInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminConfirmSignUpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminConfirmSignUpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminConfirmSignUpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminConfirmSignUpInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientMetadata sets the ClientMetadata field's value.
func (s *AdminConfirmSignUpInput) SetClientMetadata(v map[string]*string) *AdminConfirmSignUpInput {
	s.ClientMetadata = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminConfirmSignUpInput) SetUserPoolId(v string) *AdminConfirmSignUpInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminConfirmSignUpInput) SetUsername(v string) *AdminConfirmSignUpInput {
	s.Username = &v
	return s
}

// Represents the response from the server for the request to confirm registration.
type AdminConfirmSignUpOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminConfirmSignUpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminConfirmSignUpOutput) GoString() string {
	return s.String()
}

// The configuration for creating a new user profile.
type AdminCreateUserConfigType struct {
	_ struct{} `type:"structure"`

	// Set to True if only the administrator is allowed to create user profiles.
	// Set to False if users can sign themselves up via an app.
	AllowAdminCreateUserOnly *bool `type:"boolean"`

	// The message template to be used for the welcome message to new users.
	//
	// See also Customizing User Invitation Messages (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization).
	InviteMessageTemplate *MessageTemplateType `type:"structure"`

	// The user account expiration limit, in days, after which the account is no
	// longer usable. To reset the account after that time limit, you must call
	// AdminCreateUser again, specifying "RESEND" for the MessageAction parameter.
	// The default value for this parameter is 7.
	//
	// If you set a value for TemporaryPasswordValidityDays in PasswordPolicy, that
	// value will be used, and UnusedAccountValidityDays will be no longer be an
	// available parameter for that user pool.
	UnusedAccountValidityDays *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminCreateUserConfigType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminCreateUserConfigType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminCreateUserConfigType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminCreateUserConfigType"}
	if s.InviteMessageTemplate != nil {
		if err := s.InviteMessageTemplate.Validate(); err != nil {
			invalidParams.AddNested("InviteMessageTemplate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowAdminCreateUserOnly sets the AllowAdminCreateUserOnly field's value.
func (s *AdminCreateUserConfigType) SetAllowAdminCreateUserOnly(v bool) *AdminCreateUserConfigType {
	s.AllowAdminCreateUserOnly = &v
	return s
}

// SetInviteMessageTemplate sets the InviteMessageTemplate field's value.
func (s *AdminCreateUserConfigType) SetInviteMessageTemplate(v *MessageTemplateType) *AdminCreateUserConfigType {
	s.InviteMessageTemplate = v
	return s
}

// SetUnusedAccountValidityDays sets the UnusedAccountValidityDays field's value.
func (s *AdminCreateUserConfigType) SetUnusedAccountValidityDays(v int64) *AdminCreateUserConfigType {
	s.UnusedAccountValidityDays = &v
	return s
}

// Represents the request to create a user in the specified user pool.
type AdminCreateUserInput struct {
	_ struct{} `type:"structure"`

	// A map of custom key-value pairs that you can provide as input for any custom
	// workflows that this action triggers.
	//
	// You create custom workflows by assigning Lambda functions to user pool triggers.
	// When you use the AdminCreateUser API action, Amazon Cognito invokes the function
	// that is assigned to the pre sign-up trigger. When Amazon Cognito invokes
	// this function, it passes a JSON payload, which the function receives as input.
	// This payload contains a clientMetadata attribute, which provides the data
	// that you assigned to the ClientMetadata parameter in your AdminCreateUser
	// request. In your function code in Lambda, you can process the clientMetadata
	// value to enhance your workflow for your specific needs.
	//
	// For more information, see Customizing user pool Workflows with Lambda Triggers
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
	// in the Amazon Cognito Developer Guide.
	//
	// When you use the ClientMetadata parameter, remember that Amazon Cognito won't
	// do the following:
	//
	//    * Store the ClientMetadata value. This data is available only to Lambda
	//    triggers that are assigned to a user pool to support custom workflows.
	//    If your user pool configuration doesn't include triggers, the ClientMetadata
	//    parameter serves no purpose.
	//
	//    * Validate the ClientMetadata value.
	//
	//    * Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide
	//    sensitive information.
	ClientMetadata map[string]*string `type:"map"`

	// Specify "EMAIL" if email will be used to send the welcome message. Specify
	// "SMS" if the phone number will be used. The default value is "SMS". You can
	// specify more than one value.
	DesiredDeliveryMediums []*string `type:"list" enum:"DeliveryMediumType"`

	// This parameter is used only if the phone_number_verified or email_verified
	// attribute is set to True. Otherwise, it is ignored.
	//
	// If this parameter is set to True and the phone number or email address specified
	// in the UserAttributes parameter already exists as an alias with a different
	// user, the API call will migrate the alias from the previous user to the newly
	// created user. The previous user will no longer be able to log in using that
	// alias.
	//
	// If this parameter is set to False, the API throws an AliasExistsException
	// error if the alias already exists. The default value is False.
	ForceAliasCreation *bool `type:"boolean"`

	// Set to RESEND to resend the invitation message to a user that already exists
	// and reset the expiration limit on the user's account. Set to SUPPRESS to
	// suppress sending the message. You can specify only one value.
	MessageAction *string `type:"string" enum:"MessageActionType"`

	// The user's temporary password. This password must conform to the password
	// policy that you specified when you created the user pool.
	//
	// The temporary password is valid only once. To complete the Admin Create User
	// flow, the user must enter the temporary password in the sign-in page, along
	// with a new password to be used in all future sign-ins.
	//
	// This parameter isn't required. If you don't specify a value, Amazon Cognito
	// generates one for you.
	//
	// The temporary password can only be used until the user account expiration
	// limit that you specified when you created the user pool. To reset the account
	// after that time limit, you must call AdminCreateUser again, specifying "RESEND"
	// for the MessageAction parameter.
	//
	// TemporaryPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminCreateUserInput's
	// String and GoString methods.
	TemporaryPassword *string `type:"string" sensitive:"true"`

	// An array of name-value pairs that contain user attributes and attribute values
	// to be set for the user to be created. You can create a user without specifying
	// any attributes other than Username. However, any attributes that you specify
	// as required (when creating a user pool or in the Attributes tab of the console)
	// either you should supply (in your call to AdminCreateUser) or the user should
	// supply (when they sign up in response to your welcome message).
	//
	// For custom attributes, you must prepend the custom: prefix to the attribute
	// name.
	//
	// To send a message inviting the user to sign up, you must specify the user's
	// email address or phone number. You can do this in your call to AdminCreateUser
	// or in the Users tab of the Amazon Cognito console for managing your user
	// pools.
	//
	// In your call to AdminCreateUser, you can set the email_verified attribute
	// to True, and you can set the phone_number_verified attribute to True. You
	// can also do this by calling AdminUpdateUserAttributes (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html).
	//
	//    * email: The email address of the user to whom the message that contains
	//    the code and username will be sent. Required if the email_verified attribute
	//    is set to True, or if "EMAIL" is specified in the DesiredDeliveryMediums
	//    parameter.
	//
	//    * phone_number: The phone number of the user to whom the message that
	//    contains the code and username will be sent. Required if the phone_number_verified
	//    attribute is set to True, or if "SMS" is specified in the DesiredDeliveryMediums
	//    parameter.
	UserAttributes []*AttributeType `type:"list"`

	// The user pool ID for the user pool where the user will be created.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The username for the user. Must be unique within the user pool. Must be a
	// UTF-8 string between 1 and 128 characters. After the user is created, the
	// username can't be changed.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminCreateUserInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The user's validation data. This is an array of name-value pairs that contain
	// user attributes and attribute values that you can use for custom validation,
	// such as restricting the types of user accounts that can be registered. For
	// example, you might choose to allow or disallow user sign-up based on the
	// user's domain.
	//
	// To configure custom validation, you must create a Pre Sign-up Lambda trigger
	// for the user pool as described in the Amazon Cognito Developer Guide. The
	// Lambda trigger receives the validation data and uses it in the validation
	// process.
	//
	// The user's validation data isn't persisted.
	ValidationData []*AttributeType `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminCreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminCreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminCreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminCreateUserInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.UserAttributes != nil {
		for i, v := range s.UserAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ValidationData != nil {
		for i, v := range s.ValidationData {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ValidationData", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientMetadata sets the ClientMetadata field's value.
func (s *AdminCreateUserInput) SetClientMetadata(v map[string]*string) *AdminCreateUserInput {
	s.ClientMetadata = v
	return s
}

// SetDesiredDeliveryMediums sets the DesiredDeliveryMediums field's value.
func (s *AdminCreateUserInput) SetDesiredDeliveryMediums(v []*string) *AdminCreateUserInput {
	s.DesiredDeliveryMediums = v
	return s
}

// SetForceAliasCreation sets the ForceAliasCreation field's value.
func (s *AdminCreateUserInput) SetForceAliasCreation(v bool) *AdminCreateUserInput {
	s.ForceAliasCreation = &v
	return s
}

// SetMessageAction sets the MessageAction field's value.
func (s *AdminCreateUserInput) SetMessageAction(v string) *AdminCreateUserInput {
	s.MessageAction = &v
	return s
}

// SetTemporaryPassword sets the TemporaryPassword field's value.
func (s *AdminCreateUserInput) SetTemporaryPassword(v string) *AdminCreateUserInput {
	s.TemporaryPassword = &v
	return s
}

// SetUserAttributes sets the UserAttributes field's value.
func (s *AdminCreateUserInput) SetUserAttributes(v []*AttributeType) *AdminCreateUserInput {
	s.UserAttributes = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminCreateUserInput) SetUserPoolId(v string) *AdminCreateUserInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminCreateUserInput) SetUsername(v string) *AdminCreateUserInput {
	s.Username = &v
	return s
}

// SetValidationData sets the ValidationData field's value.
func (s *AdminCreateUserInput) SetValidationData(v []*AttributeType) *AdminCreateUserInput {
	s.ValidationData = v
	return s
}

// Represents the response from the server to the request to create the user.
type AdminCreateUserOutput struct {
	_ struct{} `type:"structure"`

	// The newly created user.
	User *UserType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminCreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminCreateUserOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *AdminCreateUserOutput) SetUser(v *UserType) *AdminCreateUserOutput {
	s.User = v
	return s
}

// Represents the request to delete user attributes as an administrator.
type AdminDeleteUserAttributesInput struct {
	_ struct{} `type:"structure"`

	// An array of strings representing the user attribute names you want to delete.
	//
	// For custom attributes, you must prepend the custom: prefix to the attribute
	// name.
	//
	// UserAttributeNames is a required field
	UserAttributeNames []*string `type:"list" required:"true"`

	// The user pool ID for the user pool where you want to delete user attributes.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user from which you would like to delete attributes.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminDeleteUserAttributesInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminDeleteUserAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminDeleteUserAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminDeleteUserAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminDeleteUserAttributesInput"}
	if s.UserAttributeNames == nil {
		invalidParams.Add(request.NewErrParamRequired("UserAttributeNames"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserAttributeNames sets the UserAttributeNames field's value.
func (s *AdminDeleteUserAttributesInput) SetUserAttributeNames(v []*string) *AdminDeleteUserAttributesInput {
	s.UserAttributeNames = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminDeleteUserAttributesInput) SetUserPoolId(v string) *AdminDeleteUserAttributesInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminDeleteUserAttributesInput) SetUsername(v string) *AdminDeleteUserAttributesInput {
	s.Username = &v
	return s
}

// Represents the response received from the server for a request to delete
// user attributes.
type AdminDeleteUserAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminDeleteUserAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminDeleteUserAttributesOutput) GoString() string {
	return s.String()
}

// Represents the request to delete a user as an administrator.
type AdminDeleteUserInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool where you want to delete the user.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user you want to delete.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminDeleteUserInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminDeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminDeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminDeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminDeleteUserInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminDeleteUserInput) SetUserPoolId(v string) *AdminDeleteUserInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminDeleteUserInput) SetUsername(v string) *AdminDeleteUserInput {
	s.Username = &v
	return s
}

type AdminDeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminDeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminDeleteUserOutput) GoString() string {
	return s.String()
}

type AdminDisableProviderForUserInput struct {
	_ struct{} `type:"structure"`

	// The user to be disabled.
	//
	// User is a required field
	User *ProviderUserIdentifierType `type:"structure" required:"true"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminDisableProviderForUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminDisableProviderForUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminDisableProviderForUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminDisableProviderForUserInput"}
	if s.User == nil {
		invalidParams.Add(request.NewErrParamRequired("User"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.User != nil {
		if err := s.User.Validate(); err != nil {
			invalidParams.AddNested("User", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUser sets the User field's value.
func (s *AdminDisableProviderForUserInput) SetUser(v *ProviderUserIdentifierType) *AdminDisableProviderForUserInput {
	s.User = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminDisableProviderForUserInput) SetUserPoolId(v string) *AdminDisableProviderForUserInput {
	s.UserPoolId = &v
	return s
}

type AdminDisableProviderForUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminDisableProviderForUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminDisableProviderForUserOutput) GoString() string {
	return s.String()
}

// Represents the request to disable the user as an administrator.
type AdminDisableUserInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool where you want to disable the user.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user you want to disable.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminDisableUserInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminDisableUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminDisableUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminDisableUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminDisableUserInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminDisableUserInput) SetUserPoolId(v string) *AdminDisableUserInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminDisableUserInput) SetUsername(v string) *AdminDisableUserInput {
	s.Username = &v
	return s
}

// Represents the response received from the server to disable the user as an
// administrator.
type AdminDisableUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminDisableUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminDisableUserOutput) GoString() string {
	return s.String()
}

// Represents the request that enables the user as an administrator.
type AdminEnableUserInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool where you want to enable the user.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user you want to enable.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminEnableUserInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminEnableUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminEnableUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminEnableUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminEnableUserInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminEnableUserInput) SetUserPoolId(v string) *AdminEnableUserInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminEnableUserInput) SetUsername(v string) *AdminEnableUserInput {
	s.Username = &v
	return s
}

// Represents the response from the server for the request to enable a user
// as an administrator.
type AdminEnableUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminEnableUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminEnableUserOutput) GoString() string {
	return s.String()
}

// Sends the forgot device request, as an administrator.
type AdminForgetDeviceInput struct {
	_ struct{} `type:"structure"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminForgetDeviceInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminForgetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminForgetDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminForgetDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminForgetDeviceInput"}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceKey sets the DeviceKey field's value.
func (s *AdminForgetDeviceInput) SetDeviceKey(v string) *AdminForgetDeviceInput {
	s.DeviceKey = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminForgetDeviceInput) SetUserPoolId(v string) *AdminForgetDeviceInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminForgetDeviceInput) SetUsername(v string) *AdminForgetDeviceInput {
	s.Username = &v
	return s
}

type AdminForgetDeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminForgetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminForgetDeviceOutput) GoString() string {
	return s.String()
}

// Represents the request to get the device, as an administrator.
type AdminGetDeviceInput struct {
	_ struct{} `type:"structure"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminGetDeviceInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminGetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminGetDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminGetDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminGetDeviceInput"}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceKey sets the DeviceKey field's value.
func (s *AdminGetDeviceInput) SetDeviceKey(v string) *AdminGetDeviceInput {
	s.DeviceKey = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminGetDeviceInput) SetUserPoolId(v string) *AdminGetDeviceInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminGetDeviceInput) SetUsername(v string) *AdminGetDeviceInput {
	s.Username = &v
	return s
}

// Gets the device response, as an administrator.
type AdminGetDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The device.
	//
	// Device is a required field
	Device *DeviceType `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminGetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminGetDeviceOutput) GoString() string {
	return s.String()
}

// SetDevice sets the Device field's value.
func (s *AdminGetDeviceOutput) SetDevice(v *DeviceType) *AdminGetDeviceOutput {
	s.Device = v
	return s
}

// Represents the request to get the specified user as an administrator.
type AdminGetUserInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool where you want to get information about
	// the user.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user you want to retrieve.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminGetUserInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminGetUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminGetUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminGetUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminGetUserInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminGetUserInput) SetUserPoolId(v string) *AdminGetUserInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminGetUserInput) SetUsername(v string) *AdminGetUserInput {
	s.Username = &v
	return s
}

// Represents the response from the server from the request to get the specified
// user as an administrator.
type AdminGetUserOutput struct {
	_ struct{} `type:"structure"`

	// Indicates that the status is enabled.
	Enabled *bool `type:"boolean"`

	// This response parameter is no longer supported. It provides information only
	// about SMS MFA configurations. It doesn't provide information about time-based
	// one-time password (TOTP) software token MFA configurations. To look up information
	// about either type of MFA configuration, use UserMFASettingList instead.
	MFAOptions []*MFAOptionType `type:"list"`

	// The user's preferred MFA setting.
	PreferredMfaSetting *string `type:"string"`

	// An array of name-value pairs representing user attributes.
	UserAttributes []*AttributeType `type:"list"`

	// The date the user was created.
	UserCreateDate *time.Time `type:"timestamp"`

	// The date the user was last modified.
	UserLastModifiedDate *time.Time `type:"timestamp"`

	// The MFA options that are activated for the user. The possible values in this
	// list are SMS_MFA and SOFTWARE_TOKEN_MFA.
	UserMFASettingList []*string `type:"list"`

	// The user status. Can be one of the following:
	//
	//    * UNCONFIRMED - User has been created but not confirmed.
	//
	//    * CONFIRMED - User has been confirmed.
	//
	//    * ARCHIVED - User is no longer active.
	//
	//    * UNKNOWN - User status isn't known.
	//
	//    * RESET_REQUIRED - User is confirmed, but the user must request a code
	//    and reset their password before they can sign in.
	//
	//    * FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign
	//    in using a temporary password, but on first sign-in, the user must change
	//    their password to a new value before doing anything else.
	UserStatus *string `type:"string" enum:"UserStatusType"`

	// The user name of the user about whom you're receiving information.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminGetUserOutput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminGetUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminGetUserOutput) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AdminGetUserOutput) SetEnabled(v bool) *AdminGetUserOutput {
	s.Enabled = &v
	return s
}

// SetMFAOptions sets the MFAOptions field's value.
func (s *AdminGetUserOutput) SetMFAOptions(v []*MFAOptionType) *AdminGetUserOutput {
	s.MFAOptions = v
	return s
}

// SetPreferredMfaSetting sets the PreferredMfaSetting field's value.
func (s *AdminGetUserOutput) SetPreferredMfaSetting(v string) *AdminGetUserOutput {
	s.PreferredMfaSetting = &v
	return s
}

// SetUserAttributes sets the UserAttributes field's value.
func (s *AdminGetUserOutput) SetUserAttributes(v []*AttributeType) *AdminGetUserOutput {
	s.UserAttributes = v
	return s
}

// SetUserCreateDate sets the UserCreateDate field's value.
func (s *AdminGetUserOutput) SetUserCreateDate(v time.Time) *AdminGetUserOutput {
	s.UserCreateDate = &v
	return s
}

// SetUserLastModifiedDate sets the UserLastModifiedDate field's value.
func (s *AdminGetUserOutput) SetUserLastModifiedDate(v time.Time) *AdminGetUserOutput {
	s.UserLastModifiedDate = &v
	return s
}

// SetUserMFASettingList sets the UserMFASettingList field's value.
func (s *AdminGetUserOutput) SetUserMFASettingList(v []*string) *AdminGetUserOutput {
	s.UserMFASettingList = v
	return s
}

// SetUserStatus sets the UserStatus field's value.
func (s *AdminGetUserOutput) SetUserStatus(v string) *AdminGetUserOutput {
	s.UserStatus = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminGetUserOutput) SetUsername(v string) *AdminGetUserOutput {
	s.Username = &v
	return s
}

// Initiates the authorization request, as an administrator.
type AdminInitiateAuthInput struct {
	_ struct{} `type:"structure"`

	// The analytics metadata for collecting Amazon Pinpoint metrics for AdminInitiateAuth
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The authentication flow for this call to run. The API action will depend
	// on this value. For example:
	//
	//    * REFRESH_TOKEN_AUTH will take in a valid refresh token and return new
	//    tokens.
	//
	//    * USER_SRP_AUTH will take in USERNAME and SRP_A and return the Secure
	//    Remote Password (SRP) protocol variables to be used for next challenge
	//    execution.
	//
	//    * ADMIN_USER_PASSWORD_AUTH will take in USERNAME and PASSWORD and return
	//    the next challenge or tokens.
	//
	// Valid values include:
	//
	//    * USER_SRP_AUTH: Authentication flow for the Secure Remote Password (SRP)
	//    protocol.
	//
	//    * REFRESH_TOKEN_AUTH/REFRESH_TOKEN: Authentication flow for refreshing
	//    the access token and ID token by supplying a valid refresh token.
	//
	//    * CUSTOM_AUTH: Custom authentication flow.
	//
	//    * ADMIN_NO_SRP_AUTH: Non-SRP authentication flow; you can pass in the
	//    USERNAME and PASSWORD directly if the flow is enabled for calling the
	//    app client.
	//
	//    * ADMIN_USER_PASSWORD_AUTH: Admin-based user password authentication.
	//    This replaces the ADMIN_NO_SRP_AUTH authentication flow. In this flow,
	//    Amazon Cognito receives the password in the request instead of using the
	//    SRP process to verify passwords.
	//
	// AuthFlow is a required field
	AuthFlow *string `type:"string" required:"true" enum:"AuthFlowType"`

	// The authentication parameters. These are inputs corresponding to the AuthFlow
	// that you're invoking. The required values depend on the value of AuthFlow:
	//
	//    * For USER_SRP_AUTH: USERNAME (required), SRP_A (required), SECRET_HASH
	//    (required if the app client is configured with a client secret), DEVICE_KEY.
	//
	//    * For REFRESH_TOKEN_AUTH/REFRESH_TOKEN: REFRESH_TOKEN (required), SECRET_HASH
	//    (required if the app client is configured with a client secret), DEVICE_KEY.
	//
	//    * For ADMIN_NO_SRP_AUTH: USERNAME (required), SECRET_HASH (if app client
	//    is configured with client secret), PASSWORD (required), DEVICE_KEY.
	//
	//    * For CUSTOM_AUTH: USERNAME (required), SECRET_HASH (if app client is
	//    configured with client secret), DEVICE_KEY. To start the authentication
	//    flow with password verification, include ChallengeName: SRP_A and SRP_A:
	//    (The SRP_A Value).
	//
	// AuthParameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminInitiateAuthInput's
	// String and GoString methods.
	AuthParameters map[string]*string `type:"map" sensitive:"true"`

	// The app client ID.
	//
	// ClientId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminInitiateAuthInput's
	// String and GoString methods.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// A map of custom key-value pairs that you can provide as input for certain
	// custom workflows that this action triggers.
	//
	// You create custom workflows by assigning Lambda functions to user pool triggers.
	// When you use the AdminInitiateAuth API action, Amazon Cognito invokes the
	// Lambda functions that are specified for various triggers. The ClientMetadata
	// value is passed as input to the functions for only the following triggers:
	//
	//    * Pre signup
	//
	//    * Pre authentication
	//
	//    * User migration
	//
	// When Amazon Cognito invokes the functions for these triggers, it passes a
	// JSON payload, which the function receives as input. This payload contains
	// a validationData attribute, which provides the data that you assigned to
	// the ClientMetadata parameter in your AdminInitiateAuth request. In your function
	// code in Lambda, you can process the validationData value to enhance your
	// workflow for your specific needs.
	//
	// When you use the AdminInitiateAuth API action, Amazon Cognito also invokes
	// the functions for the following triggers, but it doesn't provide the ClientMetadata
	// value as input:
	//
	//    * Post authentication
	//
	//    * Custom message
	//
	//    * Pre token generation
	//
	//    * Create auth challenge
	//
	//    * Define auth challenge
	//
	//    * Verify auth challenge
	//
	// For more information, see Customizing user pool Workflows with Lambda Triggers
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
	// in the Amazon Cognito Developer Guide.
	//
	// When you use the ClientMetadata parameter, remember that Amazon Cognito won't
	// do the following:
	//
	//    * Store the ClientMetadata value. This data is available only to Lambda
	//    triggers that are assigned to a user pool to support custom workflows.
	//    If your user pool configuration doesn't include triggers, the ClientMetadata
	//    parameter serves no purpose.
	//
	//    * Validate the ClientMetadata value.
	//
	//    * Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide
	//    sensitive information.
	ClientMetadata map[string]*string `type:"map"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	ContextData *ContextDataType `type:"structure"`

	// The ID of the Amazon Cognito user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminInitiateAuthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminInitiateAuthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminInitiateAuthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminInitiateAuthInput"}
	if s.AuthFlow == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthFlow"))
	}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.ContextData != nil {
		if err := s.ContextData.Validate(); err != nil {
			invalidParams.AddNested("ContextData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyticsMetadata sets the AnalyticsMetadata field's value.
func (s *AdminInitiateAuthInput) SetAnalyticsMetadata(v *AnalyticsMetadataType) *AdminInitiateAuthInput {
	s.AnalyticsMetadata = v
	return s
}

// SetAuthFlow sets the AuthFlow field's value.
func (s *AdminInitiateAuthInput) SetAuthFlow(v string) *AdminInitiateAuthInput {
	s.AuthFlow = &v
	return s
}

// SetAuthParameters sets the AuthParameters field's value.
func (s *AdminInitiateAuthInput) SetAuthParameters(v map[string]*string) *AdminInitiateAuthInput {
	s.AuthParameters = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *AdminInitiateAuthInput) SetClientId(v string) *AdminInitiateAuthInput {
	s.ClientId = &v
	return s
}

// SetClientMetadata sets the ClientMetadata field's value.
func (s *AdminInitiateAuthInput) SetClientMetadata(v map[string]*string) *AdminInitiateAuthInput {
	s.ClientMetadata = v
	return s
}

// SetContextData sets the ContextData field's value.
func (s *AdminInitiateAuthInput) SetContextData(v *ContextDataType) *AdminInitiateAuthInput {
	s.ContextData = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminInitiateAuthInput) SetUserPoolId(v string) *AdminInitiateAuthInput {
	s.UserPoolId = &v
	return s
}

// Initiates the authentication response, as an administrator.
type AdminInitiateAuthOutput struct {
	_ struct{} `type:"structure"`

	// The result of the authentication response. This is only returned if the caller
	// doesn't need to pass another challenge. If the caller does need to pass another
	// challenge before it gets tokens, ChallengeName, ChallengeParameters, and
	// Session are returned.
	AuthenticationResult *AuthenticationResultType `type:"structure"`

	// The name of the challenge that you're responding to with this call. This
	// is returned in the AdminInitiateAuth response if you must pass another challenge.
	//
	//    * MFA_SETUP: If MFA is required, users who don't have at least one of
	//    the MFA methods set up are presented with an MFA_SETUP challenge. The
	//    user must set up at least one MFA type to continue to authenticate.
	//
	//    * SELECT_MFA_TYPE: Selects the MFA type. Valid MFA options are SMS_MFA
	//    for text SMS MFA, and SOFTWARE_TOKEN_MFA for time-based one-time password
	//    (TOTP) software token MFA.
	//
	//    * SMS_MFA: Next challenge is to supply an SMS_MFA_CODE, delivered via
	//    SMS.
	//
	//    * PASSWORD_VERIFIER: Next challenge is to supply PASSWORD_CLAIM_SIGNATURE,
	//    PASSWORD_CLAIM_SECRET_BLOCK, and TIMESTAMP after the client-side SRP calculations.
	//
	//    * CUSTOM_CHALLENGE: This is returned if your custom authentication flow
	//    determines that the user should pass another challenge before tokens are
	//    issued.
	//
	//    * DEVICE_SRP_AUTH: If device tracking was activated in your user pool
	//    and the previous challenges were passed, this challenge is returned so
	//    that Amazon Cognito can start tracking this device.
	//
	//    * DEVICE_PASSWORD_VERIFIER: Similar to PASSWORD_VERIFIER, but for devices
	//    only.
	//
	//    * ADMIN_NO_SRP_AUTH: This is returned if you must authenticate with USERNAME
	//    and PASSWORD directly. An app client must be enabled to use this flow.
	//
	//    * NEW_PASSWORD_REQUIRED: For users who are required to change their passwords
	//    after successful first login. This challenge should be passed with NEW_PASSWORD
	//    and any other required attributes.
	//
	//    * MFA_SETUP: For users who are required to set up an MFA factor before
	//    they can sign in. The MFA types activated for the user pool will be listed
	//    in the challenge parameters MFA_CAN_SETUP value. To set up software token
	//    MFA, use the session returned here from InitiateAuth as an input to AssociateSoftwareToken,
	//    and use the session returned by VerifySoftwareToken as an input to RespondToAuthChallenge
	//    with challenge name MFA_SETUP to complete sign-in. To set up SMS MFA,
	//    users will need help from an administrator to add a phone number to their
	//    account and then call InitiateAuth again to restart sign-in.
	ChallengeName *string `type:"string" enum:"ChallengeNameType"`

	// The challenge parameters. These are returned to you in the AdminInitiateAuth
	// response if you must pass another challenge. The responses in this parameter
	// should be used to compute inputs to the next call (AdminRespondToAuthChallenge).
	//
	// All challenges require USERNAME and SECRET_HASH (if applicable).
	//
	// The value of the USER_ID_FOR_SRP attribute is the user's actual username,
	// not an alias (such as email address or phone number), even if you specified
	// an alias in your call to AdminInitiateAuth. This happens because, in the
	// AdminRespondToAuthChallenge API ChallengeResponses, the USERNAME attribute
	// can't be an alias.
	ChallengeParameters map[string]*string `type:"map"`

	// The session that should be passed both ways in challenge-response calls to
	// the service. If AdminInitiateAuth or AdminRespondToAuthChallenge API call
	// determines that the caller must pass another challenge, they return a session
	// with other challenge parameters. This session should be passed as it is to
	// the next AdminRespondToAuthChallenge API call.
	Session *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminInitiateAuthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminInitiateAuthOutput) GoString() string {
	return s.String()
}

// SetAuthenticationResult sets the AuthenticationResult field's value.
func (s *AdminInitiateAuthOutput) SetAuthenticationResult(v *AuthenticationResultType) *AdminInitiateAuthOutput {
	s.AuthenticationResult = v
	return s
}

// SetChallengeName sets the ChallengeName field's value.
func (s *AdminInitiateAuthOutput) SetChallengeName(v string) *AdminInitiateAuthOutput {
	s.ChallengeName = &v
	return s
}

// SetChallengeParameters sets the ChallengeParameters field's value.
func (s *AdminInitiateAuthOutput) SetChallengeParameters(v map[string]*string) *AdminInitiateAuthOutput {
	s.ChallengeParameters = v
	return s
}

// SetSession sets the Session field's value.
func (s *AdminInitiateAuthOutput) SetSession(v string) *AdminInitiateAuthOutput {
	s.Session = &v
	return s
}

type AdminLinkProviderForUserInput struct {
	_ struct{} `type:"structure"`

	// The existing user in the user pool that you want to assign to the external
	// identity provider user account. This user can be a native (Username + Password)
	// Amazon Cognito user pools user or a federated user (for example, a SAML or
	// Facebook user). If the user doesn't exist, Amazon Cognito generates an exception.
	// Amazon Cognito returns this user when the new user (with the linked identity
	// provider attribute) signs in.
	//
	// For a native username + password user, the ProviderAttributeValue for the
	// DestinationUser should be the username in the user pool. For a federated
	// user, it should be the provider-specific user_id.
	//
	// The ProviderAttributeName of the DestinationUser is ignored.
	//
	// The ProviderName should be set to Cognito for users in Cognito user pools.
	//
	// All attributes in the DestinationUser profile must be mutable. If you have
	// assigned the user any immutable custom attributes, the operation won't succeed.
	//
	// DestinationUser is a required field
	DestinationUser *ProviderUserIdentifierType `type:"structure" required:"true"`

	// An external identity provider account for a user who doesn't exist yet in
	// the user pool. This user must be a federated user (for example, a SAML or
	// Facebook user), not another native user.
	//
	// If the SourceUser is using a federated social identity provider, such as
	// Facebook, Google, or Login with Amazon, you must set the ProviderAttributeName
	// to Cognito_Subject. For social identity providers, the ProviderName will
	// be Facebook, Google, or LoginWithAmazon, and Amazon Cognito will automatically
	// parse the Facebook, Google, and Login with Amazon tokens for id, sub, and
	// user_id, respectively. The ProviderAttributeValue for the user must be the
	// same value as the id, sub, or user_id value found in the social identity
	// provider token.
	//
	// For SAML, the ProviderAttributeName can be any value that matches a claim
	// in the SAML assertion. If you want to link SAML users based on the subject
	// of the SAML assertion, you should map the subject to a claim through the
	// SAML identity provider and submit that claim name as the ProviderAttributeName.
	// If you set ProviderAttributeName to Cognito_Subject, Amazon Cognito will
	// automatically parse the default unique identifier found in the subject from
	// the SAML token.
	//
	// SourceUser is a required field
	SourceUser *ProviderUserIdentifierType `type:"structure" required:"true"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminLinkProviderForUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminLinkProviderForUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminLinkProviderForUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminLinkProviderForUserInput"}
	if s.DestinationUser == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationUser"))
	}
	if s.SourceUser == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceUser"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.DestinationUser != nil {
		if err := s.DestinationUser.Validate(); err != nil {
			invalidParams.AddNested("DestinationUser", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceUser != nil {
		if err := s.SourceUser.Validate(); err != nil {
			invalidParams.AddNested("SourceUser", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationUser sets the DestinationUser field's value.
func (s *AdminLinkProviderForUserInput) SetDestinationUser(v *ProviderUserIdentifierType) *AdminLinkProviderForUserInput {
	s.DestinationUser = v
	return s
}

// SetSourceUser sets the SourceUser field's value.
func (s *AdminLinkProviderForUserInput) SetSourceUser(v *ProviderUserIdentifierType) *AdminLinkProviderForUserInput {
	s.SourceUser = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminLinkProviderForUserInput) SetUserPoolId(v string) *AdminLinkProviderForUserInput {
	s.UserPoolId = &v
	return s
}

type AdminLinkProviderForUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminLinkProviderForUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminLinkProviderForUserOutput) GoString() string {
	return s.String()
}

// Represents the request to list devices, as an administrator.
type AdminListDevicesInput struct {
	_ struct{} `type:"structure"`

	// The limit of the devices request.
	Limit *int64 `type:"integer"`

	// The pagination token.
	PaginationToken *string `min:"1" type:"string"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminListDevicesInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminListDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminListDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminListDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminListDevicesInput"}
	if s.PaginationToken != nil && len(*s.PaginationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PaginationToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *AdminListDevicesInput) SetLimit(v int64) *AdminListDevicesInput {
	s.Limit = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *AdminListDevicesInput) SetPaginationToken(v string) *AdminListDevicesInput {
	s.PaginationToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminListDevicesInput) SetUserPoolId(v string) *AdminListDevicesInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminListDevicesInput) SetUsername(v string) *AdminListDevicesInput {
	s.Username = &v
	return s
}

// Lists the device's response, as an administrator.
type AdminListDevicesOutput struct {
	_ struct{} `type:"structure"`

	// The devices in the list of devices response.
	Devices []*DeviceType `type:"list"`

	// The pagination token.
	PaginationToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminListDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminListDevicesOutput) GoString() string {
	return s.String()
}

// SetDevices sets the Devices field's value.
func (s *AdminListDevicesOutput) SetDevices(v []*DeviceType) *AdminListDevicesOutput {
	s.Devices = v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *AdminListDevicesOutput) SetPaginationToken(v string) *AdminListDevicesOutput {
	s.PaginationToken = &v
	return s
}

type AdminListGroupsForUserInput struct {
	_ struct{} `type:"structure"`

	// The limit of the request to list groups.
	Limit *int64 `type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The username for the user.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminListGroupsForUserInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminListGroupsForUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminListGroupsForUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminListGroupsForUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminListGroupsForUserInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *AdminListGroupsForUserInput) SetLimit(v int64) *AdminListGroupsForUserInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *AdminListGroupsForUserInput) SetNextToken(v string) *AdminListGroupsForUserInput {
	s.NextToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminListGroupsForUserInput) SetUserPoolId(v string) *AdminListGroupsForUserInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminListGroupsForUserInput) SetUsername(v string) *AdminListGroupsForUserInput {
	s.Username = &v
	return s
}

type AdminListGroupsForUserOutput struct {
	_ struct{} `type:"structure"`

	// The groups that the user belongs to.
	Groups []*GroupType `type:"list"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminListGroupsForUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminListGroupsForUserOutput) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *AdminListGroupsForUserOutput) SetGroups(v []*GroupType) *AdminListGroupsForUserOutput {
	s.Groups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *AdminListGroupsForUserOutput) SetNextToken(v string) *AdminListGroupsForUserOutput {
	s.NextToken = &v
	return s
}

type AdminListUserAuthEventsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of authentication events to return.
	MaxResults *int64 `type:"integer"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user pool username or an alias.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminListUserAuthEventsInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminListUserAuthEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminListUserAuthEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminListUserAuthEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminListUserAuthEventsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *AdminListUserAuthEventsInput) SetMaxResults(v int64) *AdminListUserAuthEventsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *AdminListUserAuthEventsInput) SetNextToken(v string) *AdminListUserAuthEventsInput {
	s.NextToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminListUserAuthEventsInput) SetUserPoolId(v string) *AdminListUserAuthEventsInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminListUserAuthEventsInput) SetUsername(v string) *AdminListUserAuthEventsInput {
	s.Username = &v
	return s
}

type AdminListUserAuthEventsOutput struct {
	_ struct{} `type:"structure"`

	// The response object. It includes the EventID, EventType, CreationDate, EventRisk,
	// and EventResponse.
	AuthEvents []*AuthEventType `type:"list"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminListUserAuthEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminListUserAuthEventsOutput) GoString() string {
	return s.String()
}

// SetAuthEvents sets the AuthEvents field's value.
func (s *AdminListUserAuthEventsOutput) SetAuthEvents(v []*AuthEventType) *AdminListUserAuthEventsOutput {
	s.AuthEvents = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *AdminListUserAuthEventsOutput) SetNextToken(v string) *AdminListUserAuthEventsOutput {
	s.NextToken = &v
	return s
}

type AdminRemoveUserFromGroupInput struct {
	_ struct{} `type:"structure"`

	// The group name.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The username for the user.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminRemoveUserFromGroupInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminRemoveUserFromGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminRemoveUserFromGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminRemoveUserFromGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminRemoveUserFromGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *AdminRemoveUserFromGroupInput) SetGroupName(v string) *AdminRemoveUserFromGroupInput {
	s.GroupName = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminRemoveUserFromGroupInput) SetUserPoolId(v string) *AdminRemoveUserFromGroupInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminRemoveUserFromGroupInput) SetUsername(v string) *AdminRemoveUserFromGroupInput {
	s.Username = &v
	return s
}

type AdminRemoveUserFromGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminRemoveUserFromGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminRemoveUserFromGroupOutput) GoString() string {
	return s.String()
}

// Represents the request to reset a user's password as an administrator.
type AdminResetUserPasswordInput struct {
	_ struct{} `type:"structure"`

	// A map of custom key-value pairs that you can provide as input for any custom
	// workflows that this action triggers.
	//
	// You create custom workflows by assigning Lambda functions to user pool triggers.
	// When you use the AdminResetUserPassword API action, Amazon Cognito invokes
	// the function that is assigned to the custom message trigger. When Amazon
	// Cognito invokes this function, it passes a JSON payload, which the function
	// receives as input. This payload contains a clientMetadata attribute, which
	// provides the data that you assigned to the ClientMetadata parameter in your
	// AdminResetUserPassword request. In your function code in Lambda, you can
	// process the clientMetadata value to enhance your workflow for your specific
	// needs.
	//
	// For more information, see Customizing user pool Workflows with Lambda Triggers
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
	// in the Amazon Cognito Developer Guide.
	//
	// When you use the ClientMetadata parameter, remember that Amazon Cognito won't
	// do the following:
	//
	//    * Store the ClientMetadata value. This data is available only to Lambda
	//    triggers that are assigned to a user pool to support custom workflows.
	//    If your user pool configuration doesn't include triggers, the ClientMetadata
	//    parameter serves no purpose.
	//
	//    * Validate the ClientMetadata value.
	//
	//    * Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide
	//    sensitive information.
	ClientMetadata map[string]*string `type:"map"`

	// The user pool ID for the user pool where you want to reset the user's password.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user whose password you want to reset.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminResetUserPasswordInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminResetUserPasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminResetUserPasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminResetUserPasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminResetUserPasswordInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientMetadata sets the ClientMetadata field's value.
func (s *AdminResetUserPasswordInput) SetClientMetadata(v map[string]*string) *AdminResetUserPasswordInput {
	s.ClientMetadata = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminResetUserPasswordInput) SetUserPoolId(v string) *AdminResetUserPasswordInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminResetUserPasswordInput) SetUsername(v string) *AdminResetUserPasswordInput {
	s.Username = &v
	return s
}

// Represents the response from the server to reset a user password as an administrator.
type AdminResetUserPasswordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminResetUserPasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminResetUserPasswordOutput) GoString() string {
	return s.String()
}

// The request to respond to the authentication challenge, as an administrator.
type AdminRespondToAuthChallengeInput struct {
	_ struct{} `type:"structure"`

	// The analytics metadata for collecting Amazon Pinpoint metrics for AdminRespondToAuthChallenge
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The challenge name. For more information, see AdminInitiateAuth (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html).
	//
	// ChallengeName is a required field
	ChallengeName *string `type:"string" required:"true" enum:"ChallengeNameType"`

	// The challenge responses. These are inputs corresponding to the value of ChallengeName,
	// for example:
	//
	//    * SMS_MFA: SMS_MFA_CODE, USERNAME, SECRET_HASH (if app client is configured
	//    with client secret).
	//
	//    * PASSWORD_VERIFIER: PASSWORD_CLAIM_SIGNATURE, PASSWORD_CLAIM_SECRET_BLOCK,
	//    TIMESTAMP, USERNAME, SECRET_HASH (if app client is configured with client
	//    secret). PASSWORD_VERIFIER requires DEVICE_KEY when signing in with a
	//    remembered device.
	//
	//    * ADMIN_NO_SRP_AUTH: PASSWORD, USERNAME, SECRET_HASH (if app client is
	//    configured with client secret).
	//
	//    * NEW_PASSWORD_REQUIRED: NEW_PASSWORD, any other required attributes,
	//    USERNAME, SECRET_HASH (if app client is configured with client secret).
	//
	//    * MFA_SETUP requires USERNAME, plus you must use the session value returned
	//    by VerifySoftwareToken in the Session parameter.
	//
	// The value of the USERNAME attribute must be the user's actual username, not
	// an alias (such as an email address or phone number). To make this simpler,
	// the AdminInitiateAuth response includes the actual username value in the
	// USERNAMEUSER_ID_FOR_SRP attribute. This happens even if you specified an
	// alias in your call to AdminInitiateAuth.
	ChallengeResponses map[string]*string `type:"map"`

	// The app client ID.
	//
	// ClientId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminRespondToAuthChallengeInput's
	// String and GoString methods.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// A map of custom key-value pairs that you can provide as input for any custom
	// workflows that this action triggers.
	//
	// You create custom workflows by assigning Lambda functions to user pool triggers.
	// When you use the AdminRespondToAuthChallenge API action, Amazon Cognito invokes
	// any functions that you have assigned to the following triggers:
	//
	//    * pre sign-up
	//
	//    * custom message
	//
	//    * post authentication
	//
	//    * user migration
	//
	//    * pre token generation
	//
	//    * define auth challenge
	//
	//    * create auth challenge
	//
	//    * verify auth challenge response
	//
	// When Amazon Cognito invokes any of these functions, it passes a JSON payload,
	// which the function receives as input. This payload contains a clientMetadata
	// attribute that provides the data that you assigned to the ClientMetadata
	// parameter in your AdminRespondToAuthChallenge request. In your function code
	// in Lambda, you can process the clientMetadata value to enhance your workflow
	// for your specific needs.
	//
	// For more information, see Customizing user pool Workflows with Lambda Triggers
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
	// in the Amazon Cognito Developer Guide.
	//
	// When you use the ClientMetadata parameter, remember that Amazon Cognito won't
	// do the following:
	//
	//    * Store the ClientMetadata value. This data is available only to Lambda
	//    triggers that are assigned to a user pool to support custom workflows.
	//    If your user pool configuration doesn't include triggers, the ClientMetadata
	//    parameter serves no purpose.
	//
	//    * Validate the ClientMetadata value.
	//
	//    * Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide
	//    sensitive information.
	ClientMetadata map[string]*string `type:"map"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	ContextData *ContextDataType `type:"structure"`

	// The session that should be passed both ways in challenge-response calls to
	// the service. If an InitiateAuth or RespondToAuthChallenge API call determines
	// that the caller must pass another challenge, it returns a session with other
	// challenge parameters. This session should be passed as it is to the next
	// RespondToAuthChallenge API call.
	Session *string `min:"20" type:"string"`

	// The ID of the Amazon Cognito user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminRespondToAuthChallengeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminRespondToAuthChallengeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminRespondToAuthChallengeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminRespondToAuthChallengeInput"}
	if s.ChallengeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChallengeName"))
	}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.Session != nil && len(*s.Session) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Session", 20))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.ContextData != nil {
		if err := s.ContextData.Validate(); err != nil {
			invalidParams.AddNested("ContextData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyticsMetadata sets the AnalyticsMetadata field's value.
func (s *AdminRespondToAuthChallengeInput) SetAnalyticsMetadata(v *AnalyticsMetadataType) *AdminRespondToAuthChallengeInput {
	s.AnalyticsMetadata = v
	return s
}

// SetChallengeName sets the ChallengeName field's value.
func (s *AdminRespondToAuthChallengeInput) SetChallengeName(v string) *AdminRespondToAuthChallengeInput {
	s.ChallengeName = &v
	return s
}

// SetChallengeResponses sets the ChallengeResponses field's value.
func (s *AdminRespondToAuthChallengeInput) SetChallengeResponses(v map[string]*string) *AdminRespondToAuthChallengeInput {
	s.ChallengeResponses = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *AdminRespondToAuthChallengeInput) SetClientId(v string) *AdminRespondToAuthChallengeInput {
	s.ClientId = &v
	return s
}

// SetClientMetadata sets the ClientMetadata field's value.
func (s *AdminRespondToAuthChallengeInput) SetClientMetadata(v map[string]*string) *AdminRespondToAuthChallengeInput {
	s.ClientMetadata = v
	return s
}

// SetContextData sets the ContextData field's value.
func (s *AdminRespondToAuthChallengeInput) SetContextData(v *ContextDataType) *AdminRespondToAuthChallengeInput {
	s.ContextData = v
	return s
}

// SetSession sets the Session field's value.
func (s *AdminRespondToAuthChallengeInput) SetSession(v string) *AdminRespondToAuthChallengeInput {
	s.Session = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminRespondToAuthChallengeInput) SetUserPoolId(v string) *AdminRespondToAuthChallengeInput {
	s.UserPoolId = &v
	return s
}

// Responds to the authentication challenge, as an administrator.
type AdminRespondToAuthChallengeOutput struct {
	_ struct{} `type:"structure"`

	// The result returned by the server in response to the authentication request.
	AuthenticationResult *AuthenticationResultType `type:"structure"`

	// The name of the challenge. For more information, see AdminInitiateAuth (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html).
	ChallengeName *string `type:"string" enum:"ChallengeNameType"`

	// The challenge parameters. For more information, see AdminInitiateAuth (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html).
	ChallengeParameters map[string]*string `type:"map"`

	// The session that should be passed both ways in challenge-response calls to
	// the service. If the caller must pass another challenge, they return a session
	// with other challenge parameters. This session should be passed as it is to
	// the next RespondToAuthChallenge API call.
	Session *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminRespondToAuthChallengeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminRespondToAuthChallengeOutput) GoString() string {
	return s.String()
}

// SetAuthenticationResult sets the AuthenticationResult field's value.
func (s *AdminRespondToAuthChallengeOutput) SetAuthenticationResult(v *AuthenticationResultType) *AdminRespondToAuthChallengeOutput {
	s.AuthenticationResult = v
	return s
}

// SetChallengeName sets the ChallengeName field's value.
func (s *AdminRespondToAuthChallengeOutput) SetChallengeName(v string) *AdminRespondToAuthChallengeOutput {
	s.ChallengeName = &v
	return s
}

// SetChallengeParameters sets the ChallengeParameters field's value.
func (s *AdminRespondToAuthChallengeOutput) SetChallengeParameters(v map[string]*string) *AdminRespondToAuthChallengeOutput {
	s.ChallengeParameters = v
	return s
}

// SetSession sets the Session field's value.
func (s *AdminRespondToAuthChallengeOutput) SetSession(v string) *AdminRespondToAuthChallengeOutput {
	s.Session = &v
	return s
}

type AdminSetUserMFAPreferenceInput struct {
	_ struct{} `type:"structure"`

	// The SMS text message MFA settings.
	SMSMfaSettings *SMSMfaSettingsType `type:"structure"`

	// The time-based one-time password software token MFA settings.
	SoftwareTokenMfaSettings *SoftwareTokenMfaSettingsType `type:"structure"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user pool username or alias.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminSetUserMFAPreferenceInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminSetUserMFAPreferenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminSetUserMFAPreferenceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminSetUserMFAPreferenceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminSetUserMFAPreferenceInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSMSMfaSettings sets the SMSMfaSettings field's value.
func (s *AdminSetUserMFAPreferenceInput) SetSMSMfaSettings(v *SMSMfaSettingsType) *AdminSetUserMFAPreferenceInput {
	s.SMSMfaSettings = v
	return s
}

// SetSoftwareTokenMfaSettings sets the SoftwareTokenMfaSettings field's value.
func (s *AdminSetUserMFAPreferenceInput) SetSoftwareTokenMfaSettings(v *SoftwareTokenMfaSettingsType) *AdminSetUserMFAPreferenceInput {
	s.SoftwareTokenMfaSettings = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminSetUserMFAPreferenceInput) SetUserPoolId(v string) *AdminSetUserMFAPreferenceInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminSetUserMFAPreferenceInput) SetUsername(v string) *AdminSetUserMFAPreferenceInput {
	s.Username = &v
	return s
}

type AdminSetUserMFAPreferenceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminSetUserMFAPreferenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminSetUserMFAPreferenceOutput) GoString() string {
	return s.String()
}

type AdminSetUserPasswordInput struct {
	_ struct{} `type:"structure"`

	// The password for the user.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminSetUserPasswordInput's
	// String and GoString methods.
	//
	// Password is a required field
	Password *string `type:"string" required:"true" sensitive:"true"`

	// True if the password is permanent, False if it is temporary.
	Permanent *bool `type:"boolean"`

	// The user pool ID for the user pool where you want to set the user's password.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user whose password you want to set.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminSetUserPasswordInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminSetUserPasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminSetUserPasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminSetUserPasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminSetUserPasswordInput"}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPassword sets the Password field's value.
func (s *AdminSetUserPasswordInput) SetPassword(v string) *AdminSetUserPasswordInput {
	s.Password = &v
	return s
}

// SetPermanent sets the Permanent field's value.
func (s *AdminSetUserPasswordInput) SetPermanent(v bool) *AdminSetUserPasswordInput {
	s.Permanent = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminSetUserPasswordInput) SetUserPoolId(v string) *AdminSetUserPasswordInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminSetUserPasswordInput) SetUsername(v string) *AdminSetUserPasswordInput {
	s.Username = &v
	return s
}

type AdminSetUserPasswordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminSetUserPasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminSetUserPasswordOutput) GoString() string {
	return s.String()
}

// You can use this parameter to set an MFA configuration that uses the SMS
// delivery medium.
type AdminSetUserSettingsInput struct {
	_ struct{} `type:"structure"`

	// You can use this parameter only to set an SMS configuration that uses SMS
	// for delivery.
	//
	// MFAOptions is a required field
	MFAOptions []*MFAOptionType `type:"list" required:"true"`

	// The ID of the user pool that contains the user whose options you're setting.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user whose options you're setting.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminSetUserSettingsInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminSetUserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminSetUserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminSetUserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminSetUserSettingsInput"}
	if s.MFAOptions == nil {
		invalidParams.Add(request.NewErrParamRequired("MFAOptions"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.MFAOptions != nil {
		for i, v := range s.MFAOptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MFAOptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMFAOptions sets the MFAOptions field's value.
func (s *AdminSetUserSettingsInput) SetMFAOptions(v []*MFAOptionType) *AdminSetUserSettingsInput {
	s.MFAOptions = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminSetUserSettingsInput) SetUserPoolId(v string) *AdminSetUserSettingsInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminSetUserSettingsInput) SetUsername(v string) *AdminSetUserSettingsInput {
	s.Username = &v
	return s
}

// Represents the response from the server to set user settings as an administrator.
type AdminSetUserSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminSetUserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminSetUserSettingsOutput) GoString() string {
	return s.String()
}

type AdminUpdateAuthEventFeedbackInput struct {
	_ struct{} `type:"structure"`

	// The authentication event ID.
	//
	// EventId is a required field
	EventId *string `min:"1" type:"string" required:"true"`

	// The authentication event feedback value.
	//
	// FeedbackValue is a required field
	FeedbackValue *string `type:"string" required:"true" enum:"FeedbackValueType"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user pool username.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminUpdateAuthEventFeedbackInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminUpdateAuthEventFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminUpdateAuthEventFeedbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminUpdateAuthEventFeedbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminUpdateAuthEventFeedbackInput"}
	if s.EventId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventId"))
	}
	if s.EventId != nil && len(*s.EventId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventId", 1))
	}
	if s.FeedbackValue == nil {
		invalidParams.Add(request.NewErrParamRequired("FeedbackValue"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventId sets the EventId field's value.
func (s *AdminUpdateAuthEventFeedbackInput) SetEventId(v string) *AdminUpdateAuthEventFeedbackInput {
	s.EventId = &v
	return s
}

// SetFeedbackValue sets the FeedbackValue field's value.
func (s *AdminUpdateAuthEventFeedbackInput) SetFeedbackValue(v string) *AdminUpdateAuthEventFeedbackInput {
	s.FeedbackValue = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminUpdateAuthEventFeedbackInput) SetUserPoolId(v string) *AdminUpdateAuthEventFeedbackInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminUpdateAuthEventFeedbackInput) SetUsername(v string) *AdminUpdateAuthEventFeedbackInput {
	s.Username = &v
	return s
}

type AdminUpdateAuthEventFeedbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminUpdateAuthEventFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminUpdateAuthEventFeedbackOutput) GoString() string {
	return s.String()
}

// The request to update the device status, as an administrator.
type AdminUpdateDeviceStatusInput struct {
	_ struct{} `type:"structure"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`

	// The status indicating whether a device has been remembered or not.
	DeviceRememberedStatus *string `type:"string" enum:"DeviceRememberedStatusType"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminUpdateDeviceStatusInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminUpdateDeviceStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminUpdateDeviceStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminUpdateDeviceStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminUpdateDeviceStatusInput"}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceKey sets the DeviceKey field's value.
func (s *AdminUpdateDeviceStatusInput) SetDeviceKey(v string) *AdminUpdateDeviceStatusInput {
	s.DeviceKey = &v
	return s
}

// SetDeviceRememberedStatus sets the DeviceRememberedStatus field's value.
func (s *AdminUpdateDeviceStatusInput) SetDeviceRememberedStatus(v string) *AdminUpdateDeviceStatusInput {
	s.DeviceRememberedStatus = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminUpdateDeviceStatusInput) SetUserPoolId(v string) *AdminUpdateDeviceStatusInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminUpdateDeviceStatusInput) SetUsername(v string) *AdminUpdateDeviceStatusInput {
	s.Username = &v
	return s
}

// The status response to the request to update the device, as an administrator.
type AdminUpdateDeviceStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminUpdateDeviceStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminUpdateDeviceStatusOutput) GoString() string {
	return s.String()
}

// Represents the request to update the user's attributes as an administrator.
type AdminUpdateUserAttributesInput struct {
	_ struct{} `type:"structure"`

	// A map of custom key-value pairs that you can provide as input for any custom
	// workflows that this action triggers.
	//
	// You create custom workflows by assigning Lambda functions to user pool triggers.
	// When you use the AdminUpdateUserAttributes API action, Amazon Cognito invokes
	// the function that is assigned to the custom message trigger. When Amazon
	// Cognito invokes this function, it passes a JSON payload, which the function
	// receives as input. This payload contains a clientMetadata attribute, which
	// provides the data that you assigned to the ClientMetadata parameter in your
	// AdminUpdateUserAttributes request. In your function code in Lambda, you can
	// process the clientMetadata value to enhance your workflow for your specific
	// needs.
	//
	// For more information, see Customizing user pool Workflows with Lambda Triggers
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
	// in the Amazon Cognito Developer Guide.
	//
	// When you use the ClientMetadata parameter, remember that Amazon Cognito won't
	// do the following:
	//
	//    * Store the ClientMetadata value. This data is available only to Lambda
	//    triggers that are assigned to a user pool to support custom workflows.
	//    If your user pool configuration doesn't include triggers, the ClientMetadata
	//    parameter serves no purpose.
	//
	//    * Validate the ClientMetadata value.
	//
	//    * Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide
	//    sensitive information.
	ClientMetadata map[string]*string `type:"map"`

	// An array of name-value pairs representing user attributes.
	//
	// For custom attributes, you must prepend the custom: prefix to the attribute
	// name.
	//
	// UserAttributes is a required field
	UserAttributes []*AttributeType `type:"list" required:"true"`

	// The user pool ID for the user pool where you want to update user attributes.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user for whom you want to update user attributes.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminUpdateUserAttributesInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminUpdateUserAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminUpdateUserAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminUpdateUserAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminUpdateUserAttributesInput"}
	if s.UserAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("UserAttributes"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.UserAttributes != nil {
		for i, v := range s.UserAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientMetadata sets the ClientMetadata field's value.
func (s *AdminUpdateUserAttributesInput) SetClientMetadata(v map[string]*string) *AdminUpdateUserAttributesInput {
	s.ClientMetadata = v
	return s
}

// SetUserAttributes sets the UserAttributes field's value.
func (s *AdminUpdateUserAttributesInput) SetUserAttributes(v []*AttributeType) *AdminUpdateUserAttributesInput {
	s.UserAttributes = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminUpdateUserAttributesInput) SetUserPoolId(v string) *AdminUpdateUserAttributesInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminUpdateUserAttributesInput) SetUsername(v string) *AdminUpdateUserAttributesInput {
	s.Username = &v
	return s
}

// Represents the response from the server for the request to update user attributes
// as an administrator.
type AdminUpdateUserAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminUpdateUserAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminUpdateUserAttributesOutput) GoString() string {
	return s.String()
}

// The request to sign out of all devices, as an administrator.
type AdminUserGlobalSignOutInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AdminUserGlobalSignOutInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminUserGlobalSignOutInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminUserGlobalSignOutInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminUserGlobalSignOutInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminUserGlobalSignOutInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *AdminUserGlobalSignOutInput) SetUserPoolId(v string) *AdminUserGlobalSignOutInput {
	s.UserPoolId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AdminUserGlobalSignOutInput) SetUsername(v string) *AdminUserGlobalSignOutInput {
	s.Username = &v
	return s
}

// The global sign-out response, as an administrator.
type AdminUserGlobalSignOutOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminUserGlobalSignOutOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminUserGlobalSignOutOutput) GoString() string {
	return s.String()
}

// This exception is thrown when a user tries to confirm the account with an
// email or phone number that has already been supplied as an alias from a different
// account. This exception tells user that an account with this email or phone
// already exists.
type AliasExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message sent to the user when an alias exists.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AliasExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AliasExistsException) GoString() string {
	return s.String()
}

func newErrorAliasExistsException(v protocol.ResponseMetadata) error {
	return &AliasExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AliasExistsException) Code() string {
	return "AliasExistsException"
}

// Message returns the exception's message.
func (s *AliasExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AliasExistsException) OrigErr() error {
	return nil
}

func (s *AliasExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AliasExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AliasExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Amazon Pinpoint analytics configuration for collecting metrics for a
// user pool.
//
// In Regions where Amazon Pinpointisn't available, user pools only support
// sending events to Amazon Pinpoint projects in us-east-1. In Regions where
// Amazon Pinpoint is available, user pools support sending events to Amazon
// Pinpoint projects within that same Region.
type AnalyticsConfigurationType struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Amazon Pinpoint project. You can use
	// the Amazon Pinpoint project to integrate with the chosen user pool Client.
	// Amazon Cognito publishes events to the Amazon Pinpointproject declared by
	// the app ARN.
	ApplicationArn *string `min:"20" type:"string"`

	// The application ID for an Amazon Pinpoint application.
	ApplicationId *string `type:"string"`

	// The external ID.
	ExternalId *string `type:"string"`

	// The ARN of an Identity and Access Management role that authorizes Amazon
	// Cognito to publish events to Amazon Pinpoint analytics.
	RoleArn *string `min:"20" type:"string"`

	// If UserDataShared is true, Amazon Cognito will include user data in the events
	// it publishes to Amazon Pinpoint analytics.
	UserDataShared *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsConfigurationType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsConfigurationType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsConfigurationType"}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 20))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *AnalyticsConfigurationType) SetApplicationArn(v string) *AnalyticsConfigurationType {
	s.ApplicationArn = &v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *AnalyticsConfigurationType) SetApplicationId(v string) *AnalyticsConfigurationType {
	s.ApplicationId = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *AnalyticsConfigurationType) SetExternalId(v string) *AnalyticsConfigurationType {
	s.ExternalId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AnalyticsConfigurationType) SetRoleArn(v string) *AnalyticsConfigurationType {
	s.RoleArn = &v
	return s
}

// SetUserDataShared sets the UserDataShared field's value.
func (s *AnalyticsConfigurationType) SetUserDataShared(v bool) *AnalyticsConfigurationType {
	s.UserDataShared = &v
	return s
}

// An Amazon Pinpoint analytics endpoint.
//
// An endpoint uniquely identifies a mobile device, email address, or phone
// number that can receive messages from Amazon Pinpoint analytics.
//
// Amazon Cognito user pools only support sending events to Amazon Pinpoint
// projects in the US East (N. Virginia) us-east-1 Region, regardless of the
// Region where the user pool resides.
type AnalyticsMetadataType struct {
	_ struct{} `type:"structure"`

	// The endpoint ID.
	AnalyticsEndpointId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsMetadataType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsMetadataType) GoString() string {
	return s.String()
}

// SetAnalyticsEndpointId sets the AnalyticsEndpointId field's value.
func (s *AnalyticsMetadataType) SetAnalyticsEndpointId(v string) *AnalyticsMetadataType {
	s.AnalyticsEndpointId = &v
	return s
}

type AssociateSoftwareTokenInput struct {
	_ struct{} `type:"structure"`

	// The access token.
	//
	// AccessToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssociateSoftwareTokenInput's
	// String and GoString methods.
	AccessToken *string `type:"string" sensitive:"true"`

	// The session that should be passed both ways in challenge-response calls to
	// the service. This allows authentication of the user as part of the MFA setup
	// process.
	Session *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSoftwareTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSoftwareTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateSoftwareTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateSoftwareTokenInput"}
	if s.Session != nil && len(*s.Session) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Session", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *AssociateSoftwareTokenInput) SetAccessToken(v string) *AssociateSoftwareTokenInput {
	s.AccessToken = &v
	return s
}

// SetSession sets the Session field's value.
func (s *AssociateSoftwareTokenInput) SetSession(v string) *AssociateSoftwareTokenInput {
	s.Session = &v
	return s
}

type AssociateSoftwareTokenOutput struct {
	_ struct{} `type:"structure"`

	// A unique generated shared secret code that is used in the time-based one-time
	// password (TOTP) algorithm to generate a one-time code.
	//
	// SecretCode is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssociateSoftwareTokenOutput's
	// String and GoString methods.
	SecretCode *string `min:"16" type:"string" sensitive:"true"`

	// The session that should be passed both ways in challenge-response calls to
	// the service. This allows authentication of the user as part of the MFA setup
	// process.
	Session *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSoftwareTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSoftwareTokenOutput) GoString() string {
	return s.String()
}

// SetSecretCode sets the SecretCode field's value.
func (s *AssociateSoftwareTokenOutput) SetSecretCode(v string) *AssociateSoftwareTokenOutput {
	s.SecretCode = &v
	return s
}

// SetSession sets the Session field's value.
func (s *AssociateSoftwareTokenOutput) SetSession(v string) *AssociateSoftwareTokenOutput {
	s.Session = &v
	return s
}

// Specifies whether the attribute is standard or custom.
type AttributeType struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The value of the attribute.
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AttributeType's
	// String and GoString methods.
	Value *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeType"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AttributeType) SetName(v string) *AttributeType {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AttributeType) SetValue(v string) *AttributeType {
	s.Value = &v
	return s
}

// The authentication event type.
type AuthEventType struct {
	_ struct{} `type:"structure"`

	// The challenge responses.
	ChallengeResponses []*ChallengeResponseType `type:"list"`

	// The creation date
	CreationDate *time.Time `type:"timestamp"`

	// The user context data captured at the time of an event request. This value
	// provides additional information about the client from which event the request
	// is received.
	EventContextData *EventContextDataType `type:"structure"`

	// A flag specifying the user feedback captured at the time of an event request
	// is good or bad.
	EventFeedback *EventFeedbackType `type:"structure"`

	// The event ID.
	EventId *string `type:"string"`

	// The event response.
	EventResponse *string `type:"string" enum:"EventResponseType"`

	// The event risk.
	EventRisk *EventRiskType `type:"structure"`

	// The event type.
	EventType *string `type:"string" enum:"EventType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthEventType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthEventType) GoString() string {
	return s.String()
}

// SetChallengeResponses sets the ChallengeResponses field's value.
func (s *AuthEventType) SetChallengeResponses(v []*ChallengeResponseType) *AuthEventType {
	s.ChallengeResponses = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *AuthEventType) SetCreationDate(v time.Time) *AuthEventType {
	s.CreationDate = &v
	return s
}

// SetEventContextData sets the EventContextData field's value.
func (s *AuthEventType) SetEventContextData(v *EventContextDataType) *AuthEventType {
	s.EventContextData = v
	return s
}

// SetEventFeedback sets the EventFeedback field's value.
func (s *AuthEventType) SetEventFeedback(v *EventFeedbackType) *AuthEventType {
	s.EventFeedback = v
	return s
}

// SetEventId sets the EventId field's value.
func (s *AuthEventType) SetEventId(v string) *AuthEventType {
	s.EventId = &v
	return s
}

// SetEventResponse sets the EventResponse field's value.
func (s *AuthEventType) SetEventResponse(v string) *AuthEventType {
	s.EventResponse = &v
	return s
}

// SetEventRisk sets the EventRisk field's value.
func (s *AuthEventType) SetEventRisk(v *EventRiskType) *AuthEventType {
	s.EventRisk = v
	return s
}

// SetEventType sets the EventType field's value.
func (s *AuthEventType) SetEventType(v string) *AuthEventType {
	s.EventType = &v
	return s
}

// The authentication result.
type AuthenticationResultType struct {
	_ struct{} `type:"structure"`

	// The access token.
	//
	// AccessToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AuthenticationResultType's
	// String and GoString methods.
	AccessToken *string `type:"string" sensitive:"true"`

	// The expiration period of the authentication result in seconds.
	ExpiresIn *int64 `type:"integer"`

	// The ID token.
	//
	// IdToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AuthenticationResultType's
	// String and GoString methods.
	IdToken *string `type:"string" sensitive:"true"`

	// The new device metadata from an authentication result.
	NewDeviceMetadata *NewDeviceMetadataType `type:"structure"`

	// The refresh token.
	//
	// RefreshToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AuthenticationResultType's
	// String and GoString methods.
	RefreshToken *string `type:"string" sensitive:"true"`

	// The token type.
	TokenType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationResultType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationResultType) GoString() string {
	return s.String()
}

// SetAccessToken sets the AccessToken field's value.
func (s *AuthenticationResultType) SetAccessToken(v string) *AuthenticationResultType {
	s.AccessToken = &v
	return s
}

// SetExpiresIn sets the ExpiresIn field's value.
func (s *AuthenticationResultType) SetExpiresIn(v int64) *AuthenticationResultType {
	s.ExpiresIn = &v
	return s
}

// SetIdToken sets the IdToken field's value.
func (s *AuthenticationResultType) SetIdToken(v string) *AuthenticationResultType {
	s.IdToken = &v
	return s
}

// SetNewDeviceMetadata sets the NewDeviceMetadata field's value.
func (s *AuthenticationResultType) SetNewDeviceMetadata(v *NewDeviceMetadataType) *AuthenticationResultType {
	s.NewDeviceMetadata = v
	return s
}

// SetRefreshToken sets the RefreshToken field's value.
func (s *AuthenticationResultType) SetRefreshToken(v string) *AuthenticationResultType {
	s.RefreshToken = &v
	return s
}

// SetTokenType sets the TokenType field's value.
func (s *AuthenticationResultType) SetTokenType(v string) *AuthenticationResultType {
	s.TokenType = &v
	return s
}

// The challenge response type.
type ChallengeResponseType struct {
	_ struct{} `type:"structure"`

	// The challenge name.
	ChallengeName *string `type:"string" enum:"ChallengeName"`

	// The challenge response.
	ChallengeResponse *string `type:"string" enum:"ChallengeResponse"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChallengeResponseType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChallengeResponseType) GoString() string {
	return s.String()
}

// SetChallengeName sets the ChallengeName field's value.
func (s *ChallengeResponseType) SetChallengeName(v string) *ChallengeResponseType {
	s.ChallengeName = &v
	return s
}

// SetChallengeResponse sets the ChallengeResponse field's value.
func (s *ChallengeResponseType) SetChallengeResponse(v string) *ChallengeResponseType {
	s.ChallengeResponse = &v
	return s
}

// Represents the request to change a user password.
type ChangePasswordInput struct {
	_ struct{} `type:"structure"`

	// The access token.
	//
	// AccessToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChangePasswordInput's
	// String and GoString methods.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true" sensitive:"true"`

	// The old password.
	//
	// PreviousPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChangePasswordInput's
	// String and GoString methods.
	//
	// PreviousPassword is a required field
	PreviousPassword *string `type:"string" required:"true" sensitive:"true"`

	// The new password.
	//
	// ProposedPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChangePasswordInput's
	// String and GoString methods.
	//
	// ProposedPassword is a required field
	ProposedPassword *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangePasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangePasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChangePasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChangePasswordInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}
	if s.PreviousPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("PreviousPassword"))
	}
	if s.ProposedPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("ProposedPassword"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *ChangePasswordInput) SetAccessToken(v string) *ChangePasswordInput {
	s.AccessToken = &v
	return s
}

// SetPreviousPassword sets the PreviousPassword field's value.
func (s *ChangePasswordInput) SetPreviousPassword(v string) *ChangePasswordInput {
	s.PreviousPassword = &v
	return s
}

// SetProposedPassword sets the ProposedPassword field's value.
func (s *ChangePasswordInput) SetProposedPassword(v string) *ChangePasswordInput {
	s.ProposedPassword = &v
	return s
}

// The response from the server to the change password request.
type ChangePasswordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangePasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangePasswordOutput) GoString() string {
	return s.String()
}

// The code delivery details being returned from the server.
type CodeDeliveryDetailsType struct {
	_ struct{} `type:"structure"`

	// The attribute name.
	AttributeName *string `min:"1" type:"string"`

	// The delivery medium (email message or phone number).
	DeliveryMedium *string `type:"string" enum:"DeliveryMediumType"`

	// The destination for the code delivery details.
	Destination *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeDeliveryDetailsType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeDeliveryDetailsType) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *CodeDeliveryDetailsType) SetAttributeName(v string) *CodeDeliveryDetailsType {
	s.AttributeName = &v
	return s
}

// SetDeliveryMedium sets the DeliveryMedium field's value.
func (s *CodeDeliveryDetailsType) SetDeliveryMedium(v string) *CodeDeliveryDetailsType {
	s.DeliveryMedium = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *CodeDeliveryDetailsType) SetDestination(v string) *CodeDeliveryDetailsType {
	s.Destination = &v
	return s
}

// This exception is thrown when a verification code fails to deliver successfully.
type CodeDeliveryFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message sent when a verification code fails to deliver successfully.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeDeliveryFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeDeliveryFailureException) GoString() string {
	return s.String()
}

func newErrorCodeDeliveryFailureException(v protocol.ResponseMetadata) error {
	return &CodeDeliveryFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CodeDeliveryFailureException) Code() string {
	return "CodeDeliveryFailureException"
}

// Message returns the exception's message.
func (s *CodeDeliveryFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CodeDeliveryFailureException) OrigErr() error {
	return nil
}

func (s *CodeDeliveryFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CodeDeliveryFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CodeDeliveryFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown if the provided code doesn't match what the server
// was expecting.
type CodeMismatchException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message provided when the code mismatch exception is thrown.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeMismatchException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeMismatchException) GoString() string {
	return s.String()
}

func newErrorCodeMismatchException(v protocol.ResponseMetadata) error {
	return &CodeMismatchException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CodeMismatchException) Code() string {
	return "CodeMismatchException"
}

// Message returns the exception's message.
func (s *CodeMismatchException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CodeMismatchException) OrigErr() error {
	return nil
}

func (s *CodeMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CodeMismatchException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CodeMismatchException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The compromised credentials actions type.
type CompromisedCredentialsActionsType struct {
	_ struct{} `type:"structure"`

	// The event action.
	//
	// EventAction is a required field
	EventAction *string `type:"string" required:"true" enum:"CompromisedCredentialsEventActionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompromisedCredentialsActionsType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompromisedCredentialsActionsType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompromisedCredentialsActionsType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompromisedCredentialsActionsType"}
	if s.EventAction == nil {
		invalidParams.Add(request.NewErrParamRequired("EventAction"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventAction sets the EventAction field's value.
func (s *CompromisedCredentialsActionsType) SetEventAction(v string) *CompromisedCredentialsActionsType {
	s.EventAction = &v
	return s
}

// The compromised credentials risk configuration type.
type CompromisedCredentialsRiskConfigurationType struct {
	_ struct{} `type:"structure"`

	// The compromised credentials risk configuration actions.
	//
	// Actions is a required field
	Actions *CompromisedCredentialsActionsType `type:"structure" required:"true"`

	// Perform the action for these events. The default is to perform all events
	// if no event filter is specified.
	EventFilter []*string `type:"list" enum:"EventFilterType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompromisedCredentialsRiskConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompromisedCredentialsRiskConfigurationType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompromisedCredentialsRiskConfigurationType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompromisedCredentialsRiskConfigurationType"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil {
		if err := s.Actions.Validate(); err != nil {
			invalidParams.AddNested("Actions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *CompromisedCredentialsRiskConfigurationType) SetActions(v *CompromisedCredentialsActionsType) *CompromisedCredentialsRiskConfigurationType {
	s.Actions = v
	return s
}

// SetEventFilter sets the EventFilter field's value.
func (s *CompromisedCredentialsRiskConfigurationType) SetEventFilter(v []*string) *CompromisedCredentialsRiskConfigurationType {
	s.EventFilter = v
	return s
}

// This exception is thrown if two or more modifications are happening concurrently.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message provided when the concurrent exception is thrown.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Confirms the device request.
type ConfirmDeviceInput struct {
	_ struct{} `type:"structure"`

	// The access token.
	//
	// AccessToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConfirmDeviceInput's
	// String and GoString methods.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true" sensitive:"true"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`

	// The device name.
	DeviceName *string `min:"1" type:"string"`

	// The configuration of the device secret verifier.
	DeviceSecretVerifierConfig *DeviceSecretVerifierConfigType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfirmDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfirmDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmDeviceInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}
	if s.DeviceName != nil && len(*s.DeviceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *ConfirmDeviceInput) SetAccessToken(v string) *ConfirmDeviceInput {
	s.AccessToken = &v
	return s
}

// SetDeviceKey sets the DeviceKey field's value.
func (s *ConfirmDeviceInput) SetDeviceKey(v string) *ConfirmDeviceInput {
	s.DeviceKey = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *ConfirmDeviceInput) SetDeviceName(v string) *ConfirmDeviceInput {
	s.DeviceName = &v
	return s
}

// SetDeviceSecretVerifierConfig sets the DeviceSecretVerifierConfig field's value.
func (s *ConfirmDeviceInput) SetDeviceSecretVerifierConfig(v *DeviceSecretVerifierConfigType) *ConfirmDeviceInput {
	s.DeviceSecretVerifierConfig = v
	return s
}

// Confirms the device response.
type ConfirmDeviceOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the user confirmation must confirm the device response.
	UserConfirmationNecessary *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfirmDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfirmDeviceOutput) GoString() string {
	return s.String()
}

// SetUserConfirmationNecessary sets the UserConfirmationNecessary field's value.
func (s *ConfirmDeviceOutput) SetUserConfirmationNecessary(v bool) *ConfirmDeviceOutput {
	s.UserConfirmationNecessary = &v
	return s
}

// The request representing the confirmation for a password reset.
type ConfirmForgotPasswordInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Pinpoint analytics metadata for collecting metrics for ConfirmForgotPassword
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The app client ID of the app associated with the user pool.
	//
	// ClientId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConfirmForgotPasswordInput's
	// String and GoString methods.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// A map of custom key-value pairs that you can provide as input for any custom
	// workflows that this action triggers.
	//
	// You create custom workflows by assigning Lambda functions to user pool triggers.
	// When you use the ConfirmForgotPassword API action, Amazon Cognito invokes
	// the function that is assigned to the post confirmation trigger. When Amazon
	// Cognito invokes this function, it passes a JSON payload, which the function
	// receives as input. This payload contains a clientMetadata attribute, which
	// provides the data that you assigned to the ClientMetadata parameter in your
	// ConfirmForgotPassword request. In your function code in Lambda, you can process
	// the clientMetadata value to enhance your workflow for your specific needs.
	//
	// For more information, see Customizing user pool Workflows with Lambda Triggers
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
	// in the Amazon Cognito Developer Guide.
	//
	// When you use the ClientMetadata parameter, remember that Amazon Cognito won't
	// do the following:
	//
	//    * Store the ClientMetadata value. This data is available only to Lambda
	//    triggers that are assigned to a user pool to support custom workflows.
	//    If your user pool configuration doesn't include triggers, the ClientMetadata
	//    parameter serves no purpose.
	//
	//    * Validate the ClientMetadata value.
	//
	//    * Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide
	//    sensitive information.
	ClientMetadata map[string]*string `type:"map"`

	// The confirmation code sent by a user's request to retrieve a forgotten password.
	// For more information, see ForgotPassword (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ForgotPassword.html).
	//
	// ConfirmationCode is a required field
	ConfirmationCode *string `min:"1" type:"string" required:"true"`

	// The password sent by a user's request to retrieve a forgotten password.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConfirmForgotPasswordInput's
	// String and GoString methods.
	//
	// Password is a required field
	Password *string `type:"string" required:"true" sensitive:"true"`

	// A keyed-hash message authentication code (HMAC) calculated using the secret
	// key of a user pool client and username plus the client ID in the message.
	//
	// SecretHash is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConfirmForgotPasswordInput's
	// String and GoString methods.
	SecretHash *string `min:"1" type:"string" sensitive:"true"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	UserContextData *UserContextDataType `type:"structure"`

	// The user name of the user for whom you want to enter a code to retrieve a
	// forgotten password.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConfirmForgotPasswordInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfirmForgotPasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfirmForgotPasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmForgotPasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmForgotPasswordInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.ConfirmationCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfirmationCode"))
	}
	if s.ConfirmationCode != nil && len(*s.ConfirmationCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfirmationCode", 1))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.SecretHash != nil && len(*s.SecretHash) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretHash", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyticsMetadata sets the AnalyticsMetadata field's value.
func (s *ConfirmForgotPasswordInput) SetAnalyticsMetadata(v *AnalyticsMetadataType) *ConfirmForgotPasswordInput {
	s.AnalyticsMetadata = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *ConfirmForgotPasswordInput) SetClientId(v string) *ConfirmForgotPasswordInput {
	s.ClientId = &v
	return s
}

// SetClientMetadata sets the ClientMetadata field's value.
func (s *ConfirmForgotPasswordInput) SetClientMetadata(v map[string]*string) *ConfirmForgotPasswordInput {
	s.ClientMetadata = v
	return s
}

// SetConfirmationCode sets the ConfirmationCode field's value.
func (s *ConfirmForgotPasswordInput) SetConfirmationCode(v string) *ConfirmForgotPasswordInput {
	s.ConfirmationCode = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *ConfirmForgotPasswordInput) SetPassword(v string) *ConfirmForgotPasswordInput {
	s.Password = &v
	return s
}

// SetSecretHash sets the SecretHash field's value.
func (s *ConfirmForgotPasswordInput) SetSecretHash(v string) *ConfirmForgotPasswordInput {
	s.SecretHash = &v
	return s
}

// SetUserContextData sets the UserContextData field's value.
func (s *ConfirmForgotPasswordInput) SetUserContextData(v *UserContextDataType) *ConfirmForgotPasswordInput {
	s.UserContextData = v
	return s
}

// SetUsername sets the Username field's value.
func (s *ConfirmForgotPasswordInput) SetUsername(v string) *ConfirmForgotPasswordInput {
	s.Username = &v
	return s
}

// The response from the server that results from a user's request to retrieve
// a forgotten password.
type ConfirmForgotPasswordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfirmForgotPasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfirmForgotPasswordOutput) GoString() string {
	return s.String()
}

// Represents the request to confirm registration of a user.
type ConfirmSignUpInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Pinpoint analytics metadata for collecting metrics for ConfirmSignUp
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The ID of the app client associated with the user pool.
	//
	// ClientId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConfirmSignUpInput's
	// String and GoString methods.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// A map of custom key-value pairs that you can provide as input for any custom
	// workflows that this action triggers.
	//
	// You create custom workflows by assigning Lambda functions to user pool triggers.
	// When you use the ConfirmSignUp API action, Amazon Cognito invokes the function
	// that is assigned to the post confirmation trigger. When Amazon Cognito invokes
	// this function, it passes a JSON payload, which the function receives as input.
	// This payload contains a clientMetadata attribute, which provides the data
	// that you assigned to the ClientMetadata parameter in your ConfirmSignUp request.
	// In your function code in Lambda, you can process the clientMetadata value
	// to enhance your workflow for your specific needs.
	//
	// For more information, see Customizing user pool Workflows with Lambda Triggers
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
	// in the Amazon Cognito Developer Guide.
	//
	// When you use the ClientMetadata parameter, remember that Amazon Cognito won't
	// do the following:
	//
	//    * Store the ClientMetadata value. This data is available only to Lambda
	//    triggers that are assigned to a user pool to support custom workflows.
	//    If your user pool configuration doesn't include triggers, the ClientMetadata
	//    parameter serves no purpose.
	//
	//    * Validate the ClientMetadata value.
	//
	//    * Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide
	//    sensitive information.
	ClientMetadata map[string]*string `type:"map"`

	// The confirmation code sent by a user's request to confirm registration.
	//
	// ConfirmationCode is a required field
	ConfirmationCode *string `min:"1" type:"string" required:"true"`

	// Boolean to be specified to force user confirmation irrespective of existing
	// alias. By default set to False. If this parameter is set to True and the
	// phone number/email used for sign up confirmation already exists as an alias
	// with a different user, the API call will migrate the alias from the previous
	// user to the newly created user being confirmed. If set to False, the API
	// will throw an AliasExistsException error.
	ForceAliasCreation *bool `type:"boolean"`

	// A keyed-hash message authentication code (HMAC) calculated using the secret
	// key of a user pool client and username plus the client ID in the message.
	//
	// SecretHash is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConfirmSignUpInput's
	// String and GoString methods.
	SecretHash *string `min:"1" type:"string" sensitive:"true"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	UserContextData *UserContextDataType `type:"structure"`

	// The user name of the user whose registration you want to confirm.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConfirmSignUpInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfirmSignUpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfirmSignUpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmSignUpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmSignUpInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.ConfirmationCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfirmationCode"))
	}
	if s.ConfirmationCode != nil && len(*s.ConfirmationCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfirmationCode", 1))
	}
	if s.SecretHash != nil && len(*s.SecretHash) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretHash", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyticsMetadata sets the AnalyticsMetadata field's value.
func (s *ConfirmSignUpInput) SetAnalyticsMetadata(v *AnalyticsMetadataType) *ConfirmSignUpInput {
	s.AnalyticsMetadata = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *ConfirmSignUpInput) SetClientId(v string) *ConfirmSignUpInput {
	s.ClientId = &v
	return s
}

// SetClientMetadata sets the ClientMetadata field's value.
func (s *ConfirmSignUpInput) SetClientMetadata(v map[string]*string) *ConfirmSignUpInput {
	s.ClientMetadata = v
	return s
}

// SetConfirmationCode sets the ConfirmationCode field's value.
func (s *ConfirmSignUpInput) SetConfirmationCode(v string) *ConfirmSignUpInput {
	s.ConfirmationCode = &v
	return s
}

// SetForceAliasCreation sets the ForceAliasCreation field's value.
func (s *ConfirmSignUpInput) SetForceAliasCreation(v bool) *ConfirmSignUpInput {
	s.ForceAliasCreation = &v
	return s
}

// SetSecretHash sets the SecretHash field's value.
func (s *ConfirmSignUpInput) SetSecretHash(v string) *ConfirmSignUpInput {
	s.SecretHash = &v
	return s
}

// SetUserContextData sets the UserContextData field's value.
func (s *ConfirmSignUpInput) SetUserContextData(v *UserContextDataType) *ConfirmSignUpInput {
	s.UserContextData = v
	return s
}

// SetUsername sets the Username field's value.
func (s *ConfirmSignUpInput) SetUsername(v string) *ConfirmSignUpInput {
	s.Username = &v
	return s
}

// Represents the response from the server for the registration confirmation.
type ConfirmSignUpOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfirmSignUpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfirmSignUpOutput) GoString() string {
	return s.String()
}

// Contextual user data type used for evaluating the risk of an unexpected event
// by Amazon Cognito advanced security.
type ContextDataType struct {
	_ struct{} `type:"structure"`

	// Encoded data containing device fingerprinting details collected using the
	// Amazon Cognito context data collection library.
	EncodedData *string `type:"string"`

	// HttpHeaders received on your server in same order.
	//
	// HttpHeaders is a required field
	HttpHeaders []*HttpHeader `type:"list" required:"true"`

	// Source IP address of your user.
	//
	// IpAddress is a required field
	IpAddress *string `type:"string" required:"true"`

	// Your server endpoint where this API is invoked.
	//
	// ServerName is a required field
	ServerName *string `type:"string" required:"true"`

	// Your server path where this API is invoked.
	//
	// ServerPath is a required field
	ServerPath *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContextDataType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContextDataType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContextDataType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContextDataType"}
	if s.HttpHeaders == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpHeaders"))
	}
	if s.IpAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("IpAddress"))
	}
	if s.ServerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerName"))
	}
	if s.ServerPath == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncodedData sets the EncodedData field's value.
func (s *ContextDataType) SetEncodedData(v string) *ContextDataType {
	s.EncodedData = &v
	return s
}

// SetHttpHeaders sets the HttpHeaders field's value.
func (s *ContextDataType) SetHttpHeaders(v []*HttpHeader) *ContextDataType {
	s.HttpHeaders = v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *ContextDataType) SetIpAddress(v string) *ContextDataType {
	s.IpAddress = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *ContextDataType) SetServerName(v string) *ContextDataType {
	s.ServerName = &v
	return s
}

// SetServerPath sets the ServerPath field's value.
func (s *ContextDataType) SetServerPath(v string) *ContextDataType {
	s.ServerPath = &v
	return s
}

type CreateGroupInput struct {
	_ struct{} `type:"structure"`

	// A string containing the description of the group.
	Description *string `type:"string"`

	// The name of the group. Must be unique.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// A non-negative integer value that specifies the precedence of this group
	// relative to the other groups that a user can belong to in the user pool.
	// Zero is the highest precedence value. Groups with lower Precedence values
	// take precedence over groups with higher ornull Precedence values. If a user
	// belongs to two or more groups, it is the group with the lowest precedence
	// value whose role ARN is given in the user's tokens for the cognito:roles
	// and cognito:preferred_role claims.
	//
	// Two groups can have the same Precedence value. If this happens, neither group
	// takes precedence over the other. If two groups with the same Precedence have
	// the same role ARN, that role is used in the cognito:preferred_role claim
	// in tokens for users in each group. If the two groups have different role
	// ARNs, the cognito:preferred_role claim isn't set in users' tokens.
	//
	// The default Precedence value is null.
	Precedence *int64 `type:"integer"`

	// The role Amazon Resource Name (ARN) for the group.
	RoleArn *string `min:"20" type:"string"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateGroupInput) SetDescription(v string) *CreateGroupInput {
	s.Description = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateGroupInput) SetGroupName(v string) *CreateGroupInput {
	s.GroupName = &v
	return s
}

// SetPrecedence sets the Precedence field's value.
func (s *CreateGroupInput) SetPrecedence(v int64) *CreateGroupInput {
	s.Precedence = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateGroupInput) SetRoleArn(v string) *CreateGroupInput {
	s.RoleArn = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *CreateGroupInput) SetUserPoolId(v string) *CreateGroupInput {
	s.UserPoolId = &v
	return s
}

type CreateGroupOutput struct {
	_ struct{} `type:"structure"`

	// The group object for the group.
	Group *GroupType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *CreateGroupOutput) SetGroup(v *GroupType) *CreateGroupOutput {
	s.Group = v
	return s
}

type CreateIdentityProviderInput struct {
	_ struct{} `type:"structure"`

	// A mapping of identity provider attributes to standard and custom user pool
	// attributes.
	AttributeMapping map[string]*string `type:"map"`

	// A list of identity provider identifiers.
	IdpIdentifiers []*string `type:"list"`

	// The identity provider details. The following list describes the provider
	// detail keys for each identity provider type.
	//
	//    * For Google and Login with Amazon: client_id client_secret authorize_scopes
	//
	//    * For Facebook: client_id client_secret authorize_scopes api_version
	//
	//    * For Sign in with Apple: client_id team_id key_id private_key authorize_scopes
	//
	//    * For OpenID Connect (OIDC) providers: client_id client_secret attributes_request_method
	//    oidc_issuer authorize_scopes authorize_url if not available from discovery
	//    URL specified by oidc_issuer key token_url if not available from discovery
	//    URL specified by oidc_issuer key attributes_url if not available from
	//    discovery URL specified by oidc_issuer key jwks_uri if not available from
	//    discovery URL specified by oidc_issuer key attributes_url_add_attributes
	//    a read-only property that is set automatically
	//
	//    * For SAML providers: MetadataFile OR MetadataURL IDPSignout (optional)
	//
	// ProviderDetails is a required field
	ProviderDetails map[string]*string `type:"map" required:"true"`

	// The identity provider name.
	//
	// ProviderName is a required field
	ProviderName *string `min:"1" type:"string" required:"true"`

	// The identity provider type.
	//
	// ProviderType is a required field
	ProviderType *string `type:"string" required:"true" enum:"IdentityProviderTypeType"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdentityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdentityProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIdentityProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIdentityProviderInput"}
	if s.ProviderDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderDetails"))
	}
	if s.ProviderName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderName"))
	}
	if s.ProviderName != nil && len(*s.ProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderName", 1))
	}
	if s.ProviderType == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderType"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeMapping sets the AttributeMapping field's value.
func (s *CreateIdentityProviderInput) SetAttributeMapping(v map[string]*string) *CreateIdentityProviderInput {
	s.AttributeMapping = v
	return s
}

// SetIdpIdentifiers sets the IdpIdentifiers field's value.
func (s *CreateIdentityProviderInput) SetIdpIdentifiers(v []*string) *CreateIdentityProviderInput {
	s.IdpIdentifiers = v
	return s
}

// SetProviderDetails sets the ProviderDetails field's value.
func (s *CreateIdentityProviderInput) SetProviderDetails(v map[string]*string) *CreateIdentityProviderInput {
	s.ProviderDetails = v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *CreateIdentityProviderInput) SetProviderName(v string) *CreateIdentityProviderInput {
	s.ProviderName = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *CreateIdentityProviderInput) SetProviderType(v string) *CreateIdentityProviderInput {
	s.ProviderType = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *CreateIdentityProviderInput) SetUserPoolId(v string) *CreateIdentityProviderInput {
	s.UserPoolId = &v
	return s
}

type CreateIdentityProviderOutput struct {
	_ struct{} `type:"structure"`

	// The newly created identity provider object.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProviderType `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdentityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdentityProviderOutput) GoString() string {
	return s.String()
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *CreateIdentityProviderOutput) SetIdentityProvider(v *IdentityProviderType) *CreateIdentityProviderOutput {
	s.IdentityProvider = v
	return s
}

type CreateResourceServerInput struct {
	_ struct{} `type:"structure"`

	// A unique resource server identifier for the resource server. This could be
	// an HTTPS endpoint where the resource server is located, such as https://my-weather-api.example.com.
	//
	// Identifier is a required field
	Identifier *string `min:"1" type:"string" required:"true"`

	// A friendly name for the resource server.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A list of scopes. Each scope is a key-value map with the keys name and description.
	Scopes []*ResourceServerScopeType `type:"list"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourceServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourceServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourceServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourceServerInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Scopes != nil {
		for i, v := range s.Scopes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Scopes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *CreateResourceServerInput) SetIdentifier(v string) *CreateResourceServerInput {
	s.Identifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResourceServerInput) SetName(v string) *CreateResourceServerInput {
	s.Name = &v
	return s
}

// SetScopes sets the Scopes field's value.
func (s *CreateResourceServerInput) SetScopes(v []*ResourceServerScopeType) *CreateResourceServerInput {
	s.Scopes = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *CreateResourceServerInput) SetUserPoolId(v string) *CreateResourceServerInput {
	s.UserPoolId = &v
	return s
}

type CreateResourceServerOutput struct {
	_ struct{} `type:"structure"`

	// The newly created resource server.
	//
	// ResourceServer is a required field
	ResourceServer *ResourceServerType `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourceServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourceServerOutput) GoString() string {
	return s.String()
}

// SetResourceServer sets the ResourceServer field's value.
func (s *CreateResourceServerOutput) SetResourceServer(v *ResourceServerType) *CreateResourceServerOutput {
	s.ResourceServer = v
	return s
}

// Represents the request to create the user import job.
type CreateUserImportJobInput struct {
	_ struct{} `type:"structure"`

	// The role ARN for the Amazon CloudWatch Logs Logging role for the user import
	// job.
	//
	// CloudWatchLogsRoleArn is a required field
	CloudWatchLogsRoleArn *string `min:"20" type:"string" required:"true"`

	// The job name for the user import job.
	//
	// JobName is a required field
	JobName *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool that the users are being imported into.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserImportJobInput"}
	if s.CloudWatchLogsRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudWatchLogsRoleArn"))
	}
	if s.CloudWatchLogsRoleArn != nil && len(*s.CloudWatchLogsRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CloudWatchLogsRoleArn", 20))
	}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogsRoleArn sets the CloudWatchLogsRoleArn field's value.
func (s *CreateUserImportJobInput) SetCloudWatchLogsRoleArn(v string) *CreateUserImportJobInput {
	s.CloudWatchLogsRoleArn = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *CreateUserImportJobInput) SetJobName(v string) *CreateUserImportJobInput {
	s.JobName = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *CreateUserImportJobInput) SetUserPoolId(v string) *CreateUserImportJobInput {
	s.UserPoolId = &v
	return s
}

// Represents the response from the server to the request to create the user
// import job.
type CreateUserImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The job object that represents the user import job.
	UserImportJob *UserImportJobType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserImportJobOutput) GoString() string {
	return s.String()
}

// SetUserImportJob sets the UserImportJob field's value.
func (s *CreateUserImportJobOutput) SetUserImportJob(v *UserImportJobType) *CreateUserImportJobOutput {
	s.UserImportJob = v
	return s
}

// Represents the request to create a user pool client.
type CreateUserPoolClientInput struct {
	_ struct{} `type:"structure"`

	// The time limit, between 5 minutes and 1 day, after which the access token
	// is no longer valid and can't be used. If you supply a TokenValidityUnits
	// value, you will override the default time unit.
	AccessTokenValidity *int64 `min:"1" type:"integer"`

	// The allowed OAuth flows.
	//
	// Set to code to initiate a code grant flow, which provides an authorization
	// code as the response. This code can be exchanged for access tokens with the
	// token endpoint.
	//
	// Set to implicit to specify that the client should get the access token (and,
	// optionally, ID token, based on scopes) directly.
	//
	// Set to client_credentials to specify that the client should get the access
	// token (and, optionally, ID token, based on scopes) from the token endpoint
	// using a combination of client and client_secret.
	AllowedOAuthFlows []*string `type:"list" enum:"OAuthFlowType"`

	// Set to true if the client is allowed to follow the OAuth protocol when interacting
	// with Amazon Cognito user pools.
	AllowedOAuthFlowsUserPoolClient *bool `type:"boolean"`

	// The allowed OAuth scopes. Possible values provided by OAuth are: phone, email,
	// openid, and profile. Possible values provided by Amazon Web Services are:
	// aws.cognito.signin.user.admin. Custom scopes created in Resource Servers
	// are also supported.
	AllowedOAuthScopes []*string `type:"list"`

	// The user pool analytics configuration for collecting metrics and sending
	// them to your Amazon Pinpoint campaign.
	//
	// In Amazon Web Services Regions where Amazon Pinpoint isn't available, user
	// pools only support sending events to Amazon Pinpoint projects in Amazon Web
	// Services Region us-east-1. In Regions where Amazon Pinpoint is available,
	// user pools support sending events to Amazon Pinpoint projects within that
	// same Region.
	AnalyticsConfiguration *AnalyticsConfigurationType `type:"structure"`

	// A list of allowed redirect (callback) URLs for the identity providers.
	//
	// A redirect URI must:
	//
	//    * Be an absolute URI.
	//
	//    * Be registered with the authorization server.
	//
	//    * Not include a fragment component.
	//
	// See OAuth 2.0 - Redirection Endpoint (https://tools.ietf.org/html/rfc6749#section-3.1.2).
	//
	// Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing
	// purposes only.
	//
	// App callback URLs such as myapp://example are also supported.
	CallbackURLs []*string `type:"list"`

	// The client name for the user pool client you would like to create.
	//
	// ClientName is a required field
	ClientName *string `min:"1" type:"string" required:"true"`

	// The default redirect URI. Must be in the CallbackURLs list.
	//
	// A redirect URI must:
	//
	//    * Be an absolute URI.
	//
	//    * Be registered with the authorization server.
	//
	//    * Not include a fragment component.
	//
	// See OAuth 2.0 - Redirection Endpoint (https://tools.ietf.org/html/rfc6749#section-3.1.2).
	//
	// Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing
	// purposes only.
	//
	// App callback URLs such as myapp://example are also supported.
	DefaultRedirectURI *string `min:"1" type:"string"`

	// Activates or deactivates token revocation. For more information about revoking
	// tokens, see RevokeToken (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
	//
	// If you don't include this parameter, token revocation is automatically activated
	// for the new user pool client.
	EnableTokenRevocation *bool `type:"boolean"`

	// The authentication flows that are supported by the user pool clients. Flow
	// names without the ALLOW_ prefix are no longer supported, in favor of new
	// names with the ALLOW_ prefix.
	//
	// Values with ALLOW_ prefix must be used only along with the ALLOW_ prefix.
	//
	// Valid values include:
	//
	//    * ALLOW_ADMIN_USER_PASSWORD_AUTH: Enable admin based user password authentication
	//    flow ADMIN_USER_PASSWORD_AUTH. This setting replaces the ADMIN_NO_SRP_AUTH
	//    setting. With this authentication flow, Amazon Cognito receives the password
	//    in the request instead of using the Secure Remote Password (SRP) protocol
	//    to verify passwords.
	//
	//    * ALLOW_CUSTOM_AUTH: Enable Lambda trigger based authentication.
	//
	//    * ALLOW_USER_PASSWORD_AUTH: Enable user password-based authentication.
	//    In this flow, Amazon Cognito receives the password in the request instead
	//    of using the SRP protocol to verify passwords.
	//
	//    * ALLOW_USER_SRP_AUTH: Enable SRP-based authentication.
	//
	//    * ALLOW_REFRESH_TOKEN_AUTH: Enable authflow to refresh tokens.
	ExplicitAuthFlows []*string `type:"list" enum:"ExplicitAuthFlowsType"`

	// Boolean to specify whether you want to generate a secret for the user pool
	// client being created.
	GenerateSecret *bool `type:"boolean"`

	// The time limit, between 5 minutes and 1 day, after which the access token
	// is no longer valid and can't be used. If you supply a TokenValidityUnits
	// value, you will override the default time unit.
	IdTokenValidity *int64 `min:"1" type:"integer"`

	// A list of allowed logout URLs for the identity providers.
	LogoutURLs []*string `type:"list"`

	// Errors and responses that you want Amazon Cognito APIs to return during authentication,
	// account confirmation, and password recovery when the user doesn't exist in
	// the user pool. When set to ENABLED and the user doesn't exist, authentication
	// returns an error indicating either the username or password was incorrect.
	// Account confirmation and password recovery return a response indicating a
	// code was sent to a simulated destination. When set to LEGACY, those APIs
	// return a UserNotFoundException exception if the user doesn't exist in the
	// user pool.
	//
	// Valid values include:
	//
	//    * ENABLED - This prevents user existence-related errors.
	//
	//    * LEGACY - This represents the early behavior of Amazon Cognito where
	//    user existence related errors aren't prevented.
	PreventUserExistenceErrors *string `type:"string" enum:"PreventUserExistenceErrorTypes"`

	// The read attributes.
	ReadAttributes []*string `type:"list"`

	// The time limit, in days, after which the refresh token is no longer valid
	// and can't be used.
	RefreshTokenValidity *int64 `type:"integer"`

	// A list of provider names for the identity providers that are supported on
	// this client. The following are supported: COGNITO, Facebook, Google and LoginWithAmazon.
	SupportedIdentityProviders []*string `type:"list"`

	// The units in which the validity times are represented. Default for RefreshToken
	// is days, and default for ID and access tokens are hours.
	TokenValidityUnits *TokenValidityUnitsType `type:"structure"`

	// The user pool ID for the user pool where you want to create a user pool client.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user pool attributes that the app client can write to.
	//
	// If your app client allows users to sign in through an identity provider,
	// this array must include all attributes that you have mapped to identity provider
	// attributes. Amazon Cognito updates mapped attributes when users sign in to
	// your application through an identity provider. If your app client does not
	// have write access to a mapped attribute, Amazon Cognito throws an error when
	// it tries to update the attribute. For more information, see Specifying Identity
	// Provider Attribute Mappings for Your user pool (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html).
	WriteAttributes []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserPoolClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserPoolClientInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserPoolClientInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserPoolClientInput"}
	if s.AccessTokenValidity != nil && *s.AccessTokenValidity < 1 {
		invalidParams.Add(request.NewErrParamMinValue("AccessTokenValidity", 1))
	}
	if s.ClientName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientName"))
	}
	if s.ClientName != nil && len(*s.ClientName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientName", 1))
	}
	if s.DefaultRedirectURI != nil && len(*s.DefaultRedirectURI) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultRedirectURI", 1))
	}
	if s.IdTokenValidity != nil && *s.IdTokenValidity < 1 {
		invalidParams.Add(request.NewErrParamMinValue("IdTokenValidity", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.AnalyticsConfiguration != nil {
		if err := s.AnalyticsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AnalyticsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessTokenValidity sets the AccessTokenValidity field's value.
func (s *CreateUserPoolClientInput) SetAccessTokenValidity(v int64) *CreateUserPoolClientInput {
	s.AccessTokenValidity = &v
	return s
}

// SetAllowedOAuthFlows sets the AllowedOAuthFlows field's value.
func (s *CreateUserPoolClientInput) SetAllowedOAuthFlows(v []*string) *CreateUserPoolClientInput {
	s.AllowedOAuthFlows = v
	return s
}

// SetAllowedOAuthFlowsUserPoolClient sets the AllowedOAuthFlowsUserPoolClient field's value.
func (s *CreateUserPoolClientInput) SetAllowedOAuthFlowsUserPoolClient(v bool) *CreateUserPoolClientInput {
	s.AllowedOAuthFlowsUserPoolClient = &v
	return s
}

// SetAllowedOAuthScopes sets the AllowedOAuthScopes field's value.
func (s *CreateUserPoolClientInput) SetAllowedOAuthScopes(v []*string) *CreateUserPoolClientInput {
	s.AllowedOAuthScopes = v
	return s
}

// SetAnalyticsConfiguration sets the AnalyticsConfiguration field's value.
func (s *CreateUserPoolClientInput) SetAnalyticsConfiguration(v *AnalyticsConfigurationType) *CreateUserPoolClientInput {
	s.AnalyticsConfiguration = v
	return s
}

// SetCallbackURLs sets the CallbackURLs field's value.
func (s *CreateUserPoolClientInput) SetCallbackURLs(v []*string) *CreateUserPoolClientInput {
	s.CallbackURLs = v
	return s
}

// SetClientName sets the ClientName field's value.
func (s *CreateUserPoolClientInput) SetClientName(v string) *CreateUserPoolClientInput {
	s.ClientName = &v
	return s
}

// SetDefaultRedirectURI sets the DefaultRedirectURI field's value.
func (s *CreateUserPoolClientInput) SetDefaultRedirectURI(v string) *CreateUserPoolClientInput {
	s.DefaultRedirectURI = &v
	return s
}

// SetEnableTokenRevocation sets the EnableTokenRevocation field's value.
func (s *CreateUserPoolClientInput) SetEnableTokenRevocation(v bool) *CreateUserPoolClientInput {
	s.EnableTokenRevocation = &v
	return s
}

// SetExplicitAuthFlows sets the ExplicitAuthFlows field's value.
func (s *CreateUserPoolClientInput) SetExplicitAuthFlows(v []*string) *CreateUserPoolClientInput {
	s.ExplicitAuthFlows = v
	return s
}

// SetGenerateSecret sets the GenerateSecret field's value.
func (s *CreateUserPoolClientInput) SetGenerateSecret(v bool) *CreateUserPoolClientInput {
	s.GenerateSecret = &v
	return s
}

// SetIdTokenValidity sets the IdTokenValidity field's value.
func (s *CreateUserPoolClientInput) SetIdTokenValidity(v int64) *CreateUserPoolClientInput {
	s.IdTokenValidity = &v
	return s
}

// SetLogoutURLs sets the LogoutURLs field's value.
func (s *CreateUserPoolClientInput) SetLogoutURLs(v []*string) *CreateUserPoolClientInput {
	s.LogoutURLs = v
	return s
}

// SetPreventUserExistenceErrors sets the PreventUserExistenceErrors field's value.
func (s *CreateUserPoolClientInput) SetPreventUserExistenceErrors(v string) *CreateUserPoolClientInput {
	s.PreventUserExistenceErrors = &v
	return s
}

// SetReadAttributes sets the ReadAttributes field's value.
func (s *CreateUserPoolClientInput) SetReadAttributes(v []*string) *CreateUserPoolClientInput {
	s.ReadAttributes = v
	return s
}

// SetRefreshTokenValidity sets the RefreshTokenValidity field's value.
func (s *CreateUserPoolClientInput) SetRefreshTokenValidity(v int64) *CreateUserPoolClientInput {
	s.RefreshTokenValidity = &v
	return s
}

// SetSupportedIdentityProviders sets the SupportedIdentityProviders field's value.
func (s *CreateUserPoolClientInput) SetSupportedIdentityProviders(v []*string) *CreateUserPoolClientInput {
	s.SupportedIdentityProviders = v
	return s
}

// SetTokenValidityUnits sets the TokenValidityUnits field's value.
func (s *CreateUserPoolClientInput) SetTokenValidityUnits(v *TokenValidityUnitsType) *CreateUserPoolClientInput {
	s.TokenValidityUnits = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *CreateUserPoolClientInput) SetUserPoolId(v string) *CreateUserPoolClientInput {
	s.UserPoolId = &v
	return s
}

// SetWriteAttributes sets the WriteAttributes field's value.
func (s *CreateUserPoolClientInput) SetWriteAttributes(v []*string) *CreateUserPoolClientInput {
	s.WriteAttributes = v
	return s
}

// Represents the response from the server to create a user pool client.
type CreateUserPoolClientOutput struct {
	_ struct{} `type:"structure"`

	// The user pool client that was just created.
	UserPoolClient *UserPoolClientType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserPoolClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserPoolClientOutput) GoString() string {
	return s.String()
}

// SetUserPoolClient sets the UserPoolClient field's value.
func (s *CreateUserPoolClientOutput) SetUserPoolClient(v *UserPoolClientType) *CreateUserPoolClientOutput {
	s.UserPoolClient = v
	return s
}

type CreateUserPoolDomainInput struct {
	_ struct{} `type:"structure"`

	// The configuration for a custom domain that hosts the sign-up and sign-in
	// webpages for your application.
	//
	// Provide this parameter only if you want to use a custom domain for your user
	// pool. Otherwise, you can exclude this parameter and use the Amazon Cognito
	// hosted domain instead.
	//
	// For more information about the hosted domain and custom domains, see Configuring
	// a User Pool Domain (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain.html).
	CustomDomainConfig *CustomDomainConfigType `type:"structure"`

	// The domain string. For custom domains, this is the fully-qualified domain
	// name, such as auth.example.com. For Amazon Cognito prefix domains, this is
	// the prefix alone, such as auth.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserPoolDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserPoolDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserPoolDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserPoolDomainInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.CustomDomainConfig != nil {
		if err := s.CustomDomainConfig.Validate(); err != nil {
			invalidParams.AddNested("CustomDomainConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomDomainConfig sets the CustomDomainConfig field's value.
func (s *CreateUserPoolDomainInput) SetCustomDomainConfig(v *CustomDomainConfigType) *CreateUserPoolDomainInput {
	s.CustomDomainConfig = v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CreateUserPoolDomainInput) SetDomain(v string) *CreateUserPoolDomainInput {
	s.Domain = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *CreateUserPoolDomainInput) SetUserPoolId(v string) *CreateUserPoolDomainInput {
	s.UserPoolId = &v
	return s
}

type CreateUserPoolDomainOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon CloudFront endpoint that you use as the target of the alias that
	// you set up with your Domain Name Service (DNS) provider.
	CloudFrontDomain *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserPoolDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserPoolDomainOutput) GoString() string {
	return s.String()
}

// SetCloudFrontDomain sets the CloudFrontDomain field's value.
func (s *CreateUserPoolDomainOutput) SetCloudFrontDomain(v string) *CreateUserPoolDomainOutput {
	s.CloudFrontDomain = &v
	return s
}

// Represents the request to create a user pool.
type CreateUserPoolInput struct {
	_ struct{} `type:"structure"`

	// The available verified method a user can use to recover their password when
	// they call ForgotPassword. You can use this setting to define a preferred
	// method when a user has more than one method available. With this setting,
	// SMS doesn't qualify for a valid password recovery mechanism if the user also
	// has SMS multi-factor authentication (MFA) activated. In the absence of this
	// setting, Amazon Cognito uses the legacy behavior to determine the recovery
	// method where SMS is preferred through email.
	AccountRecoverySetting *AccountRecoverySettingType `type:"structure"`

	// The configuration for AdminCreateUser requests.
	AdminCreateUserConfig *AdminCreateUserConfigType `type:"structure"`

	// Attributes supported as an alias for this user pool. Possible values: phone_number,
	// email, or preferred_username.
	AliasAttributes []*string `type:"list" enum:"AliasAttributeType"`

	// The attributes to be auto-verified. Possible values: email, phone_number.
	AutoVerifiedAttributes []*string `type:"list" enum:"VerifiedAttributeType"`

	// The device configuration.
	DeviceConfiguration *DeviceConfigurationType `type:"structure"`

	// The email configuration of your user pool. The email configuration type sets
	// your preferred sending method, Amazon Web Services Region, and sender for
	// messages from your user pool.
	EmailConfiguration *EmailConfigurationType `type:"structure"`

	// A string representing the email verification message. EmailVerificationMessage
	// is allowed only if EmailSendingAccount (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER.
	EmailVerificationMessage *string `min:"6" type:"string"`

	// A string representing the email verification subject. EmailVerificationSubject
	// is allowed only if EmailSendingAccount (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER.
	EmailVerificationSubject *string `min:"1" type:"string"`

	// The Lambda trigger configuration information for the new user pool.
	//
	// In a push model, event sources (such as Amazon S3 and custom applications)
	// need permission to invoke a function. So you must make an extra call to add
	// permission for these event sources to invoke your Lambda function.
	//
	// For more information on using the Lambda API to add permission, see AddPermission
	// (https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html).
	//
	// For adding permission using the CLI, see add-permission (https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html).
	LambdaConfig *LambdaConfigType `type:"structure"`

	// Specifies MFA configuration details.
	MfaConfiguration *string `type:"string" enum:"UserPoolMfaType"`

	// The policies associated with the new user pool.
	Policies *UserPoolPolicyType `type:"structure"`

	// A string used to name the user pool.
	//
	// PoolName is a required field
	PoolName *string `min:"1" type:"string" required:"true"`

	// An array of schema attributes for the new user pool. These attributes can
	// be standard or custom attributes.
	Schema []*SchemaAttributeType `min:"1" type:"list"`

	// A string representing the SMS authentication message.
	SmsAuthenticationMessage *string `min:"6" type:"string"`

	// The SMS configuration with the settings that your Amazon Cognito user pool
	// must use to send an SMS message from your Amazon Web Services account through
	// Amazon Simple Notification Service. To send SMS messages with Amazon SNS
	// in the Amazon Web Services Region that you want, the Amazon Cognito user
	// pool uses an Identity and Access Management (IAM) role in your Amazon Web
	// Services account.
	SmsConfiguration *SmsConfigurationType `type:"structure"`

	// A string representing the SMS verification message.
	SmsVerificationMessage *string `min:"6" type:"string"`

	// Enables advanced security risk detection. Set the key AdvancedSecurityMode
	// to the value "AUDIT".
	UserPoolAddOns *UserPoolAddOnsType `type:"structure"`

	// The tag keys and values to assign to the user pool. A tag is a label that
	// you can use to categorize and manage user pools in different ways, such as
	// by purpose, owner, environment, or other criteria.
	UserPoolTags map[string]*string `type:"map"`

	// Specifies whether a user can use an email address or phone number as a username
	// when they sign up.
	UsernameAttributes []*string `type:"list" enum:"UsernameAttributeType"`

	// Case sensitivity on the username input for the selected sign-in option. For
	// example, when case sensitivity is set to False, users can sign in using either
	// "username" or "Username". This configuration is immutable once it has been
	// set. For more information, see UsernameConfigurationType (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html).
	UsernameConfiguration *UsernameConfigurationType `type:"structure"`

	// The template for the verification message that the user sees when the app
	// requests permission to access the user's information.
	VerificationMessageTemplate *VerificationMessageTemplateType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserPoolInput"}
	if s.EmailVerificationMessage != nil && len(*s.EmailVerificationMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("EmailVerificationMessage", 6))
	}
	if s.EmailVerificationSubject != nil && len(*s.EmailVerificationSubject) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailVerificationSubject", 1))
	}
	if s.PoolName == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolName"))
	}
	if s.PoolName != nil && len(*s.PoolName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PoolName", 1))
	}
	if s.Schema != nil && len(s.Schema) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Schema", 1))
	}
	if s.SmsAuthenticationMessage != nil && len(*s.SmsAuthenticationMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("SmsAuthenticationMessage", 6))
	}
	if s.SmsVerificationMessage != nil && len(*s.SmsVerificationMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("SmsVerificationMessage", 6))
	}
	if s.AccountRecoverySetting != nil {
		if err := s.AccountRecoverySetting.Validate(); err != nil {
			invalidParams.AddNested("AccountRecoverySetting", err.(request.ErrInvalidParams))
		}
	}
	if s.AdminCreateUserConfig != nil {
		if err := s.AdminCreateUserConfig.Validate(); err != nil {
			invalidParams.AddNested("AdminCreateUserConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.EmailConfiguration != nil {
		if err := s.EmailConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EmailConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaConfig != nil {
		if err := s.LambdaConfig.Validate(); err != nil {
			invalidParams.AddNested("LambdaConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Policies != nil {
		if err := s.Policies.Validate(); err != nil {
			invalidParams.AddNested("Policies", err.(request.ErrInvalidParams))
		}
	}
	if s.Schema != nil {
		for i, v := range s.Schema {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Schema", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SmsConfiguration != nil {
		if err := s.SmsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SmsConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.UserPoolAddOns != nil {
		if err := s.UserPoolAddOns.Validate(); err != nil {
			invalidParams.AddNested("UserPoolAddOns", err.(request.ErrInvalidParams))
		}
	}
	if s.UsernameConfiguration != nil {
		if err := s.UsernameConfiguration.Validate(); err != nil {
			invalidParams.AddNested("UsernameConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.VerificationMessageTemplate != nil {
		if err := s.VerificationMessageTemplate.Validate(); err != nil {
			invalidParams.AddNested("VerificationMessageTemplate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountRecoverySetting sets the AccountRecoverySetting field's value.
func (s *CreateUserPoolInput) SetAccountRecoverySetting(v *AccountRecoverySettingType) *CreateUserPoolInput {
	s.AccountRecoverySetting = v
	return s
}

// SetAdminCreateUserConfig sets the AdminCreateUserConfig field's value.
func (s *CreateUserPoolInput) SetAdminCreateUserConfig(v *AdminCreateUserConfigType) *CreateUserPoolInput {
	s.AdminCreateUserConfig = v
	return s
}

// SetAliasAttributes sets the AliasAttributes field's value.
func (s *CreateUserPoolInput) SetAliasAttributes(v []*string) *CreateUserPoolInput {
	s.AliasAttributes = v
	return s
}

// SetAutoVerifiedAttributes sets the AutoVerifiedAttributes field's value.
func (s *CreateUserPoolInput) SetAutoVerifiedAttributes(v []*string) *CreateUserPoolInput {
	s.AutoVerifiedAttributes = v
	return s
}

// SetDeviceConfiguration sets the DeviceConfiguration field's value.
func (s *CreateUserPoolInput) SetDeviceConfiguration(v *DeviceConfigurationType) *CreateUserPoolInput {
	s.DeviceConfiguration = v
	return s
}

// SetEmailConfiguration sets the EmailConfiguration field's value.
func (s *CreateUserPoolInput) SetEmailConfiguration(v *EmailConfigurationType) *CreateUserPoolInput {
	s.EmailConfiguration = v
	return s
}

// SetEmailVerificationMessage sets the EmailVerificationMessage field's value.
func (s *CreateUserPoolInput) SetEmailVerificationMessage(v string) *CreateUserPoolInput {
	s.EmailVerificationMessage = &v
	return s
}

// SetEmailVerificationSubject sets the EmailVerificationSubject field's value.
func (s *CreateUserPoolInput) SetEmailVerificationSubject(v string) *CreateUserPoolInput {
	s.EmailVerificationSubject = &v
	return s
}

// SetLambdaConfig sets the LambdaConfig field's value.
func (s *CreateUserPoolInput) SetLambdaConfig(v *LambdaConfigType) *CreateUserPoolInput {
	s.LambdaConfig = v
	return s
}

// SetMfaConfiguration sets the MfaConfiguration field's value.
func (s *CreateUserPoolInput) SetMfaConfiguration(v string) *CreateUserPoolInput {
	s.MfaConfiguration = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *CreateUserPoolInput) SetPolicies(v *UserPoolPolicyType) *CreateUserPoolInput {
	s.Policies = v
	return s
}

// SetPoolName sets the PoolName field's value.
func (s *CreateUserPoolInput) SetPoolName(v string) *CreateUserPoolInput {
	s.PoolName = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *CreateUserPoolInput) SetSchema(v []*SchemaAttributeType) *CreateUserPoolInput {
	s.Schema = v
	return s
}

// SetSmsAuthenticationMessage sets the SmsAuthenticationMessage field's value.
func (s *CreateUserPoolInput) SetSmsAuthenticationMessage(v string) *CreateUserPoolInput {
	s.SmsAuthenticationMessage = &v
	return s
}

// SetSmsConfiguration sets the SmsConfiguration field's value.
func (s *CreateUserPoolInput) SetSmsConfiguration(v *SmsConfigurationType) *CreateUserPoolInput {
	s.SmsConfiguration = v
	return s
}

// SetSmsVerificationMessage sets the SmsVerificationMessage field's value.
func (s *CreateUserPoolInput) SetSmsVerificationMessage(v string) *CreateUserPoolInput {
	s.SmsVerificationMessage = &v
	return s
}

// SetUserPoolAddOns sets the UserPoolAddOns field's value.
func (s *CreateUserPoolInput) SetUserPoolAddOns(v *UserPoolAddOnsType) *CreateUserPoolInput {
	s.UserPoolAddOns = v
	return s
}

// SetUserPoolTags sets the UserPoolTags field's value.
func (s *CreateUserPoolInput) SetUserPoolTags(v map[string]*string) *CreateUserPoolInput {
	s.UserPoolTags = v
	return s
}

// SetUsernameAttributes sets the UsernameAttributes field's value.
func (s *CreateUserPoolInput) SetUsernameAttributes(v []*string) *CreateUserPoolInput {
	s.UsernameAttributes = v
	return s
}

// SetUsernameConfiguration sets the UsernameConfiguration field's value.
func (s *CreateUserPoolInput) SetUsernameConfiguration(v *UsernameConfigurationType) *CreateUserPoolInput {
	s.UsernameConfiguration = v
	return s
}

// SetVerificationMessageTemplate sets the VerificationMessageTemplate field's value.
func (s *CreateUserPoolInput) SetVerificationMessageTemplate(v *VerificationMessageTemplateType) *CreateUserPoolInput {
	s.VerificationMessageTemplate = v
	return s
}

// Represents the response from the server for the request to create a user
// pool.
type CreateUserPoolOutput struct {
	_ struct{} `type:"structure"`

	// A container for the user pool details.
	UserPool *UserPoolType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserPoolOutput) GoString() string {
	return s.String()
}

// SetUserPool sets the UserPool field's value.
func (s *CreateUserPoolOutput) SetUserPool(v *UserPoolType) *CreateUserPoolOutput {
	s.UserPool = v
	return s
}

// The configuration for a custom domain that hosts the sign-up and sign-in
// webpages for your application.
type CustomDomainConfigType struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Certificate Manager SSL certificate.
	// You use this certificate for the subdomain of your custom domain.
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomDomainConfigType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomDomainConfigType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomDomainConfigType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomDomainConfigType"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CustomDomainConfigType) SetCertificateArn(v string) *CustomDomainConfigType {
	s.CertificateArn = &v
	return s
}

// A custom email sender Lambda configuration type.
type CustomEmailLambdaVersionConfigType struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Lambda function that Amazon Cognito
	// activates to send email notifications to users.
	//
	// LambdaArn is a required field
	LambdaArn *string `min:"20" type:"string" required:"true"`

	// Signature of the "request" attribute in the "event" information Amazon Cognito
	// passes to your custom email Lambda function. The only supported value is
	// V1_0.
	//
	// LambdaVersion is a required field
	LambdaVersion *string `type:"string" required:"true" enum:"CustomEmailSenderLambdaVersionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomEmailLambdaVersionConfigType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomEmailLambdaVersionConfigType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomEmailLambdaVersionConfigType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomEmailLambdaVersionConfigType"}
	if s.LambdaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LambdaArn"))
	}
	if s.LambdaArn != nil && len(*s.LambdaArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaArn", 20))
	}
	if s.LambdaVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("LambdaVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLambdaArn sets the LambdaArn field's value.
func (s *CustomEmailLambdaVersionConfigType) SetLambdaArn(v string) *CustomEmailLambdaVersionConfigType {
	s.LambdaArn = &v
	return s
}

// SetLambdaVersion sets the LambdaVersion field's value.
func (s *CustomEmailLambdaVersionConfigType) SetLambdaVersion(v string) *CustomEmailLambdaVersionConfigType {
	s.LambdaVersion = &v
	return s
}

// A custom SMS sender Lambda configuration type.
type CustomSMSLambdaVersionConfigType struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Lambda function that Amazon Cognito
	// activates to send SMS notifications to users.
	//
	// LambdaArn is a required field
	LambdaArn *string `min:"20" type:"string" required:"true"`

	// Signature of the "request" attribute in the "event" information that Amazon
	// Cognito passes to your custom SMS Lambda function. The only supported value
	// is V1_0.
	//
	// LambdaVersion is a required field
	LambdaVersion *string `type:"string" required:"true" enum:"CustomSMSSenderLambdaVersionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomSMSLambdaVersionConfigType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomSMSLambdaVersionConfigType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomSMSLambdaVersionConfigType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomSMSLambdaVersionConfigType"}
	if s.LambdaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LambdaArn"))
	}
	if s.LambdaArn != nil && len(*s.LambdaArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaArn", 20))
	}
	if s.LambdaVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("LambdaVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLambdaArn sets the LambdaArn field's value.
func (s *CustomSMSLambdaVersionConfigType) SetLambdaArn(v string) *CustomSMSLambdaVersionConfigType {
	s.LambdaArn = &v
	return s
}

// SetLambdaVersion sets the LambdaVersion field's value.
func (s *CustomSMSLambdaVersionConfigType) SetLambdaVersion(v string) *CustomSMSLambdaVersionConfigType {
	s.LambdaVersion = &v
	return s
}

type DeleteGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *DeleteGroupInput) SetGroupName(v string) *DeleteGroupInput {
	s.GroupName = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DeleteGroupInput) SetUserPoolId(v string) *DeleteGroupInput {
	s.UserPoolId = &v
	return s
}

type DeleteGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupOutput) GoString() string {
	return s.String()
}

type DeleteIdentityProviderInput struct {
	_ struct{} `type:"structure"`

	// The identity provider name.
	//
	// ProviderName is a required field
	ProviderName *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentityProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIdentityProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIdentityProviderInput"}
	if s.ProviderName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderName"))
	}
	if s.ProviderName != nil && len(*s.ProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderName", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProviderName sets the ProviderName field's value.
func (s *DeleteIdentityProviderInput) SetProviderName(v string) *DeleteIdentityProviderInput {
	s.ProviderName = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DeleteIdentityProviderInput) SetUserPoolId(v string) *DeleteIdentityProviderInput {
	s.UserPoolId = &v
	return s
}

type DeleteIdentityProviderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentityProviderOutput) GoString() string {
	return s.String()
}

type DeleteResourceServerInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the resource server.
	//
	// Identifier is a required field
	Identifier *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool that hosts the resource server.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourceServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourceServerInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteResourceServerInput) SetIdentifier(v string) *DeleteResourceServerInput {
	s.Identifier = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DeleteResourceServerInput) SetUserPoolId(v string) *DeleteResourceServerInput {
	s.UserPoolId = &v
	return s
}

type DeleteResourceServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceServerOutput) GoString() string {
	return s.String()
}

// Represents the request to delete user attributes.
type DeleteUserAttributesInput struct {
	_ struct{} `type:"structure"`

	// The access token used in the request to delete user attributes.
	//
	// AccessToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DeleteUserAttributesInput's
	// String and GoString methods.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true" sensitive:"true"`

	// An array of strings representing the user attribute names you want to delete.
	//
	// For custom attributes, you must prependattach the custom: prefix to the front
	// of the attribute name.
	//
	// UserAttributeNames is a required field
	UserAttributeNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserAttributesInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}
	if s.UserAttributeNames == nil {
		invalidParams.Add(request.NewErrParamRequired("UserAttributeNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *DeleteUserAttributesInput) SetAccessToken(v string) *DeleteUserAttributesInput {
	s.AccessToken = &v
	return s
}

// SetUserAttributeNames sets the UserAttributeNames field's value.
func (s *DeleteUserAttributesInput) SetUserAttributeNames(v []*string) *DeleteUserAttributesInput {
	s.UserAttributeNames = v
	return s
}

// Represents the response from the server to delete user attributes.
type DeleteUserAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserAttributesOutput) GoString() string {
	return s.String()
}

// Represents the request to delete a user.
type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// The access token from a request to delete a user.
	//
	// AccessToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DeleteUserInput's
	// String and GoString methods.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *DeleteUserInput) SetAccessToken(v string) *DeleteUserInput {
	s.AccessToken = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

// Represents the request to delete a user pool client.
type DeleteUserPoolClientInput struct {
	_ struct{} `type:"structure"`

	// The app client ID of the app associated with the user pool.
	//
	// ClientId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DeleteUserPoolClientInput's
	// String and GoString methods.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The user pool ID for the user pool where you want to delete the client.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserPoolClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserPoolClientInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserPoolClientInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserPoolClientInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientId sets the ClientId field's value.
func (s *DeleteUserPoolClientInput) SetClientId(v string) *DeleteUserPoolClientInput {
	s.ClientId = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DeleteUserPoolClientInput) SetUserPoolId(v string) *DeleteUserPoolClientInput {
	s.UserPoolId = &v
	return s
}

type DeleteUserPoolClientOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserPoolClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserPoolClientOutput) GoString() string {
	return s.String()
}

type DeleteUserPoolDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain string. For custom domains, this is the fully-qualified domain
	// name, such as auth.example.com. For Amazon Cognito prefix domains, this is
	// the prefix alone, such as auth.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserPoolDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserPoolDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserPoolDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserPoolDomainInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DeleteUserPoolDomainInput) SetDomain(v string) *DeleteUserPoolDomainInput {
	s.Domain = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DeleteUserPoolDomainInput) SetUserPoolId(v string) *DeleteUserPoolDomainInput {
	s.UserPoolId = &v
	return s
}

type DeleteUserPoolDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserPoolDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserPoolDomainOutput) GoString() string {
	return s.String()
}

// Represents the request to delete a user pool.
type DeleteUserPoolInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool you want to delete.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserPoolInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DeleteUserPoolInput) SetUserPoolId(v string) *DeleteUserPoolInput {
	s.UserPoolId = &v
	return s
}

type DeleteUserPoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserPoolOutput) GoString() string {
	return s.String()
}

type DescribeIdentityProviderInput struct {
	_ struct{} `type:"structure"`

	// The identity provider name.
	//
	// ProviderName is a required field
	ProviderName *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIdentityProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIdentityProviderInput"}
	if s.ProviderName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderName"))
	}
	if s.ProviderName != nil && len(*s.ProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderName", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProviderName sets the ProviderName field's value.
func (s *DescribeIdentityProviderInput) SetProviderName(v string) *DescribeIdentityProviderInput {
	s.ProviderName = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DescribeIdentityProviderInput) SetUserPoolId(v string) *DescribeIdentityProviderInput {
	s.UserPoolId = &v
	return s
}

type DescribeIdentityProviderOutput struct {
	_ struct{} `type:"structure"`

	// The identity provider that was deleted.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProviderType `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityProviderOutput) GoString() string {
	return s.String()
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *DescribeIdentityProviderOutput) SetIdentityProvider(v *IdentityProviderType) *DescribeIdentityProviderOutput {
	s.IdentityProvider = v
	return s
}

type DescribeResourceServerInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the resource server
	//
	// Identifier is a required field
	Identifier *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool that hosts the resource server.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourceServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourceServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourceServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeResourceServerInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *DescribeResourceServerInput) SetIdentifier(v string) *DescribeResourceServerInput {
	s.Identifier = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DescribeResourceServerInput) SetUserPoolId(v string) *DescribeResourceServerInput {
	s.UserPoolId = &v
	return s
}

type DescribeResourceServerOutput struct {
	_ struct{} `type:"structure"`

	// The resource server.
	//
	// ResourceServer is a required field
	ResourceServer *ResourceServerType `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourceServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourceServerOutput) GoString() string {
	return s.String()
}

// SetResourceServer sets the ResourceServer field's value.
func (s *DescribeResourceServerOutput) SetResourceServer(v *ResourceServerType) *DescribeResourceServerOutput {
	s.ResourceServer = v
	return s
}

type DescribeRiskConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The app client ID.
	//
	// ClientId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribeRiskConfigurationInput's
	// String and GoString methods.
	ClientId *string `min:"1" type:"string" sensitive:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRiskConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRiskConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRiskConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRiskConfigurationInput"}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientId sets the ClientId field's value.
func (s *DescribeRiskConfigurationInput) SetClientId(v string) *DescribeRiskConfigurationInput {
	s.ClientId = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DescribeRiskConfigurationInput) SetUserPoolId(v string) *DescribeRiskConfigurationInput {
	s.UserPoolId = &v
	return s
}

type DescribeRiskConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The risk configuration.
	//
	// RiskConfiguration is a required field
	RiskConfiguration *RiskConfigurationType `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRiskConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRiskConfigurationOutput) GoString() string {
	return s.String()
}

// SetRiskConfiguration sets the RiskConfiguration field's value.
func (s *DescribeRiskConfigurationOutput) SetRiskConfiguration(v *RiskConfigurationType) *DescribeRiskConfigurationOutput {
	s.RiskConfiguration = v
	return s
}

// Represents the request to describe the user import job.
type DescribeUserImportJobInput struct {
	_ struct{} `type:"structure"`

	// The job ID for the user import job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool that the users are being imported into.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserImportJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeUserImportJobInput) SetJobId(v string) *DescribeUserImportJobInput {
	s.JobId = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DescribeUserImportJobInput) SetUserPoolId(v string) *DescribeUserImportJobInput {
	s.UserPoolId = &v
	return s
}

// Represents the response from the server to the request to describe the user
// import job.
type DescribeUserImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The job object that represents the user import job.
	UserImportJob *UserImportJobType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserImportJobOutput) GoString() string {
	return s.String()
}

// SetUserImportJob sets the UserImportJob field's value.
func (s *DescribeUserImportJobOutput) SetUserImportJob(v *UserImportJobType) *DescribeUserImportJobOutput {
	s.UserImportJob = v
	return s
}

// Represents the request to describe a user pool client.
type DescribeUserPoolClientInput struct {
	_ struct{} `type:"structure"`

	// The app client ID of the app associated with the user pool.
	//
	// ClientId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribeUserPoolClientInput's
	// String and GoString methods.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The user pool ID for the user pool you want to describe.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserPoolClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserPoolClientInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserPoolClientInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserPoolClientInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientId sets the ClientId field's value.
func (s *DescribeUserPoolClientInput) SetClientId(v string) *DescribeUserPoolClientInput {
	s.ClientId = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DescribeUserPoolClientInput) SetUserPoolId(v string) *DescribeUserPoolClientInput {
	s.UserPoolId = &v
	return s
}

// Represents the response from the server from a request to describe the user
// pool client.
type DescribeUserPoolClientOutput struct {
	_ struct{} `type:"structure"`

	// The user pool client from a server response to describe the user pool client.
	UserPoolClient *UserPoolClientType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserPoolClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserPoolClientOutput) GoString() string {
	return s.String()
}

// SetUserPoolClient sets the UserPoolClient field's value.
func (s *DescribeUserPoolClientOutput) SetUserPoolClient(v *UserPoolClientType) *DescribeUserPoolClientOutput {
	s.UserPoolClient = v
	return s
}

type DescribeUserPoolDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain string. For custom domains, this is the fully-qualified domain
	// name, such as auth.example.com. For Amazon Cognito prefix domains, this is
	// the prefix alone, such as auth.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserPoolDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserPoolDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserPoolDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserPoolDomainInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DescribeUserPoolDomainInput) SetDomain(v string) *DescribeUserPoolDomainInput {
	s.Domain = &v
	return s
}

type DescribeUserPoolDomainOutput struct {
	_ struct{} `type:"structure"`

	// A domain description object containing information about the domain.
	DomainDescription *DomainDescriptionType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserPoolDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserPoolDomainOutput) GoString() string {
	return s.String()
}

// SetDomainDescription sets the DomainDescription field's value.
func (s *DescribeUserPoolDomainOutput) SetDomainDescription(v *DomainDescriptionType) *DescribeUserPoolDomainOutput {
	s.DomainDescription = v
	return s
}

// Represents the request to describe the user pool.
type DescribeUserPoolInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool you want to describe.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserPoolInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DescribeUserPoolInput) SetUserPoolId(v string) *DescribeUserPoolInput {
	s.UserPoolId = &v
	return s
}

// Represents the response to describe the user pool.
type DescribeUserPoolOutput struct {
	_ struct{} `type:"structure"`

	// The container of metadata returned by the server to describe the pool.
	UserPool *UserPoolType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserPoolOutput) GoString() string {
	return s.String()
}

// SetUserPool sets the UserPool field's value.
func (s *DescribeUserPoolOutput) SetUserPool(v *UserPoolType) *DescribeUserPoolOutput {
	s.UserPool = v
	return s
}

// The device tracking configuration for a user pool. A user pool with device
// tracking deactivated returns a null value.
//
// When you provide values for any DeviceConfiguration field, you activate device
// tracking.
type DeviceConfigurationType struct {
	_ struct{} `type:"structure"`

	// When true, device authentication can replace SMS and time-based one-time
	// password (TOTP) factors for multi-factor authentication (MFA).
	//
	// Users that sign in with devices that have not been confirmed or remembered
	// will still have to provide a second factor, whether or not ChallengeRequiredOnNewDevice
	// is true, when your user pool requires MFA.
	ChallengeRequiredOnNewDevice *bool `type:"boolean"`

	// When true, users can opt in to remembering their device. Your app code must
	// use callback functions to return the user's choice.
	DeviceOnlyRememberedOnUserPrompt *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceConfigurationType) GoString() string {
	return s.String()
}

// SetChallengeRequiredOnNewDevice sets the ChallengeRequiredOnNewDevice field's value.
func (s *DeviceConfigurationType) SetChallengeRequiredOnNewDevice(v bool) *DeviceConfigurationType {
	s.ChallengeRequiredOnNewDevice = &v
	return s
}

// SetDeviceOnlyRememberedOnUserPrompt sets the DeviceOnlyRememberedOnUserPrompt field's value.
func (s *DeviceConfigurationType) SetDeviceOnlyRememberedOnUserPrompt(v bool) *DeviceConfigurationType {
	s.DeviceOnlyRememberedOnUserPrompt = &v
	return s
}

// The device verifier against which it is authenticated.
type DeviceSecretVerifierConfigType struct {
	_ struct{} `type:"structure"`

	// The password verifier.
	PasswordVerifier *string `type:"string"`

	// The salt.
	Salt *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceSecretVerifierConfigType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceSecretVerifierConfigType) GoString() string {
	return s.String()
}

// SetPasswordVerifier sets the PasswordVerifier field's value.
func (s *DeviceSecretVerifierConfigType) SetPasswordVerifier(v string) *DeviceSecretVerifierConfigType {
	s.PasswordVerifier = &v
	return s
}

// SetSalt sets the Salt field's value.
func (s *DeviceSecretVerifierConfigType) SetSalt(v string) *DeviceSecretVerifierConfigType {
	s.Salt = &v
	return s
}

// The device type.
type DeviceType struct {
	_ struct{} `type:"structure"`

	// The device attributes.
	DeviceAttributes []*AttributeType `type:"list"`

	// The creation date of the device.
	DeviceCreateDate *time.Time `type:"timestamp"`

	// The device key.
	DeviceKey *string `min:"1" type:"string"`

	// The date when the device was last authenticated.
	DeviceLastAuthenticatedDate *time.Time `type:"timestamp"`

	// The last modified date of the device.
	DeviceLastModifiedDate *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceType) GoString() string {
	return s.String()
}

// SetDeviceAttributes sets the DeviceAttributes field's value.
func (s *DeviceType) SetDeviceAttributes(v []*AttributeType) *DeviceType {
	s.DeviceAttributes = v
	return s
}

// SetDeviceCreateDate sets the DeviceCreateDate field's value.
func (s *DeviceType) SetDeviceCreateDate(v time.Time) *DeviceType {
	s.DeviceCreateDate = &v
	return s
}

// SetDeviceKey sets the DeviceKey field's value.
func (s *DeviceType) SetDeviceKey(v string) *DeviceType {
	s.DeviceKey = &v
	return s
}

// SetDeviceLastAuthenticatedDate sets the DeviceLastAuthenticatedDate field's value.
func (s *DeviceType) SetDeviceLastAuthenticatedDate(v time.Time) *DeviceType {
	s.DeviceLastAuthenticatedDate = &v
	return s
}

// SetDeviceLastModifiedDate sets the DeviceLastModifiedDate field's value.
func (s *DeviceType) SetDeviceLastModifiedDate(v time.Time) *DeviceType {
	s.DeviceLastModifiedDate = &v
	return s
}

// A container for information about a domain.
type DomainDescriptionType struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services ID for the user pool owner.
	AWSAccountId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon CloudFront distribution.
	CloudFrontDistribution *string `type:"string"`

	// The configuration for a custom domain that hosts the sign-up and sign-in
	// webpages for your application.
	CustomDomainConfig *CustomDomainConfigType `type:"structure"`

	// The domain string. For custom domains, this is the fully-qualified domain
	// name, such as auth.example.com. For Amazon Cognito prefix domains, this is
	// the prefix alone, such as auth.
	Domain *string `min:"1" type:"string"`

	// The Amazon S3 bucket where the static files for this domain are stored.
	S3Bucket *string `min:"3" type:"string"`

	// The domain status.
	Status *string `type:"string" enum:"DomainStatusType"`

	// The user pool ID.
	UserPoolId *string `min:"1" type:"string"`

	// The app version.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainDescriptionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainDescriptionType) GoString() string {
	return s.String()
}

// SetAWSAccountId sets the AWSAccountId field's value.
func (s *DomainDescriptionType) SetAWSAccountId(v string) *DomainDescriptionType {
	s.AWSAccountId = &v
	return s
}

// SetCloudFrontDistribution sets the CloudFrontDistribution field's value.
func (s *DomainDescriptionType) SetCloudFrontDistribution(v string) *DomainDescriptionType {
	s.CloudFrontDistribution = &v
	return s
}

// SetCustomDomainConfig sets the CustomDomainConfig field's value.
func (s *DomainDescriptionType) SetCustomDomainConfig(v *CustomDomainConfigType) *DomainDescriptionType {
	s.CustomDomainConfig = v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DomainDescriptionType) SetDomain(v string) *DomainDescriptionType {
	s.Domain = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *DomainDescriptionType) SetS3Bucket(v string) *DomainDescriptionType {
	s.S3Bucket = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DomainDescriptionType) SetStatus(v string) *DomainDescriptionType {
	s.Status = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *DomainDescriptionType) SetUserPoolId(v string) *DomainDescriptionType {
	s.UserPoolId = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *DomainDescriptionType) SetVersion(v string) *DomainDescriptionType {
	s.Version = &v
	return s
}

// This exception is thrown when the provider is already supported by the user
// pool.
type DuplicateProviderException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DuplicateProviderException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DuplicateProviderException) GoString() string {
	return s.String()
}

func newErrorDuplicateProviderException(v protocol.ResponseMetadata) error {
	return &DuplicateProviderException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DuplicateProviderException) Code() string {
	return "DuplicateProviderException"
}

// Message returns the exception's message.
func (s *DuplicateProviderException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DuplicateProviderException) OrigErr() error {
	return nil
}

func (s *DuplicateProviderException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DuplicateProviderException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DuplicateProviderException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The email configuration of your user pool. The email configuration type sets
// your preferred sending method, Amazon Web Services Region, and sender for
// messages from your user pool.
//
// Amazon Cognito can send email messages with Amazon Simple Email Service resources
// in the Amazon Web Services Region where you created your user pool, and in
// alternate Regions in some cases. For more information on the supported Regions,
// see Email settings for Amazon Cognito user pools (https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html).
type EmailConfigurationType struct {
	_ struct{} `type:"structure"`

	// The set of configuration rules that can be applied to emails sent using Amazon
	// Simple Email Service. A configuration set is applied to an email by including
	// a reference to the configuration set in the headers of the email. Once applied,
	// all of the rules in that configuration set are applied to the email. Configuration
	// sets can be used to apply the following types of rules to emails:
	//
	// Event publishing
	//
	// Amazon Simple Email Service can track the number of send, delivery, open,
	// click, bounce, and complaint events for each email sent. Use event publishing
	// to send information about these events to other Amazon Web Services services
	// such as and Amazon CloudWatch
	//
	// IP pool management
	//
	// When leasing dedicated IP addresses with Amazon Simple Email Service, you
	// can create groups of IP addresses, called dedicated IP pools. You can then
	// associate the dedicated IP pools with configuration sets.
	ConfigurationSet *string `min:"1" type:"string"`

	// Specifies whether Amazon Cognito uses its built-in functionality to send
	// your users email messages, or uses your Amazon Simple Email Service email
	// configuration. Specify one of the following values:
	//
	// COGNITO_DEFAULT
	//
	// When Amazon Cognito emails your users, it uses its built-in email functionality.
	// When you use the default option, Amazon Cognito allows only a limited number
	// of emails each day for your user pool. For typical production environments,
	// the default email limit is less than the required delivery volume. To achieve
	// a higher delivery volume, specify DEVELOPER to use your Amazon SES email
	// configuration.
	//
	// To look up the email delivery limit for the default option, see Limits in
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html) in
	// the Developer Guide.
	//
	// The default FROM address is no-reply@verificationemail.com. To customize
	// the FROM address, provide the Amazon Resource Name (ARN) of an Amazon SES
	// verified email address for the SourceArn parameter.
	//
	// If EmailSendingAccount is COGNITO_DEFAULT, you can't use the following parameters:
	//
	//    * EmailVerificationMessage
	//
	//    * EmailVerificationSubject
	//
	//    * InviteMessageTemplate.EmailMessage
	//
	//    * InviteMessageTemplate.EmailSubject
	//
	//    * VerificationMessageTemplate.EmailMessage
	//
	//    * VerificationMessageTemplate.EmailMessageByLink
	//
	//    * VerificationMessageTemplate.EmailSubject,
	//
	//    * VerificationMessageTemplate.EmailSubjectByLink
	//
	// DEVELOPER EmailSendingAccount is required.
	//
	// DEVELOPER
	//
	// When Amazon Cognito emails your users, it uses your Amazon SES configuration.
	// Amazon Cognito calls Amazon SES on your behalf to send email from your verified
	// email address. When you use this option, the email delivery limits are the
	// same limits that apply to your Amazon SES verified email address in your
	// Amazon Web Services account.
	//
	// If you use this option, you must provide the ARN of an Amazon SES verified
	// email address for the SourceArn parameter.
	//
	// Before Amazon Cognito can email your users, it requires additional permissions
	// to call Amazon SES on your behalf. When you update your user pool with this
	// option, Amazon Cognito creates a service-linked role, which is a type of
	// role, in your Amazon Web Services account. This role contains the permissions
	// that allow to access Amazon SES and send email messages with your address.
	// For more information about the service-linked role that Amazon Cognito creates,
	// see Using Service-Linked Roles for Amazon Cognito (https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html)
	// in the Amazon Cognito Developer Guide.
	EmailSendingAccount *string `type:"string" enum:"EmailSendingAccountType"`

	// Either the sender’s email address or the sender’s name with their email
	// address. For example, testuser@example.com or Test User <testuser@example.com>.
	// This address appears before the body of the email.
	From *string `type:"string"`

	// The destination to which the receiver of the email should reply.
	ReplyToEmailAddress *string `type:"string"`

	// The ARN of a verified email address in Amazon SES. Amazon Cognito uses this
	// email address in one of the following ways, depending on the value that you
	// specify for the EmailSendingAccount parameter:
	//
	//    * If you specify COGNITO_DEFAULT, Amazon Cognito uses this address as
	//    the custom FROM address when it emails your users using its built-in email
	//    account.
	//
	//    * If you specify DEVELOPER, Amazon Cognito emails your users with this
	//    address by calling Amazon SES on your behalf.
	//
	// The Region value of the SourceArn parameter must indicate a supported Amazon
	// Web Services Region of your user pool. Typically, the Region in the SourceArn
	// and the user pool Region are the same. For more information, see Amazon SES
	// email configuration regions (https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html#user-pool-email-developer-region-mapping)
	// in the Amazon Cognito Developer Guide (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).
	SourceArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmailConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmailConfigurationType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EmailConfigurationType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EmailConfigurationType"}
	if s.ConfigurationSet != nil && len(*s.ConfigurationSet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSet", 1))
	}
	if s.SourceArn != nil && len(*s.SourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSet sets the ConfigurationSet field's value.
func (s *EmailConfigurationType) SetConfigurationSet(v string) *EmailConfigurationType {
	s.ConfigurationSet = &v
	return s
}

// SetEmailSendingAccount sets the EmailSendingAccount field's value.
func (s *EmailConfigurationType) SetEmailSendingAccount(v string) *EmailConfigurationType {
	s.EmailSendingAccount = &v
	return s
}

// SetFrom sets the From field's value.
func (s *EmailConfigurationType) SetFrom(v string) *EmailConfigurationType {
	s.From = &v
	return s
}

// SetReplyToEmailAddress sets the ReplyToEmailAddress field's value.
func (s *EmailConfigurationType) SetReplyToEmailAddress(v string) *EmailConfigurationType {
	s.ReplyToEmailAddress = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *EmailConfigurationType) SetSourceArn(v string) *EmailConfigurationType {
	s.SourceArn = &v
	return s
}

// This exception is thrown when there is a code mismatch and the service fails
// to configure the software token TOTP multi-factor authentication (MFA).
type EnableSoftwareTokenMFAException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableSoftwareTokenMFAException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableSoftwareTokenMFAException) GoString() string {
	return s.String()
}

func newErrorEnableSoftwareTokenMFAException(v protocol.ResponseMetadata) error {
	return &EnableSoftwareTokenMFAException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EnableSoftwareTokenMFAException) Code() string {
	return "EnableSoftwareTokenMFAException"
}

// Message returns the exception's message.
func (s *EnableSoftwareTokenMFAException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EnableSoftwareTokenMFAException) OrigErr() error {
	return nil
}

func (s *EnableSoftwareTokenMFAException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EnableSoftwareTokenMFAException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EnableSoftwareTokenMFAException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies the user context data captured at the time of an event request.
type EventContextDataType struct {
	_ struct{} `type:"structure"`

	// The user's city.
	City *string `type:"string"`

	// The user's country.
	Country *string `type:"string"`

	// The user's device name.
	DeviceName *string `type:"string"`

	// The user's IP address.
	IpAddress *string `type:"string"`

	// The user's time zone.
	Timezone *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventContextDataType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventContextDataType) GoString() string {
	return s.String()
}

// SetCity sets the City field's value.
func (s *EventContextDataType) SetCity(v string) *EventContextDataType {
	s.City = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *EventContextDataType) SetCountry(v string) *EventContextDataType {
	s.Country = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *EventContextDataType) SetDeviceName(v string) *EventContextDataType {
	s.DeviceName = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *EventContextDataType) SetIpAddress(v string) *EventContextDataType {
	s.IpAddress = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *EventContextDataType) SetTimezone(v string) *EventContextDataType {
	s.Timezone = &v
	return s
}

// Specifies the event feedback type.
type EventFeedbackType struct {
	_ struct{} `type:"structure"`

	// The event feedback date.
	FeedbackDate *time.Time `type:"timestamp"`

	// The event feedback value.
	//
	// FeedbackValue is a required field
	FeedbackValue *string `type:"string" required:"true" enum:"FeedbackValueType"`

	// The provider.
	//
	// Provider is a required field
	Provider *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventFeedbackType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventFeedbackType) GoString() string {
	return s.String()
}

// SetFeedbackDate sets the FeedbackDate field's value.
func (s *EventFeedbackType) SetFeedbackDate(v time.Time) *EventFeedbackType {
	s.FeedbackDate = &v
	return s
}

// SetFeedbackValue sets the FeedbackValue field's value.
func (s *EventFeedbackType) SetFeedbackValue(v string) *EventFeedbackType {
	s.FeedbackValue = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *EventFeedbackType) SetProvider(v string) *EventFeedbackType {
	s.Provider = &v
	return s
}

// The event risk type.
type EventRiskType struct {
	_ struct{} `type:"structure"`

	// Indicates whether compromised credentials were detected during an authentication
	// event.
	CompromisedCredentialsDetected *bool `type:"boolean"`

	// The risk decision.
	RiskDecision *string `type:"string" enum:"RiskDecisionType"`

	// The risk level.
	RiskLevel *string `type:"string" enum:"RiskLevelType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventRiskType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventRiskType) GoString() string {
	return s.String()
}

// SetCompromisedCredentialsDetected sets the CompromisedCredentialsDetected field's value.
func (s *EventRiskType) SetCompromisedCredentialsDetected(v bool) *EventRiskType {
	s.CompromisedCredentialsDetected = &v
	return s
}

// SetRiskDecision sets the RiskDecision field's value.
func (s *EventRiskType) SetRiskDecision(v string) *EventRiskType {
	s.RiskDecision = &v
	return s
}

// SetRiskLevel sets the RiskLevel field's value.
func (s *EventRiskType) SetRiskLevel(v string) *EventRiskType {
	s.RiskLevel = &v
	return s
}

// This exception is thrown if a code has expired.
type ExpiredCodeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message returned when the expired code exception is thrown.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpiredCodeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpiredCodeException) GoString() string {
	return s.String()
}

func newErrorExpiredCodeException(v protocol.ResponseMetadata) error {
	return &ExpiredCodeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ExpiredCodeException) Code() string {
	return "ExpiredCodeException"
}

// Message returns the exception's message.
func (s *ExpiredCodeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ExpiredCodeException) OrigErr() error {
	return nil
}

func (s *ExpiredCodeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ExpiredCodeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ExpiredCodeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the request to forget the device.
type ForgetDeviceInput struct {
	_ struct{} `type:"structure"`

	// The access token for the forgotten device request.
	//
	// AccessToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ForgetDeviceInput's
	// String and GoString methods.
	AccessToken *string `type:"string" sensitive:"true"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForgetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForgetDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ForgetDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ForgetDeviceInput"}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *ForgetDeviceInput) SetAccessToken(v string) *ForgetDeviceInput {
	s.AccessToken = &v
	return s
}

// SetDeviceKey sets the DeviceKey field's value.
func (s *ForgetDeviceInput) SetDeviceKey(v string) *ForgetDeviceInput {
	s.DeviceKey = &v
	return s
}

type ForgetDeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForgetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForgetDeviceOutput) GoString() string {
	return s.String()
}

// Represents the request to reset a user's password.
type ForgotPasswordInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Pinpoint analytics metadata for collecting metrics for ForgotPassword
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The ID of the client associated with the user pool.
	//
	// ClientId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ForgotPasswordInput's
	// String and GoString methods.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// A map of custom key-value pairs that you can provide as input for any custom
	// workflows that this action triggers.
	//
	// You create custom workflows by assigning Lambda functions to user pool triggers.
	// When you use the ForgotPassword API action, Amazon Cognito invokes any functions
	// that are assigned to the following triggers: pre sign-up, custom message,
	// and user migration. When Amazon Cognito invokes any of these functions, it
	// passes a JSON payload, which the function receives as input. This payload
	// contains a clientMetadata attribute, which provides the data that you assigned
	// to the ClientMetadata parameter in your ForgotPassword request. In your function
	// code in Lambda, you can process the clientMetadata value to enhance your
	// workflow for your specific needs.
	//
	// For more information, see Customizing user pool Workflows with Lambda Triggers
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
	// in the Amazon Cognito Developer Guide.
	//
	// When you use the ClientMetadata parameter, remember that Amazon Cognito won't
	// do the following:
	//
	//    * Store the ClientMetadata value. This data is available only to Lambda
	//    triggers that are assigned to a user pool to support custom workflows.
	//    If your user pool configuration doesn't include triggers, the ClientMetadata
	//    parameter serves no purpose.
	//
	//    * Validate the ClientMetadata value.
	//
	//    * Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide
	//    sensitive information.
	ClientMetadata map[string]*string `type:"map"`

	// A keyed-hash message authentication code (HMAC) calculated using the secret
	// key of a user pool client and username plus the client ID in the message.
	//
	// SecretHash is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ForgotPasswordInput's
	// String and GoString methods.
	SecretHash *string `min:"1" type:"string" sensitive:"true"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	UserContextData *UserContextDataType `type:"structure"`

	// The user name of the user for whom you want to enter a code to reset a forgotten
	// password.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ForgotPasswordInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForgotPasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForgotPasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ForgotPasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ForgotPasswordInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.SecretHash != nil && len(*s.SecretHash) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretHash", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyticsMetadata sets the AnalyticsMetadata field's value.
func (s *ForgotPasswordInput) SetAnalyticsMetadata(v *AnalyticsMetadataType) *ForgotPasswordInput {
	s.AnalyticsMetadata = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *ForgotPasswordInput) SetClientId(v string) *ForgotPasswordInput {
	s.ClientId = &v
	return s
}

// SetClientMetadata sets the ClientMetadata field's value.
func (s *ForgotPasswordInput) SetClientMetadata(v map[string]*string) *ForgotPasswordInput {
	s.ClientMetadata = v
	return s
}

// SetSecretHash sets the SecretHash field's value.
func (s *ForgotPasswordInput) SetSecretHash(v string) *ForgotPasswordInput {
	s.SecretHash = &v
	return s
}

// SetUserContextData sets the UserContextData field's value.
func (s *ForgotPasswordInput) SetUserContextData(v *UserContextDataType) *ForgotPasswordInput {
	s.UserContextData = v
	return s
}

// SetUsername sets the Username field's value.
func (s *ForgotPasswordInput) SetUsername(v string) *ForgotPasswordInput {
	s.Username = &v
	return s
}

// Respresents the response from the server regarding the request to reset a
// password.
type ForgotPasswordOutput struct {
	_ struct{} `type:"structure"`

	// The code delivery details returned by the server in response to the request
	// to reset a password.
	CodeDeliveryDetails *CodeDeliveryDetailsType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForgotPasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForgotPasswordOutput) GoString() string {
	return s.String()
}

// SetCodeDeliveryDetails sets the CodeDeliveryDetails field's value.
func (s *ForgotPasswordOutput) SetCodeDeliveryDetails(v *CodeDeliveryDetailsType) *ForgotPasswordOutput {
	s.CodeDeliveryDetails = v
	return s
}

// Represents the request to get the header information of the CSV file for
// the user import job.
type GetCSVHeaderInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool that the users are to be imported into.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCSVHeaderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCSVHeaderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCSVHeaderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCSVHeaderInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *GetCSVHeaderInput) SetUserPoolId(v string) *GetCSVHeaderInput {
	s.UserPoolId = &v
	return s
}

// Represents the response from the server to the request to get the header
// information of the CSV file for the user import job.
type GetCSVHeaderOutput struct {
	_ struct{} `type:"structure"`

	// The header information of the CSV file for the user import job.
	CSVHeader []*string `type:"list"`

	// The user pool ID for the user pool that the users are to be imported into.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCSVHeaderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCSVHeaderOutput) GoString() string {
	return s.String()
}

// SetCSVHeader sets the CSVHeader field's value.
func (s *GetCSVHeaderOutput) SetCSVHeader(v []*string) *GetCSVHeaderOutput {
	s.CSVHeader = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *GetCSVHeaderOutput) SetUserPoolId(v string) *GetCSVHeaderOutput {
	s.UserPoolId = &v
	return s
}

// Represents the request to get the device.
type GetDeviceInput struct {
	_ struct{} `type:"structure"`

	// The access token.
	//
	// AccessToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetDeviceInput's
	// String and GoString methods.
	AccessToken *string `type:"string" sensitive:"true"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeviceInput"}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *GetDeviceInput) SetAccessToken(v string) *GetDeviceInput {
	s.AccessToken = &v
	return s
}

// SetDeviceKey sets the DeviceKey field's value.
func (s *GetDeviceInput) SetDeviceKey(v string) *GetDeviceInput {
	s.DeviceKey = &v
	return s
}

// Gets the device response.
type GetDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The device.
	//
	// Device is a required field
	Device *DeviceType `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceOutput) GoString() string {
	return s.String()
}

// SetDevice sets the Device field's value.
func (s *GetDeviceOutput) SetDevice(v *DeviceType) *GetDeviceOutput {
	s.Device = v
	return s
}

type GetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *GetGroupInput) SetGroupName(v string) *GetGroupInput {
	s.GroupName = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *GetGroupInput) SetUserPoolId(v string) *GetGroupInput {
	s.UserPoolId = &v
	return s
}

type GetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The group object for the group.
	Group *GroupType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *GetGroupOutput) SetGroup(v *GroupType) *GetGroupOutput {
	s.Group = v
	return s
}

type GetIdentityProviderByIdentifierInput struct {
	_ struct{} `type:"structure"`

	// The identity provider ID.
	//
	// IdpIdentifier is a required field
	IdpIdentifier *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityProviderByIdentifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityProviderByIdentifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityProviderByIdentifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdentityProviderByIdentifierInput"}
	if s.IdpIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IdpIdentifier"))
	}
	if s.IdpIdentifier != nil && len(*s.IdpIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdpIdentifier", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdpIdentifier sets the IdpIdentifier field's value.
func (s *GetIdentityProviderByIdentifierInput) SetIdpIdentifier(v string) *GetIdentityProviderByIdentifierInput {
	s.IdpIdentifier = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *GetIdentityProviderByIdentifierInput) SetUserPoolId(v string) *GetIdentityProviderByIdentifierInput {
	s.UserPoolId = &v
	return s
}

type GetIdentityProviderByIdentifierOutput struct {
	_ struct{} `type:"structure"`

	// The identity provider object.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProviderType `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityProviderByIdentifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityProviderByIdentifierOutput) GoString() string {
	return s.String()
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *GetIdentityProviderByIdentifierOutput) SetIdentityProvider(v *IdentityProviderType) *GetIdentityProviderByIdentifierOutput {
	s.IdentityProvider = v
	return s
}

// Request to get a signing certificate from Amazon Cognito.
type GetSigningCertificateInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSigningCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSigningCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSigningCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSigningCertificateInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *GetSigningCertificateInput) SetUserPoolId(v string) *GetSigningCertificateInput {
	s.UserPoolId = &v
	return s
}

// Response from Amazon Cognito for a signing certificate request.
type GetSigningCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The signing certificate.
	Certificate *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSigningCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSigningCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *GetSigningCertificateOutput) SetCertificate(v string) *GetSigningCertificateOutput {
	s.Certificate = &v
	return s
}

type GetUICustomizationInput struct {
	_ struct{} `type:"structure"`

	// The client ID for the client app.
	//
	// ClientId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetUICustomizationInput's
	// String and GoString methods.
	ClientId *string `min:"1" type:"string" sensitive:"true"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUICustomizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUICustomizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUICustomizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUICustomizationInput"}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientId sets the ClientId field's value.
func (s *GetUICustomizationInput) SetClientId(v string) *GetUICustomizationInput {
	s.ClientId = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *GetUICustomizationInput) SetUserPoolId(v string) *GetUICustomizationInput {
	s.UserPoolId = &v
	return s
}

type GetUICustomizationOutput struct {
	_ struct{} `type:"structure"`

	// The UI customization information.
	//
	// UICustomization is a required field
	UICustomization *UICustomizationType `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUICustomizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUICustomizationOutput) GoString() string {
	return s.String()
}

// SetUICustomization sets the UICustomization field's value.
func (s *GetUICustomizationOutput) SetUICustomization(v *UICustomizationType) *GetUICustomizationOutput {
	s.UICustomization = v
	return s
}

// Represents the request to get user attribute verification.
type GetUserAttributeVerificationCodeInput struct {
	_ struct{} `type:"structure"`

	// The access token returned by the server response to get the user attribute
	// verification code.
	//
	// AccessToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetUserAttributeVerificationCodeInput's
	// String and GoString methods.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true" sensitive:"true"`

	// The attribute name returned by the server response to get the user attribute
	// verification code.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// A map of custom key-value pairs that you can provide as input for any custom
	// workflows that this action triggers.
	//
	// You create custom workflows by assigning Lambda functions to user pool triggers.
	// When you use the GetUserAttributeVerificationCode API action, Amazon Cognito
	// invokes the function that is assigned to the custom message trigger. When
	// Amazon Cognito invokes this function, it passes a JSON payload, which the
	// function receives as input. This payload contains a clientMetadata attribute,
	// which provides the data that you assigned to the ClientMetadata parameter
	// in your GetUserAttributeVerificationCode request. In your function code in
	// Lambda, you can process the clientMetadata value to enhance your workflow
	// for your specific needs.
	//
	// For more information, see Customizing user pool Workflows with Lambda Triggers
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
	// in the Amazon Cognito Developer Guide.
	//
	// When you use the ClientMetadata parameter, remember that Amazon Cognito won't
	// do the following:
	//
	//    * Store the ClientMetadata value. This data is available only to Lambda
	//    triggers that are assigned to a user pool to support custom workflows.
	//    If your user pool configuration doesn't include triggers, the ClientMetadata
	//    parameter serves no purpose.
	//
	//    * Validate the ClientMetadata value.
	//
	//    * Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide
	//    sensitive information.
	ClientMetadata map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserAttributeVerificationCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserAttributeVerificationCodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserAttributeVerificationCodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserAttributeVerificationCodeInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *GetUserAttributeVerificationCodeInput) SetAccessToken(v string) *GetUserAttributeVerificationCodeInput {
	s.AccessToken = &v
	return s
}

// SetAttributeName sets the AttributeName field's value.
func (s *GetUserAttributeVerificationCodeInput) SetAttributeName(v string) *GetUserAttributeVerificationCodeInput {
	s.AttributeName = &v
	return s
}

// SetClientMetadata sets the ClientMetadata field's value.
func (s *GetUserAttributeVerificationCodeInput) SetClientMetadata(v map[string]*string) *GetUserAttributeVerificationCodeInput {
	s.ClientMetadata = v
	return s
}

// The verification code response returned by the server response to get the
// user attribute verification code.
type GetUserAttributeVerificationCodeOutput struct {
	_ struct{} `type:"structure"`

	// The code delivery details returned by the server in response to the request
	// to get the user attribute verification code.
	CodeDeliveryDetails *CodeDeliveryDetailsType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserAttributeVerificationCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserAttributeVerificationCodeOutput) GoString() string {
	return s.String()
}

// SetCodeDeliveryDetails sets the CodeDeliveryDetails field's value.
func (s *GetUserAttributeVerificationCodeOutput) SetCodeDeliveryDetails(v *CodeDeliveryDetailsType) *GetUserAttributeVerificationCodeOutput {
	s.CodeDeliveryDetails = v
	return s
}

// Represents the request to get information about the user.
type GetUserInput struct {
	_ struct{} `type:"structure"`

	// The access token returned by the server response to get information about
	// the user.
	//
	// AccessToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetUserInput's
	// String and GoString methods.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *GetUserInput) SetAccessToken(v string) *GetUserInput {
	s.AccessToken = &v
	return s
}

// Represents the response from the server from the request to get information
// about the user.
type GetUserOutput struct {
	_ struct{} `type:"structure"`

	// This response parameter is no longer supported. It provides information only
	// about SMS MFA configurations. It doesn't provide information about time-based
	// one-time password (TOTP) software token MFA configurations. To look up information
	// about either type of MFA configuration, use UserMFASettingList instead.
	MFAOptions []*MFAOptionType `type:"list"`

	// The user's preferred MFA setting.
	PreferredMfaSetting *string `type:"string"`

	// An array of name-value pairs representing user attributes.
	//
	// For custom attributes, you must prepend the custom: prefix to the attribute
	// name.
	//
	// UserAttributes is a required field
	UserAttributes []*AttributeType `type:"list" required:"true"`

	// The MFA options that are activated for the user. The possible values in this
	// list are SMS_MFA and SOFTWARE_TOKEN_MFA.
	UserMFASettingList []*string `type:"list"`

	// The user name of the user you want to retrieve from the get user request.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetUserOutput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserOutput) GoString() string {
	return s.String()
}

// SetMFAOptions sets the MFAOptions field's value.
func (s *GetUserOutput) SetMFAOptions(v []*MFAOptionType) *GetUserOutput {
	s.MFAOptions = v
	return s
}

// SetPreferredMfaSetting sets the PreferredMfaSetting field's value.
func (s *GetUserOutput) SetPreferredMfaSetting(v string) *GetUserOutput {
	s.PreferredMfaSetting = &v
	return s
}

// SetUserAttributes sets the UserAttributes field's value.
func (s *GetUserOutput) SetUserAttributes(v []*AttributeType) *GetUserOutput {
	s.UserAttributes = v
	return s
}

// SetUserMFASettingList sets the UserMFASettingList field's value.
func (s *GetUserOutput) SetUserMFASettingList(v []*string) *GetUserOutput {
	s.UserMFASettingList = v
	return s
}

// SetUsername sets the Username field's value.
func (s *GetUserOutput) SetUsername(v string) *GetUserOutput {
	s.Username = &v
	return s
}

type GetUserPoolMfaConfigInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserPoolMfaConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserPoolMfaConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserPoolMfaConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserPoolMfaConfigInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *GetUserPoolMfaConfigInput) SetUserPoolId(v string) *GetUserPoolMfaConfigInput {
	s.UserPoolId = &v
	return s
}

type GetUserPoolMfaConfigOutput struct {
	_ struct{} `type:"structure"`

	// The multi-factor (MFA) configuration. Valid values include:
	//
	//    * OFF MFA won't be used for any users.
	//
	//    * ON MFA is required for all users to sign in.
	//
	//    * OPTIONAL MFA will be required only for individual users who have an
	//    MFA factor activated.
	MfaConfiguration *string `type:"string" enum:"UserPoolMfaType"`

	// The SMS text message multi-factor (MFA) configuration.
	SmsMfaConfiguration *SmsMfaConfigType `type:"structure"`

	// The software token multi-factor (MFA) configuration.
	SoftwareTokenMfaConfiguration *SoftwareTokenMfaConfigType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserPoolMfaConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserPoolMfaConfigOutput) GoString() string {
	return s.String()
}

// SetMfaConfiguration sets the MfaConfiguration field's value.
func (s *GetUserPoolMfaConfigOutput) SetMfaConfiguration(v string) *GetUserPoolMfaConfigOutput {
	s.MfaConfiguration = &v
	return s
}

// SetSmsMfaConfiguration sets the SmsMfaConfiguration field's value.
func (s *GetUserPoolMfaConfigOutput) SetSmsMfaConfiguration(v *SmsMfaConfigType) *GetUserPoolMfaConfigOutput {
	s.SmsMfaConfiguration = v
	return s
}

// SetSoftwareTokenMfaConfiguration sets the SoftwareTokenMfaConfiguration field's value.
func (s *GetUserPoolMfaConfigOutput) SetSoftwareTokenMfaConfiguration(v *SoftwareTokenMfaConfigType) *GetUserPoolMfaConfigOutput {
	s.SoftwareTokenMfaConfiguration = v
	return s
}

// Represents the request to sign out all devices.
type GlobalSignOutInput struct {
	_ struct{} `type:"structure"`

	// The access token.
	//
	// AccessToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GlobalSignOutInput's
	// String and GoString methods.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlobalSignOutInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlobalSignOutInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlobalSignOutInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GlobalSignOutInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *GlobalSignOutInput) SetAccessToken(v string) *GlobalSignOutInput {
	s.AccessToken = &v
	return s
}

// The response to the request to sign out all devices.
type GlobalSignOutOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlobalSignOutOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlobalSignOutOutput) GoString() string {
	return s.String()
}

// This exception is thrown when Amazon Cognito encounters a group that already
// exists in the user pool.
type GroupExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupExistsException) GoString() string {
	return s.String()
}

func newErrorGroupExistsException(v protocol.ResponseMetadata) error {
	return &GroupExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *GroupExistsException) Code() string {
	return "GroupExistsException"
}

// Message returns the exception's message.
func (s *GroupExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *GroupExistsException) OrigErr() error {
	return nil
}

func (s *GroupExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *GroupExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *GroupExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The group type.
type GroupType struct {
	_ struct{} `type:"structure"`

	// The date the group was created.
	CreationDate *time.Time `type:"timestamp"`

	// A string containing the description of the group.
	Description *string `type:"string"`

	// The name of the group.
	GroupName *string `min:"1" type:"string"`

	// The date the group was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// A non-negative integer value that specifies the precedence of this group
	// relative to the other groups that a user can belong to in the user pool.
	// Zero is the highest precedence value. Groups with lower Precedence values
	// take precedence over groups with higher ornull Precedence values. If a user
	// belongs to two or more groups, it is the group with the lowest precedence
	// value whose role ARN is given in the user's tokens for the cognito:roles
	// and cognito:preferred_role claims.
	//
	// Two groups can have the same Precedence value. If this happens, neither group
	// takes precedence over the other. If two groups with the same Precedence have
	// the same role ARN, that role is used in the cognito:preferred_role claim
	// in tokens for users in each group. If the two groups have different role
	// ARNs, the cognito:preferred_role claim isn't set in users' tokens.
	//
	// The default Precedence value is null.
	Precedence *int64 `type:"integer"`

	// The role Amazon Resource Name (ARN) for the group.
	RoleArn *string `min:"20" type:"string"`

	// The user pool ID for the user pool.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupType) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *GroupType) SetCreationDate(v time.Time) *GroupType {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GroupType) SetDescription(v string) *GroupType {
	s.Description = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *GroupType) SetGroupName(v string) *GroupType {
	s.GroupName = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *GroupType) SetLastModifiedDate(v time.Time) *GroupType {
	s.LastModifiedDate = &v
	return s
}

// SetPrecedence sets the Precedence field's value.
func (s *GroupType) SetPrecedence(v int64) *GroupType {
	s.Precedence = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GroupType) SetRoleArn(v string) *GroupType {
	s.RoleArn = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *GroupType) SetUserPoolId(v string) *GroupType {
	s.UserPoolId = &v
	return s
}

// The HTTP header.
type HttpHeader struct {
	_ struct{} `type:"structure"`

	// The header name.
	HeaderName *string `locationName:"headerName" type:"string"`

	// The header value.
	HeaderValue *string `locationName:"headerValue" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpHeader) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpHeader) GoString() string {
	return s.String()
}

// SetHeaderName sets the HeaderName field's value.
func (s *HttpHeader) SetHeaderName(v string) *HttpHeader {
	s.HeaderName = &v
	return s
}

// SetHeaderValue sets the HeaderValue field's value.
func (s *HttpHeader) SetHeaderValue(v string) *HttpHeader {
	s.HeaderValue = &v
	return s
}

// A container for information about an identity provider.
type IdentityProviderType struct {
	_ struct{} `type:"structure"`

	// A mapping of identity provider attributes to standard and custom user pool
	// attributes.
	AttributeMapping map[string]*string `type:"map"`

	// The date the identity provider was created.
	CreationDate *time.Time `type:"timestamp"`

	// A list of identity provider identifiers.
	IdpIdentifiers []*string `type:"list"`

	// The date the identity provider was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The identity provider details. The following list describes the provider
	// detail keys for each identity provider type.
	//
	//    * For Google and Login with Amazon: client_id client_secret authorize_scopes
	//
	//    * For Facebook: client_id client_secret authorize_scopes api_version
	//
	//    * For Sign in with Apple: client_id team_id key_id private_key authorize_scopes
	//
	//    * For OIDC providers: client_id client_secret attributes_request_method
	//    oidc_issuer authorize_scopes authorize_url if not available from discovery
	//    URL specified by oidc_issuer key token_url if not available from discovery
	//    URL specified by oidc_issuer key attributes_url if not available from
	//    discovery URL specified by oidc_issuer key jwks_uri if not available from
	//    discovery URL specified by oidc_issuer key attributes_url_add_attributes
	//    a read-only property that is set automatically
	//
	//    * For SAML providers: MetadataFile or MetadataURL IDPSignOut optional
	ProviderDetails map[string]*string `type:"map"`

	// The identity provider name.
	ProviderName *string `min:"1" type:"string"`

	// The identity provider type.
	ProviderType *string `type:"string" enum:"IdentityProviderTypeType"`

	// The user pool ID.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProviderType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProviderType) GoString() string {
	return s.String()
}

// SetAttributeMapping sets the AttributeMapping field's value.
func (s *IdentityProviderType) SetAttributeMapping(v map[string]*string) *IdentityProviderType {
	s.AttributeMapping = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *IdentityProviderType) SetCreationDate(v time.Time) *IdentityProviderType {
	s.CreationDate = &v
	return s
}

// SetIdpIdentifiers sets the IdpIdentifiers field's value.
func (s *IdentityProviderType) SetIdpIdentifiers(v []*string) *IdentityProviderType {
	s.IdpIdentifiers = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *IdentityProviderType) SetLastModifiedDate(v time.Time) *IdentityProviderType {
	s.LastModifiedDate = &v
	return s
}

// SetProviderDetails sets the ProviderDetails field's value.
func (s *IdentityProviderType) SetProviderDetails(v map[string]*string) *IdentityProviderType {
	s.ProviderDetails = v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *IdentityProviderType) SetProviderName(v string) *IdentityProviderType {
	s.ProviderName = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *IdentityProviderType) SetProviderType(v string) *IdentityProviderType {
	s.ProviderType = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *IdentityProviderType) SetUserPoolId(v string) *IdentityProviderType {
	s.UserPoolId = &v
	return s
}

// Initiates the authentication request.
type InitiateAuthInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Pinpoint analytics metadata for collecting metrics for InitiateAuth
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The authentication flow for this call to run. The API action will depend
	// on this value. For example:
	//
	//    * REFRESH_TOKEN_AUTH takes in a valid refresh token and returns new tokens.
	//
	//    * USER_SRP_AUTH takes in USERNAME and SRP_A and returns the SRP variables
	//    to be used for next challenge execution.
	//
	//    * USER_PASSWORD_AUTH takes in USERNAME and PASSWORD and returns the next
	//    challenge or tokens.
	//
	// Valid values include:
	//
	//    * USER_SRP_AUTH: Authentication flow for the Secure Remote Password (SRP)
	//    protocol.
	//
	//    * REFRESH_TOKEN_AUTH/REFRESH_TOKEN: Authentication flow for refreshing
	//    the access token and ID token by supplying a valid refresh token.
	//
	//    * CUSTOM_AUTH: Custom authentication flow.
	//
	//    * USER_PASSWORD_AUTH: Non-SRP authentication flow; USERNAME and PASSWORD
	//    are passed directly. If a user migration Lambda trigger is set, this flow
	//    will invoke the user migration Lambda if it doesn't find the USERNAME
	//    in the user pool.
	//
	// ADMIN_NO_SRP_AUTH isn't a valid value.
	//
	// AuthFlow is a required field
	AuthFlow *string `type:"string" required:"true" enum:"AuthFlowType"`

	// The authentication parameters. These are inputs corresponding to the AuthFlow
	// that you're invoking. The required values depend on the value of AuthFlow:
	//
	//    * For USER_SRP_AUTH: USERNAME (required), SRP_A (required), SECRET_HASH
	//    (required if the app client is configured with a client secret), DEVICE_KEY.
	//
	//    * For REFRESH_TOKEN_AUTH/REFRESH_TOKEN: REFRESH_TOKEN (required), SECRET_HASH
	//    (required if the app client is configured with a client secret), DEVICE_KEY.
	//
	//    * For CUSTOM_AUTH: USERNAME (required), SECRET_HASH (if app client is
	//    configured with client secret), DEVICE_KEY. To start the authentication
	//    flow with password verification, include ChallengeName: SRP_A and SRP_A:
	//    (The SRP_A Value).
	//
	// AuthParameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by InitiateAuthInput's
	// String and GoString methods.
	AuthParameters map[string]*string `type:"map" sensitive:"true"`

	// The app client ID.
	//
	// ClientId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by InitiateAuthInput's
	// String and GoString methods.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// A map of custom key-value pairs that you can provide as input for certain
	// custom workflows that this action triggers.
	//
	// You create custom workflows by assigning Lambda functions to user pool triggers.
	// When you use the InitiateAuth API action, Amazon Cognito invokes the Lambda
	// functions that are specified for various triggers. The ClientMetadata value
	// is passed as input to the functions for only the following triggers:
	//
	//    * Pre signup
	//
	//    * Pre authentication
	//
	//    * User migration
	//
	// When Amazon Cognito invokes the functions for these triggers, it passes a
	// JSON payload, which the function receives as input. This payload contains
	// a validationData attribute, which provides the data that you assigned to
	// the ClientMetadata parameter in your InitiateAuth request. In your function
	// code in Lambda, you can process the validationData value to enhance your
	// workflow for your specific needs.
	//
	// When you use the InitiateAuth API action, Amazon Cognito also invokes the
	// functions for the following triggers, but it doesn't provide the ClientMetadata
	// value as input:
	//
	//    * Post authentication
	//
	//    * Custom message
	//
	//    * Pre token generation
	//
	//    * Create auth challenge
	//
	//    * Define auth challenge
	//
	//    * Verify auth challenge
	//
	// For more information, see Customizing user pool Workflows with Lambda Triggers
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
	// in the Amazon Cognito Developer Guide.
	//
	// When you use the ClientMetadata parameter, remember that Amazon Cognito won't
	// do the following:
	//
	//    * Store the ClientMetadata value. This data is available only to Lambda
	//    triggers that are assigned to a user pool to support custom workflows.
	//    If your user pool configuration doesn't include triggers, the ClientMetadata
	//    parameter serves no purpose.
	//
	//    * Validate the ClientMetadata value.
	//
	//    * Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide
	//    sensitive information.
	ClientMetadata map[string]*string `type:"map"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	UserContextData *UserContextDataType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitiateAuthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitiateAuthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InitiateAuthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InitiateAuthInput"}
	if s.AuthFlow == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthFlow"))
	}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyticsMetadata sets the AnalyticsMetadata field's value.
func (s *InitiateAuthInput) SetAnalyticsMetadata(v *AnalyticsMetadataType) *InitiateAuthInput {
	s.AnalyticsMetadata = v
	return s
}

// SetAuthFlow sets the AuthFlow field's value.
func (s *InitiateAuthInput) SetAuthFlow(v string) *InitiateAuthInput {
	s.AuthFlow = &v
	return s
}

// SetAuthParameters sets the AuthParameters field's value.
func (s *InitiateAuthInput) SetAuthParameters(v map[string]*string) *InitiateAuthInput {
	s.AuthParameters = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *InitiateAuthInput) SetClientId(v string) *InitiateAuthInput {
	s.ClientId = &v
	return s
}

// SetClientMetadata sets the ClientMetadata field's value.
func (s *InitiateAuthInput) SetClientMetadata(v map[string]*string) *InitiateAuthInput {
	s.ClientMetadata = v
	return s
}

// SetUserContextData sets the UserContextData field's value.
func (s *InitiateAuthInput) SetUserContextData(v *UserContextDataType) *InitiateAuthInput {
	s.UserContextData = v
	return s
}

// Initiates the authentication response.
type InitiateAuthOutput struct {
	_ struct{} `type:"structure"`

	// The result of the authentication response. This result is only returned if
	// the caller doesn't need to pass another challenge. If the caller does need
	// to pass another challenge before it gets tokens, ChallengeName, ChallengeParameters,
	// and Session are returned.
	AuthenticationResult *AuthenticationResultType `type:"structure"`

	// The name of the challenge that you're responding to with this call. This
	// name is returned in the AdminInitiateAuth response if you must pass another
	// challenge.
	//
	// Valid values include the following:
	//
	// All of the following challenges require USERNAME and SECRET_HASH (if applicable)
	// in the parameters.
	//
	//    * SMS_MFA: Next challenge is to supply an SMS_MFA_CODE, delivered via
	//    SMS.
	//
	//    * PASSWORD_VERIFIER: Next challenge is to supply PASSWORD_CLAIM_SIGNATURE,
	//    PASSWORD_CLAIM_SECRET_BLOCK, and TIMESTAMP after the client-side SRP calculations.
	//
	//    * CUSTOM_CHALLENGE: This is returned if your custom authentication flow
	//    determines that the user should pass another challenge before tokens are
	//    issued.
	//
	//    * DEVICE_SRP_AUTH: If device tracking was activated on your user pool
	//    and the previous challenges were passed, this challenge is returned so
	//    that Amazon Cognito can start tracking this device.
	//
	//    * DEVICE_PASSWORD_VERIFIER: Similar to PASSWORD_VERIFIER, but for devices
	//    only.
	//
	//    * NEW_PASSWORD_REQUIRED: For users who are required to change their passwords
	//    after successful first login. This challenge should be passed with NEW_PASSWORD
	//    and any other required attributes.
	//
	//    * MFA_SETUP: For users who are required to setup an MFA factor before
	//    they can sign in. The MFA types activated for the user pool will be listed
	//    in the challenge parameters MFA_CAN_SETUP value. To set up software token
	//    MFA, use the session returned here from InitiateAuth as an input to AssociateSoftwareToken.
	//    Use the session returned by VerifySoftwareToken as an input to RespondToAuthChallenge
	//    with challenge name MFA_SETUP to complete sign-in. To set up SMS MFA,
	//    an administrator should help the user to add a phone number to their account,
	//    and then the user should call InitiateAuth again to restart sign-in.
	ChallengeName *string `type:"string" enum:"ChallengeNameType"`

	// The challenge parameters. These are returned in the InitiateAuth response
	// if you must pass another challenge. The responses in this parameter should
	// be used to compute inputs to the next call (RespondToAuthChallenge).
	//
	// All challenges require USERNAME and SECRET_HASH (if applicable).
	ChallengeParameters map[string]*string `type:"map"`

	// The session that should pass both ways in challenge-response calls to the
	// service. If the caller must pass another challenge, they return a session
	// with other challenge parameters. This session should be passed as it is to
	// the next RespondToAuthChallenge API call.
	Session *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitiateAuthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitiateAuthOutput) GoString() string {
	return s.String()
}

// SetAuthenticationResult sets the AuthenticationResult field's value.
func (s *InitiateAuthOutput) SetAuthenticationResult(v *AuthenticationResultType) *InitiateAuthOutput {
	s.AuthenticationResult = v
	return s
}

// SetChallengeName sets the ChallengeName field's value.
func (s *InitiateAuthOutput) SetChallengeName(v string) *InitiateAuthOutput {
	s.ChallengeName = &v
	return s
}

// SetChallengeParameters sets the ChallengeParameters field's value.
func (s *InitiateAuthOutput) SetChallengeParameters(v map[string]*string) *InitiateAuthOutput {
	s.ChallengeParameters = v
	return s
}

// SetSession sets the Session field's value.
func (s *InitiateAuthOutput) SetSession(v string) *InitiateAuthOutput {
	s.Session = &v
	return s
}

// This exception is thrown when Amazon Cognito encounters an internal error.
type InternalErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message returned when Amazon Cognito throws an internal error exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalErrorException) GoString() string {
	return s.String()
}

func newErrorInternalErrorException(v protocol.ResponseMetadata) error {
	return &InternalErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalErrorException) Code() string {
	return "InternalErrorException"
}

// Message returns the exception's message.
func (s *InternalErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalErrorException) OrigErr() error {
	return nil
}

func (s *InternalErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when Amazon Cognito isn't allowed to use your email
// identity. HTTP status code: 400.
type InvalidEmailRoleAccessPolicyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message returned when you have an unverified email address or the identity
	// policy isn't set on an email address that Amazon Cognito can access.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidEmailRoleAccessPolicyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidEmailRoleAccessPolicyException) GoString() string {
	return s.String()
}

func newErrorInvalidEmailRoleAccessPolicyException(v protocol.ResponseMetadata) error {
	return &InvalidEmailRoleAccessPolicyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidEmailRoleAccessPolicyException) Code() string {
	return "InvalidEmailRoleAccessPolicyException"
}

// Message returns the exception's message.
func (s *InvalidEmailRoleAccessPolicyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidEmailRoleAccessPolicyException) OrigErr() error {
	return nil
}

func (s *InvalidEmailRoleAccessPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidEmailRoleAccessPolicyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidEmailRoleAccessPolicyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when Amazon Cognito encounters an invalid Lambda
// response.
type InvalidLambdaResponseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message returned when Amazon Cognito hrows an invalid Lambda response
	// exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidLambdaResponseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidLambdaResponseException) GoString() string {
	return s.String()
}

func newErrorInvalidLambdaResponseException(v protocol.ResponseMetadata) error {
	return &InvalidLambdaResponseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidLambdaResponseException) Code() string {
	return "InvalidLambdaResponseException"
}

// Message returns the exception's message.
func (s *InvalidLambdaResponseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidLambdaResponseException) OrigErr() error {
	return nil
}

func (s *InvalidLambdaResponseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidLambdaResponseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidLambdaResponseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the specified OAuth flow is not valid.
type InvalidOAuthFlowException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidOAuthFlowException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidOAuthFlowException) GoString() string {
	return s.String()
}

func newErrorInvalidOAuthFlowException(v protocol.ResponseMetadata) error {
	return &InvalidOAuthFlowException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidOAuthFlowException) Code() string {
	return "InvalidOAuthFlowException"
}

// Message returns the exception's message.
func (s *InvalidOAuthFlowException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidOAuthFlowException) OrigErr() error {
	return nil
}

func (s *InvalidOAuthFlowException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidOAuthFlowException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidOAuthFlowException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the Amazon Cognito service encounters an invalid
// parameter.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message returned when the Amazon Cognito service throws an invalid parameter
	// exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when Amazon Cognito encounters an invalid password.
type InvalidPasswordException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message returned when Amazon Cognito throws an invalid user password
	// exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPasswordException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPasswordException) GoString() string {
	return s.String()
}

func newErrorInvalidPasswordException(v protocol.ResponseMetadata) error {
	return &InvalidPasswordException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidPasswordException) Code() string {
	return "InvalidPasswordException"
}

// Message returns the exception's message.
func (s *InvalidPasswordException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidPasswordException) OrigErr() error {
	return nil
}

func (s *InvalidPasswordException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidPasswordException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidPasswordException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is returned when the role provided for SMS configuration doesn't
// have permission to publish using Amazon SNS.
type InvalidSmsRoleAccessPolicyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message returned when the invalid SMS role access policy exception is
	// thrown.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSmsRoleAccessPolicyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSmsRoleAccessPolicyException) GoString() string {
	return s.String()
}

func newErrorInvalidSmsRoleAccessPolicyException(v protocol.ResponseMetadata) error {
	return &InvalidSmsRoleAccessPolicyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidSmsRoleAccessPolicyException) Code() string {
	return "InvalidSmsRoleAccessPolicyException"
}

// Message returns the exception's message.
func (s *InvalidSmsRoleAccessPolicyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidSmsRoleAccessPolicyException) OrigErr() error {
	return nil
}

func (s *InvalidSmsRoleAccessPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidSmsRoleAccessPolicyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidSmsRoleAccessPolicyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the trust relationship is not valid for the
// role provided for SMS configuration. This can happen if you don't trust cognito-idp.amazonaws.com
// or the external ID provided in the role does not match what is provided in
// the SMS configuration for the user pool.
type InvalidSmsRoleTrustRelationshipException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message returned when the role trust relationship for the SMS message
	// is not valid.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSmsRoleTrustRelationshipException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSmsRoleTrustRelationshipException) GoString() string {
	return s.String()
}

func newErrorInvalidSmsRoleTrustRelationshipException(v protocol.ResponseMetadata) error {
	return &InvalidSmsRoleTrustRelationshipException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidSmsRoleTrustRelationshipException) Code() string {
	return "InvalidSmsRoleTrustRelationshipException"
}

// Message returns the exception's message.
func (s *InvalidSmsRoleTrustRelationshipException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidSmsRoleTrustRelationshipException) OrigErr() error {
	return nil
}

func (s *InvalidSmsRoleTrustRelationshipException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidSmsRoleTrustRelationshipException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidSmsRoleTrustRelationshipException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the user pool configuration is not valid.
type InvalidUserPoolConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message returned when the user pool configuration is not valid.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidUserPoolConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidUserPoolConfigurationException) GoString() string {
	return s.String()
}

func newErrorInvalidUserPoolConfigurationException(v protocol.ResponseMetadata) error {
	return &InvalidUserPoolConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidUserPoolConfigurationException) Code() string {
	return "InvalidUserPoolConfigurationException"
}

// Message returns the exception's message.
func (s *InvalidUserPoolConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidUserPoolConfigurationException) OrigErr() error {
	return nil
}

func (s *InvalidUserPoolConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidUserPoolConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidUserPoolConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies the configuration for Lambda triggers.
type LambdaConfigType struct {
	_ struct{} `type:"structure"`

	// Creates an authentication challenge.
	CreateAuthChallenge *string `min:"20" type:"string"`

	// A custom email sender Lambda trigger.
	CustomEmailSender *CustomEmailLambdaVersionConfigType `type:"structure"`

	// A custom Message Lambda trigger.
	CustomMessage *string `min:"20" type:"string"`

	// A custom SMS sender Lambda trigger.
	CustomSMSSender *CustomSMSLambdaVersionConfigType `type:"structure"`

	// Defines the authentication challenge.
	DefineAuthChallenge *string `min:"20" type:"string"`

	// The Amazon Resource Name (ARN) of an KMS key (/kms/latest/developerguide/concepts.html#master_keys).
	// Amazon Cognito uses the key to encrypt codes and temporary passwords sent
	// to CustomEmailSender and CustomSMSSender.
	KMSKeyID *string `min:"20" type:"string"`

	// A post-authentication Lambda trigger.
	PostAuthentication *string `min:"20" type:"string"`

	// A post-confirmation Lambda trigger.
	PostConfirmation *string `min:"20" type:"string"`

	// A pre-authentication Lambda trigger.
	PreAuthentication *string `min:"20" type:"string"`

	// A pre-registration Lambda trigger.
	PreSignUp *string `min:"20" type:"string"`

	// A Lambda trigger that is invoked before token generation.
	PreTokenGeneration *string `min:"20" type:"string"`

	// The user migration Lambda config type.
	UserMigration *string `min:"20" type:"string"`

	// Verifies the authentication challenge response.
	VerifyAuthChallengeResponse *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaConfigType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaConfigType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaConfigType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaConfigType"}
	if s.CreateAuthChallenge != nil && len(*s.CreateAuthChallenge) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CreateAuthChallenge", 20))
	}
	if s.CustomMessage != nil && len(*s.CustomMessage) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CustomMessage", 20))
	}
	if s.DefineAuthChallenge != nil && len(*s.DefineAuthChallenge) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DefineAuthChallenge", 20))
	}
	if s.KMSKeyID != nil && len(*s.KMSKeyID) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKeyID", 20))
	}
	if s.PostAuthentication != nil && len(*s.PostAuthentication) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PostAuthentication", 20))
	}
	if s.PostConfirmation != nil && len(*s.PostConfirmation) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PostConfirmation", 20))
	}
	if s.PreAuthentication != nil && len(*s.PreAuthentication) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PreAuthentication", 20))
	}
	if s.PreSignUp != nil && len(*s.PreSignUp) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PreSignUp", 20))
	}
	if s.PreTokenGeneration != nil && len(*s.PreTokenGeneration) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PreTokenGeneration", 20))
	}
	if s.UserMigration != nil && len(*s.UserMigration) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("UserMigration", 20))
	}
	if s.VerifyAuthChallengeResponse != nil && len(*s.VerifyAuthChallengeResponse) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("VerifyAuthChallengeResponse", 20))
	}
	if s.CustomEmailSender != nil {
		if err := s.CustomEmailSender.Validate(); err != nil {
			invalidParams.AddNested("CustomEmailSender", err.(request.ErrInvalidParams))
		}
	}
	if s.CustomSMSSender != nil {
		if err := s.CustomSMSSender.Validate(); err != nil {
			invalidParams.AddNested("CustomSMSSender", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreateAuthChallenge sets the CreateAuthChallenge field's value.
func (s *LambdaConfigType) SetCreateAuthChallenge(v string) *LambdaConfigType {
	s.CreateAuthChallenge = &v
	return s
}

// SetCustomEmailSender sets the CustomEmailSender field's value.
func (s *LambdaConfigType) SetCustomEmailSender(v *CustomEmailLambdaVersionConfigType) *LambdaConfigType {
	s.CustomEmailSender = v
	return s
}

// SetCustomMessage sets the CustomMessage field's value.
func (s *LambdaConfigType) SetCustomMessage(v string) *LambdaConfigType {
	s.CustomMessage = &v
	return s
}

// SetCustomSMSSender sets the CustomSMSSender field's value.
func (s *LambdaConfigType) SetCustomSMSSender(v *CustomSMSLambdaVersionConfigType) *LambdaConfigType {
	s.CustomSMSSender = v
	return s
}

// SetDefineAuthChallenge sets the DefineAuthChallenge field's value.
func (s *LambdaConfigType) SetDefineAuthChallenge(v string) *LambdaConfigType {
	s.DefineAuthChallenge = &v
	return s
}

// SetKMSKeyID sets the KMSKeyID field's value.
func (s *LambdaConfigType) SetKMSKeyID(v string) *LambdaConfigType {
	s.KMSKeyID = &v
	return s
}

// SetPostAuthentication sets the PostAuthentication field's value.
func (s *LambdaConfigType) SetPostAuthentication(v string) *LambdaConfigType {
	s.PostAuthentication = &v
	return s
}

// SetPostConfirmation sets the PostConfirmation field's value.
func (s *LambdaConfigType) SetPostConfirmation(v string) *LambdaConfigType {
	s.PostConfirmation = &v
	return s
}

// SetPreAuthentication sets the PreAuthentication field's value.
func (s *LambdaConfigType) SetPreAuthentication(v string) *LambdaConfigType {
	s.PreAuthentication = &v
	return s
}

// SetPreSignUp sets the PreSignUp field's value.
func (s *LambdaConfigType) SetPreSignUp(v string) *LambdaConfigType {
	s.PreSignUp = &v
	return s
}

// SetPreTokenGeneration sets the PreTokenGeneration field's value.
func (s *LambdaConfigType) SetPreTokenGeneration(v string) *LambdaConfigType {
	s.PreTokenGeneration = &v
	return s
}

// SetUserMigration sets the UserMigration field's value.
func (s *LambdaConfigType) SetUserMigration(v string) *LambdaConfigType {
	s.UserMigration = &v
	return s
}

// SetVerifyAuthChallengeResponse sets the VerifyAuthChallengeResponse field's value.
func (s *LambdaConfigType) SetVerifyAuthChallengeResponse(v string) *LambdaConfigType {
	s.VerifyAuthChallengeResponse = &v
	return s
}

// This exception is thrown when a user exceeds the limit for a requested Amazon
// Web Services resource.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message returned when Amazon Cognito throws a limit exceeded exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the request to list the devices.
type ListDevicesInput struct {
	_ struct{} `type:"structure"`

	// The access tokens for the request to list devices.
	//
	// AccessToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListDevicesInput's
	// String and GoString methods.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true" sensitive:"true"`

	// The limit of the device request.
	Limit *int64 `type:"integer"`

	// The pagination token for the list request.
	PaginationToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDevicesInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}
	if s.PaginationToken != nil && len(*s.PaginationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PaginationToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessToken sets the AccessToken field's value.
func (s *ListDevicesInput) SetAccessToken(v string) *ListDevicesInput {
	s.AccessToken = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListDevicesInput) SetLimit(v int64) *ListDevicesInput {
	s.Limit = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *ListDevicesInput) SetPaginationToken(v string) *ListDevicesInput {
	s.PaginationToken = &v
	return s
}

// Represents the response to list devices.
type ListDevicesOutput struct {
	_ struct{} `type:"structure"`

	// The devices returned in the list devices response.
	Devices []*DeviceType `type:"list"`

	// The pagination token for the list device response.
	PaginationToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesOutput) GoString() string {
	return s.String()
}

// SetDevices sets the Devices field's value.
func (s *ListDevicesOutput) SetDevices(v []*DeviceType) *ListDevicesOutput {
	s.Devices = v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *ListDevicesOutput) SetPaginationToken(v string) *ListDevicesOutput {
	s.PaginationToken = &v
	return s
}

type ListGroupsInput struct {
	_ struct{} `type:"structure"`

	// The limit of the request to list groups.
	Limit *int64 `type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListGroupsInput) SetLimit(v int64) *ListGroupsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsInput) SetNextToken(v string) *ListGroupsInput {
	s.NextToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *ListGroupsInput) SetUserPoolId(v string) *ListGroupsInput {
	s.UserPoolId = &v
	return s
}

type ListGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The group objects for the groups.
	Groups []*GroupType `type:"list"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupsOutput) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *ListGroupsOutput) SetGroups(v []*GroupType) *ListGroupsOutput {
	s.Groups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsOutput) SetNextToken(v string) *ListGroupsOutput {
	s.NextToken = &v
	return s
}

type ListIdentityProvidersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of identity providers to return.
	MaxResults *int64 `type:"integer"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProvidersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProvidersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIdentityProvidersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIdentityProvidersInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIdentityProvidersInput) SetMaxResults(v int64) *ListIdentityProvidersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentityProvidersInput) SetNextToken(v string) *ListIdentityProvidersInput {
	s.NextToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *ListIdentityProvidersInput) SetUserPoolId(v string) *ListIdentityProvidersInput {
	s.UserPoolId = &v
	return s
}

type ListIdentityProvidersOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`

	// A list of identity provider objects.
	//
	// Providers is a required field
	Providers []*ProviderDescription `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProvidersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProvidersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentityProvidersOutput) SetNextToken(v string) *ListIdentityProvidersOutput {
	s.NextToken = &v
	return s
}

// SetProviders sets the Providers field's value.
func (s *ListIdentityProvidersOutput) SetProviders(v []*ProviderDescription) *ListIdentityProvidersOutput {
	s.Providers = v
	return s
}

type ListResourceServersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of resource servers to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceServersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceServersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceServersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceServersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceServersInput) SetMaxResults(v int64) *ListResourceServersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceServersInput) SetNextToken(v string) *ListResourceServersInput {
	s.NextToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *ListResourceServersInput) SetUserPoolId(v string) *ListResourceServersInput {
	s.UserPoolId = &v
	return s
}

type ListResourceServersOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`

	// The resource servers.
	//
	// ResourceServers is a required field
	ResourceServers []*ResourceServerType `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceServersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceServersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceServersOutput) SetNextToken(v string) *ListResourceServersOutput {
	s.NextToken = &v
	return s
}

// SetResourceServers sets the ResourceServers field's value.
func (s *ListResourceServersOutput) SetResourceServers(v []*ResourceServerType) *ListResourceServersOutput {
	s.ResourceServers = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user pool that the tags are assigned
	// to.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags that are assigned to the user pool.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Represents the request to list the user import jobs.
type ListUserImportJobsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of import jobs you want the request to return.
	//
	// MaxResults is a required field
	MaxResults *int64 `min:"1" type:"integer" required:"true"`

	// An identifier that was returned from the previous call to ListUserImportJobs,
	// which can be used to return the next set of import jobs in the list.
	PaginationToken *string `min:"1" type:"string"`

	// The user pool ID for the user pool that the users are being imported into.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUserImportJobsInput"}
	if s.MaxResults == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxResults"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PaginationToken != nil && len(*s.PaginationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PaginationToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUserImportJobsInput) SetMaxResults(v int64) *ListUserImportJobsInput {
	s.MaxResults = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *ListUserImportJobsInput) SetPaginationToken(v string) *ListUserImportJobsInput {
	s.PaginationToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *ListUserImportJobsInput) SetUserPoolId(v string) *ListUserImportJobsInput {
	s.UserPoolId = &v
	return s
}

// Represents the response from the server to the request to list the user import
// jobs.
type ListUserImportJobsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that can be used to return the next set of user import jobs
	// in the list.
	PaginationToken *string `min:"1" type:"string"`

	// The user import jobs.
	UserImportJobs []*UserImportJobType `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserImportJobsOutput) GoString() string {
	return s.String()
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *ListUserImportJobsOutput) SetPaginationToken(v string) *ListUserImportJobsOutput {
	s.PaginationToken = &v
	return s
}

// SetUserImportJobs sets the UserImportJobs field's value.
func (s *ListUserImportJobsOutput) SetUserImportJobs(v []*UserImportJobType) *ListUserImportJobsOutput {
	s.UserImportJobs = v
	return s
}

// Represents the request to list the user pool clients.
type ListUserPoolClientsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results you want the request to return when listing
	// the user pool clients.
	MaxResults *int64 `min:"1" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The user pool ID for the user pool where you want to list user pool clients.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserPoolClientsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserPoolClientsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserPoolClientsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUserPoolClientsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUserPoolClientsInput) SetMaxResults(v int64) *ListUserPoolClientsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserPoolClientsInput) SetNextToken(v string) *ListUserPoolClientsInput {
	s.NextToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *ListUserPoolClientsInput) SetUserPoolId(v string) *ListUserPoolClientsInput {
	s.UserPoolId = &v
	return s
}

// Represents the response from the server that lists user pool clients.
type ListUserPoolClientsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The user pool clients in the response that lists user pool clients.
	UserPoolClients []*UserPoolClientDescription `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserPoolClientsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserPoolClientsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserPoolClientsOutput) SetNextToken(v string) *ListUserPoolClientsOutput {
	s.NextToken = &v
	return s
}

// SetUserPoolClients sets the UserPoolClients field's value.
func (s *ListUserPoolClientsOutput) SetUserPoolClients(v []*UserPoolClientDescription) *ListUserPoolClientsOutput {
	s.UserPoolClients = v
	return s
}

// Represents the request to list user pools.
type ListUserPoolsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results you want the request to return when listing
	// the user pools.
	//
	// MaxResults is a required field
	MaxResults *int64 `min:"1" type:"integer" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserPoolsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserPoolsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserPoolsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUserPoolsInput"}
	if s.MaxResults == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxResults"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUserPoolsInput) SetMaxResults(v int64) *ListUserPoolsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserPoolsInput) SetNextToken(v string) *ListUserPoolsInput {
	s.NextToken = &v
	return s
}

// Represents the response to list user pools.
type ListUserPoolsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The user pools from the response to list users.
	UserPools []*UserPoolDescriptionType `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserPoolsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserPoolsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserPoolsOutput) SetNextToken(v string) *ListUserPoolsOutput {
	s.NextToken = &v
	return s
}

// SetUserPools sets the UserPools field's value.
func (s *ListUserPoolsOutput) SetUserPools(v []*UserPoolDescriptionType) *ListUserPoolsOutput {
	s.UserPools = v
	return s
}

type ListUsersInGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The limit of the request to list users.
	Limit *int64 `type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsersInGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsersInGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *ListUsersInGroupInput) SetGroupName(v string) *ListUsersInGroupInput {
	s.GroupName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListUsersInGroupInput) SetLimit(v int64) *ListUsersInGroupInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersInGroupInput) SetNextToken(v string) *ListUsersInGroupInput {
	s.NextToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *ListUsersInGroupInput) SetUserPoolId(v string) *ListUsersInGroupInput {
	s.UserPoolId = &v
	return s
}

type ListUsersInGroupOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The users returned in the request to list users.
	Users []*UserType `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsersInGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsersInGroupOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersInGroupOutput) SetNextToken(v string) *ListUsersInGroupOutput {
	s.NextToken = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *ListUsersInGroupOutput) SetUsers(v []*UserType) *ListUsersInGroupOutput {
	s.Users = v
	return s
}

// Represents the request to list users.
type ListUsersInput struct {
	_ struct{} `type:"structure"`

	// An array of strings, where each string is the name of a user attribute to
	// be returned for each user in the search results. If the array is null, all
	// attributes are returned.
	AttributesToGet []*string `type:"list"`

	// A filter string of the form "AttributeName Filter-Type "AttributeValue"".
	// Quotation marks within the filter string must be escaped using the backslash
	// (\) character. For example, "family_name = \"Reddy\"".
	//
	//    * AttributeName: The name of the attribute to search for. You can only
	//    search for one attribute at a time.
	//
	//    * Filter-Type: For an exact match, use =, for example, "given_name = \"Jon\"".
	//    For a prefix ("starts with") match, use ^=, for example, "given_name ^=
	//    \"Jon\"".
	//
	//    * AttributeValue: The attribute value that must be matched for each user.
	//
	// If the filter string is empty, ListUsers returns all users in the user pool.
	//
	// You can only search for the following standard attributes:
	//
	//    * username (case-sensitive)
	//
	//    * email
	//
	//    * phone_number
	//
	//    * name
	//
	//    * given_name
	//
	//    * family_name
	//
	//    * preferred_username
	//
	//    * cognito:user_status (called Status in the Console) (case-insensitive)
	//
	//    * status (called Enabled in the Console) (case-sensitive)
	//
	//    * sub
	//
	// Custom attributes aren't searchable.
	//
	// You can also list users with a client-side filter. The server-side filter
	// matches no more than 1 attribute. For an advanced search, use a client-side
	// filter with the --query parameter of the list-users action in the CLI. When
	// you use a client-side filter, ListUsers returns a paginated list of zero
	// or more users. You can receive multiple pages in a row with zero results.
	// Repeat the query with each pagination token that is returned until you receive
	// a null pagination token value, and then review the combined result.
	//
	// For more information about server-side and client-side filtering, see FilteringCLI
	// output (https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html)
	// in the Command Line Interface User Guide (https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html).
	//
	// For more information, see Searching for Users Using the ListUsers API (https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-using-listusers-api)
	// and Examples of Using the ListUsers API (https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-listusers-api-examples)
	// in the Amazon Cognito Developer Guide.
	Filter *string `type:"string"`

	// Maximum number of users to be returned.
	Limit *int64 `type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	PaginationToken *string `min:"1" type:"string"`

	// The user pool ID for the user pool on which the search should be performed.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInput"}
	if s.PaginationToken != nil && len(*s.PaginationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PaginationToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributesToGet sets the AttributesToGet field's value.
func (s *ListUsersInput) SetAttributesToGet(v []*string) *ListUsersInput {
	s.AttributesToGet = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *ListUsersInput) SetFilter(v string) *ListUsersInput {
	s.Filter = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListUsersInput) SetLimit(v int64) *ListUsersInput {
	s.Limit = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *ListUsersInput) SetPaginationToken(v string) *ListUsersInput {
	s.PaginationToken = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *ListUsersInput) SetUserPoolId(v string) *ListUsersInput {
	s.UserPoolId = &v
	return s
}

// The response from the request to list users.
type ListUsersOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	PaginationToken *string `min:"1" type:"string"`

	// The users returned in the request to list users.
	Users []*UserType `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsersOutput) GoString() string {
	return s.String()
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *ListUsersOutput) SetPaginationToken(v string) *ListUsersOutput {
	s.PaginationToken = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *ListUsersOutput) SetUsers(v []*UserType) *ListUsersOutput {
	s.Users = v
	return s
}

// This exception is thrown when Amazon Cognito can't find a multi-factor authentication
// (MFA) method.
type MFAMethodNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message returned when Amazon Cognito throws an MFA method not found exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MFAMethodNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MFAMethodNotFoundException) GoString() string {
	return s.String()
}

func newErrorMFAMethodNotFoundException(v protocol.ResponseMetadata) error {
	return &MFAMethodNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MFAMethodNotFoundException) Code() string {
	return "MFAMethodNotFoundException"
}

// Message returns the exception's message.
func (s *MFAMethodNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MFAMethodNotFoundException) OrigErr() error {
	return nil
}

func (s *MFAMethodNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MFAMethodNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MFAMethodNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This data type is no longer supported. Applies only to SMS multi-factor authentication
// (MFA) configurations. Does not apply to time-based one-time password (TOTP)
// software token MFA configurations.
type MFAOptionType struct {
	_ struct{} `type:"structure"`

	// The attribute name of the MFA option type. The only valid value is phone_number.
	AttributeName *string `min:"1" type:"string"`

	// The delivery medium to send the MFA code. You can use this parameter to set
	// only the SMS delivery medium value.
	DeliveryMedium *string `type:"string" enum:"DeliveryMediumType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MFAOptionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MFAOptionType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MFAOptionType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MFAOptionType"}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *MFAOptionType) SetAttributeName(v string) *MFAOptionType {
	s.AttributeName = &v
	return s
}

// SetDeliveryMedium sets the DeliveryMedium field's value.
func (s *MFAOptionType) SetDeliveryMedium(v string) *MFAOptionType {
	s.DeliveryMedium = &v
	return s
}

// The message template structure.
type MessageTemplateType struct {
	_ struct{} `type:"structure"`

	// The message template for email messages. EmailMessage is allowed only if
	// EmailSendingAccount (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER.
	EmailMessage *string `min:"6" type:"string"`

	// The subject line for email messages. EmailSubject is allowed only if EmailSendingAccount
	// (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER.
	EmailSubject *string `min:"1" type:"string"`

	// The message template for SMS messages.
	SMSMessage *string `min:"6" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageTemplateType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageTemplateType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageTemplateType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MessageTemplateType"}
	if s.EmailMessage != nil && len(*s.EmailMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("EmailMessage", 6))
	}
	if s.EmailSubject != nil && len(*s.EmailSubject) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailSubject", 1))
	}
	if s.SMSMessage != nil && len(*s.SMSMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("SMSMessage", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailMessage sets the EmailMessage field's value.
func (s *MessageTemplateType) SetEmailMessage(v string) *MessageTemplateType {
	s.EmailMessage = &v
	return s
}

// SetEmailSubject sets the EmailSubject field's value.
func (s *MessageTemplateType) SetEmailSubject(v string) *MessageTemplateType {
	s.EmailSubject = &v
	return s
}

// SetSMSMessage sets the SMSMessage field's value.
func (s *MessageTemplateType) SetSMSMessage(v string) *MessageTemplateType {
	s.SMSMessage = &v
	return s
}

// The new device metadata type.
type NewDeviceMetadataType struct {
	_ struct{} `type:"structure"`

	// The device group key.
	DeviceGroupKey *string `type:"string"`

	// The device key.
	DeviceKey *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NewDeviceMetadataType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NewDeviceMetadataType) GoString() string {
	return s.String()
}

// SetDeviceGroupKey sets the DeviceGroupKey field's value.
func (s *NewDeviceMetadataType) SetDeviceGroupKey(v string) *NewDeviceMetadataType {
	s.DeviceGroupKey = &v
	return s
}

// SetDeviceKey sets the DeviceKey field's value.
func (s *NewDeviceMetadataType) SetDeviceKey(v string) *NewDeviceMetadataType {
	s.DeviceKey = &v
	return s
}

// This exception is thrown when a user isn't authorized.
type NotAuthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message returned when the Amazon Cognito service returns a not authorized
	// exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotAuthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotAuthorizedException) GoString() string {
	return s.String()
}

func newErrorNotAuthorizedException(v protocol.ResponseMetadata) error {
	return &NotAuthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotAuthorizedException) Code() string {
	return "NotAuthorizedException"
}

// Message returns the exception's message.
func (s *NotAuthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotAuthorizedException) OrigErr() error {
	return nil
}

func (s *NotAuthorizedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotAuthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotAuthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The notify configuration type.
type NotifyConfigurationType struct {
	_ struct{} `type:"structure"`

	// Email template used when a detected risk event is blocked.
	BlockEmail *NotifyEmailType `type:"structure"`

	// The email address that is sending the email. The address must be either individually
	// verified with Amazon Simple Email Service, or from a domain that has been
	// verified with Amazon SES.
	From *string `type:"string"`

	// The multi-factor authentication (MFA) email template used when MFA is challenged
	// as part of a detected risk.
	MfaEmail *NotifyEmailType `type:"structure"`

	// The email template used when a detected risk event is allowed.
	NoActionEmail *NotifyEmailType `type:"structure"`

	// The destination to which the receiver of an email should reply to.
	ReplyTo *string `type:"string"`

	// The Amazon Resource Name (ARN) of the identity that is associated with the
	// sending authorization policy. This identity permits Amazon Cognito to send
	// for the email address specified in the From parameter.
	//
	// SourceArn is a required field
	SourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotifyConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotifyConfigurationType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotifyConfigurationType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotifyConfigurationType"}
	if s.SourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceArn"))
	}
	if s.SourceArn != nil && len(*s.SourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SourceArn", 20))
	}
	if s.BlockEmail != nil {
		if err := s.BlockEmail.Validate(); err != nil {
			invalidParams.AddNested("BlockEmail", err.(request.ErrInvalidParams))
		}
	}
	if s.MfaEmail != nil {
		if err := s.MfaEmail.Validate(); err != nil {
			invalidParams.AddNested("MfaEmail", err.(request.ErrInvalidParams))
		}
	}
	if s.NoActionEmail != nil {
		if err := s.NoActionEmail.Validate(); err != nil {
			invalidParams.AddNested("NoActionEmail", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlockEmail sets the BlockEmail field's value.
func (s *NotifyConfigurationType) SetBlockEmail(v *NotifyEmailType) *NotifyConfigurationType {
	s.BlockEmail = v
	return s
}

// SetFrom sets the From field's value.
func (s *NotifyConfigurationType) SetFrom(v string) *NotifyConfigurationType {
	s.From = &v
	return s
}

// SetMfaEmail sets the MfaEmail field's value.
func (s *NotifyConfigurationType) SetMfaEmail(v *NotifyEmailType) *NotifyConfigurationType {
	s.MfaEmail = v
	return s
}

// SetNoActionEmail sets the NoActionEmail field's value.
func (s *NotifyConfigurationType) SetNoActionEmail(v *NotifyEmailType) *NotifyConfigurationType {
	s.NoActionEmail = v
	return s
}

// SetReplyTo sets the ReplyTo field's value.
func (s *NotifyConfigurationType) SetReplyTo(v string) *NotifyConfigurationType {
	s.ReplyTo = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *NotifyConfigurationType) SetSourceArn(v string) *NotifyConfigurationType {
	s.SourceArn = &v
	return s
}

// The notify email type.
type NotifyEmailType struct {
	_ struct{} `type:"structure"`

	// The email HTML body.
	HtmlBody *string `min:"6" type:"string"`

	// The email subject.
	//
	// Subject is a required field
	Subject *string `min:"1" type:"string" required:"true"`

	// The email text body.
	TextBody *string `min:"6" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotifyEmailType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotifyEmailType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotifyEmailType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotifyEmailType"}
	if s.HtmlBody != nil && len(*s.HtmlBody) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("HtmlBody", 6))
	}
	if s.Subject == nil {
		invalidParams.Add(request.NewErrParamRequired("Subject"))
	}
	if s.Subject != nil && len(*s.Subject) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Subject", 1))
	}
	if s.TextBody != nil && len(*s.TextBody) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("TextBody", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHtmlBody sets the HtmlBody field's value.
func (s *NotifyEmailType) SetHtmlBody(v string) *NotifyEmailType {
	s.HtmlBody = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *NotifyEmailType) SetSubject(v string) *NotifyEmailType {
	s.Subject = &v
	return s
}

// SetTextBody sets the TextBody field's value.
func (s *NotifyEmailType) SetTextBody(v string) *NotifyEmailType {
	s.TextBody = &v
	return s
}

// The minimum and maximum values of an attribute that is of the number data
// type.
type NumberAttributeConstraintsType struct {
	_ struct{} `type:"structure"`

	// The maximum value of an attribute that is of the number data type.
	MaxValue *string `type:"string"`

	// The minimum value of an attribute that is of the number data type.
	MinValue *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NumberAttributeConstraintsType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NumberAttributeConstraintsType) GoString() string {
	return s.String()
}

// SetMaxValue sets the MaxValue field's value.
func (s *NumberAttributeConstraintsType) SetMaxValue(v string) *NumberAttributeConstraintsType {
	s.MaxValue = &v
	return s
}

// SetMinValue sets the MinValue field's value.
func (s *NumberAttributeConstraintsType) SetMinValue(v string) *NumberAttributeConstraintsType {
	s.MinValue = &v
	return s
}

// The password policy type.
type PasswordPolicyType struct {
	_ struct{} `type:"structure"`

	// The minimum length of the password in the policy that you have set. This
	// value can't be less than 6.
	MinimumLength *int64 `min:"6" type:"integer"`

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one lowercase letter in their password.
	RequireLowercase *bool `type:"boolean"`

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one number in their password.
	RequireNumbers *bool `type:"boolean"`

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one symbol in their password.
	RequireSymbols *bool `type:"boolean"`

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one uppercase letter in their password.
	RequireUppercase *bool `type:"boolean"`

	// The number of days a temporary password is valid in the password policy.
	// If the user doesn't sign in during this time, an administrator must reset
	// their password.
	//
	// When you set TemporaryPasswordValidityDays for a user pool, you can no longer
	// set the deprecated UnusedAccountValidityDays value for that user pool.
	TemporaryPasswordValidityDays *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PasswordPolicyType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PasswordPolicyType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PasswordPolicyType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PasswordPolicyType"}
	if s.MinimumLength != nil && *s.MinimumLength < 6 {
		invalidParams.Add(request.NewErrParamMinValue("MinimumLength", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMinimumLength sets the MinimumLength field's value.
func (s *PasswordPolicyType) SetMinimumLength(v int64) *PasswordPolicyType {
	s.MinimumLength = &v
	return s
}

// SetRequireLowercase sets the RequireLowercase field's value.
func (s *PasswordPolicyType) SetRequireLowercase(v bool) *PasswordPolicyType {
	s.RequireLowercase = &v
	return s
}

// SetRequireNumbers sets the RequireNumbers field's value.
func (s *PasswordPolicyType) SetRequireNumbers(v bool) *PasswordPolicyType {
	s.RequireNumbers = &v
	return s
}

// SetRequireSymbols sets the RequireSymbols field's value.
func (s *PasswordPolicyType) SetRequireSymbols(v bool) *PasswordPolicyType {
	s.RequireSymbols = &v
	return s
}

// SetRequireUppercase sets the RequireUppercase field's value.
func (s *PasswordPolicyType) SetRequireUppercase(v bool) *PasswordPolicyType {
	s.RequireUppercase = &v
	return s
}

// SetTemporaryPasswordValidityDays sets the TemporaryPasswordValidityDays field's value.
func (s *PasswordPolicyType) SetTemporaryPasswordValidityDays(v int64) *PasswordPolicyType {
	s.TemporaryPasswordValidityDays = &v
	return s
}

// This exception is thrown when a password reset is required.
type PasswordResetRequiredException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message returned when a password reset is required.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PasswordResetRequiredException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PasswordResetRequiredException) GoString() string {
	return s.String()
}

func newErrorPasswordResetRequiredException(v protocol.ResponseMetadata) error {
	return &PasswordResetRequiredException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PasswordResetRequiredException) Code() string {
	return "PasswordResetRequiredException"
}

// Message returns the exception's message.
func (s *PasswordResetRequiredException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PasswordResetRequiredException) OrigErr() error {
	return nil
}

func (s *PasswordResetRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PasswordResetRequiredException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PasswordResetRequiredException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when a precondition is not met.
type PreconditionNotMetException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message returned when a precondition is not met.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreconditionNotMetException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreconditionNotMetException) GoString() string {
	return s.String()
}

func newErrorPreconditionNotMetException(v protocol.ResponseMetadata) error {
	return &PreconditionNotMetException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PreconditionNotMetException) Code() string {
	return "PreconditionNotMetException"
}

// Message returns the exception's message.
func (s *PreconditionNotMetException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PreconditionNotMetException) OrigErr() error {
	return nil
}

func (s *PreconditionNotMetException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PreconditionNotMetException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PreconditionNotMetException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A container for identity provider details.
type ProviderDescription struct {
	_ struct{} `type:"structure"`

	// The date the provider was added to the user pool.
	CreationDate *time.Time `type:"timestamp"`

	// The date the provider was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The identity provider name.
	ProviderName *string `min:"1" type:"string"`

	// The identity provider type.
	ProviderType *string `type:"string" enum:"IdentityProviderTypeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProviderDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProviderDescription) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *ProviderDescription) SetCreationDate(v time.Time) *ProviderDescription {
	s.CreationDate = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *ProviderDescription) SetLastModifiedDate(v time.Time) *ProviderDescription {
	s.LastModifiedDate = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *ProviderDescription) SetProviderName(v string) *ProviderDescription {
	s.ProviderName = &v
	return s
}

// SetProviderType sets the ProviderType field's value.
func (s *ProviderDescription) SetProviderType(v string) *ProviderDescription {
	s.ProviderType = &v
	return s
}

// A container for information about an identity provider for a user pool.
type ProviderUserIdentifierType struct {
	_ struct{} `type:"structure"`

	// The name of the provider attribute to link to, such as NameID.
	ProviderAttributeName *string `type:"string"`

	// The value of the provider attribute to link to, such as xxxxx_account.
	ProviderAttributeValue *string `type:"string"`

	// The name of the provider, such as Facebook, Google, or Login with Amazon.
	ProviderName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProviderUserIdentifierType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProviderUserIdentifierType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProviderUserIdentifierType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProviderUserIdentifierType"}
	if s.ProviderName != nil && len(*s.ProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProviderAttributeName sets the ProviderAttributeName field's value.
func (s *ProviderUserIdentifierType) SetProviderAttributeName(v string) *ProviderUserIdentifierType {
	s.ProviderAttributeName = &v
	return s
}

// SetProviderAttributeValue sets the ProviderAttributeValue field's value.
func (s *ProviderUserIdentifierType) SetProviderAttributeValue(v string) *ProviderUserIdentifierType {
	s.ProviderAttributeValue = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *ProviderUserIdentifierType) SetProviderName(v string) *ProviderUserIdentifierType {
	s.ProviderName = &v
	return s
}

// A map containing a priority as a key, and recovery method name as a value.
type RecoveryOptionType struct {
	_ struct{} `type:"structure"`

	// The recovery method for a user.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"RecoveryOptionNameType"`

	// A positive integer specifying priority of a method with 1 being the highest
	// priority.
	//
	// Priority is a required field
	Priority *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryOptionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryOptionType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecoveryOptionType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecoveryOptionType"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Priority", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *RecoveryOptionType) SetName(v string) *RecoveryOptionType {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *RecoveryOptionType) SetPriority(v int64) *RecoveryOptionType {
	s.Priority = &v
	return s
}

// Represents the request to resend the confirmation code.
type ResendConfirmationCodeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Pinpoint analytics metadata for collecting metrics for ResendConfirmationCode
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The ID of the client associated with the user pool.
	//
	// ClientId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ResendConfirmationCodeInput's
	// String and GoString methods.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// A map of custom key-value pairs that you can provide as input for any custom
	// workflows that this action triggers.
	//
	// You create custom workflows by assigning Lambda functions to user pool triggers.
	// When you use the ResendConfirmationCode API action, Amazon Cognito invokes
	// the function that is assigned to the custom message trigger. When Amazon
	// Cognito invokes this function, it passes a JSON payload, which the function
	// receives as input. This payload contains a clientMetadata attribute, which
	// provides the data that you assigned to the ClientMetadata parameter in your
	// ResendConfirmationCode request. In your function code in Lambda, you can
	// process the clientMetadata value to enhance your workflow for your specific
	// needs.
	//
	// For more information, see Customizing user pool Workflows with Lambda Triggers
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
	// in the Amazon Cognito Developer Guide.
	//
	// When you use the ClientMetadata parameter, remember that Amazon Cognito won't
	// do the following:
	//
	//    * Store the ClientMetadata value. This data is available only to Lambda
	//    triggers that are assigned to a user pool to support custom workflows.
	//    If your user pool configuration doesn't include triggers, the ClientMetadata
	//    parameter serves no purpose.
	//
	//    * Validate the ClientMetadata value.
	//
	//    * Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide
	//    sensitive information.
	ClientMetadata map[string]*string `type:"map"`

	// A keyed-hash message authentication code (HMAC) calculated using the secret
	// key of a user pool client and username plus the client ID in the message.
	//
	// SecretHash is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ResendConfirmationCodeInput's
	// String and GoString methods.
	SecretHash *string `min:"1" type:"string" sensitive:"true"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	UserContextData *UserContextDataType `type:"structure"`

	// The username attribute of the user to whom you want to resend a confirmation
	// code.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ResendConfirmationCodeInput's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResendConfirmationCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResendConfirmationCodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResendConfirmationCodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResendConfirmationCodeInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.SecretHash != nil && len(*s.SecretHash) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretHash", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyticsMetadata sets the AnalyticsMetadata field's value.
func (s *ResendConfirmationCodeInput) SetAnalyticsMetadata(v *AnalyticsMetadataType) *ResendConfirmationCodeInput {
	s.AnalyticsMetadata = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *ResendConfirmationCodeInput) SetClientId(v string) *ResendConfirmationCodeInput {
	s.ClientId = &v
	return s
}

// SetClientMetadata sets the ClientMetadata field's value.
func (s *ResendConfirmationCodeInput) SetClientMetadata(v map[string]*string) *ResendConfirmationCodeInput {
	s.ClientMetadata = v
	return s
}

// SetSecretHash sets the SecretHash field's value.
func (s *ResendConfirmationCodeInput) SetSecretHash(v string) *ResendConfirmationCodeInput {
	s.SecretHash = &v
	return s
}

// SetUserContextData sets the UserContextData field's value.
func (s *ResendConfirmationCodeInput) SetUserContextData(v *UserContextDataType) *ResendConfirmationCodeInput {
	s.UserContextData = v
	return s
}

// SetUsername sets the Username field's value.
func (s *ResendConfirmationCodeInput) SetUsername(v string) *ResendConfirmationCodeInput {
	s.Username = &v
	return s
}

// The response from the server when Amazon Cognito makes the request to resend
// a confirmation code.
type ResendConfirmationCodeOutput struct {
	_ struct{} `type:"structure"`

	// The code delivery details returned by the server in response to the request
	// to resend the confirmation code.
	CodeDeliveryDetails *CodeDeliveryDetailsType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResendConfirmationCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResendConfirmationCodeOutput) GoString() string {
	return s.String()
}

// SetCodeDeliveryDetails sets the CodeDeliveryDetails field's value.
func (s *ResendConfirmationCodeOutput) SetCodeDeliveryDetails(v *CodeDeliveryDetailsType) *ResendConfirmationCodeOutput {
	s.CodeDeliveryDetails = v
	return s
}

// This exception is thrown when the Amazon Cognito service can't find the requested
// resource.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message returned when the Amazon Cognito service returns a resource not
	// found exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A resource server scope.
type ResourceServerScopeType struct {
	_ struct{} `type:"structure"`

	// A description of the scope.
	//
	// ScopeDescription is a required field
	ScopeDescription *string `min:"1" type:"string" required:"true"`

	// The name of the scope.
	//
	// ScopeName is a required field
	ScopeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceServerScopeType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceServerScopeType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceServerScopeType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceServerScopeType"}
	if s.ScopeDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("ScopeDescription"))
	}
	if s.ScopeDescription != nil && len(*s.ScopeDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScopeDescription", 1))
	}
	if s.ScopeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScopeName"))
	}
	if s.ScopeName != nil && len(*s.ScopeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScopeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScopeDescription sets the ScopeDescription field's value.
func (s *ResourceServerScopeType) SetScopeDescription(v string) *ResourceServerScopeType {
	s.ScopeDescription = &v
	return s
}

// SetScopeName sets the ScopeName field's value.
func (s *ResourceServerScopeType) SetScopeName(v string) *ResourceServerScopeType {
	s.ScopeName = &v
	return s
}

// A container for information about a resource server for a user pool.
type ResourceServerType struct {
	_ struct{} `type:"structure"`

	// The identifier for the resource server.
	Identifier *string `min:"1" type:"string"`

	// The name of the resource server.
	Name *string `min:"1" type:"string"`

	// A list of scopes that are defined for the resource server.
	Scopes []*ResourceServerScopeType `type:"list"`

	// The user pool ID for the user pool that hosts the resource server.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceServerType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceServerType) GoString() string {
	return s.String()
}

// SetIdentifier sets the Identifier field's value.
func (s *ResourceServerType) SetIdentifier(v string) *ResourceServerType {
	s.Identifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResourceServerType) SetName(v string) *ResourceServerType {
	s.Name = &v
	return s
}

// SetScopes sets the Scopes field's value.
func (s *ResourceServerType) SetScopes(v []*ResourceServerScopeType) *ResourceServerType {
	s.Scopes = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *ResourceServerType) SetUserPoolId(v string) *ResourceServerType {
	s.UserPoolId = &v
	return s
}

// The request to respond to an authentication challenge.
type RespondToAuthChallengeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Pinpoint analytics metadata for collecting metrics for RespondToAuthChallenge
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The challenge name. For more information, see InitiateAuth (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html).
	//
	// ADMIN_NO_SRP_AUTH isn't a valid value.
	//
	// ChallengeName is a required field
	ChallengeName *string `type:"string" required:"true" enum:"ChallengeNameType"`

	// The challenge responses. These are inputs corresponding to the value of ChallengeName,
	// for example:
	//
	// SECRET_HASH (if app client is configured with client secret) applies to all
	// of the inputs that follow (including SOFTWARE_TOKEN_MFA).
	//
	//    * SMS_MFA: SMS_MFA_CODE, USERNAME.
	//
	//    * PASSWORD_VERIFIER: PASSWORD_CLAIM_SIGNATURE, PASSWORD_CLAIM_SECRET_BLOCK,
	//    TIMESTAMP, USERNAME. PASSWORD_VERIFIER requires DEVICE_KEY when signing
	//    in with a remembered device.
	//
	//    * NEW_PASSWORD_REQUIRED: NEW_PASSWORD, any other required attributes,
	//    USERNAME.
	//
	//    * SOFTWARE_TOKEN_MFA: USERNAME and SOFTWARE_TOKEN_MFA_CODE are required
	//    attributes.
	//
	//    * DEVICE_SRP_AUTH requires USERNAME, DEVICE_KEY, SRP_A (and SECRET_HASH).
	//
	//    * DEVICE_PASSWORD_VERIFIER requires everything that PASSWORD_VERIFIER
	//    requires, plus DEVICE_KEY.
	//
	//    * MFA_SETUP requires USERNAME, plus you must use the session value returned
	//    by VerifySoftwareToken in the Session parameter.
	ChallengeResponses map[string]*string `type:"map"`

	// The app client ID.
	//
	// ClientId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RespondToAuthChallengeInput's
	// String and GoString methods.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// A map of custom key-value pairs that you can provide as input for any custom
	// workflows that this action triggers.
	//
	// You create custom workflows by assigning Lambda functions to user pool triggers.
	// When you use the RespondToAuthChallenge API action, Amazon Cognito invokes
	// any functions that are assigned to the following triggers: post authentication,
	// pre token generation, define auth challenge, create auth challenge, and verify
	// auth challenge. When Amazon Cognito invokes any of these functions, it passes
	// a JSON payload, which the function receives as input. This payload contains
	// a clientMetadata attribute, which provides the data that you assigned to
	// the ClientMetadata parameter in your RespondToAuthChallenge request. In your
	// function code in Lambda, you can process the clientMetadata value to enhance
	// your workflow for your specific needs.
	//
	// For more information, see Customizing user pool Workflows with Lambda Triggers
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
	// in the Amazon Cognito Developer Guide.
	//
	// When you use the ClientMetadata parameter, remember that Amazon Cognito won't
	// do the following:
	//
	//    * Store the ClientMetadata value. This data is available only to Lambda
	//    triggers that are assigned to a user pool to support custom workflows.
	//    If your user pool configuration doesn't include triggers, the ClientMetadata
	//    parameter serves no purpose.
	//
	//    * Validate the ClientMetadata value.
	//
	//    * Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide
	//    sensitive information.
	ClientMetadata map[string]*string `type:"map"`

	// The session that should be passed both ways in challenge-response calls to
	// the service. If InitiateAuth or RespondToAuthChallenge API call determines
	// that the caller must pass another challenge, they return a session with other
	// challenge parameters. This session should be passed as it is to the next
	// RespondToAuthChallenge API call.
	Session *string `min:"20" type:"string"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	UserContextData *UserContextDataType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RespondToAuthChallengeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RespondToAuthChallengeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RespondToAuthChallengeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RespondToAuthChallengeInput"}
	if s.ChallengeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChallengeName"))
	}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.Session != nil && len(*s.Session) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Session", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyticsMetadata sets the AnalyticsMetadata field's value.
func (s *RespondToAuthChallengeInput) SetAnalyticsMetadata(v *AnalyticsMetadataType) *RespondToAuthChallengeInput {
	s.AnalyticsMetadata = v
	return s
}

// SetChallengeName sets the ChallengeName field's value.
func (s *RespondToAuthChallengeInput) SetChallengeName(v string) *RespondToAuthChallengeInput {
	s.ChallengeName = &v
	return s
}

// SetChallengeResponses sets the ChallengeResponses field's value.
func (s *RespondToAuthChallengeInput) SetChallengeResponses(v map[string]*string) *RespondToAuthChallengeInput {
	s.ChallengeResponses = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *RespondToAuthChallengeInput) SetClientId(v string) *RespondToAuthChallengeInput {
	s.ClientId = &v
	return s
}

// SetClientMetadata sets the ClientMetadata field's value.
func (s *RespondToAuthChallengeInput) SetClientMetadata(v map[string]*string) *RespondToAuthChallengeInput {
	s.ClientMetadata = v
	return s
}

// SetSession sets the Session field's value.
func (s *RespondToAuthChallengeInput) SetSession(v string) *RespondToAuthChallengeInput {
	s.Session = &v
	return s
}

// SetUserContextData sets the UserContextData field's value.
func (s *RespondToAuthChallengeInput) SetUserContextData(v *UserContextDataType) *RespondToAuthChallengeInput {
	s.UserContextData = v
	return s
}

// The response to respond to the authentication challenge.
type RespondToAuthChallengeOutput struct {
	_ struct{} `type:"structure"`

	// The result returned by the server in response to the request to respond to
	// the authentication challenge.
	AuthenticationResult *AuthenticationResultType `type:"structure"`

	// The challenge name. For more information, see InitiateAuth (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html).
	ChallengeName *string `type:"string" enum:"ChallengeNameType"`

	// The challenge parameters. For more information, see InitiateAuth (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html).
	ChallengeParameters map[string]*string `type:"map"`

	// The session that should be passed both ways in challenge-response calls to
	// the service. If the caller must pass another challenge, they return a session
	// with other challenge parameters. This session should be passed as it is to
	// the next RespondToAuthChallenge API call.
	Session *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RespondToAuthChallengeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RespondToAuthChallengeOutput) GoString() string {
	return s.String()
}

// SetAuthenticationResult sets the AuthenticationResult field's value.
func (s *RespondToAuthChallengeOutput) SetAuthenticationResult(v *AuthenticationResultType) *RespondToAuthChallengeOutput {
	s.AuthenticationResult = v
	return s
}

// SetChallengeName sets the ChallengeName field's value.
func (s *RespondToAuthChallengeOutput) SetChallengeName(v string) *RespondToAuthChallengeOutput {
	s.ChallengeName = &v
	return s
}

// SetChallengeParameters sets the ChallengeParameters field's value.
func (s *RespondToAuthChallengeOutput) SetChallengeParameters(v map[string]*string) *RespondToAuthChallengeOutput {
	s.ChallengeParameters = v
	return s
}

// SetSession sets the Session field's value.
func (s *RespondToAuthChallengeOutput) SetSession(v string) *RespondToAuthChallengeOutput {
	s.Session = &v
	return s
}

type RevokeTokenInput struct {
	_ struct{} `type:"structure"`

	// The client ID for the token that you want to revoke.
	//
	// ClientId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RevokeTokenInput's
	// String and GoString methods.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The secret for the client ID. This is required only if the client ID has
	// a secret.
	//
	// ClientSecret is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RevokeTokenInput's
	// String and GoString methods.
	ClientSecret *string `min:"1" type:"string" sensitive:"true"`

	// The refresh token that you want to revoke.
	//
	// Token is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RevokeTokenInput's
	// String and GoString methods.
	//
	// Token is a required field
	Token *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeTokenInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.ClientSecret != nil && len(*s.ClientSecret) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientSecret", 1))
	}
	if s.Token == nil {
		invalidParams.Add(request.NewErrParamRequired("Token"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientId sets the ClientId field's value.
func (s *RevokeTokenInput) SetClientId(v string) *RevokeTokenInput {
	s.ClientId = &v
	return s
}

// SetClientSecret sets the ClientSecret field's value.
func (s *RevokeTokenInput) SetClientSecret(v string) *RevokeTokenInput {
	s.ClientSecret = &v
	return s
}

// SetToken sets the Token field's value.
func (s *RevokeTokenInput) SetToken(v string) *RevokeTokenInput {
	s.Token = &v
	return s
}

type RevokeTokenOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeTokenOutput) GoString() string {
	return s.String()
}

// The risk configuration type.
type RiskConfigurationType struct {
	_ struct{} `type:"structure"`

	// The account takeover risk configuration object, including the NotifyConfiguration
	// object and Actions to take if there is an account takeover.
	AccountTakeoverRiskConfiguration *AccountTakeoverRiskConfigurationType `type:"structure"`

	// The app client ID.
	//
	// ClientId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RiskConfigurationType's
	// String and GoString methods.
	ClientId *string `min:"1" type:"string" sensitive:"true"`

	// The compromised credentials risk configuration object, including the EventFilter
	// and the EventAction.
	CompromisedCredentialsRiskConfiguration *CompromisedCredentialsRiskConfigurationType `type:"structure"`

	// The last modified date.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The configuration to override the risk decision.
	RiskExceptionConfiguration *RiskExceptionConfigurationType `type:"structure"`

	// The user pool ID.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RiskConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RiskConfigurationType) GoString() string {
	return s.String()
}

// SetAccountTakeoverRiskConfiguration sets the AccountTakeoverRiskConfiguration field's value.
func (s *RiskConfigurationType) SetAccountTakeoverRiskConfiguration(v *AccountTakeoverRiskConfigurationType) *RiskConfigurationType {
	s.AccountTakeoverRiskConfiguration = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *RiskConfigurationType) SetClientId(v string) *RiskConfigurationType {
	s.ClientId = &v
	return s
}

// SetCompromisedCredentialsRiskConfiguration sets the CompromisedCredentialsRiskConfiguration field's value.
func (s *RiskConfigurationType) SetCompromisedCredentialsRiskConfiguration(v *CompromisedCredentialsRiskConfigurationType) *RiskConfigurationType {
	s.CompromisedCredentialsRiskConfiguration = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *RiskConfigurationType) SetLastModifiedDate(v time.Time) *RiskConfigurationType {
	s.LastModifiedDate = &v
	return s
}

// SetRiskExceptionConfiguration sets the RiskExceptionConfiguration field's value.
func (s *RiskConfigurationType) SetRiskExceptionConfiguration(v *RiskExceptionConfigurationType) *RiskConfigurationType {
	s.RiskExceptionConfiguration = v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *RiskConfigurationType) SetUserPoolId(v string) *RiskConfigurationType {
	s.UserPoolId = &v
	return s
}

// The type of the configuration to override the risk decision.
type RiskExceptionConfigurationType struct {
	_ struct{} `type:"structure"`

	// Overrides the risk decision to always block the pre-authentication requests.
	// The IP range is in CIDR notation, a compact representation of an IP address
	// and its routing prefix.
	BlockedIPRangeList []*string `type:"list"`

	// Risk detection isn't performed on the IP addresses in this range list. The
	// IP range is in CIDR notation.
	SkippedIPRangeList []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RiskExceptionConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RiskExceptionConfigurationType) GoString() string {
	return s.String()
}

// SetBlockedIPRangeList sets the BlockedIPRangeList field's value.
func (s *RiskExceptionConfigurationType) SetBlockedIPRangeList(v []*string) *RiskExceptionConfigurationType {
	s.BlockedIPRangeList = v
	return s
}

// SetSkippedIPRangeList sets the SkippedIPRangeList field's value.
func (s *RiskExceptionConfigurationType) SetSkippedIPRangeList(v []*string) *RiskExceptionConfigurationType {
	s.SkippedIPRangeList = v
	return s
}

// The type used for enabling SMS multi-factor authentication (MFA) at th