// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpointsmsvoicev2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateOriginationIdentity = "AssociateOriginationIdentity"

// AssociateOriginationIdentityRequest generates a "aws/request.Request" representing the
// client's request for the AssociateOriginationIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateOriginationIdentity for more information on using the AssociateOriginationIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateOriginationIdentityRequest method.
//    req, resp := client.AssociateOriginationIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/AssociateOriginationIdentity
func (c *PinpointSMSVoiceV2) AssociateOriginationIdentityRequest(input *AssociateOriginationIdentityInput) (req *request.Request, output *AssociateOriginationIdentityOutput) {
	op := &request.Operation{
		Name:       opAssociateOriginationIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateOriginationIdentityInput{}
	}

	output = &AssociateOriginationIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateOriginationIdentity API operation for Amazon Pinpoint SMS Voice V2.
//
// Associates the specified origination identity with a pool.
//
// If the origination identity is a phone number and is already associated with
// another pool, an Error is returned. A sender ID can be associated with multiple
// pools.
//
// If the origination identity configuration doesn't match the pool's configuration,
// an Error is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation AssociateOriginationIdentity for usage and error information.
//
// Returned Error Types:
//   * ServiceQuotaExceededException
//   The request would cause a service quota to be exceeded.
//
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time
//   or it could be that the requested action isn't valid for the current state
//   or configuration of the resource.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/AssociateOriginationIdentity
func (c *PinpointSMSVoiceV2) AssociateOriginationIdentity(input *AssociateOriginationIdentityInput) (*AssociateOriginationIdentityOutput, error) {
	req, out := c.AssociateOriginationIdentityRequest(input)
	return out, req.Send()
}

// AssociateOriginationIdentityWithContext is the same as AssociateOriginationIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateOriginationIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) AssociateOriginationIdentityWithContext(ctx aws.Context, input *AssociateOriginationIdentityInput, opts ...request.Option) (*AssociateOriginationIdentityOutput, error) {
	req, out := c.AssociateOriginationIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfigurationSet = "CreateConfigurationSet"

// CreateConfigurationSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfigurationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfigurationSet for more information on using the CreateConfigurationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConfigurationSetRequest method.
//    req, resp := client.CreateConfigurationSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateConfigurationSet
func (c *PinpointSMSVoiceV2) CreateConfigurationSetRequest(input *CreateConfigurationSetInput) (req *request.Request, output *CreateConfigurationSetOutput) {
	op := &request.Operation{
		Name:       opCreateConfigurationSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConfigurationSetInput{}
	}

	output = &CreateConfigurationSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConfigurationSet API operation for Amazon Pinpoint SMS Voice V2.
//
// Creates a new configuration set. After you create the configuration set,
// you can add one or more event destinations to it.
//
// A configuration set is a set of rules that you apply to the SMS and voice
// messages that you send.
//
// When you send a message, you can optionally specify a single configuration
// set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation CreateConfigurationSet for usage and error information.
//
// Returned Error Types:
//   * ServiceQuotaExceededException
//   The request would cause a service quota to be exceeded.
//
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time
//   or it could be that the requested action isn't valid for the current state
//   or configuration of the resource.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateConfigurationSet
func (c *PinpointSMSVoiceV2) CreateConfigurationSet(input *CreateConfigurationSetInput) (*CreateConfigurationSetOutput, error) {
	req, out := c.CreateConfigurationSetRequest(input)
	return out, req.Send()
}

// CreateConfigurationSetWithContext is the same as CreateConfigurationSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfigurationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) CreateConfigurationSetWithContext(ctx aws.Context, input *CreateConfigurationSetInput, opts ...request.Option) (*CreateConfigurationSetOutput, error) {
	req, out := c.CreateConfigurationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventDestination = "CreateEventDestination"

// CreateEventDestinationRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEventDestination for more information on using the CreateEventDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEventDestinationRequest method.
//    req, resp := client.CreateEventDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateEventDestination
func (c *PinpointSMSVoiceV2) CreateEventDestinationRequest(input *CreateEventDestinationInput) (req *request.Request, output *CreateEventDestinationOutput) {
	op := &request.Operation{
		Name:       opCreateEventDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEventDestinationInput{}
	}

	output = &CreateEventDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventDestination API operation for Amazon Pinpoint SMS Voice V2.
//
// Creates a new event destination in a configuration set.
//
// An event destination is a location where you send message events. The event
// options are Amazon CloudWatch, Amazon Kinesis Data Firehose, or Amazon SNS.
// For example, when a message is delivered successfully, you can send information
// about that event to an event destination, or send notifications to endpoints
// that are subscribed to an Amazon SNS topic.
//
// Each configuration set can contain between 0 and 5 event destinations. Each
// event destination can contain a reference to a single destination, such as
// a CloudWatch or Kinesis Data Firehose destination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation CreateEventDestination for usage and error information.
//
// Returned Error Types:
//   * ServiceQuotaExceededException
//   The request would cause a service quota to be exceeded.
//
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time
//   or it could be that the requested action isn't valid for the current state
//   or configuration of the resource.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateEventDestination
func (c *PinpointSMSVoiceV2) CreateEventDestination(input *CreateEventDestinationInput) (*CreateEventDestinationOutput, error) {
	req, out := c.CreateEventDestinationRequest(input)
	return out, req.Send()
}

// CreateEventDestinationWithContext is the same as CreateEventDestination with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) CreateEventDestinationWithContext(ctx aws.Context, input *CreateEventDestinationInput, opts ...request.Option) (*CreateEventDestinationOutput, error) {
	req, out := c.CreateEventDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOptOutList = "CreateOptOutList"

// CreateOptOutListRequest generates a "aws/request.Request" representing the
// client's request for the CreateOptOutList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOptOutList for more information on using the CreateOptOutList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateOptOutListRequest method.
//    req, resp := client.CreateOptOutListRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateOptOutList
func (c *PinpointSMSVoiceV2) CreateOptOutListRequest(input *CreateOptOutListInput) (req *request.Request, output *CreateOptOutListOutput) {
	op := &request.Operation{
		Name:       opCreateOptOutList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateOptOutListInput{}
	}

	output = &CreateOptOutListOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOptOutList API operation for Amazon Pinpoint SMS Voice V2.
//
// Creates a new opt-out list.
//
// If the opt-out list name already exists, an Error is returned.
//
// An opt-out list is a list of phone numbers that are opted out, meaning you
// can't send SMS or voice messages to them. If end user replies with the keyword
// "STOP," an entry for the phone number is added to the opt-out list. In addition
// to STOP, your recipients can use any supported opt-out keyword, such as CANCEL
// or OPTOUT. For a list of supported opt-out keywords, see SMS opt out (https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-manage.html#channels-sms-manage-optout)
// in the Amazon Pinpoint User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation CreateOptOutList for usage and error information.
//
// Returned Error Types:
//   * ServiceQuotaExceededException
//   The request would cause a service quota to be exceeded.
//
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time
//   or it could be that the requested action isn't valid for the current state
//   or configuration of the resource.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateOptOutList
func (c *PinpointSMSVoiceV2) CreateOptOutList(input *CreateOptOutListInput) (*CreateOptOutListOutput, error) {
	req, out := c.CreateOptOutListRequest(input)
	return out, req.Send()
}

// CreateOptOutListWithContext is the same as CreateOptOutList with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOptOutList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) CreateOptOutListWithContext(ctx aws.Context, input *CreateOptOutListInput, opts ...request.Option) (*CreateOptOutListOutput, error) {
	req, out := c.CreateOptOutListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePool = "CreatePool"

// CreatePoolRequest generates a "aws/request.Request" representing the
// client's request for the CreatePool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePool for more information on using the CreatePool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePoolRequest method.
//    req, resp := client.CreatePoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreatePool
func (c *PinpointSMSVoiceV2) CreatePoolRequest(input *CreatePoolInput) (req *request.Request, output *CreatePoolOutput) {
	op := &request.Operation{
		Name:       opCreatePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePoolInput{}
	}

	output = &CreatePoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePool API operation for Amazon Pinpoint SMS Voice V2.
//
// Creates a new pool and associates the specified origination identity to the
// pool. A pool can include one or more phone numbers and SenderIds that are
// associated with your Amazon Web Services account.
//
// The new pool inherits its configuration from the specified origination identity.
// This includes keywords, message type, opt-out list, two-way configuration,
// and self-managed opt-out configuration. Deletion protection isn't inherited
// from the origination identity and defaults to false.
//
// If the origination identity is a phone number and is already associated with
// another pool, an Error is returned. A sender ID can be associated with multiple
// pools.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation CreatePool for usage and error information.
//
// Returned Error Types:
//   * ServiceQuotaExceededException
//   The request would cause a service quota to be exceeded.
//
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time
//   or it could be that the requested action isn't valid for the current state
//   or configuration of the resource.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreatePool
func (c *PinpointSMSVoiceV2) CreatePool(input *CreatePoolInput) (*CreatePoolOutput, error) {
	req, out := c.CreatePoolRequest(input)
	return out, req.Send()
}

// CreatePoolWithContext is the same as CreatePool with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) CreatePoolWithContext(ctx aws.Context, input *CreatePoolInput, opts ...request.Option) (*CreatePoolOutput, error) {
	req, out := c.CreatePoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationSet = "DeleteConfigurationSet"

// DeleteConfigurationSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigurationSet for more information on using the DeleteConfigurationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConfigurationSetRequest method.
//    req, resp := client.DeleteConfigurationSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteConfigurationSet
func (c *PinpointSMSVoiceV2) DeleteConfigurationSetRequest(input *DeleteConfigurationSetInput) (req *request.Request, output *DeleteConfigurationSetOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConfigurationSetInput{}
	}

	output = &DeleteConfigurationSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteConfigurationSet API operation for Amazon Pinpoint SMS Voice V2.
//
// Deletes an existing configuration set.
//
// A configuration set is a set of rules that you apply to voice and SMS messages
// that you send. In a configuration set, you can specify a destination for
// specific types of events related to voice and SMS messages.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DeleteConfigurationSet for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteConfigurationSet
func (c *PinpointSMSVoiceV2) DeleteConfigurationSet(input *DeleteConfigurationSetInput) (*DeleteConfigurationSetOutput, error) {
	req, out := c.DeleteConfigurationSetRequest(input)
	return out, req.Send()
}

// DeleteConfigurationSetWithContext is the same as DeleteConfigurationSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DeleteConfigurationSetWithContext(ctx aws.Context, input *DeleteConfigurationSetInput, opts ...request.Option) (*DeleteConfigurationSetOutput, error) {
	req, out := c.DeleteConfigurationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDefaultMessageType = "DeleteDefaultMessageType"

// DeleteDefaultMessageTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDefaultMessageType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDefaultMessageType for more information on using the DeleteDefaultMessageType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDefaultMessageTypeRequest method.
//    req, resp := client.DeleteDefaultMessageTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteDefaultMessageType
func (c *PinpointSMSVoiceV2) DeleteDefaultMessageTypeRequest(input *DeleteDefaultMessageTypeInput) (req *request.Request, output *DeleteDefaultMessageTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteDefaultMessageType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDefaultMessageTypeInput{}
	}

	output = &DeleteDefaultMessageTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDefaultMessageType API operation for Amazon Pinpoint SMS Voice V2.
//
// Deletes an existing default message type on a configuration set.
//
// A message type is a type of messages that you plan to send. If you send account-related
// messages or time-sensitive messages such as one-time passcodes, choose Transactional.
// If you plan to send messages that contain marketing material or other promotional
// content, choose Promotional. This setting applies to your entire Amazon Web
// Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DeleteDefaultMessageType for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteDefaultMessageType
func (c *PinpointSMSVoiceV2) DeleteDefaultMessageType(input *DeleteDefaultMessageTypeInput) (*DeleteDefaultMessageTypeOutput, error) {
	req, out := c.DeleteDefaultMessageTypeRequest(input)
	return out, req.Send()
}

// DeleteDefaultMessageTypeWithContext is the same as DeleteDefaultMessageType with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDefaultMessageType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DeleteDefaultMessageTypeWithContext(ctx aws.Context, input *DeleteDefaultMessageTypeInput, opts ...request.Option) (*DeleteDefaultMessageTypeOutput, error) {
	req, out := c.DeleteDefaultMessageTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDefaultSenderId = "DeleteDefaultSenderId"

// DeleteDefaultSenderIdRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDefaultSenderId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDefaultSenderId for more information on using the DeleteDefaultSenderId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDefaultSenderIdRequest method.
//    req, resp := client.DeleteDefaultSenderIdRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteDefaultSenderId
func (c *PinpointSMSVoiceV2) DeleteDefaultSenderIdRequest(input *DeleteDefaultSenderIdInput) (req *request.Request, output *DeleteDefaultSenderIdOutput) {
	op := &request.Operation{
		Name:       opDeleteDefaultSenderId,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDefaultSenderIdInput{}
	}

	output = &DeleteDefaultSenderIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDefaultSenderId API operation for Amazon Pinpoint SMS Voice V2.
//
// Deletes an existing default sender ID on a configuration set.
//
// A default sender ID is the identity that appears on recipients' devices when
// they receive SMS messages. Support for sender ID capabilities varies by country
// or region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DeleteDefaultSenderId for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteDefaultSenderId
func (c *PinpointSMSVoiceV2) DeleteDefaultSenderId(input *DeleteDefaultSenderIdInput) (*DeleteDefaultSenderIdOutput, error) {
	req, out := c.DeleteDefaultSenderIdRequest(input)
	return out, req.Send()
}

// DeleteDefaultSenderIdWithContext is the same as DeleteDefaultSenderId with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDefaultSenderId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DeleteDefaultSenderIdWithContext(ctx aws.Context, input *DeleteDefaultSenderIdInput, opts ...request.Option) (*DeleteDefaultSenderIdOutput, error) {
	req, out := c.DeleteDefaultSenderIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventDestination = "DeleteEventDestination"

// DeleteEventDestinationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventDestination for more information on using the DeleteEventDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEventDestinationRequest method.
//    req, resp := client.DeleteEventDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteEventDestination
func (c *PinpointSMSVoiceV2) DeleteEventDestinationRequest(input *DeleteEventDestinationInput) (req *request.Request, output *DeleteEventDestinationOutput) {
	op := &request.Operation{
		Name:       opDeleteEventDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventDestinationInput{}
	}

	output = &DeleteEventDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEventDestination API operation for Amazon Pinpoint SMS Voice V2.
//
// Deletes an existing event destination.
//
// An event destination is a location where you send response information about
// the messages that you send. For example, when a message is delivered successfully,
// you can send information about that event to an Amazon CloudWatch destination,
// or send notifications to endpoints that are subscribed to an Amazon SNS topic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DeleteEventDestination for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteEventDestination
func (c *PinpointSMSVoiceV2) DeleteEventDestination(input *DeleteEventDestinationInput) (*DeleteEventDestinationOutput, error) {
	req, out := c.DeleteEventDestinationRequest(input)
	return out, req.Send()
}

// DeleteEventDestinationWithContext is the same as DeleteEventDestination with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DeleteEventDestinationWithContext(ctx aws.Context, input *DeleteEventDestinationInput, opts ...request.Option) (*DeleteEventDestinationOutput, error) {
	req, out := c.DeleteEventDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKeyword = "DeleteKeyword"

// DeleteKeywordRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKeyword operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKeyword for more information on using the DeleteKeyword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteKeywordRequest method.
//    req, resp := client.DeleteKeywordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteKeyword
func (c *PinpointSMSVoiceV2) DeleteKeywordRequest(input *DeleteKeywordInput) (req *request.Request, output *DeleteKeywordOutput) {
	op := &request.Operation{
		Name:       opDeleteKeyword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteKeywordInput{}
	}

	output = &DeleteKeywordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteKeyword API operation for Amazon Pinpoint SMS Voice V2.
//
// Deletes an existing keyword from an origination phone number or pool.
//
// A keyword is a word that you can search for on a particular phone number
// or pool. It is also a specific word or phrase that an end user can send to
// your number to elicit a response, such as an informational message or a special
// offer. When your number receives a message that begins with a keyword, Amazon
// Pinpoint responds with a customizable message.
//
// Keywords "HELP" and "STOP" can't be deleted or modified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DeleteKeyword for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time
//   or it could be that the requested action isn't valid for the current state
//   or configuration of the resource.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteKeyword
func (c *PinpointSMSVoiceV2) DeleteKeyword(input *DeleteKeywordInput) (*DeleteKeywordOutput, error) {
	req, out := c.DeleteKeywordRequest(input)
	return out, req.Send()
}

// DeleteKeywordWithContext is the same as DeleteKeyword with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKeyword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DeleteKeywordWithContext(ctx aws.Context, input *DeleteKeywordInput, opts ...request.Option) (*DeleteKeywordOutput, error) {
	req, out := c.DeleteKeywordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOptOutList = "DeleteOptOutList"

// DeleteOptOutListRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOptOutList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOptOutList for more information on using the DeleteOptOutList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteOptOutListRequest method.
//    req, resp := client.DeleteOptOutListRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteOptOutList
func (c *PinpointSMSVoiceV2) DeleteOptOutListRequest(input *DeleteOptOutListInput) (req *request.Request, output *DeleteOptOutListOutput) {
	op := &request.Operation{
		Name:       opDeleteOptOutList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOptOutListInput{}
	}

	output = &DeleteOptOutListOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteOptOutList API operation for Amazon Pinpoint SMS Voice V2.
//
// Deletes an existing opt-out list. All opted out phone numbers in the opt-out
// list are deleted.
//
// If the specified opt-out list name doesn't exist or is in-use by an origination
// phone number or pool, an Error is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DeleteOptOutList for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time
//   or it could be that the requested action isn't valid for the current state
//   or configuration of the resource.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteOptOutList
func (c *PinpointSMSVoiceV2) DeleteOptOutList(input *DeleteOptOutListInput) (*DeleteOptOutListOutput, error) {
	req, out := c.DeleteOptOutListRequest(input)
	return out, req.Send()
}

// DeleteOptOutListWithContext is the same as DeleteOptOutList with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOptOutList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DeleteOptOutListWithContext(ctx aws.Context, input *DeleteOptOutListInput, opts ...request.Option) (*DeleteOptOutListOutput, error) {
	req, out := c.DeleteOptOutListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOptedOutNumber = "DeleteOptedOutNumber"

// DeleteOptedOutNumberRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOptedOutNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOptedOutNumber for more information on using the DeleteOptedOutNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteOptedOutNumberRequest method.
//    req, resp := client.DeleteOptedOutNumberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteOptedOutNumber
func (c *PinpointSMSVoiceV2) DeleteOptedOutNumberRequest(input *DeleteOptedOutNumberInput) (req *request.Request, output *DeleteOptedOutNumberOutput) {
	op := &request.Operation{
		Name:       opDeleteOptedOutNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOptedOutNumberInput{}
	}

	output = &DeleteOptedOutNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteOptedOutNumber API operation for Amazon Pinpoint SMS Voice V2.
//
// Deletes an existing opted out destination phone number from the specified
// opt-out list.
//
// Each destination phone number can only be deleted once every 30 days.
//
// If the specified destination phone number doesn't exist or if the opt-out
// list doesn't exist, an Error is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DeleteOptedOutNumber for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time
//   or it could be that the requested action isn't valid for the current state
//   or configuration of the resource.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteOptedOutNumber
func (c *PinpointSMSVoiceV2) DeleteOptedOutNumber(input *DeleteOptedOutNumberInput) (*DeleteOptedOutNumberOutput, error) {
	req, out := c.DeleteOptedOutNumberRequest(input)
	return out, req.Send()
}

// DeleteOptedOutNumberWithContext is the same as DeleteOptedOutNumber with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOptedOutNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DeleteOptedOutNumberWithContext(ctx aws.Context, input *DeleteOptedOutNumberInput, opts ...request.Option) (*DeleteOptedOutNumberOutput, error) {
	req, out := c.DeleteOptedOutNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePool = "DeletePool"

// DeletePoolRequest generates a "aws/request.Request" representing the
// client's request for the DeletePool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePool for more information on using the DeletePool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePoolRequest method.
//    req, resp := client.DeletePoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeletePool
func (c *PinpointSMSVoiceV2) DeletePoolRequest(input *DeletePoolInput) (req *request.Request, output *DeletePoolOutput) {
	op := &request.Operation{
		Name:       opDeletePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePoolInput{}
	}

	output = &DeletePoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePool API operation for Amazon Pinpoint SMS Voice V2.
//
// Deletes an existing pool. Deleting a pool disassociates all origination identities
// from that pool.
//
// If the pool status isn't active or if deletion protection is enabled, an
// Error is returned.
//
// A pool is a collection of phone numbers and SenderIds. A pool can include
// one or more phone numbers and SenderIds that are associated with your Amazon
// Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DeletePool for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time
//   or it could be that the requested action isn't valid for the current state
//   or configuration of the resource.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeletePool
func (c *PinpointSMSVoiceV2) DeletePool(input *DeletePoolInput) (*DeletePoolOutput, error) {
	req, out := c.DeletePoolRequest(input)
	return out, req.Send()
}

// DeletePoolWithContext is the same as DeletePool with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DeletePoolWithContext(ctx aws.Context, input *DeletePoolInput, opts ...request.Option) (*DeletePoolOutput, error) {
	req, out := c.DeletePoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTextMessageSpendLimitOverride = "DeleteTextMessageSpendLimitOverride"

// DeleteTextMessageSpendLimitOverrideRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTextMessageSpendLimitOverride operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTextMessageSpendLimitOverride for more information on using the DeleteTextMessageSpendLimitOverride
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTextMessageSpendLimitOverrideRequest method.
//    req, resp := client.DeleteTextMessageSpendLimitOverrideRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteTextMessageSpendLimitOverride
func (c *PinpointSMSVoiceV2) DeleteTextMessageSpendLimitOverrideRequest(input *DeleteTextMessageSpendLimitOverrideInput) (req *request.Request, output *DeleteTextMessageSpendLimitOverrideOutput) {
	op := &request.Operation{
		Name:       opDeleteTextMessageSpendLimitOverride,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTextMessageSpendLimitOverrideInput{}
	}

	output = &DeleteTextMessageSpendLimitOverrideOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTextMessageSpendLimitOverride API operation for Amazon Pinpoint SMS Voice V2.
//
// Deletes an account-level monthly spending limit override for sending text
// messages. Deleting a spend limit override will set the EnforcedLimit to equal
// the MaxLimit, which is controlled by Amazon Web Services. For more information
// on spend limits (quotas) see Amazon Pinpoint quotas (https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html)
// in the Amazon Pinpoint Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DeleteTextMessageSpendLimitOverride for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteTextMessageSpendLimitOverride
func (c *PinpointSMSVoiceV2) DeleteTextMessageSpendLimitOverride(input *DeleteTextMessageSpendLimitOverrideInput) (*DeleteTextMessageSpendLimitOverrideOutput, error) {
	req, out := c.DeleteTextMessageSpendLimitOverrideRequest(input)
	return out, req.Send()
}

// DeleteTextMessageSpendLimitOverrideWithContext is the same as DeleteTextMessageSpendLimitOverride with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTextMessageSpendLimitOverride for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DeleteTextMessageSpendLimitOverrideWithContext(ctx aws.Context, input *DeleteTextMessageSpendLimitOverrideInput, opts ...request.Option) (*DeleteTextMessageSpendLimitOverrideOutput, error) {
	req, out := c.DeleteTextMessageSpendLimitOverrideRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceMessageSpendLimitOverride = "DeleteVoiceMessageSpendLimitOverride"

// DeleteVoiceMessageSpendLimitOverrideRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceMessageSpendLimitOverride operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceMessageSpendLimitOverride for more information on using the DeleteVoiceMessageSpendLimitOverride
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVoiceMessageSpendLimitOverrideRequest method.
//    req, resp := client.DeleteVoiceMessageSpendLimitOverrideRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteVoiceMessageSpendLimitOverride
func (c *PinpointSMSVoiceV2) DeleteVoiceMessageSpendLimitOverrideRequest(input *DeleteVoiceMessageSpendLimitOverrideInput) (req *request.Request, output *DeleteVoiceMessageSpendLimitOverrideOutput) {
	op := &request.Operation{
		Name:       opDeleteVoiceMessageSpendLimitOverride,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVoiceMessageSpendLimitOverrideInput{}
	}

	output = &DeleteVoiceMessageSpendLimitOverrideOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVoiceMessageSpendLimitOverride API operation for Amazon Pinpoint SMS Voice V2.
//
// Deletes an account level monthly spend limit override for sending voice messages.
// Deleting a spend limit override sets the EnforcedLimit equal to the MaxLimit,
// which is controlled by Amazon Web Services. For more information on spending
// limits (quotas) see Amazon Pinpoint quotas (https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html)
// in the Amazon Pinpoint Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DeleteVoiceMessageSpendLimitOverride for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteVoiceMessageSpendLimitOverride
func (c *PinpointSMSVoiceV2) DeleteVoiceMessageSpendLimitOverride(input *DeleteVoiceMessageSpendLimitOverrideInput) (*DeleteVoiceMessageSpendLimitOverrideOutput, error) {
	req, out := c.DeleteVoiceMessageSpendLimitOverrideRequest(input)
	return out, req.Send()
}

// DeleteVoiceMessageSpendLimitOverrideWithContext is the same as DeleteVoiceMessageSpendLimitOverride with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceMessageSpendLimitOverride for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DeleteVoiceMessageSpendLimitOverrideWithContext(ctx aws.Context, input *DeleteVoiceMessageSpendLimitOverrideInput, opts ...request.Option) (*DeleteVoiceMessageSpendLimitOverrideOutput, error) {
	req, out := c.DeleteVoiceMessageSpendLimitOverrideRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountAttributes = "DescribeAccountAttributes"

// DescribeAccountAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountAttributes for more information on using the DescribeAccountAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountAttributesRequest method.
//    req, resp := client.DescribeAccountAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountAttributes
func (c *PinpointSMSVoiceV2) DescribeAccountAttributesRequest(input *DescribeAccountAttributesInput) (req *request.Request, output *DescribeAccountAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAccountAttributesInput{}
	}

	output = &DescribeAccountAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountAttributes API operation for Amazon Pinpoint SMS Voice V2.
//
// Describes attributes of your Amazon Web Services account. The supported account
// attributes include account tier, which indicates whether your account is
// in the sandbox or production environment. When you're ready to move your
// account out of the sandbox, create an Amazon Web Services Support case for
// a service limit increase request.
//
// New Amazon Pinpoint accounts are placed into an SMS or voice sandbox. The
// sandbox protects both Amazon Web Services end recipients and SMS or voice
// recipients from fraud and abuse.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DescribeAccountAttributes for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountAttributes
func (c *PinpointSMSVoiceV2) DescribeAccountAttributes(input *DescribeAccountAttributesInput) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	return out, req.Send()
}

// DescribeAccountAttributesWithContext is the same as DescribeAccountAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribeAccountAttributesWithContext(ctx aws.Context, input *DescribeAccountAttributesInput, opts ...request.Option) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAccountAttributesPages iterates over the pages of a DescribeAccountAttributes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAccountAttributes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAccountAttributes operation.
//    pageNum := 0
//    err := client.DescribeAccountAttributesPages(params,
//        func(page *pinpointsmsvoicev2.DescribeAccountAttributesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *PinpointSMSVoiceV2) DescribeAccountAttributesPages(input *DescribeAccountAttributesInput, fn func(*DescribeAccountAttributesOutput, bool) bool) error {
	return c.DescribeAccountAttributesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAccountAttributesPagesWithContext same as DescribeAccountAttributesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribeAccountAttributesPagesWithContext(ctx aws.Context, input *DescribeAccountAttributesInput, fn func(*DescribeAccountAttributesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAccountAttributesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAccountAttributesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAccountAttributesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeAccountLimits = "DescribeAccountLimits"

// DescribeAccountLimitsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountLimits operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountLimits for more information on using the DescribeAccountLimits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountLimitsRequest method.
//    req, resp := client.DescribeAccountLimitsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountLimits
func (c *PinpointSMSVoiceV2) DescribeAccountLimitsRequest(input *DescribeAccountLimitsInput) (req *request.Request, output *DescribeAccountLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAccountLimitsInput{}
	}

	output = &DescribeAccountLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountLimits API operation for Amazon Pinpoint SMS Voice V2.
//
// Describes the current Amazon Pinpoint SMS Voice V2 resource quotas for your
// account. The description for a quota includes the quota name, current usage
// toward that quota, and the quota's maximum value.
//
// When you establish an Amazon Web Services account, the account has initial
// quotas on the maximum number of configuration sets, opt-out lists, phone
// numbers, and pools that you can create in a given Region. For more information
// see Amazon Pinpoint quotas (https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html)
// in the Amazon Pinpoint Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DescribeAccountLimits for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountLimits
func (c *PinpointSMSVoiceV2) DescribeAccountLimits(input *DescribeAccountLimitsInput) (*DescribeAccountLimitsOutput, error) {
	req, out := c.DescribeAccountLimitsRequest(input)
	return out, req.Send()
}

// DescribeAccountLimitsWithContext is the same as DescribeAccountLimits with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribeAccountLimitsWithContext(ctx aws.Context, input *DescribeAccountLimitsInput, opts ...request.Option) (*DescribeAccountLimitsOutput, error) {
	req, out := c.DescribeAccountLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAccountLimitsPages iterates over the pages of a DescribeAccountLimits operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAccountLimits method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAccountLimits operation.
//    pageNum := 0
//    err := client.DescribeAccountLimitsPages(params,
//        func(page *pinpointsmsvoicev2.DescribeAccountLimitsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *PinpointSMSVoiceV2) DescribeAccountLimitsPages(input *DescribeAccountLimitsInput, fn func(*DescribeAccountLimitsOutput, bool) bool) error {
	return c.DescribeAccountLimitsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAccountLimitsPagesWithContext same as DescribeAccountLimitsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribeAccountLimitsPagesWithContext(ctx aws.Context, input *DescribeAccountLimitsInput, fn func(*DescribeAccountLimitsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAccountLimitsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAccountLimitsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAccountLimitsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeConfigurationSets = "DescribeConfigurationSets"

// DescribeConfigurationSetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurationSets for more information on using the DescribeConfigurationSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationSetsRequest method.
//    req, resp := client.DescribeConfigurationSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeConfigurationSets
func (c *PinpointSMSVoiceV2) DescribeConfigurationSetsRequest(input *DescribeConfigurationSetsInput) (req *request.Request, output *DescribeConfigurationSetsOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeConfigurationSetsInput{}
	}

	output = &DescribeConfigurationSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationSets API operation for Amazon Pinpoint SMS Voice V2.
//
// Describes the specified configuration sets or all in your account.
//
// If you specify configuration set names, the output includes information for
// only the specified configuration sets. If you specify filters, the output
// includes information for only those configuration sets that meet the filter
// criteria. If you don't specify configuration set names or filters, the output
// includes information for all configuration sets.
//
// If you specify a configuration set name that isn't valid, an error is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DescribeConfigurationSets for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeConfigurationSets
func (c *PinpointSMSVoiceV2) DescribeConfigurationSets(input *DescribeConfigurationSetsInput) (*DescribeConfigurationSetsOutput, error) {
	req, out := c.DescribeConfigurationSetsRequest(input)
	return out, req.Send()
}

// DescribeConfigurationSetsWithContext is the same as DescribeConfigurationSets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribeConfigurationSetsWithContext(ctx aws.Context, input *DescribeConfigurationSetsInput, opts ...request.Option) (*DescribeConfigurationSetsOutput, error) {
	req, out := c.DescribeConfigurationSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeConfigurationSetsPages iterates over the pages of a DescribeConfigurationSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeConfigurationSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeConfigurationSets operation.
//    pageNum := 0
//    err := client.DescribeConfigurationSetsPages(params,
//        func(page *pinpointsmsvoicev2.DescribeConfigurationSetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *PinpointSMSVoiceV2) DescribeConfigurationSetsPages(input *DescribeConfigurationSetsInput, fn func(*DescribeConfigurationSetsOutput, bool) bool) error {
	return c.DescribeConfigurationSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeConfigurationSetsPagesWithContext same as DescribeConfigurationSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribeConfigurationSetsPagesWithContext(ctx aws.Context, input *DescribeConfigurationSetsInput, fn func(*DescribeConfigurationSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeConfigurationSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeConfigurationSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeConfigurationSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeKeywords = "DescribeKeywords"

// DescribeKeywordsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeKeywords operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeKeywords for more information on using the DescribeKeywords
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeKeywordsRequest method.
//    req, resp := client.DescribeKeywordsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeKeywords
func (c *PinpointSMSVoiceV2) DescribeKeywordsRequest(input *DescribeKeywordsInput) (req *request.Request, output *DescribeKeywordsOutput) {
	op := &request.Operation{
		Name:       opDescribeKeywords,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeKeywordsInput{}
	}

	output = &DescribeKeywordsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeKeywords API operation for Amazon Pinpoint SMS Voice V2.
//
// Describes the specified keywords or all keywords on your origination phone
// number or pool.
//
// A keyword is a word that you can search for on a particular phone number
// or pool. It is also a specific word or phrase that an end user can send to
// your number to elicit a response, such as an informational message or a special
// offer. When your number receives a message that begins with a keyword, Amazon
// Pinpoint responds with a customizable message.
//
// If you specify a keyword that isn't valid, an Error is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DescribeKeywords for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeKeywords
func (c *PinpointSMSVoiceV2) DescribeKeywords(input *DescribeKeywordsInput) (*DescribeKeywordsOutput, error) {
	req, out := c.DescribeKeywordsRequest(input)
	return out, req.Send()
}

// DescribeKeywordsWithContext is the same as DescribeKeywords with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeKeywords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribeKeywordsWithContext(ctx aws.Context, input *DescribeKeywordsInput, opts ...request.Option) (*DescribeKeywordsOutput, error) {
	req, out := c.DescribeKeywordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeKeywordsPages iterates over the pages of a DescribeKeywords operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeKeywords method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeKeywords operation.
//    pageNum := 0
//    err := client.DescribeKeywordsPages(params,
//        func(page *pinpointsmsvoicev2.DescribeKeywordsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *PinpointSMSVoiceV2) DescribeKeywordsPages(input *DescribeKeywordsInput, fn func(*DescribeKeywordsOutput, bool) bool) error {
	return c.DescribeKeywordsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeKeywordsPagesWithContext same as DescribeKeywordsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribeKeywordsPagesWithContext(ctx aws.Context, input *DescribeKeywordsInput, fn func(*DescribeKeywordsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeKeywordsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeKeywordsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeKeywordsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeOptOutLists = "DescribeOptOutLists"

// DescribeOptOutListsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOptOutLists operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOptOutLists for more information on using the DescribeOptOutLists
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOptOutListsRequest method.
//    req, resp := client.DescribeOptOutListsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptOutLists
func (c *PinpointSMSVoiceV2) DescribeOptOutListsRequest(input *DescribeOptOutListsInput) (req *request.Request, output *DescribeOptOutListsOutput) {
	op := &request.Operation{
		Name:       opDescribeOptOutLists,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOptOutListsInput{}
	}

	output = &DescribeOptOutListsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOptOutLists API operation for Amazon Pinpoint SMS Voice V2.
//
// Describes the specified opt-out list or all opt-out lists in your account.
//
// If you specify opt-out list names, the output includes information for only
// the specified opt-out lists. Opt-out lists include only those that meet the
// filter criteria. If you don't specify opt-out list names or filters, the
// output includes information for all opt-out lists.
//
// If you specify an opt-out list name that isn't valid, an Error is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DescribeOptOutLists for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptOutLists
func (c *PinpointSMSVoiceV2) DescribeOptOutLists(input *DescribeOptOutListsInput) (*DescribeOptOutListsOutput, error) {
	req, out := c.DescribeOptOutListsRequest(input)
	return out, req.Send()
}

// DescribeOptOutListsWithContext is the same as DescribeOptOutLists with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOptOutLists for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribeOptOutListsWithContext(ctx aws.Context, input *DescribeOptOutListsInput, opts ...request.Option) (*DescribeOptOutListsOutput, error) {
	req, out := c.DescribeOptOutListsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOptOutListsPages iterates over the pages of a DescribeOptOutLists operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOptOutLists method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeOptOutLists operation.
//    pageNum := 0
//    err := client.DescribeOptOutListsPages(params,
//        func(page *pinpointsmsvoicev2.DescribeOptOutListsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *PinpointSMSVoiceV2) DescribeOptOutListsPages(input *DescribeOptOutListsInput, fn func(*DescribeOptOutListsOutput, bool) bool) error {
	return c.DescribeOptOutListsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOptOutListsPagesWithContext same as DescribeOptOutListsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribeOptOutListsPagesWithContext(ctx aws.Context, input *DescribeOptOutListsInput, fn func(*DescribeOptOutListsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOptOutListsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOptOutListsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeOptOutListsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeOptedOutNumbers = "DescribeOptedOutNumbers"

// DescribeOptedOutNumbersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOptedOutNumbers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOptedOutNumbers for more information on using the DescribeOptedOutNumbers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOptedOutNumbersRequest method.
//    req, resp := client.DescribeOptedOutNumbersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptedOutNumbers
func (c *PinpointSMSVoiceV2) DescribeOptedOutNumbersRequest(input *DescribeOptedOutNumbersInput) (req *request.Request, output *DescribeOptedOutNumbersOutput) {
	op := &request.Operation{
		Name:       opDescribeOptedOutNumbers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOptedOutNumbersInput{}
	}

	output = &DescribeOptedOutNumbersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOptedOutNumbers API operation for Amazon Pinpoint SMS Voice V2.
//
// Describes the specified opted out destination numbers or all opted out destination
// numbers in an opt-out list.
//
// If you specify opted out numbers, the output includes information for only
// the specified opted out numbers. If you specify filters, the output includes
// information for only those opted out numbers that meet the filter criteria.
// If you don't specify opted out numbers or filters, the output includes information
// for all opted out destination numbers in your opt-out list.
//
// If you specify an opted out number that isn't valid, an Error is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DescribeOptedOutNumbers for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptedOutNumbers
func (c *PinpointSMSVoiceV2) DescribeOptedOutNumbers(input *DescribeOptedOutNumbersInput) (*DescribeOptedOutNumbersOutput, error) {
	req, out := c.DescribeOptedOutNumbersRequest(input)
	return out, req.Send()
}

// DescribeOptedOutNumbersWithContext is the same as DescribeOptedOutNumbers with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOptedOutNumbers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribeOptedOutNumbersWithContext(ctx aws.Context, input *DescribeOptedOutNumbersInput, opts ...request.Option) (*DescribeOptedOutNumbersOutput, error) {
	req, out := c.DescribeOptedOutNumbersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOptedOutNumbersPages iterates over the pages of a DescribeOptedOutNumbers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOptedOutNumbers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeOptedOutNumbers operation.
//    pageNum := 0
//    err := client.DescribeOptedOutNumbersPages(params,
//        func(page *pinpointsmsvoicev2.DescribeOptedOutNumbersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *PinpointSMSVoiceV2) DescribeOptedOutNumbersPages(input *DescribeOptedOutNumbersInput, fn func(*DescribeOptedOutNumbersOutput, bool) bool) error {
	return c.DescribeOptedOutNumbersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOptedOutNumbersPagesWithContext same as DescribeOptedOutNumbersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribeOptedOutNumbersPagesWithContext(ctx aws.Context, input *DescribeOptedOutNumbersInput, fn func(*DescribeOptedOutNumbersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOptedOutNumbersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOptedOutNumbersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeOptedOutNumbersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribePhoneNumbers = "DescribePhoneNumbers"

// DescribePhoneNumbersRequest generates a "aws/request.Request" representing the
// client's request for the DescribePhoneNumbers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePhoneNumbers for more information on using the DescribePhoneNumbers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePhoneNumbersRequest method.
//    req, resp := client.DescribePhoneNumbersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePhoneNumbers
func (c *PinpointSMSVoiceV2) DescribePhoneNumbersRequest(input *DescribePhoneNumbersInput) (req *request.Request, output *DescribePhoneNumbersOutput) {
	op := &request.Operation{
		Name:       opDescribePhoneNumbers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePhoneNumbersInput{}
	}

	output = &DescribePhoneNumbersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePhoneNumbers API operation for Amazon Pinpoint SMS Voice V2.
//
// Describes the specified origination phone number, or all the phone numbers
// in your account.
//
// If you specify phone number IDs, the output includes information for only
// the specified phone numbers. If you specify filters, the output includes
// information for only those phone numbers that meet the filter criteria. If
// you don't specify phone number IDs or filters, the output includes information
// for all phone numbers.
//
// If you specify a phone number ID that isn't valid, an Error is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DescribePhoneNumbers for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePhoneNumbers
func (c *PinpointSMSVoiceV2) DescribePhoneNumbers(input *DescribePhoneNumbersInput) (*DescribePhoneNumbersOutput, error) {
	req, out := c.DescribePhoneNumbersRequest(input)
	return out, req.Send()
}

// DescribePhoneNumbersWithContext is the same as DescribePhoneNumbers with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePhoneNumbers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribePhoneNumbersWithContext(ctx aws.Context, input *DescribePhoneNumbersInput, opts ...request.Option) (*DescribePhoneNumbersOutput, error) {
	req, out := c.DescribePhoneNumbersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribePhoneNumbersPages iterates over the pages of a DescribePhoneNumbers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribePhoneNumbers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribePhoneNumbers operation.
//    pageNum := 0
//    err := client.DescribePhoneNumbersPages(params,
//        func(page *pinpointsmsvoicev2.DescribePhoneNumbersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *PinpointSMSVoiceV2) DescribePhoneNumbersPages(input *DescribePhoneNumbersInput, fn func(*DescribePhoneNumbersOutput, bool) bool) error {
	return c.DescribePhoneNumbersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribePhoneNumbersPagesWithContext same as DescribePhoneNumbersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribePhoneNumbersPagesWithContext(ctx aws.Context, input *DescribePhoneNumbersInput, fn func(*DescribePhoneNumbersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribePhoneNumbersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePhoneNumbersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribePhoneNumbersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribePools = "DescribePools"

// DescribePoolsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePools operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePools for more information on using the DescribePools
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePoolsRequest method.
//    req, resp := client.DescribePoolsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePools
func (c *PinpointSMSVoiceV2) DescribePoolsRequest(input *DescribePoolsInput) (req *request.Request, output *DescribePoolsOutput) {
	op := &request.Operation{
		Name:       opDescribePools,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePoolsInput{}
	}

	output = &DescribePoolsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePools API operation for Amazon Pinpoint SMS Voice V2.
//
// Retrieves the specified pools or all pools associated with your Amazon Web
// Services account.
//
// If you specify pool IDs, the output includes information for only the specified
// pools. If you specify filters, the output includes information for only those
// pools that meet the filter criteria. If you don't specify pool IDs or filters,
// the output includes information for all pools.
//
// If you specify a pool ID that isn't valid, an Error is returned.
//
// A pool is a collection of phone numbers and SenderIds. A pool can include
// one or more phone numbers and SenderIds that are associated with your Amazon
// Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DescribePools for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePools
func (c *PinpointSMSVoiceV2) DescribePools(input *DescribePoolsInput) (*DescribePoolsOutput, error) {
	req, out := c.DescribePoolsRequest(input)
	return out, req.Send()
}

// DescribePoolsWithContext is the same as DescribePools with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePools for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribePoolsWithContext(ctx aws.Context, input *DescribePoolsInput, opts ...request.Option) (*DescribePoolsOutput, error) {
	req, out := c.DescribePoolsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribePoolsPages iterates over the pages of a DescribePools operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribePools method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribePools operation.
//    pageNum := 0
//    err := client.DescribePoolsPages(params,
//        func(page *pinpointsmsvoicev2.DescribePoolsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *PinpointSMSVoiceV2) DescribePoolsPages(input *DescribePoolsInput, fn func(*DescribePoolsOutput, bool) bool) error {
	return c.DescribePoolsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribePoolsPagesWithContext same as DescribePoolsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribePoolsPagesWithContext(ctx aws.Context, input *DescribePoolsInput, fn func(*DescribePoolsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribePoolsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePoolsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribePoolsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeSenderIds = "DescribeSenderIds"

// DescribeSenderIdsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSenderIds operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSenderIds for more information on using the DescribeSenderIds
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSenderIdsRequest method.
//    req, resp := client.DescribeSenderIdsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSenderIds
func (c *PinpointSMSVoiceV2) DescribeSenderIdsRequest(input *DescribeSenderIdsInput) (req *request.Request, output *DescribeSenderIdsOutput) {
	op := &request.Operation{
		Name:       opDescribeSenderIds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSenderIdsInput{}
	}

	output = &DescribeSenderIdsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSenderIds API operation for Amazon Pinpoint SMS Voice V2.
//
// Describes the specified SenderIds or all SenderIds associated with your Amazon
// Web Services account.
//
// If you specify SenderIds, the output includes information for only the specified
// SenderIds. If you specify filters, the output includes information for only
// those SenderIds that meet the filter criteria. If you don't specify SenderIds
// or filters, the output includes information for all SenderIds.
//
// f you specify a sender ID that isn't valid, an Error is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DescribeSenderIds for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSenderIds
func (c *PinpointSMSVoiceV2) DescribeSenderIds(input *DescribeSenderIdsInput) (*DescribeSenderIdsOutput, error) {
	req, out := c.DescribeSenderIdsRequest(input)
	return out, req.Send()
}

// DescribeSenderIdsWithContext is the same as DescribeSenderIds with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSenderIds for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribeSenderIdsWithContext(ctx aws.Context, input *DescribeSenderIdsInput, opts ...request.Option) (*DescribeSenderIdsOutput, error) {
	req, out := c.DescribeSenderIdsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeSenderIdsPages iterates over the pages of a DescribeSenderIds operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSenderIds method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeSenderIds operation.
//    pageNum := 0
//    err := client.DescribeSenderIdsPages(params,
//        func(page *pinpointsmsvoicev2.DescribeSenderIdsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *PinpointSMSVoiceV2) DescribeSenderIdsPages(input *DescribeSenderIdsInput, fn func(*DescribeSenderIdsOutput, bool) bool) error {
	return c.DescribeSenderIdsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeSenderIdsPagesWithContext same as DescribeSenderIdsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribeSenderIdsPagesWithContext(ctx aws.Context, input *DescribeSenderIdsInput, fn func(*DescribeSenderIdsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeSenderIdsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeSenderIdsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeSenderIdsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeSpendLimits = "DescribeSpendLimits"

// DescribeSpendLimitsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSpendLimits operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSpendLimits for more information on using the DescribeSpendLimits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSpendLimitsRequest method.
//    req, resp := client.DescribeSpendLimitsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSpendLimits
func (c *PinpointSMSVoiceV2) DescribeSpendLimitsRequest(input *DescribeSpendLimitsInput) (req *request.Request, output *DescribeSpendLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeSpendLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSpendLimitsInput{}
	}

	output = &DescribeSpendLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSpendLimits API operation for Amazon Pinpoint SMS Voice V2.
//
// Describes the current Amazon Pinpoint monthly spend limits for sending voice
// and text messages.
//
// When you establish an Amazon Web Services account, the account has initial
// monthly spend limit in a given Region. For more information on increasing
// your monthly spend limit, see Requesting increases to your monthly SMS spending
// quota for Amazon Pinpoint (https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-spend-threshold.html)
// in the Amazon Pinpoint User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DescribeSpendLimits for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSpendLimits
func (c *PinpointSMSVoiceV2) DescribeSpendLimits(input *DescribeSpendLimitsInput) (*DescribeSpendLimitsOutput, error) {
	req, out := c.DescribeSpendLimitsRequest(input)
	return out, req.Send()
}

// DescribeSpendLimitsWithContext is the same as DescribeSpendLimits with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSpendLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribeSpendLimitsWithContext(ctx aws.Context, input *DescribeSpendLimitsInput, opts ...request.Option) (*DescribeSpendLimitsOutput, error) {
	req, out := c.DescribeSpendLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeSpendLimitsPages iterates over the pages of a DescribeSpendLimits operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSpendLimits method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeSpendLimits operation.
//    pageNum := 0
//    err := client.DescribeSpendLimitsPages(params,
//        func(page *pinpointsmsvoicev2.DescribeSpendLimitsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *PinpointSMSVoiceV2) DescribeSpendLimitsPages(input *DescribeSpendLimitsInput, fn func(*DescribeSpendLimitsOutput, bool) bool) error {
	return c.DescribeSpendLimitsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeSpendLimitsPagesWithContext same as DescribeSpendLimitsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DescribeSpendLimitsPagesWithContext(ctx aws.Context, input *DescribeSpendLimitsInput, fn func(*DescribeSpendLimitsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeSpendLimitsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeSpendLimitsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeSpendLimitsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDisassociateOriginationIdentity = "DisassociateOriginationIdentity"

// DisassociateOriginationIdentityRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateOriginationIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateOriginationIdentity for more information on using the DisassociateOriginationIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateOriginationIdentityRequest method.
//    req, resp := client.DisassociateOriginationIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DisassociateOriginationIdentity
func (c *PinpointSMSVoiceV2) DisassociateOriginationIdentityRequest(input *DisassociateOriginationIdentityInput) (req *request.Request, output *DisassociateOriginationIdentityOutput) {
	op := &request.Operation{
		Name:       opDisassociateOriginationIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateOriginationIdentityInput{}
	}

	output = &DisassociateOriginationIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateOriginationIdentity API operation for Amazon Pinpoint SMS Voice V2.
//
// Removes the specified origination identity from an existing pool.
//
// If the origination identity isn't associated with the specified pool, an
// Error is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation DisassociateOriginationIdentity for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time
//   or it could be that the requested action isn't valid for the current state
//   or configuration of the resource.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DisassociateOriginationIdentity
func (c *PinpointSMSVoiceV2) DisassociateOriginationIdentity(input *DisassociateOriginationIdentityInput) (*DisassociateOriginationIdentityOutput, error) {
	req, out := c.DisassociateOriginationIdentityRequest(input)
	return out, req.Send()
}

// DisassociateOriginationIdentityWithContext is the same as DisassociateOriginationIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateOriginationIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) DisassociateOriginationIdentityWithContext(ctx aws.Context, input *DisassociateOriginationIdentityInput, opts ...request.Option) (*DisassociateOriginationIdentityOutput, error) {
	req, out := c.DisassociateOriginationIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPoolOriginationIdentities = "ListPoolOriginationIdentities"

// ListPoolOriginationIdentitiesRequest generates a "aws/request.Request" representing the
// client's request for the ListPoolOriginationIdentities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPoolOriginationIdentities for more information on using the ListPoolOriginationIdentities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPoolOriginationIdentitiesRequest method.
//    req, resp := client.ListPoolOriginationIdentitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListPoolOriginationIdentities
func (c *PinpointSMSVoiceV2) ListPoolOriginationIdentitiesRequest(input *ListPoolOriginationIdentitiesInput) (req *request.Request, output *ListPoolOriginationIdentitiesOutput) {
	op := &request.Operation{
		Name:       opListPoolOriginationIdentities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPoolOriginationIdentitiesInput{}
	}

	output = &ListPoolOriginationIdentitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPoolOriginationIdentities API operation for Amazon Pinpoint SMS Voice V2.
//
// Lists all associated origination identities in your pool.
//
// If you specify filters, the output includes information for only those origination
// identities that meet the filter criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation ListPoolOriginationIdentities for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListPoolOriginationIdentities
func (c *PinpointSMSVoiceV2) ListPoolOriginationIdentities(input *ListPoolOriginationIdentitiesInput) (*ListPoolOriginationIdentitiesOutput, error) {
	req, out := c.ListPoolOriginationIdentitiesRequest(input)
	return out, req.Send()
}

// ListPoolOriginationIdentitiesWithContext is the same as ListPoolOriginationIdentities with the addition of
// the ability to pass a context and additional request options.
//
// See ListPoolOriginationIdentities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) ListPoolOriginationIdentitiesWithContext(ctx aws.Context, input *ListPoolOriginationIdentitiesInput, opts ...request.Option) (*ListPoolOriginationIdentitiesOutput, error) {
	req, out := c.ListPoolOriginationIdentitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPoolOriginationIdentitiesPages iterates over the pages of a ListPoolOriginationIdentities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPoolOriginationIdentities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPoolOriginationIdentities operation.
//    pageNum := 0
//    err := client.ListPoolOriginationIdentitiesPages(params,
//        func(page *pinpointsmsvoicev2.ListPoolOriginationIdentitiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *PinpointSMSVoiceV2) ListPoolOriginationIdentitiesPages(input *ListPoolOriginationIdentitiesInput, fn func(*ListPoolOriginationIdentitiesOutput, bool) bool) error {
	return c.ListPoolOriginationIdentitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPoolOriginationIdentitiesPagesWithContext same as ListPoolOriginationIdentitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) ListPoolOriginationIdentitiesPagesWithContext(ctx aws.Context, input *ListPoolOriginationIdentitiesInput, fn func(*ListPoolOriginationIdentitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPoolOriginationIdentitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPoolOriginationIdentitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPoolOriginationIdentitiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListTagsForResource
func (c *PinpointSMSVoiceV2) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Pinpoint SMS Voice V2.
//
// List all tags associated with a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListTagsForResource
func (c *PinpointSMSVoiceV2) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutKeyword = "PutKeyword"

// PutKeywordRequest generates a "aws/request.Request" representing the
// client's request for the PutKeyword operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutKeyword for more information on using the PutKeyword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutKeywordRequest method.
//    req, resp := client.PutKeywordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutKeyword
func (c *PinpointSMSVoiceV2) PutKeywordRequest(input *PutKeywordInput) (req *request.Request, output *PutKeywordOutput) {
	op := &request.Operation{
		Name:       opPutKeyword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutKeywordInput{}
	}

	output = &PutKeywordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutKeyword API operation for Amazon Pinpoint SMS Voice V2.
//
// Creates or updates a keyword configuration on an origination phone number
// or pool.
//
// A keyword is a word that you can search for on a particular phone number
// or pool. It is also a specific word or phrase that an end user can send to
// your number to elicit a response, such as an informational message or a special
// offer. When your number receives a message that begins with a keyword, Amazon
// Pinpoint responds with a customizable message.
//
// If you specify a keyword that isn't valid, an Error is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation PutKeyword for usage and error information.
//
// Returned Error Types:
//   * ServiceQuotaExceededException
//   The request would cause a service quota to be exceeded.
//
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time
//   or it could be that the requested action isn't valid for the current state
//   or configuration of the resource.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutKeyword
func (c *PinpointSMSVoiceV2) PutKeyword(input *PutKeywordInput) (*PutKeywordOutput, error) {
	req, out := c.PutKeywordRequest(input)
	return out, req.Send()
}

// PutKeywordWithContext is the same as PutKeyword with the addition of
// the ability to pass a context and additional request options.
//
// See PutKeyword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) PutKeywordWithContext(ctx aws.Context, input *PutKeywordInput, opts ...request.Option) (*PutKeywordOutput, error) {
	req, out := c.PutKeywordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutOptedOutNumber = "PutOptedOutNumber"

// PutOptedOutNumberRequest generates a "aws/request.Request" representing the
// client's request for the PutOptedOutNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutOptedOutNumber for more information on using the PutOptedOutNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutOptedOutNumberRequest method.
//    req, resp := client.PutOptedOutNumberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutOptedOutNumber
func (c *PinpointSMSVoiceV2) PutOptedOutNumberRequest(input *PutOptedOutNumberInput) (req *request.Request, output *PutOptedOutNumberOutput) {
	op := &request.Operation{
		Name:       opPutOptedOutNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutOptedOutNumberInput{}
	}

	output = &PutOptedOutNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutOptedOutNumber API operation for Amazon Pinpoint SMS Voice V2.
//
// Creates an opted out destination phone number in the opt-out list.
//
// If the destination phone number isn't valid or if the specified opt-out list
// doesn't exist, an Error is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation PutOptedOutNumber for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutOptedOutNumber
func (c *PinpointSMSVoiceV2) PutOptedOutNumber(input *PutOptedOutNumberInput) (*PutOptedOutNumberOutput, error) {
	req, out := c.PutOptedOutNumberRequest(input)
	return out, req.Send()
}

// PutOptedOutNumberWithContext is the same as PutOptedOutNumber with the addition of
// the ability to pass a context and additional request options.
//
// See PutOptedOutNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) PutOptedOutNumberWithContext(ctx aws.Context, input *PutOptedOutNumberInput, opts ...request.Option) (*PutOptedOutNumberOutput, error) {
	req, out := c.PutOptedOutNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReleasePhoneNumber = "ReleasePhoneNumber"

// ReleasePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the ReleasePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReleasePhoneNumber for more information on using the ReleasePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ReleasePhoneNumberRequest method.
//    req, resp := client.ReleasePhoneNumberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ReleasePhoneNumber
func (c *PinpointSMSVoiceV2) ReleasePhoneNumberRequest(input *ReleasePhoneNumberInput) (req *request.Request, output *ReleasePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opReleasePhoneNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReleasePhoneNumberInput{}
	}

	output = &ReleasePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReleasePhoneNumber API operation for Amazon Pinpoint SMS Voice V2.
//
// Releases an existing origination phone number in your account. Once released,
// a phone number is no longer available for sending messages.
//
// If the origination phone number has deletion protection enabled or is associated
// with a pool, an Error is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation ReleasePhoneNumber for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time
//   or it could be that the requested action isn't valid for the current state
//   or configuration of the resource.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ReleasePhoneNumber
func (c *PinpointSMSVoiceV2) ReleasePhoneNumber(input *ReleasePhoneNumberInput) (*ReleasePhoneNumberOutput, error) {
	req, out := c.ReleasePhoneNumberRequest(input)
	return out, req.Send()
}

// ReleasePhoneNumberWithContext is the same as ReleasePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See ReleasePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) ReleasePhoneNumberWithContext(ctx aws.Context, input *ReleasePhoneNumberInput, opts ...request.Option) (*ReleasePhoneNumberOutput, error) {
	req, out := c.ReleasePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRequestPhoneNumber = "RequestPhoneNumber"

// RequestPhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the RequestPhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RequestPhoneNumber for more information on using the RequestPhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RequestPhoneNumberRequest method.
//    req, resp := client.RequestPhoneNumberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/RequestPhoneNumber
func (c *PinpointSMSVoiceV2) RequestPhoneNumberRequest(input *RequestPhoneNumberInput) (req *request.Request, output *RequestPhoneNumberOutput) {
	op := &request.Operation{
		Name:       opRequestPhoneNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestPhoneNumberInput{}
	}

	output = &RequestPhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RequestPhoneNumber API operation for Amazon Pinpoint SMS Voice V2.
//
// Request an origination phone number for use in your account. For more information
// on phone number request see Requesting a number (https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-request-number.html)
// in the Amazon Pinpoint User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation RequestPhoneNumber for usage and error information.
//
// Returned Error Types:
//   * ServiceQuotaExceededException
//   The request would cause a service quota to be exceeded.
//
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time
//   or it could be that the requested action isn't valid for the current state
//   or configuration of the resource.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/RequestPhoneNumber
func (c *PinpointSMSVoiceV2) RequestPhoneNumber(input *RequestPhoneNumberInput) (*RequestPhoneNumberOutput, error) {
	req, out := c.RequestPhoneNumberRequest(input)
	return out, req.Send()
}

// RequestPhoneNumberWithContext is the same as RequestPhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See RequestPhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) RequestPhoneNumberWithContext(ctx aws.Context, input *RequestPhoneNumberInput, opts ...request.Option) (*RequestPhoneNumberOutput, error) {
	req, out := c.RequestPhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendTextMessage = "SendTextMessage"

// SendTextMessageRequest generates a "aws/request.Request" representing the
// client's request for the SendTextMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendTextMessage for more information on using the SendTextMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendTextMessageRequest method.
//    req, resp := client.SendTextMessageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendTextMessage
func (c *PinpointSMSVoiceV2) SendTextMessageRequest(input *SendTextMessageInput) (req *request.Request, output *SendTextMessageOutput) {
	op := &request.Operation{
		Name:       opSendTextMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendTextMessageInput{}
	}

	output = &SendTextMessageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendTextMessage API operation for Amazon Pinpoint SMS Voice V2.
//
// Creates a new text message and sends it to a recipient's phone number.
//
// SMS throughput limits are measured in Message Parts per Second (MPS). Your
// MPS limit depends on the destination country of your messages, as well as
// the type of phone number (origination number) that you use to send the message.
// For more information, see Message Parts per Second (MPS) limits (https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-limitations-mps.html)
// in the Amazon Pinpoint User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation SendTextMessage for usage and error information.
//
// Returned Error Types:
//   * ServiceQuotaExceededException
//   The request would cause a service quota to be exceeded.
//
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time
//   or it could be that the requested action isn't valid for the current state
//   or configuration of the resource.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendTextMessage
func (c *PinpointSMSVoiceV2) SendTextMessage(input *SendTextMessageInput) (*SendTextMessageOutput, error) {
	req, out := c.SendTextMessageRequest(input)
	return out, req.Send()
}

// SendTextMessageWithContext is the same as SendTextMessage with the addition of
// the ability to pass a context and additional request options.
//
// See SendTextMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) SendTextMessageWithContext(ctx aws.Context, input *SendTextMessageInput, opts ...request.Option) (*SendTextMessageOutput, error) {
	req, out := c.SendTextMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendVoiceMessage = "SendVoiceMessage"

// SendVoiceMessageRequest generates a "aws/request.Request" representing the
// client's request for the SendVoiceMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendVoiceMessage for more information on using the SendVoiceMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendVoiceMessageRequest method.
//    req, resp := client.SendVoiceMessageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendVoiceMessage
func (c *PinpointSMSVoiceV2) SendVoiceMessageRequest(input *SendVoiceMessageInput) (req *request.Request, output *SendVoiceMessageOutput) {
	op := &request.Operation{
		Name:       opSendVoiceMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendVoiceMessageInput{}
	}

	output = &SendVoiceMessageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendVoiceMessage API operation for Amazon Pinpoint SMS Voice V2.
//
// Allows you to send a request that sends a text message through Amazon Pinpoint.
// This operation uses Amazon Polly (http://aws.amazon.com/polly/) to convert
// a text script into a voice message.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation SendVoiceMessage for usage and error information.
//
// Returned Error Types:
//   * ServiceQuotaExceededException
//   The request would cause a service quota to be exceeded.
//
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time
//   or it could be that the requested action isn't valid for the current state
//   or configuration of the resource.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendVoiceMessage
func (c *PinpointSMSVoiceV2) SendVoiceMessage(input *SendVoiceMessageInput) (*SendVoiceMessageOutput, error) {
	req, out := c.SendVoiceMessageRequest(input)
	return out, req.Send()
}

// SendVoiceMessageWithContext is the same as SendVoiceMessage with the addition of
// the ability to pass a context and additional request options.
//
// See SendVoiceMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) SendVoiceMessageWithContext(ctx aws.Context, input *SendVoiceMessageInput, opts ...request.Option) (*SendVoiceMessageOutput, error) {
	req, out := c.SendVoiceMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetDefaultMessageType = "SetDefaultMessageType"

// SetDefaultMessageTypeRequest generates a "aws/request.Request" representing the
// client's request for the SetDefaultMessageType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetDefaultMessageType for more information on using the SetDefaultMessageType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetDefaultMessageTypeRequest method.
//    req, resp := client.SetDefaultMessageTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetDefaultMessageType
func (c *PinpointSMSVoiceV2) SetDefaultMessageTypeRequest(input *SetDefaultMessageTypeInput) (req *request.Request, output *SetDefaultMessageTypeOutput) {
	op := &request.Operation{
		Name:       opSetDefaultMessageType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetDefaultMessageTypeInput{}
	}

	output = &SetDefaultMessageTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetDefaultMessageType API operation for Amazon Pinpoint SMS Voice V2.
//
// Sets the default message type on a configuration set.
//
// Choose the category of SMS messages that you plan to send from this account.
// If you send account-related messages or time-sensitive messages such as one-time
// passcodes, choose Transactional. If you plan to send messages that contain
// marketing material or other promotional content, choose Promotional. This
// setting applies to your entire Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation SetDefaultMessageType for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetDefaultMessageType
func (c *PinpointSMSVoiceV2) SetDefaultMessageType(input *SetDefaultMessageTypeInput) (*SetDefaultMessageTypeOutput, error) {
	req, out := c.SetDefaultMessageTypeRequest(input)
	return out, req.Send()
}

// SetDefaultMessageTypeWithContext is the same as SetDefaultMessageType with the addition of
// the ability to pass a context and additional request options.
//
// See SetDefaultMessageType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) SetDefaultMessageTypeWithContext(ctx aws.Context, input *SetDefaultMessageTypeInput, opts ...request.Option) (*SetDefaultMessageTypeOutput, error) {
	req, out := c.SetDefaultMessageTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetDefaultSenderId = "SetDefaultSenderId"

// SetDefaultSenderIdRequest generates a "aws/request.Request" representing the
// client's request for the SetDefaultSenderId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetDefaultSenderId for more information on using the SetDefaultSenderId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetDefaultSenderIdRequest method.
//    req, resp := client.SetDefaultSenderIdRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetDefaultSenderId
func (c *PinpointSMSVoiceV2) SetDefaultSenderIdRequest(input *SetDefaultSenderIdInput) (req *request.Request, output *SetDefaultSenderIdOutput) {
	op := &request.Operation{
		Name:       opSetDefaultSenderId,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetDefaultSenderIdInput{}
	}

	output = &SetDefaultSenderIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetDefaultSenderId API operation for Amazon Pinpoint SMS Voice V2.
//
// Sets default sender ID on a configuration set.
//
// When sending a text message to a destination country that supports sender
// IDs, the default sender ID on the configuration set specified will be used
// if no dedicated origination phone numbers or registered sender IDs are available
// in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation SetDefaultSenderId for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetDefaultSenderId
func (c *PinpointSMSVoiceV2) SetDefaultSenderId(input *SetDefaultSenderIdInput) (*SetDefaultSenderIdOutput, error) {
	req, out := c.SetDefaultSenderIdRequest(input)
	return out, req.Send()
}

// SetDefaultSenderIdWithContext is the same as SetDefaultSenderId with the addition of
// the ability to pass a context and additional request options.
//
// See SetDefaultSenderId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) SetDefaultSenderIdWithContext(ctx aws.Context, input *SetDefaultSenderIdInput, opts ...request.Option) (*SetDefaultSenderIdOutput, error) {
	req, out := c.SetDefaultSenderIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetTextMessageSpendLimitOverride = "SetTextMessageSpendLimitOverride"

// SetTextMessageSpendLimitOverrideRequest generates a "aws/request.Request" representing the
// client's request for the SetTextMessageSpendLimitOverride operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetTextMessageSpendLimitOverride for more information on using the SetTextMessageSpendLimitOverride
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetTextMessageSpendLimitOverrideRequest method.
//    req, resp := client.SetTextMessageSpendLimitOverrideRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetTextMessageSpendLimitOverride
func (c *PinpointSMSVoiceV2) SetTextMessageSpendLimitOverrideRequest(input *SetTextMessageSpendLimitOverrideInput) (req *request.Request, output *SetTextMessageSpendLimitOverrideOutput) {
	op := &request.Operation{
		Name:       opSetTextMessageSpendLimitOverride,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetTextMessageSpendLimitOverrideInput{}
	}

	output = &SetTextMessageSpendLimitOverrideOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetTextMessageSpendLimitOverride API operation for Amazon Pinpoint SMS Voice V2.
//
// Sets an account level monthly spend limit override for sending text messages.
// The requested spend limit must be less than or equal to the MaxLimit, which
// is set by Amazon Web Services.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation SetTextMessageSpendLimitOverride for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetTextMessageSpendLimitOverride
func (c *PinpointSMSVoiceV2) SetTextMessageSpendLimitOverride(input *SetTextMessageSpendLimitOverrideInput) (*SetTextMessageSpendLimitOverrideOutput, error) {
	req, out := c.SetTextMessageSpendLimitOverrideRequest(input)
	return out, req.Send()
}

// SetTextMessageSpendLimitOverrideWithContext is the same as SetTextMessageSpendLimitOverride with the addition of
// the ability to pass a context and additional request options.
//
// See SetTextMessageSpendLimitOverride for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) SetTextMessageSpendLimitOverrideWithContext(ctx aws.Context, input *SetTextMessageSpendLimitOverrideInput, opts ...request.Option) (*SetTextMessageSpendLimitOverrideOutput, error) {
	req, out := c.SetTextMessageSpendLimitOverrideRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetVoiceMessageSpendLimitOverride = "SetVoiceMessageSpendLimitOverride"

// SetVoiceMessageSpendLimitOverrideRequest generates a "aws/request.Request" representing the
// client's request for the SetVoiceMessageSpendLimitOverride operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetVoiceMessageSpendLimitOverride for more information on using the SetVoiceMessageSpendLimitOverride
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetVoiceMessageSpendLimitOverrideRequest method.
//    req, resp := client.SetVoiceMessageSpendLimitOverrideRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetVoiceMessageSpendLimitOverride
func (c *PinpointSMSVoiceV2) SetVoiceMessageSpendLimitOverrideRequest(input *SetVoiceMessageSpendLimitOverrideInput) (req *request.Request, output *SetVoiceMessageSpendLimitOverrideOutput) {
	op := &request.Operation{
		Name:       opSetVoiceMessageSpendLimitOverride,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetVoiceMessageSpendLimitOverrideInput{}
	}

	output = &SetVoiceMessageSpendLimitOverrideOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetVoiceMessageSpendLimitOverride API operation for Amazon Pinpoint SMS Voice V2.
//
// Sets an account level monthly spend limit override for sending voice messages.
// The requested spend limit must be less than or equal to the MaxLimit, which
// is set by Amazon Web Services.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation SetVoiceMessageSpendLimitOverride for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetVoiceMessageSpendLimitOverride
func (c *PinpointSMSVoiceV2) SetVoiceMessageSpendLimitOverride(input *SetVoiceMessageSpendLimitOverrideInput) (*SetVoiceMessageSpendLimitOverrideOutput, error) {
	req, out := c.SetVoiceMessageSpendLimitOverrideRequest(input)
	return out, req.Send()
}

// SetVoiceMessageSpendLimitOverrideWithContext is the same as SetVoiceMessageSpendLimitOverride with the addition of
// the ability to pass a context and additional request options.
//
// See SetVoiceMessageSpendLimitOverride for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) SetVoiceMessageSpendLimitOverrideWithContext(ctx aws.Context, input *SetVoiceMessageSpendLimitOverrideInput, opts ...request.Option) (*SetVoiceMessageSpendLimitOverrideOutput, error) {
	req, out := c.SetVoiceMessageSpendLimitOverrideRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/TagResource
func (c *PinpointSMSVoiceV2) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Pinpoint SMS Voice V2.
//
// Adds or overwrites only the specified tags for the specified Amazon Pinpoint
// SMS Voice, version 2 resource. When you specify an existing tag key, the
// value is overwritten with the new value. Each resource can have a maximum
// of 50 tags. Each tag consists of a key and an optional value. Tag keys must
// be unique per resource. For more information about tags, see Tagging Amazon
// Pinpoint resources (https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html)
// in the Amazon Pinpoint Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ServiceQuotaExceededException
//   The request would cause a service quota to be exceeded.
//
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/TagResource
func (c *PinpointSMSVoiceV2) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UntagResource
func (c *PinpointSMSVoiceV2) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Pinpoint SMS Voice V2.
//
// Removes the association of the specified tags from an Amazon Pinpoint SMS
// Voice V2 resource. For more information on tags see Tagging Amazon Pinpoint
// resources (https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html)
// in the Amazon Pinpoint Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UntagResource
func (c *PinpointSMSVoiceV2) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEventDestination = "UpdateEventDestination"

// UpdateEventDestinationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEventDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEventDestination for more information on using the UpdateEventDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEventDestinationRequest method.
//    req, resp := client.UpdateEventDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdateEventDestination
func (c *PinpointSMSVoiceV2) UpdateEventDestinationRequest(input *UpdateEventDestinationInput) (req *request.Request, output *UpdateEventDestinationOutput) {
	op := &request.Operation{
		Name:       opUpdateEventDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEventDestinationInput{}
	}

	output = &UpdateEventDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEventDestination API operation for Amazon Pinpoint SMS Voice V2.
//
// Updates an existing event destination in a configuration set. You can update
// the IAM role ARN for CloudWatch Logs and Kinesis Data Firehose. You can also
// enable or disable the event destination.
//
// You may want to update an event destination to change its matching event
// types or updating the destination resource ARN. You can't change an event
// destination's type between CloudWatch Logs, Kinesis Data Firehose, and Amazon
// SNS.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation UpdateEventDestination for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time
//   or it could be that the requested action isn't valid for the current state
//   or configuration of the resource.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdateEventDestination
func (c *PinpointSMSVoiceV2) UpdateEventDestination(input *UpdateEventDestinationInput) (*UpdateEventDestinationOutput, error) {
	req, out := c.UpdateEventDestinationRequest(input)
	return out, req.Send()
}

// UpdateEventDestinationWithContext is the same as UpdateEventDestination with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEventDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) UpdateEventDestinationWithContext(ctx aws.Context, input *UpdateEventDestinationInput, opts ...request.Option) (*UpdateEventDestinationOutput, error) {
	req, out := c.UpdateEventDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePhoneNumber = "UpdatePhoneNumber"

// UpdatePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePhoneNumber for more information on using the UpdatePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePhoneNumberRequest method.
//    req, resp := client.UpdatePhoneNumberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdatePhoneNumber
func (c *PinpointSMSVoiceV2) UpdatePhoneNumberRequest(input *UpdatePhoneNumberInput) (req *request.Request, output *UpdatePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opUpdatePhoneNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePhoneNumberInput{}
	}

	output = &UpdatePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePhoneNumber API operation for Amazon Pinpoint SMS Voice V2.
//
// Updates the configuration of an existing origination phone number. You can
// update the opt-out list, enable or disable two-way messaging, change the
// TwoWayChannelArn, enable or disable self-managed opt-outs, and enable or
// disable deletion protection.
//
// If the origination phone number is associated with a pool, an Error is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation UpdatePhoneNumber for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time
//   or it could be that the requested action isn't valid for the current state
//   or configuration of the resource.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdatePhoneNumber
func (c *PinpointSMSVoiceV2) UpdatePhoneNumber(input *UpdatePhoneNumberInput) (*UpdatePhoneNumberOutput, error) {
	req, out := c.UpdatePhoneNumberRequest(input)
	return out, req.Send()
}

// UpdatePhoneNumberWithContext is the same as UpdatePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) UpdatePhoneNumberWithContext(ctx aws.Context, input *UpdatePhoneNumberInput, opts ...request.Option) (*UpdatePhoneNumberOutput, error) {
	req, out := c.UpdatePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePool = "UpdatePool"

// UpdatePoolRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePool for more information on using the UpdatePool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePoolRequest method.
//    req, resp := client.UpdatePoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdatePool
func (c *PinpointSMSVoiceV2) UpdatePoolRequest(input *UpdatePoolInput) (req *request.Request, output *UpdatePoolOutput) {
	op := &request.Operation{
		Name:       opUpdatePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePoolInput{}
	}

	output = &UpdatePoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePool API operation for Amazon Pinpoint SMS Voice V2.
//
// Updates the configuration of an existing pool. You can update the opt-out
// list, enable or disable two-way messaging, change the TwoWayChannelArn, enable
// or disable self-managed opt-outs, enable or disable deletion protection,
// and enable or disable shared routes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint SMS Voice V2's
// API operation UpdatePool for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   An error that occurred because too many requests were sent during a certain
//   amount of time.
//
//   * AccessDeniedException
//   The request was denied because you don't have sufficient permissions to access
//   the resource.
//
//   * ResourceNotFoundException
//   A requested resource couldn't be found.
//
//   * ValidationException
//   A validation exception for a field.
//
//   * ConflictException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time
//   or it could be that the requested action isn't valid for the current state
//   or configuration of the resource.
//
//   * InternalServerException
//   The API encountered an unexpected error and couldn't complete the request.
//   You might be able to successfully issue the request again in the future.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdatePool
func (c *PinpointSMSVoiceV2) UpdatePool(input *UpdatePoolInput) (*UpdatePoolOutput, error) {
	req, out := c.UpdatePoolRequest(input)
	return out, req.Send()
}

// UpdatePoolWithContext is the same as UpdatePool with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PinpointSMSVoiceV2) UpdatePoolWithContext(ctx aws.Context, input *UpdatePoolInput, opts ...request.Option) (*UpdatePoolOutput, error) {
	req, out := c.UpdatePoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The request was denied because you don't have sufficient permissions to access
// the resource.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason for the exception.
	Reason *string `type:"string" enum:"AccessDeniedExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Displays the attributes associated with a single Amazon Web Services account.
type AccountAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the account attribute.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"AccountAttributeName"`

	// The value associated with the account attribute name.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountAttribute) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AccountAttribute) SetName(v string) *AccountAttribute {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AccountAttribute) SetValue(v string) *AccountAttribute {
	s.Value = &v
	return s
}

// The current resource quotas associated with an Amazon Web Services account.
type AccountLimit struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services set limit for that resource type, in US dollars.
	//
	// Max is a required field
	Max *int64 `type:"long" required:"true"`

	// The name of the attribute to apply the account limit to.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"AccountLimitName"`

	// The current amount that has been spent, in US dollars.
	//
	// Used is a required field
	Used *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountLimit) GoString() string {
	return s.String()
}

// SetMax sets the Max field's value.
func (s *AccountLimit) SetMax(v int64) *AccountLimit {
	s.Max = &v
	return s
}

// SetName sets the Name field's value.
func (s *AccountLimit) SetName(v string) *AccountLimit {
	s.Name = &v
	return s
}

// SetUsed sets the Used field's value.
func (s *AccountLimit) SetUsed(v int64) *AccountLimit {
	s.Used = &v
	return s
}

type AssociateOriginationIdentityInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don't specify a client token, a randomly generated
	// token is used for the request to ensure idempotency.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The new two-character code, in ISO 3166-1 alpha-2 format, for the country
	// or region of the origination identity.
	//
	// IsoCountryCode is a required field
	IsoCountryCode *string `min:"2" type:"string" required:"true"`

	// The origination identity to use, such as PhoneNumberId, PhoneNumberArn, SenderId,
	// or SenderIdArn. You can use DescribePhoneNumbers to find the values for PhoneNumberId
	// and PhoneNumberArn, while DescribeSenderIds can be used to get the values
	// for SenderId and SenderIdArn.
	//
	// OriginationIdentity is a required field
	OriginationIdentity *string `min:"1" type:"string" required:"true"`

	// The pool to update with the new Identity. This value can be either the PoolId
	// or PoolArn, and you can find these values using DescribePools.
	//
	// PoolId is a required field
	PoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateOriginationIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateOriginationIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateOriginationIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateOriginationIdentityInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.IsoCountryCode == nil {
		invalidParams.Add(request.NewErrParamRequired("IsoCountryCode"))
	}
	if s.IsoCountryCode != nil && len(*s.IsoCountryCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("IsoCountryCode", 2))
	}
	if s.OriginationIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginationIdentity"))
	}
	if s.OriginationIdentity != nil && len(*s.OriginationIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OriginationIdentity", 1))
	}
	if s.PoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolId"))
	}
	if s.PoolId != nil && len(*s.PoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *AssociateOriginationIdentityInput) SetClientToken(v string) *AssociateOriginationIdentityInput {
	s.ClientToken = &v
	return s
}

// SetIsoCountryCode sets the IsoCountryCode field's value.
func (s *AssociateOriginationIdentityInput) SetIsoCountryCode(v string) *AssociateOriginationIdentityInput {
	s.IsoCountryCode = &v
	return s
}

// SetOriginationIdentity sets the OriginationIdentity field's value.
func (s *AssociateOriginationIdentityInput) SetOriginationIdentity(v string) *AssociateOriginationIdentityInput {
	s.OriginationIdentity = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *AssociateOriginationIdentityInput) SetPoolId(v string) *AssociateOriginationIdentityInput {
	s.PoolId = &v
	return s
}

type AssociateOriginationIdentityOutput struct {
	_ struct{} `type:"structure"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region.
	IsoCountryCode *string `min:"2" type:"string"`

	// The PhoneNumberId or SenderId of the origination identity.
	OriginationIdentity *string `type:"string"`

	// The PhoneNumberArn or SenderIdArn of the origination identity.
	OriginationIdentityArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the pool that is now associated with the
	// origination identity.
	PoolArn *string `type:"string"`

	// The PoolId of the pool that is now associated with the origination identity.
	PoolId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateOriginationIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateOriginationIdentityOutput) GoString() string {
	return s.String()
}

// SetIsoCountryCode sets the IsoCountryCode field's value.
func (s *AssociateOriginationIdentityOutput) SetIsoCountryCode(v string) *AssociateOriginationIdentityOutput {
	s.IsoCountryCode = &v
	return s
}

// SetOriginationIdentity sets the OriginationIdentity field's value.
func (s *AssociateOriginationIdentityOutput) SetOriginationIdentity(v string) *AssociateOriginationIdentityOutput {
	s.OriginationIdentity = &v
	return s
}

// SetOriginationIdentityArn sets the OriginationIdentityArn field's value.
func (s *AssociateOriginationIdentityOutput) SetOriginationIdentityArn(v string) *AssociateOriginationIdentityOutput {
	s.OriginationIdentityArn = &v
	return s
}

// SetPoolArn sets the PoolArn field's value.
func (s *AssociateOriginationIdentityOutput) SetPoolArn(v string) *AssociateOriginationIdentityOutput {
	s.PoolArn = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *AssociateOriginationIdentityOutput) SetPoolId(v string) *AssociateOriginationIdentityOutput {
	s.PoolId = &v
	return s
}

// Contains the destination configuration to use when publishing message sending
// events.
type CloudWatchLogsDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Amazon Identity and Access Management
	// (IAM) role that is able to write event data to an Amazon CloudWatch destination.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `min:"20" type:"string" required:"true"`

	// The name of the Amazon CloudWatch log group that you want to record events
	// in.
	//
	// LogGroupArn is a required field
	LogGroupArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogsDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogsDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLogsDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchLogsDestination"}
	if s.IamRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRoleArn"))
	}
	if s.IamRoleArn != nil && len(*s.IamRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("IamRoleArn", 20))
	}
	if s.LogGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LogGroupArn"))
	}
	if s.LogGroupArn != nil && len(*s.LogGroupArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("LogGroupArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *CloudWatchLogsDestination) SetIamRoleArn(v string) *CloudWatchLogsDestination {
	s.IamRoleArn = &v
	return s
}

// SetLogGroupArn sets the LogGroupArn field's value.
func (s *CloudWatchLogsDestination) SetLogGroupArn(v string) *CloudWatchLogsDestination {
	s.LogGroupArn = &v
	return s
}

// The information for configuration sets that meet a specified criteria.
type ConfigurationSetFilter struct {
	_ struct{} `type:"structure"`

	// The name of the attribute to filter on.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"ConfigurationSetFilterName"`

	// An array values to filter for.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationSetFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationSetFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigurationSetFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigurationSetFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ConfigurationSetFilter) SetName(v string) *ConfigurationSetFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ConfigurationSetFilter) SetValues(v []*string) *ConfigurationSetFilter {
	s.Values = v
	return s
}

// Information related to a given configuration set in your Amazon Web Services
// account.
type ConfigurationSetInformation struct {
	_ struct{} `type:"structure"`

	// The Resource Name (ARN) of the ConfigurationSet.
	//
	// ConfigurationSetArn is a required field
	ConfigurationSetArn *string `type:"string" required:"true"`

	// The name of the ConfigurationSet.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `min:"1" type:"string" required:"true"`

	// The time when the ConfigurationSet was created, in UNIX epoch time (https://www.epochconverter.com/)
	// format.
	//
	// CreatedTimestamp is a required field
	CreatedTimestamp *time.Time `type:"timestamp" required:"true"`

	// The type of message. Valid values are TRANSACTIONAL for messages that are
	// critical or time-sensitive and PROMOTIONAL for messages that aren't critical
	// or time-sensitive.
	DefaultMessageType *string `type:"string" enum:"MessageType"`

	// The default sender ID used by the ConfigurationSet.
	DefaultSenderId *string `min:"1" type:"string"`

	// An array of EventDestination objects that describe any events to log and
	// where to log them.
	//
	// EventDestinations is a required field
	EventDestinations []*EventDestination `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationSetInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationSetInformation) GoString() string {
	return s.String()
}

// SetConfigurationSetArn sets the ConfigurationSetArn field's value.
func (s *ConfigurationSetInformation) SetConfigurationSetArn(v string) *ConfigurationSetInformation {
	s.ConfigurationSetArn = &v
	return s
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *ConfigurationSetInformation) SetConfigurationSetName(v string) *ConfigurationSetInformation {
	s.ConfigurationSetName = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *ConfigurationSetInformation) SetCreatedTimestamp(v time.Time) *ConfigurationSetInformation {
	s.CreatedTimestamp = &v
	return s
}

// SetDefaultMessageType sets the DefaultMessageType field's value.
func (s *ConfigurationSetInformation) SetDefaultMessageType(v string) *ConfigurationSetInformation {
	s.DefaultMessageType = &v
	return s
}

// SetDefaultSenderId sets the DefaultSenderId field's value.
func (s *ConfigurationSetInformation) SetDefaultSenderId(v string) *ConfigurationSetInformation {
	s.DefaultSenderId = &v
	return s
}

// SetEventDestinations sets the EventDestinations field's value.
func (s *ConfigurationSetInformation) SetEventDestinations(v []*EventDestination) *ConfigurationSetInformation {
	s.EventDestinations = v
	return s
}

// Your request has conflicting operations. This can occur if you're trying
// to perform more than one operation on the same resource at the same time
// or it could be that the requested action isn't valid for the current state
// or configuration of the resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason for the exception.
	Reason *string `type:"string" enum:"ConflictExceptionReason"`

	// The unique identifier of the request.
	ResourceId *string `type:"string"`

	// The type of resource that caused the exception.
	ResourceType *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateConfigurationSetInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don't specify a client token, a randomly generated
	// token is used for the request to ensure idempotency.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The name to use for the new configuration set.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `min:"1" type:"string" required:"true"`

	// An array of key and value pair tags that's associated with the new configuration
	// set.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfigurationSetInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateConfigurationSetInput) SetClientToken(v string) *CreateConfigurationSetInput {
	s.ClientToken = &v
	return s
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *CreateConfigurationSetInput) SetConfigurationSetName(v string) *CreateConfigurationSetInput {
	s.ConfigurationSetName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConfigurationSetInput) SetTags(v []*Tag) *CreateConfigurationSetInput {
	s.Tags = v
	return s
}

type CreateConfigurationSetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the newly created configuration set.
	ConfigurationSetArn *string `type:"string"`

	// The name of the new configuration set.
	ConfigurationSetName *string `min:"1" type:"string"`

	// The time when the configuration set was created, in UNIX epoch time (https://www.epochconverter.com/)
	// format.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// An array of key and value pair tags that's associated with the configuration
	// set.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetOutput) GoString() string {
	return s.String()
}

// SetConfigurationSetArn sets the ConfigurationSetArn field's value.
func (s *CreateConfigurationSetOutput) SetConfigurationSetArn(v string) *CreateConfigurationSetOutput {
	s.ConfigurationSetArn = &v
	return s
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *CreateConfigurationSetOutput) SetConfigurationSetName(v string) *CreateConfigurationSetOutput {
	s.ConfigurationSetName = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *CreateConfigurationSetOutput) SetCreatedTimestamp(v time.Time) *CreateConfigurationSetOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConfigurationSetOutput) SetTags(v []*Tag) *CreateConfigurationSetOutput {
	s.Tags = v
	return s
}

type CreateEventDestinationInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don't specify a client token, a randomly generated
	// token is used for the request to ensure idempotency.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// An object that contains information about an event destination for logging
	// to Amazon CloudWatch logs.
	CloudWatchLogsDestination *CloudWatchLogsDestination `type:"structure"`

	// Either the name of the configuration set or the configuration set ARN to
	// apply event logging to. The ConfigurateSetName and ConfigurationSetArn can
	// be found using the DescribeConfigurationSets action.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `min:"1" type:"string" required:"true"`

	// The name that identifies the event destination.
	//
	// EventDestinationName is a required field
	EventDestinationName *string `min:"1" type:"string" required:"true"`

	// An object that contains information about an event destination for logging
	// to Amazon Kinesis Data Firehose.
	KinesisFirehoseDestination *KinesisFirehoseDestination `type:"structure"`

	// An array of event types that determine which events to log. If "ALL" is used,
	// then Amazon Pinpoint logs every event type.
	//
	// MatchingEventTypes is a required field
	MatchingEventTypes []*string `min:"1" type:"list" required:"true" enum:"EventType"`

	// An object that contains information about an event destination for logging
	// to Amazon SNS.
	SnsDestination *SnsDestination `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventDestinationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}
	if s.EventDestinationName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestinationName"))
	}
	if s.EventDestinationName != nil && len(*s.EventDestinationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventDestinationName", 1))
	}
	if s.MatchingEventTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("MatchingEventTypes"))
	}
	if s.MatchingEventTypes != nil && len(s.MatchingEventTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MatchingEventTypes", 1))
	}
	if s.CloudWatchLogsDestination != nil {
		if err := s.CloudWatchLogsDestination.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchLogsDestination", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseDestination != nil {
		if err := s.KinesisFirehoseDestination.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseDestination", err.(request.ErrInvalidParams))
		}
	}
	if s.SnsDestination != nil {
		if err := s.SnsDestination.Validate(); err != nil {
			invalidParams.AddNested("SnsDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateEventDestinationInput) SetClientToken(v string) *CreateEventDestinationInput {
	s.ClientToken = &v
	return s
}

// SetCloudWatchLogsDestination sets the CloudWatchLogsDestination field's value.
func (s *CreateEventDestinationInput) SetCloudWatchLogsDestination(v *CloudWatchLogsDestination) *CreateEventDestinationInput {
	s.CloudWatchLogsDestination = v
	return s
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *CreateEventDestinationInput) SetConfigurationSetName(v string) *CreateEventDestinationInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestinationName sets the EventDestinationName field's value.
func (s *CreateEventDestinationInput) SetEventDestinationName(v string) *CreateEventDestinationInput {
	s.EventDestinationName = &v
	return s
}

// SetKinesisFirehoseDestination sets the KinesisFirehoseDestination field's value.
func (s *CreateEventDestinationInput) SetKinesisFirehoseDestination(v *KinesisFirehoseDestination) *CreateEventDestinationInput {
	s.KinesisFirehoseDestination = v
	return s
}

// SetMatchingEventTypes sets the MatchingEventTypes field's value.
func (s *CreateEventDestinationInput) SetMatchingEventTypes(v []*string) *CreateEventDestinationInput {
	s.MatchingEventTypes = v
	return s
}

// SetSnsDestination sets the SnsDestination field's value.
func (s *CreateEventDestinationInput) SetSnsDestination(v *SnsDestination) *CreateEventDestinationInput {
	s.SnsDestination = v
	return s
}

type CreateEventDestinationOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the configuration set.
	ConfigurationSetArn *string `type:"string"`

	// The name of the configuration set.
	ConfigurationSetName *string `min:"1" type:"string"`

	// The details of the destination where events are logged.
	EventDestination *EventDestination `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventDestinationOutput) GoString() string {
	return s.String()
}

// SetConfigurationSetArn sets the ConfigurationSetArn field's value.
func (s *CreateEventDestinationOutput) SetConfigurationSetArn(v string) *CreateEventDestinationOutput {
	s.ConfigurationSetArn = &v
	return s
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *CreateEventDestinationOutput) SetConfigurationSetName(v string) *CreateEventDestinationOutput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestination sets the EventDestination field's value.
func (s *CreateEventDestinationOutput) SetEventDestination(v *EventDestination) *CreateEventDestinationOutput {
	s.EventDestination = v
	return s
}

type CreateOptOutListInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don't specify a client token, a randomly generated
	// token is used for the request to ensure idempotency.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The name of the new OptOutList.
	//
	// OptOutListName is a required field
	OptOutListName *string `min:"1" type:"string" required:"true"`

	// An array of tags (key and value pairs) to associate with the new OptOutList.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOptOutListInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOptOutListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOptOutListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOptOutListInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.OptOutListName == nil {
		invalidParams.Add(request.NewErrParamRequired("OptOutListName"))
	}
	if s.OptOutListName != nil && len(*s.OptOutListName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OptOutListName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateOptOutListInput) SetClientToken(v string) *CreateOptOutListInput {
	s.ClientToken = &v
	return s
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *CreateOptOutListInput) SetOptOutListName(v string) *CreateOptOutListInput {
	s.OptOutListName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateOptOutListInput) SetTags(v []*Tag) *CreateOptOutListInput {
	s.Tags = v
	return s
}

type CreateOptOutListOutput struct {
	_ struct{} `type:"structure"`

	// The time when the pool was created, in UNIX epoch time (https://www.epochconverter.com/)
	// format.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) for the OptOutList.
	OptOutListArn *string `type:"string"`

	// The name of the new OptOutList.
	OptOutListName *string `min:"1" type:"string"`

	// An array of tags (key and value pairs) associated with the new OptOutList.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOptOutListOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOptOutListOutput) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *CreateOptOutListOutput) SetCreatedTimestamp(v time.Time) *CreateOptOutListOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetOptOutListArn sets the OptOutListArn field's value.
func (s *CreateOptOutListOutput) SetOptOutListArn(v string) *CreateOptOutListOutput {
	s.OptOutListArn = &v
	return s
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *CreateOptOutListOutput) SetOptOutListName(v string) *CreateOptOutListOutput {
	s.OptOutListName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateOptOutListOutput) SetTags(v []*Tag) *CreateOptOutListOutput {
	s.Tags = v
	return s
}

type CreatePoolInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don't specify a client token, a randomly generated
	// token is used for the request to ensure idempotency.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// By default this is set to false. When set to true the pool can't be deleted.
	// You can change this value using the UpdatePool action.
	DeletionProtectionEnabled *bool `type:"boolean"`

	// The new two-character code, in ISO 3166-1 alpha-2 format, for the country
	// or region of the new pool.
	//
	// IsoCountryCode is a required field
	IsoCountryCode *string `min:"2" type:"string" required:"true"`

	// The type of message. Valid values are TRANSACTIONAL for messages that are
	// critical or time-sensitive and PROMOTIONAL for messages that aren't critical
	// or time-sensitive.
	//
	// MessageType is a required field
	MessageType *string `type:"string" required:"true" enum:"MessageType"`

	// The origination identity to use such as a PhoneNumberId, PhoneNumberArn,
	// SenderId or SenderIdArn. You can use DescribePhoneNumbers to find the values
	// for PhoneNumberId and PhoneNumberArn while DescribeSenderIds can be used
	// to get the values for SenderId and SenderIdArn.
	//
	// OriginationIdentity is a required field
	OriginationIdentity *string `min:"1" type:"string" required:"true"`

	// An array of tags (key and value pairs) associated with the pool.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePoolInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.IsoCountryCode == nil {
		invalidParams.Add(request.NewErrParamRequired("IsoCountryCode"))
	}
	if s.IsoCountryCode != nil && len(*s.IsoCountryCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("IsoCountryCode", 2))
	}
	if s.MessageType == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageType"))
	}
	if s.OriginationIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginationIdentity"))
	}
	if s.OriginationIdentity != nil && len(*s.OriginationIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OriginationIdentity", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePoolInput) SetClientToken(v string) *CreatePoolInput {
	s.ClientToken = &v
	return s
}

// SetDeletionProtectionEnabled sets the DeletionProtectionEnabled field's value.
func (s *CreatePoolInput) SetDeletionProtectionEnabled(v bool) *CreatePoolInput {
	s.DeletionProtectionEnabled = &v
	return s
}

// SetIsoCountryCode sets the IsoCountryCode field's value.
func (s *CreatePoolInput) SetIsoCountryCode(v string) *CreatePoolInput {
	s.IsoCountryCode = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *CreatePoolInput) SetMessageType(v string) *CreatePoolInput {
	s.MessageType = &v
	return s
}

// SetOriginationIdentity sets the OriginationIdentity field's value.
func (s *CreatePoolInput) SetOriginationIdentity(v string) *CreatePoolInput {
	s.OriginationIdentity = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePoolInput) SetTags(v []*Tag) *CreatePoolInput {
	s.Tags = v
	return s
}

type CreatePoolOutput struct {
	_ struct{} `type:"structure"`

	// The time when the pool was created, in UNIX epoch time (https://www.epochconverter.com/)
	// format.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// When set to true deletion protection is enabled. By default this is set to
	// false.
	DeletionProtectionEnabled *bool `type:"boolean"`

	// The type of message for the pool to use.
	MessageType *string `type:"string" enum:"MessageType"`

	// The name of the OptOutList associated with the pool.
	OptOutListName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) for the pool.
	PoolArn *string `type:"string"`

	// The unique identifier for the pool.
	PoolId *string `type:"string"`

	// By default this is set to false. When an end recipient sends a message that
	// begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint
	// automatically replies with a customizable message and adds the end recipient
	// to the OptOutList. When set to true you're responsible for responding to
	// HELP and STOP requests. You're also responsible for tracking and honoring
	// opt-out requests.
	SelfManagedOptOutsEnabled *bool `type:"boolean"`

	// Indicates whether shared routes are enabled for the pool.
	SharedRoutesEnabled *bool `type:"boolean"`

	// The current status of the pool.
	//
	//    * CREATING: The pool is currently being created and isn't yet available
	//    for use.
	//
	//    * ACTIVE: The pool is active and available for use.
	//
	//    * DELETING: The pool is being deleted.
	Status *string `type:"string" enum:"PoolStatus"`

	// An array of tags (key and value pairs) associated with the pool.
	Tags []*Tag `type:"list"`

	// The Amazon Resource Name (ARN) of the two way channel.
	TwoWayChannelArn *string `min:"20" type:"string"`

	// By default this is set to false. When set to true you can receive incoming
	// text messages from your end recipients.
	TwoWayEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePoolOutput) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *CreatePoolOutput) SetCreatedTimestamp(v time.Time) *CreatePoolOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDeletionProtectionEnabled sets the DeletionProtectionEnabled field's value.
func (s *CreatePoolOutput) SetDeletionProtectionEnabled(v bool) *CreatePoolOutput {
	s.DeletionProtectionEnabled = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *CreatePoolOutput) SetMessageType(v string) *CreatePoolOutput {
	s.MessageType = &v
	return s
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *CreatePoolOutput) SetOptOutListName(v string) *CreatePoolOutput {
	s.OptOutListName = &v
	return s
}

// SetPoolArn sets the PoolArn field's value.
func (s *CreatePoolOutput) SetPoolArn(v string) *CreatePoolOutput {
	s.PoolArn = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *CreatePoolOutput) SetPoolId(v string) *CreatePoolOutput {
	s.PoolId = &v
	return s
}

// SetSelfManagedOptOutsEnabled sets the SelfManagedOptOutsEnabled field's value.
func (s *CreatePoolOutput) SetSelfManagedOptOutsEnabled(v bool) *CreatePoolOutput {
	s.SelfManagedOptOutsEnabled = &v
	return s
}

// SetSharedRoutesEnabled sets the SharedRoutesEnabled field's value.
func (s *CreatePoolOutput) SetSharedRoutesEnabled(v bool) *CreatePoolOutput {
	s.SharedRoutesEnabled = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreatePoolOutput) SetStatus(v string) *CreatePoolOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePoolOutput) SetTags(v []*Tag) *CreatePoolOutput {
	s.Tags = v
	return s
}

// SetTwoWayChannelArn sets the TwoWayChannelArn field's value.
func (s *CreatePoolOutput) SetTwoWayChannelArn(v string) *CreatePoolOutput {
	s.TwoWayChannelArn = &v
	return s
}

// SetTwoWayEnabled sets the TwoWayEnabled field's value.
func (s *CreatePoolOutput) SetTwoWayEnabled(v bool) *CreatePoolOutput {
	s.TwoWayEnabled = &v
	return s
}

type DeleteConfigurationSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set or the configuration set ARN that you want
	// to delete. The ConfigurationSetName and ConfigurationSetArn can be found
	// using the DescribeConfigurationSets action.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationSetInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DeleteConfigurationSetInput) SetConfigurationSetName(v string) *DeleteConfigurationSetInput {
	s.ConfigurationSetName = &v
	return s
}

type DeleteConfigurationSetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted configuration set.
	ConfigurationSetArn *string `type:"string"`

	// The name of the deleted configuration set.
	ConfigurationSetName *string `min:"1" type:"string"`

	// The time that the deleted configuration set was created in UNIX epoch time
	// (https://www.epochconverter.com/) format.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The default message type of the configuration set that was deleted.
	DefaultMessageType *string `type:"string" enum:"MessageType"`

	// The default Sender ID of the configuration set that was deleted.
	DefaultSenderId *string `min:"1" type:"string"`

	// An array of any EventDestination objects that were associated with the deleted
	// configuration set.
	EventDestinations []*EventDestination `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetOutput) GoString() string {
	return s.String()
}

// SetConfigurationSetArn sets the ConfigurationSetArn field's value.
func (s *DeleteConfigurationSetOutput) SetConfigurationSetArn(v string) *DeleteConfigurationSetOutput {
	s.ConfigurationSetArn = &v
	return s
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DeleteConfigurationSetOutput) SetConfigurationSetName(v string) *DeleteConfigurationSetOutput {
	s.ConfigurationSetName = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *DeleteConfigurationSetOutput) SetCreatedTimestamp(v time.Time) *DeleteConfigurationSetOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDefaultMessageType sets the DefaultMessageType field's value.
func (s *DeleteConfigurationSetOutput) SetDefaultMessageType(v string) *DeleteConfigurationSetOutput {
	s.DefaultMessageType = &v
	return s
}

// SetDefaultSenderId sets the DefaultSenderId field's value.
func (s *DeleteConfigurationSetOutput) SetDefaultSenderId(v string) *DeleteConfigurationSetOutput {
	s.DefaultSenderId = &v
	return s
}

// SetEventDestinations sets the EventDestinations field's value.
func (s *DeleteConfigurationSetOutput) SetEventDestinations(v []*EventDestination) *DeleteConfigurationSetOutput {
	s.EventDestinations = v
	return s
}

type DeleteDefaultMessageTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set or the configuration set Amazon Resource
	// Name (ARN) to delete the default message type from. The ConfigurationSetName
	// and ConfigurationSetArn can be found using the DescribeConfigurationSets
	// action.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDefaultMessageTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDefaultMessageTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDefaultMessageTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDefaultMessageTypeInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DeleteDefaultMessageTypeInput) SetConfigurationSetName(v string) *DeleteDefaultMessageTypeInput {
	s.ConfigurationSetName = &v
	return s
}

type DeleteDefaultMessageTypeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configuration set.
	ConfigurationSetArn *string `type:"string"`

	// The name of the configuration set.
	ConfigurationSetName *string `min:"1" type:"string"`

	// The current message type for the configuration set.
	MessageType *string `type:"string" enum:"MessageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDefaultMessageTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDefaultMessageTypeOutput) GoString() string {
	return s.String()
}

// SetConfigurationSetArn sets the ConfigurationSetArn field's value.
func (s *DeleteDefaultMessageTypeOutput) SetConfigurationSetArn(v string) *DeleteDefaultMessageTypeOutput {
	s.ConfigurationSetArn = &v
	return s
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DeleteDefaultMessageTypeOutput) SetConfigurationSetName(v string) *DeleteDefaultMessageTypeOutput {
	s.ConfigurationSetName = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *DeleteDefaultMessageTypeOutput) SetMessageType(v string) *DeleteDefaultMessageTypeOutput {
	s.MessageType = &v
	return s
}

type DeleteDefaultSenderIdInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set or the configuration set Amazon Resource
	// Name (ARN) to delete the default sender ID from. The ConfigurationSetName
	// and ConfigurationSetArn can be found using the DescribeConfigurationSets
	// action.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDefaultSenderIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDefaultSenderIdInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDefaultSenderIdInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDefaultSenderIdInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DeleteDefaultSenderIdInput) SetConfigurationSetName(v string) *DeleteDefaultSenderIdInput {
	s.ConfigurationSetName = &v
	return s
}

type DeleteDefaultSenderIdOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configuration set.
	ConfigurationSetArn *string `type:"string"`

	// The name of the configuration set.
	ConfigurationSetName *string `min:"1" type:"string"`

	// The current sender ID for the configuration set.
	SenderId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDefaultSenderIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDefaultSenderIdOutput) GoString() string {
	return s.String()
}

// SetConfigurationSetArn sets the ConfigurationSetArn field's value.
func (s *DeleteDefaultSenderIdOutput) SetConfigurationSetArn(v string) *DeleteDefaultSenderIdOutput {
	s.ConfigurationSetArn = &v
	return s
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DeleteDefaultSenderIdOutput) SetConfigurationSetName(v string) *DeleteDefaultSenderIdOutput {
	s.ConfigurationSetName = &v
	return s
}

// SetSenderId sets the SenderId field's value.
func (s *DeleteDefaultSenderIdOutput) SetSenderId(v string) *DeleteDefaultSenderIdOutput {
	s.SenderId = &v
	return s
}

type DeleteEventDestinationInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set or the configuration set's Amazon Resource
	// Name (ARN) to remove the event destination from. The ConfigurateSetName and
	// ConfigurationSetArn can be found using the DescribeConfigurationSets action.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `min:"1" type:"string" required:"true"`

	// The name of the event destination to delete.
	//
	// EventDestinationName is a required field
	EventDestinationName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventDestinationInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}
	if s.EventDestinationName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestinationName"))
	}
	if s.EventDestinationName != nil && len(*s.EventDestinationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventDestinationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DeleteEventDestinationInput) SetConfigurationSetName(v string) *DeleteEventDestinationInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestinationName sets the EventDestinationName field's value.
func (s *DeleteEventDestinationInput) SetEventDestinationName(v string) *DeleteEventDestinationInput {
	s.EventDestinationName = &v
	return s
}

type DeleteEventDestinationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configuration set.
	ConfigurationSetArn *string `type:"string"`

	// The name of the configuration set the event destination was deleted from.
	ConfigurationSetName *string `min:"1" type:"string"`

	// The event destination object that was deleted.
	EventDestination *EventDestination `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventDestinationOutput) GoString() string {
	return s.String()
}

// SetConfigurationSetArn sets the ConfigurationSetArn field's value.
func (s *DeleteEventDestinationOutput) SetConfigurationSetArn(v string) *DeleteEventDestinationOutput {
	s.ConfigurationSetArn = &v
	return s
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DeleteEventDestinationOutput) SetConfigurationSetName(v string) *DeleteEventDestinationOutput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestination sets the EventDestination field's value.
func (s *DeleteEventDestinationOutput) SetEventDestination(v *EventDestination) *DeleteEventDestinationOutput {
	s.EventDestination = v
	return s
}

type DeleteKeywordInput struct {
	_ struct{} `type:"structure"`

	// The keyword to delete.
	//
	// Keyword is a required field
	Keyword *string `min:"1" type:"string" required:"true"`

	// The origination identity to use such as a PhoneNumberId, PhoneNumberArn,
	// PoolId or PoolArn. You can use DescribePhoneNumbers to find the values for
	// PhoneNumberId and PhoneNumberArn and DescribePools to find the values of
	// PoolId and PoolArn.
	//
	// OriginationIdentity is a required field
	OriginationIdentity *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeywordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeywordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKeywordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKeywordInput"}
	if s.Keyword == nil {
		invalidParams.Add(request.NewErrParamRequired("Keyword"))
	}
	if s.Keyword != nil && len(*s.Keyword) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Keyword", 1))
	}
	if s.OriginationIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginationIdentity"))
	}
	if s.OriginationIdentity != nil && len(*s.OriginationIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OriginationIdentity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyword sets the Keyword field's value.
func (s *DeleteKeywordInput) SetKeyword(v string) *DeleteKeywordInput {
	s.Keyword = &v
	return s
}

// SetOriginationIdentity sets the OriginationIdentity field's value.
func (s *DeleteKeywordInput) SetOriginationIdentity(v string) *DeleteKeywordInput {
	s.OriginationIdentity = &v
	return s
}

type DeleteKeywordOutput struct {
	_ struct{} `type:"structure"`

	// The keyword that was deleted.
	Keyword *string `min:"1" type:"string"`

	// The action that was associated with the deleted keyword.
	KeywordAction *string `type:"string" enum:"KeywordAction"`

	// The message that was associated with the deleted keyword.
	KeywordMessage *string `min:"1" type:"string"`

	// The PhoneNumberId or PoolId that the keyword was associated with.
	OriginationIdentity *string `type:"string"`

	// The PhoneNumberArn or PoolArn that the keyword was associated with.
	OriginationIdentityArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeywordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeywordOutput) GoString() string {
	return s.String()
}

// SetKeyword sets the Keyword field's value.
func (s *DeleteKeywordOutput) SetKeyword(v string) *DeleteKeywordOutput {
	s.Keyword = &v
	return s
}

// SetKeywordAction sets the KeywordAction field's value.
func (s *DeleteKeywordOutput) SetKeywordAction(v string) *DeleteKeywordOutput {
	s.KeywordAction = &v
	return s
}

// SetKeywordMessage sets the KeywordMessage field's value.
func (s *DeleteKeywordOutput) SetKeywordMessage(v string) *DeleteKeywordOutput {
	s.KeywordMessage = &v
	return s
}

// SetOriginationIdentity sets the OriginationIdentity field's value.
func (s *DeleteKeywordOutput) SetOriginationIdentity(v string) *DeleteKeywordOutput {
	s.OriginationIdentity = &v
	return s
}

// SetOriginationIdentityArn sets the OriginationIdentityArn field's value.
func (s *DeleteKeywordOutput) SetOriginationIdentityArn(v string) *DeleteKeywordOutput {
	s.OriginationIdentityArn = &v
	return s
}

type DeleteOptOutListInput struct {
	_ struct{} `type:"structure"`

	// The OptOutListName or OptOutListArn of the OptOutList to delete. You can
	// use DescribeOptOutLists to find the values for OptOutListName and OptOutListArn.
	//
	// OptOutListName is a required field
	OptOutListName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOptOutListInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOptOutListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOptOutListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOptOutListInput"}
	if s.OptOutListName == nil {
		invalidParams.Add(request.NewErrParamRequired("OptOutListName"))
	}
	if s.OptOutListName != nil && len(*s.OptOutListName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OptOutListName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *DeleteOptOutListInput) SetOptOutListName(v string) *DeleteOptOutListInput {
	s.OptOutListName = &v
	return s
}

type DeleteOptOutListOutput struct {
	_ struct{} `type:"structure"`

	// The time when the OptOutList was created, in UNIX epoch time (https://www.epochconverter.com/)
	// format.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the OptOutList that was removed.
	OptOutListArn *string `type:"string"`

	// The name of the OptOutList that was removed.
	OptOutListName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOptOutListOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOptOutListOutput) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *DeleteOptOutListOutput) SetCreatedTimestamp(v time.Time) *DeleteOptOutListOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetOptOutListArn sets the OptOutListArn field's value.
func (s *DeleteOptOutListOutput) SetOptOutListArn(v string) *DeleteOptOutListOutput {
	s.OptOutListArn = &v
	return s
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *DeleteOptOutListOutput) SetOptOutListName(v string) *DeleteOptOutListOutput {
	s.OptOutListName = &v
	return s
}

type DeleteOptedOutNumberInput struct {
	_ struct{} `type:"structure"`

	// The OptOutListName or OptOutListArn to remove the phone number from.
	//
	// OptOutListName is a required field
	OptOutListName *string `min:"1" type:"string" required:"true"`

	// The phone number, in E.164 format, to remove from the OptOutList.
	//
	// OptedOutNumber is a required field
	OptedOutNumber *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOptedOutNumberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOptedOutNumberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOptedOutNumberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOptedOutNumberInput"}
	if s.OptOutListName == nil {
		invalidParams.Add(request.NewErrParamRequired("OptOutListName"))
	}
	if s.OptOutListName != nil && len(*s.OptOutListName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OptOutListName", 1))
	}
	if s.OptedOutNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("OptedOutNumber"))
	}
	if s.OptedOutNumber != nil && len(*s.OptedOutNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OptedOutNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *DeleteOptedOutNumberInput) SetOptOutListName(v string) *DeleteOptedOutNumberInput {
	s.OptOutListName = &v
	return s
}

// SetOptedOutNumber sets the OptedOutNumber field's value.
func (s *DeleteOptedOutNumberInput) SetOptedOutNumber(v string) *DeleteOptedOutNumberInput {
	s.OptedOutNumber = &v
	return s
}

type DeleteOptedOutNumberOutput struct {
	_ struct{} `type:"structure"`

	// This is true if it was the end user who requested their phone number be removed.
	EndUserOptedOut *bool `type:"boolean"`

	// The OptOutListArn that the phone number was removed from.
	OptOutListArn *string `type:"string"`

	// The OptOutListName that the phone number was removed from.
	OptOutListName *string `min:"1" type:"string"`

	// The phone number that was removed from the OptOutList.
	OptedOutNumber *string `min:"1" type:"string"`

	// The time that the number was removed at, in UNIX epoch time (https://www.epochconverter.com/)
	// format.
	OptedOutTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOptedOutNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOptedOutNumberOutput) GoString() string {
	return s.String()
}

// SetEndUserOptedOut sets the EndUserOptedOut field's value.
func (s *DeleteOptedOutNumberOutput) SetEndUserOptedOut(v bool) *DeleteOptedOutNumberOutput {
	s.EndUserOptedOut = &v
	return s
}

// SetOptOutListArn sets the OptOutListArn field's value.
func (s *DeleteOptedOutNumberOutput) SetOptOutListArn(v string) *DeleteOptedOutNumberOutput {
	s.OptOutListArn = &v
	return s
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *DeleteOptedOutNumberOutput) SetOptOutListName(v string) *DeleteOptedOutNumberOutput {
	s.OptOutListName = &v
	return s
}

// SetOptedOutNumber sets the OptedOutNumber field's value.
func (s *DeleteOptedOutNumberOutput) SetOptedOutNumber(v string) *DeleteOptedOutNumberOutput {
	s.OptedOutNumber = &v
	return s
}

// SetOptedOutTimestamp sets the OptedOutTimestamp field's value.
func (s *DeleteOptedOutNumberOutput) SetOptedOutTimestamp(v time.Time) *DeleteOptedOutNumberOutput {
	s.OptedOutTimestamp = &v
	return s
}

type DeletePoolInput struct {
	_ struct{} `type:"structure"`

	// The PoolId or PoolArn of the pool to delete. You can use DescribePools to
	// find the values for PoolId and PoolArn .
	//
	// PoolId is a required field
	PoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePoolInput"}
	if s.PoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolId"))
	}
	if s.PoolId != nil && len(*s.PoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPoolId sets the PoolId field's value.
func (s *DeletePoolInput) SetPoolId(v string) *DeletePoolInput {
	s.PoolId = &v
	return s
}

type DeletePoolOutput struct {
	_ struct{} `type:"structure"`

	// The time when the pool was created, in UNIX epoch time (https://www.epochconverter.com/)
	// format.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The message type that was associated with the deleted pool.
	MessageType *string `type:"string" enum:"MessageType"`

	// The name of the OptOutList that was associated with the deleted pool.
	OptOutListName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the pool that was deleted.
	PoolArn *string `type:"string"`

	// The PoolId of the pool that was deleted.
	PoolId *string `type:"string"`

	// By default this is set to false. When an end recipient sends a message that
	// begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint
	// automatically replies with a customizable message and adds the end recipient
	// to the OptOutList. When set to true you're responsible for responding to
	// HELP and STOP requests. You're also responsible for tracking and honoring
	// opt-out requests.
	SelfManagedOptOutsEnabled *bool `type:"boolean"`

	// Indicates whether shared routes are enabled for the pool.
	SharedRoutesEnabled *bool `type:"boolean"`

	// The current status of the pool.
	//
	//    * CREATING: The pool is currently being created and isn't yet available
	//    for use.
	//
	//    * ACTIVE: The pool is active and available for use.
	//
	//    * DELETING: The pool is being deleted.
	Status *string `type:"string" enum:"PoolStatus"`

	// The Amazon Resource Name (ARN) of the TwoWayChannel.
	TwoWayChannelArn *string `min:"20" type:"string"`

	// By default this is set to false. When set to true you can receive incoming
	// text messages from your end recipients.
	TwoWayEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePoolOutput) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *DeletePoolOutput) SetCreatedTimestamp(v time.Time) *DeletePoolOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *DeletePoolOutput) SetMessageType(v string) *DeletePoolOutput {
	s.MessageType = &v
	return s
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *DeletePoolOutput) SetOptOutListName(v string) *DeletePoolOutput {
	s.OptOutListName = &v
	return s
}

// SetPoolArn sets the PoolArn field's value.
func (s *DeletePoolOutput) SetPoolArn(v string) *DeletePoolOutput {
	s.PoolArn = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *DeletePoolOutput) SetPoolId(v string) *DeletePoolOutput {
	s.PoolId = &v
	return s
}

// SetSelfManagedOptOutsEnabled sets the SelfManagedOptOutsEnabled field's value.
func (s *DeletePoolOutput) SetSelfManagedOptOutsEnabled(v bool) *DeletePoolOutput {
	s.SelfManagedOptOutsEnabled = &v
	return s
}

// SetSharedRoutesEnabled sets the SharedRoutesEnabled field's value.
func (s *DeletePoolOutput) SetSharedRoutesEnabled(v bool) *DeletePoolOutput {
	s.SharedRoutesEnabled = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeletePoolOutput) SetStatus(v string) *DeletePoolOutput {
	s.Status = &v
	return s
}

// SetTwoWayChannelArn sets the TwoWayChannelArn field's value.
func (s *DeletePoolOutput) SetTwoWayChannelArn(v string) *DeletePoolOutput {
	s.TwoWayChannelArn = &v
	return s
}

// SetTwoWayEnabled sets the TwoWayEnabled field's value.
func (s *DeletePoolOutput) SetTwoWayEnabled(v bool) *DeletePoolOutput {
	s.TwoWayEnabled = &v
	return s
}

type DeleteTextMessageSpendLimitOverrideInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTextMessageSpendLimitOverrideInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTextMessageSpendLimitOverrideInput) GoString() string {
	return s.String()
}

type DeleteTextMessageSpendLimitOverrideOutput struct {
	_ struct{} `type:"structure"`

	// The current monthly limit, in US dollars.
	MonthlyLimit *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTextMessageSpendLimitOverrideOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTextMessageSpendLimitOverrideOutput) GoString() string {
	return s.String()
}

// SetMonthlyLimit sets the MonthlyLimit field's value.
func (s *DeleteTextMessageSpendLimitOverrideOutput) SetMonthlyLimit(v int64) *DeleteTextMessageSpendLimitOverrideOutput {
	s.MonthlyLimit = &v
	return s
}

type DeleteVoiceMessageSpendLimitOverrideInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceMessageSpendLimitOverrideInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceMessageSpendLimitOverrideInput) GoString() string {
	return s.String()
}

type DeleteVoiceMessageSpendLimitOverrideOutput struct {
	_ struct{} `type:"structure"`

	// The current monthly limit, in US dollars.
	MonthlyLimit *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceMessageSpendLimitOverrideOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVoiceMessageSpendLimitOverrideOutput) GoString() string {
	return s.String()
}

// SetMonthlyLimit sets the MonthlyLimit field's value.
func (s *DeleteVoiceMessageSpendLimitOverrideOutput) SetMonthlyLimit(v int64) *DeleteVoiceMessageSpendLimitOverrideOutput {
	s.MonthlyLimit = &v
	return s
}

type DescribeAccountAttributesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return per each request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to be used for the next set of paginated results. You don't need
	// to supply a value for this field in the initial request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountAttributesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeAccountAttributesInput) SetMaxResults(v int64) *DescribeAccountAttributesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccountAttributesInput) SetNextToken(v string) *DescribeAccountAttributesInput {
	s.NextToken = &v
	return s
}

type DescribeAccountAttributesOutput struct {
	_ struct{} `type:"structure"`

	// An array of AccountAttributes objects.
	AccountAttributes []*AccountAttribute `type:"list"`

	// The token to be used for the next set of paginated results. If this field
	// is empty then there are no more results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountAttributesOutput) GoString() string {
	return s.String()
}

// SetAccountAttributes sets the AccountAttributes field's value.
func (s *DescribeAccountAttributesOutput) SetAccountAttributes(v []*AccountAttribute) *DescribeAccountAttributesOutput {
	s.AccountAttributes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccountAttributesOutput) SetNextToken(v string) *DescribeAccountAttributesOutput {
	s.NextToken = &v
	return s
}

type DescribeAccountLimitsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return per each request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to be used for the next set of paginated results. You don't need
	// to supply a value for this field in the initial request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountLimitsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountLimitsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountLimitsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeAccountLimitsInput) SetMaxResults(v int64) *DescribeAccountLimitsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccountLimitsInput) SetNextToken(v string) *DescribeAccountLimitsInput {
	s.NextToken = &v
	return s
}

type DescribeAccountLimitsOutput struct {
	_ struct{} `type:"structure"`

	// An array of AccountLimit objects that show the current spend limits.
	AccountLimits []*AccountLimit `type:"list"`

	// The token to be used for the next set of paginated results. If this field
	// is empty then there are no more results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountLimitsOutput) GoString() string {
	return s.String()
}

// SetAccountLimits sets the AccountLimits field's value.
func (s *DescribeAccountLimitsOutput) SetAccountLimits(v []*AccountLimit) *DescribeAccountLimitsOutput {
	s.AccountLimits = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccountLimitsOutput) SetNextToken(v string) *DescribeAccountLimitsOutput {
	s.NextToken = &v
	return s
}

type DescribeConfigurationSetsInput struct {
	_ struct{} `type:"structure"`

	// An array of strings. Each element can be either a ConfigurationSetName or
	// ConfigurationSetArn.
	ConfigurationSetNames []*string `type:"list"`

	// An array of filters to apply to the results that are returned.
	Filters []*ConfigurationSetFilter `type:"list"`

	// The maximum number of results to return per each request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to be used for the next set of paginated results. You don't need
	// to supply a value for this field in the initial request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConfigurationSetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetNames sets the ConfigurationSetNames field's value.
func (s *DescribeConfigurationSetsInput) SetConfigurationSetNames(v []*string) *DescribeConfigurationSetsInput {
	s.ConfigurationSetNames = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeConfigurationSetsInput) SetFilters(v []*ConfigurationSetFilter) *DescribeConfigurationSetsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeConfigurationSetsInput) SetMaxResults(v int64) *DescribeConfigurationSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigurationSetsInput) SetNextToken(v string) *DescribeConfigurationSetsInput {
	s.NextToken = &v
	return s
}

type DescribeConfigurationSetsOutput struct {
	_ struct{} `type:"structure"`

	// An array of ConfigurationSets objects.
	ConfigurationSets []*ConfigurationSetInformation `type:"list"`

	// The token to be used for the next set of paginated results. If this field
	// is empty then there are no more results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationSetsOutput) GoString() string {
	return s.String()
}

// SetConfigurationSets sets the ConfigurationSets field's value.
func (s *DescribeConfigurationSetsOutput) SetConfigurationSets(v []*ConfigurationSetInformation) *DescribeConfigurationSetsOutput {
	s.ConfigurationSets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigurationSetsOutput) SetNextToken(v string) *DescribeConfigurationSetsOutput {
	s.NextToken = &v
	return s
}

type DescribeKeywordsInput struct {
	_ struct{} `type:"structure"`

	// An array of keyword filters to filter the results.
	Filters []*KeywordFilter `type:"list"`

	// An array of keywords to search for.
	Keywords []*string `type:"list"`

	// The maximum number of results to return per each request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to be used for the next set of paginated results. You don't need
	// to supply a value for this field in the initial request.
	NextToken *string `min:"1" type:"string"`

	// The origination identity to use such as a PhoneNumberId, PhoneNumberArn,
	// SenderId or SenderIdArn. You can use DescribePhoneNumbers to find the values
	// for PhoneNumberId and PhoneNumberArn while DescribeSenderIds can be used
	// to get the values for SenderId and SenderIdArn.
	//
	// OriginationIdentity is a required field
	OriginationIdentity *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeywordsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeywordsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeKeywordsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeKeywordsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OriginationIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginationIdentity"))
	}
	if s.OriginationIdentity != nil && len(*s.OriginationIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OriginationIdentity", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeKeywordsInput) SetFilters(v []*KeywordFilter) *DescribeKeywordsInput {
	s.Filters = v
	return s
}

// SetKeywords sets the Keywords field's value.
func (s *DescribeKeywordsInput) SetKeywords(v []*string) *DescribeKeywordsInput {
	s.Keywords = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeKeywordsInput) SetMaxResults(v int64) *DescribeKeywordsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeKeywordsInput) SetNextToken(v string) *DescribeKeywordsInput {
	s.NextToken = &v
	return s
}

// SetOriginationIdentity sets the OriginationIdentity field's value.
func (s *DescribeKeywordsInput) SetOriginationIdentity(v string) *DescribeKeywordsInput {
	s.OriginationIdentity = &v
	return s
}

type DescribeKeywordsOutput struct {
	_ struct{} `type:"structure"`

	// An array of KeywordInformation objects that contain the results.
	Keywords []*KeywordInformation `type:"list"`

	// The token to be used for the next set of paginated results. If this field
	// is empty then there are no more results.
	NextToken *string `min:"1" type:"string"`

	// The PhoneNumberId or PoolId that is associated with the OriginationIdentity.
	OriginationIdentity *string `type:"string"`

	// The PhoneNumberArn or PoolArn that is associated with the OriginationIdentity.
	OriginationIdentityArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeywordsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeywordsOutput) GoString() string {
	return s.String()
}

// SetKeywords sets the Keywords field's value.
func (s *DescribeKeywordsOutput) SetKeywords(v []*KeywordInformation) *DescribeKeywordsOutput {
	s.Keywords = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeKeywordsOutput) SetNextToken(v string) *DescribeKeywordsOutput {
	s.NextToken = &v
	return s
}

// SetOriginationIdentity sets the OriginationIdentity field's value.
func (s *DescribeKeywordsOutput) SetOriginationIdentity(v string) *DescribeKeywordsOutput {
	s.OriginationIdentity = &v
	return s
}

// SetOriginationIdentityArn sets the OriginationIdentityArn field's value.
func (s *DescribeKeywordsOutput) SetOriginationIdentityArn(v string) *DescribeKeywordsOutput {
	s.OriginationIdentityArn = &v
	return s
}

type DescribeOptOutListsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return per each request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to be used for the next set of paginated results. You don't need
	// to supply a value for this field in the initial request.
	NextToken *string `min:"1" type:"string"`

	// The OptOutLists to show the details of. This is an array of strings that
	// can be either the OptOutListName or OptOutListArn.
	OptOutListNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOptOutListsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOptOutListsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOptOutListsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOptOutListsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeOptOutListsInput) SetMaxResults(v int64) *DescribeOptOutListsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOptOutListsInput) SetNextToken(v string) *DescribeOptOutListsInput {
	s.NextToken = &v
	return s
}

// SetOptOutListNames sets the OptOutListNames field's value.
func (s *DescribeOptOutListsInput) SetOptOutListNames(v []*string) *DescribeOptOutListsInput {
	s.OptOutListNames = v
	return s
}

type DescribeOptOutListsOutput struct {
	_ struct{} `type:"structure"`

	// The token to be used for the next set of paginated results. If this field
	// is empty then there are no more results.
	NextToken *string `min:"1" type:"string"`

	// An array of OptOutListInformation objects that contain the details for the
	// requested OptOutLists.
	OptOutLists []*OptOutListInformation `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOptOutListsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOptOutListsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOptOutListsOutput) SetNextToken(v string) *DescribeOptOutListsOutput {
	s.NextToken = &v
	return s
}

// SetOptOutLists sets the OptOutLists field's value.
func (s *DescribeOptOutListsOutput) SetOptOutLists(v []*OptOutListInformation) *DescribeOptOutListsOutput {
	s.OptOutLists = v
	return s
}

type DescribeOptedOutNumbersInput struct {
	_ struct{} `type:"structure"`

	// An array of OptedOutFilter objects to filter the results on.
	Filters []*OptedOutFilter `type:"list"`

	// The maximum number of results to return per each request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to be used for the next set of paginated results. You don't need
	// to supply a value for this field in the initial request.
	NextToken *string `min:"1" type:"string"`

	// The OptOutListName or OptOutListArn of the OptOutList. You can use DescribeOptOutLists
	// to find the values for OptOutListName and OptOutListArn.
	//
	// OptOutListName is a required field
	OptOutListName *string `min:"1" type:"string" required:"true"`

	// An array of phone numbers to search for in the OptOutList.
	OptedOutNumbers []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOptedOutNumbersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOptedOutNumbersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOptedOutNumbersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOptedOutNumbersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OptOutListName == nil {
		invalidParams.Add(request.NewErrParamRequired("OptOutListName"))
	}
	if s.OptOutListName != nil && len(*s.OptOutListName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OptOutListName", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeOptedOutNumbersInput) SetFilters(v []*OptedOutFilter) *DescribeOptedOutNumbersInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeOptedOutNumbersInput) SetMaxResults(v int64) *DescribeOptedOutNumbersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOptedOutNumbersInput) SetNextToken(v string) *DescribeOptedOutNumbersInput {
	s.NextToken = &v
	return s
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *DescribeOptedOutNumbersInput) SetOptOutListName(v string) *DescribeOptedOutNumbersInput {
	s.OptOutListName = &v
	return s
}

// SetOptedOutNumbers sets the OptedOutNumbers field's value.
func (s *DescribeOptedOutNumbersInput) SetOptedOutNumbers(v []*string) *DescribeOptedOutNumbersInput {
	s.OptedOutNumbers = v
	return s
}

type DescribeOptedOutNumbersOutput struct {
	_ struct{} `type:"structure"`

	// The token to be used for the next set of paginated results. If this field
	// is empty then there are no more results.
	NextToken *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the OptOutList.
	OptOutListArn *string `type:"string"`

	// The name of the OptOutList.
	OptOutListName *string `min:"1" type:"string"`

	// An array of OptedOutNumbersInformation objects that provide information about
	// the requested OptedOutNumbers.
	OptedOutNumbers []*OptedOutNumberInformation `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOptedOutNumbersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOptedOutNumbersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOptedOutNumbersOutput) SetNextToken(v string) *DescribeOptedOutNumbersOutput {
	s.NextToken = &v
	return s
}

// SetOptOutListArn sets the OptOutListArn field's value.
func (s *DescribeOptedOutNumbersOutput) SetOptOutListArn(v string) *DescribeOptedOutNumbersOutput {
	s.OptOutListArn = &v
	return s
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *DescribeOptedOutNumbersOutput) SetOptOutListName(v string) *DescribeOptedOutNumbersOutput {
	s.OptOutListName = &v
	return s
}

// SetOptedOutNumbers sets the OptedOutNumbers field's value.
func (s *DescribeOptedOutNumbersOutput) SetOptedOutNumbers(v []*OptedOutNumberInformation) *DescribeOptedOutNumbersOutput {
	s.OptedOutNumbers = v
	return s
}

type DescribePhoneNumbersInput struct {
	_ struct{} `type:"structure"`

	// An array of PhoneNumberFilter objects to filter the results.
	Filters []*PhoneNumberFilter `type:"list"`

	// The maximum number of results to return per each request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to be used for the next set of paginated results. You don't need
	// to supply a value for this field in the initial request.
	NextToken *string `min:"1" type:"string"`

	// The unique identifier of phone numbers to find information about. This is
	// an array of strings that can be either the PhoneNumberId or PhoneNumberArn.
	PhoneNumberIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePhoneNumbersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePhoneNumbersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePhoneNumbersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePhoneNumbersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribePhoneNumbersInput) SetFilters(v []*PhoneNumberFilter) *DescribePhoneNumbersInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribePhoneNumbersInput) SetMaxResults(v int64) *DescribePhoneNumbersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePhoneNumbersInput) SetNextToken(v string) *DescribePhoneNumbersInput {
	s.NextToken = &v
	return s
}

// SetPhoneNumberIds sets the PhoneNumberIds field's value.
func (s *DescribePhoneNumbersInput) SetPhoneNumberIds(v []*string) *DescribePhoneNumbersInput {
	s.PhoneNumberIds = v
	return s
}

type DescribePhoneNumbersOutput struct {
	_ struct{} `type:"structure"`

	// The token to be used for the next set of paginated results. If this field
	// is empty then there are no more results.
	NextToken *string `min:"1" type:"string"`

	// An array of PhoneNumberInformation objects that contain the details for the
	// requested phone numbers.
	PhoneNumbers []*PhoneNumberInformation `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePhoneNumbersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePhoneNumbersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePhoneNumbersOutput) SetNextToken(v string) *DescribePhoneNumbersOutput {
	s.NextToken = &v
	return s
}

// SetPhoneNumbers sets the PhoneNumbers field's value.
func (s *DescribePhoneNumbersOutput) SetPhoneNumbers(v []*PhoneNumberInformation) *DescribePhoneNumbersOutput {
	s.PhoneNumbers = v
	return s
}

type DescribePoolsInput struct {
	_ struct{} `type:"structure"`

	// An array of PoolFilter objects to filter the results.
	Filters []*PoolFilter `type:"list"`

	// The maximum number of results to return per each request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to be used for the next set of paginated results. You don't need
	// to supply a value for this field in the initial request.
	NextToken *string `min:"1" type:"string"`

	// The unique identifier of pools to find. This is an array of strings that
	// can be either the PoolId or PoolArn.
	PoolIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePoolsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePoolsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePoolsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePoolsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribePoolsInput) SetFilters(v []*PoolFilter) *DescribePoolsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribePoolsInput) SetMaxResults(v int64) *DescribePoolsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePoolsInput) SetNextToken(v string) *DescribePoolsInput {
	s.NextToken = &v
	return s
}

// SetPoolIds sets the PoolIds field's value.
func (s *DescribePoolsInput) SetPoolIds(v []*string) *DescribePoolsInput {
	s.PoolIds = v
	return s
}

type DescribePoolsOutput struct {
	_ struct{} `type:"structure"`

	// The token to be used for the next set of paginated results. If this field
	// is empty then there are no more results.
	NextToken *string `min:"1" type:"string"`

	// An array of PoolInformation objects that contain the details for the requested
	// pools.
	Pools []*PoolInformation `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePoolsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePoolsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePoolsOutput) SetNextToken(v string) *DescribePoolsOutput {
	s.NextToken = &v
	return s
}

// SetPools sets the Pools field's value.
func (s *DescribePoolsOutput) SetPools(v []*PoolInformation) *DescribePoolsOutput {
	s.Pools = v
	return s
}

type DescribeSenderIdsInput struct {
	_ struct{} `type:"structure"`

	// An array of SenderIdFilter objects to filter the results.
	Filters []*SenderIdFilter `type:"list"`

	// The maximum number of results to return per each request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to be used for the next set of paginated results. You don't need
	// to supply a value for this field in the initial request.
	NextToken *string `min:"1" type:"string"`

	// An array of SenderIdAndCountry objects to search for.
	SenderIds []*SenderIdAndCountry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSenderIdsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSenderIdsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSenderIdsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSenderIdsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SenderIds != nil {
		for i, v := range s.SenderIds {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SenderIds", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeSenderIdsInput) SetFilters(v []*SenderIdFilter) *DescribeSenderIdsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeSenderIdsInput) SetMaxResults(v int64) *DescribeSenderIdsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSenderIdsInput) SetNextToken(v string) *DescribeSenderIdsInput {
	s.NextToken = &v
	return s
}

// SetSenderIds sets the SenderIds field's value.
func (s *DescribeSenderIdsInput) SetSenderIds(v []*SenderIdAndCountry) *DescribeSenderIdsInput {
	s.SenderIds = v
	return s
}

type DescribeSenderIdsOutput struct {
	_ struct{} `type:"structure"`

	// The token to be used for the next set of paginated results. If this field
	// is empty then there are no more results.
	NextToken *string `min:"1" type:"string"`

	// An array of SernderIdInformation objects that contain the details for the
	// requested SenderIds.
	SenderIds []*SenderIdInformation `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSenderIdsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSenderIdsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSenderIdsOutput) SetNextToken(v string) *DescribeSenderIdsOutput {
	s.NextToken = &v
	return s
}

// SetSenderIds sets the SenderIds field's value.
func (s *DescribeSenderIdsOutput) SetSenderIds(v []*SenderIdInformation) *DescribeSenderIdsOutput {
	s.SenderIds = v
	return s
}

type DescribeSpendLimitsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return per each request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to be used for the next set of paginated results. You don't need
	// to supply a value for this field in the initial request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSpendLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSpendLimitsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSpendLimitsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSpendLimitsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeSpendLimitsInput) SetMaxResults(v int64) *DescribeSpendLimitsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSpendLimitsInput) SetNextToken(v string) *DescribeSpendLimitsInput {
	s.NextToken = &v
	return s
}

type DescribeSpendLimitsOutput struct {
	_ struct{} `type:"structure"`

	// The token to be used for the next set of paginated results. If this field
	// is empty then there are no more results.
	NextToken *string `min:"1" type:"string"`

	// An array of SpendLimit objects that contain the details for the requested
	// spend limits.
	SpendLimits []*SpendLimit `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSpendLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSpendLimitsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSpendLimitsOutput) SetNextToken(v string) *DescribeSpendLimitsOutput {
	s.NextToken = &v
	return s
}

// SetSpendLimits sets the SpendLimits field's value.
func (s *DescribeSpendLimitsOutput) SetSpendLimits(v []*SpendLimit) *DescribeSpendLimitsOutput {
	s.SpendLimits = v
	return s
}

type DisassociateOriginationIdentityInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request. If you don't specify a client token, a randomly generated token
	// is used for the request to ensure idempotency.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region.
	//
	// IsoCountryCode is a required field
	IsoCountryCode *string `min:"2" type:"string" required:"true"`

	// The origination identity to use such as a PhoneNumberId, PhoneNumberArn,
	// SenderId or SenderIdArn. You can use DescribePhoneNumbers find the values
	// for PhoneNumberId and PhoneNumberArn, or use DescribeSenderIds to get the
	// values for SenderId and SenderIdArn.
	//
	// OriginationIdentity is a required field
	OriginationIdentity *string `min:"1" type:"string" required:"true"`

	// The unique identifier for the pool to disassociate with the origination identity.
	// This value can be either the PoolId or PoolArn.
	//
	// PoolId is a required field
	PoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateOriginationIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateOriginationIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateOriginationIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateOriginationIdentityInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.IsoCountryCode == nil {
		invalidParams.Add(request.NewErrParamRequired("IsoCountryCode"))
	}
	if s.IsoCountryCode != nil && len(*s.IsoCountryCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("IsoCountryCode", 2))
	}
	if s.OriginationIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginationIdentity"))
	}
	if s.OriginationIdentity != nil && len(*s.OriginationIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OriginationIdentity", 1))
	}
	if s.PoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolId"))
	}
	if s.PoolId != nil && len(*s.PoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DisassociateOriginationIdentityInput) SetClientToken(v string) *DisassociateOriginationIdentityInput {
	s.ClientToken = &v
	return s
}

// SetIsoCountryCode sets the IsoCountryCode field's value.
func (s *DisassociateOriginationIdentityInput) SetIsoCountryCode(v string) *DisassociateOriginationIdentityInput {
	s.IsoCountryCode = &v
	return s
}

// SetOriginationIdentity sets the OriginationIdentity field's value.
func (s *DisassociateOriginationIdentityInput) SetOriginationIdentity(v string) *DisassociateOriginationIdentityInput {
	s.OriginationIdentity = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *DisassociateOriginationIdentityInput) SetPoolId(v string) *DisassociateOriginationIdentityInput {
	s.PoolId = &v
	return s
}

type DisassociateOriginationIdentityOutput struct {
	_ struct{} `type:"structure"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region.
	IsoCountryCode *string `min:"2" type:"string"`

	// The PhoneNumberId or SenderId of the origination identity.
	OriginationIdentity *string `type:"string"`

	// The PhoneNumberArn or SenderIdArn of the origination identity.
	OriginationIdentityArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the pool.
	PoolArn *string `type:"string"`

	// The PoolId of the pool no longer associated with the origination identity.
	PoolId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateOriginationIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateOriginationIdentityOutput) GoString() string {
	return s.String()
}

// SetIsoCountryCode sets the IsoCountryCode field's value.
func (s *DisassociateOriginationIdentityOutput) SetIsoCountryCode(v string) *DisassociateOriginationIdentityOutput {
	s.IsoCountryCode = &v
	return s
}

// SetOriginationIdentity sets the OriginationIdentity field's value.
func (s *DisassociateOriginationIdentityOutput) SetOriginationIdentity(v string) *DisassociateOriginationIdentityOutput {
	s.OriginationIdentity = &v
	return s
}

// SetOriginationIdentityArn sets the OriginationIdentityArn field's value.
func (s *DisassociateOriginationIdentityOutput) SetOriginationIdentityArn(v string) *DisassociateOriginationIdentityOutput {
	s.OriginationIdentityArn = &v
	return s
}

// SetPoolArn sets the PoolArn field's value.
func (s *DisassociateOriginationIdentityOutput) SetPoolArn(v string) *DisassociateOriginationIdentityOutput {
	s.PoolArn = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *DisassociateOriginationIdentityOutput) SetPoolId(v string) *DisassociateOriginationIdentityOutput {
	s.PoolId = &v
	return s
}

// Contains information about an event destination.
//
// Event destinations are associated with configuration sets, which enable you
// to publish message sending events to Amazon CloudWatch, Amazon Kinesis Data
// Firehose, or Amazon SNS.
type EventDestination struct {
	_ struct{} `type:"structure"`

	// An object that contains information about an event destination that sends
	// logging events to Amazon CloudWatch logs.
	CloudWatchLogsDestination *CloudWatchLogsDestination `type:"structure"`

	// When set to true events will be logged.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// The name of the EventDestination.
	//
	// EventDestinationName is a required field
	EventDestinationName *string `min:"1" type:"string" required:"true"`

	// An object that contains information about an event destination for logging
	// to Amazon Kinesis Data Firehose.
	KinesisFirehoseDestination *KinesisFirehoseDestination `type:"structure"`

	// An array of event types that determine which events to log.
	//
	// MatchingEventTypes is a required field
	MatchingEventTypes []*string `min:"1" type:"list" required:"true" enum:"EventType"`

	// An object that contains information about an event destination that sends
	// logging events to Amazon SNS.
	SnsDestination *SnsDestination `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventDestination) GoString() string {
	return s.String()
}

// SetCloudWatchLogsDestination sets the CloudWatchLogsDestination field's value.
func (s *EventDestination) SetCloudWatchLogsDestination(v *CloudWatchLogsDestination) *EventDestination {
	s.CloudWatchLogsDestination = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EventDestination) SetEnabled(v bool) *EventDestination {
	s.Enabled = &v
	return s
}

// SetEventDestinationName sets the EventDestinationName field's value.
func (s *EventDestination) SetEventDestinationName(v string) *EventDestination {
	s.EventDestinationName = &v
	return s
}

// SetKinesisFirehoseDestination sets the KinesisFirehoseDestination field's value.
func (s *EventDestination) SetKinesisFirehoseDestination(v *KinesisFirehoseDestination) *EventDestination {
	s.KinesisFirehoseDestination = v
	return s
}

// SetMatchingEventTypes sets the MatchingEventTypes field's value.
func (s *EventDestination) SetMatchingEventTypes(v []*string) *EventDestination {
	s.MatchingEventTypes = v
	return s
}

// SetSnsDestination sets the SnsDestination field's value.
func (s *EventDestination) SetSnsDestination(v *SnsDestination) *EventDestination {
	s.SnsDestination = v
	return s
}

// The API encountered an unexpected error and couldn't complete the request.
// You might be able to successfully issue the request again in the future.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The unique identifier of the request.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The information for keywords that meet a specified criteria.
type KeywordFilter struct {
	_ struct{} `type:"structure"`

	// The name of the attribute to filter on.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"KeywordFilterName"`

	// An array values to filter for.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeywordFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeywordFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeywordFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeywordFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *KeywordFilter) SetName(v string) *KeywordFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *KeywordFilter) SetValues(v []*string) *KeywordFilter {
	s.Values = v
	return s
}

// The information for all keywords in a pool.
type KeywordInformation struct {
	_ struct{} `type:"structure"`

	// The keyword as a string.
	//
	// Keyword is a required field
	Keyword *string `min:"1" type:"string" required:"true"`

	// The action to perform for the keyword.
	//
	// KeywordAction is a required field
	KeywordAction *string `type:"string" required:"true" enum:"KeywordAction"`

	// A custom message that can be used with the keyword.
	//
	// KeywordMessage is a required field
	KeywordMessage *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeywordInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeywordInformation) GoString() string {
	return s.String()
}

// SetKeyword sets the Keyword field's value.
func (s *KeywordInformation) SetKeyword(v string) *KeywordInformation {
	s.Keyword = &v
	return s
}

// SetKeywordAction sets the KeywordAction field's value.
func (s *KeywordInformation) SetKeywordAction(v string) *KeywordInformation {
	s.KeywordAction = &v
	return s
}

// SetKeywordMessage sets the KeywordMessage field's value.
func (s *KeywordInformation) SetKeywordMessage(v string) *KeywordInformation {
	s.KeywordMessage = &v
	return s
}

// Contains the delivery stream Amazon Resource Name (ARN), and the ARN of the
// Identity and Access Management (IAM) role associated with an Kinesis Data
// Firehose event destination.
//
// Event destinations, such as Kinesis Data Firehose, are associated with configuration
// sets, which enable you to publish message sending events.
type KinesisFirehoseDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the delivery stream.
	//
	// DeliveryStreamArn is a required field
	DeliveryStreamArn *string `min:"20" type:"string" required:"true"`

	// The ARN of an Amazon Identity and Access Management (IAM) role that is able
	// to write event data to an Amazon Firehose destination.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisFirehoseDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisFirehoseDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisFirehoseDestination"}
	if s.DeliveryStreamArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamArn"))
	}
	if s.DeliveryStreamArn != nil && len(*s.DeliveryStreamArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamArn", 20))
	}
	if s.IamRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRoleArn"))
	}
	if s.IamRoleArn != nil && len(*s.IamRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("IamRoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamArn sets the DeliveryStreamArn field's value.
func (s *KinesisFirehoseDestination) SetDeliveryStreamArn(v string) *KinesisFirehoseDestination {
	s.DeliveryStreamArn = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *KinesisFirehoseDestination) SetIamRoleArn(v string) *KinesisFirehoseDestination {
	s.IamRoleArn = &v
	return s
}

type ListPoolOriginationIdentitiesInput struct {
	_ struct{} `type:"structure"`

	// An array of PoolOriginationIdentitiesFilter objects to filter the results..
	Filters []*PoolOriginationIdentitiesFilter `type:"list"`

	// The maximum number of results to return per each request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to be used for the next set of paginated results. You don't need
	// to supply a value for this field in the initial request.
	NextToken *string `min:"1" type:"string"`

	// The unique identifier for the pool. This value can be either the PoolId or
	// PoolArn.
	//
	// PoolId is a required field
	PoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPoolOriginationIdentitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPoolOriginationIdentitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPoolOriginationIdentitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPoolOriginationIdentitiesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolId"))
	}
	if s.PoolId != nil && len(*s.PoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PoolId", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListPoolOriginationIdentitiesInput) SetFilters(v []*PoolOriginationIdentitiesFilter) *ListPoolOriginationIdentitiesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPoolOriginationIdentitiesInput) SetMaxResults(v int64) *ListPoolOriginationIdentitiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPoolOriginationIdentitiesInput) SetNextToken(v string) *ListPoolOriginationIdentitiesInput {
	s.NextToken = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *ListPoolOriginationIdentitiesInput) SetPoolId(v string) *ListPoolOriginationIdentitiesInput {
	s.PoolId = &v
	return s
}

type ListPoolOriginationIdentitiesOutput struct {
	_ struct{} `type:"structure"`

	// The token to be used for the next set of paginated results. If this field
	// is empty then there are no more results.
	NextToken *string `min:"1" type:"string"`

	// An array of any OriginationIdentityMetadata objects.
	OriginationIdentities []*OriginationIdentityMetadata `type:"list"`

	// The Amazon Resource Name (ARN) for the pool.
	PoolArn *string `type:"string"`

	// The unique PoolId of the pool.
	PoolId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPoolOriginationIdentitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPoolOriginationIdentitiesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPoolOriginationIdentitiesOutput) SetNextToken(v string) *ListPoolOriginationIdentitiesOutput {
	s.NextToken = &v
	return s
}

// SetOriginationIdentities sets the OriginationIdentities field's value.
func (s *ListPoolOriginationIdentitiesOutput) SetOriginationIdentities(v []*OriginationIdentityMetadata) *ListPoolOriginationIdentitiesOutput {
	s.OriginationIdentities = v
	return s
}

// SetPoolArn sets the PoolArn field's value.
func (s *ListPoolOriginationIdentitiesOutput) SetPoolArn(v string) *ListPoolOriginationIdentitiesOutput {
	s.PoolArn = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *ListPoolOriginationIdentitiesOutput) SetPoolId(v string) *ListPoolOriginationIdentitiesOutput {
	s.PoolId = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to query for.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	ResourceArn *string `min:"20" type:"string"`

	// An array of key and value pair tags that are associated with the resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceOutput) SetResourceArn(v string) *ListTagsForResourceOutput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The information for all OptOutList in an Amazon Web Services account.
type OptOutListInformation struct {
	_ struct{} `type:"structure"`

	// The time when the OutOutList was created, in UNIX epoch time (https://www.epochconverter.com/)
	// format.
	//
	// CreatedTimestamp is a required field
	CreatedTimestamp *time.Time `type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the OptOutList.
	//
	// OptOutListArn is a required field
	OptOutListArn *string `type:"string" required:"true"`

	// The name of the OptOutList.
	//
	// OptOutListName is a required field
	OptOutListName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OptOutListInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OptOutListInformation) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *OptOutListInformation) SetCreatedTimestamp(v time.Time) *OptOutListInformation {
	s.CreatedTimestamp = &v
	return s
}

// SetOptOutListArn sets the OptOutListArn field's value.
func (s *OptOutListInformation) SetOptOutListArn(v string) *OptOutListInformation {
	s.OptOutListArn = &v
	return s
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *OptOutListInformation) SetOptOutListName(v string) *OptOutListInformation {
	s.OptOutListName = &v
	return s
}

// The information for opted out numbers that meet a specified criteria.
type OptedOutFilter struct {
	_ struct{} `type:"structure"`

	// The name of the attribute to filter on.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"OptedOutFilterName"`

	// An array of values to filter for.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OptedOutFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OptedOutFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OptedOutFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OptedOutFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *OptedOutFilter) SetName(v string) *OptedOutFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *OptedOutFilter) SetValues(v []*string) *OptedOutFilter {
	s.Values = v
	return s
}

// The information for an opted out number in an Amazon Web Services account.
type OptedOutNumberInformation struct {
	_ struct{} `type:"structure"`

	// This is set to true if it was the end recipient that opted out.
	//
	// EndUserOptedOut is a required field
	EndUserOptedOut *bool `type:"boolean" required:"true"`

	// The phone number that is opted out.
	//
	// OptedOutNumber is a required field
	OptedOutNumber *string `min:"1" type:"string" required:"true"`

	// The time that the op tout occurred, in UNIX epoch time (https://www.epochconverter.com/)
	// format.
	//
	// OptedOutTimestamp is a required field
	OptedOutTimestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OptedOutNumberInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OptedOutNumberInformation) GoString() string {
	return s.String()
}

// SetEndUserOptedOut sets the EndUserOptedOut field's value.
func (s *OptedOutNumberInformation) SetEndUserOptedOut(v bool) *OptedOutNumberInformation {
	s.EndUserOptedOut = &v
	return s
}

// SetOptedOutNumber sets the OptedOutNumber field's value.
func (s *OptedOutNumberInformation) SetOptedOutNumber(v string) *OptedOutNumberInformation {
	s.OptedOutNumber = &v
	return s
}

// SetOptedOutTimestamp sets the OptedOutTimestamp field's value.
func (s *OptedOutNumberInformation) SetOptedOutTimestamp(v time.Time) *OptedOutNumberInformation {
	s.OptedOutTimestamp = &v
	return s
}

// The metadata for an origination identity associated with a pool.
type OriginationIdentityMetadata struct {
	_ struct{} `type:"structure"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region.
	//
	// IsoCountryCode is a required field
	IsoCountryCode *string `min:"2" type:"string" required:"true"`

	// Describes if the origination identity can be used for text messages, voice
	// calls or both.
	//
	// NumberCapabilities is a required field
	NumberCapabilities []*string `min:"1" type:"list" required:"true" enum:"NumberCapability"`

	// The unique identifier of the origination identity.
	//
	// OriginationIdentity is a required field
	OriginationIdentity *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) associated with the origination identity.
	//
	// OriginationIdentityArn is a required field
	OriginationIdentityArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OriginationIdentityMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OriginationIdentityMetadata) GoString() string {
	return s.String()
}

// SetIsoCountryCode sets the IsoCountryCode field's value.
func (s *OriginationIdentityMetadata) SetIsoCountryCode(v string) *OriginationIdentityMetadata {
	s.IsoCountryCode = &v
	return s
}

// SetNumberCapabilities sets the NumberCapabilities field's value.
func (s *OriginationIdentityMetadata) SetNumberCapabilities(v []*string) *OriginationIdentityMetadata {
	s.NumberCapabilities = v
	return s
}

// SetOriginationIdentity sets the OriginationIdentity field's value.
func (s *OriginationIdentityMetadata) SetOriginationIdentity(v string) *OriginationIdentityMetadata {
	s.OriginationIdentity = &v
	return s
}

// SetOriginationIdentityArn sets the OriginationIdentityArn field's value.
func (s *OriginationIdentityMetadata) SetOriginationIdentityArn(v string) *OriginationIdentityMetadata {
	s.OriginationIdentityArn = &v
	return s
}

// The information for a phone number that meets a specified criteria.
type PhoneNumberFilter struct {
	_ struct{} `type:"structure"`

	// The name of the attribute to filter on.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"PhoneNumberFilterName"`

	// An array values to filter for.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumberFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumberFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PhoneNumberFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PhoneNumberFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *PhoneNumberFilter) SetName(v string) *PhoneNumberFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *PhoneNumberFilter) SetValues(v []*string) *PhoneNumberFilter {
	s.Values = v
	return s
}

// The information for a phone number in an Amazon Web Services account.
type PhoneNumberInformation struct {
	_ struct{} `type:"structure"`

	// The time when the phone number was created, in UNIX epoch time (https://www.epochconverter.com/)
	// format.
	//
	// CreatedTimestamp is a required field
	CreatedTimestamp *time.Time `type:"timestamp" required:"true"`

	// When set to true the phone number can't be deleted.
	//
	// DeletionProtectionEnabled is a required field
	DeletionProtectionEnabled *bool `type:"boolean" required:"true"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region.
	//
	// IsoCountryCode is a required field
	IsoCountryCode *string `min:"2" type:"string" required:"true"`

	// The type of message. Valid values are TRANSACTIONAL for messages that are
	// critical or time-sensitive and PROMOTIONAL for messages that aren't critical
	// or time-sensitive.
	//
	// MessageType is a required field
	MessageType *string `type:"string" required:"true" enum:"MessageType"`

	// The price, in US dollars, to lease the phone number.
	//
	// MonthlyLeasingPrice is a required field
	MonthlyLeasingPrice *string `type:"string" required:"true"`

	// Describes if the origination identity can be used for text messages, voice
	// calls or both.
	//
	// NumberCapabilities is a required field
	NumberCapabilities []*string `min:"1" type:"list" required:"true" enum:"NumberCapability"`

	// The type of phone number.
	//
	// NumberType is a required field
	NumberType *string `type:"string" required:"true" enum:"NumberType"`

	// The name of the OptOutList associated with the phone number.
	//
	// OptOutListName is a required field
	OptOutListName *string `min:"1" type:"string" required:"true"`

	// The phone number in E.164 format.
	//
	// PhoneNumber is a required field
	PhoneNumber *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) associated with the phone number.
	//
	// PhoneNumberArn is a required field
	PhoneNumberArn *string `type:"string" required:"true"`

	// The unique identifier for the phone number.
	PhoneNumberId *string `type:"string"`

	// The unique identifier of the pool associated with the phone number.
	PoolId *string `type:"string"`

	// When set to false an end recipient sends a message that begins with HELP
	// or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies
	// with a customizable message and adds the end recipient to the OptOutList.
	// When set to true you're responsible for responding to HELP and STOP requests.
	// You're also responsible for tracking and honoring opt-out request. For more
	// information see Self-managed opt-outs (https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out)
	//
	// SelfManagedOptOutsEnabled is a required field
	SelfManagedOptOutsEnabled *bool `type:"boolean" required:"true"`

	// The current status of the phone number.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"NumberStatus"`

	// The Amazon Resource Name (ARN) of the two way channel.
	TwoWayChannelArn *string `min:"20" type:"string"`

	// By default this is set to false. When set to true you can receive incoming
	// text messages from your end recipients using the TwoWayChannelArn.
	//
	// TwoWayEnabled is a required field
	TwoWayEnabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumberInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumberInformation) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *PhoneNumberInformation) SetCreatedTimestamp(v time.Time) *PhoneNumberInformation {
	s.CreatedTimestamp = &v
	return s
}

// SetDeletionProtectionEnabled sets the DeletionProtectionEnabled field's value.
func (s *PhoneNumberInformation) SetDeletionProtectionEnabled(v bool) *PhoneNumberInformation {
	s.DeletionProtectionEnabled = &v
	return s
}

// SetIsoCountryCode sets the IsoCountryCode field's value.
func (s *PhoneNumberInformation) SetIsoCountryCode(v string) *PhoneNumberInformation {
	s.IsoCountryCode = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *PhoneNumberInformation) SetMessageType(v string) *PhoneNumberInformation {
	s.MessageType = &v
	return s
}

// SetMonthlyLeasingPrice sets the MonthlyLeasingPrice field's value.
func (s *PhoneNumberInformation) SetMonthlyLeasingPrice(v string) *PhoneNumberInformation {
	s.MonthlyLeasingPrice = &v
	return s
}

// SetNumberCapabilities sets the NumberCapabilities field's value.
func (s *PhoneNumberInformation) SetNumberCapabilities(v []*string) *PhoneNumberInformation {
	s.NumberCapabilities = v
	return s
}

// SetNumberType sets the NumberType field's value.
func (s *PhoneNumberInformation) SetNumberType(v string) *PhoneNumberInformation {
	s.NumberType = &v
	return s
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *PhoneNumberInformation) SetOptOutListName(v string) *PhoneNumberInformation {
	s.OptOutListName = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *PhoneNumberInformation) SetPhoneNumber(v string) *PhoneNumberInformation {
	s.PhoneNumber = &v
	return s
}

// SetPhoneNumberArn sets the PhoneNumberArn field's value.
func (s *PhoneNumberInformation) SetPhoneNumberArn(v string) *PhoneNumberInformation {
	s.PhoneNumberArn = &v
	return s
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *PhoneNumberInformation) SetPhoneNumberId(v string) *PhoneNumberInformation {
	s.PhoneNumberId = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *PhoneNumberInformation) SetPoolId(v string) *PhoneNumberInformation {
	s.PoolId = &v
	return s
}

// SetSelfManagedOptOutsEnabled sets the SelfManagedOptOutsEnabled field's value.
func (s *PhoneNumberInformation) SetSelfManagedOptOutsEnabled(v bool) *PhoneNumberInformation {
	s.SelfManagedOptOutsEnabled = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PhoneNumberInformation) SetStatus(v string) *PhoneNumberInformation {
	s.Status = &v
	return s
}

// SetTwoWayChannelArn sets the TwoWayChannelArn field's value.
func (s *PhoneNumberInformation) SetTwoWayChannelArn(v string) *PhoneNumberInformation {
	s.TwoWayChannelArn = &v
	return s
}

// SetTwoWayEnabled sets the TwoWayEnabled field's value.
func (s *PhoneNumberInformation) SetTwoWayEnabled(v bool) *PhoneNumberInformation {
	s.TwoWayEnabled = &v
	return s
}

// The information for a pool that meets a specified criteria.
type PoolFilter struct {
	_ struct{} `type:"structure"`

	// The name of the attribute to filter on.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"PoolFilterName"`

	// An array values to filter for.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PoolFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PoolFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PoolFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PoolFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *PoolFilter) SetName(v string) *PoolFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *PoolFilter) SetValues(v []*string) *PoolFilter {
	s.Values = v
	return s
}

// The information for a pool in an Amazon Web Services account.
type PoolInformation struct {
	_ struct{} `type:"structure"`

	// The time when the pool was created, in UNIX epoch time (https://www.epochconverter.com/)
	// format.
	//
	// CreatedTimestamp is a required field
	CreatedTimestamp *time.Time `type:"timestamp" required:"true"`

	// When set to true the pool can't be deleted.
	//
	// DeletionProtectionEnabled is a required field
	DeletionProtectionEnabled *bool `type:"boolean" required:"true"`

	// The type of message. Valid values are TRANSACTIONAL for messages that are
	// critical or time-sensitive and PROMOTIONAL for messages that aren't critical
	// or time-sensitive.
	//
	// MessageType is a required field
	MessageType *string `type:"string" required:"true" enum:"MessageType"`

	// The name of the OptOutList associated with the pool.
	//
	// OptOutListName is a required field
	OptOutListName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for the pool.
	//
	// PoolArn is a required field
	PoolArn *string `type:"string" required:"true"`

	// The unique identifier for the pool.
	//
	// PoolId is a required field
	PoolId *string `type:"string" required:"true"`

	// When set to false, an end recipient sends a message that begins with HELP
	// or STOP to one of your dedicated numbers, Amazon Pinpoint automatically replies
	// with a customizable message and adds the end recipient to the OptOutList.
	// When set to true you're responsible for responding to HELP and STOP requests.
	// You're also responsible for tracking and honoring opt-out requests. For more
	// information see Self-managed opt-outs (https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out)
	//
	// SelfManagedOptOutsEnabled is a required field
	SelfManagedOptOutsEnabled *bool `type:"boolean" required:"true"`

	// Allows you to enable shared routes on your pool.
	//
	// By default, this is set to False. If you set this value to True, your messages
	// are sent using phone numbers or sender IDs (depending on the country) that
	// are shared with other Amazon Pinpoint users. In some countries, such as the
	// United States, senders aren't allowed to use shared routes and must use a
	// dedicated phone number or short code.
	//
	// SharedRoutesEnabled is a required field
	SharedRoutesEnabled *bool `type:"boolean" required:"true"`

	// The current status of the pool.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"PoolStatus"`

	// The Amazon Resource Name (ARN) of the two way channel.
	TwoWayChannelArn *string `min:"20" type:"string"`

	// When set to true you can receive incoming text messages from your end recipients
	// using the TwoWayChannelArn.
	//
	// TwoWayEnabled is a required field
	TwoWayEnabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PoolInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PoolInformation) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *PoolInformation) SetCreatedTimestamp(v time.Time) *PoolInformation {
	s.CreatedTimestamp = &v
	return s
}

// SetDeletionProtectionEnabled sets the DeletionProtectionEnabled field's value.
func (s *PoolInformation) SetDeletionProtectionEnabled(v bool) *PoolInformation {
	s.DeletionProtectionEnabled = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *PoolInformation) SetMessageType(v string) *PoolInformation {
	s.MessageType = &v
	return s
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *PoolInformation) SetOptOutListName(v string) *PoolInformation {
	s.OptOutListName = &v
	return s
}

// SetPoolArn sets the PoolArn field's value.
func (s *PoolInformation) SetPoolArn(v string) *PoolInformation {
	s.PoolArn = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *PoolInformation) SetPoolId(v string) *PoolInformation {
	s.PoolId = &v
	return s
}

// SetSelfManagedOptOutsEnabled sets the SelfManagedOptOutsEnabled field's value.
func (s *PoolInformation) SetSelfManagedOptOutsEnabled(v bool) *PoolInformation {
	s.SelfManagedOptOutsEnabled = &v
	return s
}

// SetSharedRoutesEnabled sets the SharedRoutesEnabled field's value.
func (s *PoolInformation) SetSharedRoutesEnabled(v bool) *PoolInformation {
	s.SharedRoutesEnabled = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PoolInformation) SetStatus(v string) *PoolInformation {
	s.Status = &v
	return s
}

// SetTwoWayChannelArn sets the TwoWayChannelArn field's value.
func (s *PoolInformation) SetTwoWayChannelArn(v string) *PoolInformation {
	s.TwoWayChannelArn = &v
	return s
}

// SetTwoWayEnabled sets the TwoWayEnabled field's value.
func (s *PoolInformation) SetTwoWayEnabled(v bool) *PoolInformation {
	s.TwoWayEnabled = &v
	return s
}

// Information about origination identities associated with a pool that meets
// a specified criteria.
type PoolOriginationIdentitiesFilter struct {
	_ struct{} `type:"structure"`

	// The name of the attribute to filter on.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"PoolOriginationIdentitiesFilterName"`

	// An array values to filter for.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PoolOriginationIdentitiesFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PoolOriginationIdentitiesFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PoolOriginationIdentitiesFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PoolOriginationIdentitiesFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *PoolOriginationIdentitiesFilter) SetName(v string) *PoolOriginationIdentitiesFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *PoolOriginationIdentitiesFilter) SetValues(v []*string) *PoolOriginationIdentitiesFilter {
	s.Values = v
	return s
}

type PutKeywordInput struct {
	_ struct{} `type:"structure"`

	// The new keyword to add.
	//
	// Keyword is a required field
	Keyword *string `min:"1" type:"string" required:"true"`

	// The action to perform for the new keyword when it is received.
	KeywordAction *string `type:"string" enum:"KeywordAction"`

	// The message associated with the keyword.
	//
	//    * AUTOMATIC_RESPONSE: A message is sent to the recipient.
	//
	//    * OPT_OUT: Keeps the recipient from receiving future messages.
	//
	//    * OPT_IN: The recipient wants to receive future messages.
	//
	// KeywordMessage is a required field
	KeywordMessage *string `min:"1" type:"string" required:"true"`

	// The origination identity to use such as a PhoneNumberId, PhoneNumberArn,
	// SenderId or SenderIdArn. You can use DescribePhoneNumbers get the values
	// for PhoneNumberId and PhoneNumberArn while DescribeSenderIds can be used
	// to get the values for SenderId and SenderIdArn.
	//
	// OriginationIdentity is a required field
	OriginationIdentity *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutKeywordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutKeywordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutKeywordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutKeywordInput"}
	if s.Keyword == nil {
		invalidParams.Add(request.NewErrParamRequired("Keyword"))
	}
	if s.Keyword != nil && len(*s.Keyword) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Keyword", 1))
	}
	if s.KeywordMessage == nil {
		invalidParams.Add(request.NewErrParamRequired("KeywordMessage"))
	}
	if s.KeywordMessage != nil && len(*s.KeywordMessage) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeywordMessage", 1))
	}
	if s.OriginationIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginationIdentity"))
	}
	if s.OriginationIdentity != nil && len(*s.OriginationIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OriginationIdentity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyword sets the Keyword field's value.
func (s *PutKeywordInput) SetKeyword(v string) *PutKeywordInput {
	s.Keyword = &v
	return s
}

// SetKeywordAction sets the KeywordAction field's value.
func (s *PutKeywordInput) SetKeywordAction(v string) *PutKeywordInput {
	s.KeywordAction = &v
	return s
}

// SetKeywordMessage sets the KeywordMessage field's value.
func (s *PutKeywordInput) SetKeywordMessage(v string) *PutKeywordInput {
	s.KeywordMessage = &v
	return s
}

// SetOriginationIdentity sets the OriginationIdentity field's value.
func (s *PutKeywordInput) SetOriginationIdentity(v string) *PutKeywordInput {
	s.OriginationIdentity = &v
	return s
}

type PutKeywordOutput struct {
	_ struct{} `type:"structure"`

	// The keyword that was added.
	Keyword *string `min:"1" type:"string"`

	// The action to perform when the keyword is used.
	KeywordAction *string `type:"string" enum:"KeywordAction"`

	// The message associated with the keyword.
	KeywordMessage *string `min:"1" type:"string"`

	// The PhoneNumberId or PoolId that the keyword was associated with.
	OriginationIdentity *string `type:"string"`

	// The PhoneNumberArn or PoolArn that the keyword was associated with.
	OriginationIdentityArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutKeywordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutKeywordOutput) GoString() string {
	return s.String()
}

// SetKeyword sets the Keyword field's value.
func (s *PutKeywordOutput) SetKeyword(v string) *PutKeywordOutput {
	s.Keyword = &v
	return s
}

// SetKeywordAction sets the KeywordAction field's value.
func (s *PutKeywordOutput) SetKeywordAction(v string) *PutKeywordOutput {
	s.KeywordAction = &v
	return s
}

// SetKeywordMessage sets the KeywordMessage field's value.
func (s *PutKeywordOutput) SetKeywordMessage(v string) *PutKeywordOutput {
	s.KeywordMessage = &v
	return s
}

// SetOriginationIdentity sets the OriginationIdentity field's value.
func (s *PutKeywordOutput) SetOriginationIdentity(v string) *PutKeywordOutput {
	s.OriginationIdentity = &v
	return s
}

// SetOriginationIdentityArn sets the OriginationIdentityArn field's value.
func (s *PutKeywordOutput) SetOriginationIdentityArn(v string) *PutKeywordOutput {
	s.OriginationIdentityArn = &v
	return s
}

type PutOptedOutNumberInput struct {
	_ struct{} `type:"structure"`

	// The OptOutListName or OptOutListArn to add the phone number to.
	//
	// OptOutListName is a required field
	OptOutListName *string `min:"1" type:"string" required:"true"`

	// The phone number to add to the OptOutList in E.164 format.
	//
	// OptedOutNumber is a required field
	OptedOutNumber *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutOptedOutNumberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutOptedOutNumberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutOptedOutNumberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutOptedOutNumberInput"}
	if s.OptOutListName == nil {
		invalidParams.Add(request.NewErrParamRequired("OptOutListName"))
	}
	if s.OptOutListName != nil && len(*s.OptOutListName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OptOutListName", 1))
	}
	if s.OptedOutNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("OptedOutNumber"))
	}
	if s.OptedOutNumber != nil && len(*s.OptedOutNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OptedOutNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *PutOptedOutNumberInput) SetOptOutListName(v string) *PutOptedOutNumberInput {
	s.OptOutListName = &v
	return s
}

// SetOptedOutNumber sets the OptedOutNumber field's value.
func (s *PutOptedOutNumberInput) SetOptedOutNumber(v string) *PutOptedOutNumberInput {
	s.OptedOutNumber = &v
	return s
}

type PutOptedOutNumberOutput struct {
	_ struct{} `type:"structure"`

	// This is true if it was the end user who requested their phone number be removed.
	EndUserOptedOut *bool `type:"boolean"`

	// The OptOutListArn that the phone number was removed from.
	OptOutListArn *string `type:"string"`

	// The OptOutListName that the phone number was removed from.
	OptOutListName *string `min:"1" type:"string"`

	// The phone number that was added to the OptOutList.
	OptedOutNumber *string `min:"1" type:"string"`

	// The time that the phone number was added to the OptOutList, in UNIX epoch
	// time (https://www.epochconverter.com/) format.
	OptedOutTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutOptedOutNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutOptedOutNumberOutput) GoString() string {
	return s.String()
}

// SetEndUserOptedOut sets the EndUserOptedOut field's value.
func (s *PutOptedOutNumberOutput) SetEndUserOptedOut(v bool) *PutOptedOutNumberOutput {
	s.EndUserOptedOut = &v
	return s
}

// SetOptOutListArn sets the OptOutListArn field's value.
func (s *PutOptedOutNumberOutput) SetOptOutListArn(v string) *PutOptedOutNumberOutput {
	s.OptOutListArn = &v
	return s
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *PutOptedOutNumberOutput) SetOptOutListName(v string) *PutOptedOutNumberOutput {
	s.OptOutListName = &v
	return s
}

// SetOptedOutNumber sets the OptedOutNumber field's value.
func (s *PutOptedOutNumberOutput) SetOptedOutNumber(v string) *PutOptedOutNumberOutput {
	s.OptedOutNumber = &v
	return s
}

// SetOptedOutTimestamp sets the OptedOutTimestamp field's value.
func (s *PutOptedOutNumberOutput) SetOptedOutTimestamp(v time.Time) *PutOptedOutNumberOutput {
	s.OptedOutTimestamp = &v
	return s
}

type ReleasePhoneNumberInput struct {
	_ struct{} `type:"structure"`

	// The PhoneNumberId or PhoneNumberArn of the phone number to release. You can
	// use DescribePhoneNumbers to get the values for PhoneNumberId and PhoneNumberArn.
	//
	// PhoneNumberId is a required field
	PhoneNumberId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReleasePhoneNumberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReleasePhoneNumberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReleasePhoneNumberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReleasePhoneNumberInput"}
	if s.PhoneNumberId == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumberId"))
	}
	if s.PhoneNumberId != nil && len(*s.PhoneNumberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumberId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *ReleasePhoneNumberInput) SetPhoneNumberId(v string) *ReleasePhoneNumberInput {
	s.PhoneNumberId = &v
	return s
}

type ReleasePhoneNumberOutput struct {
	_ struct{} `type:"structure"`

	// The time when the phone number was created, in UNIX epoch time (https://www.epochconverter.com/)
	// format.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region.
	IsoCountryCode *string `min:"2" type:"string"`

	// The message type that was associated with the phone number.
	MessageType *string `type:"string" enum:"MessageType"`

	// The monthly price of the phone number, in US dollars.
	MonthlyLeasingPrice *string `type:"string"`

	// Specifies if the number could be used for text messages, voice, or both.
	NumberCapabilities []*string `min:"1" type:"list" enum:"NumberCapability"`

	// The type of number that was released.
	NumberType *string `type:"string" enum:"NumberType"`

	// The name of the OptOutList that was associated with the phone number.
	OptOutListName *string `min:"1" type:"string"`

	// The phone number that was released.
	PhoneNumber *string `min:"1" type:"string"`

	// The PhoneNumberArn of the phone number that was released.
	PhoneNumberArn *string `type:"string"`

	// The PhoneNumberId of the phone number that was released.
	PhoneNumberId *string `type:"string"`

	// By default this is set to false. When an end recipient sends a message that
	// begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint
	// automatically replies with a customizable message and adds the end recipient
	// to the OptOutList. When set to true you're responsible for responding to
	// HELP and STOP requests. You're also responsible for tracking and honoring
	// opt-out requests.
	SelfManagedOptOutsEnabled *bool `type:"boolean"`

	// The current status of the request.
	Status *string `type:"string" enum:"NumberStatus"`

	// The Amazon Resource Name (ARN) of the TwoWayChannel.
	TwoWayChannelArn *string `min:"20" type:"string"`

	// By default this is set to false. When set to true you can receive incoming
	// text messages from your end recipients.
	TwoWayEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReleasePhoneNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReleasePhoneNumberOutput) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *ReleasePhoneNumberOutput) SetCreatedTimestamp(v time.Time) *ReleasePhoneNumberOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetIsoCountryCode sets the IsoCountryCode field's value.
func (s *ReleasePhoneNumberOutput) SetIsoCountryCode(v string) *ReleasePhoneNumberOutput {
	s.IsoCountryCode = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *ReleasePhoneNumberOutput) SetMessageType(v string) *ReleasePhoneNumberOutput {
	s.MessageType = &v
	return s
}

// SetMonthlyLeasingPrice sets the MonthlyLeasingPrice field's value.
func (s *ReleasePhoneNumberOutput) SetMonthlyLeasingPrice(v string) *ReleasePhoneNumberOutput {
	s.MonthlyLeasingPrice = &v
	return s
}

// SetNumberCapabilities sets the NumberCapabilities field's value.
func (s *ReleasePhoneNumberOutput) SetNumberCapabilities(v []*string) *ReleasePhoneNumberOutput {
	s.NumberCapabilities = v
	return s
}

// SetNumberType sets the NumberType field's value.
func (s *ReleasePhoneNumberOutput) SetNumberType(v string) *ReleasePhoneNumberOutput {
	s.NumberType = &v
	return s
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *ReleasePhoneNumberOutput) SetOptOutListName(v string) *ReleasePhoneNumberOutput {
	s.OptOutListName = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *ReleasePhoneNumberOutput) SetPhoneNumber(v string) *ReleasePhoneNumberOutput {
	s.PhoneNumber = &v
	return s
}

// SetPhoneNumberArn sets the PhoneNumberArn field's value.
func (s *ReleasePhoneNumberOutput) SetPhoneNumberArn(v string) *ReleasePhoneNumberOutput {
	s.PhoneNumberArn = &v
	return s
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *ReleasePhoneNumberOutput) SetPhoneNumberId(v string) *ReleasePhoneNumberOutput {
	s.PhoneNumberId = &v
	return s
}

// SetSelfManagedOptOutsEnabled sets the SelfManagedOptOutsEnabled field's value.
func (s *ReleasePhoneNumberOutput) SetSelfManagedOptOutsEnabled(v bool) *ReleasePhoneNumberOutput {
	s.SelfManagedOptOutsEnabled = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReleasePhoneNumberOutput) SetStatus(v string) *ReleasePhoneNumberOutput {
	s.Status = &v
	return s
}

// SetTwoWayChannelArn sets the TwoWayChannelArn field's value.
func (s *ReleasePhoneNumberOutput) SetTwoWayChannelArn(v string) *ReleasePhoneNumberOutput {
	s.TwoWayChannelArn = &v
	return s
}

// SetTwoWayEnabled sets the TwoWayEnabled field's value.
func (s *ReleasePhoneNumberOutput) SetTwoWayEnabled(v bool) *ReleasePhoneNumberOutput {
	s.TwoWayEnabled = &v
	return s
}

type RequestPhoneNumberInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don't specify a client token, a randomly generated
	// token is used for the request to ensure idempotency.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// By default this is set to false. When set to true the phone number can't
	// be deleted.
	DeletionProtectionEnabled *bool `type:"boolean"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region.
	//
	// IsoCountryCode is a required field
	IsoCountryCode *string `min:"2" type:"string" required:"true"`

	// The type of message. Valid values are TRANSACTIONAL for messages that are
	// critical or time-sensitive and PROMOTIONAL for messages that aren't critical
	// or time-sensitive.
	//
	// MessageType is a required field
	MessageType *string `type:"string" required:"true" enum:"MessageType"`

	// Indicates if the phone number will be used for text messages, voice messages,
	// or both.
	//
	// NumberCapabilities is a required field
	NumberCapabilities []*string `min:"1" type:"list" required:"true" enum:"NumberCapability"`

	// The type of phone number to request.
	//
	// NumberType is a required field
	NumberType *string `type:"string" required:"true" enum:"RequestableNumberType"`

	// The name of the OptOutList to associate with the phone number. You can use
	// the OutOutListName or OptPutListArn.
	OptOutListName *string `min:"1" type:"string"`

	// The pool to associated with the phone number. You can use the PoolId or PoolArn.
	PoolId *string `min:"1" type:"string"`

	// Use this field to attach your phone number for an external registration process.
	RegistrationId *string `min:"1" type:"string"`

	// An array of tags (key and value pairs) associate with the requested phone
	// number.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestPhoneNumberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestPhoneNumberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestPhoneNumberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RequestPhoneNumberInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.IsoCountryCode == nil {
		invalidParams.Add(request.NewErrParamRequired("IsoCountryCode"))
	}
	if s.IsoCountryCode != nil && len(*s.IsoCountryCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("IsoCountryCode", 2))
	}
	if s.MessageType == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageType"))
	}
	if s.NumberCapabilities == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberCapabilities"))
	}
	if s.NumberCapabilities != nil && len(s.NumberCapabilities) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NumberCapabilities", 1))
	}
	if s.NumberType == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberType"))
	}
	if s.OptOutListName != nil && len(*s.OptOutListName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OptOutListName", 1))
	}
	if s.PoolId != nil && len(*s.PoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PoolId", 1))
	}
	if s.RegistrationId != nil && len(*s.RegistrationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistrationId", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *RequestPhoneNumberInput) SetClientToken(v string) *RequestPhoneNumberInput {
	s.ClientToken = &v
	return s
}

// SetDeletionProtectionEnabled sets the DeletionProtectionEnabled field's value.
func (s *RequestPhoneNumberInput) SetDeletionProtectionEnabled(v bool) *RequestPhoneNumberInput {
	s.DeletionProtectionEnabled = &v
	return s
}

// SetIsoCountryCode sets the IsoCountryCode field's value.
func (s *RequestPhoneNumberInput) SetIsoCountryCode(v string) *RequestPhoneNumberInput {
	s.IsoCountryCode = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *RequestPhoneNumberInput) SetMessageType(v string) *RequestPhoneNumberInput {
	s.MessageType = &v
	return s
}

// SetNumberCapabilities sets the NumberCapabilities field's value.
func (s *RequestPhoneNumberInput) SetNumberCapabilities(v []*string) *RequestPhoneNumberInput {
	s.NumberCapabilities = v
	return s
}

// SetNumberType sets the NumberType field's value.
func (s *RequestPhoneNumberInput) SetNumberType(v string) *RequestPhoneNumberInput {
	s.NumberType = &v
	return s
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *RequestPhoneNumberInput) SetOptOutListName(v string) *RequestPhoneNumberInput {
	s.OptOutListName = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *RequestPhoneNumberInput) SetPoolId(v string) *RequestPhoneNumberInput {
	s.PoolId = &v
	return s
}

// SetRegistrationId sets the RegistrationId field's value.
func (s *RequestPhoneNumberInput) SetRegistrationId(v string) *RequestPhoneNumberInput {
	s.RegistrationId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RequestPhoneNumberInput) SetTags(v []*Tag) *RequestPhoneNumberInput {
	s.Tags = v
	return s
}

type RequestPhoneNumberOutput struct {
	_ struct{} `type:"structure"`

	// The time when the phone number was created, in UNIX epoch time (https://www.epochconverter.com/)
	// format.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// By default this is set to false. When set to true the phone number can't
	// be deleted.
	DeletionProtectionEnabled *bool `type:"boolean"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region.
	IsoCountryCode *string `min:"2" type:"string"`

	// The type of message. Valid values are TRANSACTIONAL for messages that are
	// critical or time-sensitive and PROMOTIONAL for messages that aren't critical
	// or time-sensitive.
	MessageType *string `type:"string" enum:"MessageType"`

	// The monthly price, in US dollars, to lease the phone number.
	MonthlyLeasingPrice *string `type:"string"`

	// Indicates if the phone number will be used for text messages, voice messages
	// or both.
	NumberCapabilities []*string `min:"1" type:"list" enum:"NumberCapability"`

	// The type of number that was released.
	NumberType *string `type:"string" enum:"RequestableNumberType"`

	// The name of the OptOutList that is associated with the requested phone number.
	OptOutListName *string `min:"1" type:"string"`

	// The new phone number that was requested.
	PhoneNumber *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the requested phone number.
	PhoneNumberArn *string `type:"string"`

	// The unique identifier of the new phone number.
	PhoneNumberId *string `type:"string"`

	// The unique identifier of the pool associated with the phone number
	PoolId *string `type:"string"`

	// By default this is set to false. When an end recipient sends a message that
	// begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint
	// automatically replies with a customizable message and adds the end recipient
	// to the OptOutList. When set to true you're responsible for responding to
	// HELP and STOP requests. You're also responsible for tracking and honoring
	// opt-out requests.
	SelfManagedOptOutsEnabled *bool `type:"boolean"`

	// The current status of the request.
	Status *string `type:"string" enum:"NumberStatus"`

	// An array of key and value pair tags that are associated with the phone number.
	Tags []*Tag `type:"list"`

	// The ARN used to identify the two way channel.
	TwoWayChannelArn *string `min:"20" type:"string"`

	// By default this is set to false. When set to true you can receive incoming
	// text messages from your end recipients.
	TwoWayEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestPhoneNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestPhoneNumberOutput) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *RequestPhoneNumberOutput) SetCreatedTimestamp(v time.Time) *RequestPhoneNumberOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDeletionProtectionEnabled sets the DeletionProtectionEnabled field's value.
func (s *RequestPhoneNumberOutput) SetDeletionProtectionEnabled(v bool) *RequestPhoneNumberOutput {
	s.DeletionProtectionEnabled = &v
	return s
}

// SetIsoCountryCode sets the IsoCountryCode field's value.
func (s *RequestPhoneNumberOutput) SetIsoCountryCode(v string) *RequestPhoneNumberOutput {
	s.IsoCountryCode = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *RequestPhoneNumberOutput) SetMessageType(v string) *RequestPhoneNumberOutput {
	s.MessageType = &v
	return s
}

// SetMonthlyLeasingPrice sets the MonthlyLeasingPrice field's value.
func (s *RequestPhoneNumberOutput) SetMonthlyLeasingPrice(v string) *RequestPhoneNumberOutput {
	s.MonthlyLeasingPrice = &v
	return s
}

// SetNumberCapabilities sets the NumberCapabilities field's value.
func (s *RequestPhoneNumberOutput) SetNumberCapabilities(v []*string) *RequestPhoneNumberOutput {
	s.NumberCapabilities = v
	return s
}

// SetNumberType sets the NumberType field's value.
func (s *RequestPhoneNumberOutput) SetNumberType(v string) *RequestPhoneNumberOutput {
	s.NumberType = &v
	return s
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *RequestPhoneNumberOutput) SetOptOutListName(v string) *RequestPhoneNumberOutput {
	s.OptOutListName = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *RequestPhoneNumberOutput) SetPhoneNumber(v string) *RequestPhoneNumberOutput {
	s.PhoneNumber = &v
	return s
}

// SetPhoneNumberArn sets the PhoneNumberArn field's value.
func (s *RequestPhoneNumberOutput) SetPhoneNumberArn(v string) *RequestPhoneNumberOutput {
	s.PhoneNumberArn = &v
	return s
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *RequestPhoneNumberOutput) SetPhoneNumberId(v string) *RequestPhoneNumberOutput {
	s.PhoneNumberId = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *RequestPhoneNumberOutput) SetPoolId(v string) *RequestPhoneNumberOutput {
	s.PoolId = &v
	return s
}

// SetSelfManagedOptOutsEnabled sets the SelfManagedOptOutsEnabled field's value.
func (s *RequestPhoneNumberOutput) SetSelfManagedOptOutsEnabled(v bool) *RequestPhoneNumberOutput {
	s.SelfManagedOptOutsEnabled = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RequestPhoneNumberOutput) SetStatus(v string) *RequestPhoneNumberOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RequestPhoneNumberOutput) SetTags(v []*Tag) *RequestPhoneNumberOutput {
	s.Tags = v
	return s
}

// SetTwoWayChannelArn sets the TwoWayChannelArn field's value.
func (s *RequestPhoneNumberOutput) SetTwoWayChannelArn(v string) *RequestPhoneNumberOutput {
	s.TwoWayChannelArn = &v
	return s
}

// SetTwoWayEnabled sets the TwoWayEnabled field's value.
func (s *RequestPhoneNumberOutput) SetTwoWayEnabled(v bool) *RequestPhoneNumberOutput {
	s.TwoWayEnabled = &v
	return s
}

// A requested resource couldn't be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The unique identifier of the resource.
	ResourceId *string `type:"string"`

	// The type of resource that caused the exception.
	ResourceType *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type SendTextMessageInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set to use. This can be either the ConfigurationSetName
	// or ConfigurationSetArn.
	ConfigurationSetName *string `min:"1" type:"string"`

	// You can specify custom data in this field. If you do, that data is logged
	// to the event destination.
	Context map[string]*string `type:"map"`

	// This field is used for any country-specific registration requirements. Currently,
	// this setting is only used when you send messages to recipients in India using
	// a sender ID. For more information see Special requirements for sending SMS
	// messages to recipients in India (https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html).
	DestinationCountryParameters map[string]*string `type:"map"`

	// The destination phone number in E.164 format.
	//
	// DestinationPhoneNumber is a required field
	DestinationPhoneNumber *string `min:"1" type:"string" required:"true"`

	// When set to true, the message is checked and validated, but isn't sent to
	// the end recipient.
	DryRun *bool `type:"boolean"`

	// When you register a short code in the US, you must specify a program name.
	// If you don’t have a US short code, omit this attribute.
	Keyword *string `min:"1" type:"string"`

	// The maximum amount that you want to spend, in US dollars, per each text message
	// part. A text message can contain multiple parts.
	MaxPrice *string `min:"2" type:"string"`

	// The body of the text message.
	MessageBody *string `min:"1" type:"string"`

	// The type of message. Valid values are TRANSACTIONAL for messages that are
	// critical or time-sensitive and PROMOTIONAL for messages that aren't critical
	// or time-sensitive.
	MessageType *string `type:"string" enum:"MessageType"`

	// The origination identity of the message. This can be either the PhoneNumber,
	// PhoneNumberId, PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.
	OriginationIdentity *string `min:"1" type:"string"`

	// How long the text message is valid for. By default this is 72 hours.
	TimeToLive *int64 `min:"5" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendTextMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendTextMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendTextMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendTextMessageInput"}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}
	if s.DestinationPhoneNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationPhoneNumber"))
	}
	if s.DestinationPhoneNumber != nil && len(*s.DestinationPhoneNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationPhoneNumber", 1))
	}
	if s.Keyword != nil && len(*s.Keyword) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Keyword", 1))
	}
	if s.MaxPrice != nil && len(*s.MaxPrice) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MaxPrice", 2))
	}
	if s.MessageBody != nil && len(*s.MessageBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageBody", 1))
	}
	if s.OriginationIdentity != nil && len(*s.OriginationIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OriginationIdentity", 1))
	}
	if s.TimeToLive != nil && *s.TimeToLive < 5 {
		invalidParams.Add(request.NewErrParamMinValue("TimeToLive", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *SendTextMessageInput) SetConfigurationSetName(v string) *SendTextMessageInput {
	s.ConfigurationSetName = &v
	return s
}

// SetContext sets the Context field's value.
func (s *SendTextMessageInput) SetContext(v map[string]*string) *SendTextMessageInput {
	s.Context = v
	return s
}

// SetDestinationCountryParameters sets the DestinationCountryParameters field's value.
func (s *SendTextMessageInput) SetDestinationCountryParameters(v map[string]*string) *SendTextMessageInput {
	s.DestinationCountryParameters = v
	return s
}

// SetDestinationPhoneNumber sets the DestinationPhoneNumber field's value.
func (s *SendTextMessageInput) SetDestinationPhoneNumber(v string) *SendTextMessageInput {
	s.DestinationPhoneNumber = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *SendTextMessageInput) SetDryRun(v bool) *SendTextMessageInput {
	s.DryRun = &v
	return s
}

// SetKeyword sets the Keyword field's value.
func (s *SendTextMessageInput) SetKeyword(v string) *SendTextMessageInput {
	s.Keyword = &v
	return s
}

// SetMaxPrice sets the MaxPrice field's value.
func (s *SendTextMessageInput) SetMaxPrice(v string) *SendTextMessageInput {
	s.MaxPrice = &v
	return s
}

// SetMessageBody sets the MessageBody field's value.
func (s *SendTextMessageInput) SetMessageBody(v string) *SendTextMessageInput {
	s.MessageBody = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *SendTextMessageInput) SetMessageType(v string) *SendTextMessageInput {
	s.MessageType = &v
	return s
}

// SetOriginationIdentity sets the OriginationIdentity field's value.
func (s *SendTextMessageInput) SetOriginationIdentity(v string) *SendTextMessageInput {
	s.OriginationIdentity = &v
	return s
}

// SetTimeToLive sets the TimeToLive field's value.
func (s *SendTextMessageInput) SetTimeToLive(v int64) *SendTextMessageInput {
	s.TimeToLive = &v
	return s
}

type SendTextMessageOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the message.
	MessageId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendTextMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendTextMessageOutput) GoString() string {
	return s.String()
}

// SetMessageId sets the MessageId field's value.
func (s *SendTextMessageOutput) SetMessageId(v string) *SendTextMessageOutput {
	s.MessageId = &v
	return s
}

type SendVoiceMessageInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set to use. This can be either the ConfigurationSetName
	// or ConfigurationSetArn.
	ConfigurationSetName *string `min:"1" type:"string"`

	// You can specify custom data in this field. If you do, that data is logged
	// to the event destination.
	Context map[string]*string `type:"map"`

	// The destination phone number in E.164 format.
	//
	// DestinationPhoneNumber is a required field
	DestinationPhoneNumber *string `min:"1" type:"string" required:"true"`

	// When set to true, the message is checked and validated, but isn't sent to
	// the end recipient.
	DryRun *bool `type:"boolean"`

	// The maximum amount to spend per voice message, in US dollars.
	MaxPricePerMinute *string `min:"2" type:"string"`

	// The text to convert to a voice message.
	MessageBody *string `min:"1" type:"string"`

	// Specifies if the MessageBody field contains text or speech synthesis markup
	// language (SSML) (https://docs.aws.amazon.com/polly/latest/dg/what-is.html).
	//
	//    * TEXT: This is the default value. When used the maximum character limit
	//    is 3000.
	//
	//    * SSML: When used the maximum character limit is 6000 including SSML tagging.
	MessageBodyTextType *string `type:"string" enum:"VoiceMessageBodyTextType"`

	// The origination identity to use for the voice call. This can be the PhoneNumber,
	// PhoneNumberId, PhoneNumberArn, PoolId, or PoolArn.
	//
	// OriginationIdentity is a required field
	OriginationIdentity *string `min:"1" type:"string" required:"true"`

	// How long the voice message is valid for. By default this is 72 hours.
	TimeToLive *int64 `min:"5" type:"integer"`

	// The voice for the Amazon Polly (https://docs.aws.amazon.com/polly/latest/dg/what-is.html)
	// service to use. By default this is set to "MATTHEW".
	VoiceId *string `type:"string" enum:"VoiceId"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendVoiceMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendVoiceMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendVoiceMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendVoiceMessageInput"}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}
	if s.DestinationPhoneNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationPhoneNumber"))
	}
	if s.DestinationPhoneNumber != nil && len(*s.DestinationPhoneNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationPhoneNumber", 1))
	}
	if s.MaxPricePerMinute != nil && len(*s.MaxPricePerMinute) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MaxPricePerMinute", 2))
	}
	if s.MessageBody != nil && len(*s.MessageBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageBody", 1))
	}
	if s.OriginationIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginationIdentity"))
	}
	if s.OriginationIdentity != nil && len(*s.OriginationIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OriginationIdentity", 1))
	}
	if s.TimeToLive != nil && *s.TimeToLive < 5 {
		invalidParams.Add(request.NewErrParamMinValue("TimeToLive", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *SendVoiceMessageInput) SetConfigurationSetName(v string) *SendVoiceMessageInput {
	s.ConfigurationSetName = &v
	return s
}

// SetContext sets the Context field's value.
func (s *SendVoiceMessageInput) SetContext(v map[string]*string) *SendVoiceMessageInput {
	s.Context = v
	return s
}

// SetDestinationPhoneNumber sets the DestinationPhoneNumber field's value.
func (s *SendVoiceMessageInput) SetDestinationPhoneNumber(v string) *SendVoiceMessageInput {
	s.DestinationPhoneNumber = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *SendVoiceMessageInput) SetDryRun(v bool) *SendVoiceMessageInput {
	s.DryRun = &v
	return s
}

// SetMaxPricePerMinute sets the MaxPricePerMinute field's value.
func (s *SendVoiceMessageInput) SetMaxPricePerMinute(v string) *SendVoiceMessageInput {
	s.MaxPricePerMinute = &v
	return s
}

// SetMessageBody sets the MessageBody field's value.
func (s *SendVoiceMessageInput) SetMessageBody(v string) *SendVoiceMessageInput {
	s.MessageBody = &v
	return s
}

// SetMessageBodyTextType sets the MessageBodyTextType field's value.
func (s *SendVoiceMessageInput) SetMessageBodyTextType(v string) *SendVoiceMessageInput {
	s.MessageBodyTextType = &v
	return s
}

// SetOriginationIdentity sets the OriginationIdentity field's value.
func (s *SendVoiceMessageInput) SetOriginationIdentity(v string) *SendVoiceMessageInput {
	s.OriginationIdentity = &v
	return s
}

// SetTimeToLive sets the TimeToLive field's value.
func (s *SendVoiceMessageInput) SetTimeToLive(v int64) *SendVoiceMessageInput {
	s.TimeToLive = &v
	return s
}

// SetVoiceId sets the VoiceId field's value.
func (s *SendVoiceMessageInput) SetVoiceId(v string) *SendVoiceMessageInput {
	s.VoiceId = &v
	return s
}

type SendVoiceMessageOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the message.
	MessageId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendVoiceMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendVoiceMessageOutput) GoString() string {
	return s.String()
}

// SetMessageId sets the MessageId field's value.
func (s *SendVoiceMessageOutput) SetMessageId(v string) *SendVoiceMessageOutput {
	s.MessageId = &v
	return s
}

// The alphanumeric sender ID in a specific country that you want to describe.
// For more information on sender IDs see Requesting sender IDs for SMS messaging
// with Amazon Pinpoint (https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-sender-id.html)
// in the Amazon Pinpoint User Guide.
type SenderIdAndCountry struct {
	_ struct{} `type:"structure"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region.
	//
	// IsoCountryCode is a required field
	IsoCountryCode *string `min:"2" type:"string" required:"true"`

	// The unique identifier of the sender.
	//
	// SenderId is a required field
	SenderId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SenderIdAndCountry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SenderIdAndCountry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SenderIdAndCountry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SenderIdAndCountry"}
	if s.IsoCountryCode == nil {
		invalidParams.Add(request.NewErrParamRequired("IsoCountryCode"))
	}
	if s.IsoCountryCode != nil && len(*s.IsoCountryCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("IsoCountryCode", 2))
	}
	if s.SenderId == nil {
		invalidParams.Add(request.NewErrParamRequired("SenderId"))
	}
	if s.SenderId != nil && len(*s.SenderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SenderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIsoCountryCode sets the IsoCountryCode field's value.
func (s *SenderIdAndCountry) SetIsoCountryCode(v string) *SenderIdAndCountry {
	s.IsoCountryCode = &v
	return s
}

// SetSenderId sets the SenderId field's value.
func (s *SenderIdAndCountry) SetSenderId(v string) *SenderIdAndCountry {
	s.SenderId = &v
	return s
}

// The information for a sender ID that meets a specified criteria.
type SenderIdFilter struct {
	_ struct{} `type:"structure"`

	// The name of the attribute to filter on.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"SenderIdFilterName"`

	// An array of values to filter for.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SenderIdFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SenderIdFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SenderIdFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SenderIdFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *SenderIdFilter) SetName(v string) *SenderIdFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *SenderIdFilter) SetValues(v []*string) *SenderIdFilter {
	s.Values = v
	return s
}

// The information for all SenderIds in an Amazon Web Services account.
type SenderIdInformation struct {
	_ struct{} `type:"structure"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region.
	//
	// IsoCountryCode is a required field
	IsoCountryCode *string `min:"2" type:"string" required:"true"`

	// The type of message. Valid values are TRANSACTIONAL for messages that are
	// critical or time-sensitive and PROMOTIONAL for messages that aren't critical
	// or time-sensitive.
	//
	// MessageTypes is a required field
	MessageTypes []*string `type:"list" required:"true" enum:"MessageType"`

	// The monthly leasing price, in US dollars.
	//
	// MonthlyLeasingPrice is a required field
	MonthlyLeasingPrice *string `type:"string" required:"true"`

	// The alphanumeric sender ID in a specific country that you'd like to describe.
	//
	// SenderId is a required field
	SenderId *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) associated with the SenderId.
	//
	// SenderIdArn is a required field
	SenderIdArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SenderIdInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SenderIdInformation) GoString() string {
	return s.String()
}

// SetIsoCountryCode sets the IsoCountryCode field's value.
func (s *SenderIdInformation) SetIsoCountryCode(v string) *SenderIdInformation {
	s.IsoCountryCode = &v
	return s
}

// SetMessageTypes sets the MessageTypes field's value.
func (s *SenderIdInformation) SetMessageTypes(v []*string) *SenderIdInformation {
	s.MessageTypes = v
	return s
}

// SetMonthlyLeasingPrice sets the MonthlyLeasingPrice field's value.
func (s *SenderIdInformation) SetMonthlyLeasingPrice(v string) *SenderIdInformation {
	s.MonthlyLeasingPrice = &v
	return s
}

// SetSenderId sets the SenderId field's value.
func (s *SenderIdInformation) SetSenderId(v string) *SenderIdInformation {
	s.SenderId = &v
	return s
}

// SetSenderIdArn sets the SenderIdArn field's value.
func (s *SenderIdInformation) SetSenderIdArn(v string) *SenderIdInformation {
	s.SenderIdArn = &v
	return s
}

// The request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason for the exception.
	Reason *string `type:"string" enum:"ServiceQuotaExceededExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type SetDefaultMessageTypeInput struct {
	_ struct{} `type:"structure"`

	// The configuration set to update with a new default message type. This field
	// can be the ConsigurationSetName or ConfigurationSetArn.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `min:"1" type:"string" required:"true"`

	// The type of message. Valid values are TRANSACTIONAL for messages that are
	// critical or time-sensitive and PROMOTIONAL for messages that aren't critical
	// or time-sensitive.
	//
	// MessageType is a required field
	MessageType *string `type:"string" required:"true" enum:"MessageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetDefaultMessageTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetDefaultMessageTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetDefaultMessageTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetDefaultMessageTypeInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}
	if s.MessageType == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *SetDefaultMessageTypeInput) SetConfigurationSetName(v string) *SetDefaultMessageTypeInput {
	s.ConfigurationSetName = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *SetDefaultMessageTypeInput) SetMessageType(v string) *SetDefaultMessageTypeInput {
	s.MessageType = &v
	return s
}

type SetDefaultMessageTypeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated configuration set.
	ConfigurationSetArn *string `type:"string"`

	// The name of the configuration set that was updated.
	ConfigurationSetName *string `min:"1" type:"string"`

	// The new default message type of the configuration set.
	MessageType *string `type:"string" enum:"MessageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetDefaultMessageTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetDefaultMessageTypeOutput) GoString() string {
	return s.String()
}

// SetConfigurationSetArn sets the ConfigurationSetArn field's value.
func (s *SetDefaultMessageTypeOutput) SetConfigurationSetArn(v string) *SetDefaultMessageTypeOutput {
	s.ConfigurationSetArn = &v
	return s
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *SetDefaultMessageTypeOutput) SetConfigurationSetName(v string) *SetDefaultMessageTypeOutput {
	s.ConfigurationSetName = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *SetDefaultMessageTypeOutput) SetMessageType(v string) *SetDefaultMessageTypeOutput {
	s.MessageType = &v
	return s
}

type SetDefaultSenderIdInput struct {
	_ struct{} `type:"structure"`

	// The configuration set to updated with a new default SenderId. This field
	// can be the ConsigurationSetName or ConfigurationSetArn.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `min:"1" type:"string" required:"true"`

	// The current sender ID for the configuration set. When sending a text message
	// to a destination country which supports SenderIds, the default sender ID
	// on the configuration set specified on SendTextMessage will be used if no
	// dedicated origination phone numbers or registered SenderIds are available
	// in your account, instead of a generic sender ID, such as 'NOTICE'.
	//
	// SenderId is a required field
	SenderId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetDefaultSenderIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetDefaultSenderIdInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetDefaultSenderIdInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetDefaultSenderIdInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}
	if s.SenderId == nil {
		invalidParams.Add(request.NewErrParamRequired("SenderId"))
	}
	if s.SenderId != nil && len(*s.SenderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SenderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *SetDefaultSenderIdInput) SetConfigurationSetName(v string) *SetDefaultSenderIdInput {
	s.ConfigurationSetName = &v
	return s
}

// SetSenderId sets the SenderId field's value.
func (s *SetDefaultSenderIdInput) SetSenderId(v string) *SetDefaultSenderIdInput {
	s.SenderId = &v
	return s
}

type SetDefaultSenderIdOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated configuration set.
	ConfigurationSetArn *string `type:"string"`

	// The name of the configuration set that was updated.
	ConfigurationSetName *string `min:"1" type:"string"`

	// The default sender ID to set for the ConfigurationSet.
	SenderId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetDefaultSenderIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetDefaultSenderIdOutput) GoString() string {
	return s.String()
}

// SetConfigurationSetArn sets the ConfigurationSetArn field's value.
func (s *SetDefaultSenderIdOutput) SetConfigurationSetArn(v string) *SetDefaultSenderIdOutput {
	s.ConfigurationSetArn = &v
	return s
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *SetDefaultSenderIdOutput) SetConfigurationSetName(v string) *SetDefaultSenderIdOutput {
	s.ConfigurationSetName = &v
	return s
}

// SetSenderId sets the SenderId field's value.
func (s *SetDefaultSenderIdOutput) SetSenderId(v string) *SetDefaultSenderIdOutput {
	s.SenderId = &v
	return s
}

type SetTextMessageSpendLimitOverrideInput struct {
	_ struct{} `type:"structure"`

	// The new monthly limit to enforce on text messages.
	//
	// MonthlyLimit is a required field
	MonthlyLimit *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetTextMessageSpendLimitOverrideInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetTextMessageSpendLimitOverrideInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetTextMessageSpendLimitOverrideInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetTextMessageSpendLimitOverrideInput"}
	if s.MonthlyLimit == nil {
		invalidParams.Add(request.NewErrParamRequired("MonthlyLimit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonthlyLimit sets the MonthlyLimit field's value.
func (s *SetTextMessageSpendLimitOverrideInput) SetMonthlyLimit(v int64) *SetTextMessageSpendLimitOverrideInput {
	s.MonthlyLimit = &v
	return s
}

type SetTextMessageSpendLimitOverrideOutput struct {
	_ struct{} `type:"structure"`

	// The current monthly limit to enforce on sending text messages.
	MonthlyLimit *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetTextMessageSpendLimitOverrideOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetTextMessageSpendLimitOverrideOutput) GoString() string {
	return s.String()
}

// SetMonthlyLimit sets the MonthlyLimit field's value.
func (s *SetTextMessageSpendLimitOverrideOutput) SetMonthlyLimit(v int64) *SetTextMessageSpendLimitOverrideOutput {
	s.MonthlyLimit = &v
	return s
}

type SetVoiceMessageSpendLimitOverrideInput struct {
	_ struct{} `type:"structure"`

	// The new monthly limit to enforce on voice messages.
	//
	// MonthlyLimit is a required field
	MonthlyLimit *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetVoiceMessageSpendLimitOverrideInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetVoiceMessageSpendLimitOverrideInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetVoiceMessageSpendLimitOverrideInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetVoiceMessageSpendLimitOverrideInput"}
	if s.MonthlyLimit == nil {
		invalidParams.Add(request.NewErrParamRequired("MonthlyLimit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonthlyLimit sets the MonthlyLimit field's value.
func (s *SetVoiceMessageSpendLimitOverrideInput) SetMonthlyLimit(v int64) *SetVoiceMessageSpendLimitOverrideInput {
	s.MonthlyLimit = &v
	return s
}

type SetVoiceMessageSpendLimitOverrideOutput struct {
	_ struct{} `type:"structure"`

	// The current monthly limit to enforce on sending voice messages.
	MonthlyLimit *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetVoiceMessageSpendLimitOverrideOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetVoiceMessageSpendLimitOverrideOutput) GoString() string {
	return s.String()
}

// SetMonthlyLimit sets the MonthlyLimit field's value.
func (s *SetVoiceMessageSpendLimitOverrideOutput) SetMonthlyLimit(v int64) *SetVoiceMessageSpendLimitOverrideOutput {
	s.MonthlyLimit = &v
	return s
}

// An object that defines an Amazon SNS destination for events. You can use
// Amazon SNS to send notification when certain events occur.
type SnsDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish
	// events to.
	//
	// TopicArn is a required field
	TopicArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnsDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnsDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SnsDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SnsDestination"}
	if s.TopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicArn"))
	}
	if s.TopicArn != nil && len(*s.TopicArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("TopicArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTopicArn sets the TopicArn field's value.
func (s *SnsDestination) SetTopicArn(v string) *SnsDestination {
	s.TopicArn = &v
	return s
}

// Describes the current Amazon Pinpoint monthly spend limits for sending voice
// and text messages. For more information on increasing your monthly spend
// limit, see Requesting increases to your monthly SMS spending quota for Amazon
// Pinpoint (https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-spend-threshold.html)
// in the Amazon Pinpoint User Guide.
type SpendLimit struct {
	_ struct{} `type:"structure"`

	// The maximum amount of money, in US dollars, that you want to be able to spend
	// sending messages each month. This value has to be less than or equal to the
	// amount in MaxLimit. To use this custom limit, Overridden must be set to true.
	//
	// EnforcedLimit is a required field
	EnforcedLimit *int64 `type:"long" required:"true"`

	// The maximum amount of money that you are able to spend to send messages each
	// month, in US dollars.
	//
	// MaxLimit is a required field
	MaxLimit *int64 `type:"long" required:"true"`

	// The name for the SpendLimit.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"SpendLimitName"`

	// When set to True, the value that has been specified in the EnforcedLimit
	// is used to determine the maximum amount in US dollars that can be spent to
	// send messages each month, in US dollars.
	//
	// Overridden is a required field
	Overridden *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SpendLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SpendLimit) GoString() string {
	return s.String()
}

// SetEnforcedLimit sets the EnforcedLimit field's value.
func (s *SpendLimit) SetEnforcedLimit(v int64) *SpendLimit {
	s.EnforcedLimit = &v
	return s
}

// SetMaxLimit sets the MaxLimit field's value.
func (s *SpendLimit) SetMaxLimit(v int64) *SpendLimit {
	s.MaxLimit = &v
	return s
}

// SetName sets the Name field's value.
func (s *SpendLimit) SetName(v string) *SpendLimit {
	s.Name = &v
	return s
}

// SetOverridden sets the Overridden field's value.
func (s *SpendLimit) SetOverridden(v bool) *SpendLimit {
	s.Overridden = &v
	return s
}

// The list of tags to be added to the specified topic.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key identifier, or name, of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The string value associated with the key of the tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`

	// An array of key and value pair tags that are associated with the resource.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// An error that occurred because too many requests were sent during a certain
// amount of time.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`

	// An array of tag key values to unassociate with the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateEventDestinationInput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about an event destination that sends
	// data to CloudWatch Logs.
	CloudWatchLogsDestination *CloudWatchLogsDestination `type:"structure"`

	// The configuration set to update with the new event destination. Valid values
	// for this can be the ConfigurationSetName or ConfigurationSetArn.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `min:"1" type:"string" required:"true"`

	// When set to true logging is enabled.
	Enabled *bool `type:"boolean"`

	// The name to use for the event destination.
	//
	// EventDestinationName is a required field
	EventDestinationName *string `min:"1" type:"string" required:"true"`

	// An object that contains information about an event destination for logging
	// to Kinesis Data Firehose.
	KinesisFirehoseDestination *KinesisFirehoseDestination `type:"structure"`

	// An array of event types that determine which events to log.
	MatchingEventTypes []*string `min:"1" type:"list" enum:"EventType"`

	// An object that contains information about an event destination that sends
	// data to Amazon SNS.
	SnsDestination *SnsDestination `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEventDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEventDestinationInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}
	if s.EventDestinationName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestinationName"))
	}
	if s.EventDestinationName != nil && len(*s.EventDestinationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventDestinationName", 1))
	}
	if s.MatchingEventTypes != nil && len(s.MatchingEventTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MatchingEventTypes", 1))
	}
	if s.CloudWatchLogsDestination != nil {
		if err := s.CloudWatchLogsDestination.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchLogsDestination", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseDestination != nil {
		if err := s.KinesisFirehoseDestination.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseDestination", err.(request.ErrInvalidParams))
		}
	}
	if s.SnsDestination != nil {
		if err := s.SnsDestination.Validate(); err != nil {
			invalidParams.AddNested("SnsDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogsDestination sets the CloudWatchLogsDestination field's value.
func (s *UpdateEventDestinationInput) SetCloudWatchLogsDestination(v *CloudWatchLogsDestination) *UpdateEventDestinationInput {
	s.CloudWatchLogsDestination = v
	return s
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *UpdateEventDestinationInput) SetConfigurationSetName(v string) *UpdateEventDestinationInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *UpdateEventDestinationInput) SetEnabled(v bool) *UpdateEventDestinationInput {
	s.Enabled = &v
	return s
}

// SetEventDestinationName sets the EventDestinationName field's value.
func (s *UpdateEventDestinationInput) SetEventDestinationName(v string) *UpdateEventDestinationInput {
	s.EventDestinationName = &v
	return s
}

// SetKinesisFirehoseDestination sets the KinesisFirehoseDestination field's value.
func (s *UpdateEventDestinationInput) SetKinesisFirehoseDestination(v *KinesisFirehoseDestination) *UpdateEventDestinationInput {
	s.KinesisFirehoseDestination = v
	return s
}

// SetMatchingEventTypes sets the MatchingEventTypes field's value.
func (s *UpdateEventDestinationInput) SetMatchingEventTypes(v []*string) *UpdateEventDestinationInput {
	s.MatchingEventTypes = v
	return s
}

// SetSnsDestination sets the SnsDestination field's value.
func (s *UpdateEventDestinationInput) SetSnsDestination(v *SnsDestination) *UpdateEventDestinationInput {
	s.SnsDestination = v
	return s
}

type UpdateEventDestinationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the ConfigurationSet that was updated.
	ConfigurationSetArn *string `type:"string"`

	// The name of the configuration set.
	ConfigurationSetName *string `min:"1" type:"string"`

	// An EventDestination object containing the details of where events will be
	// logged.
	EventDestination *EventDestination `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventDestinationOutput) GoString() string {
	return s.String()
}

// SetConfigurationSetArn sets the ConfigurationSetArn field's value.
func (s *UpdateEventDestinationOutput) SetConfigurationSetArn(v string) *UpdateEventDestinationOutput {
	s.ConfigurationSetArn = &v
	return s
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *UpdateEventDestinationOutput) SetConfigurationSetName(v string) *UpdateEventDestinationOutput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestination sets the EventDestination field's value.
func (s *UpdateEventDestinationOutput) SetEventDestination(v *EventDestination) *UpdateEventDestinationOutput {
	s.EventDestination = v
	return s
}

type UpdatePhoneNumberInput struct {
	_ struct{} `type:"structure"`

	// By default this is set to false. When set to true the phone number can't
	// be deleted.
	DeletionProtectionEnabled *bool `type:"boolean"`

	// The OptOutList to add the phone number to. Valid values for this field can
	// be either the OutOutListName or OutOutListArn.
	OptOutListName *string `min:"1" type:"string"`

	// The unique identifier of the phone number. Valid values for this field can
	// be either the PhoneNumberId or PhoneNumberArn.
	//
	// PhoneNumberId is a required field
	PhoneNumberId *string `min:"1" type:"string" required:"true"`

	// By default this is set to false. When an end recipient sends a message that
	// begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint
	// automatically replies with a customizable message and adds the end recipient
	// to the OptOutList. When set to true you're responsible for responding to
	// HELP and STOP requests. You're also responsible for tracking and honoring
	// opt-out requests.
	SelfManagedOptOutsEnabled *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the two way channel.
	TwoWayChannelArn *string `min:"20" type:"string"`

	// By default this is set to false. When set to true you can receive incoming
	// text messages from your end recipients.
	TwoWayEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePhoneNumberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePhoneNumberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePhoneNumberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePhoneNumberInput"}
	if s.OptOutListName != nil && len(*s.OptOutListName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OptOutListName", 1))
	}
	if s.PhoneNumberId == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumberId"))
	}
	if s.PhoneNumberId != nil && len(*s.PhoneNumberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumberId", 1))
	}
	if s.TwoWayChannelArn != nil && len(*s.TwoWayChannelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("TwoWayChannelArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeletionProtectionEnabled sets the DeletionProtectionEnabled field's value.
func (s *UpdatePhoneNumberInput) SetDeletionProtectionEnabled(v bool) *UpdatePhoneNumberInput {
	s.DeletionProtectionEnabled = &v
	return s
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *UpdatePhoneNumberInput) SetOptOutListName(v string) *UpdatePhoneNumberInput {
	s.OptOutListName = &v
	return s
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *UpdatePhoneNumberInput) SetPhoneNumberId(v string) *UpdatePhoneNumberInput {
	s.PhoneNumberId = &v
	return s
}

// SetSelfManagedOptOutsEnabled sets the SelfManagedOptOutsEnabled field's value.
func (s *UpdatePhoneNumberInput) SetSelfManagedOptOutsEnabled(v bool) *UpdatePhoneNumberInput {
	s.SelfManagedOptOutsEnabled = &v
	return s
}

// SetTwoWayChannelArn sets the TwoWayChannelArn field's value.
func (s *UpdatePhoneNumberInput) SetTwoWayChannelArn(v string) *UpdatePhoneNumberInput {
	s.TwoWayChannelArn = &v
	return s
}

// SetTwoWayEnabled sets the TwoWayEnabled field's value.
func (s *UpdatePhoneNumberInput) SetTwoWayEnabled(v bool) *UpdatePhoneNumberInput {
	s.TwoWayEnabled = &v
	return s
}

type UpdatePhoneNumberOutput struct {
	_ struct{} `type:"structure"`

	// The time when the phone number was created, in UNIX epoch time (https://www.epochconverter.com/)
	// format.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// When set to true the phone number can't be deleted.
	DeletionProtectionEnabled *bool `type:"boolean"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region.
	IsoCountryCode *string `min:"2" type:"string"`

	// The type of message. Valid values are TRANSACTIONAL for messages that are
	// critical or time-sensitive and PROMOTIONAL for messages that aren't critical
	// or time-sensitive.
	MessageType *string `type:"string" enum:"MessageType"`

	// The monthly leasing price of the phone number, in US dollars.
	MonthlyLeasingPrice *string `type:"string"`

	// Specifies if the number could be used for text messages, voice or both.
	NumberCapabilities []*string `min:"1" type:"list" enum:"NumberCapability"`

	// The type of number that was requested.
	NumberType *string `type:"string" enum:"NumberType"`

	// The name of the OptOutList associated with the phone number.
	OptOutListName *string `min:"1" type:"string"`

	// The phone number that was updated.
	PhoneNumber *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the updated phone number.
	PhoneNumberArn *string `type:"string"`

	// The unique identifier of the phone number.
	PhoneNumberId *string `type:"string"`

	// This is true if self managed opt-out are enabled.
	SelfManagedOptOutsEnabled *bool `type:"boolean"`

	// The current status of the request.
	Status *string `type:"string" enum:"NumberStatus"`

	// The Amazon Resource Name (ARN) of the two way channel.
	TwoWayChannelArn *string `min:"20" type:"string"`

	// By default this is set to false. When set to true you can receive incoming
	// text messages from your end recipients.
	TwoWayEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePhoneNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePhoneNumberOutput) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *UpdatePhoneNumberOutput) SetCreatedTimestamp(v time.Time) *UpdatePhoneNumberOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDeletionProtectionEnabled sets the DeletionProtectionEnabled field's value.
func (s *UpdatePhoneNumberOutput) SetDeletionProtectionEnabled(v bool) *UpdatePhoneNumberOutput {
	s.DeletionProtectionEnabled = &v
	return s
}

// SetIsoCountryCode sets the IsoCountryCode field's value.
func (s *UpdatePhoneNumberOutput) SetIsoCountryCode(v string) *UpdatePhoneNumberOutput {
	s.IsoCountryCode = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *UpdatePhoneNumberOutput) SetMessageType(v string) *UpdatePhoneNumberOutput {
	s.MessageType = &v
	return s
}

// SetMonthlyLeasingPrice sets the MonthlyLeasingPrice field's value.
func (s *UpdatePhoneNumberOutput) SetMonthlyLeasingPrice(v string) *UpdatePhoneNumberOutput {
	s.MonthlyLeasingPrice = &v
	return s
}

// SetNumberCapabilities sets the NumberCapabilities field's value.
func (s *UpdatePhoneNumberOutput) SetNumberCapabilities(v []*string) *UpdatePhoneNumberOutput {
	s.NumberCapabilities = v
	return s
}

// SetNumberType sets the NumberType field's value.
func (s *UpdatePhoneNumberOutput) SetNumberType(v string) *UpdatePhoneNumberOutput {
	s.NumberType = &v
	return s
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *UpdatePhoneNumberOutput) SetOptOutListName(v string) *UpdatePhoneNumberOutput {
	s.OptOutListName = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *UpdatePhoneNumberOutput) SetPhoneNumber(v string) *UpdatePhoneNumberOutput {
	s.PhoneNumber = &v
	return s
}

// SetPhoneNumberArn sets the PhoneNumberArn field's value.
func (s *UpdatePhoneNumberOutput) SetPhoneNumberArn(v string) *UpdatePhoneNumberOutput {
	s.PhoneNumberArn = &v
	return s
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *UpdatePhoneNumberOutput) SetPhoneNumberId(v string) *UpdatePhoneNumberOutput {
	s.PhoneNumberId = &v
	return s
}

// SetSelfManagedOptOutsEnabled sets the SelfManagedOptOutsEnabled field's value.
func (s *UpdatePhoneNumberOutput) SetSelfManagedOptOutsEnabled(v bool) *UpdatePhoneNumberOutput {
	s.SelfManagedOptOutsEnabled = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdatePhoneNumberOutput) SetStatus(v string) *UpdatePhoneNumberOutput {
	s.Status = &v
	return s
}

// SetTwoWayChannelArn sets the TwoWayChannelArn field's value.
func (s *UpdatePhoneNumberOutput) SetTwoWayChannelArn(v string) *UpdatePhoneNumberOutput {
	s.TwoWayChannelArn = &v
	return s
}

// SetTwoWayEnabled sets the TwoWayEnabled field's value.
func (s *UpdatePhoneNumberOutput) SetTwoWayEnabled(v bool) *UpdatePhoneNumberOutput {
	s.TwoWayEnabled = &v
	return s
}

type UpdatePoolInput struct {
	_ struct{} `type:"structure"`

	// When set to true the pool can't be deleted.
	DeletionProtectionEnabled *bool `type:"boolean"`

	// The OptOutList to associate with the pool. Valid values are either OptOutListName
	// or OptOutListArn.
	OptOutListName *string `min:"1" type:"string"`

	// The unique identifier of the pool to update. Valid values are either the
	// PoolId or PoolArn.
	//
	// PoolId is a required field
	PoolId *string `min:"1" type:"string" required:"true"`

	// By default this is set to false. When an end recipient sends a message that
	// begins with HELP or STOP to one of your dedicated numbers, Amazon Pinpoint
	// automatically replies with a customizable message and adds the end recipient
	// to the OptOutList. When set to true you're responsible for responding to
	// HELP and STOP requests. You're also responsible for tracking and honoring
	// opt-out requests.
	SelfManagedOptOutsEnabled *bool `type:"boolean"`

	// Indicates whether shared routes are enabled for the pool.
	SharedRoutesEnabled *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the two way channel.
	TwoWayChannelArn *string `min:"20" type:"string"`

	// By default this is set to false. When set to true you can receive incoming
	// text messages from your end recipients.
	TwoWayEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePoolInput"}
	if s.OptOutListName != nil && len(*s.OptOutListName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OptOutListName", 1))
	}
	if s.PoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolId"))
	}
	if s.PoolId != nil && len(*s.PoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PoolId", 1))
	}
	if s.TwoWayChannelArn != nil && len(*s.TwoWayChannelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("TwoWayChannelArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeletionProtectionEnabled sets the DeletionProtectionEnabled field's value.
func (s *UpdatePoolInput) SetDeletionProtectionEnabled(v bool) *UpdatePoolInput {
	s.DeletionProtectionEnabled = &v
	return s
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *UpdatePoolInput) SetOptOutListName(v string) *UpdatePoolInput {
	s.OptOutListName = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *UpdatePoolInput) SetPoolId(v string) *UpdatePoolInput {
	s.PoolId = &v
	return s
}

// SetSelfManagedOptOutsEnabled sets the SelfManagedOptOutsEnabled field's value.
func (s *UpdatePoolInput) SetSelfManagedOptOutsEnabled(v bool) *UpdatePoolInput {
	s.SelfManagedOptOutsEnabled = &v
	return s
}

// SetSharedRoutesEnabled sets the SharedRoutesEnabled field's value.
func (s *UpdatePoolInput) SetSharedRoutesEnabled(v bool) *UpdatePoolInput {
	s.SharedRoutesEnabled = &v
	return s
}

// SetTwoWayChannelArn sets the TwoWayChannelArn field's value.
func (s *UpdatePoolInput) SetTwoWayChannelArn(v string) *UpdatePoolInput {
	s.TwoWayChannelArn = &v
	return s
}

// SetTwoWayEnabled sets the TwoWayEnabled field's value.
func (s *UpdatePoolInput) SetTwoWayEnabled(v bool) *UpdatePoolInput {
	s.TwoWayEnabled = &v
	return s
}

type UpdatePoolOutput struct {
	_ struct{} `type:"structure"`

	// The time when the pool was created, in UNIX epoch time (https://www.epochconverter.com/)
	// format.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// When set to true the pool can't be deleted.
	DeletionProtectionEnabled *bool `type:"boolean"`

	// The type of message for the pool to use.
	MessageType *string `type:"string" enum:"MessageType"`

	// The name of the OptOutList associated with the pool.
	OptOutListName *string `min:"1" type:"string"`

	// The ARN of the pool.
	PoolArn *string `type:"string"`

	// The unique identifier of the pool.
	PoolId *string `type:"string"`

	// When an end recipient sends a message that begins with HELP or STOP to one
	// of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable
	// message and adds the end recipient to the OptOutList. When set to true you're
	// responsible for responding to HELP and STOP requests. You're also responsible
	// for tracking and honoring opt-out requests.
	SelfManagedOptOutsEnabled *bool `type:"boolean"`

	// Indicates whether shared routes are enabled for the pool.
	SharedRoutesEnabled *bool `type:"boolean"`

	// The current status of the pool update request.
	Status *string `type:"string" enum:"PoolStatus"`

	// The Amazon Resource Name (ARN) of the two way channel.
	TwoWayChannelArn *string `min:"20" type:"string"`

	// By default this is set to false. When set to true you can receive incoming
	// text messages from your end recipients.
	TwoWayEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePoolOutput) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *UpdatePoolOutput) SetCreatedTimestamp(v time.Time) *UpdatePoolOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDeletionProtectionEnabled sets the DeletionProtectionEnabled field's value.
func (s *UpdatePoolOutput) SetDeletionProtectionEnabled(v bool) *UpdatePoolOutput {
	s.DeletionProtectionEnabled = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *UpdatePoolOutput) SetMessageType(v string) *UpdatePoolOutput {
	s.MessageType = &v
	return s
}

// SetOptOutListName sets the OptOutListName field's value.
func (s *UpdatePoolOutput) SetOptOutListName(v string) *UpdatePoolOutput {
	s.OptOutListName = &v
	return s
}

// SetPoolArn sets the PoolArn field's value.
func (s *UpdatePoolOutput) SetPoolArn(v string) *UpdatePoolOutput {
	s.PoolArn = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *UpdatePoolOutput) SetPoolId(v string) *UpdatePoolOutput {
	s.PoolId = &v
	return s
}

// SetSelfManagedOptOutsEnabled sets the SelfManagedOptOutsEnabled field's value.
func (s *UpdatePoolOutput) SetSelfManagedOptOutsEnabled(v bool) *UpdatePoolOutput {
	s.SelfManagedOptOutsEnabled = &v
	return s
}

// SetSharedRoutesEnabled sets the SharedRoutesEnabled field's value.
func (s *UpdatePoolOutput) SetSharedRoutesEnabled(v bool) *UpdatePoolOutput {
	s.SharedRoutesEnabled = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdatePoolOutput) SetStatus(v string) *UpdatePoolOutput {
	s.Status = &v
	return s
}

// SetTwoWayChannelArn sets the TwoWayChannelArn field's value.
func (s *UpdatePoolOutput) SetTwoWayChannelArn(v string) *UpdatePoolOutput {
	s.TwoWayChannelArn = &v
	return s
}

// SetTwoWayEnabled sets the TwoWayEnabled field's value.
func (s *UpdatePoolOutput) SetTwoWayEnabled(v bool) *UpdatePoolOutput {
	s.TwoWayEnabled = &v
	return s
}

// A validation exception for a field.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The field that failed validation.
	Fields []*ValidationExceptionField `type:"list"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason for the exception.
	Reason *string `type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The field associated with the validation exception.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The message associated with the validation exception with information to
	// help determine its cause.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The name of the field.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// AccessDeniedExceptionReasonInsufficientAccountReputation is a AccessDeniedExceptionReason enum value
	AccessDeniedExceptionReasonInsufficientAccountReputation = "INSUFFICIENT_ACCOUNT_REPUTATION"

	// AccessDeniedExceptionReasonAccountDisabled is a AccessDeniedExceptionReason enum value
	AccessDeniedExceptionReasonAccountDisabled = "ACCOUNT_DISABLED"
)

// AccessDeniedExceptionReason_Values returns all elements of the AccessDeniedExceptionReason enum
func AccessDeniedExceptionReason_Values() []string {
	return []string{
		AccessDeniedExceptionReasonInsufficientAccountReputation,
		AccessDeniedExceptionReasonAccountDisabled,
	}
}

const (
	// AccountAttributeNameAccountTier is a AccountAttributeName enum value
	AccountAttributeNameAccountTier = "ACCOUNT_TIER"
)

// AccountAttributeName_Values returns all elements of the AccountAttributeName enum
func AccountAttributeName_Values() []string {
	return []string{
		AccountAttributeNameAccountTier,
	}
}

const (
	// AccountLimitNamePhoneNumbers is a AccountLimitName enum value
	AccountLimitNamePhoneNumbers = "PHONE_NUMBERS"

	// AccountLimitNamePools is a AccountLimitName enum value
	AccountLimitNamePools = "POOLS"

	// AccountLimitNameConfigurationSets is a AccountLimitName enum value
	AccountLimitNameConfigurationSets = "CONFIGURATION_SETS"

	// AccountLimitNameOptOutLists is a AccountLimitName enum value
	AccountLimitNameOptOutLists = "OPT_OUT_LISTS"
)

// AccountLimitName_Values returns all elements of the AccountLimitName enum
func AccountLimitName_Values() []string {
	return []string{
		AccountLimitNamePhoneNumbers,
		AccountLimitNamePools,
		AccountLimitNameConfigurationSets,
		AccountLimitNameOptOutLists,
	}
}

const (
	// ConfigurationSetFilterNameEventDestinationName is a ConfigurationSetFilterName enum value
	ConfigurationSetFilterNameEventDestinationName = "event-destination-name"

	// ConfigurationSetFilterNameMatchingEventTypes is a ConfigurationSetFilterName enum value
	ConfigurationSetFilterNameMatchingEventTypes = "matching-event-types"

	// ConfigurationSetFilterNameDefaultMessageType is a ConfigurationSetFilterName enum value
	ConfigurationSetFilterNameDefaultMessageType = "default-message-type"

	// ConfigurationSetFilterNameDefaultSenderId is a ConfigurationSetFilterName enum value
	ConfigurationSetFilterNameDefaultSenderId = "default-sender-id"
)

// ConfigurationSetFilterName_Values returns all elements of the ConfigurationSetFilterName enum
func ConfigurationSetFilterName_Values() []string {
	return []string{
		ConfigurationSetFilterNameEventDestinationName,
		ConfigurationSetFilterNameMatchingEventTypes,
		ConfigurationSetFilterNameDefaultMessageType,
		ConfigurationSetFilterNameDefaultSenderId,
	}
}

const (
	// ConflictExceptionReasonDeletionProtectionEnabled is a ConflictExceptionReason enum value
	ConflictExceptionReasonDeletionProtectionEnabled = "DELETION_PROTECTION_ENABLED"

	// ConflictExceptionReasonDestinationPhoneNumberNotVerified is a ConflictExceptionReason enum value
	ConflictExceptionReasonDestinationPhoneNumberNotVerified = "DESTINATION_PHONE_NUMBER_NOT_VERIFIED"

	// ConflictExceptionReasonDestinationPhoneNumberOptedOut is a ConflictExceptionReason enum value
	ConflictExceptionReasonDestinationPhoneNumberOptedOut = "DESTINATION_PHONE_NUMBER_OPTED_OUT"

	// ConflictExceptionReasonEventDestinationMismatch is a ConflictExceptionReason enum value
	ConflictExceptionReasonEventDestinationMismatch = "EVENT_DESTINATION_MISMATCH"

	// ConflictExceptionReasonKeywordMismatch is a ConflictExceptionReason enum value
	ConflictExceptionReasonKeywordMismatch = "KEYWORD_MISMATCH"

	// ConflictExceptionReasonLastPhoneNumber is a ConflictExceptionReason enum value
	ConflictExceptionReasonLastPhoneNumber = "LAST_PHONE_NUMBER"

	// ConflictExceptionReasonSelfManagedOptOutsMismatch is a ConflictExceptionReason enum value
	ConflictExceptionReasonSelfManagedOptOutsMismatch = "SELF_MANAGED_OPT_OUTS_MISMATCH"

	// ConflictExceptionReasonMessageTypeMismatch is a ConflictExceptionReason enum value
	ConflictExceptionReasonMessageTypeMismatch = "MESSAGE_TYPE_MISMATCH"

	// ConflictExceptionReasonNoOriginationIdentitiesFound is a ConflictExceptionReason enum value
	ConflictExceptionReasonNoOriginationIdentitiesFound = "NO_ORIGINATION_IDENTITIES_FOUND"

	// ConflictExceptionReasonOptOutListMismatch is a ConflictExceptionReason enum value
	ConflictExceptionReasonOptOutListMismatch = "OPT_OUT_LIST_MISMATCH"

	// ConflictExceptionReasonPhoneNumberAssociatedToPool is a ConflictExceptionReason enum value
	ConflictExceptionReasonPhoneNumberAssociatedToPool = "PHONE_NUMBER_ASSOCIATED_TO_POOL"

	// ConflictExceptionReasonPhoneNumberNotAssociatedToPool is a ConflictExceptionReason enum value
	ConflictExceptionReasonPhoneNumberNotAssociatedToPool = "PHONE_NUMBER_NOT_ASSOCIATED_TO_POOL"

	// ConflictExceptionReasonPhoneNumberNotInRegistrationRegion is a ConflictExceptionReason enum value
	ConflictExceptionReasonPhoneNumberNotInRegistrationRegion = "PHONE_NUMBER_NOT_IN_REGISTRATION_REGION"

	// ConflictExceptionReasonResourceAlreadyExists is a ConflictExceptionReason enum value
	ConflictExceptionReasonResourceAlreadyExists = "RESOURCE_ALREADY_EXISTS"

	// ConflictExceptionReasonResourceDeletionNotAllowed is a ConflictExceptionReason enum value
	ConflictExceptionReasonResourceDeletionNotAllowed = "RESOURCE_DELETION_NOT_ALLOWED"

	// ConflictExceptionReasonResourceModificationNotAllowed is a ConflictExceptionReason enum value
	ConflictExceptionReasonResourceModificationNotAllowed = "RESOURCE_MODIFICATION_NOT_ALLOWED"

	// ConflictExceptionReasonResourceNotActive is a ConflictExceptionReason enum value
	ConflictExceptionReasonResourceNotActive = "RESOURCE_NOT_ACTIVE"

	// ConflictExceptionReasonResourceNotEmpty is a ConflictExceptionReason enum value
	ConflictExceptionReasonResourceNotEmpty = "RESOURCE_NOT_EMPTY"

	// ConflictExceptionReasonTwoWayConfigMismatch is a ConflictExceptionReason enum value
	ConflictExceptionReasonTwoWayConfigMismatch = "TWO_WAY_CONFIG_MISMATCH"
)

// ConflictExceptionReason_Values returns all elements of the ConflictExceptionReason enum
func ConflictExceptionReason_Values() []string {
	return []string{
		ConflictExceptionReasonDeletionProtectionEnabled,
		ConflictExceptionReasonDestinationPhoneNumberNotVerified,
		ConflictExceptionReasonDestinationPhoneNumberOptedOut,
		ConflictExceptionReasonEventDestinationMismatch,
		ConflictExceptionReasonKeywordMismatch,
		ConflictExceptionReasonLastPhoneNumber,
		ConflictExceptionReasonSelfManagedOptOutsMismatch,
		ConflictExceptionReasonMessageTypeMismatch,
		ConflictExceptionReasonNoOriginationIdentitiesFound,
		ConflictExceptionReasonOptOutListMismatch,
		ConflictExceptionReasonPhoneNumberAssociatedToPool,
		ConflictExceptionReasonPhoneNumberNotAssociatedToPool,
		ConflictExceptionReasonPhoneNumberNotInRegistrationRegion,
		ConflictExceptionReasonResourceAlreadyExists,
		ConflictExceptionReasonResourceDeletionNotAllowed,
		ConflictExceptionReasonResourceModificationNotAllowed,
		ConflictExceptionReasonResourceNotActive,
		ConflictExceptionReasonResourceNotEmpty,
		ConflictExceptionReasonTwoWayConfigMismatch,
	}
}

const (
	// DestinationCountryParameterKeyInTemplateId is a DestinationCountryParameterKey enum value
	DestinationCountryParameterKeyInTemplateId = "IN_TEMPLATE_ID"

	// DestinationCountryParameterKeyInEntityId is a DestinationCountryParameterKey enum value
	DestinationCountryParameterKeyInEntityId = "IN_ENTITY_ID"
)

// DestinationCountryParameterKey_Values returns all elements of the DestinationCountryParameterKey enum
func DestinationCountryParameterKey_Values() []string {
	return []string{
		DestinationCountryParameterKeyInTemplateId,
		DestinationCountryParameterKeyInEntityId,
	}
}

const (
	// EventTypeAll is a EventType enum value
	EventTypeAll = "ALL"

	// EventTypeTextAll is a EventType enum value
	EventTypeTextAll = "TEXT_ALL"

	// EventTypeTextSent is a EventType enum value
	EventTypeTextSent = "TEXT_SENT"

	// EventTypeTextPending is a EventType enum value
	EventTypeTextPending = "TEXT_PENDING"

	// EventTypeTextQueued is a EventType enum value
	EventTypeTextQueued = "TEXT_QUEUED"

	// EventTypeTextSuccessful is a EventType enum value
	EventTypeTextSuccessful = "TEXT_SUCCESSFUL"

	// EventTypeTextDelivered is a EventType enum value
	EventTypeTextDelivered = "TEXT_DELIVERED"

	// EventTypeTextInvalid is a EventType enum value
	EventTypeTextInvalid = "TEXT_INVALID"

	// EventTypeTextInvalidMessage is a EventType enum value
	EventTypeTextInvalidMessage = "TEXT_INVALID_MESSAGE"

	// EventTypeTextUnreachable is a EventType enum value
	EventTypeTextUnreachable = "TEXT_UNREACHABLE"

	// EventTypeTextCarrierUnreachable is a EventType enum value
	EventTypeTextCarrierUnreachable = "TEXT_CARRIER_UNREACHABLE"

	// EventTypeTextBlocked is a EventType enum value
	EventTypeTextBlocked = "TEXT_BLOCKED"

	// EventTypeTextCarrierBlocked is a EventType enum value
	EventTypeTextCarrierBlocked = "TEXT_CARRIER_BLOCKED"

	// EventTypeTextSpam is a EventType enum value
	EventTypeTextSpam = "TEXT_SPAM"

	// EventTypeTextUnknown is a EventType enum value
	EventTypeTextUnknown = "TEXT_UNKNOWN"

	// EventTypeTextTtlExpired is a EventType enum value
	EventTypeTextTtlExpired = "TEXT_TTL_EXPIRED"

	// EventTypeVoiceAll is a EventType enum value
	EventTypeVoiceAll = "VOICE_ALL"

	// EventTypeVoiceInitiated is a EventType enum value
	EventTypeVoiceInitiated = "VOICE_INITIATED"

	// EventTypeVoiceRinging is a EventType enum value
	EventTypeVoiceRinging = "VOICE_RINGING"

	// EventTypeVoiceAnswered is a EventType enum value
	EventTypeVoiceAnswered = "VOICE_ANSWERED"

	// EventTypeVoiceCompleted is a EventType enum value
	EventTypeVoiceCompleted = "VOICE_COMPLETED"

	// EventTypeVoiceBusy is a EventType enum value
	EventTypeVoiceBusy = "VOICE_BUSY"

	// EventTypeVoiceNoAnswer is a EventType enum value
	EventTypeVoiceNoAnswer = "VOICE_NO_ANSWER"

	// EventTypeVoiceFailed is a EventType enum value
	EventTypeVoiceFailed = "VOICE_FAILED"

	// EventTypeVoiceTtlExpired is a EventType enum value
	EventTypeVoiceTtlExpired = "VOICE_TTL_EXPIRED"
)

// EventType_Values returns all elements of the EventType enum
func EventType_Values() []string {
	return []string{
		EventTypeAll,
		EventTypeTextAll,
		EventTypeTextSent,
		EventTypeTextPending,
		EventTypeTextQueued,
		EventTypeTextSuccessful,
		EventTypeTextDelivered,
		EventTypeTextInvalid,
		EventTypeTextInvalidMessage,
		EventTypeTextUnreachable,
		EventTypeTextCarrierUnreachable,
		EventTypeTextBlocked,
		EventTypeTextCarrierBlocked,
		EventTypeTextSpam,
		EventTypeTextUnknown,
		EventTypeTextTtlExpired,
		EventTypeVoiceAll,
		EventTypeVoiceInitiated,
		EventTypeVoiceRinging,
		EventTypeVoiceAnswered,
		EventTypeVoiceCompleted,
		EventTypeVoiceBusy,
		EventTypeVoiceNoAnswer,
		EventTypeVoiceFailed,
		EventTypeVoiceTtlExpired,
	}
}

const (
	// KeywordActionAutomaticResponse is a KeywordAction enum value
	KeywordActionAutomaticResponse = "AUTOMATIC_RESPONSE"

	// KeywordActionOptOut is a KeywordAction enum value
	KeywordActionOptOut = "OPT_OUT"

	// KeywordActionOptIn is a KeywordAction enum value
	KeywordActionOptIn = "OPT_IN"
)

// KeywordAction_Values returns all elements of the KeywordAction enum
func KeywordAction_Values() []string {
	return []string{
		KeywordActionAutomaticResponse,
		KeywordActionOptOut,
		KeywordActionOptIn,
	}
}

const (
	// KeywordFilterNameKeywordAction is a KeywordFilterName enum value
	KeywordFilterNameKeywordAction = "keyword-action"
)

// KeywordFilterName_Values returns all elements of the KeywordFilterName enum
func KeywordFilterName_Values() []string {
	return []string{
		KeywordFilterNameKeywordAction,
	}
}

const (
	// MessageTypeTransactional is a MessageType enum value
	MessageTypeTransactional = "TRANSACTIONAL"

	// MessageTypePromotional is a MessageType enum value
	MessageTypePromotional = "PROMOTIONAL"
)

// MessageType_Values returns all elements of the MessageType enum
func MessageType_Values() []string {
	return []string{
		MessageTypeTransactional,
		MessageTypePromotional,
	}
}

const (
	// NumberCapabilitySms is a NumberCapability enum value
	NumberCapabilitySms = "SMS"

	// NumberCapabilityVoice is a NumberCapability enum value
	NumberCapabilityVoice = "VOICE"
)

// NumberCapability_Values returns all elements of the NumberCapability enum
func NumberCapability_Values() []string {
	return []string{
		NumberCapabilitySms,
		NumberCapabilityVoice,
	}
}

const (
	// NumberStatusPending is a NumberStatus enum value
	NumberStatusPending = "PENDING"

	// NumberStatusActive is a NumberStatus enum value
	NumberStatusActive = "ACTIVE"

	// NumberStatusAssociating is a NumberStatus enum value
	NumberStatusAssociating = "ASSOCIATING"

	// NumberStatusDisassociating is a NumberStatus enum value
	NumberStatusDisassociating = "DISASSOCIATING"

	// NumberStatusDeleted is a NumberStatus enum value
	NumberStatusDeleted = "DELETED"
)

// NumberStatus_Values returns all elements of the NumberStatus enum
func NumberStatus_Values() []string {
	return []string{
		NumberStatusPending,
		NumberStatusActive,
		NumberStatusAssociating,
		NumberStatusDisassociating,
		NumberStatusDeleted,
	}
}

const (
	// NumberTypeShortCode is a NumberType enum value
	NumberTypeShortCode = "SHORT_CODE"

	// NumberTypeLongCode is a NumberType enum value
	NumberTypeLongCode = "LONG_CODE"

	// NumberTypeTollFree is a NumberType enum value
	NumberTypeTollFree = "TOLL_FREE"

	// NumberTypeTenDlc is a NumberType enum value
	NumberTypeTenDlc = "TEN_DLC"
)

// NumberType_Values returns all elements of the NumberType enum
func NumberType_Values() []string {
	return []string{
		NumberTypeShortCode,
		NumberTypeLongCode,
		NumberTypeTollFree,
		NumberTypeTenDlc,
	}
}

const (
	// OptedOutFilterNameEndUserOptedOut is a OptedOutFilterName enum value
	OptedOutFilterNameEndUserOptedOut = "end-user-opted-out"
)

// OptedOutFilterName_Values returns all elements of the OptedOutFilterName enum
func OptedOutFilterName_Values() []string {
	return []string{
		OptedOutFilterNameEndUserOptedOut,
	}
}

const (
	// PhoneNumberFilterNameStatus is a PhoneNumberFilterName enum value
	PhoneNumberFilterNameStatus = "status"

	// PhoneNumberFilterNameIsoCountryCode is a PhoneNumberFilterName enum value
	PhoneNumberFilterNameIsoCountryCode = "iso-country-code"

	// PhoneNumberFilterNameMessageType is a PhoneNumberFilterName enum value
	PhoneNumberFilterNameMessageType = "message-type"

	// PhoneNumberFilterNameNumberCapability is a PhoneNumberFilterName enum value
	PhoneNumberFilterNameNumberCapability = "number-capability"

	// PhoneNumberFilterNameNumberType is a PhoneNumberFilterName enum value
	PhoneNumberFilterNameNumberType = "number-type"

	// PhoneNumberFilterNameTwoWayEnabled is a PhoneNumberFilterName enum value
	PhoneNumberFilterNameTwoWayEnabled = "two-way-enabled"

	// PhoneNumberFilterNameSelfManagedOptOutsEnabled is a PhoneNumberFilterName enum value
	PhoneNumberFilterNameSelfManagedOptOutsEnabled = "self-managed-opt-outs-enabled"

	// PhoneNumberFilterNameOptOutListName is a PhoneNumberFilterName enum value
	PhoneNumberFilterNameOptOutListName = "opt-out-list-name"

	// PhoneNumberFilterNameDeletionProtectionEnabled is a PhoneNumberFilterName enum value
	PhoneNumberFilterNameDeletionProtectionEnabled = "deletion-protection-enabled"
)

// PhoneNumberFilterName_Values returns all elements of the PhoneNumberFilterName enum
func PhoneNumberFilterName_Values() []string {
	return []string{
		PhoneNumberFilterNameStatus,
		PhoneNumberFilterNameIsoCountryCode,
		PhoneNumberFilterNameMessageType,
		PhoneNumberFilterNameNumberCapability,
		PhoneNumberFilterNameNumberType,
		PhoneNumberFilterNameTwoWayEnabled,
		PhoneNumberFilterNameSelfManagedOptOutsEnabled,
		PhoneNumberFilterNameOptOutListName,
		PhoneNumberFilterNameDeletionProtectionEnabled,
	}
}

const (
	// PoolFilterNameStatus is a PoolFilterName enum value
	PoolFilterNameStatus = "status"

	// PoolFilterNameMessageType is a PoolFilterName enum value
	PoolFilterNameMessageType = "message-type"

	// PoolFilterNameTwoWayEnabled is a PoolFilterName enum value
	PoolFilterNameTwoWayEnabled = "two-way-enabled"

	// PoolFilterNameSelfManagedOptOutsEnabled is a PoolFilterName enum value
	PoolFilterNameSelfManagedOptOutsEnabled = "self-managed-opt-outs-enabled"

	// PoolFilterNameOptOutListName is a PoolFilterName enum value
	PoolFilterNameOptOutListName = "opt-out-list-name"

	// PoolFilterNameSharedRoutesEnabled is a PoolFilterName enum value
	PoolFilterNameSharedRoutesEnabled = "shared-routes-enabled"

	// PoolFilterNameDeletionProtectionEnabled is a PoolFilterName enum value
	PoolFilterNameDeletionProtectionEnabled = "deletion-protection-enabled"
)

// PoolFilterName_Values returns all elements of the PoolFilterName enum
func PoolFilterName_Values() []string {
	return []string{
		PoolFilterNameStatus,
		PoolFilterNameMessageType,
		PoolFilterNameTwoWayEnabled,
		PoolFilterNameSelfManagedOptOutsEnabled,
		PoolFilterNameOptOutListName,
		PoolFilterNameSharedRoutesEnabled,
		PoolFilterNameDeletionProtectionEnabled,
	}
}

const (
	// PoolOriginationIdentitiesFilterNameIsoCountryCode is a PoolOriginationIdentitiesFilterName enum value
	PoolOriginationIdentitiesFilterNameIsoCountryCode = "iso-country-code"

	// PoolOriginationIdentitiesFilterNameNumberCapability is a PoolOriginationIdentitiesFilterName enum value
	PoolOriginationIdentitiesFilterNameNumberCapability = "number-capability"
)

// PoolOriginationIdentitiesFilterName_Values returns all elements of the PoolOriginationIdentitiesFilterName enum
func PoolOriginationIdentitiesFilterName_Values() []string {
	return []string{
		PoolOriginationIdentitiesFilterNameIsoCountryCode,
		PoolOriginationIdentitiesFilterNameNumberCapability,
	}
}

const (
	// PoolStatusCreating is a PoolStatus enum value
	PoolStatusCreating = "CREATING"

	// PoolStatusActive is a PoolStatus enum value
	PoolStatusActive = "ACTIVE"

	// PoolStatusDeleting is a PoolStatus enum value
	PoolStatusDeleting = "DELETING"
)

// PoolStatus_Values returns all elements of the PoolStatus enum
func PoolStatus_Values() []string {
	return []string{
		PoolStatusCreating,
		PoolStatusActive,
		PoolStatusDeleting,
	}
}

const (
	// RequestableNumberTypeLongCode is a RequestableNumberType enum value
	RequestableNumberTypeLongCode = "LONG_CODE"

	// RequestableNumberTypeTollFree is a RequestableNumberType enum value
	RequestableNumberTypeTollFree = "TOLL_FREE"

	// RequestableNumberTypeTenDlc is a RequestableNumberType enum value
	RequestableNumberTypeTenDlc = "TEN_DLC"
)

// RequestableNumberType_Values returns all elements of the RequestableNumberType enum
func RequestableNumberType_Values() []string {
	return []string{
		RequestableNumberTypeLongCode,
		RequestableNumberTypeTollFree,
		RequestableNumberTypeTenDlc,
	}
}

const (
	// ResourceTypeAccount is a ResourceType enum value
	ResourceTypeAccount = "account"

	// ResourceTypePhoneNumber is a ResourceType enum value
	ResourceTypePhoneNumber = "phone-number"

	// ResourceTypeSenderId is a ResourceType enum value
	ResourceTypeSenderId = "sender-id"

	// ResourceTypePool is a ResourceType enum value
	ResourceTypePool = "pool"

	// ResourceTypeConfigurationSet is a ResourceType enum value
	ResourceTypeConfigurationSet = "configuration-set"

	// ResourceTypeOptOutList is a ResourceType enum value
	ResourceTypeOptOutList = "opt-out-list"

	// ResourceTypeEventDestination is a ResourceType enum value
	ResourceTypeEventDestination = "event-destination"

	// ResourceTypeKeyword is a ResourceType enum value
	ResourceTypeKeyword = "keyword"

	// ResourceTypeOptedOutNumber is a ResourceType enum value
	ResourceTypeOptedOutNumber = "opted-out-number"

	// ResourceTypeRegistration is a ResourceType enum value
	ResourceTypeRegistration = "registration"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeAccount,
		ResourceTypePhoneNumber,
		ResourceTypeSenderId,
		ResourceTypePool,
		ResourceTypeConfigurationSet,
		ResourceTypeOptOutList,
		ResourceTypeEventDestination,
		ResourceTypeKeyword,
		ResourceTypeOptedOutNumber,
		ResourceTypeRegistration,
	}
}

const (
	// SenderIdFilterNameSenderId is a SenderIdFilterName enum value
	SenderIdFilterNameSenderId = "sender-id"

	// SenderIdFilterNameIsoCountryCode is a SenderIdFilterName enum value
	SenderIdFilterNameIsoCountryCode = "iso-country-code"

	// SenderIdFilterNameMessageType is a SenderIdFilterName enum value
	SenderIdFilterNameMessageType = "message-type"
)

// SenderIdFilterName_Values returns all elements of the SenderIdFilterName enum
func SenderIdFilterName_Values() []string {
	return []string{
		SenderIdFilterNameSenderId,
		SenderIdFilterNameIsoCountryCode,
		SenderIdFilterNameMessageType,
	}
}

const (
	// ServiceQuotaExceededExceptionReasonConfigurationSetsPerAccount is a ServiceQuotaExceededExceptionReason enum value
	ServiceQuotaExceededExceptionReasonConfigurationSetsPerAccount = "CONFIGURATION_SETS_PER_ACCOUNT"

	// ServiceQuotaExceededExceptionReasonDailyDestinationCallLimit is a ServiceQuotaExceededExceptionReason enum value
	ServiceQuotaExceededExceptionReasonDailyDestinationCallLimit = "DAILY_DESTINATION_CALL_LIMIT"

	// ServiceQuotaExceededExceptionReasonEventDestinationsPerConfigurationSet is a ServiceQuotaExceededExceptionReason enum value
	ServiceQuotaExceededExceptionReasonEventDestinationsPerConfigurationSet = "EVENT_DESTINATIONS_PER_CONFIGURATION_SET"

	// ServiceQuotaExceededExceptionReasonKeywordsPerPhoneNumber is a ServiceQuotaExceededExceptionReason enum value
	ServiceQuotaExceededExceptionReasonKeywordsPerPhoneNumber = "KEYWORDS_PER_PHONE_NUMBER"

	// ServiceQuotaExceededExceptionReasonKeywordsPerPool is a ServiceQuotaExceededExceptionReason enum value
	ServiceQuotaExceededExceptionReasonKeywordsPerPool = "KEYWORDS_PER_POOL"

	// ServiceQuotaExceededExceptionReasonMonthlySpendLimitReachedForText is a ServiceQuotaExceededExceptionReason enum value
	ServiceQuotaExceededExceptionReasonMonthlySpendLimitReachedForText = "MONTHLY_SPEND_LIMIT_REACHED_FOR_TEXT"

	// ServiceQuotaExceededExceptionReasonMonthlySpendLimitReachedForVoice is a ServiceQuotaExceededExceptionReason enum value
	ServiceQuotaExceededExceptionReasonMonthlySpendLimitReachedForVoice = "MONTHLY_SPEND_LIMIT_REACHED_FOR_VOICE"

	// ServiceQuotaExceededExceptionReasonOptOutListsPerAccount is a ServiceQuotaExceededExceptionReason enum value
	ServiceQuotaExceededExceptionReasonOptOutListsPerAccount = "OPT_OUT_LISTS_PER_ACCOUNT"

	// ServiceQuotaExceededExceptionReasonOriginationIdentitiesPerPool is a ServiceQuotaExceededExceptionReason enum value
	ServiceQuotaExceededExceptionReasonOriginationIdentitiesPerPool = "ORIGINATION_IDENTITIES_PER_POOL"

	// ServiceQuotaExceededExceptionReasonPhoneNumbersPerAccount is a ServiceQuotaExceededExceptionReason enum value
	ServiceQuotaExceededExceptionReasonPhoneNumbersPerAccount = "PHONE_NUMBERS_PER_ACCOUNT"

	// ServiceQuotaExceededExceptionReasonPhoneNumbersPerRegistration is a ServiceQuotaExceededExceptionReason enum value
	ServiceQuotaExceededExceptionReasonPhoneNumbersPerRegistration = "PHONE_NUMBERS_PER_REGISTRATION"

	// ServiceQuotaExceededExceptionReasonPoolsPerAccount is a ServiceQuotaExceededExceptionReason enum value
	ServiceQuotaExceededExceptionReasonPoolsPerAccount = "POOLS_PER_ACCOUNT"

	// ServiceQuotaExceededExceptionReasonTagsPerResource is a ServiceQuotaExceededExceptionReason enum value
	ServiceQuotaExceededExceptionReasonTagsPerResource = "TAGS_PER_RESOURCE"
)

// ServiceQuotaExceededExceptionReason_Values returns all elements of the ServiceQuotaExceededExceptionReason enum
func ServiceQuotaExceededExceptionReason_Values() []string {
	return []string{
		ServiceQuotaExceededExceptionReasonConfigurationSetsPerAccount,
		ServiceQuotaExceededExceptionReasonDailyDestinationCallLimit,
		ServiceQuotaExceededExceptionReasonEventDestinationsPerConfigurationSet,
		ServiceQuotaExceededExceptionReasonKeywordsPerPhoneNumber,
		ServiceQuotaExceededExceptionReasonKeywordsPerPool,
		ServiceQuotaExceededExceptionReasonMonthlySpendLimitReachedForText,
		ServiceQuotaExceededExceptionReasonMonthlySpendLimitReachedForVoice,
		ServiceQuotaExceededExceptionReasonOptOutListsPerAccount,
		ServiceQuotaExceededExceptionReasonOriginationIdentitiesPerPool,
		ServiceQuotaExceededExceptionReasonPhoneNumbersPerAccount,
		ServiceQuotaExceededExceptionReasonPhoneNumbersPerRegistration,
		ServiceQuotaExceededExceptionReasonPoolsPerAccount,
		ServiceQuotaExceededExceptionReasonTagsPerResource,
	}
}

const (
	// SpendLimitNameTextMessageMonthlySpendLimit is a SpendLimitName enum value
	SpendLimitNameTextMessageMonthlySpendLimit = "TEXT_MESSAGE_MONTHLY_SPEND_LIMIT"

	// SpendLimitNameVoiceMessageMonthlySpendLimit is a SpendLimitName enum value
	SpendLimitNameVoiceMessageMonthlySpendLimit = "VOICE_MESSAGE_MONTHLY_SPEND_LIMIT"
)

// SpendLimitName_Values returns all elements of the SpendLimitName enum
func SpendLimitName_Values() []string {
	return []string{
		SpendLimitNameTextMessageMonthlySpendLimit,
		SpendLimitNameVoiceMessageMonthlySpendLimit,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CANNOT_PARSE"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"

	// ValidationExceptionReasonInvalidParameter is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidParameter = "INVALID_PARAMETER"

	// ValidationExceptionReasonInvalidArn is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidArn = "INVALID_ARN"

	// ValidationExceptionReasonInvalidIdentityForDestinationCountry is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidIdentityForDestinationCountry = "INVALID_IDENTITY_FOR_DESTINATION_COUNTRY"

	// ValidationExceptionReasonDestinationCountryBlocked is a ValidationExceptionReason enum value
	ValidationExceptionReasonDestinationCountryBlocked = "DESTINATION_COUNTRY_BLOCKED"

	// ValidationExceptionReasonCannotAddOptedOutNumber is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotAddOptedOutNumber = "CANNOT_ADD_OPTED_OUT_NUMBER"

	// ValidationExceptionReasonCountryCodeMismatch is a ValidationExceptionReason enum value
	ValidationExceptionReasonCountryCodeMismatch = "COUNTRY_CODE_MISMATCH"

	// ValidationExceptionReasonInvalidFilterValues is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidFilterValues = "INVALID_FILTER_VALUES"

	// ValidationExceptionReasonInvalidNextToken is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidNextToken = "INVALID_NEXT_TOKEN"

	// ValidationExceptionReasonMissingParameter is a ValidationExceptionReason enum value
	ValidationExceptionReasonMissingParameter = "MISSING_PARAMETER"

	// ValidationExceptionReasonParametersCannotBeUsedTogether is a ValidationExceptionReason enum value
	ValidationExceptionReasonParametersCannotBeUsedTogether = "PARAMETERS_CANNOT_BE_USED_TOGETHER"

	// ValidationExceptionReasonPhoneNumberCannotBeOptedIn is a ValidationExceptionReason enum value
	ValidationExceptionReasonPhoneNumberCannotBeOptedIn = "PHONE_NUMBER_CANNOT_BE_OPTED_IN"

	// ValidationExceptionReasonPhoneNumberCannotBeReleased is a ValidationExceptionReason enum value
	ValidationExceptionReasonPhoneNumberCannotBeReleased = "PHONE_NUMBER_CANNOT_BE_RELEASED"

	// ValidationExceptionReasonPriceOverThreshold is a ValidationExceptionReason enum value
	ValidationExceptionReasonPriceOverThreshold = "PRICE_OVER_THRESHOLD"

	// ValidationExceptionReasonRequestedSpendLimitHigherThanServiceLimit is a ValidationExceptionReason enum value
	ValidationExceptionReasonRequestedSpendLimitHigherThanServiceLimit = "REQUESTED_SPEND_LIMIT_HIGHER_THAN_SERVICE_LIMIT"

	// ValidationExceptionReasonSenderIdNotRegistered is a ValidationExceptionReason enum value
	ValidationExceptionReasonSenderIdNotRegistered = "SENDER_ID_NOT_REGISTERED"

	// ValidationExceptionReasonSenderIdNotSupported is a ValidationExceptionReason enum value
	ValidationExceptionReasonSenderIdNotSupported = "SENDER_ID_NOT_SUPPORTED"

	// ValidationExceptionReasonTwoWayNotEnabled is a ValidationExceptionReason enum value
	ValidationExceptionReasonTwoWayNotEnabled = "TWO_WAY_NOT_ENABLED"

	// ValidationExceptionReasonTwoWayNotSupportedInCountry is a ValidationExceptionReason enum value
	ValidationExceptionReasonTwoWayNotSupportedInCountry = "TWO_WAY_NOT_SUPPORTED_IN_COUNTRY"

	// ValidationExceptionReasonTwoWayNotSupportedInRegion is a ValidationExceptionReason enum value
	ValidationExceptionReasonTwoWayNotSupportedInRegion = "TWO_WAY_NOT_SUPPORTED_IN_REGION"

	// ValidationExceptionReasonTwoWayTopicNotPresent is a ValidationExceptionReason enum value
	ValidationExceptionReasonTwoWayTopicNotPresent = "TWO_WAY_TOPIC_NOT_PRESENT"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
		ValidationExceptionReasonInvalidParameter,
		ValidationExceptionReasonInvalidArn,
		ValidationExceptionReasonInvalidIdentityForDestinationCountry,
		ValidationExceptionReasonDestinationCountryBlocked,
		ValidationExceptionReasonCannotAddOptedOutNumber,
		ValidationExceptionReasonCountryCodeMismatch,
		ValidationExceptionReasonInvalidFilterValues,
		ValidationExceptionReasonInvalidNextToken,
		ValidationExceptionReasonMissingParameter,
		ValidationExceptionReasonParametersCannotBeUsedTogether,
		ValidationExceptionReasonPhoneNumberCannotBeOptedIn,
		ValidationExceptionReasonPhoneNumberCannotBeReleased,
		ValidationExceptionReasonPriceOverThreshold,
		ValidationExceptionReasonRequestedSpendLimitHigherThanServiceLimit,
		ValidationExceptionReasonSenderIdNotRegistered,
		ValidationExceptionReasonSenderIdNotSupported,
		ValidationExceptionReasonTwoWayNotEnabled,
		ValidationExceptionReasonTwoWayNotSupportedInCountry,
		ValidationExceptionReasonTwoWayNotSupportedInRegion,
		ValidationExceptionReasonTwoWayTopicNotPresent,
	}
}

const (
	// VoiceIdAmy is a VoiceId enum value
	VoiceIdAmy = "AMY"

	// VoiceIdAstrid is a VoiceId enum value
	VoiceIdAstrid = "ASTRID"

	// VoiceIdBianca is a VoiceId enum value
	VoiceIdBianca = "BIANCA"

	// VoiceIdBrian is a VoiceId enum value
	VoiceIdBrian = "BRIAN"

	// VoiceIdCamila is a VoiceId enum value
	VoiceIdCamila = "CAMILA"

	// VoiceIdCarla is a VoiceId enum value
	VoiceIdCarla = "CARLA"

	// VoiceIdCarmen is a VoiceId enum value
	VoiceIdCarmen = "CARMEN"

	// VoiceIdCeline is a VoiceId enum value
	VoiceIdCeline = "CELINE"

	// VoiceIdChantal is a VoiceId enum value
	VoiceIdChantal = "CHANTAL"

	// VoiceIdConchita is a VoiceId enum value
	VoiceIdConchita = "CONCHITA"

	// VoiceIdCristiano is a VoiceId enum value
	VoiceIdCristiano = "CRISTIANO"

	// VoiceIdDora is a VoiceId enum value
	VoiceIdDora = "DORA"

	// VoiceIdEmma is a VoiceId enum value
	VoiceIdEmma = "EMMA"

	// VoiceIdEnrique is a VoiceId enum value
	VoiceIdEnrique = "ENRIQUE"

	// VoiceIdEwa is a VoiceId enum value
	VoiceIdEwa = "EWA"

	// VoiceIdFiliz is a VoiceId enum value
	VoiceIdFiliz = "FILIZ"

	// VoiceIdGeraint is a VoiceId enum value
	VoiceIdGeraint = "GERAINT"

	// VoiceIdGiorgio is a VoiceId enum value
	VoiceIdGiorgio = "GIORGIO"

	// VoiceIdGwyneth is a VoiceId enum value
	VoiceIdGwyneth = "GWYNETH"

	// VoiceIdHans is a VoiceId enum value
	VoiceIdHans = "HANS"

	// VoiceIdInes is a VoiceId enum value
	VoiceIdInes = "INES"

	// VoiceIdIvy is a VoiceId enum value
	VoiceIdIvy = "IVY"

	// VoiceIdJacek is a VoiceId enum value
	VoiceIdJacek = "JACEK"

	// VoiceIdJan is a VoiceId enum value
	VoiceIdJan = "JAN"

	// VoiceIdJoanna is a VoiceId enum value
	VoiceIdJoanna = "JOANNA"

	// VoiceIdJoey is a VoiceId enum value
	VoiceIdJoey = "JOEY"

	// VoiceIdJustin is a VoiceId enum value
	VoiceIdJustin = "JUSTIN"

	// VoiceIdKarl is a VoiceId enum value
	VoiceIdKarl = "KARL"

	// VoiceIdKendra is a VoiceId enum value
	VoiceIdKendra = "KENDRA"

	// VoiceIdKimberly is a VoiceId enum value
	VoiceIdKimberly = "KIMBERLY"

	// VoiceIdLea is a VoiceId enum value
	VoiceIdLea = "LEA"

	// VoiceIdLiv is a VoiceId enum value
	VoiceIdLiv = "LIV"

	// VoiceIdLotte is a VoiceId enum value
	VoiceIdLotte = "LOTTE"

	// VoiceIdLucia is a VoiceId enum value
	VoiceIdLucia = "LUCIA"

	// VoiceIdLupe is a VoiceId enum value
	VoiceIdLupe = "LUPE"

	// VoiceIdMads is a VoiceId enum value
	VoiceIdMads = "MADS"

	// VoiceIdMaja is a VoiceId enum value
	VoiceIdMaja = "MAJA"

	// VoiceIdMarlene is a VoiceId enum value
	VoiceIdMarlene = "MARLENE"

	// VoiceIdMathieu is a VoiceId enum value
	VoiceIdMathieu = "MATHIEU"

	// VoiceIdMatthew is a VoiceId enum value
	VoiceIdMatthew = "MATTHEW"

	// VoiceIdMaxim is a VoiceId enum value
	VoiceIdMaxim = "MAXIM"

	// VoiceIdMia is a VoiceId enum value
	VoiceIdMia = "MIA"

	// VoiceIdMiguel is a VoiceId enum value
	VoiceIdMiguel = "MIGUEL"

	// VoiceIdMizuki is a VoiceId enum value
	VoiceIdMizuki = "MIZUKI"

	// VoiceIdNaja is a VoiceId enum value
	VoiceIdNaja = "NAJA"

	// VoiceIdNicole is a VoiceId enum value
	VoiceIdNicole = "NICOLE"

	// VoiceIdPenelope is a VoiceId enum value
	VoiceIdPenelope = "PENELOPE"

	// VoiceIdRaveena is a VoiceId enum value
	VoiceIdRaveena = "RAVEENA"

	// VoiceIdRicardo is a VoiceId enum value
	VoiceIdRicardo = "RICARDO"

	// VoiceIdRuben is a VoiceId enum value
	VoiceIdRuben = "RUBEN"

	// VoiceIdRussell is a VoiceId enum value
	VoiceIdRussell = "RUSSELL"

	// VoiceIdSalli is a VoiceId enum value
	VoiceIdSalli = "SALLI"

	// VoiceIdSeoyeon is a VoiceId enum value
	VoiceIdSeoyeon = "SEOYEON"

	// VoiceIdTakumi is a VoiceId enum value
	VoiceIdTakumi = "TAKUMI"

	// VoiceIdTatyana is a VoiceId enum value
	VoiceIdTatyana = "TATYANA"

	// VoiceIdVicki is a VoiceId enum value
	VoiceIdVicki = "VICKI"

	// VoiceIdVitoria is a VoiceId enum value
	VoiceIdVitoria = "VITORIA"

	// VoiceIdZeina is a VoiceId enum value
	VoiceIdZeina = "ZEINA"

	// VoiceIdZhiyu is a VoiceId enum value
	VoiceIdZhiyu = "ZHIYU"
)

// VoiceId_Values returns all elements of the VoiceId enum
func VoiceId_Values() []string {
	return []string{
		VoiceIdAmy,
		VoiceIdAstrid,
		VoiceIdBianca,
		VoiceIdBrian,
		VoiceIdCamila,
		VoiceIdCarla,
		VoiceIdCarmen,
		VoiceIdCeline,
		VoiceIdChantal,
		VoiceIdConchita,
		VoiceIdCristiano,
		VoiceIdDora,
		VoiceIdEmma,
		VoiceIdEnrique,
		VoiceIdEwa,
		VoiceIdFiliz,
		VoiceIdGeraint,
		VoiceIdGiorgio,
		VoiceIdGwyneth,
		VoiceIdHans,
		VoiceIdInes,
		VoiceIdIvy,
		VoiceIdJacek,
		VoiceIdJan,
		VoiceIdJoanna,
		VoiceIdJoey,
		VoiceIdJustin,
		VoiceIdKarl,
		VoiceIdKendra,
		VoiceIdKimberly,
		VoiceIdLea,
		VoiceIdLiv,
		VoiceIdLotte,
		VoiceIdLucia,
		VoiceIdLupe,
		VoiceIdMads,
		VoiceIdMaja,
		VoiceIdMarlene,
		VoiceIdMathieu,
		VoiceIdMatthew,
		VoiceIdMaxim,
		VoiceIdMia,
		VoiceIdMiguel,
		VoiceIdMizuki,
		VoiceIdNaja,
		VoiceIdNicole,
		VoiceIdPenelope,
		VoiceIdRaveena,
		VoiceIdRicardo,
		VoiceIdRuben,
		VoiceIdRussell,
		VoiceIdSalli,
		VoiceIdSeoyeon,
		VoiceIdTakumi,
		VoiceIdTatyana,
		VoiceIdVicki,
		VoiceIdVitoria,
		VoiceIdZeina,
		VoiceIdZhiyu,
	}
}

const (
	// VoiceMessageBodyTextTypeText is a VoiceMessageBodyTextType enum value
	VoiceMessageBodyTextTypeText = "TEXT"

	// VoiceMessageBodyTextTypeSsml is a VoiceMessageBodyTextType enum value
	VoiceMessageBodyTextTypeSsml = "SSML"
)

// VoiceMessageBodyTextType_Values returns all elements of the VoiceMessageBodyTextType enum
func VoiceMessageBodyTextType_Values() []string {
	return []string{
		VoiceMessageBodyTextTypeText,
		VoiceMessageBodyTextTypeSsml,
	}
}
