// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptAdministratorInvitation = "AcceptAdministratorInvitation"

// AcceptAdministratorInvitationRequest generates a "aws/request.Request" representing the
// client's request for the AcceptAdministratorInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptAdministratorInvitation for more information on using the AcceptAdministratorInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptAdministratorInvitationRequest method.
//    req, resp := client.AcceptAdministratorInvitationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptAdministratorInvitation
func (c *SecurityHub) AcceptAdministratorInvitationRequest(input *AcceptAdministratorInvitationInput) (req *request.Request, output *AcceptAdministratorInvitationOutput) {
	op := &request.Operation{
		Name:       opAcceptAdministratorInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/administrator",
	}

	if input == nil {
		input = &AcceptAdministratorInvitationInput{}
	}

	output = &AcceptAdministratorInvitationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcceptAdministratorInvitation API operation for AWS SecurityHub.
//
// Accepts the invitation to be a member account and be monitored by the Security
// Hub administrator account that the invitation was sent from.
//
// This operation is only used by member accounts that are not added through
// Organizations.
//
// When the member account accepts the invitation, permission is granted to
// the administrator account to view findings generated in the member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation AcceptAdministratorInvitation for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptAdministratorInvitation
func (c *SecurityHub) AcceptAdministratorInvitation(input *AcceptAdministratorInvitationInput) (*AcceptAdministratorInvitationOutput, error) {
	req, out := c.AcceptAdministratorInvitationRequest(input)
	return out, req.Send()
}

// AcceptAdministratorInvitationWithContext is the same as AcceptAdministratorInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptAdministratorInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) AcceptAdministratorInvitationWithContext(ctx aws.Context, input *AcceptAdministratorInvitationInput, opts ...request.Option) (*AcceptAdministratorInvitationOutput, error) {
	req, out := c.AcceptAdministratorInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAcceptInvitation = "AcceptInvitation"

// AcceptInvitationRequest generates a "aws/request.Request" representing the
// client's request for the AcceptInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptInvitation for more information on using the AcceptInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptInvitationRequest method.
//    req, resp := client.AcceptInvitationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptInvitation
//
// Deprecated: This API has been deprecated, use AcceptAdministratorInvitation API instead.
func (c *SecurityHub) AcceptInvitationRequest(input *AcceptInvitationInput) (req *request.Request, output *AcceptInvitationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, AcceptInvitation, has been deprecated")
	}
	op := &request.Operation{
		Name:       opAcceptInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/master",
	}

	if input == nil {
		input = &AcceptInvitationInput{}
	}

	output = &AcceptInvitationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcceptInvitation API operation for AWS SecurityHub.
//
// This method is deprecated. Instead, use AcceptAdministratorInvitation.
//
// The Security Hub console continues to use AcceptInvitation. It will eventually
// change to use AcceptAdministratorInvitation. Any IAM policies that specifically
// control access to this function must continue to use AcceptInvitation. You
// should also add AcceptAdministratorInvitation to your policies to ensure
// that the correct permissions are in place after the console begins to use
// AcceptAdministratorInvitation.
//
// Accepts the invitation to be a member account and be monitored by the Security
// Hub administrator account that the invitation was sent from.
//
// This operation is only used by member accounts that are not added through
// Organizations.
//
// When the member account accepts the invitation, permission is granted to
// the administrator account to view findings generated in the member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation AcceptInvitation for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptInvitation
//
// Deprecated: This API has been deprecated, use AcceptAdministratorInvitation API instead.
func (c *SecurityHub) AcceptInvitation(input *AcceptInvitationInput) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	return out, req.Send()
}

// AcceptInvitationWithContext is the same as AcceptInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: This API has been deprecated, use AcceptAdministratorInvitation API instead.
func (c *SecurityHub) AcceptInvitationWithContext(ctx aws.Context, input *AcceptInvitationInput, opts ...request.Option) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDisableStandards = "BatchDisableStandards"

// BatchDisableStandardsRequest generates a "aws/request.Request" representing the
// client's request for the BatchDisableStandards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDisableStandards for more information on using the BatchDisableStandards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDisableStandardsRequest method.
//    req, resp := client.BatchDisableStandardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDisableStandards
func (c *SecurityHub) BatchDisableStandardsRequest(input *BatchDisableStandardsInput) (req *request.Request, output *BatchDisableStandardsOutput) {
	op := &request.Operation{
		Name:       opBatchDisableStandards,
		HTTPMethod: "POST",
		HTTPPath:   "/standards/deregister",
	}

	if input == nil {
		input = &BatchDisableStandardsInput{}
	}

	output = &BatchDisableStandardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDisableStandards API operation for AWS SecurityHub.
//
// Disables the standards specified by the provided StandardsSubscriptionArns.
//
// For more information, see Security Standards (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html)
// section of the Security Hub User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchDisableStandards for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDisableStandards
func (c *SecurityHub) BatchDisableStandards(input *BatchDisableStandardsInput) (*BatchDisableStandardsOutput, error) {
	req, out := c.BatchDisableStandardsRequest(input)
	return out, req.Send()
}

// BatchDisableStandardsWithContext is the same as BatchDisableStandards with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDisableStandards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchDisableStandardsWithContext(ctx aws.Context, input *BatchDisableStandardsInput, opts ...request.Option) (*BatchDisableStandardsOutput, error) {
	req, out := c.BatchDisableStandardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchEnableStandards = "BatchEnableStandards"

// BatchEnableStandardsRequest generates a "aws/request.Request" representing the
// client's request for the BatchEnableStandards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchEnableStandards for more information on using the BatchEnableStandards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchEnableStandardsRequest method.
//    req, resp := client.BatchEnableStandardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchEnableStandards
func (c *SecurityHub) BatchEnableStandardsRequest(input *BatchEnableStandardsInput) (req *request.Request, output *BatchEnableStandardsOutput) {
	op := &request.Operation{
		Name:       opBatchEnableStandards,
		HTTPMethod: "POST",
		HTTPPath:   "/standards/register",
	}

	if input == nil {
		input = &BatchEnableStandardsInput{}
	}

	output = &BatchEnableStandardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchEnableStandards API operation for AWS SecurityHub.
//
// Enables the standards specified by the provided StandardsArn. To obtain the
// ARN for a standard, use the DescribeStandards operation.
//
// For more information, see the Security Standards (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html)
// section of the Security Hub User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchEnableStandards for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchEnableStandards
func (c *SecurityHub) BatchEnableStandards(input *BatchEnableStandardsInput) (*BatchEnableStandardsOutput, error) {
	req, out := c.BatchEnableStandardsRequest(input)
	return out, req.Send()
}

// BatchEnableStandardsWithContext is the same as BatchEnableStandards with the addition of
// the ability to pass a context and additional request options.
//
// See BatchEnableStandards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchEnableStandardsWithContext(ctx aws.Context, input *BatchEnableStandardsInput, opts ...request.Option) (*BatchEnableStandardsOutput, error) {
	req, out := c.BatchEnableStandardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchImportFindings = "BatchImportFindings"

// BatchImportFindingsRequest generates a "aws/request.Request" representing the
// client's request for the BatchImportFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchImportFindings for more information on using the BatchImportFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchImportFindingsRequest method.
//    req, resp := client.BatchImportFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchImportFindings
func (c *SecurityHub) BatchImportFindingsRequest(input *BatchImportFindingsInput) (req *request.Request, output *BatchImportFindingsOutput) {
	op := &request.Operation{
		Name:       opBatchImportFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/findings/import",
	}

	if input == nil {
		input = &BatchImportFindingsInput{}
	}

	output = &BatchImportFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchImportFindings API operation for AWS SecurityHub.
//
// Imports security findings generated by a finding provider into Security Hub.
// This action is requested by the finding provider to import its findings into
// Security Hub.
//
// BatchImportFindings must be called by one of the following:
//
//    * The account that is associated with the findings. The identifier of
//    the associated account is the value of the AwsAccountId attribute for
//    the finding.
//
//    * An account that is allow-listed for an official Security Hub partner
//    integration.
//
// The maximum allowed size for a finding is 240 Kb. An error is returned for
// any finding larger than 240 Kb.
//
// After a finding is created, BatchImportFindings cannot be used to update
// the following finding fields and objects, which Security Hub customers use
// to manage their investigation workflow.
//
//    * Note
//
//    * UserDefinedFields
//
//    * VerificationState
//
//    * Workflow
//
// Finding providers also should not use BatchImportFindings to update the following
// attributes.
//
//    * Confidence
//
//    * Criticality
//
//    * RelatedFindings
//
//    * Severity
//
//    * Types
//
// Instead, finding providers use FindingProviderFields to provide values for
// these attributes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchImportFindings for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchImportFindings
func (c *SecurityHub) BatchImportFindings(input *BatchImportFindingsInput) (*BatchImportFindingsOutput, error) {
	req, out := c.BatchImportFindingsRequest(input)
	return out, req.Send()
}

// BatchImportFindingsWithContext is the same as BatchImportFindings with the addition of
// the ability to pass a context and additional request options.
//
// See BatchImportFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchImportFindingsWithContext(ctx aws.Context, input *BatchImportFindingsInput, opts ...request.Option) (*BatchImportFindingsOutput, error) {
	req, out := c.BatchImportFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateFindings = "BatchUpdateFindings"

// BatchUpdateFindingsRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateFindings for more information on using the BatchUpdateFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchUpdateFindingsRequest method.
//    req, resp := client.BatchUpdateFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateFindings
func (c *SecurityHub) BatchUpdateFindingsRequest(input *BatchUpdateFindingsInput) (req *request.Request, output *BatchUpdateFindingsOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateFindings,
		HTTPMethod: "PATCH",
		HTTPPath:   "/findings/batchupdate",
	}

	if input == nil {
		input = &BatchUpdateFindingsInput{}
	}

	output = &BatchUpdateFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateFindings API operation for AWS SecurityHub.
//
// Used by Security Hub customers to update information about their investigation
// into a finding. Requested by administrator accounts or member accounts. Administrator
// accounts can update findings for their account and their member accounts.
// Member accounts can update findings for their account.
//
// Updates from BatchUpdateFindings do not affect the value of UpdatedAt for
// a finding.
//
// Administrator and member accounts can use BatchUpdateFindings to update the
// following finding fields and objects.
//
//    * Confidence
//
//    * Criticality
//
//    * Note
//
//    * RelatedFindings
//
//    * Severity
//
//    * Types
//
//    * UserDefinedFields
//
//    * VerificationState
//
//    * Workflow
//
// You can configure IAM policies to restrict access to fields and field values.
// For example, you might not want member accounts to be able to suppress findings
// or change the finding severity. See Configuring access to BatchUpdateFindings
// (https://docs.aws.amazon.com/securityhub/latest/userguide/finding-update-batchupdatefindings.html#batchupdatefindings-configure-access)
// in the Security Hub User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchUpdateFindings for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateFindings
func (c *SecurityHub) BatchUpdateFindings(input *BatchUpdateFindingsInput) (*BatchUpdateFindingsOutput, error) {
	req, out := c.BatchUpdateFindingsRequest(input)
	return out, req.Send()
}

// BatchUpdateFindingsWithContext is the same as BatchUpdateFindings with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchUpdateFindingsWithContext(ctx aws.Context, input *BatchUpdateFindingsInput, opts ...request.Option) (*BatchUpdateFindingsOutput, error) {
	req, out := c.BatchUpdateFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateActionTarget = "CreateActionTarget"

// CreateActionTargetRequest generates a "aws/request.Request" representing the
// client's request for the CreateActionTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateActionTarget for more information on using the CreateActionTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateActionTargetRequest method.
//    req, resp := client.CreateActionTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateActionTarget
func (c *SecurityHub) CreateActionTargetRequest(input *CreateActionTargetInput) (req *request.Request, output *CreateActionTargetOutput) {
	op := &request.Operation{
		Name:       opCreateActionTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/actionTargets",
	}

	if input == nil {
		input = &CreateActionTargetInput{}
	}

	output = &CreateActionTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateActionTarget API operation for AWS SecurityHub.
//
// Creates a custom action target in Security Hub.
//
// You can use custom actions on findings and insights in Security Hub to trigger
// target actions in Amazon CloudWatch Events.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation CreateActionTarget for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * ResourceConflictException
//   The resource specified in the request conflicts with an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateActionTarget
func (c *SecurityHub) CreateActionTarget(input *CreateActionTargetInput) (*CreateActionTargetOutput, error) {
	req, out := c.CreateActionTargetRequest(input)
	return out, req.Send()
}

// CreateActionTargetWithContext is the same as CreateActionTarget with the addition of
// the ability to pass a context and additional request options.
//
// See CreateActionTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) CreateActionTargetWithContext(ctx aws.Context, input *CreateActionTargetInput, opts ...request.Option) (*CreateActionTargetOutput, error) {
	req, out := c.CreateActionTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFindingAggregator = "CreateFindingAggregator"

// CreateFindingAggregatorRequest generates a "aws/request.Request" representing the
// client's request for the CreateFindingAggregator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFindingAggregator for more information on using the CreateFindingAggregator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFindingAggregatorRequest method.
//    req, resp := client.CreateFindingAggregatorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateFindingAggregator
func (c *SecurityHub) CreateFindingAggregatorRequest(input *CreateFindingAggregatorInput) (req *request.Request, output *CreateFindingAggregatorOutput) {
	op := &request.Operation{
		Name:       opCreateFindingAggregator,
		HTTPMethod: "POST",
		HTTPPath:   "/findingAggregator/create",
	}

	if input == nil {
		input = &CreateFindingAggregatorInput{}
	}

	output = &CreateFindingAggregatorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFindingAggregator API operation for AWS SecurityHub.
//
// Used to enable finding aggregation. Must be called from the aggregation Region.
//
// For more details about cross-Region replication, see Configuring finding
// aggregation (securityhub/latest/userguide/finding-aggregation.html) in the
// Security Hub User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation CreateFindingAggregator for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * AccessDeniedException
//   You don't have permission to perform the action specified in the request.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateFindingAggregator
func (c *SecurityHub) CreateFindingAggregator(input *CreateFindingAggregatorInput) (*CreateFindingAggregatorOutput, error) {
	req, out := c.CreateFindingAggregatorRequest(input)
	return out, req.Send()
}

// CreateFindingAggregatorWithContext is the same as CreateFindingAggregator with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFindingAggregator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) CreateFindingAggregatorWithContext(ctx aws.Context, input *CreateFindingAggregatorInput, opts ...request.Option) (*CreateFindingAggregatorOutput, error) {
	req, out := c.CreateFindingAggregatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInsight = "CreateInsight"

// CreateInsightRequest generates a "aws/request.Request" representing the
// client's request for the CreateInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInsight for more information on using the CreateInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInsightRequest method.
//    req, resp := client.CreateInsightRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight
func (c *SecurityHub) CreateInsightRequest(input *CreateInsightInput) (req *request.Request, output *CreateInsightOutput) {
	op := &request.Operation{
		Name:       opCreateInsight,
		HTTPMethod: "POST",
		HTTPPath:   "/insights",
	}

	if input == nil {
		input = &CreateInsightInput{}
	}

	output = &CreateInsightOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInsight API operation for AWS SecurityHub.
//
// Creates a custom insight in Security Hub. An insight is a consolidation of
// findings that relate to a security issue that requires attention or remediation.
//
// To group the related findings in the insight, use the GroupByAttribute.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation CreateInsight for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceConflictException
//   The resource specified in the request conflicts with an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight
func (c *SecurityHub) CreateInsight(input *CreateInsightInput) (*CreateInsightOutput, error) {
	req, out := c.CreateInsightRequest(input)
	return out, req.Send()
}

// CreateInsightWithContext is the same as CreateInsight with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) CreateInsightWithContext(ctx aws.Context, input *CreateInsightInput, opts ...request.Option) (*CreateInsightOutput, error) {
	req, out := c.CreateInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMembers = "CreateMembers"

// CreateMembersRequest generates a "aws/request.Request" representing the
// client's request for the CreateMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMembers for more information on using the CreateMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMembersRequest method.
//    req, resp := client.CreateMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateMembers
func (c *SecurityHub) CreateMembersRequest(input *CreateMembersInput) (req *request.Request, output *CreateMembersOutput) {
	op := &request.Operation{
		Name:       opCreateMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members",
	}

	if input == nil {
		input = &CreateMembersInput{}
	}

	output = &CreateMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMembers API operation for AWS SecurityHub.
//
// Creates a member association in Security Hub between the specified accounts
// and the account used to make the request, which is the administrator account.
// If you are integrated with Organizations, then the administrator account
// is designated by the organization management account.
//
// CreateMembers is always used to add accounts that are not organization members.
//
// For accounts that are managed using Organizations, CreateMembers is only
// used in the following cases:
//
//    * Security Hub is not configured to automatically add new organization
//    accounts.
//
//    * The account was disassociated or deleted in Security Hub.
//
// This action can only be used by an account that has Security Hub enabled.
// To enable Security Hub, you can use the EnableSecurityHub operation.
//
// For accounts that are not organization members, you create the account association
// and then send an invitation to the member account. To send the invitation,
// you use the InviteMembers operation. If the account owner accepts the invitation,
// the account becomes a member account in Security Hub.
//
// Accounts that are managed using Organizations do not receive an invitation.
// They automatically become a member account in Security Hub.
//
//    * If the organization account does not have Security Hub enabled, then
//    Security Hub and the default standards are automatically enabled. Note
//    that Security Hub cannot be enabled automatically for the organization
//    management account. The organization management account must enable Security
//    Hub before the administrator account enables it as a member account.
//
//    * For organization accounts that already have Security Hub enabled, Security
//    Hub does not make any other changes to those accounts. It does not change
//    their enabled standards or controls.
//
// A permissions policy is added that permits the administrator account to view
// the findings generated in the member account.
//
// To remove the association between the administrator and member accounts,
// use the DisassociateFromMasterAccount or DisassociateMembers operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation CreateMembers for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceConflictException
//   The resource specified in the request conflicts with an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateMembers
func (c *SecurityHub) CreateMembers(input *CreateMembersInput) (*CreateMembersOutput, error) {
	req, out := c.CreateMembersRequest(input)
	return out, req.Send()
}

// CreateMembersWithContext is the same as CreateMembers with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) CreateMembersWithContext(ctx aws.Context, input *CreateMembersInput, opts ...request.Option) (*CreateMembersOutput, error) {
	req, out := c.CreateMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeclineInvitations = "DeclineInvitations"

// DeclineInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the DeclineInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeclineInvitations for more information on using the DeclineInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeclineInvitationsRequest method.
//    req, resp := client.DeclineInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeclineInvitations
func (c *SecurityHub) DeclineInvitationsRequest(input *DeclineInvitationsInput) (req *request.Request, output *DeclineInvitationsOutput) {
	op := &request.Operation{
		Name:       opDeclineInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitations/decline",
	}

	if input == nil {
		input = &DeclineInvitationsInput{}
	}

	output = &DeclineInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeclineInvitations API operation for AWS SecurityHub.
//
// Declines invitations to become a member account.
//
// This operation is only used by accounts that are not part of an organization.
// Organization accounts do not receive invitations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeclineInvitations for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeclineInvitations
func (c *SecurityHub) DeclineInvitations(input *DeclineInvitationsInput) (*DeclineInvitationsOutput, error) {
	req, out := c.DeclineInvitationsRequest(input)
	return out, req.Send()
}

// DeclineInvitationsWithContext is the same as DeclineInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See DeclineInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeclineInvitationsWithContext(ctx aws.Context, input *DeclineInvitationsInput, opts ...request.Option) (*DeclineInvitationsOutput, error) {
	req, out := c.DeclineInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteActionTarget = "DeleteActionTarget"

// DeleteActionTargetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteActionTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteActionTarget for more information on using the DeleteActionTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteActionTargetRequest method.
//    req, resp := client.DeleteActionTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteActionTarget
func (c *SecurityHub) DeleteActionTargetRequest(input *DeleteActionTargetInput) (req *request.Request, output *DeleteActionTargetOutput) {
	op := &request.Operation{
		Name:       opDeleteActionTarget,
		HTTPMethod: "DELETE",
		HTTPPath:   "/actionTargets/{ActionTargetArn+}",
	}

	if input == nil {
		input = &DeleteActionTargetInput{}
	}

	output = &DeleteActionTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteActionTarget API operation for AWS SecurityHub.
//
// Deletes a custom action target from Security Hub.
//
// Deleting a custom action target does not affect any findings or insights
// that were already sent to Amazon CloudWatch Events using the custom action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteActionTarget for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteActionTarget
func (c *SecurityHub) DeleteActionTarget(input *DeleteActionTargetInput) (*DeleteActionTargetOutput, error) {
	req, out := c.DeleteActionTargetRequest(input)
	return out, req.Send()
}

// DeleteActionTargetWithContext is the same as DeleteActionTarget with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteActionTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteActionTargetWithContext(ctx aws.Context, input *DeleteActionTargetInput, opts ...request.Option) (*DeleteActionTargetOutput, error) {
	req, out := c.DeleteActionTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFindingAggregator = "DeleteFindingAggregator"

// DeleteFindingAggregatorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFindingAggregator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFindingAggregator for more information on using the DeleteFindingAggregator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFindingAggregatorRequest method.
//    req, resp := client.DeleteFindingAggregatorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteFindingAggregator
func (c *SecurityHub) DeleteFindingAggregatorRequest(input *DeleteFindingAggregatorInput) (req *request.Request, output *DeleteFindingAggregatorOutput) {
	op := &request.Operation{
		Name:       opDeleteFindingAggregator,
		HTTPMethod: "DELETE",
		HTTPPath:   "/findingAggregator/delete/{FindingAggregatorArn+}",
	}

	if input == nil {
		input = &DeleteFindingAggregatorInput{}
	}

	output = &DeleteFindingAggregatorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFindingAggregator API operation for AWS SecurityHub.
//
// Deletes a finding aggregator. When you delete the finding aggregator, you
// stop finding aggregation.
//
// When you stop finding aggregation, findings that were already aggregated
// to the aggregation Region are still visible from the aggregation Region.
// New findings and finding updates are not aggregated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteFindingAggregator for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * AccessDeniedException
//   You don't have permission to perform the action specified in the request.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteFindingAggregator
func (c *SecurityHub) DeleteFindingAggregator(input *DeleteFindingAggregatorInput) (*DeleteFindingAggregatorOutput, error) {
	req, out := c.DeleteFindingAggregatorRequest(input)
	return out, req.Send()
}

// DeleteFindingAggregatorWithContext is the same as DeleteFindingAggregator with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFindingAggregator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteFindingAggregatorWithContext(ctx aws.Context, input *DeleteFindingAggregatorInput, opts ...request.Option) (*DeleteFindingAggregatorOutput, error) {
	req, out := c.DeleteFindingAggregatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInsight = "DeleteInsight"

// DeleteInsightRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInsight for more information on using the DeleteInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInsightRequest method.
//    req, resp := client.DeleteInsightRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInsight
func (c *SecurityHub) DeleteInsightRequest(input *DeleteInsightInput) (req *request.Request, output *DeleteInsightOutput) {
	op := &request.Operation{
		Name:       opDeleteInsight,
		HTTPMethod: "DELETE",
		HTTPPath:   "/insights/{InsightArn+}",
	}

	if input == nil {
		input = &DeleteInsightInput{}
	}

	output = &DeleteInsightOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInsight API operation for AWS SecurityHub.
//
// Deletes the insight specified by the InsightArn.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteInsight for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInsight
func (c *SecurityHub) DeleteInsight(input *DeleteInsightInput) (*DeleteInsightOutput, error) {
	req, out := c.DeleteInsightRequest(input)
	return out, req.Send()
}

// DeleteInsightWithContext is the same as DeleteInsight with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteInsightWithContext(ctx aws.Context, input *DeleteInsightInput, opts ...request.Option) (*DeleteInsightOutput, error) {
	req, out := c.DeleteInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInvitations = "DeleteInvitations"

// DeleteInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInvitations for more information on using the DeleteInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInvitationsRequest method.
//    req, resp := client.DeleteInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInvitations
func (c *SecurityHub) DeleteInvitationsRequest(input *DeleteInvitationsInput) (req *request.Request, output *DeleteInvitationsOutput) {
	op := &request.Operation{
		Name:       opDeleteInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitations/delete",
	}

	if input == nil {
		input = &DeleteInvitationsInput{}
	}

	output = &DeleteInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInvitations API operation for AWS SecurityHub.
//
// Deletes invitations received by the Amazon Web Services account to become
// a member account.
//
// This operation is only used by accounts that are not part of an organization.
// Organization accounts do not receive invitations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteInvitations for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInvitations
func (c *SecurityHub) DeleteInvitations(input *DeleteInvitationsInput) (*DeleteInvitationsOutput, error) {
	req, out := c.DeleteInvitationsRequest(input)
	return out, req.Send()
}

// DeleteInvitationsWithContext is the same as DeleteInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteInvitationsWithContext(ctx aws.Context, input *DeleteInvitationsInput, opts ...request.Option) (*DeleteInvitationsOutput, error) {
	req, out := c.DeleteInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMembers = "DeleteMembers"

// DeleteMembersRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMembers for more information on using the DeleteMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMembersRequest method.
//    req, resp := client.DeleteMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteMembers
func (c *SecurityHub) DeleteMembersRequest(input *DeleteMembersInput) (req *request.Request, output *DeleteMembersOutput) {
	op := &request.Operation{
		Name:       opDeleteMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/delete",
	}

	if input == nil {
		input = &DeleteMembersInput{}
	}

	output = &DeleteMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMembers API operation for AWS SecurityHub.
//
// Deletes the specified member accounts from Security Hub.
//
// Can be used to delete member accounts that belong to an organization as well
// as member accounts that were invited manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteMembers for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteMembers
func (c *SecurityHub) DeleteMembers(input *DeleteMembersInput) (*DeleteMembersOutput, error) {
	req, out := c.DeleteMembersRequest(input)
	return out, req.Send()
}

// DeleteMembersWithContext is the same as DeleteMembers with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteMembersWithContext(ctx aws.Context, input *DeleteMembersInput, opts ...request.Option) (*DeleteMembersOutput, error) {
	req, out := c.DeleteMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeActionTargets = "DescribeActionTargets"

// DescribeActionTargetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeActionTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeActionTargets for more information on using the DescribeActionTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeActionTargetsRequest method.
//    req, resp := client.DescribeActionTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets
func (c *SecurityHub) DescribeActionTargetsRequest(input *DescribeActionTargetsInput) (req *request.Request, output *DescribeActionTargetsOutput) {
	op := &request.Operation{
		Name:       opDescribeActionTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/actionTargets/get",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeActionTargetsInput{}
	}

	output = &DescribeActionTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeActionTargets API operation for AWS SecurityHub.
//
// Returns a list of the custom action targets in Security Hub in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeActionTargets for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets
func (c *SecurityHub) DescribeActionTargets(input *DescribeActionTargetsInput) (*DescribeActionTargetsOutput, error) {
	req, out := c.DescribeActionTargetsRequest(input)
	return out, req.Send()
}

// DescribeActionTargetsWithContext is the same as DescribeActionTargets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeActionTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeActionTargetsWithContext(ctx aws.Context, input *DescribeActionTargetsInput, opts ...request.Option) (*DescribeActionTargetsOutput, error) {
	req, out := c.DescribeActionTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeActionTargetsPages iterates over the pages of a DescribeActionTargets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeActionTargets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeActionTargets operation.
//    pageNum := 0
//    err := client.DescribeActionTargetsPages(params,
//        func(page *securityhub.DescribeActionTargetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) DescribeActionTargetsPages(input *DescribeActionTargetsInput, fn func(*DescribeActionTargetsOutput, bool) bool) error {
	return c.DescribeActionTargetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeActionTargetsPagesWithContext same as DescribeActionTargetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeActionTargetsPagesWithContext(ctx aws.Context, input *DescribeActionTargetsInput, fn func(*DescribeActionTargetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeActionTargetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeActionTargetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeActionTargetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeHub = "DescribeHub"

// DescribeHubRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHub operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHub for more information on using the DescribeHub
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHubRequest method.
//    req, resp := client.DescribeHubRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeHub
func (c *SecurityHub) DescribeHubRequest(input *DescribeHubInput) (req *request.Request, output *DescribeHubOutput) {
	op := &request.Operation{
		Name:       opDescribeHub,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &DescribeHubInput{}
	}

	output = &DescribeHubOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHub API operation for AWS SecurityHub.
//
// Returns details about the Hub resource in your account, including the HubArn
// and the time when you enabled Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeHub for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeHub
func (c *SecurityHub) DescribeHub(input *DescribeHubInput) (*DescribeHubOutput, error) {
	req, out := c.DescribeHubRequest(input)
	return out, req.Send()
}

// DescribeHubWithContext is the same as DescribeHub with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHub for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeHubWithContext(ctx aws.Context, input *DescribeHubInput, opts ...request.Option) (*DescribeHubOutput, error) {
	req, out := c.DescribeHubRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganizationConfiguration = "DescribeOrganizationConfiguration"

// DescribeOrganizationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationConfiguration for more information on using the DescribeOrganizationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrganizationConfigurationRequest method.
//    req, resp := client.DescribeOrganizationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeOrganizationConfiguration
func (c *SecurityHub) DescribeOrganizationConfigurationRequest(input *DescribeOrganizationConfigurationInput) (req *request.Request, output *DescribeOrganizationConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/organization/configuration",
	}

	if input == nil {
		input = &DescribeOrganizationConfigurationInput{}
	}

	output = &DescribeOrganizationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationConfiguration API operation for AWS SecurityHub.
//
// Returns information about the Organizations configuration for Security Hub.
// Can only be called from a Security Hub administrator account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeOrganizationConfiguration for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeOrganizationConfiguration
func (c *SecurityHub) DescribeOrganizationConfiguration(input *DescribeOrganizationConfigurationInput) (*DescribeOrganizationConfigurationOutput, error) {
	req, out := c.DescribeOrganizationConfigurationRequest(input)
	return out, req.Send()
}

// DescribeOrganizationConfigurationWithContext is the same as DescribeOrganizationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeOrganizationConfigurationWithContext(ctx aws.Context, input *DescribeOrganizationConfigurationInput, opts ...request.Option) (*DescribeOrganizationConfigurationOutput, error) {
	req, out := c.DescribeOrganizationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProducts = "DescribeProducts"

// DescribeProductsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProducts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProducts for more information on using the DescribeProducts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProductsRequest method.
//    req, resp := client.DescribeProductsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts
func (c *SecurityHub) DescribeProductsRequest(input *DescribeProductsInput) (req *request.Request, output *DescribeProductsOutput) {
	op := &request.Operation{
		Name:       opDescribeProducts,
		HTTPMethod: "GET",
		HTTPPath:   "/products",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeProductsInput{}
	}

	output = &DescribeProductsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProducts API operation for AWS SecurityHub.
//
// Returns information about product integrations in Security Hub.
//
// You can optionally provide an integration ARN. If you provide an integration
// ARN, then the results only include that integration.
//
// If you do not provide an integration ARN, then the results include all of
// the available product integrations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeProducts for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts
func (c *SecurityHub) DescribeProducts(input *DescribeProductsInput) (*DescribeProductsOutput, error) {
	req, out := c.DescribeProductsRequest(input)
	return out, req.Send()
}

// DescribeProductsWithContext is the same as DescribeProducts with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProducts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeProductsWithContext(ctx aws.Context, input *DescribeProductsInput, opts ...request.Option) (*DescribeProductsOutput, error) {
	req, out := c.DescribeProductsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeProductsPages iterates over the pages of a DescribeProducts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeProducts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeProducts operation.
//    pageNum := 0
//    err := client.DescribeProductsPages(params,
//        func(page *securityhub.DescribeProductsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) DescribeProductsPages(input *DescribeProductsInput, fn func(*DescribeProductsOutput, bool) bool) error {
	return c.DescribeProductsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeProductsPagesWithContext same as DescribeProductsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeProductsPagesWithContext(ctx aws.Context, input *DescribeProductsInput, fn func(*DescribeProductsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeProductsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeProductsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeProductsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeStandards = "DescribeStandards"

// DescribeStandardsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStandards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStandards for more information on using the DescribeStandards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStandardsRequest method.
//    req, resp := client.DescribeStandardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards
func (c *SecurityHub) DescribeStandardsRequest(input *DescribeStandardsInput) (req *request.Request, output *DescribeStandardsOutput) {
	op := &request.Operation{
		Name:       opDescribeStandards,
		HTTPMethod: "GET",
		HTTPPath:   "/standards",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStandardsInput{}
	}

	output = &DescribeStandardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStandards API operation for AWS SecurityHub.
//
// Returns a list of the available standards in Security Hub.
//
// For each standard, the results include the standard ARN, the name, and a
// description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeStandards for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards
func (c *SecurityHub) DescribeStandards(input *DescribeStandardsInput) (*DescribeStandardsOutput, error) {
	req, out := c.DescribeStandardsRequest(input)
	return out, req.Send()
}

// DescribeStandardsWithContext is the same as DescribeStandards with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStandards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeStandardsWithContext(ctx aws.Context, input *DescribeStandardsInput, opts ...request.Option) (*DescribeStandardsOutput, error) {
	req, out := c.DescribeStandardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeStandardsPages iterates over the pages of a DescribeStandards operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStandards method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeStandards operation.
//    pageNum := 0
//    err := client.DescribeStandardsPages(params,
//        func(page *securityhub.DescribeStandardsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) DescribeStandardsPages(input *DescribeStandardsInput, fn func(*DescribeStandardsOutput, bool) bool) error {
	return c.DescribeStandardsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeStandardsPagesWithContext same as DescribeStandardsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeStandardsPagesWithContext(ctx aws.Context, input *DescribeStandardsInput, fn func(*DescribeStandardsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeStandardsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeStandardsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeStandardsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeStandardsControls = "DescribeStandardsControls"

// DescribeStandardsControlsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStandardsControls operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStandardsControls for more information on using the DescribeStandardsControls
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStandardsControlsRequest method.
//    req, resp := client.DescribeStandardsControlsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls
func (c *SecurityHub) DescribeStandardsControlsRequest(input *DescribeStandardsControlsInput) (req *request.Request, output *DescribeStandardsControlsOutput) {
	op := &request.Operation{
		Name:       opDescribeStandardsControls,
		HTTPMethod: "GET",
		HTTPPath:   "/standards/controls/{StandardsSubscriptionArn+}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStandardsControlsInput{}
	}

	output = &DescribeStandardsControlsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStandardsControls API operation for AWS SecurityHub.
//
// Returns a list of security standards controls.
//
// For each control, the results include information about whether it is currently
// enabled, the severity, and a link to remediation information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeStandardsControls for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls
func (c *SecurityHub) DescribeStandardsControls(input *DescribeStandardsControlsInput) (*DescribeStandardsControlsOutput, error) {
	req, out := c.DescribeStandardsControlsRequest(input)
	return out, req.Send()
}

// DescribeStandardsControlsWithContext is the same as DescribeStandardsControls with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStandardsControls for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeStandardsControlsWithContext(ctx aws.Context, input *DescribeStandardsControlsInput, opts ...request.Option) (*DescribeStandardsControlsOutput, error) {
	req, out := c.DescribeStandardsControlsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeStandardsControlsPages iterates over the pages of a DescribeStandardsControls operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStandardsControls method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeStandardsControls operation.
//    pageNum := 0
//    err := client.DescribeStandardsControlsPages(params,
//        func(page *securityhub.DescribeStandardsControlsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) DescribeStandardsControlsPages(input *DescribeStandardsControlsInput, fn func(*DescribeStandardsControlsOutput, bool) bool) error {
	return c.DescribeStandardsControlsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeStandardsControlsPagesWithContext same as DescribeStandardsControlsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeStandardsControlsPagesWithContext(ctx aws.Context, input *DescribeStandardsControlsInput, fn func(*DescribeStandardsControlsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeStandardsControlsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeStandardsControlsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeStandardsControlsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDisableImportFindingsForProduct = "DisableImportFindingsForProduct"

// DisableImportFindingsForProductRequest generates a "aws/request.Request" representing the
// client's request for the DisableImportFindingsForProduct operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableImportFindingsForProduct for more information on using the DisableImportFindingsForProduct
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableImportFindingsForProductRequest method.
//    req, resp := client.DisableImportFindingsForProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableImportFindingsForProduct
func (c *SecurityHub) DisableImportFindingsForProductRequest(input *DisableImportFindingsForProductInput) (req *request.Request, output *DisableImportFindingsForProductOutput) {
	op := &request.Operation{
		Name:       opDisableImportFindingsForProduct,
		HTTPMethod: "DELETE",
		HTTPPath:   "/productSubscriptions/{ProductSubscriptionArn+}",
	}

	if input == nil {
		input = &DisableImportFindingsForProductInput{}
	}

	output = &DisableImportFindingsForProductOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableImportFindingsForProduct API operation for AWS SecurityHub.
//
// Disables the integration of the specified product with Security Hub. After
// the integration is disabled, findings from that product are no longer sent
// to Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisableImportFindingsForProduct for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableImportFindingsForProduct
func (c *SecurityHub) DisableImportFindingsForProduct(input *DisableImportFindingsForProductInput) (*DisableImportFindingsForProductOutput, error) {
	req, out := c.DisableImportFindingsForProductRequest(input)
	return out, req.Send()
}

// DisableImportFindingsForProductWithContext is the same as DisableImportFindingsForProduct with the addition of
// the ability to pass a context and additional request options.
//
// See DisableImportFindingsForProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisableImportFindingsForProductWithContext(ctx aws.Context, input *DisableImportFindingsForProductInput, opts ...request.Option) (*DisableImportFindingsForProductOutput, error) {
	req, out := c.DisableImportFindingsForProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableOrganizationAdminAccount = "DisableOrganizationAdminAccount"

// DisableOrganizationAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisableOrganizationAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableOrganizationAdminAccount for more information on using the DisableOrganizationAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableOrganizationAdminAccountRequest method.
//    req, resp := client.DisableOrganizationAdminAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableOrganizationAdminAccount
func (c *SecurityHub) DisableOrganizationAdminAccountRequest(input *DisableOrganizationAdminAccountInput) (req *request.Request, output *DisableOrganizationAdminAccountOutput) {
	op := &request.Operation{
		Name:       opDisableOrganizationAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/organization/admin/disable",
	}

	if input == nil {
		input = &DisableOrganizationAdminAccountInput{}
	}

	output = &DisableOrganizationAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableOrganizationAdminAccount API operation for AWS SecurityHub.
//
// Disables a Security Hub administrator account. Can only be called by the
// organization management account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisableOrganizationAdminAccount for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableOrganizationAdminAccount
func (c *SecurityHub) DisableOrganizationAdminAccount(input *DisableOrganizationAdminAccountInput) (*DisableOrganizationAdminAccountOutput, error) {
	req, out := c.DisableOrganizationAdminAccountRequest(input)
	return out, req.Send()
}

// DisableOrganizationAdminAccountWithContext is the same as DisableOrganizationAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisableOrganizationAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisableOrganizationAdminAccountWithContext(ctx aws.Context, input *DisableOrganizationAdminAccountInput, opts ...request.Option) (*DisableOrganizationAdminAccountOutput, error) {
	req, out := c.DisableOrganizationAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableSecurityHub = "DisableSecurityHub"

// DisableSecurityHubRequest generates a "aws/request.Request" representing the
// client's request for the DisableSecurityHub operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableSecurityHub for more information on using the DisableSecurityHub
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableSecurityHubRequest method.
//    req, resp := client.DisableSecurityHubRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub
func (c *SecurityHub) DisableSecurityHubRequest(input *DisableSecurityHubInput) (req *request.Request, output *DisableSecurityHubOutput) {
	op := &request.Operation{
		Name:       opDisableSecurityHub,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &DisableSecurityHubInput{}
	}

	output = &DisableSecurityHubOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableSecurityHub API operation for AWS SecurityHub.
//
// Disables Security Hub in your account only in the current Region. To disable
// Security Hub in all Regions, you must submit one request per Region where
// you have enabled Security Hub.
//
// When you disable Security Hub for an administrator account, it doesn't disable
// Security Hub for any associated member accounts.
//
// When you disable Security Hub, your existing findings and insights and any
// Security Hub configuration settings are deleted after 90 days and cannot
// be recovered. Any standards that were enabled are disabled, and your administrator
// and member account associations are removed.
//
// If you want to save your existing findings, you must export them before you
// disable Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisableSecurityHub for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub
func (c *SecurityHub) DisableSecurityHub(input *DisableSecurityHubInput) (*DisableSecurityHubOutput, error) {
	req, out := c.DisableSecurityHubRequest(input)
	return out, req.Send()
}

// DisableSecurityHubWithContext is the same as DisableSecurityHub with the addition of
// the ability to pass a context and additional request options.
//
// See DisableSecurityHub for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisableSecurityHubWithContext(ctx aws.Context, input *DisableSecurityHubInput, opts ...request.Option) (*DisableSecurityHubOutput, error) {
	req, out := c.DisableSecurityHubRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateFromAdministratorAccount = "DisassociateFromAdministratorAccount"

// DisassociateFromAdministratorAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateFromAdministratorAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateFromAdministratorAccount for more information on using the DisassociateFromAdministratorAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateFromAdministratorAccountRequest method.
//    req, resp := client.DisassociateFromAdministratorAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromAdministratorAccount
func (c *SecurityHub) DisassociateFromAdministratorAccountRequest(input *DisassociateFromAdministratorAccountInput) (req *request.Request, output *DisassociateFromAdministratorAccountOutput) {
	op := &request.Operation{
		Name:       opDisassociateFromAdministratorAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/administrator/disassociate",
	}

	if input == nil {
		input = &DisassociateFromAdministratorAccountInput{}
	}

	output = &DisassociateFromAdministratorAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateFromAdministratorAccount API operation for AWS SecurityHub.
//
// Disassociates the current Security Hub member account from the associated
// administrator account.
//
// This operation is only used by accounts that are not part of an organization.
// For organization accounts, only the administrator account can disassociate
// a member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisassociateFromAdministratorAccount for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromAdministratorAccount
func (c *SecurityHub) DisassociateFromAdministratorAccount(input *DisassociateFromAdministratorAccountInput) (*DisassociateFromAdministratorAccountOutput, error) {
	req, out := c.DisassociateFromAdministratorAccountRequest(input)
	return out, req.Send()
}

// DisassociateFromAdministratorAccountWithContext is the same as DisassociateFromAdministratorAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateFromAdministratorAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisassociateFromAdministratorAccountWithContext(ctx aws.Context, input *DisassociateFromAdministratorAccountInput, opts ...request.Option) (*DisassociateFromAdministratorAccountOutput, error) {
	req, out := c.DisassociateFromAdministratorAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateFromMasterAccount = "DisassociateFromMasterAccount"

// DisassociateFromMasterAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateFromMasterAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateFromMasterAccount for more information on using the DisassociateFromMasterAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateFromMasterAccountRequest method.
//    req, resp := client.DisassociateFromMasterAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromMasterAccount
//
// Deprecated: This API has been deprecated, use DisassociateFromAdministratorAccount API instead.
func (c *SecurityHub) DisassociateFromMasterAccountRequest(input *DisassociateFromMasterAccountInput) (req *request.Request, output *DisassociateFromMasterAccountOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DisassociateFromMasterAccount, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDisassociateFromMasterAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/master/disassociate",
	}

	if input == nil {
		input = &DisassociateFromMasterAccountInput{}
	}

	output = &DisassociateFromMasterAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateFromMasterAccount API operation for AWS SecurityHub.
//
// This method is deprecated. Instead, use DisassociateFromAdministratorAccount.
//
// The Security Hub console continues to use DisassociateFromMasterAccount.
// It will eventually change to use DisassociateFromAdministratorAccount. Any
// IAM policies that specifically control access to this function must continue
// to use DisassociateFromMasterAccount. You should also add DisassociateFromAdministratorAccount
// to your policies to ensure that the correct permissions are in place after
// the console begins to use DisassociateFromAdministratorAccount.
//
// Disassociates the current Security Hub member account from the associated
// administrator account.
//
// This operation is only used by accounts that are not part of an organization.
// For organization accounts, only the administrator account can disassociate
// a member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisassociateFromMasterAccount for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromMasterAccount
//
// Deprecated: This API has been deprecated, use DisassociateFromAdministratorAccount API instead.
func (c *SecurityHub) DisassociateFromMasterAccount(input *DisassociateFromMasterAccountInput) (*DisassociateFromMasterAccountOutput, error) {
	req, out := c.DisassociateFromMasterAccountRequest(input)
	return out, req.Send()
}

// DisassociateFromMasterAccountWithContext is the same as DisassociateFromMasterAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateFromMasterAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: This API has been deprecated, use DisassociateFromAdministratorAccount API instead.
func (c *SecurityHub) DisassociateFromMasterAccountWithContext(ctx aws.Context, input *DisassociateFromMasterAccountInput, opts ...request.Option) (*DisassociateFromMasterAccountOutput, error) {
	req, out := c.DisassociateFromMasterAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateMembers = "DisassociateMembers"

// DisassociateMembersRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateMembers for more information on using the DisassociateMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateMembersRequest method.
//    req, resp := client.DisassociateMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateMembers
func (c *SecurityHub) DisassociateMembersRequest(input *DisassociateMembersInput) (req *request.Request, output *DisassociateMembersOutput) {
	op := &request.Operation{
		Name:       opDisassociateMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/disassociate",
	}

	if input == nil {
		input = &DisassociateMembersInput{}
	}

	output = &DisassociateMembersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateMembers API operation for AWS SecurityHub.
//
// Disassociates the specified member accounts from the associated administrator
// account.
//
// Can be used to disassociate both accounts that are managed using Organizations
// and accounts that were invited manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisassociateMembers for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateMembers
func (c *SecurityHub) DisassociateMembers(input *DisassociateMembersInput) (*DisassociateMembersOutput, error) {
	req, out := c.DisassociateMembersRequest(input)
	return out, req.Send()
}

// DisassociateMembersWithContext is the same as DisassociateMembers with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisassociateMembersWithContext(ctx aws.Context, input *DisassociateMembersInput, opts ...request.Option) (*DisassociateMembersOutput, error) {
	req, out := c.DisassociateMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableImportFindingsForProduct = "EnableImportFindingsForProduct"

// EnableImportFindingsForProductRequest generates a "aws/request.Request" representing the
// client's request for the EnableImportFindingsForProduct operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableImportFindingsForProduct for more information on using the EnableImportFindingsForProduct
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableImportFindingsForProductRequest method.
//    req, resp := client.EnableImportFindingsForProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableImportFindingsForProduct
func (c *SecurityHub) EnableImportFindingsForProductRequest(input *EnableImportFindingsForProductInput) (req *request.Request, output *EnableImportFindingsForProductOutput) {
	op := &request.Operation{
		Name:       opEnableImportFindingsForProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/productSubscriptions",
	}

	if input == nil {
		input = &EnableImportFindingsForProductInput{}
	}

	output = &EnableImportFindingsForProductOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableImportFindingsForProduct API operation for AWS SecurityHub.
//
// Enables the integration of a partner product with Security Hub. Integrated
// products send findings to Security Hub.
//
// When you enable a product integration, a permissions policy that grants permission
// for the product to send findings to Security Hub is applied.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation EnableImportFindingsForProduct for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceConflictException
//   The resource specified in the request conflicts with an existing resource.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableImportFindingsForProduct
func (c *SecurityHub) EnableImportFindingsForProduct(input *EnableImportFindingsForProductInput) (*EnableImportFindingsForProductOutput, error) {
	req, out := c.EnableImportFindingsForProductRequest(input)
	return out, req.Send()
}

// EnableImportFindingsForProductWithContext is the same as EnableImportFindingsForProduct with the addition of
// the ability to pass a context and additional request options.
//
// See EnableImportFindingsForProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) EnableImportFindingsForProductWithContext(ctx aws.Context, input *EnableImportFindingsForProductInput, opts ...request.Option) (*EnableImportFindingsForProductOutput, error) {
	req, out := c.EnableImportFindingsForProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableOrganizationAdminAccount = "EnableOrganizationAdminAccount"

// EnableOrganizationAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the EnableOrganizationAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableOrganizationAdminAccount for more information on using the EnableOrganizationAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableOrganizationAdminAccountRequest method.
//    req, resp := client.EnableOrganizationAdminAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableOrganizationAdminAccount
func (c *SecurityHub) EnableOrganizationAdminAccountRequest(input *EnableOrganizationAdminAccountInput) (req *request.Request, output *EnableOrganizationAdminAccountOutput) {
	op := &request.Operation{
		Name:       opEnableOrganizationAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/organization/admin/enable",
	}

	if input == nil {
		input = &EnableOrganizationAdminAccountInput{}
	}

	output = &EnableOrganizationAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableOrganizationAdminAccount API operation for AWS SecurityHub.
//
// Designates the Security Hub administrator account for an organization. Can
// only be called by the organization management account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation EnableOrganizationAdminAccount for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableOrganizationAdminAccount
func (c *SecurityHub) EnableOrganizationAdminAccount(input *EnableOrganizationAdminAccountInput) (*EnableOrganizationAdminAccountOutput, error) {
	req, out := c.EnableOrganizationAdminAccountRequest(input)
	return out, req.Send()
}

// EnableOrganizationAdminAccountWithContext is the same as EnableOrganizationAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See EnableOrganizationAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) EnableOrganizationAdminAccountWithContext(ctx aws.Context, input *EnableOrganizationAdminAccountInput, opts ...request.Option) (*EnableOrganizationAdminAccountOutput, error) {
	req, out := c.EnableOrganizationAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableSecurityHub = "EnableSecurityHub"

// EnableSecurityHubRequest generates a "aws/request.Request" representing the
// client's request for the EnableSecurityHub operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableSecurityHub for more information on using the EnableSecurityHub
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableSecurityHubRequest method.
//    req, resp := client.EnableSecurityHubRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub
func (c *SecurityHub) EnableSecurityHubRequest(input *EnableSecurityHubInput) (req *request.Request, output *EnableSecurityHubOutput) {
	op := &request.Operation{
		Name:       opEnableSecurityHub,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &EnableSecurityHubInput{}
	}

	output = &EnableSecurityHubOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableSecurityHub API operation for AWS SecurityHub.
//
// Enables Security Hub for your account in the current Region or the Region
// you specify in the request.
//
// When you enable Security Hub, you grant to Security Hub the permissions necessary
// to gather findings from other services that are integrated with Security
// Hub.
//
// When you use the EnableSecurityHub operation to enable Security Hub, you
// also automatically enable the following standards.
//
//    * CIS Amazon Web Services Foundations
//
//    * Amazon Web Services Foundational Security Best Practices
//
// You do not enable the Payment Card Industry Data Security Standard (PCI DSS)
// standard.
//
// To not enable the automatically enabled standards, set EnableDefaultStandards
// to false.
//
// After you enable Security Hub, to enable a standard, use the BatchEnableStandards
// operation. To disable a standard, use the BatchDisableStandards operation.
//
// To learn more, see the setup information (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html)
// in the Security Hub User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation EnableSecurityHub for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceConflictException
//   The resource specified in the request conflicts with an existing resource.
//
//   * AccessDeniedException
//   You don't have permission to perform the action specified in the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub
func (c *SecurityHub) EnableSecurityHub(input *EnableSecurityHubInput) (*EnableSecurityHubOutput, error) {
	req, out := c.EnableSecurityHubRequest(input)
	return out, req.Send()
}

// EnableSecurityHubWithContext is the same as EnableSecurityHub with the addition of
// the ability to pass a context and additional request options.
//
// See EnableSecurityHub for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) EnableSecurityHubWithContext(ctx aws.Context, input *EnableSecurityHubInput, opts ...request.Option) (*EnableSecurityHubOutput, error) {
	req, out := c.EnableSecurityHubRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAdministratorAccount = "GetAdministratorAccount"

// GetAdministratorAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetAdministratorAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAdministratorAccount for more information on using the GetAdministratorAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAdministratorAccountRequest method.
//    req, resp := client.GetAdministratorAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetAdministratorAccount
func (c *SecurityHub) GetAdministratorAccountRequest(input *GetAdministratorAccountInput) (req *request.Request, output *GetAdministratorAccountOutput) {
	op := &request.Operation{
		Name:       opGetAdministratorAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/administrator",
	}

	if input == nil {
		input = &GetAdministratorAccountInput{}
	}

	output = &GetAdministratorAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAdministratorAccount API operation for AWS SecurityHub.
//
// Provides the details for the Security Hub administrator account for the current
// member account.
//
// Can be used by both member accounts that are managed using Organizations
// and accounts that were invited manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetAdministratorAccount for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetAdministratorAccount
func (c *SecurityHub) GetAdministratorAccount(input *GetAdministratorAccountInput) (*GetAdministratorAccountOutput, error) {
	req, out := c.GetAdministratorAccountRequest(input)
	return out, req.Send()
}

// GetAdministratorAccountWithContext is the same as GetAdministratorAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetAdministratorAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetAdministratorAccountWithContext(ctx aws.Context, input *GetAdministratorAccountInput, opts ...request.Option) (*GetAdministratorAccountOutput, error) {
	req, out := c.GetAdministratorAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnabledStandards = "GetEnabledStandards"

// GetEnabledStandardsRequest generates a "aws/request.Request" representing the
// client's request for the GetEnabledStandards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnabledStandards for more information on using the GetEnabledStandards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEnabledStandardsRequest method.
//    req, resp := client.GetEnabledStandardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards
func (c *SecurityHub) GetEnabledStandardsRequest(input *GetEnabledStandardsInput) (req *request.Request, output *GetEnabledStandardsOutput) {
	op := &request.Operation{
		Name:       opGetEnabledStandards,
		HTTPMethod: "POST",
		HTTPPath:   "/standards/get",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetEnabledStandardsInput{}
	}

	output = &GetEnabledStandardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEnabledStandards API operation for AWS SecurityHub.
//
// Returns a list of the standards that are currently enabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetEnabledStandards for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards
func (c *SecurityHub) GetEnabledStandards(input *GetEnabledStandardsInput) (*GetEnabledStandardsOutput, error) {
	req, out := c.GetEnabledStandardsRequest(input)
	return out, req.Send()
}

// GetEnabledStandardsWithContext is the same as GetEnabledStandards with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnabledStandards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetEnabledStandardsWithContext(ctx aws.Context, input *GetEnabledStandardsInput, opts ...request.Option) (*GetEnabledStandardsOutput, error) {
	req, out := c.GetEnabledStandardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetEnabledStandardsPages iterates over the pages of a GetEnabledStandards operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetEnabledStandards method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetEnabledStandards operation.
//    pageNum := 0
//    err := client.GetEnabledStandardsPages(params,
//        func(page *securityhub.GetEnabledStandardsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) GetEnabledStandardsPages(input *GetEnabledStandardsInput, fn func(*GetEnabledStandardsOutput, bool) bool) error {
	return c.GetEnabledStandardsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetEnabledStandardsPagesWithContext same as GetEnabledStandardsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetEnabledStandardsPagesWithContext(ctx aws.Context, input *GetEnabledStandardsInput, fn func(*GetEnabledStandardsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetEnabledStandardsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetEnabledStandardsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetEnabledStandardsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetFindingAggregator = "GetFindingAggregator"

// GetFindingAggregatorRequest generates a "aws/request.Request" representing the
// client's request for the GetFindingAggregator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFindingAggregator for more information on using the GetFindingAggregator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFindingAggregatorRequest method.
//    req, resp := client.GetFindingAggregatorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingAggregator
func (c *SecurityHub) GetFindingAggregatorRequest(input *GetFindingAggregatorInput) (req *request.Request, output *GetFindingAggregatorOutput) {
	op := &request.Operation{
		Name:       opGetFindingAggregator,
		HTTPMethod: "GET",
		HTTPPath:   "/findingAggregator/get/{FindingAggregatorArn+}",
	}

	if input == nil {
		input = &GetFindingAggregatorInput{}
	}

	output = &GetFindingAggregatorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFindingAggregator API operation for AWS SecurityHub.
//
// Returns the current finding aggregation configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetFindingAggregator for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * AccessDeniedException
//   You don't have permission to perform the action specified in the request.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingAggregator
func (c *SecurityHub) GetFindingAggregator(input *GetFindingAggregatorInput) (*GetFindingAggregatorOutput, error) {
	req, out := c.GetFindingAggregatorRequest(input)
	return out, req.Send()
}

// GetFindingAggregatorWithContext is the same as GetFindingAggregator with the addition of
// the ability to pass a context and additional request options.
//
// See GetFindingAggregator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetFindingAggregatorWithContext(ctx aws.Context, input *GetFindingAggregatorInput, opts ...request.Option) (*GetFindingAggregatorOutput, error) {
	req, out := c.GetFindingAggregatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFindings = "GetFindings"

// GetFindingsRequest generates a "aws/request.Request" representing the
// client's request for the GetFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFindings for more information on using the GetFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFindingsRequest method.
//    req, resp := client.GetFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings
func (c *SecurityHub) GetFindingsRequest(input *GetFindingsInput) (req *request.Request, output *GetFindingsOutput) {
	op := &request.Operation{
		Name:       opGetFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/findings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetFindingsInput{}
	}

	output = &GetFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFindings API operation for AWS SecurityHub.
//
// Returns a list of findings that match the specified criteria.
//
// If finding aggregation is enabled, then when you call GetFindings from the
// aggregation Region, the results include all of the matching findings from
// both the aggregation Region and the linked Regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetFindings for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings
func (c *SecurityHub) GetFindings(input *GetFindingsInput) (*GetFindingsOutput, error) {
	req, out := c.GetFindingsRequest(input)
	return out, req.Send()
}

// GetFindingsWithContext is the same as GetFindings with the addition of
// the ability to pass a context and additional request options.
//
// See GetFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetFindingsWithContext(ctx aws.Context, input *GetFindingsInput, opts ...request.Option) (*GetFindingsOutput, error) {
	req, out := c.GetFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetFindingsPages iterates over the pages of a GetFindings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetFindings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetFindings operation.
//    pageNum := 0
//    err := client.GetFindingsPages(params,
//        func(page *securityhub.GetFindingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) GetFindingsPages(input *GetFindingsInput, fn func(*GetFindingsOutput, bool) bool) error {
	return c.GetFindingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetFindingsPagesWithContext same as GetFindingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetFindingsPagesWithContext(ctx aws.Context, input *GetFindingsInput, fn func(*GetFindingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetFindingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetFindingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetFindingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetInsightResults = "GetInsightResults"

// GetInsightResultsRequest generates a "aws/request.Request" representing the
// client's request for the GetInsightResults operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInsightResults for more information on using the GetInsightResults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInsightResultsRequest method.
//    req, resp := client.GetInsightResultsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResults
func (c *SecurityHub) GetInsightResultsRequest(input *GetInsightResultsInput) (req *request.Request, output *GetInsightResultsOutput) {
	op := &request.Operation{
		Name:       opGetInsightResults,
		HTTPMethod: "GET",
		HTTPPath:   "/insights/results/{InsightArn+}",
	}

	if input == nil {
		input = &GetInsightResultsInput{}
	}

	output = &GetInsightResultsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInsightResults API operation for AWS SecurityHub.
//
// Lists the results of the Security Hub insight specified by the insight ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetInsightResults for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResults
func (c *SecurityHub) GetInsightResults(input *GetInsightResultsInput) (*GetInsightResultsOutput, error) {
	req, out := c.GetInsightResultsRequest(input)
	return out, req.Send()
}

// GetInsightResultsWithContext is the same as GetInsightResults with the addition of
// the ability to pass a context and additional request options.
//
// See GetInsightResults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInsightResultsWithContext(ctx aws.Context, input *GetInsightResultsInput, opts ...request.Option) (*GetInsightResultsOutput, error) {
	req, out := c.GetInsightResultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInsights = "GetInsights"

// GetInsightsRequest generates a "aws/request.Request" representing the
// client's request for the GetInsights operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInsights for more information on using the GetInsights
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInsightsRequest method.
//    req, resp := client.GetInsightsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights
func (c *SecurityHub) GetInsightsRequest(input *GetInsightsInput) (req *request.Request, output *GetInsightsOutput) {
	op := &request.Operation{
		Name:       opGetInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/insights/get",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetInsightsInput{}
	}

	output = &GetInsightsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInsights API operation for AWS SecurityHub.
//
// Lists and describes insights for the specified insight ARNs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetInsights for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights
func (c *SecurityHub) GetInsights(input *GetInsightsInput) (*GetInsightsOutput, error) {
	req, out := c.GetInsightsRequest(input)
	return out, req.Send()
}

// GetInsightsWithContext is the same as GetInsights with the addition of
// the ability to pass a context and additional request options.
//
// See GetInsights for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInsightsWithContext(ctx aws.Context, input *GetInsightsInput, opts ...request.Option) (*GetInsightsOutput, error) {
	req, out := c.GetInsightsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetInsightsPages iterates over the pages of a GetInsights operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetInsights method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetInsights operation.
//    pageNum := 0
//    err := client.GetInsightsPages(params,
//        func(page *securityhub.GetInsightsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) GetInsightsPages(input *GetInsightsInput, fn func(*GetInsightsOutput, bool) bool) error {
	return c.GetInsightsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetInsightsPagesWithContext same as GetInsightsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInsightsPagesWithContext(ctx aws.Context, input *GetInsightsInput, fn func(*GetInsightsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetInsightsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetInsightsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetInsightsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetInvitationsCount = "GetInvitationsCount"

// GetInvitationsCountRequest generates a "aws/request.Request" representing the
// client's request for the GetInvitationsCount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInvitationsCount for more information on using the GetInvitationsCount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInvitationsCountRequest method.
//    req, resp := client.GetInvitationsCountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount
func (c *SecurityHub) GetInvitationsCountRequest(input *GetInvitationsCountInput) (req *request.Request, output *GetInvitationsCountOutput) {
	op := &request.Operation{
		Name:       opGetInvitationsCount,
		HTTPMethod: "GET",
		HTTPPath:   "/invitations/count",
	}

	if input == nil {
		input = &GetInvitationsCountInput{}
	}

	output = &GetInvitationsCountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInvitationsCount API operation for AWS SecurityHub.
//
// Returns the count of all Security Hub membership invitations that were sent
// to the current member account, not including the currently accepted invitation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetInvitationsCount for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount
func (c *SecurityHub) GetInvitationsCount(input *GetInvitationsCountInput) (*GetInvitationsCountOutput, error) {
	req, out := c.GetInvitationsCountRequest(input)
	return out, req.Send()
}

// GetInvitationsCountWithContext is the same as GetInvitationsCount with the addition of
// the ability to pass a context and additional request options.
//
// See GetInvitationsCount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInvitationsCountWithContext(ctx aws.Context, input *GetInvitationsCountInput, opts ...request.Option) (*GetInvitationsCountOutput, error) {
	req, out := c.GetInvitationsCountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMasterAccount = "GetMasterAccount"

// GetMasterAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetMasterAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMasterAccount for more information on using the GetMasterAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMasterAccountRequest method.
//    req, resp := client.GetMasterAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount
//
// Deprecated: This API has been deprecated, use GetAdministratorAccount API instead.
func (c *SecurityHub) GetMasterAccountRequest(input *GetMasterAccountInput) (req *request.Request, output *GetMasterAccountOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetMasterAccount, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetMasterAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/master",
	}

	if input == nil {
		input = &GetMasterAccountInput{}
	}

	output = &GetMasterAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMasterAccount API operation for AWS SecurityHub.
//
// This method is deprecated. Instead, use GetAdministratorAccount.
//
// The Security Hub console continues to use GetMasterAccount. It will eventually
// change to use GetAdministratorAccount. Any IAM policies that specifically
// control access to this function must continue to use GetMasterAccount. You
// should also add GetAdministratorAccount to your policies to ensure that the
// correct permissions are in place after the console begins to use GetAdministratorAccount.
//
// Provides the details for the Security Hub administrator account for the current
// member account.
//
// Can be used by both member accounts that are managed using Organizations
// and accounts that were invited manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetMasterAccount for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount
//
// Deprecated: This API has been deprecated, use GetAdministratorAccount API instead.
func (c *SecurityHub) GetMasterAccount(input *GetMasterAccountInput) (*GetMasterAccountOutput, error) {
	req, out := c.GetMasterAccountRequest(input)
	return out, req.Send()
}

// GetMasterAccountWithContext is the same as GetMasterAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetMasterAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: This API has been deprecated, use GetAdministratorAccount API instead.
func (c *SecurityHub) GetMasterAccountWithContext(ctx aws.Context, input *GetMasterAccountInput, opts ...request.Option) (*GetMasterAccountOutput, error) {
	req, out := c.GetMasterAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMembers = "GetMembers"

// GetMembersRequest generates a "aws/request.Request" representing the
// client's request for the GetMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMembers for more information on using the GetMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMembersRequest method.
//    req, resp := client.GetMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMembers
func (c *SecurityHub) GetMembersRequest(input *GetMembersInput) (req *request.Request, output *GetMembersOutput) {
	op := &request.Operation{
		Name:       opGetMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/get",
	}

	if input == nil {
		input = &GetMembersInput{}
	}

	output = &GetMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMembers API operation for AWS SecurityHub.
//
// Returns the details for the Security Hub member accounts for the specified
// account IDs.
//
// An administrator account can be either the delegated Security Hub administrator
// account for an organization or an administrator account that enabled Security
// Hub manually.
//
// The results include both member accounts that are managed using Organizations
// and accounts that were invited manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetMembers for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMembers
func (c *SecurityHub) GetMembers(input *GetMembersInput) (*GetMembersOutput, error) {
	req, out := c.GetMembersRequest(input)
	return out, req.Send()
}

// GetMembersWithContext is the same as GetMembers with the addition of
// the ability to pass a context and additional request options.
//
// See GetMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetMembersWithContext(ctx aws.Context, input *GetMembersInput, opts ...request.Option) (*GetMembersOutput, error) {
	req, out := c.GetMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInviteMembers = "InviteMembers"

// InviteMembersRequest generates a "aws/request.Request" representing the
// client's request for the InviteMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InviteMembers for more information on using the InviteMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InviteMembersRequest method.
//    req, resp := client.InviteMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InviteMembers
func (c *SecurityHub) InviteMembersRequest(input *InviteMembersInput) (req *request.Request, output *InviteMembersOutput) {
	op := &request.Operation{
		Name:       opInviteMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/invite",
	}

	if input == nil {
		input = &InviteMembersInput{}
	}

	output = &InviteMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InviteMembers API operation for AWS SecurityHub.
//
// Invites other Amazon Web Services accounts to become member accounts for
// the Security Hub administrator account that the invitation is sent from.
//
// This operation is only used to invite accounts that do not belong to an organization.
// Organization accounts do not receive invitations.
//
// Before you can use this action to invite a member, you must first use the
// CreateMembers action to create the member account in Security Hub.
//
// When the account owner enables Security Hub and accepts the invitation to
// become a member account, the administrator account can view the findings
// generated from the member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation InviteMembers for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InviteMembers
func (c *SecurityHub) InviteMembers(input *InviteMembersInput) (*InviteMembersOutput, error) {
	req, out := c.InviteMembersRequest(input)
	return out, req.Send()
}

// InviteMembersWithContext is the same as InviteMembers with the addition of
// the ability to pass a context and additional request options.
//
// See InviteMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) InviteMembersWithContext(ctx aws.Context, input *InviteMembersInput, opts ...request.Option) (*InviteMembersOutput, error) {
	req, out := c.InviteMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEnabledProductsForImport = "ListEnabledProductsForImport"

// ListEnabledProductsForImportRequest generates a "aws/request.Request" representing the
// client's request for the ListEnabledProductsForImport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnabledProductsForImport for more information on using the ListEnabledProductsForImport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEnabledProductsForImportRequest method.
//    req, resp := client.ListEnabledProductsForImportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport
func (c *SecurityHub) ListEnabledProductsForImportRequest(input *ListEnabledProductsForImportInput) (req *request.Request, output *ListEnabledProductsForImportOutput) {
	op := &request.Operation{
		Name:       opListEnabledProductsForImport,
		HTTPMethod: "GET",
		HTTPPath:   "/productSubscriptions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnabledProductsForImportInput{}
	}

	output = &ListEnabledProductsForImportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnabledProductsForImport API operation for AWS SecurityHub.
//
// Lists all findings-generating solutions (products) that you are subscribed
// to receive findings from in Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListEnabledProductsForImport for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport
func (c *SecurityHub) ListEnabledProductsForImport(input *ListEnabledProductsForImportInput) (*ListEnabledProductsForImportOutput, error) {
	req, out := c.ListEnabledProductsForImportRequest(input)
	return out, req.Send()
}

// ListEnabledProductsForImportWithContext is the same as ListEnabledProductsForImport with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnabledProductsForImport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListEnabledProductsForImportWithContext(ctx aws.Context, input *ListEnabledProductsForImportInput, opts ...request.Option) (*ListEnabledProductsForImportOutput, error) {
	req, out := c.ListEnabledProductsForImportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnabledProductsForImportPages iterates over the pages of a ListEnabledProductsForImport operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnabledProductsForImport method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEnabledProductsForImport operation.
//    pageNum := 0
//    err := client.ListEnabledProductsForImportPages(params,
//        func(page *securityhub.ListEnabledProductsForImportOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) ListEnabledProductsForImportPages(input *ListEnabledProductsForImportInput, fn func(*ListEnabledProductsForImportOutput, bool) bool) error {
	return c.ListEnabledProductsForImportPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnabledProductsForImportPagesWithContext same as ListEnabledProductsForImportPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListEnabledProductsForImportPagesWithContext(ctx aws.Context, input *ListEnabledProductsForImportInput, fn func(*ListEnabledProductsForImportOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnabledProductsForImportInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnabledProductsForImportRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnabledProductsForImportOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFindingAggregators = "ListFindingAggregators"

// ListFindingAggregatorsRequest generates a "aws/request.Request" representing the
// client's request for the ListFindingAggregators operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFindingAggregators for more information on using the ListFindingAggregators
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFindingAggregatorsRequest method.
//    req, resp := client.ListFindingAggregatorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListFindingAggregators
func (c *SecurityHub) ListFindingAggregatorsRequest(input *ListFindingAggregatorsInput) (req *request.Request, output *ListFindingAggregatorsOutput) {
	op := &request.Operation{
		Name:       opListFindingAggregators,
		HTTPMethod: "GET",
		HTTPPath:   "/findingAggregator/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFindingAggregatorsInput{}
	}

	output = &ListFindingAggregatorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFindingAggregators API operation for AWS SecurityHub.
//
// If finding aggregation is enabled, then ListFindingAggregators returns the
// ARN of the finding aggregator. You can run this operation from any Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListFindingAggregators for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * AccessDeniedException
//   You don't have permission to perform the action specified in the request.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListFindingAggregators
func (c *SecurityHub) ListFindingAggregators(input *ListFindingAggregatorsInput) (*ListFindingAggregatorsOutput, error) {
	req, out := c.ListFindingAggregatorsRequest(input)
	return out, req.Send()
}

// ListFindingAggregatorsWithContext is the same as ListFindingAggregators with the addition of
// the ability to pass a context and additional request options.
//
// See ListFindingAggregators for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListFindingAggregatorsWithContext(ctx aws.Context, input *ListFindingAggregatorsInput, opts ...request.Option) (*ListFindingAggregatorsOutput, error) {
	req, out := c.ListFindingAggregatorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFindingAggregatorsPages iterates over the pages of a ListFindingAggregators operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFindingAggregators method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFindingAggregators operation.
//    pageNum := 0
//    err := client.ListFindingAggregatorsPages(params,
//        func(page *securityhub.ListFindingAggregatorsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) ListFindingAggregatorsPages(input *ListFindingAggregatorsInput, fn func(*ListFindingAggregatorsOutput, bool) bool) error {
	return c.ListFindingAggregatorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFindingAggregatorsPagesWithContext same as ListFindingAggregatorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListFindingAggregatorsPagesWithContext(ctx aws.Context, input *ListFindingAggregatorsInput, fn func(*ListFindingAggregatorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFindingAggregatorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFindingAggregatorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFindingAggregatorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInvitations = "ListInvitations"

// ListInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the ListInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInvitations for more information on using the ListInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInvitationsRequest method.
//    req, resp := client.ListInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations
func (c *SecurityHub) ListInvitationsRequest(input *ListInvitationsInput) (req *request.Request, output *ListInvitationsOutput) {
	op := &request.Operation{
		Name:       opListInvitations,
		HTTPMethod: "GET",
		HTTPPath:   "/invitations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInvitationsInput{}
	}

	output = &ListInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInvitations API operation for AWS SecurityHub.
//
// Lists all Security Hub membership invitations that were sent to the current
// Amazon Web Services account.
//
// This operation is only used by accounts that are managed by invitation. Accounts
// that are managed using the integration with Organizations do not receive
// invitations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListInvitations for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations
func (c *SecurityHub) ListInvitations(input *ListInvitationsInput) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	return out, req.Send()
}

// ListInvitationsWithContext is the same as ListInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See ListInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListInvitationsWithContext(ctx aws.Context, input *ListInvitationsInput, opts ...request.Option) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInvitationsPages iterates over the pages of a ListInvitations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInvitations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInvitations operation.
//    pageNum := 0
//    err := client.ListInvitationsPages(params,
//        func(page *securityhub.ListInvitationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) ListInvitationsPages(input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool) error {
	return c.ListInvitationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInvitationsPagesWithContext same as ListInvitationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListInvitationsPagesWithContext(ctx aws.Context, input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInvitationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInvitationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInvitationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMembers = "ListMembers"

// ListMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMembers for more information on using the ListMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMembersRequest method.
//    req, resp := client.ListMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers
func (c *SecurityHub) ListMembersRequest(input *ListMembersInput) (req *request.Request, output *ListMembersOutput) {
	op := &request.Operation{
		Name:       opListMembers,
		HTTPMethod: "GET",
		HTTPPath:   "/members",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMembersInput{}
	}

	output = &ListMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMembers API operation for AWS SecurityHub.
//
// Lists details about all member accounts for the current Security Hub administrator
// account.
//
// The results include both member accounts that belong to an organization and
// member accounts that were invited manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListMembers for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers
func (c *SecurityHub) ListMembers(input *ListMembersInput) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	return out, req.Send()
}

// ListMembersWithContext is the same as ListMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListMembersWithContext(ctx aws.Context, input *ListMembersInput, opts ...request.Option) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMembersPages iterates over the pages of a ListMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMembers operation.
//    pageNum := 0
//    err := client.ListMembersPages(params,
//        func(page *securityhub.ListMembersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) ListMembersPages(input *ListMembersInput, fn func(*ListMembersOutput, bool) bool) error {
	return c.ListMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMembersPagesWithContext same as ListMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListMembersPagesWithContext(ctx aws.Context, input *ListMembersInput, fn func(*ListMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOrganizationAdminAccounts = "ListOrganizationAdminAccounts"

// ListOrganizationAdminAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListOrganizationAdminAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOrganizationAdminAccounts for more information on using the ListOrganizationAdminAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOrganizationAdminAccountsRequest method.
//    req, resp := client.ListOrganizationAdminAccountsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListOrganizationAdminAccounts
func (c *SecurityHub) ListOrganizationAdminAccountsRequest(input *ListOrganizationAdminAccountsInput) (req *request.Request, output *ListOrganizationAdminAccountsOutput) {
	op := &request.Operation{
		Name:       opListOrganizationAdminAccounts,
		HTTPMethod: "GET",
		HTTPPath:   "/organization/admin",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOrganizationAdminAccountsInput{}
	}

	output = &ListOrganizationAdminAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOrganizationAdminAccounts API operation for AWS SecurityHub.
//
// Lists the Security Hub administrator accounts. Can only be called by the
// organization management account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListOrganizationAdminAccounts for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListOrganizationAdminAccounts
func (c *SecurityHub) ListOrganizationAdminAccounts(input *ListOrganizationAdminAccountsInput) (*ListOrganizationAdminAccountsOutput, error) {
	req, out := c.ListOrganizationAdminAccountsRequest(input)
	return out, req.Send()
}

// ListOrganizationAdminAccountsWithContext is the same as ListOrganizationAdminAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListOrganizationAdminAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListOrganizationAdminAccountsWithContext(ctx aws.Context, input *ListOrganizationAdminAccountsInput, opts ...request.Option) (*ListOrganizationAdminAccountsOutput, error) {
	req, out := c.ListOrganizationAdminAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOrganizationAdminAccountsPages iterates over the pages of a ListOrganizationAdminAccounts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOrganizationAdminAccounts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListOrganizationAdminAccounts operation.
//    pageNum := 0
//    err := client.ListOrganizationAdminAccountsPages(params,
//        func(page *securityhub.ListOrganizationAdminAccountsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) ListOrganizationAdminAccountsPages(input *ListOrganizationAdminAccountsInput, fn func(*ListOrganizationAdminAccountsOutput, bool) bool) error {
	return c.ListOrganizationAdminAccountsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOrganizationAdminAccountsPagesWithContext same as ListOrganizationAdminAccountsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListOrganizationAdminAccountsPagesWithContext(ctx aws.Context, input *ListOrganizationAdminAccountsInput, fn func(*ListOrganizationAdminAccountsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOrganizationAdminAccountsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOrganizationAdminAccountsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOrganizationAdminAccountsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListTagsForResource
func (c *SecurityHub) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS SecurityHub.
//
// Returns a list of tags associated with a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListTagsForResource
func (c *SecurityHub) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/TagResource
func (c *SecurityHub) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS SecurityHub.
//
// Adds one or more tags to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/TagResource
func (c *SecurityHub) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UntagResource
func (c *SecurityHub) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS SecurityHub.
//
// Removes one or more tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UntagResource
func (c *SecurityHub) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateActionTarget = "UpdateActionTarget"

// UpdateActionTargetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateActionTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateActionTarget for more information on using the UpdateActionTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateActionTargetRequest method.
//    req, resp := client.UpdateActionTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateActionTarget
func (c *SecurityHub) UpdateActionTargetRequest(input *UpdateActionTargetInput) (req *request.Request, output *UpdateActionTargetOutput) {
	op := &request.Operation{
		Name:       opUpdateActionTarget,
		HTTPMethod: "PATCH",
		HTTPPath:   "/actionTargets/{ActionTargetArn+}",
	}

	if input == nil {
		input = &UpdateActionTargetInput{}
	}

	output = &UpdateActionTargetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateActionTarget API operation for AWS SecurityHub.
//
// Updates the name and description of a custom action target in Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateActionTarget for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateActionTarget
func (c *SecurityHub) UpdateActionTarget(input *UpdateActionTargetInput) (*UpdateActionTargetOutput, error) {
	req, out := c.UpdateActionTargetRequest(input)
	return out, req.Send()
}

// UpdateActionTargetWithContext is the same as UpdateActionTarget with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateActionTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateActionTargetWithContext(ctx aws.Context, input *UpdateActionTargetInput, opts ...request.Option) (*UpdateActionTargetOutput, error) {
	req, out := c.UpdateActionTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFindingAggregator = "UpdateFindingAggregator"

// UpdateFindingAggregatorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFindingAggregator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFindingAggregator for more information on using the UpdateFindingAggregator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFindingAggregatorRequest method.
//    req, resp := client.UpdateFindingAggregatorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindingAggregator
func (c *SecurityHub) UpdateFindingAggregatorRequest(input *UpdateFindingAggregatorInput) (req *request.Request, output *UpdateFindingAggregatorOutput) {
	op := &request.Operation{
		Name:       opUpdateFindingAggregator,
		HTTPMethod: "PATCH",
		HTTPPath:   "/findingAggregator/update",
	}

	if input == nil {
		input = &UpdateFindingAggregatorInput{}
	}

	output = &UpdateFindingAggregatorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFindingAggregator API operation for AWS SecurityHub.
//
// Updates the finding aggregation configuration. Used to update the Region
// linking mode and the list of included or excluded Regions. You cannot use
// UpdateFindingAggregator to change the aggregation Region.
//
// You must run UpdateFindingAggregator from the current aggregation Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateFindingAggregator for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * AccessDeniedException
//   You don't have permission to perform the action specified in the request.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindingAggregator
func (c *SecurityHub) UpdateFindingAggregator(input *UpdateFindingAggregatorInput) (*UpdateFindingAggregatorOutput, error) {
	req, out := c.UpdateFindingAggregatorRequest(input)
	return out, req.Send()
}

// UpdateFindingAggregatorWithContext is the same as UpdateFindingAggregator with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFindingAggregator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateFindingAggregatorWithContext(ctx aws.Context, input *UpdateFindingAggregatorInput, opts ...request.Option) (*UpdateFindingAggregatorOutput, error) {
	req, out := c.UpdateFindingAggregatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFindings = "UpdateFindings"

// UpdateFindingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFindings for more information on using the UpdateFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFindingsRequest method.
//    req, resp := client.UpdateFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindings
func (c *SecurityHub) UpdateFindingsRequest(input *UpdateFindingsInput) (req *request.Request, output *UpdateFindingsOutput) {
	op := &request.Operation{
		Name:       opUpdateFindings,
		HTTPMethod: "PATCH",
		HTTPPath:   "/findings",
	}

	if input == nil {
		input = &UpdateFindingsInput{}
	}

	output = &UpdateFindingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateFindings API operation for AWS SecurityHub.
//
// UpdateFindings is deprecated. Instead of UpdateFindings, use BatchUpdateFindings.
//
// Updates the Note and RecordState of the Security Hub-aggregated findings
// that the filter attributes specify. Any member account that can view the
// finding also sees the update to the finding.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateFindings for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindings
func (c *SecurityHub) UpdateFindings(input *UpdateFindingsInput) (*UpdateFindingsOutput, error) {
	req, out := c.UpdateFindingsRequest(input)
	return out, req.Send()
}

// UpdateFindingsWithContext is the same as UpdateFindings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateFindingsWithContext(ctx aws.Context, input *UpdateFindingsInput, opts ...request.Option) (*UpdateFindingsOutput, error) {
	req, out := c.UpdateFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInsight = "UpdateInsight"

// UpdateInsightRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInsight for more information on using the UpdateInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateInsightRequest method.
//    req, resp := client.UpdateInsightRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateInsight
func (c *SecurityHub) UpdateInsightRequest(input *UpdateInsightInput) (req *request.Request, output *UpdateInsightOutput) {
	op := &request.Operation{
		Name:       opUpdateInsight,
		HTTPMethod: "PATCH",
		HTTPPath:   "/insights/{InsightArn+}",
	}

	if input == nil {
		input = &UpdateInsightInput{}
	}

	output = &UpdateInsightOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateInsight API operation for AWS SecurityHub.
//
// Updates the Security Hub insight identified by the specified insight ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateInsight for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateInsight
func (c *SecurityHub) UpdateInsight(input *UpdateInsightInput) (*UpdateInsightOutput, error) {
	req, out := c.UpdateInsightRequest(input)
	return out, req.Send()
}

// UpdateInsightWithContext is the same as UpdateInsight with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateInsightWithContext(ctx aws.Context, input *UpdateInsightInput, opts ...request.Option) (*UpdateInsightOutput, error) {
	req, out := c.UpdateInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateOrganizationConfiguration = "UpdateOrganizationConfiguration"

// UpdateOrganizationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateOrganizationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateOrganizationConfiguration for more information on using the UpdateOrganizationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateOrganizationConfigurationRequest method.
//    req, resp := client.UpdateOrganizationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateOrganizationConfiguration
func (c *SecurityHub) UpdateOrganizationConfigurationRequest(input *UpdateOrganizationConfigurationInput) (req *request.Request, output *UpdateOrganizationConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateOrganizationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/organization/configuration",
	}

	if input == nil {
		input = &UpdateOrganizationConfigurationInput{}
	}

	output = &UpdateOrganizationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateOrganizationConfiguration API operation for AWS SecurityHub.
//
// Used to update the configuration related to Organizations. Can only be called
// from a Security Hub administrator account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateOrganizationConfiguration for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateOrganizationConfiguration
func (c *SecurityHub) UpdateOrganizationConfiguration(input *UpdateOrganizationConfigurationInput) (*UpdateOrganizationConfigurationOutput, error) {
	req, out := c.UpdateOrganizationConfigurationRequest(input)
	return out, req.Send()
}

// UpdateOrganizationConfigurationWithContext is the same as UpdateOrganizationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateOrganizationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateOrganizationConfigurationWithContext(ctx aws.Context, input *UpdateOrganizationConfigurationInput, opts ...request.Option) (*UpdateOrganizationConfigurationOutput, error) {
	req, out := c.UpdateOrganizationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSecurityHubConfiguration = "UpdateSecurityHubConfiguration"

// UpdateSecurityHubConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSecurityHubConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSecurityHubConfiguration for more information on using the UpdateSecurityHubConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSecurityHubConfigurationRequest method.
//    req, resp := client.UpdateSecurityHubConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateSecurityHubConfiguration
func (c *SecurityHub) UpdateSecurityHubConfigurationRequest(input *UpdateSecurityHubConfigurationInput) (req *request.Request, output *UpdateSecurityHubConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateSecurityHubConfiguration,
		HTTPMethod: "PATCH",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &UpdateSecurityHubConfigurationInput{}
	}

	output = &UpdateSecurityHubConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateSecurityHubConfiguration API operation for AWS SecurityHub.
//
// Updates configuration options for Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateSecurityHubConfiguration for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current Amazon Web Services account or throttling limits. The error code
//   describes the limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateSecurityHubConfiguration
func (c *SecurityHub) UpdateSecurityHubConfiguration(input *UpdateSecurityHubConfigurationInput) (*UpdateSecurityHubConfigurationOutput, error) {
	req, out := c.UpdateSecurityHubConfigurationRequest(input)
	return out, req.Send()
}

// UpdateSecurityHubConfigurationWithContext is the same as UpdateSecurityHubConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSecurityHubConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateSecurityHubConfigurationWithContext(ctx aws.Context, input *UpdateSecurityHubConfigurationInput, opts ...request.Option) (*UpdateSecurityHubConfigurationOutput, error) {
	req, out := c.UpdateSecurityHubConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStandardsControl = "UpdateStandardsControl"

// UpdateStandardsControlRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStandardsControl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStandardsControl for more information on using the UpdateStandardsControl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStandardsControlRequest method.
//    req, resp := client.UpdateStandardsControlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateStandardsControl
func (c *SecurityHub) UpdateStandardsControlRequest(input *UpdateStandardsControlInput) (req *request.Request, output *UpdateStandardsControlOutput) {
	op := &request.Operation{
		Name:       opUpdateStandardsControl,
		HTTPMethod: "PATCH",
		HTTPPath:   "/standards/control/{StandardsControlArn+}",
	}

	if input == nil {
		input = &UpdateStandardsControlInput{}
	}

	output = &UpdateStandardsControlOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateStandardsControl API operation for AWS SecurityHub.
//
// Used to control whether an individual security standard control is enabled
// or disabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateStandardsControl for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateStandardsControl
func (c *SecurityHub) UpdateStandardsControl(input *UpdateStandardsControlInput) (*UpdateStandardsControlOutput, error) {
	req, out := c.UpdateStandardsControlRequest(input)
	return out, req.Send()
}

// UpdateStandardsControlWithContext is the same as UpdateStandardsControl with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStandardsControl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateStandardsControlWithContext(ctx aws.Context, input *UpdateStandardsControlInput, opts ...request.Option) (*UpdateStandardsControlOutput, error) {
	req, out := c.UpdateStandardsControlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptAdministratorInvitationInput struct {
	_ struct{} `type:"structure"`

	// The account ID of the Security Hub administrator account that sent the invitation.
	//
	// AdministratorId is a required field
	AdministratorId *string `type:"string" required:"true"`

	// The identifier of the invitation sent from the Security Hub administrator
	// account.
	//
	// InvitationId is a required field
	InvitationId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptAdministratorInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptAdministratorInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptAdministratorInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptAdministratorInvitationInput"}
	if s.AdministratorId == nil {
		invalidParams.Add(request.NewErrParamRequired("AdministratorId"))
	}
	if s.InvitationId == nil {
		invalidParams.Add(request.NewErrParamRequired("InvitationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdministratorId sets the AdministratorId field's value.
func (s *AcceptAdministratorInvitationInput) SetAdministratorId(v string) *AcceptAdministratorInvitationInput {
	s.AdministratorId = &v
	return s
}

// SetInvitationId sets the InvitationId field's value.
func (s *AcceptAdministratorInvitationInput) SetInvitationId(v string) *AcceptAdministratorInvitationInput {
	s.InvitationId = &v
	return s
}

type AcceptAdministratorInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptAdministratorInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptAdministratorInvitationOutput) GoString() string {
	return s.String()
}

type AcceptInvitationInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the invitation sent from the Security Hub administrator
	// account.
	//
	// InvitationId is a required field
	InvitationId *string `type:"string" required:"true"`

	// The account ID of the Security Hub administrator account that sent the invitation.
	//
	// MasterId is a required field
	MasterId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptInvitationInput"}
	if s.InvitationId == nil {
		invalidParams.Add(request.NewErrParamRequired("InvitationId"))
	}
	if s.MasterId == nil {
		invalidParams.Add(request.NewErrParamRequired("MasterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInvitationId sets the InvitationId field's value.
func (s *AcceptInvitationInput) SetInvitationId(v string) *AcceptInvitationInput {
	s.InvitationId = &v
	return s
}

// SetMasterId sets the MasterId field's value.
func (s *AcceptInvitationInput) SetMasterId(v string) *AcceptInvitationInput {
	s.MasterId = &v
	return s
}

type AcceptInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInvitationOutput) GoString() string {
	return s.String()
}

// You don't have permission to perform the action specified in the request.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The details of an Amazon Web Services account.
type AccountDetails struct {
	_ struct{} `type:"structure"`

	// The ID of an Amazon Web Services account.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The email of an Amazon Web Services account.
	Email *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccountDetails"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AccountDetails) SetAccountId(v string) *AccountDetails {
	s.AccountId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *AccountDetails) SetEmail(v string) *AccountDetails {
	s.Email = &v
	return s
}

// Provides details about one of the following actions that affects or that
// was taken on a resource:
//
//    * A remote IP address issued an Amazon Web Services API call
//
//    * A DNS request was received
//
//    * A remote IP address attempted to connect to an EC2 instance
//
//    * A remote IP address attempted a port probe on an EC2 instance
type Action struct {
	_ struct{} `type:"structure"`

	// The type of action that was detected. The possible action types are:
	//
	//    * NETWORK_CONNECTION
	//
	//    * AWS_API_CALL
	//
	//    * DNS_REQUEST
	//
	//    * PORT_PROBE
	ActionType *string `type:"string"`

	// Included if ActionType is AWS_API_CALL. Provides details about the API call
	// that was detected.
	AwsApiCallAction *AwsApiCallAction `type:"structure"`

	// Included if ActionType is DNS_REQUEST. Provides details about the DNS request
	// that was detected.
	DnsRequestAction *DnsRequestAction `type:"structure"`

	// Included if ActionType is NETWORK_CONNECTION. Provides details about the
	// network connection that was detected.
	NetworkConnectionAction *NetworkConnectionAction `type:"structure"`

	// Included if ActionType is PORT_PROBE. Provides details about the port probe
	// that was detected.
	PortProbeAction *PortProbeAction `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Action) GoString() string {
	return s.String()
}

// SetActionType sets the ActionType field's value.
func (s *Action) SetActionType(v string) *Action {
	s.ActionType = &v
	return s
}

// SetAwsApiCallAction sets the AwsApiCallAction field's value.
func (s *Action) SetAwsApiCallAction(v *AwsApiCallAction) *Action {
	s.AwsApiCallAction = v
	return s
}

// SetDnsRequestAction sets the DnsRequestAction field's value.
func (s *Action) SetDnsRequestAction(v *DnsRequestAction) *Action {
	s.DnsRequestAction = v
	return s
}

// SetNetworkConnectionAction sets the NetworkConnectionAction field's value.
func (s *Action) SetNetworkConnectionAction(v *NetworkConnectionAction) *Action {
	s.NetworkConnectionAction = v
	return s
}

// SetPortProbeAction sets the PortProbeAction field's value.
func (s *Action) SetPortProbeAction(v *PortProbeAction) *Action {
	s.PortProbeAction = v
	return s
}

// Provides information about the IP address where the scanned port is located.
type ActionLocalIpDetails struct {
	_ struct{} `type:"structure"`

	// The IP address.
	IpAddressV4 *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionLocalIpDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionLocalIpDetails) GoString() string {
	return s.String()
}

// SetIpAddressV4 sets the IpAddressV4 field's value.
func (s *ActionLocalIpDetails) SetIpAddressV4(v string) *ActionLocalIpDetails {
	s.IpAddressV4 = &v
	return s
}

// For NetworkConnectionAction and PortProbeDetails, LocalPortDetails provides
// information about the local port that was involved in the action.
type ActionLocalPortDetails struct {
	_ struct{} `type:"structure"`

	// The number of the port.
	Port *int64 `type:"integer"`

	// The port name of the local connection.
	PortName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionLocalPortDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionLocalPortDetails) GoString() string {
	return s.String()
}

// SetPort sets the Port field's value.
func (s *ActionLocalPortDetails) SetPort(v int64) *ActionLocalPortDetails {
	s.Port = &v
	return s
}

// SetPortName sets the PortName field's value.
func (s *ActionLocalPortDetails) SetPortName(v string) *ActionLocalPortDetails {
	s.PortName = &v
	return s
}

// For AwsApiAction, NetworkConnectionAction, and PortProbeAction, RemoteIpDetails
// provides information about the remote IP address that was involved in the
// action.
type ActionRemoteIpDetails struct {
	_ struct{} `type:"structure"`

	// The city where the remote IP address is located.
	City *City `type:"structure"`

	// The country where the remote IP address is located.
	Country *Country `type:"structure"`

	// The coordinates of the location of the remote IP address.
	GeoLocation *GeoLocation `type:"structure"`

	// The IP address.
	IpAddressV4 *string `type:"string"`

	// The internet service provider (ISP) organization associated with the remote
	// IP address.
	Organization *IpOrganizationDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionRemoteIpDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionRemoteIpDetails) GoString() string {
	return s.String()
}

// SetCity sets the City field's value.
func (s *ActionRemoteIpDetails) SetCity(v *City) *ActionRemoteIpDetails {
	s.City = v
	return s
}

// SetCountry sets the Country field's value.
func (s *ActionRemoteIpDetails) SetCountry(v *Country) *ActionRemoteIpDetails {
	s.Country = v
	return s
}

// SetGeoLocation sets the GeoLocation field's value.
func (s *ActionRemoteIpDetails) SetGeoLocation(v *GeoLocation) *ActionRemoteIpDetails {
	s.GeoLocation = v
	return s
}

// SetIpAddressV4 sets the IpAddressV4 field's value.
func (s *ActionRemoteIpDetails) SetIpAddressV4(v string) *ActionRemoteIpDetails {
	s.IpAddressV4 = &v
	return s
}

// SetOrganization sets the Organization field's value.
func (s *ActionRemoteIpDetails) SetOrganization(v *IpOrganizationDetails) *ActionRemoteIpDetails {
	s.Organization = v
	return s
}

// Provides information about the remote port that was involved in an attempted
// network connection.
type ActionRemotePortDetails struct {
	_ struct{} `type:"structure"`

	// The number of the port.
	Port *int64 `type:"integer"`

	// The port name of the remote connection.
	PortName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionRemotePortDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionRemotePortDetails) GoString() string {
	return s.String()
}

// SetPort sets the Port field's value.
func (s *ActionRemotePortDetails) SetPort(v int64) *ActionRemotePortDetails {
	s.Port = &v
	return s
}

// SetPortName sets the PortName field's value.
func (s *ActionRemotePortDetails) SetPortName(v string) *ActionRemotePortDetails {
	s.PortName = &v
	return s
}

// An ActionTarget object.
type ActionTarget struct {
	_ struct{} `type:"structure"`

	// The ARN for the target action.
	//
	// ActionTargetArn is a required field
	ActionTargetArn *string `type:"string" required:"true"`

	// The description of the target action.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The name of the action target.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionTarget) GoString() string {
	return s.String()
}

// SetActionTargetArn sets the ActionTargetArn field's value.
func (s *ActionTarget) SetActionTargetArn(v string) *ActionTarget {
	s.ActionTargetArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ActionTarget) SetDescription(v string) *ActionTarget {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *ActionTarget) SetName(v string) *ActionTarget {
	s.Name = &v
	return s
}

// An adjustment to the CVSS metric.
type Adjustment struct {
	_ struct{} `type:"structure"`

	// The metric to adjust.
	Metric *string `type:"string"`

	// The reason for the adjustment.
	Reason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Adjustment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Adjustment) GoString() string {
	return s.String()
}

// SetMetric sets the Metric field's value.
func (s *Adjustment) SetMetric(v string) *Adjustment {
	s.Metric = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *Adjustment) SetReason(v string) *Adjustment {
	s.Reason = &v
	return s
}

// Represents a Security Hub administrator account designated by an organization
// management account.
type AdminAccount struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account identifier of the Security Hub administrator
	// account.
	AccountId *string `type:"string"`

	// The current status of the Security Hub administrator account. Indicates whether
	// the account is currently enabled as a Security Hub administrator.
	Status *string `type:"string" enum:"AdminStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminAccount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdminAccount) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AdminAccount) SetAccountId(v string) *AdminAccount {
	s.AccountId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AdminAccount) SetStatus(v string) *AdminAccount {
	s.Status = &v
	return s
}

// Information about an Availability Zone.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The ID of the subnet. You can specify one subnet per Availability Zone.
	SubnetId *string `type:"string"`

	// The name of the Availability Zone.
	ZoneName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetSubnetId sets the SubnetId field's value.
func (s *AvailabilityZone) SetSubnetId(v string) *AvailabilityZone {
	s.SubnetId = &v
	return s
}

// SetZoneName sets the ZoneName field's value.
func (s *AvailabilityZone) SetZoneName(v string) *AvailabilityZone {
	s.ZoneName = &v
	return s
}

// Provided if ActionType is AWS_API_CALL. It provides details about the API
// call that was detected.
type AwsApiCallAction struct {
	_ struct{} `type:"structure"`

	// Identifies the resources that were affected by the API call.
	AffectedResources map[string]*string `type:"map"`

	// The name of the API method that was issued.
	Api *string `type:"string"`

	// Indicates whether the API call originated from a remote IP address (remoteip)
	// or from a DNS domain (domain).
	CallerType *string `type:"string"`

	// Provided if CallerType is domain. Provides information about the DNS domain
	// that the API call originated from.
	DomainDetails *AwsApiCallActionDomainDetails `type:"structure"`

	// An ISO8601-formatted timestamp that indicates when the API call was first
	// observed.
	FirstSeen *string `type:"string"`

	// An ISO8601-formatted timestamp that indicates when the API call was most
	// recently observed.
	LastSeen *string `type:"string"`

	// Provided if CallerType is remoteIp. Provides information about the remote
	// IP address that the API call originated from.
	RemoteIpDetails *ActionRemoteIpDetails `type:"structure"`

	// The name of the Amazon Web Services service that the API method belongs to.
	ServiceName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiCallAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiCallAction) GoString() string {
	return s.String()
}

// SetAffectedResources sets the AffectedResources field's value.
func (s *AwsApiCallAction) SetAffectedResources(v map[string]*string) *AwsApiCallAction {
	s.AffectedResources = v
	return s
}

// SetApi sets the Api field's value.
func (s *AwsApiCallAction) SetApi(v string) *AwsApiCallAction {
	s.Api = &v
	return s
}

// SetCallerType sets the CallerType field's value.
func (s *AwsApiCallAction) SetCallerType(v string) *AwsApiCallAction {
	s.CallerType = &v
	return s
}

// SetDomainDetails sets the DomainDetails field's value.
func (s *AwsApiCallAction) SetDomainDetails(v *AwsApiCallActionDomainDetails) *AwsApiCallAction {
	s.DomainDetails = v
	return s
}

// SetFirstSeen sets the FirstSeen field's value.
func (s *AwsApiCallAction) SetFirstSeen(v string) *AwsApiCallAction {
	s.FirstSeen = &v
	return s
}

// SetLastSeen sets the LastSeen field's value.
func (s *AwsApiCallAction) SetLastSeen(v string) *AwsApiCallAction {
	s.LastSeen = &v
	return s
}

// SetRemoteIpDetails sets the RemoteIpDetails field's value.
func (s *AwsApiCallAction) SetRemoteIpDetails(v *ActionRemoteIpDetails) *AwsApiCallAction {
	s.RemoteIpDetails = v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *AwsApiCallAction) SetServiceName(v string) *AwsApiCallAction {
	s.ServiceName = &v
	return s
}

// Provided if CallerType is domain. It provides information about the DNS domain
// that issued the API call.
type AwsApiCallActionDomainDetails struct {
	_ struct{} `type:"structure"`

	// The name of the DNS domain that issued the API call.
	Domain *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiCallActionDomainDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiCallActionDomainDetails) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *AwsApiCallActionDomainDetails) SetDomain(v string) *AwsApiCallActionDomainDetails {
	s.Domain = &v
	return s
}

// Contains information about settings for logging access for the stage.
type AwsApiGatewayAccessLogSettings struct {
	_ struct{} `type:"structure"`

	// The ARN of the CloudWatch Logs log group that receives the access logs.
	DestinationArn *string `type:"string"`

	// A single-line format of the access logs of data, as specified by selected
	// $context variables. The format must include at least $context.requestId.
	Format *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayAccessLogSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayAccessLogSettings) GoString() string {
	return s.String()
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *AwsApiGatewayAccessLogSettings) SetDestinationArn(v string) *AwsApiGatewayAccessLogSettings {
	s.DestinationArn = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *AwsApiGatewayAccessLogSettings) SetFormat(v string) *AwsApiGatewayAccessLogSettings {
	s.Format = &v
	return s
}

// Contains information about settings for canary deployment in the stage.
type AwsApiGatewayCanarySettings struct {
	_ struct{} `type:"structure"`

	// The deployment identifier for the canary deployment.
	DeploymentId *string `type:"string"`

	// The percentage of traffic that is diverted to a canary deployment.
	PercentTraffic *float64 `type:"double"`

	// Stage variables that are overridden in the canary release deployment. The
	// variables include new stage variables that are introduced in the canary.
	//
	// Each variable is represented as a string-to-string map between the stage
	// variable name and the variable value.
	StageVariableOverrides map[string]*string `type:"map"`

	// Indicates whether the canary deployment uses the stage cache.
	UseStageCache *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayCanarySettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayCanarySettings) GoString() string {
	return s.String()
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *AwsApiGatewayCanarySettings) SetDeploymentId(v string) *AwsApiGatewayCanarySettings {
	s.DeploymentId = &v
	return s
}

// SetPercentTraffic sets the PercentTraffic field's value.
func (s *AwsApiGatewayCanarySettings) SetPercentTraffic(v float64) *AwsApiGatewayCanarySettings {
	s.PercentTraffic = &v
	return s
}

// SetStageVariableOverrides sets the StageVariableOverrides field's value.
func (s *AwsApiGatewayCanarySettings) SetStageVariableOverrides(v map[string]*string) *AwsApiGatewayCanarySettings {
	s.StageVariableOverrides = v
	return s
}

// SetUseStageCache sets the UseStageCache field's value.
func (s *AwsApiGatewayCanarySettings) SetUseStageCache(v bool) *AwsApiGatewayCanarySettings {
	s.UseStageCache = &v
	return s
}

// Contains information about the endpoints for the API.
type AwsApiGatewayEndpointConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of endpoint types for the REST API.
	//
	// For an edge-optimized API, the endpoint type is EDGE. For a Regional API,
	// the endpoint type is REGIONAL. For a private API, the endpoint type is PRIVATE.
	Types []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayEndpointConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayEndpointConfiguration) GoString() string {
	return s.String()
}

// SetTypes sets the Types field's value.
func (s *AwsApiGatewayEndpointConfiguration) SetTypes(v []*string) *AwsApiGatewayEndpointConfiguration {
	s.Types = v
	return s
}

// Defines settings for a method for the stage.
type AwsApiGatewayMethodSettings struct {
	_ struct{} `type:"structure"`

	// Indicates whether the cached responses are encrypted.
	CacheDataEncrypted *bool `type:"boolean"`

	// Specifies the time to live (TTL), in seconds, for cached responses. The higher
	// the TTL, the longer the response is cached.
	CacheTtlInSeconds *int64 `type:"integer"`

	// Indicates whether responses are cached and returned for requests. For responses
	// to be cached, a cache cluster must be enabled on the stage.
	CachingEnabled *bool `type:"boolean"`

	// Indicates whether data trace logging is enabled for the method. Data trace
	// logging affects the log entries that are pushed to CloudWatch Logs.
	DataTraceEnabled *bool `type:"boolean"`

	// The HTTP method. You can use an asterisk (*) as a wildcard to apply method
	// settings to multiple methods.
	HttpMethod *string `type:"string"`

	// The logging level for this method. The logging level affects the log entries
	// that are pushed to CloudWatch Logs.
	//
	// If the logging level is ERROR, then the logs only include error-level entries.
	//
	// If the logging level is INFO, then the logs include both ERROR events and
	// extra informational events.
	//
	// Valid values: OFF | ERROR | INFO
	LoggingLevel *string `type:"string"`

	// Indicates whether CloudWatch metrics are enabled for the method.
	MetricsEnabled *bool `type:"boolean"`

	// Indicates whether authorization is required for a cache invalidation request.
	RequireAuthorizationForCacheControl *bool `type:"boolean"`

	// The resource path for this method. Forward slashes (/) are encoded as ~1
	// . The initial slash must include a forward slash.
	//
	// For example, the path value /resource/subresource must be encoded as /~1resource~1subresource.
	//
	// To specify the root path, use only a slash (/). You can use an asterisk (*)
	// as a wildcard to apply method settings to multiple methods.
	ResourcePath *string `type:"string"`

	// The throttling burst limit for the method.
	ThrottlingBurstLimit *int64 `type:"integer"`

	// The throttling rate limit for the method.
	ThrottlingRateLimit *float64 `type:"double"`

	// Indicates how to handle unauthorized requests for cache invalidation.
	//
	// Valid values: FAIL_WITH_403 | SUCCEED_WITH_RESPONSE_HEADER | SUCCEED_WITHOUT_RESPONSE_HEADER
	UnauthorizedCacheControlHeaderStrategy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayMethodSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayMethodSettings) GoString() string {
	return s.String()
}

// SetCacheDataEncrypted sets the CacheDataEncrypted field's value.
func (s *AwsApiGatewayMethodSettings) SetCacheDataEncrypted(v bool) *AwsApiGatewayMethodSettings {
	s.CacheDataEncrypted = &v
	return s
}

// SetCacheTtlInSeconds sets the CacheTtlInSeconds field's value.
func (s *AwsApiGatewayMethodSettings) SetCacheTtlInSeconds(v int64) *AwsApiGatewayMethodSettings {
	s.CacheTtlInSeconds = &v
	return s
}

// SetCachingEnabled sets the CachingEnabled field's value.
func (s *AwsApiGatewayMethodSettings) SetCachingEnabled(v bool) *AwsApiGatewayMethodSettings {
	s.CachingEnabled = &v
	return s
}

// SetDataTraceEnabled sets the DataTraceEnabled field's value.
func (s *AwsApiGatewayMethodSettings) SetDataTraceEnabled(v bool) *AwsApiGatewayMethodSettings {
	s.DataTraceEnabled = &v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *AwsApiGatewayMethodSettings) SetHttpMethod(v string) *AwsApiGatewayMethodSettings {
	s.HttpMethod = &v
	return s
}

// SetLoggingLevel sets the LoggingLevel field's value.
func (s *AwsApiGatewayMethodSettings) SetLoggingLevel(v string) *AwsApiGatewayMethodSettings {
	s.LoggingLevel = &v
	return s
}

// SetMetricsEnabled sets the MetricsEnabled field's value.
func (s *AwsApiGatewayMethodSettings) SetMetricsEnabled(v bool) *AwsApiGatewayMethodSettings {
	s.MetricsEnabled = &v
	return s
}

// SetRequireAuthorizationForCacheControl sets the RequireAuthorizationForCacheControl field's value.
func (s *AwsApiGatewayMethodSettings) SetRequireAuthorizationForCacheControl(v bool) *AwsApiGatewayMethodSettings {
	s.RequireAuthorizationForCacheControl = &v
	return s
}

// SetResourcePath sets the ResourcePath field's value.
func (s *AwsApiGatewayMethodSettings) SetResourcePath(v string) *AwsApiGatewayMethodSettings {
	s.ResourcePath = &v
	return s
}

// SetThrottlingBurstLimit sets the ThrottlingBurstLimit field's value.
func (s *AwsApiGatewayMethodSettings) SetThrottlingBurstLimit(v int64) *AwsApiGatewayMethodSettings {
	s.ThrottlingBurstLimit = &v
	return s
}

// SetThrottlingRateLimit sets the ThrottlingRateLimit field's value.
func (s *AwsApiGatewayMethodSettings) SetThrottlingRateLimit(v float64) *AwsApiGatewayMethodSettings {
	s.ThrottlingRateLimit = &v
	return s
}

// SetUnauthorizedCacheControlHeaderStrategy sets the UnauthorizedCacheControlHeaderStrategy field's value.
func (s *AwsApiGatewayMethodSettings) SetUnauthorizedCacheControlHeaderStrategy(v string) *AwsApiGatewayMethodSettings {
	s.UnauthorizedCacheControlHeaderStrategy = &v
	return s
}

// Contains information about a REST API in version 1 of Amazon API Gateway.
type AwsApiGatewayRestApiDetails struct {
	_ struct{} `type:"structure"`

	// The source of the API key for metering requests according to a usage plan.
	//
	// HEADER indicates whether to read the API key from the X-API-Key header of
	// a request.
	//
	// AUTHORIZER indicates whether to read the API key from the UsageIdentifierKey
	// from a custom authorizer.
	ApiKeySource *string `type:"string"`

	// The list of binary media types supported by the REST API.
	BinaryMediaTypes []*string `type:"list"`

	// Indicates when the API was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedDate *string `type:"string"`

	// A description of the REST API.
	Description *string `type:"string"`

	// The endpoint configuration of the REST API.
	EndpointConfiguration *AwsApiGatewayEndpointConfiguration `type:"structure"`

	// The identifier of the REST API.
	Id *string `type:"string"`

	// The minimum size in bytes of a payload before compression is enabled.
	//
	// If null, then compression is disabled.
	//
	// If 0, then all payloads are compressed.
	MinimumCompressionSize *int64 `type:"integer"`

	// The name of the REST API.
	Name *string `type:"string"`

	// The version identifier for the REST API.
	Version *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayRestApiDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayRestApiDetails) GoString() string {
	return s.String()
}

// SetApiKeySource sets the ApiKeySource field's value.
func (s *AwsApiGatewayRestApiDetails) SetApiKeySource(v string) *AwsApiGatewayRestApiDetails {
	s.ApiKeySource = &v
	return s
}

// SetBinaryMediaTypes sets the BinaryMediaTypes field's value.
func (s *AwsApiGatewayRestApiDetails) SetBinaryMediaTypes(v []*string) *AwsApiGatewayRestApiDetails {
	s.BinaryMediaTypes = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AwsApiGatewayRestApiDetails) SetCreatedDate(v string) *AwsApiGatewayRestApiDetails {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsApiGatewayRestApiDetails) SetDescription(v string) *AwsApiGatewayRestApiDetails {
	s.Description = &v
	return s
}

// SetEndpointConfiguration sets the EndpointConfiguration field's value.
func (s *AwsApiGatewayRestApiDetails) SetEndpointConfiguration(v *AwsApiGatewayEndpointConfiguration) *AwsApiGatewayRestApiDetails {
	s.EndpointConfiguration = v
	return s
}

// SetId sets the Id field's value.
func (s *AwsApiGatewayRestApiDetails) SetId(v string) *AwsApiGatewayRestApiDetails {
	s.Id = &v
	return s
}

// SetMinimumCompressionSize sets the MinimumCompressionSize field's value.
func (s *AwsApiGatewayRestApiDetails) SetMinimumCompressionSize(v int64) *AwsApiGatewayRestApiDetails {
	s.MinimumCompressionSize = &v
	return s
}

// SetName sets the Name field's value.
func (s *AwsApiGatewayRestApiDetails) SetName(v string) *AwsApiGatewayRestApiDetails {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsApiGatewayRestApiDetails) SetVersion(v string) *AwsApiGatewayRestApiDetails {
	s.Version = &v
	return s
}

// Provides information about a version 1 Amazon API Gateway stage.
type AwsApiGatewayStageDetails struct {
	_ struct{} `type:"structure"`

	// Settings for logging access for the stage.
	AccessLogSettings *AwsApiGatewayAccessLogSettings `type:"structure"`

	// Indicates whether a cache cluster is enabled for the stage.
	CacheClusterEnabled *bool `type:"boolean"`

	// If a cache cluster is enabled, the size of the cache cluster.
	CacheClusterSize *string `type:"string"`

	// If a cache cluster is enabled, the status of the cache cluster.
	CacheClusterStatus *string `type:"string"`

	// Information about settings for canary deployment in the stage.
	CanarySettings *AwsApiGatewayCanarySettings `type:"structure"`

	// The identifier of the client certificate for the stage.
	ClientCertificateId *string `type:"string"`

	// Indicates when the stage was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedDate *string `type:"string"`

	// The identifier of the deployment that the stage points to.
	DeploymentId *string `type:"string"`

	// A description of the stage.
	Description *string `type:"string"`

	// The version of the API documentation that is associated with the stage.
	DocumentationVersion *string `type:"string"`

	// Indicates when the stage was most recently updated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastUpdatedDate *string `type:"string"`

	// Defines the method settings for the stage.
	MethodSettings []*AwsApiGatewayMethodSettings `type:"list"`

	// The name of the stage.
	StageName *string `type:"string"`

	// Indicates whether active tracing with X-Ray is enabled for the stage.
	TracingEnabled *bool `type:"boolean"`

	// A map that defines the stage variables for the stage.
	//
	// Variable names can have alphanumeric and underscore characters.
	//
	// Variable values can contain the following characters:
	//
	//    * Uppercase and lowercase letters
	//
	//    * Numbers
	//
	//    * Special characters -._~:/?#&=,
	Variables map[string]*string `type:"map"`

	// The ARN of the web ACL associated with the stage.
	WebAclArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayStageDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayStageDetails) GoString() string {
	return s.String()
}

// SetAccessLogSettings sets the AccessLogSettings field's value.
func (s *AwsApiGatewayStageDetails) SetAccessLogSettings(v *AwsApiGatewayAccessLogSettings) *AwsApiGatewayStageDetails {
	s.AccessLogSettings = v
	return s
}

// SetCacheClusterEnabled sets the CacheClusterEnabled field's value.
func (s *AwsApiGatewayStageDetails) SetCacheClusterEnabled(v bool) *AwsApiGatewayStageDetails {
	s.CacheClusterEnabled = &v
	return s
}

// SetCacheClusterSize sets the CacheClusterSize field's value.
func (s *AwsApiGatewayStageDetails) SetCacheClusterSize(v string) *AwsApiGatewayStageDetails {
	s.CacheClusterSize = &v
	return s
}

// SetCacheClusterStatus sets the CacheClusterStatus field's value.
func (s *AwsApiGatewayStageDetails) SetCacheClusterStatus(v string) *AwsApiGatewayStageDetails {
	s.CacheClusterStatus = &v
	return s
}

// SetCanarySettings sets the CanarySettings field's value.
func (s *AwsApiGatewayStageDetails) SetCanarySettings(v *AwsApiGatewayCanarySettings) *AwsApiGatewayStageDetails {
	s.CanarySettings = v
	return s
}

// SetClientCertificateId sets the ClientCertificateId field's value.
func (s *AwsApiGatewayStageDetails) SetClientCertificateId(v string) *AwsApiGatewayStageDetails {
	s.ClientCertificateId = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AwsApiGatewayStageDetails) SetCreatedDate(v string) *AwsApiGatewayStageDetails {
	s.CreatedDate = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *AwsApiGatewayStageDetails) SetDeploymentId(v string) *AwsApiGatewayStageDetails {
	s.DeploymentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsApiGatewayStageDetails) SetDescription(v string) *AwsApiGatewayStageDetails {
	s.Description = &v
	return s
}

// SetDocumentationVersion sets the DocumentationVersion field's value.
func (s *AwsApiGatewayStageDetails) SetDocumentationVersion(v string) *AwsApiGatewayStageDetails {
	s.DocumentationVersion = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *AwsApiGatewayStageDetails) SetLastUpdatedDate(v string) *AwsApiGatewayStageDetails {
	s.LastUpdatedDate = &v
	return s
}

// SetMethodSettings sets the MethodSettings field's value.
func (s *AwsApiGatewayStageDetails) SetMethodSettings(v []*AwsApiGatewayMethodSettings) *AwsApiGatewayStageDetails {
	s.MethodSettings = v
	return s
}

// SetStageName sets the StageName field's value.
func (s *AwsApiGatewayStageDetails) SetStageName(v string) *AwsApiGatewayStageDetails {
	s.StageName = &v
	return s
}

// SetTracingEnabled sets the TracingEnabled field's value.
func (s *AwsApiGatewayStageDetails) SetTracingEnabled(v bool) *AwsApiGatewayStageDetails {
	s.TracingEnabled = &v
	return s
}

// SetVariables sets the Variables field's value.
func (s *AwsApiGatewayStageDetails) SetVariables(v map[string]*string) *AwsApiGatewayStageDetails {
	s.Variables = v
	return s
}

// SetWebAclArn sets the WebAclArn field's value.
func (s *AwsApiGatewayStageDetails) SetWebAclArn(v string) *AwsApiGatewayStageDetails {
	s.WebAclArn = &v
	return s
}

// Contains information about a version 2 API in Amazon API Gateway.
type AwsApiGatewayV2ApiDetails struct {
	_ struct{} `type:"structure"`

	// The URI of the API.
	//
	// Uses the format <api-id>.execute-api.<region>.amazonaws.com
	//
	// The stage name is typically appended to the URI to form a complete path to
	// a deployed API stage.
	ApiEndpoint *string `type:"string"`

	// The identifier of the API.
	ApiId *string `type:"string"`

	// An API key selection expression. Supported only for WebSocket APIs.
	ApiKeySelectionExpression *string `type:"string"`

	// A cross-origin resource sharing (CORS) configuration. Supported only for
	// HTTP APIs.
	CorsConfiguration *AwsCorsConfiguration `type:"structure"`

	// Indicates when the API was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedDate *string `type:"string"`

	// A description of the API.
	Description *string `type:"string"`

	// The name of the API.
	Name *string `type:"string"`

	// The API protocol for the API.
	//
	// Valid values: WEBSOCKET | HTTP
	ProtocolType *string `type:"string"`

	// The route selection expression for the API.
	//
	// For HTTP APIs, must be ${request.method} ${request.path}. This is the default
	// value for HTTP APIs.
	//
	// For WebSocket APIs, there is no default value.
	RouteSelectionExpression *string `type:"string"`

	// The version identifier for the API.
	Version *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayV2ApiDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayV2ApiDetails) GoString() string {
	return s.String()
}

// SetApiEndpoint sets the ApiEndpoint field's value.
func (s *AwsApiGatewayV2ApiDetails) SetApiEndpoint(v string) *AwsApiGatewayV2ApiDetails {
	s.ApiEndpoint = &v
	return s
}

// SetApiId sets the ApiId field's value.
func (s *AwsApiGatewayV2ApiDetails) SetApiId(v string) *AwsApiGatewayV2ApiDetails {
	s.ApiId = &v
	return s
}

// SetApiKeySelectionExpression sets the ApiKeySelectionExpression field's value.
func (s *AwsApiGatewayV2ApiDetails) SetApiKeySelectionExpression(v string) *AwsApiGatewayV2ApiDetails {
	s.ApiKeySelectionExpression = &v
	return s
}

// SetCorsConfiguration sets the CorsConfiguration field's value.
func (s *AwsApiGatewayV2ApiDetails) SetCorsConfiguration(v *AwsCorsConfiguration) *AwsApiGatewayV2ApiDetails {
	s.CorsConfiguration = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AwsApiGatewayV2ApiDetails) SetCreatedDate(v string) *AwsApiGatewayV2ApiDetails {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsApiGatewayV2ApiDetails) SetDescription(v string) *AwsApiGatewayV2ApiDetails {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *AwsApiGatewayV2ApiDetails) SetName(v string) *AwsApiGatewayV2ApiDetails {
	s.Name = &v
	return s
}

// SetProtocolType sets the ProtocolType field's value.
func (s *AwsApiGatewayV2ApiDetails) SetProtocolType(v string) *AwsApiGatewayV2ApiDetails {
	s.ProtocolType = &v
	return s
}

// SetRouteSelectionExpression sets the RouteSelectionExpression field's value.
func (s *AwsApiGatewayV2ApiDetails) SetRouteSelectionExpression(v string) *AwsApiGatewayV2ApiDetails {
	s.RouteSelectionExpression = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsApiGatewayV2ApiDetails) SetVersion(v string) *AwsApiGatewayV2ApiDetails {
	s.Version = &v
	return s
}

// Contains route settings for a stage.
type AwsApiGatewayV2RouteSettings struct {
	_ struct{} `type:"structure"`

	// Indicates whether data trace logging is enabled. Data trace logging affects
	// the log entries that are pushed to CloudWatch Logs. Supported only for WebSocket
	// APIs.
	DataTraceEnabled *bool `type:"boolean"`

	// Indicates whether detailed metrics are enabled.
	DetailedMetricsEnabled *bool `type:"boolean"`

	// The logging level. The logging level affects the log entries that are pushed
	// to CloudWatch Logs. Supported only for WebSocket APIs.
	//
	// If the logging level is ERROR, then the logs only include error-level entries.
	//
	// If the logging level is INFO, then the logs include both ERROR events and
	// extra informational events.
	//
	// Valid values: OFF | ERROR | INFO
	LoggingLevel *string `type:"string"`

	// The throttling burst limit.
	ThrottlingBurstLimit *int64 `type:"integer"`

	// The throttling rate limit.
	ThrottlingRateLimit *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayV2RouteSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayV2RouteSettings) GoString() string {
	return s.String()
}

// SetDataTraceEnabled sets the DataTraceEnabled field's value.
func (s *AwsApiGatewayV2RouteSettings) SetDataTraceEnabled(v bool) *AwsApiGatewayV2RouteSettings {
	s.DataTraceEnabled = &v
	return s
}

// SetDetailedMetricsEnabled sets the DetailedMetricsEnabled field's value.
func (s *AwsApiGatewayV2RouteSettings) SetDetailedMetricsEnabled(v bool) *AwsApiGatewayV2RouteSettings {
	s.DetailedMetricsEnabled = &v
	return s
}

// SetLoggingLevel sets the LoggingLevel field's value.
func (s *AwsApiGatewayV2RouteSettings) SetLoggingLevel(v string) *AwsApiGatewayV2RouteSettings {
	s.LoggingLevel = &v
	return s
}

// SetThrottlingBurstLimit sets the ThrottlingBurstLimit field's value.
func (s *AwsApiGatewayV2RouteSettings) SetThrottlingBurstLimit(v int64) *AwsApiGatewayV2RouteSettings {
	s.ThrottlingBurstLimit = &v
	return s
}

// SetThrottlingRateLimit sets the ThrottlingRateLimit field's value.
func (s *AwsApiGatewayV2RouteSettings) SetThrottlingRateLimit(v float64) *AwsApiGatewayV2RouteSettings {
	s.ThrottlingRateLimit = &v
	return s
}

// Contains information about a version 2 stage for Amazon API Gateway.
type AwsApiGatewayV2StageDetails struct {
	_ struct{} `type:"structure"`

	// Information about settings for logging access for the stage.
	AccessLogSettings *AwsApiGatewayAccessLogSettings `type:"structure"`

	// Indicates whether the stage is managed by API Gateway.
	ApiGatewayManaged *bool `type:"boolean"`

	// Indicates whether updates to an API automatically trigger a new deployment.
	AutoDeploy *bool `type:"boolean"`

	// The identifier of a client certificate for a stage. Supported only for WebSocket
	// API calls.
	ClientCertificateId *string `type:"string"`

	// Indicates when the stage was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedDate *string `type:"string"`

	// Default route settings for the stage.
	DefaultRouteSettings *AwsApiGatewayV2RouteSettings `type:"structure"`

	// The identifier of the deployment that the stage is associated with.
	DeploymentId *string `type:"string"`

	// The description of the stage.
	Description *string `type:"string"`

	// The status of the last deployment of a stage. Supported only if the stage
	// has automatic deployment enabled.
	LastDeploymentStatusMessage *string `type:"string"`

	// Indicates when the stage was most recently updated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastUpdatedDate *string `type:"string"`

	// The route settings for the stage.
	RouteSettings *AwsApiGatewayV2RouteSettings `type:"structure"`

	// The name of the stage.
	StageName *string `type:"string"`

	// A map that defines the stage variables for the stage.
	//
	// Variable names can have alphanumeric and underscore characters.
	//
	// Variable values can contain the following characters:
	//
	//    * Uppercase and lowercase letters
	//
	//    * Numbers
	//
	//    * Special characters -._~:/?#&=,
	StageVariables map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayV2StageDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsApiGatewayV2StageDetails) GoString() string {
	return s.String()
}

// SetAccessLogSettings sets the AccessLogSettings field's value.
func (s *AwsApiGatewayV2StageDetails) SetAccessLogSettings(v *AwsApiGatewayAccessLogSettings) *AwsApiGatewayV2StageDetails {
	s.AccessLogSettings = v
	return s
}

// SetApiGatewayManaged sets the ApiGatewayManaged field's value.
func (s *AwsApiGatewayV2StageDetails) SetApiGatewayManaged(v bool) *AwsApiGatewayV2StageDetails {
	s.ApiGatewayManaged = &v
	return s
}

// SetAutoDeploy sets the AutoDeploy field's value.
func (s *AwsApiGatewayV2StageDetails) SetAutoDeploy(v bool) *AwsApiGatewayV2StageDetails {
	s.AutoDeploy = &v
	return s
}

// SetClientCertificateId sets the ClientCertificateId field's value.
func (s *AwsApiGatewayV2StageDetails) SetClientCertificateId(v string) *AwsApiGatewayV2StageDetails {
	s.ClientCertificateId = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AwsApiGatewayV2StageDetails) SetCreatedDate(v string) *AwsApiGatewayV2StageDetails {
	s.CreatedDate = &v
	return s
}

// SetDefaultRouteSettings sets the DefaultRouteSettings field's value.
func (s *AwsApiGatewayV2StageDetails) SetDefaultRouteSettings(v *AwsApiGatewayV2RouteSettings) *AwsApiGatewayV2StageDetails {
	s.DefaultRouteSettings = v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *AwsApiGatewayV2StageDetails) SetDeploymentId(v string) *AwsApiGatewayV2StageDetails {
	s.DeploymentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsApiGatewayV2StageDetails) SetDescription(v string) *AwsApiGatewayV2StageDetails {
	s.Description = &v
	return s
}

// SetLastDeploymentStatusMessage sets the LastDeploymentStatusMessage field's value.
func (s *AwsApiGatewayV2StageDetails) SetLastDeploymentStatusMessage(v string) *AwsApiGatewayV2StageDetails {
	s.LastDeploymentStatusMessage = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *AwsApiGatewayV2StageDetails) SetLastUpdatedDate(v string) *AwsApiGatewayV2StageDetails {
	s.LastUpdatedDate = &v
	return s
}

// SetRouteSettings sets the RouteSettings field's value.
func (s *AwsApiGatewayV2StageDetails) SetRouteSettings(v *AwsApiGatewayV2RouteSettings) *AwsApiGatewayV2StageDetails {
	s.RouteSettings = v
	return s
}

// SetStageName sets the StageName field's value.
func (s *AwsApiGatewayV2StageDetails) SetStageName(v string) *AwsApiGatewayV2StageDetails {
	s.StageName = &v
	return s
}

// SetStageVariables sets the StageVariables field's value.
func (s *AwsApiGatewayV2StageDetails) SetStageVariables(v map[string]*string) *AwsApiGatewayV2StageDetails {
	s.StageVariables = v
	return s
}

// An Availability Zone for the automatic scaling group.
type AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails struct {
	_ struct{} `type:"structure"`

	// The name of the Availability Zone.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails) GoString() string {
	return s.String()
}

// SetValue sets the Value field's value.
func (s *AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails) SetValue(v string) *AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails {
	s.Value = &v
	return s
}

// Provides details about an auto scaling group.
type AwsAutoScalingAutoScalingGroupDetails struct {
	_ struct{} `type:"structure"`

	// The list of Availability Zones for the automatic scaling group.
	AvailabilityZones []*AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails `type:"list"`

	// Indicates whether capacity rebalancing is enabled.
	CapacityRebalance *bool `type:"boolean"`

	// Indicates when the auto scaling group was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedTime *string `type:"string"`

	// The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before
	// it checks the health status of an EC2 instance that has come into service.
	HealthCheckGracePeriod *int64 `type:"integer"`

	// The service to use for the health checks.
	HealthCheckType *string `type:"string"`

	// The name of the launch configuration.
	LaunchConfigurationName *string `type:"string"`

	// The launch template to use.
	LaunchTemplate *AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification `type:"structure"`

	// The list of load balancers associated with the group.
	LoadBalancerNames []*string `type:"list"`

	// The mixed instances policy for the automatic scaling group.
	MixedInstancesPolicy *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupDetails) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetAvailabilityZones(v []*AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails) *AwsAutoScalingAutoScalingGroupDetails {
	s.AvailabilityZones = v
	return s
}

// SetCapacityRebalance sets the CapacityRebalance field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetCapacityRebalance(v bool) *AwsAutoScalingAutoScalingGroupDetails {
	s.CapacityRebalance = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetCreatedTime(v string) *AwsAutoScalingAutoScalingGroupDetails {
	s.CreatedTime = &v
	return s
}

// SetHealthCheckGracePeriod sets the HealthCheckGracePeriod field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetHealthCheckGracePeriod(v int64) *AwsAutoScalingAutoScalingGroupDetails {
	s.HealthCheckGracePeriod = &v
	return s
}

// SetHealthCheckType sets the HealthCheckType field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetHealthCheckType(v string) *AwsAutoScalingAutoScalingGroupDetails {
	s.HealthCheckType = &v
	return s
}

// SetLaunchConfigurationName sets the LaunchConfigurationName field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetLaunchConfigurationName(v string) *AwsAutoScalingAutoScalingGroupDetails {
	s.LaunchConfigurationName = &v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetLaunchTemplate(v *AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification) *AwsAutoScalingAutoScalingGroupDetails {
	s.LaunchTemplate = v
	return s
}

// SetLoadBalancerNames sets the LoadBalancerNames field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetLoadBalancerNames(v []*string) *AwsAutoScalingAutoScalingGroupDetails {
	s.LoadBalancerNames = v
	return s
}

// SetMixedInstancesPolicy sets the MixedInstancesPolicy field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetMixedInstancesPolicy(v *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails) *AwsAutoScalingAutoScalingGroupDetails {
	s.MixedInstancesPolicy = v
	return s
}

// Details about the launch template to use.
type AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification struct {
	_ struct{} `type:"structure"`

	// The identifier of the launch template. You must specify either LaunchTemplateId
	// or LaunchTemplateName.
	LaunchTemplateId *string `type:"string"`

	// The name of the launch template. You must specify either LaunchTemplateId
	// or LaunchTemplateName.
	LaunchTemplateName *string `type:"string"`

	// Identifies the version of the launch template. You can specify a version
	// identifier, or use the values $Latest or $Default.
	Version *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification) GoString() string {
	return s.String()
}

// SetLaunchTemplateId sets the LaunchTemplateId field's value.
func (s *AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification) SetLaunchTemplateId(v string) *AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification {
	s.LaunchTemplateId = &v
	return s
}

// SetLaunchTemplateName sets the LaunchTemplateName field's value.
func (s *AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification) SetLaunchTemplateName(v string) *AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification {
	s.LaunchTemplateName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification) SetVersion(v string) *AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification {
	s.Version = &v
	return s
}

// The mixed instances policy for the automatic scaling group.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails struct {
	_ struct{} `type:"structure"`

	// The instances distribution. The instances distribution specifies the distribution
	// of On-Demand Instances and Spot Instances, the maximum price to pay for Spot
	// Instances, and how the Auto Scaling group allocates instance types to fulfill
	// On-Demand and Spot capacity.
	InstancesDistribution *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails `type:"structure"`

	// The launch template to use and the instance types (overrides) to use to provision
	// EC2 instances to fulfill On-Demand and Spot capacities.
	LaunchTemplate *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails) GoString() string {
	return s.String()
}

// SetInstancesDistribution sets the InstancesDistribution field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails) SetInstancesDistribution(v *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails {
	s.InstancesDistribution = v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails) SetLaunchTemplate(v *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails {
	s.LaunchTemplate = v
	return s
}

// Information about the instances distribution.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails struct {
	_ struct{} `type:"structure"`

	// How to allocate instance types to fulfill On-Demand capacity.
	OnDemandAllocationStrategy *string `type:"string"`

	// The minimum amount of the Auto Scaling group's capacity that must be fulfilled
	// by On-Demand Instances.
	OnDemandBaseCapacity *int64 `type:"integer"`

	// The percentage of On-Demand Instances and Spot Instances for additional capacity
	// beyond OnDemandBaseCapacity.
	OnDemandPercentageAboveBaseCapacity *int64 `type:"integer"`

	// How to allocate instances across Spot Instance pools.
	SpotAllocationStrategy *string `type:"string"`

	// The number of Spot Instance pools across which to allocate your Spot Instances.
	SpotInstancePools *int64 `type:"integer"`

	// The maximum price per unit hour that you are willing to pay for a Spot Instance.
	SpotMaxPrice *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) GoString() string {
	return s.String()
}

// SetOnDemandAllocationStrategy sets the OnDemandAllocationStrategy field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) SetOnDemandAllocationStrategy(v string) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails {
	s.OnDemandAllocationStrategy = &v
	return s
}

// SetOnDemandBaseCapacity sets the OnDemandBaseCapacity field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) SetOnDemandBaseCapacity(v int64) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails {
	s.OnDemandBaseCapacity = &v
	return s
}

// SetOnDemandPercentageAboveBaseCapacity sets the OnDemandPercentageAboveBaseCapacity field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) SetOnDemandPercentageAboveBaseCapacity(v int64) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails {
	s.OnDemandPercentageAboveBaseCapacity = &v
	return s
}

// SetSpotAllocationStrategy sets the SpotAllocationStrategy field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) SetSpotAllocationStrategy(v string) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails {
	s.SpotAllocationStrategy = &v
	return s
}

// SetSpotInstancePools sets the SpotInstancePools field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) SetSpotInstancePools(v int64) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails {
	s.SpotInstancePools = &v
	return s
}

// SetSpotMaxPrice sets the SpotMaxPrice field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) SetSpotMaxPrice(v string) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails {
	s.SpotMaxPrice = &v
	return s
}

// Describes a launch template and overrides for a mixed instances policy.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails struct {
	_ struct{} `type:"structure"`

	// The launch template to use for a mixed instances policy.
	LaunchTemplateSpecification *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification `type:"structure"`

	// Property values to use to override the values in the launch template.
	Overrides []*AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails) GoString() string {
	return s.String()
}

// SetLaunchTemplateSpecification sets the LaunchTemplateSpecification field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails) SetLaunchTemplateSpecification(v *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails {
	s.LaunchTemplateSpecification = v
	return s
}

// SetOverrides sets the Overrides field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails) SetOverrides(v []*AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails {
	s.Overrides = v
	return s
}

// Details about the launch template to use for a mixed instances policy.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification struct {
	_ struct{} `type:"structure"`

	// The identifier of the launch template. You must specify either LaunchTemplateId
	// or LaunchTemplateName.
	LaunchTemplateId *string `type:"string"`

	// The name of the launch template. You must specify either LaunchTemplateId
	// or LaunchTemplateName.
	LaunchTemplateName *string `type:"string"`

	// Identifies the version of the launch template. You can specify a version
	// identifier, or use the values $Latest or $Default.
	Version *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification) GoString() string {
	return s.String()
}

// SetLaunchTemplateId sets the LaunchTemplateId field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification) SetLaunchTemplateId(v string) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification {
	s.LaunchTemplateId = &v
	return s
}

// SetLaunchTemplateName sets the LaunchTemplateName field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification) SetLaunchTemplateName(v string) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification {
	s.LaunchTemplateName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification) SetVersion(v string) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification {
	s.Version = &v
	return s
}

// Property values to use to override the values in the launch template.
type AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails struct {
	_ struct{} `type:"structure"`

	// The instance type. For example, m3.xlarge.
	InstanceType *string `type:"string"`

	// The number of capacity units provided by the specified instance type in terms
	// of virtual CPUs, memory, storage, throughput, or other relative performance
	// characteristic.
	WeightedCapacity *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails) GoString() string {
	return s.String()
}

// SetInstanceType sets the InstanceType field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails) SetInstanceType(v string) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails {
	s.InstanceType = &v
	return s
}

// SetWeightedCapacity sets the WeightedCapacity field's value.
func (s *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails) SetWeightedCapacity(v string) *AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails {
	s.WeightedCapacity = &v
	return s
}

// A block device for the instance.
type AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails struct {
	_ struct{} `type:"structure"`

	// The device name that is exposed to the EC2 instance. For example, /dev/sdh
	// or xvdh.
	DeviceName *string `type:"string"`

	// Parameters that are used to automatically set up Amazon EBS volumes when
	// an instance is launched.
	Ebs *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails `type:"structure"`

	// Whether to suppress the device that is included in the block device mapping
	// of the Amazon Machine Image (AMI).
	//
	// If NoDevice is true, then you cannot specify Ebs.>
	NoDevice *bool `type:"boolean"`

	// The name of the virtual device (for example, ephemeral0).
	//
	// You can provide either VirtualName or Ebs, but not both.
	VirtualName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails) GoString() string {
	return s.String()
}

// SetDeviceName sets the DeviceName field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails) SetDeviceName(v string) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails {
	s.DeviceName = &v
	return s
}

// SetEbs sets the Ebs field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails) SetEbs(v *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails {
	s.Ebs = v
	return s
}

// SetNoDevice sets the NoDevice field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails) SetNoDevice(v bool) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails {
	s.NoDevice = &v
	return s
}

// SetVirtualName sets the VirtualName field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails) SetVirtualName(v string) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails {
	s.VirtualName = &v
	return s
}

// Parameters that are used to automatically set up EBS volumes when an instance
// is launched.
type AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails struct {
	_ struct{} `type:"structure"`

	// Whether to delete the volume when the instance is terminated.
	DeleteOnTermination *bool `type:"boolean"`

	// Whether to encrypt the volume.
	Encrypted *bool `type:"boolean"`

	// The number of input/output (I/O) operations per second (IOPS) to provision
	// for the volume.
	//
	// Only supported for gp3 or io1 volumes. Required for io1 volumes. Not used
	// with standard, gp2, st1, or sc1 volumes.
	Iops *int64 `type:"integer"`

	// The snapshot ID of the volume to use.
	//
	// You must specify either VolumeSize or SnapshotId.
	SnapshotId *string `type:"string"`

	// The volume size, in GiBs. The following are the supported volumes sizes for
	// each volume type:
	//
	//    * gp2 and gp3: 1-16,384
	//
	//    * io1: 4-16,384
	//
	//    * st1 and sc1: 125-16,384
	//
	//    * standard: 1-1,024
	//
	// You must specify either SnapshotId or VolumeSize. If you specify both SnapshotId
	// and VolumeSize, the volume size must be equal or greater than the size of
	// the snapshot.
	VolumeSize *int64 `type:"integer"`

	// The volume type.
	VolumeType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) GoString() string {
	return s.String()
}

// SetDeleteOnTermination sets the DeleteOnTermination field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) SetDeleteOnTermination(v bool) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails {
	s.DeleteOnTermination = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) SetEncrypted(v bool) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails {
	s.Encrypted = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) SetIops(v int64) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails {
	s.Iops = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) SetSnapshotId(v string) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails {
	s.SnapshotId = &v
	return s
}

// SetVolumeSize sets the VolumeSize field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) SetVolumeSize(v int64) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails {
	s.VolumeSize = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) SetVolumeType(v string) *AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails {
	s.VolumeType = &v
	return s
}

// Details about a launch configuration.
type AwsAutoScalingLaunchConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// For Auto Scaling groups that run in a VPC, specifies whether to assign a
	// public IP address to the group's instances.
	AssociatePublicIpAddress *bool `type:"boolean"`

	// Specifies the block devices for the instance.
	BlockDeviceMappings []*AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails `type:"list"`

	// The identifier of a ClassicLink-enabled VPC that EC2-Classic instances are
	// linked to.
	ClassicLinkVpcId *string `type:"string"`

	// The identifiers of one or more security groups for the VPC that is specified
	// in ClassicLinkVPCId.
	ClassicLinkVpcSecurityGroups []*string `type:"list"`

	// The creation date and time for the launch configuration.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedTime *string `type:"string"`

	// Whether the launch configuration is optimized for Amazon EBS I/O.
	EbsOptimized *bool `type:"boolean"`

	// The name or the ARN of the instance profile associated with the IAM role
	// for the instance. The instance profile contains the IAM role.
	IamInstanceProfile *string `type:"string"`

	// The identifier of the Amazon Machine Image (AMI) that is used to launch EC2
	// instances.
	ImageId *string `type:"string"`

	// Indicates the type of monitoring for instances in the group.
	InstanceMonitoring *AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails `type:"structure"`

	// The instance type for the instances.
	InstanceType *string `type:"string"`

	// The identifier of the kernel associated with the AMI.
	KernelId *string `type:"string"`

	// The name of the key pair.
	KeyName *string `type:"string"`

	// The name of the launch configuration.
	LaunchConfigurationName *string `type:"string"`

	// The metadata options for the instances.
	MetadataOptions *AwsAutoScalingLaunchConfigurationMetadataOptions `type:"structure"`

	// The tenancy of the instance. An instance with dedicated tenancy runs on isolated,
	// single-tenant hardware and can only be launched into a VPC.
	PlacementTenancy *string `type:"string"`

	// The identifier of the RAM disk associated with the AMI.
	RamdiskId *string `type:"string"`

	// The security groups to assign to the instances in the Auto Scaling group.
	SecurityGroups []*string `type:"list"`

	// The maximum hourly price to be paid for any Spot Instance that is launched
	// to fulfill the request.
	SpotPrice *string `type:"string"`

	// The user data to make available to the launched EC2 instances. Must be base64-encoded
	// text.
	UserData *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationDetails) GoString() string {
	return s.String()
}

// SetAssociatePublicIpAddress sets the AssociatePublicIpAddress field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetAssociatePublicIpAddress(v bool) *AwsAutoScalingLaunchConfigurationDetails {
	s.AssociatePublicIpAddress = &v
	return s
}

// SetBlockDeviceMappings sets the BlockDeviceMappings field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetBlockDeviceMappings(v []*AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails) *AwsAutoScalingLaunchConfigurationDetails {
	s.BlockDeviceMappings = v
	return s
}

// SetClassicLinkVpcId sets the ClassicLinkVpcId field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetClassicLinkVpcId(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.ClassicLinkVpcId = &v
	return s
}

// SetClassicLinkVpcSecurityGroups sets the ClassicLinkVpcSecurityGroups field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetClassicLinkVpcSecurityGroups(v []*string) *AwsAutoScalingLaunchConfigurationDetails {
	s.ClassicLinkVpcSecurityGroups = v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetCreatedTime(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.CreatedTime = &v
	return s
}

// SetEbsOptimized sets the EbsOptimized field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetEbsOptimized(v bool) *AwsAutoScalingLaunchConfigurationDetails {
	s.EbsOptimized = &v
	return s
}

// SetIamInstanceProfile sets the IamInstanceProfile field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetIamInstanceProfile(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.IamInstanceProfile = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetImageId(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.ImageId = &v
	return s
}

// SetInstanceMonitoring sets the InstanceMonitoring field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetInstanceMonitoring(v *AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails) *AwsAutoScalingLaunchConfigurationDetails {
	s.InstanceMonitoring = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetInstanceType(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.InstanceType = &v
	return s
}

// SetKernelId sets the KernelId field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetKernelId(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.KernelId = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetKeyName(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.KeyName = &v
	return s
}

// SetLaunchConfigurationName sets the LaunchConfigurationName field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetLaunchConfigurationName(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.LaunchConfigurationName = &v
	return s
}

// SetMetadataOptions sets the MetadataOptions field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetMetadataOptions(v *AwsAutoScalingLaunchConfigurationMetadataOptions) *AwsAutoScalingLaunchConfigurationDetails {
	s.MetadataOptions = v
	return s
}

// SetPlacementTenancy sets the PlacementTenancy field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetPlacementTenancy(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.PlacementTenancy = &v
	return s
}

// SetRamdiskId sets the RamdiskId field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetRamdiskId(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.RamdiskId = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetSecurityGroups(v []*string) *AwsAutoScalingLaunchConfigurationDetails {
	s.SecurityGroups = v
	return s
}

// SetSpotPrice sets the SpotPrice field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetSpotPrice(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.SpotPrice = &v
	return s
}

// SetUserData sets the UserData field's value.
func (s *AwsAutoScalingLaunchConfigurationDetails) SetUserData(v string) *AwsAutoScalingLaunchConfigurationDetails {
	s.UserData = &v
	return s
}

// Information about the type of monitoring for instances in the group.
type AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails struct {
	_ struct{} `type:"structure"`

	// If set to true, then instances in the group launch with detailed monitoring.
	//
	// If set to false, then instances in the group launch with basic monitoring.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails) SetEnabled(v bool) *AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails {
	s.Enabled = &v
	return s
}

// The metadata options for the instances.
type AwsAutoScalingLaunchConfigurationMetadataOptions struct {
	_ struct{} `type:"structure"`

	// Enables or disables the HTTP metadata endpoint on your instances. By default,
	// the metadata endpoint is enabled.
	HttpEndpoint *string `type:"string"`

	// The HTTP PUT response hop limit for instance metadata requests. The larger
	// the number, the further instance metadata requests can travel.
	HttpPutResponseHopLimit *int64 `type:"integer"`

	// Indicates whether token usage is required or optional for metadata requests.
	// By default, token usage is optional.
	HttpTokens *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationMetadataOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsAutoScalingLaunchConfigurationMetadataOptions) GoString() string {
	return s.String()
}

// SetHttpEndpoint sets the HttpEndpoint field's value.
func (s *AwsAutoScalingLaunchConfigurationMetadataOptions) SetHttpEndpoint(v string) *AwsAutoScalingLaunchConfigurationMetadataOptions {
	s.HttpEndpoint = &v
	return s
}

// SetHttpPutResponseHopLimit sets the HttpPutResponseHopLimit field's value.
func (s *AwsAutoScalingLaunchConfigurationMetadataOptions) SetHttpPutResponseHopLimit(v int64) *AwsAutoScalingLaunchConfigurationMetadataOptions {
	s.HttpPutResponseHopLimit = &v
	return s
}

// SetHttpTokens sets the HttpTokens field's value.
func (s *AwsAutoScalingLaunchConfigurationMetadataOptions) SetHttpTokens(v string) *AwsAutoScalingLaunchConfigurationMetadataOptions {
	s.HttpTokens = &v
	return s
}

// Provides details about an Certificate Manager certificate.
type AwsCertificateManagerCertificateDetails struct {
	_ struct{} `type:"structure"`

	// The ARN of the private certificate authority (CA) that will be used to issue
	// the certificate.
	CertificateAuthorityArn *string `type:"string"`

	// Indicates when the certificate was requested.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedAt *string `type:"string"`

	// The fully qualified domain name (FQDN), such as www.example.com, that is
	// secured by the certificate.
	DomainName *string `type:"string"`

	// Contains information about the initial validation of each domain name that
	// occurs as a result of the RequestCertificate request.
	//
	// Only provided if the certificate type is AMAZON_ISSUED.
	DomainValidationOptions []*AwsCertificateManagerCertificateDomainValidationOption `type:"list"`

	// Contains a list of Extended Key Usage X.509 v3 extension objects. Each object
	// specifies a purpose for which the certificate public key can be used and
	// consists of a name and an object identifier (OID).
	ExtendedKeyUsages []*AwsCertificateManagerCertificateExtendedKeyUsage `type:"list"`

	// For a failed certificate request, the reason for the failure.
	//
	// Valid values: NO_AVAILABLE_CONTACTS | ADDITIONAL_VERIFICATION_REQUIRED |
	// DOMAIN_NOT_ALLOWED | INVALID_PUBLIC_DOMAIN | DOMAIN_VALIDATION_DENIED | CAA_ERROR
	// | PCA_LIMIT_EXCEEDED | PCA_INVALID_ARN | PCA_INVALID_STATE | PCA_REQUEST_FAILED
	// | PCA_NAME_CONSTRAINTS_VALIDATION | PCA_RESOURCE_NOT_FOUND | PCA_INVALID_ARGS
	// | PCA_INVALID_DURATION | PCA_ACCESS_DENIED | SLR_NOT_FOUND | OTHER
	FailureReason *string `type:"string"`

	// Indicates when the certificate was imported. Provided if the certificate
	// type is IMPORTED.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	ImportedAt *string `type:"string"`

	// The list of ARNs for the Amazon Web Services resources that use the certificate.
	InUseBy []*string `type:"list"`

	// Indicates when the certificate was issued. Provided if the certificate type
	// is AMAZON_ISSUED.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	IssuedAt *string `type:"string"`

	// The name of the certificate authority that issued and signed the certificate.
	Issuer *string `type:"string"`

	// The algorithm that was used to generate the public-private key pair.
	//
	// Valid values: RSA_2048 | RSA_1024 |RSA_4096 | EC_prime256v1 | EC_secp384r1
	// | EC_secp521r1
	KeyAlgorithm *string `type:"string"`

	// A list of key usage X.509 v3 extension objects.
	KeyUsages []*AwsCertificateManagerCertificateKeyUsage `type:"list"`

	// The time after which the certificate becomes invalid.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	NotAfter *string `type:"string"`

	// The time before which the certificate is not valid.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	NotBefore *string `type:"string"`

	// Provides a value that specifies whether to add the certificate to a transparency
	// log.
	Options *AwsCertificateManagerCertificateOptions `type:"structure"`

	// Whether the certificate is eligible for renewal.
	//
	// Valid values: ELIGIBLE | INELIGIBLE
	RenewalEligibility *string `type:"string"`

	// Information about the status of the Certificate Manager managed renewal for
	// the certificate. Provided only when the certificate type is AMAZON_ISSUED.
	RenewalSummary *AwsCertificateManagerCertificateRenewalSummary `type:"structure"`

	// The serial number of the certificate.
	Serial *string `type:"string"`

	// The algorithm that was used to sign the certificate.
	SignatureAlgorithm *string `type:"string"`

	// The status of the certificate.
	//
	// Valid values: PENDING_VALIDATION | ISSUED | INACTIVE | EXPIRED | VALIDATION_TIMED_OUT
	// | REVOKED | FAILED
	Status *string `type:"string"`

	// The name of the entity that is associated with the public key contained in
	// the certificate.
	Subject *string `type:"string"`

	// One or more domain names (subject alternative names) included in the certificate.
	// This list contains the domain names that are bound to the public key that
	// is contained in the certificate.
	//
	// The subject alternative names include the canonical domain name (CN) of the
	// certificate and additional domain names that can be used to connect to the
	// website.
	SubjectAlternativeNames []*string `type:"list"`

	// The source of the certificate. For certificates that Certificate Manager
	// provides, Type is AMAZON_ISSUED. For certificates that are imported with
	// ImportCertificate, Type is IMPORTED.
	//
	// Valid values: IMPORTED | AMAZON_ISSUED | PRIVATE
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateDetails) GoString() string {
	return s.String()
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *AwsCertificateManagerCertificateDetails) SetCertificateAuthorityArn(v string) *AwsCertificateManagerCertificateDetails {
	s.CertificateAuthorityArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AwsCertificateManagerCertificateDetails) SetCreatedAt(v string) *AwsCertificateManagerCertificateDetails {
	s.CreatedAt = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *AwsCertificateManagerCertificateDetails) SetDomainName(v string) *AwsCertificateManagerCertificateDetails {
	s.DomainName = &v
	return s
}

// SetDomainValidationOptions sets the DomainValidationOptions field's value.
func (s *AwsCertificateManagerCertificateDetails) SetDomainValidationOptions(v []*AwsCertificateManagerCertificateDomainValidationOption) *AwsCertificateManagerCertificateDetails {
	s.DomainValidationOptions = v
	return s
}

// SetExtendedKeyUsages sets the ExtendedKeyUsages field's value.
func (s *AwsCertificateManagerCertificateDetails) SetExtendedKeyUsages(v []*AwsCertificateManagerCertificateExtendedKeyUsage) *AwsCertificateManagerCertificateDetails {
	s.ExtendedKeyUsages = v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *AwsCertificateManagerCertificateDetails) SetFailureReason(v string) *AwsCertificateManagerCertificateDetails {
	s.FailureReason = &v
	return s
}

// SetImportedAt sets the ImportedAt field's value.
func (s *AwsCertificateManagerCertificateDetails) SetImportedAt(v string) *AwsCertificateManagerCertificateDetails {
	s.ImportedAt = &v
	return s
}

// SetInUseBy sets the InUseBy field's value.
func (s *AwsCertificateManagerCertificateDetails) SetInUseBy(v []*string) *AwsCertificateManagerCertificateDetails {
	s.InUseBy = v
	return s
}

// SetIssuedAt sets the IssuedAt field's value.
func (s *AwsCertificateManagerCertificateDetails) SetIssuedAt(v string) *AwsCertificateManagerCertificateDetails {
	s.IssuedAt = &v
	return s
}

// SetIssuer sets the Issuer field's value.
func (s *AwsCertificateManagerCertificateDetails) SetIssuer(v string) *AwsCertificateManagerCertificateDetails {
	s.Issuer = &v
	return s
}

// SetKeyAlgorithm sets the KeyAlgorithm field's value.
func (s *AwsCertificateManagerCertificateDetails) SetKeyAlgorithm(v string) *AwsCertificateManagerCertificateDetails {
	s.KeyAlgorithm = &v
	return s
}

// SetKeyUsages sets the KeyUsages field's value.
func (s *AwsCertificateManagerCertificateDetails) SetKeyUsages(v []*AwsCertificateManagerCertificateKeyUsage) *AwsCertificateManagerCertificateDetails {
	s.KeyUsages = v
	return s
}

// SetNotAfter sets the NotAfter field's value.
func (s *AwsCertificateManagerCertificateDetails) SetNotAfter(v string) *AwsCertificateManagerCertificateDetails {
	s.NotAfter = &v
	return s
}

// SetNotBefore sets the NotBefore field's value.
func (s *AwsCertificateManagerCertificateDetails) SetNotBefore(v string) *AwsCertificateManagerCertificateDetails {
	s.NotBefore = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *AwsCertificateManagerCertificateDetails) SetOptions(v *AwsCertificateManagerCertificateOptions) *AwsCertificateManagerCertificateDetails {
	s.Options = v
	return s
}

// SetRenewalEligibility sets the RenewalEligibility field's value.
func (s *AwsCertificateManagerCertificateDetails) SetRenewalEligibility(v string) *AwsCertificateManagerCertificateDetails {
	s.RenewalEligibility = &v
	return s
}

// SetRenewalSummary sets the RenewalSummary field's value.
func (s *AwsCertificateManagerCertificateDetails) SetRenewalSummary(v *AwsCertificateManagerCertificateRenewalSummary) *AwsCertificateManagerCertificateDetails {
	s.RenewalSummary = v
	return s
}

// SetSerial sets the Serial field's value.
func (s *AwsCertificateManagerCertificateDetails) SetSerial(v string) *AwsCertificateManagerCertificateDetails {
	s.Serial = &v
	return s
}

// SetSignatureAlgorithm sets the SignatureAlgorithm field's value.
func (s *AwsCertificateManagerCertificateDetails) SetSignatureAlgorithm(v string) *AwsCertificateManagerCertificateDetails {
	s.SignatureAlgorithm = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsCertificateManagerCertificateDetails) SetStatus(v string) *AwsCertificateManagerCertificateDetails {
	s.Status = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *AwsCertificateManagerCertificateDetails) SetSubject(v string) *AwsCertificateManagerCertificateDetails {
	s.Subject = &v
	return s
}

// SetSubjectAlternativeNames sets the SubjectAlternativeNames field's value.
func (s *AwsCertificateManagerCertificateDetails) SetSubjectAlternativeNames(v []*string) *AwsCertificateManagerCertificateDetails {
	s.SubjectAlternativeNames = v
	return s
}

// SetType sets the Type field's value.
func (s *AwsCertificateManagerCertificateDetails) SetType(v string) *AwsCertificateManagerCertificateDetails {
	s.Type = &v
	return s
}

// Contains information about one of the following:
//
//    * The initial validation of each domain name that occurs as a result of
//    the RequestCertificate request
//
//    * The validation of each domain name in the certificate, as it pertains
//    to Certificate Manager managed renewal
type AwsCertificateManagerCertificateDomainValidationOption struct {
	_ struct{} `type:"structure"`

	// A fully qualified domain name (FQDN) in the certificate.
	DomainName *string `type:"string"`

	// The CNAME record that is added to the DNS database for domain validation.
	ResourceRecord *AwsCertificateManagerCertificateResourceRecord `type:"structure"`

	// The domain name that Certificate Manager uses to send domain validation emails.
	ValidationDomain *string `type:"string"`

	// A list of email addresses that Certificate Manager uses to send domain validation
	// emails.
	ValidationEmails []*string `type:"list"`

	// The method used to validate the domain name.
	ValidationMethod *string `type:"string"`

	// The validation status of the domain name.
	ValidationStatus *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateDomainValidationOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateDomainValidationOption) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *AwsCertificateManagerCertificateDomainValidationOption) SetDomainName(v string) *AwsCertificateManagerCertificateDomainValidationOption {
	s.DomainName = &v
	return s
}

// SetResourceRecord sets the ResourceRecord field's value.
func (s *AwsCertificateManagerCertificateDomainValidationOption) SetResourceRecord(v *AwsCertificateManagerCertificateResourceRecord) *AwsCertificateManagerCertificateDomainValidationOption {
	s.ResourceRecord = v
	return s
}

// SetValidationDomain sets the ValidationDomain field's value.
func (s *AwsCertificateManagerCertificateDomainValidationOption) SetValidationDomain(v string) *AwsCertificateManagerCertificateDomainValidationOption {
	s.ValidationDomain = &v
	return s
}

// SetValidationEmails sets the ValidationEmails field's value.
func (s *AwsCertificateManagerCertificateDomainValidationOption) SetValidationEmails(v []*string) *AwsCertificateManagerCertificateDomainValidationOption {
	s.ValidationEmails = v
	return s
}

// SetValidationMethod sets the ValidationMethod field's value.
func (s *AwsCertificateManagerCertificateDomainValidationOption) SetValidationMethod(v string) *AwsCertificateManagerCertificateDomainValidationOption {
	s.ValidationMethod = &v
	return s
}

// SetValidationStatus sets the ValidationStatus field's value.
func (s *AwsCertificateManagerCertificateDomainValidationOption) SetValidationStatus(v string) *AwsCertificateManagerCertificateDomainValidationOption {
	s.ValidationStatus = &v
	return s
}

// Contains information about an extended key usage X.509 v3 extension object.
type AwsCertificateManagerCertificateExtendedKeyUsage struct {
	_ struct{} `type:"structure"`

	// The name of an extension value. Indicates the purpose for which the certificate
	// public key can be used.
	Name *string `type:"string"`

	// An object identifier (OID) for the extension value.
	//
	// The format is numbers separated by periods.
	OId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateExtendedKeyUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateExtendedKeyUsage) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsCertificateManagerCertificateExtendedKeyUsage) SetName(v string) *AwsCertificateManagerCertificateExtendedKeyUsage {
	s.Name = &v
	return s
}

// SetOId sets the OId field's value.
func (s *AwsCertificateManagerCertificateExtendedKeyUsage) SetOId(v string) *AwsCertificateManagerCertificateExtendedKeyUsage {
	s.OId = &v
	return s
}

// Contains information about a key usage X.509 v3 extension object.
type AwsCertificateManagerCertificateKeyUsage struct {
	_ struct{} `type:"structure"`

	// The key usage extension name.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateKeyUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateKeyUsage) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsCertificateManagerCertificateKeyUsage) SetName(v string) *AwsCertificateManagerCertificateKeyUsage {
	s.Name = &v
	return s
}

// Contains other options for the certificate.
type AwsCertificateManagerCertificateOptions struct {
	_ struct{} `type:"structure"`

	// Whether to add the certificate to a transparency log.
	//
	// Valid values: DISABLED | ENABLED
	CertificateTransparencyLoggingPreference *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateOptions) GoString() string {
	return s.String()
}

// SetCertificateTransparencyLoggingPreference sets the CertificateTransparencyLoggingPreference field's value.
func (s *AwsCertificateManagerCertificateOptions) SetCertificateTransparencyLoggingPreference(v string) *AwsCertificateManagerCertificateOptions {
	s.CertificateTransparencyLoggingPreference = &v
	return s
}

// Contains information about the Certificate Manager managed renewal for an
// AMAZON_ISSUED certificate.
type AwsCertificateManagerCertificateRenewalSummary struct {
	_ struct{} `type:"structure"`

	// Information about the validation of each domain name in the certificate,
	// as it pertains to Certificate Manager managed renewal. Provided only when
	// the certificate type is AMAZON_ISSUED.
	DomainValidationOptions []*AwsCertificateManagerCertificateDomainValidationOption `type:"list"`

	// The status of the Certificate Manager managed renewal of the certificate.
	//
	// Valid values: PENDING_AUTO_RENEWAL | PENDING_VALIDATION | SUCCESS | FAILED
	RenewalStatus *string `type:"string"`

	// The reason that a renewal request was unsuccessful.
	//
	// Valid values: NO_AVAILABLE_CONTACTS | ADDITIONAL_VERIFICATION_REQUIRED |
	// DOMAIN_NOT_ALLOWED | INVALID_PUBLIC_DOMAIN | DOMAIN_VALIDATION_DENIED | CAA_ERROR
	// | PCA_LIMIT_EXCEEDED | PCA_INVALID_ARN | PCA_INVALID_STATE | PCA_REQUEST_FAILED
	// | PCA_NAME_CONSTRAINTS_VALIDATION | PCA_RESOURCE_NOT_FOUND | PCA_INVALID_ARGS
	// | PCA_INVALID_DURATION | PCA_ACCESS_DENIED | SLR_NOT_FOUND | OTHER
	RenewalStatusReason *string `type:"string"`

	// Indicates when the renewal summary was last updated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	UpdatedAt *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateRenewalSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateRenewalSummary) GoString() string {
	return s.String()
}

// SetDomainValidationOptions sets the DomainValidationOptions field's value.
func (s *AwsCertificateManagerCertificateRenewalSummary) SetDomainValidationOptions(v []*AwsCertificateManagerCertificateDomainValidationOption) *AwsCertificateManagerCertificateRenewalSummary {
	s.DomainValidationOptions = v
	return s
}

// SetRenewalStatus sets the RenewalStatus field's value.
func (s *AwsCertificateManagerCertificateRenewalSummary) SetRenewalStatus(v string) *AwsCertificateManagerCertificateRenewalSummary {
	s.RenewalStatus = &v
	return s
}

// SetRenewalStatusReason sets the RenewalStatusReason field's value.
func (s *AwsCertificateManagerCertificateRenewalSummary) SetRenewalStatusReason(v string) *AwsCertificateManagerCertificateRenewalSummary {
	s.RenewalStatusReason = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AwsCertificateManagerCertificateRenewalSummary) SetUpdatedAt(v string) *AwsCertificateManagerCertificateRenewalSummary {
	s.UpdatedAt = &v
	return s
}

// Provides details about the CNAME record that is added to the DNS database
// for domain validation.
type AwsCertificateManagerCertificateResourceRecord struct {
	_ struct{} `type:"structure"`

	// The name of the resource.
	Name *string `type:"string"`

	// The type of resource.
	Type *string `type:"string"`

	// The value of the resource.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateResourceRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCertificateManagerCertificateResourceRecord) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsCertificateManagerCertificateResourceRecord) SetName(v string) *AwsCertificateManagerCertificateResourceRecord {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsCertificateManagerCertificateResourceRecord) SetType(v string) *AwsCertificateManagerCertificateResourceRecord {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsCertificateManagerCertificateResourceRecord) SetValue(v string) *AwsCertificateManagerCertificateResourceRecord {
	s.Value = &v
	return s
}

// Information about a cache behavior for the distribution.
type AwsCloudFrontDistributionCacheBehavior struct {
	_ struct{} `type:"structure"`

	// The protocol that viewers can use to access the files in an origin. You can
	// specify the following options:
	//
	//    * allow-all - Viewers can use HTTP or HTTPS.
	//
	//    * redirect-to-https - CloudFront responds to HTTP requests with an HTTP
	//    status code of 301 (Moved Permanently) and the HTTPS URL. The viewer then
	//    uses the new URL to resubmit.
	//
	//    * https-only - CloudFront responds to HTTP request with an HTTP status
	//    code of 403 (Forbidden).
	ViewerProtocolPolicy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionCacheBehavior) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionCacheBehavior) GoString() string {
	return s.String()
}

// SetViewerProtocolPolicy sets the ViewerProtocolPolicy field's value.
func (s *AwsCloudFrontDistributionCacheBehavior) SetViewerProtocolPolicy(v string) *AwsCloudFrontDistributionCacheBehavior {
	s.ViewerProtocolPolicy = &v
	return s
}

// Provides information about caching for the distribution.
type AwsCloudFrontDistributionCacheBehaviors struct {
	_ struct{} `type:"structure"`

	// The cache behaviors for the distribution.
	Items []*AwsCloudFrontDistributionCacheBehavior `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionCacheBehaviors) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionCacheBehaviors) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *AwsCloudFrontDistributionCacheBehaviors) SetItems(v []*AwsCloudFrontDistributionCacheBehavior) *AwsCloudFrontDistributionCacheBehaviors {
	s.Items = v
	return s
}

// Contains information about the default cache configuration for the distribution.
type AwsCloudFrontDistributionDefaultCacheBehavior struct {
	_ struct{} `type:"structure"`

	// The protocol that viewers can use to access the files in an origin. You can
	// specify the following options:
	//
	//    * allow-all - Viewers can use HTTP or HTTPS.
	//
	//    * redirect-to-https - CloudFront responds to HTTP requests with an HTTP
	//    status code of 301 (Moved Permanently) and the HTTPS URL. The viewer then
	//    uses the new URL to resubmit.
	//
	//    * https-only - CloudFront responds to HTTP request with an HTTP status
	//    code of 403 (Forbidden).
	ViewerProtocolPolicy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionDefaultCacheBehavior) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionDefaultCacheBehavior) GoString() string {
	return s.String()
}

// SetViewerProtocolPolicy sets the ViewerProtocolPolicy field's value.
func (s *AwsCloudFrontDistributionDefaultCacheBehavior) SetViewerProtocolPolicy(v string) *AwsCloudFrontDistributionDefaultCacheBehavior {
	s.ViewerProtocolPolicy = &v
	return s
}

// A distribution configuration.
type AwsCloudFrontDistributionDetails struct {
	_ struct{} `type:"structure"`

	// Provides information about the cache configuration for the distribution.
	CacheBehaviors *AwsCloudFrontDistributionCacheBehaviors `type:"structure"`

	// The default cache behavior for the configuration.
	DefaultCacheBehavior *AwsCloudFrontDistributionDefaultCacheBehavior `type:"structure"`

	// The object that CloudFront sends in response to requests from the origin
	// (for example, index.html) when a viewer requests the root URL for the distribution
	// (http://www.example.com) instead of an object in your distribution (http://www.example.com/product-description.html).
	DefaultRootObject *string `type:"string"`

	// The domain name corresponding to the distribution.
	DomainName *string `type:"string"`

	// The entity tag is a hash of the object.
	ETag *string `type:"string"`

	// Indicates when that the distribution was last modified.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastModifiedTime *string `type:"string"`

	// A complex type that controls whether access logs are written for the distribution.
	Logging *AwsCloudFrontDistributionLogging `type:"structure"`

	// Provides information about the origin groups in the distribution.
	OriginGroups *AwsCloudFrontDistributionOriginGroups `type:"structure"`

	// A complex type that contains information about origins for this distribution.
	Origins *AwsCloudFrontDistributionOrigins `type:"structure"`

	// Indicates the current status of the distribution.
	Status *string `type:"string"`

	// Provides information about the TLS/SSL configuration that the distribution
	// uses to communicate with viewers.
	ViewerCertificate *AwsCloudFrontDistributionViewerCertificate `type:"structure"`

	// A unique identifier that specifies the WAF web ACL, if any, to associate
	// with this distribution.
	WebAclId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionDetails) GoString() string {
	return s.String()
}

// SetCacheBehaviors sets the CacheBehaviors field's value.
func (s *AwsCloudFrontDistributionDetails) SetCacheBehaviors(v *AwsCloudFrontDistributionCacheBehaviors) *AwsCloudFrontDistributionDetails {
	s.CacheBehaviors = v
	return s
}

// SetDefaultCacheBehavior sets the DefaultCacheBehavior field's value.
func (s *AwsCloudFrontDistributionDetails) SetDefaultCacheBehavior(v *AwsCloudFrontDistributionDefaultCacheBehavior) *AwsCloudFrontDistributionDetails {
	s.DefaultCacheBehavior = v
	return s
}

// SetDefaultRootObject sets the DefaultRootObject field's value.
func (s *AwsCloudFrontDistributionDetails) SetDefaultRootObject(v string) *AwsCloudFrontDistributionDetails {
	s.DefaultRootObject = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *AwsCloudFrontDistributionDetails) SetDomainName(v string) *AwsCloudFrontDistributionDetails {
	s.DomainName = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *AwsCloudFrontDistributionDetails) SetETag(v string) *AwsCloudFrontDistributionDetails {
	s.ETag = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *AwsCloudFrontDistributionDetails) SetLastModifiedTime(v string) *AwsCloudFrontDistributionDetails {
	s.LastModifiedTime = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *AwsCloudFrontDistributionDetails) SetLogging(v *AwsCloudFrontDistributionLogging) *AwsCloudFrontDistributionDetails {
	s.Logging = v
	return s
}

// SetOriginGroups sets the OriginGroups field's value.
func (s *AwsCloudFrontDistributionDetails) SetOriginGroups(v *AwsCloudFrontDistributionOriginGroups) *AwsCloudFrontDistributionDetails {
	s.OriginGroups = v
	return s
}

// SetOrigins sets the Origins field's value.
func (s *AwsCloudFrontDistributionDetails) SetOrigins(v *AwsCloudFrontDistributionOrigins) *AwsCloudFrontDistributionDetails {
	s.Origins = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsCloudFrontDistributionDetails) SetStatus(v string) *AwsCloudFrontDistributionDetails {
	s.Status = &v
	return s
}

// SetViewerCertificate sets the ViewerCertificate field's value.
func (s *AwsCloudFrontDistributionDetails) SetViewerCertificate(v *AwsCloudFrontDistributionViewerCertificate) *AwsCloudFrontDistributionDetails {
	s.ViewerCertificate = v
	return s
}

// SetWebAclId sets the WebAclId field's value.
func (s *AwsCloudFrontDistributionDetails) SetWebAclId(v string) *AwsCloudFrontDistributionDetails {
	s.WebAclId = &v
	return s
}

// A complex type that controls whether access logs are written for the distribution.
type AwsCloudFrontDistributionLogging struct {
	_ struct{} `type:"structure"`

	// The S3 bucket to store the access logs in.
	Bucket *string `type:"string"`

	// With this field, you can enable or disable the selected distribution.
	Enabled *bool `type:"boolean"`

	// Specifies whether you want CloudFront to include cookies in access logs.
	IncludeCookies *bool `type:"boolean"`

	// An optional string that you want CloudFront to use as a prefix to the access
	// log filenames for this distribution.
	Prefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionLogging) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionLogging) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *AwsCloudFrontDistributionLogging) SetBucket(v string) *AwsCloudFrontDistributionLogging {
	s.Bucket = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AwsCloudFrontDistributionLogging) SetEnabled(v bool) *AwsCloudFrontDistributionLogging {
	s.Enabled = &v
	return s
}

// SetIncludeCookies sets the IncludeCookies field's value.
func (s *AwsCloudFrontDistributionLogging) SetIncludeCookies(v bool) *AwsCloudFrontDistributionLogging {
	s.IncludeCookies = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *AwsCloudFrontDistributionLogging) SetPrefix(v string) *AwsCloudFrontDistributionLogging {
	s.Prefix = &v
	return s
}

// Information about an origin group for the distribution.
type AwsCloudFrontDistributionOriginGroup struct {
	_ struct{} `type:"structure"`

	// Provides the criteria for an origin group to fail over.
	FailoverCriteria *AwsCloudFrontDistributionOriginGroupFailover `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginGroup) GoString() string {
	return s.String()
}

// SetFailoverCriteria sets the FailoverCriteria field's value.
func (s *AwsCloudFrontDistributionOriginGroup) SetFailoverCriteria(v *AwsCloudFrontDistributionOriginGroupFailover) *AwsCloudFrontDistributionOriginGroup {
	s.FailoverCriteria = v
	return s
}

// Provides information about when an origin group fails over.
type AwsCloudFrontDistributionOriginGroupFailover struct {
	_ struct{} `type:"structure"`

	// Information about the status codes that cause an origin group to fail over.
	StatusCodes *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginGroupFailover) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginGroupFailover) GoString() string {
	return s.String()
}

// SetStatusCodes sets the StatusCodes field's value.
func (s *AwsCloudFrontDistributionOriginGroupFailover) SetStatusCodes(v *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes) *AwsCloudFrontDistributionOriginGroupFailover {
	s.StatusCodes = v
	return s
}

// The status codes that cause an origin group to fail over.
type AwsCloudFrontDistributionOriginGroupFailoverStatusCodes struct {
	_ struct{} `type:"structure"`

	// The list of status code values that can cause a failover to the next origin.
	Items []*int64 `type:"list"`

	// The number of status codes that can cause a failover.
	Quantity *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginGroupFailoverStatusCodes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginGroupFailoverStatusCodes) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes) SetItems(v []*int64) *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes) SetQuantity(v int64) *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes {
	s.Quantity = &v
	return s
}

// Provides information about origin groups that are associated with the distribution.
type AwsCloudFrontDistributionOriginGroups struct {
	_ struct{} `type:"structure"`

	// The list of origin groups.
	Items []*AwsCloudFrontDistributionOriginGroup `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginGroups) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginGroups) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *AwsCloudFrontDistributionOriginGroups) SetItems(v []*AwsCloudFrontDistributionOriginGroup) *AwsCloudFrontDistributionOriginGroups {
	s.Items = v
	return s
}

// A complex type that describes the S3 bucket, HTTP server (for example, a
// web server), AWS Elemental MediaStore, or other server from which CloudFront
// gets your files.
type AwsCloudFrontDistributionOriginItem struct {
	_ struct{} `type:"structure"`

	// Amazon S3 origins: The DNS name of the S3 bucket from which you want CloudFront
	// to get objects for this origin.
	DomainName *string `type:"string"`

	// A unique identifier for the origin or origin group.
	Id *string `type:"string"`

	// An optional element that causes CloudFront to request your content from a
	// directory in your Amazon S3 bucket or your custom origin.
	OriginPath *string `type:"string"`

	// An origin that is an S3 bucket that is not configured with static website
	// hosting.
	S3OriginConfig *AwsCloudFrontDistributionOriginS3OriginConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginItem) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *AwsCloudFrontDistributionOriginItem) SetDomainName(v string) *AwsCloudFrontDistributionOriginItem {
	s.DomainName = &v
	return s
}

// SetId sets the Id field's value.
func (s *AwsCloudFrontDistributionOriginItem) SetId(v string) *AwsCloudFrontDistributionOriginItem {
	s.Id = &v
	return s
}

// SetOriginPath sets the OriginPath field's value.
func (s *AwsCloudFrontDistributionOriginItem) SetOriginPath(v string) *AwsCloudFrontDistributionOriginItem {
	s.OriginPath = &v
	return s
}

// SetS3OriginConfig sets the S3OriginConfig field's value.
func (s *AwsCloudFrontDistributionOriginItem) SetS3OriginConfig(v *AwsCloudFrontDistributionOriginS3OriginConfig) *AwsCloudFrontDistributionOriginItem {
	s.S3OriginConfig = v
	return s
}

// Information about an origin that is an S3 bucket that is not configured with
// static website hosting.
type AwsCloudFrontDistributionOriginS3OriginConfig struct {
	_ struct{} `type:"structure"`

	// The CloudFront origin access identity to associate with the origin.
	OriginAccessIdentity *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginS3OriginConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOriginS3OriginConfig) GoString() string {
	return s.String()
}

// SetOriginAccessIdentity sets the OriginAccessIdentity field's value.
func (s *AwsCloudFrontDistributionOriginS3OriginConfig) SetOriginAccessIdentity(v string) *AwsCloudFrontDistributionOriginS3OriginConfig {
	s.OriginAccessIdentity = &v
	return s
}

// A complex type that contains information about origins and origin groups
// for this distribution.
type AwsCloudFrontDistributionOrigins struct {
	_ struct{} `type:"structure"`

	// A complex type that contains origins or origin groups for this distribution.
	Items []*AwsCloudFrontDistributionOriginItem `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOrigins) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionOrigins) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *AwsCloudFrontDistributionOrigins) SetItems(v []*AwsCloudFrontDistributionOriginItem) *AwsCloudFrontDistributionOrigins {
	s.Items = v
	return s
}

// Provides information about the TLS/SSL configuration that the distribution
// uses to communicate with viewers.
type AwsCloudFrontDistributionViewerCertificate struct {
	_ struct{} `type:"structure"`

	// The ARN of the ACM certificate. Used if the certificate is stored in ACM.
	// If you provide an ACM certificate ARN, you must also provide MinimumCertificateVersion
	// and SslSupportMethod.
	AcmCertificateArn *string `type:"string"`

	// The identifier of the certificate. Note that in CloudFront, this attribute
	// is deprecated.
	Certificate *string `type:"string"`

	// The source of the certificate identified by Certificate. Note that in CloudFront,
	// this attribute is deprecated.
	CertificateSource *string `type:"string"`

	// Whether the distribution uses the CloudFront domain name. If set to false,
	// then you provide either AcmCertificateArn or IamCertificateId.
	CloudFrontDefaultCertificate *bool `type:"boolean"`

	// The identifier of the IAM certificate. Used if the certificate is stored
	// in IAM. If you provide IamCertificateId, then you also must provide MinimumProtocolVersion
	// and SslSupportMethod.
	IamCertificateId *string `type:"string"`

	// The security policy that CloudFront uses for HTTPS connections with viewers.
	// If SslSupportMethod is sni-only, then MinimumProtocolVersion must be TLSv1
	// or higher.
	MinimumProtocolVersion *string `type:"string"`

	// The viewers that the distribution accepts HTTPS connections from.
	SslSupportMethod *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionViewerCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudFrontDistributionViewerCertificate) GoString() string {
	return s.String()
}

// SetAcmCertificateArn sets the AcmCertificateArn field's value.
func (s *AwsCloudFrontDistributionViewerCertificate) SetAcmCertificateArn(v string) *AwsCloudFrontDistributionViewerCertificate {
	s.AcmCertificateArn = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *AwsCloudFrontDistributionViewerCertificate) SetCertificate(v string) *AwsCloudFrontDistributionViewerCertificate {
	s.Certificate = &v
	return s
}

// SetCertificateSource sets the CertificateSource field's value.
func (s *AwsCloudFrontDistributionViewerCertificate) SetCertificateSource(v string) *AwsCloudFrontDistributionViewerCertificate {
	s.CertificateSource = &v
	return s
}

// SetCloudFrontDefaultCertificate sets the CloudFrontDefaultCertificate field's value.
func (s *AwsCloudFrontDistributionViewerCertificate) SetCloudFrontDefaultCertificate(v bool) *AwsCloudFrontDistributionViewerCertificate {
	s.CloudFrontDefaultCertificate = &v
	return s
}

// SetIamCertificateId sets the IamCertificateId field's value.
func (s *AwsCloudFrontDistributionViewerCertificate) SetIamCertificateId(v string) *AwsCloudFrontDistributionViewerCertificate {
	s.IamCertificateId = &v
	return s
}

// SetMinimumProtocolVersion sets the MinimumProtocolVersion field's value.
func (s *AwsCloudFrontDistributionViewerCertificate) SetMinimumProtocolVersion(v string) *AwsCloudFrontDistributionViewerCertificate {
	s.MinimumProtocolVersion = &v
	return s
}

// SetSslSupportMethod sets the SslSupportMethod field's value.
func (s *AwsCloudFrontDistributionViewerCertificate) SetSslSupportMethod(v string) *AwsCloudFrontDistributionViewerCertificate {
	s.SslSupportMethod = &v
	return s
}

// Provides details about a CloudTrail trail.
type AwsCloudTrailTrailDetails struct {
	_ struct{} `type:"structure"`

	// The ARN of the log group that CloudTrail logs are delivered to.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// The ARN of the role that the CloudWatch Events endpoint assumes when it writes
	// to the log group.
	CloudWatchLogsRoleArn *string `type:"string"`

	// Indicates whether the trail has custom event selectors.
	HasCustomEventSelectors *bool `type:"boolean"`

	// The Region where the trail was created.
	HomeRegion *string `type:"string"`

	// Indicates whether the trail publishes events from global services such as
	// IAM to the log files.
	IncludeGlobalServiceEvents *bool `type:"boolean"`

	// Indicates whether the trail applies only to the current Region or to all
	// Regions.
	IsMultiRegionTrail *bool `type:"boolean"`

	// Whether the trail is created for all accounts in an organization in Organizations,
	// or only for the current Amazon Web Services account.
	IsOrganizationTrail *bool `type:"boolean"`

	// The KMS key ID to use to encrypt the logs.
	KmsKeyId *string `type:"string"`

	// Indicates whether CloudTrail log file validation is enabled.
	LogFileValidationEnabled *bool `type:"boolean"`

	// The name of the trail.
	Name *string `type:"string"`

	// The name of the S3 bucket where the log files are published.
	S3BucketName *string `type:"string"`

	// The S3 key prefix. The key prefix is added after the name of the S3 bucket
	// where the log files are published.
	S3KeyPrefix *string `type:"string"`

	// The ARN of the SNS topic that is used for notifications of log file delivery.
	SnsTopicArn *string `type:"string"`

	// The name of the SNS topic that is used for notifications of log file delivery.
	SnsTopicName *string `type:"string"`

	// The ARN of the trail.
	TrailArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudTrailTrailDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCloudTrailTrailDetails) GoString() string {
	return s.String()
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *AwsCloudTrailTrailDetails) SetCloudWatchLogsLogGroupArn(v string) *AwsCloudTrailTrailDetails {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetCloudWatchLogsRoleArn sets the CloudWatchLogsRoleArn field's value.
func (s *AwsCloudTrailTrailDetails) SetCloudWatchLogsRoleArn(v string) *AwsCloudTrailTrailDetails {
	s.CloudWatchLogsRoleArn = &v
	return s
}

// SetHasCustomEventSelectors sets the HasCustomEventSelectors field's value.
func (s *AwsCloudTrailTrailDetails) SetHasCustomEventSelectors(v bool) *AwsCloudTrailTrailDetails {
	s.HasCustomEventSelectors = &v
	return s
}

// SetHomeRegion sets the HomeRegion field's value.
func (s *AwsCloudTrailTrailDetails) SetHomeRegion(v string) *AwsCloudTrailTrailDetails {
	s.HomeRegion = &v
	return s
}

// SetIncludeGlobalServiceEvents sets the IncludeGlobalServiceEvents field's value.
func (s *AwsCloudTrailTrailDetails) SetIncludeGlobalServiceEvents(v bool) *AwsCloudTrailTrailDetails {
	s.IncludeGlobalServiceEvents = &v
	return s
}

// SetIsMultiRegionTrail sets the IsMultiRegionTrail field's value.
func (s *AwsCloudTrailTrailDetails) SetIsMultiRegionTrail(v bool) *AwsCloudTrailTrailDetails {
	s.IsMultiRegionTrail = &v
	return s
}

// SetIsOrganizationTrail sets the IsOrganizationTrail field's value.
func (s *AwsCloudTrailTrailDetails) SetIsOrganizationTrail(v bool) *AwsCloudTrailTrailDetails {
	s.IsOrganizationTrail = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsCloudTrailTrailDetails) SetKmsKeyId(v string) *AwsCloudTrailTrailDetails {
	s.KmsKeyId = &v
	return s
}

// SetLogFileValidationEnabled sets the LogFileValidationEnabled field's value.
func (s *AwsCloudTrailTrailDetails) SetLogFileValidationEnabled(v bool) *AwsCloudTrailTrailDetails {
	s.LogFileValidationEnabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *AwsCloudTrailTrailDetails) SetName(v string) *AwsCloudTrailTrailDetails {
	s.Name = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *AwsCloudTrailTrailDetails) SetS3BucketName(v string) *AwsCloudTrailTrailDetails {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *AwsCloudTrailTrailDetails) SetS3KeyPrefix(v string) *AwsCloudTrailTrailDetails {
	s.S3KeyPrefix = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *AwsCloudTrailTrailDetails) SetSnsTopicArn(v string) *AwsCloudTrailTrailDetails {
	s.SnsTopicArn = &v
	return s
}

// SetSnsTopicName sets the SnsTopicName field's value.
func (s *AwsCloudTrailTrailDetails) SetSnsTopicName(v string) *AwsCloudTrailTrailDetails {
	s.SnsTopicName = &v
	return s
}

// SetTrailArn sets the TrailArn field's value.
func (s *AwsCloudTrailTrailDetails) SetTrailArn(v string) *AwsCloudTrailTrailDetails {
	s.TrailArn = &v
	return s
}

// Information about the build artifacts for the CodeBuild project.
type AwsCodeBuildProjectArtifactsDetails struct {
	_ struct{} `type:"structure"`

	// An identifier for the artifact definition.
	ArtifactIdentifier *string `type:"string"`

	// Indicates whether to disable encryption on the artifact. Only valid when
	// Type is S3.
	EncryptionDisabled *bool `type:"boolean"`

	// Only used when Type is S3. The name of the S3 bucket where the artifact is
	// located.
	Location *string `type:"string"`

	// Only used when Type is S3. The name of the artifact. Used with NamepaceType
	// and Path to determine the pattern for storing the artifact.
	Name *string `type:"string"`

	// Only used when Type is S3. The value to use for the namespace. Used with
	// Name and Path to determine the pattern for storing the artifact.
	NamespaceType *string `type:"string"`

	// Whether the name specified in the buildspec file overrides the artifact name.
	OverrideArtifactName *bool `type:"boolean"`

	// Only used when Type is S3. The type of output artifact to create.
	Packaging *string `type:"string"`

	// Only used when Type is S3. The path to the artifact. Used with Name and NamespaceType
	// to determine the pattern for storing the artifact.
	Path *string `type:"string"`

	// The type of build artifact.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectArtifactsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectArtifactsDetails) GoString() string {
	return s.String()
}

// SetArtifactIdentifier sets the ArtifactIdentifier field's value.
func (s *AwsCodeBuildProjectArtifactsDetails) SetArtifactIdentifier(v string) *AwsCodeBuildProjectArtifactsDetails {
	s.ArtifactIdentifier = &v
	return s
}

// SetEncryptionDisabled sets the EncryptionDisabled field's value.
func (s *AwsCodeBuildProjectArtifactsDetails) SetEncryptionDisabled(v bool) *AwsCodeBuildProjectArtifactsDetails {
	s.EncryptionDisabled = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *AwsCodeBuildProjectArtifactsDetails) SetLocation(v string) *AwsCodeBuildProjectArtifactsDetails {
	s.Location = &v
	return s
}

// SetName sets the Name field's value.
func (s *AwsCodeBuildProjectArtifactsDetails) SetName(v string) *AwsCodeBuildProjectArtifactsDetails {
	s.Name = &v
	return s
}

// SetNamespaceType sets the NamespaceType field's value.
func (s *AwsCodeBuildProjectArtifactsDetails) SetNamespaceType(v string) *AwsCodeBuildProjectArtifactsDetails {
	s.NamespaceType = &v
	return s
}

// SetOverrideArtifactName sets the OverrideArtifactName field's value.
func (s *AwsCodeBuildProjectArtifactsDetails) SetOverrideArtifactName(v bool) *AwsCodeBuildProjectArtifactsDetails {
	s.OverrideArtifactName = &v
	return s
}

// SetPackaging sets the Packaging field's value.
func (s *AwsCodeBuildProjectArtifactsDetails) SetPackaging(v string) *AwsCodeBuildProjectArtifactsDetails {
	s.Packaging = &v
	return s
}

// SetPath sets the Path field's value.
func (s *AwsCodeBuildProjectArtifactsDetails) SetPath(v string) *AwsCodeBuildProjectArtifactsDetails {
	s.Path = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsCodeBuildProjectArtifactsDetails) SetType(v string) *AwsCodeBuildProjectArtifactsDetails {
	s.Type = &v
	return s
}

// Information about an CodeBuild project.
type AwsCodeBuildProjectDetails struct {
	_ struct{} `type:"structure"`

	// Information about the build artifacts for the CodeBuild project.
	Artifacts []*AwsCodeBuildProjectArtifactsDetails `type:"list"`

	// The KMS key used to encrypt the build output artifacts.
	//
	// You can specify either the ARN of the KMS key or, if available, the KMS key
	// alias (using the format alias/alias-name).
	EncryptionKey *string `type:"string"`

	// Information about the build environment for this build project.
	Environment *AwsCodeBuildProjectEnvironment `type:"structure"`

	// Information about logs for the build project.
	LogsConfig *AwsCodeBuildProjectLogsConfigDetails `type:"structure"`

	// The name of the build project.
	Name *string `type:"string"`

	// Information about the secondary artifacts for the CodeBuild project.
	SecondaryArtifacts []*AwsCodeBuildProjectArtifactsDetails `type:"list"`

	// The ARN of the IAM role that enables CodeBuild to interact with dependent
	// Amazon Web Services services on behalf of the Amazon Web Services account.
	ServiceRole *string `type:"string"`

	// Information about the build input source code for this build project.
	Source *AwsCodeBuildProjectSource `type:"structure"`

	// Information about the VPC configuration that CodeBuild accesses.
	VpcConfig *AwsCodeBuildProjectVpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectDetails) GoString() string {
	return s.String()
}

// SetArtifacts sets the Artifacts field's value.
func (s *AwsCodeBuildProjectDetails) SetArtifacts(v []*AwsCodeBuildProjectArtifactsDetails) *AwsCodeBuildProjectDetails {
	s.Artifacts = v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *AwsCodeBuildProjectDetails) SetEncryptionKey(v string) *AwsCodeBuildProjectDetails {
	s.EncryptionKey = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *AwsCodeBuildProjectDetails) SetEnvironment(v *AwsCodeBuildProjectEnvironment) *AwsCodeBuildProjectDetails {
	s.Environment = v
	return s
}

// SetLogsConfig sets the LogsConfig field's value.
func (s *AwsCodeBuildProjectDetails) SetLogsConfig(v *AwsCodeBuildProjectLogsConfigDetails) *AwsCodeBuildProjectDetails {
	s.LogsConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *AwsCodeBuildProjectDetails) SetName(v string) *AwsCodeBuildProjectDetails {
	s.Name = &v
	return s
}

// SetSecondaryArtifacts sets the SecondaryArtifacts field's value.
func (s *AwsCodeBuildProjectDetails) SetSecondaryArtifacts(v []*AwsCodeBuildProjectArtifactsDetails) *AwsCodeBuildProjectDetails {
	s.SecondaryArtifacts = v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *AwsCodeBuildProjectDetails) SetServiceRole(v string) *AwsCodeBuildProjectDetails {
	s.ServiceRole = &v
	return s
}

// SetSource sets the Source field's value.
func (s *AwsCodeBuildProjectDetails) SetSource(v *AwsCodeBuildProjectSource) *AwsCodeBuildProjectDetails {
	s.Source = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *AwsCodeBuildProjectDetails) SetVpcConfig(v *AwsCodeBuildProjectVpcConfig) *AwsCodeBuildProjectDetails {
	s.VpcConfig = v
	return s
}

// Information about the build environment for this build project.
type AwsCodeBuildProjectEnvironment struct {
	_ struct{} `type:"structure"`

	// The certificate to use with this build project.
	Certificate *string `type:"string"`

	// A set of environment variables to make available to builds for the build
	// project.
	EnvironmentVariables []*AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails `type:"list"`

	// The type of credentials CodeBuild uses to pull images in your build.
	//
	// Valid values:
	//
	//    * CODEBUILD specifies that CodeBuild uses its own credentials. This requires
	//    that you modify your ECR repository policy to trust the CodeBuild service
	//    principal.
	//
	//    * SERVICE_ROLE specifies that CodeBuild uses your build project's service
	//    role.
	//
	// When you use a cross-account or private registry image, you must use SERVICE_ROLE
	// credentials. When you use an CodeBuild curated image, you must use CODEBUILD
	// credentials.
	ImagePullCredentialsType *string `type:"string"`

	// Whether to allow the Docker daemon to run inside a Docker container. Set
	// to true if the build project is used to build Docker images.
	PrivilegedMode *bool `type:"boolean"`

	// The credentials for access to a private registry.
	RegistryCredential *AwsCodeBuildProjectEnvironmentRegistryCredential `type:"structure"`

	// The type of build environment to use for related builds.
	//
	// The environment type ARM_CONTAINER is available only in Regions US East (N.
	// Virginia), US East (Ohio), US West (Oregon), Europe (Ireland), Asia Pacific
	// (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney), and Europe (Frankfurt).
	//
	// The environment type LINUX_CONTAINER with compute type build.general1.2xlarge
	// is available only in Regions US East (N. Virginia), US East (N. Virginia),
	// US West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe
	// (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore),
	// Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
	//
	// The environment type LINUX_GPU_CONTAINER is available only in Regions US
	// East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central),
	// Europe (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo),
	// Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China
	// (Beijing), and China (Ningxia).
	//
	// Valid values: WINDOWS_CONTAINER | LINUX_CONTAINER | LINUX_GPU_CONTAINER |
	// ARM_CONTAINER
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectEnvironment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectEnvironment) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *AwsCodeBuildProjectEnvironment) SetCertificate(v string) *AwsCodeBuildProjectEnvironment {
	s.Certificate = &v
	return s
}

// SetEnvironmentVariables sets the EnvironmentVariables field's value.
func (s *AwsCodeBuildProjectEnvironment) SetEnvironmentVariables(v []*AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails) *AwsCodeBuildProjectEnvironment {
	s.EnvironmentVariables = v
	return s
}

// SetImagePullCredentialsType sets the ImagePullCredentialsType field's value.
func (s *AwsCodeBuildProjectEnvironment) SetImagePullCredentialsType(v string) *AwsCodeBuildProjectEnvironment {
	s.ImagePullCredentialsType = &v
	return s
}

// SetPrivilegedMode sets the PrivilegedMode field's value.
func (s *AwsCodeBuildProjectEnvironment) SetPrivilegedMode(v bool) *AwsCodeBuildProjectEnvironment {
	s.PrivilegedMode = &v
	return s
}

// SetRegistryCredential sets the RegistryCredential field's value.
func (s *AwsCodeBuildProjectEnvironment) SetRegistryCredential(v *AwsCodeBuildProjectEnvironmentRegistryCredential) *AwsCodeBuildProjectEnvironment {
	s.RegistryCredential = v
	return s
}

// SetType sets the Type field's value.
func (s *AwsCodeBuildProjectEnvironment) SetType(v string) *AwsCodeBuildProjectEnvironment {
	s.Type = &v
	return s
}

// Information about an environment variable that is available to builds for
// the build project.
type AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails struct {
	_ struct{} `type:"structure"`

	// The name of the environment variable.
	Name *string `type:"string"`

	// The type of environment variable.
	Type *string `type:"string"`

	// The value of the environment variable.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails) SetName(v string) *AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails) SetType(v string) *AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails) SetValue(v string) *AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails {
	s.Value = &v
	return s
}

// The credentials for access to a private registry.
type AwsCodeBuildProjectEnvironmentRegistryCredential struct {
	_ struct{} `type:"structure"`

	// The ARN or name of credentials created using Secrets Manager.
	//
	// The credential can use the name of the credentials only if they exist in
	// your current Amazon Web Services Region.
	Credential *string `type:"string"`

	// The service that created the credentials to access a private Docker registry.
	//
	// The valid value,SECRETS_MANAGER, is for Secrets Manager.
	CredentialProvider *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectEnvironmentRegistryCredential) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectEnvironmentRegistryCredential) GoString() string {
	return s.String()
}

// SetCredential sets the Credential field's value.
func (s *AwsCodeBuildProjectEnvironmentRegistryCredential) SetCredential(v string) *AwsCodeBuildProjectEnvironmentRegistryCredential {
	s.Credential = &v
	return s
}

// SetCredentialProvider sets the CredentialProvider field's value.
func (s *AwsCodeBuildProjectEnvironmentRegistryCredential) SetCredentialProvider(v string) *AwsCodeBuildProjectEnvironmentRegistryCredential {
	s.CredentialProvider = &v
	return s
}

// Information about CloudWatch Logs for the build project.
type AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails struct {
	_ struct{} `type:"structure"`

	// The group name of the logs in CloudWatch Logs.
	GroupName *string `type:"string"`

	// The current status of the logs in CloudWatch Logs for a build project.
	Status *string `type:"string"`

	// The prefix of the stream name of the CloudWatch Logs.
	StreamName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails) GoString() string {
	return s.String()
}

// SetGroupName sets the GroupName field's value.
func (s *AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails) SetGroupName(v string) *AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails {
	s.GroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails) SetStatus(v string) *AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails {
	s.Status = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails) SetStreamName(v string) *AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails {
	s.StreamName = &v
	return s
}

// Information about logs for the build project.
type AwsCodeBuildProjectLogsConfigDetails struct {
	_ struct{} `type:"structure"`

	// Information about CloudWatch Logs for the build project.
	CloudWatchLogs *AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails `type:"structure"`

	// Information about logs built to an S3 bucket for a build project.
	S3Logs *AwsCodeBuildProjectLogsConfigS3LogsDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectLogsConfigDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectLogsConfigDetails) GoString() string {
	return s.String()
}

// SetCloudWatchLogs sets the CloudWatchLogs field's value.
func (s *AwsCodeBuildProjectLogsConfigDetails) SetCloudWatchLogs(v *AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails) *AwsCodeBuildProjectLogsConfigDetails {
	s.CloudWatchLogs = v
	return s
}

// SetS3Logs sets the S3Logs field's value.
func (s *AwsCodeBuildProjectLogsConfigDetails) SetS3Logs(v *AwsCodeBuildProjectLogsConfigS3LogsDetails) *AwsCodeBuildProjectLogsConfigDetails {
	s.S3Logs = v
	return s
}

// Information about logs built to an S3 bucket for a build project.
type AwsCodeBuildProjectLogsConfigS3LogsDetails struct {
	_ struct{} `type:"structure"`

	// Whether to disable encryption of the S3 build log output.
	EncryptionDisabled *bool `type:"boolean"`

	// The ARN of the S3 bucket and the path prefix for S3 logs.
	Location *string `type:"string"`

	// The current status of the S3 build logs.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectLogsConfigS3LogsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectLogsConfigS3LogsDetails) GoString() string {
	return s.String()
}

// SetEncryptionDisabled sets the EncryptionDisabled field's value.
func (s *AwsCodeBuildProjectLogsConfigS3LogsDetails) SetEncryptionDisabled(v bool) *AwsCodeBuildProjectLogsConfigS3LogsDetails {
	s.EncryptionDisabled = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *AwsCodeBuildProjectLogsConfigS3LogsDetails) SetLocation(v string) *AwsCodeBuildProjectLogsConfigS3LogsDetails {
	s.Location = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsCodeBuildProjectLogsConfigS3LogsDetails) SetStatus(v string) *AwsCodeBuildProjectLogsConfigS3LogsDetails {
	s.Status = &v
	return s
}

// Information about the build input source code for this build project.
type AwsCodeBuildProjectSource struct {
	_ struct{} `type:"structure"`

	// Information about the Git clone depth for the build project.
	GitCloneDepth *int64 `type:"integer"`

	// Whether to ignore SSL warnings while connecting to the project source code.
	InsecureSsl *bool `type:"boolean"`

	// Information about the location of the source code to be built.
	//
	// Valid values include:
	//
	//    * For source code settings that are specified in the source action of
	//    a pipeline in CodePipeline, location should not be specified. If it is
	//    specified, CodePipeline ignores it. This is because CodePipeline uses
	//    the settings in a pipeline's source action instead of this value.
	//
	//    * For source code in an CodeCommit repository, the HTTPS clone URL to
	//    the repository that contains the source code and the build spec file (for
	//    example, https://git-codecommit.region-ID.amazonaws.com/v1/repos/repo-name
	//    ).
	//
	//    * For source code in an S3 input bucket, one of the following. The path
	//    to the ZIP file that contains the source code (for example, bucket-name/path/to/object-name.zip).
	//    The path to the folder that contains the source code (for example, bucket-name/path/to/source-code/folder/).
	//
	//    * For source code in a GitHub repository, the HTTPS clone URL to the repository
	//    that contains the source and the build spec file.
	//
	//    * For source code in a Bitbucket repository, the HTTPS clone URL to the
	//    repository that contains the source and the build spec file.
	Location *string `type:"string"`

	// The type of repository that contains the source code to be built. Valid values
	// are:
	//
	//    * BITBUCKET - The source code is in a Bitbucket repository.
	//
	//    * CODECOMMIT - The source code is in an CodeCommit repository.
	//
	//    * CODEPIPELINE - The source code settings are specified in the source
	//    action of a pipeline in CodePipeline.
	//
	//    * GITHUB - The source code is in a GitHub repository.
	//
	//    * GITHUB_ENTERPRISE - The source code is in a GitHub Enterprise repository.
	//
	//    * NO_SOURCE - The project does not have input source code.
	//
	//    * S3 - The source code is in an S3 input bucket.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectSource) GoString() string {
	return s.String()
}

// SetGitCloneDepth sets the GitCloneDepth field's value.
func (s *AwsCodeBuildProjectSource) SetGitCloneDepth(v int64) *AwsCodeBuildProjectSource {
	s.GitCloneDepth = &v
	return s
}

// SetInsecureSsl sets the InsecureSsl field's value.
func (s *AwsCodeBuildProjectSource) SetInsecureSsl(v bool) *AwsCodeBuildProjectSource {
	s.InsecureSsl = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *AwsCodeBuildProjectSource) SetLocation(v string) *AwsCodeBuildProjectSource {
	s.Location = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsCodeBuildProjectSource) SetType(v string) *AwsCodeBuildProjectSource {
	s.Type = &v
	return s
}

// Information about the VPC configuration that CodeBuild accesses.
type AwsCodeBuildProjectVpcConfig struct {
	_ struct{} `type:"structure"`

	// A list of one or more security group IDs in your VPC.
	SecurityGroupIds []*string `type:"list"`

	// A list of one or more subnet IDs in your VPC.
	Subnets []*string `type:"list"`

	// The ID of the VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectVpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCodeBuildProjectVpcConfig) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *AwsCodeBuildProjectVpcConfig) SetSecurityGroupIds(v []*string) *AwsCodeBuildProjectVpcConfig {
	s.SecurityGroupIds = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *AwsCodeBuildProjectVpcConfig) SetSubnets(v []*string) *AwsCodeBuildProjectVpcConfig {
	s.Subnets = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsCodeBuildProjectVpcConfig) SetVpcId(v string) *AwsCodeBuildProjectVpcConfig {
	s.VpcId = &v
	return s
}

// Contains the cross-origin resource sharing (CORS) configuration for the API.
// CORS is only supported for HTTP APIs.
type AwsCorsConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether the CORS request includes credentials.
	AllowCredentials *bool `type:"boolean"`

	// The allowed headers for CORS requests.
	AllowHeaders []*string `type:"list"`

	// The allowed methods for CORS requests.
	AllowMethods []*string `type:"list"`

	// The allowed origins for CORS requests.
	AllowOrigins []*string `type:"list"`

	// The exposed headers for CORS requests.
	ExposeHeaders []*string `type:"list"`

	// The number of seconds for which the browser caches preflight request results.
	MaxAge *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCorsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCorsConfiguration) GoString() string {
	return s.String()
}

// SetAllowCredentials sets the AllowCredentials field's value.
func (s *AwsCorsConfiguration) SetAllowCredentials(v bool) *AwsCorsConfiguration {
	s.AllowCredentials = &v
	return s
}

// SetAllowHeaders sets the AllowHeaders field's value.
func (s *AwsCorsConfiguration) SetAllowHeaders(v []*string) *AwsCorsConfiguration {
	s.AllowHeaders = v
	return s
}

// SetAllowMethods sets the AllowMethods field's value.
func (s *AwsCorsConfiguration) SetAllowMethods(v []*string) *AwsCorsConfiguration {
	s.AllowMethods = v
	return s
}

// SetAllowOrigins sets the AllowOrigins field's value.
func (s *AwsCorsConfiguration) SetAllowOrigins(v []*string) *AwsCorsConfiguration {
	s.AllowOrigins = v
	return s
}

// SetExposeHeaders sets the ExposeHeaders field's value.
func (s *AwsCorsConfiguration) SetExposeHeaders(v []*string) *AwsCorsConfiguration {
	s.ExposeHeaders = v
	return s
}

// SetMaxAge sets the MaxAge field's value.
func (s *AwsCorsConfiguration) SetMaxAge(v int64) *AwsCorsConfiguration {
	s.MaxAge = &v
	return s
}

// Contains a definition of an attribute for the table.
type AwsDynamoDbTableAttributeDefinition struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	AttributeName *string `type:"string"`

	// The type of the attribute.
	AttributeType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableAttributeDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableAttributeDefinition) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *AwsDynamoDbTableAttributeDefinition) SetAttributeName(v string) *AwsDynamoDbTableAttributeDefinition {
	s.AttributeName = &v
	return s
}

// SetAttributeType sets the AttributeType field's value.
func (s *AwsDynamoDbTableAttributeDefinition) SetAttributeType(v string) *AwsDynamoDbTableAttributeDefinition {
	s.AttributeType = &v
	return s
}

// Provides information about the billing for read/write capacity on the table.
type AwsDynamoDbTableBillingModeSummary struct {
	_ struct{} `type:"structure"`

	// The method used to charge for read and write throughput and to manage capacity.
	BillingMode *string `type:"string"`

	// If the billing mode is PAY_PER_REQUEST, indicates when the billing mode was
	// set to that value.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastUpdateToPayPerRequestDateTime *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableBillingModeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableBillingModeSummary) GoString() string {
	return s.String()
}

// SetBillingMode sets the BillingMode field's value.
func (s *AwsDynamoDbTableBillingModeSummary) SetBillingMode(v string) *AwsDynamoDbTableBillingModeSummary {
	s.BillingMode = &v
	return s
}

// SetLastUpdateToPayPerRequestDateTime sets the LastUpdateToPayPerRequestDateTime field's value.
func (s *AwsDynamoDbTableBillingModeSummary) SetLastUpdateToPayPerRequestDateTime(v string) *AwsDynamoDbTableBillingModeSummary {
	s.LastUpdateToPayPerRequestDateTime = &v
	return s
}

// Provides details about a DynamoDB table.
type AwsDynamoDbTableDetails struct {
	_ struct{} `type:"structure"`

	// A list of attribute definitions for the table.
	AttributeDefinitions []*AwsDynamoDbTableAttributeDefinition `type:"list"`

	// Information about the billing for read/write capacity on the table.
	BillingModeSummary *AwsDynamoDbTableBillingModeSummary `type:"structure"`

	// Indicates when the table was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreationDateTime *string `type:"string"`

	// List of global secondary indexes for the table.
	GlobalSecondaryIndexes []*AwsDynamoDbTableGlobalSecondaryIndex `type:"list"`

	// The version of global tables being used.
	GlobalTableVersion *string `type:"string"`

	// The number of items in the table.
	ItemCount *int64 `type:"integer"`

	// The primary key structure for the table.
	KeySchema []*AwsDynamoDbTableKeySchema `type:"list"`

	// The ARN of the latest stream for the table.
	LatestStreamArn *string `type:"string"`

	// The label of the latest stream. The label is not a unique identifier.
	LatestStreamLabel *string `type:"string"`

	// The list of local secondary indexes for the table.
	LocalSecondaryIndexes []*AwsDynamoDbTableLocalSecondaryIndex `type:"list"`

	// Information about the provisioned throughput for the table.
	ProvisionedThroughput *AwsDynamoDbTableProvisionedThroughput `type:"structure"`

	// The list of replicas of this table.
	Replicas []*AwsDynamoDbTableReplica `type:"list"`

	// Information about the restore for the table.
	RestoreSummary *AwsDynamoDbTableRestoreSummary `type:"structure"`

	// Information about the server-side encryption for the table.
	SseDescription *AwsDynamoDbTableSseDescription `type:"structure"`

	// The current DynamoDB Streams configuration for the table.
	StreamSpecification *AwsDynamoDbTableStreamSpecification `type:"structure"`

	// The identifier of the table.
	TableId *string `type:"string"`

	// The name of the table.
	TableName *string `type:"string"`

	// The total size of the table in bytes.
	TableSizeBytes *int64 `type:"long"`

	// The current status of the table.
	TableStatus *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableDetails) GoString() string {
	return s.String()
}

// SetAttributeDefinitions sets the AttributeDefinitions field's value.
func (s *AwsDynamoDbTableDetails) SetAttributeDefinitions(v []*AwsDynamoDbTableAttributeDefinition) *AwsDynamoDbTableDetails {
	s.AttributeDefinitions = v
	return s
}

// SetBillingModeSummary sets the BillingModeSummary field's value.
func (s *AwsDynamoDbTableDetails) SetBillingModeSummary(v *AwsDynamoDbTableBillingModeSummary) *AwsDynamoDbTableDetails {
	s.BillingModeSummary = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *AwsDynamoDbTableDetails) SetCreationDateTime(v string) *AwsDynamoDbTableDetails {
	s.CreationDateTime = &v
	return s
}

// SetGlobalSecondaryIndexes sets the GlobalSecondaryIndexes field's value.
func (s *AwsDynamoDbTableDetails) SetGlobalSecondaryIndexes(v []*AwsDynamoDbTableGlobalSecondaryIndex) *AwsDynamoDbTableDetails {
	s.GlobalSecondaryIndexes = v
	return s
}

// SetGlobalTableVersion sets the GlobalTableVersion field's value.
func (s *AwsDynamoDbTableDetails) SetGlobalTableVersion(v string) *AwsDynamoDbTableDetails {
	s.GlobalTableVersion = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *AwsDynamoDbTableDetails) SetItemCount(v int64) *AwsDynamoDbTableDetails {
	s.ItemCount = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *AwsDynamoDbTableDetails) SetKeySchema(v []*AwsDynamoDbTableKeySchema) *AwsDynamoDbTableDetails {
	s.KeySchema = v
	return s
}

// SetLatestStreamArn sets the LatestStreamArn field's value.
func (s *AwsDynamoDbTableDetails) SetLatestStreamArn(v string) *AwsDynamoDbTableDetails {
	s.LatestStreamArn = &v
	return s
}

// SetLatestStreamLabel sets the LatestStreamLabel field's value.
func (s *AwsDynamoDbTableDetails) SetLatestStreamLabel(v string) *AwsDynamoDbTableDetails {
	s.LatestStreamLabel = &v
	return s
}

// SetLocalSecondaryIndexes sets the LocalSecondaryIndexes field's value.
func (s *AwsDynamoDbTableDetails) SetLocalSecondaryIndexes(v []*AwsDynamoDbTableLocalSecondaryIndex) *AwsDynamoDbTableDetails {
	s.LocalSecondaryIndexes = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *AwsDynamoDbTableDetails) SetProvisionedThroughput(v *AwsDynamoDbTableProvisionedThroughput) *AwsDynamoDbTableDetails {
	s.ProvisionedThroughput = v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *AwsDynamoDbTableDetails) SetReplicas(v []*AwsDynamoDbTableReplica) *AwsDynamoDbTableDetails {
	s.Replicas = v
	return s
}

// SetRestoreSummary sets the RestoreSummary field's value.
func (s *AwsDynamoDbTableDetails) SetRestoreSummary(v *AwsDynamoDbTableRestoreSummary) *AwsDynamoDbTableDetails {
	s.RestoreSummary = v
	return s
}

// SetSseDescription sets the SseDescription field's value.
func (s *AwsDynamoDbTableDetails) SetSseDescription(v *AwsDynamoDbTableSseDescription) *AwsDynamoDbTableDetails {
	s.SseDescription = v
	return s
}

// SetStreamSpecification sets the StreamSpecification field's value.
func (s *AwsDynamoDbTableDetails) SetStreamSpecification(v *AwsDynamoDbTableStreamSpecification) *AwsDynamoDbTableDetails {
	s.StreamSpecification = v
	return s
}

// SetTableId sets the TableId field's value.
func (s *AwsDynamoDbTableDetails) SetTableId(v string) *AwsDynamoDbTableDetails {
	s.TableId = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *AwsDynamoDbTableDetails) SetTableName(v string) *AwsDynamoDbTableDetails {
	s.TableName = &v
	return s
}

// SetTableSizeBytes sets the TableSizeBytes field's value.
func (s *AwsDynamoDbTableDetails) SetTableSizeBytes(v int64) *AwsDynamoDbTableDetails {
	s.TableSizeBytes = &v
	return s
}

// SetTableStatus sets the TableStatus field's value.
func (s *AwsDynamoDbTableDetails) SetTableStatus(v string) *AwsDynamoDbTableDetails {
	s.TableStatus = &v
	return s
}

// Information abut a global secondary index for the table.
type AwsDynamoDbTableGlobalSecondaryIndex struct {
	_ struct{} `type:"structure"`

	// Whether the index is currently backfilling.
	Backfilling *bool `type:"boolean"`

	// The ARN of the index.
	IndexArn *string `type:"string"`

	// The name of the index.
	IndexName *string `type:"string"`

	// The total size in bytes of the index.
	IndexSizeBytes *int64 `type:"long"`

	// The current status of the index.
	IndexStatus *string `type:"string"`

	// The number of items in the index.
	ItemCount *int64 `type:"integer"`

	// The key schema for the index.
	KeySchema []*AwsDynamoDbTableKeySchema `type:"list"`

	// Attributes that are copied from the table into an index.
	Projection *AwsDynamoDbTableProjection `type:"structure"`

	// Information about the provisioned throughput settings for the indexes.
	ProvisionedThroughput *AwsDynamoDbTableProvisionedThroughput `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableGlobalSecondaryIndex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableGlobalSecondaryIndex) GoString() string {
	return s.String()
}

// SetBackfilling sets the Backfilling field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetBackfilling(v bool) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.Backfilling = &v
	return s
}

// SetIndexArn sets the IndexArn field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetIndexArn(v string) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.IndexArn = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetIndexName(v string) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.IndexName = &v
	return s
}

// SetIndexSizeBytes sets the IndexSizeBytes field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetIndexSizeBytes(v int64) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.IndexSizeBytes = &v
	return s
}

// SetIndexStatus sets the IndexStatus field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetIndexStatus(v string) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.IndexStatus = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetItemCount(v int64) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.ItemCount = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetKeySchema(v []*AwsDynamoDbTableKeySchema) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.KeySchema = v
	return s
}

// SetProjection sets the Projection field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetProjection(v *AwsDynamoDbTableProjection) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.Projection = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetProvisionedThroughput(v *AwsDynamoDbTableProvisionedThroughput) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.ProvisionedThroughput = v
	return s
}

// A component of the key schema for the DynamoDB table, a global secondary
// index, or a local secondary index.
type AwsDynamoDbTableKeySchema struct {
	_ struct{} `type:"structure"`

	// The name of the key schema attribute.
	AttributeName *string `type:"string"`

	// The type of key used for the key schema attribute.
	KeyType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableKeySchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableKeySchema) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *AwsDynamoDbTableKeySchema) SetAttributeName(v string) *AwsDynamoDbTableKeySchema {
	s.AttributeName = &v
	return s
}

// SetKeyType sets the KeyType field's value.
func (s *AwsDynamoDbTableKeySchema) SetKeyType(v string) *AwsDynamoDbTableKeySchema {
	s.KeyType = &v
	return s
}

// Information about a local secondary index for a DynamoDB table.
type AwsDynamoDbTableLocalSecondaryIndex struct {
	_ struct{} `type:"structure"`

	// The ARN of the index.
	IndexArn *string `type:"string"`

	// The name of the index.
	IndexName *string `type:"string"`

	// The complete key schema for the index.
	KeySchema []*AwsDynamoDbTableKeySchema `type:"list"`

	// Attributes that are copied from the table into the index. These are in addition
	// to the primary key attributes and index key attributes, which are automatically
	// projected.
	Projection *AwsDynamoDbTableProjection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableLocalSecondaryIndex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableLocalSecondaryIndex) GoString() string {
	return s.String()
}

// SetIndexArn sets the IndexArn field's value.
func (s *AwsDynamoDbTableLocalSecondaryIndex) SetIndexArn(v string) *AwsDynamoDbTableLocalSecondaryIndex {
	s.IndexArn = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *AwsDynamoDbTableLocalSecondaryIndex) SetIndexName(v string) *AwsDynamoDbTableLocalSecondaryIndex {
	s.IndexName = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *AwsDynamoDbTableLocalSecondaryIndex) SetKeySchema(v []*AwsDynamoDbTableKeySchema) *AwsDynamoDbTableLocalSecondaryIndex {
	s.KeySchema = v
	return s
}

// SetProjection sets the Projection field's value.
func (s *AwsDynamoDbTableLocalSecondaryIndex) SetProjection(v *AwsDynamoDbTableProjection) *AwsDynamoDbTableLocalSecondaryIndex {
	s.Projection = v
	return s
}

// For global and local secondary indexes, identifies the attributes that are
// copied from the table into the index.
type AwsDynamoDbTableProjection struct {
	_ struct{} `type:"structure"`

	// The nonkey attributes that are projected into the index. For each attribute,
	// provide the attribute name.
	NonKeyAttributes []*string `type:"list"`

	// The types of attributes that are projected into the index.
	ProjectionType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableProjection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableProjection) GoString() string {
	return s.String()
}

// SetNonKeyAttributes sets the NonKeyAttributes field's value.
func (s *AwsDynamoDbTableProjection) SetNonKeyAttributes(v []*string) *AwsDynamoDbTableProjection {
	s.NonKeyAttributes = v
	return s
}

// SetProjectionType sets the ProjectionType field's value.
func (s *AwsDynamoDbTableProjection) SetProjectionType(v string) *AwsDynamoDbTableProjection {
	s.ProjectionType = &v
	return s
}

// Information about the provisioned throughput for the table or for a global
// secondary index.
type AwsDynamoDbTableProvisionedThroughput struct {
	_ struct{} `type:"structure"`

	// Indicates when the provisioned throughput was last decreased.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastDecreaseDateTime *string `type:"string"`

	// Indicates when the provisioned throughput was last increased.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastIncreaseDateTime *string `type:"string"`

	// The number of times during the current UTC calendar day that the provisioned
	// throughput was decreased.
	NumberOfDecreasesToday *int64 `type:"integer"`

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException.
	ReadCapacityUnits *int64 `type:"integer"`

	// The maximum number of writes consumed per second before DynamoDB returns
	// a ThrottlingException.
	WriteCapacityUnits *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableProvisionedThroughput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableProvisionedThroughput) GoString() string {
	return s.String()
}

// SetLastDecreaseDateTime sets the LastDecreaseDateTime field's value.
func (s *AwsDynamoDbTableProvisionedThroughput) SetLastDecreaseDateTime(v string) *AwsDynamoDbTableProvisionedThroughput {
	s.LastDecreaseDateTime = &v
	return s
}

// SetLastIncreaseDateTime sets the LastIncreaseDateTime field's value.
func (s *AwsDynamoDbTableProvisionedThroughput) SetLastIncreaseDateTime(v string) *AwsDynamoDbTableProvisionedThroughput {
	s.LastIncreaseDateTime = &v
	return s
}

// SetNumberOfDecreasesToday sets the NumberOfDecreasesToday field's value.
func (s *AwsDynamoDbTableProvisionedThroughput) SetNumberOfDecreasesToday(v int64) *AwsDynamoDbTableProvisionedThroughput {
	s.NumberOfDecreasesToday = &v
	return s
}

// SetReadCapacityUnits sets the ReadCapacityUnits field's value.
func (s *AwsDynamoDbTableProvisionedThroughput) SetReadCapacityUnits(v int64) *AwsDynamoDbTableProvisionedThroughput {
	s.ReadCapacityUnits = &v
	return s
}

// SetWriteCapacityUnits sets the WriteCapacityUnits field's value.
func (s *AwsDynamoDbTableProvisionedThroughput) SetWriteCapacityUnits(v int64) *AwsDynamoDbTableProvisionedThroughput {
	s.WriteCapacityUnits = &v
	return s
}

// Replica-specific configuration for the provisioned throughput.
type AwsDynamoDbTableProvisionedThroughputOverride struct {
	_ struct{} `type:"structure"`

	// The read capacity units for the replica.
	ReadCapacityUnits *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableProvisionedThroughputOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableProvisionedThroughputOverride) GoString() string {
	return s.String()
}

// SetReadCapacityUnits sets the ReadCapacityUnits field's value.
func (s *AwsDynamoDbTableProvisionedThroughputOverride) SetReadCapacityUnits(v int64) *AwsDynamoDbTableProvisionedThroughputOverride {
	s.ReadCapacityUnits = &v
	return s
}

// Information about a replica of a DynamoDB table.
type AwsDynamoDbTableReplica struct {
	_ struct{} `type:"structure"`

	// List of global secondary indexes for the replica.
	GlobalSecondaryIndexes []*AwsDynamoDbTableReplicaGlobalSecondaryIndex `type:"list"`

	// The identifier of the KMS key that will be used for KMS encryption for the
	// replica.
	KmsMasterKeyId *string `type:"string"`

	// Replica-specific configuration for the provisioned throughput.
	ProvisionedThroughputOverride *AwsDynamoDbTableProvisionedThroughputOverride `type:"structure"`

	// The name of the Region where the replica is located.
	RegionName *string `type:"string"`

	// The current status of the replica.
	ReplicaStatus *string `type:"string"`

	// Detailed information about the replica status.
	ReplicaStatusDescription *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableReplica) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableReplica) GoString() string {
	return s.String()
}

// SetGlobalSecondaryIndexes sets the GlobalSecondaryIndexes field's value.
func (s *AwsDynamoDbTableReplica) SetGlobalSecondaryIndexes(v []*AwsDynamoDbTableReplicaGlobalSecondaryIndex) *AwsDynamoDbTableReplica {
	s.GlobalSecondaryIndexes = v
	return s
}

// SetKmsMasterKeyId sets the KmsMasterKeyId field's value.
func (s *AwsDynamoDbTableReplica) SetKmsMasterKeyId(v string) *AwsDynamoDbTableReplica {
	s.KmsMasterKeyId = &v
	return s
}

// SetProvisionedThroughputOverride sets the ProvisionedThroughputOverride field's value.
func (s *AwsDynamoDbTableReplica) SetProvisionedThroughputOverride(v *AwsDynamoDbTableProvisionedThroughputOverride) *AwsDynamoDbTableReplica {
	s.ProvisionedThroughputOverride = v
	return s
}

// SetRegionName sets the RegionName field's value.
func (s *AwsDynamoDbTableReplica) SetRegionName(v string) *AwsDynamoDbTableReplica {
	s.RegionName = &v
	return s
}

// SetReplicaStatus sets the ReplicaStatus field's value.
func (s *AwsDynamoDbTableReplica) SetReplicaStatus(v string) *AwsDynamoDbTableReplica {
	s.ReplicaStatus = &v
	return s
}

// SetReplicaStatusDescription sets the ReplicaStatusDescription field's value.
func (s *AwsDynamoDbTableReplica) SetReplicaStatusDescription(v string) *AwsDynamoDbTableReplica {
	s.ReplicaStatusDescription = &v
	return s
}

// Information about a global secondary index for a DynamoDB table replica.
type AwsDynamoDbTableReplicaGlobalSecondaryIndex struct {
	_ struct{} `type:"structure"`

	// The name of the index.
	IndexName *string `type:"string"`

	// Replica-specific configuration for the provisioned throughput for the index.
	ProvisionedThroughputOverride *AwsDynamoDbTableProvisionedThroughputOverride `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableReplicaGlobalSecondaryIndex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableReplicaGlobalSecondaryIndex) GoString() string {
	return s.String()
}

// SetIndexName sets the IndexName field's value.
func (s *AwsDynamoDbTableReplicaGlobalSecondaryIndex) SetIndexName(v string) *AwsDynamoDbTableReplicaGlobalSecondaryIndex {
	s.IndexName = &v
	return s
}

// SetProvisionedThroughputOverride sets the ProvisionedThroughputOverride field's value.
func (s *AwsDynamoDbTableReplicaGlobalSecondaryIndex) SetProvisionedThroughputOverride(v *AwsDynamoDbTableProvisionedThroughputOverride) *AwsDynamoDbTableReplicaGlobalSecondaryIndex {
	s.ProvisionedThroughputOverride = v
	return s
}

// Information about the restore for the table.
type AwsDynamoDbTableRestoreSummary struct {
	_ struct{} `type:"structure"`

	// Indicates the point in time that the table was restored to.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	RestoreDateTime *string `type:"string"`

	// Whether a restore is currently in progress.
	RestoreInProgress *bool `type:"boolean"`

	// The ARN of the source backup from which the table was restored.
	SourceBackupArn *string `type:"string"`

	// The ARN of the source table for the backup.
	SourceTableArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableRestoreSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableRestoreSummary) GoString() string {
	return s.String()
}

// SetRestoreDateTime sets the RestoreDateTime field's value.
func (s *AwsDynamoDbTableRestoreSummary) SetRestoreDateTime(v string) *AwsDynamoDbTableRestoreSummary {
	s.RestoreDateTime = &v
	return s
}

// SetRestoreInProgress sets the RestoreInProgress field's value.
func (s *AwsDynamoDbTableRestoreSummary) SetRestoreInProgress(v bool) *AwsDynamoDbTableRestoreSummary {
	s.RestoreInProgress = &v
	return s
}

// SetSourceBackupArn sets the SourceBackupArn field's value.
func (s *AwsDynamoDbTableRestoreSummary) SetSourceBackupArn(v string) *AwsDynamoDbTableRestoreSummary {
	s.SourceBackupArn = &v
	return s
}

// SetSourceTableArn sets the SourceTableArn field's value.
func (s *AwsDynamoDbTableRestoreSummary) SetSourceTableArn(v string) *AwsDynamoDbTableRestoreSummary {
	s.SourceTableArn = &v
	return s
}

// Information about the server-side encryption for the table.
type AwsDynamoDbTableSseDescription struct {
	_ struct{} `type:"structure"`

	// If the key is inaccessible, the date and time when DynamoDB detected that
	// the key was inaccessible.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	InaccessibleEncryptionDateTime *string `type:"string"`

	// The ARN of the KMS key that is used for the KMS encryption.
	KmsMasterKeyArn *string `type:"string"`

	// The type of server-side encryption.
	SseType *string `type:"string"`

	// The status of the server-side encryption.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableSseDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableSseDescription) GoString() string {
	return s.String()
}

// SetInaccessibleEncryptionDateTime sets the InaccessibleEncryptionDateTime field's value.
func (s *AwsDynamoDbTableSseDescription) SetInaccessibleEncryptionDateTime(v string) *AwsDynamoDbTableSseDescription {
	s.InaccessibleEncryptionDateTime = &v
	return s
}

// SetKmsMasterKeyArn sets the KmsMasterKeyArn field's value.
func (s *AwsDynamoDbTableSseDescription) SetKmsMasterKeyArn(v string) *AwsDynamoDbTableSseDescription {
	s.KmsMasterKeyArn = &v
	return s
}

// SetSseType sets the SseType field's value.
func (s *AwsDynamoDbTableSseDescription) SetSseType(v string) *AwsDynamoDbTableSseDescription {
	s.SseType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsDynamoDbTableSseDescription) SetStatus(v string) *AwsDynamoDbTableSseDescription {
	s.Status = &v
	return s
}

// The current DynamoDB Streams configuration for the table.
type AwsDynamoDbTableStreamSpecification struct {
	_ struct{} `type:"structure"`

	// Indicates whether DynamoDB Streams is enabled on the table.
	StreamEnabled *bool `type:"boolean"`

	// Determines the information that is written to the table.
	StreamViewType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableStreamSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsDynamoDbTableStreamSpecification) GoString() string {
	return s.String()
}

// SetStreamEnabled sets the StreamEnabled field's value.
func (s *AwsDynamoDbTableStreamSpecification) SetStreamEnabled(v bool) *AwsDynamoDbTableStreamSpecification {
	s.StreamEnabled = &v
	return s
}

// SetStreamViewType sets the StreamViewType field's value.
func (s *AwsDynamoDbTableStreamSpecification) SetStreamViewType(v string) *AwsDynamoDbTableStreamSpecification {
	s.StreamViewType = &v
	return s
}

// Information about an Elastic IP address.
type AwsEc2EipDetails struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Web Services assigns to represent the allocation
	// of the Elastic IP address for use with Amazon VPC.
	AllocationId *string `type:"string"`

	// The identifier that represents the association of the Elastic IP address
	// with an EC2 instance.
	AssociationId *string `type:"string"`

	// The domain in which to allocate the address.
	//
	// If the address is for use with EC2 instances in a VPC, then Domain is vpc.
	// Otherwise, Domain is standard.
	Domain *string `type:"string"`

	// The identifier of the EC2 instance.
	InstanceId *string `type:"string"`

	// The name of the location from which the Elastic IP address is advertised.
	NetworkBorderGroup *string `type:"string"`

	// The identifier of the network interface.
	NetworkInterfaceId *string `type:"string"`

	// The Amazon Web Services account ID of the owner of the network interface.
	NetworkInterfaceOwnerId *string `type:"string"`

	// The private IP address that is associated with the Elastic IP address.
	PrivateIpAddress *string `type:"string"`

	// A public IP address that is associated with the EC2 instance.
	PublicIp *string `type:"string"`

	// The identifier of an IP address pool. This parameter allows Amazon EC2 to
	// select an IP address from the address pool.
	PublicIpv4Pool *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2EipDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2EipDetails) GoString() string {
	return s.String()
}

// SetAllocationId sets the AllocationId field's value.
func (s *AwsEc2EipDetails) SetAllocationId(v string) *AwsEc2EipDetails {
	s.AllocationId = &v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *AwsEc2EipDetails) SetAssociationId(v string) *AwsEc2EipDetails {
	s.AssociationId = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *AwsEc2EipDetails) SetDomain(v string) *AwsEc2EipDetails {
	s.Domain = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AwsEc2EipDetails) SetInstanceId(v string) *AwsEc2EipDetails {
	s.InstanceId = &v
	return s
}

// SetNetworkBorderGroup sets the NetworkBorderGroup field's value.
func (s *AwsEc2EipDetails) SetNetworkBorderGroup(v string) *AwsEc2EipDetails {
	s.NetworkBorderGroup = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *AwsEc2EipDetails) SetNetworkInterfaceId(v string) *AwsEc2EipDetails {
	s.NetworkInterfaceId = &v
	return s
}

// SetNetworkInterfaceOwnerId sets the NetworkInterfaceOwnerId field's value.
func (s *AwsEc2EipDetails) SetNetworkInterfaceOwnerId(v string) *AwsEc2EipDetails {
	s.NetworkInterfaceOwnerId = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *AwsEc2EipDetails) SetPrivateIpAddress(v string) *AwsEc2EipDetails {
	s.PrivateIpAddress = &v
	return s
}

// SetPublicIp sets the PublicIp field's value.
func (s *AwsEc2EipDetails) SetPublicIp(v string) *AwsEc2EipDetails {
	s.PublicIp = &v
	return s
}

// SetPublicIpv4Pool sets the PublicIpv4Pool field's value.
func (s *AwsEc2EipDetails) SetPublicIpv4Pool(v string) *AwsEc2EipDetails {
	s.PublicIpv4Pool = &v
	return s
}

// The details of an EC2 instance.
type AwsEc2InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The IAM profile ARN of the instance.
	IamInstanceProfileArn *string `type:"string"`

	// The Amazon Machine Image (AMI) ID of the instance.
	ImageId *string `type:"string"`

	// The IPv4 addresses associated with the instance.
	IpV4Addresses []*string `type:"list"`

	// The IPv6 addresses associated with the instance.
	IpV6Addresses []*string `type:"list"`

	// The key name associated with the instance.
	KeyName *string `type:"string"`

	// Indicates when the instance was launched.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LaunchedAt *string `type:"string"`

	// The identifiers of the network interfaces for the EC2 instance. The details
	// for each network interface are in a corresponding AwsEc2NetworkInterfacesDetails
	// object.
	NetworkInterfaces []*AwsEc2InstanceNetworkInterfacesDetails `type:"list"`

	// The identifier of the subnet that the instance was launched in.
	SubnetId *string `type:"string"`

	// The instance type of the instance.
	Type *string `type:"string"`

	// The identifier of the VPC that the instance was launched in.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2InstanceDetails) GoString() string {
	return s.String()
}

// SetIamInstanceProfileArn sets the IamInstanceProfileArn field's value.
func (s *AwsEc2InstanceDetails) SetIamInstanceProfileArn(v string) *AwsEc2InstanceDetails {
	s.IamInstanceProfileArn = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *AwsEc2InstanceDetails) SetImageId(v string) *AwsEc2InstanceDetails {
	s.ImageId = &v
	return s
}

// SetIpV4Addresses sets the IpV4Addresses field's value.
func (s *AwsEc2InstanceDetails) SetIpV4Addresses(v []*string) *AwsEc2InstanceDetails {
	s.IpV4Addresses = v
	return s
}

// SetIpV6Addresses sets the IpV6Addresses field's value.
func (s *AwsEc2InstanceDetails) SetIpV6Addresses(v []*string) *AwsEc2InstanceDetails {
	s.IpV6Addresses = v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *AwsEc2InstanceDetails) SetKeyName(v string) *AwsEc2InstanceDetails {
	s.KeyName = &v
	return s
}

// SetLaunchedAt sets the LaunchedAt field's value.
func (s *AwsEc2InstanceDetails) SetLaunchedAt(v string) *AwsEc2InstanceDetails {
	s.LaunchedAt = &v
	return s
}

// SetNetworkInterfaces sets the NetworkInterfaces field's value.
func (s *AwsEc2InstanceDetails) SetNetworkInterfaces(v []*AwsEc2InstanceNetworkInterfacesDetails) *AwsEc2InstanceDetails {
	s.NetworkInterfaces = v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *AwsEc2InstanceDetails) SetSubnetId(v string) *AwsEc2InstanceDetails {
	s.SubnetId = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsEc2InstanceDetails) SetType(v string) *AwsEc2InstanceDetails {
	s.Type = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2InstanceDetails) SetVpcId(v string) *AwsEc2InstanceDetails {
	s.VpcId = &v
	return s
}

// Identifies a network interface for the EC2 instance.
type AwsEc2InstanceNetworkInterfacesDetails struct {
	_ struct{} `type:"structure"`

	// The identifier of the network interface. The details are in a corresponding
	// AwsEc2NetworkInterfacesDetails object.
	NetworkInterfaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2InstanceNetworkInterfacesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2InstanceNetworkInterfacesDetails) GoString() string {
	return s.String()
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *AwsEc2InstanceNetworkInterfacesDetails) SetNetworkInterfaceId(v string) *AwsEc2InstanceNetworkInterfacesDetails {
	s.NetworkInterfaceId = &v
	return s
}

// An association between the network ACL and a subnet.
type AwsEc2NetworkAclAssociation struct {
	_ struct{} `type:"structure"`

	// The identifier of the association between the network ACL and the subnet.
	NetworkAclAssociationId *string `type:"string"`

	// The identifier of the network ACL.
	NetworkAclId *string `type:"string"`

	// The identifier of the subnet that is associated with the network ACL.
	SubnetId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkAclAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkAclAssociation) GoString() string {
	return s.String()
}

// SetNetworkAclAssociationId sets the NetworkAclAssociationId field's value.
func (s *AwsEc2NetworkAclAssociation) SetNetworkAclAssociationId(v string) *AwsEc2NetworkAclAssociation {
	s.NetworkAclAssociationId = &v
	return s
}

// SetNetworkAclId sets the NetworkAclId field's value.
func (s *AwsEc2NetworkAclAssociation) SetNetworkAclId(v string) *AwsEc2NetworkAclAssociation {
	s.NetworkAclId = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *AwsEc2NetworkAclAssociation) SetSubnetId(v string) *AwsEc2NetworkAclAssociation {
	s.SubnetId = &v
	return s
}

// Contains details about an EC2 network access control list (ACL).
type AwsEc2NetworkAclDetails struct {
	_ struct{} `type:"structure"`

	// Associations between the network ACL and subnets.
	Associations []*AwsEc2NetworkAclAssociation `type:"list"`

	// The set of rules in the network ACL.
	Entries []*AwsEc2NetworkAclEntry `type:"list"`

	// Whether this is the default network ACL for the VPC.
	IsDefault *bool `type:"boolean"`

	// The identifier of the network ACL.
	NetworkAclId *string `type:"string"`

	// The identifier of the Amazon Web Services account that owns the network ACL.
	OwnerId *string `type:"string"`

	// The identifier of the VPC for the network ACL.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkAclDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkAclDetails) GoString() string {
	return s.String()
}

// SetAssociations sets the Associations field's value.
func (s *AwsEc2NetworkAclDetails) SetAssociations(v []*AwsEc2NetworkAclAssociation) *AwsEc2NetworkAclDetails {
	s.Associations = v
	return s
}

// SetEntries sets the Entries field's value.
func (s *AwsEc2NetworkAclDetails) SetEntries(v []*AwsEc2NetworkAclEntry) *AwsEc2NetworkAclDetails {
	s.Entries = v
	return s
}

// SetIsDefault sets the IsDefault field's value.
func (s *AwsEc2NetworkAclDetails) SetIsDefault(v bool) *AwsEc2NetworkAclDetails {
	s.IsDefault = &v
	return s
}

// SetNetworkAclId sets the NetworkAclId field's value.
func (s *AwsEc2NetworkAclDetails) SetNetworkAclId(v string) *AwsEc2NetworkAclDetails {
	s.NetworkAclId = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *AwsEc2NetworkAclDetails) SetOwnerId(v string) *AwsEc2NetworkAclDetails {
	s.OwnerId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2NetworkAclDetails) SetVpcId(v string) *AwsEc2NetworkAclDetails {
	s.VpcId = &v
	return s
}

// A rule for the network ACL. Each rule allows or denies access based on the
// IP address, traffic direction, port, and protocol.
type AwsEc2NetworkAclEntry struct {
	_ struct{} `type:"structure"`

	// The IPV4 network range for which to deny or allow access.
	CidrBlock *string `type:"string"`

	// Whether the rule is an egress rule. An egress rule is a rule that applies
	// to traffic that leaves the subnet.
	Egress *bool `type:"boolean"`

	// The Internet Control Message Protocol (ICMP) type and code for which to deny
	// or allow access.
	IcmpTypeCode *IcmpTypeCode `type:"structure"`

	// The IPV6 network range for which to deny or allow access.
	Ipv6CidrBlock *string `type:"string"`

	// For TCP or UDP protocols, the range of ports that the rule applies to.
	PortRange *PortRangeFromTo `type:"structure"`

	// The protocol that the rule applies to. To deny or allow access to all protocols,
	// use the value -1.
	Protocol *string `type:"string"`

	// Whether the rule is used to allow access or deny access.
	RuleAction *string `type:"string"`

	// The rule number. The rules are processed in order by their number.
	RuleNumber *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkAclEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkAclEntry) GoString() string {
	return s.String()
}

// SetCidrBlock sets the CidrBlock field's value.
func (s *AwsEc2NetworkAclEntry) SetCidrBlock(v string) *AwsEc2NetworkAclEntry {
	s.CidrBlock = &v
	return s
}

// SetEgress sets the Egress field's value.
func (s *AwsEc2NetworkAclEntry) SetEgress(v bool) *AwsEc2NetworkAclEntry {
	s.Egress = &v
	return s
}

// SetIcmpTypeCode sets the IcmpTypeCode field's value.
func (s *AwsEc2NetworkAclEntry) SetIcmpTypeCode(v *IcmpTypeCode) *AwsEc2NetworkAclEntry {
	s.IcmpTypeCode = v
	return s
}

// SetIpv6CidrBlock sets the Ipv6CidrBlock field's value.
func (s *AwsEc2NetworkAclEntry) SetIpv6CidrBlock(v string) *AwsEc2NetworkAclEntry {
	s.Ipv6CidrBlock = &v
	return s
}

// SetPortRange sets the PortRange field's value.
func (s *AwsEc2NetworkAclEntry) SetPortRange(v *PortRangeFromTo) *AwsEc2NetworkAclEntry {
	s.PortRange = v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *AwsEc2NetworkAclEntry) SetProtocol(v string) *AwsEc2NetworkAclEntry {
	s.Protocol = &v
	return s
}

// SetRuleAction sets the RuleAction field's value.
func (s *AwsEc2NetworkAclEntry) SetRuleAction(v string) *AwsEc2NetworkAclEntry {
	s.RuleAction = &v
	return s
}

// SetRuleNumber sets the RuleNumber field's value.
func (s *AwsEc2NetworkAclEntry) SetRuleNumber(v int64) *AwsEc2NetworkAclEntry {
	s.RuleNumber = &v
	return s
}

// Information about the network interface attachment.
type AwsEc2NetworkInterfaceAttachment struct {
	_ struct{} `type:"structure"`

	// Indicates when the attachment initiated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	AttachTime *string `type:"string"`

	// The identifier of the network interface attachment
	AttachmentId *string `type:"string"`

	// Indicates whether the network interface is deleted when the instance is terminated.
	DeleteOnTermination *bool `type:"boolean"`

	// The device index of the network interface attachment on the instance.
	DeviceIndex *int64 `type:"integer"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// The Amazon Web Services account ID of the owner of the instance.
	InstanceOwnerId *string `type:"string"`

	// The attachment state.
	//
	// Valid values: attaching | attached | detaching | detached
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfaceAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfaceAttachment) GoString() string {
	return s.String()
}

// SetAttachTime sets the AttachTime field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetAttachTime(v string) *AwsEc2NetworkInterfaceAttachment {
	s.AttachTime = &v
	return s
}

// SetAttachmentId sets the AttachmentId field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetAttachmentId(v string) *AwsEc2NetworkInterfaceAttachment {
	s.AttachmentId = &v
	return s
}

// SetDeleteOnTermination sets the DeleteOnTermination field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetDeleteOnTermination(v bool) *AwsEc2NetworkInterfaceAttachment {
	s.DeleteOnTermination = &v
	return s
}

// SetDeviceIndex sets the DeviceIndex field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetDeviceIndex(v int64) *AwsEc2NetworkInterfaceAttachment {
	s.DeviceIndex = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetInstanceId(v string) *AwsEc2NetworkInterfaceAttachment {
	s.InstanceId = &v
	return s
}

// SetInstanceOwnerId sets the InstanceOwnerId field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetInstanceOwnerId(v string) *AwsEc2NetworkInterfaceAttachment {
	s.InstanceOwnerId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetStatus(v string) *AwsEc2NetworkInterfaceAttachment {
	s.Status = &v
	return s
}

// Details about the network interface
type AwsEc2NetworkInterfaceDetails struct {
	_ struct{} `type:"structure"`

	// The network interface attachment.
	Attachment *AwsEc2NetworkInterfaceAttachment `type:"structure"`

	// The IPv6 addresses associated with the network interface.
	IpV6Addresses []*AwsEc2NetworkInterfaceIpV6AddressDetail `type:"list"`

	// The ID of the network interface.
	NetworkInterfaceId *string `type:"string"`

	// The private IPv4 addresses associated with the network interface.
	PrivateIpAddresses []*AwsEc2NetworkInterfacePrivateIpAddressDetail `type:"list"`

	// The public DNS name of the network interface.
	PublicDnsName *string `type:"string"`

	// The address of the Elastic IP address bound to the network interface.
	PublicIp *string `type:"string"`

	// Security groups for the network interface.
	SecurityGroups []*AwsEc2NetworkInterfaceSecurityGroup `type:"list"`

	// Indicates whether traffic to or from the instance is validated.
	SourceDestCheck *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfaceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfaceDetails) GoString() string {
	return s.String()
}

// SetAttachment sets the Attachment field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetAttachment(v *AwsEc2NetworkInterfaceAttachment) *AwsEc2NetworkInterfaceDetails {
	s.Attachment = v
	return s
}

// SetIpV6Addresses sets the IpV6Addresses field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetIpV6Addresses(v []*AwsEc2NetworkInterfaceIpV6AddressDetail) *AwsEc2NetworkInterfaceDetails {
	s.IpV6Addresses = v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetNetworkInterfaceId(v string) *AwsEc2NetworkInterfaceDetails {
	s.NetworkInterfaceId = &v
	return s
}

// SetPrivateIpAddresses sets the PrivateIpAddresses field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetPrivateIpAddresses(v []*AwsEc2NetworkInterfacePrivateIpAddressDetail) *AwsEc2NetworkInterfaceDetails {
	s.PrivateIpAddresses = v
	return s
}

// SetPublicDnsName sets the PublicDnsName field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetPublicDnsName(v string) *AwsEc2NetworkInterfaceDetails {
	s.PublicDnsName = &v
	return s
}

// SetPublicIp sets the PublicIp field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetPublicIp(v string) *AwsEc2NetworkInterfaceDetails {
	s.PublicIp = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetSecurityGroups(v []*AwsEc2NetworkInterfaceSecurityGroup) *AwsEc2NetworkInterfaceDetails {
	s.SecurityGroups = v
	return s
}

// SetSourceDestCheck sets the SourceDestCheck field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetSourceDestCheck(v bool) *AwsEc2NetworkInterfaceDetails {
	s.SourceDestCheck = &v
	return s
}

// Provides information about an IPV6 address that is associated with the network
// interface.
type AwsEc2NetworkInterfaceIpV6AddressDetail struct {
	_ struct{} `type:"structure"`

	// The IPV6 address.
	IpV6Address *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfaceIpV6AddressDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfaceIpV6AddressDetail) GoString() string {
	return s.String()
}

// SetIpV6Address sets the IpV6Address field's value.
func (s *AwsEc2NetworkInterfaceIpV6AddressDetail) SetIpV6Address(v string) *AwsEc2NetworkInterfaceIpV6AddressDetail {
	s.IpV6Address = &v
	return s
}

// Provides information about a private IPv4 address that is with the network
// interface.
type AwsEc2NetworkInterfacePrivateIpAddressDetail struct {
	_ struct{} `type:"structure"`

	// The private DNS name for the IP address.
	PrivateDnsName *string `type:"string"`

	// The IP address.
	PrivateIpAddress *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfacePrivateIpAddressDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfacePrivateIpAddressDetail) GoString() string {
	return s.String()
}

// SetPrivateDnsName sets the PrivateDnsName field's value.
func (s *AwsEc2NetworkInterfacePrivateIpAddressDetail) SetPrivateDnsName(v string) *AwsEc2NetworkInterfacePrivateIpAddressDetail {
	s.PrivateDnsName = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *AwsEc2NetworkInterfacePrivateIpAddressDetail) SetPrivateIpAddress(v string) *AwsEc2NetworkInterfacePrivateIpAddressDetail {
	s.PrivateIpAddress = &v
	return s
}

// A security group associated with the network interface.
type AwsEc2NetworkInterfaceSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `type:"string"`

	// The name of the security group.
	GroupName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfaceSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2NetworkInterfaceSecurityGroup) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *AwsEc2NetworkInterfaceSecurityGroup) SetGroupId(v string) *AwsEc2NetworkInterfaceSecurityGroup {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AwsEc2NetworkInterfaceSecurityGroup) SetGroupName(v string) *AwsEc2NetworkInterfaceSecurityGroup {
	s.GroupName = &v
	return s
}

// Details about an EC2 security group.
type AwsEc2SecurityGroupDetails struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `type:"string"`

	// The name of the security group.
	GroupName *string `type:"string"`

	// The inbound rules associated with the security group.
	IpPermissions []*AwsEc2SecurityGroupIpPermission `type:"list"`

	// [VPC only] The outbound rules associated with the security group.
	IpPermissionsEgress []*AwsEc2SecurityGroupIpPermission `type:"list"`

	// The Amazon Web Services account ID of the owner of the security group.
	OwnerId *string `type:"string"`

	// [VPC only] The ID of the VPC for the security group.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupDetails) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *AwsEc2SecurityGroupDetails) SetGroupId(v string) *AwsEc2SecurityGroupDetails {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AwsEc2SecurityGroupDetails) SetGroupName(v string) *AwsEc2SecurityGroupDetails {
	s.GroupName = &v
	return s
}

// SetIpPermissions sets the IpPermissions field's value.
func (s *AwsEc2SecurityGroupDetails) SetIpPermissions(v []*AwsEc2SecurityGroupIpPermission) *AwsEc2SecurityGroupDetails {
	s.IpPermissions = v
	return s
}

// SetIpPermissionsEgress sets the IpPermissionsEgress field's value.
func (s *AwsEc2SecurityGroupDetails) SetIpPermissionsEgress(v []*AwsEc2SecurityGroupIpPermission) *AwsEc2SecurityGroupDetails {
	s.IpPermissionsEgress = v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *AwsEc2SecurityGroupDetails) SetOwnerId(v string) *AwsEc2SecurityGroupDetails {
	s.OwnerId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2SecurityGroupDetails) SetVpcId(v string) *AwsEc2SecurityGroupDetails {
	s.VpcId = &v
	return s
}

// An IP permission for an EC2 security group.
type AwsEc2SecurityGroupIpPermission struct {
	_ struct{} `type:"structure"`

	// The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// type number.
	//
	// A value of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6
	// types, you must specify all codes.
	FromPort *int64 `type:"integer"`

	// The IP protocol name (tcp, udp, icmp, icmpv6) or number.
	//
	// [VPC only] Use -1 to specify all protocols.
	//
	// When authorizing security group rules, specifying -1 or a protocol number
	// other than tcp, udp, icmp, or icmpv6 allows traffic on all ports, regardless
	// of any port range you specify.
	//
	// For tcp, udp, and icmp, you must specify a port range.
	//
	// For icmpv6, the port range is optional. If you omit the port range, traffic
	// for all types and codes is allowed.
	IpProtocol *string `type:"string"`

	// The IPv4 ranges.
	IpRanges []*AwsEc2SecurityGroupIpRange `type:"list"`

	// The IPv6 ranges.
	Ipv6Ranges []*AwsEc2SecurityGroupIpv6Range `type:"list"`

	// [VPC only] The prefix list IDs for an Amazon Web Services service. With outbound
	// rules, this is the Amazon Web Services service to access through a VPC endpoint
	// from instances associated with the security group.
	PrefixListIds []*AwsEc2SecurityGroupPrefixListId `type:"list"`

	// The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// code.
	//
	// A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6
	// types, you must specify all codes.
	ToPort *int64 `type:"integer"`

	// The security group and Amazon Web Services account ID pairs.
	UserIdGroupPairs []*AwsEc2SecurityGroupUserIdGroupPair `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupIpPermission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupIpPermission) GoString() string {
	return s.String()
}

// SetFromPort sets the FromPort field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetFromPort(v int64) *AwsEc2SecurityGroupIpPermission {
	s.FromPort = &v
	return s
}

// SetIpProtocol sets the IpProtocol field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetIpProtocol(v string) *AwsEc2SecurityGroupIpPermission {
	s.IpProtocol = &v
	return s
}

// SetIpRanges sets the IpRanges field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetIpRanges(v []*AwsEc2SecurityGroupIpRange) *AwsEc2SecurityGroupIpPermission {
	s.IpRanges = v
	return s
}

// SetIpv6Ranges sets the Ipv6Ranges field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetIpv6Ranges(v []*AwsEc2SecurityGroupIpv6Range) *AwsEc2SecurityGroupIpPermission {
	s.Ipv6Ranges = v
	return s
}

// SetPrefixListIds sets the PrefixListIds field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetPrefixListIds(v []*AwsEc2SecurityGroupPrefixListId) *AwsEc2SecurityGroupIpPermission {
	s.PrefixListIds = v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetToPort(v int64) *AwsEc2SecurityGroupIpPermission {
	s.ToPort = &v
	return s
}

// SetUserIdGroupPairs sets the UserIdGroupPairs field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetUserIdGroupPairs(v []*AwsEc2SecurityGroupUserIdGroupPair) *AwsEc2SecurityGroupIpPermission {
	s.UserIdGroupPairs = v
	return s
}

// A range of IPv4 addresses.
type AwsEc2SecurityGroupIpRange struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR range. You can specify either a CIDR range or a source security
	// group, but not both. To specify a single IPv4 address, use the /32 prefix
	// length.
	CidrIp *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupIpRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupIpRange) GoString() string {
	return s.String()
}

// SetCidrIp sets the CidrIp field's value.
func (s *AwsEc2SecurityGroupIpRange) SetCidrIp(v string) *AwsEc2SecurityGroupIpRange {
	s.CidrIp = &v
	return s
}

// A range of IPv6 addresses.
type AwsEc2SecurityGroupIpv6Range struct {
	_ struct{} `type:"structure"`

	// The IPv6 CIDR range. You can specify either a CIDR range or a source security
	// group, but not both. To specify a single IPv6 address, use the /128 prefix
	// length.
	CidrIpv6 *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupIpv6Range) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupIpv6Range) GoString() string {
	return s.String()
}

// SetCidrIpv6 sets the CidrIpv6 field's value.
func (s *AwsEc2SecurityGroupIpv6Range) SetCidrIpv6(v string) *AwsEc2SecurityGroupIpv6Range {
	s.CidrIpv6 = &v
	return s
}

// A prefix list ID.
type AwsEc2SecurityGroupPrefixListId struct {
	_ struct{} `type:"structure"`

	// The ID of the prefix.
	PrefixListId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupPrefixListId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupPrefixListId) GoString() string {
	return s.String()
}

// SetPrefixListId sets the PrefixListId field's value.
func (s *AwsEc2SecurityGroupPrefixListId) SetPrefixListId(v string) *AwsEc2SecurityGroupPrefixListId {
	s.PrefixListId = &v
	return s
}

// A relationship between a security group and a user.
type AwsEc2SecurityGroupUserIdGroupPair struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `type:"string"`

	// The name of the security group.
	GroupName *string `type:"string"`

	// The status of a VPC peering connection, if applicable.
	PeeringStatus *string `type:"string"`

	// The ID of an Amazon Web Services account.
	//
	// For a referenced security group in another VPC, the account ID of the referenced
	// security group is returned in the response. If the referenced security group
	// is deleted, this value is not returned.
	//
	// [EC2-Classic] Required when adding or removing rules that reference a security
	// group in another VPC.
	UserId *string `type:"string"`

	// The ID of the VPC for the referenced security group, if applicable.
	VpcId *string `type:"string"`

	// The ID of the VPC peering connection, if applicable.
	VpcPeeringConnectionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupUserIdGroupPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SecurityGroupUserIdGroupPair) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetGroupId(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetGroupName(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.GroupName = &v
	return s
}

// SetPeeringStatus sets the PeeringStatus field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetPeeringStatus(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.PeeringStatus = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetUserId(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.UserId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetVpcId(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.VpcId = &v
	return s
}

// SetVpcPeeringConnectionId sets the VpcPeeringConnectionId field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetVpcPeeringConnectionId(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.VpcPeeringConnectionId = &v
	return s
}

// Contains information about a subnet in Amazon EC2.
type AwsEc2SubnetDetails struct {
	_ struct{} `type:"structure"`

	// Whether to assign an IPV6 address to a network interface that is created
	// in this subnet.
	AssignIpv6AddressOnCreation *bool `type:"boolean"`

	// The Availability Zone for the subnet.
	AvailabilityZone *string `type:"string"`

	// The identifier of the Availability Zone for the subnet.
	AvailabilityZoneId *string `type:"string"`

	// The number of available IPV4 addresses in the subnet. Does not include addresses
	// for stopped instances.
	AvailableIpAddressCount *int64 `type:"integer"`

	// The IPV4 CIDR block that is assigned to the subnet.
	CidrBlock *string `type:"string"`

	// Whether this subnet is the default subnet for the Availability Zone.
	DefaultForAz *bool `type:"boolean"`

	// The IPV6 CIDR blocks that are associated with the subnet.
	Ipv6CidrBlockAssociationSet []*Ipv6CidrBlockAssociation `type:"list"`

	// Whether instances in this subnet receive a public IP address.
	MapPublicIpOnLaunch *bool `type:"boolean"`

	// The identifier of the Amazon Web Services account that owns the subnet.
	OwnerId *string `type:"string"`

	// The current state of the subnet.
	State *string `type:"string"`

	// The ARN of the subnet.
	SubnetArn *string `type:"string"`

	// The identifier of the subnet.
	SubnetId *string `type:"string"`

	// The identifier of the VPC that contains the subnet.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SubnetDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2SubnetDetails) GoString() string {
	return s.String()
}

// SetAssignIpv6AddressOnCreation sets the AssignIpv6AddressOnCreation field's value.
func (s *AwsEc2SubnetDetails) SetAssignIpv6AddressOnCreation(v bool) *AwsEc2SubnetDetails {
	s.AssignIpv6AddressOnCreation = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *AwsEc2SubnetDetails) SetAvailabilityZone(v string) *AwsEc2SubnetDetails {
	s.AvailabilityZone = &v
	return s
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *AwsEc2SubnetDetails) SetAvailabilityZoneId(v string) *AwsEc2SubnetDetails {
	s.AvailabilityZoneId = &v
	return s
}

// SetAvailableIpAddressCount sets the AvailableIpAddressCount field's value.
func (s *AwsEc2SubnetDetails) SetAvailableIpAddressCount(v int64) *AwsEc2SubnetDetails {
	s.AvailableIpAddressCount = &v
	return s
}

// SetCidrBlock sets the CidrBlock field's value.
func (s *AwsEc2SubnetDetails) SetCidrBlock(v string) *AwsEc2SubnetDetails {
	s.CidrBlock = &v
	return s
}

// SetDefaultForAz sets the DefaultForAz field's value.
func (s *AwsEc2SubnetDetails) SetDefaultForAz(v bool) *AwsEc2SubnetDetails {
	s.DefaultForAz = &v
	return s
}

// SetIpv6CidrBlockAssociationSet sets the Ipv6CidrBlockAssociationSet field's value.
func (s *AwsEc2SubnetDetails) SetIpv6CidrBlockAssociationSet(v []*Ipv6CidrBlockAssociation) *AwsEc2SubnetDetails {
	s.Ipv6CidrBlockAssociationSet = v
	return s
}

// SetMapPublicIpOnLaunch sets the MapPublicIpOnLaunch field's value.
func (s *AwsEc2SubnetDetails) SetMapPublicIpOnLaunch(v bool) *AwsEc2SubnetDetails {
	s.MapPublicIpOnLaunch = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *AwsEc2SubnetDetails) SetOwnerId(v string) *AwsEc2SubnetDetails {
	s.OwnerId = &v
	return s
}

// SetState sets the State field's value.
func (s *AwsEc2SubnetDetails) SetState(v string) *AwsEc2SubnetDetails {
	s.State = &v
	return s
}

// SetSubnetArn sets the SubnetArn field's value.
func (s *AwsEc2SubnetDetails) SetSubnetArn(v string) *AwsEc2SubnetDetails {
	s.SubnetArn = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *AwsEc2SubnetDetails) SetSubnetId(v string) *AwsEc2SubnetDetails {
	s.SubnetId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2SubnetDetails) SetVpcId(v string) *AwsEc2SubnetDetails {
	s.VpcId = &v
	return s
}

// An attachment to an Amazon EC2 volume.
type AwsEc2VolumeAttachment struct {
	_ struct{} `type:"structure"`

	// The datetime when the attachment initiated.
	AttachTime *string `type:"string"`

	// Whether the EBS volume is deleted when the EC2 instance is terminated.
	DeleteOnTermination *bool `type:"boolean"`

	// The identifier of the EC2 instance.
	InstanceId *string `type:"string"`

	// The attachment state of the volume.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VolumeAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VolumeAttachment) GoString() string {
	return s.String()
}

// SetAttachTime sets the AttachTime field's value.
func (s *AwsEc2VolumeAttachment) SetAttachTime(v string) *AwsEc2VolumeAttachment {
	s.AttachTime = &v
	return s
}

// SetDeleteOnTermination sets the DeleteOnTermination field's value.
func (s *AwsEc2VolumeAttachment) SetDeleteOnTermination(v bool) *AwsEc2VolumeAttachment {
	s.DeleteOnTermination = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AwsEc2VolumeAttachment) SetInstanceId(v string) *AwsEc2VolumeAttachment {
	s.InstanceId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsEc2VolumeAttachment) SetStatus(v string) *AwsEc2VolumeAttachment {
	s.Status = &v
	return s
}

// Details about an EC2 volume.
type AwsEc2VolumeDetails struct {
	_ struct{} `type:"structure"`

	// The volume attachments.
	Attachments []*AwsEc2VolumeAttachment `type:"list"`

	// Indicates when the volume was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateTime *string `type:"string"`

	// Whether the volume is encrypted.
	Encrypted *bool `type:"boolean"`

	// The ARN of the KMS key that was used to protect the volume encryption key
	// for the volume.
	KmsKeyId *string `type:"string"`

	// The size of the volume, in GiBs.
	Size *int64 `type:"integer"`

	// The snapshot from which the volume was created.
	SnapshotId *string `type:"string"`

	// The volume state.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VolumeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VolumeDetails) GoString() string {
	return s.String()
}

// SetAttachments sets the Attachments field's value.
func (s *AwsEc2VolumeDetails) SetAttachments(v []*AwsEc2VolumeAttachment) *AwsEc2VolumeDetails {
	s.Attachments = v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *AwsEc2VolumeDetails) SetCreateTime(v string) *AwsEc2VolumeDetails {
	s.CreateTime = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *AwsEc2VolumeDetails) SetEncrypted(v bool) *AwsEc2VolumeDetails {
	s.Encrypted = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsEc2VolumeDetails) SetKmsKeyId(v string) *AwsEc2VolumeDetails {
	s.KmsKeyId = &v
	return s
}

// SetSize sets the Size field's value.
func (s *AwsEc2VolumeDetails) SetSize(v int64) *AwsEc2VolumeDetails {
	s.Size = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *AwsEc2VolumeDetails) SetSnapshotId(v string) *AwsEc2VolumeDetails {
	s.SnapshotId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsEc2VolumeDetails) SetStatus(v string) *AwsEc2VolumeDetails {
	s.Status = &v
	return s
}

// Details about an EC2 VPC.
type AwsEc2VpcDetails struct {
	_ struct{} `type:"structure"`

	// Information about the IPv4 CIDR blocks associated with the VPC.
	CidrBlockAssociationSet []*CidrBlockAssociation `type:"list"`

	// The identifier of the set of Dynamic Host Configuration Protocol (DHCP) options
	// that are associated with the VPC. If the default options are associated with
	// the VPC, then this is default.
	DhcpOptionsId *string `type:"string"`

	// Information about the IPv6 CIDR blocks associated with the VPC.
	Ipv6CidrBlockAssociationSet []*Ipv6CidrBlockAssociation `type:"list"`

	// The current state of the VPC.
	State *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpcDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpcDetails) GoString() string {
	return s.String()
}

// SetCidrBlockAssociationSet sets the CidrBlockAssociationSet field's value.
func (s *AwsEc2VpcDetails) SetCidrBlockAssociationSet(v []*CidrBlockAssociation) *AwsEc2VpcDetails {
	s.CidrBlockAssociationSet = v
	return s
}

// SetDhcpOptionsId sets the DhcpOptionsId field's value.
func (s *AwsEc2VpcDetails) SetDhcpOptionsId(v string) *AwsEc2VpcDetails {
	s.DhcpOptionsId = &v
	return s
}

// SetIpv6CidrBlockAssociationSet sets the Ipv6CidrBlockAssociationSet field's value.
func (s *AwsEc2VpcDetails) SetIpv6CidrBlockAssociationSet(v []*Ipv6CidrBlockAssociation) *AwsEc2VpcDetails {
	s.Ipv6CidrBlockAssociationSet = v
	return s
}

// SetState sets the State field's value.
func (s *AwsEc2VpcDetails) SetState(v string) *AwsEc2VpcDetails {
	s.State = &v
	return s
}

// Contains details about the service configuration for a VPC endpoint service.
type AwsEc2VpcEndpointServiceDetails struct {
	_ struct{} `type:"structure"`

	// Whether requests from other Amazon Web Services accounts to create an endpoint
	// to the service must first be accepted.
	AcceptanceRequired *bool `type:"boolean"`

	// The Availability Zones where the service is available.
	AvailabilityZones []*string `type:"list"`

	// The DNS names for the service.
	BaseEndpointDnsNames []*string `type:"list"`

	// The ARNs of the Gateway Load Balancers for the service.
	GatewayLoadBalancerArns []*string `type:"list"`

	// Whether the service manages its VPC endpoints.
	ManagesVpcEndpoints *bool `type:"boolean"`

	// The ARNs of the Network Load Balancers for the service.
	NetworkLoadBalancerArns []*string `type:"list"`

	// The private DNS name for the service.
	PrivateDnsName *string `type:"string"`

	// The identifier of the service.
	ServiceId *string `type:"string"`

	// The name of the service.
	ServiceName *string `type:"string"`

	// The current state of the service.
	ServiceState *string `type:"string"`

	// The types for the service.
	ServiceType []*AwsEc2VpcEndpointServiceServiceTypeDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpcEndpointServiceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpcEndpointServiceDetails) GoString() string {
	return s.String()
}

// SetAcceptanceRequired sets the AcceptanceRequired field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetAcceptanceRequired(v bool) *AwsEc2VpcEndpointServiceDetails {
	s.AcceptanceRequired = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetAvailabilityZones(v []*string) *AwsEc2VpcEndpointServiceDetails {
	s.AvailabilityZones = v
	return s
}

// SetBaseEndpointDnsNames sets the BaseEndpointDnsNames field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetBaseEndpointDnsNames(v []*string) *AwsEc2VpcEndpointServiceDetails {
	s.BaseEndpointDnsNames = v
	return s
}

// SetGatewayLoadBalancerArns sets the GatewayLoadBalancerArns field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetGatewayLoadBalancerArns(v []*string) *AwsEc2VpcEndpointServiceDetails {
	s.GatewayLoadBalancerArns = v
	return s
}

// SetManagesVpcEndpoints sets the ManagesVpcEndpoints field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetManagesVpcEndpoints(v bool) *AwsEc2VpcEndpointServiceDetails {
	s.ManagesVpcEndpoints = &v
	return s
}

// SetNetworkLoadBalancerArns sets the NetworkLoadBalancerArns field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetNetworkLoadBalancerArns(v []*string) *AwsEc2VpcEndpointServiceDetails {
	s.NetworkLoadBalancerArns = v
	return s
}

// SetPrivateDnsName sets the PrivateDnsName field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetPrivateDnsName(v string) *AwsEc2VpcEndpointServiceDetails {
	s.PrivateDnsName = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetServiceId(v string) *AwsEc2VpcEndpointServiceDetails {
	s.ServiceId = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetServiceName(v string) *AwsEc2VpcEndpointServiceDetails {
	s.ServiceName = &v
	return s
}

// SetServiceState sets the ServiceState field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetServiceState(v string) *AwsEc2VpcEndpointServiceDetails {
	s.ServiceState = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *AwsEc2VpcEndpointServiceDetails) SetServiceType(v []*AwsEc2VpcEndpointServiceServiceTypeDetails) *AwsEc2VpcEndpointServiceDetails {
	s.ServiceType = v
	return s
}

// The service type information for a VPC endpoint service.
type AwsEc2VpcEndpointServiceServiceTypeDetails struct {
	_ struct{} `type:"structure"`

	// The type of service.
	ServiceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpcEndpointServiceServiceTypeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpcEndpointServiceServiceTypeDetails) GoString() string {
	return s.String()
}

// SetServiceType sets the ServiceType field's value.
func (s *AwsEc2VpcEndpointServiceServiceTypeDetails) SetServiceType(v string) *AwsEc2VpcEndpointServiceServiceTypeDetails {
	s.ServiceType = &v
	return s
}

// Details about an Amazon EC2 VPN connection.
type AwsEc2VpnConnectionDetails struct {
	_ struct{} `type:"structure"`

	// The category of the VPN connection. VPN indicates an Amazon Web Services
	// VPN connection. VPN-Classic indicates an Amazon Web Services Classic VPN
	// connection.
	Category *string `type:"string"`

	// The configuration information for the VPN connection's customer gateway,
	// in the native XML format.
	CustomerGatewayConfiguration *string `type:"string"`

	// The identifier of the customer gateway that is at your end of the VPN connection.
	CustomerGatewayId *string `type:"string"`

	// The VPN connection options.
	Options *AwsEc2VpnConnectionOptionsDetails `type:"structure"`

	// The static routes that are associated with the VPN connection.
	Routes []*AwsEc2VpnConnectionRoutesDetails `type:"list"`

	// The current state of the VPN connection.
	State *string `type:"string"`

	// The identifier of the transit gateway that is associated with the VPN connection.
	TransitGatewayId *string `type:"string"`

	// The type of VPN connection.
	Type *string `type:"string"`

	// Information about the VPN tunnel.
	VgwTelemetry []*AwsEc2VpnConnectionVgwTelemetryDetails `type:"list"`

	// The identifier of the VPN connection.
	VpnConnectionId *string `type:"string"`

	// The identifier of the virtual private gateway that is at the Amazon Web Services
	// side of the VPN connection.
	VpnGatewayId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionDetails) GoString() string {
	return s.String()
}

// SetCategory sets the Category field's value.
func (s *AwsEc2VpnConnectionDetails) SetCategory(v string) *AwsEc2VpnConnectionDetails {
	s.Category = &v
	return s
}

// SetCustomerGatewayConfiguration sets the CustomerGatewayConfiguration field's value.
func (s *AwsEc2VpnConnectionDetails) SetCustomerGatewayConfiguration(v string) *AwsEc2VpnConnectionDetails {
	s.CustomerGatewayConfiguration = &v
	return s
}

// SetCustomerGatewayId sets the CustomerGatewayId field's value.
func (s *AwsEc2VpnConnectionDetails) SetCustomerGatewayId(v string) *AwsEc2VpnConnectionDetails {
	s.CustomerGatewayId = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *AwsEc2VpnConnectionDetails) SetOptions(v *AwsEc2VpnConnectionOptionsDetails) *AwsEc2VpnConnectionDetails {
	s.Options = v
	return s
}

// SetRoutes sets the Routes field's value.
func (s *AwsEc2VpnConnectionDetails) SetRoutes(v []*AwsEc2VpnConnectionRoutesDetails) *AwsEc2VpnConnectionDetails {
	s.Routes = v
	return s
}

// SetState sets the State field's value.
func (s *AwsEc2VpnConnectionDetails) SetState(v string) *AwsEc2VpnConnectionDetails {
	s.State = &v
	return s
}

// SetTransitGatewayId sets the TransitGatewayId field's value.
func (s *AwsEc2VpnConnectionDetails) SetTransitGatewayId(v string) *AwsEc2VpnConnectionDetails {
	s.TransitGatewayId = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsEc2VpnConnectionDetails) SetType(v string) *AwsEc2VpnConnectionDetails {
	s.Type = &v
	return s
}

// SetVgwTelemetry sets the VgwTelemetry field's value.
func (s *AwsEc2VpnConnectionDetails) SetVgwTelemetry(v []*AwsEc2VpnConnectionVgwTelemetryDetails) *AwsEc2VpnConnectionDetails {
	s.VgwTelemetry = v
	return s
}

// SetVpnConnectionId sets the VpnConnectionId field's value.
func (s *AwsEc2VpnConnectionDetails) SetVpnConnectionId(v string) *AwsEc2VpnConnectionDetails {
	s.VpnConnectionId = &v
	return s
}

// SetVpnGatewayId sets the VpnGatewayId field's value.
func (s *AwsEc2VpnConnectionDetails) SetVpnGatewayId(v string) *AwsEc2VpnConnectionDetails {
	s.VpnGatewayId = &v
	return s
}

// VPN connection options.
type AwsEc2VpnConnectionOptionsDetails struct {
	_ struct{} `type:"structure"`

	// Whether the VPN connection uses static routes only.
	StaticRoutesOnly *bool `type:"boolean"`

	// The VPN tunnel options.
	TunnelOptions []*AwsEc2VpnConnectionOptionsTunnelOptionsDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionOptionsDetails) GoString() string {
	return s.String()
}

// SetStaticRoutesOnly sets the StaticRoutesOnly field's value.
func (s *AwsEc2VpnConnectionOptionsDetails) SetStaticRoutesOnly(v bool) *AwsEc2VpnConnectionOptionsDetails {
	s.StaticRoutesOnly = &v
	return s
}

// SetTunnelOptions sets the TunnelOptions field's value.
func (s *AwsEc2VpnConnectionOptionsDetails) SetTunnelOptions(v []*AwsEc2VpnConnectionOptionsTunnelOptionsDetails) *AwsEc2VpnConnectionOptionsDetails {
	s.TunnelOptions = v
	return s
}

// The VPN tunnel options.
type AwsEc2VpnConnectionOptionsTunnelOptionsDetails struct {
	_ struct{} `type:"structure"`

	// The number of seconds after which a Dead Peer Detection (DPD) timeout occurs.
	DpdTimeoutSeconds *int64 `type:"integer"`

	// The Internet Key Exchange (IKE) versions that are permitted for the VPN tunnel.
	IkeVersions []*string `type:"list"`

	// The external IP address of the VPN tunnel.
	OutsideIpAddress *string `type:"string"`

	// The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1
	// IKE negotiations.
	Phase1DhGroupNumbers []*int64 `type:"list"`

	// The permitted encryption algorithms for the VPN tunnel for phase 1 IKE negotiations.
	Phase1EncryptionAlgorithms []*string `type:"list"`

	// The permitted integrity algorithms for the VPN tunnel for phase 1 IKE negotiations.
	Phase1IntegrityAlgorithms []*string `type:"list"`

	// The lifetime for phase 1 of the IKE negotiation, in seconds.
	Phase1LifetimeSeconds *int64 `type:"integer"`

	// The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2
	// IKE negotiations.
	Phase2DhGroupNumbers []*int64 `type:"list"`

	// The permitted encryption algorithms for the VPN tunnel for phase 2 IKE negotiations.
	Phase2EncryptionAlgorithms []*string `type:"list"`

	// The permitted integrity algorithms for the VPN tunnel for phase 2 IKE negotiations.
	Phase2IntegrityAlgorithms []*string `type:"list"`

	// The lifetime for phase 2 of the IKE negotiation, in seconds.
	Phase2LifetimeSeconds *int64 `type:"integer"`

	// The preshared key to establish initial authentication between the virtual
	// private gateway and the customer gateway.
	PreSharedKey *string `type:"string"`

	// The percentage of the rekey window, which is determined by RekeyMarginTimeSeconds
	// during which the rekey time is randomly selected.
	RekeyFuzzPercentage *int64 `type:"integer"`

	// The margin time, in seconds, before the phase 2 lifetime expires, during
	// which the Amazon Web Services side of the VPN connection performs an IKE
	// rekey.
	RekeyMarginTimeSeconds *int64 `type:"integer"`

	// The number of packets in an IKE replay window.
	ReplayWindowSize *int64 `type:"integer"`

	// The range of inside IPv4 addresses for the tunnel.
	TunnelInsideCidr *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionOptionsTunnelOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionOptionsTunnelOptionsDetails) GoString() string {
	return s.String()
}

// SetDpdTimeoutSeconds sets the DpdTimeoutSeconds field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetDpdTimeoutSeconds(v int64) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.DpdTimeoutSeconds = &v
	return s
}

// SetIkeVersions sets the IkeVersions field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetIkeVersions(v []*string) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.IkeVersions = v
	return s
}

// SetOutsideIpAddress sets the OutsideIpAddress field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetOutsideIpAddress(v string) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.OutsideIpAddress = &v
	return s
}

// SetPhase1DhGroupNumbers sets the Phase1DhGroupNumbers field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetPhase1DhGroupNumbers(v []*int64) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.Phase1DhGroupNumbers = v
	return s
}

// SetPhase1EncryptionAlgorithms sets the Phase1EncryptionAlgorithms field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetPhase1EncryptionAlgorithms(v []*string) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.Phase1EncryptionAlgorithms = v
	return s
}

// SetPhase1IntegrityAlgorithms sets the Phase1IntegrityAlgorithms field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetPhase1IntegrityAlgorithms(v []*string) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.Phase1IntegrityAlgorithms = v
	return s
}

// SetPhase1LifetimeSeconds sets the Phase1LifetimeSeconds field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetPhase1LifetimeSeconds(v int64) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.Phase1LifetimeSeconds = &v
	return s
}

// SetPhase2DhGroupNumbers sets the Phase2DhGroupNumbers field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetPhase2DhGroupNumbers(v []*int64) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.Phase2DhGroupNumbers = v
	return s
}

// SetPhase2EncryptionAlgorithms sets the Phase2EncryptionAlgorithms field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetPhase2EncryptionAlgorithms(v []*string) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.Phase2EncryptionAlgorithms = v
	return s
}

// SetPhase2IntegrityAlgorithms sets the Phase2IntegrityAlgorithms field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetPhase2IntegrityAlgorithms(v []*string) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.Phase2IntegrityAlgorithms = v
	return s
}

// SetPhase2LifetimeSeconds sets the Phase2LifetimeSeconds field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetPhase2LifetimeSeconds(v int64) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.Phase2LifetimeSeconds = &v
	return s
}

// SetPreSharedKey sets the PreSharedKey field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetPreSharedKey(v string) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.PreSharedKey = &v
	return s
}

// SetRekeyFuzzPercentage sets the RekeyFuzzPercentage field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetRekeyFuzzPercentage(v int64) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.RekeyFuzzPercentage = &v
	return s
}

// SetRekeyMarginTimeSeconds sets the RekeyMarginTimeSeconds field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetRekeyMarginTimeSeconds(v int64) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.RekeyMarginTimeSeconds = &v
	return s
}

// SetReplayWindowSize sets the ReplayWindowSize field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetReplayWindowSize(v int64) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.ReplayWindowSize = &v
	return s
}

// SetTunnelInsideCidr sets the TunnelInsideCidr field's value.
func (s *AwsEc2VpnConnectionOptionsTunnelOptionsDetails) SetTunnelInsideCidr(v string) *AwsEc2VpnConnectionOptionsTunnelOptionsDetails {
	s.TunnelInsideCidr = &v
	return s
}

// A static routes associated with the VPN connection.
type AwsEc2VpnConnectionRoutesDetails struct {
	_ struct{} `type:"structure"`

	// The CIDR block associated with the local subnet of the customer data center.
	DestinationCidrBlock *string `type:"string"`

	// The current state of the static route.
	State *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionRoutesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionRoutesDetails) GoString() string {
	return s.String()
}

// SetDestinationCidrBlock sets the DestinationCidrBlock field's value.
func (s *AwsEc2VpnConnectionRoutesDetails) SetDestinationCidrBlock(v string) *AwsEc2VpnConnectionRoutesDetails {
	s.DestinationCidrBlock = &v
	return s
}

// SetState sets the State field's value.
func (s *AwsEc2VpnConnectionRoutesDetails) SetState(v string) *AwsEc2VpnConnectionRoutesDetails {
	s.State = &v
	return s
}

// Information about the VPN tunnel.
type AwsEc2VpnConnectionVgwTelemetryDetails struct {
	_ struct{} `type:"structure"`

	// The number of accepted routes.
	AcceptedRouteCount *int64 `type:"integer"`

	// The ARN of the VPN tunnel endpoint certificate.
	CertificateArn *string `type:"string"`

	// The date and time of the last change in status.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastStatusChange *string `type:"string"`

	// The Internet-routable IP address of the virtual private gateway's outside
	// interface.
	OutsideIpAddress *string `type:"string"`

	// The status of the VPN tunnel.
	Status *string `type:"string"`

	// If an error occurs, a description of the error.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionVgwTelemetryDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2VpnConnectionVgwTelemetryDetails) GoString() string {
	return s.String()
}

// SetAcceptedRouteCount sets the AcceptedRouteCount field's value.
func (s *AwsEc2VpnConnectionVgwTelemetryDetails) SetAcceptedRouteCount(v int64) *AwsEc2VpnConnectionVgwTelemetryDetails {
	s.AcceptedRouteCount = &v
	return s
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *AwsEc2VpnConnectionVgwTelemetryDetails) SetCertificateArn(v string) *AwsEc2VpnConnectionVgwTelemetryDetails {
	s.CertificateArn = &v
	return s
}

// SetLastStatusChange sets the LastStatusChange field's value.
func (s *AwsEc2VpnConnectionVgwTelemetryDetails) SetLastStatusChange(v string) *AwsEc2VpnConnectionVgwTelemetryDetails {
	s.LastStatusChange = &v
	return s
}

// SetOutsideIpAddress sets the OutsideIpAddress field's value.
func (s *AwsEc2VpnConnectionVgwTelemetryDetails) SetOutsideIpAddress(v string) *AwsEc2VpnConnectionVgwTelemetryDetails {
	s.OutsideIpAddress = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsEc2VpnConnectionVgwTelemetryDetails) SetStatus(v string) *AwsEc2VpnConnectionVgwTelemetryDetails {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *AwsEc2VpnConnectionVgwTelemetryDetails) SetStatusMessage(v string) *AwsEc2VpnConnectionVgwTelemetryDetails {
	s.StatusMessage = &v
	return s
}

// Information about an Amazon ECR image.
type AwsEcrContainerImageDetails struct {
	_ struct{} `type:"structure"`

	// The architecture of the image.
	Architecture *string `type:"string"`

	// The sha256 digest of the image manifest.
	ImageDigest *string `type:"string"`

	// The date and time when the image was pushed to the repository.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	ImagePublishedAt *string `type:"string"`

	// The list of tags that are associated with the image.
	ImageTags []*string `type:"list"`

	// The Amazon Web Services account identifier that is associated with the registry
	// that the image belongs to.
	RegistryId *string `type:"string"`

	// The name of the repository that the image belongs to.
	RepositoryName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrContainerImageDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrContainerImageDetails) GoString() string {
	return s.String()
}

// SetArchitecture sets the Architecture field's value.
func (s *AwsEcrContainerImageDetails) SetArchitecture(v string) *AwsEcrContainerImageDetails {
	s.Architecture = &v
	return s
}

// SetImageDigest sets the ImageDigest field's value.
func (s *AwsEcrContainerImageDetails) SetImageDigest(v string) *AwsEcrContainerImageDetails {
	s.ImageDigest = &v
	return s
}

// SetImagePublishedAt sets the ImagePublishedAt field's value.
func (s *AwsEcrContainerImageDetails) SetImagePublishedAt(v string) *AwsEcrContainerImageDetails {
	s.ImagePublishedAt = &v
	return s
}

// SetImageTags sets the ImageTags field's value.
func (s *AwsEcrContainerImageDetails) SetImageTags(v []*string) *AwsEcrContainerImageDetails {
	s.ImageTags = v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *AwsEcrContainerImageDetails) SetRegistryId(v string) *AwsEcrContainerImageDetails {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *AwsEcrContainerImageDetails) SetRepositoryName(v string) *AwsEcrContainerImageDetails {
	s.RepositoryName = &v
	return s
}

// Provides information about an Amazon Elastic Container Registry repository.
type AwsEcrRepositoryDetails struct {
	_ struct{} `type:"structure"`

	// The ARN of the repository.
	Arn *string `type:"string"`

	// The image scanning configuration for a repository.
	ImageScanningConfiguration *AwsEcrRepositoryImageScanningConfigurationDetails `type:"structure"`

	// The tag mutability setting for the repository.
	ImageTagMutability *string `type:"string"`

	// Information about the lifecycle policy for the repository.
	LifecyclePolicy *AwsEcrRepositoryLifecyclePolicyDetails `type:"structure"`

	// The name of the repository.
	RepositoryName *string `type:"string"`

	// The text of the repository policy.
	RepositoryPolicyText *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrRepositoryDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrRepositoryDetails) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AwsEcrRepositoryDetails) SetArn(v string) *AwsEcrRepositoryDetails {
	s.Arn = &v
	return s
}

// SetImageScanningConfiguration sets the ImageScanningConfiguration field's value.
func (s *AwsEcrRepositoryDetails) SetImageScanningConfiguration(v *AwsEcrRepositoryImageScanningConfigurationDetails) *AwsEcrRepositoryDetails {
	s.ImageScanningConfiguration = v
	return s
}

// SetImageTagMutability sets the ImageTagMutability field's value.
func (s *AwsEcrRepositoryDetails) SetImageTagMutability(v string) *AwsEcrRepositoryDetails {
	s.ImageTagMutability = &v
	return s
}

// SetLifecyclePolicy sets the LifecyclePolicy field's value.
func (s *AwsEcrRepositoryDetails) SetLifecyclePolicy(v *AwsEcrRepositoryLifecyclePolicyDetails) *AwsEcrRepositoryDetails {
	s.LifecyclePolicy = v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *AwsEcrRepositoryDetails) SetRepositoryName(v string) *AwsEcrRepositoryDetails {
	s.RepositoryName = &v
	return s
}

// SetRepositoryPolicyText sets the RepositoryPolicyText field's value.
func (s *AwsEcrRepositoryDetails) SetRepositoryPolicyText(v string) *AwsEcrRepositoryDetails {
	s.RepositoryPolicyText = &v
	return s
}

// The image scanning configuration for a repository.
type AwsEcrRepositoryImageScanningConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// Whether to scan images after they are pushed to a repository.
	ScanOnPush *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrRepositoryImageScanningConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrRepositoryImageScanningConfigurationDetails) GoString() string {
	return s.String()
}

// SetScanOnPush sets the ScanOnPush field's value.
func (s *AwsEcrRepositoryImageScanningConfigurationDetails) SetScanOnPush(v bool) *AwsEcrRepositoryImageScanningConfigurationDetails {
	s.ScanOnPush = &v
	return s
}

// Information about the lifecycle policy for the repository.
type AwsEcrRepositoryLifecyclePolicyDetails struct {
	_ struct{} `type:"structure"`

	// The text of the lifecycle policy.
	LifecyclePolicyText *string `type:"string"`

	// The Amazon Web Services account identifier that is associated with the registry
	// that contains the repository.
	RegistryId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrRepositoryLifecyclePolicyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrRepositoryLifecyclePolicyDetails) GoString() string {
	return s.String()
}

// SetLifecyclePolicyText sets the LifecyclePolicyText field's value.
func (s *AwsEcrRepositoryLifecyclePolicyDetails) SetLifecyclePolicyText(v string) *AwsEcrRepositoryLifecyclePolicyDetails {
	s.LifecyclePolicyText = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *AwsEcrRepositoryLifecyclePolicyDetails) SetRegistryId(v string) *AwsEcrRepositoryLifecyclePolicyDetails {
	s.RegistryId = &v
	return s
}

// Indicates whether to enable CloudWatch Container Insights for the ECS cluster.
type AwsEcsClusterClusterSettingsDetails struct {
	_ struct{} `type:"structure"`

	// The name of the setting.
	Name *string `type:"string"`

	// The value of the setting.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterClusterSettingsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterClusterSettingsDetails) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsEcsClusterClusterSettingsDetails) SetName(v string) *AwsEcsClusterClusterSettingsDetails {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsEcsClusterClusterSettingsDetails) SetValue(v string) *AwsEcsClusterClusterSettingsDetails {
	s.Value = &v
	return s
}

// The run command configuration for the cluster.
type AwsEcsClusterConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// Contains the run command configuration for the cluster.
	ExecuteCommandConfiguration *AwsEcsClusterConfigurationExecuteCommandConfigurationDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterConfigurationDetails) GoString() string {
	return s.String()
}

// SetExecuteCommandConfiguration sets the ExecuteCommandConfiguration field's value.
func (s *AwsEcsClusterConfigurationDetails) SetExecuteCommandConfiguration(v *AwsEcsClusterConfigurationExecuteCommandConfigurationDetails) *AwsEcsClusterConfigurationDetails {
	s.ExecuteCommandConfiguration = v
	return s
}

// Contains the run command configuration for the cluster.
type AwsEcsClusterConfigurationExecuteCommandConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// The identifier of the KMS key that is used to encrypt the data between the
	// local client and the container.
	KmsKeyId *string `type:"string"`

	// The log configuration for the results of the run command actions. Required
	// if Logging is NONE.
	LogConfiguration *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails `type:"structure"`

	// The log setting to use for redirecting logs for run command results.
	Logging *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterConfigurationExecuteCommandConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterConfigurationExecuteCommandConfigurationDetails) GoString() string {
	return s.String()
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsEcsClusterConfigurationExecuteCommandConfigurationDetails) SetKmsKeyId(v string) *AwsEcsClusterConfigurationExecuteCommandConfigurationDetails {
	s.KmsKeyId = &v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *AwsEcsClusterConfigurationExecuteCommandConfigurationDetails) SetLogConfiguration(v *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails) *AwsEcsClusterConfigurationExecuteCommandConfigurationDetails {
	s.LogConfiguration = v
	return s
}

// SetLogging sets the Logging field's value.
func (s *AwsEcsClusterConfigurationExecuteCommandConfigurationDetails) SetLogging(v string) *AwsEcsClusterConfigurationExecuteCommandConfigurationDetails {
	s.Logging = &v
	return s
}

// The log configuration for the results of the run command actions.
type AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// Whether to enable encryption on the CloudWatch logs.
	CloudWatchEncryptionEnabled *bool `type:"boolean"`

	// The name of the CloudWatch log group to send the logs to.
	CloudWatchLogGroupName *string `type:"string"`

	// The name of the S3 bucket to send logs to.
	S3BucketName *string `type:"string"`

	// Whether to encrypt the logs that are sent to the S3 bucket.
	S3EncryptionEnabled *bool `type:"boolean"`

	// Identifies the folder in the S3 bucket to send the logs to.
	S3KeyPrefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails) GoString() string {
	return s.String()
}

// SetCloudWatchEncryptionEnabled sets the CloudWatchEncryptionEnabled field's value.
func (s *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails) SetCloudWatchEncryptionEnabled(v bool) *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails {
	s.CloudWatchEncryptionEnabled = &v
	return s
}

// SetCloudWatchLogGroupName sets the CloudWatchLogGroupName field's value.
func (s *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails) SetCloudWatchLogGroupName(v string) *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails {
	s.CloudWatchLogGroupName = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails) SetS3BucketName(v string) *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails {
	s.S3BucketName = &v
	return s
}

// SetS3EncryptionEnabled sets the S3EncryptionEnabled field's value.
func (s *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails) SetS3EncryptionEnabled(v bool) *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails {
	s.S3EncryptionEnabled = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails) SetS3KeyPrefix(v string) *AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails {
	s.S3KeyPrefix = &v
	return s
}

// The default capacity provider strategy for the cluster. The default capacity
// provider strategy is used when services or tasks are run without a specified
// launch type or capacity provider strategy.
type AwsEcsClusterDefaultCapacityProviderStrategyDetails struct {
	_ struct{} `type:"structure"`

	// The minimum number of tasks to run on the specified capacity provider.
	Base *int64 `type:"integer"`

	// The name of the capacity provider.
	CapacityProvider *string `type:"string"`

	// The relative percentage of the total number of tasks launched that should
	// use the capacity provider.
	Weight *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterDefaultCapacityProviderStrategyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterDefaultCapacityProviderStrategyDetails) GoString() string {
	return s.String()
}

// SetBase sets the Base field's value.
func (s *AwsEcsClusterDefaultCapacityProviderStrategyDetails) SetBase(v int64) *AwsEcsClusterDefaultCapacityProviderStrategyDetails {
	s.Base = &v
	return s
}

// SetCapacityProvider sets the CapacityProvider field's value.
func (s *AwsEcsClusterDefaultCapacityProviderStrategyDetails) SetCapacityProvider(v string) *AwsEcsClusterDefaultCapacityProviderStrategyDetails {
	s.CapacityProvider = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *AwsEcsClusterDefaultCapacityProviderStrategyDetails) SetWeight(v int64) *AwsEcsClusterDefaultCapacityProviderStrategyDetails {
	s.Weight = &v
	return s
}

// provides details about an ECS cluster.
type AwsEcsClusterDetails struct {
	_ struct{} `type:"structure"`

	// The short name of one or more capacity providers to associate with the cluster.
	CapacityProviders []*string `type:"list"`

	// The setting to use to create the cluster. Specifically used to configure
	// whether to enable CloudWatch Container Insights for the cluster.
	ClusterSettings []*AwsEcsClusterClusterSettingsDetails `type:"list"`

	// The run command configuration for the cluster.
	Configuration *AwsEcsClusterConfigurationDetails `type:"structure"`

	// The default capacity provider strategy for the cluster. The default capacity
	// provider strategy is used when services or tasks are run without a specified
	// launch type or capacity provider strategy.
	DefaultCapacityProviderStrategy []*AwsEcsClusterDefaultCapacityProviderStrategyDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsClusterDetails) GoString() string {
	return s.String()
}

// SetCapacityProviders sets the CapacityProviders field's value.
func (s *AwsEcsClusterDetails) SetCapacityProviders(v []*string) *AwsEcsClusterDetails {
	s.CapacityProviders = v
	return s
}

// SetClusterSettings sets the ClusterSettings field's value.
func (s *AwsEcsClusterDetails) SetClusterSettings(v []*AwsEcsClusterClusterSettingsDetails) *AwsEcsClusterDetails {
	s.ClusterSettings = v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *AwsEcsClusterDetails) SetConfiguration(v *AwsEcsClusterConfigurationDetails) *AwsEcsClusterDetails {
	s.Configuration = v
	return s
}

// SetDefaultCapacityProviderStrategy sets the DefaultCapacityProviderStrategy field's value.
func (s *AwsEcsClusterDetails) SetDefaultCapacityProviderStrategy(v []*AwsEcsClusterDefaultCapacityProviderStrategyDetails) *AwsEcsClusterDetails {
	s.DefaultCapacityProviderStrategy = v
	return s
}

// Strategy item for the capacity provider strategy that the service uses.
type AwsEcsServiceCapacityProviderStrategyDetails struct {
	_ struct{} `type:"structure"`

	// The minimum number of tasks to run on the capacity provider. Only one strategy
	// item can specify a value for Base.
	//
	// The value must be between 0 and 100000.
	Base *int64 `type:"integer"`

	// The short name of the capacity provider.
	CapacityProvider *string `type:"string"`

	// The relative percentage of the total number of tasks that should use the
	// capacity provider.
	//
	// If no weight is specified, the default value is 0. At least one capacity
	// provider must have a weight greater than 0.
	//
	// The value can be between 0 and 1000.
	Weight *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceCapacityProviderStrategyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceCapacityProviderStrategyDetails) GoString() string {
	return s.String()
}

// SetBase sets the Base field's value.
func (s *AwsEcsServiceCapacityProviderStrategyDetails) SetBase(v int64) *AwsEcsServiceCapacityProviderStrategyDetails {
	s.Base = &v
	return s
}

// SetCapacityProvider sets the CapacityProvider field's value.
func (s *AwsEcsServiceCapacityProviderStrategyDetails) SetCapacityProvider(v string) *AwsEcsServiceCapacityProviderStrategyDetails {
	s.CapacityProvider = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *AwsEcsServiceCapacityProviderStrategyDetails) SetWeight(v int64) *AwsEcsServiceCapacityProviderStrategyDetails {
	s.Weight = &v
	return s
}

// Determines whether a service deployment fails if a service cannot reach a
// steady state.
type AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails struct {
	_ struct{} `type:"structure"`

	// Whether to enable the deployment circuit breaker logic for the service.
	Enable *bool `type:"boolean"`

	// Whether to roll back the service if a service deployment fails. If rollback
	// is enabled, when a service deployment fails, the service is rolled back to
	// the last deployment that completed successfully.
	Rollback *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails) SetEnable(v bool) *AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails {
	s.Enable = &v
	return s
}

// SetRollback sets the Rollback field's value.
func (s *AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails) SetRollback(v bool) *AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails {
	s.Rollback = &v
	return s
}

// Optional deployment parameters for the service.
type AwsEcsServiceDeploymentConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// Determines whether a service deployment fails if a service cannot reach a
	// steady state.
	DeploymentCircuitBreaker *AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails `type:"structure"`

	// For a service that uses the rolling update (ECS) deployment type, the maximum
	// number of tasks in a service that are allowed in the RUNNING or PENDING state
	// during a deployment, and for tasks that use the EC2 launch type, when any
	// container instances are in the DRAINING state. Provided as a percentage of
	// the desired number of tasks. The default value is 200%.
	//
	// For a service that uses the blue/green (CODE_DEPLOY) or EXTERNAL deployment
	// types, and tasks that use the EC2 launch type, the maximum number of tasks
	// in the service that remain in the RUNNING state while the container instances
	// are in the DRAINING state.
	//
	// For the Fargate launch type, the maximum percent value is not used.
	MaximumPercent *int64 `type:"integer"`

	// For a service that uses the rolling update (ECS) deployment type, the minimum
	// number of tasks in a service that must remain in the RUNNING state during
	// a deployment, and while any container instances are in the DRAINING state
	// if the service contains tasks using the EC2 launch type. Expressed as a percentage
	// of the desired number of tasks. The default value is 100%.
	//
	// For a service that uses the blue/green (CODE_DEPLOY) or EXTERNAL deployment
	// types and tasks that use the EC2 launch type, the minimum number of the tasks
	// in the service that remain in the RUNNING state while the container instances
	// are in the DRAINING state.
	//
	// For the Fargate launch type, the minimum healthy percent value is not used.
	MinimumHealthyPercent *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceDeploymentConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceDeploymentConfigurationDetails) GoString() string {
	return s.String()
}

// SetDeploymentCircuitBreaker sets the DeploymentCircuitBreaker field's value.
func (s *AwsEcsServiceDeploymentConfigurationDetails) SetDeploymentCircuitBreaker(v *AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails) *AwsEcsServiceDeploymentConfigurationDetails {
	s.DeploymentCircuitBreaker = v
	return s
}

// SetMaximumPercent sets the MaximumPercent field's value.
func (s *AwsEcsServiceDeploymentConfigurationDetails) SetMaximumPercent(v int64) *AwsEcsServiceDeploymentConfigurationDetails {
	s.MaximumPercent = &v
	return s
}

// SetMinimumHealthyPercent sets the MinimumHealthyPercent field's value.
func (s *AwsEcsServiceDeploymentConfigurationDetails) SetMinimumHealthyPercent(v int64) *AwsEcsServiceDeploymentConfigurationDetails {
	s.MinimumHealthyPercent = &v
	return s
}

// Information about the deployment controller type that the service uses.
type AwsEcsServiceDeploymentControllerDetails struct {
	_ struct{} `type:"structure"`

	// The rolling update (ECS) deployment type replaces the current running version
	// of the container with the latest version.
	//
	// The blue/green (CODE_DEPLOY) deployment type uses the blue/green deployment
	// model that is powered by CodeDeploy. This deployment model a new deployment
	// of a service can be verified before production traffic is sent to it.
	//
	// The external (EXTERNAL) deployment type allows the use of any third-party
	// deployment controller for full control over the deployment process for an
	// Amazon ECS service.
	//
	// Valid values: ECS | CODE_DEPLOY | EXTERNAL
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceDeploymentControllerDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceDeploymentControllerDetails) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *AwsEcsServiceDeploymentControllerDetails) SetType(v string) *AwsEcsServiceDeploymentControllerDetails {
	s.Type = &v
	return s
}

// Provides details about a service within an ECS cluster.
type AwsEcsServiceDetails struct {
	_ struct{} `type:"structure"`

	// The capacity provider strategy that the service uses.
	CapacityProviderStrategy []*AwsEcsServiceCapacityProviderStrategyDetails `type:"list"`

	// The ARN of the cluster that hosts the service.
	Cluster *string `type:"string"`

	// Deployment parameters for the service. Includes the number of tasks that
	// run and the order in which to start and stop tasks.
	DeploymentConfiguration *AwsEcsServiceDeploymentConfigurationDetails `type:"structure"`

	// Contains the deployment controller type that the service uses.
	DeploymentController *AwsEcsServiceDeploymentControllerDetails `type:"structure"`

	// The number of instantiations of the task definition to run on the service.
	DesiredCount *int64 `type:"integer"`

	// Whether to enable Amazon ECS managed tags for the tasks in the service.
	EnableEcsManagedTags *bool `type:"boolean"`

	// Whether the execute command functionality is enabled for the service.
	EnableExecuteCommand *bool `type:"boolean"`

	// After a task starts, the amount of time in seconds that the Amazon ECS service
	// scheduler ignores unhealthy Elastic Load Balancing target health checks.
	HealthCheckGracePeriodSeconds *int64 `type:"integer"`

	// The launch type that the service uses.
	//
	// Valid values: EC2 | FARGATE | EXTERNAL
	LaunchType *string `type:"string"`

	// Information about the load balancers that the service uses.
	LoadBalancers []*AwsEcsServiceLoadBalancersDetails `type:"list"`

	// The name of the service.
	Name *string `type:"string"`

	// For tasks that use the awsvpc networking mode, the VPC subnet and security
	// group configuration.
	NetworkConfiguration *AwsEcsServiceNetworkConfigurationDetails `type:"structure"`

	// The placement constraints for the tasks in the service.
	PlacementConstraints []*AwsEcsServicePlacementConstraintsDetails `type:"list"`

	// Information about how tasks for the service are placed.
	PlacementStrategies []*AwsEcsServicePlacementStrategiesDetails `type:"list"`

	// The platform version on which to run the service. Only specified for tasks
	// that are hosted on Fargate. If a platform version is not specified, the LATEST
	// platform version is used by default.
	PlatformVersion *string `type:"string"`

	// Indicates whether to propagate the tags from the task definition to the task
	// or from the service to the task. If no value is provided, then tags are not
	// propagated.
	//
	// Valid values: TASK_DEFINITION | SERVICE
	PropagateTags *string `type:"string"`

	// The ARN of the IAM role that is associated with the service. The role allows
	// the Amazon ECS container agent to register container instances with an Elastic
	// Load Balancing load balancer.
	Role *string `type:"string"`

	// The scheduling strategy to use for the service.
	//
	// The REPLICA scheduling strategy places and maintains the desired number of
	// tasks across the cluster. By default, the service scheduler spreads tasks
	// across Availability Zones. Task placement strategies and constraints are
	// used to customize task placement decisions.
	//
	// The DAEMON scheduling strategy deploys exactly one task on each active container
	// instance that meets all of the task placement constraints that are specified
	// in the cluster. The service scheduler also evaluates the task placement constraints
	// for running tasks and stops tasks that do not meet the placement constraints.
	//
	// Valid values: REPLICA | DAEMON
	SchedulingStrategy *string `type:"string"`

	// The ARN of the service.
	ServiceArn *string `type:"string"`

	// The name of the service.
	//
	// The name can contain up to 255 characters. It can use letters, numbers, underscores,
	// and hyphens.
	ServiceName *string `type:"string"`

	// Information about the service discovery registries to assign to the service.
	ServiceRegistries []*AwsEcsServiceServiceRegistriesDetails `type:"list"`

	// The task definition to use for tasks in the service.
	TaskDefinition *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceDetails) GoString() string {
	return s.String()
}

// SetCapacityProviderStrategy sets the CapacityProviderStrategy field's value.
func (s *AwsEcsServiceDetails) SetCapacityProviderStrategy(v []*AwsEcsServiceCapacityProviderStrategyDetails) *AwsEcsServiceDetails {
	s.CapacityProviderStrategy = v
	return s
}

// SetCluster sets the Cluster field's value.
func (s *AwsEcsServiceDetails) SetCluster(v string) *AwsEcsServiceDetails {
	s.Cluster = &v
	return s
}

// SetDeploymentConfiguration sets the DeploymentConfiguration field's value.
func (s *AwsEcsServiceDetails) SetDeploymentConfiguration(v *AwsEcsServiceDeploymentConfigurationDetails) *AwsEcsServiceDetails {
	s.DeploymentConfiguration = v
	return s
}

// SetDeploymentController sets the DeploymentController field's value.
func (s *AwsEcsServiceDetails) SetDeploymentController(v *AwsEcsServiceDeploymentControllerDetails) *AwsEcsServiceDetails {
	s.DeploymentController = v
	return s
}

// SetDesiredCount sets the DesiredCount field's value.
func (s *AwsEcsServiceDetails) SetDesiredCount(v int64) *AwsEcsServiceDetails {
	s.DesiredCount = &v
	return s
}

// SetEnableEcsManagedTags sets the EnableEcsManagedTags field's value.
func (s *AwsEcsServiceDetails) SetEnableEcsManagedTags(v bool) *AwsEcsServiceDetails {
	s.EnableEcsManagedTags = &v
	return s
}

// SetEnableExecuteCommand sets the EnableExecuteCommand field's value.
func (s *AwsEcsServiceDetails) SetEnableExecuteCommand(v bool) *AwsEcsServiceDetails {
	s.EnableExecuteCommand = &v
	return s
}

// SetHealthCheckGracePeriodSeconds sets the HealthCheckGracePeriodSeconds field's value.
func (s *AwsEcsServiceDetails) SetHealthCheckGracePeriodSeconds(v int64) *AwsEcsServiceDetails {
	s.HealthCheckGracePeriodSeconds = &v
	return s
}

// SetLaunchType sets the LaunchType field's value.
func (s *AwsEcsServiceDetails) SetLaunchType(v string) *AwsEcsServiceDetails {
	s.LaunchType = &v
	return s
}

// SetLoadBalancers sets the LoadBalancers field's value.
func (s *AwsEcsServiceDetails) SetLoadBalancers(v []*AwsEcsServiceLoadBalancersDetails) *AwsEcsServiceDetails {
	s.LoadBalancers = v
	return s
}

// SetName sets the Name field's value.
func (s *AwsEcsServiceDetails) SetName(v string) *AwsEcsServiceDetails {
	s.Name = &v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *AwsEcsServiceDetails) SetNetworkConfiguration(v *AwsEcsServiceNetworkConfigurationDetails) *AwsEcsServiceDetails {
	s.NetworkConfiguration = v
	return s
}

// SetPlacementConstraints sets the PlacementConstraints field's value.
func (s *AwsEcsServiceDetails) SetPlacementConstraints(v []*AwsEcsServicePlacementConstraintsDetails) *AwsEcsServiceDetails {
	s.PlacementConstraints = v
	return s
}

// SetPlacementStrategies sets the PlacementStrategies field's value.
func (s *AwsEcsServiceDetails) SetPlacementStrategies(v []*AwsEcsServicePlacementStrategiesDetails) *AwsEcsServiceDetails {
	s.PlacementStrategies = v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *AwsEcsServiceDetails) SetPlatformVersion(v string) *AwsEcsServiceDetails {
	s.PlatformVersion = &v
	return s
}

// SetPropagateTags sets the PropagateTags field's value.
func (s *AwsEcsServiceDetails) SetPropagateTags(v string) *AwsEcsServiceDetails {
	s.PropagateTags = &v
	return s
}

// SetRole sets the Role field's value.
func (s *AwsEcsServiceDetails) SetRole(v string) *AwsEcsServiceDetails {
	s.Role = &v
	return s
}

// SetSchedulingStrategy sets the SchedulingStrategy field's value.
func (s *AwsEcsServiceDetails) SetSchedulingStrategy(v string) *AwsEcsServiceDetails {
	s.SchedulingStrategy = &v
	return s
}

// SetServiceArn sets the ServiceArn field's value.
func (s *AwsEcsServiceDetails) SetServiceArn(v string) *AwsEcsServiceDetails {
	s.ServiceArn = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *AwsEcsServiceDetails) SetServiceName(v string) *AwsEcsServiceDetails {
	s.ServiceName = &v
	return s
}

// SetServiceRegistries sets the ServiceRegistries field's value.
func (s *AwsEcsServiceDetails) SetServiceRegistries(v []*AwsEcsServiceServiceRegistriesDetails) *AwsEcsServiceDetails {
	s.ServiceRegistries = v
	return s
}

// SetTaskDefinition sets the TaskDefinition field's value.
func (s *AwsEcsServiceDetails) SetTaskDefinition(v string) *AwsEcsServiceDetails {
	s.TaskDefinition = &v
	return s
}

// Information about a load balancer that the service uses.
type AwsEcsServiceLoadBalancersDetails struct {
	_ struct{} `type:"structure"`

	// The name of the container to associate with the load balancer.
	ContainerName *string `type:"string"`

	// The port on the container to associate with the load balancer. This port
	// must correspond to a containerPort in the task definition the tasks in the
	// service are using. For tasks that use the EC2 launch type, the container
	// instance they are launched on must allow ingress traffic on the hostPort
	// of the port mapping.
	ContainerPort *int64 `type:"integer"`

	// The name of the load balancer to associate with the Amazon ECS service or
	// task set.
	//
	// Only specified when using a Classic Load Balancer. For an Application Load
	// Balancer or a Network Load Balancer, the load balancer name is omitted.
	LoadBalancerName *string `type:"string"`

	// The ARN of the Elastic Load Balancing target group or groups associated with
	// a service or task set.
	//
	// Only specified when using an Application Load Balancer or a Network Load
	// Balancer. For a Classic Load Balancer, the target group ARN is omitted.
	TargetGroupArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceLoadBalancersDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceLoadBalancersDetails) GoString() string {
	return s.String()
}

// SetContainerName sets the ContainerName field's value.
func (s *AwsEcsServiceLoadBalancersDetails) SetContainerName(v string) *AwsEcsServiceLoadBalancersDetails {
	s.ContainerName = &v
	return s
}

// SetContainerPort sets the ContainerPort field's value.
func (s *AwsEcsServiceLoadBalancersDetails) SetContainerPort(v int64) *AwsEcsServiceLoadBalancersDetails {
	s.ContainerPort = &v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *AwsEcsServiceLoadBalancersDetails) SetLoadBalancerName(v string) *AwsEcsServiceLoadBalancersDetails {
	s.LoadBalancerName = &v
	return s
}

// SetTargetGroupArn sets the TargetGroupArn field's value.
func (s *AwsEcsServiceLoadBalancersDetails) SetTargetGroupArn(v string) *AwsEcsServiceLoadBalancersDetails {
	s.TargetGroupArn = &v
	return s
}

// For tasks that use the awsvpc networking mode, the VPC subnet and security
// group configuration.
type AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// Whether the task's elastic network interface receives a public IP address.
	// The default value is DISABLED.
	//
	// Valid values: ENABLED | DISABLED
	AssignPublicIp *string `type:"string"`

	// The IDs of the security groups associated with the task or service.
	//
	// You can provide up to five security groups.
	SecurityGroups []*string `type:"list"`

	// The IDs of the subnets associated with the task or service.
	//
	// You can provide up to 16 subnets.
	Subnets []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails) GoString() string {
	return s.String()
}

// SetAssignPublicIp sets the AssignPublicIp field's value.
func (s *AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails) SetAssignPublicIp(v string) *AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails {
	s.AssignPublicIp = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails) SetSecurityGroups(v []*string) *AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails {
	s.SecurityGroups = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails) SetSubnets(v []*string) *AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails {
	s.Subnets = v
	return s
}

// For tasks that use the awsvpc networking mode, the VPC subnet and security
// group configuration.
type AwsEcsServiceNetworkConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// The VPC subnet and security group configuration.
	AwsVpcConfiguration *AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceNetworkConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceNetworkConfigurationDetails) GoString() string {
	return s.String()
}

// SetAwsVpcConfiguration sets the AwsVpcConfiguration field's value.
func (s *AwsEcsServiceNetworkConfigurationDetails) SetAwsVpcConfiguration(v *AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails) *AwsEcsServiceNetworkConfigurationDetails {
	s.AwsVpcConfiguration = v
	return s
}

// A placement constraint for the tasks in the service.
type AwsEcsServicePlacementConstraintsDetails struct {
	_ struct{} `type:"structure"`

	// A cluster query language expression to apply to the constraint. You cannot
	// specify an expression if the constraint type is distinctInstance.
	Expression *string `type:"string"`

	// The type of constraint. Use distinctInstance to run each task in a particular
	// group on a different container instance. Use memberOf to restrict the selection
	// to a group of valid candidates.
	//
	// Valid values: distinctInstance | memberOf
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServicePlacementConstraintsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServicePlacementConstraintsDetails) GoString() string {
	return s.String()
}

// SetExpression sets the Expression field's value.
func (s *AwsEcsServicePlacementConstraintsDetails) SetExpression(v string) *AwsEcsServicePlacementConstraintsDetails {
	s.Expression = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsEcsServicePlacementConstraintsDetails) SetType(v string) *AwsEcsServicePlacementConstraintsDetails {
	s.Type = &v
	return s
}

// A placement strategy that determines how to place the tasks for the service.
type AwsEcsServicePlacementStrategiesDetails struct {
	_ struct{} `type:"structure"`

	// The field to apply the placement strategy against.
	//
	// For the spread placement strategy, valid values are instanceId (or host,
	// which has the same effect), or any platform or custom attribute that is applied
	// to a container instance, such as attribute:ecs.availability-zone.
	//
	// For the binpack placement strategy, valid values are cpu and memory.
	//
	// For the random placement strategy, this attribute is not used.
	Field *string `type:"string"`

	// The type of placement strategy.
	//
	// The random placement strategy randomly places tasks on available candidates.
	//
	// The spread placement strategy spreads placement across available candidates
	// evenly based on the value of Field.
	//
	// The binpack strategy places tasks on available candidates that have the least
	// available amount of the resource that is specified in Field.
	//
	// Valid values: random | spread | binpack
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServicePlacementStrategiesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServicePlacementStrategiesDetails) GoString() string {
	return s.String()
}

// SetField sets the Field field's value.
func (s *AwsEcsServicePlacementStrategiesDetails) SetField(v string) *AwsEcsServicePlacementStrategiesDetails {
	s.Field = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsEcsServicePlacementStrategiesDetails) SetType(v string) *AwsEcsServicePlacementStrategiesDetails {
	s.Type = &v
	return s
}

// Information about a service discovery registry to assign to the service.
type AwsEcsServiceServiceRegistriesDetails struct {
	_ struct{} `type:"structure"`

	// The container name value to use for the service discovery service.
	//
	// If the task definition uses the bridge or host network mode, you must specify
	// ContainerName and ContainerPort.
	//
	// If the task definition uses the awsvpc network mode and a type SRV DNS record,
	// you must specify either ContainerName and ContainerPort, or Port , but not
	// both.
	ContainerName *string `type:"string"`

	// The port value to use for the service discovery service.
	//
	// If the task definition uses the bridge or host network mode, you must specify
	// ContainerName and ContainerPort.
	//
	// If the task definition uses the awsvpc network mode and a type SRV DNS record,
	// you must specify either ContainerName and ContainerPort, or Port , but not
	// both.
	ContainerPort *int64 `type:"integer"`

	// The port value to use for a service discovery service that specifies an SRV
	// record. This field can be used if both the awsvpcawsvpc network mode and
	// SRV records are used.
	Port *int64 `type:"integer"`

	// The ARN of the service registry.
	RegistryArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceServiceRegistriesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsServiceServiceRegistriesDetails) GoString() string {
	return s.String()
}

// SetContainerName sets the ContainerName field's value.
func (s *AwsEcsServiceServiceRegistriesDetails) SetContainerName(v string) *AwsEcsServiceServiceRegistriesDetails {
	s.ContainerName = &v
	return s
}

// SetContainerPort sets the ContainerPort field's value.
func (s *AwsEcsServiceServiceRegistriesDetails) SetContainerPort(v int64) *AwsEcsServiceServiceRegistriesDetails {
	s.ContainerPort = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AwsEcsServiceServiceRegistriesDetails) SetPort(v int64) *AwsEcsServiceServiceRegistriesDetails {
	s.Port = &v
	return s
}

// SetRegistryArn sets the RegistryArn field's value.
func (s *AwsEcsServiceServiceRegistriesDetails) SetRegistryArn(v string) *AwsEcsServiceServiceRegistriesDetails {
	s.RegistryArn = &v
	return s
}

// A dependency that is defined for container startup and shutdown.
type AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails struct {
	_ struct{} `type:"structure"`

	// The dependency condition of the dependent container. Indicates the required
	// status of the dependent container before the current container can start.
	Condition *string `type:"string"`

	// The name of the dependent container.
	ContainerName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails) SetCondition(v string) *AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails {
	s.Condition = &v
	return s
}

// SetContainerName sets the ContainerName field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails) SetContainerName(v string) *AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails {
	s.ContainerName = &v
	return s
}

// A container definition that describes a container in the task.
type AwsEcsTaskDefinitionContainerDefinitionsDetails struct {
	_ struct{} `type:"structure"`

	// The command that is passed to the container.
	Command []*string `type:"list"`

	// The number of CPU units reserved for the container.
	Cpu *int64 `type:"integer"`

	// The dependencies that are defined for container startup and shutdown.
	DependsOn []*AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails `type:"list"`

	// Whether to disable networking within the container.
	DisableNetworking *bool `type:"boolean"`

	// A list of DNS search domains that are presented to the container.
	DnsSearchDomains []*string `type:"list"`

	// A list of DNS servers that are presented to the container.
	DnsServers []*string `type:"list"`

	// A key-value map of labels to add to the container.
	DockerLabels map[string]*string `type:"map"`

	// A list of strings to provide custom labels for SELinux and AppArmor multi-level
	// security systems.
	DockerSecurityOptions []*string `type:"list"`

	// The entry point that is passed to the container.
	EntryPoint []*string `type:"list"`

	// The environment variables to pass to a container.
	Environment []*AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails `type:"list"`

	// A list of files containing the environment variables to pass to a container.
	EnvironmentFiles []*AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails `type:"list"`

	// Whether the container is essential. All tasks must have at least one essential
	// container.
	Essential *bool `type:"boolean"`

	// A list of hostnames and IP address mappings to append to the /etc/hosts file
	// on the container.
	ExtraHosts []*AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails `type:"list"`

	// The FireLens configuration for the container. Specifies and configures a
	// log router for container logs.
	FirelensConfiguration *AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails `type:"structure"`

	// The container health check command and associated configuration parameters
	// for the container.
	HealthCheck *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails `type:"structure"`

	// The hostname to use for the container.
	Hostname *string `type:"string"`

	// The image used to start the container.
	Image *string `type:"string"`

	// If set to true, then containerized applications can be deployed that require
	// stdin or a tty to be allocated.
	Interactive *bool `type:"boolean"`

	// A list of links for the container in the form container_name:alias . Allows
	// containers to communicate with each other without the need for port mappings.
	Links []*string `type:"list"`

	// Linux-specific modifications that are applied to the container, such as Linux
	// kernel capabilities.
	LinuxParameters *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails `type:"structure"`

	// The log configuration specification for the container.
	LogConfiguration *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails `type:"structure"`

	// The amount (in MiB) of memory to present to the container. If the container
	// attempts to exceed the memory specified here, the container is shut down.
	// The total amount of memory reserved for all containers within a task must
	// be lower than the task memory value, if one is specified.
	Memory *int64 `type:"integer"`

	// The soft limit (in MiB) of memory to reserve for the container.
	MemoryReservation *int64 `type:"integer"`

	// The mount points for the data volumes in the container.
	MountPoints []*AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails `type:"list"`

	// The name of the container.
	Name *string `type:"string"`

	// The list of port mappings for the container.
	PortMappings []*AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails `type:"list"`

	// Whether the container is given elevated privileges on the host container
	// instance. The elevated privileges are similar to the root user.
	Privileged *bool `type:"boolean"`

	// Whether to allocate a TTY to the container.
	PseudoTerminal *bool `type:"boolean"`

	// Whether the container is given read-only access to its root file system.
	ReadonlyRootFilesystem *bool `type:"boolean"`

	// The private repository authentication credentials to use.
	RepositoryCredentials *AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails `type:"structure"`

	// The type and amount of a resource to assign to a container. The only supported
	// resource is a GPU.
	ResourceRequirements []*AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails `type:"list"`

	// The secrets to pass to the container.
	Secrets []*AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails `type:"list"`

	// The number of seconds to wait before giving up on resolving dependencies
	// for a container.
	StartTimeout *int64 `type:"integer"`

	// The number of seconds to wait before the container is stopped if it doesn't
	// shut down normally on its own.
	StopTimeout *int64 `type:"integer"`

	// A list of namespaced kernel parameters to set in the container.
	SystemControls []*AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails `type:"list"`

	// A list of ulimits to set in the container.
	Ulimits []*AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails `type:"list"`

	// The user to use inside the container.
	//
	// The value can use one of the following formats.
	//
	//    * user
	//
	//    * user :group
	//
	//    * uid
	//
	//    * uid :gid
	//
	//    * user :gid
	//
	//    * uid :group
	User *string `type:"string"`

	// Data volumes to mount from another container.
	VolumesFrom []*AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails `type:"list"`

	// The working directory in which to run commands inside the container.
	WorkingDirectory *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsDetails) GoString() string {
	return s.String()
}

// SetCommand sets the Command field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetCommand(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Command = v
	return s
}

// SetCpu sets the Cpu field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetCpu(v int64) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Cpu = &v
	return s
}

// SetDependsOn sets the DependsOn field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetDependsOn(v []*AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.DependsOn = v
	return s
}

// SetDisableNetworking sets the DisableNetworking field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetDisableNetworking(v bool) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.DisableNetworking = &v
	return s
}

// SetDnsSearchDomains sets the DnsSearchDomains field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetDnsSearchDomains(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.DnsSearchDomains = v
	return s
}

// SetDnsServers sets the DnsServers field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetDnsServers(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.DnsServers = v
	return s
}

// SetDockerLabels sets the DockerLabels field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetDockerLabels(v map[string]*string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.DockerLabels = v
	return s
}

// SetDockerSecurityOptions sets the DockerSecurityOptions field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetDockerSecurityOptions(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.DockerSecurityOptions = v
	return s
}

// SetEntryPoint sets the EntryPoint field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetEntryPoint(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.EntryPoint = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetEnvironment(v []*AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Environment = v
	return s
}

// SetEnvironmentFiles sets the EnvironmentFiles field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetEnvironmentFiles(v []*AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.EnvironmentFiles = v
	return s
}

// SetEssential sets the Essential field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetEssential(v bool) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Essential = &v
	return s
}

// SetExtraHosts sets the ExtraHosts field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetExtraHosts(v []*AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.ExtraHosts = v
	return s
}

// SetFirelensConfiguration sets the FirelensConfiguration field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetFirelensConfiguration(v *AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.FirelensConfiguration = v
	return s
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetHealthCheck(v *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.HealthCheck = v
	return s
}

// SetHostname sets the Hostname field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetHostname(v string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Hostname = &v
	return s
}

// SetImage sets the Image field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetImage(v string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Image = &v
	return s
}

// SetInteractive sets the Interactive field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetInteractive(v bool) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Interactive = &v
	return s
}

// SetLinks sets the Links field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetLinks(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Links = v
	return s
}

// SetLinuxParameters sets the LinuxParameters field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetLinuxParameters(v *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.LinuxParameters = v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetLogConfiguration(v *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.LogConfiguration = v
	return s
}

// SetMemory sets the Memory field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetMemory(v int64) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Memory = &v
	return s
}

// SetMemoryReservation sets the MemoryReservation field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetMemoryReservation(v int64) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.MemoryReservation = &v
	return s
}

// SetMountPoints sets the MountPoints field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetMountPoints(v []*AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.MountPoints = v
	return s
}

// SetName sets the Name field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetName(v string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Name = &v
	return s
}

// SetPortMappings sets the PortMappings field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetPortMappings(v []*AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.PortMappings = v
	return s
}

// SetPrivileged sets the Privileged field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetPrivileged(v bool) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Privileged = &v
	return s
}

// SetPseudoTerminal sets the PseudoTerminal field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetPseudoTerminal(v bool) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.PseudoTerminal = &v
	return s
}

// SetReadonlyRootFilesystem sets the ReadonlyRootFilesystem field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetReadonlyRootFilesystem(v bool) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.ReadonlyRootFilesystem = &v
	return s
}

// SetRepositoryCredentials sets the RepositoryCredentials field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetRepositoryCredentials(v *AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.RepositoryCredentials = v
	return s
}

// SetResourceRequirements sets the ResourceRequirements field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetResourceRequirements(v []*AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.ResourceRequirements = v
	return s
}

// SetSecrets sets the Secrets field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetSecrets(v []*AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Secrets = v
	return s
}

// SetStartTimeout sets the StartTimeout field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetStartTimeout(v int64) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.StartTimeout = &v
	return s
}

// SetStopTimeout sets the StopTimeout field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetStopTimeout(v int64) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.StopTimeout = &v
	return s
}

// SetSystemControls sets the SystemControls field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetSystemControls(v []*AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.SystemControls = v
	return s
}

// SetUlimits sets the Ulimits field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetUlimits(v []*AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.Ulimits = v
	return s
}

// SetUser sets the User field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetUser(v string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.User = &v
	return s
}

// SetVolumesFrom sets the VolumesFrom field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetVolumesFrom(v []*AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.VolumesFrom = v
	return s
}

// SetWorkingDirectory sets the WorkingDirectory field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsDetails) SetWorkingDirectory(v string) *AwsEcsTaskDefinitionContainerDefinitionsDetails {
	s.WorkingDirectory = &v
	return s
}

// An environment variable to pass to the container.
type AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails struct {
	_ struct{} `type:"structure"`

	// The name of the environment variable.
	Name *string `type:"string"`

	// The value of the environment variable.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails) SetName(v string) *AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails) SetValue(v string) *AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails {
	s.Value = &v
	return s
}

// A file that contain environment variables to pass to a container.
type AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails struct {
	_ struct{} `type:"structure"`

	// The type of environment file.
	Type *string `type:"string"`

	// The ARN of the S3 object that contains the environment variable file.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails) SetType(v string) *AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails) SetValue(v string) *AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails {
	s.Value = &v
	return s
}

// A hostname and IP address mapping to append to the /etc/hosts file on the
// container.
type AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails struct {
	_ struct{} `type:"structure"`

	// The hostname to use in the /etc/hosts entry.
	Hostname *string `type:"string"`

	// The IP address to use in the /etc/hosts entry.
	IpAddress *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails) GoString() string {
	return s.String()
}

// SetHostname sets the Hostname field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails) SetHostname(v string) *AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails {
	s.Hostname = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails) SetIpAddress(v string) *AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails {
	s.IpAddress = &v
	return s
}

// The FireLens configuration for the container. The configuration specifies
// and configures a log router for container logs.
type AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// The options to use to configure the log router.
	//
	// The valid option keys are as follows:
	//
	//    * enable-ecs-log-metadata. The value can be true or false.
	//
	//    * config-file-type. The value can be s3 or file.
	//
	//    * config-file-value. The value is either an S3 ARN or a file path.
	Options map[string]*string `type:"map"`

	// The log router to use.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails) SetOptions(v map[string]*string) *AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails {
	s.Options = v
	return s
}

// SetType sets the Type field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails) SetType(v string) *AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails {
	s.Type = &v
	return s
}

// The container health check command and associated configuration parameters
// for the container.
type AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails struct {
	_ struct{} `type:"structure"`

	// The command that the container runs to determine whether it is healthy.
	Command []*string `type:"list"`

	// The time period in seconds between each health check execution. The default
	// value is 30 seconds.
	Interval *int64 `type:"integer"`

	// The number of times to retry a failed health check before the container is
	// considered unhealthy. The default value is 3.
	Retries *int64 `type:"integer"`

	// The optional grace period in seconds that allows containers time to bootstrap
	// before failed health checks count towards the maximum number of retries.
	StartPeriod *int64 `type:"integer"`

	// The time period in seconds to wait for a health check to succeed before it
	// is considered a failure. The default value is 5.
	Timeout *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails) GoString() string {
	return s.String()
}

// SetCommand sets the Command field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails) SetCommand(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails {
	s.Command = v
	return s
}

// SetInterval sets the Interval field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails) SetInterval(v int64) *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails {
	s.Interval = &v
	return s
}

// SetRetries sets the Retries field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails) SetRetries(v int64) *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails {
	s.Retries = &v
	return s
}

// SetStartPeriod sets the StartPeriod field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails) SetStartPeriod(v int64) *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails {
	s.StartPeriod = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails) SetTimeout(v int64) *AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails {
	s.Timeout = &v
	return s
}

// The Linux capabilities for the container that are added to or dropped from
// the default configuration provided by Docker.
type AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails struct {
	_ struct{} `type:"structure"`

	// The Linux capabilities for the container that are added to the default configuration
	// provided by Docker.
	Add []*string `type:"list"`

	// The Linux capabilities for the container that are dropped from the default
	// configuration provided by Docker.
	Drop []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails) GoString() string {
	return s.String()
}

// SetAdd sets the Add field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails) SetAdd(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails {
	s.Add = v
	return s
}

// SetDrop sets the Drop field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails) SetDrop(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails {
	s.Drop = v
	return s
}

// >Linux-specific modifications that are applied to the container, such as
// Linux kernel capabilities.
type AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails struct {
	_ struct{} `type:"structure"`

	// The Linux capabilities for the container that are added to or dropped from
	// the default configuration provided by Docker.
	Capabilities *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails `type:"structure"`

	// The host devices to expose to the container.
	Devices []*AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails `type:"list"`

	// Whether to run an init process inside the container that forwards signals
	// and reaps processes.
	InitProcessEnabled *bool `type:"boolean"`

	// The total amount of swap memory (in MiB) that a container can use.
	MaxSwap *int64 `type:"integer"`

	// The value for the size (in MiB) of the /dev/shm volume.
	SharedMemorySize *int64 `type:"integer"`

	// Configures the container's memory swappiness behavior. Determines how aggressively
	// pages are swapped. The higher the value, the more aggressive the swappiness.
	// The default is 60.
	Swappiness *int64 `type:"integer"`

	// The container path, mount options, and size (in MiB) of the tmpfs mount.
	Tmpfs []*AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) SetCapabilities(v *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
	s.Capabilities = v
	return s
}

// SetDevices sets the Devices field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) SetDevices(v []*AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
	s.Devices = v
	return s
}

// SetInitProcessEnabled sets the InitProcessEnabled field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) SetInitProcessEnabled(v bool) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
	s.InitProcessEnabled = &v
	return s
}

// SetMaxSwap sets the MaxSwap field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) SetMaxSwap(v int64) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
	s.MaxSwap = &v
	return s
}

// SetSharedMemorySize sets the SharedMemorySize field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) SetSharedMemorySize(v int64) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
	s.SharedMemorySize = &v
	return s
}

// SetSwappiness sets the Swappiness field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) SetSwappiness(v int64) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
	s.Swappiness = &v
	return s
}

// SetTmpfs sets the Tmpfs field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails) SetTmpfs(v []*AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails {
	s.Tmpfs = v
	return s
}

// A host device to expose to the container.
type AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails struct {
	_ struct{} `type:"structure"`

	// The path inside the container at which to expose the host device.
	ContainerPath *string `type:"string"`

	// The path for the device on the host container instance.
	HostPath *string `type:"string"`

	// The explicit permissions to provide to the container for the device. By default,
	// the container has permissions for read, write, and mknod for the device.
	Permissions []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails) GoString() string {
	return s.String()
}

// SetContainerPath sets the ContainerPath field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails) SetContainerPath(v string) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails {
	s.ContainerPath = &v
	return s
}

// SetHostPath sets the HostPath field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails) SetHostPath(v string) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails {
	s.HostPath = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails) SetPermissions(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails {
	s.Permissions = v
	return s
}

// The container path, mount options, and size (in MiB) of a tmpfs mount.
type AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails struct {
	_ struct{} `type:"structure"`

	// The absolute file path where the tmpfs volume is to be mounted.
	ContainerPath *string `type:"string"`

	// The list of tmpfs volume mount options.
	MountOptions []*string `type:"list"`

	// The maximum size (in MiB) of the tmpfs volume.
	Size *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails) GoString() string {
	return s.String()
}

// SetContainerPath sets the ContainerPath field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails) SetContainerPath(v string) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails {
	s.ContainerPath = &v
	return s
}

// SetMountOptions sets the MountOptions field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails) SetMountOptions(v []*string) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails {
	s.MountOptions = v
	return s
}

// SetSize sets the Size field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails) SetSize(v int64) *AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails {
	s.Size = &v
	return s
}

// The log configuration specification for the container.
type AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// The log driver to use for the container.
	LogDriver *string `type:"string"`

	// The configuration options to send to the log driver. Requires version 1.19
	// of the Docker Remote API or greater on your container instance.
	Options map[string]*string `type:"map"`

	// The secrets to pass to the log configuration.
	SecretOptions []*AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails) GoString() string {
	return s.String()
}

// SetLogDriver sets the LogDriver field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails) SetLogDriver(v string) *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails {
	s.LogDriver = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails) SetOptions(v map[string]*string) *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails {
	s.Options = v
	return s
}

// SetSecretOptions sets the SecretOptions field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails) SetSecretOptions(v []*AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails) *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails {
	s.SecretOptions = v
	return s
}

// A secret to pass to the log configuration.
type AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails struct {
	_ struct{} `type:"structure"`

	// The name of the secret.
	Name *string `type:"string"`

	// The secret to expose to the container.
	//
	// The value is either the full ARN of the Secrets Manager secret or the full
	// ARN of the parameter in the Systems Manager Parameter Store.
	ValueFrom *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails) SetName(v string) *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails {
	s.Name = &v
	return s
}

// SetValueFrom sets the ValueFrom field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails) SetValueFrom(v string) *AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails {
	s.ValueFrom = &v
	return s
}

// A mount point for the data volumes in the container.
type AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails struct {
	_ struct{} `type:"structure"`

	// The path on the container to mount the host volume at.
	ContainerPath *string `type:"string"`

	// Whether the container has read-only access to the volume.
	ReadOnly *bool `type:"boolean"`

	// The name of the volume to mount. Must match the name of a volume listed in
	// VolumeDetails for the task definition.
	SourceVolume *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails) GoString() string {
	return s.String()
}

// SetContainerPath sets the ContainerPath field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails) SetContainerPath(v string) *AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails {
	s.ContainerPath = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails) SetReadOnly(v bool) *AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails {
	s.ReadOnly = &v
	return s
}

// SetSourceVolume sets the SourceVolume field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails) SetSourceVolume(v string) *AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails {
	s.SourceVolume = &v
	return s
}

// A port mapping for the container.
type AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails struct {
	_ struct{} `type:"structure"`

	// The port number on the container that is bound to the user-specified or automatically
	// assigned host port.
	ContainerPort *int64 `type:"integer"`

	// The port number on the container instance to reserve for the container.
	HostPort *int64 `type:"integer"`

	// The protocol used for the port mapping. The default is tcp.
	Protocol *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails) GoString() string {
	return s.String()
}

// SetContainerPort sets the ContainerPort field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails) SetContainerPort(v int64) *AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails {
	s.ContainerPort = &v
	return s
}

// SetHostPort sets the HostPort field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails) SetHostPort(v int64) *AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails {
	s.HostPort = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails) SetProtocol(v string) *AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails {
	s.Protocol = &v
	return s
}

// The private repository authentication credentials to use.
type AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret that contains the private repository credentials.
	CredentialsParameter *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails) GoString() string {
	return s.String()
}

// SetCredentialsParameter sets the CredentialsParameter field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails) SetCredentialsParameter(v string) *AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails {
	s.CredentialsParameter = &v
	return s
}

// A resource to assign to a container.
type AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails struct {
	_ struct{} `type:"structure"`

	// The type of resource to assign to a container.
	Type *string `type:"string"`

	// The value for the specified resource type.
	//
	// For GPU, the value is the number of physical GPUs the Amazon ECS container
	// agent reserves for the container.
	//
	// For InferenceAccelerator, the value should match the DeviceName attribute
	// of an entry in InferenceAccelerators.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails) SetType(v string) *AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails) SetValue(v string) *AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails {
	s.Value = &v
	return s
}

// A secret to pass to the container.
type AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails struct {
	_ struct{} `type:"structure"`

	// The name of the secret.
	Name *string `type:"string"`

	// The secret to expose to the container. The value is either the full ARN of
	// the Secrets Manager secret or the full ARN of the parameter in the Systems
	// Manager Parameter Store.
	ValueFrom *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails) SetName(v string) *AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails {
	s.Name = &v
	return s
}

// SetValueFrom sets the ValueFrom field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails) SetValueFrom(v string) *AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails {
	s.ValueFrom = &v
	return s
}

// A namespaced kernel parameter to set in the container.
type AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails struct {
	_ struct{} `type:"structure"`

	// The namespaced kernel parameter for which to set a value.
	Namespace *string `type:"string"`

	// The value of the parameter.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails) GoString() string {
	return s.String()
}

// SetNamespace sets the Namespace field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails) SetNamespace(v string) *AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails {
	s.Namespace = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails) SetValue(v string) *AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails {
	s.Value = &v
	return s
}

// A ulimit to set in the container.
type AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails struct {
	_ struct{} `type:"structure"`

	// The hard limit for the ulimit type.
	HardLimit *int64 `type:"integer"`

	// The type of the ulimit.
	Name *string `type:"string"`

	// The soft limit for the ulimit type.
	SoftLimit *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails) GoString() string {
	return s.String()
}

// SetHardLimit sets the HardLimit field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails) SetHardLimit(v int64) *AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails {
	s.HardLimit = &v
	return s
}

// SetName sets the Name field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails) SetName(v string) *AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails {
	s.Name = &v
	return s
}

// SetSoftLimit sets the SoftLimit field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails) SetSoftLimit(v int64) *AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails {
	s.SoftLimit = &v
	return s
}

// A data volume to mount from another container.
type AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails struct {
	_ struct{} `type:"structure"`

	// Whether the container has read-only access to the volume.
	ReadOnly *bool `type:"boolean"`

	// The name of another container within the same task definition from which
	// to mount volumes.
	SourceContainer *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails) GoString() string {
	return s.String()
}

// SetReadOnly sets the ReadOnly field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails) SetReadOnly(v bool) *AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails {
	s.ReadOnly = &v
	return s
}

// SetSourceContainer sets the SourceContainer field's value.
func (s *AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails) SetSourceContainer(v string) *AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails {
	s.SourceContainer = &v
	return s
}

// details about a task definition. A task definition describes the container
// and volume definitions of an Amazon Elastic Container Service task.
type AwsEcsTaskDefinitionDetails struct {
	_ struct{} `type:"structure"`

	// The container definitions that describe the containers that make up the task.
	ContainerDefinitions []*AwsEcsTaskDefinitionContainerDefinitionsDetails `type:"list"`

	// The number of CPU units used by the task.
	Cpu *string `type:"string"`

	// The ARN of the task execution role that grants the container agent permission
	// to make API calls on behalf of the container user.
	ExecutionRoleArn *string `type:"string"`

	// The name of a family that this task definition is registered to.
	Family *string `type:"string"`

	// The Elastic Inference accelerators to use for the containers in the task.
	InferenceAccelerators []*AwsEcsTaskDefinitionInferenceAcceleratorsDetails `type:"list"`

	// The IPC resource namespace to use for the containers in the task.
	IpcMode *string `type:"string"`

	// The amount (in MiB) of memory used by the task.
	Memory *string `type:"string"`

	// The Docker networking mode to use for the containers in the task.
	NetworkMode *string `type:"string"`

	// The process namespace to use for the containers in the task.
	PidMode *string `type:"string"`

	// The placement constraint objects to use for tasks.
	PlacementConstraints []*AwsEcsTaskDefinitionPlacementConstraintsDetails `type:"list"`

	// The configuration details for the App Mesh proxy.
	ProxyConfiguration *AwsEcsTaskDefinitionProxyConfigurationDetails `type:"structure"`

	// The task launch types that the task definition was validated against.
	RequiresCompatibilities []*string `type:"list"`

	// The short name or ARN of the IAM role that grants containers in the task
	// permission to call Amazon Web Services API operations on your behalf.
	TaskRoleArn *string `type:"string"`

	// The data volume definitions for the task.
	Volumes []*AwsEcsTaskDefinitionVolumesDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionDetails) GoString() string {
	return s.String()
}

// SetContainerDefinitions sets the ContainerDefinitions field's value.
func (s *AwsEcsTaskDefinitionDetails) SetContainerDefinitions(v []*AwsEcsTaskDefinitionContainerDefinitionsDetails) *AwsEcsTaskDefinitionDetails {
	s.ContainerDefinitions = v
	return s
}

// SetCpu sets the Cpu field's value.
func (s *AwsEcsTaskDefinitionDetails) SetCpu(v string) *AwsEcsTaskDefinitionDetails {
	s.Cpu = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *AwsEcsTaskDefinitionDetails) SetExecutionRoleArn(v string) *AwsEcsTaskDefinitionDetails {
	s.ExecutionRoleArn = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *AwsEcsTaskDefinitionDetails) SetFamily(v string) *AwsEcsTaskDefinitionDetails {
	s.Family = &v
	return s
}

// SetInferenceAccelerators sets the InferenceAccelerators field's value.
func (s *AwsEcsTaskDefinitionDetails) SetInferenceAccelerators(v []*AwsEcsTaskDefinitionInferenceAcceleratorsDetails) *AwsEcsTaskDefinitionDetails {
	s.InferenceAccelerators = v
	return s
}

// SetIpcMode sets the IpcMode field's value.
func (s *AwsEcsTaskDefinitionDetails) SetIpcMode(v string) *AwsEcsTaskDefinitionDetails {
	s.IpcMode = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *AwsEcsTaskDefinitionDetails) SetMemory(v string) *AwsEcsTaskDefinitionDetails {
	s.Memory = &v
	return s
}

// SetNetworkMode sets the NetworkMode field's value.
func (s *AwsEcsTaskDefinitionDetails) SetNetworkMode(v string) *AwsEcsTaskDefinitionDetails {
	s.NetworkMode = &v
	return s
}

// SetPidMode sets the PidMode field's value.
func (s *AwsEcsTaskDefinitionDetails) SetPidMode(v string) *AwsEcsTaskDefinitionDetails {
	s.PidMode = &v
	return s
}

// SetPlacementConstraints sets the PlacementConstraints field's value.
func (s *AwsEcsTaskDefinitionDetails) SetPlacementConstraints(v []*AwsEcsTaskDefinitionPlacementConstraintsDetails) *AwsEcsTaskDefinitionDetails {
	s.PlacementConstraints = v
	return s
}

// SetProxyConfiguration sets the ProxyConfiguration field's value.
func (s *AwsEcsTaskDefinitionDetails) SetProxyConfiguration(v *AwsEcsTaskDefinitionProxyConfigurationDetails) *AwsEcsTaskDefinitionDetails {
	s.ProxyConfiguration = v
	return s
}

// SetRequiresCompatibilities sets the RequiresCompatibilities field's value.
func (s *AwsEcsTaskDefinitionDetails) SetRequiresCompatibilities(v []*string) *AwsEcsTaskDefinitionDetails {
	s.RequiresCompatibilities = v
	return s
}

// SetTaskRoleArn sets the TaskRoleArn field's value.
func (s *AwsEcsTaskDefinitionDetails) SetTaskRoleArn(v string) *AwsEcsTaskDefinitionDetails {
	s.TaskRoleArn = &v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *AwsEcsTaskDefinitionDetails) SetVolumes(v []*AwsEcsTaskDefinitionVolumesDetails) *AwsEcsTaskDefinitionDetails {
	s.Volumes = v
	return s
}

// An Elastic Inference accelerator to use for the containers in the task.
type AwsEcsTaskDefinitionInferenceAcceleratorsDetails struct {
	_ struct{} `type:"structure"`

	// The Elastic Inference accelerator device name.
	DeviceName *string `type:"string"`

	// The Elastic Inference accelerator type to use.
	DeviceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionInferenceAcceleratorsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionInferenceAcceleratorsDetails) GoString() string {
	return s.String()
}

// SetDeviceName sets the DeviceName field's value.
func (s *AwsEcsTaskDefinitionInferenceAcceleratorsDetails) SetDeviceName(v string) *AwsEcsTaskDefinitionInferenceAcceleratorsDetails {
	s.DeviceName = &v
	return s
}

// SetDeviceType sets the DeviceType field's value.
func (s *AwsEcsTaskDefinitionInferenceAcceleratorsDetails) SetDeviceType(v string) *AwsEcsTaskDefinitionInferenceAcceleratorsDetails {
	s.DeviceType = &v
	return s
}

// A placement constraint object to use for tasks.
type AwsEcsTaskDefinitionPlacementConstraintsDetails struct {
	_ struct{} `type:"structure"`

	// A cluster query language expression to apply to the constraint.
	Expression *string `type:"string"`

	// The type of constraint.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionPlacementConstraintsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionPlacementConstraintsDetails) GoString() string {
	return s.String()
}

// SetExpression sets the Expression field's value.
func (s *AwsEcsTaskDefinitionPlacementConstraintsDetails) SetExpression(v string) *AwsEcsTaskDefinitionPlacementConstraintsDetails {
	s.Expression = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsEcsTaskDefinitionPlacementConstraintsDetails) SetType(v string) *AwsEcsTaskDefinitionPlacementConstraintsDetails {
	s.Type = &v
	return s
}

// The configuration details for the App Mesh proxy.
type AwsEcsTaskDefinitionProxyConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// The name of the container that will serve as the App Mesh proxy.
	ContainerName *string `type:"string"`

	// The set of network configuration parameters to provide to the Container Network
	// Interface (CNI) plugin, specified as key-value pairs.
	ProxyConfigurationProperties []*AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails `type:"list"`

	// The proxy type.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionProxyConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionProxyConfigurationDetails) GoString() string {
	return s.String()
}

// SetContainerName sets the ContainerName field's value.
func (s *AwsEcsTaskDefinitionProxyConfigurationDetails) SetContainerName(v string) *AwsEcsTaskDefinitionProxyConfigurationDetails {
	s.ContainerName = &v
	return s
}

// SetProxyConfigurationProperties sets the ProxyConfigurationProperties field's value.
func (s *AwsEcsTaskDefinitionProxyConfigurationDetails) SetProxyConfigurationProperties(v []*AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails) *AwsEcsTaskDefinitionProxyConfigurationDetails {
	s.ProxyConfigurationProperties = v
	return s
}

// SetType sets the Type field's value.
func (s *AwsEcsTaskDefinitionProxyConfigurationDetails) SetType(v string) *AwsEcsTaskDefinitionProxyConfigurationDetails {
	s.Type = &v
	return s
}

// A network configuration parameter to provide to the Container Network Interface
// (CNI) plugin.
type AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails struct {
	_ struct{} `type:"structure"`

	// The name of the property.
	Name *string `type:"string"`

	// The value of the property.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails) SetName(v string) *AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails) SetValue(v string) *AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails {
	s.Value = &v
	return s
}

// A data volume to mount from another container.
type AwsEcsTaskDefinitionVolumesDetails struct {
	_ struct{} `type:"structure"`

	// Information about a Docker volume.
	DockerVolumeConfiguration *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails `type:"structure"`

	// Information about the Amazon Elastic File System file system that is used
	// for task storage.
	EfsVolumeConfiguration *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails `type:"structure"`

	// Information about a bind mount host volume.
	Host *AwsEcsTaskDefinitionVolumesHostDetails `type:"structure"`

	// The name of the data volume.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesDetails) GoString() string {
	return s.String()
}

// SetDockerVolumeConfiguration sets the DockerVolumeConfiguration field's value.
func (s *AwsEcsTaskDefinitionVolumesDetails) SetDockerVolumeConfiguration(v *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails) *AwsEcsTaskDefinitionVolumesDetails {
	s.DockerVolumeConfiguration = v
	return s
}

// SetEfsVolumeConfiguration sets the EfsVolumeConfiguration field's value.
func (s *AwsEcsTaskDefinitionVolumesDetails) SetEfsVolumeConfiguration(v *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails) *AwsEcsTaskDefinitionVolumesDetails {
	s.EfsVolumeConfiguration = v
	return s
}

// SetHost sets the Host field's value.
func (s *AwsEcsTaskDefinitionVolumesDetails) SetHost(v *AwsEcsTaskDefinitionVolumesHostDetails) *AwsEcsTaskDefinitionVolumesDetails {
	s.Host = v
	return s
}

// SetName sets the Name field's value.
func (s *AwsEcsTaskDefinitionVolumesDetails) SetName(v string) *AwsEcsTaskDefinitionVolumesDetails {
	s.Name = &v
	return s
}

// Information about a Docker volume.
type AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// Whether to create the Docker volume automatically if it does not already
	// exist.
	Autoprovision *bool `type:"boolean"`

	// The Docker volume driver to use.
	Driver *string `type:"string"`

	// A map of Docker driver-specific options that are passed through.
	DriverOpts map[string]*string `type:"map"`

	// Custom metadata to add to the Docker volume.
	Labels map[string]*string `type:"map"`

	// The scope for the Docker volume that determines its lifecycle. Docker volumes
	// that are scoped to a task are provisioned automatically when the task starts
	// and destroyed when the task stops. Docker volumes that are shared persist
	// after the task stops.
	Scope *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails) GoString() string {
	return s.String()
}

// SetAutoprovision sets the Autoprovision field's value.
func (s *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails) SetAutoprovision(v bool) *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails {
	s.Autoprovision = &v
	return s
}

// SetDriver sets the Driver field's value.
func (s *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails) SetDriver(v string) *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails {
	s.Driver = &v
	return s
}

// SetDriverOpts sets the DriverOpts field's value.
func (s *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails) SetDriverOpts(v map[string]*string) *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails {
	s.DriverOpts = v
	return s
}

// SetLabels sets the Labels field's value.
func (s *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails) SetLabels(v map[string]*string) *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails {
	s.Labels = v
	return s
}

// SetScope sets the Scope field's value.
func (s *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails) SetScope(v string) *AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails {
	s.Scope = &v
	return s
}

type AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails struct {
	_ struct{} `type:"structure"`

	// The Amazon EFS access point identifier to use.
	AccessPointId *string `type:"string"`

	// Whether to use the Amazon ECS task IAM role defined in a task definition
	// when mounting the Amazon EFS file system.
	Iam *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails) GoString() string {
	return s.String()
}

// SetAccessPointId sets the AccessPointId field's value.
func (s *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails) SetAccessPointId(v string) *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails {
	s.AccessPointId = &v
	return s
}

// SetIam sets the Iam field's value.
func (s *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails) SetIam(v string) *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails {
	s.Iam = &v
	return s
}

// Information about the Amazon Elastic File System file system that is used
// for task storage.
type AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// The authorization configuration details for the Amazon EFS file system.
	AuthorizationConfig *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails `type:"structure"`

	// The Amazon EFS file system identifier to use.
	FilesystemId *string `type:"string"`

	// The directory within the Amazon EFS file system to mount as the root directory
	// inside the host.
	RootDirectory *string `type:"string"`

	// Whether to enable encryption for Amazon EFS data in transit between the Amazon
	// ECS host and the Amazon EFS server.
	TransitEncryption *string `type:"string"`

	// The port to use when sending encrypted data between the Amazon ECS host and
	// the Amazon EFS server.
	TransitEncryptionPort *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails) GoString() string {
	return s.String()
}

// SetAuthorizationConfig sets the AuthorizationConfig field's value.
func (s *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails) SetAuthorizationConfig(v *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails) *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails {
	s.AuthorizationConfig = v
	return s
}

// SetFilesystemId sets the FilesystemId field's value.
func (s *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails) SetFilesystemId(v string) *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails {
	s.FilesystemId = &v
	return s
}

// SetRootDirectory sets the RootDirectory field's value.
func (s *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails) SetRootDirectory(v string) *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails {
	s.RootDirectory = &v
	return s
}

// SetTransitEncryption sets the TransitEncryption field's value.
func (s *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails) SetTransitEncryption(v string) *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails {
	s.TransitEncryption = &v
	return s
}

// SetTransitEncryptionPort sets the TransitEncryptionPort field's value.
func (s *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails) SetTransitEncryptionPort(v int64) *AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails {
	s.TransitEncryptionPort = &v
	return s
}

// Information about a bind mount host volume.
type AwsEcsTaskDefinitionVolumesHostDetails struct {
	_ struct{} `type:"structure"`

	// The path on the host container instance that is presented to the container.
	SourcePath *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesHostDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcsTaskDefinitionVolumesHostDetails) GoString() string {
	return s.String()
}

// SetSourcePath sets the SourcePath field's value.
func (s *AwsEcsTaskDefinitionVolumesHostDetails) SetSourcePath(v string) *AwsEcsTaskDefinitionVolumesHostDetails {
	s.SourcePath = &v
	return s
}

// Provides details about an Amazon EKS cluster.
type AwsEksClusterDetails struct {
	_ struct{} `type:"structure"`

	// The ARN of the cluster.
	Arn *string `type:"string"`

	// The certificate authority data for the cluster.
	CertificateAuthorityData *string `type:"string"`

	// The status of the cluster.
	ClusterStatus *string `type:"string"`

	// The endpoint for the Amazon EKS API server.
	Endpoint *string `type:"string"`

	// The logging configuration for the cluster.
	Logging *AwsEksClusterLoggingDetails `type:"structure"`

	// The name of the cluster.
	Name *string `type:"string"`

	// The VPC configuration used by the cluster control plane.
	ResourcesVpcConfig *AwsEksClusterResourcesVpcConfigDetails `type:"structure"`

	// The ARN of the IAM role that provides permissions for the Amazon EKS control
	// plane to make calls to Amazon Web Services API operations on your behalf.
	RoleArn *string `type:"string"`

	// The Amazon EKS server version for the cluster.
	Version *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEksClusterDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEksClusterDetails) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AwsEksClusterDetails) SetArn(v string) *AwsEksClusterDetails {
	s.Arn = &v
	return s
}

// SetCertificateAuthorityData sets the CertificateAuthorityData field's value.
func (s *AwsEksClusterDetails) SetCertificateAuthorityData(v string) *AwsEksClusterDetails {
	s.CertificateAuthorityData = &v
	return s
}

// SetClusterStatus sets the ClusterStatus field's value.
func (s *AwsEksClusterDetails) SetClusterStatus(v string) *AwsEksClusterDetails {
	s.ClusterStatus = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *AwsEksClusterDetails) SetEndpoint(v string) *AwsEksClusterDetails {
	s.Endpoint = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *AwsEksClusterDetails) SetLogging(v *AwsEksClusterLoggingDetails) *AwsEksClusterDetails {
	s.Logging = v
	return s
}

// SetName sets the Name field's value.
func (s *AwsEksClusterDetails) SetName(v string) *AwsEksClusterDetails {
	s.Name = &v
	return s
}

// SetResourcesVpcConfig sets the ResourcesVpcConfig field's value.
func (s *AwsEksClusterDetails) SetResourcesVpcConfig(v *AwsEksClusterResourcesVpcConfigDetails) *AwsEksClusterDetails {
	s.ResourcesVpcConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AwsEksClusterDetails) SetRoleArn(v string) *AwsEksClusterDetails {
	s.RoleArn = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsEksClusterDetails) SetVersion(v string) *AwsEksClusterDetails {
	s.Version = &v
	return s
}

// Details for a cluster logging configuration.
type AwsEksClusterLoggingClusterLoggingDetails struct {
	_ struct{} `type:"structure"`

	// Whether the logging types that are listed in Types are enabled.
	Enabled *bool `type:"boolean"`

	// A list of logging types.
	Types []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEksClusterLoggingClusterLoggingDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEksClusterLoggingClusterLoggingDetails) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AwsEksClusterLoggingClusterLoggingDetails) SetEnabled(v bool) *AwsEksClusterLoggingClusterLoggingDetails {
	s.Enabled = &v
	return s
}

// SetTypes sets the Types field's value.
func (s *AwsEksClusterLoggingClusterLoggingDetails) SetTypes(v []*string) *AwsEksClusterLoggingClusterLoggingDetails {
	s.Types = v
	return s
}

// The logging configuration for an Amazon EKS cluster.
type AwsEksClusterLoggingDetails struct {
	_ struct{} `type:"structure"`

	// Cluster logging configurations.
	ClusterLogging []*AwsEksClusterLoggingClusterLoggingDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEksClusterLoggingDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEksClusterLoggingDetails) GoString() string {
	return s.String()
}

// SetClusterLogging sets the ClusterLogging field's value.
func (s *AwsEksClusterLoggingDetails) SetClusterLogging(v []*AwsEksClusterLoggingClusterLoggingDetails) *AwsEksClusterLoggingDetails {
	s.ClusterLogging = v
	return s
}

// Information about the VPC configuration used by the cluster control plane.
type AwsEksClusterResourcesVpcConfigDetails struct {
	_ struct{} `type:"structure"`

	// The security groups that are associated with the cross-account elastic network
	// interfaces that are used to allow communication between your nodes and the
	// Amazon EKS control plane.
	SecurityGroupIds []*string `type:"list"`

	// The subnets that are associated with the cluster.
	SubnetIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEksClusterResourcesVpcConfigDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEksClusterResourcesVpcConfigDetails) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *AwsEksClusterResourcesVpcConfigDetails) SetSecurityGroupIds(v []*string) *AwsEksClusterResourcesVpcConfigDetails {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *AwsEksClusterResourcesVpcConfigDetails) SetSubnetIds(v []*string) *AwsEksClusterResourcesVpcConfigDetails {
	s.SubnetIds = v
	return s
}

// Contains details about an Elastic Beanstalk environment.
type AwsElasticBeanstalkEnvironmentDetails struct {
	_ struct{} `type:"structure"`

	// The name of the application that is associated with the environment.
	ApplicationName *string `type:"string"`

	// The URL to the CNAME for this environment.
	Cname *string `type:"string"`

	// The creation date for this environment.
	DateCreated *string `type:"string"`

	// The date when this environment was last modified.
	DateUpdated *string `type:"string"`

	// A description of the environment.
	Description *string `type:"string"`

	// For load-balanced, autoscaling environments, the URL to the load balancer.
	// For single-instance environments, the IP address of the instance.
	EndpointUrl *string `type:"string"`

	// The ARN of the environment.
	EnvironmentArn *string `type:"string"`

	// The identifier of the environment.
	EnvironmentId *string `type:"string"`

	// Links to other environments in the same group.
	EnvironmentLinks []*AwsElasticBeanstalkEnvironmentEnvironmentLink `type:"list"`

	// The name of the environment.
	EnvironmentName *string `type:"string"`

	// The configuration setting for the environment.
	OptionSettings []*AwsElasticBeanstalkEnvironmentOptionSetting `type:"list"`

	// The ARN of the platform version for the environment.
	PlatformArn *string `type:"string"`

	// The name of the solution stack that is deployed with the environment.
	SolutionStackName *string `type:"string"`

	// The current operational status of the environment.
	Status *string `type:"string"`

	// The tier of the environment.
	Tier *AwsElasticBeanstalkEnvironmentTier `type:"structure"`

	// The application version of the environment.
	VersionLabel *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticBeanstalkEnvironmentDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticBeanstalkEnvironmentDetails) GoString() string {
	return s.String()
}

// SetApplicationName sets the ApplicationName field's value.
func (s *AwsElasticBeanstalkEnvironmentDetails) SetApplicationName(v string) *AwsElasticBeanstalkEnvironmentDetails {
	s.ApplicationName = &v
	return s
}

// SetCname sets the Cname field's value.
func (s *AwsElasticBeanstalkEnvironmentDetails) SetCname(v string) *AwsElasticBeanstalkEnvironmentDetails {
	s.Cname = &v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *AwsElasticBeanstalkEnvironmentDetails) SetDateCreated(v string) *AwsElasticBeanstalkEnvironmentDetails {
	s.DateCreated = &v
	return s
}

// SetDateUpdated sets the DateUpdated field's value.
func (s *AwsElasticBeanstalkEnvironmentDetails) SetDateUpdated(v string) *AwsElasticBeanstalkEnvironmentDetails {
	s.DateUpdated = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsElasticBeanstalkEnvironmentDetails) SetDescription(v string) *AwsElasticBeanstalkEnvironmentDetails {
	s.Description = &v
	return s
}

// SetEndpointUrl sets the EndpointUrl field's value.
func (s *AwsElasticBeanstalkEnvironmentDetails) SetEndpointUrl(v string) *AwsElasticBeanstalkEnvironmentDetails {
	s.EndpointUrl = &v
	return s
}

// SetEnvironmentArn sets the EnvironmentArn field's value.
func (s *AwsElasticBeanstalkEnvironmentDetails) SetEnvironmentArn(v string) *AwsElasticBeanstalkEnvironmentDetails {
	s.EnvironmentArn = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *AwsElasticBeanstalkEnvironmentDetails) SetEnvironmentId(v string) *AwsElasticBeanstalkEnvironmentDetails {
	s.EnvironmentId = &v
	return s
}

// SetEnvironmentLinks sets the EnvironmentLinks field's value.
func (s *AwsElasticBeanstalkEnvironmentDetails) SetEnvironmentLinks(v []*AwsElasticBeanstalkEnvironmentEnvironmentLink) *AwsElasticBeanstalkEnvironmentDetails {
	s.EnvironmentLinks = v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *AwsElasticBeanstalkEnvironmentDetails) SetEnvironmentName(v string) *AwsElasticBeanstalkEnvironmentDetails {
	s.EnvironmentName = &v
	return s
}

// SetOptionSettings sets the OptionSettings field's value.
func (s *AwsElasticBeanstalkEnvironmentDetails) SetOptionSettings(v []*AwsElasticBeanstalkEnvironmentOptionSetting) *AwsElasticBeanstalkEnvironmentDetails {
	s.OptionSettings = v
	return s
}

// SetPlatformArn sets the PlatformArn field's value.
func (s *AwsElasticBeanstalkEnvironmentDetails) SetPlatformArn(v string) *AwsElasticBeanstalkEnvironmentDetails {
	s.PlatformArn = &v
	return s
}

// SetSolutionStackName sets the SolutionStackName field's value.
func (s *AwsElasticBeanstalkEnvironmentDetails) SetSolutionStackName(v string) *AwsElasticBeanstalkEnvironmentDetails {
	s.SolutionStackName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsElasticBeanstalkEnvironmentDetails) SetStatus(v string) *AwsElasticBeanstalkEnvironmentDetails {
	s.Status = &v
	return s
}

// SetTier sets the Tier field's value.
func (s *AwsElasticBeanstalkEnvironmentDetails) SetTier(v *AwsElasticBeanstalkEnvironmentTier) *AwsElasticBeanstalkEnvironmentDetails {
	s.Tier = v
	return s
}

// SetVersionLabel sets the VersionLabel field's value.
func (s *AwsElasticBeanstalkEnvironmentDetails) SetVersionLabel(v string) *AwsElasticBeanstalkEnvironmentDetails {
	s.VersionLabel = &v
	return s
}

// Contains information about a link to another environment that is in the same
// group.
type AwsElasticBeanstalkEnvironmentEnvironmentLink struct {
	_ struct{} `type:"structure"`

	// The name of the linked environment.
	EnvironmentName *string `type:"string"`

	// The name of the environment link.
	LinkName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticBeanstalkEnvironmentEnvironmentLink) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticBeanstalkEnvironmentEnvironmentLink) GoString() string {
	return s.String()
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *AwsElasticBeanstalkEnvironmentEnvironmentLink) SetEnvironmentName(v string) *AwsElasticBeanstalkEnvironmentEnvironmentLink {
	s.EnvironmentName = &v
	return s
}

// SetLinkName sets the LinkName field's value.
func (s *AwsElasticBeanstalkEnvironmentEnvironmentLink) SetLinkName(v string) *AwsElasticBeanstalkEnvironmentEnvironmentLink {
	s.LinkName = &v
	return s
}

// A configuration option setting for the environment.
type AwsElasticBeanstalkEnvironmentOptionSetting struct {
	_ struct{} `type:"structure"`

	// The type of resource that the configuration option is associated with.
	Namespace *string `type:"string"`

	// The name of the option.
	OptionName *string `type:"string"`

	// The name of the resource.
	ResourceName *string `type:"string"`

	// The value of the configuration setting.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticBeanstalkEnvironmentOptionSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticBeanstalkEnvironmentOptionSetting) GoString() string {
	return s.String()
}

// SetNamespace sets the Namespace field's value.
func (s *AwsElasticBeanstalkEnvironmentOptionSetting) SetNamespace(v string) *AwsElasticBeanstalkEnvironmentOptionSetting {
	s.Namespace = &v
	return s
}

// SetOptionName sets the OptionName field's value.
func (s *AwsElasticBeanstalkEnvironmentOptionSetting) SetOptionName(v string) *AwsElasticBeanstalkEnvironmentOptionSetting {
	s.OptionName = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *AwsElasticBeanstalkEnvironmentOptionSetting) SetResourceName(v string) *AwsElasticBeanstalkEnvironmentOptionSetting {
	s.ResourceName = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsElasticBeanstalkEnvironmentOptionSetting) SetValue(v string) *AwsElasticBeanstalkEnvironmentOptionSetting {
	s.Value = &v
	return s
}

// Contains information about the tier of the environment.
type AwsElasticBeanstalkEnvironmentTier struct {
	_ struct{} `type:"structure"`

	// The name of the environment tier.
	Name *string `type:"string"`

	// The type of environment tier.
	Type *string `type:"string"`

	// The version of the environment tier.
	Version *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticBeanstalkEnvironmentTier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticBeanstalkEnvironmentTier) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsElasticBeanstalkEnvironmentTier) SetName(v string) *AwsElasticBeanstalkEnvironmentTier {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsElasticBeanstalkEnvironmentTier) SetType(v string) *AwsElasticBeanstalkEnvironmentTier {
	s.Type = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsElasticBeanstalkEnvironmentTier) SetVersion(v string) *AwsElasticBeanstalkEnvironmentTier {
	s.Version = &v
	return s
}

// Information about an Elasticsearch domain.
type AwsElasticsearchDomainDetails struct {
	_ struct{} `type:"structure"`

	// IAM policy document specifying the access policies for the new Elasticsearch
	// domain.
	AccessPolicies *string `type:"string"`

	// Additional options for the domain endpoint.
	DomainEndpointOptions *AwsElasticsearchDomainDomainEndpointOptions `type:"structure"`

	// Unique identifier for an Elasticsearch domain.
	DomainId *string `type:"string"`

	// Name of an Elasticsearch domain.
	//
	// Domain names are unique across all domains owned by the same account within
	// an Amazon Web Services Region.
	//
	// Domain names must start with a lowercase letter and must be between 3 and
	// 28 characters.
	//
	// Valid characters are a-z (lowercase only), 0-9, and – (hyphen).
	DomainName *string `type:"string"`

	// Information about an OpenSearch cluster configuration.
	ElasticsearchClusterConfig *AwsElasticsearchDomainElasticsearchClusterConfigDetails `type:"structure"`

	// OpenSearch version.
	ElasticsearchVersion *string `type:"string"`

	// Details about the configuration for encryption at rest.
	EncryptionAtRestOptions *AwsElasticsearchDomainEncryptionAtRestOptions `type:"structure"`

	// Domain-specific endpoint used to submit index, search, and data upload requests
	// to an Elasticsearch domain.
	//
	// The endpoint is a service URL.
	Endpoint *string `type:"string"`

	// The key-value pair that exists if the Elasticsearch domain uses VPC endpoints.
	Endpoints map[string]*string `type:"map"`

	// Configures the CloudWatch Logs to publish for the Elasticsearch domain.
	LogPublishingOptions *AwsElasticsearchDomainLogPublishingOptions `type:"structure"`

	// Details about the configuration for node-to-node encryption.
	NodeToNodeEncryptionOptions *AwsElasticsearchDomainNodeToNodeEncryptionOptions `type:"structure"`

	// Information about the status of a domain relative to the latest service software.
	ServiceSoftwareOptions *AwsElasticsearchDomainServiceSoftwareOptions `type:"structure"`

	// Information that OpenSearch derives based on VPCOptions for the domain.
	VPCOptions *AwsElasticsearchDomainVPCOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainDetails) GoString() string {
	return s.String()
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *AwsElasticsearchDomainDetails) SetAccessPolicies(v string) *AwsElasticsearchDomainDetails {
	s.AccessPolicies = &v
	return s
}

// SetDomainEndpointOptions sets the DomainEndpointOptions field's value.
func (s *AwsElasticsearchDomainDetails) SetDomainEndpointOptions(v *AwsElasticsearchDomainDomainEndpointOptions) *AwsElasticsearchDomainDetails {
	s.DomainEndpointOptions = v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *AwsElasticsearchDomainDetails) SetDomainId(v string) *AwsElasticsearchDomainDetails {
	s.DomainId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *AwsElasticsearchDomainDetails) SetDomainName(v string) *AwsElasticsearchDomainDetails {
	s.DomainName = &v
	return s
}

// SetElasticsearchClusterConfig sets the ElasticsearchClusterConfig field's value.
func (s *AwsElasticsearchDomainDetails) SetElasticsearchClusterConfig(v *AwsElasticsearchDomainElasticsearchClusterConfigDetails) *AwsElasticsearchDomainDetails {
	s.ElasticsearchClusterConfig = v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *AwsElasticsearchDomainDetails) SetElasticsearchVersion(v string) *AwsElasticsearchDomainDetails {
	s.ElasticsearchVersion = &v
	return s
}

// SetEncryptionAtRestOptions sets the EncryptionAtRestOptions field's value.
func (s *AwsElasticsearchDomainDetails) SetEncryptionAtRestOptions(v *AwsElasticsearchDomainEncryptionAtRestOptions) *AwsElasticsearchDomainDetails {
	s.EncryptionAtRestOptions = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *AwsElasticsearchDomainDetails) SetEndpoint(v string) *AwsElasticsearchDomainDetails {
	s.Endpoint = &v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *AwsElasticsearchDomainDetails) SetEndpoints(v map[string]*string) *AwsElasticsearchDomainDetails {
	s.Endpoints = v
	return s
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *AwsElasticsearchDomainDetails) SetLogPublishingOptions(v *AwsElasticsearchDomainLogPublishingOptions) *AwsElasticsearchDomainDetails {
	s.LogPublishingOptions = v
	return s
}

// SetNodeToNodeEncryptionOptions sets the NodeToNodeEncryptionOptions field's value.
func (s *AwsElasticsearchDomainDetails) SetNodeToNodeEncryptionOptions(v *AwsElasticsearchDomainNodeToNodeEncryptionOptions) *AwsElasticsearchDomainDetails {
	s.NodeToNodeEncryptionOptions = v
	return s
}

// SetServiceSoftwareOptions sets the ServiceSoftwareOptions field's value.
func (s *AwsElasticsearchDomainDetails) SetServiceSoftwareOptions(v *AwsElasticsearchDomainServiceSoftwareOptions) *AwsElasticsearchDomainDetails {
	s.ServiceSoftwareOptions = v
	return s
}

// SetVPCOptions sets the VPCOptions field's value.
func (s *AwsElasticsearchDomainDetails) SetVPCOptions(v *AwsElasticsearchDomainVPCOptions) *AwsElasticsearchDomainDetails {
	s.VPCOptions = v
	return s
}

// Additional options for the domain endpoint, such as whether to require HTTPS
// for all traffic.
type AwsElasticsearchDomainDomainEndpointOptions struct {
	_ struct{} `type:"structure"`

	// Whether to require that all traffic to the domain arrive over HTTPS.
	EnforceHTTPS *bool `type:"boolean"`

	// The TLS security policy to apply to the HTTPS endpoint of the OpenSearch
	// domain.
	//
	// Valid values:
	//
	//    * Policy-Min-TLS-1-0-2019-07, which supports TLSv1.0 and higher
	//
	//    * Policy-Min-TLS-1-2-2019-07, which only supports TLSv1.2
	TLSSecurityPolicy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainDomainEndpointOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainDomainEndpointOptions) GoString() string {
	return s.String()
}

// SetEnforceHTTPS sets the EnforceHTTPS field's value.
func (s *AwsElasticsearchDomainDomainEndpointOptions) SetEnforceHTTPS(v bool) *AwsElasticsearchDomainDomainEndpointOptions {
	s.EnforceHTTPS = &v
	return s
}

// SetTLSSecurityPolicy sets the TLSSecurityPolicy field's value.
func (s *AwsElasticsearchDomainDomainEndpointOptions) SetTLSSecurityPolicy(v string) *AwsElasticsearchDomainDomainEndpointOptions {
	s.TLSSecurityPolicy = &v
	return s
}

// details about the configuration of an OpenSearch cluster.
type AwsElasticsearchDomainElasticsearchClusterConfigDetails struct {
	_ struct{} `type:"structure"`

	// The number of instances to use for the master node. If this attribute is
	// specified, then DedicatedMasterEnabled must be true.
	DedicatedMasterCount *int64 `type:"integer"`

	// Whether to use a dedicated master node for the Elasticsearch domain. A dedicated
	// master node performs cluster management tasks, but doesn't hold data or respond
	// to data upload requests.
	DedicatedMasterEnabled *bool `type:"boolean"`

	// The hardware configuration of the computer that hosts the dedicated master
	// node. For example, m3.medium.elasticsearch. If this attribute is specified,
	// then DedicatedMasterEnabled must be true.
	DedicatedMasterType *string `type:"string"`

	// The number of data nodes to use in the Elasticsearch domain.
	InstanceCount *int64 `type:"integer"`

	// The instance type for your data nodes. For example, m3.medium.elasticsearch.
	InstanceType *string `type:"string"`

	// Configuration options for zone awareness. Provided if ZoneAwarenessEnabled
	// is true.
	ZoneAwarenessConfig *AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails `type:"structure"`

	// Whether to enable zone awareness for the Elasticsearch domain. When zone
	// awareness is enabled, OpenSearch allocates the cluster's nodes and replica
	// index shards across Availability Zones in the same Region. This prevents
	// data loss and minimizes downtime if a node or data center fails.
	ZoneAwarenessEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainElasticsearchClusterConfigDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainElasticsearchClusterConfigDetails) GoString() string {
	return s.String()
}

// SetDedicatedMasterCount sets the DedicatedMasterCount field's value.
func (s *AwsElasticsearchDomainElasticsearchClusterConfigDetails) SetDedicatedMasterCount(v int64) *AwsElasticsearchDomainElasticsearchClusterConfigDetails {
	s.DedicatedMasterCount = &v
	return s
}

// SetDedicatedMasterEnabled sets the DedicatedMasterEnabled field's value.
func (s *AwsElasticsearchDomainElasticsearchClusterConfigDetails) SetDedicatedMasterEnabled(v bool) *AwsElasticsearchDomainElasticsearchClusterConfigDetails {
	s.DedicatedMasterEnabled = &v
	return s
}

// SetDedicatedMasterType sets the DedicatedMasterType field's value.
func (s *AwsElasticsearchDomainElasticsearchClusterConfigDetails) SetDedicatedMasterType(v string) *AwsElasticsearchDomainElasticsearchClusterConfigDetails {
	s.DedicatedMasterType = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *AwsElasticsearchDomainElasticsearchClusterConfigDetails) SetInstanceCount(v int64) *AwsElasticsearchDomainElasticsearchClusterConfigDetails {
	s.InstanceCount = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *AwsElasticsearchDomainElasticsearchClusterConfigDetails) SetInstanceType(v string) *AwsElasticsearchDomainElasticsearchClusterConfigDetails {
	s.InstanceType = &v
	return s
}

// SetZoneAwarenessConfig sets the ZoneAwarenessConfig field's value.
func (s *AwsElasticsearchDomainElasticsearchClusterConfigDetails) SetZoneAwarenessConfig(v *AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails) *AwsElasticsearchDomainElasticsearchClusterConfigDetails {
	s.ZoneAwarenessConfig = v
	return s
}

// SetZoneAwarenessEnabled sets the ZoneAwarenessEnabled field's value.
func (s *AwsElasticsearchDomainElasticsearchClusterConfigDetails) SetZoneAwarenessEnabled(v bool) *AwsElasticsearchDomainElasticsearchClusterConfigDetails {
	s.ZoneAwarenessEnabled = &v
	return s
}

// Configuration options for zone awareness.
type AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails struct {
	_ struct{} `type:"structure"`

	// he number of Availability Zones that the domain uses. Valid values are 2
	// and 3. The default is 2.
	AvailabilityZoneCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails) GoString() string {
	return s.String()
}

// SetAvailabilityZoneCount sets the AvailabilityZoneCount field's value.
func (s *AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails) SetAvailabilityZoneCount(v int64) *AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails {
	s.AvailabilityZoneCount = &v
	return s
}

// Details about the configuration for encryption at rest.
type AwsElasticsearchDomainEncryptionAtRestOptions struct {
	_ struct{} `type:"structure"`

	// Whether encryption at rest is enabled.
	Enabled *bool `type:"boolean"`

	// The KMS key ID. Takes the form 1a2a3a4-1a2a-3a4a-5a6a-1a2a3a4a5a6a.
	KmsKeyId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainEncryptionAtRestOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainEncryptionAtRestOptions) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AwsElasticsearchDomainEncryptionAtRestOptions) SetEnabled(v bool) *AwsElasticsearchDomainEncryptionAtRestOptions {
	s.Enabled = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsElasticsearchDomainEncryptionAtRestOptions) SetKmsKeyId(v string) *AwsElasticsearchDomainEncryptionAtRestOptions {
	s.KmsKeyId = &v
	return s
}

// configures the CloudWatch Logs to publish for the Elasticsearch domain.
type AwsElasticsearchDomainLogPublishingOptions struct {
	_ struct{} `type:"structure"`

	// The log configuration.
	AuditLogs *AwsElasticsearchDomainLogPublishingOptionsLogConfig `type:"structure"`

	// Configures the OpenSearch index logs publishing.
	IndexSlowLogs *AwsElasticsearchDomainLogPublishingOptionsLogConfig `type:"structure"`

	// Configures the OpenSearch search slow log publishing.
	SearchSlowLogs *AwsElasticsearchDomainLogPublishingOptionsLogConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainLogPublishingOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainLogPublishingOptions) GoString() string {
	return s.String()
}

// SetAuditLogs sets the AuditLogs field's value.
func (s *AwsElasticsearchDomainLogPublishingOptions) SetAuditLogs(v *AwsElasticsearchDomainLogPublishingOptionsLogConfig) *AwsElasticsearchDomainLogPublishingOptions {
	s.AuditLogs = v
	return s
}

// SetIndexSlowLogs sets the IndexSlowLogs field's value.
func (s *AwsElasticsearchDomainLogPublishingOptions) SetIndexSlowLogs(v *AwsElasticsearchDomainLogPublishingOptionsLogConfig) *AwsElasticsearchDomainLogPublishingOptions {
	s.IndexSlowLogs = v
	return s
}

// SetSearchSlowLogs sets the SearchSlowLogs field's value.
func (s *AwsElasticsearchDomainLogPublishingOptions) SetSearchSlowLogs(v *AwsElasticsearchDomainLogPublishingOptionsLogConfig) *AwsElasticsearchDomainLogPublishingOptions {
	s.SearchSlowLogs = v
	return s
}

// The log configuration.
type AwsElasticsearchDomainLogPublishingOptionsLogConfig struct {
	_ struct{} `type:"structure"`

	// The ARN of the CloudWatch Logs group to publish the logs to.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Whether the log publishing is enabled.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainLogPublishingOptionsLogConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainLogPublishingOptionsLogConfig) GoString() string {
	return s.String()
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *AwsElasticsearchDomainLogPublishingOptionsLogConfig) SetCloudWatchLogsLogGroupArn(v string) *AwsElasticsearchDomainLogPublishingOptionsLogConfig {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AwsElasticsearchDomainLogPublishingOptionsLogConfig) SetEnabled(v bool) *AwsElasticsearchDomainLogPublishingOptionsLogConfig {
	s.Enabled = &v
	return s
}

// Details about the configuration for node-to-node encryption.
type AwsElasticsearchDomainNodeToNodeEncryptionOptions struct {
	_ struct{} `type:"structure"`

	// Whether node-to-node encryption is enabled.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainNodeToNodeEncryptionOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainNodeToNodeEncryptionOptions) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AwsElasticsearchDomainNodeToNodeEncryptionOptions) SetEnabled(v bool) *AwsElasticsearchDomainNodeToNodeEncryptionOptions {
	s.Enabled = &v
	return s
}

// Information about the state of the domain relative to the latest service
// software.
type AwsElasticsearchDomainServiceSoftwareOptions struct {
	_ struct{} `type:"structure"`

	// The epoch time when the deployment window closes for required updates. After
	// this time, Amazon OpenSearch Service schedules the software upgrade automatically.
	AutomatedUpdateDate *string `type:"string"`

	// Whether a request to update the domain can be canceled.
	Cancellable *bool `type:"boolean"`

	// The version of the service software that is currently installed on the domain.
	CurrentVersion *string `type:"string"`

	// A more detailed description of the service software status.
	Description *string `type:"string"`

	// The most recent version of the service software.
	NewVersion *string `type:"string"`

	// Whether a service software update is available for the domain.
	UpdateAvailable *bool `type:"boolean"`

	// The status of the service software update.
	UpdateStatus *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainServiceSoftwareOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainServiceSoftwareOptions) GoString() string {
	return s.String()
}

// SetAutomatedUpdateDate sets the AutomatedUpdateDate field's value.
func (s *AwsElasticsearchDomainServiceSoftwareOptions) SetAutomatedUpdateDate(v string) *AwsElasticsearchDomainServiceSoftwareOptions {
	s.AutomatedUpdateDate = &v
	return s
}

// SetCancellable sets the Cancellable field's value.
func (s *AwsElasticsearchDomainServiceSoftwareOptions) SetCancellable(v bool) *AwsElasticsearchDomainServiceSoftwareOptions {
	s.Cancellable = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *AwsElasticsearchDomainServiceSoftwareOptions) SetCurrentVersion(v string) *AwsElasticsearchDomainServiceSoftwareOptions {
	s.CurrentVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsElasticsearchDomainServiceSoftwareOptions) SetDescription(v string) *AwsElasticsearchDomainServiceSoftwareOptions {
	s.Description = &v
	return s
}

// SetNewVersion sets the NewVersion field's value.
func (s *AwsElasticsearchDomainServiceSoftwareOptions) SetNewVersion(v string) *AwsElasticsearchDomainServiceSoftwareOptions {
	s.NewVersion = &v
	return s
}

// SetUpdateAvailable sets the UpdateAvailable field's value.
func (s *AwsElasticsearchDomainServiceSoftwareOptions) SetUpdateAvailable(v bool) *AwsElasticsearchDomainServiceSoftwareOptions {
	s.UpdateAvailable = &v
	return s
}

// SetUpdateStatus sets the UpdateStatus field's value.
func (s *AwsElasticsearchDomainServiceSoftwareOptions) SetUpdateStatus(v string) *AwsElasticsearchDomainServiceSoftwareOptions {
	s.UpdateStatus = &v
	return s
}

// Information that OpenSearch derives based on VPCOptions for the domain.
type AwsElasticsearchDomainVPCOptions struct {
	_ struct{} `type:"structure"`

	// The list of Availability Zones associated with the VPC subnets.
	AvailabilityZones []*string `type:"list"`

	// The list of security group IDs associated with the VPC endpoints for the
	// domain.
	SecurityGroupIds []*string `type:"list"`

	// A list of subnet IDs associated with the VPC endpoints for the domain.
	SubnetIds []*string `type:"list"`

	// ID for the VPC.
	VPCId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainVPCOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElasticsearchDomainVPCOptions) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *AwsElasticsearchDomainVPCOptions) SetAvailabilityZones(v []*string) *AwsElasticsearchDomainVPCOptions {
	s.AvailabilityZones = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *AwsElasticsearchDomainVPCOptions) SetSecurityGroupIds(v []*string) *AwsElasticsearchDomainVPCOptions {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *AwsElasticsearchDomainVPCOptions) SetSubnetIds(v []*string) *AwsElasticsearchDomainVPCOptions {
	s.SubnetIds = v
	return s
}

// SetVPCId sets the VPCId field's value.
func (s *AwsElasticsearchDomainVPCOptions) SetVPCId(v string) *AwsElasticsearchDomainVPCOptions {
	s.VPCId = &v
	return s
}

// Contains information about a stickiness policy that was created using CreateAppCookieStickinessPolicy.
type AwsElbAppCookieStickinessPolicy struct {
	_ struct{} `type:"structure"`

	// The name of the application cookie used for stickiness.
	CookieName *string `type:"string"`

	// The mnemonic name for the policy being created. The name must be unique within
	// the set of policies for the load balancer.
	PolicyName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbAppCookieStickinessPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbAppCookieStickinessPolicy) GoString() string {
	return s.String()
}

// SetCookieName sets the CookieName field's value.
func (s *AwsElbAppCookieStickinessPolicy) SetCookieName(v string) *AwsElbAppCookieStickinessPolicy {
	s.CookieName = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *AwsElbAppCookieStickinessPolicy) SetPolicyName(v string) *AwsElbAppCookieStickinessPolicy {
	s.PolicyName = &v
	return s
}

// Contains information about a stickiness policy that was created using CreateLBCookieStickinessPolicy.
type AwsElbLbCookieStickinessPolicy struct {
	_ struct{} `type:"structure"`

	// The amount of time, in seconds, after which the cookie is considered stale.
	// If an expiration period is not specified, the stickiness session lasts for
	// the duration of the browser session.
	CookieExpirationPeriod *int64 `type:"long"`

	// The name of the policy. The name must be unique within the set of policies
	// for the load balancer.
	PolicyName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLbCookieStickinessPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLbCookieStickinessPolicy) GoString() string {
	return s.String()
}

// SetCookieExpirationPeriod sets the CookieExpirationPeriod field's value.
func (s *AwsElbLbCookieStickinessPolicy) SetCookieExpirationPeriod(v int64) *AwsElbLbCookieStickinessPolicy {
	s.CookieExpirationPeriod = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *AwsElbLbCookieStickinessPolicy) SetPolicyName(v string) *AwsElbLbCookieStickinessPolicy {
	s.PolicyName = &v
	return s
}

// Contains information about the access log configuration for the load balancer.
type AwsElbLoadBalancerAccessLog struct {
	_ struct{} `type:"structure"`

	// The interval in minutes for publishing the access logs.
	//
	// You can publish access logs either every 5 minutes or every 60 minutes.
	EmitInterval *int64 `type:"integer"`

	// Indicates whether access logs are enabled for the load balancer.
	Enabled *bool `type:"boolean"`

	// The name of the S3 bucket where the access logs are stored.
	S3BucketName *string `type:"string"`

	// The logical hierarchy that was created for the S3 bucket.
	//
	// If a prefix is not provided, the log is placed at the root level of the bucket.
	S3BucketPrefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerAccessLog) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerAccessLog) GoString() string {
	return s.String()
}

// SetEmitInterval sets the EmitInterval field's value.
func (s *AwsElbLoadBalancerAccessLog) SetEmitInterval(v int64) *AwsElbLoadBalancerAccessLog {
	s.EmitInterval = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AwsElbLoadBalancerAccessLog) SetEnabled(v bool) *AwsElbLoadBalancerAccessLog {
	s.Enabled = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *AwsElbLoadBalancerAccessLog) SetS3BucketName(v string) *AwsElbLoadBalancerAccessLog {
	s.S3BucketName = &v
	return s
}

// SetS3BucketPrefix sets the S3BucketPrefix field's value.
func (s *AwsElbLoadBalancerAccessLog) SetS3BucketPrefix(v string) *AwsElbLoadBalancerAccessLog {
	s.S3BucketPrefix = &v
	return s
}

// Provides information about additional attributes for the load balancer.
type AwsElbLoadBalancerAdditionalAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	Key *string `type:"string"`

	// The value of the attribute.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerAdditionalAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerAdditionalAttribute) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *AwsElbLoadBalancerAdditionalAttribute) SetKey(v string) *AwsElbLoadBalancerAdditionalAttribute {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsElbLoadBalancerAdditionalAttribute) SetValue(v string) *AwsElbLoadBalancerAdditionalAttribute {
	s.Value = &v
	return s
}

// Contains attributes for the load balancer.
type AwsElbLoadBalancerAttributes struct {
	_ struct{} `type:"structure"`

	// Information about the access log configuration for the load balancer.
	//
	// If the access log is enabled, the load balancer captures detailed information
	// about all requests. It delivers the information to a specified S3 bucket.
	AccessLog *AwsElbLoadBalancerAccessLog `type:"structure"`

	// Any additional attributes for a load balancer.
	AdditionalAttributes []*AwsElbLoadBalancerAdditionalAttribute `type:"list"`

	// Information about the connection draining configuration for the load balancer.
	//
	// If connection draining is enabled, the load balancer allows existing requests
	// to complete before it shifts traffic away from a deregistered or unhealthy
	// instance.
	ConnectionDraining *AwsElbLoadBalancerConnectionDraining `type:"structure"`

	// Connection settings for the load balancer.
	//
	// If an idle timeout is configured, the load balancer allows connections to
	// remain idle for the specified duration. When a connection is idle, no data
	// is sent over the connection.
	ConnectionSettings *AwsElbLoadBalancerConnectionSettings `type:"structure"`

	// Cross-zone load balancing settings for the load balancer.
	//
	// If cross-zone load balancing is enabled, the load balancer routes the request
	// traffic evenly across all instances regardless of the Availability Zones.
	CrossZoneLoadBalancing *AwsElbLoadBalancerCrossZoneLoadBalancing `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerAttributes) GoString() string {
	return s.String()
}

// SetAccessLog sets the AccessLog field's value.
func (s *AwsElbLoadBalancerAttributes) SetAccessLog(v *AwsElbLoadBalancerAccessLog) *AwsElbLoadBalancerAttributes {
	s.AccessLog = v
	return s
}

// SetAdditionalAttributes sets the AdditionalAttributes field's value.
func (s *AwsElbLoadBalancerAttributes) SetAdditionalAttributes(v []*AwsElbLoadBalancerAdditionalAttribute) *AwsElbLoadBalancerAttributes {
	s.AdditionalAttributes = v
	return s
}

// SetConnectionDraining sets the ConnectionDraining field's value.
func (s *AwsElbLoadBalancerAttributes) SetConnectionDraining(v *AwsElbLoadBalancerConnectionDraining) *AwsElbLoadBalancerAttributes {
	s.ConnectionDraining = v
	return s
}

// SetConnectionSettings sets the ConnectionSettings field's value.
func (s *AwsElbLoadBalancerAttributes) SetConnectionSettings(v *AwsElbLoadBalancerConnectionSettings) *AwsElbLoadBalancerAttributes {
	s.ConnectionSettings = v
	return s
}

// SetCrossZoneLoadBalancing sets the CrossZoneLoadBalancing field's value.
func (s *AwsElbLoadBalancerAttributes) SetCrossZoneLoadBalancing(v *AwsElbLoadBalancerCrossZoneLoadBalancing) *AwsElbLoadBalancerAttributes {
	s.CrossZoneLoadBalancing = v
	return s
}

// Provides information about the configuration of an EC2 instance for the load
// balancer.
type AwsElbLoadBalancerBackendServerDescription struct {
	_ struct{} `type:"structure"`

	// The port on which the EC2 instance is listening.
	InstancePort *int64 `type:"integer"`

	// The names of the policies that are enabled for the EC2 instance.
	PolicyNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerBackendServerDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerBackendServerDescription) GoString() string {
	return s.String()
}

// SetInstancePort sets the InstancePort field's value.
func (s *AwsElbLoadBalancerBackendServerDescription) SetInstancePort(v int64) *AwsElbLoadBalancerBackendServerDescription {
	s.InstancePort = &v
	return s
}

// SetPolicyNames sets the PolicyNames field's value.
func (s *AwsElbLoadBalancerBackendServerDescription) SetPolicyNames(v []*string) *AwsElbLoadBalancerBackendServerDescription {
	s.PolicyNames = v
	return s
}

// Contains information about the connection draining configuration for the
// load balancer.
type AwsElbLoadBalancerConnectionDraining struct {
	_ struct{} `type:"structure"`

	// Indicates whether connection draining is enabled for the load balancer.
	Enabled *bool `type:"boolean"`

	// The maximum time, in seconds, to keep the existing connections open before
	// deregistering the instances.
	Timeout *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerConnectionDraining) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerConnectionDraining) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AwsElbLoadBalancerConnectionDraining) SetEnabled(v bool) *AwsElbLoadBalancerConnectionDraining {
	s.Enabled = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *AwsElbLoadBalancerConnectionDraining) SetTimeout(v int64) *AwsElbLoadBalancerConnectionDraining {
	s.Timeout = &v
	return s
}

// Contains connection settings for the load balancer.
type AwsElbLoadBalancerConnectionSettings struct {
	_ struct{} `type:"structure"`

	// The time, in seconds, that the connection can be idle (no data is sent over
	// the connection) before it is closed by the load balancer.
	IdleTimeout *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerConnectionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerConnectionSettings) GoString() string {
	return s.String()
}

// SetIdleTimeout sets the IdleTimeout field's value.
func (s *AwsElbLoadBalancerConnectionSettings) SetIdleTimeout(v int64) *AwsElbLoadBalancerConnectionSettings {
	s.IdleTimeout = &v
	return s
}

// Contains cross-zone load balancing settings for the load balancer.
type AwsElbLoadBalancerCrossZoneLoadBalancing struct {
	_ struct{} `type:"structure"`

	// Indicates whether cross-zone load balancing is enabled for the load balancer.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerCrossZoneLoadBalancing) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerCrossZoneLoadBalancing) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AwsElbLoadBalancerCrossZoneLoadBalancing) SetEnabled(v bool) *AwsElbLoadBalancerCrossZoneLoadBalancing {
	s.Enabled = &v
	return s
}

// Contains details about a Classic Load Balancer.
type AwsElbLoadBalancerDetails struct {
	_ struct{} `type:"structure"`

	// The list of Availability Zones for the load balancer.
	AvailabilityZones []*string `type:"list"`

	// Information about the configuration of the EC2 instances.
	BackendServerDescriptions []*AwsElbLoadBalancerBackendServerDescription `type:"list"`

	// The name of the Amazon Route 53 hosted zone for the load balancer.
	CanonicalHostedZoneName *string `type:"string"`

	// The ID of the Amazon Route 53 hosted zone for the load balancer.
	CanonicalHostedZoneNameID *string `type:"string"`

	// Indicates when the load balancer was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedTime *string `type:"string"`

	// The DNS name of the load balancer.
	DnsName *string `type:"string"`

	// Information about the health checks that are conducted on the load balancer.
	HealthCheck *AwsElbLoadBalancerHealthCheck `type:"structure"`

	// List of EC2 instances for the load balancer.
	Instances []*AwsElbLoadBalancerInstance `type:"list"`

	// The policies that are enabled for the load balancer listeners.
	ListenerDescriptions []*AwsElbLoadBalancerListenerDescription `type:"list"`

	// The attributes for a load balancer.
	LoadBalancerAttributes *AwsElbLoadBalancerAttributes `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string"`

	// The policies for a load balancer.
	Policies *AwsElbLoadBalancerPolicies `type:"structure"`

	// The type of load balancer. Only provided if the load balancer is in a VPC.
	//
	// If Scheme is internet-facing, the load balancer has a public DNS name that
	// resolves to a public IP address.
	//
	// If Scheme is internal, the load balancer has a public DNS name that resolves
	// to a private IP address.
	Scheme *string `type:"string"`

	// The security groups for the load balancer. Only provided if the load balancer
	// is in a VPC.
	SecurityGroups []*string `type:"list"`

	// Information about the security group for the load balancer. This is the security
	// group that is used for inbound rules.
	SourceSecurityGroup *AwsElbLoadBalancerSourceSecurityGroup `type:"structure"`

	// The list of subnet identifiers for the load balancer.
	Subnets []*string `type:"list"`

	// The identifier of the VPC for the load balancer.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerDetails) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *AwsElbLoadBalancerDetails) SetAvailabilityZones(v []*string) *AwsElbLoadBalancerDetails {
	s.AvailabilityZones = v
	return s
}

// SetBackendServerDescriptions sets the BackendServerDescriptions field's value.
func (s *AwsElbLoadBalancerDetails) SetBackendServerDescriptions(v []*AwsElbLoadBalancerBackendServerDescription) *AwsElbLoadBalancerDetails {
	s.BackendServerDescriptions = v
	return s
}

// SetCanonicalHostedZoneName sets the CanonicalHostedZoneName field's value.
func (s *AwsElbLoadBalancerDetails) SetCanonicalHostedZoneName(v string) *AwsElbLoadBalancerDetails {
	s.CanonicalHostedZoneName = &v
	return s
}

// SetCanonicalHostedZoneNameID sets the CanonicalHostedZoneNameID field's value.
func (s *AwsElbLoadBalancerDetails) SetCanonicalHostedZoneNameID(v string) *AwsElbLoadBalancerDetails {
	s.CanonicalHostedZoneNameID = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *AwsElbLoadBalancerDetails) SetCreatedTime(v string) *AwsElbLoadBalancerDetails {
	s.CreatedTime = &v
	return s
}

// SetDnsName sets the DnsName field's value.
func (s *AwsElbLoadBalancerDetails) SetDnsName(v string) *AwsElbLoadBalancerDetails {
	s.DnsName = &v
	return s
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *AwsElbLoadBalancerDetails) SetHealthCheck(v *AwsElbLoadBalancerHealthCheck) *AwsElbLoadBalancerDetails {
	s.HealthCheck = v
	return s
}

// SetInstances sets the Instances field's value.
func (s *AwsElbLoadBalancerDetails) SetInstances(v []*AwsElbLoadBalancerInstance) *AwsElbLoadBalancerDetails {
	s.Instances = v
	return s
}

// SetListenerDescriptions sets the ListenerDescriptions field's value.
func (s *AwsElbLoadBalancerDetails) SetListenerDescriptions(v []*AwsElbLoadBalancerListenerDescription) *AwsElbLoadBalancerDetails {
	s.ListenerDescriptions = v
	return s
}

// SetLoadBalancerAttributes sets the LoadBalancerAttributes field's value.
func (s *AwsElbLoadBalancerDetails) SetLoadBalancerAttributes(v *AwsElbLoadBalancerAttributes) *AwsElbLoadBalancerDetails {
	s.LoadBalancerAttributes = v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *AwsElbLoadBalancerDetails) SetLoadBalancerName(v string) *AwsElbLoadBalancerDetails {
	s.LoadBalancerName = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *AwsElbLoadBalancerDetails) SetPolicies(v *AwsElbLoadBalancerPolicies) *AwsElbLoadBalancerDetails {
	s.Policies = v
	return s
}

// SetScheme sets the Scheme field's value.
func (s *AwsElbLoadBalancerDetails) SetScheme(v string) *AwsElbLoadBalancerDetails {
	s.Scheme = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *AwsElbLoadBalancerDetails) SetSecurityGroups(v []*string) *AwsElbLoadBalancerDetails {
	s.SecurityGroups = v
	return s
}

// SetSourceSecurityGroup sets the SourceSecurityGroup field's value.
func (s *AwsElbLoadBalancerDetails) SetSourceSecurityGroup(v *AwsElbLoadBalancerSourceSecurityGroup) *AwsElbLoadBalancerDetails {
	s.SourceSecurityGroup = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *AwsElbLoadBalancerDetails) SetSubnets(v []*string) *AwsElbLoadBalancerDetails {
	s.Subnets = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsElbLoadBalancerDetails) SetVpcId(v string) *AwsElbLoadBalancerDetails {
	s.VpcId = &v
	return s
}

// Contains information about the health checks that are conducted on the load
// balancer.
type AwsElbLoadBalancerHealthCheck struct {
	_ struct{} `type:"structure"`

	// The number of consecutive health check successes required before the instance
	// is moved to the Healthy state.
	HealthyThreshold *int64 `type:"integer"`

	// The approximate interval, in seconds, between health checks of an individual
	// instance.
	Interval *int64 `type:"integer"`

	// The instance that is being checked. The target specifies the protocol and
	// port. The available protocols are TCP, SSL, HTTP, and HTTPS. The range of
	// valid ports is 1 through 65535.
	//
	// For the HTTP and HTTPS protocols, the target also specifies the ping path.
	//
	// For the TCP protocol, the target is specified as TCP: <port> .
	//
	// For the SSL protocol, the target is specified as SSL.<port> .
	//
	// For the HTTP and HTTPS protocols, the target is specified as <protocol>:<port>/<path
	// to ping> .
	Target *string `type:"string"`

	// The amount of time, in seconds, during which no response means a failed health
	// check.
	Timeout *int64 `type:"integer"`

	// The number of consecutive health check failures that must occur before the
	// instance is moved to the Unhealthy state.
	UnhealthyThreshold *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerHealthCheck) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerHealthCheck) GoString() string {
	return s.String()
}

// SetHealthyThreshold sets the HealthyThreshold field's value.
func (s *AwsElbLoadBalancerHealthCheck) SetHealthyThreshold(v int64) *AwsElbLoadBalancerHealthCheck {
	s.HealthyThreshold = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *AwsElbLoadBalancerHealthCheck) SetInterval(v int64) *AwsElbLoadBalancerHealthCheck {
	s.Interval = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *AwsElbLoadBalancerHealthCheck) SetTarget(v string) *AwsElbLoadBalancerHealthCheck {
	s.Target = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *AwsElbLoadBalancerHealthCheck) SetTimeout(v int64) *AwsElbLoadBalancerHealthCheck {
	s.Timeout = &v
	return s
}

// SetUnhealthyThreshold sets the UnhealthyThreshold field's value.
func (s *AwsElbLoadBalancerHealthCheck) SetUnhealthyThreshold(v int64) *AwsElbLoadBalancerHealthCheck {
	s.UnhealthyThreshold = &v
	return s
}

// Provides information about an EC2 instance for a load balancer.
type AwsElbLoadBalancerInstance struct {
	_ struct{} `type:"structure"`

	// The instance identifier.
	InstanceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerInstance) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *AwsElbLoadBalancerInstance) SetInstanceId(v string) *AwsElbLoadBalancerInstance {
	s.InstanceId = &v
	return s
}

// Information about a load balancer listener.
type AwsElbLoadBalancerListener struct {
	_ struct{} `type:"structure"`

	// The port on which the instance is listening.
	InstancePort *int64 `type:"integer"`

	// The protocol to use to route traffic to instances.
	//
	// Valid values: HTTP | HTTPS | TCP | SSL
	InstanceProtocol *string `type:"string"`

	// The port on which the load balancer is listening.
	//
	// On EC2-VPC, you can specify any port from the range 1-65535.
	//
	// On EC2-Classic, you can specify any port from the following list: 25, 80,
	// 443, 465, 587, 1024-65535.
	LoadBalancerPort *int64 `type:"integer"`

	// The load balancer transport protocol to use for routing.
	//
	// Valid values: HTTP | HTTPS | TCP | SSL
	Protocol *string `type:"string"`

	// The ARN of the server certificate.
	SslCertificateId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerListener) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerListener) GoString() string {
	return s.String()
}

// SetInstancePort sets the InstancePort field's value.
func (s *AwsElbLoadBalancerListener) SetInstancePort(v int64) *AwsElbLoadBalancerListener {
	s.InstancePort = &v
	return s
}

// SetInstanceProtocol sets the InstanceProtocol field's value.
func (s *AwsElbLoadBalancerListener) SetInstanceProtocol(v string) *AwsElbLoadBalancerListener {
	s.InstanceProtocol = &v
	return s
}

// SetLoadBalancerPort sets the LoadBalancerPort field's value.
func (s *AwsElbLoadBalancerListener) SetLoadBalancerPort(v int64) *AwsElbLoadBalancerListener {
	s.LoadBalancerPort = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *AwsElbLoadBalancerListener) SetProtocol(v string) *AwsElbLoadBalancerListener {
	s.Protocol = &v
	return s
}

// SetSslCertificateId sets the SslCertificateId field's value.
func (s *AwsElbLoadBalancerListener) SetSslCertificateId(v string) *AwsElbLoadBalancerListener {
	s.SslCertificateId = &v
	return s
}

// Lists the policies that are enabled for a load balancer listener.
type AwsElbLoadBalancerListenerDescription struct {
	_ struct{} `type:"structure"`

	// Information about the listener.
	Listener *AwsElbLoadBalancerListener `type:"structure"`

	// The policies enabled for the listener.
	PolicyNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerListenerDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerListenerDescription) GoString() string {
	return s.String()
}

// SetListener sets the Listener field's value.
func (s *AwsElbLoadBalancerListenerDescription) SetListener(v *AwsElbLoadBalancerListener) *AwsElbLoadBalancerListenerDescription {
	s.Listener = v
	return s
}

// SetPolicyNames sets the PolicyNames field's value.
func (s *AwsElbLoadBalancerListenerDescription) SetPolicyNames(v []*string) *AwsElbLoadBalancerListenerDescription {
	s.PolicyNames = v
	return s
}

// Contains information about the policies for a load balancer.
type AwsElbLoadBalancerPolicies struct {
	_ struct{} `type:"structure"`

	// The stickiness policies that are created using CreateAppCookieStickinessPolicy.
	AppCookieStickinessPolicies []*AwsElbAppCookieStickinessPolicy `type:"list"`

	// The stickiness policies that are created using CreateLBCookieStickinessPolicy.
	LbCookieStickinessPolicies []*AwsElbLbCookieStickinessPolicy `type:"list"`

	// The policies other than the stickiness policies.
	OtherPolicies []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerPolicies) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerPolicies) GoString() string {
	return s.String()
}

// SetAppCookieStickinessPolicies sets the AppCookieStickinessPolicies field's value.
func (s *AwsElbLoadBalancerPolicies) SetAppCookieStickinessPolicies(v []*AwsElbAppCookieStickinessPolicy) *AwsElbLoadBalancerPolicies {
	s.AppCookieStickinessPolicies = v
	return s
}

// SetLbCookieStickinessPolicies sets the LbCookieStickinessPolicies field's value.
func (s *AwsElbLoadBalancerPolicies) SetLbCookieStickinessPolicies(v []*AwsElbLbCookieStickinessPolicy) *AwsElbLoadBalancerPolicies {
	s.LbCookieStickinessPolicies = v
	return s
}

// SetOtherPolicies sets the OtherPolicies field's value.
func (s *AwsElbLoadBalancerPolicies) SetOtherPolicies(v []*string) *AwsElbLoadBalancerPolicies {
	s.OtherPolicies = v
	return s
}

// Contains information about the security group for the load balancer.
type AwsElbLoadBalancerSourceSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The name of the security group.
	GroupName *string `type:"string"`

	// The owner of the security group.
	OwnerAlias *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerSourceSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbLoadBalancerSourceSecurityGroup) GoString() string {
	return s.String()
}

// SetGroupName sets the GroupName field's value.
func (s *AwsElbLoadBalancerSourceSecurityGroup) SetGroupName(v string) *AwsElbLoadBalancerSourceSecurityGroup {
	s.GroupName = &v
	return s
}

// SetOwnerAlias sets the OwnerAlias field's value.
func (s *AwsElbLoadBalancerSourceSecurityGroup) SetOwnerAlias(v string) *AwsElbLoadBalancerSourceSecurityGroup {
	s.OwnerAlias = &v
	return s
}

// A load balancer attribute.
type AwsElbv2LoadBalancerAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer attribute.
	Key *string `type:"string"`

	// The value of the load balancer attribute.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbv2LoadBalancerAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbv2LoadBalancerAttribute) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *AwsElbv2LoadBalancerAttribute) SetKey(v string) *AwsElbv2LoadBalancerAttribute {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsElbv2LoadBalancerAttribute) SetValue(v string) *AwsElbv2LoadBalancerAttribute {
	s.Value = &v
	return s
}

// Information about a load balancer.
type AwsElbv2LoadBalancerDetails struct {
	_ struct{} `type:"structure"`

	// The Availability Zones for the load balancer.
	AvailabilityZones []*AvailabilityZone `type:"list"`

	// The ID of the Amazon Route 53 hosted zone associated with the load balancer.
	CanonicalHostedZoneId *string `type:"string"`

	// Indicates when the load balancer was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedTime *string `type:"string"`

	// The public DNS name of the load balancer.
	DNSName *string `type:"string"`

	// The type of IP addresses used by the subnets for your load balancer. The
	// possible values are ipv4 (for IPv4 addresses) and dualstack (for IPv4 and
	// IPv6 addresses).
	IpAddressType *string `type:"string"`

	// Attributes of the load balancer.
	LoadBalancerAttributes []*AwsElbv2LoadBalancerAttribute `type:"list"`

	// The nodes of an Internet-facing load balancer have public IP addresses.
	Scheme *string `type:"string"`

	// The IDs of the security groups for the load balancer.
	SecurityGroups []*string `type:"list"`

	// The state of the load balancer.
	State *LoadBalancerState `type:"structure"`

	// The type of load balancer.
	Type *string `type:"string"`

	// The ID of the VPC for the load balancer.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbv2LoadBalancerDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsElbv2LoadBalancerDetails) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *AwsElbv2LoadBalancerDetails) SetAvailabilityZones(v []*AvailabilityZone) *AwsElbv2LoadBalancerDetails {
	s.AvailabilityZones = v
	return s
}

// SetCanonicalHostedZoneId sets the CanonicalHostedZoneId field's value.
func (s *AwsElbv2LoadBalancerDetails) SetCanonicalHostedZoneId(v string) *AwsElbv2LoadBalancerDetails {
	s.CanonicalHostedZoneId = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *AwsElbv2LoadBalancerDetails) SetCreatedTime(v string) *AwsElbv2LoadBalancerDetails {
	s.CreatedTime = &v
	return s
}

// SetDNSName sets the DNSName field's value.
func (s *AwsElbv2LoadBalancerDetails) SetDNSName(v string) *AwsElbv2LoadBalancerDetails {
	s.DNSName = &v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *AwsElbv2LoadBalancerDetails) SetIpAddressType(v string) *AwsElbv2LoadBalancerDetails {
	s.IpAddressType = &v
	return s
}

// SetLoadBalancerAttributes sets the LoadBalancerAttributes field's value.
func (s *AwsElbv2LoadBalancerDetails) SetLoadBalancerAttributes(v []*AwsElbv2LoadBalancerAttribute) *AwsElbv2LoadBalancerDetails {
	s.LoadBalancerAttributes = v
	return s
}

// SetScheme sets the Scheme field's value.
func (s *AwsElbv2LoadBalancerDetails) SetScheme(v string) *AwsElbv2LoadBalancerDetails {
	s.Scheme = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *AwsElbv2LoadBalancerDetails) SetSecurityGroups(v []*string) *AwsElbv2LoadBalancerDetails {
	s.SecurityGroups = v
	return s
}

// SetState sets the State field's value.
func (s *AwsElbv2LoadBalancerDetails) SetState(v *LoadBalancerState) *AwsElbv2LoadBalancerDetails {
	s.State = v
	return s
}

// SetType sets the Type field's value.
func (s *AwsElbv2LoadBalancerDetails) SetType(v string) *AwsElbv2LoadBalancerDetails {
	s.Type = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsElbv2LoadBalancerDetails) SetVpcId(v string) *AwsElbv2LoadBalancerDetails {
	s.VpcId = &v
	return s
}

// IAM access key details related to a finding.
type AwsIamAccessKeyDetails struct {
	_ struct{} `type:"structure"`

	// The identifier of the access key.
	AccessKeyId *string `type:"string"`

	// The Amazon Web Services account ID of the account for the key.
	AccountId *string `type:"string"`

	// Indicates when the IAM access key was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedAt *string `type:"string"`

	// The ID of the principal associated with an access key.
	PrincipalId *string `type:"string"`

	// The name of the principal.
	PrincipalName *string `type:"string"`

	// The type of principal associated with an access key.
	PrincipalType *string `type:"string"`

	// Information about the session that the key was used for.
	SessionContext *AwsIamAccessKeySessionContext `type:"structure"`

	// The status of the IAM access key related to a finding.
	Status *string `type:"string" enum:"AwsIamAccessKeyStatus"`

	// The user associated with the IAM access key related to a finding.
	//
	// The UserName parameter has been replaced with the PrincipalName parameter
	// because access keys can also be assigned to principals that are not IAM users.
	//
	// Deprecated: This filter is deprecated. Instead, use PrincipalName.
	UserName *string `deprecated:"true" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamAccessKeyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamAccessKeyDetails) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *AwsIamAccessKeyDetails) SetAccessKeyId(v string) *AwsIamAccessKeyDetails {
	s.AccessKeyId = &v
	return s
}

// SetAccountId sets the AccountId field's value.
func (s *AwsIamAccessKeyDetails) SetAccountId(v string) *AwsIamAccessKeyDetails {
	s.AccountId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AwsIamAccessKeyDetails) SetCreatedAt(v string) *AwsIamAccessKeyDetails {
	s.CreatedAt = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *AwsIamAccessKeyDetails) SetPrincipalId(v string) *AwsIamAccessKeyDetails {
	s.PrincipalId = &v
	return s
}

// SetPrincipalName sets the PrincipalName field's value.
func (s *AwsIamAccessKeyDetails) SetPrincipalName(v string) *AwsIamAccessKeyDetails {
	s.PrincipalName = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *AwsIamAccessKeyDetails) SetPrincipalType(v string) *AwsIamAccessKeyDetails {
	s.PrincipalType = &v
	return s
}

// SetSessionContext sets the SessionContext field's value.
func (s *AwsIamAccessKeyDetails) SetSessionContext(v *AwsIamAccessKeySessionContext) *AwsIamAccessKeyDetails {
	s.SessionContext = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsIamAccessKeyDetails) SetStatus(v string) *AwsIamAccessKeyDetails {
	s.Status = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *AwsIamAccessKeyDetails) SetUserName(v string) *AwsIamAccessKeyDetails {
	s.UserName = &v
	return s
}

// Provides information about the session that the key was used for.
type AwsIamAccessKeySessionContext struct {
	_ struct{} `type:"structure"`

	// Attributes of the session that the key was used for.
	Attributes *AwsIamAccessKeySessionContextAttributes `type:"structure"`

	// Information about the entity that created the session.
	SessionIssuer *AwsIamAccessKeySessionContextSessionIssuer `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamAccessKeySessionContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamAccessKeySessionContext) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *AwsIamAccessKeySessionContext) SetAttributes(v *AwsIamAccessKeySessionContextAttributes) *AwsIamAccessKeySessionContext {
	s.Attributes = v
	return s
}

// SetSessionIssuer sets the SessionIssuer field's value.
func (s *AwsIamAccessKeySessionContext) SetSessionIssuer(v *AwsIamAccessKeySessionContextSessionIssuer) *AwsIamAccessKeySessionContext {
	s.SessionIssuer = v
	return s
}

// Attributes of the session that the key was used for.
type AwsIamAccessKeySessionContextAttributes struct {
	_ struct{} `type:"structure"`

	// Indicates when the session was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreationDate *string `type:"string"`

	// Indicates whether the session used multi-factor authentication (MFA).
	MfaAuthenticated *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamAccessKeySessionContextAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamAccessKeySessionContextAttributes) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *AwsIamAccessKeySessionContextAttributes) SetCreationDate(v string) *AwsIamAccessKeySessionContextAttributes {
	s.CreationDate = &v
	return s
}

// SetMfaAuthenticated sets the MfaAuthenticated field's value.
func (s *AwsIamAccessKeySessionContextAttributes) SetMfaAuthenticated(v bool) *AwsIamAccessKeySessionContextAttributes {
	s.MfaAuthenticated = &v
	return s
}

// Information about the entity that created the session.
type AwsIamAccessKeySessionContextSessionIssuer struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Web Services account that created the session.
	AccountId *string `type:"string"`

	// The ARN of the session.
	Arn *string `type:"string"`

	// The principal ID of the principal (user, role, or group) that created the
	// session.
	PrincipalId *string `type:"string"`

	// The type of principal (user, role, or group) that created the session.
	Type *string `type:"string"`

	// The name of the principal that created the session.
	UserName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamAccessKeySessionContextSessionIssuer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamAccessKeySessionContextSessionIssuer) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AwsIamAccessKeySessionContextSessionIssuer) SetAccountId(v string) *AwsIamAccessKeySessionContextSessionIssuer {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *AwsIamAccessKeySessionContextSessionIssuer) SetArn(v string) *AwsIamAccessKeySessionContextSessionIssuer {
	s.Arn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *AwsIamAccessKeySessionContextSessionIssuer) SetPrincipalId(v string) *AwsIamAccessKeySessionContextSessionIssuer {
	s.PrincipalId = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsIamAccessKeySessionContextSessionIssuer) SetType(v string) *AwsIamAccessKeySessionContextSessionIssuer {
	s.Type = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *AwsIamAccessKeySessionContextSessionIssuer) SetUserName(v string) *AwsIamAccessKeySessionContextSessionIssuer {
	s.UserName = &v
	return s
}

// A managed policy that is attached to an IAM principal.
type AwsIamAttachedManagedPolicy struct {
	_ struct{} `type:"structure"`

	// The ARN of the policy.
	PolicyArn *string `type:"string"`

	// The name of the policy.
	PolicyName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamAttachedManagedPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamAttachedManagedPolicy) GoString() string {
	return s.String()
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *AwsIamAttachedManagedPolicy) SetPolicyArn(v string) *AwsIamAttachedManagedPolicy {
	s.PolicyArn = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *AwsIamAttachedManagedPolicy) SetPolicyName(v string) *AwsIamAttachedManagedPolicy {
	s.PolicyName = &v
	return s
}

// Contains details about an IAM group.
type AwsIamGroupDetails struct {
	_ struct{} `type:"structure"`

	// A list of the managed policies that are attached to the IAM group.
	AttachedManagedPolicies []*AwsIamAttachedManagedPolicy `type:"list"`

	// Indicates when the IAM group was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string `type:"string"`

	// The identifier of the IAM group.
	GroupId *string `type:"string"`

	// The name of the IAM group.
	GroupName *string `type:"string"`

	// The list of inline policies that are embedded in the group.
	GroupPolicyList []*AwsIamGroupPolicy `type:"list"`

	// The path to the group.
	Path *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamGroupDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamGroupDetails) GoString() string {
	return s.String()
}

// SetAttachedManagedPolicies sets the AttachedManagedPolicies field's value.
func (s *AwsIamGroupDetails) SetAttachedManagedPolicies(v []*AwsIamAttachedManagedPolicy) *AwsIamGroupDetails {
	s.AttachedManagedPolicies = v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *AwsIamGroupDetails) SetCreateDate(v string) *AwsIamGroupDetails {
	s.CreateDate = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *AwsIamGroupDetails) SetGroupId(v string) *AwsIamGroupDetails {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AwsIamGroupDetails) SetGroupName(v string) *AwsIamGroupDetails {
	s.GroupName = &v
	return s
}

// SetGroupPolicyList sets the GroupPolicyList field's value.
func (s *AwsIamGroupDetails) SetGroupPolicyList(v []*AwsIamGroupPolicy) *AwsIamGroupDetails {
	s.GroupPolicyList = v
	return s
}

// SetPath sets the Path field's value.
func (s *AwsIamGroupDetails) SetPath(v string) *AwsIamGroupDetails {
	s.Path = &v
	return s
}

// A managed policy that is attached to the IAM group.
type AwsIamGroupPolicy struct {
	_ struct{} `type:"structure"`

	// The name of the policy.
	PolicyName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamGroupPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamGroupPolicy) GoString() string {
	return s.String()
}

// SetPolicyName sets the PolicyName field's value.
func (s *AwsIamGroupPolicy) SetPolicyName(v string) *AwsIamGroupPolicy {
	s.PolicyName = &v
	return s
}

// Information about an instance profile.
type AwsIamInstanceProfile struct {
	_ struct{} `type:"structure"`

	// The ARN of the instance profile.
	Arn *string `type:"string"`

	// Indicates when the instance profile was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string `type:"string"`

	// The identifier of the instance profile.
	InstanceProfileId *string `type:"string"`

	// The name of the instance profile.
	InstanceProfileName *string `type:"string"`

	// The path to the instance profile.
	Path *string `type:"string"`

	// The roles associated with the instance profile.
	Roles []*AwsIamInstanceProfileRole `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamInstanceProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamInstanceProfile) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsIamInstanceProfile) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsIamInstanceProfile"}
	if s.Roles != nil {
		for i, v := range s.Roles {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Roles", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *AwsIamInstanceProfile) SetArn(v string) *AwsIamInstanceProfile {
	s.Arn = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *AwsIamInstanceProfile) SetCreateDate(v string) *AwsIamInstanceProfile {
	s.CreateDate = &v
	return s
}

// SetInstanceProfileId sets the InstanceProfileId field's value.
func (s *AwsIamInstanceProfile) SetInstanceProfileId(v string) *AwsIamInstanceProfile {
	s.InstanceProfileId = &v
	return s
}

// SetInstanceProfileName sets the InstanceProfileName field's value.
func (s *AwsIamInstanceProfile) SetInstanceProfileName(v string) *AwsIamInstanceProfile {
	s.InstanceProfileName = &v
	return s
}

// SetPath sets the Path field's value.
func (s *AwsIamInstanceProfile) SetPath(v string) *AwsIamInstanceProfile {
	s.Path = &v
	return s
}

// SetRoles sets the Roles field's value.
func (s *AwsIamInstanceProfile) SetRoles(v []*AwsIamInstanceProfileRole) *AwsIamInstanceProfile {
	s.Roles = v
	return s
}

// Information about a role associated with an instance profile.
type AwsIamInstanceProfileRole struct {
	_ struct{} `type:"structure"`

	// The ARN of the role.
	Arn *string `type:"string"`

	// The policy that grants an entity permission to assume the role.
	AssumeRolePolicyDocument *string `min:"1" type:"string"`

	// Indicates when the role was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string `type:"string"`

	// The path to the role.
	Path *string `type:"string"`

	// The identifier of the role.
	RoleId *string `type:"string"`

	// The name of the role.
	RoleName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamInstanceProfileRole) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamInstanceProfileRole) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsIamInstanceProfileRole) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsIamInstanceProfileRole"}
	if s.AssumeRolePolicyDocument != nil && len(*s.AssumeRolePolicyDocument) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssumeRolePolicyDocument", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *AwsIamInstanceProfileRole) SetArn(v string) *AwsIamInstanceProfileRole {
	s.Arn = &v
	return s
}

// SetAssumeRolePolicyDocument sets the AssumeRolePolicyDocument field's value.
func (s *AwsIamInstanceProfileRole) SetAssumeRolePolicyDocument(v string) *AwsIamInstanceProfileRole {
	s.AssumeRolePolicyDocument = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *AwsIamInstanceProfileRole) SetCreateDate(v string) *AwsIamInstanceProfileRole {
	s.CreateDate = &v
	return s
}

// SetPath sets the Path field's value.
func (s *AwsIamInstanceProfileRole) SetPath(v string) *AwsIamInstanceProfileRole {
	s.Path = &v
	return s
}

// SetRoleId sets the RoleId field's value.
func (s *AwsIamInstanceProfileRole) SetRoleId(v string) *AwsIamInstanceProfileRole {
	s.RoleId = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *AwsIamInstanceProfileRole) SetRoleName(v string) *AwsIamInstanceProfileRole {
	s.RoleName = &v
	return s
}

// Information about the policy used to set the permissions boundary for an
// IAM principal.
type AwsIamPermissionsBoundary struct {
	_ struct{} `type:"structure"`

	// The ARN of the policy used to set the permissions boundary.
	PermissionsBoundaryArn *string `type:"string"`

	// The usage type for the permissions boundary.
	PermissionsBoundaryType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamPermissionsBoundary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamPermissionsBoundary) GoString() string {
	return s.String()
}

// SetPermissionsBoundaryArn sets the PermissionsBoundaryArn field's value.
func (s *AwsIamPermissionsBoundary) SetPermissionsBoundaryArn(v string) *AwsIamPermissionsBoundary {
	s.PermissionsBoundaryArn = &v
	return s
}

// SetPermissionsBoundaryType sets the PermissionsBoundaryType field's value.
func (s *AwsIamPermissionsBoundary) SetPermissionsBoundaryType(v string) *AwsIamPermissionsBoundary {
	s.PermissionsBoundaryType = &v
	return s
}

// Represents an IAM permissions policy.
type AwsIamPolicyDetails struct {
	_ struct{} `type:"structure"`

	// The number of users, groups, and roles that the policy is attached to.
	AttachmentCount *int64 `type:"integer"`

	// When the policy was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string `type:"string"`

	// The identifier of the default version of the policy.
	DefaultVersionId *string `type:"string"`

	// A description of the policy.
	Description *string `type:"string"`

	// Whether the policy can be attached to a user, group, or role.
	IsAttachable *bool `type:"boolean"`

	// The path to the policy.
	Path *string `type:"string"`

	// The number of users and roles that use the policy to set the permissions
	// boundary.
	PermissionsBoundaryUsageCount *int64 `type:"integer"`

	// The unique identifier of the policy.
	PolicyId *string `type:"string"`

	// The name of the policy.
	PolicyName *string `type:"string"`

	// List of versions of the policy.
	PolicyVersionList []*AwsIamPolicyVersion `type:"list"`

	// When the policy was most recently updated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	UpdateDate *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamPolicyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamPolicyDetails) GoString() string {
	return s.String()
}

// SetAttachmentCount sets the AttachmentCount field's value.
func (s *AwsIamPolicyDetails) SetAttachmentCount(v int64) *AwsIamPolicyDetails {
	s.AttachmentCount = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *AwsIamPolicyDetails) SetCreateDate(v string) *AwsIamPolicyDetails {
	s.CreateDate = &v
	return s
}

// SetDefaultVersionId sets the DefaultVersionId field's value.
func (s *AwsIamPolicyDetails) SetDefaultVersionId(v string) *AwsIamPolicyDetails {
	s.DefaultVersionId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsIamPolicyDetails) SetDescription(v string) *AwsIamPolicyDetails {
	s.Description = &v
	return s
}

// SetIsAttachable sets the IsAttachable field's value.
func (s *AwsIamPolicyDetails) SetIsAttachable(v bool) *AwsIamPolicyDetails {
	s.IsAttachable = &v
	return s
}

// SetPath sets the Path field's value.
func (s *AwsIamPolicyDetails) SetPath(v string) *AwsIamPolicyDetails {
	s.Path = &v
	return s
}

// SetPermissionsBoundaryUsageCount sets the PermissionsBoundaryUsageCount field's value.
func (s *AwsIamPolicyDetails) SetPermissionsBoundaryUsageCount(v int64) *AwsIamPolicyDetails {
	s.PermissionsBoundaryUsageCount = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *AwsIamPolicyDetails) SetPolicyId(v string) *AwsIamPolicyDetails {
	s.PolicyId = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *AwsIamPolicyDetails) SetPolicyName(v string) *AwsIamPolicyDetails {
	s.PolicyName = &v
	return s
}

// SetPolicyVersionList sets the PolicyVersionList field's value.
func (s *AwsIamPolicyDetails) SetPolicyVersionList(v []*AwsIamPolicyVersion) *AwsIamPolicyDetails {
	s.PolicyVersionList = v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *AwsIamPolicyDetails) SetUpdateDate(v string) *AwsIamPolicyDetails {
	s.UpdateDate = &v
	return s
}

// A version of an IAM policy.
type AwsIamPolicyVersion struct {
	_ struct{} `type:"structure"`

	// Indicates when the version was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string `type:"string"`

	// Whether the version is the default version.
	IsDefaultVersion *bool `type:"boolean"`

	// The identifier of the policy version.
	VersionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamPolicyVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamPolicyVersion) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *AwsIamPolicyVersion) SetCreateDate(v string) *AwsIamPolicyVersion {
	s.CreateDate = &v
	return s
}

// SetIsDefaultVersion sets the IsDefaultVersion field's value.
func (s *AwsIamPolicyVersion) SetIsDefaultVersion(v bool) *AwsIamPolicyVersion {
	s.IsDefaultVersion = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *AwsIamPolicyVersion) SetVersionId(v string) *AwsIamPolicyVersion {
	s.VersionId = &v
	return s
}

// Contains information about an IAM role, including all of the role's policies.
type AwsIamRoleDetails struct {
	_ struct{} `type:"structure"`

	// The trust policy that grants permission to assume the role.
	AssumeRolePolicyDocument *string `min:"1" type:"string"`

	// The list of the managed policies that are attached to the role.
	AttachedManagedPolicies []*AwsIamAttachedManagedPolicy `type:"list"`

	// Indicates when the role was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string `type:"string"`

	// The list of instance profiles that contain this role.
	InstanceProfileList []*AwsIamInstanceProfile `type:"list"`

	// The maximum session duration (in seconds) that you want to set for the specified
	// role.
	MaxSessionDuration *int64 `type:"integer"`

	// The path to the role.
	Path *string `type:"string"`

	// Information about the policy used to set the permissions boundary for an
	// IAM principal.
	PermissionsBoundary *AwsIamPermissionsBoundary `type:"structure"`

	// The stable and unique string identifying the role.
	RoleId *string `type:"string"`

	// The friendly name that identifies the role.
	RoleName *string `type:"string"`

	// The list of inline policies that are embedded in the role.
	RolePolicyList []*AwsIamRolePolicy `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamRoleDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamRoleDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsIamRoleDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsIamRoleDetails"}
	if s.AssumeRolePolicyDocument != nil && len(*s.AssumeRolePolicyDocument) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssumeRolePolicyDocument", 1))
	}
	if s.InstanceProfileList != nil {
		for i, v := range s.InstanceProfileList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceProfileList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssumeRolePolicyDocument sets the AssumeRolePolicyDocument field's value.
func (s *AwsIamRoleDetails) SetAssumeRolePolicyDocument(v string) *AwsIamRoleDetails {
	s.AssumeRolePolicyDocument = &v
	return s
}

// SetAttachedManagedPolicies sets the AttachedManagedPolicies field's value.
func (s *AwsIamRoleDetails) SetAttachedManagedPolicies(v []*AwsIamAttachedManagedPolicy) *AwsIamRoleDetails {
	s.AttachedManagedPolicies = v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *AwsIamRoleDetails) SetCreateDate(v string) *AwsIamRoleDetails {
	s.CreateDate = &v
	return s
}

// SetInstanceProfileList sets the InstanceProfileList field's value.
func (s *AwsIamRoleDetails) SetInstanceProfileList(v []*AwsIamInstanceProfile) *AwsIamRoleDetails {
	s.InstanceProfileList = v
	return s
}

// SetMaxSessionDuration sets the MaxSessionDuration field's value.
func (s *AwsIamRoleDetails) SetMaxSessionDuration(v int64) *AwsIamRoleDetails {
	s.MaxSessionDuration = &v
	return s
}

// SetPath sets the Path field's value.
func (s *AwsIamRoleDetails) SetPath(v string) *AwsIamRoleDetails {
	s.Path = &v
	return s
}

// SetPermissionsBoundary sets the PermissionsBoundary field's value.
func (s *AwsIamRoleDetails) SetPermissionsBoundary(v *AwsIamPermissionsBoundary) *AwsIamRoleDetails {
	s.PermissionsBoundary = v
	return s
}

// SetRoleId sets the RoleId field's value.
func (s *AwsIamRoleDetails) SetRoleId(v string) *AwsIamRoleDetails {
	s.RoleId = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *AwsIamRoleDetails) SetRoleName(v string) *AwsIamRoleDetails {
	s.RoleName = &v
	return s
}

// SetRolePolicyList sets the RolePolicyList field's value.
func (s *AwsIamRoleDetails) SetRolePolicyList(v []*AwsIamRolePolicy) *AwsIamRoleDetails {
	s.RolePolicyList = v
	return s
}

// An inline policy that is embedded in the role.
type AwsIamRolePolicy struct {
	_ struct{} `type:"structure"`

	// The name of the policy.
	PolicyName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamRolePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamRolePolicy) GoString() string {
	return s.String()
}

// SetPolicyName sets the PolicyName field's value.
func (s *AwsIamRolePolicy) SetPolicyName(v string) *AwsIamRolePolicy {
	s.PolicyName = &v
	return s
}

// Information about an IAM user.
type AwsIamUserDetails struct {
	_ struct{} `type:"structure"`

	// A list of the managed policies that are attached to the user.
	AttachedManagedPolicies []*AwsIamAttachedManagedPolicy `type:"list"`

	// Indicates when the user was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string `type:"string"`

	// A list of IAM groups that the user belongs to.
	GroupList []*string `type:"list"`

	// The path to the user.
	Path *string `type:"string"`

	// The permissions boundary for the user.
	PermissionsBoundary *AwsIamPermissionsBoundary `type:"structure"`

	// The unique identifier for the user.
	UserId *string `type:"string"`

	// The name of the user.
	UserName *string `type:"string"`

	// The list of inline policies that are embedded in the user.
	UserPolicyList []*AwsIamUserPolicy `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamUserDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamUserDetails) GoString() string {
	return s.String()
}

// SetAttachedManagedPolicies sets the AttachedManagedPolicies field's value.
func (s *AwsIamUserDetails) SetAttachedManagedPolicies(v []*AwsIamAttachedManagedPolicy) *AwsIamUserDetails {
	s.AttachedManagedPolicies = v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *AwsIamUserDetails) SetCreateDate(v string) *AwsIamUserDetails {
	s.CreateDate = &v
	return s
}

// SetGroupList sets the GroupList field's value.
func (s *AwsIamUserDetails) SetGroupList(v []*string) *AwsIamUserDetails {
	s.GroupList = v
	return s
}

// SetPath sets the Path field's value.
func (s *AwsIamUserDetails) SetPath(v string) *AwsIamUserDetails {
	s.Path = &v
	return s
}

// SetPermissionsBoundary sets the PermissionsBoundary field's value.
func (s *AwsIamUserDetails) SetPermissionsBoundary(v *AwsIamPermissionsBoundary) *AwsIamUserDetails {
	s.PermissionsBoundary = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *AwsIamUserDetails) SetUserId(v string) *AwsIamUserDetails {
	s.UserId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *AwsIamUserDetails) SetUserName(v string) *AwsIamUserDetails {
	s.UserName = &v
	return s
}

// SetUserPolicyList sets the UserPolicyList field's value.
func (s *AwsIamUserDetails) SetUserPolicyList(v []*AwsIamUserPolicy) *AwsIamUserDetails {
	s.UserPolicyList = v
	return s
}

// Information about an inline policy that is embedded in the user.
type AwsIamUserPolicy struct {
	_ struct{} `type:"structure"`

	// The name of the policy.
	PolicyName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamUserPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIamUserPolicy) GoString() string {
	return s.String()
}

// SetPolicyName sets the PolicyName field's value.
func (s *AwsIamUserPolicy) SetPolicyName(v string) *AwsIamUserPolicy {
	s.PolicyName = &v
	return s
}

// Contains metadata about an KMS key.
type AwsKmsKeyDetails struct {
	_ struct{} `type:"structure"`

	// The twelve-digit account ID of the Amazon Web Services account that owns
	// the KMS key.
	AWSAccountId *string `type:"string"`

	// Indicates when the KMS key was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreationDate *float64 `type:"double"`

	// A description of the key.
	Description *string `type:"string"`

	// The globally unique identifier for the KMS key.
	KeyId *string `type:"string"`

	// The manager of the KMS key. KMS keys in your Amazon Web Services account
	// are either customer managed or Amazon Web Services managed.
	KeyManager *string `type:"string"`

	// Whether the key has key rotation enabled.
	KeyRotationStatus *bool `type:"boolean"`

	// The state of the KMS key.
	KeyState *string `type:"string"`

	// The source of the KMS key material.
	//
	// When this value is AWS_KMS, KMS created the key material.
	//
	// When this value is EXTERNAL, the key material was imported from your existing
	// key management infrastructure or the KMS key lacks key material.
	//
	// When this value is AWS_CLOUDHSM, the key material was created in the CloudHSM
	// cluster associated with a custom key store.
	Origin *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsKmsKeyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsKmsKeyDetails) GoString() string {
	return s.String()
}

// SetAWSAccountId sets the AWSAccountId field's value.
func (s *AwsKmsKeyDetails) SetAWSAccountId(v string) *AwsKmsKeyDetails {
	s.AWSAccountId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *AwsKmsKeyDetails) SetCreationDate(v float64) *AwsKmsKeyDetails {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsKmsKeyDetails) SetDescription(v string) *AwsKmsKeyDetails {
	s.Description = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *AwsKmsKeyDetails) SetKeyId(v string) *AwsKmsKeyDetails {
	s.KeyId = &v
	return s
}

// SetKeyManager sets the KeyManager field's value.
func (s *AwsKmsKeyDetails) SetKeyManager(v string) *AwsKmsKeyDetails {
	s.KeyManager = &v
	return s
}

// SetKeyRotationStatus sets the KeyRotationStatus field's value.
func (s *AwsKmsKeyDetails) SetKeyRotationStatus(v bool) *AwsKmsKeyDetails {
	s.KeyRotationStatus = &v
	return s
}

// SetKeyState sets the KeyState field's value.
func (s *AwsKmsKeyDetails) SetKeyState(v string) *AwsKmsKeyDetails {
	s.KeyState = &v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *AwsKmsKeyDetails) SetOrigin(v string) *AwsKmsKeyDetails {
	s.Origin = &v
	return s
}

// The code for the Lambda function. You can specify either an object in Amazon
// S3, or upload a deployment package directly.
type AwsLambdaFunctionCode struct {
	_ struct{} `type:"structure"`

	// An Amazon S3 bucket in the same Amazon Web Services Region as your function.
	// The bucket can be in a different Amazon Web Services account.
	S3Bucket *string `type:"string"`

	// The Amazon S3 key of the deployment package.
	S3Key *string `type:"string"`

	// For versioned objects, the version of the deployment package object to use.
	S3ObjectVersion *string `type:"string"`

	// The base64-encoded contents of the deployment package. Amazon Web Services
	// SDK and Amazon Web Services CLI clients handle the encoding for you.
	ZipFile *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaFunctionCode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaFunctionCode) GoString() string {
	return s.String()
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *AwsLambdaFunctionCode) SetS3Bucket(v string) *AwsLambdaFunctionCode {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *AwsLambdaFunctionCode) SetS3Key(v string) *AwsLambdaFunctionCode {
	s.S3Key = &v
	return s
}

// SetS3ObjectVersion sets the S3ObjectVersion field's value.
func (s *AwsLambdaFunctionCode) SetS3ObjectVersion(v string) *AwsLambdaFunctionCode {
	s.S3ObjectVersion = &v
	return s
}

// SetZipFile sets the ZipFile field's value.
func (s *AwsLambdaFunctionCode) SetZipFile(v string) *AwsLambdaFunctionCode {
	s.ZipFile = &v
	return s
}

// The dead-letter queue for failed asynchronous invocations.
type AwsLambdaFunctionDeadLetterConfig struct {
	_ struct{} `type:"structure"`

	// The ARN of an SQS queue or SNS topic.
	TargetArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaFunctionDeadLetterConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaFunctionDeadLetterConfig) GoString() string {
	return s.String()
}

// SetTargetArn sets the TargetArn field's value.
func (s *AwsLambdaFunctionDeadLetterConfig) SetTargetArn(v string) *AwsLambdaFunctionDeadLetterConfig {
	s.TargetArn = &v
	return s
}

// Details about a function's configuration.
type AwsLambdaFunctionDetails struct {
	_ struct{} `type:"structure"`

	// An AwsLambdaFunctionCode object.
	Code *AwsLambdaFunctionCode `type:"structure"`

	// The SHA256 hash of the function's deployment package.
	CodeSha256 *string `type:"string"`

	// The function's dead letter queue.
	DeadLetterConfig *AwsLambdaFunctionDeadLetterConfig `type:"structure"`

	// The function's environment variables.
	Environment *AwsLambdaFunctionEnvironment `type:"structure"`

	// The name of the function.
	FunctionName *string `type:"string"`

	// The function that Lambda calls to begin executing your function.
	Handler *string `type:"string"`

	// The KMS key that is used to encrypt the function's environment variables.
	// This key is only returned if you've configured a customer managed customer
	// managed key.
	KmsKeyArn *string `type:"string"`

	// Indicates when the function was last updated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastModified *string `type:"string"`

	// The function's layers.
	Layers []*AwsLambdaFunctionLayer `type:"list"`

	// For Lambda@Edge functions, the ARN of the master function.
	MasterArn *string `type:"string"`

	// The memory that is allocated to the function.
	MemorySize *int64 `type:"integer"`

	// The latest updated revision of the function or alias.
	RevisionId *string `type:"string"`

	// The function's execution role.
	Role *string `type:"string"`

	// The runtime environment for the Lambda function.
	Runtime *string `type:"string"`

	// The amount of time that Lambda allows a function to run before stopping it.
	Timeout *int64 `type:"integer"`

	// The function's X-Ray tracing configuration.
	TracingConfig *AwsLambdaFunctionTracingConfig `type:"structure"`

	// The version of the Lambda function.
	Version *string `type:"string"`

	// The function's networking configuration.
	VpcConfig *AwsLambdaFunctionVpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaFunctionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaFunctionDetails) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *AwsLambdaFunctionDetails) SetCode(v *AwsLambdaFunctionCode) *AwsLambdaFunctionDetails {
	s.Code = v
	return s
}

// SetCodeSha256 sets the CodeSha256 field's value.
func (s *AwsLambdaFunctionDetails) SetCodeSha256(v string) *AwsLambdaFunctionDetails {
	s.CodeSha256 = &v
	return s
}

// SetDeadLetterConfig sets the DeadLetterConfig field's value.
func (s *AwsLambdaFunctionDetails) SetDeadLetterConfig(v *AwsLambdaFunctionDeadLetterConfig) *AwsLambdaFunctionDetails {
	s.DeadLetterConfig = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *AwsLambdaFunctionDetails) SetEnvironment(v *AwsLambdaFunctionEnvironment) *AwsLambdaFunctionDetails {
	s.Environment = v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *AwsLambdaFunctionDetails) SetFunctionName(v string) *AwsLambdaFunctionDetails {
	s.FunctionName = &v
	return s
}

// SetHandler sets the Handler field's value.
func (s *AwsLambdaFunctionDetails) SetHandler(v string) *AwsLambdaFunctionDetails {
	s.Handler = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *AwsLambdaFunctionDetails) SetKmsKeyArn(v string) *AwsLambdaFunctionDetails {
	s.KmsKeyArn = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *AwsLambdaFunctionDetails) SetLastModified(v string) *AwsLambdaFunctionDetails {
	s.LastModified = &v
	return s
}

// SetLayers sets the Layers field's value.
func (s *AwsLambdaFunctionDetails) SetLayers(v []*AwsLambdaFunctionLayer) *AwsLambdaFunctionDetails {
	s.Layers = v
	return s
}

// SetMasterArn sets the MasterArn field's value.
func (s *AwsLambdaFunctionDetails) SetMasterArn(v string) *AwsLambdaFunctionDetails {
	s.MasterArn = &v
	return s
}

// SetMemorySize sets the MemorySize field's value.
func (s *AwsLambdaFunctionDetails) SetMemorySize(v int64) *AwsLambdaFunctionDetails {
	s.MemorySize = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *AwsLambdaFunctionDetails) SetRevisionId(v string) *AwsLambdaFunctionDetails {
	s.RevisionId = &v
	return s
}

// SetRole sets the Role field's value.
func (s *AwsLambdaFunctionDetails) SetRole(v string) *AwsLambdaFunctionDetails {
	s.Role = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *AwsLambdaFunctionDetails) SetRuntime(v string) *AwsLambdaFunctionDetails {
	s.Runtime = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *AwsLambdaFunctionDetails) SetTimeout(v int64) *AwsLambdaFunctionDetails {
	s.Timeout = &v
	return s
}

// SetTracingConfig sets the TracingConfig field's value.
func (s *AwsLambdaFunctionDetails) SetTracingConfig(v *AwsLambdaFunctionTracingConfig) *AwsLambdaFunctionDetails {
	s.TracingConfig = v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsLambdaFunctionDetails) SetVersion(v string) *AwsLambdaFunctionDetails {
	s.Version = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *AwsLambdaFunctionDetails) SetVpcConfig(v *AwsLambdaFunctionVpcConfig) *AwsLambdaFunctionDetails {
	s.VpcConfig = v
	return s
}

// A function's environment variable settings.
type AwsLambdaFunctionEnvironment struct {
	_ struct{} `type:"structure"`

	// An AwsLambdaFunctionEnvironmentError object.
	Error *AwsLambdaFunctionEnvironmentError `type:"structure"`

	// Environment variable key-value pairs.
	Variables map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaFunctionEnvironment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaFunctionEnvironment) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *AwsLambdaFunctionEnvironment) SetError(v *AwsLambdaFunctionEnvironmentError) *AwsLambdaFunctionEnvironment {
	s.Error = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *AwsLambdaFunctionEnvironment) SetVariables(v map[string]*string) *AwsLambdaFunctionEnvironment {
	s.Variables = v
	return s
}

// Error messages for environment variables that could not be applied.
type AwsLambdaFunctionEnvironmentError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string"`

	// The error message.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaFunctionEnvironmentError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaFunctionEnvironmentError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *AwsLambdaFunctionEnvironmentError) SetErrorCode(v string) *AwsLambdaFunctionEnvironmentError {
	s.ErrorCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AwsLambdaFunctionEnvironmentError) SetMessage(v string) *AwsLambdaFunctionEnvironmentError {
	s.Message = &v
	return s
}

// An Lambda layer.
type AwsLambdaFunctionLayer struct {
	_ struct{} `type:"structure"`

	// The ARN of the function layer.
	Arn *string `type:"string"`

	// The size of the layer archive in bytes.
	CodeSize *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaFunctionLayer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaFunctionLayer) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AwsLambdaFunctionLayer) SetArn(v string) *AwsLambdaFunctionLayer {
	s.Arn = &v
	return s
}

// SetCodeSize sets the CodeSize field's value.
func (s *AwsLambdaFunctionLayer) SetCodeSize(v int64) *AwsLambdaFunctionLayer {
	s.CodeSize = &v
	return s
}

// The function's X-Ray tracing configuration.
type AwsLambdaFunctionTracingConfig struct {
	_ struct{} `type:"structure"`

	// The tracing mode.
	Mode *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaFunctionTracingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaFunctionTracingConfig) GoString() string {
	return s.String()
}

// SetMode sets the Mode field's value.
func (s *AwsLambdaFunctionTracingConfig) SetMode(v string) *AwsLambdaFunctionTracingConfig {
	s.Mode = &v
	return s
}

// The VPC security groups and subnets that are attached to a Lambda function.
type AwsLambdaFunctionVpcConfig struct {
	_ struct{} `type:"structure"`

	// A list of VPC security groups IDs.
	SecurityGroupIds []*string `type:"list"`

	// A list of VPC subnet IDs.
	SubnetIds []*string `type:"list"`

	// The ID of the VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaFunctionVpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaFunctionVpcConfig) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *AwsLambdaFunctionVpcConfig) SetSecurityGroupIds(v []*string) *AwsLambdaFunctionVpcConfig {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *AwsLambdaFunctionVpcConfig) SetSubnetIds(v []*string) *AwsLambdaFunctionVpcConfig {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsLambdaFunctionVpcConfig) SetVpcId(v string) *AwsLambdaFunctionVpcConfig {
	s.VpcId = &v
	return s
}

// Details about a Lambda layer version.
type AwsLambdaLayerVersionDetails struct {
	_ struct{} `type:"structure"`

	// The layer's compatible runtimes. Maximum number of five items.
	//
	// Valid values: nodejs10.x | nodejs12.x | java8 | java11 | python2.7 | python3.6
	// | python3.7 | python3.8 | dotnetcore1.0 | dotnetcore2.1 | go1.x | ruby2.5
	// | provided
	CompatibleRuntimes []*string `type:"list"`

	// Indicates when the version was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedDate *string `type:"string"`

	// The version number.
	Version *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaLayerVersionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaLayerVersionDetails) GoString() string {
	return s.String()
}

// SetCompatibleRuntimes sets the CompatibleRuntimes field's value.
func (s *AwsLambdaLayerVersionDetails) SetCompatibleRuntimes(v []*string) *AwsLambdaLayerVersionDetails {
	s.CompatibleRuntimes = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AwsLambdaLayerVersionDetails) SetCreatedDate(v string) *AwsLambdaLayerVersionDetails {
	s.CreatedDate = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsLambdaLayerVersionDetails) SetVersion(v int64) *AwsLambdaLayerVersionDetails {
	s.Version = &v
	return s
}

// Details about an Network Firewall firewall.
type AwsNetworkFirewallFirewallDetails struct {
	_ struct{} `type:"structure"`

	// Whether the firewall is protected from deletion. If set to true, then the
	// firewall cannot be deleted.
	DeleteProtection *bool `type:"boolean"`

	// A description of the firewall.
	Description *string `type:"string"`

	// The ARN of the firewall.
	FirewallArn *string `type:"string"`

	// The identifier of the firewall.
	FirewallId *string `type:"string"`

	// A descriptive name of the firewall.
	FirewallName *string `type:"string"`

	// The ARN of the firewall policy.
	FirewallPolicyArn *string `type:"string"`

	// Whether the firewall is protected from a change to the firewall policy. If
	// set to true, you cannot associate a different policy with the firewall.
	FirewallPolicyChangeProtection *bool `type:"boolean"`

	// Whether the firewall is protected from a change to the subnet associations.
	// If set to true, you cannot map different subnets to the firewall.
	SubnetChangeProtection *bool `type:"boolean"`

	// The public subnets that Network Firewall uses for the firewall. Each subnet
	// must belong to a different Availability Zone.
	SubnetMappings []*AwsNetworkFirewallFirewallSubnetMappingsDetails `type:"list"`

	// The identifier of the VPC where the firewall is used.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsNetworkFirewallFirewallDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsNetworkFirewallFirewallDetails) GoString() string {
	return s.String()
}

// SetDeleteProtection sets the DeleteProtection field's value.
func (s *AwsNetworkFirewallFirewallDetails) SetDeleteProtection(v bool) *AwsNetworkFirewallFirewallDetails {
	s.DeleteProtection = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsNetworkFirewallFirewallDetails) SetDescription(v string) *AwsNetworkFirewallFirewallDetails {
	s.Description = &v
	return s
}

// SetFirewallArn sets the FirewallArn field's value.
func (s *AwsNetworkFirewallFirewallDetails) SetFirewallArn(v string) *AwsNetworkFirewallFirewallDetails {
	s.FirewallArn = &v
	return s
}

// SetFirewallId sets the FirewallId field's value.
func (s *AwsNetworkFirewallFirewallDetails) SetFirewallId(v string) *AwsNetworkFirewallFirewallDetails {
	s.FirewallId = &v
	return s
}

// SetFirewallName sets the FirewallName field's value.
func (s *AwsNetworkFirewallFirewallDetails) SetFirewallName(v string) *AwsNetworkFirewallFirewallDetails {
	s.FirewallName = &v
	return s
}

// SetFirewallPolicyArn sets the FirewallPolicyArn field's value.
func (s *AwsNetworkFirewallFirewallDetails) SetFirewallPolicyArn(v string) *AwsNetworkFirewallFirewallDetails {
	s.FirewallPolicyArn = &v
	return s
}

// SetFirewallPolicyChangeProtection sets the FirewallPolicyChangeProtection field's value.
func (s *AwsNetworkFirewallFirewallDetails) SetFirewallPolicyChangeProtection(v bool) *AwsNetworkFirewallFirewallDetails {
	s.FirewallPolicyChangeProtection = &v
	return s
}

// SetSubnetChangeProtection sets the SubnetChangeProtection field's value.
func (s *AwsNetworkFirewallFirewallDetails) SetSubnetChangeProtection(v bool) *AwsNetworkFirewallFirewallDetails {
	s.SubnetChangeProtection = &v
	return s
}

// SetSubnetMappings sets the SubnetMappings field's value.
func (s *AwsNetworkFirewallFirewallDetails) SetSubnetMappings(v []*AwsNetworkFirewallFirewallSubnetMappingsDetails) *AwsNetworkFirewallFirewallDetails {
	s.SubnetMappings = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsNetworkFirewallFirewallDetails) SetVpcId(v string) *AwsNetworkFirewallFirewallDetails {
	s.VpcId = &v
	return s
}

// Details about a firewall policy. A firewall policy defines the behavior of
// a network firewall.
type AwsNetworkFirewallFirewallPolicyDetails struct {
	_ struct{} `type:"structure"`

	// A description of the firewall policy.
	Description *string `type:"string"`

	// The firewall policy configuration.
	FirewallPolicy *FirewallPolicyDetails `type:"structure"`

	// The ARN of the firewall policy.
	FirewallPolicyArn *string `type:"string"`

	// The identifier of the firewall policy.
	FirewallPolicyId *string `type:"string"`

	// The name of the firewall policy.
	FirewallPolicyName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsNetworkFirewallFirewallPolicyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsNetworkFirewallFirewallPolicyDetails) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *AwsNetworkFirewallFirewallPolicyDetails) SetDescription(v string) *AwsNetworkFirewallFirewallPolicyDetails {
	s.Description = &v
	return s
}

// SetFirewallPolicy sets the FirewallPolicy field's value.
func (s *AwsNetworkFirewallFirewallPolicyDetails) SetFirewallPolicy(v *FirewallPolicyDetails) *AwsNetworkFirewallFirewallPolicyDetails {
	s.FirewallPolicy = v
	return s
}

// SetFirewallPolicyArn sets the FirewallPolicyArn field's value.
func (s *AwsNetworkFirewallFirewallPolicyDetails) SetFirewallPolicyArn(v string) *AwsNetworkFirewallFirewallPolicyDetails {
	s.FirewallPolicyArn = &v
	return s
}

// SetFirewallPolicyId sets the FirewallPolicyId field's value.
func (s *AwsNetworkFirewallFirewallPolicyDetails) SetFirewallPolicyId(v string) *AwsNetworkFirewallFirewallPolicyDetails {
	s.FirewallPolicyId = &v
	return s
}

// SetFirewallPolicyName sets the FirewallPolicyName field's value.
func (s *AwsNetworkFirewallFirewallPolicyDetails) SetFirewallPolicyName(v string) *AwsNetworkFirewallFirewallPolicyDetails {
	s.FirewallPolicyName = &v
	return s
}

// A public subnet that Network Firewall uses for the firewall.
type AwsNetworkFirewallFirewallSubnetMappingsDetails struct {
	_ struct{} `type:"structure"`

	// The identifier of the subnet
	SubnetId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsNetworkFirewallFirewallSubnetMappingsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsNetworkFirewallFirewallSubnetMappingsDetails) GoString() string {
	return s.String()
}

// SetSubnetId sets the SubnetId field's value.
func (s *AwsNetworkFirewallFirewallSubnetMappingsDetails) SetSubnetId(v string) *AwsNetworkFirewallFirewallSubnetMappingsDetails {
	s.SubnetId = &v
	return s
}

// Details about an Network Firewall rule group. Rule groups are used to inspect
// and control network traffic. Stateless rule groups apply to individual packets.
// Stateful rule groups apply to packets in the context of their traffic flow.
//
// Rule groups are referenced in firewall policies.
type AwsNetworkFirewallRuleGroupDetails struct {
	_ struct{} `type:"structure"`

	// The maximum number of operating resources that this rule group can use.
	Capacity *int64 `type:"integer"`

	// A description of the rule group.
	Description *string `type:"string"`

	// Details about the rule group.
	RuleGroup *RuleGroupDetails `type:"structure"`

	// The ARN of the rule group.
	RuleGroupArn *string `type:"string"`

	// The identifier of the rule group.
	RuleGroupId *string `type:"string"`

	// The descriptive name of the rule group.
	RuleGroupName *string `type:"string"`

	// The type of rule group. A rule group can be stateful or stateless.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsNetworkFirewallRuleGroupDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsNetworkFirewallRuleGroupDetails) GoString() string {
	return s.String()
}

// SetCapacity sets the Capacity field's value.
func (s *AwsNetworkFirewallRuleGroupDetails) SetCapacity(v int64) *AwsNetworkFirewallRuleGroupDetails {
	s.Capacity = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsNetworkFirewallRuleGroupDetails) SetDescription(v string) *AwsNetworkFirewallRuleGroupDetails {
	s.Description = &v
	return s
}

// SetRuleGroup sets the RuleGroup field's value.
func (s *AwsNetworkFirewallRuleGroupDetails) SetRuleGroup(v *RuleGroupDetails) *AwsNetworkFirewallRuleGroupDetails {
	s.RuleGroup = v
	return s
}

// SetRuleGroupArn sets the RuleGroupArn field's value.
func (s *AwsNetworkFirewallRuleGroupDetails) SetRuleGroupArn(v string) *AwsNetworkFirewallRuleGroupDetails {
	s.RuleGroupArn = &v
	return s
}

// SetRuleGroupId sets the RuleGroupId field's value.
func (s *AwsNetworkFirewallRuleGroupDetails) SetRuleGroupId(v string) *AwsNetworkFirewallRuleGroupDetails {
	s.RuleGroupId = &v
	return s
}

// SetRuleGroupName sets the RuleGroupName field's value.
func (s *AwsNetworkFirewallRuleGroupDetails) SetRuleGroupName(v string) *AwsNetworkFirewallRuleGroupDetails {
	s.RuleGroupName = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsNetworkFirewallRuleGroupDetails) SetType(v string) *AwsNetworkFirewallRuleGroupDetails {
	s.Type = &v
	return s
}

// Details about the configuration of an OpenSearch cluster.
type AwsOpenSearchServiceDomainClusterConfigDetails struct {
	_ struct{} `type:"structure"`

	// The number of instances to use for the master node. If this attribute is
	// specified, then DedicatedMasterEnabled must be true.
	DedicatedMasterCount *int64 `type:"integer"`

	// Whether to use a dedicated master node for the OpenSearch domain. A dedicated
	// master node performs cluster management tasks, but does not hold data or
	// respond to data upload requests.
	DedicatedMasterEnabled *bool `type:"boolean"`

	// The hardware configuration of the computer that hosts the dedicated master
	// node.
	//
	// If this attribute is specified, then DedicatedMasterEnabled must be true.
	DedicatedMasterType *string `type:"string"`

	// The number of data nodes to use in the OpenSearch domain.
	InstanceCount *int64 `type:"integer"`

	// The instance type for your data nodes.
	InstanceType *string `type:"string"`

	// The number of UltraWarm instances.
	WarmCount *int64 `type:"integer"`

	// Whether UltraWarm is enabled.
	WarmEnabled *bool `type:"boolean"`

	// The type of UltraWarm instance.
	WarmType *string `type:"string"`

	// Configuration options for zone awareness. Provided if ZoneAwarenessEnabled
	// is true.
	ZoneAwarenessConfig *AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails `type:"structure"`

	// Whether to enable zone awareness for the OpenSearch domain. When zone awareness
	// is enabled, OpenSearch Service allocates the cluster's nodes and replica
	// index shards across Availability Zones (AZs) in the same Region. This prevents
	// data loss and minimizes downtime if a node or data center fails.
	ZoneAwarenessEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainClusterConfigDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainClusterConfigDetails) GoString() string {
	return s.String()
}

// SetDedicatedMasterCount sets the DedicatedMasterCount field's value.
func (s *AwsOpenSearchServiceDomainClusterConfigDetails) SetDedicatedMasterCount(v int64) *AwsOpenSearchServiceDomainClusterConfigDetails {
	s.DedicatedMasterCount = &v
	return s
}

// SetDedicatedMasterEnabled sets the DedicatedMasterEnabled field's value.
func (s *AwsOpenSearchServiceDomainClusterConfigDetails) SetDedicatedMasterEnabled(v bool) *AwsOpenSearchServiceDomainClusterConfigDetails {
	s.DedicatedMasterEnabled = &v
	return s
}

// SetDedicatedMasterType sets the DedicatedMasterType field's value.
func (s *AwsOpenSearchServiceDomainClusterConfigDetails) SetDedicatedMasterType(v string) *AwsOpenSearchServiceDomainClusterConfigDetails {
	s.DedicatedMasterType = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *AwsOpenSearchServiceDomainClusterConfigDetails) SetInstanceCount(v int64) *AwsOpenSearchServiceDomainClusterConfigDetails {
	s.InstanceCount = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *AwsOpenSearchServiceDomainClusterConfigDetails) SetInstanceType(v string) *AwsOpenSearchServiceDomainClusterConfigDetails {
	s.InstanceType = &v
	return s
}

// SetWarmCount sets the WarmCount field's value.
func (s *AwsOpenSearchServiceDomainClusterConfigDetails) SetWarmCount(v int64) *AwsOpenSearchServiceDomainClusterConfigDetails {
	s.WarmCount = &v
	return s
}

// SetWarmEnabled sets the WarmEnabled field's value.
func (s *AwsOpenSearchServiceDomainClusterConfigDetails) SetWarmEnabled(v bool) *AwsOpenSearchServiceDomainClusterConfigDetails {
	s.WarmEnabled = &v
	return s
}

// SetWarmType sets the WarmType field's value.
func (s *AwsOpenSearchServiceDomainClusterConfigDetails) SetWarmType(v string) *AwsOpenSearchServiceDomainClusterConfigDetails {
	s.WarmType = &v
	return s
}

// SetZoneAwarenessConfig sets the ZoneAwarenessConfig field's value.
func (s *AwsOpenSearchServiceDomainClusterConfigDetails) SetZoneAwarenessConfig(v *AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails) *AwsOpenSearchServiceDomainClusterConfigDetails {
	s.ZoneAwarenessConfig = v
	return s
}

// SetZoneAwarenessEnabled sets the ZoneAwarenessEnabled field's value.
func (s *AwsOpenSearchServiceDomainClusterConfigDetails) SetZoneAwarenessEnabled(v bool) *AwsOpenSearchServiceDomainClusterConfigDetails {
	s.ZoneAwarenessEnabled = &v
	return s
}

// Configuration options for zone awareness.
type AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails struct {
	_ struct{} `type:"structure"`

	// The number of Availability Zones that the domain uses. Valid values are 2
	// and 3. The default is 2.
	AvailabilityZoneCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails) GoString() string {
	return s.String()
}

// SetAvailabilityZoneCount sets the AvailabilityZoneCount field's value.
func (s *AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails) SetAvailabilityZoneCount(v int64) *AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails {
	s.AvailabilityZoneCount = &v
	return s
}

// Information about an Amazon OpenSearch Service domain.
type AwsOpenSearchServiceDomainDetails struct {
	_ struct{} `type:"structure"`

	// IAM policy document that specifies the access policies for the OpenSearch
	// Service domain.
	AccessPolicies *string `type:"string"`

	// The ARN of the OpenSearch Service domain.
	Arn *string `type:"string"`

	// Details about the configuration of an OpenSearch cluster.
	ClusterConfig *AwsOpenSearchServiceDomainClusterConfigDetails `type:"structure"`

	// The domain endpoint.
	DomainEndpoint *string `type:"string"`

	// Additional options for the domain endpoint.
	DomainEndpointOptions *AwsOpenSearchServiceDomainDomainEndpointOptionsDetails `type:"structure"`

	// The domain endpoints. Used if the OpenSearch domain resides in a VPC.
	//
	// This is a map of key-value pairs. The key is always vpc. The value is the
	// endpoint.
	DomainEndpoints map[string]*string `type:"map"`

	// The name of the endpoint.
	DomainName *string `type:"string"`

	// Details about the configuration for encryption at rest.
	EncryptionAtRestOptions *AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails `type:"structure"`

	// The version of the domain engine.
	EngineVersion *string `type:"string"`

	// The identifier of the domain.
	Id *string `type:"string"`

	// Configures the CloudWatch Logs to publish for the OpenSearch domain.
	LogPublishingOptions *AwsOpenSearchServiceDomainLogPublishingOptionsDetails `type:"structure"`

	// Details about the configuration for node-to-node encryption.
	NodeToNodeEncryptionOptions *AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails `type:"structure"`

	// Information about the status of a domain relative to the latest service software.
	ServiceSoftwareOptions *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails `type:"structure"`

	// Information that OpenSearch Service derives based on VPCOptions for the domain.
	VpcOptions *AwsOpenSearchServiceDomainVpcOptionsDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainDetails) GoString() string {
	return s.String()
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *AwsOpenSearchServiceDomainDetails) SetAccessPolicies(v string) *AwsOpenSearchServiceDomainDetails {
	s.AccessPolicies = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *AwsOpenSearchServiceDomainDetails) SetArn(v string) *AwsOpenSearchServiceDomainDetails {
	s.Arn = &v
	return s
}

// SetClusterConfig sets the ClusterConfig field's value.
func (s *AwsOpenSearchServiceDomainDetails) SetClusterConfig(v *AwsOpenSearchServiceDomainClusterConfigDetails) *AwsOpenSearchServiceDomainDetails {
	s.ClusterConfig = v
	return s
}

// SetDomainEndpoint sets the DomainEndpoint field's value.
func (s *AwsOpenSearchServiceDomainDetails) SetDomainEndpoint(v string) *AwsOpenSearchServiceDomainDetails {
	s.DomainEndpoint = &v
	return s
}

// SetDomainEndpointOptions sets the DomainEndpointOptions field's value.
func (s *AwsOpenSearchServiceDomainDetails) SetDomainEndpointOptions(v *AwsOpenSearchServiceDomainDomainEndpointOptionsDetails) *AwsOpenSearchServiceDomainDetails {
	s.DomainEndpointOptions = v
	return s
}

// SetDomainEndpoints sets the DomainEndpoints field's value.
func (s *AwsOpenSearchServiceDomainDetails) SetDomainEndpoints(v map[string]*string) *AwsOpenSearchServiceDomainDetails {
	s.DomainEndpoints = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *AwsOpenSearchServiceDomainDetails) SetDomainName(v string) *AwsOpenSearchServiceDomainDetails {
	s.DomainName = &v
	return s
}

// SetEncryptionAtRestOptions sets the EncryptionAtRestOptions field's value.
func (s *AwsOpenSearchServiceDomainDetails) SetEncryptionAtRestOptions(v *AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails) *AwsOpenSearchServiceDomainDetails {
	s.EncryptionAtRestOptions = v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *AwsOpenSearchServiceDomainDetails) SetEngineVersion(v string) *AwsOpenSearchServiceDomainDetails {
	s.EngineVersion = &v
	return s
}

// SetId sets the Id field's value.
func (s *AwsOpenSearchServiceDomainDetails) SetId(v string) *AwsOpenSearchServiceDomainDetails {
	s.Id = &v
	return s
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *AwsOpenSearchServiceDomainDetails) SetLogPublishingOptions(v *AwsOpenSearchServiceDomainLogPublishingOptionsDetails) *AwsOpenSearchServiceDomainDetails {
	s.LogPublishingOptions = v
	return s
}

// SetNodeToNodeEncryptionOptions sets the NodeToNodeEncryptionOptions field's value.
func (s *AwsOpenSearchServiceDomainDetails) SetNodeToNodeEncryptionOptions(v *AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails) *AwsOpenSearchServiceDomainDetails {
	s.NodeToNodeEncryptionOptions = v
	return s
}

// SetServiceSoftwareOptions sets the ServiceSoftwareOptions field's value.
func (s *AwsOpenSearchServiceDomainDetails) SetServiceSoftwareOptions(v *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails) *AwsOpenSearchServiceDomainDetails {
	s.ServiceSoftwareOptions = v
	return s
}

// SetVpcOptions sets the VpcOptions field's value.
func (s *AwsOpenSearchServiceDomainDetails) SetVpcOptions(v *AwsOpenSearchServiceDomainVpcOptionsDetails) *AwsOpenSearchServiceDomainDetails {
	s.VpcOptions = v
	return s
}

// Information about additional options for the domain endpoint.
type AwsOpenSearchServiceDomainDomainEndpointOptionsDetails struct {
	_ struct{} `type:"structure"`

	// The fully qualified URL for the custom endpoint.
	CustomEndpoint *string `type:"string"`

	// The ARN for the security certificate. The certificate is managed in ACM.
	CustomEndpointCertificateArn *string `type:"string"`

	// Whether to enable a custom endpoint for the domain.
	CustomEndpointEnabled *bool `type:"boolean"`

	// Whether to require that all traffic to the domain arrive over HTTPS.
	EnforceHTTPS *bool `type:"boolean"`

	// The TLS security policy to apply to the HTTPS endpoint of the OpenSearch
	// domain.
	TLSSecurityPolicy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainDomainEndpointOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainDomainEndpointOptionsDetails) GoString() string {
	return s.String()
}

// SetCustomEndpoint sets the CustomEndpoint field's value.
func (s *AwsOpenSearchServiceDomainDomainEndpointOptionsDetails) SetCustomEndpoint(v string) *AwsOpenSearchServiceDomainDomainEndpointOptionsDetails {
	s.CustomEndpoint = &v
	return s
}

// SetCustomEndpointCertificateArn sets the CustomEndpointCertificateArn field's value.
func (s *AwsOpenSearchServiceDomainDomainEndpointOptionsDetails) SetCustomEndpointCertificateArn(v string) *AwsOpenSearchServiceDomainDomainEndpointOptionsDetails {
	s.CustomEndpointCertificateArn = &v
	return s
}

// SetCustomEndpointEnabled sets the CustomEndpointEnabled field's value.
func (s *AwsOpenSearchServiceDomainDomainEndpointOptionsDetails) SetCustomEndpointEnabled(v bool) *AwsOpenSearchServiceDomainDomainEndpointOptionsDetails {
	s.CustomEndpointEnabled = &v
	return s
}

// SetEnforceHTTPS sets the EnforceHTTPS field's value.
func (s *AwsOpenSearchServiceDomainDomainEndpointOptionsDetails) SetEnforceHTTPS(v bool) *AwsOpenSearchServiceDomainDomainEndpointOptionsDetails {
	s.EnforceHTTPS = &v
	return s
}

// SetTLSSecurityPolicy sets the TLSSecurityPolicy field's value.
func (s *AwsOpenSearchServiceDomainDomainEndpointOptionsDetails) SetTLSSecurityPolicy(v string) *AwsOpenSearchServiceDomainDomainEndpointOptionsDetails {
	s.TLSSecurityPolicy = &v
	return s
}

// Details about the configuration for encryption at rest for the OpenSearch
// domain.
type AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails struct {
	_ struct{} `type:"structure"`

	// Whether encryption at rest is enabled.
	Enabled *bool `type:"boolean"`

	// The KMS key ID.
	KmsKeyId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails) SetEnabled(v bool) *AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails {
	s.Enabled = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails) SetKmsKeyId(v string) *AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails {
	s.KmsKeyId = &v
	return s
}

// Configuration details for a log publishing option.
type AwsOpenSearchServiceDomainLogPublishingOption struct {
	_ struct{} `type:"structure"`

	// The ARN of the CloudWatch Logs group to publish the logs to.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Whether the log publishing is enabled.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainLogPublishingOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainLogPublishingOption) GoString() string {
	return s.String()
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *AwsOpenSearchServiceDomainLogPublishingOption) SetCloudWatchLogsLogGroupArn(v string) *AwsOpenSearchServiceDomainLogPublishingOption {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AwsOpenSearchServiceDomainLogPublishingOption) SetEnabled(v bool) *AwsOpenSearchServiceDomainLogPublishingOption {
	s.Enabled = &v
	return s
}

// Configures the CloudWatch Logs to publish for the OpenSearch domain.
type AwsOpenSearchServiceDomainLogPublishingOptionsDetails struct {
	_ struct{} `type:"structure"`

	// Configures the OpenSearch audit logs publishing.
	AuditLogs *AwsOpenSearchServiceDomainLogPublishingOption `type:"structure"`

	// Configures the OpenSearch index logs publishing.
	IndexSlowLogs *AwsOpenSearchServiceDomainLogPublishingOption `type:"structure"`

	// Configures the OpenSearch search slow log publishing.
	SearchSlowLogs *AwsOpenSearchServiceDomainLogPublishingOption `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainLogPublishingOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainLogPublishingOptionsDetails) GoString() string {
	return s.String()
}

// SetAuditLogs sets the AuditLogs field's value.
func (s *AwsOpenSearchServiceDomainLogPublishingOptionsDetails) SetAuditLogs(v *AwsOpenSearchServiceDomainLogPublishingOption) *AwsOpenSearchServiceDomainLogPublishingOptionsDetails {
	s.AuditLogs = v
	return s
}

// SetIndexSlowLogs sets the IndexSlowLogs field's value.
func (s *AwsOpenSearchServiceDomainLogPublishingOptionsDetails) SetIndexSlowLogs(v *AwsOpenSearchServiceDomainLogPublishingOption) *AwsOpenSearchServiceDomainLogPublishingOptionsDetails {
	s.IndexSlowLogs = v
	return s
}

// SetSearchSlowLogs sets the SearchSlowLogs field's value.
func (s *AwsOpenSearchServiceDomainLogPublishingOptionsDetails) SetSearchSlowLogs(v *AwsOpenSearchServiceDomainLogPublishingOption) *AwsOpenSearchServiceDomainLogPublishingOptionsDetails {
	s.SearchSlowLogs = v
	return s
}

// Provides details about the configuration for node-to-node encryption.
type AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails struct {
	_ struct{} `type:"structure"`

	// Whether node-to-node encryption is enabled.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails) SetEnabled(v bool) *AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails {
	s.Enabled = &v
	return s
}

// Provides information about the state of the domain relative to the latest
// service software.
type AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails struct {
	_ struct{} `type:"structure"`

	// The epoch time when the deployment window closes for required updates. After
	// this time, OpenSearch Service schedules the software upgrade automatically.
	AutomatedUpdateDate *string `type:"string"`

	// Whether a request to update the domain can be canceled.
	Cancellable *bool `type:"boolean"`

	// The version of the service software that is currently installed on the domain.
	CurrentVersion *string `type:"string"`

	// A more detailed description of the service software status.
	Description *string `type:"string"`

	// The most recent version of the service software.
	NewVersion *string `type:"string"`

	// Whether the service software update is optional.
	OptionalDeployment *bool `type:"boolean"`

	// Whether a service software update is available for the domain.
	UpdateAvailable *bool `type:"boolean"`

	// The status of the service software update.
	UpdateStatus *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails) GoString() string {
	return s.String()
}

// SetAutomatedUpdateDate sets the AutomatedUpdateDate field's value.
func (s *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails) SetAutomatedUpdateDate(v string) *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails {
	s.AutomatedUpdateDate = &v
	return s
}

// SetCancellable sets the Cancellable field's value.
func (s *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails) SetCancellable(v bool) *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails {
	s.Cancellable = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails) SetCurrentVersion(v string) *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails {
	s.CurrentVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails) SetDescription(v string) *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails {
	s.Description = &v
	return s
}

// SetNewVersion sets the NewVersion field's value.
func (s *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails) SetNewVersion(v string) *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails {
	s.NewVersion = &v
	return s
}

// SetOptionalDeployment sets the OptionalDeployment field's value.
func (s *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails) SetOptionalDeployment(v bool) *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails {
	s.OptionalDeployment = &v
	return s
}

// SetUpdateAvailable sets the UpdateAvailable field's value.
func (s *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails) SetUpdateAvailable(v bool) *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails {
	s.UpdateAvailable = &v
	return s
}

// SetUpdateStatus sets the UpdateStatus field's value.
func (s *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails) SetUpdateStatus(v string) *AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails {
	s.UpdateStatus = &v
	return s
}

// Contains information that OpenSearch Service derives based on the VPCOptions
// for the domain.
type AwsOpenSearchServiceDomainVpcOptionsDetails struct {
	_ struct{} `type:"structure"`

	// The list of security group IDs that are associated with the VPC endpoints
	// for the domain.
	SecurityGroupIds []*string `type:"list"`

	// A list of subnet IDs that are associated with the VPC endpoints for the domain.
	SubnetIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainVpcOptionsDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsOpenSearchServiceDomainVpcOptionsDetails) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *AwsOpenSearchServiceDomainVpcOptionsDetails) SetSecurityGroupIds(v []*string) *AwsOpenSearchServiceDomainVpcOptionsDetails {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *AwsOpenSearchServiceDomainVpcOptionsDetails) SetSubnetIds(v []*string) *AwsOpenSearchServiceDomainVpcOptionsDetails {
	s.SubnetIds = v
	return s
}

// An IAM role that is associated with the Amazon RDS DB cluster.
type AwsRdsDbClusterAssociatedRole struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM role.
	RoleArn *string `type:"string"`

	// The status of the association between the IAM role and the DB cluster.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbClusterAssociatedRole) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbClusterAssociatedRole) GoString() string {
	return s.String()
}

// SetRoleArn sets the RoleArn field's value.
func (s *AwsRdsDbClusterAssociatedRole) SetRoleArn(v string) *AwsRdsDbClusterAssociatedRole {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbClusterAssociatedRole) SetStatus(v string) *AwsRdsDbClusterAssociatedRole {
	s.Status = &v
	return s
}

// Information about an Amazon RDS DB cluster.
type AwsRdsDbClusterDetails struct {
	_ struct{} `type:"structure"`

	// The status of the database activity stream.
	ActivityStreamStatus *string `type:"string"`

	// For all database engines except Aurora, specifies the allocated storage size
	// in gibibytes (GiB).
	AllocatedStorage *int64 `type:"integer"`

	// A list of the IAM roles that are associated with the DB cluster.
	AssociatedRoles []*AwsRdsDbClusterAssociatedRole `type:"list"`

	// A list of Availability Zones (AZs) where instances in the DB cluster can
	// be created.
	AvailabilityZones []*string `type:"list"`

	// The number of days for which automated backups are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// Indicates when the DB cluster was created, in Universal Coordinated Time
	// (UTC).
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	ClusterCreateTime *string `type:"string"`

	// Whether tags are copied from the DB cluster to snapshots of the DB cluster.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// Whether the DB cluster is a clone of a DB cluster owned by a different Amazon
	// Web Services account.
	CrossAccountClone *bool `type:"boolean"`

	// A list of custom endpoints for the DB cluster.
	CustomEndpoints []*string `type:"list"`

	// The name of the database.
	DatabaseName *string `type:"string"`

	// The DB cluster identifier that the user assigned to the cluster. This identifier
	// is the unique key that identifies a DB cluster.
	DbClusterIdentifier *string `type:"string"`

	// The list of instances that make up the DB cluster.
	DbClusterMembers []*AwsRdsDbClusterMember `type:"list"`

	// The list of option group memberships for this DB cluster.
	DbClusterOptionGroupMemberships []*AwsRdsDbClusterOptionGroupMembership `type:"list"`

	// The name of the DB cluster parameter group for the DB cluster.
	DbClusterParameterGroup *string `type:"string"`

	// The identifier of the DB cluster. The identifier must be unique within each
	// Amazon Web Services Region and is immutable.
	DbClusterResourceId *string `type:"string"`

	// The subnet group that is associated with the DB cluster, including the name,
	// description, and subnets in the subnet group.
	DbSubnetGroup *string `type:"string"`

	// Whether the DB cluster has deletion protection enabled.
	DeletionProtection *bool `type:"boolean"`

	// The Active Directory domain membership records that are associated with the
	// DB cluster.
	DomainMemberships []*AwsRdsDbDomainMembership `type:"list"`

	// A list of log types that this DB cluster is configured to export to CloudWatch
	// Logs.
	EnabledCloudWatchLogsExports []*string `type:"list"`

	// The connection endpoint for the primary instance of the DB cluster.
	Endpoint *string `type:"string"`

	// The name of the database engine to use for this DB cluster.
	Engine *string `type:"string"`

	// The database engine mode of the DB cluster.
	EngineMode *string `type:"string"`

	// The version number of the database engine to use.
	EngineVersion *string `type:"string"`

	// Specifies the identifier that Amazon Route 53 assigns when you create a hosted
	// zone.
	HostedZoneId *string `type:"string"`

	// Whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.
	HttpEndpointEnabled *bool `type:"boolean"`

	// Whether the mapping of IAM accounts to database accounts is enabled.
	IamDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// The ARN of the KMS master key that is used to encrypt the database instances
	// in the DB cluster.
	KmsKeyId *string `type:"string"`

	// The name of the master user for the DB cluster.
	MasterUsername *string `type:"string"`

	// Whether the DB cluster has instances in multiple Availability Zones.
	MultiAz *bool `type:"boolean"`

	// The port number on which the DB instances in the DB cluster accept connections.
	Port *int64 `type:"integer"`

	// The range of time each day when automated backups are created, if automated
	// backups are enabled.
	//
	// Uses the format HH:MM-HH:MM. For example, 04:52-05:22.
	PreferredBackupWindow *string `type:"string"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Uses the format <day>:HH:MM-<day>:HH:MM.
	//
	// For the day values, use mon|tue|wed|thu|fri|sat|sun.
	//
	// For example, sun:09:32-sun:10:02.
	PreferredMaintenanceWindow *string `type:"string"`

	// The identifiers of the read replicas that are associated with this DB cluster.
	ReadReplicaIdentifiers []*string `type:"list"`

	// The reader endpoint for the DB cluster.
	ReaderEndpoint *string `type:"string"`

	// The current status of this DB cluster.
	Status *string `type:"string"`

	// Whether the DB cluster is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// A list of VPC security groups that the DB cluster belongs to.
	VpcSecurityGroups []*AwsRdsDbInstanceVpcSecurityGroup `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbClusterDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbClusterDetails) GoString() string {
	return s.String()
}

// SetActivityStreamStatus sets the ActivityStreamStatus field's value.
func (s *AwsRdsDbClusterDetails) SetActivityStreamStatus(v string) *AwsRdsDbClusterDetails {
	s.ActivityStreamStatus = &v
	return s
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *AwsRdsDbClusterDetails) SetAllocatedStorage(v int64) *AwsRdsDbClusterDetails {
	s.AllocatedStorage = &v
	return s
}

// SetAssociatedRoles sets the AssociatedRoles field's value.
func (s *AwsRdsDbClusterDetails) SetAssociatedRoles(v []*AwsRdsDbClusterAssociatedRole) *AwsRdsDbClusterDetails {
	s.AssociatedRoles = v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *AwsRdsDbClusterDetails) SetAvailabilityZones(v []*string) *AwsRdsDbClusterDetails {
	s.AvailabilityZones = v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *AwsRdsDbClusterDetails) SetBackupRetentionPeriod(v int64) *AwsRdsDbClusterDetails {
	s.BackupRetentionPeriod = &v
	return s
}

// SetClusterCreateTime sets the ClusterCreateTime field's value.
func (s *AwsRdsDbClusterDetails) SetClusterCreateTime(v string) *AwsRdsDbClusterDetails {
	s.ClusterCreateTime = &v
	return s
}

// SetCopyTagsToSnapshot sets the CopyTagsToSnapshot field's value.
func (s *AwsRdsDbClusterDetails) SetCopyTagsToSnapshot(v bool) *AwsRdsDbClusterDetails {
	s.CopyTagsToSnapshot = &v
	return s
}

// SetCrossAccountClone sets the CrossAccountClone field's value.
func (s *AwsRdsDbClusterDetails) SetCrossAccountClone(v bool) *AwsRdsDbClusterDetails {
	s.CrossAccountClone = &v
	return s
}

// SetCustomEndpoints sets the CustomEndpoints field's value.
func (s *AwsRdsDbClusterDetails) SetCustomEndpoints(v []*string) *AwsRdsDbClusterDetails {
	s.CustomEndpoints = v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *AwsRdsDbClusterDetails) SetDatabaseName(v string) *AwsRdsDbClusterDetails {
	s.DatabaseName = &v
	return s
}

// SetDbClusterIdentifier sets the DbClusterIdentifier field's value.
func (s *AwsRdsDbClusterDetails) SetDbClusterIdentifier(v string) *AwsRdsDbClusterDetails {
	s.DbClusterIdentifier = &v
	return s
}

// SetDbClusterMembers sets the DbClusterMembers field's value.
func (s *AwsRdsDbClusterDetails) SetDbClusterMembers(v []*AwsRdsDbClusterMember) *AwsRdsDbClusterDetails {
	s.DbClusterMembers = v
	return s
}

// SetDbClusterOptionGroupMemberships sets the DbClusterOptionGroupMemberships field's value.
func (s *AwsRdsDbClusterDetails) SetDbClusterOptionGroupMemberships(v []*AwsRdsDbClusterOptionGroupMembership) *AwsRdsDbClusterDetails {
	s.DbClusterOptionGroupMemberships = v
	return s
}

// SetDbClusterParameterGroup sets the DbClusterParameterGroup field's value.
func (s *AwsRdsDbClusterDetails) SetDbClusterParameterGroup(v string) *AwsRdsDbClusterDetails {
	s.DbClusterParameterGroup = &v
	return s
}

// SetDbClusterResourceId sets the DbClusterResourceId field's value.
func (s *AwsRdsDbClusterDetails) SetDbClusterResourceId(v string) *AwsRdsDbClusterDetails {
	s.DbClusterResourceId = &v
	return s
}

// SetDbSubnetGroup sets the DbSubnetGroup field's value.
func (s *AwsRdsDbClusterDetails) SetDbSubnetGroup(v string) *AwsRdsDbClusterDetails {
	s.DbSubnetGroup = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *AwsRdsDbClusterDetails) SetDeletionProtection(v bool) *AwsRdsDbClusterDetails {
	s.DeletionProtection = &v
	return s
}

// SetDomainMemberships sets the DomainMemberships field's value.
func (s *AwsRdsDbClusterDetails) SetDomainMemberships(v []*AwsRdsDbDomainMembership) *AwsRdsDbClusterDetails {
	s.DomainMemberships = v
	return s
}

// SetEnabledCloudWatchLogsExports sets the EnabledCloudWatchLogsExports field's value.
func (s *AwsRdsDbClusterDetails) SetEnabledCloudWatchLogsExports(v []*string) *AwsRdsDbClusterDetails {
	s.EnabledCloudWatchLogsExports = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *AwsRdsDbClusterDetails) SetEndpoint(v string) *AwsRdsDbClusterDetails {
	s.Endpoint = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *AwsRdsDbClusterDetails) SetEngine(v string) *AwsRdsDbClusterDetails {
	s.Engine = &v
	return s
}

// SetEngineMode sets the EngineMode field's value.
func (s *AwsRdsDbClusterDetails) SetEngineMode(v string) *AwsRdsDbClusterDetails {
	s.EngineMode = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *AwsRdsDbClusterDetails) SetEngineVersion(v string) *AwsRdsDbClusterDetails {
	s.EngineVersion = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *AwsRdsDbClusterDetails) SetHostedZoneId(v string) *AwsRdsDbClusterDetails {
	s.HostedZoneId = &v
	return s
}

// SetHttpEndpointEnabled sets the HttpEndpointEnabled field's value.
func (s *AwsRdsDbClusterDetails) SetHttpEndpointEnabled(v bool) *AwsRdsDbClusterDetails {
	s.HttpEndpointEnabled = &v
	return s
}

// SetIamDatabaseAuthenticationEnabled sets the IamDatabaseAuthenticationEnabled field's value.
func (s *AwsRdsDbClusterDetails) SetIamDatabaseAuthenticationEnabled(v bool) *AwsRdsDbClusterDetails {
	s.IamDatabaseAuthenticationEnabled = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsRdsDbClusterDetails) SetKmsKeyId(v string) *AwsRdsDbClusterDetails {
	s.KmsKeyId = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *AwsRdsDbClusterDetails) SetMasterUsername(v string) *AwsRdsDbClusterDetails {
	s.MasterUsername = &v
	return s
}

// SetMultiAz sets the MultiAz field's value.
func (s *AwsRdsDbClusterDetails) SetMultiAz(v bool) *AwsRdsDbClusterDetails {
	s.MultiAz = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AwsRdsDbClusterDetails) SetPort(v int64) *AwsRdsDbClusterDetails {
	s.Port = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *AwsRdsDbClusterDetails) SetPreferredBackupWindow(v string) *AwsRdsDbClusterDetails {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *AwsRdsDbClusterDetails) SetPreferredMaintenanceWindow(v string) *AwsRdsDbClusterDetails {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetReadReplicaIdentifiers sets the ReadReplicaIdentifiers field's value.
func (s *AwsRdsDbClusterDetails) SetReadReplicaIdentifiers(v []*string) *AwsRdsDbClusterDetails {
	s.ReadReplicaIdentifiers = v
	return s
}

// SetReaderEndpoint sets the ReaderEndpoint field's value.
func (s *AwsRdsDbClusterDetails) SetReaderEndpoint(v string) *AwsRdsDbClusterDetails {
	s.ReaderEndpoint = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbClusterDetails) SetStatus(v string) *AwsRdsDbClusterDetails {
	s.Status = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *AwsRdsDbClusterDetails) SetStorageEncrypted(v bool) *AwsRdsDbClusterDetails {
	s.StorageEncrypted = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *AwsRdsDbClusterDetails) SetVpcSecurityGroups(v []*AwsRdsDbInstanceVpcSecurityGroup) *AwsRdsDbClusterDetails {
	s.VpcSecurityGroups = v
	return s
}

// Information about an instance in the DB cluster.
type AwsRdsDbClusterMember struct {
	_ struct{} `type:"structure"`

	// The status of the DB cluster parameter group for this member of the DB cluster.
	DbClusterParameterGroupStatus *string `type:"string"`

	// The instance identifier for this member of the DB cluster.
	DbInstanceIdentifier *string `type:"string"`

	// Whether the cluster member is the primary instance for the DB cluster.
	IsClusterWriter *bool `type:"boolean"`

	// Specifies the order in which an Aurora replica is promoted to the primary
	// instance when the existing primary instance fails.
	PromotionTier *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbClusterMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbClusterMember) GoString() string {
	return s.String()
}

// SetDbClusterParameterGroupStatus sets the DbClusterParameterGroupStatus field's value.
func (s *AwsRdsDbClusterMember) SetDbClusterParameterGroupStatus(v string) *AwsRdsDbClusterMember {
	s.DbClusterParameterGroupStatus = &v
	return s
}

// SetDbInstanceIdentifier sets the DbInstanceIdentifier field's value.
func (s *AwsRdsDbClusterMember) SetDbInstanceIdentifier(v string) *AwsRdsDbClusterMember {
	s.DbInstanceIdentifier = &v
	return s
}

// SetIsClusterWriter sets the IsClusterWriter field's value.
func (s *AwsRdsDbClusterMember) SetIsClusterWriter(v bool) *AwsRdsDbClusterMember {
	s.IsClusterWriter = &v
	return s
}

// SetPromotionTier sets the PromotionTier field's value.
func (s *AwsRdsDbClusterMember) SetPromotionTier(v int64) *AwsRdsDbClusterMember {
	s.PromotionTier = &v
	return s
}

// Information about an option group membership for a DB cluster.
type AwsRdsDbClusterOptionGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster option group.
	DbClusterOptionGroupName *string `type:"string"`

	// The status of the DB cluster option group.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbClusterOptionGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbClusterOptionGroupMembership) GoString() string {
	return s.String()
}

// SetDbClusterOptionGroupName sets the DbClusterOptionGroupName field's value.
func (s *AwsRdsDbClusterOptionGroupMembership) SetDbClusterOptionGroupName(v string) *AwsRdsDbClusterOptionGroupMembership {
	s.DbClusterOptionGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbClusterOptionGroupMembership) SetStatus(v string) *AwsRdsDbClusterOptionGroupMembership {
	s.Status = &v
	return s
}

// Information about an Amazon RDS DB cluster snapshot.
type AwsRdsDbClusterSnapshotDetails struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size in gibibytes (GiB).
	AllocatedStorage *int64 `type:"integer"`

	// A list of Availability Zones where instances in the DB cluster can be created.
	AvailabilityZones []*string `type:"list"`

	// Indicates when the DB cluster was created, in Universal Coordinated Time
	// (UTC).
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	ClusterCreateTime *string `type:"string"`

	// The DB cluster identifier.
	DbClusterIdentifier *string `type:"string"`

	// The identifier of the DB cluster snapshot.
	DbClusterSnapshotIdentifier *string `type:"string"`

	// The name of the database engine that you want to use for this DB instance.
	Engine *string `type:"string"`

	// The version of the database engine to use.
	EngineVersion *string `type:"string"`

	// Whether mapping of IAM accounts to database accounts is enabled.
	IamDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// The ARN of the KMS master key that is used to encrypt the database instances
	// in the DB cluster.
	KmsKeyId *string `type:"string"`

	// The license model information for this DB cluster snapshot.
	LicenseModel *string `type:"string"`

	// The name of the master user for the DB cluster.
	MasterUsername *string `type:"string"`

	// Specifies the percentage of the estimated data that has been transferred.
	PercentProgress *int64 `type:"integer"`

	// The port number on which the DB instances in the DB cluster accept connections.
	Port *int64 `type:"integer"`

	// Indicates when the snapshot was taken.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	SnapshotCreateTime *string `type:"string"`

	// The type of DB cluster snapshot.
	SnapshotType *string `type:"string"`

	// The status of this DB cluster snapshot.
	Status *string `type:"string"`

	// Whether the DB cluster is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// The VPC ID that is associated with the DB cluster snapshot.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbClusterSnapshotDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbClusterSnapshotDetails) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetAllocatedStorage(v int64) *AwsRdsDbClusterSnapshotDetails {
	s.AllocatedStorage = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetAvailabilityZones(v []*string) *AwsRdsDbClusterSnapshotDetails {
	s.AvailabilityZones = v
	return s
}

// SetClusterCreateTime sets the ClusterCreateTime field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetClusterCreateTime(v string) *AwsRdsDbClusterSnapshotDetails {
	s.ClusterCreateTime = &v
	return s
}

// SetDbClusterIdentifier sets the DbClusterIdentifier field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetDbClusterIdentifier(v string) *AwsRdsDbClusterSnapshotDetails {
	s.DbClusterIdentifier = &v
	return s
}

// SetDbClusterSnapshotIdentifier sets the DbClusterSnapshotIdentifier field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetDbClusterSnapshotIdentifier(v string) *AwsRdsDbClusterSnapshotDetails {
	s.DbClusterSnapshotIdentifier = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetEngine(v string) *AwsRdsDbClusterSnapshotDetails {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetEngineVersion(v string) *AwsRdsDbClusterSnapshotDetails {
	s.EngineVersion = &v
	return s
}

// SetIamDatabaseAuthenticationEnabled sets the IamDatabaseAuthenticationEnabled field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetIamDatabaseAuthenticationEnabled(v bool) *AwsRdsDbClusterSnapshotDetails {
	s.IamDatabaseAuthenticationEnabled = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetKmsKeyId(v string) *AwsRdsDbClusterSnapshotDetails {
	s.KmsKeyId = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetLicenseModel(v string) *AwsRdsDbClusterSnapshotDetails {
	s.LicenseModel = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetMasterUsername(v string) *AwsRdsDbClusterSnapshotDetails {
	s.MasterUsername = &v
	return s
}

// SetPercentProgress sets the PercentProgress field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetPercentProgress(v int64) *AwsRdsDbClusterSnapshotDetails {
	s.PercentProgress = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetPort(v int64) *AwsRdsDbClusterSnapshotDetails {
	s.Port = &v
	return s
}

// SetSnapshotCreateTime sets the SnapshotCreateTime field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetSnapshotCreateTime(v string) *AwsRdsDbClusterSnapshotDetails {
	s.SnapshotCreateTime = &v
	return s
}

// SetSnapshotType sets the SnapshotType field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetSnapshotType(v string) *AwsRdsDbClusterSnapshotDetails {
	s.SnapshotType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetStatus(v string) *AwsRdsDbClusterSnapshotDetails {
	s.Status = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetStorageEncrypted(v bool) *AwsRdsDbClusterSnapshotDetails {
	s.StorageEncrypted = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetVpcId(v string) *AwsRdsDbClusterSnapshotDetails {
	s.VpcId = &v
	return s
}

// Information about an Active Directory domain membership record associated
// with the DB instance.
type AwsRdsDbDomainMembership struct {
	_ struct{} `type:"structure"`

	// The identifier of the Active Directory domain.
	Domain *string `type:"string"`

	// The fully qualified domain name of the Active Directory domain.
	Fqdn *string `type:"string"`

	// The name of the IAM role to use when making API calls to the Directory Service.
	IamRoleName *string `type:"string"`

	// The status of the Active Directory Domain membership for the DB instance.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbDomainMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbDomainMembership) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *AwsRdsDbDomainMembership) SetDomain(v string) *AwsRdsDbDomainMembership {
	s.Domain = &v
	return s
}

// SetFqdn sets the Fqdn field's value.
func (s *AwsRdsDbDomainMembership) SetFqdn(v string) *AwsRdsDbDomainMembership {
	s.Fqdn = &v
	return s
}

// SetIamRoleName sets the IamRoleName field's value.
func (s *AwsRdsDbDomainMembership) SetIamRoleName(v string) *AwsRdsDbDomainMembership {
	s.IamRoleName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbDomainMembership) SetStatus(v string) *AwsRdsDbDomainMembership {
	s.Status = &v
	return s
}

// An IAM role associated with the DB instance.
type AwsRdsDbInstanceAssociatedRole struct {
	_ struct{} `type:"structure"`

	// The name of the feature associated with the IAM role.
	FeatureName *string `type:"string"`

	// The ARN of the IAM role that is associated with the DB instance.
	RoleArn *string `type:"string"`

	// Describes the state of the association between the IAM role and the DB instance.
	// The Status property returns one of the following values:
	//
	//    * ACTIVE - The IAM role ARN is associated with the DB instance and can
	//    be used to access other Amazon Web Services services on your behalf.
	//
	//    * PENDING - The IAM role ARN is being associated with the DB instance.
	//
	//    * INVALID - The IAM role ARN is associated with the DB instance. But the
	//    DB instance is unable to assume the IAM role in order to access other
	//    Amazon Web Services services on your behalf.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbInstanceAssociatedRole) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbInstanceAssociatedRole) GoString() string {
	return s.String()
}

// SetFeatureName sets the FeatureName field's value.
func (s *AwsRdsDbInstanceAssociatedRole) SetFeatureName(v string) *AwsRdsDbInstanceAssociatedRole {
	s.FeatureName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AwsRdsDbInstanceAssociatedRole) SetRoleArn(v string) *AwsRdsDbInstanceAssociatedRole {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbInstanceAssociatedRole) SetStatus(v string) *AwsRdsDbInstanceAssociatedRole {
	s.Status = &v
	return s
}

// Contains the details of an Amazon RDS DB instance.
type AwsRdsDbInstanceDetails struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) to initially allocate for the DB instance.
	AllocatedStorage *int64 `type:"integer"`

	// The IAM roles associated with the DB instance.
	AssociatedRoles []*AwsRdsDbInstanceAssociatedRole `type:"list"`

	// Indicates whether minor version patches are applied automatically.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The Availability Zone where the DB instance will be created.
	AvailabilityZone *string `type:"string"`

	// The number of days for which to retain automated backups.
	BackupRetentionPeriod *int64 `type:"integer"`

	// The identifier of the CA certificate for this DB instance.
	CACertificateIdentifier *string `type:"string"`

	// The name of the character set that this DB instance is associated with.
	CharacterSetName *string `type:"string"`

	// Whether to copy resource tags to snapshots of the DB instance.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// If the DB instance is a member of a DB cluster, contains the name of the
	// DB cluster that the DB instance is a member of.
	DBClusterIdentifier *string `type:"string"`

	// Contains the name of the compute and memory capacity class of the DB instance.
	DBInstanceClass *string `type:"string"`

	// Contains a user-supplied database identifier. This identifier is the unique
	// key that identifies a DB instance.
	DBInstanceIdentifier *string `type:"string"`

	// The meaning of this parameter differs according to the database engine you
	// use.
	//
	// MySQL, MariaDB, SQL Server, PostgreSQL
	//
	// Contains the name of the initial database of this instance that was provided
	// at create time, if one was specified when the DB instance was created. This
	// same name is returned for the life of the DB instance.
	//
	// Oracle
	//
	// Contains the Oracle System ID (SID) of the created DB instance. Not shown
	// when the returned parameters do not apply to an Oracle DB instance.
	DBName *string `type:"string"`

	// Specifies the port that the DB instance listens on. If the DB instance is
	// part of a DB cluster, this can be a different port than the DB cluster port.
	DbInstancePort *int64 `type:"integer"`

	// The current status of the DB instance.
	DbInstanceStatus *string `type:"string"`

	// A list of the DB parameter groups to assign to the DB instance.
	DbParameterGroups []*AwsRdsDbParameterGroup `type:"list"`

	// A list of the DB security groups to assign to the DB instance.
	DbSecurityGroups []*string `type:"list"`

	// Information about the subnet group that is associated with the DB instance.
	DbSubnetGroup *AwsRdsDbSubnetGroup `type:"structure"`

	// The Amazon Web Services Region-unique, immutable identifier for the DB instance.
	// This identifier is found in CloudTrail log entries whenever the KMS key for
	// the DB instance is accessed.
	DbiResourceId *string `type:"string"`

	// Indicates whether the DB instance has deletion protection enabled.
	//
	// When deletion protection is enabled, the database cannot be deleted.
	DeletionProtection *bool `type:"boolean"`

	// The Active Directory domain membership records associated with the DB instance.
	DomainMemberships []*AwsRdsDbDomainMembership `type:"list"`

	// A list of log types that this DB instance is configured to export to CloudWatch
	// Logs.
	EnabledCloudWatchLogsExports []*string `type:"list"`

	// Specifies the connection endpoint.
	Endpoint *AwsRdsDbInstanceEndpoint `type:"structure"`

	// Provides the name of the database engine to use for this DB instance.
	Engine *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// The ARN of the CloudWatch Logs log stream that receives the enhanced monitoring
	// metrics data for the DB instance.
	EnhancedMonitoringResourceArn *string `type:"string"`

	// True if mapping of IAM accounts to database accounts is enabled, and otherwise
	// false.
	//
	// IAM database authentication can be enabled for the following database engines.
	//
	//    * For MySQL 5.6, minor version 5.6.34 or higher
	//
	//    * For MySQL 5.7, minor version 5.7.16 or higher
	//
	//    * Aurora 5.6 or higher
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// Indicates when the DB instance was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	InstanceCreateTime *string `type:"string"`

	// Specifies the provisioned IOPS (I/O operations per second) for this DB instance.
	Iops *int64 `type:"integer"`

	// If StorageEncrypted is true, the KMS key identifier for the encrypted DB
	// instance.
	KmsKeyId *string `type:"string"`

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LatestRestorableTime *string `type:"string"`

	// License model information for this DB instance.
	LicenseModel *string `type:"string"`

	// Specifies the connection endpoint.
	ListenerEndpoint *AwsRdsDbInstanceEndpoint `type:"structure"`

	// The master user name of the DB instance.
	MasterUsername *string `type:"string"`

	// The upper limit to which Amazon RDS can automatically scale the storage of
	// the DB instance.
	MaxAllocatedStorage *int64 `type:"integer"`

	// The interval, in seconds, between points when enhanced monitoring metrics
	// are collected for the DB instance.
	MonitoringInterval *int64 `type:"integer"`

	// The ARN for the IAM role that permits Amazon RDS to send enhanced monitoring
	// metrics to CloudWatch Logs.
	MonitoringRoleArn *string `type:"string"`

	// Whether the DB instance is a multiple Availability Zone deployment.
	MultiAz *bool `type:"boolean"`

	// The list of option group memberships for this DB instance.
	OptionGroupMemberships []*AwsRdsDbOptionGroupMembership `type:"list"`

	// Changes to the DB instance that are currently pending.
	PendingModifiedValues *AwsRdsDbPendingModifiedValues `type:"structure"`

	// Indicates whether Performance Insights is enabled for the DB instance.
	PerformanceInsightsEnabled *bool `type:"boolean"`

	// The identifier of the KMS key used to encrypt the Performance Insights data.
	PerformanceInsightsKmsKeyId *string `type:"string"`

	// The number of days to retain Performance Insights data.
	PerformanceInsightsRetentionPeriod *int64 `type:"integer"`

	// The range of time each day when automated backups are created, if automated
	// backups are enabled.
	//
	// Uses the format HH:MM-HH:MM. For example, 04:52-05:22.
	PreferredBackupWindow *string `type:"string"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Uses the format <day>:HH:MM-<day>:HH:MM.
	//
	// For the day values, use mon|tue|wed|thu|fri|sat|sun.
	//
	// For example, sun:09:32-sun:10:02.
	PreferredMaintenanceWindow *string `type:"string"`

	// The number of CPU cores and the number of threads per core for the DB instance
	// class of the DB instance.
	ProcessorFeatures []*AwsRdsDbProcessorFeature `type:"list"`

	// The order in which to promote an Aurora replica to the primary instance after
	// a failure of the existing primary instance.
	PromotionTier *int64 `type:"integer"`

	// Specifies the accessibility options for the DB instance.
	//
	// A value of true specifies an Internet-facing instance with a publicly resolvable
	// DNS name, which resolves to a public IP address.
	//
	// A value of false specifies an internal instance with a DNS name that resolves
	// to a private IP address.
	PubliclyAccessible *bool `type:"boolean"`

	// List of identifiers of Aurora DB clusters to which the RDS DB instance is
	// replicated as a read replica.
	ReadReplicaDBClusterIdentifiers []*string `type:"list"`

	// List of identifiers of the read replicas associated with this DB instance.
	ReadReplicaDBInstanceIdentifiers []*string `type:"list"`

	// If this DB instance is a read replica, contains the identifier of the source
	// DB instance.
	ReadReplicaSourceDBInstanceIdentifier *string `type:"string"`

	// For a DB instance with multi-Availability Zone support, the name of the secondary
	// Availability Zone.
	SecondaryAvailabilityZone *string `type:"string"`

	// The status of a read replica. If the instance isn't a read replica, this
	// is empty.
	StatusInfos []*AwsRdsDbStatusInfo `type:"list"`

	// Specifies whether the DB instance is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// The storage type for the DB instance.
	StorageType *string `type:"string"`

	// The ARN from the key store with which the instance is associated for TDE
	// encryption.
	TdeCredentialArn *string `type:"string"`

	// The time zone of the DB instance.
	Timezone *string `type:"string"`

	// A list of VPC security groups that the DB instance belongs to.
	VpcSecurityGroups []*AwsRdsDbInstanceVpcSecurityGroup `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbInstanceDetails) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *AwsRdsDbInstanceDetails) SetAllocatedStorage(v int64) *AwsRdsDbInstanceDetails {
	s.AllocatedStorage = &v
	return s
}

// SetAssociatedRoles sets the AssociatedRoles field's value.
func (s *AwsRdsDbInstanceDetails) SetAssociatedRoles(v []*AwsRdsDbInstanceAssociatedRole) *AwsRdsDbInstanceDetails {
	s.AssociatedRoles = v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *AwsRdsDbInstanceDetails) SetAutoMinorVersionUpgrade(v bool) *AwsRdsDbInstanceDetails {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *AwsRdsDbInstanceDetails) SetAvailabilityZone(v string) *AwsRdsDbInstanceDetails {
	s.AvailabilityZone = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *AwsRdsDbInstanceDetails) SetBackupRetentionPeriod(v int64) *AwsRdsDbInstanceDetails {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCACertificateIdentifier sets the CACertificateIdentifier field's value.
func (s *AwsRdsDbInstanceDetails) SetCACertificateIdentifier(v string) *AwsRdsDbInstanceDetails {
	s.CACertificateIdentifier = &v
	return s
}

// SetCharacterSetName sets the CharacterSetName field's value.
func (s *AwsRdsDbInstanceDetails) SetCharacterSetName(v string) *AwsRdsDbInstanceDetails {
	s.CharacterSetName = &v
	return s
}

// SetCopyTagsToSnapshot sets the CopyTagsToSnapshot field's value.
func (s *AwsRdsDbInstanceDetails) SetCopyTagsToSnapshot(v bool) *AwsRdsDbInstanceDetails {
	s.CopyTagsToSnapshot = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *AwsRdsDbInstanceDetails) SetDBClusterIdentifier(v string) *AwsRdsDbInstanceDetails {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *AwsRdsDbInstanceDetails) SetDBInstanceClass(v string) *AwsRdsDbInstanceDetails {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *AwsRdsDbInstanceDetails) SetDBInstanceIdentifier(v string) *AwsRdsDbInstanceDetails {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBName sets the DBName field's value.
func (s *AwsRdsDbInstanceDetails) SetDBName(v string) *AwsRdsDbInstanceDetails {
	s.DBName = &v
	return s
}

// SetDbInstancePort sets the DbInstancePort field's value.
func (s *AwsRdsDbInstanceDetails) SetDbInstancePort(v int64) *AwsRdsDbInstanceDetails {
	s.DbInstancePort = &v
	return s
}

// SetDbInstanceStatus sets the DbInstanceStatus field's value.
func (s *AwsRdsDbInstanceDetails) SetDbInstanceStatus(v string) *AwsRdsDbInstanceDetails {
	s.DbInstanceStatus = &v
	return s
}

// SetDbParameterGroups sets the DbParameterGroups field's value.
func (s *AwsRdsDbInstanceDetails) SetDbParameterGroups(v []*AwsRdsDbParameterGroup) *AwsRdsDbInstanceDetails {
	s.DbParameterGroups = v
	return s
}

// SetDbSecurityGroups sets the DbSecurityGroups field's value.
func (s *AwsRdsDbInstanceDetails) SetDbSecurityGroups(v []*string) *AwsRdsDbInstanceDetails {
	s.DbSecurityGroups = v
	return s
}

// SetDbSubnetGroup sets the DbSubnetGroup field's value.
func (s *AwsRdsDbInstanceDetails) SetDbSubnetGroup(v *AwsRdsDbSubnetGroup) *AwsRdsDbInstanceDetails {
	s.DbSubnetGroup = v
	return s
}

// SetDbiResourceId sets the DbiResourceId field's value.
func (s *AwsRdsDbInstanceDetails) SetDbiResourceId(v string) *AwsRdsDbInstanceDetails {
	s.DbiResourceId = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *AwsRdsDbInstanceDetails) SetDeletionProtection(v bool) *AwsRdsDbInstanceDetails {
	s.DeletionProtection = &v
	return s
}

// SetDomainMemberships sets the DomainMemberships field's value.
func (s *AwsRdsDbInstanceDetails) SetDomainMemberships(v []*AwsRdsDbDomainMembership) *AwsRdsDbInstanceDetails {
	s.DomainMemberships = v
	return s
}

// SetEnabledCloudWatchLogsExports sets the EnabledCloudWatchLogsExports field's value.
func (s *AwsRdsDbInstanceDetails) SetEnabledCloudWatchLogsExports(v []*string) *AwsRdsDbInstanceDetails {
	s.EnabledCloudWatchLogsExports = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *AwsRdsDbInstanceDetails) SetEndpoint(v *AwsRdsDbInstanceEndpoint) *AwsRdsDbInstanceDetails {
	s.Endpoint = v
	return s
}

// SetEngine sets the Engine field's value.
func (s *AwsRdsDbInstanceDetails) SetEngine(v string) *AwsRdsDbInstanceDetails {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *AwsRdsDbInstanceDetails) SetEngineVersion(v string) *AwsRdsDbInstanceDetails {
	s.EngineVersion = &v
	return s
}

// SetEnhancedMonitoringResourceArn sets the EnhancedMonitoringResourceArn field's value.
func (s *AwsRdsDbInstanceDetails) SetEnhancedMonitoringResourceArn(v string) *AwsRdsDbInstanceDetails {
	s.EnhancedMonitoringResourceArn = &v
	return s
}

// SetIAMDatabaseAuthenticationEnabled sets the IAMDatabaseAuthenticationEnabled field's value.
func (s *AwsRdsDbInstanceDetails) SetIAMDatabaseAuthenticationEnabled(v bool) *AwsRdsDbInstanceDetails {
	s.IAMDatabaseAuthenticationEnabled = &v
	return s
}

// SetInstanceCreateTime sets the InstanceCreateTime field's value.
func (s *AwsRdsDbInstanceDetails) SetInstanceCreateTime(v string) *AwsRdsDbInstanceDetails {
	s.InstanceCreateTime = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *AwsRdsDbInstanceDetails) SetIops(v int64) *AwsRdsDbInstanceDetails {
	s.Iops = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsRdsDbInstanceDetails) SetKmsKeyId(v string) *AwsRdsDbInstanceDetails {
	s.KmsKeyId = &v
	return s
}

// SetLatestRestorableTime sets the LatestRestorableTime field's value.
func (s *AwsRdsDbInstanceDetails) SetLatestRestorableTime(v string) *AwsRdsDbInstanceDetails {
	s.LatestRestorableTime = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *AwsRdsDbInstanceDetails) SetLicenseModel(v string) *AwsRdsDbInstanceDetails {
	s.LicenseModel = &v
	return s
}

// SetListenerEndpoint sets the ListenerEndpoint field's value.
func (s *AwsRdsDbInstanceDetails) SetListenerEndpoint(v *AwsRdsDbInstanceEndpoint) *AwsRdsDbInstanceDetails {
	s.ListenerEndpoint = v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *AwsRdsDbInstanceDetails) SetMasterUsername(v string) *AwsRdsDbInstanceDetails {
	s.MasterUsername = &v
	return s
}

// SetMaxAllocatedStorage sets the MaxAllocatedStorage field's value.
func (s *AwsRdsDbInstanceDetails) SetMaxAllocatedStorage(v int64) *AwsRdsDbInstanceDetails {
	s.MaxAllocatedStorage = &v
	return s
}

// SetMonitoringInterval sets the MonitoringInterval field's value.
func (s *AwsRdsDbInstanceDetails) SetMonitoringInterval(v int64) *AwsRdsDbInstanceDetails {
	s.MonitoringInterval = &v
	return s
}

// SetMonitoringRoleArn sets the MonitoringRoleArn field's value.
func (s *AwsRdsDbInstanceDetails) SetMonitoringRoleArn(v string) *AwsRdsDbInstanceDetails {
	s.MonitoringRoleArn = &v
	return s
}

// SetMultiAz sets the MultiAz field's value.
func (s *AwsRdsDbInstanceDetails) SetMultiAz(v bool) *AwsRdsDbInstanceDetails {
	s.MultiAz = &v
	return s
}

// SetOptionGroupMemberships sets the OptionGroupMemberships field's value.
func (s *AwsRdsDbInstanceDetails) SetOptionGroupMemberships(v []*AwsRdsDbOptionGroupMembership) *AwsRdsDbInstanceDetails {
	s.OptionGroupMemberships = v
	return s
}

// SetPendingModifiedValues sets the PendingModifiedValues field's value.
func (s *AwsRdsDbInstanceDetails) SetPendingModifiedValues(v *AwsRdsDbPendingModifiedValues) *AwsRdsDbInstanceDetails {
	s.PendingModifiedValues = v
	return s
}

// SetPerformanceInsightsEnabled sets the PerformanceInsightsEnabled field's value.
func (s *AwsRdsDbInstanceDetails) SetPerformanceInsightsEnabled(v bool) *AwsRdsDbInstanceDetails {
	s.PerformanceInsightsEnabled = &v
	return s
}

// SetPerformanceInsightsKmsKeyId sets the PerformanceInsightsKmsKeyId field's value.
func (s *AwsRdsDbInstanceDetails) SetPerformanceInsightsKmsKeyId(v string) *AwsRdsDbInstanceDetails {
	s.PerformanceInsightsKmsKeyId = &v
	return s
}

// SetPerformanceInsightsRetentionPeriod sets the PerformanceInsightsRetentionPeriod field's value.
func (s *AwsRdsDbInstanceDetails) SetPerformanceInsightsRetentionPeriod(v int64) *AwsRdsDbInstanceDetails {
	s.PerformanceInsightsRetentionPeriod = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *AwsRdsDbInstanceDetails) SetPreferredBackupWindow(v string) *AwsRdsDbInstanceDetails {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *AwsRdsDbInstanceDetails) SetPreferredMaintenanceWindow(v string) *AwsRdsDbInstanceDetails {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetProcessorFeatures sets the ProcessorFeatures field's value.
func (s *AwsRdsDbInstanceDetails) SetProcessorFeatures(v []*AwsRdsDbProcessorFeature) *AwsRdsDbInstanceDetails {
	s.ProcessorFeatures = v
	return s
}

// SetPromotionTier sets the PromotionTier field's value.
func (s *AwsRdsDbInstanceDetails) SetPromotionTier(v int64) *AwsRdsDbInstanceDetails {
	s.PromotionTier = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *AwsRdsDbInstanceDetails) SetPubliclyAccessible(v bool) *AwsRdsDbInstanceDetails {
	s.PubliclyAccessible = &v
	return s
}

// SetReadReplicaDBClusterIdentifiers sets the ReadReplicaDBClusterIdentifiers field's value.
func (s *AwsRdsDbInstanceDetails) SetReadReplicaDBClusterIdentifiers(v []*string) *AwsRdsDbInstanceDetails {
	s.ReadReplicaDBClusterIdentifiers = v
	return s
}

// SetReadReplicaDBInstanceIdentifiers sets the ReadReplicaDBInstanceIdentifiers field's value.
func (s *AwsRdsDbInstanceDetails) SetReadReplicaDBInstanceIdentifiers(v []*string) *AwsRdsDbInstanceDetails {
	s.ReadReplicaDBInstanceIdentifiers = v
	return s
}

// SetReadReplicaSourceDBInstanceIdentifier sets the ReadReplicaSourceDBInstanceIdentifier field's value.
func (s *AwsRdsDbInstanceDetails) SetReadReplicaSourceDBInstanceIdentifier(v string) *AwsRdsDbInstanceDetails {
	s.ReadReplicaSourceDBInstanceIdentifier = &v
	return s
}

// SetSecondaryAvailabilityZone sets the SecondaryAvailabilityZone field's value.
func (s *AwsRdsDbInstanceDetails) SetSecondaryAvailabilityZone(v string) *AwsRdsDbInstanceDetails {
	s.SecondaryAvailabilityZone = &v
	return s
}

// SetStatusInfos sets the StatusInfos field's value.
func (s *AwsRdsDbInstanceDetails) SetStatusInfos(v []*AwsRdsDbStatusInfo) *AwsRdsDbInstanceDetails {
	s.StatusInfos = v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *AwsRdsDbInstanceDetails) SetStorageEncrypted(v bool) *AwsRdsDbInstanceDetails {
	s.StorageEncrypted = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *AwsRdsDbInstanceDetails) SetStorageType(v string) *AwsRdsDbInstanceDetails {
	s.StorageType = &v
	return s
}

// SetTdeCredentialArn sets the TdeCredentialArn field's value.
func (s *AwsRdsDbInstanceDetails) SetTdeCredentialArn(v string) *AwsRdsDbInstanceDetails {
	s.TdeCredentialArn = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *AwsRdsDbInstanceDetails) SetTimezone(v string) *AwsRdsDbInstanceDetails {
	s.Timezone = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *AwsRdsDbInstanceDetails) SetVpcSecurityGroups(v []*AwsRdsDbInstanceVpcSecurityGroup) *AwsRdsDbInstanceDetails {
	s.VpcSecurityGroups = v
	return s
}

// Specifies the connection endpoint.
type AwsRdsDbInstanceEndpoint struct {
	_ struct{} `type:"structure"`

	// Specifies the DNS address of the DB instance.
	Address *string `type:"string"`

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string `type:"string"`

	// Specifies the port that the database engine is listening on.
	Port *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbInstanceEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbInstanceEndpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *AwsRdsDbInstanceEndpoint) SetAddress(v string) *AwsRdsDbInstanceEndpoint {
	s.Address = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *AwsRdsDbInstanceEndpoint) SetHostedZoneId(v string) *AwsRdsDbInstanceEndpoint {
	s.HostedZoneId = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AwsRdsDbInstanceEndpoint) SetPort(v int64) *AwsRdsDbInstanceEndpoint {
	s.Port = &v
	return s
}

// A VPC security groups that the DB instance belongs to.
type AwsRdsDbInstanceVpcSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The name of the VPC security group.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbInstanceVpcSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbInstanceVpcSecurityGroup) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbInstanceVpcSecurityGroup) SetStatus(v string) *AwsRdsDbInstanceVpcSecurityGroup {
	s.Status = &v
	return s
}

// SetVpcSecurityGroupId sets the VpcSecurityGroupId field's value.
func (s *AwsRdsDbInstanceVpcSecurityGroup) SetVpcSecurityGroupId(v string) *AwsRdsDbInstanceVpcSecurityGroup {
	s.VpcSecurityGroupId = &v
	return s
}

// An option group membership.
type AwsRdsDbOptionGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the option group.
	OptionGroupName *string `type:"string"`

	// The status of the option group membership.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbOptionGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbOptionGroupMembership) GoString() string {
	return s.String()
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *AwsRdsDbOptionGroupMembership) SetOptionGroupName(v string) *AwsRdsDbOptionGroupMembership {
	s.OptionGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbOptionGroupMembership) SetStatus(v string) *AwsRdsDbOptionGroupMembership {
	s.Status = &v
	return s
}

// Provides information about a parameter group for a DB instance.
type AwsRdsDbParameterGroup struct {
	_ struct{} `type:"structure"`

	// The name of the parameter group.
	DbParameterGroupName *string `type:"string"`

	// The status of parameter updates.
	ParameterApplyStatus *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbParameterGroup) GoString() string {
	return s.String()
}

// SetDbParameterGroupName sets the DbParameterGroupName field's value.
func (s *AwsRdsDbParameterGroup) SetDbParameterGroupName(v string) *AwsRdsDbParameterGroup {
	s.DbParameterGroupName = &v
	return s
}

// SetParameterApplyStatus sets the ParameterApplyStatus field's value.
func (s *AwsRdsDbParameterGroup) SetParameterApplyStatus(v string) *AwsRdsDbParameterGroup {
	s.ParameterApplyStatus = &v
	return s
}

// Changes to a DB instance that are currently pending.
type AwsRdsDbPendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// The new value of the allocated storage for the DB instance.
	AllocatedStorage *int64 `type:"integer"`

	// The new backup retention period for the DB instance.
	BackupRetentionPeriod *int64 `type:"integer"`

	// The new CA certificate identifier for the DB instance.
	CaCertificateIdentifier *string `type:"string"`

	// The new DB instance class for the DB instance.
	DbInstanceClass *string `type:"string"`

	// The new DB instance identifier for the DB instance.
	DbInstanceIdentifier *string `type:"string"`

	// The name of the new subnet group for the DB instance.
	DbSubnetGroupName *string `type:"string"`

	// The new engine version for the DB instance.
	EngineVersion *string `type:"string"`

	// The new provisioned IOPS value for the DB instance.
	Iops *int64 `type:"integer"`

	// The new license model value for the DB instance.
	LicenseModel *string `type:"string"`

	// The new master user password for the DB instance.
	MasterUserPassword *string `type:"string"`

	// Indicates that a single Availability Zone DB instance is changing to a multiple
	// Availability Zone deployment.
	MultiAZ *bool `type:"boolean"`

	// A list of log types that are being enabled or disabled.
	PendingCloudWatchLogsExports *AwsRdsPendingCloudWatchLogsExports `type:"structure"`

	// The new port for the DB instance.
	Port *int64 `type:"integer"`

	// Processor features that are being updated.
	ProcessorFeatures []*AwsRdsDbProcessorFeature `type:"list"`

	// The new storage type for the DB instance.
	StorageType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbPendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbPendingModifiedValues) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *AwsRdsDbPendingModifiedValues) SetAllocatedStorage(v int64) *AwsRdsDbPendingModifiedValues {
	s.AllocatedStorage = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *AwsRdsDbPendingModifiedValues) SetBackupRetentionPeriod(v int64) *AwsRdsDbPendingModifiedValues {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCaCertificateIdentifier sets the CaCertificateIdentifier field's value.
func (s *AwsRdsDbPendingModifiedValues) SetCaCertificateIdentifier(v string) *AwsRdsDbPendingModifiedValues {
	s.CaCertificateIdentifier = &v
	return s
}

// SetDbInstanceClass sets the DbInstanceClass field's value.
func (s *AwsRdsDbPendingModifiedValues) SetDbInstanceClass(v string) *AwsRdsDbPendingModifiedValues {
	s.DbInstanceClass = &v
	return s
}

// SetDbInstanceIdentifier sets the DbInstanceIdentifier field's value.
func (s *AwsRdsDbPendingModifiedValues) SetDbInstanceIdentifier(v string) *AwsRdsDbPendingModifiedValues {
	s.DbInstanceIdentifier = &v
	return s
}

// SetDbSubnetGroupName sets the DbSubnetGroupName field's value.
func (s *AwsRdsDbPendingModifiedValues) SetDbSubnetGroupName(v string) *AwsRdsDbPendingModifiedValues {
	s.DbSubnetGroupName = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *AwsRdsDbPendingModifiedValues) SetEngineVersion(v string) *AwsRdsDbPendingModifiedValues {
	s.EngineVersion = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *AwsRdsDbPendingModifiedValues) SetIops(v int64) *AwsRdsDbPendingModifiedValues {
	s.Iops = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *AwsRdsDbPendingModifiedValues) SetLicenseModel(v string) *AwsRdsDbPendingModifiedValues {
	s.LicenseModel = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *AwsRdsDbPendingModifiedValues) SetMasterUserPassword(v string) *AwsRdsDbPendingModifiedValues {
	s.MasterUserPassword = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *AwsRdsDbPendingModifiedValues) SetMultiAZ(v bool) *AwsRdsDbPendingModifiedValues {
	s.MultiAZ = &v
	return s
}

// SetPendingCloudWatchLogsExports sets the PendingCloudWatchLogsExports field's value.
func (s *AwsRdsDbPendingModifiedValues) SetPendingCloudWatchLogsExports(v *AwsRdsPendingCloudWatchLogsExports) *AwsRdsDbPendingModifiedValues {
	s.PendingCloudWatchLogsExports = v
	return s
}

// SetPort sets the Port field's value.
func (s *AwsRdsDbPendingModifiedValues) SetPort(v int64) *AwsRdsDbPendingModifiedValues {
	s.Port = &v
	return s
}

// SetProcessorFeatures sets the ProcessorFeatures field's value.
func (s *AwsRdsDbPendingModifiedValues) SetProcessorFeatures(v []*AwsRdsDbProcessorFeature) *AwsRdsDbPendingModifiedValues {
	s.ProcessorFeatures = v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *AwsRdsDbPendingModifiedValues) SetStorageType(v string) *AwsRdsDbPendingModifiedValues {
	s.StorageType = &v
	return s
}

// A processor feature.
type AwsRdsDbProcessorFeature struct {
	_ struct{} `type:"structure"`

	// The name of the processor feature.
	Name *string `type:"string"`

	// The value of the processor feature.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbProcessorFeature) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbProcessorFeature) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsRdsDbProcessorFeature) SetName(v string) *AwsRdsDbProcessorFeature {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsRdsDbProcessorFeature) SetValue(v string) *AwsRdsDbProcessorFeature {
	s.Value = &v
	return s
}

// Provides information about an Amazon RDS DB security group.
type AwsRdsDbSecurityGroupDetails struct {
	_ struct{} `type:"structure"`

	// The ARN for the DB security group.
	DbSecurityGroupArn *string `type:"string"`

	// Provides the description of the DB security group.
	DbSecurityGroupDescription *string `type:"string"`

	// Specifies the name of the DB security group.
	DbSecurityGroupName *string `type:"string"`

	// Contains a list of EC2 security groups.
	Ec2SecurityGroups []*AwsRdsDbSecurityGroupEc2SecurityGroup `type:"list"`

	// Contains a list of IP ranges.
	IpRanges []*AwsRdsDbSecurityGroupIpRange `type:"list"`

	// Provides the Amazon Web Services ID of the owner of a specific DB security
	// group.
	OwnerId *string `type:"string"`

	// Provides VPC ID associated with the DB security group.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbSecurityGroupDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbSecurityGroupDetails) GoString() string {
	return s.String()
}

// SetDbSecurityGroupArn sets the DbSecurityGroupArn field's value.
func (s *AwsRdsDbSecurityGroupDetails) SetDbSecurityGroupArn(v string) *AwsRdsDbSecurityGroupDetails {
	s.DbSecurityGroupArn = &v
	return s
}

// SetDbSecurityGroupDescription sets the DbSecurityGroupDescription field's value.
func (s *AwsRdsDbSecurityGroupDetails) SetDbSecurityGroupDescription(v string) *AwsRdsDbSecurityGroupDetails {
	s.DbSecurityGroupDescription = &v
	return s
}

// SetDbSecurityGroupName sets the DbSecurityGroupName field's value.
func (s *AwsRdsDbSecurityGroupDetails) SetDbSecurityGroupName(v string) *AwsRdsDbSecurityGroupDetails {
	s.DbSecurityGroupName = &v
	return s
}

// SetEc2SecurityGroups sets the Ec2SecurityGroups field's value.
func (s *AwsRdsDbSecurityGroupDetails) SetEc2SecurityGroups(v []*AwsRdsDbSecurityGroupEc2SecurityGroup) *AwsRdsDbSecurityGroupDetails {
	s.Ec2SecurityGroups = v
	return s
}

// SetIpRanges sets the IpRanges field's value.
func (s *AwsRdsDbSecurityGroupDetails) SetIpRanges(v []*AwsRdsDbSecurityGroupIpRange) *AwsRdsDbSecurityGroupDetails {
	s.IpRanges = v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *AwsRdsDbSecurityGroupDetails) SetOwnerId(v string) *AwsRdsDbSecurityGroupDetails {
	s.OwnerId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsRdsDbSecurityGroupDetails) SetVpcId(v string) *AwsRdsDbSecurityGroupDetails {
	s.VpcId = &v
	return s
}

// EC2 security group information for an RDS DB security group.
type AwsRdsDbSecurityGroupEc2SecurityGroup struct {
	_ struct{} `type:"structure"`

	// Specifies the ID for the EC2 security group.
	Ec2SecurityGroupId *string `type:"string"`

	// Specifies the name of the EC2 security group.
	Ec2SecurityGroupName *string `type:"string"`

	// Provides the Amazon Web Services ID of the owner of the EC2 security group.
	Ec2SecurityGroupOwnerId *string `type:"string"`

	// Provides the status of the EC2 security group.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbSecurityGroupEc2SecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbSecurityGroupEc2SecurityGroup) GoString() string {
	return s.String()
}

// SetEc2SecurityGroupId sets the Ec2SecurityGroupId field's value.
func (s *AwsRdsDbSecurityGroupEc2SecurityGroup) SetEc2SecurityGroupId(v string) *AwsRdsDbSecurityGroupEc2SecurityGroup {
	s.Ec2SecurityGroupId = &v
	return s
}

// SetEc2SecurityGroupName sets the Ec2SecurityGroupName field's value.
func (s *AwsRdsDbSecurityGroupEc2SecurityGroup) SetEc2SecurityGroupName(v string) *AwsRdsDbSecurityGroupEc2SecurityGroup {
	s.Ec2SecurityGroupName = &v
	return s
}

// SetEc2SecurityGroupOwnerId sets the Ec2SecurityGroupOwnerId field's value.
func (s *AwsRdsDbSecurityGroupEc2SecurityGroup) SetEc2SecurityGroupOwnerId(v string) *AwsRdsDbSecurityGroupEc2SecurityGroup {
	s.Ec2SecurityGroupOwnerId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbSecurityGroupEc2SecurityGroup) SetStatus(v string) *AwsRdsDbSecurityGroupEc2SecurityGroup {
	s.Status = &v
	return s
}

// IP range information for an RDS DB security group.
type AwsRdsDbSecurityGroupIpRange struct {
	_ struct{} `type:"structure"`

	// Specifies the IP range.
	CidrIp *string `type:"string"`

	// Specifies the status of the IP range.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbSecurityGroupIpRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbSecurityGroupIpRange) GoString() string {
	return s.String()
}

// SetCidrIp sets the CidrIp field's value.
func (s *AwsRdsDbSecurityGroupIpRange) SetCidrIp(v string) *AwsRdsDbSecurityGroupIpRange {
	s.CidrIp = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbSecurityGroupIpRange) SetStatus(v string) *AwsRdsDbSecurityGroupIpRange {
	s.Status = &v
	return s
}

// Provides details about an Amazon RDS DB cluster snapshot.
type AwsRdsDbSnapshotDetails struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) to be initially allocated for the database
	// instance.
	AllocatedStorage *int64 `type:"integer"`

	// Specifies the name of the Availability Zone in which the DB instance was
	// located at the time of the DB snapshot.
	AvailabilityZone *string `type:"string"`

	// A name for the DB instance.
	DbInstanceIdentifier *string `type:"string"`

	// The name or ARN of the DB snapshot that is used to restore the DB instance.
	DbSnapshotIdentifier *string `type:"string"`

	// The identifier for the source DB instance.
	DbiResourceId *string `type:"string"`

	// Whether the DB snapshot is encrypted.
	Encrypted *bool `type:"boolean"`

	// The name of the database engine to use for this DB instance.
	Engine *string `type:"string"`

	// The version of the database engine.
	EngineVersion *string `type:"string"`

	// Whether mapping of IAM accounts to database accounts is enabled.
	IamDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// Specifies the time in Coordinated Universal Time (UTC) when the DB instance,
	// from which the snapshot was taken, was created.
	InstanceCreateTime *string `type:"string"`

	// The provisioned IOPS (I/O operations per second) value of the DB instance
	// at the time of the snapshot.
	Iops *int64 `type:"integer"`

	// If Encrypted is true, the KMS key identifier for the encrypted DB snapshot.
	KmsKeyId *string `type:"string"`

	// License model information for the restored DB instance.
	LicenseModel *string `type:"string"`

	// The master user name for the DB snapshot.
	MasterUsername *string `type:"string"`

	// The option group name for the DB snapshot.
	OptionGroupName *string `type:"string"`

	// The percentage of the estimated data that has been transferred.
	PercentProgress *int64 `type:"integer"`

	// The port that the database engine was listening on at the time of the snapshot.
	Port *int64 `type:"integer"`

	// The number of CPU cores and the number of threads per core for the DB instance
	// class of the DB instance.
	ProcessorFeatures []*AwsRdsDbProcessorFeature `type:"list"`

	// When the snapshot was taken in Coordinated Universal Time (UTC).
	SnapshotCreateTime *string `type:"string"`

	// The type of the DB snapshot.
	SnapshotType *string `type:"string"`

	// The DB snapshot ARN that the DB snapshot was copied from.
	SourceDbSnapshotIdentifier *string `type:"string"`

	// The Amazon Web Services Region that the DB snapshot was created in or copied
	// from.
	SourceRegion *string `type:"string"`

	// The status of this DB snapshot.
	Status *string `type:"string"`

	// The storage type associated with the DB snapshot.
	StorageType *string `type:"string"`

	// The ARN from the key store with which to associate the instance for TDE encryption.
	TdeCredentialArn *string `type:"string"`

	// The time zone of the DB snapshot.
	Timezone *string `type:"string"`

	// The VPC ID associated with the DB snapshot.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbSnapshotDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbSnapshotDetails) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *AwsRdsDbSnapshotDetails) SetAllocatedStorage(v int64) *AwsRdsDbSnapshotDetails {
	s.AllocatedStorage = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *AwsRdsDbSnapshotDetails) SetAvailabilityZone(v string) *AwsRdsDbSnapshotDetails {
	s.AvailabilityZone = &v
	return s
}

// SetDbInstanceIdentifier sets the DbInstanceIdentifier field's value.
func (s *AwsRdsDbSnapshotDetails) SetDbInstanceIdentifier(v string) *AwsRdsDbSnapshotDetails {
	s.DbInstanceIdentifier = &v
	return s
}

// SetDbSnapshotIdentifier sets the DbSnapshotIdentifier field's value.
func (s *AwsRdsDbSnapshotDetails) SetDbSnapshotIdentifier(v string) *AwsRdsDbSnapshotDetails {
	s.DbSnapshotIdentifier = &v
	return s
}

// SetDbiResourceId sets the DbiResourceId field's value.
func (s *AwsRdsDbSnapshotDetails) SetDbiResourceId(v string) *AwsRdsDbSnapshotDetails {
	s.DbiResourceId = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *AwsRdsDbSnapshotDetails) SetEncrypted(v bool) *AwsRdsDbSnapshotDetails {
	s.Encrypted = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *AwsRdsDbSnapshotDetails) SetEngine(v string) *AwsRdsDbSnapshotDetails {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *AwsRdsDbSnapshotDetails) SetEngineVersion(v string) *AwsRdsDbSnapshotDetails {
	s.EngineVersion = &v
	return s
}

// SetIamDatabaseAuthenticationEnabled sets the IamDatabaseAuthenticationEnabled field's value.
func (s *AwsRdsDbSnapshotDetails) SetIamDatabaseAuthenticationEnabled(v bool) *AwsRdsDbSnapshotDetails {
	s.IamDatabaseAuthenticationEnabled = &v
	return s
}

// SetInstanceCreateTime sets the InstanceCreateTime field's value.
func (s *AwsRdsDbSnapshotDetails) SetInstanceCreateTime(v string) *AwsRdsDbSnapshotDetails {
	s.InstanceCreateTime = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *AwsRdsDbSnapshotDetails) SetIops(v int64) *AwsRdsDbSnapshotDetails {
	s.Iops = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsRdsDbSnapshotDetails) SetKmsKeyId(v string) *AwsRdsDbSnapshotDetails {
	s.KmsKeyId = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *AwsRdsDbSnapshotDetails) SetLicenseModel(v string) *AwsRdsDbSnapshotDetails {
	s.LicenseModel = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *AwsRdsDbSnapshotDetails) SetMasterUsername(v string) *AwsRdsDbSnapshotDetails {
	s.MasterUsername = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *AwsRdsDbSnapshotDetails) SetOptionGroupName(v string) *AwsRdsDbSnapshotDetails {
	s.OptionGroupName = &v
	return s
}

// SetPercentProgress sets the PercentProgress field's value.
func (s *AwsRdsDbSnapshotDetails) SetPercentProgress(v int64) *AwsRdsDbSnapshotDetails {
	s.PercentProgress = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AwsRdsDbSnapshotDetails) SetPort(v int64) *AwsRdsDbSnapshotDetails {
	s.Port = &v
	return s
}

// SetProcessorFeatures sets the ProcessorFeatures field's value.
func (s *AwsRdsDbSnapshotDetails) SetProcessorFeatures(v []*AwsRdsDbProcessorFeature) *AwsRdsDbSnapshotDetails {
	s.ProcessorFeatures = v
	return s
}

// SetSnapshotCreateTime sets the SnapshotCreateTime field's value.
func (s *AwsRdsDbSnapshotDetails) SetSnapshotCreateTime(v string) *AwsRdsDbSnapshotDetails {
	s.SnapshotCreateTime = &v
	return s
}

// SetSnapshotType sets the SnapshotType field's value.
func (s *AwsRdsDbSnapshotDetails) SetSnapshotType(v string) *AwsRdsDbSnapshotDetails {
	s.SnapshotType = &v
	return s
}

// SetSourceDbSnapshotIdentifier sets the SourceDbSnapshotIdentifier field's value.
func (s *AwsRdsDbSnapshotDetails) SetSourceDbSnapshotIdentifier(v string) *AwsRdsDbSnapshotDetails {
	s.SourceDbSnapshotIdentifier = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *AwsRdsDbSnapshotDetails) SetSourceRegion(v string) *AwsRdsDbSnapshotDetails {
	s.SourceRegion = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbSnapshotDetails) SetStatus(v string) *AwsRdsDbSnapshotDetails {
	s.Status = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *AwsRdsDbSnapshotDetails) SetStorageType(v string) *AwsRdsDbSnapshotDetails {
	s.StorageType = &v
	return s
}

// SetTdeCredentialArn sets the TdeCredentialArn field's value.
func (s *AwsRdsDbSnapshotDetails) SetTdeCredentialArn(v string) *AwsRdsDbSnapshotDetails {
	s.TdeCredentialArn = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *AwsRdsDbSnapshotDetails) SetTimezone(v string) *AwsRdsDbSnapshotDetails {
	s.Timezone = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsRdsDbSnapshotDetails) SetVpcId(v string) *AwsRdsDbSnapshotDetails {
	s.VpcId = &v
	return s
}

// Information about the status of a read replica.
type AwsRdsDbStatusInfo struct {
	_ struct{} `type:"structure"`

	// If the read replica is currently in an error state, provides the error details.
	Message *string `type:"string"`

	// Whether the read replica instance is operating normally.
	Normal *bool `type:"boolean"`

	// The status of the read replica instance.
	Status *string `type:"string"`

	// The type of status. For a read replica, the status type is read replication.
	StatusType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbStatusInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbStatusInfo) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *AwsRdsDbStatusInfo) SetMessage(v string) *AwsRdsDbStatusInfo {
	s.Message = &v
	return s
}

// SetNormal sets the Normal field's value.
func (s *AwsRdsDbStatusInfo) SetNormal(v bool) *AwsRdsDbStatusInfo {
	s.Normal = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbStatusInfo) SetStatus(v string) *AwsRdsDbStatusInfo {
	s.Status = &v
	return s
}

// SetStatusType sets the StatusType field's value.
func (s *AwsRdsDbStatusInfo) SetStatusType(v string) *AwsRdsDbStatusInfo {
	s.StatusType = &v
	return s
}

// Information about the subnet group for the database instance.
type AwsRdsDbSubnetGroup struct {
	_ struct{} `type:"structure"`

	// The ARN of the subnet group.
	DbSubnetGroupArn *string `type:"string"`

	// The description of the subnet group.
	DbSubnetGroupDescription *string `type:"string"`

	// The name of the subnet group.
	DbSubnetGroupName *string `type:"string"`

	// The status of the subnet group.
	SubnetGroupStatus *string `type:"string"`

	// A list of subnets in the subnet group.
	Subnets []*AwsRdsDbSubnetGroupSubnet `type:"list"`

	// The VPC ID of the subnet group.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbSubnetGroup) GoString() string {
	return s.String()
}

// SetDbSubnetGroupArn sets the DbSubnetGroupArn field's value.
func (s *AwsRdsDbSubnetGroup) SetDbSubnetGroupArn(v string) *AwsRdsDbSubnetGroup {
	s.DbSubnetGroupArn = &v
	return s
}

// SetDbSubnetGroupDescription sets the DbSubnetGroupDescription field's value.
func (s *AwsRdsDbSubnetGroup) SetDbSubnetGroupDescription(v string) *AwsRdsDbSubnetGroup {
	s.DbSubnetGroupDescription = &v
	return s
}

// SetDbSubnetGroupName sets the DbSubnetGroupName field's value.
func (s *AwsRdsDbSubnetGroup) SetDbSubnetGroupName(v string) *AwsRdsDbSubnetGroup {
	s.DbSubnetGroupName = &v
	return s
}

// SetSubnetGroupStatus sets the SubnetGroupStatus field's value.
func (s *AwsRdsDbSubnetGroup) SetSubnetGroupStatus(v string) *AwsRdsDbSubnetGroup {
	s.SubnetGroupStatus = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *AwsRdsDbSubnetGroup) SetSubnets(v []*AwsRdsDbSubnetGroupSubnet) *AwsRdsDbSubnetGroup {
	s.Subnets = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsRdsDbSubnetGroup) SetVpcId(v string) *AwsRdsDbSubnetGroup {
	s.VpcId = &v
	return s
}

// Information about a subnet in a subnet group.
type AwsRdsDbSubnetGroupSubnet struct {
	_ struct{} `type:"structure"`

	// Information about the Availability Zone for a subnet in the subnet group.
	SubnetAvailabilityZone *AwsRdsDbSubnetGroupSubnetAvailabilityZone `type:"structure"`

	// The identifier of a subnet in the subnet group.
	SubnetIdentifier *string `type:"string"`

	// The status of a subnet in the subnet group.
	SubnetStatus *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbSubnetGroupSubnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbSubnetGroupSubnet) GoString() string {
	return s.String()
}

// SetSubnetAvailabilityZone sets the SubnetAvailabilityZone field's value.
func (s *AwsRdsDbSubnetGroupSubnet) SetSubnetAvailabilityZone(v *AwsRdsDbSubnetGroupSubnetAvailabilityZone) *AwsRdsDbSubnetGroupSubnet {
	s.SubnetAvailabilityZone = v
	return s
}

// SetSubnetIdentifier sets the SubnetIdentifier field's value.
func (s *AwsRdsDbSubnetGroupSubnet) SetSubnetIdentifier(v string) *AwsRdsDbSubnetGroupSubnet {
	s.SubnetIdentifier = &v
	return s
}

// SetSubnetStatus sets the SubnetStatus field's value.
func (s *AwsRdsDbSubnetGroupSubnet) SetSubnetStatus(v string) *AwsRdsDbSubnetGroupSubnet {
	s.SubnetStatus = &v
	return s
}

// An Availability Zone for a subnet in a subnet group.
type AwsRdsDbSubnetGroupSubnetAvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the Availability Zone for a subnet in the subnet group.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbSubnetGroupSubnetAvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsDbSubnetGroupSubnetAvailabilityZone) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsRdsDbSubnetGroupSubnetAvailabilityZone) SetName(v string) *AwsRdsDbSubnetGroupSubnetAvailabilityZone {
	s.Name = &v
	return s
}

// Details about an Amazon RDS event notification subscription. The subscription
// allows Amazon RDS to post events to an SNS topic.
type AwsRdsEventSubscriptionDetails struct {
	_ struct{} `type:"structure"`

	// The identifier of the account that is associated with the event notification
	// subscription.
	CustSubscriptionId *string `type:"string"`

	// The identifier of the event notification subscription.
	CustomerAwsId *string `type:"string"`

	// Whether the event notification subscription is enabled.
	Enabled *bool `type:"boolean"`

	// The list of event categories for the event notification subscription.
	EventCategoriesList []*string `type:"list"`

	// The ARN of the event notification subscription.
	EventSubscriptionArn *string `type:"string"`

	// The ARN of the SNS topic to post the event notifications to.
	SnsTopicArn *string `type:"string"`

	// A list of source identifiers for the event notification subscription.
	SourceIdsList []*string `type:"list"`

	// The source type for the event notification subscription.
	SourceType *string `type:"string"`

	// The status of the event notification subscription.
	//
	// Valid values: creating | modifying | deleting | active | no-permission |
	// topic-not-exist
	Status *string `type:"string"`

	// The datetime when the event notification subscription was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	SubscriptionCreationTime *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsEventSubscriptionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsEventSubscriptionDetails) GoString() string {
	return s.String()
}

// SetCustSubscriptionId sets the CustSubscriptionId field's value.
func (s *AwsRdsEventSubscriptionDetails) SetCustSubscriptionId(v string) *AwsRdsEventSubscriptionDetails {
	s.CustSubscriptionId = &v
	return s
}

// SetCustomerAwsId sets the CustomerAwsId field's value.
func (s *AwsRdsEventSubscriptionDetails) SetCustomerAwsId(v string) *AwsRdsEventSubscriptionDetails {
	s.CustomerAwsId = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AwsRdsEventSubscriptionDetails) SetEnabled(v bool) *AwsRdsEventSubscriptionDetails {
	s.Enabled = &v
	return s
}

// SetEventCategoriesList sets the EventCategoriesList field's value.
func (s *AwsRdsEventSubscriptionDetails) SetEventCategoriesList(v []*string) *AwsRdsEventSubscriptionDetails {
	s.EventCategoriesList = v
	return s
}

// SetEventSubscriptionArn sets the EventSubscriptionArn field's value.
func (s *AwsRdsEventSubscriptionDetails) SetEventSubscriptionArn(v string) *AwsRdsEventSubscriptionDetails {
	s.EventSubscriptionArn = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *AwsRdsEventSubscriptionDetails) SetSnsTopicArn(v string) *AwsRdsEventSubscriptionDetails {
	s.SnsTopicArn = &v
	return s
}

// SetSourceIdsList sets the SourceIdsList field's value.
func (s *AwsRdsEventSubscriptionDetails) SetSourceIdsList(v []*string) *AwsRdsEventSubscriptionDetails {
	s.SourceIdsList = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *AwsRdsEventSubscriptionDetails) SetSourceType(v string) *AwsRdsEventSubscriptionDetails {
	s.SourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsEventSubscriptionDetails) SetStatus(v string) *AwsRdsEventSubscriptionDetails {
	s.Status = &v
	return s
}

// SetSubscriptionCreationTime sets the SubscriptionCreationTime field's value.
func (s *AwsRdsEventSubscriptionDetails) SetSubscriptionCreationTime(v string) *AwsRdsEventSubscriptionDetails {
	s.SubscriptionCreationTime = &v
	return s
}

// Identifies the log types to enable and disable.
type AwsRdsPendingCloudWatchLogsExports struct {
	_ struct{} `type:"structure"`

	// A list of log types that are being disabled.
	LogTypesToDisable []*string `type:"list"`

	// A list of log types that are being enabled.
	LogTypesToEnable []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsPendingCloudWatchLogsExports) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRdsPendingCloudWatchLogsExports) GoString() string {
	return s.String()
}

// SetLogTypesToDisable sets the LogTypesToDisable field's value.
func (s *AwsRdsPendingCloudWatchLogsExports) SetLogTypesToDisable(v []*string) *AwsRdsPendingCloudWatchLogsExports {
	s.LogTypesToDisable = v
	return s
}

// SetLogTypesToEnable sets the LogTypesToEnable field's value.
func (s *AwsRdsPendingCloudWatchLogsExports) SetLogTypesToEnable(v []*string) *AwsRdsPendingCloudWatchLogsExports {
	s.LogTypesToEnable = v
	return s
}

// A node in an Amazon Redshift cluster.
type AwsRedshiftClusterClusterNode struct {
	_ struct{} `type:"structure"`

	// The role of the node. A node might be a leader node or a compute node.
	NodeRole *string `type:"string"`

	// The private IP address of the node.
	PrivateIpAddress *string `type:"string"`

	// The public IP address of the node.
	PublicIpAddress *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterClusterNode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterClusterNode) GoString() string {
	return s.String()
}

// SetNodeRole sets the NodeRole field's value.
func (s *AwsRedshiftClusterClusterNode) SetNodeRole(v string) *AwsRedshiftClusterClusterNode {
	s.NodeRole = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *AwsRedshiftClusterClusterNode) SetPrivateIpAddress(v string) *AwsRedshiftClusterClusterNode {
	s.PrivateIpAddress = &v
	return s
}

// SetPublicIpAddress sets the PublicIpAddress field's value.
func (s *AwsRedshiftClusterClusterNode) SetPublicIpAddress(v string) *AwsRedshiftClusterClusterNode {
	s.PublicIpAddress = &v
	return s
}

// A cluster parameter group that is associated with an Amazon Redshift cluster.
type AwsRedshiftClusterClusterParameterGroup struct {
	_ struct{} `type:"structure"`

	// The list of parameter statuses.
	ClusterParameterStatusList []*AwsRedshiftClusterClusterParameterStatus `type:"list"`

	// The status of updates to the parameters.
	ParameterApplyStatus *string `type:"string"`

	// The name of the parameter group.
	ParameterGroupName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterClusterParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterClusterParameterGroup) GoString() string {
	return s.String()
}

// SetClusterParameterStatusList sets the ClusterParameterStatusList field's value.
func (s *AwsRedshiftClusterClusterParameterGroup) SetClusterParameterStatusList(v []*AwsRedshiftClusterClusterParameterStatus) *AwsRedshiftClusterClusterParameterGroup {
	s.ClusterParameterStatusList = v
	return s
}

// SetParameterApplyStatus sets the ParameterApplyStatus field's value.
func (s *AwsRedshiftClusterClusterParameterGroup) SetParameterApplyStatus(v string) *AwsRedshiftClusterClusterParameterGroup {
	s.ParameterApplyStatus = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *AwsRedshiftClusterClusterParameterGroup) SetParameterGroupName(v string) *AwsRedshiftClusterClusterParameterGroup {
	s.ParameterGroupName = &v
	return s
}

// The status of a parameter in a cluster parameter group for an Amazon Redshift
// cluster.
type AwsRedshiftClusterClusterParameterStatus struct {
	_ struct{} `type:"structure"`

	// The error that prevented the parameter from being applied to the database.
	ParameterApplyErrorDescription *string `type:"string"`

	// The status of the parameter. Indicates whether the parameter is in sync with
	// the database, waiting for a cluster reboot, or encountered an error when
	// it was applied.
	//
	// Valid values: in-sync | pending-reboot | applying | invalid-parameter | apply-deferred
	// | apply-error | unknown-error
	ParameterApplyStatus *string `type:"string"`

	// The name of the parameter.
	ParameterName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterClusterParameterStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterClusterParameterStatus) GoString() string {
	return s.String()
}

// SetParameterApplyErrorDescription sets the ParameterApplyErrorDescription field's value.
func (s *AwsRedshiftClusterClusterParameterStatus) SetParameterApplyErrorDescription(v string) *AwsRedshiftClusterClusterParameterStatus {
	s.ParameterApplyErrorDescription = &v
	return s
}

// SetParameterApplyStatus sets the ParameterApplyStatus field's value.
func (s *AwsRedshiftClusterClusterParameterStatus) SetParameterApplyStatus(v string) *AwsRedshiftClusterClusterParameterStatus {
	s.ParameterApplyStatus = &v
	return s
}

// SetParameterName sets the ParameterName field's value.
func (s *AwsRedshiftClusterClusterParameterStatus) SetParameterName(v string) *AwsRedshiftClusterClusterParameterStatus {
	s.ParameterName = &v
	return s
}

// A security group that is associated with the cluster.
type AwsRedshiftClusterClusterSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The name of the cluster security group.
	ClusterSecurityGroupName *string `type:"string"`

	// The status of the cluster security group.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterClusterSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterClusterSecurityGroup) GoString() string {
	return s.String()
}

// SetClusterSecurityGroupName sets the ClusterSecurityGroupName field's value.
func (s *AwsRedshiftClusterClusterSecurityGroup) SetClusterSecurityGroupName(v string) *AwsRedshiftClusterClusterSecurityGroup {
	s.ClusterSecurityGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRedshiftClusterClusterSecurityGroup) SetStatus(v string) *AwsRedshiftClusterClusterSecurityGroup {
	s.Status = &v
	return s
}

// Information about a cross-Region snapshot copy.
type AwsRedshiftClusterClusterSnapshotCopyStatus struct {
	_ struct{} `type:"structure"`

	// The destination Region that snapshots are automatically copied to when cross-Region
	// snapshot copy is enabled.
	DestinationRegion *string `type:"string"`

	// The number of days that manual snapshots are retained in the destination
	// region after they are copied from a source region.
	//
	// If the value is -1, then the manual snapshot is retained indefinitely.
	//
	// Valid values: Either -1 or an integer between 1 and 3,653
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// The number of days to retain automated snapshots in the destination Region
	// after they are copied from a source Region.
	RetentionPeriod *int64 `type:"integer"`

	// The name of the snapshot copy grant.
	SnapshotCopyGrantName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterClusterSnapshotCopyStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterClusterSnapshotCopyStatus) GoString() string {
	return s.String()
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *AwsRedshiftClusterClusterSnapshotCopyStatus) SetDestinationRegion(v string) *AwsRedshiftClusterClusterSnapshotCopyStatus {
	s.DestinationRegion = &v
	return s
}

// SetManualSnapshotRetentionPeriod sets the ManualSnapshotRetentionPeriod field's value.
func (s *AwsRedshiftClusterClusterSnapshotCopyStatus) SetManualSnapshotRetentionPeriod(v int64) *AwsRedshiftClusterClusterSnapshotCopyStatus {
	s.ManualSnapshotRetentionPeriod = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *AwsRedshiftClusterClusterSnapshotCopyStatus) SetRetentionPeriod(v int64) *AwsRedshiftClusterClusterSnapshotCopyStatus {
	s.RetentionPeriod = &v
	return s
}

// SetSnapshotCopyGrantName sets the SnapshotCopyGrantName field's value.
func (s *AwsRedshiftClusterClusterSnapshotCopyStatus) SetSnapshotCopyGrantName(v string) *AwsRedshiftClusterClusterSnapshotCopyStatus {
	s.SnapshotCopyGrantName = &v
	return s
}

// A time windows during which maintenance was deferred for an Amazon Redshift
// cluster.
type AwsRedshiftClusterDeferredMaintenanceWindow struct {
	_ struct{} `type:"structure"`

	// The end of the time window for which maintenance was deferred.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	DeferMaintenanceEndTime *string `type:"string"`

	// The identifier of the maintenance window.
	DeferMaintenanceIdentifier *string `type:"string"`

	// The start of the time window for which maintenance was deferred.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	DeferMaintenanceStartTime *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterDeferredMaintenanceWindow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterDeferredMaintenanceWindow) GoString() string {
	return s.String()
}

// SetDeferMaintenanceEndTime sets the DeferMaintenanceEndTime field's value.
func (s *AwsRedshiftClusterDeferredMaintenanceWindow) SetDeferMaintenanceEndTime(v string) *AwsRedshiftClusterDeferredMaintenanceWindow {
	s.DeferMaintenanceEndTime = &v
	return s
}

// SetDeferMaintenanceIdentifier sets the DeferMaintenanceIdentifier field's value.
func (s *AwsRedshiftClusterDeferredMaintenanceWindow) SetDeferMaintenanceIdentifier(v string) *AwsRedshiftClusterDeferredMaintenanceWindow {
	s.DeferMaintenanceIdentifier = &v
	return s
}

// SetDeferMaintenanceStartTime sets the DeferMaintenanceStartTime field's value.
func (s *AwsRedshiftClusterDeferredMaintenanceWindow) SetDeferMaintenanceStartTime(v string) *AwsRedshiftClusterDeferredMaintenanceWindow {
	s.DeferMaintenanceStartTime = &v
	return s
}

// Details about an Amazon Redshift cluster.
type AwsRedshiftClusterDetails struct {
	_ struct{} `type:"structure"`

	// Indicates whether major version upgrades are applied automatically to the
	// cluster during the maintenance window.
	AllowVersionUpgrade *bool `type:"boolean"`

	// The number of days that automatic cluster snapshots are retained.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The name of the Availability Zone in which the cluster is located.
	AvailabilityZone *string `type:"string"`

	// The availability status of the cluster for queries. Possible values are the
	// following:
	//
	//    * Available - The cluster is available for queries.
	//
	//    * Unavailable - The cluster is not available for queries.
	//
	//    * Maintenance - The cluster is intermittently available for queries due
	//    to maintenance activities.
	//
	//    * Modifying -The cluster is intermittently available for queries due to
	//    changes that modify the cluster.
	//
	//    * Failed - The cluster failed and is not available for queries.
	ClusterAvailabilityStatus *string `type:"string"`

	// Indicates when the cluster was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	ClusterCreateTime *string `type:"string"`

	// The unique identifier of the cluster.
	ClusterIdentifier *string `type:"string"`

	// The nodes in the cluster.
	ClusterNodes []*AwsRedshiftClusterClusterNode `type:"list"`

	// The list of cluster parameter groups that are associated with this cluster.
	ClusterParameterGroups []*AwsRedshiftClusterClusterParameterGroup `type:"list"`

	// The public key for the cluster.
	ClusterPublicKey *string `type:"string"`

	// The specific revision number of the database in the cluster.
	ClusterRevisionNumber *string `type:"string"`

	// A list of cluster security groups that are associated with the cluster.
	ClusterSecurityGroups []*AwsRedshiftClusterClusterSecurityGroup `type:"list"`

	// Information about the destination Region and retention period for the cross-Region
	// snapshot copy.
	ClusterSnapshotCopyStatus *AwsRedshiftClusterClusterSnapshotCopyStatus `type:"structure"`

	// The current status of the cluster.
	//
	// Valid values: available | available, prep-for-resize | available, resize-cleanup
	// |cancelling-resize | creating | deleting | final-snapshot | hardware-failure
	// | incompatible-hsm |incompatible-network | incompatible-parameters | incompatible-restore
	// | modifying | paused | rebooting | renaming | resizing | rotating-keys |
	// storage-full | updating-hsm
	ClusterStatus *string `type:"string"`

	// The name of the subnet group that is associated with the cluster. This parameter
	// is valid only when the cluster is in a VPC.
	ClusterSubnetGroupName *string `type:"string"`

	// The version ID of the Amazon Redshift engine that runs on the cluster.
	ClusterVersion *string `type:"string"`

	// The name of the initial database that was created when the cluster was created.
	//
	// The same name is returned for the life of the cluster.
	//
	// If an initial database is not specified, a database named devdev is created
	// by default.
	DBName *string `type:"string"`

	// List of time windows during which maintenance was deferred.
	DeferredMaintenanceWindows []*AwsRedshiftClusterDeferredMaintenanceWindow `type:"list"`

	// Information about the status of the Elastic IP (EIP) address.
	ElasticIpStatus *AwsRedshiftClusterElasticIpStatus `type:"structure"`

	// The number of nodes that you can use the elastic resize method to resize
	// the cluster to.
	ElasticResizeNumberOfNodeOptions *string `type:"string"`

	// Indicates whether the data in the cluster is encrypted at rest.
	Encrypted *bool `type:"boolean"`

	// The connection endpoint.
	Endpoint *AwsRedshiftClusterEndpoint `type:"structure"`

	// Indicates whether to create the cluster with enhanced VPC routing enabled.
	EnhancedVpcRouting *bool `type:"boolean"`

	// Indicates when the next snapshot is expected to be taken. The cluster must
	// have a valid snapshot schedule and have backups enabled.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	ExpectedNextSnapshotScheduleTime *string `type:"string"`

	// The status of the next expected snapshot.
	//
	// Valid values: OnTrack | Pending
	ExpectedNextSnapshotScheduleTimeStatus *string `type:"string"`

	// Information about whether the Amazon Redshift cluster finished applying any
	// changes to hardware security module (HSM) settings that were specified in
	// a modify cluster command.
	HsmStatus *AwsRedshiftClusterHsmStatus `type:"structure"`

	// A list of IAM roles that the cluster can use to access other Amazon Web Services
	// services.
	IamRoles []*AwsRedshiftClusterIamRole `type:"list"`

	// The identifier of the KMS encryption key that is used to encrypt data in
	// the cluster.
	KmsKeyId *string `type:"string"`

	// Information about the logging status of the cluster.
	LoggingStatus *AwsRedshiftClusterLoggingStatus `type:"structure"`

	// The name of the maintenance track for the cluster.
	MaintenanceTrackName *string `type:"string"`

	// The default number of days to retain a manual snapshot.
	//
	// If the value is -1, the snapshot is retained indefinitely.
	//
	// This setting doesn't change the retention period of existing snapshots.
	//
	// Valid values: Either -1 or an integer between 1 and 3,653
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// The master user name for the cluster. This name is used to connect to the
	// database that is specified in as the value of DBName.
	MasterUsername *string `type:"string"`

	// Indicates the start of the next maintenance window.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	NextMaintenanceWindowStartTime *string `type:"string"`

	// The node type for the nodes in the cluster.
	NodeType *string `type:"string"`

	// The number of compute nodes in the cluster.
	NumberOfNodes *int64 `type:"integer"`

	// A list of cluster operations that are waiting to start.
	PendingActions []*string `type:"list"`

	// A list of changes to the cluster that are currently pending.
	PendingModifiedValues *AwsRedshiftClusterPendingModifiedValues `type:"structure"`

	// The weekly time range, in Universal Coordinated Time (UTC), during which
	// system maintenance can occur.
	//
	// Format: <day>:HH:MM-<day>:HH:MM
	//
	// For the day values, use mon | tue | wed | thu | fri | sat | sun
	//
	// For example, sun:09:32-sun:10:02
	PreferredMaintenanceWindow *string `type:"string"`

	// Whether the cluster can be accessed from a public network.
	PubliclyAccessible *bool `type:"boolean"`

	// Information about the resize operation for the cluster.
	ResizeInfo *AwsRedshiftClusterResizeInfo `type:"structure"`

	// Information about the status of a cluster restore action. Only applies to
	// a cluster that was created by restoring a snapshot.
	RestoreStatus *AwsRedshiftClusterRestoreStatus `type:"structure"`

	// A unique identifier for the cluster snapshot schedule.
	SnapshotScheduleIdentifier *string `type:"string"`

	// The current state of the cluster snapshot schedule.
	//
	// Valid values: MODIFYING | ACTIVE | FAILED
	SnapshotScheduleState *string `type:"string"`

	// The identifier of the VPC that the cluster is in, if the cluster is in a
	// VPC.
	VpcId *string `type:"string"`

	// The list of VPC security groups that the cluster belongs to, if the cluster
	// is in a VPC.
	VpcSecurityGroups []*AwsRedshiftClusterVpcSecurityGroup `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterDetails) GoString() string {
	return s.String()
}

// SetAllowVersionUpgrade sets the AllowVersionUpgrade field's value.
func (s *AwsRedshiftClusterDetails) SetAllowVersionUpgrade(v bool) *AwsRedshiftClusterDetails {
	s.AllowVersionUpgrade = &v
	return s
}

// SetAutomatedSnapshotRetentionPeriod sets the AutomatedSnapshotRetentionPeriod field's value.
func (s *AwsRedshiftClusterDetails) SetAutomatedSnapshotRetentionPeriod(v int64) *AwsRedshiftClusterDetails {
	s.AutomatedSnapshotRetentionPeriod = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *AwsRedshiftClusterDetails) SetAvailabilityZone(v string) *AwsRedshiftClusterDetails {
	s.AvailabilityZone = &v
	return s
}

// SetClusterAvailabilityStatus sets the ClusterAvailabilityStatus field's value.
func (s *AwsRedshiftClusterDetails) SetClusterAvailabilityStatus(v string) *AwsRedshiftClusterDetails {
	s.ClusterAvailabilityStatus = &v
	return s
}

// SetClusterCreateTime sets the ClusterCreateTime field's value.
func (s *AwsRedshiftClusterDetails) SetClusterCreateTime(v string) *AwsRedshiftClusterDetails {
	s.ClusterCreateTime = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *AwsRedshiftClusterDetails) SetClusterIdentifier(v string) *AwsRedshiftClusterDetails {
	s.ClusterIdentifier = &v
	return s
}

// SetClusterNodes sets the ClusterNodes field's value.
func (s *AwsRedshiftClusterDetails) SetClusterNodes(v []*AwsRedshiftClusterClusterNode) *AwsRedshiftClusterDetails {
	s.ClusterNodes = v
	return s
}

// SetClusterParameterGroups sets the ClusterParameterGroups field's value.
func (s *AwsRedshiftClusterDetails) SetClusterParameterGroups(v []*AwsRedshiftClusterClusterParameterGroup) *AwsRedshiftClusterDetails {
	s.ClusterParameterGroups = v
	return s
}

// SetClusterPublicKey sets the ClusterPublicKey field's value.
func (s *AwsRedshiftClusterDetails) SetClusterPublicKey(v string) *AwsRedshiftClusterDetails {
	s.ClusterPublicKey = &v
	return s
}

// SetClusterRevisionNumber sets the ClusterRevisionNumber field's value.
func (s *AwsRedshiftClusterDetails) SetClusterRevisionNumber(v string) *AwsRedshiftClusterDetails {
	s.ClusterRevisionNumber = &v
	return s
}

// SetClusterSecurityGroups sets the ClusterSecurityGroups field's value.
func (s *AwsRedshiftClusterDetails) SetClusterSecurityGroups(v []*AwsRedshiftClusterClusterSecurityGroup) *AwsRedshiftClusterDetails {
	s.ClusterSecurityGroups = v
	return s
}

// SetClusterSnapshotCopyStatus sets the ClusterSnapshotCopyStatus field's value.
func (s *AwsRedshiftClusterDetails) SetClusterSnapshotCopyStatus(v *AwsRedshiftClusterClusterSnapshotCopyStatus) *AwsRedshiftClusterDetails {
	s.ClusterSnapshotCopyStatus = v
	return s
}

// SetClusterStatus sets the ClusterStatus field's value.
func (s *AwsRedshiftClusterDetails) SetClusterStatus(v string) *AwsRedshiftClusterDetails {
	s.ClusterStatus = &v
	return s
}

// SetClusterSubnetGroupName sets the ClusterSubnetGroupName field's value.
func (s *AwsRedshiftClusterDetails) SetClusterSubnetGroupName(v string) *AwsRedshiftClusterDetails {
	s.ClusterSubnetGroupName = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *AwsRedshiftClusterDetails) SetClusterVersion(v string) *AwsRedshiftClusterDetails {
	s.ClusterVersion = &v
	return s
}

// SetDBName sets the DBName field's value.
func (s *AwsRedshiftClusterDetails) SetDBName(v string) *AwsRedshiftClusterDetails {
	s.DBName = &v
	return s
}

// SetDeferredMaintenanceWindows sets the DeferredMaintenanceWindows field's value.
func (s *AwsRedshiftClusterDetails) SetDeferredMaintenanceWindows(v []*AwsRedshiftClusterDeferredMaintenanceWindow) *AwsRedshiftClusterDetails {
	s.DeferredMaintenanceWindows = v
	return s
}

// SetElasticIpStatus sets the ElasticIpStatus field's value.
func (s *AwsRedshiftClusterDetails) SetElasticIpStatus(v *AwsRedshiftClusterElasticIpStatus) *AwsRedshiftClusterDetails {
	s.ElasticIpStatus = v
	return s
}

// SetElasticResizeNumberOfNodeOptions sets the ElasticResizeNumberOfNodeOptions field's value.
func (s *AwsRedshiftClusterDetails) SetElasticResizeNumberOfNodeOptions(v string) *AwsRedshiftClusterDetails {
	s.ElasticResizeNumberOfNodeOptions = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *AwsRedshiftClusterDetails) SetEncrypted(v bool) *AwsRedshiftClusterDetails {
	s.Encrypted = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *AwsRedshiftClusterDetails) SetEndpoint(v *AwsRedshiftClusterEndpoint) *AwsRedshiftClusterDetails {
	s.Endpoint = v
	return s
}

// SetEnhancedVpcRouting sets the EnhancedVpcRouting field's value.
func (s *AwsRedshiftClusterDetails) SetEnhancedVpcRouting(v bool) *AwsRedshiftClusterDetails {
	s.EnhancedVpcRouting = &v
	return s
}

// SetExpectedNextSnapshotScheduleTime sets the ExpectedNextSnapshotScheduleTime field's value.
func (s *AwsRedshiftClusterDetails) SetExpectedNextSnapshotScheduleTime(v string) *AwsRedshiftClusterDetails {
	s.ExpectedNextSnapshotScheduleTime = &v
	return s
}

// SetExpectedNextSnapshotScheduleTimeStatus sets the ExpectedNextSnapshotScheduleTimeStatus field's value.
func (s *AwsRedshiftClusterDetails) SetExpectedNextSnapshotScheduleTimeStatus(v string) *AwsRedshiftClusterDetails {
	s.ExpectedNextSnapshotScheduleTimeStatus = &v
	return s
}

// SetHsmStatus sets the HsmStatus field's value.
func (s *AwsRedshiftClusterDetails) SetHsmStatus(v *AwsRedshiftClusterHsmStatus) *AwsRedshiftClusterDetails {
	s.HsmStatus = v
	return s
}

// SetIamRoles sets the IamRoles field's value.
func (s *AwsRedshiftClusterDetails) SetIamRoles(v []*AwsRedshiftClusterIamRole) *AwsRedshiftClusterDetails {
	s.IamRoles = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsRedshiftClusterDetails) SetKmsKeyId(v string) *AwsRedshiftClusterDetails {
	s.KmsKeyId = &v
	return s
}

// SetLoggingStatus sets the LoggingStatus field's value.
func (s *AwsRedshiftClusterDetails) SetLoggingStatus(v *AwsRedshiftClusterLoggingStatus) *AwsRedshiftClusterDetails {
	s.LoggingStatus = v
	return s
}

// SetMaintenanceTrackName sets the MaintenanceTrackName field's value.
func (s *AwsRedshiftClusterDetails) SetMaintenanceTrackName(v string) *AwsRedshiftClusterDetails {
	s.MaintenanceTrackName = &v
	return s
}

// SetManualSnapshotRetentionPeriod sets the ManualSnapshotRetentionPeriod field's value.
func (s *AwsRedshiftClusterDetails) SetManualSnapshotRetentionPeriod(v int64) *AwsRedshiftClusterDetails {
	s.ManualSnapshotRetentionPeriod = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *AwsRedshiftClusterDetails) SetMasterUsername(v string) *AwsRedshiftClusterDetails {
	s.MasterUsername = &v
	return s
}

// SetNextMaintenanceWindowStartTime sets the NextMaintenanceWindowStartTime field's value.
func (s *AwsRedshiftClusterDetails) SetNextMaintenanceWindowStartTime(v string) *AwsRedshiftClusterDetails {
	s.NextMaintenanceWindowStartTime = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *AwsRedshiftClusterDetails) SetNodeType(v string) *AwsRedshiftClusterDetails {
	s.NodeType = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *AwsRedshiftClusterDetails) SetNumberOfNodes(v int64) *AwsRedshiftClusterDetails {
	s.NumberOfNodes = &v
	return s
}

// SetPendingActions sets the PendingActions field's value.
func (s *AwsRedshiftClusterDetails) SetPendingActions(v []*string) *AwsRedshiftClusterDetails {
	s.PendingActions = v
	return s
}

// SetPendingModifiedValues sets the PendingModifiedValues field's value.
func (s *AwsRedshiftClusterDetails) SetPendingModifiedValues(v *AwsRedshiftClusterPendingModifiedValues) *AwsRedshiftClusterDetails {
	s.PendingModifiedValues = v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *AwsRedshiftClusterDetails) SetPreferredMaintenanceWindow(v string) *AwsRedshiftClusterDetails {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *AwsRedshiftClusterDetails) SetPubliclyAccessible(v bool) *AwsRedshiftClusterDetails {
	s.PubliclyAccessible = &v
	return s
}

// SetResizeInfo sets the ResizeInfo field's value.
func (s *AwsRedshiftClusterDetails) SetResizeInfo(v *AwsRedshiftClusterResizeInfo) *AwsRedshiftClusterDetails {
	s.ResizeInfo = v
	return s
}

// SetRestoreStatus sets the RestoreStatus field's value.
func (s *AwsRedshiftClusterDetails) SetRestoreStatus(v *AwsRedshiftClusterRestoreStatus) *AwsRedshiftClusterDetails {
	s.RestoreStatus = v
	return s
}

// SetSnapshotScheduleIdentifier sets the SnapshotScheduleIdentifier field's value.
func (s *AwsRedshiftClusterDetails) SetSnapshotScheduleIdentifier(v string) *AwsRedshiftClusterDetails {
	s.SnapshotScheduleIdentifier = &v
	return s
}

// SetSnapshotScheduleState sets the SnapshotScheduleState field's value.
func (s *AwsRedshiftClusterDetails) SetSnapshotScheduleState(v string) *AwsRedshiftClusterDetails {
	s.SnapshotScheduleState = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsRedshiftClusterDetails) SetVpcId(v string) *AwsRedshiftClusterDetails {
	s.VpcId = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *AwsRedshiftClusterDetails) SetVpcSecurityGroups(v []*AwsRedshiftClusterVpcSecurityGroup) *AwsRedshiftClusterDetails {
	s.VpcSecurityGroups = v
	return s
}

// The status of the elastic IP (EIP) address for an Amazon Redshift cluster.
type AwsRedshiftClusterElasticIpStatus struct {
	_ struct{} `type:"structure"`

	// The elastic IP address for the cluster.
	ElasticIp *string `type:"string"`

	// The status of the elastic IP address.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterElasticIpStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterElasticIpStatus) GoString() string {
	return s.String()
}

// SetElasticIp sets the ElasticIp field's value.
func (s *AwsRedshiftClusterElasticIpStatus) SetElasticIp(v string) *AwsRedshiftClusterElasticIpStatus {
	s.ElasticIp = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRedshiftClusterElasticIpStatus) SetStatus(v string) *AwsRedshiftClusterElasticIpStatus {
	s.Status = &v
	return s
}

// The connection endpoint for an Amazon Redshift cluster.
type AwsRedshiftClusterEndpoint struct {
	_ struct{} `type:"structure"`

	// The DNS address of the cluster.
	Address *string `type:"string"`

	// The port that the database engine listens on.
	Port *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterEndpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *AwsRedshiftClusterEndpoint) SetAddress(v string) *AwsRedshiftClusterEndpoint {
	s.Address = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AwsRedshiftClusterEndpoint) SetPort(v int64) *AwsRedshiftClusterEndpoint {
	s.Port = &v
	return s
}

// Information about whether an Amazon Redshift cluster finished applying any
// hardware changes to security module (HSM) settings that were specified in
// a modify cluster command.
type AwsRedshiftClusterHsmStatus struct {
	_ struct{} `type:"structure"`

	// The name of the HSM client certificate that the Amazon Redshift cluster uses
	// to retrieve the data encryption keys that are stored in an HSM.
	HsmClientCertificateIdentifier *string `type:"string"`

	// The name of the HSM configuration that contains the information that the
	// Amazon Redshift cluster can use to retrieve and store keys in an HSM.
	HsmConfigurationIdentifier *string `type:"string"`

	// Indicates whether the Amazon Redshift cluster has finished applying any HSM
	// settings changes specified in a modify cluster command.
	//
	// Type: String
	//
	// Valid values: active | applying
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterHsmStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterHsmStatus) GoString() string {
	return s.String()
}

// SetHsmClientCertificateIdentifier sets the HsmClientCertificateIdentifier field's value.
func (s *AwsRedshiftClusterHsmStatus) SetHsmClientCertificateIdentifier(v string) *AwsRedshiftClusterHsmStatus {
	s.HsmClientCertificateIdentifier = &v
	return s
}

// SetHsmConfigurationIdentifier sets the HsmConfigurationIdentifier field's value.
func (s *AwsRedshiftClusterHsmStatus) SetHsmConfigurationIdentifier(v string) *AwsRedshiftClusterHsmStatus {
	s.HsmConfigurationIdentifier = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRedshiftClusterHsmStatus) SetStatus(v string) *AwsRedshiftClusterHsmStatus {
	s.Status = &v
	return s
}

// An IAM role that the cluster can use to access other Amazon Web Services
// services.
type AwsRedshiftClusterIamRole struct {
	_ struct{} `type:"structure"`

	// The status of the IAM role's association with the cluster.
	//
	// Valid values: in-sync | adding | removing
	ApplyStatus *string `type:"string"`

	// The ARN of the IAM role.
	IamRoleArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterIamRole) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterIamRole) GoString() string {
	return s.String()
}

// SetApplyStatus sets the ApplyStatus field's value.
func (s *AwsRedshiftClusterIamRole) SetApplyStatus(v string) *AwsRedshiftClusterIamRole {
	s.ApplyStatus = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *AwsRedshiftClusterIamRole) SetIamRoleArn(v string) *AwsRedshiftClusterIamRole {
	s.IamRoleArn = &v
	return s
}

// Provides information about the logging status of the cluster.
type AwsRedshiftClusterLoggingStatus struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket where the log files are stored.
	BucketName *string `type:"string"`

	// The message indicating that the logs failed to be delivered.
	LastFailureMessage *string `type:"string"`

	// The last time when logs failed to be delivered.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastFailureTime *string `type:"string"`

	// The last time that logs were delivered successfully.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastSuccessfulDeliveryTime *string `type:"string"`

	// Indicates whether logging is enabled.
	LoggingEnabled *bool `type:"boolean"`

	// Provides the prefix applied to the log file names.
	S3KeyPrefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterLoggingStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterLoggingStatus) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *AwsRedshiftClusterLoggingStatus) SetBucketName(v string) *AwsRedshiftClusterLoggingStatus {
	s.BucketName = &v
	return s
}

// SetLastFailureMessage sets the LastFailureMessage field's value.
func (s *AwsRedshiftClusterLoggingStatus) SetLastFailureMessage(v string) *AwsRedshiftClusterLoggingStatus {
	s.LastFailureMessage = &v
	return s
}

// SetLastFailureTime sets the LastFailureTime field's value.
func (s *AwsRedshiftClusterLoggingStatus) SetLastFailureTime(v string) *AwsRedshiftClusterLoggingStatus {
	s.LastFailureTime = &v
	return s
}

// SetLastSuccessfulDeliveryTime sets the LastSuccessfulDeliveryTime field's value.
func (s *AwsRedshiftClusterLoggingStatus) SetLastSuccessfulDeliveryTime(v string) *AwsRedshiftClusterLoggingStatus {
	s.LastSuccessfulDeliveryTime = &v
	return s
}

// SetLoggingEnabled sets the LoggingEnabled field's value.
func (s *AwsRedshiftClusterLoggingStatus) SetLoggingEnabled(v bool) *AwsRedshiftClusterLoggingStatus {
	s.LoggingEnabled = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *AwsRedshiftClusterLoggingStatus) SetS3KeyPrefix(v string) *AwsRedshiftClusterLoggingStatus {
	s.S3KeyPrefix = &v
	return s
}

// Changes to the Amazon Redshift cluster that are currently pending.
type AwsRedshiftClusterPendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// The pending or in-progress change to the automated snapshot retention period.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The pending or in-progress change to the identifier for the cluster.
	ClusterIdentifier *string `type:"string"`

	// The pending or in-progress change to the cluster type.
	ClusterType *string `type:"string"`

	// The pending or in-progress change to the service version.
	ClusterVersion *string `type:"string"`

	// The encryption type for a cluster.
	EncryptionType *string `type:"string"`

	// Indicates whether to create the cluster with enhanced VPC routing enabled.
	EnhancedVpcRouting *bool `type:"boolean"`

	// The name of the maintenance track that the cluster changes to during the
	// next maintenance window.
	MaintenanceTrackName *string `type:"string"`

	// The pending or in-progress change to the master user password for the cluster.
	MasterUserPassword *string `type:"string"`

	// The pending or in-progress change to the cluster's node type.
	NodeType *string `type:"string"`

	// The pending or in-progress change to the number of nodes in the cluster.
	NumberOfNodes *int64 `type:"integer"`

	// The pending or in-progress change to whether the cluster can be connected
	// to from the public network.
	PubliclyAccessible *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterPendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterPendingModifiedValues) GoString() string {
	return s.String()
}

// SetAutomatedSnapshotRetentionPeriod sets the AutomatedSnapshotRetentionPeriod field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetAutomatedSnapshotRetentionPeriod(v int64) *AwsRedshiftClusterPendingModifiedValues {
	s.AutomatedSnapshotRetentionPeriod = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetClusterIdentifier(v string) *AwsRedshiftClusterPendingModifiedValues {
	s.ClusterIdentifier = &v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetClusterType(v string) *AwsRedshiftClusterPendingModifiedValues {
	s.ClusterType = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetClusterVersion(v string) *AwsRedshiftClusterPendingModifiedValues {
	s.ClusterVersion = &v
	return s
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetEncryptionType(v string) *AwsRedshiftClusterPendingModifiedValues {
	s.EncryptionType = &v
	return s
}

// SetEnhancedVpcRouting sets the EnhancedVpcRouting field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetEnhancedVpcRouting(v bool) *AwsRedshiftClusterPendingModifiedValues {
	s.EnhancedVpcRouting = &v
	return s
}

// SetMaintenanceTrackName sets the MaintenanceTrackName field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetMaintenanceTrackName(v string) *AwsRedshiftClusterPendingModifiedValues {
	s.MaintenanceTrackName = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetMasterUserPassword(v string) *AwsRedshiftClusterPendingModifiedValues {
	s.MasterUserPassword = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetNodeType(v string) *AwsRedshiftClusterPendingModifiedValues {
	s.NodeType = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetNumberOfNodes(v int64) *AwsRedshiftClusterPendingModifiedValues {
	s.NumberOfNodes = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetPubliclyAccessible(v bool) *AwsRedshiftClusterPendingModifiedValues {
	s.PubliclyAccessible = &v
	return s
}

// Information about the resize operation for the cluster.
type AwsRedshiftClusterResizeInfo struct {
	_ struct{} `type:"structure"`

	// Indicates whether the resize operation can be canceled.
	AllowCancelResize *bool `type:"boolean"`

	// The type of resize operation.
	//
	// Valid values: ClassicResize
	ResizeType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterResizeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterResizeInfo) GoString() string {
	return s.String()
}

// SetAllowCancelResize sets the AllowCancelResize field's value.
func (s *AwsRedshiftClusterResizeInfo) SetAllowCancelResize(v bool) *AwsRedshiftClusterResizeInfo {
	s.AllowCancelResize = &v
	return s
}

// SetResizeType sets the ResizeType field's value.
func (s *AwsRedshiftClusterResizeInfo) SetResizeType(v string) *AwsRedshiftClusterResizeInfo {
	s.ResizeType = &v
	return s
}

// Information about the status of a cluster restore action. It only applies
// if the cluster was created by restoring a snapshot.
type AwsRedshiftClusterRestoreStatus struct {
	_ struct{} `type:"structure"`

	// The number of megabytes per second being transferred from the backup storage.
	// Returns the average rate for a completed backup.
	//
	// This field is only updated when you restore to DC2 and DS2 node types.
	CurrentRestoreRateInMegaBytesPerSecond *float64 `type:"double"`

	// The amount of time an in-progress restore has been running, or the amount
	// of time it took a completed restore to finish.
	//
	// This field is only updated when you restore to DC2 and DS2 node types.
	ElapsedTimeInSeconds *int64 `type:"long"`

	// The estimate of the time remaining before the restore is complete. Returns
	// 0 for a completed restore.
	//
	// This field is only updated when you restore to DC2 and DS2 node types.
	EstimatedTimeToCompletionInSeconds *int64 `type:"long"`

	// The number of megabytes that were transferred from snapshot storage.
	//
	// This field is only updated when you restore to DC2 and DS2 node types.
	ProgressInMegaBytes *int64 `type:"long"`

	// The size of the set of snapshot data that was used to restore the cluster.
	//
	// This field is only updated when you restore to DC2 and DS2 node types.
	SnapshotSizeInMegaBytes *int64 `type:"long"`

	// The status of the restore action.
	//
	// Valid values: starting | restoring | completed | failed
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterRestoreStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterRestoreStatus) GoString() string {
	return s.String()
}

// SetCurrentRestoreRateInMegaBytesPerSecond sets the CurrentRestoreRateInMegaBytesPerSecond field's value.
func (s *AwsRedshiftClusterRestoreStatus) SetCurrentRestoreRateInMegaBytesPerSecond(v float64) *AwsRedshiftClusterRestoreStatus {
	s.CurrentRestoreRateInMegaBytesPerSecond = &v
	return s
}

// SetElapsedTimeInSeconds sets the ElapsedTimeInSeconds field's value.
func (s *AwsRedshiftClusterRestoreStatus) SetElapsedTimeInSeconds(v int64) *AwsRedshiftClusterRestoreStatus {
	s.ElapsedTimeInSeconds = &v
	return s
}

// SetEstimatedTimeToCompletionInSeconds sets the EstimatedTimeToCompletionInSeconds field's value.
func (s *AwsRedshiftClusterRestoreStatus) SetEstimatedTimeToCompletionInSeconds(v int64) *AwsRedshiftClusterRestoreStatus {
	s.EstimatedTimeToCompletionInSeconds = &v
	return s
}

// SetProgressInMegaBytes sets the ProgressInMegaBytes field's value.
func (s *AwsRedshiftClusterRestoreStatus) SetProgressInMegaBytes(v int64) *AwsRedshiftClusterRestoreStatus {
	s.ProgressInMegaBytes = &v
	return s
}

// SetSnapshotSizeInMegaBytes sets the SnapshotSizeInMegaBytes field's value.
func (s *AwsRedshiftClusterRestoreStatus) SetSnapshotSizeInMegaBytes(v int64) *AwsRedshiftClusterRestoreStatus {
	s.SnapshotSizeInMegaBytes = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRedshiftClusterRestoreStatus) SetStatus(v string) *AwsRedshiftClusterRestoreStatus {
	s.Status = &v
	return s
}

// A VPC security group that the cluster belongs to, if the cluster is in a
// VPC.
type AwsRedshiftClusterVpcSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The identifier of the VPC security group.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterVpcSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsRedshiftClusterVpcSecurityGroup) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *AwsRedshiftClusterVpcSecurityGroup) SetStatus(v string) *AwsRedshiftClusterVpcSecurityGroup {
	s.Status = &v
	return s
}

// SetVpcSecurityGroupId sets the VpcSecurityGroupId field's value.
func (s *AwsRedshiftClusterVpcSecurityGroup) SetVpcSecurityGroupId(v string) *AwsRedshiftClusterVpcSecurityGroup {
	s.VpcSecurityGroupId = &v
	return s
}

// provides information about the Amazon S3 Public Access Block configuration
// for accounts.
type AwsS3AccountPublicAccessBlockDetails struct {
	_ struct{} `type:"structure"`

	// Indicates whether to reject calls to update an S3 bucket if the calls include
	// a public access control list (ACL).
	BlockPublicAcls *bool `type:"boolean"`

	// Indicates whether to reject calls to update the access policy for an S3 bucket
	// or access point if the policy allows public access.
	BlockPublicPolicy *bool `type:"boolean"`

	// Indicates whether Amazon S3 ignores public ACLs that are associated with
	// an S3 bucket.
	IgnorePublicAcls *bool `type:"boolean"`

	// Indicates whether to restrict access to an access point or S3 bucket that
	// has a public policy to only Amazon Web Services service principals and authorized
	// users within the S3 bucket owner's account.
	RestrictPublicBuckets *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsS3AccountPublicAccessBlockDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsS3AccountPublicAccessBlockDetails) GoString() string {
	return s.String()
}

// SetBlockPublicAcls sets the BlockPublicAcls field's value.
func (s *AwsS3AccountPublicAccessBlockDetails) SetBlockPublicAcls(v bool) *AwsS3AccountPublicAccessBlockDetails {
	s.BlockPublicAcls = &v
	return s
}

// SetBlockPublicPolicy sets the BlockPublicPolicy field's value.
func (s *AwsS3AccountPublicAccessBlockDetails) SetBlockPublicPolicy(v bool) *AwsS3AccountPublicAccessBlockDetails {
	s.BlockPublicPolicy = &v
	return s
}

// SetIgnorePublicAcls sets the IgnorePublicAcls field's value.
func (s *AwsS3AccountPublicAccessBlockDetails) SetIgnorePublicAcls(v bool) *AwsS3AccountPublicAccessBlockDetails {
	s.IgnorePublicAcls = &v
	return s
}

// SetRestrictPublicBuckets sets the RestrictPublicBuckets field's value.
func (s *AwsS3AccountPublicAccessBlockDetails) SetRestrictPublicBuckets(v bool) *AwsS3AccountPublicAccessBlockDetails {
	s.RestrictPublicBuckets = &v
	return s
}

// The lifecycle configuration for the objects in the S3 bucket.
type AwsS3BucketBucketLifecycleConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// The lifecycle rules.
	Rules []*AwsS3BucketBucketLifecycleConfigurationRulesDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsS3BucketBucketLifecycleConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsS3BucketBucketLifecycleConfigurationDetails) GoString() string {
	return s.String()
}

// SetRules sets the Rules field's value.
func (s *AwsS3BucketBucketLifecycleConfigurationDetails) SetRules(v []*AwsS3BucketBucketLifecycleConfigurationRulesDetails) *AwsS3BucketBucketLifecycleConfigurationDetails {
	s.Rules = v
	return s
}

// Information about what Amazon S3 does when a multipart upload is incomplete.
type AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails struct {
	_ struct{} `type:"structure"`

	// The number of days after which Amazon S3 cancels an incomplete multipart
	// upload.
	DaysAfterInitiation *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails) GoString() string {
	return s.String()
}

// SetDaysAfterInitiation sets the DaysAfterInitiation field's value.
func (s *AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails) SetDaysAfterInitiation(v int64) *AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails {
	s.DaysAfterInitiation = &v
	return s
}

// Configuration for a lifecycle rule.
type AwsS3BucketBucketLifecycleConfigurationRulesDetails struct {
	_ struct{} `type:"structure"`

	// How Amazon S3 responds when a multipart upload is incomplete. Specifically,
	// provides a number of days before Amazon S3 cancels the entire upload.
	AbortIncompleteMultipartUpload *AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails `type:"structure"`

	// The date when objects are moved or deleted.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	ExpirationDate *string `type:"string"`

	// The length in days of the lifetime for objects that are subject to the rule.
	ExpirationInDays *int64 `type:"integer"`

	// Whether Amazon S3 removes a delete marker that has no noncurrent versions.
	// If set to true, the delete marker is expired. If set to false, the policy
	// takes no action.
	//
	// If you provide ExpiredObjectDeleteMarker, you cannot provide ExpirationInDays
	// or ExpirationDate.
	ExpiredObjectDeleteMarker *bool `type:"boolean"`

	// Identifies the objects that a rule applies to.
	Filter *AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails `type:"structure"`

	// The unique identifier of the rule.
	ID *string `type:"string"`

	// The number of days that an object is noncurrent before Amazon S3 can perform
	// the associated action.
	NoncurrentVersionExpirationInDays *int64 `type:"integer"`

	// Transition rules that describe when noncurrent objects transition to a specified
	// storage class.
	NoncurrentVersionTransitions []*AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails `type:"list"`

	// A prefix that identifies one or more objects that the rule applies to.
	Prefix *string `type:"string"`

	// The current status of the rule. Indicates whether the rule is currently being
	// applied.
	Status *string `type:"string"`

	// Transition rules that indicate when objects transition to a specified storage
	// class.
	Transitions []*AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsS3BucketBucketLifecycleConfigurationRulesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsS3BucketBucketLifecycleConfigurationRulesDetails) GoString() string {
	return s.String()
}

// SetAbortIncompleteMultipartUpload sets the AbortIncompleteMultipartUpload field's value.
func (s *AwsS3BucketBucketLifecycleConfigurationRulesDetails) SetAbortIncompleteMultipartUpload(v *AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails) *AwsS3BucketBucketLifecycleConfigurationRulesDetails {
	s.AbortIncompleteMultipartUpload = v
	return s
}

// SetExpirationDate sets the ExpirationDate field's value.
func (s *AwsS3BucketBucketLifecycleConfigurationRulesDetails) SetExpirationDate(v string) *AwsS3BucketBucketLifecycleConfigurationRulesDetails {
	s.ExpirationDate = &v
	return s
}

// SetExpirationInDays sets the ExpirationInDays field's value.
func (s *AwsS3BucketBucketLifecycleConfigurationRulesDetails) SetExpirationInDays(v int64) *AwsS3BucketBucketLifecycleConfigurationRulesDetails {
	s.ExpirationInDays = &v
	return s
}

// SetExpiredObjectDeleteMarker sets the ExpiredObjectDeleteMarker field's value.
func (s *AwsS3BucketBucketLifecycleConfigurationRulesDetails) SetExpiredObjectDeleteMarker(v bool) *AwsS3BucketBucketLifecycleConfigurationRulesDetails {
	s.ExpiredObjectDeleteMarker = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *AwsS3BucketBucketLifecycleConfigurationRulesDetails) SetFilter(v *AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails) *AwsS3BucketBucketLifecycleConfigurationRulesDetails {
	s.Filter = v
	return s
}

// SetID sets the ID field's value.
func (s *AwsS3BucketBucketLifecycleConfigurationRulesDetails) SetID(v string) *AwsS3BucketBucketLifecycleConfigurationRulesDetails {
	s.ID = &v
	return s
}

// SetNoncurrentVersionExpirationInDays sets the NoncurrentVersionExpirationInDays field's value.
func (s *AwsS3BucketBucketLifecycleConfigurationRulesDetails) SetNoncurrentVersionExpirationInDays(v int64) *AwsS3BucketBucketLifecycleConfigurationRulesDetails {
	s.NoncurrentVersionExpirationInDays = &v
	return s
}

// SetNoncurrentVersionTransitions sets the NoncurrentVersionTransitions field's value.
func (s *AwsS3BucketBucketLifecycleConfigurationRulesDetails) SetNoncurrentVersionTransitions(v []*AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails) *AwsS3BucketBucketLifecycleConfigurationRulesDetails {
	s.NoncurrentVersionTransitions = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *AwsS3BucketBucketLifecycleConfigurationRulesDetails) SetPrefix(v string) *AwsS3BucketBucketLifecycleConfigurationRulesDetails {
	s.Prefix = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsS3BucketBucketLifecycleConfigurationRulesDetails) SetStatus(v string) *AwsS3BucketBucketLifecycleConfigurationRulesDetails {
	s.Status = &v
	return s
}

// SetTransitions sets the Transitions field's value.
func (s *AwsS3BucketBucketLifecycleConfigurationRulesDetails) SetTransitions(v []*AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails) *AwsS3BucketBucketLifecycleConfigurationRulesDetails {
	s.Transitions = v
	return s
}

// Identifies the objects that a rule applies to.
type AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails struct {
	_ struct{} `type:"structure"`

	// The configuration for the filter.
	Predicate *AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails) GoString() string {
	return s.String()
}

// SetPredicate sets the Predicate field's value.
func (s *AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails) SetPredicate(v *AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails) *AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails {
	s.Predicate = v
	return s
}

// The configuration for the filter.
type AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails struct {
	_ struct{} `type:"structure"`

	// The values to use for the filter.
	Operands []*AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails `type:"list"`

	// A prefix filter.
	Prefix *string `type: