<?xml version="1.0"?>
<!--
	A stylesheet to format the xml representation of the object model
	generated by Tahiti.
	
	$Id$
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

	<xsl:template match="class|interface">
		<html>
			<head>
				<title><xsl:value-of select="@name"/></title>
			</head>
			<body>
				<xsl:value-of select="local-name(.)"/>
				<xsl:text> </xsl:text>
				<xsl:call-template name="stripPrefix">
					<xsl:with-param name="str" select="@name"/>
				</xsl:call-template>
				<xsl:text> : </xsl:text>
				
				<xsl:for-each select="extends|implements">
					<xsl:if test="position()!=1">
						<xsl:text>, </xsl:text>
					</xsl:if>
					<br/>
					<span style="width:5em"> </span>
					<a href="{@name}.xml" title="{@name}">
						<xsl:call-template name="stripPrefix">
							<xsl:with-param name="str" select="@name"/>
						</xsl:call-template>
					</a>
				</xsl:for-each>
				<br/>
				
				<xsl:text>{</xsl:text>
				<br/>
				
				<table style="margin-left:2em">
					<xsl:for-each select="field">
						<tr style="margin-top:0.5em; margin-bottom:0.5em">
							<td>
								<a href="{@itemType}.xml" title="{@itemType}">
									<xsl:call-template name="stripPrefix">
										<xsl:with-param name="str" select="@itemType"/>
									</xsl:call-template>
									<xsl:if test="@maxOccurs!=0 and @maxOccurs!=1">
										<xsl:text>[]</xsl:text>
									</xsl:if>
								</a>
							</td>
							<td style="padding-left:1em; padding-right:5em">
								<xsl:value-of select="@name"/>
							</td>
							<td style="font-size:smaller">
								<xsl:text>// (</xsl:text>
								<xsl:value-of select="@minOccurs"/>
								<xsl:text>,</xsl:text>
								<xsl:choose>
									<xsl:when test="@maxOccurs='unbounded'">
										<xsl:text>*</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="@maxOccurs"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:text>)</xsl:text>
							</td>
						</tr>
					</xsl:for-each>
				</table>
				
				<xsl:text>}</xsl:text>
				<br/>
				
				<hr/>
				
				<p>
					<xsl:text>Derived types : </xsl:text>
					<xsl:for-each select="info/derivedTypes/*">
						<xsl:text> </xsl:text>
						<a href="{@name}.xml" title="{@name}">
							<xsl:call-template name="stripPrefix">
								<xsl:with-param name="str" select="@name"/>
							</xsl:call-template>
						</a>
					</xsl:for-each>
				</p>
			</body>
		</html>
	</xsl:template>
	
	
	<xsl:template name="stripPrefix">
		<xsl:param name="str"/>
		
		<xsl:choose>
			<xsl:when test="contains($str,'.')">
				<xsl:call-template name="stripPrefix">
					<xsl:with-param name="str" select="substring-after($str,'.')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$str"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>