// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package endpoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// GetEndpointIDLogReader is a Reader for the GetEndpointIDLog structure.
type GetEndpointIDLogReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetEndpointIDLogReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetEndpointIDLogOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetEndpointIDLogInvalid()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetEndpointIDLogNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetEndpointIDLogTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /endpoint/{id}/log] GetEndpointIDLog", response, response.Code())
	}
}

// NewGetEndpointIDLogOK creates a GetEndpointIDLogOK with default headers values
func NewGetEndpointIDLogOK() *GetEndpointIDLogOK {
	return &GetEndpointIDLogOK{}
}

/*
GetEndpointIDLogOK describes a response with status code 200, with default header values.

Success
*/
type GetEndpointIDLogOK struct {
	Payload models.EndpointStatusLog
}

// IsSuccess returns true when this get endpoint Id log o k response has a 2xx status code
func (o *GetEndpointIDLogOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get endpoint Id log o k response has a 3xx status code
func (o *GetEndpointIDLogOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get endpoint Id log o k response has a 4xx status code
func (o *GetEndpointIDLogOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get endpoint Id log o k response has a 5xx status code
func (o *GetEndpointIDLogOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get endpoint Id log o k response a status code equal to that given
func (o *GetEndpointIDLogOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get endpoint Id log o k response
func (o *GetEndpointIDLogOK) Code() int {
	return 200
}

func (o *GetEndpointIDLogOK) Error() string {
	return fmt.Sprintf("[GET /endpoint/{id}/log][%d] getEndpointIdLogOK  %+v", 200, o.Payload)
}

func (o *GetEndpointIDLogOK) String() string {
	return fmt.Sprintf("[GET /endpoint/{id}/log][%d] getEndpointIdLogOK  %+v", 200, o.Payload)
}

func (o *GetEndpointIDLogOK) GetPayload() models.EndpointStatusLog {
	return o.Payload
}

func (o *GetEndpointIDLogOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetEndpointIDLogInvalid creates a GetEndpointIDLogInvalid with default headers values
func NewGetEndpointIDLogInvalid() *GetEndpointIDLogInvalid {
	return &GetEndpointIDLogInvalid{}
}

/*
GetEndpointIDLogInvalid describes a response with status code 400, with default header values.

Invalid identity provided
*/
type GetEndpointIDLogInvalid struct {
}

// IsSuccess returns true when this get endpoint Id log invalid response has a 2xx status code
func (o *GetEndpointIDLogInvalid) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get endpoint Id log invalid response has a 3xx status code
func (o *GetEndpointIDLogInvalid) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get endpoint Id log invalid response has a 4xx status code
func (o *GetEndpointIDLogInvalid) IsClientError() bool {
	return true
}

// IsServerError returns true when this get endpoint Id log invalid response has a 5xx status code
func (o *GetEndpointIDLogInvalid) IsServerError() bool {
	return false
}

// IsCode returns true when this get endpoint Id log invalid response a status code equal to that given
func (o *GetEndpointIDLogInvalid) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get endpoint Id log invalid response
func (o *GetEndpointIDLogInvalid) Code() int {
	return 400
}

func (o *GetEndpointIDLogInvalid) Error() string {
	return fmt.Sprintf("[GET /endpoint/{id}/log][%d] getEndpointIdLogInvalid ", 400)
}

func (o *GetEndpointIDLogInvalid) String() string {
	return fmt.Sprintf("[GET /endpoint/{id}/log][%d] getEndpointIdLogInvalid ", 400)
}

func (o *GetEndpointIDLogInvalid) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetEndpointIDLogNotFound creates a GetEndpointIDLogNotFound with default headers values
func NewGetEndpointIDLogNotFound() *GetEndpointIDLogNotFound {
	return &GetEndpointIDLogNotFound{}
}

/*
GetEndpointIDLogNotFound describes a response with status code 404, with default header values.

Endpoint not found
*/
type GetEndpointIDLogNotFound struct {
}

// IsSuccess returns true when this get endpoint Id log not found response has a 2xx status code
func (o *GetEndpointIDLogNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get endpoint Id log not found response has a 3xx status code
func (o *GetEndpointIDLogNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get endpoint Id log not found response has a 4xx status code
func (o *GetEndpointIDLogNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get endpoint Id log not found response has a 5xx status code
func (o *GetEndpointIDLogNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get endpoint Id log not found response a status code equal to that given
func (o *GetEndpointIDLogNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get endpoint Id log not found response
func (o *GetEndpointIDLogNotFound) Code() int {
	return 404
}

func (o *GetEndpointIDLogNotFound) Error() string {
	return fmt.Sprintf("[GET /endpoint/{id}/log][%d] getEndpointIdLogNotFound ", 404)
}

func (o *GetEndpointIDLogNotFound) String() string {
	return fmt.Sprintf("[GET /endpoint/{id}/log][%d] getEndpointIdLogNotFound ", 404)
}

func (o *GetEndpointIDLogNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetEndpointIDLogTooManyRequests creates a GetEndpointIDLogTooManyRequests with default headers values
func NewGetEndpointIDLogTooManyRequests() *GetEndpointIDLogTooManyRequests {
	return &GetEndpointIDLogTooManyRequests{}
}

/*
GetEndpointIDLogTooManyRequests describes a response with status code 429, with default header values.

Rate-limiting too many requests in the given time frame
*/
type GetEndpointIDLogTooManyRequests struct {
}

// IsSuccess returns true when this get endpoint Id log too many requests response has a 2xx status code
func (o *GetEndpointIDLogTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get endpoint Id log too many requests response has a 3xx status code
func (o *GetEndpointIDLogTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get endpoint Id log too many requests response has a 4xx status code
func (o *GetEndpointIDLogTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get endpoint Id log too many requests response has a 5xx status code
func (o *GetEndpointIDLogTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get endpoint Id log too many requests response a status code equal to that given
func (o *GetEndpointIDLogTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get endpoint Id log too many requests response
func (o *GetEndpointIDLogTooManyRequests) Code() int {
	return 429
}

func (o *GetEndpointIDLogTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /endpoint/{id}/log][%d] getEndpointIdLogTooManyRequests ", 429)
}

func (o *GetEndpointIDLogTooManyRequests) String() string {
	return fmt.Sprintf("[GET /endpoint/{id}/log][%d] getEndpointIdLogTooManyRequests ", 429)
}

func (o *GetEndpointIDLogTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}
