/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools.policytool;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import javax.swing.JTextField;
import sun.security.tools.policytool.PolicyTool;
import sun.security.tools.policytool.ToolDialog;
import sun.security.tools.policytool.ToolWindow;

class FileMenuListener
implements ActionListener {
    private PolicyTool tool;
    private ToolWindow tw;

    FileMenuListener(PolicyTool policyTool, ToolWindow toolWindow) {
        this.tool = policyTool;
        this.tw = toolWindow;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block17: {
            if (PolicyTool.collator.compare(actionEvent.getActionCommand(), "Exit") == 0) {
                ToolDialog toolDialog = new ToolDialog(PolicyTool.getMessage("Save.Changes"), this.tool, this.tw, true);
                toolDialog.displayUserSave(1);
            } else if (PolicyTool.collator.compare(actionEvent.getActionCommand(), "New") == 0) {
                ToolDialog toolDialog = new ToolDialog(PolicyTool.getMessage("Save.Changes"), this.tool, this.tw, true);
                toolDialog.displayUserSave(2);
            } else if (PolicyTool.collator.compare(actionEvent.getActionCommand(), "Open") == 0) {
                ToolDialog toolDialog = new ToolDialog(PolicyTool.getMessage("Save.Changes"), this.tool, this.tw, true);
                toolDialog.displayUserSave(3);
            } else if (PolicyTool.collator.compare(actionEvent.getActionCommand(), "Save") == 0) {
                String string = ((JTextField)this.tw.getComponent(1)).getText();
                if (string == null || string.length() == 0) {
                    ToolDialog toolDialog = new ToolDialog(PolicyTool.getMessage("Save.As"), this.tool, this.tw, true);
                    toolDialog.displaySaveAsDialog(0);
                } else {
                    try {
                        this.tool.savePolicy(string);
                        MessageFormat messageFormat = new MessageFormat(PolicyTool.getMessage("Policy.successfully.written.to.filename"));
                        Object[] objectArray = new Object[]{string};
                        this.tw.displayStatusDialog(null, messageFormat.format(objectArray));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (string == null || string.equals("")) {
                            this.tw.displayErrorDialog(null, new FileNotFoundException(PolicyTool.getMessage("null.filename")));
                            break block17;
                        }
                        this.tw.displayErrorDialog(null, fileNotFoundException);
                    }
                    catch (Exception exception) {
                        this.tw.displayErrorDialog(null, exception);
                    }
                }
            } else if (PolicyTool.collator.compare(actionEvent.getActionCommand(), "Save.As") == 0) {
                ToolDialog toolDialog = new ToolDialog(PolicyTool.getMessage("Save.As"), this.tool, this.tw, true);
                toolDialog.displaySaveAsDialog(0);
            } else if (PolicyTool.collator.compare(actionEvent.getActionCommand(), "View.Warning.Log") == 0) {
                this.tw.displayWarningLog(null);
            }
        }
    }
}

