/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.task;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObjectLocalized;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.task.DBTTaskCategory;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.registry.task.TaskTypeDescriptor;

public class TaskCategoryDescriptor
extends AbstractContextDescriptor
implements DBTTaskCategory,
DBPNamedObjectLocalized {
    private final IConfigurationElement config;
    private final List<TaskTypeDescriptor> tasks = new ArrayList<TaskTypeDescriptor>();
    private TaskCategoryDescriptor parent;
    private List<TaskCategoryDescriptor> children = new ArrayList<TaskCategoryDescriptor>();

    TaskCategoryDescriptor(TaskRegistry registry, IConfigurationElement config) {
        super(config);
        this.config = config;
        String parentId = config.getAttribute("parent");
        if (parentId != null) {
            this.parent = registry.getTaskCategory(parentId);
            if (this.parent != null) {
                this.parent.addChild(this);
            }
        }
    }

    private void addChild(TaskCategoryDescriptor child) {
        this.children.add(child);
    }

    void addTask(TaskTypeDescriptor task) {
        this.tasks.add(task);
    }

    @NotNull
    public String getId() {
        return this.config.getAttribute("id");
    }

    @Nullable
    public TaskCategoryDescriptor getParent() {
        return this.parent;
    }

    @NotNull
    public DBTTaskCategory[] getChildren() {
        return this.children.toArray(new DBTTaskCategory[0]);
    }

    @NotNull
    public String getName() {
        return this.config.getAttribute("name");
    }

    public String getDescription() {
        return this.config.getAttribute("description");
    }

    public DBPImage getIcon() {
        return this.iconToImage(this.config.getAttribute("icon"));
    }

    @NotNull
    public DBTTaskType[] getTaskTypes() {
        return this.tasks.toArray(new DBTTaskType[0]);
    }

    public String toString() {
        return this.getId();
    }

    @NotNull
    public String getLocalizedName(@NotNull String locale) {
        return this.config.getAttribute("name", locale);
    }
}

