#include <sys/file.h>  	// LOCK_EX, LOCK_NB, flock(), LOCK_SH, LOCK_UN 
#include <sys/stat.h>   // struct stat
#include <stdlib.h>	// free(), calloc()
#include <stdio.h>	// FILE *, fopen(), fileno(), ftell(), fseek(), fflush(), fclose() 
#include <string.h>	// strlen(), strncpy()
#include <unistd.h>	// read(), write()

/**************************************************************************
 **SA Network Connection Profiler [sancp] - A TCP/IP statistical/collection tool
 * ************************************************************************
 * * Copyright (C) 2003 John Curry <john.curry@metre.net>
 * *
 * * This program is distributed under the terms of version 1.0 of the
 * * Q Public License.  See LICENSE.QPL for further details.
 * *
 * * This program is distributed in the hope that it will be useful,
 * * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * *
 * ***********************************************************************/


#define FILEHANDLE_H
#define READ_MODE 0
#define WRITE_MODE 1
#define APPEND_MODE 2

class fileHandle {

	public: 
		fileHandle();

		fileHandle(const char *newfilename);

		fileHandle(FILE *OFH, int);
		
		fileHandle(const char *newfilename, int);
		
		void setFileName(const char *newfilename);

		char * getFileName();

		int isOpen();

		int open();
		
		void reopen();

		FILE *getFileHandle();

		ssize_t write(const char *data, int len);
		
		int read(char *data, int len);
		
		long tell();
		
		int seek(long offset, int whence);
		
		void setMode(int mode);
		
		int getMode();
		
		fileHandle * attach();
		
		void detach();
		
		void close();

		void destroy();  // Do not call if object is declared on the stack - we need to change this...

		~fileHandle();

	private:
		u_int64_t in_use;// Count of 
		FILE *handle;	// Where we write data to the file
		char *filename; // self-explanatory
		int  mode;	// are we opened for reading, writing, append...
};

	
