/**************************************************************************
 **sA Network Connection Profiler [sancp] - A TCP/IP statistical/collection tool
 * ************************************************************************
 * * Copyright (C) 2003 John Curry <john.curry@metre.net>
 * *
 * * This program is distributed under the terms of version 1.0 of the
 * * Q Public License.  See LICENSE.QPL for further details.
 * *
 * * This program is distributed in the hope that it will be useful,
 * * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * *
 * ***********************************************************************/

#include "fileHandle.h"

#define PCAP_HEADER_SIZE 24

const char pcap_header[] = { 0xd4,0xc3,0xb2,0xa1,0x02,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x4e,0x00,0x00,0x01,0x00,0x00,0x00 };

class pcapFileHandle : public fileHandle {

	public: 
		pcapFileHandle();

		pcapFileHandle(const char *newfilename);

		int open();

		int stat();
		
		ssize_t write(const char *data, int len, struct timeval *time);

		pcapFileHandle * attach();

	protected:
		~pcapFileHandle();

	private:
		void writePcapHeader();

};

	
/*
Flow of stuff
-------------

Upon startup,  process command line, read configuration file (setup rules), get last connection ID,
open files, setup signal handling, open input device or file, run pcap_loop    

Packet Processing

New connection -> first packet arrives check if we want the packet 
	(ARP, RARP, IP broadcasts are not welcome) (need to use BPF instead)
Allocate memory for a "cnx" structure
Decode the packet; fill in the "cnx" structure

Check if we are already tracking this session, 
		if not, locate applicable rule and initialize tracking, accordingly
		record realtime if required
Update connection information

Record raw data to appropriate output file handle

Erase all idle connections (if 10 seconds have transpired since the last packet was received)	
	Close any unused output file handles
	Free memory used for each connection we expire


Upon termination, record all open connections to stdout (should be configurable - or flag a 
connection as being recorded  pre-maturely)
Free all memory, close all open file handles, record last connection ID



	
	
	

1. Process-based output files - created when process starts
2. Rule-based output files - created when rules are processed
3. Connection-based output files - created when new connections are created

A. Open a connection, increment in_use; open output_file when in_use == 1
Z. Close a connection, decrement in_use; close output_file when in_use == 0 

Need something to locate all connections that have the a pointer to a specific file handle.
(not really but it would be cool)
*/
