# This file was automatically generated by running:
#
#   scripts/generate_grapheme_break_spec.cr
#
# See https://www.unicode.org/license.html for the Unicode license agreement.
# DO NOT EDIT

require "./spec_helper"

describe "String#each_grapheme" do
  it_iterates_graphemes "\r\r", ['\r', '\r']                                                                                                                                                                                            #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\r", ['\r', '\u0308', '\r']                                                                                                                                                                            #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\r\n", ["\r\n"]                                                                                                                                                                                                #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\n", ['\r', '\u0308', '\n']                                                                                                                                                                            #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\r\u0000", ['\r', '\0']                                                                                                                                                                                        #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u0000", ['\r', '\u0308', '\0']                                                                                                                                                                        #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\r\u094D", ['\r', '\u094D']                                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u094D", ['\r', "\u0308\u094D"]                                                                                                                                                                        #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\r\u0300", ['\r', '\u0300']                                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u0300", ['\r', "\u0308\u0300"]                                                                                                                                                                        #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\r\u200C", ['\r', '\u200C']                                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u200C", ['\r', "\u0308\u200C"]                                                                                                                                                                        #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\r\u200D", ['\r', '\u200D']                                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u200D", ['\r', "\u0308\u200D"]                                                                                                                                                                        #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\r\u{1F1E6}", ['\r', '\u{1F1E6}']                                                                                                                                                                              #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u{1F1E6}", ['\r', '\u0308', '\u{1F1E6}']                                                                                                                                                              #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\r\u06DD", ['\r', '\u06DD']                                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u06DD", ['\r', '\u0308', '\u06DD']                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\r\u0903", ['\r', '\u0903']                                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u0903", ['\r', "\u0308\u0903"]                                                                                                                                                                        #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\r\u1100", ['\r', '\u1100']                                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u1100", ['\r', '\u0308', '\u1100']                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\r\u1160", ['\r', '\u1160']                                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u1160", ['\r', '\u0308', '\u1160']                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\r\u11A8", ['\r', '\u11A8']                                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u11A8", ['\r', '\u0308', '\u11A8']                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\r\uAC00", ['\r', '\uAC00']                                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\uAC00", ['\r', '\u0308', '\uAC00']                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\r\uAC01", ['\r', '\uAC01']                                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\uAC01", ['\r', '\u0308', '\uAC01']                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\r\u0915", ['\r', '\u0915']                                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u0915", ['\r', '\u0308', '\u0915']                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\r\u00A9", ['\r', '\u00A9']                                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u00A9", ['\r', '\u0308', '\u00A9']                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\r ", ['\r', ' ']                                                                                                                                                                                              #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\r\u0308 ", ['\r', '\u0308', ' ']                                                                                                                                                                              #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\r\u0378", ['\r', '\u0378']                                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u0378", ['\r', '\u0308', '\u0378']                                                                                                                                                                    #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\n\r", ['\n', '\r']                                                                                                                                                                                            #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\r", ['\n', '\u0308', '\r']                                                                                                                                                                            #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\n\n", ['\n', '\n']                                                                                                                                                                                            #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\n", ['\n', '\u0308', '\n']                                                                                                                                                                            #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\n\u0000", ['\n', '\0']                                                                                                                                                                                        #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u0000", ['\n', '\u0308', '\0']                                                                                                                                                                        #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\n\u094D", ['\n', '\u094D']                                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u094D", ['\n', "\u0308\u094D"]                                                                                                                                                                        #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\n\u0300", ['\n', '\u0300']                                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u0300", ['\n', "\u0308\u0300"]                                                                                                                                                                        #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\n\u200C", ['\n', '\u200C']                                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u200C", ['\n', "\u0308\u200C"]                                                                                                                                                                        #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\n\u200D", ['\n', '\u200D']                                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u200D", ['\n', "\u0308\u200D"]                                                                                                                                                                        #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\n\u{1F1E6}", ['\n', '\u{1F1E6}']                                                                                                                                                                              #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u{1F1E6}", ['\n', '\u0308', '\u{1F1E6}']                                                                                                                                                              #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\n\u06DD", ['\n', '\u06DD']                                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u06DD", ['\n', '\u0308', '\u06DD']                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\n\u0903", ['\n', '\u0903']                                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u0903", ['\n', "\u0308\u0903"]                                                                                                                                                                        #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\n\u1100", ['\n', '\u1100']                                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u1100", ['\n', '\u0308', '\u1100']                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\n\u1160", ['\n', '\u1160']                                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u1160", ['\n', '\u0308', '\u1160']                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\n\u11A8", ['\n', '\u11A8']                                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u11A8", ['\n', '\u0308', '\u11A8']                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\n\uAC00", ['\n', '\uAC00']                                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\uAC00", ['\n', '\u0308', '\uAC00']                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\n\uAC01", ['\n', '\uAC01']                                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\uAC01", ['\n', '\u0308', '\uAC01']                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\n\u0915", ['\n', '\u0915']                                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u0915", ['\n', '\u0308', '\u0915']                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\n\u00A9", ['\n', '\u00A9']                                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u00A9", ['\n', '\u0308', '\u00A9']                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\n ", ['\n', ' ']                                                                                                                                                                                              #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\n\u0308 ", ['\n', '\u0308', ' ']                                                                                                                                                                              #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\n\u0378", ['\n', '\u0378']                                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u0378", ['\n', '\u0308', '\u0378']                                                                                                                                                                    #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0000\r", ['\0', '\r']                                                                                                                                                                                        #   ÷ [0.2] <NULL> (Control) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0308\r", ['\0', '\u0308', '\r']                                                                                                                                                                        #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u0000\n", ['\0', '\n']                                                                                                                                                                                        #   ÷ [0.2] <NULL> (Control) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0308\n", ['\0', '\u0308', '\n']                                                                                                                                                                        #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0000", ['\0', '\0']                                                                                                                                                                                    #   ÷ [0.2] <NULL> (Control) ÷ [4.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0308\u0000", ['\0', '\u0308', '\0']                                                                                                                                                                    #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0000\u094D", ['\0', '\u094D']                                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0308\u094D", ['\0', "\u0308\u094D"]                                                                                                                                                                    #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0300", ['\0', '\u0300']                                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0308\u0300", ['\0', "\u0308\u0300"]                                                                                                                                                                    #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0000\u200C", ['\0', '\u200C']                                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0308\u200C", ['\0', "\u0308\u200C"]                                                                                                                                                                    #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u0000\u200D", ['\0', '\u200D']                                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0308\u200D", ['\0', "\u0308\u200D"]                                                                                                                                                                    #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u0000\u{1F1E6}", ['\0', '\u{1F1E6}']                                                                                                                                                                          #   ÷ [0.2] <NULL> (Control) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0308\u{1F1E6}", ['\0', '\u0308', '\u{1F1E6}']                                                                                                                                                          #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0000\u06DD", ['\0', '\u06DD']                                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0308\u06DD", ['\0', '\u0308', '\u06DD']                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0903", ['\0', '\u0903']                                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0308\u0903", ['\0', "\u0308\u0903"]                                                                                                                                                                    #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0000\u1100", ['\0', '\u1100']                                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0308\u1100", ['\0', '\u0308', '\u1100']                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0000\u1160", ['\0', '\u1160']                                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0308\u1160", ['\0', '\u0308', '\u1160']                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0000\u11A8", ['\0', '\u11A8']                                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0308\u11A8", ['\0', '\u0308', '\u11A8']                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0000\uAC00", ['\0', '\uAC00']                                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0308\uAC00", ['\0', '\u0308', '\uAC00']                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0000\uAC01", ['\0', '\uAC01']                                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0308\uAC01", ['\0', '\u0308', '\uAC01']                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0915", ['\0', '\u0915']                                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0308\u0915", ['\0', '\u0308', '\u0915']                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u0000\u00A9", ['\0', '\u00A9']                                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0308\u00A9", ['\0', '\u0308', '\u00A9']                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0000 ", ['\0', ' ']                                                                                                                                                                                          #   ÷ [0.2] <NULL> (Control) ÷ [4.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0308 ", ['\0', '\u0308', ' ']                                                                                                                                                                          #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0378", ['\0', '\u0378']                                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0000\u0308\u0378", ['\0', '\u0308', '\u0378']                                                                                                                                                                #   ÷ [0.2] <NULL> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u094D\r", ['\u094D', '\r']                                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0308\r", ["\u094D\u0308", '\r']                                                                                                                                                                        #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u094D\n", ['\u094D', '\n']                                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0308\n", ["\u094D\u0308", '\n']                                                                                                                                                                        #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0000", ['\u094D', '\0']                                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0308\u0000", ["\u094D\u0308", '\0']                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u094D\u094D", ["\u094D\u094D"]                                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0308\u094D", ["\u094D\u0308\u094D"]                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0300", ["\u094D\u0300"]                                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0308\u0300", ["\u094D\u0308\u0300"]                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u094D\u200C", ["\u094D\u200C"]                                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0308\u200C", ["\u094D\u0308\u200C"]                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u094D\u200D", ["\u094D\u200D"]                                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0308\u200D", ["\u094D\u0308\u200D"]                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u094D\u{1F1E6}", ['\u094D', '\u{1F1E6}']                                                                                                                                                                      #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0308\u{1F1E6}", ["\u094D\u0308", '\u{1F1E6}']                                                                                                                                                          #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u094D\u06DD", ['\u094D', '\u06DD']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0308\u06DD", ["\u094D\u0308", '\u06DD']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0903", ["\u094D\u0903"]                                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0308\u0903", ["\u094D\u0308\u0903"]                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u094D\u1100", ['\u094D', '\u1100']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0308\u1100", ["\u094D\u0308", '\u1100']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u094D\u1160", ['\u094D', '\u1160']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0308\u1160", ["\u094D\u0308", '\u1160']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u094D\u11A8", ['\u094D', '\u11A8']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0308\u11A8", ["\u094D\u0308", '\u11A8']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u094D\uAC00", ['\u094D', '\uAC00']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0308\uAC00", ["\u094D\u0308", '\uAC00']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u094D\uAC01", ['\u094D', '\uAC01']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0308\uAC01", ["\u094D\u0308", '\uAC01']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0915", ['\u094D', '\u0915']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0308\u0915", ["\u094D\u0308", '\u0915']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u094D\u00A9", ['\u094D', '\u00A9']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0308\u00A9", ["\u094D\u0308", '\u00A9']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u094D ", ['\u094D', ' ']                                                                                                                                                                                      #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0308 ", ["\u094D\u0308", ' ']                                                                                                                                                                          #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0378", ['\u094D', '\u0378']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u094D\u0308\u0378", ["\u094D\u0308", '\u0378']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0300\r", ['\u0300', '\r']                                                                                                                                                                                    #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\r", ["\u0300\u0308", '\r']                                                                                                                                                                        #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u0300\n", ['\u0300', '\n']                                                                                                                                                                                    #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\n", ["\u0300\u0308", '\n']                                                                                                                                                                        #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0000", ['\u0300', '\0']                                                                                                                                                                                #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u0000", ["\u0300\u0308", '\0']                                                                                                                                                                    #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0300\u094D", ["\u0300\u094D"]                                                                                                                                                                                #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u094D", ["\u0300\u0308\u094D"]                                                                                                                                                                    #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0300", ["\u0300\u0300"]                                                                                                                                                                                #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u0300", ["\u0300\u0308\u0300"]                                                                                                                                                                    #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0300\u200C", ["\u0300\u200C"]                                                                                                                                                                                #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u200C", ["\u0300\u0308\u200C"]                                                                                                                                                                    #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u0300\u200D", ["\u0300\u200D"]                                                                                                                                                                                #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u200D", ["\u0300\u0308\u200D"]                                                                                                                                                                    #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u0300\u{1F1E6}", ['\u0300', '\u{1F1E6}']                                                                                                                                                                      #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u{1F1E6}", ["\u0300\u0308", '\u{1F1E6}']                                                                                                                                                          #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0300\u06DD", ['\u0300', '\u06DD']                                                                                                                                                                            #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u06DD", ["\u0300\u0308", '\u06DD']                                                                                                                                                                #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0903", ["\u0300\u0903"]                                                                                                                                                                                #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u0903", ["\u0300\u0308\u0903"]                                                                                                                                                                    #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0300\u1100", ['\u0300', '\u1100']                                                                                                                                                                            #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u1100", ["\u0300\u0308", '\u1100']                                                                                                                                                                #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0300\u1160", ['\u0300', '\u1160']                                                                                                                                                                            #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u1160", ["\u0300\u0308", '\u1160']                                                                                                                                                                #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0300\u11A8", ['\u0300', '\u11A8']                                                                                                                                                                            #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u11A8", ["\u0300\u0308", '\u11A8']                                                                                                                                                                #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0300\uAC00", ['\u0300', '\uAC00']                                                                                                                                                                            #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\uAC00", ["\u0300\u0308", '\uAC00']                                                                                                                                                                #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0300\uAC01", ['\u0300', '\uAC01']                                                                                                                                                                            #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\uAC01", ["\u0300\u0308", '\uAC01']                                                                                                                                                                #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0915", ['\u0300', '\u0915']                                                                                                                                                                            #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u0915", ["\u0300\u0308", '\u0915']                                                                                                                                                                #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u0300\u00A9", ['\u0300', '\u00A9']                                                                                                                                                                            #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u00A9", ["\u0300\u0308", '\u00A9']                                                                                                                                                                #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0300 ", ['\u0300', ' ']                                                                                                                                                                                      #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308 ", ["\u0300\u0308", ' ']                                                                                                                                                                          #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0378", ['\u0300', '\u0378']                                                                                                                                                                            #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u0378", ["\u0300\u0308", '\u0378']                                                                                                                                                                #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u200C\r", ['\u200C', '\r']                                                                                                                                                                                    #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0308\r", ["\u200C\u0308", '\r']                                                                                                                                                                        #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u200C\n", ['\u200C', '\n']                                                                                                                                                                                    #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0308\n", ["\u200C\u0308", '\n']                                                                                                                                                                        #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0000", ['\u200C', '\0']                                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0308\u0000", ["\u200C\u0308", '\0']                                                                                                                                                                    #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u200C\u094D", ["\u200C\u094D"]                                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0308\u094D", ["\u200C\u0308\u094D"]                                                                                                                                                                    #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0300", ["\u200C\u0300"]                                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0308\u0300", ["\u200C\u0308\u0300"]                                                                                                                                                                    #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u200C\u200C", ["\u200C\u200C"]                                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0308\u200C", ["\u200C\u0308\u200C"]                                                                                                                                                                    #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u200C\u200D", ["\u200C\u200D"]                                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0308\u200D", ["\u200C\u0308\u200D"]                                                                                                                                                                    #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u200C\u{1F1E6}", ['\u200C', '\u{1F1E6}']                                                                                                                                                                      #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0308\u{1F1E6}", ["\u200C\u0308", '\u{1F1E6}']                                                                                                                                                          #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u200C\u06DD", ['\u200C', '\u06DD']                                                                                                                                                                            #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0308\u06DD", ["\u200C\u0308", '\u06DD']                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0903", ["\u200C\u0903"]                                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0308\u0903", ["\u200C\u0308\u0903"]                                                                                                                                                                    #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u200C\u1100", ['\u200C', '\u1100']                                                                                                                                                                            #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0308\u1100", ["\u200C\u0308", '\u1100']                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u200C\u1160", ['\u200C', '\u1160']                                                                                                                                                                            #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0308\u1160", ["\u200C\u0308", '\u1160']                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u200C\u11A8", ['\u200C', '\u11A8']                                                                                                                                                                            #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0308\u11A8", ["\u200C\u0308", '\u11A8']                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u200C\uAC00", ['\u200C', '\uAC00']                                                                                                                                                                            #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0308\uAC00", ["\u200C\u0308", '\uAC00']                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u200C\uAC01", ['\u200C', '\uAC01']                                                                                                                                                                            #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0308\uAC01", ["\u200C\u0308", '\uAC01']                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0915", ['\u200C', '\u0915']                                                                                                                                                                            #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0308\u0915", ["\u200C\u0308", '\u0915']                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u200C\u00A9", ['\u200C', '\u00A9']                                                                                                                                                                            #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0308\u00A9", ["\u200C\u0308", '\u00A9']                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u200C ", ['\u200C', ' ']                                                                                                                                                                                      #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0308 ", ["\u200C\u0308", ' ']                                                                                                                                                                          #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0378", ['\u200C', '\u0378']                                                                                                                                                                            #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u200C\u0308\u0378", ["\u200C\u0308", '\u0378']                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u200D\r", ['\u200D', '\r']                                                                                                                                                                                    #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\r", ["\u200D\u0308", '\r']                                                                                                                                                                        #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u200D\n", ['\u200D', '\n']                                                                                                                                                                                    #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\n", ["\u200D\u0308", '\n']                                                                                                                                                                        #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0000", ['\u200D', '\0']                                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u0000", ["\u200D\u0308", '\0']                                                                                                                                                                    #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u200D\u094D", ["\u200D\u094D"]                                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u094D", ["\u200D\u0308\u094D"]                                                                                                                                                                    #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0300", ["\u200D\u0300"]                                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u0300", ["\u200D\u0308\u0300"]                                                                                                                                                                    #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u200D\u200C", ["\u200D\u200C"]                                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u200C", ["\u200D\u0308\u200C"]                                                                                                                                                                    #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u200D\u200D", ["\u200D\u200D"]                                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u200D", ["\u200D\u0308\u200D"]                                                                                                                                                                    #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u200D\u{1F1E6}", ['\u200D', '\u{1F1E6}']                                                                                                                                                                      #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u{1F1E6}", ["\u200D\u0308", '\u{1F1E6}']                                                                                                                                                          #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u200D\u06DD", ['\u200D', '\u06DD']                                                                                                                                                                            #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u06DD", ["\u200D\u0308", '\u06DD']                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0903", ["\u200D\u0903"]                                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u0903", ["\u200D\u0308\u0903"]                                                                                                                                                                    #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u200D\u1100", ['\u200D', '\u1100']                                                                                                                                                                            #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u1100", ["\u200D\u0308", '\u1100']                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u200D\u1160", ['\u200D', '\u1160']                                                                                                                                                                            #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u1160", ["\u200D\u0308", '\u1160']                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u200D\u11A8", ['\u200D', '\u11A8']                                                                                                                                                                            #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u11A8", ["\u200D\u0308", '\u11A8']                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u200D\uAC00", ['\u200D', '\uAC00']                                                                                                                                                                            #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\uAC00", ["\u200D\u0308", '\uAC00']                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u200D\uAC01", ['\u200D', '\uAC01']                                                                                                                                                                            #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\uAC01", ["\u200D\u0308", '\uAC01']                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0915", ['\u200D', '\u0915']                                                                                                                                                                            #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u0915", ["\u200D\u0308", '\u0915']                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u200D\u00A9", ['\u200D', '\u00A9']                                                                                                                                                                            #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u00A9", ["\u200D\u0308", '\u00A9']                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u200D ", ['\u200D', ' ']                                                                                                                                                                                      #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308 ", ["\u200D\u0308", ' ']                                                                                                                                                                          #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0378", ['\u200D', '\u0378']                                                                                                                                                                            #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u0378", ["\u200D\u0308", '\u0378']                                                                                                                                                                #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\r", ['\u{1F1E6}', '\r']                                                                                                                                                                              #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\r", ["\u{1F1E6}\u0308", '\r']                                                                                                                                                                  #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\n", ['\u{1F1E6}', '\n']                                                                                                                                                                              #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\n", ["\u{1F1E6}\u0308", '\n']                                                                                                                                                                  #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0000", ['\u{1F1E6}', '\0']                                                                                                                                                                          #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u0000", ["\u{1F1E6}\u0308", '\0']                                                                                                                                                              #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u094D", ["\u{1F1E6}\u094D"]                                                                                                                                                                          #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u094D", ["\u{1F1E6}\u0308\u094D"]                                                                                                                                                              #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0300", ["\u{1F1E6}\u0300"]                                                                                                                                                                          #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u0300", ["\u{1F1E6}\u0308\u0300"]                                                                                                                                                              #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u200C", ["\u{1F1E6}\u200C"]                                                                                                                                                                          #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u200C", ["\u{1F1E6}\u0308\u200C"]                                                                                                                                                              #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u200D", ["\u{1F1E6}\u200D"]                                                                                                                                                                          #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u200D", ["\u{1F1E6}\u0308\u200D"]                                                                                                                                                              #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u{1F1E6}", ["\u{1F1E6}\u{1F1E6}"]                                                                                                                                                                    #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [12.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u{1F1E6}", ["\u{1F1E6}\u0308", '\u{1F1E6}']                                                                                                                                                    #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u06DD", ['\u{1F1E6}', '\u06DD']                                                                                                                                                                      #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u06DD", ["\u{1F1E6}\u0308", '\u06DD']                                                                                                                                                          #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0903", ["\u{1F1E6}\u0903"]                                                                                                                                                                          #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u0903", ["\u{1F1E6}\u0308\u0903"]                                                                                                                                                              #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u1100", ['\u{1F1E6}', '\u1100']                                                                                                                                                                      #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u1100", ["\u{1F1E6}\u0308", '\u1100']                                                                                                                                                          #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u1160", ['\u{1F1E6}', '\u1160']                                                                                                                                                                      #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u1160", ["\u{1F1E6}\u0308", '\u1160']                                                                                                                                                          #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u11A8", ['\u{1F1E6}', '\u11A8']                                                                                                                                                                      #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u11A8", ["\u{1F1E6}\u0308", '\u11A8']                                                                                                                                                          #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\uAC00", ['\u{1F1E6}', '\uAC00']                                                                                                                                                                      #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\uAC00", ["\u{1F1E6}\u0308", '\uAC00']                                                                                                                                                          #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\uAC01", ['\u{1F1E6}', '\uAC01']                                                                                                                                                                      #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\uAC01", ["\u{1F1E6}\u0308", '\uAC01']                                                                                                                                                          #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0915", ['\u{1F1E6}', '\u0915']                                                                                                                                                                      #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u0915", ["\u{1F1E6}\u0308", '\u0915']                                                                                                                                                          #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u00A9", ['\u{1F1E6}', '\u00A9']                                                                                                                                                                      #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u00A9", ["\u{1F1E6}\u0308", '\u00A9']                                                                                                                                                          #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6} ", ['\u{1F1E6}', ' ']                                                                                                                                                                                #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308 ", ["\u{1F1E6}\u0308", ' ']                                                                                                                                                                    #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0378", ['\u{1F1E6}', '\u0378']                                                                                                                                                                      #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u0378", ["\u{1F1E6}\u0308", '\u0378']                                                                                                                                                          #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u06DD\r", ['\u06DD', '\r']                                                                                                                                                                                    #   ÷ [0.2] ARABIC END OF AYAH (Prepend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0308\r", ["\u06DD\u0308", '\r']                                                                                                                                                                        #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u06DD\n", ['\u06DD', '\n']                                                                                                                                                                                    #   ÷ [0.2] ARABIC END OF AYAH (Prepend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0308\n", ["\u06DD\u0308", '\n']                                                                                                                                                                        #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0000", ['\u06DD', '\0']                                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0308\u0000", ["\u06DD\u0308", '\0']                                                                                                                                                                    #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u094D", ["\u06DD\u094D"]                                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0308\u094D", ["\u06DD\u0308\u094D"]                                                                                                                                                                    #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0300", ["\u06DD\u0300"]                                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0308\u0300", ["\u06DD\u0308\u0300"]                                                                                                                                                                    #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u200C", ["\u06DD\u200C"]                                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0308\u200C", ["\u06DD\u0308\u200C"]                                                                                                                                                                    #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u200D", ["\u06DD\u200D"]                                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0308\u200D", ["\u06DD\u0308\u200D"]                                                                                                                                                                    #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u{1F1E6}", ["\u06DD\u{1F1E6}"]                                                                                                                                                                          #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0308\u{1F1E6}", ["\u06DD\u0308", '\u{1F1E6}']                                                                                                                                                          #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u06DD", ["\u06DD\u06DD"]                                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0308\u06DD", ["\u06DD\u0308", '\u06DD']                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0903", ["\u06DD\u0903"]                                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0308\u0903", ["\u06DD\u0308\u0903"]                                                                                                                                                                    #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u1100", ["\u06DD\u1100"]                                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0308\u1100", ["\u06DD\u0308", '\u1100']                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u1160", ["\u06DD\u1160"]                                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0308\u1160", ["\u06DD\u0308", '\u1160']                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u11A8", ["\u06DD\u11A8"]                                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0308\u11A8", ["\u06DD\u0308", '\u11A8']                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u06DD\uAC00", ["\u06DD\uAC00"]                                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0308\uAC00", ["\u06DD\u0308", '\uAC00']                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u06DD\uAC01", ["\u06DD\uAC01"]                                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0308\uAC01", ["\u06DD\u0308", '\uAC01']                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0915", ["\u06DD\u0915"]                                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0308\u0915", ["\u06DD\u0308", '\u0915']                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u00A9", ["\u06DD\u00A9"]                                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0308\u00A9", ["\u06DD\u0308", '\u00A9']                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u06DD ", ["\u06DD "]                                                                                                                                                                                          #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0308 ", ["\u06DD\u0308", ' ']                                                                                                                                                                          #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0378", ["\u06DD\u0378"]                                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u06DD\u0308\u0378", ["\u06DD\u0308", '\u0378']                                                                                                                                                                #   ÷ [0.2] ARABIC END OF AYAH (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0903\r", ['\u0903', '\r']                                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\r", ["\u0903\u0308", '\r']                                                                                                                                                                        #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u0903\n", ['\u0903', '\n']                                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\n", ["\u0903\u0308", '\n']                                                                                                                                                                        #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0000", ['\u0903', '\0']                                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u0000", ["\u0903\u0308", '\0']                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0903\u094D", ["\u0903\u094D"]                                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u094D", ["\u0903\u0308\u094D"]                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0300", ["\u0903\u0300"]                                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u0300", ["\u0903\u0308\u0300"]                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0903\u200C", ["\u0903\u200C"]                                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u200C", ["\u0903\u0308\u200C"]                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u0903\u200D", ["\u0903\u200D"]                                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u200D", ["\u0903\u0308\u200D"]                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u0903\u{1F1E6}", ['\u0903', '\u{1F1E6}']                                                                                                                                                                      #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u{1F1E6}", ["\u0903\u0308", '\u{1F1E6}']                                                                                                                                                          #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0903\u06DD", ['\u0903', '\u06DD']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u06DD", ["\u0903\u0308", '\u06DD']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0903", ["\u0903\u0903"]                                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u0903", ["\u0903\u0308\u0903"]                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0903\u1100", ['\u0903', '\u1100']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u1100", ["\u0903\u0308", '\u1100']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0903\u1160", ['\u0903', '\u1160']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u1160", ["\u0903\u0308", '\u1160']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0903\u11A8", ['\u0903', '\u11A8']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u11A8", ["\u0903\u0308", '\u11A8']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0903\uAC00", ['\u0903', '\uAC00']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\uAC00", ["\u0903\u0308", '\uAC00']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0903\uAC01", ['\u0903', '\uAC01']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\uAC01", ["\u0903\u0308", '\uAC01']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0915", ['\u0903', '\u0915']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u0915", ["\u0903\u0308", '\u0915']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u0903\u00A9", ['\u0903', '\u00A9']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u00A9", ["\u0903\u0308", '\u00A9']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0903 ", ['\u0903', ' ']                                                                                                                                                                                      #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308 ", ["\u0903\u0308", ' ']                                                                                                                                                                          #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0378", ['\u0903', '\u0378']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u0378", ["\u0903\u0308", '\u0378']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u1100\r", ['\u1100', '\r']                                                                                                                                                                                    #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\r", ["\u1100\u0308", '\r']                                                                                                                                                                        #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u1100\n", ['\u1100', '\n']                                                                                                                                                                                    #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\n", ["\u1100\u0308", '\n']                                                                                                                                                                        #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0000", ['\u1100', '\0']                                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u0000", ["\u1100\u0308", '\0']                                                                                                                                                                    #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u1100\u094D", ["\u1100\u094D"]                                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u094D", ["\u1100\u0308\u094D"]                                                                                                                                                                    #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0300", ["\u1100\u0300"]                                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u0300", ["\u1100\u0308\u0300"]                                                                                                                                                                    #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u1100\u200C", ["\u1100\u200C"]                                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u200C", ["\u1100\u0308\u200C"]                                                                                                                                                                    #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u1100\u200D", ["\u1100\u200D"]                                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u200D", ["\u1100\u0308\u200D"]                                                                                                                                                                    #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u1100\u{1F1E6}", ['\u1100', '\u{1F1E6}']                                                                                                                                                                      #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u{1F1E6}", ["\u1100\u0308", '\u{1F1E6}']                                                                                                                                                          #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u1100\u06DD", ['\u1100', '\u06DD']                                                                                                                                                                            #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u06DD", ["\u1100\u0308", '\u06DD']                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0903", ["\u1100\u0903"]                                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u0903", ["\u1100\u0308\u0903"]                                                                                                                                                                    #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u1100\u1100", ["\u1100\u1100"]                                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u1100", ["\u1100\u0308", '\u1100']                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u1100\u1160", ["\u1100\u1160"]                                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u1160", ["\u1100\u0308", '\u1160']                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u1100\u11A8", ['\u1100', '\u11A8']                                                                                                                                                                            #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u11A8", ["\u1100\u0308", '\u11A8']                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u1100\uAC00", ["\u1100\uAC00"]                                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\uAC00", ["\u1100\u0308", '\uAC00']                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u1100\uAC01", ["\u1100\uAC01"]                                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\uAC01", ["\u1100\u0308", '\uAC01']                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0915", ['\u1100', '\u0915']                                                                                                                                                                            #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u0915", ["\u1100\u0308", '\u0915']                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u1100\u00A9", ['\u1100', '\u00A9']                                                                                                                                                                            #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u00A9", ["\u1100\u0308", '\u00A9']                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u1100 ", ['\u1100', ' ']                                                                                                                                                                                      #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308 ", ["\u1100\u0308", ' ']                                                                                                                                                                          #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0378", ['\u1100', '\u0378']                                                                                                                                                                            #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u0378", ["\u1100\u0308", '\u0378']                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u1160\r", ['\u1160', '\r']                                                                                                                                                                                    #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\r", ["\u1160\u0308", '\r']                                                                                                                                                                        #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u1160\n", ['\u1160', '\n']                                                                                                                                                                                    #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\n", ["\u1160\u0308", '\n']                                                                                                                                                                        #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0000", ['\u1160', '\0']                                                                                                                                                                                #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u0000", ["\u1160\u0308", '\0']                                                                                                                                                                    #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u1160\u094D", ["\u1160\u094D"]                                                                                                                                                                                #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u094D", ["\u1160\u0308\u094D"]                                                                                                                                                                    #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0300", ["\u1160\u0300"]                                                                                                                                                                                #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u0300", ["\u1160\u0308\u0300"]                                                                                                                                                                    #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u1160\u200C", ["\u1160\u200C"]                                                                                                                                                                                #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u200C", ["\u1160\u0308\u200C"]                                                                                                                                                                    #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u1160\u200D", ["\u1160\u200D"]                                                                                                                                                                                #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u200D", ["\u1160\u0308\u200D"]                                                                                                                                                                    #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u1160\u{1F1E6}", ['\u1160', '\u{1F1E6}']                                                                                                                                                                      #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u{1F1E6}", ["\u1160\u0308", '\u{1F1E6}']                                                                                                                                                          #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u1160\u06DD", ['\u1160', '\u06DD']                                                                                                                                                                            #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u06DD", ["\u1160\u0308", '\u06DD']                                                                                                                                                                #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0903", ["\u1160\u0903"]                                                                                                                                                                                #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u0903", ["\u1160\u0308\u0903"]                                                                                                                                                                    #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u1160\u1100", ['\u1160', '\u1100']                                                                                                                                                                            #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u1100", ["\u1160\u0308", '\u1100']                                                                                                                                                                #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u1160\u1160", ["\u1160\u1160"]                                                                                                                                                                                #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [7.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u1160", ["\u1160\u0308", '\u1160']                                                                                                                                                                #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u1160\u11A8", ["\u1160\u11A8"]                                                                                                                                                                                #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [7.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u11A8", ["\u1160\u0308", '\u11A8']                                                                                                                                                                #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u1160\uAC00", ['\u1160', '\uAC00']                                                                                                                                                                            #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\uAC00", ["\u1160\u0308", '\uAC00']                                                                                                                                                                #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u1160\uAC01", ['\u1160', '\uAC01']                                                                                                                                                                            #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\uAC01", ["\u1160\u0308", '\uAC01']                                                                                                                                                                #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0915", ['\u1160', '\u0915']                                                                                                                                                                            #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u0915", ["\u1160\u0308", '\u0915']                                                                                                                                                                #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u1160\u00A9", ['\u1160', '\u00A9']                                                                                                                                                                            #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u00A9", ["\u1160\u0308", '\u00A9']                                                                                                                                                                #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u1160 ", ['\u1160', ' ']                                                                                                                                                                                      #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308 ", ["\u1160\u0308", ' ']                                                                                                                                                                          #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0378", ['\u1160', '\u0378']                                                                                                                                                                            #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u0378", ["\u1160\u0308", '\u0378']                                                                                                                                                                #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u11A8\r", ['\u11A8', '\r']                                                                                                                                                                                    #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\r", ["\u11A8\u0308", '\r']                                                                                                                                                                        #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u11A8\n", ['\u11A8', '\n']                                                                                                                                                                                    #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\n", ["\u11A8\u0308", '\n']                                                                                                                                                                        #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0000", ['\u11A8', '\0']                                                                                                                                                                                #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u0000", ["\u11A8\u0308", '\0']                                                                                                                                                                    #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u094D", ["\u11A8\u094D"]                                                                                                                                                                                #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u094D", ["\u11A8\u0308\u094D"]                                                                                                                                                                    #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0300", ["\u11A8\u0300"]                                                                                                                                                                                #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u0300", ["\u11A8\u0308\u0300"]                                                                                                                                                                    #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u200C", ["\u11A8\u200C"]                                                                                                                                                                                #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u200C", ["\u11A8\u0308\u200C"]                                                                                                                                                                    #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u200D", ["\u11A8\u200D"]                                                                                                                                                                                #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u200D", ["\u11A8\u0308\u200D"]                                                                                                                                                                    #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u{1F1E6}", ['\u11A8', '\u{1F1E6}']                                                                                                                                                                      #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u{1F1E6}", ["\u11A8\u0308", '\u{1F1E6}']                                                                                                                                                          #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u06DD", ['\u11A8', '\u06DD']                                                                                                                                                                            #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u06DD", ["\u11A8\u0308", '\u06DD']                                                                                                                                                                #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0903", ["\u11A8\u0903"]                                                                                                                                                                                #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u0903", ["\u11A8\u0308\u0903"]                                                                                                                                                                    #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u1100", ['\u11A8', '\u1100']                                                                                                                                                                            #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u1100", ["\u11A8\u0308", '\u1100']                                                                                                                                                                #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u1160", ['\u11A8', '\u1160']                                                                                                                                                                            #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u1160", ["\u11A8\u0308", '\u1160']                                                                                                                                                                #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u11A8", ["\u11A8\u11A8"]                                                                                                                                                                                #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [8.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u11A8", ["\u11A8\u0308", '\u11A8']                                                                                                                                                                #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u11A8\uAC00", ['\u11A8', '\uAC00']                                                                                                                                                                            #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\uAC00", ["\u11A8\u0308", '\uAC00']                                                                                                                                                                #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u11A8\uAC01", ['\u11A8', '\uAC01']                                                                                                                                                                            #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\uAC01", ["\u11A8\u0308", '\uAC01']                                                                                                                                                                #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0915", ['\u11A8', '\u0915']                                                                                                                                                                            #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u0915", ["\u11A8\u0308", '\u0915']                                                                                                                                                                #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u00A9", ['\u11A8', '\u00A9']                                                                                                                                                                            #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u00A9", ["\u11A8\u0308", '\u00A9']                                                                                                                                                                #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u11A8 ", ['\u11A8', ' ']                                                                                                                                                                                      #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308 ", ["\u11A8\u0308", ' ']                                                                                                                                                                          #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0378", ['\u11A8', '\u0378']                                                                                                                                                                            #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u0378", ["\u11A8\u0308", '\u0378']                                                                                                                                                                #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\uAC00\r", ['\uAC00', '\r']                                                                                                                                                                                    #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\r", ["\uAC00\u0308", '\r']                                                                                                                                                                        #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\uAC00\n", ['\uAC00', '\n']                                                                                                                                                                                    #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\n", ["\uAC00\u0308", '\n']                                                                                                                                                                        #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0000", ['\uAC00', '\0']                                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u0000", ["\uAC00\u0308", '\0']                                                                                                                                                                    #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u094D", ["\uAC00\u094D"]                                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u094D", ["\uAC00\u0308\u094D"]                                                                                                                                                                    #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0300", ["\uAC00\u0300"]                                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u0300", ["\uAC00\u0308\u0300"]                                                                                                                                                                    #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u200C", ["\uAC00\u200C"]                                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u200C", ["\uAC00\u0308\u200C"]                                                                                                                                                                    #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u200D", ["\uAC00\u200D"]                                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u200D", ["\uAC00\u0308\u200D"]                                                                                                                                                                    #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u{1F1E6}", ['\uAC00', '\u{1F1E6}']                                                                                                                                                                      #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u{1F1E6}", ["\uAC00\u0308", '\u{1F1E6}']                                                                                                                                                          #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u06DD", ['\uAC00', '\u06DD']                                                                                                                                                                            #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u06DD", ["\uAC00\u0308", '\u06DD']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0903", ["\uAC00\u0903"]                                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u0903", ["\uAC00\u0308\u0903"]                                                                                                                                                                    #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u1100", ['\uAC00', '\u1100']                                                                                                                                                                            #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u1100", ["\uAC00\u0308", '\u1100']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u1160", ["\uAC00\u1160"]                                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [7.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u1160", ["\uAC00\u0308", '\u1160']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u11A8", ["\uAC00\u11A8"]                                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [7.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u11A8", ["\uAC00\u0308", '\u11A8']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\uAC00\uAC00", ['\uAC00', '\uAC00']                                                                                                                                                                            #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\uAC00", ["\uAC00\u0308", '\uAC00']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\uAC00\uAC01", ['\uAC00', '\uAC01']                                                                                                                                                                            #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\uAC01", ["\uAC00\u0308", '\uAC01']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0915", ['\uAC00', '\u0915']                                                                                                                                                                            #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u0915", ["\uAC00\u0308", '\u0915']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u00A9", ['\uAC00', '\u00A9']                                                                                                                                                                            #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u00A9", ["\uAC00\u0308", '\u00A9']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\uAC00 ", ['\uAC00', ' ']                                                                                                                                                                                      #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308 ", ["\uAC00\u0308", ' ']                                                                                                                                                                          #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0378", ['\uAC00', '\u0378']                                                                                                                                                                            #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u0378", ["\uAC00\u0308", '\u0378']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\uAC01\r", ['\uAC01', '\r']                                                                                                                                                                                    #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\r", ["\uAC01\u0308", '\r']                                                                                                                                                                        #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\uAC01\n", ['\uAC01', '\n']                                                                                                                                                                                    #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\n", ["\uAC01\u0308", '\n']                                                                                                                                                                        #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0000", ['\uAC01', '\0']                                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u0000", ["\uAC01\u0308", '\0']                                                                                                                                                                    #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u094D", ["\uAC01\u094D"]                                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u094D", ["\uAC01\u0308\u094D"]                                                                                                                                                                    #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0300", ["\uAC01\u0300"]                                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u0300", ["\uAC01\u0308\u0300"]                                                                                                                                                                    #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u200C", ["\uAC01\u200C"]                                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u200C", ["\uAC01\u0308\u200C"]                                                                                                                                                                    #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u200D", ["\uAC01\u200D"]                                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u200D", ["\uAC01\u0308\u200D"]                                                                                                                                                                    #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u{1F1E6}", ['\uAC01', '\u{1F1E6}']                                                                                                                                                                      #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u{1F1E6}", ["\uAC01\u0308", '\u{1F1E6}']                                                                                                                                                          #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u06DD", ['\uAC01', '\u06DD']                                                                                                                                                                            #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u06DD", ["\uAC01\u0308", '\u06DD']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0903", ["\uAC01\u0903"]                                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u0903", ["\uAC01\u0308\u0903"]                                                                                                                                                                    #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u1100", ['\uAC01', '\u1100']                                                                                                                                                                            #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u1100", ["\uAC01\u0308", '\u1100']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u1160", ['\uAC01', '\u1160']                                                                                                                                                                            #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u1160", ["\uAC01\u0308", '\u1160']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u11A8", ["\uAC01\u11A8"]                                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [8.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u11A8", ["\uAC01\u0308", '\u11A8']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\uAC01\uAC00", ['\uAC01', '\uAC00']                                                                                                                                                                            #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\uAC00", ["\uAC01\u0308", '\uAC00']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\uAC01\uAC01", ['\uAC01', '\uAC01']                                                                                                                                                                            #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\uAC01", ["\uAC01\u0308", '\uAC01']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0915", ['\uAC01', '\u0915']                                                                                                                                                                            #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u0915", ["\uAC01\u0308", '\u0915']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u00A9", ['\uAC01', '\u00A9']                                                                                                                                                                            #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u00A9", ["\uAC01\u0308", '\u00A9']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\uAC01 ", ['\uAC01', ' ']                                                                                                                                                                                      #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308 ", ["\uAC01\u0308", ' ']                                                                                                                                                                          #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0378", ['\uAC01', '\u0378']                                                                                                                                                                            #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u0378", ["\uAC01\u0308", '\u0378']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0915\r", ['\u0915', '\r']                                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0308\r", ["\u0915\u0308", '\r']                                                                                                                                                                        #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u0915\n", ['\u0915', '\n']                                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0308\n", ["\u0915\u0308", '\n']                                                                                                                                                                        #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0000", ['\u0915', '\0']                                                                                                                                                                                #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0308\u0000", ["\u0915\u0308", '\0']                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0915\u094D", ["\u0915\u094D"]                                                                                                                                                                                #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0308\u094D", ["\u0915\u0308\u094D"]                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0300", ["\u0915\u0300"]                                                                                                                                                                                #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0308\u0300", ["\u0915\u0308\u0300"]                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0915\u200C", ["\u0915\u200C"]                                                                                                                                                                                #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0308\u200C", ["\u0915\u0308\u200C"]                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u0915\u200D", ["\u0915\u200D"]                                                                                                                                                                                #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0308\u200D", ["\u0915\u0308\u200D"]                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u0915\u{1F1E6}", ['\u0915', '\u{1F1E6}']                                                                                                                                                                      #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0308\u{1F1E6}", ["\u0915\u0308", '\u{1F1E6}']                                                                                                                                                          #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0915\u06DD", ['\u0915', '\u06DD']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0308\u06DD", ["\u0915\u0308", '\u06DD']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0903", ["\u0915\u0903"]                                                                                                                                                                                #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0308\u0903", ["\u0915\u0308\u0903"]                                                                                                                                                                    #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0915\u1100", ['\u0915', '\u1100']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0308\u1100", ["\u0915\u0308", '\u1100']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0915\u1160", ['\u0915', '\u1160']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0308\u1160", ["\u0915\u0308", '\u1160']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0915\u11A8", ['\u0915', '\u11A8']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0308\u11A8", ["\u0915\u0308", '\u11A8']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0915\uAC00", ['\u0915', '\uAC00']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0308\uAC00", ["\u0915\u0308", '\uAC00']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0915\uAC01", ['\u0915', '\uAC01']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0308\uAC01", ["\u0915\u0308", '\uAC01']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0915", ['\u0915', '\u0915']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0308\u0915", ["\u0915\u0308", '\u0915']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u0915\u00A9", ['\u0915', '\u00A9']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0308\u00A9", ["\u0915\u0308", '\u00A9']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0915 ", ['\u0915', ' ']                                                                                                                                                                                      #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0308 ", ["\u0915\u0308", ' ']                                                                                                                                                                          #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0378", ['\u0915', '\u0378']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0308\u0378", ["\u0915\u0308", '\u0378']                                                                                                                                                                #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u00A9\r", ['\u00A9', '\r']                                                                                                                                                                                    #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0308\r", ["\u00A9\u0308", '\r']                                                                                                                                                                        #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u00A9\n", ['\u00A9', '\n']                                                                                                                                                                                    #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0308\n", ["\u00A9\u0308", '\n']                                                                                                                                                                        #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0000", ['\u00A9', '\0']                                                                                                                                                                                #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0308\u0000", ["\u00A9\u0308", '\0']                                                                                                                                                                    #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u094D", ["\u00A9\u094D"]                                                                                                                                                                                #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0308\u094D", ["\u00A9\u0308\u094D"]                                                                                                                                                                    #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0300", ["\u00A9\u0300"]                                                                                                                                                                                #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0308\u0300", ["\u00A9\u0308\u0300"]                                                                                                                                                                    #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u200C", ["\u00A9\u200C"]                                                                                                                                                                                #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0308\u200C", ["\u00A9\u0308\u200C"]                                                                                                                                                                    #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u200D", ["\u00A9\u200D"]                                                                                                                                                                                #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0308\u200D", ["\u00A9\u0308\u200D"]                                                                                                                                                                    #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u{1F1E6}", ['\u00A9', '\u{1F1E6}']                                                                                                                                                                      #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0308\u{1F1E6}", ["\u00A9\u0308", '\u{1F1E6}']                                                                                                                                                          #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u06DD", ['\u00A9', '\u06DD']                                                                                                                                                                            #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0308\u06DD", ["\u00A9\u0308", '\u06DD']                                                                                                                                                                #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0903", ["\u00A9\u0903"]                                                                                                                                                                                #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0308\u0903", ["\u00A9\u0308\u0903"]                                                                                                                                                                    #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u1100", ['\u00A9', '\u1100']                                                                                                                                                                            #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0308\u1100", ["\u00A9\u0308", '\u1100']                                                                                                                                                                #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u1160", ['\u00A9', '\u1160']                                                                                                                                                                            #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0308\u1160", ["\u00A9\u0308", '\u1160']                                                                                                                                                                #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u11A8", ['\u00A9', '\u11A8']                                                                                                                                                                            #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0308\u11A8", ["\u00A9\u0308", '\u11A8']                                                                                                                                                                #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u00A9\uAC00", ['\u00A9', '\uAC00']                                                                                                                                                                            #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0308\uAC00", ["\u00A9\u0308", '\uAC00']                                                                                                                                                                #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u00A9\uAC01", ['\u00A9', '\uAC01']                                                                                                                                                                            #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0308\uAC01", ["\u00A9\u0308", '\uAC01']                                                                                                                                                                #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0915", ['\u00A9', '\u0915']                                                                                                                                                                            #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0308\u0915", ["\u00A9\u0308", '\u0915']                                                                                                                                                                #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u00A9", ['\u00A9', '\u00A9']                                                                                                                                                                            #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0308\u00A9", ["\u00A9\u0308", '\u00A9']                                                                                                                                                                #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u00A9 ", ['\u00A9', ' ']                                                                                                                                                                                      #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0308 ", ["\u00A9\u0308", ' ']                                                                                                                                                                          #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0378", ['\u00A9', '\u0378']                                                                                                                                                                            #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u00A9\u0308\u0378", ["\u00A9\u0308", '\u0378']                                                                                                                                                                #   ÷ [0.2] COPYRIGHT SIGN (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes " \r", [' ', '\r']                                                                                                                                                                                              #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes " \u0308\r", [" \u0308", '\r']                                                                                                                                                                                  #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes " \n", [' ', '\n']                                                                                                                                                                                              #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes " \u0308\n", [" \u0308", '\n']                                                                                                                                                                                  #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes " \u0000", [' ', '\0']                                                                                                                                                                                          #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes " \u0308\u0000", [" \u0308", '\0']                                                                                                                                                                              #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes " \u094D", [" \u094D"]                                                                                                                                                                                          #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes " \u0308\u094D", [" \u0308\u094D"]                                                                                                                                                                              #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes " \u0300", [" \u0300"]                                                                                                                                                                                          #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes " \u0308\u0300", [" \u0308\u0300"]                                                                                                                                                                              #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes " \u200C", [" \u200C"]                                                                                                                                                                                          #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes " \u0308\u200C", [" \u0308\u200C"]                                                                                                                                                                              #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes " \u200D", [" \u200D"]                                                                                                                                                                                          #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes " \u0308\u200D", [" \u0308\u200D"]                                                                                                                                                                              #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes " \u{1F1E6}", [' ', '\u{1F1E6}']                                                                                                                                                                                #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes " \u0308\u{1F1E6}", [" \u0308", '\u{1F1E6}']                                                                                                                                                                    #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes " \u06DD", [' ', '\u06DD']                                                                                                                                                                                      #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes " \u0308\u06DD", [" \u0308", '\u06DD']                                                                                                                                                                          #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes " \u0903", [" \u0903"]                                                                                                                                                                                          #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes " \u0308\u0903", [" \u0308\u0903"]                                                                                                                                                                              #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes " \u1100", [' ', '\u1100']                                                                                                                                                                                      #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes " \u0308\u1100", [" \u0308", '\u1100']                                                                                                                                                                          #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes " \u1160", [' ', '\u1160']                                                                                                                                                                                      #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes " \u0308\u1160", [" \u0308", '\u1160']                                                                                                                                                                          #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes " \u11A8", [' ', '\u11A8']                                                                                                                                                                                      #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes " \u0308\u11A8", [" \u0308", '\u11A8']                                                                                                                                                                          #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes " \uAC00", [' ', '\uAC00']                                                                                                                                                                                      #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes " \u0308\uAC00", [" \u0308", '\uAC00']                                                                                                                                                                          #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes " \uAC01", [' ', '\uAC01']                                                                                                                                                                                      #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes " \u0308\uAC01", [" \u0308", '\uAC01']                                                                                                                                                                          #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes " \u0915", [' ', '\u0915']                                                                                                                                                                                      #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes " \u0308\u0915", [" \u0308", '\u0915']                                                                                                                                                                          #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes " \u00A9", [' ', '\u00A9']                                                                                                                                                                                      #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes " \u0308\u00A9", [" \u0308", '\u00A9']                                                                                                                                                                          #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "  ", [' ', ' ']                                                                                                                                                                                                #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes " \u0308 ", [" \u0308", ' ']                                                                                                                                                                                    #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes " \u0378", [' ', '\u0378']                                                                                                                                                                                      #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes " \u0308\u0378", [" \u0308", '\u0378']                                                                                                                                                                          #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0378\r", ['\u0378', '\r']                                                                                                                                                                                    #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\r", ["\u0378\u0308", '\r']                                                                                                                                                                        #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
  it_iterates_graphemes "\u0378\n", ['\u0378', '\n']                                                                                                                                                                                    #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\n", ["\u0378\u0308", '\n']                                                                                                                                                                        #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0000", ['\u0378', '\0']                                                                                                                                                                                #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u0000", ["\u0378\u0308", '\0']                                                                                                                                                                    #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [5.0] <NULL> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0378\u094D", ["\u0378\u094D"]                                                                                                                                                                                #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u094D", ["\u0378\u0308\u094D"]                                                                                                                                                                    #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0300", ["\u0378\u0300"]                                                                                                                                                                                #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u0300", ["\u0378\u0308\u0300"]                                                                                                                                                                    #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING GRAVE ACCENT (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u0378\u200C", ["\u0378\u200C"]                                                                                                                                                                                #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u200C", ["\u0378\u0308\u200C"]                                                                                                                                                                    #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH NON-JOINER (ExtendmConjunctLinkermConjunctExtender) ÷ [0.3]
  it_iterates_graphemes "\u0378\u200D", ["\u0378\u200D"]                                                                                                                                                                                #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u200D", ["\u0378\u0308\u200D"]                                                                                                                                                                    #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "\u0378\u{1F1E6}", ['\u0378', '\u{1F1E6}']                                                                                                                                                                      #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u{1F1E6}", ["\u0378\u0308", '\u{1F1E6}']                                                                                                                                                          #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0378\u06DD", ['\u0378', '\u06DD']                                                                                                                                                                            #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u06DD", ["\u0378\u0308", '\u06DD']                                                                                                                                                                #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] ARABIC END OF AYAH (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0903", ["\u0378\u0903"]                                                                                                                                                                                #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u0903", ["\u0378\u0308\u0903"]                                                                                                                                                                    #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0378\u1100", ['\u0378', '\u1100']                                                                                                                                                                            #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u1100", ["\u0378\u0308", '\u1100']                                                                                                                                                                #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0378\u1160", ['\u0378', '\u1160']                                                                                                                                                                            #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u1160", ["\u0378\u0308", '\u1160']                                                                                                                                                                #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0378\u11A8", ['\u0378', '\u11A8']                                                                                                                                                                            #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u11A8", ["\u0378\u0308", '\u11A8']                                                                                                                                                                #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0378\uAC00", ['\u0378', '\uAC00']                                                                                                                                                                            #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\uAC00", ["\u0378\u0308", '\uAC00']                                                                                                                                                                #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0378\uAC01", ['\u0378', '\uAC01']                                                                                                                                                                            #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\uAC01", ["\u0378\u0308", '\uAC01']                                                                                                                                                                #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0915", ['\u0378', '\u0915']                                                                                                                                                                            #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u0915", ["\u0378\u0308", '\u0915']                                                                                                                                                                #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u0378\u00A9", ['\u0378', '\u00A9']                                                                                                                                                                            #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u00A9", ["\u0378\u0308", '\u00A9']                                                                                                                                                                #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] COPYRIGHT SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0378 ", ['\u0378', ' ']                                                                                                                                                                                      #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308 ", ["\u0378\u0308", ' ']                                                                                                                                                                          #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0378", ['\u0378', '\u0378']                                                                                                                                                                            #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u0378", ["\u0378\u0308", '\u0378']                                                                                                                                                                #   ÷ [0.2] <reserved-0378> (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] <reserved-0378> (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\r\na\n\u0308", ["\r\n", 'a', '\n', '\u0308']                                                                                                                                                                  #   ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "a\u0308", ["a\u0308"]                                                                                                                                                                                          #   ÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes " \u200D\u0646", [" \u200D", '\u0646']                                                                                                                                                                          #   ÷ [0.2] SPACE (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] ARABIC LETTER NOON (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0646\u200D ", ["\u0646\u200D", ' ']                                                                                                                                                                          #   ÷ [0.2] ARABIC LETTER NOON (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] SPACE (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u1100\u1100", ["\u1100\u1100"]                                                                                                                                                                                #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u11A8\u1100", ["\uAC00\u11A8", '\u1100']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [7.0] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u11A8\u1100", ["\uAC01\u11A8", '\u1100']                                                                                                                                                                #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [8.0] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u{1F1E7}\u{1F1E8}b", ["\u{1F1E6}\u{1F1E7}", '\u{1F1E8}', 'b']                                                                                                                                        #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [12.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "a\u{1F1E6}\u{1F1E7}\u{1F1E8}b", ['a', "\u{1F1E6}\u{1F1E7}", '\u{1F1E8}', 'b']                                                                                                                                  #   ÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "a\u{1F1E6}\u{1F1E7}\u200D\u{1F1E8}b", ['a', "\u{1F1E6}\u{1F1E7}\u200D", '\u{1F1E8}', 'b']                                                                                                                      #   ÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "a\u{1F1E6}\u200D\u{1F1E7}\u{1F1E8}b", ['a', "\u{1F1E6}\u200D", "\u{1F1E7}\u{1F1E8}", 'b']                                                                                                                      #   ÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "a\u{1F1E6}\u{1F1E7}\u{1F1E8}\u{1F1E9}b", ['a', "\u{1F1E6}\u{1F1E7}", "\u{1F1E8}\u{1F1E9}", 'b']                                                                                                                #   ÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER D (RI) ÷ [999.0] LATIN SMALL LETTER B (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "a\u200D", ["a\u200D"]                                                                                                                                                                                          #   ÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]
  it_iterates_graphemes "a\u0308b", ["a\u0308", 'b']                                                                                                                                                                                    #   ÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] LATIN SMALL LETTER B (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "a\u0903b", ["a\u0903", 'b']                                                                                                                                                                                    #   ÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] LATIN SMALL LETTER B (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "a\u0600b", ['a', "\u0600b"]                                                                                                                                                                                    #   ÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) × [9.2] LATIN SMALL LETTER B (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u{1F476}\u{1F3FF}\u{1F476}", ["\u{1F476}\u{1F3FF}", '\u{1F476}']                                                                                                                                              #   ÷ [0.2] BABY (ExtPict) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] BABY (ExtPict) ÷ [0.3]
  it_iterates_graphemes "a\u{1F3FF}\u{1F476}", ["a\u{1F3FF}", '\u{1F476}']                                                                                                                                                              #   ÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] BABY (ExtPict) ÷ [0.3]
  it_iterates_graphemes "a\u{1F3FF}\u{1F476}\u200D\u{1F6D1}", ["a\u{1F3FF}", "\u{1F476}\u200D\u{1F6D1}"]                                                                                                                                #   ÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] BABY (ExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) × [11.0] OCTAGONAL SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u{1F476}\u{1F3FF}\u0308\u200D\u{1F476}\u{1F3FF}", ["\u{1F476}\u{1F3FF}\u0308\u200D\u{1F476}\u{1F3FF}"]                                                                                                        #   ÷ [0.2] BABY (ExtPict) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_ConjunctExtendermConjunctLinker) × [9.0] COMBINING DIAERESIS (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) × [11.0] BABY (ExtPict) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  it_iterates_graphemes "\u{1F6D1}\u200D\u{1F6D1}", ["\u{1F6D1}\u200D\u{1F6D1}"]                                                                                                                                                        #   ÷ [0.2] OCTAGONAL SIGN (ExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) × [11.0] OCTAGONAL SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "a\u200D\u{1F6D1}", ["a\u200D", '\u{1F6D1}']                                                                                                                                                                    #   ÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] OCTAGONAL SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u2701\u200D\u2701", ["\u2701\u200D", '\u2701']                                                                                                                                                                #   ÷ [0.2] UPPER BLADE SCISSORS (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] UPPER BLADE SCISSORS (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "a\u200D\u2701", ["a\u200D", '\u2701']                                                                                                                                                                          #   ÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] UPPER BLADE SCISSORS (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0915\u0924", ['\u0915', '\u0924']                                                                                                                                                                            #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) ÷ [999.0] DEVANAGARI LETTER TA (LinkingConsonant) ÷ [0.3]
  pending "GB9c" { it_iterates_graphemes "\u0915\u094D\u0924", ["\u0915\u094D\u0924"] }                                                                                                                                                 #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] DEVANAGARI LETTER TA (LinkingConsonant) ÷ [0.3]
  pending "GB9c" { it_iterates_graphemes "\u0915\u094D\u094D\u0924", ["\u0915\u094D\u094D\u0924"] }                                                                                                                                     #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] DEVANAGARI LETTER TA (LinkingConsonant) ÷ [0.3]
  pending "GB9c" { it_iterates_graphemes "\u0915\u094D\u200D\u0924", ["\u0915\u094D\u200D\u0924"] }                                                                                                                                     #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) × [9.3] DEVANAGARI LETTER TA (LinkingConsonant) ÷ [0.3]
  pending "GB9c" { it_iterates_graphemes "\u0915\u093C\u200D\u094D\u0924", ["\u0915\u093C\u200D\u094D\u0924"] }                                                                                                                         #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] DEVANAGARI SIGN NUKTA (Extend_ConjunctExtendermConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] DEVANAGARI LETTER TA (LinkingConsonant) ÷ [0.3]
  pending "GB9c" { it_iterates_graphemes "\u0915\u093C\u094D\u200D\u0924", ["\u0915\u093C\u094D\u200D\u0924"] }                                                                                                                         #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] DEVANAGARI SIGN NUKTA (Extend_ConjunctExtendermConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] ZERO WIDTH JOINER (ZWJ) × [9.3] DEVANAGARI LETTER TA (LinkingConsonant) ÷ [0.3]
  pending "GB9c" { it_iterates_graphemes "\u0915\u094D\u0924\u094D\u092F", ["\u0915\u094D\u0924\u094D\u092F"] }                                                                                                                         #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] DEVANAGARI LETTER TA (LinkingConsonant) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] DEVANAGARI LETTER YA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "\u0915\u094Da", ["\u0915\u094D", 'a']                                                                                                                                                                          #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) ÷ [0.3]
  it_iterates_graphemes "a\u094D\u0924", ["a\u094D", '\u0924']                                                                                                                                                                          #   ÷ [0.2] LATIN SMALL LETTER A (XXmLinkingConsonantmExtPict) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] DEVANAGARI LETTER TA (LinkingConsonant) ÷ [0.3]
  it_iterates_graphemes "?\u094D\u0924", ["?\u094D", '\u0924']                                                                                                                                                                          #   ÷ [0.2] QUESTION MARK (XXmLinkingConsonantmExtPict) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) ÷ [999.0] DEVANAGARI LETTER TA (LinkingConsonant) ÷ [0.3]
  pending "GB9c" { it_iterates_graphemes "\u0915\u094D\u094D\u0924", ["\u0915\u094D\u094D\u0924"] }                                                                                                                                     #   ÷ [0.2] DEVANAGARI LETTER KA (LinkingConsonant) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.0] DEVANAGARI SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] DEVANAGARI LETTER TA (LinkingConsonant) ÷ [0.3]
  pending "GB9c" { it_iterates_graphemes "\u0AB8\u0AFB\u0ACD\u0AB8\u0AFB", ["\u0AB8\u0AFB\u0ACD\u0AB8\u0AFB"] }                                                                                                                         #   ÷ [0.2] GUJARATI LETTER SA (LinkingConsonant) × [9.0] GUJARATI SIGN SHADDA (Extend_ConjunctExtendermConjunctLinker) × [9.0] GUJARATI SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] GUJARATI LETTER SA (LinkingConsonant) × [9.0] GUJARATI SIGN SHADDA (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  pending "GB9c" { it_iterates_graphemes "\u1019\u1039\u1018\u102C\u1037", ["\u1019\u1039\u1018", "\u102C\u1037"] }                                                                                                                     #   ÷ [0.2] MYANMAR LETTER MA (LinkingConsonant) × [9.0] MYANMAR SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] MYANMAR LETTER BHA (LinkingConsonant) ÷ [999.0] MYANMAR VOWEL SIGN AA (XXmLinkingConsonantmExtPict) × [9.0] MYANMAR SIGN DOT BELOW (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  pending "GB9c" { it_iterates_graphemes "\u1004\u103A\u1039\u1011\u1039\u1011", ["\u1004\u103A\u1039\u1011\u1039\u1011"] }                                                                                                             #   ÷ [0.2] MYANMAR LETTER NGA (LinkingConsonant) × [9.0] MYANMAR SIGN ASAT (Extend_ConjunctExtendermConjunctLinker) × [9.0] MYANMAR SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] MYANMAR LETTER THA (LinkingConsonant) × [9.0] MYANMAR SIGN VIRAMA (Extend_ConjunctLinker) × [9.3] MYANMAR LETTER THA (LinkingConsonant) ÷ [0.3]
  pending "GB9c" { it_iterates_graphemes "\u1B12\u1B01\u1B32\u1B44\u1B2F\u1B32\u1B44\u1B22\u1B44\u1B2C\u1B32\u1B44\u1B22\u1B38", ["\u1B12\u1B01", "\u1B32\u1B44\u1B2F", "\u1B32\u1B44\u1B22\u1B44\u1B2C", "\u1B32\u1B44\u1B22\u1B38"] } #   ÷ [0.2] BALINESE LETTER OKARA TEDUNG (XXmLinkingConsonantmExtPict) × [9.0] BALINESE SIGN ULU CANDRA (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] BALINESE LETTER SA (LinkingConsonant) × [9.0] BALINESE ADEG ADEG (Extend_ConjunctLinker) × [9.3] BALINESE LETTER WA (LinkingConsonant) ÷ [999.0] BALINESE LETTER SA (LinkingConsonant) × [9.0] BALINESE ADEG ADEG (Extend_ConjunctLinker) × [9.3] BALINESE LETTER TA (LinkingConsonant) × [9.0] BALINESE ADEG ADEG (Extend_ConjunctLinker) × [9.3] BALINESE LETTER YA (LinkingConsonant) ÷ [999.0] BALINESE LETTER SA (LinkingConsonant) × [9.0] BALINESE ADEG ADEG (Extend_ConjunctLinker) × [9.3] BALINESE LETTER TA (LinkingConsonant) × [9.0] BALINESE VOWEL SIGN SUKU (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  pending "GB9c" { it_iterates_graphemes "\u179F\u17D2\u178F\u17D2\u179A\u17B8", ["\u179F\u17D2\u178F\u17D2\u179A\u17B8"] }                                                                                                             #   ÷ [0.2] KHMER LETTER SA (LinkingConsonant) × [9.0] KHMER SIGN COENG (Extend_ConjunctLinker) × [9.3] KHMER LETTER TA (LinkingConsonant) × [9.0] KHMER SIGN COENG (Extend_ConjunctLinker) × [9.3] KHMER LETTER RO (LinkingConsonant) × [9.0] KHMER VOWEL SIGN II (Extend_ConjunctExtendermConjunctLinker) ÷ [0.3]
  pending "GB9c" { it_iterates_graphemes "\u1B26\u1B17\u1B44\u1B13", ['\u1B26', "\u1B17\u1B44\u1B13"] }                                                                                                                                 #   ÷ [0.2] BALINESE LETTER NA (LinkingConsonant) ÷ [999.0] BALINESE LETTER NGA (LinkingConsonant) × [9.0] BALINESE ADEG ADEG (Extend_ConjunctLinker) × [9.3] BALINESE LETTER KA (LinkingConsonant) ÷ [0.3]
  pending "GB9c" { it_iterates_graphemes "\u1B27\u1B13\u1B44\u1B0B\u1B0B\u1B04", ['\u1B27', "\u1B13\u1B44\u1B0B", "\u1B0B\u1B04"] }                                                                                                     #   ÷ [0.2] BALINESE LETTER PA (LinkingConsonant) ÷ [999.0] BALINESE LETTER KA (LinkingConsonant) × [9.0] BALINESE ADEG ADEG (Extend_ConjunctLinker) × [9.3] BALINESE LETTER RA REPA (LinkingConsonant) ÷ [999.0] BALINESE LETTER RA REPA (LinkingConsonant) × [9.1] BALINESE SIGN BISAH (SpacingMark) ÷ [0.3]
  pending "GB9c" { it_iterates_graphemes "\u1795\u17D2\u17AF\u1798", ["\u1795\u17D2\u17AF", '\u1798'] }                                                                                                                                 #   ÷ [0.2] KHMER LETTER PHA (LinkingConsonant) × [9.0] KHMER SIGN COENG (Extend_ConjunctLinker) × [9.3] KHMER INDEPENDENT VOWEL QE (LinkingConsonant) ÷ [999.0] KHMER LETTER MO (LinkingConsonant) ÷ [0.3]
  pending "GB9c" { it_iterates_graphemes "\u17A0\u17D2\u17AB\u1791\u17D0\u1799", ["\u17A0\u17D2\u17AB", "\u1791\u17D0", '\u1799'] }                                                                                                     #   ÷ [0.2] KHMER LETTER HA (LinkingConsonant) × [9.0] KHMER SIGN COENG (Extend_ConjunctLinker) × [9.3] KHMER INDEPENDENT VOWEL RY (LinkingConsonant) ÷ [999.0] KHMER LETTER TO (LinkingConsonant) × [9.0] KHMER SIGN SAMYOK SANNYA (Extend_ConjunctExtendermConjunctLinker) ÷ [999.0] KHMER LETTER YO (LinkingConsonant) ÷ [0.3]
end
