package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePdnsOperateLogs invokes the alidns.DescribePdnsOperateLogs API synchronously
func (client *Client) DescribePdnsOperateLogs(request *DescribePdnsOperateLogsRequest) (response *DescribePdnsOperateLogsResponse, err error) {
	response = CreateDescribePdnsOperateLogsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePdnsOperateLogsWithChan invokes the alidns.DescribePdnsOperateLogs API asynchronously
func (client *Client) DescribePdnsOperateLogsWithChan(request *DescribePdnsOperateLogsRequest) (<-chan *DescribePdnsOperateLogsResponse, <-chan error) {
	responseChan := make(chan *DescribePdnsOperateLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePdnsOperateLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePdnsOperateLogsWithCallback invokes the alidns.DescribePdnsOperateLogs API asynchronously
func (client *Client) DescribePdnsOperateLogsWithCallback(request *DescribePdnsOperateLogsRequest, callback func(response *DescribePdnsOperateLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePdnsOperateLogsResponse
		var err error
		defer close(result)
		response, err = client.DescribePdnsOperateLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePdnsOperateLogsRequest is the request struct for api DescribePdnsOperateLogs
type DescribePdnsOperateLogsRequest struct {
	*requests.RpcRequest
	ActionType string           `position:"Query" name:"ActionType"`
	StartDate  string           `position:"Query" name:"StartDate"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	EndDate    string           `position:"Query" name:"EndDate"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	Lang       string           `position:"Query" name:"Lang"`
	Keyword    string           `position:"Query" name:"Keyword"`
}

// DescribePdnsOperateLogsResponse is the response struct for api DescribePdnsOperateLogs
type DescribePdnsOperateLogsResponse struct {
	*responses.BaseResponse
	TotalCount int64  `json:"TotalCount" xml:"TotalCount"`
	PageSize   int64  `json:"PageSize" xml:"PageSize"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	PageNumber int64  `json:"PageNumber" xml:"PageNumber"`
	Logs       []Log  `json:"Logs" xml:"Logs"`
}

// CreateDescribePdnsOperateLogsRequest creates a request to invoke DescribePdnsOperateLogs API
func CreateDescribePdnsOperateLogsRequest() (request *DescribePdnsOperateLogsRequest) {
	request = &DescribePdnsOperateLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribePdnsOperateLogs", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePdnsOperateLogsResponse creates a response to parse from DescribePdnsOperateLogs response
func CreateDescribePdnsOperateLogsResponse() (response *DescribePdnsOperateLogsResponse) {
	response = &DescribePdnsOperateLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
