// Code generated by sdkgen. DO NOT EDIT.

// nolint
package broker

import (
	"context"

	"google.golang.org/grpc"

	broker "github.com/yandex-cloud/go-genproto/yandex/cloud/iot/broker/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// BrokerServiceClient is a broker.BrokerServiceClient with
// lazy GRPC connection initialization.
type BrokerServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// AddCertificate implements broker.BrokerServiceClient
func (c *BrokerServiceClient) AddCertificate(ctx context.Context, in *broker.AddBrokerCertificateRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return broker.NewBrokerServiceClient(conn).AddCertificate(ctx, in, opts...)
}

// AddPassword implements broker.BrokerServiceClient
func (c *BrokerServiceClient) AddPassword(ctx context.Context, in *broker.AddBrokerPasswordRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return broker.NewBrokerServiceClient(conn).AddPassword(ctx, in, opts...)
}

// Create implements broker.BrokerServiceClient
func (c *BrokerServiceClient) Create(ctx context.Context, in *broker.CreateBrokerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return broker.NewBrokerServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements broker.BrokerServiceClient
func (c *BrokerServiceClient) Delete(ctx context.Context, in *broker.DeleteBrokerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return broker.NewBrokerServiceClient(conn).Delete(ctx, in, opts...)
}

// DeleteCertificate implements broker.BrokerServiceClient
func (c *BrokerServiceClient) DeleteCertificate(ctx context.Context, in *broker.DeleteBrokerCertificateRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return broker.NewBrokerServiceClient(conn).DeleteCertificate(ctx, in, opts...)
}

// DeletePassword implements broker.BrokerServiceClient
func (c *BrokerServiceClient) DeletePassword(ctx context.Context, in *broker.DeleteBrokerPasswordRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return broker.NewBrokerServiceClient(conn).DeletePassword(ctx, in, opts...)
}

// Get implements broker.BrokerServiceClient
func (c *BrokerServiceClient) Get(ctx context.Context, in *broker.GetBrokerRequest, opts ...grpc.CallOption) (*broker.Broker, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return broker.NewBrokerServiceClient(conn).Get(ctx, in, opts...)
}

// List implements broker.BrokerServiceClient
func (c *BrokerServiceClient) List(ctx context.Context, in *broker.ListBrokersRequest, opts ...grpc.CallOption) (*broker.ListBrokersResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return broker.NewBrokerServiceClient(conn).List(ctx, in, opts...)
}

type BrokerIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *BrokerServiceClient
	request *broker.ListBrokersRequest

	items []*broker.Broker
}

func (c *BrokerServiceClient) BrokerIterator(ctx context.Context, req *broker.ListBrokersRequest, opts ...grpc.CallOption) *BrokerIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &BrokerIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *BrokerIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Brokers
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *BrokerIterator) Take(size int64) ([]*broker.Broker, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*broker.Broker

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *BrokerIterator) TakeAll() ([]*broker.Broker, error) {
	return it.Take(0)
}

func (it *BrokerIterator) Value() *broker.Broker {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *BrokerIterator) Error() error {
	return it.err
}

// ListCertificates implements broker.BrokerServiceClient
func (c *BrokerServiceClient) ListCertificates(ctx context.Context, in *broker.ListBrokerCertificatesRequest, opts ...grpc.CallOption) (*broker.ListBrokerCertificatesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return broker.NewBrokerServiceClient(conn).ListCertificates(ctx, in, opts...)
}

type BrokerCertificatesIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *BrokerServiceClient
	request *broker.ListBrokerCertificatesRequest

	items []*broker.BrokerCertificate
}

func (c *BrokerServiceClient) BrokerCertificatesIterator(ctx context.Context, req *broker.ListBrokerCertificatesRequest, opts ...grpc.CallOption) *BrokerCertificatesIterator {
	var pageSize int64
	const defaultPageSize = 1000

	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &BrokerCertificatesIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *BrokerCertificatesIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started {
		return false
	}
	it.started = true

	response, err := it.client.ListCertificates(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Certificates
	return len(it.items) > 0
}

func (it *BrokerCertificatesIterator) Take(size int64) ([]*broker.BrokerCertificate, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*broker.BrokerCertificate

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *BrokerCertificatesIterator) TakeAll() ([]*broker.BrokerCertificate, error) {
	return it.Take(0)
}

func (it *BrokerCertificatesIterator) Value() *broker.BrokerCertificate {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *BrokerCertificatesIterator) Error() error {
	return it.err
}

// ListOperations implements broker.BrokerServiceClient
func (c *BrokerServiceClient) ListOperations(ctx context.Context, in *broker.ListBrokerOperationsRequest, opts ...grpc.CallOption) (*broker.ListBrokerOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return broker.NewBrokerServiceClient(conn).ListOperations(ctx, in, opts...)
}

type BrokerOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *BrokerServiceClient
	request *broker.ListBrokerOperationsRequest

	items []*operation.Operation
}

func (c *BrokerServiceClient) BrokerOperationsIterator(ctx context.Context, req *broker.ListBrokerOperationsRequest, opts ...grpc.CallOption) *BrokerOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &BrokerOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *BrokerOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *BrokerOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *BrokerOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *BrokerOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *BrokerOperationsIterator) Error() error {
	return it.err
}

// ListPasswords implements broker.BrokerServiceClient
func (c *BrokerServiceClient) ListPasswords(ctx context.Context, in *broker.ListBrokerPasswordsRequest, opts ...grpc.CallOption) (*broker.ListBrokerPasswordsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return broker.NewBrokerServiceClient(conn).ListPasswords(ctx, in, opts...)
}

type BrokerPasswordsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *BrokerServiceClient
	request *broker.ListBrokerPasswordsRequest

	items []*broker.BrokerPassword
}

func (c *BrokerServiceClient) BrokerPasswordsIterator(ctx context.Context, req *broker.ListBrokerPasswordsRequest, opts ...grpc.CallOption) *BrokerPasswordsIterator {
	var pageSize int64
	const defaultPageSize = 1000

	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &BrokerPasswordsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *BrokerPasswordsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started {
		return false
	}
	it.started = true

	response, err := it.client.ListPasswords(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Passwords
	return len(it.items) > 0
}

func (it *BrokerPasswordsIterator) Take(size int64) ([]*broker.BrokerPassword, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*broker.BrokerPassword

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *BrokerPasswordsIterator) TakeAll() ([]*broker.BrokerPassword, error) {
	return it.Take(0)
}

func (it *BrokerPasswordsIterator) Value() *broker.BrokerPassword {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *BrokerPasswordsIterator) Error() error {
	return it.err
}

// Update implements broker.BrokerServiceClient
func (c *BrokerServiceClient) Update(ctx context.Context, in *broker.UpdateBrokerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return broker.NewBrokerServiceClient(conn).Update(ctx, in, opts...)
}
