#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1722
#define LARGE_STATE_COUNT 326
#define SYMBOL_COUNT 259
#define ALIAS_COUNT 4
#define TOKEN_COUNT 133
#define EXTERNAL_TOKEN_COUNT 8
#define FIELD_COUNT 36
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 111

enum ts_symbol_identifiers {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_as = 6,
  anon_sym_LBRACE = 7,
  anon_sym_COMMA = 8,
  anon_sym_RBRACE = 9,
  anon_sym_import = 10,
  anon_sym_from = 11,
  anon_sym_with = 12,
  anon_sym_var = 13,
  anon_sym_let = 14,
  anon_sym_const = 15,
  anon_sym_else = 16,
  anon_sym_if = 17,
  anon_sym_switch = 18,
  anon_sym_for = 19,
  anon_sym_LPAREN = 20,
  anon_sym_SEMI = 21,
  anon_sym_RPAREN = 22,
  anon_sym_await = 23,
  anon_sym_in = 24,
  anon_sym_of = 25,
  anon_sym_while = 26,
  anon_sym_do = 27,
  anon_sym_try = 28,
  anon_sym_break = 29,
  anon_sym_continue = 30,
  anon_sym_debugger = 31,
  anon_sym_return = 32,
  anon_sym_throw = 33,
  anon_sym_COLON = 34,
  anon_sym_case = 35,
  anon_sym_catch = 36,
  anon_sym_finally = 37,
  anon_sym_yield = 38,
  anon_sym_EQ = 39,
  anon_sym_LBRACK = 40,
  anon_sym_RBRACK = 41,
  sym_html_character_reference = 42,
  anon_sym_LT = 43,
  anon_sym_GT = 44,
  sym_jsx_identifier = 45,
  anon_sym_DOT = 46,
  anon_sym_LT_SLASH = 47,
  anon_sym_SLASH_GT = 48,
  anon_sym_DQUOTE = 49,
  anon_sym_SQUOTE = 50,
  sym_unescaped_double_jsx_string_fragment = 51,
  sym_unescaped_single_jsx_string_fragment = 52,
  anon_sym_class = 53,
  anon_sym_extends = 54,
  anon_sym_async = 55,
  anon_sym_function = 56,
  anon_sym_EQ_GT = 57,
  sym_optional_chain = 58,
  anon_sym_new = 59,
  anon_sym_PLUS_EQ = 60,
  anon_sym_DASH_EQ = 61,
  anon_sym_STAR_EQ = 62,
  anon_sym_SLASH_EQ = 63,
  anon_sym_PERCENT_EQ = 64,
  anon_sym_CARET_EQ = 65,
  anon_sym_AMP_EQ = 66,
  anon_sym_PIPE_EQ = 67,
  anon_sym_GT_GT_EQ = 68,
  anon_sym_GT_GT_GT_EQ = 69,
  anon_sym_LT_LT_EQ = 70,
  anon_sym_STAR_STAR_EQ = 71,
  anon_sym_AMP_AMP_EQ = 72,
  anon_sym_PIPE_PIPE_EQ = 73,
  anon_sym_QMARK_QMARK_EQ = 74,
  anon_sym_DOT_DOT_DOT = 75,
  anon_sym_AMP_AMP = 76,
  anon_sym_PIPE_PIPE = 77,
  anon_sym_GT_GT = 78,
  anon_sym_GT_GT_GT = 79,
  anon_sym_LT_LT = 80,
  anon_sym_AMP = 81,
  anon_sym_CARET = 82,
  anon_sym_PIPE = 83,
  anon_sym_PLUS = 84,
  anon_sym_DASH = 85,
  anon_sym_SLASH = 86,
  anon_sym_PERCENT = 87,
  anon_sym_STAR_STAR = 88,
  anon_sym_LT_EQ = 89,
  anon_sym_EQ_EQ = 90,
  anon_sym_EQ_EQ_EQ = 91,
  anon_sym_BANG_EQ = 92,
  anon_sym_BANG_EQ_EQ = 93,
  anon_sym_GT_EQ = 94,
  anon_sym_QMARK_QMARK = 95,
  anon_sym_instanceof = 96,
  anon_sym_BANG = 97,
  anon_sym_TILDE = 98,
  anon_sym_typeof = 99,
  anon_sym_void = 100,
  anon_sym_delete = 101,
  anon_sym_PLUS_PLUS = 102,
  anon_sym_DASH_DASH = 103,
  sym_unescaped_double_string_fragment = 104,
  sym_unescaped_single_string_fragment = 105,
  sym_escape_sequence = 106,
  sym_comment = 107,
  anon_sym_BQUOTE = 108,
  anon_sym_DOLLAR_LBRACE = 109,
  anon_sym_SLASH2 = 110,
  sym_regex_pattern = 111,
  sym_regex_flags = 112,
  sym_number = 113,
  sym_private_property_identifier = 114,
  anon_sym_target = 115,
  anon_sym_meta = 116,
  sym_this = 117,
  sym_super = 118,
  sym_true = 119,
  sym_false = 120,
  sym_null = 121,
  sym_undefined = 122,
  anon_sym_AT = 123,
  anon_sym_static = 124,
  aux_sym_method_definition_token1 = 125,
  anon_sym_get = 126,
  anon_sym_set = 127,
  sym__automatic_semicolon = 128,
  sym__template_chars = 129,
  sym__ternary_qmark = 130,
  sym_html_comment = 131,
  sym_jsx_text = 132,
  sym_program = 133,
  sym_export_statement = 134,
  sym_namespace_export = 135,
  sym_export_clause = 136,
  sym_export_specifier = 137,
  sym__module_export_name = 138,
  sym_declaration = 139,
  sym_import = 140,
  sym_import_statement = 141,
  sym_import_clause = 142,
  sym__from_clause = 143,
  sym_namespace_import = 144,
  sym_named_imports = 145,
  sym_import_specifier = 146,
  sym_import_attribute = 147,
  sym_statement = 148,
  sym_expression_statement = 149,
  sym_variable_declaration = 150,
  sym_lexical_declaration = 151,
  sym_variable_declarator = 152,
  sym_statement_block = 153,
  sym_else_clause = 154,
  sym_if_statement = 155,
  sym_switch_statement = 156,
  sym_for_statement = 157,
  sym_for_in_statement = 158,
  sym__for_header = 159,
  sym_while_statement = 160,
  sym_do_statement = 161,
  sym_try_statement = 162,
  sym_with_statement = 163,
  sym_break_statement = 164,
  sym_continue_statement = 165,
  sym_debugger_statement = 166,
  sym_return_statement = 167,
  sym_throw_statement = 168,
  sym_empty_statement = 169,
  sym_labeled_statement = 170,
  sym_switch_body = 171,
  sym_switch_case = 172,
  sym_switch_default = 173,
  sym_catch_clause = 174,
  sym_finally_clause = 175,
  sym_parenthesized_expression = 176,
  sym_expression = 177,
  sym_primary_expression = 178,
  sym_yield_expression = 179,
  sym_object = 180,
  sym_object_pattern = 181,
  sym_assignment_pattern = 182,
  sym_object_assignment_pattern = 183,
  sym_array = 184,
  sym_array_pattern = 185,
  sym_jsx_element = 186,
  sym_jsx_expression = 187,
  sym_jsx_opening_element = 188,
  sym_nested_identifier = 189,
  sym_jsx_namespace_name = 190,
  sym_jsx_closing_element = 191,
  sym_jsx_self_closing_element = 192,
  sym_jsx_attribute = 193,
  sym__jsx_string = 194,
  sym_class = 195,
  sym_class_declaration = 196,
  sym_class_heritage = 197,
  sym_function_expression = 198,
  sym_function_declaration = 199,
  sym_generator_function = 200,
  sym_generator_function_declaration = 201,
  sym_arrow_function = 202,
  sym_call_expression = 203,
  sym_new_expression = 204,
  sym_await_expression = 205,
  sym_member_expression = 206,
  sym_subscript_expression = 207,
  sym_assignment_expression = 208,
  sym__augmented_assignment_lhs = 209,
  sym_augmented_assignment_expression = 210,
  sym__initializer = 211,
  sym__destructuring_pattern = 212,
  sym_spread_element = 213,
  sym_ternary_expression = 214,
  sym_binary_expression = 215,
  sym_unary_expression = 216,
  sym_update_expression = 217,
  sym_sequence_expression = 218,
  sym_string = 219,
  sym_template_string = 220,
  sym_template_substitution = 221,
  sym_regex = 222,
  sym_meta_property = 223,
  sym_arguments = 224,
  sym_decorator = 225,
  sym_decorator_member_expression = 226,
  sym_decorator_call_expression = 227,
  sym_class_body = 228,
  sym_field_definition = 229,
  sym_formal_parameters = 230,
  sym_class_static_block = 231,
  sym_pattern = 232,
  sym_rest_pattern = 233,
  sym_method_definition = 234,
  sym_pair = 235,
  sym_pair_pattern = 236,
  sym__property_name = 237,
  sym_computed_property_name = 238,
  aux_sym_program_repeat1 = 239,
  aux_sym_export_statement_repeat1 = 240,
  aux_sym_export_clause_repeat1 = 241,
  aux_sym_named_imports_repeat1 = 242,
  aux_sym_variable_declaration_repeat1 = 243,
  aux_sym_switch_body_repeat1 = 244,
  aux_sym_object_repeat1 = 245,
  aux_sym_object_pattern_repeat1 = 246,
  aux_sym_array_repeat1 = 247,
  aux_sym_array_pattern_repeat1 = 248,
  aux_sym_jsx_element_repeat1 = 249,
  aux_sym_jsx_opening_element_repeat1 = 250,
  aux_sym__jsx_string_repeat1 = 251,
  aux_sym__jsx_string_repeat2 = 252,
  aux_sym_sequence_expression_repeat1 = 253,
  aux_sym_string_repeat1 = 254,
  aux_sym_string_repeat2 = 255,
  aux_sym_template_string_repeat1 = 256,
  aux_sym_class_body_repeat1 = 257,
  aux_sym_formal_parameters_repeat1 = 258,
  alias_sym_property_identifier = 259,
  alias_sym_shorthand_property_identifier = 260,
  alias_sym_shorthand_property_identifier_pattern = 261,
  alias_sym_statement_identifier = 262,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_as] = "as",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_with] = "with",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_SEMI] = ";",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_EQ] = "=",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym_html_character_reference] = "html_character_reference",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [sym_jsx_identifier] = "identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_LT_SLASH] = "</",
  [anon_sym_SLASH_GT] = "/>",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym_unescaped_double_jsx_string_fragment] = "string_fragment",
  [sym_unescaped_single_jsx_string_fragment] = "string_fragment",
  [anon_sym_class] = "class",
  [anon_sym_extends] = "extends",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [sym_optional_chain] = "optional_chain",
  [anon_sym_new] = "new",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_typeof] = "typeof",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_unescaped_single_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [sym_private_property_identifier] = "private_property_identifier",
  [anon_sym_target] = "target",
  [anon_sym_meta] = "meta",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [aux_sym_method_definition_token1] = "static get",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "string_fragment",
  [sym__ternary_qmark] = "\?",
  [sym_html_comment] = "html_comment",
  [sym_jsx_text] = "jsx_text",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_namespace_export] = "namespace_export",
  [sym_export_clause] = "export_clause",
  [sym_export_specifier] = "export_specifier",
  [sym__module_export_name] = "_module_export_name",
  [sym_declaration] = "declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_import_specifier] = "import_specifier",
  [sym_import_attribute] = "import_attribute",
  [sym_statement] = "statement",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_object_pattern] = "object_pattern",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_object_assignment_pattern] = "object_assignment_pattern",
  [sym_array] = "array",
  [sym_array_pattern] = "array_pattern",
  [sym_jsx_element] = "jsx_element",
  [sym_jsx_expression] = "jsx_expression",
  [sym_jsx_opening_element] = "jsx_opening_element",
  [sym_nested_identifier] = "member_expression",
  [sym_jsx_namespace_name] = "jsx_namespace_name",
  [sym_jsx_closing_element] = "jsx_closing_element",
  [sym_jsx_self_closing_element] = "jsx_self_closing_element",
  [sym_jsx_attribute] = "jsx_attribute",
  [sym__jsx_string] = "string",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function_expression] = "function_expression",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym__augmented_assignment_lhs] = "_augmented_assignment_lhs",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_field_definition] = "field_definition",
  [sym_formal_parameters] = "formal_parameters",
  [sym_class_static_block] = "class_static_block",
  [sym_pattern] = "pattern",
  [sym_rest_pattern] = "rest_pattern",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym_pair_pattern] = "pair_pattern",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_object_pattern_repeat1] = "object_pattern_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_jsx_element_repeat1] = "jsx_element_repeat1",
  [aux_sym_jsx_opening_element_repeat1] = "jsx_opening_element_repeat1",
  [aux_sym__jsx_string_repeat1] = "_jsx_string_repeat1",
  [aux_sym__jsx_string_repeat2] = "_jsx_string_repeat2",
  [aux_sym_sequence_expression_repeat1] = "sequence_expression_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_shorthand_property_identifier_pattern] = "shorthand_property_identifier_pattern",
  [alias_sym_statement_identifier] = "statement_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym_html_character_reference] = sym_html_character_reference,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [sym_jsx_identifier] = sym_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LT_SLASH] = anon_sym_LT_SLASH,
  [anon_sym_SLASH_GT] = anon_sym_SLASH_GT,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_unescaped_double_jsx_string_fragment] = sym__template_chars,
  [sym_unescaped_single_jsx_string_fragment] = sym__template_chars,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [sym_optional_chain] = sym_optional_chain,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [sym_unescaped_double_string_fragment] = sym__template_chars,
  [sym_unescaped_single_string_fragment] = sym__template_chars,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [sym_private_property_identifier] = sym_private_property_identifier,
  [anon_sym_target] = anon_sym_target,
  [anon_sym_meta] = anon_sym_meta,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [aux_sym_method_definition_token1] = aux_sym_method_definition_token1,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym__ternary_qmark] = sym__ternary_qmark,
  [sym_html_comment] = sym_html_comment,
  [sym_jsx_text] = sym_jsx_text,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_namespace_export] = sym_namespace_export,
  [sym_export_clause] = sym_export_clause,
  [sym_export_specifier] = sym_export_specifier,
  [sym__module_export_name] = sym__module_export_name,
  [sym_declaration] = sym_declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import] = sym_namespace_import,
  [sym_named_imports] = sym_named_imports,
  [sym_import_specifier] = sym_import_specifier,
  [sym_import_attribute] = sym_import_attribute,
  [sym_statement] = sym_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_object_pattern] = sym_object_pattern,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_object_assignment_pattern] = sym_object_assignment_pattern,
  [sym_array] = sym_array,
  [sym_array_pattern] = sym_array_pattern,
  [sym_jsx_element] = sym_jsx_element,
  [sym_jsx_expression] = sym_jsx_expression,
  [sym_jsx_opening_element] = sym_jsx_opening_element,
  [sym_nested_identifier] = sym_member_expression,
  [sym_jsx_namespace_name] = sym_jsx_namespace_name,
  [sym_jsx_closing_element] = sym_jsx_closing_element,
  [sym_jsx_self_closing_element] = sym_jsx_self_closing_element,
  [sym_jsx_attribute] = sym_jsx_attribute,
  [sym__jsx_string] = sym_string,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function_expression] = sym_function_expression,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__augmented_assignment_lhs] = sym__augmented_assignment_lhs,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_field_definition] = sym_field_definition,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_class_static_block] = sym_class_static_block,
  [sym_pattern] = sym_pattern,
  [sym_rest_pattern] = sym_rest_pattern,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym_pair_pattern] = sym_pair_pattern,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_object_pattern_repeat1] = aux_sym_object_pattern_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_jsx_element_repeat1] = aux_sym_jsx_element_repeat1,
  [aux_sym_jsx_opening_element_repeat1] = aux_sym_jsx_opening_element_repeat1,
  [aux_sym__jsx_string_repeat1] = aux_sym__jsx_string_repeat1,
  [aux_sym__jsx_string_repeat2] = aux_sym__jsx_string_repeat2,
  [aux_sym_sequence_expression_repeat1] = aux_sym_sequence_expression_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_shorthand_property_identifier_pattern] = alias_sym_shorthand_property_identifier_pattern,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_html_character_reference] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_jsx_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_jsx_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_jsx_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_optional_chain] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_private_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_meta] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_method_definition_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = true,
    .named = true,
  },
  [sym__ternary_qmark] = {
    .visible = true,
    .named = false,
  },
  [sym_html_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_text] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_export] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym__module_export_name] = {
    .visible = false,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_import_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_object_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_opening_element] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_namespace_name] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_self_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__jsx_string] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__augmented_assignment_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_class_static_block] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_rest_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_opening_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__jsx_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__jsx_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sequence_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_close_tag = 7,
  field_condition = 8,
  field_consequence = 9,
  field_constructor = 10,
  field_declaration = 11,
  field_decorator = 12,
  field_finalizer = 13,
  field_flags = 14,
  field_function = 15,
  field_handler = 16,
  field_increment = 17,
  field_index = 18,
  field_initializer = 19,
  field_key = 20,
  field_kind = 21,
  field_label = 22,
  field_left = 23,
  field_member = 24,
  field_name = 25,
  field_object = 26,
  field_open_tag = 27,
  field_operator = 28,
  field_optional_chain = 29,
  field_parameter = 30,
  field_parameters = 31,
  field_pattern = 32,
  field_property = 33,
  field_right = 34,
  field_source = 35,
  field_value = 36,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_close_tag] = "close_tag",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_kind] = "kind",
  [field_label] = "label",
  [field_left] = "left",
  [field_member] = "member",
  [field_name] = "name",
  [field_object] = "object",
  [field_open_tag] = "open_tag",
  [field_operator] = "operator",
  [field_optional_chain] = "optional_chain",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_right] = "right",
  [field_source] = "source",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 1},
  [7] = {.index = 4, .length = 1},
  [8] = {.index = 5, .length = 2},
  [9] = {.index = 7, .length = 2},
  [10] = {.index = 9, .length = 2},
  [11] = {.index = 11, .length = 2},
  [12] = {.index = 13, .length = 2},
  [13] = {.index = 15, .length = 1},
  [14] = {.index = 16, .length = 2},
  [15] = {.index = 18, .length = 2},
  [16] = {.index = 20, .length = 2},
  [20] = {.index = 22, .length = 1},
  [21] = {.index = 23, .length = 2},
  [22] = {.index = 25, .length = 2},
  [23] = {.index = 27, .length = 1},
  [24] = {.index = 28, .length = 2},
  [25] = {.index = 30, .length = 2},
  [26] = {.index = 32, .length = 6},
  [27] = {.index = 38, .length = 2},
  [28] = {.index = 40, .length = 2},
  [29] = {.index = 42, .length = 2},
  [30] = {.index = 44, .length = 1},
  [31] = {.index = 45, .length = 1},
  [32] = {.index = 46, .length = 1},
  [33] = {.index = 47, .length = 1},
  [34] = {.index = 48, .length = 1},
  [35] = {.index = 49, .length = 2},
  [36] = {.index = 51, .length = 1},
  [37] = {.index = 52, .length = 2},
  [38] = {.index = 54, .length = 2},
  [39] = {.index = 56, .length = 1},
  [40] = {.index = 18, .length = 2},
  [41] = {.index = 20, .length = 2},
  [42] = {.index = 57, .length = 3},
  [43] = {.index = 60, .length = 2},
  [44] = {.index = 60, .length = 2},
  [45] = {.index = 62, .length = 3},
  [46] = {.index = 62, .length = 3},
  [47] = {.index = 65, .length = 3},
  [48] = {.index = 68, .length = 2},
  [49] = {.index = 70, .length = 2},
  [50] = {.index = 72, .length = 2},
  [51] = {.index = 74, .length = 2},
  [52] = {.index = 76, .length = 1},
  [53] = {.index = 77, .length = 1},
  [54] = {.index = 18, .length = 2},
  [55] = {.index = 78, .length = 2},
  [56] = {.index = 80, .length = 3},
  [57] = {.index = 83, .length = 1},
  [58] = {.index = 84, .length = 3},
  [59] = {.index = 87, .length = 6},
  [60] = {.index = 93, .length = 2},
  [61] = {.index = 95, .length = 3},
  [62] = {.index = 98, .length = 2},
  [63] = {.index = 100, .length = 2},
  [64] = {.index = 102, .length = 1},
  [65] = {.index = 103, .length = 2},
  [66] = {.index = 105, .length = 2},
  [67] = {.index = 107, .length = 1},
  [68] = {.index = 108, .length = 2},
  [69] = {.index = 110, .length = 2},
  [70] = {.index = 112, .length = 2},
  [71] = {.index = 114, .length = 2},
  [72] = {.index = 112, .length = 2},
  [73] = {.index = 116, .length = 2},
  [74] = {.index = 118, .length = 3},
  [75] = {.index = 121, .length = 2},
  [76] = {.index = 123, .length = 2},
  [77] = {.index = 125, .length = 2},
  [78] = {.index = 127, .length = 3},
  [79] = {.index = 130, .length = 2},
  [80] = {.index = 132, .length = 2},
  [81] = {.index = 134, .length = 4},
  [82] = {.index = 138, .length = 2},
  [83] = {.index = 140, .length = 2},
  [84] = {.index = 142, .length = 3},
  [85] = {.index = 145, .length = 2},
  [86] = {.index = 147, .length = 3},
  [87] = {.index = 150, .length = 3},
  [88] = {.index = 153, .length = 3},
  [89] = {.index = 156, .length = 2},
  [90] = {.index = 158, .length = 3},
  [91] = {.index = 161, .length = 4},
  [92] = {.index = 165, .length = 3},
  [93] = {.index = 165, .length = 3},
  [94] = {.index = 168, .length = 3},
  [95] = {.index = 171, .length = 3},
  [96] = {.index = 174, .length = 3},
  [97] = {.index = 177, .length = 4},
  [98] = {.index = 181, .length = 2},
  [99] = {.index = 183, .length = 4},
  [100] = {.index = 187, .length = 4},
  [101] = {.index = 191, .length = 4},
  [102] = {.index = 195, .length = 3},
  [103] = {.index = 198, .length = 2},
  [104] = {.index = 200, .length = 4},
  [105] = {.index = 204, .length = 5},
  [106] = {.index = 209, .length = 4},
  [107] = {.index = 213, .length = 5},
  [108] = {.index = 218, .length = 4},
  [109] = {.index = 222, .length = 4},
  [110] = {.index = 226, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_declaration, 1},
  [2] =
    {field_name, 0},
  [3] =
    {field_body, 1},
  [4] =
    {field_constructor, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_argument, 0},
    {field_operator, 1},
  [11] =
    {field_close_tag, 1},
    {field_open_tag, 0},
  [13] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [15] =
    {field_declaration, 2},
  [16] =
    {field_body, 2},
    {field_label, 0},
  [18] =
    {field_left, 0},
    {field_right, 2},
  [20] =
    {field_body, 2},
    {field_parameter, 0},
  [22] =
    {field_source, 1},
  [23] =
    {field_body, 2},
    {field_object, 1},
  [25] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [27] =
    {field_kind, 0},
  [28] =
    {field_condition, 1},
    {field_consequence, 2},
  [30] =
    {field_body, 2},
    {field_value, 1},
  [32] =
    {field_body, 2},
    {field_kind, 1, .inherited = true},
    {field_left, 1, .inherited = true},
    {field_operator, 1, .inherited = true},
    {field_right, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [38] =
    {field_body, 2},
    {field_condition, 1},
  [40] =
    {field_body, 1},
    {field_handler, 2},
  [42] =
    {field_body, 1},
    {field_finalizer, 2},
  [44] =
    {field_label, 1},
  [45] =
    {field_name, 1},
  [46] =
    {field_attribute, 0},
  [47] =
    {field_member, 0},
  [48] =
    {field_property, 0},
  [49] =
    {field_body, 2},
    {field_name, 1},
  [51] =
    {field_body, 2},
  [52] =
    {field_body, 2},
    {field_parameters, 1},
  [54] =
    {field_arguments, 2},
    {field_constructor, 1},
  [56] =
    {field_pattern, 1},
  [57] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [60] =
    {field_object, 0},
    {field_property, 2},
  [62] =
    {field_object, 0},
    {field_optional_chain, 1},
    {field_property, 2},
  [65] =
    {field_arguments, 2},
    {field_function, 0},
    {field_optional_chain, 1},
  [68] =
    {field_close_tag, 2},
    {field_open_tag, 0},
  [70] =
    {field_body, 2},
    {field_parameters, 0},
  [72] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [74] =
    {field_body, 2},
    {field_decorator, 0, .inherited = true},
  [76] =
    {field_source, 2, .inherited = true},
  [77] =
    {field_value, 2},
  [78] =
    {field_key, 0},
    {field_value, 2},
  [80] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1},
  [83] =
    {field_value, 1},
  [84] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [87] =
    {field_body, 3},
    {field_kind, 2, .inherited = true},
    {field_left, 2, .inherited = true},
    {field_operator, 2, .inherited = true},
    {field_right, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [93] =
    {field_body, 1},
    {field_condition, 3},
  [95] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [98] =
    {field_attribute, 2, .inherited = true},
    {field_name, 1},
  [100] =
    {field_attribute, 0, .inherited = true},
    {field_attribute, 1, .inherited = true},
  [102] =
    {field_property, 1},
  [103] =
    {field_property, 0},
    {field_value, 1, .inherited = true},
  [105] =
    {field_decorator, 0, .inherited = true},
    {field_property, 1},
  [107] =
    {field_member, 1, .inherited = true},
  [108] =
    {field_member, 0, .inherited = true},
    {field_member, 1, .inherited = true},
  [110] =
    {field_body, 3},
    {field_name, 1},
  [112] =
    {field_body, 3},
    {field_parameter, 1},
  [114] =
    {field_body, 3},
    {field_parameters, 2},
  [116] =
    {field_body, 3},
    {field_parameters, 1},
  [118] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [121] =
    {field_flags, 3},
    {field_pattern, 1},
  [123] =
    {field_index, 2},
    {field_object, 0},
  [125] =
    {field_declaration, 3},
    {field_decorator, 0, .inherited = true},
  [127] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [130] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [132] =
    {field_alias, 2},
    {field_name, 0},
  [134] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_parameters, 2},
  [138] =
    {field_property, 1},
    {field_value, 2, .inherited = true},
  [140] =
    {field_decorator, 0, .inherited = true},
    {field_property, 2},
  [142] =
    {field_decorator, 0, .inherited = true},
    {field_property, 1},
    {field_value, 2, .inherited = true},
  [145] =
    {field_body, 4},
    {field_parameters, 3},
  [147] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [150] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [153] =
    {field_index, 3},
    {field_object, 0},
    {field_optional_chain, 1},
  [156] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [158] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [161] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_parameters, 3},
  [165] =
    {field_left, 1},
    {field_operator, 2},
    {field_right, 3},
  [168] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [171] =
    {field_decorator, 0, .inherited = true},
    {field_property, 2},
    {field_value, 3, .inherited = true},
  [174] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4},
  [177] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_parameters, 4},
  [181] =
    {field_body, 3},
    {field_value, 1},
  [183] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 3},
    {field_right, 4},
  [187] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [191] =
    {field_body, 6},
    {field_condition, 3},
    {field_condition, 4},
    {field_initializer, 2},
  [195] =
    {field_body, 6},
    {field_condition, 4},
    {field_initializer, 2},
  [198] =
    {field_body, 4},
    {field_parameter, 2},
  [200] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_parameters, 5},
  [204] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
    {field_value, 3, .inherited = true},
  [209] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
  [213] =
    {field_body, 7},
    {field_condition, 3},
    {field_condition, 4},
    {field_increment, 5},
    {field_initializer, 2},
  [218] =
    {field_body, 7},
    {field_condition, 4},
    {field_increment, 5},
    {field_initializer, 2},
  [222] =
    {field_body, 7},
    {field_condition, 4},
    {field_condition, 5},
    {field_initializer, 2},
  [226] =
    {field_body, 8},
    {field_condition, 4},
    {field_condition, 5},
    {field_increment, 6},
    {field_initializer, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [4] = {
    [0] = alias_sym_property_identifier,
  },
  [14] = {
    [0] = alias_sym_statement_identifier,
  },
  [15] = {
    [0] = sym_identifier,
  },
  [16] = {
    [0] = sym_identifier,
  },
  [17] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [18] = {
    [1] = alias_sym_shorthand_property_identifier_pattern,
  },
  [19] = {
    [1] = sym_identifier,
  },
  [30] = {
    [1] = alias_sym_statement_identifier,
  },
  [43] = {
    [2] = alias_sym_property_identifier,
  },
  [45] = {
    [2] = alias_sym_property_identifier,
  },
  [54] = {
    [0] = alias_sym_shorthand_property_identifier_pattern,
  },
  [70] = {
    [1] = sym_identifier,
  },
  [92] = {
    [1] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 2,
  [5] = 2,
  [6] = 2,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 12,
  [15] = 15,
  [16] = 12,
  [17] = 15,
  [18] = 18,
  [19] = 15,
  [20] = 20,
  [21] = 12,
  [22] = 15,
  [23] = 15,
  [24] = 12,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 30,
  [32] = 32,
  [33] = 27,
  [34] = 28,
  [35] = 25,
  [36] = 36,
  [37] = 37,
  [38] = 29,
  [39] = 39,
  [40] = 37,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 26,
  [46] = 39,
  [47] = 47,
  [48] = 48,
  [49] = 41,
  [50] = 32,
  [51] = 42,
  [52] = 36,
  [53] = 43,
  [54] = 44,
  [55] = 48,
  [56] = 56,
  [57] = 56,
  [58] = 56,
  [59] = 56,
  [60] = 56,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 76,
  [79] = 76,
  [80] = 76,
  [81] = 76,
  [82] = 76,
  [83] = 83,
  [84] = 84,
  [85] = 84,
  [86] = 83,
  [87] = 87,
  [88] = 87,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 89,
  [93] = 93,
  [94] = 93,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 96,
  [100] = 100,
  [101] = 96,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 104,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 110,
  [112] = 108,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 115,
  [117] = 117,
  [118] = 118,
  [119] = 118,
  [120] = 113,
  [121] = 117,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 122,
  [129] = 122,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 132,
  [135] = 135,
  [136] = 131,
  [137] = 137,
  [138] = 132,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 125,
  [143] = 131,
  [144] = 123,
  [145] = 126,
  [146] = 127,
  [147] = 127,
  [148] = 148,
  [149] = 124,
  [150] = 140,
  [151] = 125,
  [152] = 126,
  [153] = 127,
  [154] = 154,
  [155] = 155,
  [156] = 122,
  [157] = 155,
  [158] = 148,
  [159] = 123,
  [160] = 124,
  [161] = 125,
  [162] = 131,
  [163] = 163,
  [164] = 124,
  [165] = 165,
  [166] = 123,
  [167] = 124,
  [168] = 125,
  [169] = 126,
  [170] = 127,
  [171] = 122,
  [172] = 131,
  [173] = 126,
  [174] = 123,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 176,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 179,
  [200] = 181,
  [201] = 201,
  [202] = 175,
  [203] = 182,
  [204] = 183,
  [205] = 185,
  [206] = 186,
  [207] = 187,
  [208] = 188,
  [209] = 189,
  [210] = 190,
  [211] = 191,
  [212] = 192,
  [213] = 193,
  [214] = 194,
  [215] = 195,
  [216] = 196,
  [217] = 198,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 178,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 219,
  [226] = 219,
  [227] = 222,
  [228] = 228,
  [229] = 179,
  [230] = 181,
  [231] = 201,
  [232] = 182,
  [233] = 183,
  [234] = 185,
  [235] = 187,
  [236] = 188,
  [237] = 189,
  [238] = 190,
  [239] = 191,
  [240] = 192,
  [241] = 193,
  [242] = 194,
  [243] = 195,
  [244] = 196,
  [245] = 198,
  [246] = 178,
  [247] = 222,
  [248] = 248,
  [249] = 249,
  [250] = 181,
  [251] = 201,
  [252] = 175,
  [253] = 182,
  [254] = 183,
  [255] = 176,
  [256] = 185,
  [257] = 187,
  [258] = 188,
  [259] = 189,
  [260] = 190,
  [261] = 191,
  [262] = 192,
  [263] = 193,
  [264] = 194,
  [265] = 195,
  [266] = 196,
  [267] = 198,
  [268] = 220,
  [269] = 269,
  [270] = 270,
  [271] = 178,
  [272] = 176,
  [273] = 222,
  [274] = 179,
  [275] = 201,
  [276] = 179,
  [277] = 181,
  [278] = 201,
  [279] = 175,
  [280] = 182,
  [281] = 183,
  [282] = 185,
  [283] = 187,
  [284] = 188,
  [285] = 189,
  [286] = 190,
  [287] = 191,
  [288] = 192,
  [289] = 193,
  [290] = 194,
  [291] = 195,
  [292] = 196,
  [293] = 198,
  [294] = 178,
  [295] = 222,
  [296] = 176,
  [297] = 175,
  [298] = 298,
  [299] = 299,
  [300] = 298,
  [301] = 298,
  [302] = 299,
  [303] = 303,
  [304] = 303,
  [305] = 305,
  [306] = 305,
  [307] = 305,
  [308] = 303,
  [309] = 309,
  [310] = 309,
  [311] = 63,
  [312] = 64,
  [313] = 313,
  [314] = 313,
  [315] = 313,
  [316] = 316,
  [317] = 317,
  [318] = 309,
  [319] = 316,
  [320] = 309,
  [321] = 309,
  [322] = 317,
  [323] = 309,
  [324] = 324,
  [325] = 325,
  [326] = 61,
  [327] = 65,
  [328] = 328,
  [329] = 325,
  [330] = 316,
  [331] = 309,
  [332] = 332,
  [333] = 333,
  [334] = 332,
  [335] = 64,
  [336] = 63,
  [337] = 61,
  [338] = 338,
  [339] = 339,
  [340] = 65,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 328,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 66,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 343,
  [353] = 353,
  [354] = 354,
  [355] = 67,
  [356] = 309,
  [357] = 309,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 359,
  [434] = 432,
  [435] = 435,
  [436] = 436,
  [437] = 432,
  [438] = 438,
  [439] = 438,
  [440] = 440,
  [441] = 440,
  [442] = 442,
  [443] = 430,
  [444] = 444,
  [445] = 429,
  [446] = 436,
  [447] = 438,
  [448] = 448,
  [449] = 440,
  [450] = 427,
  [451] = 438,
  [452] = 452,
  [453] = 453,
  [454] = 440,
  [455] = 455,
  [456] = 452,
  [457] = 435,
  [458] = 440,
  [459] = 459,
  [460] = 438,
  [461] = 430,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 455,
  [467] = 467,
  [468] = 464,
  [469] = 469,
  [470] = 438,
  [471] = 440,
  [472] = 472,
  [473] = 473,
  [474] = 359,
  [475] = 431,
  [476] = 359,
  [477] = 428,
  [478] = 453,
  [479] = 469,
  [480] = 480,
  [481] = 430,
  [482] = 467,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 483,
  [487] = 430,
  [488] = 455,
  [489] = 489,
  [490] = 440,
  [491] = 438,
  [492] = 464,
  [493] = 485,
  [494] = 480,
  [495] = 440,
  [496] = 438,
  [497] = 484,
  [498] = 483,
  [499] = 438,
  [500] = 440,
  [501] = 489,
  [502] = 430,
  [503] = 503,
  [504] = 504,
  [505] = 62,
  [506] = 63,
  [507] = 507,
  [508] = 64,
  [509] = 509,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 518,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 524,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 66,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 67,
  [558] = 558,
  [559] = 559,
  [560] = 560,
  [561] = 561,
  [562] = 562,
  [563] = 563,
  [564] = 564,
  [565] = 565,
  [566] = 566,
  [567] = 567,
  [568] = 568,
  [569] = 569,
  [570] = 61,
  [571] = 571,
  [572] = 65,
  [573] = 573,
  [574] = 574,
  [575] = 575,
  [576] = 576,
  [577] = 511,
  [578] = 578,
  [579] = 503,
  [580] = 580,
  [581] = 581,
  [582] = 582,
  [583] = 583,
  [584] = 504,
  [585] = 585,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 592,
  [593] = 593,
  [594] = 594,
  [595] = 595,
  [596] = 596,
  [597] = 525,
  [598] = 598,
  [599] = 533,
  [600] = 600,
  [601] = 542,
  [602] = 602,
  [603] = 603,
  [604] = 62,
  [605] = 62,
  [606] = 525,
  [607] = 607,
  [608] = 569,
  [609] = 510,
  [610] = 533,
  [611] = 507,
  [612] = 511,
  [613] = 542,
  [614] = 509,
  [615] = 512,
  [616] = 571,
  [617] = 513,
  [618] = 74,
  [619] = 550,
  [620] = 555,
  [621] = 556,
  [622] = 558,
  [623] = 587,
  [624] = 580,
  [625] = 532,
  [626] = 551,
  [627] = 559,
  [628] = 560,
  [629] = 589,
  [630] = 561,
  [631] = 603,
  [632] = 632,
  [633] = 562,
  [634] = 515,
  [635] = 563,
  [636] = 564,
  [637] = 526,
  [638] = 72,
  [639] = 565,
  [640] = 566,
  [641] = 527,
  [642] = 70,
  [643] = 511,
  [644] = 534,
  [645] = 645,
  [646] = 71,
  [647] = 516,
  [648] = 517,
  [649] = 518,
  [650] = 73,
  [651] = 528,
  [652] = 75,
  [653] = 519,
  [654] = 520,
  [655] = 521,
  [656] = 68,
  [657] = 522,
  [658] = 535,
  [659] = 552,
  [660] = 553,
  [661] = 69,
  [662] = 554,
  [663] = 567,
  [664] = 568,
  [665] = 514,
  [666] = 596,
  [667] = 525,
  [668] = 533,
  [669] = 542,
  [670] = 529,
  [671] = 632,
  [672] = 524,
  [673] = 575,
  [674] = 530,
  [675] = 536,
  [676] = 537,
  [677] = 523,
  [678] = 531,
  [679] = 539,
  [680] = 540,
  [681] = 541,
  [682] = 514,
  [683] = 573,
  [684] = 583,
  [685] = 543,
  [686] = 585,
  [687] = 586,
  [688] = 544,
  [689] = 580,
  [690] = 582,
  [691] = 588,
  [692] = 575,
  [693] = 583,
  [694] = 585,
  [695] = 586,
  [696] = 588,
  [697] = 590,
  [698] = 590,
  [699] = 591,
  [700] = 592,
  [701] = 574,
  [702] = 593,
  [703] = 594,
  [704] = 595,
  [705] = 598,
  [706] = 600,
  [707] = 602,
  [708] = 576,
  [709] = 578,
  [710] = 591,
  [711] = 592,
  [712] = 587,
  [713] = 589,
  [714] = 603,
  [715] = 574,
  [716] = 593,
  [717] = 594,
  [718] = 596,
  [719] = 595,
  [720] = 598,
  [721] = 600,
  [722] = 602,
  [723] = 545,
  [724] = 546,
  [725] = 511,
  [726] = 547,
  [727] = 581,
  [728] = 576,
  [729] = 548,
  [730] = 578,
  [731] = 549,
  [732] = 581,
  [733] = 582,
  [734] = 734,
  [735] = 645,
  [736] = 736,
  [737] = 737,
  [738] = 738,
  [739] = 739,
  [740] = 525,
  [741] = 533,
  [742] = 542,
  [743] = 743,
  [744] = 744,
  [745] = 745,
  [746] = 746,
  [747] = 747,
  [748] = 748,
  [749] = 749,
  [750] = 750,
  [751] = 751,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 754,
  [756] = 753,
  [757] = 596,
  [758] = 607,
  [759] = 525,
  [760] = 760,
  [761] = 533,
  [762] = 542,
  [763] = 763,
  [764] = 603,
  [765] = 753,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 754,
  [770] = 760,
  [771] = 771,
  [772] = 772,
  [773] = 768,
  [774] = 774,
  [775] = 775,
  [776] = 753,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 780,
  [781] = 580,
  [782] = 582,
  [783] = 783,
  [784] = 751,
  [785] = 575,
  [786] = 589,
  [787] = 585,
  [788] = 788,
  [789] = 777,
  [790] = 586,
  [791] = 791,
  [792] = 588,
  [793] = 590,
  [794] = 591,
  [795] = 592,
  [796] = 581,
  [797] = 771,
  [798] = 574,
  [799] = 593,
  [800] = 594,
  [801] = 595,
  [802] = 598,
  [803] = 778,
  [804] = 600,
  [805] = 783,
  [806] = 602,
  [807] = 791,
  [808] = 576,
  [809] = 809,
  [810] = 578,
  [811] = 788,
  [812] = 767,
  [813] = 813,
  [814] = 587,
  [815] = 736,
  [816] = 632,
  [817] = 766,
  [818] = 583,
  [819] = 576,
  [820] = 511,
  [821] = 821,
  [822] = 514,
  [823] = 823,
  [824] = 823,
  [825] = 825,
  [826] = 823,
  [827] = 823,
  [828] = 823,
  [829] = 823,
  [830] = 744,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 580,
  [835] = 582,
  [836] = 575,
  [837] = 583,
  [838] = 585,
  [839] = 586,
  [840] = 588,
  [841] = 590,
  [842] = 591,
  [843] = 592,
  [844] = 574,
  [845] = 593,
  [846] = 594,
  [847] = 595,
  [848] = 598,
  [849] = 600,
  [850] = 602,
  [851] = 578,
  [852] = 587,
  [853] = 589,
  [854] = 603,
  [855] = 596,
  [856] = 581,
  [857] = 857,
  [858] = 858,
  [859] = 857,
  [860] = 857,
  [861] = 861,
  [862] = 857,
  [863] = 736,
  [864] = 857,
  [865] = 861,
  [866] = 866,
  [867] = 867,
  [868] = 867,
  [869] = 869,
  [870] = 870,
  [871] = 871,
  [872] = 870,
  [873] = 870,
  [874] = 871,
  [875] = 875,
  [876] = 876,
  [877] = 877,
  [878] = 877,
  [879] = 871,
  [880] = 880,
  [881] = 881,
  [882] = 882,
  [883] = 881,
  [884] = 882,
  [885] = 881,
  [886] = 882,
  [887] = 882,
  [888] = 882,
  [889] = 881,
  [890] = 882,
  [891] = 881,
  [892] = 881,
  [893] = 893,
  [894] = 893,
  [895] = 895,
  [896] = 893,
  [897] = 893,
  [898] = 893,
  [899] = 893,
  [900] = 900,
  [901] = 901,
  [902] = 902,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 906,
  [907] = 907,
  [908] = 908,
  [909] = 909,
  [910] = 910,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 918,
  [919] = 919,
  [920] = 920,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 924,
  [925] = 925,
  [926] = 926,
  [927] = 927,
  [928] = 928,
  [929] = 929,
  [930] = 930,
  [931] = 931,
  [932] = 932,
  [933] = 933,
  [934] = 934,
  [935] = 935,
  [936] = 936,
  [937] = 937,
  [938] = 938,
  [939] = 939,
  [940] = 940,
  [941] = 941,
  [942] = 942,
  [943] = 943,
  [944] = 944,
  [945] = 945,
  [946] = 946,
  [947] = 947,
  [948] = 63,
  [949] = 949,
  [950] = 950,
  [951] = 951,
  [952] = 952,
  [953] = 64,
  [954] = 954,
  [955] = 955,
  [956] = 61,
  [957] = 65,
  [958] = 958,
  [959] = 959,
  [960] = 960,
  [961] = 906,
  [962] = 962,
  [963] = 963,
  [964] = 964,
  [965] = 907,
  [966] = 966,
  [967] = 906,
  [968] = 960,
  [969] = 969,
  [970] = 911,
  [971] = 971,
  [972] = 916,
  [973] = 973,
  [974] = 923,
  [975] = 975,
  [976] = 544,
  [977] = 920,
  [978] = 978,
  [979] = 919,
  [980] = 980,
  [981] = 981,
  [982] = 916,
  [983] = 983,
  [984] = 978,
  [985] = 983,
  [986] = 975,
  [987] = 987,
  [988] = 980,
  [989] = 989,
  [990] = 987,
  [991] = 991,
  [992] = 992,
  [993] = 991,
  [994] = 992,
  [995] = 995,
  [996] = 996,
  [997] = 918,
  [998] = 995,
  [999] = 996,
  [1000] = 564,
  [1001] = 568,
  [1002] = 1002,
  [1003] = 981,
  [1004] = 1004,
  [1005] = 989,
  [1006] = 1006,
  [1007] = 973,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1009,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 1012,
  [1017] = 1017,
  [1018] = 1015,
  [1019] = 1015,
  [1020] = 1020,
  [1021] = 1011,
  [1022] = 1022,
  [1023] = 1015,
  [1024] = 1022,
  [1025] = 1010,
  [1026] = 1020,
  [1027] = 1008,
  [1028] = 1017,
  [1029] = 1015,
  [1030] = 1014,
  [1031] = 1031,
  [1032] = 1032,
  [1033] = 1033,
  [1034] = 1034,
  [1035] = 1032,
  [1036] = 1034,
  [1037] = 1033,
  [1038] = 1032,
  [1039] = 1033,
  [1040] = 1034,
  [1041] = 1032,
  [1042] = 1034,
  [1043] = 1033,
  [1044] = 1044,
  [1045] = 1045,
  [1046] = 1044,
  [1047] = 1047,
  [1048] = 1047,
  [1049] = 1044,
  [1050] = 1047,
  [1051] = 1044,
  [1052] = 1047,
  [1053] = 1053,
  [1054] = 1054,
  [1055] = 1054,
  [1056] = 1056,
  [1057] = 1057,
  [1058] = 1058,
  [1059] = 1058,
  [1060] = 1057,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1062,
  [1064] = 1061,
  [1065] = 1057,
  [1066] = 1054,
  [1067] = 1061,
  [1068] = 1061,
  [1069] = 1058,
  [1070] = 1070,
  [1071] = 1058,
  [1072] = 1054,
  [1073] = 1062,
  [1074] = 1062,
  [1075] = 1057,
  [1076] = 1076,
  [1077] = 1077,
  [1078] = 1078,
  [1079] = 1079,
  [1080] = 1080,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 1082,
  [1084] = 1082,
  [1085] = 1082,
  [1086] = 1086,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 1089,
  [1090] = 1082,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 1096,
  [1097] = 1097,
  [1098] = 1098,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1082,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 569,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 1089,
  [1117] = 1117,
  [1118] = 1118,
  [1119] = 1119,
  [1120] = 571,
  [1121] = 1088,
  [1122] = 1106,
  [1123] = 1123,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1126,
  [1127] = 1102,
  [1128] = 1100,
  [1129] = 1093,
  [1130] = 1130,
  [1131] = 1131,
  [1132] = 1115,
  [1133] = 1133,
  [1134] = 547,
  [1135] = 1135,
  [1136] = 1136,
  [1137] = 1137,
  [1138] = 1138,
  [1139] = 1137,
  [1140] = 1140,
  [1141] = 1141,
  [1142] = 1142,
  [1143] = 1143,
  [1144] = 1144,
  [1145] = 1144,
  [1146] = 553,
  [1147] = 554,
  [1148] = 1137,
  [1149] = 555,
  [1150] = 556,
  [1151] = 1151,
  [1152] = 1152,
  [1153] = 1153,
  [1154] = 1154,
  [1155] = 565,
  [1156] = 1156,
  [1157] = 1157,
  [1158] = 1141,
  [1159] = 1159,
  [1160] = 1160,
  [1161] = 1161,
  [1162] = 531,
  [1163] = 1136,
  [1164] = 1137,
  [1165] = 1165,
  [1166] = 1142,
  [1167] = 569,
  [1168] = 1168,
  [1169] = 1161,
  [1170] = 1156,
  [1171] = 1171,
  [1172] = 531,
  [1173] = 537,
  [1174] = 1174,
  [1175] = 1135,
  [1176] = 1176,
  [1177] = 546,
  [1178] = 547,
  [1179] = 537,
  [1180] = 553,
  [1181] = 554,
  [1182] = 555,
  [1183] = 556,
  [1184] = 565,
  [1185] = 1153,
  [1186] = 1186,
  [1187] = 1144,
  [1188] = 1144,
  [1189] = 1189,
  [1190] = 1151,
  [1191] = 1191,
  [1192] = 1192,
  [1193] = 1193,
  [1194] = 1194,
  [1195] = 546,
  [1196] = 571,
  [1197] = 1174,
  [1198] = 1186,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 1201,
  [1202] = 1202,
  [1203] = 1203,
  [1204] = 1204,
  [1205] = 1205,
  [1206] = 1206,
  [1207] = 1203,
  [1208] = 1208,
  [1209] = 1209,
  [1210] = 1210,
  [1211] = 1086,
  [1212] = 1201,
  [1213] = 1213,
  [1214] = 1214,
  [1215] = 1110,
  [1216] = 1126,
  [1217] = 1217,
  [1218] = 1218,
  [1219] = 1159,
  [1220] = 1220,
  [1221] = 1221,
  [1222] = 1222,
  [1223] = 1223,
  [1224] = 1200,
  [1225] = 1222,
  [1226] = 1226,
  [1227] = 1200,
  [1228] = 1210,
  [1229] = 1229,
  [1230] = 1230,
  [1231] = 1231,
  [1232] = 1232,
  [1233] = 1217,
  [1234] = 1234,
  [1235] = 1214,
  [1236] = 1222,
  [1237] = 1237,
  [1238] = 1238,
  [1239] = 1200,
  [1240] = 1240,
  [1241] = 1229,
  [1242] = 1078,
  [1243] = 1243,
  [1244] = 1244,
  [1245] = 1226,
  [1246] = 1208,
  [1247] = 1226,
  [1248] = 1248,
  [1249] = 1214,
  [1250] = 1222,
  [1251] = 1251,
  [1252] = 1252,
  [1253] = 1204,
  [1254] = 1254,
  [1255] = 1255,
  [1256] = 1118,
  [1257] = 1257,
  [1258] = 1258,
  [1259] = 1230,
  [1260] = 1260,
  [1261] = 1261,
  [1262] = 1254,
  [1263] = 1263,
  [1264] = 1264,
  [1265] = 1265,
  [1266] = 1226,
  [1267] = 1234,
  [1268] = 1268,
  [1269] = 1214,
  [1270] = 1270,
  [1271] = 1271,
  [1272] = 1232,
  [1273] = 1237,
  [1274] = 1274,
  [1275] = 1275,
  [1276] = 1276,
  [1277] = 1277,
  [1278] = 1278,
  [1279] = 1279,
  [1280] = 1280,
  [1281] = 1281,
  [1282] = 1282,
  [1283] = 1283,
  [1284] = 1284,
  [1285] = 1285,
  [1286] = 1286,
  [1287] = 1287,
  [1288] = 1288,
  [1289] = 1289,
  [1290] = 1290,
  [1291] = 1289,
  [1292] = 1292,
  [1293] = 1293,
  [1294] = 1294,
  [1295] = 1295,
  [1296] = 1296,
  [1297] = 1297,
  [1298] = 1298,
  [1299] = 1299,
  [1300] = 1300,
  [1301] = 1301,
  [1302] = 1302,
  [1303] = 1303,
  [1304] = 1304,
  [1305] = 1305,
  [1306] = 1306,
  [1307] = 1307,
  [1308] = 1308,
  [1309] = 1292,
  [1310] = 1296,
  [1311] = 1311,
  [1312] = 1312,
  [1313] = 1313,
  [1314] = 1305,
  [1315] = 1315,
  [1316] = 1316,
  [1317] = 1306,
  [1318] = 1318,
  [1319] = 1303,
  [1320] = 1304,
  [1321] = 1321,
  [1322] = 1322,
  [1323] = 345,
  [1324] = 1324,
  [1325] = 1325,
  [1326] = 1326,
  [1327] = 1327,
  [1328] = 1328,
  [1329] = 1329,
  [1330] = 1330,
  [1331] = 1331,
  [1332] = 1281,
  [1333] = 1289,
  [1334] = 1292,
  [1335] = 1312,
  [1336] = 1297,
  [1337] = 1337,
  [1338] = 1285,
  [1339] = 1339,
  [1340] = 1337,
  [1341] = 1341,
  [1342] = 1325,
  [1343] = 1343,
  [1344] = 1326,
  [1345] = 1328,
  [1346] = 1341,
  [1347] = 1305,
  [1348] = 1274,
  [1349] = 1322,
  [1350] = 1296,
  [1351] = 1316,
  [1352] = 1311,
  [1353] = 1324,
  [1354] = 1297,
  [1355] = 1283,
  [1356] = 1284,
  [1357] = 1357,
  [1358] = 1315,
  [1359] = 1359,
  [1360] = 1360,
  [1361] = 1361,
  [1362] = 1303,
  [1363] = 1363,
  [1364] = 1304,
  [1365] = 1305,
  [1366] = 1366,
  [1367] = 1306,
  [1368] = 1368,
  [1369] = 1343,
  [1370] = 1275,
  [1371] = 1371,
  [1372] = 1372,
  [1373] = 1373,
  [1374] = 1374,
  [1375] = 1375,
  [1376] = 1376,
  [1377] = 1377,
  [1378] = 1378,
  [1379] = 1379,
  [1380] = 1380,
  [1381] = 1381,
  [1382] = 1382,
  [1383] = 1383,
  [1384] = 1384,
  [1385] = 1385,
  [1386] = 1386,
  [1387] = 1387,
  [1388] = 1388,
  [1389] = 1389,
  [1390] = 1390,
  [1391] = 1391,
  [1392] = 1392,
  [1393] = 1393,
  [1394] = 1394,
  [1395] = 1395,
  [1396] = 1396,
  [1397] = 534,
  [1398] = 1398,
  [1399] = 1399,
  [1400] = 1400,
  [1401] = 1401,
  [1402] = 1402,
  [1403] = 1403,
  [1404] = 1404,
  [1405] = 1405,
  [1406] = 550,
  [1407] = 551,
  [1408] = 1408,
  [1409] = 1409,
  [1410] = 1410,
  [1411] = 1411,
  [1412] = 1412,
  [1413] = 1413,
  [1414] = 1414,
  [1415] = 1390,
  [1416] = 1416,
  [1417] = 1392,
  [1418] = 1418,
  [1419] = 1419,
  [1420] = 1420,
  [1421] = 1421,
  [1422] = 1422,
  [1423] = 1423,
  [1424] = 1424,
  [1425] = 1425,
  [1426] = 1426,
  [1427] = 1427,
  [1428] = 1428,
  [1429] = 1429,
  [1430] = 1430,
  [1431] = 1431,
  [1432] = 1432,
  [1433] = 1433,
  [1434] = 1434,
  [1435] = 1435,
  [1436] = 1436,
  [1437] = 1437,
  [1438] = 1438,
  [1439] = 1439,
  [1440] = 1440,
  [1441] = 1441,
  [1442] = 1442,
  [1443] = 1443,
  [1444] = 1444,
  [1445] = 1445,
  [1446] = 1446,
  [1447] = 1447,
  [1448] = 1448,
  [1449] = 1449,
  [1450] = 1450,
  [1451] = 1451,
  [1452] = 1452,
  [1453] = 1453,
  [1454] = 1454,
  [1455] = 1455,
  [1456] = 1456,
  [1457] = 1457,
  [1458] = 1412,
  [1459] = 1459,
  [1460] = 1460,
  [1461] = 1461,
  [1462] = 1462,
  [1463] = 1463,
  [1464] = 1464,
  [1465] = 1465,
  [1466] = 1377,
  [1467] = 1467,
  [1468] = 1468,
  [1469] = 1433,
  [1470] = 1436,
  [1471] = 1471,
  [1472] = 1472,
  [1473] = 1438,
  [1474] = 1431,
  [1475] = 1475,
  [1476] = 1476,
  [1477] = 1477,
  [1478] = 1478,
  [1479] = 1479,
  [1480] = 1480,
  [1481] = 1481,
  [1482] = 1482,
  [1483] = 1483,
  [1484] = 1484,
  [1485] = 1380,
  [1486] = 1486,
  [1487] = 1410,
  [1488] = 1414,
  [1489] = 1422,
  [1490] = 1490,
  [1491] = 1491,
  [1492] = 1492,
  [1493] = 1493,
  [1494] = 1444,
  [1495] = 1374,
  [1496] = 1496,
  [1497] = 1497,
  [1498] = 1498,
  [1499] = 1499,
  [1500] = 1500,
  [1501] = 1501,
  [1502] = 1502,
  [1503] = 1463,
  [1504] = 1405,
  [1505] = 1408,
  [1506] = 1409,
  [1507] = 1416,
  [1508] = 1462,
  [1509] = 1465,
  [1510] = 1510,
  [1511] = 1511,
  [1512] = 1512,
  [1513] = 1418,
  [1514] = 1514,
  [1515] = 1515,
  [1516] = 1516,
  [1517] = 1517,
  [1518] = 1518,
  [1519] = 1519,
  [1520] = 1520,
  [1521] = 1521,
  [1522] = 1396,
  [1523] = 1523,
  [1524] = 1478,
  [1525] = 1372,
  [1526] = 1371,
  [1527] = 1510,
  [1528] = 1528,
  [1529] = 1376,
  [1530] = 1515,
  [1531] = 1516,
  [1532] = 1517,
  [1533] = 1533,
  [1534] = 1390,
  [1535] = 1480,
  [1536] = 1392,
  [1537] = 1537,
  [1538] = 1384,
  [1539] = 1386,
  [1540] = 1540,
  [1541] = 1395,
  [1542] = 1403,
  [1543] = 1543,
  [1544] = 1391,
  [1545] = 1428,
  [1546] = 1546,
  [1547] = 1432,
  [1548] = 1492,
  [1549] = 1549,
  [1550] = 1537,
  [1551] = 1521,
  [1552] = 1518,
  [1553] = 1519,
  [1554] = 1520,
  [1555] = 1439,
  [1556] = 1452,
  [1557] = 1459,
  [1558] = 1558,
  [1559] = 1270,
  [1560] = 1533,
  [1561] = 1561,
  [1562] = 1562,
  [1563] = 1563,
  [1564] = 1427,
  [1565] = 1434,
  [1566] = 1566,
  [1567] = 1437,
  [1568] = 1568,
  [1569] = 1442,
  [1570] = 1570,
  [1571] = 1499,
  [1572] = 1572,
  [1573] = 1481,
  [1574] = 1574,
  [1575] = 1575,
  [1576] = 1576,
  [1577] = 1496,
  [1578] = 1486,
  [1579] = 1426,
  [1580] = 1580,
  [1581] = 1390,
  [1582] = 1392,
  [1583] = 1500,
  [1584] = 1566,
  [1585] = 1501,
  [1586] = 1586,
  [1587] = 1441,
  [1588] = 1588,
  [1589] = 1450,
  [1590] = 1373,
  [1591] = 1497,
  [1592] = 1375,
  [1593] = 1378,
  [1594] = 1404,
  [1595] = 1493,
  [1596] = 1514,
  [1597] = 1456,
  [1598] = 1563,
  [1599] = 1580,
  [1600] = 1460,
  [1601] = 1413,
  [1602] = 1471,
  [1603] = 1472,
  [1604] = 1475,
  [1605] = 1502,
  [1606] = 1586,
  [1607] = 1419,
  [1608] = 1608,
  [1609] = 1420,
  [1610] = 1484,
  [1611] = 1425,
  [1612] = 1449,
  [1613] = 1512,
  [1614] = 1467,
  [1615] = 1615,
  [1616] = 1616,
  [1617] = 1617,
  [1618] = 1618,
  [1619] = 1619,
  [1620] = 1620,
  [1621] = 1621,
  [1622] = 1622,
  [1623] = 1623,
  [1624] = 1624,
  [1625] = 1625,
  [1626] = 1626,
  [1627] = 1627,
  [1628] = 1628,
  [1629] = 1629,
  [1630] = 1622,
  [1631] = 1240,
  [1632] = 1632,
  [1633] = 1619,
  [1634] = 1634,
  [1635] = 1635,
  [1636] = 1622,
  [1637] = 1637,
  [1638] = 1638,
  [1639] = 1638,
  [1640] = 1640,
  [1641] = 1637,
  [1642] = 1642,
  [1643] = 1643,
  [1644] = 1644,
  [1645] = 1645,
  [1646] = 1646,
  [1647] = 1621,
  [1648] = 1637,
  [1649] = 1644,
  [1650] = 1617,
  [1651] = 1651,
  [1652] = 1652,
  [1653] = 1653,
  [1654] = 1654,
  [1655] = 1623,
  [1656] = 1656,
  [1657] = 1651,
  [1658] = 1658,
  [1659] = 1659,
  [1660] = 1660,
  [1661] = 1661,
  [1662] = 1662,
  [1663] = 1644,
  [1664] = 1664,
  [1665] = 1665,
  [1666] = 1623,
  [1667] = 1667,
  [1668] = 1668,
  [1669] = 1652,
  [1670] = 1617,
  [1671] = 1619,
  [1672] = 1660,
  [1673] = 1645,
  [1674] = 1674,
  [1675] = 1675,
  [1676] = 1676,
  [1677] = 1677,
  [1678] = 1658,
  [1679] = 1624,
  [1680] = 1680,
  [1681] = 1617,
  [1682] = 1682,
  [1683] = 1683,
  [1684] = 1684,
  [1685] = 1685,
  [1686] = 1686,
  [1687] = 1687,
  [1688] = 1635,
  [1689] = 1682,
  [1690] = 1675,
  [1691] = 1686,
  [1692] = 1635,
  [1693] = 1693,
  [1694] = 1694,
  [1695] = 1694,
  [1696] = 1682,
  [1697] = 1697,
  [1698] = 1635,
  [1699] = 1637,
  [1700] = 1637,
  [1701] = 1623,
  [1702] = 1682,
  [1703] = 1632,
  [1704] = 1619,
  [1705] = 1632,
  [1706] = 1624,
  [1707] = 1619,
  [1708] = 1644,
  [1709] = 1623,
  [1710] = 1632,
  [1711] = 1711,
  [1712] = 1677,
  [1713] = 1713,
  [1714] = 1622,
  [1715] = 1715,
  [1716] = 1682,
  [1717] = 1717,
  [1718] = 1632,
  [1719] = 1717,
  [1720] = 1644,
  [1721] = 1624,
};

static TSCharacterRange extras_character_set_1[] = {
  {'\t', '\r'}, {' ', ' '}, {0xa0, 0xa0}, {0x1680, 0x1680}, {0x2000, 0x200b}, {0x2028, 0x2029}, {0x202f, 0x202f}, {0x205f, 0x2060},
  {0x3000, 0x3000}, {0xfeff, 0xfeff},
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'$', '$'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0x7f, 0x9f}, {0xa1, 0x167f}, {0x1681, 0x1fff},
  {0x200c, 0x2027}, {0x202a, 0x202e}, {0x2030, 0x205e}, {0x2061, 0x2fff}, {0x3001, 0xfefe}, {0xff00, 0x10ffff},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'$', '$'}, {'0', '9'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0x7f, 0x9f}, {0xa1, 0x167f},
  {0x1681, 0x1fff}, {0x200c, 0x2027}, {0x202a, 0x202e}, {0x2030, 0x205e}, {0x2061, 0x2fff}, {0x3001, 0xfefe}, {0xff00, 0x10ffff},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(126);
      ADVANCE_MAP(
        '!', 226,
        '"', 159,
        '#', 3,
        '$', 273,
        '%', 214,
        '&', 201,
        '\'', 160,
        '(', 134,
        ')', 136,
        '*', 129,
        '+', 208,
        ',', 132,
        '-', 210,
        '.', 155,
        '/', 253,
        '0', 258,
        ':', 137,
        ';', 135,
        '<', 147,
        '=', 140,
        '>', 151,
        '?', 28,
        '@', 277,
        '[', 142,
        '\\', 80,
        ']', 143,
        '^', 204,
        '`', 251,
        's', 271,
        '{', 131,
        '|', 205,
        '}', 133,
        '~', 227,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(259);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(123);
      if (lookahead > '@') ADVANCE(275);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(278);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(1);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(33);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(122);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(254);
      if (lookahead != 0) ADVANCE(255);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '\\') ADVANCE(81);
      if (set_contains(sym_identifier_character_set_1, 14, lookahead)) ADVANCE(276);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 225,
        '"', 159,
        '#', 75,
        '\'', 160,
        '(', 134,
        '*', 128,
        '+', 207,
        ',', 132,
        '-', 209,
        '.', 27,
        '/', 211,
        '0', 258,
        ';', 135,
        '<', 145,
        '@', 277,
        '[', 142,
        '\\', 82,
        '`', 251,
        's', 271,
        '{', 131,
        '}', 133,
        '~', 227,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(259);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(4);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(275);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 225,
        '"', 159,
        '#', 75,
        '\'', 160,
        '(', 134,
        '+', 207,
        '-', 209,
        '.', 156,
        '/', 211,
        '0', 258,
        ':', 137,
        '<', 145,
        '>', 150,
        '@', 277,
        '[', 142,
        '\\', 82,
        '`', 251,
        '{', 131,
        '~', 227,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(259);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(5);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(275);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 73,
        '"', 159,
        '#', 75,
        '%', 214,
        '&', 201,
        '\'', 160,
        '(', 134,
        ')', 136,
        '*', 129,
        '+', 208,
        ',', 132,
        '-', 210,
        '.', 156,
        '/', 212,
        '0', 258,
        ':', 137,
        ';', 135,
        '<', 148,
        '=', 140,
        '>', 151,
        '?', 28,
        '@', 277,
        '[', 142,
        '\\', 82,
        ']', 143,
        '^', 204,
        '`', 251,
        '{', 131,
        '|', 205,
        '}', 133,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(259);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(6);
      if (lookahead > '#' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(275);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 73,
        '%', 213,
        '&', 202,
        '(', 134,
        ')', 136,
        '*', 130,
        '+', 207,
        ',', 132,
        '-', 209,
        '.', 154,
        '/', 211,
        ':', 137,
        ';', 135,
        '<', 149,
        '=', 74,
        '>', 152,
        '?', 29,
        '[', 142,
        '\\', 82,
        ']', 143,
        '^', 203,
        '`', 251,
        '{', 131,
        '|', 206,
        '}', 133,
      );
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(8);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '`' || '~' < lookahead)) ADVANCE(275);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '!', 73,
        '%', 213,
        '&', 202,
        '(', 134,
        ')', 136,
        '*', 130,
        '+', 207,
        ',', 132,
        '-', 209,
        '.', 154,
        '/', 211,
        ':', 137,
        ';', 135,
        '<', 149,
        '=', 74,
        '>', 152,
        '?', 29,
        '[', 142,
        '\\', 82,
        ']', 143,
        '^', 203,
        '`', 251,
        '{', 131,
        '|', 206,
        '}', 133,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(8);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(275);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '"', 159,
        '#', 75,
        '&', 13,
        '\'', 160,
        '(', 134,
        '*', 128,
        '.', 156,
        '/', 21,
        '0', 258,
        '<', 146,
        '@', 277,
        '[', 142,
        '\\', 82,
        's', 271,
        '{', 131,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(259);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(9);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(275);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(159);
      if (lookahead == '&') ADVANCE(14);
      if (lookahead == '/') ADVANCE(162);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(161);
      if (lookahead != 0) ADVANCE(163);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(159);
      if (lookahead == '/') ADVANCE(21);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(11);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(159);
      if (lookahead == '/') ADVANCE(230);
      if (lookahead == '\\') ADVANCE(83);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(11);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(233);
      if (lookahead != 0) ADVANCE(235);
      END_STATE();
    case 13:
      if (lookahead == '#') ADVANCE(94);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(72);
      END_STATE();
    case 14:
      if (lookahead == '#') ADVANCE(94);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(72);
      if (lookahead != 0) ADVANCE(163);
      END_STATE();
    case 15:
      if (lookahead == '#') ADVANCE(94);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(72);
      if (lookahead != 0) ADVANCE(169);
      END_STATE();
    case 16:
      if (lookahead == '$') ADVANCE(84);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '\\') ADVANCE(83);
      if (lookahead == '`') ADVANCE(251);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(17);
      END_STATE();
    case 17:
      if (lookahead == '$') ADVANCE(84);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '`') ADVANCE(251);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(17);
      END_STATE();
    case 18:
      if (lookahead == '&') ADVANCE(15);
      if (lookahead == '\'') ADVANCE(160);
      if (lookahead == '/') ADVANCE(168);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(167);
      if (lookahead != 0) ADVANCE(169);
      END_STATE();
    case 19:
      if (lookahead == '\'') ADVANCE(160);
      if (lookahead == '/') ADVANCE(21);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(19);
      END_STATE();
    case 20:
      if (lookahead == '\'') ADVANCE(160);
      if (lookahead == '/') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(83);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(19);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(239);
      if (lookahead != 0) ADVANCE(241);
      END_STATE();
    case 21:
      if (lookahead == '*') ADVANCE(24);
      if (lookahead == '/') ADVANCE(250);
      END_STATE();
    case 22:
      if (lookahead == '*') ADVANCE(24);
      if (lookahead == '/') ADVANCE(250);
      if (lookahead == '>') ADVANCE(158);
      END_STATE();
    case 23:
      if (lookahead == '*') ADVANCE(23);
      if (lookahead == '/') ADVANCE(247);
      if (lookahead != 0) ADVANCE(24);
      END_STATE();
    case 24:
      if (lookahead == '*') ADVANCE(23);
      if (lookahead != 0) ADVANCE(24);
      END_STATE();
    case 25:
      if (lookahead == '*') ADVANCE(164);
      if (lookahead == '#' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(24);
      if (lookahead != 0) ADVANCE(165);
      END_STATE();
    case 26:
      if (lookahead == '*') ADVANCE(170);
      if (lookahead == '#' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(24);
      if (lookahead != 0) ADVANCE(171);
      END_STATE();
    case 27:
      if (lookahead == '.') ADVANCE(30);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      END_STATE();
    case 28:
      if (lookahead == '.') ADVANCE(174);
      if (lookahead == '?') ADVANCE(224);
      END_STATE();
    case 29:
      if (lookahead == '.') ADVANCE(174);
      if (lookahead == '?') ADVANCE(223);
      END_STATE();
    case 30:
      if (lookahead == '.') ADVANCE(190);
      END_STATE();
    case 31:
      if (lookahead == '.') ADVANCE(154);
      if (lookahead == '/') ADVANCE(22);
      if (lookahead == ':') ADVANCE(137);
      if (lookahead == '=') ADVANCE(138);
      if (lookahead == '>') ADVANCE(150);
      if (lookahead == '\\') ADVANCE(82);
      if (lookahead == '{') ADVANCE(131);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(31);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(267);
      if (lookahead > '~') ADVANCE(275);
      END_STATE();
    case 32:
      if (lookahead == '/') ADVANCE(253);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(33);
      END_STATE();
    case 33:
      if (lookahead == '/') ADVANCE(21);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(33);
      END_STATE();
    case 34:
      if (lookahead == ';') ADVANCE(144);
      END_STATE();
    case 35:
      if (lookahead == ';') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(34);
      END_STATE();
    case 36:
      if (lookahead == ';') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(35);
      END_STATE();
    case 37:
      if (lookahead == ';') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(36);
      END_STATE();
    case 38:
      if (lookahead == ';') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(37);
      END_STATE();
    case 39:
      if (lookahead == ';') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(34);
      END_STATE();
    case 40:
      if (lookahead == ';') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 41:
      if (lookahead == ';') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 42:
      if (lookahead == ';') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(41);
      END_STATE();
    case 43:
      if (lookahead == ';') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 44:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(34);
      END_STATE();
    case 45:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(44);
      END_STATE();
    case 46:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(45);
      END_STATE();
    case 47:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(46);
      END_STATE();
    case 48:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(47);
      END_STATE();
    case 49:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(48);
      END_STATE();
    case 50:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(49);
      END_STATE();
    case 51:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(50);
      END_STATE();
    case 52:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(51);
      END_STATE();
    case 53:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(52);
      END_STATE();
    case 54:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(53);
      END_STATE();
    case 55:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    case 56:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(55);
      END_STATE();
    case 57:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(56);
      END_STATE();
    case 58:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(57);
      END_STATE();
    case 59:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(58);
      END_STATE();
    case 60:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(59);
      END_STATE();
    case 61:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(60);
      END_STATE();
    case 62:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(61);
      END_STATE();
    case 63:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(62);
      END_STATE();
    case 64:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(63);
      END_STATE();
    case 65:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 66:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(65);
      END_STATE();
    case 67:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 68:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(67);
      END_STATE();
    case 69:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(68);
      END_STATE();
    case 70:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(69);
      END_STATE();
    case 71:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(70);
      END_STATE();
    case 72:
      if (lookahead == ';') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(71);
      END_STATE();
    case 73:
      if (lookahead == '=') ADVANCE(220);
      END_STATE();
    case 74:
      if (lookahead == '=') ADVANCE(218);
      END_STATE();
    case 75:
      if (lookahead == '\\') ADVANCE(81);
      if (set_contains(sym_identifier_character_set_1, 14, lookahead)) ADVANCE(276);
      END_STATE();
    case 76:
      if (lookahead == '\\') ADVANCE(121);
      if (lookahead == ']') ADVANCE(255);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(76);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(79);
      END_STATE();
    case 78:
      if (lookahead == 'g') ADVANCE(77);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(78);
      END_STATE();
    case 79:
      if (lookahead == 't') ADVANCE(1);
      END_STATE();
    case 80:
      if (lookahead == 'u') ADVANCE(85);
      if (lookahead == 'x') ADVANCE(111);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(246);
      if (lookahead != 0) ADVANCE(242);
      END_STATE();
    case 81:
      if (lookahead == 'u') ADVANCE(86);
      END_STATE();
    case 82:
      if (lookahead == 'u') ADVANCE(87);
      END_STATE();
    case 83:
      if (lookahead == 'u') ADVANCE(88);
      if (lookahead == 'x') ADVANCE(111);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(246);
      if (lookahead != 0) ADVANCE(242);
      END_STATE();
    case 84:
      if (lookahead == '{') ADVANCE(252);
      END_STATE();
    case 85:
      if (lookahead == '{') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(116);
      END_STATE();
    case 86:
      if (lookahead == '{') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(117);
      END_STATE();
    case 87:
      if (lookahead == '{') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(118);
      END_STATE();
    case 88:
      if (lookahead == '{') ADVANCE(112);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(108);
      END_STATE();
    case 89:
      if (lookahead == '}') ADVANCE(275);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(89);
      END_STATE();
    case 90:
      if (lookahead == '}') ADVANCE(276);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 91:
      if (lookahead == '}') ADVANCE(242);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(91);
      END_STATE();
    case 92:
      if (lookahead == '}') ADVANCE(243);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(92);
      END_STATE();
    case 93:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(265);
      END_STATE();
    case 94:
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(107);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(38);
      END_STATE();
    case 95:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(261);
      END_STATE();
    case 96:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(262);
      END_STATE();
    case 97:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(259);
      END_STATE();
    case 98:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      END_STATE();
    case 99:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(260);
      END_STATE();
    case 100:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(265);
      END_STATE();
    case 101:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(275);
      END_STATE();
    case 102:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(276);
      END_STATE();
    case 103:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(242);
      END_STATE();
    case 104:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(263);
      END_STATE();
    case 105:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(92);
      END_STATE();
    case 106:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(243);
      END_STATE();
    case 107:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 108:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(111);
      END_STATE();
    case 109:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 110:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(89);
      END_STATE();
    case 111:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(103);
      END_STATE();
    case 112:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(91);
      END_STATE();
    case 113:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(106);
      END_STATE();
    case 114:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(102);
      END_STATE();
    case 115:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(101);
      END_STATE();
    case 116:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(113);
      END_STATE();
    case 117:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(114);
      END_STATE();
    case 118:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(115);
      END_STATE();
    case 119:
      if (lookahead != 0 &&
          lookahead != '#' &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          (lookahead < 'a' || 'z' < lookahead)) ADVANCE(163);
      END_STATE();
    case 120:
      if (lookahead != 0 &&
          lookahead != '#' &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          (lookahead < 'a' || 'z' < lookahead)) ADVANCE(169);
      END_STATE();
    case 121:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(76);
      END_STATE();
    case 122:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(255);
      END_STATE();
    case 123:
      if (eof) ADVANCE(126);
      ADVANCE_MAP(
        '!', 226,
        '"', 159,
        '#', 3,
        '$', 273,
        '%', 214,
        '&', 201,
        '\'', 160,
        '(', 134,
        ')', 136,
        '*', 129,
        '+', 208,
        ',', 132,
        '-', 210,
        '.', 155,
        '/', 212,
        '0', 258,
        ':', 137,
        ';', 135,
        '<', 147,
        '=', 140,
        '>', 151,
        '?', 28,
        '@', 277,
        '[', 142,
        '\\', 82,
        ']', 143,
        '^', 204,
        '`', 251,
        's', 271,
        '{', 131,
        '|', 205,
        '}', 133,
        '~', 227,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(259);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(123);
      if (lookahead > '@') ADVANCE(275);
      END_STATE();
    case 124:
      if (eof) ADVANCE(126);
      ADVANCE_MAP(
        '!', 226,
        '"', 159,
        '#', 75,
        '%', 213,
        '&', 202,
        '\'', 160,
        '(', 134,
        ')', 136,
        '*', 130,
        '+', 207,
        ',', 132,
        '-', 209,
        '.', 156,
        '/', 211,
        '0', 258,
        ':', 137,
        ';', 135,
        '<', 149,
        '=', 139,
        '>', 152,
        '?', 29,
        '@', 277,
        '[', 142,
        '\\', 82,
        ']', 143,
        '^', 203,
        '`', 251,
        '{', 131,
        '|', 206,
        '}', 133,
        '~', 227,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(259);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(124);
      if (lookahead > '#') ADVANCE(275);
      END_STATE();
    case 125:
      if (eof) ADVANCE(126);
      ADVANCE_MAP(
        '!', 225,
        '"', 159,
        '#', 3,
        '\'', 160,
        '(', 134,
        ')', 136,
        '*', 128,
        '+', 207,
        ',', 132,
        '-', 209,
        '.', 27,
        '/', 211,
        '0', 258,
        ':', 137,
        ';', 135,
        '<', 145,
        '=', 141,
        '>', 150,
        '@', 277,
        '[', 142,
        '\\', 82,
        ']', 143,
        '`', 251,
        '{', 131,
        '}', 133,
        '~', 227,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(259);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(125);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(275);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(127);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(216);
      if (lookahead == '=') ADVANCE(177);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(215);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(218);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(218);
      if (lookahead == '>') ADVANCE(173);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(173);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_html_character_reference);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '/') ADVANCE(157);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '/') ADVANCE(157);
      if (lookahead == '<') ADVANCE(200);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(200);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(199);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(222);
      if (lookahead == '>') ADVANCE(195);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(222);
      if (lookahead == '>') ADVANCE(196);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_jsx_identifier);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(153);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(30);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_LT_SLASH);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_SLASH_GT);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(14);
      if (lookahead == '/') ADVANCE(162);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(161);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(163);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(119);
      if (lookahead == '*') ADVANCE(165);
      if (lookahead == '/') ADVANCE(166);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(163);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(119);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(163);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(25);
      if (lookahead == '*') ADVANCE(164);
      if (lookahead == '/') ADVANCE(163);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(165);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(25);
      if (lookahead == '*') ADVANCE(164);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(165);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(248);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(163);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(166);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(15);
      if (lookahead == '/') ADVANCE(168);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(167);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(169);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(120);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(169);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(120);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(169);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(26);
      if (lookahead == '*') ADVANCE(170);
      if (lookahead == '/') ADVANCE(169);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(171);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(26);
      if (lookahead == '*') ADVANCE(170);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(171);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(249);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(169);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(172);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_optional_chain);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(187);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(188);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(183);
      if (lookahead == '>') ADVANCE(198);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(197);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(184);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(185);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(192);
      if (lookahead == '=') ADVANCE(181);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(191);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(180);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(182);
      if (lookahead == '|') ADVANCE(194);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(193);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(228);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(228);
      if (lookahead == '=') ADVANCE(175);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(229);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(229);
      if (lookahead == '=') ADVANCE(176);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(24);
      if (lookahead == '/') ADVANCE(250);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(24);
      if (lookahead == '/') ADVANCE(250);
      if (lookahead == '=') ADVANCE(178);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(179);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(186);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(219);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(221);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(189);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(220);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(232);
      if (lookahead == '/') ADVANCE(234);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(235);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(231);
      if (lookahead == '/') ADVANCE(235);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(232);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(231);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(232);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '/') ADVANCE(230);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(233);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(235);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(235);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(234);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(235);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(238);
      if (lookahead == '/') ADVANCE(240);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(241);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(237);
      if (lookahead == '/') ADVANCE(241);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(238);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(237);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(238);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '/') ADVANCE(236);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(239);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(241);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(241);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(240);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(241);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(82);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(275);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(242);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(242);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(245);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(163);
      if (lookahead == '#' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      if (lookahead != 0) ADVANCE(166);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(169);
      if (lookahead == '#' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      if (lookahead != 0) ADVANCE(172);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != 0x2028 &&
          lookahead != 0x2029) ADVANCE(250);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n') SKIP(33);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(122);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(254);
      if (lookahead != 0) ADVANCE(255);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(122);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(255);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(82);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(275);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_number);
      ADVANCE_MAP(
        '.', 266,
        '0', 260,
        '_', 99,
        'n', 257,
        'B', 95,
        'b', 95,
        'E', 93,
        'e', 93,
        'O', 96,
        'o', 96,
        'X', 104,
        'x', 104,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(259);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(266);
      if (lookahead == '_') ADVANCE(97);
      if (lookahead == 'n') ADVANCE(257);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(259);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(99);
      if (lookahead == 'n') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(260);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(95);
      if (lookahead == 'n') ADVANCE(257);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(261);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(96);
      if (lookahead == 'n') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(262);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(104);
      if (lookahead == 'n') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(263);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(98);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(265);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(153);
      if (lookahead == '\\') ADVANCE(82);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(267);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(275);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(82);
      if (lookahead == 'a') ADVANCE(272);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(275);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(82);
      if (lookahead == 'c') ADVANCE(274);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(275);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(82);
      if (lookahead == 'i') ADVANCE(269);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(275);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(82);
      if (lookahead == 't') ADVANCE(268);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(275);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(82);
      if (lookahead == 't') ADVANCE(270);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(275);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(82);
      if (lookahead == '{') ADVANCE(252);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(275);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(82);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(78);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(275);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(82);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(275);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_private_property_identifier);
      if (lookahead == '\\') ADVANCE(81);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(276);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(aux_sym_method_definition_token1);
      if (lookahead == '\n') ADVANCE(278);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(1);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'g', 7,
        'i', 8,
        'l', 9,
        'm', 10,
        'n', 11,
        'o', 12,
        'r', 13,
        's', 14,
        't', 15,
        'u', 16,
        'v', 17,
        'w', 18,
        'y', 19,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 's') ADVANCE(20);
      if (lookahead == 'w') ADVANCE(21);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(22);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(23);
      if (lookahead == 'l') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(26);
      if (lookahead == 'o') ADVANCE(27);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(28);
      if (lookahead == 'x') ADVANCE(29);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(30);
      if (lookahead == 'i') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      if (lookahead == 'r') ADVANCE(33);
      if (lookahead == 'u') ADVANCE(34);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(35);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(36);
      if (lookahead == 'm') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(38);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(39);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(41);
      if (lookahead == 'u') ADVANCE(42);
      END_STATE();
    case 12:
      if (lookahead == 'f') ADVANCE(43);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(44);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(45);
      if (lookahead == 't') ADVANCE(46);
      if (lookahead == 'u') ADVANCE(47);
      if (lookahead == 'w') ADVANCE(48);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(49);
      if (lookahead == 'h') ADVANCE(50);
      if (lookahead == 'r') ADVANCE(51);
      if (lookahead == 'y') ADVANCE(52);
      END_STATE();
    case 16:
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(54);
      if (lookahead == 'o') ADVANCE(55);
      END_STATE();
    case 18:
      if (lookahead == 'h') ADVANCE(56);
      if (lookahead == 'i') ADVANCE(57);
      END_STATE();
    case 19:
      if (lookahead == 'i') ADVANCE(58);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'y') ADVANCE(59);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(60);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 23:
      if (lookahead == 's') ADVANCE(62);
      if (lookahead == 't') ADVANCE(63);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(64);
      END_STATE();
    case 25:
      if (lookahead == 'n') ADVANCE(65);
      END_STATE();
    case 26:
      if (lookahead == 'b') ADVANCE(66);
      if (lookahead == 'f') ADVANCE(67);
      if (lookahead == 'l') ADVANCE(68);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 28:
      if (lookahead == 's') ADVANCE(69);
      END_STATE();
    case 29:
      if (lookahead == 'p') ADVANCE(70);
      if (lookahead == 't') ADVANCE(71);
      END_STATE();
    case 30:
      if (lookahead == 'l') ADVANCE(72);
      END_STATE();
    case 31:
      if (lookahead == 'n') ADVANCE(73);
      END_STATE();
    case 32:
      if (lookahead == 'r') ADVANCE(74);
      END_STATE();
    case 33:
      if (lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 34:
      if (lookahead == 'n') ADVANCE(76);
      END_STATE();
    case 35:
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 37:
      if (lookahead == 'p') ADVANCE(78);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 's') ADVANCE(79);
      END_STATE();
    case 39:
      if (lookahead == 't') ADVANCE(80);
      END_STATE();
    case 40:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 41:
      if (lookahead == 'w') ADVANCE(82);
      END_STATE();
    case 42:
      if (lookahead == 'l') ADVANCE(83);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 44:
      if (lookahead == 't') ADVANCE(84);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(85);
      END_STATE();
    case 46:
      if (lookahead == 'a') ADVANCE(86);
      END_STATE();
    case 47:
      if (lookahead == 'p') ADVANCE(87);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(88);
      END_STATE();
    case 49:
      if (lookahead == 'r') ADVANCE(89);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(90);
      if (lookahead == 'r') ADVANCE(91);
      END_STATE();
    case 51:
      if (lookahead == 'u') ADVANCE(92);
      if (lookahead == 'y') ADVANCE(93);
      END_STATE();
    case 52:
      if (lookahead == 'p') ADVANCE(94);
      END_STATE();
    case 53:
      if (lookahead == 'd') ADVANCE(95);
      END_STATE();
    case 54:
      if (lookahead == 'r') ADVANCE(96);
      END_STATE();
    case 55:
      if (lookahead == 'i') ADVANCE(97);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(98);
      END_STATE();
    case 57:
      if (lookahead == 't') ADVANCE(99);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 59:
      if (lookahead == 'n') ADVANCE(101);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(102);
      END_STATE();
    case 61:
      if (lookahead == 'a') ADVANCE(103);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(104);
      END_STATE();
    case 63:
      if (lookahead == 'c') ADVANCE(105);
      END_STATE();
    case 64:
      if (lookahead == 's') ADVANCE(106);
      END_STATE();
    case 65:
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == 't') ADVANCE(108);
      END_STATE();
    case 66:
      if (lookahead == 'u') ADVANCE(109);
      END_STATE();
    case 67:
      if (lookahead == 'a') ADVANCE(110);
      END_STATE();
    case 68:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(112);
      END_STATE();
    case 70:
      if (lookahead == 'o') ADVANCE(113);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(114);
      END_STATE();
    case 72:
      if (lookahead == 's') ADVANCE(115);
      END_STATE();
    case 73:
      if (lookahead == 'a') ADVANCE(116);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 75:
      if (lookahead == 'm') ADVANCE(117);
      END_STATE();
    case 76:
      if (lookahead == 'c') ADVANCE(118);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 78:
      if (lookahead == 'o') ADVANCE(119);
      END_STATE();
    case 79:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(121);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 83:
      if (lookahead == 'l') ADVANCE(122);
      END_STATE();
    case 84:
      if (lookahead == 'u') ADVANCE(123);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 86:
      if (lookahead == 't') ADVANCE(124);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(125);
      END_STATE();
    case 88:
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 89:
      if (lookahead == 'g') ADVANCE(127);
      END_STATE();
    case 90:
      if (lookahead == 's') ADVANCE(128);
      END_STATE();
    case 91:
      if (lookahead == 'o') ADVANCE(129);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(130);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 94:
      if (lookahead == 'e') ADVANCE(131);
      END_STATE();
    case 95:
      if (lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 97:
      if (lookahead == 'd') ADVANCE(133);
      END_STATE();
    case 98:
      if (lookahead == 'l') ADVANCE(134);
      END_STATE();
    case 99:
      if (lookahead == 'h') ADVANCE(135);
      END_STATE();
    case 100:
      if (lookahead == 'l') ADVANCE(136);
      END_STATE();
    case 101:
      if (lookahead == 'c') ADVANCE(137);
      END_STATE();
    case 102:
      if (lookahead == 't') ADVANCE(138);
      END_STATE();
    case 103:
      if (lookahead == 'k') ADVANCE(139);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 105:
      if (lookahead == 'h') ADVANCE(140);
      END_STATE();
    case 106:
      if (lookahead == 's') ADVANCE(141);
      END_STATE();
    case 107:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 108:
      if (lookahead == 'i') ADVANCE(143);
      END_STATE();
    case 109:
      if (lookahead == 'g') ADVANCE(144);
      END_STATE();
    case 110:
      if (lookahead == 'u') ADVANCE(145);
      END_STATE();
    case 111:
      if (lookahead == 't') ADVANCE(146);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 113:
      if (lookahead == 'r') ADVANCE(147);
      END_STATE();
    case 114:
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 115:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 116:
      if (lookahead == 'l') ADVANCE(150);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 118:
      if (lookahead == 't') ADVANCE(151);
      END_STATE();
    case 119:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 120:
      if (lookahead == 'a') ADVANCE(153);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_meta);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 123:
      if (lookahead == 'r') ADVANCE(154);
      END_STATE();
    case 124:
      if (lookahead == 'i') ADVANCE(155);
      END_STATE();
    case 125:
      if (lookahead == 'r') ADVANCE(156);
      END_STATE();
    case 126:
      if (lookahead == 'c') ADVANCE(157);
      END_STATE();
    case 127:
      if (lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 129:
      if (lookahead == 'w') ADVANCE(159);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 131:
      if (lookahead == 'o') ADVANCE(160);
      END_STATE();
    case 132:
      if (lookahead == 'f') ADVANCE(161);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 134:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 136:
      if (lookahead == 'd') ADVANCE(163);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 143:
      if (lookahead == 'n') ADVANCE(164);
      END_STATE();
    case 144:
      if (lookahead == 'g') ADVANCE(165);
      END_STATE();
    case 145:
      if (lookahead == 'l') ADVANCE(166);
      END_STATE();
    case 146:
      if (lookahead == 'e') ADVANCE(167);
      END_STATE();
    case 147:
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 148:
      if (lookahead == 'd') ADVANCE(169);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 150:
      if (lookahead == 'l') ADVANCE(170);
      END_STATE();
    case 151:
      if (lookahead == 'i') ADVANCE(171);
      END_STATE();
    case 152:
      if (lookahead == 't') ADVANCE(172);
      END_STATE();
    case 153:
      if (lookahead == 'n') ADVANCE(173);
      END_STATE();
    case 154:
      if (lookahead == 'n') ADVANCE(174);
      END_STATE();
    case 155:
      if (lookahead == 'c') ADVANCE(175);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 157:
      if (lookahead == 'h') ADVANCE(176);
      END_STATE();
    case 158:
      if (lookahead == 't') ADVANCE(177);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 160:
      if (lookahead == 'f') ADVANCE(178);
      END_STATE();
    case 161:
      if (lookahead == 'i') ADVANCE(179);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 164:
      if (lookahead == 'u') ADVANCE(180);
      END_STATE();
    case 165:
      if (lookahead == 'e') ADVANCE(181);
      END_STATE();
    case 166:
      if (lookahead == 't') ADVANCE(182);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 169:
      if (lookahead == 's') ADVANCE(183);
      END_STATE();
    case 170:
      if (lookahead == 'y') ADVANCE(184);
      END_STATE();
    case 171:
      if (lookahead == 'o') ADVANCE(185);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 173:
      if (lookahead == 'c') ADVANCE(186);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 179:
      if (lookahead == 'n') ADVANCE(187);
      END_STATE();
    case 180:
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 181:
      if (lookahead == 'r') ADVANCE(189);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 185:
      if (lookahead == 'n') ADVANCE(190);
      END_STATE();
    case 186:
      if (lookahead == 'e') ADVANCE(191);
      END_STATE();
    case 187:
      if (lookahead == 'e') ADVANCE(192);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 191:
      if (lookahead == 'o') ADVANCE(193);
      END_STATE();
    case 192:
      if (lookahead == 'd') ADVANCE(194);
      END_STATE();
    case 193:
      if (lookahead == 'f') ADVANCE(195);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 125, .external_lex_state = 2},
  [2] = {.lex_state = 4, .external_lex_state = 2},
  [3] = {.lex_state = 4, .external_lex_state = 2},
  [4] = {.lex_state = 4, .external_lex_state = 2},
  [5] = {.lex_state = 4, .external_lex_state = 2},
  [6] = {.lex_state = 4, .external_lex_state = 2},
  [7] = {.lex_state = 125, .external_lex_state = 2},
  [8] = {.lex_state = 125, .external_lex_state = 2},
  [9] = {.lex_state = 125, .external_lex_state = 2},
  [10] = {.lex_state = 125, .external_lex_state = 2},
  [11] = {.lex_state = 125, .external_lex_state = 2},
  [12] = {.lex_state = 125, .external_lex_state = 2},
  [13] = {.lex_state = 125, .external_lex_state = 2},
  [14] = {.lex_state = 125, .external_lex_state = 2},
  [15] = {.lex_state = 125, .external_lex_state = 2},
  [16] = {.lex_state = 125, .external_lex_state = 2},
  [17] = {.lex_state = 125, .external_lex_state = 2},
  [18] = {.lex_state = 125, .external_lex_state = 2},
  [19] = {.lex_state = 125, .external_lex_state = 2},
  [20] = {.lex_state = 125, .external_lex_state = 2},
  [21] = {.lex_state = 125, .external_lex_state = 2},
  [22] = {.lex_state = 125, .external_lex_state = 2},
  [23] = {.lex_state = 125, .external_lex_state = 2},
  [24] = {.lex_state = 125, .external_lex_state = 2},
  [25] = {.lex_state = 125, .external_lex_state = 2},
  [26] = {.lex_state = 125, .external_lex_state = 2},
  [27] = {.lex_state = 125, .external_lex_state = 2},
  [28] = {.lex_state = 125, .external_lex_state = 2},
  [29] = {.lex_state = 125, .external_lex_state = 2},
  [30] = {.lex_state = 125, .external_lex_state = 2},
  [31] = {.lex_state = 125, .external_lex_state = 2},
  [32] = {.lex_state = 125, .external_lex_state = 2},
  [33] = {.lex_state = 125, .external_lex_state = 2},
  [34] = {.lex_state = 125, .external_lex_state = 2},
  [35] = {.lex_state = 125, .external_lex_state = 2},
  [36] = {.lex_state = 125, .external_lex_state = 2},
  [37] = {.lex_state = 125, .external_lex_state = 2},
  [38] = {.lex_state = 125, .external_lex_state = 2},
  [39] = {.lex_state = 125, .external_lex_state = 2},
  [40] = {.lex_state = 125, .external_lex_state = 2},
  [41] = {.lex_state = 125, .external_lex_state = 2},
  [42] = {.lex_state = 125, .external_lex_state = 2},
  [43] = {.lex_state = 125, .external_lex_state = 2},
  [44] = {.lex_state = 125, .external_lex_state = 2},
  [45] = {.lex_state = 125, .external_lex_state = 2},
  [46] = {.lex_state = 125, .external_lex_state = 2},
  [47] = {.lex_state = 125, .external_lex_state = 2},
  [48] = {.lex_state = 125, .external_lex_state = 2},
  [49] = {.lex_state = 125, .external_lex_state = 2},
  [50] = {.lex_state = 125, .external_lex_state = 2},
  [51] = {.lex_state = 125, .external_lex_state = 2},
  [52] = {.lex_state = 125, .external_lex_state = 2},
  [53] = {.lex_state = 125, .external_lex_state = 2},
  [54] = {.lex_state = 125, .external_lex_state = 2},
  [55] = {.lex_state = 125, .external_lex_state = 2},
  [56] = {.lex_state = 124, .external_lex_state = 3},
  [57] = {.lex_state = 124, .external_lex_state = 4},
  [58] = {.lex_state = 124, .external_lex_state = 4},
  [59] = {.lex_state = 124, .external_lex_state = 3},
  [60] = {.lex_state = 124, .external_lex_state = 3},
  [61] = {.lex_state = 124, .external_lex_state = 4},
  [62] = {.lex_state = 124, .external_lex_state = 4},
  [63] = {.lex_state = 124, .external_lex_state = 4},
  [64] = {.lex_state = 124, .external_lex_state = 4},
  [65] = {.lex_state = 124, .external_lex_state = 4},
  [66] = {.lex_state = 124, .external_lex_state = 4},
  [67] = {.lex_state = 124, .external_lex_state = 4},
  [68] = {.lex_state = 124, .external_lex_state = 4},
  [69] = {.lex_state = 124, .external_lex_state = 4},
  [70] = {.lex_state = 124, .external_lex_state = 4},
  [71] = {.lex_state = 124, .external_lex_state = 4},
  [72] = {.lex_state = 124, .external_lex_state = 4},
  [73] = {.lex_state = 124, .external_lex_state = 4},
  [74] = {.lex_state = 124, .external_lex_state = 4},
  [75] = {.lex_state = 124, .external_lex_state = 4},
  [76] = {.lex_state = 125, .external_lex_state = 2},
  [77] = {.lex_state = 125, .external_lex_state = 2},
  [78] = {.lex_state = 125, .external_lex_state = 2},
  [79] = {.lex_state = 125, .external_lex_state = 2},
  [80] = {.lex_state = 125, .external_lex_state = 2},
  [81] = {.lex_state = 125, .external_lex_state = 2},
  [82] = {.lex_state = 125, .external_lex_state = 2},
  [83] = {.lex_state = 125, .external_lex_state = 2},
  [84] = {.lex_state = 125, .external_lex_state = 2},
  [85] = {.lex_state = 125, .external_lex_state = 2},
  [86] = {.lex_state = 125, .external_lex_state = 2},
  [87] = {.lex_state = 125, .external_lex_state = 2},
  [88] = {.lex_state = 125, .external_lex_state = 2},
  [89] = {.lex_state = 125, .external_lex_state = 2},
  [90] = {.lex_state = 125, .external_lex_state = 2},
  [91] = {.lex_state = 125, .external_lex_state = 2},
  [92] = {.lex_state = 125, .external_lex_state = 2},
  [93] = {.lex_state = 125, .external_lex_state = 2},
  [94] = {.lex_state = 125, .external_lex_state = 2},
  [95] = {.lex_state = 125, .external_lex_state = 2},
  [96] = {.lex_state = 125, .external_lex_state = 2},
  [97] = {.lex_state = 125, .external_lex_state = 2},
  [98] = {.lex_state = 125, .external_lex_state = 2},
  [99] = {.lex_state = 125, .external_lex_state = 2},
  [100] = {.lex_state = 125, .external_lex_state = 2},
  [101] = {.lex_state = 125, .external_lex_state = 2},
  [102] = {.lex_state = 125, .external_lex_state = 2},
  [103] = {.lex_state = 125, .external_lex_state = 2},
  [104] = {.lex_state = 125, .external_lex_state = 2},
  [105] = {.lex_state = 125, .external_lex_state = 2},
  [106] = {.lex_state = 125, .external_lex_state = 2},
  [107] = {.lex_state = 125, .external_lex_state = 2},
  [108] = {.lex_state = 125, .external_lex_state = 2},
  [109] = {.lex_state = 125, .external_lex_state = 5},
  [110] = {.lex_state = 125, .external_lex_state = 2},
  [111] = {.lex_state = 125, .external_lex_state = 2},
  [112] = {.lex_state = 125, .external_lex_state = 2},
  [113] = {.lex_state = 125, .external_lex_state = 2},
  [114] = {.lex_state = 125, .external_lex_state = 2},
  [115] = {.lex_state = 125, .external_lex_state = 2},
  [116] = {.lex_state = 125, .external_lex_state = 2},
  [117] = {.lex_state = 125, .external_lex_state = 2},
  [118] = {.lex_state = 125, .external_lex_state = 2},
  [119] = {.lex_state = 125, .external_lex_state = 2},
  [120] = {.lex_state = 125, .external_lex_state = 2},
  [121] = {.lex_state = 125, .external_lex_state = 2},
  [122] = {.lex_state = 125, .external_lex_state = 2},
  [123] = {.lex_state = 125, .external_lex_state = 2},
  [124] = {.lex_state = 125, .external_lex_state = 2},
  [125] = {.lex_state = 125, .external_lex_state = 2},
  [126] = {.lex_state = 125, .external_lex_state = 2},
  [127] = {.lex_state = 125, .external_lex_state = 2},
  [128] = {.lex_state = 125, .external_lex_state = 2},
  [129] = {.lex_state = 125, .external_lex_state = 2},
  [130] = {.lex_state = 125, .external_lex_state = 2},
  [131] = {.lex_state = 5, .external_lex_state = 2},
  [132] = {.lex_state = 6, .external_lex_state = 4},
  [133] = {.lex_state = 125, .external_lex_state = 2},
  [134] = {.lex_state = 6, .external_lex_state = 4},
  [135] = {.lex_state = 125, .external_lex_state = 2},
  [136] = {.lex_state = 5, .external_lex_state = 2},
  [137] = {.lex_state = 125, .external_lex_state = 2},
  [138] = {.lex_state = 6, .external_lex_state = 4},
  [139] = {.lex_state = 125, .external_lex_state = 2},
  [140] = {.lex_state = 125, .external_lex_state = 2},
  [141] = {.lex_state = 125, .external_lex_state = 2},
  [142] = {.lex_state = 125, .external_lex_state = 2},
  [143] = {.lex_state = 5, .external_lex_state = 2},
  [144] = {.lex_state = 125, .external_lex_state = 2},
  [145] = {.lex_state = 125, .external_lex_state = 2},
  [146] = {.lex_state = 125, .external_lex_state = 2},
  [147] = {.lex_state = 125, .external_lex_state = 2},
  [148] = {.lex_state = 125, .external_lex_state = 2},
  [149] = {.lex_state = 125, .external_lex_state = 2},
  [150] = {.lex_state = 125, .external_lex_state = 2},
  [151] = {.lex_state = 125, .external_lex_state = 2},
  [152] = {.lex_state = 125, .external_lex_state = 2},
  [153] = {.lex_state = 125, .external_lex_state = 2},
  [154] = {.lex_state = 125, .external_lex_state = 2},
  [155] = {.lex_state = 125, .external_lex_state = 2},
  [156] = {.lex_state = 125, .external_lex_state = 2},
  [157] = {.lex_state = 125, .external_lex_state = 2},
  [158] = {.lex_state = 125, .external_lex_state = 2},
  [159] = {.lex_state = 125, .external_lex_state = 2},
  [160] = {.lex_state = 125, .external_lex_state = 2},
  [161] = {.lex_state = 125, .external_lex_state = 2},
  [162] = {.lex_state = 5, .external_lex_state = 2},
  [163] = {.lex_state = 125, .external_lex_state = 2},
  [164] = {.lex_state = 125, .external_lex_state = 2},
  [165] = {.lex_state = 125, .external_lex_state = 2},
  [166] = {.lex_state = 125, .external_lex_state = 2},
  [167] = {.lex_state = 125, .external_lex_state = 2},
  [168] = {.lex_state = 125, .external_lex_state = 2},
  [169] = {.lex_state = 125, .external_lex_state = 2},
  [170] = {.lex_state = 125, .external_lex_state = 2},
  [171] = {.lex_state = 125, .external_lex_state = 2},
  [172] = {.lex_state = 5, .external_lex_state = 2},
  [173] = {.lex_state = 125, .external_lex_state = 2},
  [174] = {.lex_state = 125, .external_lex_state = 2},
  [175] = {.lex_state = 125, .external_lex_state = 2},
  [176] = {.lex_state = 125, .external_lex_state = 2},
  [177] = {.lex_state = 125, .external_lex_state = 2},
  [178] = {.lex_state = 125, .external_lex_state = 2},
  [179] = {.lex_state = 125, .external_lex_state = 2},
  [180] = {.lex_state = 125, .external_lex_state = 2},
  [181] = {.lex_state = 125, .external_lex_state = 2},
  [182] = {.lex_state = 125, .external_lex_state = 2},
  [183] = {.lex_state = 125, .external_lex_state = 2},
  [184] = {.lex_state = 125, .external_lex_state = 2},
  [185] = {.lex_state = 125, .external_lex_state = 2},
  [186] = {.lex_state = 125, .external_lex_state = 2},
  [187] = {.lex_state = 125, .external_lex_state = 2},
  [188] = {.lex_state = 125, .external_lex_state = 2},
  [189] = {.lex_state = 125, .external_lex_state = 2},
  [190] = {.lex_state = 125, .external_lex_state = 2},
  [191] = {.lex_state = 125, .external_lex_state = 2},
  [192] = {.lex_state = 125, .external_lex_state = 2},
  [193] = {.lex_state = 125, .external_lex_state = 2},
  [194] = {.lex_state = 125, .external_lex_state = 2},
  [195] = {.lex_state = 125, .external_lex_state = 2},
  [196] = {.lex_state = 125, .external_lex_state = 2},
  [197] = {.lex_state = 125, .external_lex_state = 2},
  [198] = {.lex_state = 125, .external_lex_state = 2},
  [199] = {.lex_state = 125, .external_lex_state = 2},
  [200] = {.lex_state = 125, .external_lex_state = 2},
  [201] = {.lex_state = 125, .external_lex_state = 2},
  [202] = {.lex_state = 125, .external_lex_state = 2},
  [203] = {.lex_state = 125, .external_lex_state = 2},
  [204] = {.lex_state = 125, .external_lex_state = 2},
  [205] = {.lex_state = 125, .external_lex_state = 2},
  [206] = {.lex_state = 125, .external_lex_state = 2},
  [207] = {.lex_state = 125, .external_lex_state = 2},
  [208] = {.lex_state = 125, .external_lex_state = 2},
  [209] = {.lex_state = 125, .external_lex_state = 2},
  [210] = {.lex_state = 125, .external_lex_state = 2},
  [211] = {.lex_state = 125, .external_lex_state = 2},
  [212] = {.lex_state = 125, .external_lex_state = 2},
  [213] = {.lex_state = 125, .external_lex_state = 2},
  [214] = {.lex_state = 125, .external_lex_state = 2},
  [215] = {.lex_state = 125, .external_lex_state = 2},
  [216] = {.lex_state = 125, .external_lex_state = 2},
  [217] = {.lex_state = 125, .external_lex_state = 2},
  [218] = {.lex_state = 125, .external_lex_state = 2},
  [219] = {.lex_state = 125, .external_lex_state = 2},
  [220] = {.lex_state = 125, .external_lex_state = 2},
  [221] = {.lex_state = 125, .external_lex_state = 2},
  [222] = {.lex_state = 125, .external_lex_state = 2},
  [223] = {.lex_state = 125, .external_lex_state = 2},
  [224] = {.lex_state = 125, .external_lex_state = 2},
  [225] = {.lex_state = 125, .external_lex_state = 2},
  [226] = {.lex_state = 125, .external_lex_state = 2},
  [227] = {.lex_state = 125, .external_lex_state = 2},
  [228] = {.lex_state = 125, .external_lex_state = 2},
  [229] = {.lex_state = 125, .external_lex_state = 2},
  [230] = {.lex_state = 125, .external_lex_state = 2},
  [231] = {.lex_state = 125, .external_lex_state = 2},
  [232] = {.lex_state = 125, .external_lex_state = 2},
  [233] = {.lex_state = 125, .external_lex_state = 2},
  [234] = {.lex_state = 125, .external_lex_state = 2},
  [235] = {.lex_state = 125, .external_lex_state = 2},
  [236] = {.lex_state = 125, .external_lex_state = 2},
  [237] = {.lex_state = 125, .external_lex_state = 2},
  [238] = {.lex_state = 125, .external_lex_state = 2},
  [239] = {.lex_state = 125, .external_lex_state = 2},
  [240] = {.lex_state = 125, .external_lex_state = 2},
  [241] = {.lex_state = 125, .external_lex_state = 2},
  [242] = {.lex_state = 125, .external_lex_state = 2},
  [243] = {.lex_state = 125, .external_lex_state = 2},
  [244] = {.lex_state = 125, .external_lex_state = 2},
  [245] = {.lex_state = 125, .external_lex_state = 2},
  [246] = {.lex_state = 125, .external_lex_state = 2},
  [247] = {.lex_state = 125, .external_lex_state = 2},
  [248] = {.lex_state = 125, .external_lex_state = 2},
  [249] = {.lex_state = 125, .external_lex_state = 2},
  [250] = {.lex_state = 125, .external_lex_state = 2},
  [251] = {.lex_state = 125, .external_lex_state = 2},
  [252] = {.lex_state = 125, .external_lex_state = 2},
  [253] = {.lex_state = 125, .external_lex_state = 2},
  [254] = {.lex_state = 125, .external_lex_state = 2},
  [255] = {.lex_state = 125, .external_lex_state = 2},
  [256] = {.lex_state = 125, .external_lex_state = 2},
  [257] = {.lex_state = 125, .external_lex_state = 2},
  [258] = {.lex_state = 125, .external_lex_state = 2},
  [259] = {.lex_state = 125, .external_lex_state = 2},
  [260] = {.lex_state = 125, .external_lex_state = 2},
  [261] = {.lex_state = 125, .external_lex_state = 2},
  [262] = {.lex_state = 125, .external_lex_state = 2},
  [263] = {.lex_state = 125, .external_lex_state = 2},
  [264] = {.lex_state = 125, .external_lex_state = 2},
  [265] = {.lex_state = 125, .external_lex_state = 2},
  [266] = {.lex_state = 125, .external_lex_state = 2},
  [267] = {.lex_state = 125, .external_lex_state = 2},
  [268] = {.lex_state = 125, .external_lex_state = 2},
  [269] = {.lex_state = 125, .external_lex_state = 2},
  [270] = {.lex_state = 125, .external_lex_state = 2},
  [271] = {.lex_state = 125, .external_lex_state = 2},
  [272] = {.lex_state = 125, .external_lex_state = 2},
  [273] = {.lex_state = 125, .external_lex_state = 2},
  [274] = {.lex_state = 125, .external_lex_state = 2},
  [275] = {.lex_state = 125, .external_lex_state = 2},
  [276] = {.lex_state = 125, .external_lex_state = 2},
  [277] = {.lex_state = 125, .external_lex_state = 2},
  [278] = {.lex_state = 125, .external_lex_state = 2},
  [279] = {.lex_state = 125, .external_lex_state = 2},
  [280] = {.lex_state = 125, .external_lex_state = 2},
  [281] = {.lex_state = 125, .external_lex_state = 2},
  [282] = {.lex_state = 125, .external_lex_state = 2},
  [283] = {.lex_state = 125, .external_lex_state = 2},
  [284] = {.lex_state = 125, .external_lex_state = 2},
  [285] = {.lex_state = 125, .external_lex_state = 2},
  [286] = {.lex_state = 125, .external_lex_state = 2},
  [287] = {.lex_state = 125, .external_lex_state = 2},
  [288] = {.lex_state = 125, .external_lex_state = 2},
  [289] = {.lex_state = 125, .external_lex_state = 2},
  [290] = {.lex_state = 125, .external_lex_state = 2},
  [291] = {.lex_state = 125, .external_lex_state = 2},
  [292] = {.lex_state = 125, .external_lex_state = 2},
  [293] = {.lex_state = 125, .external_lex_state = 2},
  [294] = {.lex_state = 125, .external_lex_state = 2},
  [295] = {.lex_state = 125, .external_lex_state = 2},
  [296] = {.lex_state = 125, .external_lex_state = 2},
  [297] = {.lex_state = 125, .external_lex_state = 2},
  [298] = {.lex_state = 6, .external_lex_state = 4},
  [299] = {.lex_state = 6, .external_lex_state = 4},
  [300] = {.lex_state = 6, .external_lex_state = 4},
  [301] = {.lex_state = 6, .external_lex_state = 4},
  [302] = {.lex_state = 6, .external_lex_state = 4},
  [303] = {.lex_state = 6, .external_lex_state = 4},
  [304] = {.lex_state = 6, .external_lex_state = 4},
  [305] = {.lex_state = 6, .external_lex_state = 4},
  [306] = {.lex_state = 6, .external_lex_state = 4},
  [307] = {.lex_state = 6, .external_lex_state = 4},
  [308] = {.lex_state = 6, .external_lex_state = 4},
  [309] = {.lex_state = 6, .external_lex_state = 3},
  [310] = {.lex_state = 6, .external_lex_state = 3},
  [311] = {.lex_state = 125, .external_lex_state = 5},
  [312] = {.lex_state = 125, .external_lex_state = 5},
  [313] = {.lex_state = 6, .external_lex_state = 4},
  [314] = {.lex_state = 6, .external_lex_state = 4},
  [315] = {.lex_state = 6, .external_lex_state = 4},
  [316] = {.lex_state = 6, .external_lex_state = 3},
  [317] = {.lex_state = 6, .external_lex_state = 4},
  [318] = {.lex_state = 6, .external_lex_state = 4},
  [319] = {.lex_state = 6, .external_lex_state = 3},
  [320] = {.lex_state = 6, .external_lex_state = 4},
  [321] = {.lex_state = 6, .external_lex_state = 4},
  [322] = {.lex_state = 6, .external_lex_state = 4},
  [323] = {.lex_state = 6, .external_lex_state = 4},
  [324] = {.lex_state = 125, .external_lex_state = 2},
  [325] = {.lex_state = 6, .external_lex_state = 3},
  [326] = {.lex_state = 125, .external_lex_state = 2},
  [327] = {.lex_state = 125, .external_lex_state = 2},
  [328] = {.lex_state = 6, .external_lex_state = 3},
  [329] = {.lex_state = 6, .external_lex_state = 3},
  [330] = {.lex_state = 6, .external_lex_state = 3},
  [331] = {.lex_state = 6, .external_lex_state = 3},
  [332] = {.lex_state = 6, .external_lex_state = 4},
  [333] = {.lex_state = 125, .external_lex_state = 2},
  [334] = {.lex_state = 6, .external_lex_state = 4},
  [335] = {.lex_state = 125, .external_lex_state = 5},
  [336] = {.lex_state = 125, .external_lex_state = 5},
  [337] = {.lex_state = 125, .external_lex_state = 5},
  [338] = {.lex_state = 125, .external_lex_state = 5},
  [339] = {.lex_state = 125, .external_lex_state = 2},
  [340] = {.lex_state = 125, .external_lex_state = 5},
  [341] = {.lex_state = 125, .external_lex_state = 5},
  [342] = {.lex_state = 125, .external_lex_state = 2},
  [343] = {.lex_state = 6, .external_lex_state = 4},
  [344] = {.lex_state = 6, .external_lex_state = 3},
  [345] = {.lex_state = 125, .external_lex_state = 2},
  [346] = {.lex_state = 125, .external_lex_state = 2},
  [347] = {.lex_state = 125, .external_lex_state = 5},
  [348] = {.lex_state = 125, .external_lex_state = 5},
  [349] = {.lex_state = 125, .external_lex_state = 5},
  [350] = {.lex_state = 125, .external_lex_state = 5},
  [351] = {.lex_state = 125, .external_lex_state = 5},
  [352] = {.lex_state = 6, .external_lex_state = 4},
  [353] = {.lex_state = 125, .external_lex_state = 5},
  [354] = {.lex_state = 125, .external_lex_state = 5},
  [355] = {.lex_state = 125, .external_lex_state = 5},
  [356] = {.lex_state = 6, .external_lex_state = 3},
  [357] = {.lex_state = 6, .external_lex_state = 3},
  [358] = {.lex_state = 125, .external_lex_state = 5},
  [359] = {.lex_state = 125, .external_lex_state = 5},
  [360] = {.lex_state = 125, .external_lex_state = 2},
  [361] = {.lex_state = 125, .external_lex_state = 2},
  [362] = {.lex_state = 125, .external_lex_state = 2},
  [363] = {.lex_state = 125, .external_lex_state = 2},
  [364] = {.lex_state = 125, .external_lex_state = 2},
  [365] = {.lex_state = 125, .external_lex_state = 2},
  [366] = {.lex_state = 125, .external_lex_state = 2},
  [367] = {.lex_state = 125, .external_lex_state = 2},
  [368] = {.lex_state = 125, .external_lex_state = 2},
  [369] = {.lex_state = 125, .external_lex_state = 2},
  [370] = {.lex_state = 125, .external_lex_state = 2},
  [371] = {.lex_state = 125, .external_lex_state = 2},
  [372] = {.lex_state = 125, .external_lex_state = 2},
  [373] = {.lex_state = 125, .external_lex_state = 2},
  [374] = {.lex_state = 125, .external_lex_state = 2},
  [375] = {.lex_state = 125, .external_lex_state = 2},
  [376] = {.lex_state = 125, .external_lex_state = 2},
  [377] = {.lex_state = 125, .external_lex_state = 2},
  [378] = {.lex_state = 125, .external_lex_state = 2},
  [379] = {.lex_state = 125, .external_lex_state = 2},
  [380] = {.lex_state = 125, .external_lex_state = 2},
  [381] = {.lex_state = 125, .external_lex_state = 2},
  [382] = {.lex_state = 125, .external_lex_state = 2},
  [383] = {.lex_state = 125, .external_lex_state = 2},
  [384] = {.lex_state = 125, .external_lex_state = 2},
  [385] = {.lex_state = 125, .external_lex_state = 2},
  [386] = {.lex_state = 125, .external_lex_state = 2},
  [387] = {.lex_state = 125, .external_lex_state = 2},
  [388] = {.lex_state = 125, .external_lex_state = 2},
  [389] = {.lex_state = 125, .external_lex_state = 2},
  [390] = {.lex_state = 125, .external_lex_state = 2},
  [391] = {.lex_state = 125, .external_lex_state = 2},
  [392] = {.lex_state = 125, .external_lex_state = 2},
  [393] = {.lex_state = 125, .external_lex_state = 2},
  [394] = {.lex_state = 125, .external_lex_state = 2},
  [395] = {.lex_state = 125, .external_lex_state = 2},
  [396] = {.lex_state = 125, .external_lex_state = 2},
  [397] = {.lex_state = 125, .external_lex_state = 2},
  [398] = {.lex_state = 125, .external_lex_state = 2},
  [399] = {.lex_state = 125, .external_lex_state = 2},
  [400] = {.lex_state = 125, .external_lex_state = 2},
  [401] = {.lex_state = 125, .external_lex_state = 2},
  [402] = {.lex_state = 125, .external_lex_state = 2},
  [403] = {.lex_state = 125, .external_lex_state = 2},
  [404] = {.lex_state = 125, .external_lex_state = 2},
  [405] = {.lex_state = 125, .external_lex_state = 2},
  [406] = {.lex_state = 125, .external_lex_state = 2},
  [407] = {.lex_state = 125, .external_lex_state = 2},
  [408] = {.lex_state = 125, .external_lex_state = 2},
  [409] = {.lex_state = 125, .external_lex_state = 2},
  [410] = {.lex_state = 6, .external_lex_state = 3},
  [411] = {.lex_state = 125, .external_lex_state = 2},
  [412] = {.lex_state = 125, .external_lex_state = 2},
  [413] = {.lex_state = 125, .external_lex_state = 2},
  [414] = {.lex_state = 125, .external_lex_state = 2},
  [415] = {.lex_state = 125, .external_lex_state = 2},
  [416] = {.lex_state = 125, .external_lex_state = 2},
  [417] = {.lex_state = 125, .external_lex_state = 2},
  [418] = {.lex_state = 125, .external_lex_state = 2},
  [419] = {.lex_state = 125, .external_lex_state = 2},
  [420] = {.lex_state = 125, .external_lex_state = 2},
  [421] = {.lex_state = 125, .external_lex_state = 2},
  [422] = {.lex_state = 125, .external_lex_state = 2},
  [423] = {.lex_state = 125, .external_lex_state = 2},
  [424] = {.lex_state = 125, .external_lex_state = 2},
  [425] = {.lex_state = 125, .external_lex_state = 2},
  [426] = {.lex_state = 6, .external_lex_state = 4},
  [427] = {.lex_state = 6, .external_lex_state = 3},
  [428] = {.lex_state = 6, .external_lex_state = 3},
  [429] = {.lex_state = 6, .external_lex_state = 3},
  [430] = {.lex_state = 6, .external_lex_state = 3},
  [431] = {.lex_state = 6, .external_lex_state = 3},
  [432] = {.lex_state = 6, .external_lex_state = 4},
  [433] = {.lex_state = 6, .external_lex_state = 3},
  [434] = {.lex_state = 6, .external_lex_state = 4},
  [435] = {.lex_state = 6, .external_lex_state = 3},
  [436] = {.lex_state = 6, .external_lex_state = 3},
  [437] = {.lex_state = 6, .external_lex_state = 4},
  [438] = {.lex_state = 6, .external_lex_state = 3},
  [439] = {.lex_state = 6, .external_lex_state = 3},
  [440] = {.lex_state = 6, .external_lex_state = 3},
  [441] = {.lex_state = 6, .external_lex_state = 3},
  [442] = {.lex_state = 6, .external_lex_state = 3},
  [443] = {.lex_state = 6, .external_lex_state = 3},
  [444] = {.lex_state = 125, .external_lex_state = 2},
  [445] = {.lex_state = 6, .external_lex_state = 4},
  [446] = {.lex_state = 6, .external_lex_state = 4},
  [447] = {.lex_state = 6, .external_lex_state = 4},
  [448] = {.lex_state = 125, .external_lex_state = 2},
  [449] = {.lex_state = 6, .external_lex_state = 4},
  [450] = {.lex_state = 6, .external_lex_state = 4},
  [451] = {.lex_state = 6, .external_lex_state = 4},
  [452] = {.lex_state = 6, .external_lex_state = 4},
  [453] = {.lex_state = 6, .external_lex_state = 4},
  [454] = {.lex_state = 6, .external_lex_state = 4},
  [455] = {.lex_state = 6, .external_lex_state = 3},
  [456] = {.lex_state = 6, .external_lex_state = 4},
  [457] = {.lex_state = 6, .external_lex_state = 4},
  [458] = {.lex_state = 6, .external_lex_state = 4},
  [459] = {.lex_state = 125, .external_lex_state = 2},
  [460] = {.lex_state = 6, .external_lex_state = 4},
  [461] = {.lex_state = 6, .external_lex_state = 4},
  [462] = {.lex_state = 125, .external_lex_state = 2},
  [463] = {.lex_state = 125, .external_lex_state = 2},
  [464] = {.lex_state = 6, .external_lex_state = 3},
  [465] = {.lex_state = 125, .external_lex_state = 2},
  [466] = {.lex_state = 6, .external_lex_state = 3},
  [467] = {.lex_state = 6, .external_lex_state = 3},
  [468] = {.lex_state = 6, .external_lex_state = 3},
  [469] = {.lex_state = 6, .external_lex_state = 3},
  [470] = {.lex_state = 6, .external_lex_state = 4},
  [471] = {.lex_state = 6, .external_lex_state = 4},
  [472] = {.lex_state = 125, .external_lex_state = 2},
  [473] = {.lex_state = 125, .external_lex_state = 2},
  [474] = {.lex_state = 125, .external_lex_state = 2},
  [475] = {.lex_state = 6, .external_lex_state = 4},
  [476] = {.lex_state = 6, .external_lex_state = 4},
  [477] = {.lex_state = 6, .external_lex_state = 4},
  [478] = {.lex_state = 6, .external_lex_state = 4},
  [479] = {.lex_state = 6, .external_lex_state = 3},
  [480] = {.lex_state = 6, .external_lex_state = 3},
  [481] = {.lex_state = 6, .external_lex_state = 4},
  [482] = {.lex_state = 6, .external_lex_state = 3},
  [483] = {.lex_state = 6, .external_lex_state = 3},
  [484] = {.lex_state = 6, .external_lex_state = 3},
  [485] = {.lex_state = 6, .external_lex_state = 3},
  [486] = {.lex_state = 6, .external_lex_state = 3},
  [487] = {.lex_state = 6, .external_lex_state = 4},
  [488] = {.lex_state = 6, .external_lex_state = 3},
  [489] = {.lex_state = 6, .external_lex_state = 3},
  [490] = {.lex_state = 6, .external_lex_state = 3},
  [491] = {.lex_state = 6, .external_lex_state = 3},
  [492] = {.lex_state = 6, .external_lex_state = 3},
  [493] = {.lex_state = 6, .external_lex_state = 3},
  [494] = {.lex_state = 6, .external_lex_state = 3},
  [495] = {.lex_state = 6, .external_lex_state = 3},
  [496] = {.lex_state = 6, .external_lex_state = 3},
  [497] = {.lex_state = 6, .external_lex_state = 3},
  [498] = {.lex_state = 6, .external_lex_state = 3},
  [499] = {.lex_state = 6, .external_lex_state = 3},
  [500] = {.lex_state = 6, .external_lex_state = 3},
  [501] = {.lex_state = 6, .external_lex_state = 3},
  [502] = {.lex_state = 6, .external_lex_state = 3},
  [503] = {.lex_state = 124, .external_lex_state = 3},
  [504] = {.lex_state = 124, .external_lex_state = 3},
  [505] = {.lex_state = 124, .external_lex_state = 4},
  [506] = {.lex_state = 124, .external_lex_state = 4},
  [507] = {.lex_state = 124, .external_lex_state = 3},
  [508] = {.lex_state = 124, .external_lex_state = 4},
  [509] = {.lex_state = 124, .external_lex_state = 3},
  [510] = {.lex_state = 124, .external_lex_state = 3},
  [511] = {.lex_state = 124, .external_lex_state = 3},
  [512] = {.lex_state = 124, .external_lex_state = 3},
  [513] = {.lex_state = 124, .external_lex_state = 3},
  [514] = {.lex_state = 7, .external_lex_state = 3},
  [515] = {.lex_state = 124, .external_lex_state = 3},
  [516] = {.lex_state = 124, .external_lex_state = 3},
  [517] = {.lex_state = 124, .external_lex_state = 3},
  [518] = {.lex_state = 124, .external_lex_state = 3},
  [519] = {.lex_state = 124, .external_lex_state = 3},
  [520] = {.lex_state = 124, .external_lex_state = 3},
  [521] = {.lex_state = 124, .external_lex_state = 3},
  [522] = {.lex_state = 124, .external_lex_state = 3},
  [523] = {.lex_state = 124, .external_lex_state = 3},
  [524] = {.lex_state = 124, .external_lex_state = 3},
  [525] = {.lex_state = 124, .external_lex_state = 3},
  [526] = {.lex_state = 124, .external_lex_state = 3},
  [527] = {.lex_state = 124, .external_lex_state = 3},
  [528] = {.lex_state = 124, .external_lex_state = 3},
  [529] = {.lex_state = 124, .external_lex_state = 3},
  [530] = {.lex_state = 124, .external_lex_state = 3},
  [531] = {.lex_state = 124, .external_lex_state = 3},
  [532] = {.lex_state = 124, .external_lex_state = 3},
  [533] = {.lex_state = 124, .external_lex_state = 3},
  [534] = {.lex_state = 124, .external_lex_state = 3},
  [535] = {.lex_state = 124, .external_lex_state = 3},
  [536] = {.lex_state = 124, .external_lex_state = 3},
  [537] = {.lex_state = 124, .external_lex_state = 3},
  [538] = {.lex_state = 124, .external_lex_state = 3},
  [539] = {.lex_state = 124, .external_lex_state = 3},
  [540] = {.lex_state = 124, .external_lex_state = 3},
  [541] = {.lex_state = 124, .external_lex_state = 3},
  [542] = {.lex_state = 124, .external_lex_state = 3},
  [543] = {.lex_state = 124, .external_lex_state = 3},
  [544] = {.lex_state = 124, .external_lex_state = 3},
  [545] = {.lex_state = 124, .external_lex_state = 3},
  [546] = {.lex_state = 124, .external_lex_state = 3},
  [547] = {.lex_state = 124, .external_lex_state = 3},
  [548] = {.lex_state = 124, .external_lex_state = 3},
  [549] = {.lex_state = 124, .external_lex_state = 3},
  [550] = {.lex_state = 124, .external_lex_state = 3},
  [551] = {.lex_state = 124, .external_lex_state = 3},
  [552] = {.lex_state = 124, .external_lex_state = 3},
  [553] = {.lex_state = 124, .external_lex_state = 3},
  [554] = {.lex_state = 124, .external_lex_state = 3},
  [555] = {.lex_state = 124, .external_lex_state = 3},
  [556] = {.lex_state = 124, .external_lex_state = 3},
  [557] = {.lex_state = 124, .external_lex_state = 3},
  [558] = {.lex_state = 124, .external_lex_state = 3},
  [559] = {.lex_state = 124, .external_lex_state = 3},
  [560] = {.lex_state = 124, .external_lex_state = 3},
  [561] = {.lex_state = 124, .external_lex_state = 3},
  [562] = {.lex_state = 124, .external_lex_state = 3},
  [563] = {.lex_state = 124, .external_lex_state = 3},
  [564] = {.lex_state = 124, .external_lex_state = 3},
  [565] = {.lex_state = 124, .external_lex_state = 3},
  [566] = {.lex_state = 124, .external_lex_state = 3},
  [567] = {.lex_state = 124, .external_lex_state = 3},
  [568] = {.lex_state = 124, .external_lex_state = 3},
  [569] = {.lex_state = 124, .external_lex_state = 3},
  [570] = {.lex_state = 124, .external_lex_state = 3},
  [571] = {.lex_state = 124, .external_lex_state = 3},
  [572] = {.lex_state = 124, .external_lex_state = 3},
  [573] = {.lex_state = 124, .external_lex_state = 3},
  [574] = {.lex_state = 124, .external_lex_state = 3},
  [575] = {.lex_state = 124, .external_lex_state = 3},
  [576] = {.lex_state = 124, .external_lex_state = 3},
  [577] = {.lex_state = 124, .external_lex_state = 3},
  [578] = {.lex_state = 124, .external_lex_state = 3},
  [579] = {.lex_state = 124, .external_lex_state = 4},
  [580] = {.lex_state = 124, .external_lex_state = 3},
  [581] = {.lex_state = 124, .external_lex_state = 3},
  [582] = {.lex_state = 124, .external_lex_state = 3},
  [583] = {.lex_state = 124, .external_lex_state = 3},
  [584] = {.lex_state = 124, .external_lex_state = 4},
  [585] = {.lex_state = 124, .external_lex_state = 3},
  [586] = {.lex_state = 124, .external_lex_state = 3},
  [587] = {.lex_state = 124, .external_lex_state = 3},
  [588] = {.lex_state = 124, .external_lex_state = 3},
  [589] = {.lex_state = 124, .external_lex_state = 3},
  [590] = {.lex_state = 124, .external_lex_state = 3},
  [591] = {.lex_state = 124, .external_lex_state = 3},
  [592] = {.lex_state = 124, .external_lex_state = 3},
  [593] = {.lex_state = 124, .external_lex_state = 3},
  [594] = {.lex_state = 124, .external_lex_state = 3},
  [595] = {.lex_state = 124, .external_lex_state = 3},
  [596] = {.lex_state = 124, .external_lex_state = 3},
  [597] = {.lex_state = 124, .external_lex_state = 3},
  [598] = {.lex_state = 124, .external_lex_state = 3},
  [599] = {.lex_state = 124, .external_lex_state = 3},
  [600] = {.lex_state = 124, .external_lex_state = 3},
  [601] = {.lex_state = 124, .external_lex_state = 3},
  [602] = {.lex_state = 124, .external_lex_state = 3},
  [603] = {.lex_state = 124, .external_lex_state = 3},
  [604] = {.lex_state = 124, .external_lex_state = 4},
  [605] = {.lex_state = 124, .external_lex_state = 4},
  [606] = {.lex_state = 124, .external_lex_state = 4},
  [607] = {.lex_state = 124, .external_lex_state = 3},
  [608] = {.lex_state = 124, .external_lex_state = 4},
  [609] = {.lex_state = 124, .external_lex_state = 4},
  [610] = {.lex_state = 124, .external_lex_state = 4},
  [611] = {.lex_state = 124, .external_lex_state = 4},
  [612] = {.lex_state = 124, .external_lex_state = 4},
  [613] = {.lex_state = 124, .external_lex_state = 4},
  [614] = {.lex_state = 124, .external_lex_state = 4},
  [615] = {.lex_state = 124, .external_lex_state = 4},
  [616] = {.lex_state = 124, .external_lex_state = 4},
  [617] = {.lex_state = 124, .external_lex_state = 4},
  [618] = {.lex_state = 124, .external_lex_state = 4},
  [619] = {.lex_state = 124, .external_lex_state = 4},
  [620] = {.lex_state = 124, .external_lex_state = 4},
  [621] = {.lex_state = 124, .external_lex_state = 4},
  [622] = {.lex_state = 124, .external_lex_state = 4},
  [623] = {.lex_state = 124, .external_lex_state = 4},
  [624] = {.lex_state = 124, .external_lex_state = 4},
  [625] = {.lex_state = 124, .external_lex_state = 4},
  [626] = {.lex_state = 124, .external_lex_state = 4},
  [627] = {.lex_state = 124, .external_lex_state = 4},
  [628] = {.lex_state = 124, .external_lex_state = 4},
  [629] = {.lex_state = 124, .external_lex_state = 4},
  [630] = {.lex_state = 124, .external_lex_state = 4},
  [631] = {.lex_state = 124, .external_lex_state = 4},
  [632] = {.lex_state = 124, .external_lex_state = 3},
  [633] = {.lex_state = 124, .external_lex_state = 4},
  [634] = {.lex_state = 124, .external_lex_state = 4},
  [635] = {.lex_state = 124, .external_lex_state = 4},
  [636] = {.lex_state = 124, .external_lex_state = 4},
  [637] = {.lex_state = 124, .external_lex_state = 4},
  [638] = {.lex_state = 124, .external_lex_state = 4},
  [639] = {.lex_state = 124, .external_lex_state = 4},
  [640] = {.lex_state = 124, .external_lex_state = 4},
  [641] = {.lex_state = 124, .external_lex_state = 4},
  [642] = {.lex_state = 124, .external_lex_state = 4},
  [643] = {.lex_state = 124, .external_lex_state = 4},
  [644] = {.lex_state = 124, .external_lex_state = 4},
  [645] = {.lex_state = 124, .external_lex_state = 3},
  [646] = {.lex_state = 124, .external_lex_state = 4},
  [647] = {.lex_state = 124, .external_lex_state = 4},
  [648] = {.lex_state = 124, .external_lex_state = 4},
  [649] = {.lex_state = 124, .external_lex_state = 4},
  [650] = {.lex_state = 124, .external_lex_state = 4},
  [651] = {.lex_state = 124, .external_lex_state = 4},
  [652] = {.lex_state = 124, .external_lex_state = 4},
  [653] = {.lex_state = 124, .external_lex_state = 4},
  [654] = {.lex_state = 124, .external_lex_state = 4},
  [655] = {.lex_state = 124, .external_lex_state = 4},
  [656] = {.lex_state = 124, .external_lex_state = 4},
  [657] = {.lex_state = 124, .external_lex_state = 4},
  [658] = {.lex_state = 124, .external_lex_state = 4},
  [659] = {.lex_state = 124, .external_lex_state = 4},
  [660] = {.lex_state = 124, .external_lex_state = 4},
  [661] = {.lex_state = 124, .external_lex_state = 4},
  [662] = {.lex_state = 124, .external_lex_state = 4},
  [663] = {.lex_state = 124, .external_lex_state = 4},
  [664] = {.lex_state = 124, .external_lex_state = 4},
  [665] = {.lex_state = 7, .external_lex_state = 4},
  [666] = {.lex_state = 124, .external_lex_state = 4},
  [667] = {.lex_state = 124, .external_lex_state = 3},
  [668] = {.lex_state = 124, .external_lex_state = 3},
  [669] = {.lex_state = 124, .external_lex_state = 3},
  [670] = {.lex_state = 124, .external_lex_state = 4},
  [671] = {.lex_state = 124, .external_lex_state = 3},
  [672] = {.lex_state = 124, .external_lex_state = 4},
  [673] = {.lex_state = 124, .external_lex_state = 4},
  [674] = {.lex_state = 124, .external_lex_state = 4},
  [675] = {.lex_state = 124, .external_lex_state = 4},
  [676] = {.lex_state = 124, .external_lex_state = 4},
  [677] = {.lex_state = 124, .external_lex_state = 4},
  [678] = {.lex_state = 124, .external_lex_state = 4},
  [679] = {.lex_state = 124, .external_lex_state = 4},
  [680] = {.lex_state = 124, .external_lex_state = 4},
  [681] = {.lex_state = 124, .external_lex_state = 4},
  [682] = {.lex_state = 7, .external_lex_state = 4},
  [683] = {.lex_state = 124, .external_lex_state = 4},
  [684] = {.lex_state = 124, .external_lex_state = 4},
  [685] = {.lex_state = 124, .external_lex_state = 4},
  [686] = {.lex_state = 124, .external_lex_state = 4},
  [687] = {.lex_state = 124, .external_lex_state = 4},
  [688] = {.lex_state = 124, .external_lex_state = 4},
  [689] = {.lex_state = 124, .external_lex_state = 4},
  [690] = {.lex_state = 124, .external_lex_state = 4},
  [691] = {.lex_state = 124, .external_lex_state = 4},
  [692] = {.lex_state = 124, .external_lex_state = 4},
  [693] = {.lex_state = 124, .external_lex_state = 4},
  [694] = {.lex_state = 124, .external_lex_state = 4},
  [695] = {.lex_state = 124, .external_lex_state = 4},
  [696] = {.lex_state = 124, .external_lex_state = 4},
  [697] = {.lex_state = 124, .external_lex_state = 4},
  [698] = {.lex_state = 124, .external_lex_state = 4},
  [699] = {.lex_state = 124, .external_lex_state = 4},
  [700] = {.lex_state = 124, .external_lex_state = 4},
  [701] = {.lex_state = 124, .external_lex_state = 4},
  [702] = {.lex_state = 124, .external_lex_state = 4},
  [703] = {.lex_state = 124, .external_lex_state = 4},
  [704] = {.lex_state = 124, .external_lex_state = 4},
  [705] = {.lex_state = 124, .external_lex_state = 4},
  [706] = {.lex_state = 124, .external_lex_state = 4},
  [707] = {.lex_state = 124, .external_lex_state = 4},
  [708] = {.lex_state = 124, .external_lex_state = 4},
  [709] = {.lex_state = 124, .external_lex_state = 4},
  [710] = {.lex_state = 124, .external_lex_state = 4},
  [711] = {.lex_state = 124, .external_lex_state = 4},
  [712] = {.lex_state = 124, .external_lex_state = 4},
  [713] = {.lex_state = 124, .external_lex_state = 4},
  [714] = {.lex_state = 124, .external_lex_state = 4},
  [715] = {.lex_state = 124, .external_lex_state = 4},
  [716] = {.lex_state = 124, .external_lex_state = 4},
  [717] = {.lex_state = 124, .external_lex_state = 4},
  [718] = {.lex_state = 124, .external_lex_state = 4},
  [719] = {.lex_state = 124, .external_lex_state = 4},
  [720] = {.lex_state = 124, .external_lex_state = 4},
  [721] = {.lex_state = 124, .external_lex_state = 4},
  [722] = {.lex_state = 124, .external_lex_state = 4},
  [723] = {.lex_state = 124, .external_lex_state = 4},
  [724] = {.lex_state = 124, .external_lex_state = 4},
  [725] = {.lex_state = 124, .external_lex_state = 4},
  [726] = {.lex_state = 124, .external_lex_state = 4},
  [727] = {.lex_state = 124, .external_lex_state = 4},
  [728] = {.lex_state = 124, .external_lex_state = 4},
  [729] = {.lex_state = 124, .external_lex_state = 4},
  [730] = {.lex_state = 124, .external_lex_state = 4},
  [731] = {.lex_state = 124, .external_lex_state = 4},
  [732] = {.lex_state = 124, .external_lex_state = 4},
  [733] = {.lex_state = 124, .external_lex_state = 4},
  [734] = {.lex_state = 124, .external_lex_state = 4},
  [735] = {.lex_state = 124, .external_lex_state = 3},
  [736] = {.lex_state = 124, .external_lex_state = 4},
  [737] = {.lex_state = 124, .external_lex_state = 3},
  [738] = {.lex_state = 124, .external_lex_state = 4},
  [739] = {.lex_state = 124, .external_lex_state = 3},
  [740] = {.lex_state = 124, .external_lex_state = 3},
  [741] = {.lex_state = 124, .external_lex_state = 3},
  [742] = {.lex_state = 124, .external_lex_state = 3},
  [743] = {.lex_state = 124, .external_lex_state = 4},
  [744] = {.lex_state = 124, .external_lex_state = 3},
  [745] = {.lex_state = 124, .external_lex_state = 4},
  [746] = {.lex_state = 124, .external_lex_state = 4},
  [747] = {.lex_state = 124, .external_lex_state = 4},
  [748] = {.lex_state = 124, .external_lex_state = 4},
  [749] = {.lex_state = 124, .external_lex_state = 4},
  [750] = {.lex_state = 124, .external_lex_state = 3},
  [751] = {.lex_state = 124, .external_lex_state = 3},
  [752] = {.lex_state = 124, .external_lex_state = 3},
  [753] = {.lex_state = 124, .external_lex_state = 3},
  [754] = {.lex_state = 124, .external_lex_state = 3},
  [755] = {.lex_state = 124, .external_lex_state = 3},
  [756] = {.lex_state = 124, .external_lex_state = 3},
  [757] = {.lex_state = 124, .external_lex_state = 3},
  [758] = {.lex_state = 124, .external_lex_state = 4},
  [759] = {.lex_state = 124, .external_lex_state = 3},
  [760] = {.lex_state = 124, .external_lex_state = 3},
  [761] = {.lex_state = 124, .external_lex_state = 3},
  [762] = {.lex_state = 124, .external_lex_state = 3},
  [763] = {.lex_state = 124, .external_lex_state = 3},
  [764] = {.lex_state = 124, .external_lex_state = 3},
  [765] = {.lex_state = 124, .external_lex_state = 3},
  [766] = {.lex_state = 124, .external_lex_state = 3},
  [767] = {.lex_state = 124, .external_lex_state = 3},
  [768] = {.lex_state = 124, .external_lex_state = 3},
  [769] = {.lex_state = 124, .external_lex_state = 3},
  [770] = {.lex_state = 124, .external_lex_state = 3},
  [771] = {.lex_state = 124, .external_lex_state = 3},
  [772] = {.lex_state = 124, .external_lex_state = 3},
  [773] = {.lex_state = 124, .external_lex_state = 3},
  [774] = {.lex_state = 124, .external_lex_state = 3},
  [775] = {.lex_state = 124, .external_lex_state = 3},
  [776] = {.lex_state = 124, .external_lex_state = 3},
  [777] = {.lex_state = 124, .external_lex_state = 3},
  [778] = {.lex_state = 124, .external_lex_state = 3},
  [779] = {.lex_state = 124, .external_lex_state = 3},
  [780] = {.lex_state = 124, .external_lex_state = 3},
  [781] = {.lex_state = 124, .external_lex_state = 3},
  [782] = {.lex_state = 124, .external_lex_state = 3},
  [783] = {.lex_state = 124, .external_lex_state = 3},
  [784] = {.lex_state = 124, .external_lex_state = 3},
  [785] = {.lex_state = 124, .external_lex_state = 3},
  [786] = {.lex_state = 124, .external_lex_state = 3},
  [787] = {.lex_state = 124, .external_lex_state = 3},
  [788] = {.lex_state = 124, .external_lex_state = 3},
  [789] = {.lex_state = 124, .external_lex_state = 3},
  [790] = {.lex_state = 124, .external_lex_state = 3},
  [791] = {.lex_state = 124, .external_lex_state = 3},
  [792] = {.lex_state = 124, .external_lex_state = 3},
  [793] = {.lex_state = 124, .external_lex_state = 3},
  [794] = {.lex_state = 124, .external_lex_state = 3},
  [795] = {.lex_state = 124, .external_lex_state = 3},
  [796] = {.lex_state = 124, .external_lex_state = 3},
  [797] = {.lex_state = 124, .external_lex_state = 3},
  [798] = {.lex_state = 124, .external_lex_state = 3},
  [799] = {.lex_state = 124, .external_lex_state = 3},
  [800] = {.lex_state = 124, .external_lex_state = 3},
  [801] = {.lex_state = 124, .external_lex_state = 3},
  [802] = {.lex_state = 124, .external_lex_state = 3},
  [803] = {.lex_state = 124, .external_lex_state = 3},
  [804] = {.lex_state = 124, .external_lex_state = 3},
  [805] = {.lex_state = 124, .external_lex_state = 3},
  [806] = {.lex_state = 124, .external_lex_state = 3},
  [807] = {.lex_state = 124, .external_lex_state = 3},
  [808] = {.lex_state = 124, .external_lex_state = 3},
  [809] = {.lex_state = 124, .external_lex_state = 3},
  [810] = {.lex_state = 124, .external_lex_state = 3},
  [811] = {.lex_state = 124, .external_lex_state = 3},
  [812] = {.lex_state = 124, .external_lex_state = 3},
  [813] = {.lex_state = 124, .external_lex_state = 3},
  [814] = {.lex_state = 124, .external_lex_state = 3},
  [815] = {.lex_state = 124, .external_lex_state = 4},
  [816] = {.lex_state = 124, .external_lex_state = 3},
  [817] = {.lex_state = 124, .external_lex_state = 3},
  [818] = {.lex_state = 124, .external_lex_state = 3},
  [819] = {.lex_state = 124, .external_lex_state = 3},
  [820] = {.lex_state = 124, .external_lex_state = 3},
  [821] = {.lex_state = 124, .external_lex_state = 3},
  [822] = {.lex_state = 7, .external_lex_state = 3},
  [823] = {.lex_state = 4, .external_lex_state = 2},
  [824] = {.lex_state = 4, .external_lex_state = 2},
  [825] = {.lex_state = 124, .external_lex_state = 4},
  [826] = {.lex_state = 4, .external_lex_state = 2},
  [827] = {.lex_state = 4, .external_lex_state = 2},
  [828] = {.lex_state = 4, .external_lex_state = 2},
  [829] = {.lex_state = 4, .external_lex_state = 2},
  [830] = {.lex_state = 124, .external_lex_state = 3},
  [831] = {.lex_state = 124, .external_lex_state = 4},
  [832] = {.lex_state = 124, .external_lex_state = 3},
  [833] = {.lex_state = 124, .external_lex_state = 3},
  [834] = {.lex_state = 124, .external_lex_state = 3},
  [835] = {.lex_state = 124, .external_lex_state = 3},
  [836] = {.lex_state = 124, .external_lex_state = 3},
  [837] = {.lex_state = 124, .external_lex_state = 3},
  [838] = {.lex_state = 124, .external_lex_state = 3},
  [839] = {.lex_state = 124, .external_lex_state = 3},
  [840] = {.lex_state = 124, .external_lex_state = 3},
  [841] = {.lex_state = 124, .external_lex_state = 3},
  [842] = {.lex_state = 124, .external_lex_state = 3},
  [843] = {.lex_state = 124, .external_lex_state = 3},
  [844] = {.lex_state = 124, .external_lex_state = 3},
  [845] = {.lex_state = 124, .external_lex_state = 3},
  [846] = {.lex_state = 124, .external_lex_state = 3},
  [847] = {.lex_state = 124, .external_lex_state = 3},
  [848] = {.lex_state = 124, .external_lex_state = 3},
  [849] = {.lex_state = 124, .external_lex_state = 3},
  [850] = {.lex_state = 124, .external_lex_state = 3},
  [851] = {.lex_state = 124, .external_lex_state = 3},
  [852] = {.lex_state = 124, .external_lex_state = 3},
  [853] = {.lex_state = 124, .external_lex_state = 3},
  [854] = {.lex_state = 124, .external_lex_state = 3},
  [855] = {.lex_state = 124, .external_lex_state = 3},
  [856] = {.lex_state = 124, .external_lex_state = 3},
  [857] = {.lex_state = 124, .external_lex_state = 3},
  [858] = {.lex_state = 124, .external_lex_state = 3},
  [859] = {.lex_state = 124, .external_lex_state = 3},
  [860] = {.lex_state = 124, .external_lex_state = 3},
  [861] = {.lex_state = 124, .external_lex_state = 3},
  [862] = {.lex_state = 124, .external_lex_state = 3},
  [863] = {.lex_state = 124, .external_lex_state = 3},
  [864] = {.lex_state = 124, .external_lex_state = 3},
  [865] = {.lex_state = 124, .external_lex_state = 3},
  [866] = {.lex_state = 4, .external_lex_state = 2},
  [867] = {.lex_state = 124, .external_lex_state = 3},
  [868] = {.lex_state = 124, .external_lex_state = 3},
  [869] = {.lex_state = 4, .external_lex_state = 2},
  [870] = {.lex_state = 4, .external_lex_state = 2},
  [871] = {.lex_state = 4, .external_lex_state = 2},
  [872] = {.lex_state = 4, .external_lex_state = 2},
  [873] = {.lex_state = 4, .external_lex_state = 2},
  [874] = {.lex_state = 4, .external_lex_state = 2},
  [875] = {.lex_state = 4, .external_lex_state = 2},
  [876] = {.lex_state = 4, .external_lex_state = 2},
  [877] = {.lex_state = 125, .external_lex_state = 2},
  [878] = {.lex_state = 125, .external_lex_state = 2},
  [879] = {.lex_state = 4, .external_lex_state = 2},
  [880] = {.lex_state = 125, .external_lex_state = 2},
  [881] = {.lex_state = 125, .external_lex_state = 2},
  [882] = {.lex_state = 125, .external_lex_state = 2},
  [883] = {.lex_state = 125, .external_lex_state = 2},
  [884] = {.lex_state = 125, .external_lex_state = 2},
  [885] = {.lex_state = 125, .external_lex_state = 2},
  [886] = {.lex_state = 125, .external_lex_state = 2},
  [887] = {.lex_state = 125, .external_lex_state = 2},
  [888] = {.lex_state = 125, .external_lex_state = 2},
  [889] = {.lex_state = 125, .external_lex_state = 2},
  [890] = {.lex_state = 125, .external_lex_state = 2},
  [891] = {.lex_state = 125, .external_lex_state = 2},
  [892] = {.lex_state = 125, .external_lex_state = 2},
  [893] = {.lex_state = 125, .external_lex_state = 2},
  [894] = {.lex_state = 125, .external_lex_state = 2},
  [895] = {.lex_state = 125, .external_lex_state = 5},
  [896] = {.lex_state = 125, .external_lex_state = 2},
  [897] = {.lex_state = 125, .external_lex_state = 2},
  [898] = {.lex_state = 125, .external_lex_state = 2},
  [899] = {.lex_state = 125, .external_lex_state = 2},
  [900] = {.lex_state = 125, .external_lex_state = 2},
  [901] = {.lex_state = 125, .external_lex_state = 2},
  [902] = {.lex_state = 125, .external_lex_state = 2},
  [903] = {.lex_state = 4, .external_lex_state = 2},
  [904] = {.lex_state = 125, .external_lex_state = 2},
  [905] = {.lex_state = 125, .external_lex_state = 2},
  [906] = {.lex_state = 125, .external_lex_state = 5},
  [907] = {.lex_state = 125, .external_lex_state = 5},
  [908] = {.lex_state = 125, .external_lex_state = 5},
  [909] = {.lex_state = 125, .external_lex_state = 2},
  [910] = {.lex_state = 4, .external_lex_state = 2},
  [911] = {.lex_state = 125, .external_lex_state = 5},
  [912] = {.lex_state = 125, .external_lex_state = 2},
  [913] = {.lex_state = 125, .external_lex_state = 5},
  [914] = {.lex_state = 125, .external_lex_state = 2},
  [915] = {.lex_state = 4, .external_lex_state = 2},
  [916] = {.lex_state = 125, .external_lex_state = 5},
  [917] = {.lex_state = 9, .external_lex_state = 2},
  [918] = {.lex_state = 125, .external_lex_state = 5},
  [919] = {.lex_state = 125, .external_lex_state = 5},
  [920] = {.lex_state = 125, .external_lex_state = 5},
  [921] = {.lex_state = 125, .external_lex_state = 5},
  [922] = {.lex_state = 125, .external_lex_state = 2},
  [923] = {.lex_state = 125, .external_lex_state = 5},
  [924] = {.lex_state = 4, .external_lex_state = 2},
  [925] = {.lex_state = 4, .external_lex_state = 2},
  [926] = {.lex_state = 4, .external_lex_state = 2},
  [927] = {.lex_state = 4, .external_lex_state = 2},
  [928] = {.lex_state = 4, .external_lex_state = 2},
  [929] = {.lex_state = 9, .external_lex_state = 2},
  [930] = {.lex_state = 4, .external_lex_state = 2},
  [931] = {.lex_state = 4, .external_lex_state = 2},
  [932] = {.lex_state = 4, .external_lex_state = 2},
  [933] = {.lex_state = 4, .external_lex_state = 2},
  [934] = {.lex_state = 4, .external_lex_state = 2},
  [935] = {.lex_state = 4, .external_lex_state = 2},
  [936] = {.lex_state = 4, .external_lex_state = 2},
  [937] = {.lex_state = 4, .external_lex_state = 2},
  [938] = {.lex_state = 4, .external_lex_state = 2},
  [939] = {.lex_state = 4, .external_lex_state = 2},
  [940] = {.lex_state = 4, .external_lex_state = 2},
  [941] = {.lex_state = 4, .external_lex_state = 2},
  [942] = {.lex_state = 4, .external_lex_state = 2},
  [943] = {.lex_state = 4, .external_lex_state = 2},
  [944] = {.lex_state = 4, .external_lex_state = 2},
  [945] = {.lex_state = 4, .external_lex_state = 2},
  [946] = {.lex_state = 4, .external_lex_state = 2},
  [947] = {.lex_state = 4, .external_lex_state = 2},
  [948] = {.lex_state = 4, .external_lex_state = 5},
  [949] = {.lex_state = 4, .external_lex_state = 2},
  [950] = {.lex_state = 4, .external_lex_state = 2},
  [951] = {.lex_state = 4, .external_lex_state = 2},
  [952] = {.lex_state = 4, .external_lex_state = 2},
  [953] = {.lex_state = 4, .external_lex_state = 5},
  [954] = {.lex_state = 4, .external_lex_state = 2},
  [955] = {.lex_state = 4, .external_lex_state = 2},
  [956] = {.lex_state = 4, .external_lex_state = 2},
  [957] = {.lex_state = 4, .external_lex_state = 2},
  [958] = {.lex_state = 4, .external_lex_state = 2},
  [959] = {.lex_state = 125, .external_lex_state = 2},
  [960] = {.lex_state = 125, .external_lex_state = 2},
  [961] = {.lex_state = 125, .external_lex_state = 2},
  [962] = {.lex_state = 4, .external_lex_state = 2},
  [963] = {.lex_state = 4, .external_lex_state = 2},
  [964] = {.lex_state = 125, .external_lex_state = 2},
  [965] = {.lex_state = 125, .external_lex_state = 2},
  [966] = {.lex_state = 125, .external_lex_state = 2},
  [967] = {.lex_state = 125, .external_lex_state = 2},
  [968] = {.lex_state = 125, .external_lex_state = 2},
  [969] = {.lex_state = 4, .external_lex_state = 2},
  [970] = {.lex_state = 125, .external_lex_state = 2},
  [971] = {.lex_state = 4, .external_lex_state = 2},
  [972] = {.lex_state = 125, .external_lex_state = 2},
  [973] = {.lex_state = 125, .external_lex_state = 2},
  [974] = {.lex_state = 125, .external_lex_state = 2},
  [975] = {.lex_state = 125, .external_lex_state = 2},
  [976] = {.lex_state = 4, .external_lex_state = 2},
  [977] = {.lex_state = 125, .external_lex_state = 2},
  [978] = {.lex_state = 125, .external_lex_state = 2},
  [979] = {.lex_state = 125, .external_lex_state = 2},
  [980] = {.lex_state = 125, .external_lex_state = 2},
  [981] = {.lex_state = 125, .external_lex_state = 2},
  [982] = {.lex_state = 125, .external_lex_state = 2},
  [983] = {.lex_state = 125, .external_lex_state = 2},
  [984] = {.lex_state = 125, .external_lex_state = 2},
  [985] = {.lex_state = 125, .external_lex_state = 2},
  [986] = {.lex_state = 125, .external_lex_state = 2},
  [987] = {.lex_state = 125, .external_lex_state = 2},
  [988] = {.lex_state = 125, .external_lex_state = 2},
  [989] = {.lex_state = 125, .external_lex_state = 2},
  [990] = {.lex_state = 125, .external_lex_state = 2},
  [991] = {.lex_state = 125, .external_lex_state = 2},
  [992] = {.lex_state = 125, .external_lex_state = 2},
  [993] = {.lex_state = 125, .external_lex_state = 2},
  [994] = {.lex_state = 125, .external_lex_state = 2},
  [995] = {.lex_state = 125, .external_lex_state = 2},
  [996] = {.lex_state = 125, .external_lex_state = 2},
  [997] = {.lex_state = 125, .external_lex_state = 2},
  [998] = {.lex_state = 125, .external_lex_state = 2},
  [999] = {.lex_state = 125, .external_lex_state = 2},
  [1000] = {.lex_state = 4, .external_lex_state = 2},
  [1001] = {.lex_state = 4, .external_lex_state = 2},
  [1002] = {.lex_state = 4, .external_lex_state = 2},
  [1003] = {.lex_state = 125, .external_lex_state = 2},
  [1004] = {.lex_state = 4, .external_lex_state = 2},
  [1005] = {.lex_state = 125, .external_lex_state = 2},
  [1006] = {.lex_state = 4, .external_lex_state = 2},
  [1007] = {.lex_state = 125, .external_lex_state = 2},
  [1008] = {.lex_state = 125, .external_lex_state = 2},
  [1009] = {.lex_state = 125, .external_lex_state = 2},
  [1010] = {.lex_state = 125, .external_lex_state = 2},
  [1011] = {.lex_state = 125, .external_lex_state = 2},
  [1012] = {.lex_state = 125, .external_lex_state = 2},
  [1013] = {.lex_state = 125, .external_lex_state = 2},
  [1014] = {.lex_state = 125, .external_lex_state = 2},
  [1015] = {.lex_state = 6, .external_lex_state = 2},
  [1016] = {.lex_state = 125, .external_lex_state = 2},
  [1017] = {.lex_state = 125, .external_lex_state = 2},
  [1018] = {.lex_state = 6, .external_lex_state = 2},
  [1019] = {.lex_state = 6, .external_lex_state = 2},
  [1020] = {.lex_state = 125, .external_lex_state = 2},
  [1021] = {.lex_state = 125, .external_lex_state = 2},
  [1022] = {.lex_state = 125, .external_lex_state = 2},
  [1023] = {.lex_state = 6, .external_lex_state = 2},
  [1024] = {.lex_state = 125, .external_lex_state = 2},
  [1025] = {.lex_state = 125, .external_lex_state = 2},
  [1026] = {.lex_state = 125, .external_lex_state = 2},
  [1027] = {.lex_state = 125, .external_lex_state = 2},
  [1028] = {.lex_state = 125, .external_lex_state = 2},
  [1029] = {.lex_state = 6, .external_lex_state = 2},
  [1030] = {.lex_state = 125, .external_lex_state = 2},
  [1031] = {.lex_state = 124, .external_lex_state = 2},
  [1032] = {.lex_state = 9, .external_lex_state = 6},
  [1033] = {.lex_state = 9, .external_lex_state = 6},
  [1034] = {.lex_state = 31, .external_lex_state = 2},
  [1035] = {.lex_state = 9, .external_lex_state = 6},
  [1036] = {.lex_state = 31, .external_lex_state = 2},
  [1037] = {.lex_state = 9, .external_lex_state = 6},
  [1038] = {.lex_state = 9, .external_lex_state = 6},
  [1039] = {.lex_state = 9, .external_lex_state = 6},
  [1040] = {.lex_state = 31, .external_lex_state = 2},
  [1041] = {.lex_state = 9, .external_lex_state = 6},
  [1042] = {.lex_state = 31, .external_lex_state = 2},
  [1043] = {.lex_state = 9, .external_lex_state = 6},
  [1044] = {.lex_state = 31, .external_lex_state = 2},
  [1045] = {.lex_state = 9, .external_lex_state = 6},
  [1046] = {.lex_state = 31, .external_lex_state = 2},
  [1047] = {.lex_state = 31, .external_lex_state = 2},
  [1048] = {.lex_state = 31, .external_lex_state = 2},
  [1049] = {.lex_state = 31, .external_lex_state = 2},
  [1050] = {.lex_state = 31, .external_lex_state = 2},
  [1051] = {.lex_state = 31, .external_lex_state = 2},
  [1052] = {.lex_state = 31, .external_lex_state = 2},
  [1053] = {.lex_state = 125, .external_lex_state = 2},
  [1054] = {.lex_state = 31, .external_lex_state = 2},
  [1055] = {.lex_state = 31, .external_lex_state = 2},
  [1056] = {.lex_state = 125, .external_lex_state = 2},
  [1057] = {.lex_state = 31, .external_lex_state = 2},
  [1058] = {.lex_state = 31, .external_lex_state = 2},
  [1059] = {.lex_state = 31, .external_lex_state = 2},
  [1060] = {.lex_state = 31, .external_lex_state = 2},
  [1061] = {.lex_state = 31, .external_lex_state = 2},
  [1062] = {.lex_state = 31, .external_lex_state = 2},
  [1063] = {.lex_state = 31, .external_lex_state = 2},
  [1064] = {.lex_state = 31, .external_lex_state = 2},
  [1065] = {.lex_state = 31, .external_lex_state = 2},
  [1066] = {.lex_state = 31, .external_lex_state = 2},
  [1067] = {.lex_state = 31, .external_lex_state = 2},
  [1068] = {.lex_state = 31, .external_lex_state = 2},
  [1069] = {.lex_state = 31, .external_lex_state = 2},
  [1070] = {.lex_state = 31, .external_lex_state = 2},
  [1071] = {.lex_state = 31, .external_lex_state = 2},
  [1072] = {.lex_state = 31, .external_lex_state = 2},
  [1073] = {.lex_state = 31, .external_lex_state = 2},
  [1074] = {.lex_state = 31, .external_lex_state = 2},
  [1075] = {.lex_state = 31, .external_lex_state = 2},
  [1076] = {.lex_state = 125, .external_lex_state = 2},
  [1077] = {.lex_state = 125, .external_lex_state = 2},
  [1078] = {.lex_state = 125, .external_lex_state = 2},
  [1079] = {.lex_state = 125, .external_lex_state = 2},
  [1080] = {.lex_state = 125, .external_lex_state = 2},
  [1081] = {.lex_state = 125, .external_lex_state = 2},
  [1082] = {.lex_state = 125, .external_lex_state = 2},
  [1083] = {.lex_state = 125, .external_lex_state = 2},
  [1084] = {.lex_state = 125, .external_lex_state = 2},
  [1085] = {.lex_state = 125, .external_lex_state = 2},
  [1086] = {.lex_state = 125, .external_lex_state = 2},
  [1087] = {.lex_state = 125, .external_lex_state = 2},
  [1088] = {.lex_state = 125, .external_lex_state = 2},
  [1089] = {.lex_state = 125, .external_lex_state = 2},
  [1090] = {.lex_state = 125, .external_lex_state = 2},
  [1091] = {.lex_state = 125, .external_lex_state = 2},
  [1092] = {.lex_state = 125, .external_lex_state = 5},
  [1093] = {.lex_state = 125, .external_lex_state = 2},
  [1094] = {.lex_state = 31, .external_lex_state = 2},
  [1095] = {.lex_state = 125, .external_lex_state = 2},
  [1096] = {.lex_state = 125, .external_lex_state = 2},
  [1097] = {.lex_state = 125, .external_lex_state = 2},
  [1098] = {.lex_state = 125, .external_lex_state = 2},
  [1099] = {.lex_state = 125, .external_lex_state = 5},
  [1100] = {.lex_state = 125, .external_lex_state = 2},
  [1101] = {.lex_state = 125, .external_lex_state = 2},
  [1102] = {.lex_state = 125, .external_lex_state = 2},
  [1103] = {.lex_state = 125, .external_lex_state = 2},
  [1104] = {.lex_state = 125, .external_lex_state = 2},
  [1105] = {.lex_state = 31, .external_lex_state = 2},
  [1106] = {.lex_state = 16, .external_lex_state = 7},
  [1107] = {.lex_state = 125, .external_lex_state = 2},
  [1108] = {.lex_state = 125, .external_lex_state = 2},
  [1109] = {.lex_state = 125, .external_lex_state = 5},
  [1110] = {.lex_state = 125, .external_lex_state = 5},
  [1111] = {.lex_state = 125, .external_lex_state = 5},
  [1112] = {.lex_state = 125, .external_lex_state = 2},
  [1113] = {.lex_state = 125, .external_lex_state = 2},
  [1114] = {.lex_state = 125, .external_lex_state = 5},
  [1115] = {.lex_state = 16, .external_lex_state = 7},
  [1116] = {.lex_state = 125, .external_lex_state = 5},
  [1117] = {.lex_state = 125, .external_lex_state = 2},
  [1118] = {.lex_state = 125, .external_lex_state = 5},
  [1119] = {.lex_state = 31, .external_lex_state = 2},
  [1120] = {.lex_state = 125, .external_lex_state = 2},
  [1121] = {.lex_state = 125, .external_lex_state = 5},
  [1122] = {.lex_state = 16, .external_lex_state = 7},
  [1123] = {.lex_state = 16, .external_lex_state = 7},
  [1124] = {.lex_state = 31, .external_lex_state = 2},
  [1125] = {.lex_state = 125, .external_lex_state = 2},
  [1126] = {.lex_state = 125, .external_lex_state = 5},
  [1127] = {.lex_state = 125, .external_lex_state = 5},
  [1128] = {.lex_state = 125, .external_lex_state = 5},
  [1129] = {.lex_state = 125, .external_lex_state = 5},
  [1130] = {.lex_state = 125, .external_lex_state = 5},
  [1131] = {.lex_state = 125, .external_lex_state = 2},
  [1132] = {.lex_state = 16, .external_lex_state = 7},
  [1133] = {.lex_state = 125, .external_lex_state = 2},
  [1134] = {.lex_state = 9, .external_lex_state = 6},
  [1135] = {.lex_state = 125, .external_lex_state = 2},
  [1136] = {.lex_state = 9, .external_lex_state = 6},
  [1137] = {.lex_state = 31, .external_lex_state = 2},
  [1138] = {.lex_state = 125, .external_lex_state = 2},
  [1139] = {.lex_state = 31, .external_lex_state = 2},
  [1140] = {.lex_state = 31, .external_lex_state = 2},
  [1141] = {.lex_state = 125, .external_lex_state = 2},
  [1142] = {.lex_state = 125, .external_lex_state = 2},
  [1143] = {.lex_state = 31, .external_lex_state = 2},
  [1144] = {.lex_state = 31, .external_lex_state = 2},
  [1145] = {.lex_state = 31, .external_lex_state = 2},
  [1146] = {.lex_state = 9, .external_lex_state = 6},
  [1147] = {.lex_state = 9, .external_lex_state = 6},
  [1148] = {.lex_state = 31, .external_lex_state = 2},
  [1149] = {.lex_state = 9, .external_lex_state = 6},
  [1150] = {.lex_state = 9, .external_lex_state = 6},
  [1151] = {.lex_state = 125, .external_lex_state = 2},
  [1152] = {.lex_state = 9, .external_lex_state = 6},
  [1153] = {.lex_state = 125, .external_lex_state = 2},
  [1154] = {.lex_state = 9, .external_lex_state = 6},
  [1155] = {.lex_state = 9, .external_lex_state = 6},
  [1156] = {.lex_state = 125, .external_lex_state = 2},
  [1157] = {.lex_state = 9, .external_lex_state = 6},
  [1158] = {.lex_state = 125, .external_lex_state = 2},
  [1159] = {.lex_state = 125, .external_lex_state = 2},
  [1160] = {.lex_state = 125, .external_lex_state = 2},
  [1161] = {.lex_state = 125, .external_lex_state = 2},
  [1162] = {.lex_state = 31, .external_lex_state = 2},
  [1163] = {.lex_state = 31, .external_lex_state = 2},
  [1164] = {.lex_state = 31, .external_lex_state = 2},
  [1165] = {.lex_state = 9, .external_lex_state = 6},
  [1166] = {.lex_state = 125, .external_lex_state = 2},
  [1167] = {.lex_state = 125, .external_lex_state = 5},
  [1168] = {.lex_state = 31, .external_lex_state = 2},
  [1169] = {.lex_state = 125, .external_lex_state = 2},
  [1170] = {.lex_state = 125, .external_lex_state = 2},
  [1171] = {.lex_state = 125, .external_lex_state = 2},
  [1172] = {.lex_state = 9, .external_lex_state = 6},
  [1173] = {.lex_state = 31, .external_lex_state = 2},
  [1174] = {.lex_state = 125, .external_lex_state = 2},
  [1175] = {.lex_state = 125, .external_lex_state = 2},
  [1176] = {.lex_state = 125, .external_lex_state = 2},
  [1177] = {.lex_state = 31, .external_lex_state = 2},
  [1178] = {.lex_state = 31, .external_lex_state = 2},
  [1179] = {.lex_state = 9, .external_lex_state = 6},
  [1180] = {.lex_state = 31, .external_lex_state = 2},
  [1181] = {.lex_state = 31, .external_lex_state = 2},
  [1182] = {.lex_state = 31, .external_lex_state = 2},
  [1183] = {.lex_state = 31, .external_lex_state = 2},
  [1184] = {.lex_state = 31, .external_lex_state = 2},
  [1185] = {.lex_state = 125, .external_lex_state = 2},
  [1186] = {.lex_state = 9, .external_lex_state = 6},
  [1187] = {.lex_state = 31, .external_lex_state = 2},
  [1188] = {.lex_state = 31, .external_lex_state = 2},
  [1189] = {.lex_state = 9, .external_lex_state = 6},
  [1190] = {.lex_state = 125, .external_lex_state = 2},
  [1191] = {.lex_state = 125, .external_lex_state = 5},
  [1192] = {.lex_state = 31, .external_lex_state = 2},
  [1193] = {.lex_state = 31, .external_lex_state = 2},
  [1194] = {.lex_state = 125, .external_lex_state = 5},
  [1195] = {.lex_state = 9, .external_lex_state = 6},
  [1196] = {.lex_state = 125, .external_lex_state = 5},
  [1197] = {.lex_state = 125, .external_lex_state = 2},
  [1198] = {.lex_state = 31, .external_lex_state = 2},
  [1199] = {.lex_state = 9, .external_lex_state = 6},
  [1200] = {.lex_state = 20, .external_lex_state = 8},
  [1201] = {.lex_state = 125, .external_lex_state = 2},
  [1202] = {.lex_state = 125, .external_lex_state = 2},
  [1203] = {.lex_state = 125, .external_lex_state = 2},
  [1204] = {.lex_state = 125, .external_lex_state = 2},
  [1205] = {.lex_state = 10, .external_lex_state = 2},
  [1206] = {.lex_state = 125, .external_lex_state = 2},
  [1207] = {.lex_state = 125, .external_lex_state = 2},
  [1208] = {.lex_state = 125, .external_lex_state = 2},
  [1209] = {.lex_state = 18, .external_lex_state = 2},
  [1210] = {.lex_state = 125, .external_lex_state = 2},
  [1211] = {.lex_state = 125, .external_lex_state = 5},
  [1212] = {.lex_state = 125, .external_lex_state = 2},
  [1213] = {.lex_state = 10, .external_lex_state = 2},
  [1214] = {.lex_state = 12, .external_lex_state = 8},
  [1215] = {.lex_state = 125, .external_lex_state = 2},
  [1216] = {.lex_state = 125, .external_lex_state = 2},
  [1217] = {.lex_state = 125, .external_lex_state = 2},
  [1218] = {.lex_state = 18, .external_lex_state = 2},
  [1219] = {.lex_state = 125, .external_lex_state = 2},
  [1220] = {.lex_state = 125, .external_lex_state = 2},
  [1221] = {.lex_state = 125, .external_lex_state = 2},
  [1222] = {.lex_state = 20, .external_lex_state = 8},
  [1223] = {.lex_state = 125, .external_lex_state = 5},
  [1224] = {.lex_state = 20, .external_lex_state = 8},
  [1225] = {.lex_state = 20, .external_lex_state = 8},
  [1226] = {.lex_state = 12, .external_lex_state = 8},
  [1227] = {.lex_state = 20, .external_lex_state = 8},
  [1228] = {.lex_state = 125, .external_lex_state = 2},
  [1229] = {.lex_state = 125, .external_lex_state = 2},
  [1230] = {.lex_state = 125, .external_lex_state = 2},
  [1231] = {.lex_state = 125, .external_lex_state = 5},
  [1232] = {.lex_state = 124, .external_lex_state = 2},
  [1233] = {.lex_state = 125, .external_lex_state = 2},
  [1234] = {.lex_state = 125, .external_lex_state = 2},
  [1235] = {.lex_state = 12, .external_lex_state = 8},
  [1236] = {.lex_state = 20, .external_lex_state = 8},
  [1237] = {.lex_state = 125, .external_lex_state = 2},
  [1238] = {.lex_state = 125, .external_lex_state = 2},
  [1239] = {.lex_state = 20, .external_lex_state = 8},
  [1240] = {.lex_state = 125, .external_lex_state = 5},
  [1241] = {.lex_state = 125, .external_lex_state = 2},
  [1242] = {.lex_state = 125, .external_lex_state = 5},
  [1243] = {.lex_state = 125, .external_lex_state = 2},
  [1244] = {.lex_state = 12, .external_lex_state = 8},
  [1245] = {.lex_state = 12, .external_lex_state = 8},
  [1246] = {.lex_state = 125, .external_lex_state = 2},
  [1247] = {.lex_state = 12, .external_lex_state = 8},
  [1248] = {.lex_state = 125, .external_lex_state = 5},
  [1249] = {.lex_state = 12, .external_lex_state = 8},
  [1250] = {.lex_state = 20, .external_lex_state = 8},
  [1251] = {.lex_state = 125, .external_lex_state = 2},
  [1252] = {.lex_state = 20, .external_lex_state = 8},
  [1253] = {.lex_state = 125, .external_lex_state = 2},
  [1254] = {.lex_state = 125, .external_lex_state = 2},
  [1255] = {.lex_state = 125, .external_lex_state = 5},
  [1256] = {.lex_state = 125, .external_lex_state = 2},
  [1257] = {.lex_state = 125, .external_lex_state = 2},
  [1258] = {.lex_state = 125, .external_lex_state = 2},
  [1259] = {.lex_state = 125, .external_lex_state = 2},
  [1260] = {.lex_state = 125, .external_lex_state = 5},
  [1261] = {.lex_state = 125, .external_lex_state = 5},
  [1262] = {.lex_state = 125, .external_lex_state = 2},
  [1263] = {.lex_state = 10, .external_lex_state = 2},
  [1264] = {.lex_state = 18, .external_lex_state = 2},
  [1265] = {.lex_state = 16, .external_lex_state = 7},
  [1266] = {.lex_state = 12, .external_lex_state = 8},
  [1267] = {.lex_state = 125, .external_lex_state = 2},
  [1268] = {.lex_state = 125, .external_lex_state = 5},
  [1269] = {.lex_state = 12, .external_lex_state = 8},
  [1270] = {.lex_state = 125, .external_lex_state = 5},
  [1271] = {.lex_state = 125, .external_lex_state = 5},
  [1272] = {.lex_state = 124, .external_lex_state = 2},
  [1273] = {.lex_state = 125, .external_lex_state = 2},
  [1274] = {.lex_state = 125, .external_lex_state = 2},
  [1275] = {.lex_state = 125, .external_lex_state = 2},
  [1276] = {.lex_state = 125, .external_lex_state = 2},
  [1277] = {.lex_state = 125, .external_lex_state = 2},
  [1278] = {.lex_state = 125, .external_lex_state = 2},
  [1279] = {.lex_state = 125, .external_lex_state = 2},
  [1280] = {.lex_state = 125, .external_lex_state = 2},
  [1281] = {.lex_state = 125, .external_lex_state = 2},
  [1282] = {.lex_state = 125, .external_lex_state = 2},
  [1283] = {.lex_state = 125, .external_lex_state = 2},
  [1284] = {.lex_state = 125, .external_lex_state = 2},
  [1285] = {.lex_state = 125, .external_lex_state = 2},
  [1286] = {.lex_state = 125, .external_lex_state = 2},
  [1287] = {.lex_state = 125, .external_lex_state = 2},
  [1288] = {.lex_state = 125, .external_lex_state = 2},
  [1289] = {.lex_state = 125, .external_lex_state = 2},
  [1290] = {.lex_state = 125, .external_lex_state = 2},
  [1291] = {.lex_state = 125, .external_lex_state = 2},
  [1292] = {.lex_state = 125, .external_lex_state = 2},
  [1293] = {.lex_state = 125, .external_lex_state = 5},
  [1294] = {.lex_state = 125, .external_lex_state = 2},
  [1295] = {.lex_state = 125, .external_lex_state = 2},
  [1296] = {.lex_state = 125, .external_lex_state = 2},
  [1297] = {.lex_state = 125, .external_lex_state = 2},
  [1298] = {.lex_state = 125, .external_lex_state = 2},
  [1299] = {.lex_state = 125, .external_lex_state = 2},
  [1300] = {.lex_state = 125, .external_lex_state = 2},
  [1301] = {.lex_state = 125, .external_lex_state = 2},
  [1302] = {.lex_state = 125, .external_lex_state = 5},
  [1303] = {.lex_state = 125, .external_lex_state = 2},
  [1304] = {.lex_state = 125, .external_lex_state = 2},
  [1305] = {.lex_state = 5, .external_lex_state = 2},
  [1306] = {.lex_state = 125, .external_lex_state = 2},
  [1307] = {.lex_state = 125, .external_lex_state = 2},
  [1308] = {.lex_state = 125, .external_lex_state = 5},
  [1309] = {.lex_state = 125, .external_lex_state = 2},
  [1310] = {.lex_state = 125, .external_lex_state = 2},
  [1311] = {.lex_state = 125, .external_lex_state = 2},
  [1312] = {.lex_state = 125, .external_lex_state = 2},
  [1313] = {.lex_state = 125, .external_lex_state = 5},
  [1314] = {.lex_state = 5, .external_lex_state = 2},
  [1315] = {.lex_state = 125, .external_lex_state = 2},
  [1316] = {.lex_state = 125, .external_lex_state = 2},
  [1317] = {.lex_state = 125, .external_lex_state = 2},
  [1318] = {.lex_state = 125, .external_lex_state = 5},
  [1319] = {.lex_state = 125, .external_lex_state = 2},
  [1320] = {.lex_state = 125, .external_lex_state = 2},
  [1321] = {.lex_state = 125, .external_lex_state = 2},
  [1322] = {.lex_state = 125, .external_lex_state = 2},
  [1323] = {.lex_state = 125, .external_lex_state = 2},
  [1324] = {.lex_state = 125, .external_lex_state = 2},
  [1325] = {.lex_state = 125, .external_lex_state = 2},
  [1326] = {.lex_state = 125, .external_lex_state = 2},
  [1327] = {.lex_state = 125, .external_lex_state = 5},
  [1328] = {.lex_state = 125, .external_lex_state = 2},
  [1329] = {.lex_state = 125, .external_lex_state = 5},
  [1330] = {.lex_state = 125, .external_lex_state = 2},
  [1331] = {.lex_state = 125, .external_lex_state = 5},
  [1332] = {.lex_state = 125, .external_lex_state = 2},
  [1333] = {.lex_state = 125, .external_lex_state = 2},
  [1334] = {.lex_state = 125, .external_lex_state = 2},
  [1335] = {.lex_state = 125, .external_lex_state = 2},
  [1336] = {.lex_state = 125, .external_lex_state = 2},
  [1337] = {.lex_state = 124, .external_lex_state = 2},
  [1338] = {.lex_state = 125, .external_lex_state = 2},
  [1339] = {.lex_state = 125, .external_lex_state = 2},
  [1340] = {.lex_state = 124, .external_lex_state = 2},
  [1341] = {.lex_state = 125, .external_lex_state = 2},
  [1342] = {.lex_state = 125, .external_lex_state = 2},
  [1343] = {.lex_state = 125, .external_lex_state = 2},
  [1344] = {.lex_state = 125, .external_lex_state = 2},
  [1345] = {.lex_state = 125, .external_lex_state = 2},
  [1346] = {.lex_state = 125, .external_lex_state = 2},
  [1347] = {.lex_state = 5, .external_lex_state = 2},
  [1348] = {.lex_state = 125, .external_lex_state = 2},
  [1349] = {.lex_state = 125, .external_lex_state = 2},
  [1350] = {.lex_state = 125, .external_lex_state = 2},
  [1351] = {.lex_state = 125, .external_lex_state = 2},
  [1352] = {.lex_state = 125, .external_lex_state = 2},
  [1353] = {.lex_state = 125, .external_lex_state = 2},
  [1354] = {.lex_state = 125, .external_lex_state = 2},
  [1355] = {.lex_state = 125, .external_lex_state = 2},
  [1356] = {.lex_state = 125, .external_lex_state = 2},
  [1357] = {.lex_state = 125, .external_lex_state = 2},
  [1358] = {.lex_state = 125, .external_lex_state = 2},
  [1359] = {.lex_state = 125, .external_lex_state = 5},
  [1360] = {.lex_state = 125, .external_lex_state = 5},
  [1361] = {.lex_state = 125, .external_lex_state = 2},
  [1362] = {.lex_state = 125, .external_lex_state = 2},
  [1363] = {.lex_state = 125, .external_lex_state = 2},
  [1364] = {.lex_state = 125, .external_lex_state = 2},
  [1365] = {.lex_state = 5, .external_lex_state = 2},
  [1366] = {.lex_state = 125, .external_lex_state = 2},
  [1367] = {.lex_state = 125, .external_lex_state = 2},
  [1368] = {.lex_state = 125, .external_lex_state = 2},
  [1369] = {.lex_state = 125, .external_lex_state = 2},
  [1370] = {.lex_state = 125, .external_lex_state = 2},
  [1371] = {.lex_state = 125, .external_lex_state = 2},
  [1372] = {.lex_state = 125, .external_lex_state = 2},
  [1373] = {.lex_state = 125, .external_lex_state = 2},
  [1374] = {.lex_state = 125, .external_lex_state = 2},
  [1375] = {.lex_state = 125, .external_lex_state = 2},
  [1376] = {.lex_state = 125, .external_lex_state = 2},
  [1377] = {.lex_state = 125, .external_lex_state = 2},
  [1378] = {.lex_state = 125, .external_lex_state = 2},
  [1379] = {.lex_state = 125, .external_lex_state = 2},
  [1380] = {.lex_state = 125, .external_lex_state = 2},
  [1381] = {.lex_state = 125, .external_lex_state = 2},
  [1382] = {.lex_state = 125, .external_lex_state = 2},
  [1383] = {.lex_state = 125, .external_lex_state = 2},
  [1384] = {.lex_state = 125, .external_lex_state = 2},
  [1385] = {.lex_state = 125, .external_lex_state = 2},
  [1386] = {.lex_state = 125, .external_lex_state = 2},
  [1387] = {.lex_state = 125, .external_lex_state = 2},
  [1388] = {.lex_state = 125, .external_lex_state = 2},
  [1389] = {.lex_state = 125, .external_lex_state = 2},
  [1390] = {.lex_state = 125, .external_lex_state = 2},
  [1391] = {.lex_state = 125, .external_lex_state = 2},
  [1392] = {.lex_state = 5, .external_lex_state = 2},
  [1393] = {.lex_state = 125, .external_lex_state = 2},
  [1394] = {.lex_state = 125, .external_lex_state = 2},
  [1395] = {.lex_state = 125, .external_lex_state = 2},
  [1396] = {.lex_state = 125, .external_lex_state = 2},
  [1397] = {.lex_state = 125, .external_lex_state = 5},
  [1398] = {.lex_state = 125, .external_lex_state = 5},
  [1399] = {.lex_state = 125, .external_lex_state = 5},
  [1400] = {.lex_state = 125, .external_lex_state = 2},
  [1401] = {.lex_state = 125, .external_lex_state = 5},
  [1402] = {.lex_state = 125, .external_lex_state = 5},
  [1403] = {.lex_state = 125, .external_lex_state = 2},
  [1404] = {.lex_state = 125, .external_lex_state = 2},
  [1405] = {.lex_state = 125, .external_lex_state = 2},
  [1406] = {.lex_state = 125, .external_lex_state = 5},
  [1407] = {.lex_state = 125, .external_lex_state = 5},
  [1408] = {.lex_state = 125, .external_lex_state = 2},
  [1409] = {.lex_state = 125, .external_lex_state = 2},
  [1410] = {.lex_state = 125, .external_lex_state = 2},
  [1411] = {.lex_state = 125, .external_lex_state = 2},
  [1412] = {.lex_state = 125, .external_lex_state = 2},
  [1413] = {.lex_state = 125, .external_lex_state = 2},
  [1414] = {.lex_state = 125, .external_lex_state = 2},
  [1415] = {.lex_state = 125, .external_lex_state = 2},
  [1416] = {.lex_state = 125, .external_lex_state = 2},
  [1417] = {.lex_state = 5, .external_lex_state = 2},
  [1418] = {.lex_state = 125, .external_lex_state = 2},
  [1419] = {.lex_state = 125, .external_lex_state = 2},
  [1420] = {.lex_state = 125, .external_lex_state = 2},
  [1421] = {.lex_state = 125, .external_lex_state = 2},
  [1422] = {.lex_state = 125, .external_lex_state = 2},
  [1423] = {.lex_state = 125, .external_lex_state = 2},
  [1424] = {.lex_state = 125, .external_lex_state = 2},
  [1425] = {.lex_state = 125, .external_lex_state = 2},
  [1426] = {.lex_state = 125, .external_lex_state = 2},
  [1427] = {.lex_state = 125, .external_lex_state = 2},
  [1428] = {.lex_state = 125, .external_lex_state = 2},
  [1429] = {.lex_state = 125, .external_lex_state = 2},
  [1430] = {.lex_state = 125, .external_lex_state = 2},
  [1431] = {.lex_state = 125, .external_lex_state = 2},
  [1432] = {.lex_state = 125, .external_lex_state = 2},
  [1433] = {.lex_state = 125, .external_lex_state = 2},
  [1434] = {.lex_state = 125, .external_lex_state = 2},
  [1435] = {.lex_state = 125, .external_lex_state = 5},
  [1436] = {.lex_state = 125, .external_lex_state = 2},
  [1437] = {.lex_state = 125, .external_lex_state = 2},
  [1438] = {.lex_state = 125, .external_lex_state = 2},
  [1439] = {.lex_state = 125, .external_lex_state = 2},
  [1440] = {.lex_state = 125, .external_lex_state = 2},
  [1441] = {.lex_state = 125, .external_lex_state = 2},
  [1442] = {.lex_state = 125, .external_lex_state = 2},
  [1443] = {.lex_state = 125, .external_lex_state = 2},
  [1444] = {.lex_state = 125, .external_lex_state = 2},
  [1445] = {.lex_state = 125, .external_lex_state = 2},
  [1446] = {.lex_state = 125, .external_lex_state = 2},
  [1447] = {.lex_state = 125, .external_lex_state = 5},
  [1448] = {.lex_state = 125, .external_lex_state = 5},
  [1449] = {.lex_state = 125, .external_lex_state = 2},
  [1450] = {.lex_state = 125, .external_lex_state = 2},
  [1451] = {.lex_state = 125, .external_lex_state = 5},
  [1452] = {.lex_state = 125, .external_lex_state = 2},
  [1453] = {.lex_state = 125, .external_lex_state = 5},
  [1454] = {.lex_state = 125, .external_lex_state = 2},
  [1455] = {.lex_state = 125, .external_lex_state = 5},
  [1456] = {.lex_state = 125, .external_lex_state = 2},
  [1457] = {.lex_state = 125, .external_lex_state = 2},
  [1458] = {.lex_state = 125, .external_lex_state = 2},
  [1459] = {.lex_state = 125, .external_lex_state = 2},
  [1460] = {.lex_state = 125, .external_lex_state = 2},
  [1461] = {.lex_state = 125, .external_lex_state = 5},
  [1462] = {.lex_state = 125, .external_lex_state = 2},
  [1463] = {.lex_state = 125, .external_lex_state = 2},
  [1464] = {.lex_state = 125, .external_lex_state = 2},
  [1465] = {.lex_state = 125, .external_lex_state = 2},
  [1466] = {.lex_state = 125, .external_lex_state = 2},
  [1467] = {.lex_state = 125, .external_lex_state = 2},
  [1468] = {.lex_state = 125, .external_lex_state = 2},
  [1469] = {.lex_state = 125, .external_lex_state = 2},
  [1470] = {.lex_state = 125, .external_lex_state = 2},
  [1471] = {.lex_state = 125, .external_lex_state = 2},
  [1472] = {.lex_state = 125, .external_lex_state = 2},
  [1473] = {.lex_state = 125, .external_lex_state = 2},
  [1474] = {.lex_state = 125, .external_lex_state = 2},
  [1475] = {.lex_state = 125, .external_lex_state = 2},
  [1476] = {.lex_state = 125, .external_lex_state = 5},
  [1477] = {.lex_state = 125, .external_lex_state = 2},
  [1478] = {.lex_state = 125, .external_lex_state = 2},
  [1479] = {.lex_state = 125, .external_lex_state = 2},
  [1480] = {.lex_state = 125, .external_lex_state = 2},
  [1481] = {.lex_state = 125, .external_lex_state = 2},
  [1482] = {.lex_state = 125, .external_lex_state = 2},
  [1483] = {.lex_state = 125, .external_lex_state = 2},
  [1484] = {.lex_state = 125, .external_lex_state = 2},
  [1485] = {.lex_state = 125, .external_lex_state = 2},
  [1486] = {.lex_state = 125, .external_lex_state = 2},
  [1487] = {.lex_state = 125, .external_lex_state = 2},
  [1488] = {.lex_state = 125, .external_lex_state = 2},
  [1489] = {.lex_state = 125, .external_lex_state = 2},
  [1490] = {.lex_state = 125, .external_lex_state = 2},
  [1491] = {.lex_state = 125, .external_lex_state = 2},
  [1492] = {.lex_state = 125, .external_lex_state = 2},
  [1493] = {.lex_state = 125, .external_lex_state = 2},
  [1494] = {.lex_state = 125, .external_lex_state = 2},
  [1495] = {.lex_state = 125, .external_lex_state = 2},
  [1496] = {.lex_state = 125, .external_lex_state = 2},
  [1497] = {.lex_state = 125, .external_lex_state = 2},
  [1498] = {.lex_state = 125, .external_lex_state = 2},
  [1499] = {.lex_state = 125, .external_lex_state = 2},
  [1500] = {.lex_state = 125, .external_lex_state = 2},
  [1501] = {.lex_state = 125, .external_lex_state = 2},
  [1502] = {.lex_state = 125, .external_lex_state = 2},
  [1503] = {.lex_state = 125, .external_lex_state = 2},
  [1504] = {.lex_state = 125, .external_lex_state = 2},
  [1505] = {.lex_state = 125, .external_lex_state = 2},
  [1506] = {.lex_state = 125, .external_lex_state = 2},
  [1507] = {.lex_state = 125, .external_lex_state = 2},
  [1508] = {.lex_state = 125, .external_lex_state = 2},
  [1509] = {.lex_state = 125, .external_lex_state = 2},
  [1510] = {.lex_state = 125, .external_lex_state = 2},
  [1511] = {.lex_state = 125, .external_lex_state = 2},
  [1512] = {.lex_state = 125, .external_lex_state = 2},
  [1513] = {.lex_state = 125, .external_lex_state = 2},
  [1514] = {.lex_state = 125, .external_lex_state = 2},
  [1515] = {.lex_state = 125, .external_lex_state = 2},
  [1516] = {.lex_state = 125, .external_lex_state = 2},
  [1517] = {.lex_state = 125, .external_lex_state = 2},
  [1518] = {.lex_state = 125, .external_lex_state = 2},
  [1519] = {.lex_state = 125, .external_lex_state = 2},
  [1520] = {.lex_state = 125, .external_lex_state = 2},
  [1521] = {.lex_state = 125, .external_lex_state = 2},
  [1522] = {.lex_state = 125, .external_lex_state = 2},
  [1523] = {.lex_state = 125, .external_lex_state = 2},
  [1524] = {.lex_state = 125, .external_lex_state = 2},
  [1525] = {.lex_state = 125, .external_lex_state = 2},
  [1526] = {.lex_state = 125, .external_lex_state = 2},
  [1527] = {.lex_state = 125, .external_lex_state = 2},
  [1528] = {.lex_state = 125, .external_lex_state = 5},
  [1529] = {.lex_state = 125, .external_lex_state = 2},
  [1530] = {.lex_state = 125, .external_lex_state = 2},
  [1531] = {.lex_state = 125, .external_lex_state = 2},
  [1532] = {.lex_state = 125, .external_lex_state = 2},
  [1533] = {.lex_state = 125, .external_lex_state = 2},
  [1534] = {.lex_state = 125, .external_lex_state = 2},
  [1535] = {.lex_state = 125, .external_lex_state = 2},
  [1536] = {.lex_state = 5, .external_lex_state = 2},
  [1537] = {.lex_state = 125, .external_lex_state = 2},
  [1538] = {.lex_state = 125, .external_lex_state = 2},
  [1539] = {.lex_state = 125, .external_lex_state = 2},
  [1540] = {.lex_state = 31, .external_lex_state = 2},
  [1541] = {.lex_state = 125, .external_lex_state = 2},
  [1542] = {.lex_state = 125, .external_lex_state = 2},
  [1543] = {.lex_state = 125, .external_lex_state = 5},
  [1544] = {.lex_state = 125, .external_lex_state = 2},
  [1545] = {.lex_state = 125, .external_lex_state = 2},
  [1546] = {.lex_state = 125, .external_lex_state = 2},
  [1547] = {.lex_state = 125, .external_lex_state = 2},
  [1548] = {.lex_state = 125, .external_lex_state = 2},
  [1549] = {.lex_state = 125, .external_lex_state = 5},
  [1550] = {.lex_state = 125, .external_lex_state = 2},
  [1551] = {.lex_state = 125, .external_lex_state = 2},
  [1552] = {.lex_state = 125, .external_lex_state = 2},
  [1553] = {.lex_state = 125, .external_lex_state = 2},
  [1554] = {.lex_state = 125, .external_lex_state = 2},
  [1555] = {.lex_state = 125, .external_lex_state = 2},
  [1556] = {.lex_state = 125, .external_lex_state = 2},
  [1557] = {.lex_state = 125, .external_lex_state = 2},
  [1558] = {.lex_state = 125, .external_lex_state = 2},
  [1559] = {.lex_state = 125, .external_lex_state = 2},
  [1560] = {.lex_state = 125, .external_lex_state = 2},
  [1561] = {.lex_state = 125, .external_lex_state = 5},
  [1562] = {.lex_state = 125, .external_lex_state = 5},
  [1563] = {.lex_state = 125, .external_lex_state = 2},
  [1564] = {.lex_state = 125, .external_lex_state = 2},
  [1565] = {.lex_state = 125, .external_lex_state = 2},
  [1566] = {.lex_state = 125, .external_lex_state = 2},
  [1567] = {.lex_state = 125, .external_lex_state = 2},
  [1568] = {.lex_state = 125, .external_lex_state = 5},
  [1569] = {.lex_state = 125, .external_lex_state = 2},
  [1570] = {.lex_state = 125, .external_lex_state = 5},
  [1571] = {.lex_state = 125, .external_lex_state = 2},
  [1572] = {.lex_state = 125, .external_lex_state = 2},
  [1573] = {.lex_state = 125, .external_lex_state = 2},
  [1574] = {.lex_state = 125, .external_lex_state = 2},
  [1575] = {.lex_state = 125, .external_lex_state = 2},
  [1576] = {.lex_state = 125, .external_lex_state = 2},
  [1577] = {.lex_state = 125, .external_lex_state = 2},
  [1578] = {.lex_state = 125, .external_lex_state = 2},
  [1579] = {.lex_state = 125, .external_lex_state = 2},
  [1580] = {.lex_state = 125, .external_lex_state = 2},
  [1581] = {.lex_state = 125, .external_lex_state = 2},
  [1582] = {.lex_state = 5, .external_lex_state = 2},
  [1583] = {.lex_state = 125, .external_lex_state = 2},
  [1584] = {.lex_state = 125, .external_lex_state = 2},
  [1585] = {.lex_state = 125, .external_lex_state = 2},
  [1586] = {.lex_state = 125, .external_lex_state = 2},
  [1587] = {.lex_state = 125, .external_lex_state = 2},
  [1588] = {.lex_state = 125, .external_lex_state = 2},
  [1589] = {.lex_state = 125, .external_lex_state = 2},
  [1590] = {.lex_state = 125, .external_lex_state = 2},
  [1591] = {.lex_state = 125, .external_lex_state = 2},
  [1592] = {.lex_state = 125, .external_lex_state = 2},
  [1593] = {.lex_state = 125, .external_lex_state = 2},
  [1594] = {.lex_state = 125, .external_lex_state = 2},
  [1595] = {.lex_state = 125, .external_lex_state = 2},
  [1596] = {.lex_state = 125, .external_lex_state = 2},
  [1597] = {.lex_state = 125, .external_lex_state = 2},
  [1598] = {.lex_state = 125, .external_lex_state = 2},
  [1599] = {.lex_state = 125, .external_lex_state = 2},
  [1600] = {.lex_state = 125, .external_lex_state = 2},
  [1601] = {.lex_state = 125, .external_lex_state = 2},
  [1602] = {.lex_state = 125, .external_lex_state = 2},
  [1603] = {.lex_state = 125, .external_lex_state = 2},
  [1604] = {.lex_state = 125, .external_lex_state = 2},
  [1605] = {.lex_state = 125, .external_lex_state = 2},
  [1606] = {.lex_state = 125, .external_lex_state = 2},
  [1607] = {.lex_state = 125, .external_lex_state = 2},
  [1608] = {.lex_state = 125, .external_lex_state = 2},
  [1609] = {.lex_state = 125, .external_lex_state = 2},
  [1610] = {.lex_state = 125, .external_lex_state = 2},
  [1611] = {.lex_state = 125, .external_lex_state = 2},
  [1612] = {.lex_state = 125, .external_lex_state = 2},
  [1613] = {.lex_state = 125, .external_lex_state = 2},
  [1614] = {.lex_state = 125, .external_lex_state = 2},
  [1615] = {.lex_state = 125, .external_lex_state = 2},
  [1616] = {.lex_state = 125, .external_lex_state = 2},
  [1617] = {.lex_state = 125, .external_lex_state = 2},
  [1618] = {.lex_state = 125, .external_lex_state = 2},
  [1619] = {.lex_state = 125, .external_lex_state = 2},
  [1620] = {.lex_state = 125, .external_lex_state = 2},
  [1621] = {.lex_state = 125, .external_lex_state = 2},
  [1622] = {.lex_state = 32, .external_lex_state = 2},
  [1623] = {.lex_state = 125, .external_lex_state = 2},
  [1624] = {.lex_state = 125, .external_lex_state = 2},
  [1625] = {.lex_state = 125, .external_lex_state = 2},
  [1626] = {.lex_state = 125, .external_lex_state = 2},
  [1627] = {.lex_state = 125, .external_lex_state = 2},
  [1628] = {.lex_state = 125, .external_lex_state = 2},
  [1629] = {.lex_state = 125, .external_lex_state = 2},
  [1630] = {.lex_state = 32, .external_lex_state = 2},
  [1631] = {.lex_state = 125, .external_lex_state = 2},
  [1632] = {.lex_state = 125, .external_lex_state = 2},
  [1633] = {.lex_state = 125, .external_lex_state = 2},
  [1634] = {.lex_state = 125, .external_lex_state = 2},
  [1635] = {.lex_state = 2, .external_lex_state = 9},
  [1636] = {.lex_state = 32, .external_lex_state = 2},
  [1637] = {.lex_state = 125, .external_lex_state = 2},
  [1638] = {.lex_state = 125, .external_lex_state = 2},
  [1639] = {.lex_state = 125, .external_lex_state = 2},
  [1640] = {.lex_state = 125, .external_lex_state = 2},
  [1641] = {.lex_state = 125, .external_lex_state = 2},
  [1642] = {.lex_state = 125, .external_lex_state = 2},
  [1643] = {.lex_state = 125, .external_lex_state = 2},
  [1644] = {.lex_state = 125, .external_lex_state = 2},
  [1645] = {.lex_state = 125, .external_lex_state = 2},
  [1646] = {.lex_state = 125, .external_lex_state = 2},
  [1647] = {.lex_state = 125, .external_lex_state = 2},
  [1648] = {.lex_state = 125, .external_lex_state = 2},
  [1649] = {.lex_state = 125, .external_lex_state = 2},
  [1650] = {.lex_state = 125, .external_lex_state = 2},
  [1651] = {.lex_state = 125, .external_lex_state = 2},
  [1652] = {.lex_state = 125, .external_lex_state = 2},
  [1653] = {.lex_state = 125, .external_lex_state = 2},
  [1654] = {.lex_state = 125, .external_lex_state = 2},
  [1655] = {.lex_state = 125, .external_lex_state = 2},
  [1656] = {.lex_state = 125, .external_lex_state = 2},
  [1657] = {.lex_state = 125, .external_lex_state = 2},
  [1658] = {.lex_state = 125, .external_lex_state = 2},
  [1659] = {.lex_state = 125, .external_lex_state = 2},
  [1660] = {.lex_state = 125, .external_lex_state = 2},
  [1661] = {.lex_state = 125, .external_lex_state = 2},
  [1662] = {.lex_state = 125, .external_lex_state = 2},
  [1663] = {.lex_state = 125, .external_lex_state = 2},
  [1664] = {.lex_state = 125, .external_lex_state = 2},
  [1665] = {.lex_state = 125, .external_lex_state = 2},
  [1666] = {.lex_state = 125, .external_lex_state = 2},
  [1667] = {.lex_state = 125, .external_lex_state = 2},
  [1668] = {.lex_state = 125, .external_lex_state = 2},
  [1669] = {.lex_state = 125, .external_lex_state = 2},
  [1670] = {.lex_state = 125, .external_lex_state = 2},
  [1671] = {.lex_state = 125, .external_lex_state = 2},
  [1672] = {.lex_state = 125, .external_lex_state = 2},
  [1673] = {.lex_state = 125, .external_lex_state = 2},
  [1674] = {.lex_state = 125, .external_lex_state = 2},
  [1675] = {.lex_state = 125, .external_lex_state = 2},
  [1676] = {.lex_state = 125, .external_lex_state = 2},
  [1677] = {.lex_state = 125, .external_lex_state = 2},
  [1678] = {.lex_state = 125, .external_lex_state = 2},
  [1679] = {.lex_state = 125, .external_lex_state = 2},
  [1680] = {.lex_state = 125, .external_lex_state = 2},
  [1681] = {.lex_state = 125, .external_lex_state = 2},
  [1682] = {.lex_state = 125, .external_lex_state = 2},
  [1683] = {.lex_state = 125, .external_lex_state = 2},
  [1684] = {.lex_state = 125, .external_lex_state = 2},
  [1685] = {.lex_state = 125, .external_lex_state = 2},
  [1686] = {.lex_state = 125, .external_lex_state = 2},
  [1687] = {.lex_state = 125, .external_lex_state = 2},
  [1688] = {.lex_state = 2, .external_lex_state = 9},
  [1689] = {.lex_state = 125, .external_lex_state = 2},
  [1690] = {.lex_state = 125, .external_lex_state = 2},
  [1691] = {.lex_state = 125, .external_lex_state = 2},
  [1692] = {.lex_state = 2, .external_lex_state = 9},
  [1693] = {.lex_state = 125, .external_lex_state = 2},
  [1694] = {.lex_state = 125, .external_lex_state = 2},
  [1695] = {.lex_state = 125, .external_lex_state = 2},
  [1696] = {.lex_state = 125, .external_lex_state = 2},
  [1697] = {.lex_state = 125, .external_lex_state = 2},
  [1698] = {.lex_state = 2, .external_lex_state = 9},
  [1699] = {.lex_state = 125, .external_lex_state = 2},
  [1700] = {.lex_state = 125, .external_lex_state = 2},
  [1701] = {.lex_state = 125, .external_lex_state = 2},
  [1702] = {.lex_state = 125, .external_lex_state = 2},
  [1703] = {.lex_state = 125, .external_lex_state = 2},
  [1704] = {.lex_state = 125, .external_lex_state = 2},
  [1705] = {.lex_state = 125, .external_lex_state = 2},
  [1706] = {.lex_state = 125, .external_lex_state = 2},
  [1707] = {.lex_state = 125, .external_lex_state = 2},
  [1708] = {.lex_state = 125, .external_lex_state = 2},
  [1709] = {.lex_state = 125, .external_lex_state = 2},
  [1710] = {.lex_state = 125, .external_lex_state = 2},
  [1711] = {.lex_state = 125, .external_lex_state = 2},
  [1712] = {.lex_state = 125, .external_lex_state = 2},
  [1713] = {.lex_state = 125, .external_lex_state = 2},
  [1714] = {.lex_state = 32, .external_lex_state = 2},
  [1715] = {.lex_state = 125, .external_lex_state = 2},
  [1716] = {.lex_state = 125, .external_lex_state = 2},
  [1717] = {.lex_state = 125, .external_lex_state = 2},
  [1718] = {.lex_state = 125, .external_lex_state = 2},
  [1719] = {.lex_state = 125, .external_lex_state = 2},
  [1720] = {.lex_state = 125, .external_lex_state = 2},
  [1721] = {.lex_state = 125, .external_lex_state = 2},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_LT_SLASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [sym_optional_chain] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_private_property_identifier] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [anon_sym_meta] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [aux_sym_method_definition_token1] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
    [sym__ternary_qmark] = ACTIONS(1),
    [sym_html_comment] = ACTIONS(5),
    [sym_jsx_text] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1626),
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(18),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [sym_hash_bang_line] = ACTIONS(11),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [2] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(12),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1661),
    [sym_object_assignment_pattern] = STATE(1281),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1661),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1661),
    [sym_spread_element] = STATE(1333),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(743),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [sym_rest_pattern] = STATE(1281),
    [sym_method_definition] = STATE(1333),
    [sym_pair] = STATE(1333),
    [sym_pair_pattern] = STATE(1281),
    [sym__property_name] = STATE(1290),
    [sym_computed_property_name] = STATE(1290),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(903),
    [aux_sym_object_repeat1] = STATE(1334),
    [aux_sym_object_pattern_repeat1] = STATE(1312),
    [sym_identifier] = ACTIONS(95),
    [anon_sym_export] = ACTIONS(97),
    [anon_sym_STAR] = ACTIONS(99),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(101),
    [anon_sym_RBRACE] = ACTIONS(103),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(105),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(107),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(109),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(113),
    [sym_private_property_identifier] = ACTIONS(115),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(117),
    [aux_sym_method_definition_token1] = ACTIONS(119),
    [anon_sym_get] = ACTIONS(121),
    [anon_sym_set] = ACTIONS(121),
    [sym_html_comment] = ACTIONS(5),
  },
  [3] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1661),
    [sym_object_assignment_pattern] = STATE(1281),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1661),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1661),
    [sym_spread_element] = STATE(1289),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(743),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [sym_rest_pattern] = STATE(1281),
    [sym_method_definition] = STATE(1289),
    [sym_pair] = STATE(1289),
    [sym_pair_pattern] = STATE(1281),
    [sym__property_name] = STATE(1290),
    [sym_computed_property_name] = STATE(1290),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(903),
    [aux_sym_object_repeat1] = STATE(1309),
    [aux_sym_object_pattern_repeat1] = STATE(1312),
    [sym_identifier] = ACTIONS(123),
    [anon_sym_export] = ACTIONS(125),
    [anon_sym_STAR] = ACTIONS(99),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(101),
    [anon_sym_RBRACE] = ACTIONS(127),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(129),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(107),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(131),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(113),
    [sym_private_property_identifier] = ACTIONS(115),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(133),
    [aux_sym_method_definition_token1] = ACTIONS(119),
    [anon_sym_get] = ACTIONS(135),
    [anon_sym_set] = ACTIONS(135),
    [sym_html_comment] = ACTIONS(5),
  },
  [4] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1661),
    [sym_object_assignment_pattern] = STATE(1281),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1661),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1661),
    [sym_spread_element] = STATE(1289),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(743),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [sym_rest_pattern] = STATE(1281),
    [sym_method_definition] = STATE(1289),
    [sym_pair] = STATE(1289),
    [sym_pair_pattern] = STATE(1281),
    [sym__property_name] = STATE(1290),
    [sym_computed_property_name] = STATE(1290),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(903),
    [aux_sym_object_repeat1] = STATE(1309),
    [aux_sym_object_pattern_repeat1] = STATE(1312),
    [sym_identifier] = ACTIONS(123),
    [anon_sym_export] = ACTIONS(125),
    [anon_sym_STAR] = ACTIONS(99),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(101),
    [anon_sym_RBRACE] = ACTIONS(137),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(129),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(107),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(131),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(113),
    [sym_private_property_identifier] = ACTIONS(115),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(133),
    [aux_sym_method_definition_token1] = ACTIONS(119),
    [anon_sym_get] = ACTIONS(135),
    [anon_sym_set] = ACTIONS(135),
    [sym_html_comment] = ACTIONS(5),
  },
  [5] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(16),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1661),
    [sym_object_assignment_pattern] = STATE(1281),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1661),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1661),
    [sym_spread_element] = STATE(1289),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(743),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [sym_rest_pattern] = STATE(1281),
    [sym_method_definition] = STATE(1289),
    [sym_pair] = STATE(1289),
    [sym_pair_pattern] = STATE(1281),
    [sym__property_name] = STATE(1290),
    [sym_computed_property_name] = STATE(1290),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_export_statement_repeat1] = STATE(903),
    [aux_sym_object_repeat1] = STATE(1309),
    [aux_sym_object_pattern_repeat1] = STATE(1312),
    [sym_identifier] = ACTIONS(123),
    [anon_sym_export] = ACTIONS(125),
    [anon_sym_STAR] = ACTIONS(99),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(101),
    [anon_sym_RBRACE] = ACTIONS(139),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(129),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(107),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(131),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(113),
    [sym_private_property_identifier] = ACTIONS(115),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(133),
    [aux_sym_method_definition_token1] = ACTIONS(119),
    [anon_sym_get] = ACTIONS(135),
    [anon_sym_set] = ACTIONS(135),
    [sym_html_comment] = ACTIONS(5),
  },
  [6] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(12),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1661),
    [sym_object_assignment_pattern] = STATE(1281),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1661),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1661),
    [sym_spread_element] = STATE(1333),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(743),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [sym_rest_pattern] = STATE(1281),
    [sym_method_definition] = STATE(1333),
    [sym_pair] = STATE(1333),
    [sym_pair_pattern] = STATE(1281),
    [sym__property_name] = STATE(1290),
    [sym_computed_property_name] = STATE(1290),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(903),
    [aux_sym_object_repeat1] = STATE(1334),
    [aux_sym_object_pattern_repeat1] = STATE(1312),
    [sym_identifier] = ACTIONS(141),
    [anon_sym_export] = ACTIONS(143),
    [anon_sym_STAR] = ACTIONS(99),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(101),
    [anon_sym_RBRACE] = ACTIONS(103),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(145),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(107),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(147),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(113),
    [sym_private_property_identifier] = ACTIONS(115),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(149),
    [aux_sym_method_definition_token1] = ACTIONS(119),
    [anon_sym_get] = ACTIONS(151),
    [anon_sym_set] = ACTIONS(151),
    [sym_html_comment] = ACTIONS(5),
  },
  [7] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [ts_builtin_sym_end] = ACTIONS(153),
    [sym_identifier] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(158),
    [anon_sym_default] = ACTIONS(161),
    [anon_sym_LBRACE] = ACTIONS(163),
    [anon_sym_RBRACE] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(166),
    [anon_sym_with] = ACTIONS(169),
    [anon_sym_var] = ACTIONS(172),
    [anon_sym_let] = ACTIONS(175),
    [anon_sym_const] = ACTIONS(178),
    [anon_sym_if] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(184),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_LPAREN] = ACTIONS(190),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym_await] = ACTIONS(196),
    [anon_sym_while] = ACTIONS(199),
    [anon_sym_do] = ACTIONS(202),
    [anon_sym_try] = ACTIONS(205),
    [anon_sym_break] = ACTIONS(208),
    [anon_sym_continue] = ACTIONS(211),
    [anon_sym_debugger] = ACTIONS(214),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_throw] = ACTIONS(220),
    [anon_sym_case] = ACTIONS(161),
    [anon_sym_yield] = ACTIONS(223),
    [anon_sym_LBRACK] = ACTIONS(226),
    [anon_sym_LT] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(232),
    [anon_sym_SQUOTE] = ACTIONS(235),
    [anon_sym_class] = ACTIONS(238),
    [anon_sym_async] = ACTIONS(241),
    [anon_sym_function] = ACTIONS(244),
    [anon_sym_new] = ACTIONS(247),
    [anon_sym_PLUS] = ACTIONS(250),
    [anon_sym_DASH] = ACTIONS(250),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_BANG] = ACTIONS(256),
    [anon_sym_TILDE] = ACTIONS(256),
    [anon_sym_typeof] = ACTIONS(250),
    [anon_sym_void] = ACTIONS(250),
    [anon_sym_delete] = ACTIONS(250),
    [anon_sym_PLUS_PLUS] = ACTIONS(259),
    [anon_sym_DASH_DASH] = ACTIONS(259),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(262),
    [sym_number] = ACTIONS(265),
    [sym_private_property_identifier] = ACTIONS(268),
    [sym_this] = ACTIONS(271),
    [sym_super] = ACTIONS(271),
    [sym_true] = ACTIONS(271),
    [sym_false] = ACTIONS(271),
    [sym_null] = ACTIONS(271),
    [sym_undefined] = ACTIONS(274),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_static] = ACTIONS(280),
    [anon_sym_get] = ACTIONS(280),
    [anon_sym_set] = ACTIONS(280),
    [sym_html_comment] = ACTIONS(5),
  },
  [8] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(11),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(283),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(285),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_case] = ACTIONS(283),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [9] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(287),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(289),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_case] = ACTIONS(287),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [10] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(291),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(293),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_case] = ACTIONS(291),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [11] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(295),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(297),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_case] = ACTIONS(295),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [12] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(299),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [13] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(20),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_program_repeat1] = STATE(20),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [ts_builtin_sym_end] = ACTIONS(301),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [14] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [15] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(305),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [16] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(307),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [17] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(16),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(309),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [18] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [ts_builtin_sym_end] = ACTIONS(301),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [19] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(12),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [20] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [ts_builtin_sym_end] = ACTIONS(313),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [21] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(315),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [22] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(21),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_program_repeat1] = STATE(21),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(317),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [23] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(24),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_program_repeat1] = STATE(24),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(319),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [24] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(321),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [25] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(384),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1142),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [26] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(377),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [27] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(416),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [28] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(361),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [29] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(422),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [30] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(414),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1142),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [31] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(414),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [32] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(1323),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1142),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [33] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(416),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1142),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [34] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(361),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1142),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [35] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(384),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [36] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(420),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1142),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [37] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(374),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1142),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [38] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(422),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1142),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [39] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(362),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1142),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [40] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(374),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [41] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(363),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1142),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [42] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(366),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1142),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [43] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(370),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1142),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [44] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(372),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1142),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [45] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(377),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1142),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [46] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(362),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [47] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(1653),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1142),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [48] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(425),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [49] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(363),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [50] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(345),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [51] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(366),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [52] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(420),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [53] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(370),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [54] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(372),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1166),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(67),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [55] = {
    [sym_export_statement] = STATE(385),
    [sym_declaration] = STATE(385),
    [sym_import] = STATE(1232),
    [sym_import_statement] = STATE(385),
    [sym_statement] = STATE(425),
    [sym_expression_statement] = STATE(385),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_statement_block] = STATE(385),
    [sym_if_statement] = STATE(385),
    [sym_switch_statement] = STATE(385),
    [sym_for_statement] = STATE(385),
    [sym_for_in_statement] = STATE(385),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(385),
    [sym_try_statement] = STATE(385),
    [sym_with_statement] = STATE(385),
    [sym_break_statement] = STATE(385),
    [sym_continue_statement] = STATE(385),
    [sym_debugger_statement] = STATE(385),
    [sym_return_statement] = STATE(385),
    [sym_throw_statement] = STATE(385),
    [sym_empty_statement] = STATE(385),
    [sym_labeled_statement] = STATE(385),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1435),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1142),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [56] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(581),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_STAR] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_COMMA] = ACTIONS(355),
    [anon_sym_RBRACE] = ACTIONS(355),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_RPAREN] = ACTIONS(355),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_in] = ACTIONS(363),
    [anon_sym_COLON] = ACTIONS(355),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_RBRACK] = ACTIONS(355),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(363),
    [anon_sym_DOT] = ACTIONS(363),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [sym_optional_chain] = ACTIONS(355),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_AMP_AMP] = ACTIONS(355),
    [anon_sym_PIPE_PIPE] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(363),
    [anon_sym_GT_GT_GT] = ACTIONS(355),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_AMP] = ACTIONS(363),
    [anon_sym_CARET] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(363),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_PERCENT] = ACTIONS(355),
    [anon_sym_STAR_STAR] = ACTIONS(355),
    [anon_sym_LT_EQ] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(363),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(355),
    [anon_sym_BANG_EQ] = ACTIONS(363),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(355),
    [anon_sym_GT_EQ] = ACTIONS(355),
    [anon_sym_QMARK_QMARK] = ACTIONS(355),
    [anon_sym_instanceof] = ACTIONS(363),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym__ternary_qmark] = ACTIONS(355),
    [sym_html_comment] = ACTIONS(5),
  },
  [57] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(732),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_STAR] = ACTIONS(405),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_COMMA] = ACTIONS(355),
    [anon_sym_RBRACE] = ACTIONS(355),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_in] = ACTIONS(363),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(411),
    [anon_sym_GT] = ACTIONS(363),
    [anon_sym_DOT] = ACTIONS(363),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [sym_optional_chain] = ACTIONS(355),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_AMP_AMP] = ACTIONS(355),
    [anon_sym_PIPE_PIPE] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(363),
    [anon_sym_GT_GT_GT] = ACTIONS(355),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_AMP] = ACTIONS(363),
    [anon_sym_CARET] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(363),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_PERCENT] = ACTIONS(355),
    [anon_sym_STAR_STAR] = ACTIONS(355),
    [anon_sym_LT_EQ] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(363),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(355),
    [anon_sym_BANG_EQ] = ACTIONS(363),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(355),
    [anon_sym_GT_EQ] = ACTIONS(355),
    [anon_sym_QMARK_QMARK] = ACTIONS(355),
    [anon_sym_instanceof] = ACTIONS(363),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym__automatic_semicolon] = ACTIONS(355),
    [sym__ternary_qmark] = ACTIONS(355),
    [sym_html_comment] = ACTIONS(5),
  },
  [58] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(487),
    [sym_expression] = STATE(727),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1708),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1708),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(487),
    [sym_subscript_expression] = STATE(487),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1708),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1709),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(419),
    [anon_sym_export] = ACTIONS(421),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_COMMA] = ACTIONS(355),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_await] = ACTIONS(425),
    [anon_sym_in] = ACTIONS(363),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_yield] = ACTIONS(427),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(411),
    [anon_sym_GT] = ACTIONS(363),
    [anon_sym_DOT] = ACTIONS(363),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(429),
    [anon_sym_function] = ACTIONS(417),
    [sym_optional_chain] = ACTIONS(355),
    [anon_sym_new] = ACTIONS(431),
    [anon_sym_AMP_AMP] = ACTIONS(355),
    [anon_sym_PIPE_PIPE] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(363),
    [anon_sym_GT_GT_GT] = ACTIONS(355),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_AMP] = ACTIONS(363),
    [anon_sym_CARET] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(363),
    [anon_sym_PLUS] = ACTIONS(433),
    [anon_sym_DASH] = ACTIONS(433),
    [anon_sym_SLASH] = ACTIONS(435),
    [anon_sym_PERCENT] = ACTIONS(355),
    [anon_sym_STAR_STAR] = ACTIONS(355),
    [anon_sym_LT_EQ] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(363),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(355),
    [anon_sym_BANG_EQ] = ACTIONS(363),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(355),
    [anon_sym_GT_EQ] = ACTIONS(355),
    [anon_sym_QMARK_QMARK] = ACTIONS(355),
    [anon_sym_instanceof] = ACTIONS(363),
    [anon_sym_BANG] = ACTIONS(433),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(433),
    [anon_sym_void] = ACTIONS(433),
    [anon_sym_delete] = ACTIONS(433),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(441),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(421),
    [anon_sym_get] = ACTIONS(421),
    [anon_sym_set] = ACTIONS(421),
    [sym__automatic_semicolon] = ACTIONS(355),
    [sym__ternary_qmark] = ACTIONS(355),
    [sym_html_comment] = ACTIONS(5),
  },
  [59] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(796),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1663),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1663),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1663),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(445),
    [anon_sym_export] = ACTIONS(447),
    [anon_sym_STAR] = ACTIONS(449),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(447),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_in] = ACTIONS(363),
    [anon_sym_COLON] = ACTIONS(355),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(363),
    [anon_sym_DOT] = ACTIONS(363),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(459),
    [anon_sym_function] = ACTIONS(379),
    [sym_optional_chain] = ACTIONS(355),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_AMP_AMP] = ACTIONS(355),
    [anon_sym_PIPE_PIPE] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(363),
    [anon_sym_GT_GT_GT] = ACTIONS(355),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_AMP] = ACTIONS(363),
    [anon_sym_CARET] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(363),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_PERCENT] = ACTIONS(355),
    [anon_sym_STAR_STAR] = ACTIONS(355),
    [anon_sym_LT_EQ] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(363),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(355),
    [anon_sym_BANG_EQ] = ACTIONS(363),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(355),
    [anon_sym_GT_EQ] = ACTIONS(355),
    [anon_sym_QMARK_QMARK] = ACTIONS(355),
    [anon_sym_instanceof] = ACTIONS(363),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(447),
    [anon_sym_get] = ACTIONS(447),
    [anon_sym_set] = ACTIONS(447),
    [sym__ternary_qmark] = ACTIONS(355),
    [sym_html_comment] = ACTIONS(5),
  },
  [60] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(502),
    [sym_expression] = STATE(856),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1720),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1720),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(502),
    [sym_subscript_expression] = STATE(502),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1029),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1720),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(473),
    [anon_sym_export] = ACTIONS(475),
    [anon_sym_STAR] = ACTIONS(477),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(475),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(479),
    [anon_sym_in] = ACTIONS(363),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_yield] = ACTIONS(481),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(363),
    [anon_sym_DOT] = ACTIONS(363),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(483),
    [anon_sym_function] = ACTIONS(379),
    [sym_optional_chain] = ACTIONS(355),
    [anon_sym_new] = ACTIONS(485),
    [anon_sym_AMP_AMP] = ACTIONS(355),
    [anon_sym_PIPE_PIPE] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(363),
    [anon_sym_GT_GT_GT] = ACTIONS(355),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_AMP] = ACTIONS(363),
    [anon_sym_CARET] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(363),
    [anon_sym_PLUS] = ACTIONS(487),
    [anon_sym_DASH] = ACTIONS(487),
    [anon_sym_SLASH] = ACTIONS(489),
    [anon_sym_PERCENT] = ACTIONS(355),
    [anon_sym_STAR_STAR] = ACTIONS(355),
    [anon_sym_LT_EQ] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(363),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(355),
    [anon_sym_BANG_EQ] = ACTIONS(363),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(355),
    [anon_sym_GT_EQ] = ACTIONS(355),
    [anon_sym_QMARK_QMARK] = ACTIONS(355),
    [anon_sym_instanceof] = ACTIONS(363),
    [anon_sym_BANG] = ACTIONS(487),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_typeof] = ACTIONS(487),
    [anon_sym_void] = ACTIONS(487),
    [anon_sym_delete] = ACTIONS(487),
    [anon_sym_PLUS_PLUS] = ACTIONS(493),
    [anon_sym_DASH_DASH] = ACTIONS(493),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(495),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(497),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(475),
    [anon_sym_get] = ACTIONS(475),
    [anon_sym_set] = ACTIONS(475),
    [sym__ternary_qmark] = ACTIONS(355),
    [sym_html_comment] = ACTIONS(5),
  },
  [61] = {
    [ts_builtin_sym_end] = ACTIONS(499),
    [sym_identifier] = ACTIONS(501),
    [anon_sym_export] = ACTIONS(501),
    [anon_sym_STAR] = ACTIONS(501),
    [anon_sym_default] = ACTIONS(501),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_COMMA] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(499),
    [anon_sym_import] = ACTIONS(501),
    [anon_sym_with] = ACTIONS(501),
    [anon_sym_var] = ACTIONS(501),
    [anon_sym_let] = ACTIONS(501),
    [anon_sym_const] = ACTIONS(501),
    [anon_sym_else] = ACTIONS(501),
    [anon_sym_if] = ACTIONS(501),
    [anon_sym_switch] = ACTIONS(501),
    [anon_sym_for] = ACTIONS(501),
    [anon_sym_LPAREN] = ACTIONS(499),
    [anon_sym_SEMI] = ACTIONS(499),
    [anon_sym_await] = ACTIONS(501),
    [anon_sym_in] = ACTIONS(501),
    [anon_sym_of] = ACTIONS(501),
    [anon_sym_while] = ACTIONS(501),
    [anon_sym_do] = ACTIONS(501),
    [anon_sym_try] = ACTIONS(501),
    [anon_sym_break] = ACTIONS(501),
    [anon_sym_continue] = ACTIONS(501),
    [anon_sym_debugger] = ACTIONS(501),
    [anon_sym_return] = ACTIONS(501),
    [anon_sym_throw] = ACTIONS(501),
    [anon_sym_case] = ACTIONS(501),
    [anon_sym_yield] = ACTIONS(501),
    [anon_sym_LBRACK] = ACTIONS(499),
    [anon_sym_LT] = ACTIONS(501),
    [anon_sym_GT] = ACTIONS(501),
    [anon_sym_DOT] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(499),
    [anon_sym_SQUOTE] = ACTIONS(499),
    [anon_sym_class] = ACTIONS(501),
    [anon_sym_async] = ACTIONS(501),
    [anon_sym_function] = ACTIONS(501),
    [sym_optional_chain] = ACTIONS(499),
    [anon_sym_new] = ACTIONS(501),
    [anon_sym_AMP_AMP] = ACTIONS(499),
    [anon_sym_PIPE_PIPE] = ACTIONS(499),
    [anon_sym_GT_GT] = ACTIONS(501),
    [anon_sym_GT_GT_GT] = ACTIONS(499),
    [anon_sym_LT_LT] = ACTIONS(499),
    [anon_sym_AMP] = ACTIONS(501),
    [anon_sym_CARET] = ACTIONS(499),
    [anon_sym_PIPE] = ACTIONS(501),
    [anon_sym_PLUS] = ACTIONS(501),
    [anon_sym_DASH] = ACTIONS(501),
    [anon_sym_SLASH] = ACTIONS(501),
    [anon_sym_PERCENT] = ACTIONS(499),
    [anon_sym_STAR_STAR] = ACTIONS(499),
    [anon_sym_LT_EQ] = ACTIONS(499),
    [anon_sym_EQ_EQ] = ACTIONS(501),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(499),
    [anon_sym_BANG_EQ] = ACTIONS(501),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(499),
    [anon_sym_GT_EQ] = ACTIONS(499),
    [anon_sym_QMARK_QMARK] = ACTIONS(499),
    [anon_sym_instanceof] = ACTIONS(501),
    [anon_sym_BANG] = ACTIONS(501),
    [anon_sym_TILDE] = ACTIONS(499),
    [anon_sym_typeof] = ACTIONS(501),
    [anon_sym_void] = ACTIONS(501),
    [anon_sym_delete] = ACTIONS(501),
    [anon_sym_PLUS_PLUS] = ACTIONS(499),
    [anon_sym_DASH_DASH] = ACTIONS(499),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(499),
    [sym_number] = ACTIONS(499),
    [sym_private_property_identifier] = ACTIONS(499),
    [sym_this] = ACTIONS(501),
    [sym_super] = ACTIONS(501),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [sym_null] = ACTIONS(501),
    [sym_undefined] = ACTIONS(501),
    [anon_sym_AT] = ACTIONS(499),
    [anon_sym_static] = ACTIONS(501),
    [anon_sym_get] = ACTIONS(501),
    [anon_sym_set] = ACTIONS(501),
    [sym__automatic_semicolon] = ACTIONS(499),
    [sym__ternary_qmark] = ACTIONS(499),
    [sym_html_comment] = ACTIONS(5),
  },
  [62] = {
    [ts_builtin_sym_end] = ACTIONS(503),
    [sym_identifier] = ACTIONS(505),
    [anon_sym_export] = ACTIONS(505),
    [anon_sym_STAR] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(505),
    [anon_sym_LBRACE] = ACTIONS(503),
    [anon_sym_COMMA] = ACTIONS(509),
    [anon_sym_RBRACE] = ACTIONS(503),
    [anon_sym_import] = ACTIONS(505),
    [anon_sym_with] = ACTIONS(505),
    [anon_sym_var] = ACTIONS(505),
    [anon_sym_let] = ACTIONS(505),
    [anon_sym_const] = ACTIONS(505),
    [anon_sym_else] = ACTIONS(505),
    [anon_sym_if] = ACTIONS(505),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_for] = ACTIONS(505),
    [anon_sym_LPAREN] = ACTIONS(503),
    [anon_sym_SEMI] = ACTIONS(503),
    [anon_sym_await] = ACTIONS(505),
    [anon_sym_in] = ACTIONS(507),
    [anon_sym_while] = ACTIONS(505),
    [anon_sym_do] = ACTIONS(505),
    [anon_sym_try] = ACTIONS(505),
    [anon_sym_break] = ACTIONS(505),
    [anon_sym_continue] = ACTIONS(505),
    [anon_sym_debugger] = ACTIONS(505),
    [anon_sym_return] = ACTIONS(505),
    [anon_sym_throw] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(505),
    [anon_sym_yield] = ACTIONS(505),
    [anon_sym_EQ] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(503),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_GT] = ACTIONS(507),
    [anon_sym_DOT] = ACTIONS(507),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [anon_sym_SQUOTE] = ACTIONS(503),
    [anon_sym_class] = ACTIONS(505),
    [anon_sym_async] = ACTIONS(505),
    [anon_sym_function] = ACTIONS(505),
    [sym_optional_chain] = ACTIONS(509),
    [anon_sym_new] = ACTIONS(505),
    [anon_sym_AMP_AMP] = ACTIONS(509),
    [anon_sym_PIPE_PIPE] = ACTIONS(509),
    [anon_sym_GT_GT] = ACTIONS(507),
    [anon_sym_GT_GT_GT] = ACTIONS(509),
    [anon_sym_LT_LT] = ACTIONS(509),
    [anon_sym_AMP] = ACTIONS(507),
    [anon_sym_CARET] = ACTIONS(509),
    [anon_sym_PIPE] = ACTIONS(507),
    [anon_sym_PLUS] = ACTIONS(505),
    [anon_sym_DASH] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(505),
    [anon_sym_PERCENT] = ACTIONS(509),
    [anon_sym_STAR_STAR] = ACTIONS(509),
    [anon_sym_LT_EQ] = ACTIONS(509),
    [anon_sym_EQ_EQ] = ACTIONS(507),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(509),
    [anon_sym_BANG_EQ] = ACTIONS(507),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(509),
    [anon_sym_GT_EQ] = ACTIONS(509),
    [anon_sym_QMARK_QMARK] = ACTIONS(509),
    [anon_sym_instanceof] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(505),
    [anon_sym_TILDE] = ACTIONS(503),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_void] = ACTIONS(505),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(503),
    [anon_sym_DASH_DASH] = ACTIONS(503),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_number] = ACTIONS(503),
    [sym_private_property_identifier] = ACTIONS(503),
    [sym_this] = ACTIONS(505),
    [sym_super] = ACTIONS(505),
    [sym_true] = ACTIONS(505),
    [sym_false] = ACTIONS(505),
    [sym_null] = ACTIONS(505),
    [sym_undefined] = ACTIONS(505),
    [anon_sym_AT] = ACTIONS(503),
    [anon_sym_static] = ACTIONS(505),
    [anon_sym_get] = ACTIONS(505),
    [anon_sym_set] = ACTIONS(505),
    [sym__automatic_semicolon] = ACTIONS(513),
    [sym__ternary_qmark] = ACTIONS(509),
    [sym_html_comment] = ACTIONS(5),
  },
  [63] = {
    [ts_builtin_sym_end] = ACTIONS(499),
    [sym_identifier] = ACTIONS(501),
    [anon_sym_export] = ACTIONS(501),
    [anon_sym_STAR] = ACTIONS(501),
    [anon_sym_default] = ACTIONS(501),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_COMMA] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(499),
    [anon_sym_import] = ACTIONS(501),
    [anon_sym_with] = ACTIONS(501),
    [anon_sym_var] = ACTIONS(501),
    [anon_sym_let] = ACTIONS(501),
    [anon_sym_const] = ACTIONS(501),
    [anon_sym_else] = ACTIONS(501),
    [anon_sym_if] = ACTIONS(501),
    [anon_sym_switch] = ACTIONS(501),
    [anon_sym_for] = ACTIONS(501),
    [anon_sym_LPAREN] = ACTIONS(499),
    [anon_sym_SEMI] = ACTIONS(499),
    [anon_sym_await] = ACTIONS(501),
    [anon_sym_in] = ACTIONS(501),
    [anon_sym_of] = ACTIONS(501),
    [anon_sym_while] = ACTIONS(501),
    [anon_sym_do] = ACTIONS(501),
    [anon_sym_try] = ACTIONS(501),
    [anon_sym_break] = ACTIONS(501),
    [anon_sym_continue] = ACTIONS(501),
    [anon_sym_debugger] = ACTIONS(501),
    [anon_sym_return] = ACTIONS(501),
    [anon_sym_throw] = ACTIONS(501),
    [anon_sym_case] = ACTIONS(501),
    [anon_sym_yield] = ACTIONS(501),
    [anon_sym_LBRACK] = ACTIONS(499),
    [anon_sym_LT] = ACTIONS(501),
    [anon_sym_GT] = ACTIONS(501),
    [anon_sym_DOT] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(499),
    [anon_sym_SQUOTE] = ACTIONS(499),
    [anon_sym_class] = ACTIONS(501),
    [anon_sym_async] = ACTIONS(501),
    [anon_sym_function] = ACTIONS(501),
    [sym_optional_chain] = ACTIONS(499),
    [anon_sym_new] = ACTIONS(501),
    [anon_sym_AMP_AMP] = ACTIONS(499),
    [anon_sym_PIPE_PIPE] = ACTIONS(499),
    [anon_sym_GT_GT] = ACTIONS(501),
    [anon_sym_GT_GT_GT] = ACTIONS(499),
    [anon_sym_LT_LT] = ACTIONS(499),
    [anon_sym_AMP] = ACTIONS(501),
    [anon_sym_CARET] = ACTIONS(499),
    [anon_sym_PIPE] = ACTIONS(501),
    [anon_sym_PLUS] = ACTIONS(501),
    [anon_sym_DASH] = ACTIONS(501),
    [anon_sym_SLASH] = ACTIONS(501),
    [anon_sym_PERCENT] = ACTIONS(499),
    [anon_sym_STAR_STAR] = ACTIONS(499),
    [anon_sym_LT_EQ] = ACTIONS(499),
    [anon_sym_EQ_EQ] = ACTIONS(501),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(499),
    [anon_sym_BANG_EQ] = ACTIONS(501),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(499),
    [anon_sym_GT_EQ] = ACTIONS(499),
    [anon_sym_QMARK_QMARK] = ACTIONS(499),
    [anon_sym_instanceof] = ACTIONS(501),
    [anon_sym_BANG] = ACTIONS(501),
    [anon_sym_TILDE] = ACTIONS(499),
    [anon_sym_typeof] = ACTIONS(501),
    [anon_sym_void] = ACTIONS(501),
    [anon_sym_delete] = ACTIONS(501),
    [anon_sym_PLUS_PLUS] = ACTIONS(499),
    [anon_sym_DASH_DASH] = ACTIONS(499),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(499),
    [sym_number] = ACTIONS(499),
    [sym_private_property_identifier] = ACTIONS(499),
    [sym_this] = ACTIONS(501),
    [sym_super] = ACTIONS(501),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [sym_null] = ACTIONS(501),
    [sym_undefined] = ACTIONS(501),
    [anon_sym_AT] = ACTIONS(499),
    [anon_sym_static] = ACTIONS(501),
    [anon_sym_get] = ACTIONS(501),
    [anon_sym_set] = ACTIONS(501),
    [sym__automatic_semicolon] = ACTIONS(515),
    [sym__ternary_qmark] = ACTIONS(499),
    [sym_html_comment] = ACTIONS(5),
  },
  [64] = {
    [ts_builtin_sym_end] = ACTIONS(503),
    [sym_identifier] = ACTIONS(505),
    [anon_sym_export] = ACTIONS(505),
    [anon_sym_STAR] = ACTIONS(505),
    [anon_sym_default] = ACTIONS(505),
    [anon_sym_LBRACE] = ACTIONS(503),
    [anon_sym_COMMA] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(503),
    [anon_sym_import] = ACTIONS(505),
    [anon_sym_with] = ACTIONS(505),
    [anon_sym_var] = ACTIONS(505),
    [anon_sym_let] = ACTIONS(505),
    [anon_sym_const] = ACTIONS(505),
    [anon_sym_else] = ACTIONS(505),
    [anon_sym_if] = ACTIONS(505),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_for] = ACTIONS(505),
    [anon_sym_LPAREN] = ACTIONS(503),
    [anon_sym_SEMI] = ACTIONS(503),
    [anon_sym_await] = ACTIONS(505),
    [anon_sym_in] = ACTIONS(505),
    [anon_sym_of] = ACTIONS(505),
    [anon_sym_while] = ACTIONS(505),
    [anon_sym_do] = ACTIONS(505),
    [anon_sym_try] = ACTIONS(505),
    [anon_sym_break] = ACTIONS(505),
    [anon_sym_continue] = ACTIONS(505),
    [anon_sym_debugger] = ACTIONS(505),
    [anon_sym_return] = ACTIONS(505),
    [anon_sym_throw] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(505),
    [anon_sym_yield] = ACTIONS(505),
    [anon_sym_LBRACK] = ACTIONS(503),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_GT] = ACTIONS(505),
    [anon_sym_DOT] = ACTIONS(505),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [anon_sym_SQUOTE] = ACTIONS(503),
    [anon_sym_class] = ACTIONS(505),
    [anon_sym_async] = ACTIONS(505),
    [anon_sym_function] = ACTIONS(505),
    [sym_optional_chain] = ACTIONS(503),
    [anon_sym_new] = ACTIONS(505),
    [anon_sym_AMP_AMP] = ACTIONS(503),
    [anon_sym_PIPE_PIPE] = ACTIONS(503),
    [anon_sym_GT_GT] = ACTIONS(505),
    [anon_sym_GT_GT_GT] = ACTIONS(503),
    [anon_sym_LT_LT] = ACTIONS(503),
    [anon_sym_AMP] = ACTIONS(505),
    [anon_sym_CARET] = ACTIONS(503),
    [anon_sym_PIPE] = ACTIONS(505),
    [anon_sym_PLUS] = ACTIONS(505),
    [anon_sym_DASH] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(505),
    [anon_sym_PERCENT] = ACTIONS(503),
    [anon_sym_STAR_STAR] = ACTIONS(503),
    [anon_sym_LT_EQ] = ACTIONS(503),
    [anon_sym_EQ_EQ] = ACTIONS(505),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(503),
    [anon_sym_BANG_EQ] = ACTIONS(505),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(503),
    [anon_sym_GT_EQ] = ACTIONS(503),
    [anon_sym_QMARK_QMARK] = ACTIONS(503),
    [anon_sym_instanceof] = ACTIONS(505),
    [anon_sym_BANG] = ACTIONS(505),
    [anon_sym_TILDE] = ACTIONS(503),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_void] = ACTIONS(505),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(503),
    [anon_sym_DASH_DASH] = ACTIONS(503),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_number] = ACTIONS(503),
    [sym_private_property_identifier] = ACTIONS(503),
    [sym_this] = ACTIONS(505),
    [sym_super] = ACTIONS(505),
    [sym_true] = ACTIONS(505),
    [sym_false] = ACTIONS(505),
    [sym_null] = ACTIONS(505),
    [sym_undefined] = ACTIONS(505),
    [anon_sym_AT] = ACTIONS(503),
    [anon_sym_static] = ACTIONS(505),
    [anon_sym_get] = ACTIONS(505),
    [anon_sym_set] = ACTIONS(505),
    [sym__automatic_semicolon] = ACTIONS(517),
    [sym__ternary_qmark] = ACTIONS(503),
    [sym_html_comment] = ACTIONS(5),
  },
  [65] = {
    [ts_builtin_sym_end] = ACTIONS(519),
    [sym_identifier] = ACTIONS(521),
    [anon_sym_export] = ACTIONS(521),
    [anon_sym_STAR] = ACTIONS(521),
    [anon_sym_default] = ACTIONS(521),
    [anon_sym_LBRACE] = ACTIONS(519),
    [anon_sym_COMMA] = ACTIONS(519),
    [anon_sym_RBRACE] = ACTIONS(519),
    [anon_sym_import] = ACTIONS(521),
    [anon_sym_with] = ACTIONS(521),
    [anon_sym_var] = ACTIONS(521),
    [anon_sym_let] = ACTIONS(521),
    [anon_sym_const] = ACTIONS(521),
    [anon_sym_else] = ACTIONS(521),
    [anon_sym_if] = ACTIONS(521),
    [anon_sym_switch] = ACTIONS(521),
    [anon_sym_for] = ACTIONS(521),
    [anon_sym_LPAREN] = ACTIONS(519),
    [anon_sym_SEMI] = ACTIONS(519),
    [anon_sym_await] = ACTIONS(521),
    [anon_sym_in] = ACTIONS(521),
    [anon_sym_of] = ACTIONS(521),
    [anon_sym_while] = ACTIONS(521),
    [anon_sym_do] = ACTIONS(521),
    [anon_sym_try] = ACTIONS(521),
    [anon_sym_break] = ACTIONS(521),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_debugger] = ACTIONS(521),
    [anon_sym_return] = ACTIONS(521),
    [anon_sym_throw] = ACTIONS(521),
    [anon_sym_case] = ACTIONS(521),
    [anon_sym_yield] = ACTIONS(521),
    [anon_sym_LBRACK] = ACTIONS(519),
    [anon_sym_LT] = ACTIONS(521),
    [anon_sym_GT] = ACTIONS(521),
    [anon_sym_DOT] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(519),
    [anon_sym_SQUOTE] = ACTIONS(519),
    [anon_sym_class] = ACTIONS(521),
    [anon_sym_async] = ACTIONS(521),
    [anon_sym_function] = ACTIONS(521),
    [sym_optional_chain] = ACTIONS(519),
    [anon_sym_new] = ACTIONS(521),
    [anon_sym_AMP_AMP] = ACTIONS(519),
    [anon_sym_PIPE_PIPE] = ACTIONS(519),
    [anon_sym_GT_GT] = ACTIONS(521),
    [anon_sym_GT_GT_GT] = ACTIONS(519),
    [anon_sym_LT_LT] = ACTIONS(519),
    [anon_sym_AMP] = ACTIONS(521),
    [anon_sym_CARET] = ACTIONS(519),
    [anon_sym_PIPE] = ACTIONS(521),
    [anon_sym_PLUS] = ACTIONS(521),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_SLASH] = ACTIONS(521),
    [anon_sym_PERCENT] = ACTIONS(519),
    [anon_sym_STAR_STAR] = ACTIONS(519),
    [anon_sym_LT_EQ] = ACTIONS(519),
    [anon_sym_EQ_EQ] = ACTIONS(521),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(519),
    [anon_sym_BANG_EQ] = ACTIONS(521),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(519),
    [anon_sym_GT_EQ] = ACTIONS(519),
    [anon_sym_QMARK_QMARK] = ACTIONS(519),
    [anon_sym_instanceof] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_TILDE] = ACTIONS(519),
    [anon_sym_typeof] = ACTIONS(521),
    [anon_sym_void] = ACTIONS(521),
    [anon_sym_delete] = ACTIONS(521),
    [anon_sym_PLUS_PLUS] = ACTIONS(519),
    [anon_sym_DASH_DASH] = ACTIONS(519),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(519),
    [sym_number] = ACTIONS(519),
    [sym_private_property_identifier] = ACTIONS(519),
    [sym_this] = ACTIONS(521),
    [sym_super] = ACTIONS(521),
    [sym_true] = ACTIONS(521),
    [sym_false] = ACTIONS(521),
    [sym_null] = ACTIONS(521),
    [sym_undefined] = ACTIONS(521),
    [anon_sym_AT] = ACTIONS(519),
    [anon_sym_static] = ACTIONS(521),
    [anon_sym_get] = ACTIONS(521),
    [anon_sym_set] = ACTIONS(521),
    [sym__automatic_semicolon] = ACTIONS(519),
    [sym__ternary_qmark] = ACTIONS(519),
    [sym_html_comment] = ACTIONS(5),
  },
  [66] = {
    [ts_builtin_sym_end] = ACTIONS(523),
    [sym_identifier] = ACTIONS(525),
    [anon_sym_export] = ACTIONS(525),
    [anon_sym_STAR] = ACTIONS(525),
    [anon_sym_default] = ACTIONS(525),
    [anon_sym_LBRACE] = ACTIONS(523),
    [anon_sym_COMMA] = ACTIONS(523),
    [anon_sym_RBRACE] = ACTIONS(523),
    [anon_sym_import] = ACTIONS(525),
    [anon_sym_with] = ACTIONS(525),
    [anon_sym_var] = ACTIONS(525),
    [anon_sym_let] = ACTIONS(525),
    [anon_sym_const] = ACTIONS(525),
    [anon_sym_else] = ACTIONS(525),
    [anon_sym_if] = ACTIONS(525),
    [anon_sym_switch] = ACTIONS(525),
    [anon_sym_for] = ACTIONS(525),
    [anon_sym_LPAREN] = ACTIONS(523),
    [anon_sym_SEMI] = ACTIONS(523),
    [anon_sym_await] = ACTIONS(525),
    [anon_sym_in] = ACTIONS(525),
    [anon_sym_of] = ACTIONS(525),
    [anon_sym_while] = ACTIONS(525),
    [anon_sym_do] = ACTIONS(525),
    [anon_sym_try] = ACTIONS(525),
    [anon_sym_break] = ACTIONS(525),
    [anon_sym_continue] = ACTIONS(525),
    [anon_sym_debugger] = ACTIONS(525),
    [anon_sym_return] = ACTIONS(525),
    [anon_sym_throw] = ACTIONS(525),
    [anon_sym_case] = ACTIONS(525),
    [anon_sym_yield] = ACTIONS(525),
    [anon_sym_LBRACK] = ACTIONS(523),
    [anon_sym_LT] = ACTIONS(525),
    [anon_sym_GT] = ACTIONS(525),
    [anon_sym_DOT] = ACTIONS(525),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(523),
    [anon_sym_class] = ACTIONS(525),
    [anon_sym_async] = ACTIONS(525),
    [anon_sym_function] = ACTIONS(525),
    [sym_optional_chain] = ACTIONS(523),
    [anon_sym_new] = ACTIONS(525),
    [anon_sym_AMP_AMP] = ACTIONS(523),
    [anon_sym_PIPE_PIPE] = ACTIONS(523),
    [anon_sym_GT_GT] = ACTIONS(525),
    [anon_sym_GT_GT_GT] = ACTIONS(523),
    [anon_sym_LT_LT] = ACTIONS(523),
    [anon_sym_AMP] = ACTIONS(525),
    [anon_sym_CARET] = ACTIONS(523),
    [anon_sym_PIPE] = ACTIONS(525),
    [anon_sym_PLUS] = ACTIONS(525),
    [anon_sym_DASH] = ACTIONS(525),
    [anon_sym_SLASH] = ACTIONS(525),
    [anon_sym_PERCENT] = ACTIONS(523),
    [anon_sym_STAR_STAR] = ACTIONS(523),
    [anon_sym_LT_EQ] = ACTIONS(523),
    [anon_sym_EQ_EQ] = ACTIONS(525),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(523),
    [anon_sym_BANG_EQ] = ACTIONS(525),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(523),
    [anon_sym_GT_EQ] = ACTIONS(523),
    [anon_sym_QMARK_QMARK] = ACTIONS(523),
    [anon_sym_instanceof] = ACTIONS(525),
    [anon_sym_BANG] = ACTIONS(525),
    [anon_sym_TILDE] = ACTIONS(523),
    [anon_sym_typeof] = ACTIONS(525),
    [anon_sym_void] = ACTIONS(525),
    [anon_sym_delete] = ACTIONS(525),
    [anon_sym_PLUS_PLUS] = ACTIONS(523),
    [anon_sym_DASH_DASH] = ACTIONS(523),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(523),
    [sym_number] = ACTIONS(523),
    [sym_private_property_identifier] = ACTIONS(523),
    [sym_this] = ACTIONS(525),
    [sym_super] = ACTIONS(525),
    [sym_true] = ACTIONS(525),
    [sym_false] = ACTIONS(525),
    [sym_null] = ACTIONS(525),
    [sym_undefined] = ACTIONS(525),
    [anon_sym_AT] = ACTIONS(523),
    [anon_sym_static] = ACTIONS(525),
    [anon_sym_get] = ACTIONS(525),
    [anon_sym_set] = ACTIONS(525),
    [sym__automatic_semicolon] = ACTIONS(523),
    [sym__ternary_qmark] = ACTIONS(523),
    [sym_html_comment] = ACTIONS(5),
  },
  [67] = {
    [ts_builtin_sym_end] = ACTIONS(527),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(529),
    [anon_sym_STAR] = ACTIONS(529),
    [anon_sym_default] = ACTIONS(529),
    [anon_sym_LBRACE] = ACTIONS(527),
    [anon_sym_COMMA] = ACTIONS(527),
    [anon_sym_RBRACE] = ACTIONS(527),
    [anon_sym_import] = ACTIONS(529),
    [anon_sym_with] = ACTIONS(529),
    [anon_sym_var] = ACTIONS(529),
    [anon_sym_let] = ACTIONS(529),
    [anon_sym_const] = ACTIONS(529),
    [anon_sym_else] = ACTIONS(529),
    [anon_sym_if] = ACTIONS(529),
    [anon_sym_switch] = ACTIONS(529),
    [anon_sym_for] = ACTIONS(529),
    [anon_sym_LPAREN] = ACTIONS(527),
    [anon_sym_SEMI] = ACTIONS(527),
    [anon_sym_await] = ACTIONS(529),
    [anon_sym_in] = ACTIONS(529),
    [anon_sym_of] = ACTIONS(529),
    [anon_sym_while] = ACTIONS(529),
    [anon_sym_do] = ACTIONS(529),
    [anon_sym_try] = ACTIONS(529),
    [anon_sym_break] = ACTIONS(529),
    [anon_sym_continue] = ACTIONS(529),
    [anon_sym_debugger] = ACTIONS(529),
    [anon_sym_return] = ACTIONS(529),
    [anon_sym_throw] = ACTIONS(529),
    [anon_sym_case] = ACTIONS(529),
    [anon_sym_yield] = ACTIONS(529),
    [anon_sym_LBRACK] = ACTIONS(527),
    [anon_sym_LT] = ACTIONS(529),
    [anon_sym_GT] = ACTIONS(529),
    [anon_sym_DOT] = ACTIONS(529),
    [anon_sym_DQUOTE] = ACTIONS(527),
    [anon_sym_SQUOTE] = ACTIONS(527),
    [anon_sym_class] = ACTIONS(529),
    [anon_sym_async] = ACTIONS(529),
    [anon_sym_function] = ACTIONS(529),
    [sym_optional_chain] = ACTIONS(527),
    [anon_sym_new] = ACTIONS(529),
    [anon_sym_AMP_AMP] = ACTIONS(527),
    [anon_sym_PIPE_PIPE] = ACTIONS(527),
    [anon_sym_GT_GT] = ACTIONS(529),
    [anon_sym_GT_GT_GT] = ACTIONS(527),
    [anon_sym_LT_LT] = ACTIONS(527),
    [anon_sym_AMP] = ACTIONS(529),
    [anon_sym_CARET] = ACTIONS(527),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_PLUS] = ACTIONS(529),
    [anon_sym_DASH] = ACTIONS(529),
    [anon_sym_SLASH] = ACTIONS(529),
    [anon_sym_PERCENT] = ACTIONS(527),
    [anon_sym_STAR_STAR] = ACTIONS(527),
    [anon_sym_LT_EQ] = ACTIONS(527),
    [anon_sym_EQ_EQ] = ACTIONS(529),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(527),
    [anon_sym_BANG_EQ] = ACTIONS(529),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(527),
    [anon_sym_GT_EQ] = ACTIONS(527),
    [anon_sym_QMARK_QMARK] = ACTIONS(527),
    [anon_sym_instanceof] = ACTIONS(529),
    [anon_sym_BANG] = ACTIONS(529),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_typeof] = ACTIONS(529),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(529),
    [anon_sym_PLUS_PLUS] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(527),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(527),
    [sym_number] = ACTIONS(527),
    [sym_private_property_identifier] = ACTIONS(527),
    [sym_this] = ACTIONS(529),
    [sym_super] = ACTIONS(529),
    [sym_true] = ACTIONS(529),
    [sym_false] = ACTIONS(529),
    [sym_null] = ACTIONS(529),
    [sym_undefined] = ACTIONS(529),
    [anon_sym_AT] = ACTIONS(527),
    [anon_sym_static] = ACTIONS(529),
    [anon_sym_get] = ACTIONS(529),
    [anon_sym_set] = ACTIONS(529),
    [sym__automatic_semicolon] = ACTIONS(527),
    [sym__ternary_qmark] = ACTIONS(527),
    [sym_html_comment] = ACTIONS(5),
  },
  [68] = {
    [ts_builtin_sym_end] = ACTIONS(531),
    [sym_identifier] = ACTIONS(533),
    [anon_sym_export] = ACTIONS(533),
    [anon_sym_STAR] = ACTIONS(535),
    [anon_sym_default] = ACTIONS(533),
    [anon_sym_LBRACE] = ACTIONS(531),
    [anon_sym_COMMA] = ACTIONS(537),
    [anon_sym_RBRACE] = ACTIONS(531),
    [anon_sym_import] = ACTIONS(533),
    [anon_sym_with] = ACTIONS(533),
    [anon_sym_var] = ACTIONS(533),
    [anon_sym_let] = ACTIONS(533),
    [anon_sym_const] = ACTIONS(533),
    [anon_sym_else] = ACTIONS(533),
    [anon_sym_if] = ACTIONS(533),
    [anon_sym_switch] = ACTIONS(533),
    [anon_sym_for] = ACTIONS(533),
    [anon_sym_LPAREN] = ACTIONS(531),
    [anon_sym_SEMI] = ACTIONS(531),
    [anon_sym_await] = ACTIONS(533),
    [anon_sym_in] = ACTIONS(535),
    [anon_sym_while] = ACTIONS(533),
    [anon_sym_do] = ACTIONS(533),
    [anon_sym_try] = ACTIONS(533),
    [anon_sym_break] = ACTIONS(533),
    [anon_sym_continue] = ACTIONS(533),
    [anon_sym_debugger] = ACTIONS(533),
    [anon_sym_return] = ACTIONS(533),
    [anon_sym_throw] = ACTIONS(533),
    [anon_sym_case] = ACTIONS(533),
    [anon_sym_yield] = ACTIONS(533),
    [anon_sym_LBRACK] = ACTIONS(531),
    [anon_sym_LT] = ACTIONS(533),
    [anon_sym_GT] = ACTIONS(535),
    [anon_sym_DOT] = ACTIONS(535),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_SQUOTE] = ACTIONS(531),
    [anon_sym_class] = ACTIONS(533),
    [anon_sym_async] = ACTIONS(533),
    [anon_sym_function] = ACTIONS(533),
    [sym_optional_chain] = ACTIONS(537),
    [anon_sym_new] = ACTIONS(533),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_GT_GT] = ACTIONS(535),
    [anon_sym_GT_GT_GT] = ACTIONS(537),
    [anon_sym_LT_LT] = ACTIONS(537),
    [anon_sym_AMP] = ACTIONS(535),
    [anon_sym_CARET] = ACTIONS(537),
    [anon_sym_PIPE] = ACTIONS(535),
    [anon_sym_PLUS] = ACTIONS(533),
    [anon_sym_DASH] = ACTIONS(533),
    [anon_sym_SLASH] = ACTIONS(533),
    [anon_sym_PERCENT] = ACTIONS(537),
    [anon_sym_STAR_STAR] = ACTIONS(537),
    [anon_sym_LT_EQ] = ACTIONS(537),
    [anon_sym_EQ_EQ] = ACTIONS(535),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(537),
    [anon_sym_BANG_EQ] = ACTIONS(535),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(537),
    [anon_sym_GT_EQ] = ACTIONS(537),
    [anon_sym_QMARK_QMARK] = ACTIONS(537),
    [anon_sym_instanceof] = ACTIONS(535),
    [anon_sym_BANG] = ACTIONS(533),
    [anon_sym_TILDE] = ACTIONS(531),
    [anon_sym_typeof] = ACTIONS(533),
    [anon_sym_void] = ACTIONS(533),
    [anon_sym_delete] = ACTIONS(533),
    [anon_sym_PLUS_PLUS] = ACTIONS(531),
    [anon_sym_DASH_DASH] = ACTIONS(531),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(531),
    [sym_number] = ACTIONS(531),
    [sym_private_property_identifier] = ACTIONS(531),
    [sym_this] = ACTIONS(533),
    [sym_super] = ACTIONS(533),
    [sym_true] = ACTIONS(533),
    [sym_false] = ACTIONS(533),
    [sym_null] = ACTIONS(533),
    [sym_undefined] = ACTIONS(533),
    [anon_sym_AT] = ACTIONS(531),
    [anon_sym_static] = ACTIONS(533),
    [anon_sym_get] = ACTIONS(533),
    [anon_sym_set] = ACTIONS(533),
    [sym__automatic_semicolon] = ACTIONS(539),
    [sym__ternary_qmark] = ACTIONS(537),
    [sym_html_comment] = ACTIONS(5),
  },
  [69] = {
    [ts_builtin_sym_end] = ACTIONS(541),
    [sym_identifier] = ACTIONS(543),
    [anon_sym_export] = ACTIONS(543),
    [anon_sym_STAR] = ACTIONS(545),
    [anon_sym_default] = ACTIONS(543),
    [anon_sym_LBRACE] = ACTIONS(541),
    [anon_sym_COMMA] = ACTIONS(547),
    [anon_sym_RBRACE] = ACTIONS(541),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_with] = ACTIONS(543),
    [anon_sym_var] = ACTIONS(543),
    [anon_sym_let] = ACTIONS(543),
    [anon_sym_const] = ACTIONS(543),
    [anon_sym_else] = ACTIONS(543),
    [anon_sym_if] = ACTIONS(543),
    [anon_sym_switch] = ACTIONS(543),
    [anon_sym_for] = ACTIONS(543),
    [anon_sym_LPAREN] = ACTIONS(541),
    [anon_sym_SEMI] = ACTIONS(541),
    [anon_sym_await] = ACTIONS(543),
    [anon_sym_in] = ACTIONS(545),
    [anon_sym_while] = ACTIONS(543),
    [anon_sym_do] = ACTIONS(543),
    [anon_sym_try] = ACTIONS(543),
    [anon_sym_break] = ACTIONS(543),
    [anon_sym_continue] = ACTIONS(543),
    [anon_sym_debugger] = ACTIONS(543),
    [anon_sym_return] = ACTIONS(543),
    [anon_sym_throw] = ACTIONS(543),
    [anon_sym_case] = ACTIONS(543),
    [anon_sym_yield] = ACTIONS(543),
    [anon_sym_LBRACK] = ACTIONS(541),
    [anon_sym_LT] = ACTIONS(543),
    [anon_sym_GT] = ACTIONS(545),
    [anon_sym_DOT] = ACTIONS(545),
    [anon_sym_DQUOTE] = ACTIONS(541),
    [anon_sym_SQUOTE] = ACTIONS(541),
    [anon_sym_class] = ACTIONS(543),
    [anon_sym_async] = ACTIONS(543),
    [anon_sym_function] = ACTIONS(543),
    [sym_optional_chain] = ACTIONS(547),
    [anon_sym_new] = ACTIONS(543),
    [anon_sym_AMP_AMP] = ACTIONS(547),
    [anon_sym_PIPE_PIPE] = ACTIONS(547),
    [anon_sym_GT_GT] = ACTIONS(545),
    [anon_sym_GT_GT_GT] = ACTIONS(547),
    [anon_sym_LT_LT] = ACTIONS(547),
    [anon_sym_AMP] = ACTIONS(545),
    [anon_sym_CARET] = ACTIONS(547),
    [anon_sym_PIPE] = ACTIONS(545),
    [anon_sym_PLUS] = ACTIONS(543),
    [anon_sym_DASH] = ACTIONS(543),
    [anon_sym_SLASH] = ACTIONS(543),
    [anon_sym_PERCENT] = ACTIONS(547),
    [anon_sym_STAR_STAR] = ACTIONS(547),
    [anon_sym_LT_EQ] = ACTIONS(547),
    [anon_sym_EQ_EQ] = ACTIONS(545),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(547),
    [anon_sym_BANG_EQ] = ACTIONS(545),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(547),
    [anon_sym_GT_EQ] = ACTIONS(547),
    [anon_sym_QMARK_QMARK] = ACTIONS(547),
    [anon_sym_instanceof] = ACTIONS(545),
    [anon_sym_BANG] = ACTIONS(543),
    [anon_sym_TILDE] = ACTIONS(541),
    [anon_sym_typeof] = ACTIONS(543),
    [anon_sym_void] = ACTIONS(543),
    [anon_sym_delete] = ACTIONS(543),
    [anon_sym_PLUS_PLUS] = ACTIONS(541),
    [anon_sym_DASH_DASH] = ACTIONS(541),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(541),
    [sym_number] = ACTIONS(541),
    [sym_private_property_identifier] = ACTIONS(541),
    [sym_this] = ACTIONS(543),
    [sym_super] = ACTIONS(543),
    [sym_true] = ACTIONS(543),
    [sym_false] = ACTIONS(543),
    [sym_null] = ACTIONS(543),
    [sym_undefined] = ACTIONS(543),
    [anon_sym_AT] = ACTIONS(541),
    [anon_sym_static] = ACTIONS(543),
    [anon_sym_get] = ACTIONS(543),
    [anon_sym_set] = ACTIONS(543),
    [sym__automatic_semicolon] = ACTIONS(549),
    [sym__ternary_qmark] = ACTIONS(547),
    [sym_html_comment] = ACTIONS(5),
  },
  [70] = {
    [ts_builtin_sym_end] = ACTIONS(551),
    [sym_identifier] = ACTIONS(553),
    [anon_sym_export] = ACTIONS(553),
    [anon_sym_STAR] = ACTIONS(555),
    [anon_sym_default] = ACTIONS(553),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_COMMA] = ACTIONS(557),
    [anon_sym_RBRACE] = ACTIONS(551),
    [anon_sym_import] = ACTIONS(553),
    [anon_sym_with] = ACTIONS(553),
    [anon_sym_var] = ACTIONS(553),
    [anon_sym_let] = ACTIONS(553),
    [anon_sym_const] = ACTIONS(553),
    [anon_sym_else] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(553),
    [anon_sym_for] = ACTIONS(553),
    [anon_sym_LPAREN] = ACTIONS(551),
    [anon_sym_SEMI] = ACTIONS(551),
    [anon_sym_await] = ACTIONS(553),
    [anon_sym_in] = ACTIONS(555),
    [anon_sym_while] = ACTIONS(553),
    [anon_sym_do] = ACTIONS(553),
    [anon_sym_try] = ACTIONS(553),
    [anon_sym_break] = ACTIONS(553),
    [anon_sym_continue] = ACTIONS(553),
    [anon_sym_debugger] = ACTIONS(553),
    [anon_sym_return] = ACTIONS(553),
    [anon_sym_throw] = ACTIONS(553),
    [anon_sym_case] = ACTIONS(553),
    [anon_sym_yield] = ACTIONS(553),
    [anon_sym_LBRACK] = ACTIONS(551),
    [anon_sym_LT] = ACTIONS(553),
    [anon_sym_GT] = ACTIONS(555),
    [anon_sym_DOT] = ACTIONS(555),
    [anon_sym_DQUOTE] = ACTIONS(551),
    [anon_sym_SQUOTE] = ACTIONS(551),
    [anon_sym_class] = ACTIONS(553),
    [anon_sym_async] = ACTIONS(553),
    [anon_sym_function] = ACTIONS(553),
    [sym_optional_chain] = ACTIONS(557),
    [anon_sym_new] = ACTIONS(553),
    [anon_sym_AMP_AMP] = ACTIONS(557),
    [anon_sym_PIPE_PIPE] = ACTIONS(557),
    [anon_sym_GT_GT] = ACTIONS(555),
    [anon_sym_GT_GT_GT] = ACTIONS(557),
    [anon_sym_LT_LT] = ACTIONS(557),
    [anon_sym_AMP] = ACTIONS(555),
    [anon_sym_CARET] = ACTIONS(557),
    [anon_sym_PIPE] = ACTIONS(555),
    [anon_sym_PLUS] = ACTIONS(553),
    [anon_sym_DASH] = ACTIONS(553),
    [anon_sym_SLASH] = ACTIONS(553),
    [anon_sym_PERCENT] = ACTIONS(557),
    [anon_sym_STAR_STAR] = ACTIONS(557),
    [anon_sym_LT_EQ] = ACTIONS(557),
    [anon_sym_EQ_EQ] = ACTIONS(555),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(557),
    [anon_sym_BANG_EQ] = ACTIONS(555),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(557),
    [anon_sym_GT_EQ] = ACTIONS(557),
    [anon_sym_QMARK_QMARK] = ACTIONS(557),
    [anon_sym_instanceof] = ACTIONS(555),
    [anon_sym_BANG] = ACTIONS(553),
    [anon_sym_TILDE] = ACTIONS(551),
    [anon_sym_typeof] = ACTIONS(553),
    [anon_sym_void] = ACTIONS(553),
    [anon_sym_delete] = ACTIONS(553),
    [anon_sym_PLUS_PLUS] = ACTIONS(551),
    [anon_sym_DASH_DASH] = ACTIONS(551),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(551),
    [sym_number] = ACTIONS(551),
    [sym_private_property_identifier] = ACTIONS(551),
    [sym_this] = ACTIONS(553),
    [sym_super] = ACTIONS(553),
    [sym_true] = ACTIONS(553),
    [sym_false] = ACTIONS(553),
    [sym_null] = ACTIONS(553),
    [sym_undefined] = ACTIONS(553),
    [anon_sym_AT] = ACTIONS(551),
    [anon_sym_static] = ACTIONS(553),
    [anon_sym_get] = ACTIONS(553),
    [anon_sym_set] = ACTIONS(553),
    [sym__automatic_semicolon] = ACTIONS(559),
    [sym__ternary_qmark] = ACTIONS(557),
    [sym_html_comment] = ACTIONS(5),
  },
  [71] = {
    [ts_builtin_sym_end] = ACTIONS(561),
    [sym_identifier] = ACTIONS(563),
    [anon_sym_export] = ACTIONS(563),
    [anon_sym_STAR] = ACTIONS(565),
    [anon_sym_default] = ACTIONS(563),
    [anon_sym_LBRACE] = ACTIONS(561),
    [anon_sym_COMMA] = ACTIONS(567),
    [anon_sym_RBRACE] = ACTIONS(561),
    [anon_sym_import] = ACTIONS(563),
    [anon_sym_with] = ACTIONS(563),
    [anon_sym_var] = ACTIONS(563),
    [anon_sym_let] = ACTIONS(563),
    [anon_sym_const] = ACTIONS(563),
    [anon_sym_else] = ACTIONS(563),
    [anon_sym_if] = ACTIONS(563),
    [anon_sym_switch] = ACTIONS(563),
    [anon_sym_for] = ACTIONS(563),
    [anon_sym_LPAREN] = ACTIONS(561),
    [anon_sym_SEMI] = ACTIONS(561),
    [anon_sym_await] = ACTIONS(563),
    [anon_sym_in] = ACTIONS(565),
    [anon_sym_while] = ACTIONS(563),
    [anon_sym_do] = ACTIONS(563),
    [anon_sym_try] = ACTIONS(563),
    [anon_sym_break] = ACTIONS(563),
    [anon_sym_continue] = ACTIONS(563),
    [anon_sym_debugger] = ACTIONS(563),
    [anon_sym_return] = ACTIONS(563),
    [anon_sym_throw] = ACTIONS(563),
    [anon_sym_case] = ACTIONS(563),
    [anon_sym_yield] = ACTIONS(563),
    [anon_sym_LBRACK] = ACTIONS(561),
    [anon_sym_LT] = ACTIONS(563),
    [anon_sym_GT] = ACTIONS(565),
    [anon_sym_DOT] = ACTIONS(565),
    [anon_sym_DQUOTE] = ACTIONS(561),
    [anon_sym_SQUOTE] = ACTIONS(561),
    [anon_sym_class] = ACTIONS(563),
    [anon_sym_async] = ACTIONS(563),
    [anon_sym_function] = ACTIONS(563),
    [sym_optional_chain] = ACTIONS(567),
    [anon_sym_new] = ACTIONS(563),
    [anon_sym_AMP_AMP] = ACTIONS(567),
    [anon_sym_PIPE_PIPE] = ACTIONS(567),
    [anon_sym_GT_GT] = ACTIONS(565),
    [anon_sym_GT_GT_GT] = ACTIONS(567),
    [anon_sym_LT_LT] = ACTIONS(567),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_CARET] = ACTIONS(567),
    [anon_sym_PIPE] = ACTIONS(565),
    [anon_sym_PLUS] = ACTIONS(563),
    [anon_sym_DASH] = ACTIONS(563),
    [anon_sym_SLASH] = ACTIONS(563),
    [anon_sym_PERCENT] = ACTIONS(567),
    [anon_sym_STAR_STAR] = ACTIONS(567),
    [anon_sym_LT_EQ] = ACTIONS(567),
    [anon_sym_EQ_EQ] = ACTIONS(565),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(567),
    [anon_sym_BANG_EQ] = ACTIONS(565),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(567),
    [anon_sym_GT_EQ] = ACTIONS(567),
    [anon_sym_QMARK_QMARK] = ACTIONS(567),
    [anon_sym_instanceof] = ACTIONS(565),
    [anon_sym_BANG] = ACTIONS(563),
    [anon_sym_TILDE] = ACTIONS(561),
    [anon_sym_typeof] = ACTIONS(563),
    [anon_sym_void] = ACTIONS(563),
    [anon_sym_delete] = ACTIONS(563),
    [anon_sym_PLUS_PLUS] = ACTIONS(561),
    [anon_sym_DASH_DASH] = ACTIONS(561),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(561),
    [sym_number] = ACTIONS(561),
    [sym_private_property_identifier] = ACTIONS(561),
    [sym_this] = ACTIONS(563),
    [sym_super] = ACTIONS(563),
    [sym_true] = ACTIONS(563),
    [sym_false] = ACTIONS(563),
    [sym_null] = ACTIONS(563),
    [sym_undefined] = ACTIONS(563),
    [anon_sym_AT] = ACTIONS(561),
    [anon_sym_static] = ACTIONS(563),
    [anon_sym_get] = ACTIONS(563),
    [anon_sym_set] = ACTIONS(563),
    [sym__automatic_semicolon] = ACTIONS(569),
    [sym__ternary_qmark] = ACTIONS(567),
    [sym_html_comment] = ACTIONS(5),
  },
  [72] = {
    [ts_builtin_sym_end] = ACTIONS(571),
    [sym_identifier] = ACTIONS(573),
    [anon_sym_export] = ACTIONS(573),
    [anon_sym_STAR] = ACTIONS(575),
    [anon_sym_default] = ACTIONS(573),
    [anon_sym_LBRACE] = ACTIONS(571),
    [anon_sym_COMMA] = ACTIONS(577),
    [anon_sym_RBRACE] = ACTIONS(571),
    [anon_sym_import] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(573),
    [anon_sym_var] = ACTIONS(573),
    [anon_sym_let] = ACTIONS(573),
    [anon_sym_const] = ACTIONS(573),
    [anon_sym_else] = ACTIONS(573),
    [anon_sym_if] = ACTIONS(573),
    [anon_sym_switch] = ACTIONS(573),
    [anon_sym_for] = ACTIONS(573),
    [anon_sym_LPAREN] = ACTIONS(571),
    [anon_sym_SEMI] = ACTIONS(571),
    [anon_sym_await] = ACTIONS(573),
    [anon_sym_in] = ACTIONS(575),
    [anon_sym_while] = ACTIONS(573),
    [anon_sym_do] = ACTIONS(573),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_break] = ACTIONS(573),
    [anon_sym_continue] = ACTIONS(573),
    [anon_sym_debugger] = ACTIONS(573),
    [anon_sym_return] = ACTIONS(573),
    [anon_sym_throw] = ACTIONS(573),
    [anon_sym_case] = ACTIONS(573),
    [anon_sym_yield] = ACTIONS(573),
    [anon_sym_LBRACK] = ACTIONS(571),
    [anon_sym_LT] = ACTIONS(573),
    [anon_sym_GT] = ACTIONS(575),
    [anon_sym_DOT] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(571),
    [anon_sym_SQUOTE] = ACTIONS(571),
    [anon_sym_class] = ACTIONS(573),
    [anon_sym_async] = ACTIONS(573),
    [anon_sym_function] = ACTIONS(573),
    [sym_optional_chain] = ACTIONS(577),
    [anon_sym_new] = ACTIONS(573),
    [anon_sym_AMP_AMP] = ACTIONS(577),
    [anon_sym_PIPE_PIPE] = ACTIONS(577),
    [anon_sym_GT_GT] = ACTIONS(575),
    [anon_sym_GT_GT_GT] = ACTIONS(577),
    [anon_sym_LT_LT] = ACTIONS(577),
    [anon_sym_AMP] = ACTIONS(575),
    [anon_sym_CARET] = ACTIONS(577),
    [anon_sym_PIPE] = ACTIONS(575),
    [anon_sym_PLUS] = ACTIONS(573),
    [anon_sym_DASH] = ACTIONS(573),
    [anon_sym_SLASH] = ACTIONS(573),
    [anon_sym_PERCENT] = ACTIONS(577),
    [anon_sym_STAR_STAR] = ACTIONS(577),
    [anon_sym_LT_EQ] = ACTIONS(577),
    [anon_sym_EQ_EQ] = ACTIONS(575),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(577),
    [anon_sym_BANG_EQ] = ACTIONS(575),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(577),
    [anon_sym_GT_EQ] = ACTIONS(577),
    [anon_sym_QMARK_QMARK] = ACTIONS(577),
    [anon_sym_instanceof] = ACTIONS(575),
    [anon_sym_BANG] = ACTIONS(573),
    [anon_sym_TILDE] = ACTIONS(571),
    [anon_sym_typeof] = ACTIONS(573),
    [anon_sym_void] = ACTIONS(573),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(571),
    [anon_sym_DASH_DASH] = ACTIONS(571),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(571),
    [sym_number] = ACTIONS(571),
    [sym_private_property_identifier] = ACTIONS(571),
    [sym_this] = ACTIONS(573),
    [sym_super] = ACTIONS(573),
    [sym_true] = ACTIONS(573),
    [sym_false] = ACTIONS(573),
    [sym_null] = ACTIONS(573),
    [sym_undefined] = ACTIONS(573),
    [anon_sym_AT] = ACTIONS(571),
    [anon_sym_static] = ACTIONS(573),
    [anon_sym_get] = ACTIONS(573),
    [anon_sym_set] = ACTIONS(573),
    [sym__automatic_semicolon] = ACTIONS(579),
    [sym__ternary_qmark] = ACTIONS(577),
    [sym_html_comment] = ACTIONS(5),
  },
  [73] = {
    [ts_builtin_sym_end] = ACTIONS(581),
    [sym_identifier] = ACTIONS(583),
    [anon_sym_export] = ACTIONS(583),
    [anon_sym_STAR] = ACTIONS(585),
    [anon_sym_default] = ACTIONS(583),
    [anon_sym_LBRACE] = ACTIONS(581),
    [anon_sym_COMMA] = ACTIONS(587),
    [anon_sym_RBRACE] = ACTIONS(581),
    [anon_sym_import] = ACTIONS(583),
    [anon_sym_with] = ACTIONS(583),
    [anon_sym_var] = ACTIONS(583),
    [anon_sym_let] = ACTIONS(583),
    [anon_sym_const] = ACTIONS(583),
    [anon_sym_else] = ACTIONS(583),
    [anon_sym_if] = ACTIONS(583),
    [anon_sym_switch] = ACTIONS(583),
    [anon_sym_for] = ACTIONS(583),
    [anon_sym_LPAREN] = ACTIONS(581),
    [anon_sym_SEMI] = ACTIONS(581),
    [anon_sym_await] = ACTIONS(583),
    [anon_sym_in] = ACTIONS(585),
    [anon_sym_while] = ACTIONS(583),
    [anon_sym_do] = ACTIONS(583),
    [anon_sym_try] = ACTIONS(583),
    [anon_sym_break] = ACTIONS(583),
    [anon_sym_continue] = ACTIONS(583),
    [anon_sym_debugger] = ACTIONS(583),
    [anon_sym_return] = ACTIONS(583),
    [anon_sym_throw] = ACTIONS(583),
    [anon_sym_case] = ACTIONS(583),
    [anon_sym_yield] = ACTIONS(583),
    [anon_sym_LBRACK] = ACTIONS(581),
    [anon_sym_LT] = ACTIONS(583),
    [anon_sym_GT] = ACTIONS(585),
    [anon_sym_DOT] = ACTIONS(585),
    [anon_sym_DQUOTE] = ACTIONS(581),
    [anon_sym_SQUOTE] = ACTIONS(581),
    [anon_sym_class] = ACTIONS(583),
    [anon_sym_async] = ACTIONS(583),
    [anon_sym_function] = ACTIONS(583),
    [sym_optional_chain] = ACTIONS(587),
    [anon_sym_new] = ACTIONS(583),
    [anon_sym_AMP_AMP] = ACTIONS(587),
    [anon_sym_PIPE_PIPE] = ACTIONS(587),
    [anon_sym_GT_GT] = ACTIONS(585),
    [anon_sym_GT_GT_GT] = ACTIONS(587),
    [anon_sym_LT_LT] = ACTIONS(587),
    [anon_sym_AMP] = ACTIONS(585),
    [anon_sym_CARET] = ACTIONS(587),
    [anon_sym_PIPE] = ACTIONS(585),
    [anon_sym_PLUS] = ACTIONS(583),
    [anon_sym_DASH] = ACTIONS(583),
    [anon_sym_SLASH] = ACTIONS(583),
    [anon_sym_PERCENT] = ACTIONS(587),
    [anon_sym_STAR_STAR] = ACTIONS(587),
    [anon_sym_LT_EQ] = ACTIONS(587),
    [anon_sym_EQ_EQ] = ACTIONS(585),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(587),
    [anon_sym_BANG_EQ] = ACTIONS(585),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(587),
    [anon_sym_GT_EQ] = ACTIONS(587),
    [anon_sym_QMARK_QMARK] = ACTIONS(587),
    [anon_sym_instanceof] = ACTIONS(585),
    [anon_sym_BANG] = ACTIONS(583),
    [anon_sym_TILDE] = ACTIONS(581),
    [anon_sym_typeof] = ACTIONS(583),
    [anon_sym_void] = ACTIONS(583),
    [anon_sym_delete] = ACTIONS(583),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(581),
    [sym_number] = ACTIONS(581),
    [sym_private_property_identifier] = ACTIONS(581),
    [sym_this] = ACTIONS(583),
    [sym_super] = ACTIONS(583),
    [sym_true] = ACTIONS(583),
    [sym_false] = ACTIONS(583),
    [sym_null] = ACTIONS(583),
    [sym_undefined] = ACTIONS(583),
    [anon_sym_AT] = ACTIONS(581),
    [anon_sym_static] = ACTIONS(583),
    [anon_sym_get] = ACTIONS(583),
    [anon_sym_set] = ACTIONS(583),
    [sym__automatic_semicolon] = ACTIONS(589),
    [sym__ternary_qmark] = ACTIONS(587),
    [sym_html_comment] = ACTIONS(5),
  },
  [74] = {
    [ts_builtin_sym_end] = ACTIONS(591),
    [sym_identifier] = ACTIONS(593),
    [anon_sym_export] = ACTIONS(593),
    [anon_sym_STAR] = ACTIONS(595),
    [anon_sym_default] = ACTIONS(593),
    [anon_sym_LBRACE] = ACTIONS(591),
    [anon_sym_COMMA] = ACTIONS(597),
    [anon_sym_RBRACE] = ACTIONS(591),
    [anon_sym_import] = ACTIONS(593),
    [anon_sym_with] = ACTIONS(593),
    [anon_sym_var] = ACTIONS(593),
    [anon_sym_let] = ACTIONS(593),
    [anon_sym_const] = ACTIONS(593),
    [anon_sym_else] = ACTIONS(593),
    [anon_sym_if] = ACTIONS(593),
    [anon_sym_switch] = ACTIONS(593),
    [anon_sym_for] = ACTIONS(593),
    [anon_sym_LPAREN] = ACTIONS(591),
    [anon_sym_SEMI] = ACTIONS(591),
    [anon_sym_await] = ACTIONS(593),
    [anon_sym_in] = ACTIONS(595),
    [anon_sym_while] = ACTIONS(593),
    [anon_sym_do] = ACTIONS(593),
    [anon_sym_try] = ACTIONS(593),
    [anon_sym_break] = ACTIONS(593),
    [anon_sym_continue] = ACTIONS(593),
    [anon_sym_debugger] = ACTIONS(593),
    [anon_sym_return] = ACTIONS(593),
    [anon_sym_throw] = ACTIONS(593),
    [anon_sym_case] = ACTIONS(593),
    [anon_sym_yield] = ACTIONS(593),
    [anon_sym_LBRACK] = ACTIONS(591),
    [anon_sym_LT] = ACTIONS(593),
    [anon_sym_GT] = ACTIONS(595),
    [anon_sym_DOT] = ACTIONS(595),
    [anon_sym_DQUOTE] = ACTIONS(591),
    [anon_sym_SQUOTE] = ACTIONS(591),
    [anon_sym_class] = ACTIONS(593),
    [anon_sym_async] = ACTIONS(593),
    [anon_sym_function] = ACTIONS(593),
    [sym_optional_chain] = ACTIONS(597),
    [anon_sym_new] = ACTIONS(593),
    [anon_sym_AMP_AMP] = ACTIONS(597),
    [anon_sym_PIPE_PIPE] = ACTIONS(597),
    [anon_sym_GT_GT] = ACTIONS(595),
    [anon_sym_GT_GT_GT] = ACTIONS(597),
    [anon_sym_LT_LT] = ACTIONS(597),
    [anon_sym_AMP] = ACTIONS(595),
    [anon_sym_CARET] = ACTIONS(597),
    [anon_sym_PIPE] = ACTIONS(595),
    [anon_sym_PLUS] = ACTIONS(593),
    [anon_sym_DASH] = ACTIONS(593),
    [anon_sym_SLASH] = ACTIONS(593),
    [anon_sym_PERCENT] = ACTIONS(597),
    [anon_sym_STAR_STAR] = ACTIONS(597),
    [anon_sym_LT_EQ] = ACTIONS(597),
    [anon_sym_EQ_EQ] = ACTIONS(595),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(597),
    [anon_sym_BANG_EQ] = ACTIONS(595),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(597),
    [anon_sym_GT_EQ] = ACTIONS(597),
    [anon_sym_QMARK_QMARK] = ACTIONS(597),
    [anon_sym_instanceof] = ACTIONS(595),
    [anon_sym_BANG] = ACTIONS(593),
    [anon_sym_TILDE] = ACTIONS(591),
    [anon_sym_typeof] = ACTIONS(593),
    [anon_sym_void] = ACTIONS(593),
    [anon_sym_delete] = ACTIONS(593),
    [anon_sym_PLUS_PLUS] = ACTIONS(591),
    [anon_sym_DASH_DASH] = ACTIONS(591),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(591),
    [sym_number] = ACTIONS(591),
    [sym_private_property_identifier] = ACTIONS(591),
    [sym_this] = ACTIONS(593),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(593),
    [sym_false] = ACTIONS(593),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(591),
    [anon_sym_static] = ACTIONS(593),
    [anon_sym_get] = ACTIONS(593),
    [anon_sym_set] = ACTIONS(593),
    [sym__automatic_semicolon] = ACTIONS(599),
    [sym__ternary_qmark] = ACTIONS(597),
    [sym_html_comment] = ACTIONS(5),
  },
  [75] = {
    [ts_builtin_sym_end] = ACTIONS(601),
    [sym_identifier] = ACTIONS(603),
    [anon_sym_export] = ACTIONS(603),
    [anon_sym_STAR] = ACTIONS(605),
    [anon_sym_default] = ACTIONS(603),
    [anon_sym_LBRACE] = ACTIONS(601),
    [anon_sym_COMMA] = ACTIONS(607),
    [anon_sym_RBRACE] = ACTIONS(601),
    [anon_sym_import] = ACTIONS(603),
    [anon_sym_with] = ACTIONS(603),
    [anon_sym_var] = ACTIONS(603),
    [anon_sym_let] = ACTIONS(603),
    [anon_sym_const] = ACTIONS(603),
    [anon_sym_else] = ACTIONS(603),
    [anon_sym_if] = ACTIONS(603),
    [anon_sym_switch] = ACTIONS(603),
    [anon_sym_for] = ACTIONS(603),
    [anon_sym_LPAREN] = ACTIONS(601),
    [anon_sym_SEMI] = ACTIONS(601),
    [anon_sym_await] = ACTIONS(603),
    [anon_sym_in] = ACTIONS(605),
    [anon_sym_while] = ACTIONS(603),
    [anon_sym_do] = ACTIONS(603),
    [anon_sym_try] = ACTIONS(603),
    [anon_sym_break] = ACTIONS(603),
    [anon_sym_continue] = ACTIONS(603),
    [anon_sym_debugger] = ACTIONS(603),
    [anon_sym_return] = ACTIONS(603),
    [anon_sym_throw] = ACTIONS(603),
    [anon_sym_case] = ACTIONS(603),
    [anon_sym_yield] = ACTIONS(603),
    [anon_sym_LBRACK] = ACTIONS(601),
    [anon_sym_LT] = ACTIONS(603),
    [anon_sym_GT] = ACTIONS(605),
    [anon_sym_DOT] = ACTIONS(605),
    [anon_sym_DQUOTE] = ACTIONS(601),
    [anon_sym_SQUOTE] = ACTIONS(601),
    [anon_sym_class] = ACTIONS(603),
    [anon_sym_async] = ACTIONS(603),
    [anon_sym_function] = ACTIONS(603),
    [sym_optional_chain] = ACTIONS(607),
    [anon_sym_new] = ACTIONS(603),
    [anon_sym_AMP_AMP] = ACTIONS(607),
    [anon_sym_PIPE_PIPE] = ACTIONS(607),
    [anon_sym_GT_GT] = ACTIONS(605),
    [anon_sym_GT_GT_GT] = ACTIONS(607),
    [anon_sym_LT_LT] = ACTIONS(607),
    [anon_sym_AMP] = ACTIONS(605),
    [anon_sym_CARET] = ACTIONS(607),
    [anon_sym_PIPE] = ACTIONS(605),
    [anon_sym_PLUS] = ACTIONS(603),
    [anon_sym_DASH] = ACTIONS(603),
    [anon_sym_SLASH] = ACTIONS(603),
    [anon_sym_PERCENT] = ACTIONS(607),
    [anon_sym_STAR_STAR] = ACTIONS(607),
    [anon_sym_LT_EQ] = ACTIONS(607),
    [anon_sym_EQ_EQ] = ACTIONS(605),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(607),
    [anon_sym_BANG_EQ] = ACTIONS(605),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(607),
    [anon_sym_GT_EQ] = ACTIONS(607),
    [anon_sym_QMARK_QMARK] = ACTIONS(607),
    [anon_sym_instanceof] = ACTIONS(605),
    [anon_sym_BANG] = ACTIONS(603),
    [anon_sym_TILDE] = ACTIONS(601),
    [anon_sym_typeof] = ACTIONS(603),
    [anon_sym_void] = ACTIONS(603),
    [anon_sym_delete] = ACTIONS(603),
    [anon_sym_PLUS_PLUS] = ACTIONS(601),
    [anon_sym_DASH_DASH] = ACTIONS(601),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(601),
    [sym_number] = ACTIONS(601),
    [sym_private_property_identifier] = ACTIONS(601),
    [sym_this] = ACTIONS(603),
    [sym_super] = ACTIONS(603),
    [sym_true] = ACTIONS(603),
    [sym_false] = ACTIONS(603),
    [sym_null] = ACTIONS(603),
    [sym_undefined] = ACTIONS(603),
    [anon_sym_AT] = ACTIONS(601),
    [anon_sym_static] = ACTIONS(603),
    [anon_sym_get] = ACTIONS(603),
    [anon_sym_set] = ACTIONS(603),
    [sym__automatic_semicolon] = ACTIONS(609),
    [sym__ternary_qmark] = ACTIONS(607),
    [sym_html_comment] = ACTIONS(5),
  },
  [76] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(767),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1135),
    [sym_assignment_pattern] = STATE(1369),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1135),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1135),
    [sym_spread_element] = STATE(1344),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [sym_pattern] = STATE(1207),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [aux_sym_array_repeat1] = STATE(1345),
    [aux_sym_array_pattern_repeat1] = STATE(1341),
    [sym_identifier] = ACTIONS(611),
    [anon_sym_export] = ACTIONS(613),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(615),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(613),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_RBRACK] = ACTIONS(617),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(621),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(623),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(613),
    [anon_sym_get] = ACTIONS(613),
    [anon_sym_set] = ACTIONS(613),
    [sym_html_comment] = ACTIONS(5),
  },
  [77] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(750),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1135),
    [sym_assignment_pattern] = STATE(1369),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1135),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1135),
    [sym_spread_element] = STATE(1326),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [sym_pattern] = STATE(1207),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [aux_sym_array_repeat1] = STATE(1328),
    [aux_sym_array_pattern_repeat1] = STATE(1341),
    [sym_identifier] = ACTIONS(611),
    [anon_sym_export] = ACTIONS(613),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(615),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(613),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_RBRACK] = ACTIONS(625),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(621),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(623),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(613),
    [anon_sym_get] = ACTIONS(613),
    [anon_sym_set] = ACTIONS(613),
    [sym_html_comment] = ACTIONS(5),
  },
  [78] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(767),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1135),
    [sym_assignment_pattern] = STATE(1369),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1135),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1135),
    [sym_spread_element] = STATE(1344),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [sym_pattern] = STATE(1207),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [aux_sym_array_repeat1] = STATE(1345),
    [aux_sym_array_pattern_repeat1] = STATE(1341),
    [sym_identifier] = ACTIONS(611),
    [anon_sym_export] = ACTIONS(613),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(615),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(613),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_RBRACK] = ACTIONS(627),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(621),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(623),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(613),
    [anon_sym_get] = ACTIONS(613),
    [anon_sym_set] = ACTIONS(613),
    [sym_html_comment] = ACTIONS(5),
  },
  [79] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(812),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1135),
    [sym_assignment_pattern] = STATE(1369),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1135),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1135),
    [sym_spread_element] = STATE(1326),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [sym_pattern] = STATE(1207),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [aux_sym_array_repeat1] = STATE(1328),
    [aux_sym_array_pattern_repeat1] = STATE(1341),
    [sym_identifier] = ACTIONS(611),
    [anon_sym_export] = ACTIONS(613),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(615),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(613),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_RBRACK] = ACTIONS(625),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(621),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(623),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(613),
    [anon_sym_get] = ACTIONS(613),
    [anon_sym_set] = ACTIONS(613),
    [sym_html_comment] = ACTIONS(5),
  },
  [80] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(767),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1135),
    [sym_assignment_pattern] = STATE(1369),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1135),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1135),
    [sym_spread_element] = STATE(1344),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [sym_pattern] = STATE(1207),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [aux_sym_array_repeat1] = STATE(1345),
    [aux_sym_array_pattern_repeat1] = STATE(1341),
    [sym_identifier] = ACTIONS(611),
    [anon_sym_export] = ACTIONS(613),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(615),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(613),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_RBRACK] = ACTIONS(629),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(621),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(623),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(613),
    [anon_sym_get] = ACTIONS(613),
    [anon_sym_set] = ACTIONS(613),
    [sym_html_comment] = ACTIONS(5),
  },
  [81] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(767),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1135),
    [sym_assignment_pattern] = STATE(1369),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1135),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1135),
    [sym_spread_element] = STATE(1344),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [sym_pattern] = STATE(1207),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [aux_sym_array_repeat1] = STATE(1345),
    [aux_sym_array_pattern_repeat1] = STATE(1341),
    [sym_identifier] = ACTIONS(611),
    [anon_sym_export] = ACTIONS(613),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(615),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(613),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_RBRACK] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(621),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(623),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(613),
    [anon_sym_get] = ACTIONS(613),
    [anon_sym_set] = ACTIONS(613),
    [sym_html_comment] = ACTIONS(5),
  },
  [82] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(767),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1135),
    [sym_assignment_pattern] = STATE(1369),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1135),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1135),
    [sym_spread_element] = STATE(1344),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [sym_pattern] = STATE(1207),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [aux_sym_array_repeat1] = STATE(1345),
    [aux_sym_array_pattern_repeat1] = STATE(1341),
    [sym_identifier] = ACTIONS(611),
    [anon_sym_export] = ACTIONS(613),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(615),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(613),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_RBRACK] = ACTIONS(633),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(621),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(623),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(613),
    [anon_sym_get] = ACTIONS(613),
    [anon_sym_set] = ACTIONS(613),
    [sym_html_comment] = ACTIONS(5),
  },
  [83] = {
    [sym_declaration] = STATE(391),
    [sym_import] = STATE(1232),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(831),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1237),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(635),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(637),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [84] = {
    [sym_declaration] = STATE(401),
    [sym_import] = STATE(1232),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(825),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1273),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(635),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(639),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [85] = {
    [sym_declaration] = STATE(401),
    [sym_import] = STATE(1232),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(825),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1237),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(635),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(65),
    [anon_sym_async] = ACTIONS(637),
    [anon_sym_function] = ACTIONS(69),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [86] = {
    [sym_declaration] = STATE(391),
    [sym_import] = STATE(1232),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(831),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_class_declaration] = STATE(412),
    [sym_function_expression] = STATE(677),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function] = STATE(677),
    [sym_generator_function_declaration] = STATE(412),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1273),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(635),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(639),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [87] = {
    [sym_import] = STATE(1272),
    [sym_variable_declaration] = STATE(110),
    [sym_lexical_declaration] = STATE(110),
    [sym_empty_statement] = STATE(110),
    [sym_parenthesized_expression] = STATE(489),
    [sym_expression] = STATE(766),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1342),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1342),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(489),
    [sym_subscript_expression] = STATE(489),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1342),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1717),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(641),
    [anon_sym_export] = ACTIONS(643),
    [anon_sym_LBRACE] = ACTIONS(645),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_var] = ACTIONS(647),
    [anon_sym_let] = ACTIONS(649),
    [anon_sym_const] = ACTIONS(651),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(653),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(655),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(657),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(643),
    [anon_sym_get] = ACTIONS(643),
    [anon_sym_set] = ACTIONS(643),
    [sym_html_comment] = ACTIONS(5),
  },
  [88] = {
    [sym_import] = STATE(1272),
    [sym_variable_declaration] = STATE(111),
    [sym_lexical_declaration] = STATE(111),
    [sym_empty_statement] = STATE(111),
    [sym_parenthesized_expression] = STATE(489),
    [sym_expression] = STATE(817),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1342),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1342),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(489),
    [sym_subscript_expression] = STATE(489),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1342),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1719),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(641),
    [anon_sym_export] = ACTIONS(643),
    [anon_sym_LBRACE] = ACTIONS(645),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_var] = ACTIONS(647),
    [anon_sym_let] = ACTIONS(649),
    [anon_sym_const] = ACTIONS(651),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(653),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(655),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(657),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(643),
    [anon_sym_get] = ACTIONS(643),
    [anon_sym_set] = ACTIONS(643),
    [sym_html_comment] = ACTIONS(5),
  },
  [89] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(867),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1175),
    [sym_assignment_pattern] = STATE(1369),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1175),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1175),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [sym_pattern] = STATE(1207),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [aux_sym_array_pattern_repeat1] = STATE(1341),
    [sym_identifier] = ACTIONS(659),
    [anon_sym_export] = ACTIONS(661),
    [anon_sym_LBRACE] = ACTIONS(663),
    [anon_sym_COMMA] = ACTIONS(665),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(667),
    [anon_sym_RBRACK] = ACTIONS(669),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(671),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(673),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(675),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(661),
    [anon_sym_get] = ACTIONS(661),
    [anon_sym_set] = ACTIONS(661),
    [sym_html_comment] = ACTIONS(5),
  },
  [90] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(779),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1135),
    [sym_assignment_pattern] = STATE(1429),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1135),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1135),
    [sym_spread_element] = STATE(1279),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [sym_pattern] = STATE(1280),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(611),
    [anon_sym_export] = ACTIONS(613),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(677),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(613),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_RBRACK] = ACTIONS(677),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(621),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(623),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(613),
    [anon_sym_get] = ACTIONS(613),
    [anon_sym_set] = ACTIONS(613),
    [sym_html_comment] = ACTIONS(5),
  },
  [91] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(865),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1135),
    [sym_assignment_pattern] = STATE(1369),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1135),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(498),
    [sym_subscript_expression] = STATE(498),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1135),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [sym_pattern] = STATE(1207),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [aux_sym_array_pattern_repeat1] = STATE(1341),
    [sym_identifier] = ACTIONS(680),
    [anon_sym_export] = ACTIONS(682),
    [anon_sym_LBRACE] = ACTIONS(684),
    [anon_sym_COMMA] = ACTIONS(665),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(682),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(686),
    [anon_sym_RBRACK] = ACTIONS(669),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(688),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(673),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(690),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(682),
    [anon_sym_get] = ACTIONS(682),
    [anon_sym_set] = ACTIONS(682),
    [sym_html_comment] = ACTIONS(5),
  },
  [92] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(867),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1175),
    [sym_assignment_pattern] = STATE(1343),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1175),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1175),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [sym_pattern] = STATE(1203),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [aux_sym_array_pattern_repeat1] = STATE(1346),
    [sym_identifier] = ACTIONS(659),
    [anon_sym_export] = ACTIONS(661),
    [anon_sym_LBRACE] = ACTIONS(663),
    [anon_sym_COMMA] = ACTIONS(665),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(667),
    [anon_sym_RBRACK] = ACTIONS(692),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(671),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(673),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(675),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(661),
    [anon_sym_get] = ACTIONS(661),
    [anon_sym_set] = ACTIONS(661),
    [sym_html_comment] = ACTIONS(5),
  },
  [93] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(776),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1135),
    [sym_assignment_pattern] = STATE(1277),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1135),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1135),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1617),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [sym_pattern] = STATE(1243),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(611),
    [anon_sym_export] = ACTIONS(613),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(613),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(694),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(621),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(673),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(623),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(613),
    [anon_sym_get] = ACTIONS(613),
    [anon_sym_set] = ACTIONS(613),
    [sym_html_comment] = ACTIONS(5),
  },
  [94] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(753),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1135),
    [sym_assignment_pattern] = STATE(1277),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1135),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1135),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1670),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [sym_pattern] = STATE(1243),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(611),
    [anon_sym_export] = ACTIONS(613),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(613),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(694),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(621),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(673),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(623),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(613),
    [anon_sym_get] = ACTIONS(613),
    [anon_sym_set] = ACTIONS(613),
    [sym_html_comment] = ACTIONS(5),
  },
  [95] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(867),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1175),
    [sym_assignment_pattern] = STATE(1429),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1175),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1175),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [sym_pattern] = STATE(1280),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(659),
    [anon_sym_export] = ACTIONS(661),
    [anon_sym_LBRACE] = ACTIONS(663),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(667),
    [anon_sym_RBRACK] = ACTIONS(696),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(671),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(673),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(675),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(661),
    [anon_sym_get] = ACTIONS(661),
    [anon_sym_set] = ACTIONS(661),
    [sym_html_comment] = ACTIONS(5),
  },
  [96] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(754),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_spread_element] = STATE(1319),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [aux_sym_array_repeat1] = STATE(1320),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_COMMA] = ACTIONS(698),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(700),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(702),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [97] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(867),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1175),
    [sym_assignment_pattern] = STATE(1277),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1175),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1175),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [sym_pattern] = STATE(1243),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(659),
    [anon_sym_export] = ACTIONS(661),
    [anon_sym_LBRACE] = ACTIONS(663),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(694),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(667),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(671),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(673),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(675),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(661),
    [anon_sym_get] = ACTIONS(661),
    [anon_sym_set] = ACTIONS(661),
    [sym_html_comment] = ACTIONS(5),
  },
  [98] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(867),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1175),
    [sym_assignment_pattern] = STATE(1381),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1175),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1175),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [sym_pattern] = STATE(1298),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(659),
    [anon_sym_export] = ACTIONS(661),
    [anon_sym_LBRACE] = ACTIONS(663),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(704),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(667),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(671),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(673),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(675),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(661),
    [anon_sym_get] = ACTIONS(661),
    [anon_sym_set] = ACTIONS(661),
    [sym_html_comment] = ACTIONS(5),
  },
  [99] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(769),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_spread_element] = STATE(1362),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [aux_sym_array_repeat1] = STATE(1364),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_COMMA] = ACTIONS(698),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(706),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(702),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [100] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(867),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1175),
    [sym_assignment_pattern] = STATE(1381),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1175),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1175),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [sym_pattern] = STATE(1298),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(659),
    [anon_sym_export] = ACTIONS(661),
    [anon_sym_LBRACE] = ACTIONS(663),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(708),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(667),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(671),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(673),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(675),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(661),
    [anon_sym_get] = ACTIONS(661),
    [anon_sym_set] = ACTIONS(661),
    [sym_html_comment] = ACTIONS(5),
  },
  [101] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(755),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_spread_element] = STATE(1303),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [aux_sym_array_repeat1] = STATE(1304),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_COMMA] = ACTIONS(698),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(710),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(702),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [102] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(779),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_spread_element] = STATE(1279),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_COMMA] = ACTIONS(712),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(712),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_RBRACK] = ACTIONS(712),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(702),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [103] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(821),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1135),
    [sym_assignment_pattern] = STATE(1454),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1135),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1135),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [sym_pattern] = STATE(1282),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(611),
    [anon_sym_export] = ACTIONS(613),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(613),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(621),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(673),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(623),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(613),
    [anon_sym_get] = ACTIONS(613),
    [anon_sym_set] = ACTIONS(613),
    [sym_html_comment] = ACTIONS(5),
  },
  [104] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(771),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_spread_element] = STATE(1675),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1675),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(714),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(702),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [105] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(797),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_spread_element] = STATE(1690),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1690),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(716),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(702),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [106] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(867),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1175),
    [sym_assignment_pattern] = STATE(1454),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1175),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1175),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [sym_pattern] = STATE(1282),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(659),
    [anon_sym_export] = ACTIONS(661),
    [anon_sym_LBRACE] = ACTIONS(663),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(667),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(671),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(673),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(675),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(661),
    [anon_sym_get] = ACTIONS(661),
    [anon_sym_set] = ACTIONS(661),
    [sym_html_comment] = ACTIONS(5),
  },
  [107] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(867),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1175),
    [sym_assignment_pattern] = STATE(1381),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1175),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1175),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [sym_pattern] = STATE(1298),
    [sym_rest_pattern] = STATE(1138),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(659),
    [anon_sym_export] = ACTIONS(661),
    [anon_sym_LBRACE] = ACTIONS(663),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(667),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(671),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(673),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(675),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(661),
    [anon_sym_get] = ACTIONS(661),
    [anon_sym_set] = ACTIONS(661),
    [sym_html_comment] = ACTIONS(5),
  },
  [108] = {
    [sym_import] = STATE(1272),
    [sym_empty_statement] = STATE(121),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(783),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1621),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [109] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(746),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1568),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(718),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym__automatic_semicolon] = ACTIONS(718),
    [sym_html_comment] = ACTIONS(5),
  },
  [110] = {
    [sym_import] = STATE(1272),
    [sym_empty_statement] = STATE(113),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(778),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1639),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [111] = {
    [sym_import] = STATE(1272),
    [sym_empty_statement] = STATE(120),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(803),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1638),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [112] = {
    [sym_import] = STATE(1272),
    [sym_empty_statement] = STATE(117),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(805),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1647),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [113] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(751),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1657),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(720),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [114] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(501),
    [sym_expression] = STATE(867),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1325),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1325),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(501),
    [sym_subscript_expression] = STATE(501),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1325),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(722),
    [anon_sym_export] = ACTIONS(724),
    [anon_sym_LBRACE] = ACTIONS(645),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_var] = ACTIONS(726),
    [anon_sym_let] = ACTIONS(728),
    [anon_sym_const] = ACTIONS(730),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(653),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(732),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(734),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(724),
    [anon_sym_get] = ACTIONS(724),
    [anon_sym_set] = ACTIONS(724),
    [sym_html_comment] = ACTIONS(5),
  },
  [115] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(788),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1669),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(736),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [116] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(811),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1652),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(738),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [117] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(789),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1673),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(740),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [118] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(807),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1658),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(742),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [119] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(791),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1678),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(744),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [120] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(784),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1651),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(746),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [121] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(777),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1645),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(748),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [122] = {
    [sym_import] = STATE(1232),
    [sym_statement_block] = STATE(630),
    [sym_parenthesized_expression] = STATE(487),
    [sym_expression] = STATE(714),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1708),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1708),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(487),
    [sym_subscript_expression] = STATE(487),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1708),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1709),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(419),
    [anon_sym_export] = ACTIONS(421),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(425),
    [anon_sym_yield] = ACTIONS(427),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(429),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(431),
    [anon_sym_PLUS] = ACTIONS(433),
    [anon_sym_DASH] = ACTIONS(433),
    [anon_sym_SLASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(433),
    [anon_sym_void] = ACTIONS(433),
    [anon_sym_delete] = ACTIONS(433),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(441),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(421),
    [anon_sym_get] = ACTIONS(421),
    [anon_sym_set] = ACTIONS(421),
    [sym_html_comment] = ACTIONS(5),
  },
  [123] = {
    [sym_import] = STATE(1272),
    [sym_statement_block] = STATE(532),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(782),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1663),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1663),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1663),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(445),
    [anon_sym_export] = ACTIONS(447),
    [anon_sym_LBRACE] = ACTIONS(752),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(447),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(459),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(447),
    [anon_sym_get] = ACTIONS(447),
    [anon_sym_set] = ACTIONS(447),
    [sym_html_comment] = ACTIONS(5),
  },
  [124] = {
    [sym_import] = STATE(1272),
    [sym_statement_block] = STATE(543),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(787),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1663),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1663),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1663),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(445),
    [anon_sym_export] = ACTIONS(447),
    [anon_sym_LBRACE] = ACTIONS(752),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(447),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(459),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(447),
    [anon_sym_get] = ACTIONS(447),
    [anon_sym_set] = ACTIONS(447),
    [sym_html_comment] = ACTIONS(5),
  },
  [125] = {
    [sym_import] = STATE(1272),
    [sym_statement_block] = STATE(548),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(810),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1663),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1663),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1663),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(445),
    [anon_sym_export] = ACTIONS(447),
    [anon_sym_LBRACE] = ACTIONS(752),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(447),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(459),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(447),
    [anon_sym_get] = ACTIONS(447),
    [anon_sym_set] = ACTIONS(447),
    [sym_html_comment] = ACTIONS(5),
  },
  [126] = {
    [sym_import] = STATE(1272),
    [sym_statement_block] = STATE(558),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(814),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1663),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1663),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1663),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(445),
    [anon_sym_export] = ACTIONS(447),
    [anon_sym_LBRACE] = ACTIONS(752),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(447),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(459),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(447),
    [anon_sym_get] = ACTIONS(447),
    [anon_sym_set] = ACTIONS(447),
    [sym_html_comment] = ACTIONS(5),
  },
  [127] = {
    [sym_import] = STATE(1272),
    [sym_statement_block] = STATE(560),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(786),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1663),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1663),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1663),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(445),
    [anon_sym_export] = ACTIONS(447),
    [anon_sym_LBRACE] = ACTIONS(752),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(447),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(459),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(447),
    [anon_sym_get] = ACTIONS(447),
    [anon_sym_set] = ACTIONS(447),
    [sym_html_comment] = ACTIONS(5),
  },
  [128] = {
    [sym_import] = STATE(1272),
    [sym_statement_block] = STATE(561),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(764),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1663),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1663),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1663),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(445),
    [anon_sym_export] = ACTIONS(447),
    [anon_sym_LBRACE] = ACTIONS(752),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(447),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(459),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(447),
    [anon_sym_get] = ACTIONS(447),
    [anon_sym_set] = ACTIONS(447),
    [sym_html_comment] = ACTIONS(5),
  },
  [129] = {
    [sym_import] = STATE(1272),
    [sym_statement_block] = STATE(561),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(603),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(754),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [130] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(763),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1664),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [131] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(867),
    [sym_primary_expression] = STATE(503),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1663),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1663),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(504),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1663),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(445),
    [anon_sym_export] = ACTIONS(447),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(447),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DOT] = ACTIONS(756),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(459),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(447),
    [anon_sym_get] = ACTIONS(447),
    [anon_sym_set] = ACTIONS(447),
    [sym_html_comment] = ACTIONS(5),
  },
  [132] = {
    [sym_namespace_export] = STATE(1424),
    [sym_export_clause] = STATE(1271),
    [sym_declaration] = STATE(397),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_class_declaration] = STATE(412),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function_declaration] = STATE(412),
    [sym_decorator] = STATE(1006),
    [aux_sym_export_statement_repeat1] = STATE(1220),
    [aux_sym_object_repeat1] = STATE(1350),
    [aux_sym_object_pattern_repeat1] = STATE(1311),
    [anon_sym_STAR] = ACTIONS(758),
    [anon_sym_default] = ACTIONS(760),
    [anon_sym_LBRACE] = ACTIONS(762),
    [anon_sym_COMMA] = ACTIONS(764),
    [anon_sym_RBRACE] = ACTIONS(766),
    [anon_sym_var] = ACTIONS(768),
    [anon_sym_let] = ACTIONS(770),
    [anon_sym_const] = ACTIONS(770),
    [anon_sym_LPAREN] = ACTIONS(772),
    [anon_sym_SEMI] = ACTIONS(764),
    [anon_sym_in] = ACTIONS(775),
    [anon_sym_COLON] = ACTIONS(777),
    [anon_sym_EQ] = ACTIONS(780),
    [anon_sym_LBRACK] = ACTIONS(764),
    [anon_sym_LT] = ACTIONS(775),
    [anon_sym_GT] = ACTIONS(775),
    [anon_sym_DOT] = ACTIONS(764),
    [anon_sym_class] = ACTIONS(782),
    [anon_sym_async] = ACTIONS(784),
    [anon_sym_function] = ACTIONS(786),
    [anon_sym_EQ_GT] = ACTIONS(788),
    [sym_optional_chain] = ACTIONS(764),
    [anon_sym_PLUS_EQ] = ACTIONS(790),
    [anon_sym_DASH_EQ] = ACTIONS(790),
    [anon_sym_STAR_EQ] = ACTIONS(790),
    [anon_sym_SLASH_EQ] = ACTIONS(790),
    [anon_sym_PERCENT_EQ] = ACTIONS(790),
    [anon_sym_CARET_EQ] = ACTIONS(790),
    [anon_sym_AMP_EQ] = ACTIONS(790),
    [anon_sym_PIPE_EQ] = ACTIONS(790),
    [anon_sym_GT_GT_EQ] = ACTIONS(790),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(790),
    [anon_sym_LT_LT_EQ] = ACTIONS(790),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(790),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(790),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(790),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(790),
    [anon_sym_AMP_AMP] = ACTIONS(775),
    [anon_sym_PIPE_PIPE] = ACTIONS(775),
    [anon_sym_GT_GT] = ACTIONS(775),
    [anon_sym_GT_GT_GT] = ACTIONS(775),
    [anon_sym_LT_LT] = ACTIONS(775),
    [anon_sym_AMP] = ACTIONS(775),
    [anon_sym_CARET] = ACTIONS(775),
    [anon_sym_PIPE] = ACTIONS(775),
    [anon_sym_PLUS] = ACTIONS(775),
    [anon_sym_DASH] = ACTIONS(775),
    [anon_sym_SLASH] = ACTIONS(775),
    [anon_sym_PERCENT] = ACTIONS(775),
    [anon_sym_STAR_STAR] = ACTIONS(775),
    [anon_sym_LT_EQ] = ACTIONS(764),
    [anon_sym_EQ_EQ] = ACTIONS(775),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(764),
    [anon_sym_BANG_EQ] = ACTIONS(775),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(764),
    [anon_sym_GT_EQ] = ACTIONS(764),
    [anon_sym_QMARK_QMARK] = ACTIONS(775),
    [anon_sym_instanceof] = ACTIONS(764),
    [anon_sym_PLUS_PLUS] = ACTIONS(764),
    [anon_sym_DASH_DASH] = ACTIONS(764),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(91),
    [sym__automatic_semicolon] = ACTIONS(764),
    [sym__ternary_qmark] = ACTIONS(764),
    [sym_html_comment] = ACTIONS(5),
  },
  [133] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(813),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1656),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [134] = {
    [sym_namespace_export] = STATE(1424),
    [sym_export_clause] = STATE(1271),
    [sym_declaration] = STATE(397),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_class_declaration] = STATE(412),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function_declaration] = STATE(412),
    [sym_decorator] = STATE(1006),
    [aux_sym_export_statement_repeat1] = STATE(1220),
    [aux_sym_object_repeat1] = STATE(1310),
    [aux_sym_object_pattern_repeat1] = STATE(1311),
    [anon_sym_STAR] = ACTIONS(758),
    [anon_sym_default] = ACTIONS(760),
    [anon_sym_LBRACE] = ACTIONS(762),
    [anon_sym_COMMA] = ACTIONS(764),
    [anon_sym_RBRACE] = ACTIONS(792),
    [anon_sym_var] = ACTIONS(768),
    [anon_sym_let] = ACTIONS(770),
    [anon_sym_const] = ACTIONS(770),
    [anon_sym_LPAREN] = ACTIONS(772),
    [anon_sym_SEMI] = ACTIONS(764),
    [anon_sym_in] = ACTIONS(775),
    [anon_sym_COLON] = ACTIONS(777),
    [anon_sym_EQ] = ACTIONS(780),
    [anon_sym_LBRACK] = ACTIONS(764),
    [anon_sym_LT] = ACTIONS(775),
    [anon_sym_GT] = ACTIONS(775),
    [anon_sym_DOT] = ACTIONS(764),
    [anon_sym_class] = ACTIONS(782),
    [anon_sym_async] = ACTIONS(784),
    [anon_sym_function] = ACTIONS(786),
    [anon_sym_EQ_GT] = ACTIONS(788),
    [sym_optional_chain] = ACTIONS(764),
    [anon_sym_PLUS_EQ] = ACTIONS(790),
    [anon_sym_DASH_EQ] = ACTIONS(790),
    [anon_sym_STAR_EQ] = ACTIONS(790),
    [anon_sym_SLASH_EQ] = ACTIONS(790),
    [anon_sym_PERCENT_EQ] = ACTIONS(790),
    [anon_sym_CARET_EQ] = ACTIONS(790),
    [anon_sym_AMP_EQ] = ACTIONS(790),
    [anon_sym_PIPE_EQ] = ACTIONS(790),
    [anon_sym_GT_GT_EQ] = ACTIONS(790),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(790),
    [anon_sym_LT_LT_EQ] = ACTIONS(790),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(790),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(790),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(790),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(790),
    [anon_sym_AMP_AMP] = ACTIONS(775),
    [anon_sym_PIPE_PIPE] = ACTIONS(775),
    [anon_sym_GT_GT] = ACTIONS(775),
    [anon_sym_GT_GT_GT] = ACTIONS(775),
    [anon_sym_LT_LT] = ACTIONS(775),
    [anon_sym_AMP] = ACTIONS(775),
    [anon_sym_CARET] = ACTIONS(775),
    [anon_sym_PIPE] = ACTIONS(775),
    [anon_sym_PLUS] = ACTIONS(775),
    [anon_sym_DASH] = ACTIONS(775),
    [anon_sym_SLASH] = ACTIONS(775),
    [anon_sym_PERCENT] = ACTIONS(775),
    [anon_sym_STAR_STAR] = ACTIONS(775),
    [anon_sym_LT_EQ] = ACTIONS(764),
    [anon_sym_EQ_EQ] = ACTIONS(775),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(764),
    [anon_sym_BANG_EQ] = ACTIONS(775),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(764),
    [anon_sym_GT_EQ] = ACTIONS(764),
    [anon_sym_QMARK_QMARK] = ACTIONS(775),
    [anon_sym_instanceof] = ACTIONS(764),
    [anon_sym_PLUS_PLUS] = ACTIONS(764),
    [anon_sym_DASH_DASH] = ACTIONS(764),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(91),
    [sym__automatic_semicolon] = ACTIONS(764),
    [sym__ternary_qmark] = ACTIONS(764),
    [sym_html_comment] = ACTIONS(5),
  },
  [135] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(752),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1625),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [136] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(867),
    [sym_primary_expression] = STATE(503),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1663),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1663),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(504),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1663),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(794),
    [anon_sym_export] = ACTIONS(796),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(796),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DOT] = ACTIONS(756),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(798),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(796),
    [anon_sym_get] = ACTIONS(796),
    [anon_sym_set] = ACTIONS(796),
    [sym_html_comment] = ACTIONS(5),
  },
  [137] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(772),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1627),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [138] = {
    [sym_namespace_export] = STATE(1424),
    [sym_export_clause] = STATE(1271),
    [sym_declaration] = STATE(397),
    [sym_variable_declaration] = STATE(412),
    [sym_lexical_declaration] = STATE(412),
    [sym_class_declaration] = STATE(412),
    [sym_function_declaration] = STATE(412),
    [sym_generator_function_declaration] = STATE(412),
    [sym_decorator] = STATE(1006),
    [aux_sym_export_statement_repeat1] = STATE(1220),
    [aux_sym_object_repeat1] = STATE(1350),
    [aux_sym_object_pattern_repeat1] = STATE(1311),
    [anon_sym_STAR] = ACTIONS(758),
    [anon_sym_default] = ACTIONS(760),
    [anon_sym_LBRACE] = ACTIONS(762),
    [anon_sym_COMMA] = ACTIONS(764),
    [anon_sym_RBRACE] = ACTIONS(800),
    [anon_sym_var] = ACTIONS(768),
    [anon_sym_let] = ACTIONS(770),
    [anon_sym_const] = ACTIONS(770),
    [anon_sym_LPAREN] = ACTIONS(772),
    [anon_sym_SEMI] = ACTIONS(764),
    [anon_sym_in] = ACTIONS(775),
    [anon_sym_COLON] = ACTIONS(777),
    [anon_sym_EQ] = ACTIONS(780),
    [anon_sym_LBRACK] = ACTIONS(764),
    [anon_sym_LT] = ACTIONS(775),
    [anon_sym_GT] = ACTIONS(775),
    [anon_sym_DOT] = ACTIONS(764),
    [anon_sym_class] = ACTIONS(782),
    [anon_sym_async] = ACTIONS(784),
    [anon_sym_function] = ACTIONS(786),
    [anon_sym_EQ_GT] = ACTIONS(788),
    [sym_optional_chain] = ACTIONS(764),
    [anon_sym_PLUS_EQ] = ACTIONS(790),
    [anon_sym_DASH_EQ] = ACTIONS(790),
    [anon_sym_STAR_EQ] = ACTIONS(790),
    [anon_sym_SLASH_EQ] = ACTIONS(790),
    [anon_sym_PERCENT_EQ] = ACTIONS(790),
    [anon_sym_CARET_EQ] = ACTIONS(790),
    [anon_sym_AMP_EQ] = ACTIONS(790),
    [anon_sym_PIPE_EQ] = ACTIONS(790),
    [anon_sym_GT_GT_EQ] = ACTIONS(790),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(790),
    [anon_sym_LT_LT_EQ] = ACTIONS(790),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(790),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(790),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(790),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(790),
    [anon_sym_AMP_AMP] = ACTIONS(775),
    [anon_sym_PIPE_PIPE] = ACTIONS(775),
    [anon_sym_GT_GT] = ACTIONS(775),
    [anon_sym_GT_GT_GT] = ACTIONS(775),
    [anon_sym_LT_LT] = ACTIONS(775),
    [anon_sym_AMP] = ACTIONS(775),
    [anon_sym_CARET] = ACTIONS(775),
    [anon_sym_PIPE] = ACTIONS(775),
    [anon_sym_PLUS] = ACTIONS(775),
    [anon_sym_DASH] = ACTIONS(775),
    [anon_sym_SLASH] = ACTIONS(775),
    [anon_sym_PERCENT] = ACTIONS(775),
    [anon_sym_STAR_STAR] = ACTIONS(775),
    [anon_sym_LT_EQ] = ACTIONS(764),
    [anon_sym_EQ_EQ] = ACTIONS(775),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(764),
    [anon_sym_BANG_EQ] = ACTIONS(775),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(764),
    [anon_sym_GT_EQ] = ACTIONS(764),
    [anon_sym_QMARK_QMARK] = ACTIONS(775),
    [anon_sym_instanceof] = ACTIONS(764),
    [anon_sym_PLUS_PLUS] = ACTIONS(764),
    [anon_sym_DASH_DASH] = ACTIONS(764),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(91),
    [sym__automatic_semicolon] = ACTIONS(764),
    [sym__ternary_qmark] = ACTIONS(764),
    [sym_html_comment] = ACTIONS(5),
  },
  [139] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(780),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1642),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [140] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(760),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1660),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [141] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(747),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_sequence_expression] = STATE(1570),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [142] = {
    [sym_import] = STATE(1232),
    [sym_statement_block] = STATE(729),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(730),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [143] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(461),
    [sym_expression] = STATE(868),
    [sym_primary_expression] = STATE(579),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1663),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1663),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(584),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(461),
    [sym_subscript_expression] = STATE(461),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1663),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(802),
    [anon_sym_export] = ACTIONS(804),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(804),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DOT] = ACTIONS(806),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(808),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(810),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(804),
    [anon_sym_get] = ACTIONS(804),
    [anon_sym_set] = ACTIONS(804),
    [sym_html_comment] = ACTIONS(5),
  },
  [144] = {
    [sym_import] = STATE(1232),
    [sym_statement_block] = STATE(625),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(733),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [145] = {
    [sym_import] = STATE(1232),
    [sym_statement_block] = STATE(622),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(623),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [146] = {
    [sym_import] = STATE(1272),
    [sym_statement_block] = STATE(560),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(589),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(754),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [147] = {
    [sym_import] = STATE(1232),
    [sym_statement_block] = STATE(628),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(629),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [148] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(756),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1681),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [149] = {
    [sym_import] = STATE(1232),
    [sym_statement_block] = STATE(685),
    [sym_parenthesized_expression] = STATE(487),
    [sym_expression] = STATE(694),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1708),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1708),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(487),
    [sym_subscript_expression] = STATE(487),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1708),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1709),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(419),
    [anon_sym_export] = ACTIONS(421),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(425),
    [anon_sym_yield] = ACTIONS(427),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(429),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(431),
    [anon_sym_PLUS] = ACTIONS(433),
    [anon_sym_DASH] = ACTIONS(433),
    [anon_sym_SLASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(433),
    [anon_sym_void] = ACTIONS(433),
    [anon_sym_delete] = ACTIONS(433),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(441),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(421),
    [anon_sym_get] = ACTIONS(421),
    [anon_sym_set] = ACTIONS(421),
    [sym_html_comment] = ACTIONS(5),
  },
  [150] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(770),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1672),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [151] = {
    [sym_import] = STATE(1232),
    [sym_statement_block] = STATE(729),
    [sym_parenthesized_expression] = STATE(487),
    [sym_expression] = STATE(709),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1708),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1708),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(487),
    [sym_subscript_expression] = STATE(487),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1708),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1709),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(419),
    [anon_sym_export] = ACTIONS(421),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(425),
    [anon_sym_yield] = ACTIONS(427),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(429),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(431),
    [anon_sym_PLUS] = ACTIONS(433),
    [anon_sym_DASH] = ACTIONS(433),
    [anon_sym_SLASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(433),
    [anon_sym_void] = ACTIONS(433),
    [anon_sym_delete] = ACTIONS(433),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(441),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(421),
    [anon_sym_get] = ACTIONS(421),
    [anon_sym_set] = ACTIONS(421),
    [sym_html_comment] = ACTIONS(5),
  },
  [152] = {
    [sym_import] = STATE(1232),
    [sym_statement_block] = STATE(622),
    [sym_parenthesized_expression] = STATE(487),
    [sym_expression] = STATE(712),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1708),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1708),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(487),
    [sym_subscript_expression] = STATE(487),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1708),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1709),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(419),
    [anon_sym_export] = ACTIONS(421),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(425),
    [anon_sym_yield] = ACTIONS(427),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(429),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(431),
    [anon_sym_PLUS] = ACTIONS(433),
    [anon_sym_DASH] = ACTIONS(433),
    [anon_sym_SLASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(433),
    [anon_sym_void] = ACTIONS(433),
    [anon_sym_delete] = ACTIONS(433),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(441),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(421),
    [anon_sym_get] = ACTIONS(421),
    [anon_sym_set] = ACTIONS(421),
    [sym_html_comment] = ACTIONS(5),
  },
  [153] = {
    [sym_import] = STATE(1232),
    [sym_statement_block] = STATE(628),
    [sym_parenthesized_expression] = STATE(487),
    [sym_expression] = STATE(713),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1708),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1708),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(487),
    [sym_subscript_expression] = STATE(487),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1708),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1709),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(419),
    [anon_sym_export] = ACTIONS(421),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(425),
    [anon_sym_yield] = ACTIONS(427),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(429),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(431),
    [anon_sym_PLUS] = ACTIONS(433),
    [anon_sym_DASH] = ACTIONS(433),
    [anon_sym_SLASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(433),
    [anon_sym_void] = ACTIONS(433),
    [anon_sym_delete] = ACTIONS(433),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(441),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(421),
    [anon_sym_get] = ACTIONS(421),
    [anon_sym_set] = ACTIONS(421),
    [sym_html_comment] = ACTIONS(5),
  },
  [154] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(774),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1615),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [155] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(773),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1694),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [156] = {
    [sym_import] = STATE(1232),
    [sym_statement_block] = STATE(630),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(631),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [157] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(768),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1695),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [158] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(765),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1650),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [159] = {
    [sym_import] = STATE(1272),
    [sym_statement_block] = STATE(532),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(582),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(754),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [160] = {
    [sym_import] = STATE(1272),
    [sym_statement_block] = STATE(543),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(585),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(754),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [161] = {
    [sym_import] = STATE(1272),
    [sym_statement_block] = STATE(548),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(578),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(754),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [162] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(461),
    [sym_expression] = STATE(868),
    [sym_primary_expression] = STATE(579),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1663),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1663),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(584),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(461),
    [sym_subscript_expression] = STATE(461),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1663),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1709),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(812),
    [anon_sym_export] = ACTIONS(814),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(814),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DOT] = ACTIONS(806),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(816),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(431),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(810),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(814),
    [anon_sym_get] = ACTIONS(814),
    [anon_sym_set] = ACTIONS(814),
    [sym_html_comment] = ACTIONS(5),
  },
  [163] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(809),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1687),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [164] = {
    [sym_import] = STATE(1232),
    [sym_statement_block] = STATE(685),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(686),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [165] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(775),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1668),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [166] = {
    [sym_import] = STATE(1272),
    [sym_statement_block] = STATE(532),
    [sym_parenthesized_expression] = STATE(502),
    [sym_expression] = STATE(835),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1720),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1720),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(502),
    [sym_subscript_expression] = STATE(502),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1029),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1720),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(473),
    [anon_sym_export] = ACTIONS(475),
    [anon_sym_LBRACE] = ACTIONS(752),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(475),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(479),
    [anon_sym_yield] = ACTIONS(481),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(483),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(485),
    [anon_sym_PLUS] = ACTIONS(487),
    [anon_sym_DASH] = ACTIONS(487),
    [anon_sym_SLASH] = ACTIONS(489),
    [anon_sym_BANG] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_typeof] = ACTIONS(487),
    [anon_sym_void] = ACTIONS(487),
    [anon_sym_delete] = ACTIONS(487),
    [anon_sym_PLUS_PLUS] = ACTIONS(493),
    [anon_sym_DASH_DASH] = ACTIONS(493),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(495),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(497),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(475),
    [anon_sym_get] = ACTIONS(475),
    [anon_sym_set] = ACTIONS(475),
    [sym_html_comment] = ACTIONS(5),
  },
  [167] = {
    [sym_import] = STATE(1272),
    [sym_statement_block] = STATE(543),
    [sym_parenthesized_expression] = STATE(502),
    [sym_expression] = STATE(838),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1720),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1720),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(502),
    [sym_subscript_expression] = STATE(502),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1029),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1720),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(473),
    [anon_sym_export] = ACTIONS(475),
    [anon_sym_LBRACE] = ACTIONS(752),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(475),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(479),
    [anon_sym_yield] = ACTIONS(481),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(483),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(485),
    [anon_sym_PLUS] = ACTIONS(487),
    [anon_sym_DASH] = ACTIONS(487),
    [anon_sym_SLASH] = ACTIONS(489),
    [anon_sym_BANG] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_typeof] = ACTIONS(487),
    [anon_sym_void] = ACTIONS(487),
    [anon_sym_delete] = ACTIONS(487),
    [anon_sym_PLUS_PLUS] = ACTIONS(493),
    [anon_sym_DASH_DASH] = ACTIONS(493),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(495),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(497),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(475),
    [anon_sym_get] = ACTIONS(475),
    [anon_sym_set] = ACTIONS(475),
    [sym_html_comment] = ACTIONS(5),
  },
  [168] = {
    [sym_import] = STATE(1272),
    [sym_statement_block] = STATE(548),
    [sym_parenthesized_expression] = STATE(502),
    [sym_expression] = STATE(851),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1720),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1720),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(502),
    [sym_subscript_expression] = STATE(502),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1029),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1720),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(473),
    [anon_sym_export] = ACTIONS(475),
    [anon_sym_LBRACE] = ACTIONS(752),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(475),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(479),
    [anon_sym_yield] = ACTIONS(481),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(483),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(485),
    [anon_sym_PLUS] = ACTIONS(487),
    [anon_sym_DASH] = ACTIONS(487),
    [anon_sym_SLASH] = ACTIONS(489),
    [anon_sym_BANG] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_typeof] = ACTIONS(487),
    [anon_sym_void] = ACTIONS(487),
    [anon_sym_delete] = ACTIONS(487),
    [anon_sym_PLUS_PLUS] = ACTIONS(493),
    [anon_sym_DASH_DASH] = ACTIONS(493),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(495),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(497),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(475),
    [anon_sym_get] = ACTIONS(475),
    [anon_sym_set] = ACTIONS(475),
    [sym_html_comment] = ACTIONS(5),
  },
  [169] = {
    [sym_import] = STATE(1272),
    [sym_statement_block] = STATE(558),
    [sym_parenthesized_expression] = STATE(502),
    [sym_expression] = STATE(852),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1720),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1720),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(502),
    [sym_subscript_expression] = STATE(502),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1029),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1720),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(473),
    [anon_sym_export] = ACTIONS(475),
    [anon_sym_LBRACE] = ACTIONS(752),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(475),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(479),
    [anon_sym_yield] = ACTIONS(481),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(483),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(485),
    [anon_sym_PLUS] = ACTIONS(487),
    [anon_sym_DASH] = ACTIONS(487),
    [anon_sym_SLASH] = ACTIONS(489),
    [anon_sym_BANG] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_typeof] = ACTIONS(487),
    [anon_sym_void] = ACTIONS(487),
    [anon_sym_delete] = ACTIONS(487),
    [anon_sym_PLUS_PLUS] = ACTIONS(493),
    [anon_sym_DASH_DASH] = ACTIONS(493),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(495),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(497),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(475),
    [anon_sym_get] = ACTIONS(475),
    [anon_sym_set] = ACTIONS(475),
    [sym_html_comment] = ACTIONS(5),
  },
  [170] = {
    [sym_import] = STATE(1272),
    [sym_statement_block] = STATE(560),
    [sym_parenthesized_expression] = STATE(502),
    [sym_expression] = STATE(853),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1720),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1720),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(502),
    [sym_subscript_expression] = STATE(502),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1029),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1720),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(473),
    [anon_sym_export] = ACTIONS(475),
    [anon_sym_LBRACE] = ACTIONS(752),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(475),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(479),
    [anon_sym_yield] = ACTIONS(481),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(483),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(485),
    [anon_sym_PLUS] = ACTIONS(487),
    [anon_sym_DASH] = ACTIONS(487),
    [anon_sym_SLASH] = ACTIONS(489),
    [anon_sym_BANG] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_typeof] = ACTIONS(487),
    [anon_sym_void] = ACTIONS(487),
    [anon_sym_delete] = ACTIONS(487),
    [anon_sym_PLUS_PLUS] = ACTIONS(493),
    [anon_sym_DASH_DASH] = ACTIONS(493),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(495),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(497),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(475),
    [anon_sym_get] = ACTIONS(475),
    [anon_sym_set] = ACTIONS(475),
    [sym_html_comment] = ACTIONS(5),
  },
  [171] = {
    [sym_import] = STATE(1272),
    [sym_statement_block] = STATE(561),
    [sym_parenthesized_expression] = STATE(502),
    [sym_expression] = STATE(854),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1720),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1720),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(502),
    [sym_subscript_expression] = STATE(502),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1029),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1720),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(473),
    [anon_sym_export] = ACTIONS(475),
    [anon_sym_LBRACE] = ACTIONS(752),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(475),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(479),
    [anon_sym_yield] = ACTIONS(481),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(483),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(485),
    [anon_sym_PLUS] = ACTIONS(487),
    [anon_sym_DASH] = ACTIONS(487),
    [anon_sym_SLASH] = ACTIONS(489),
    [anon_sym_BANG] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_typeof] = ACTIONS(487),
    [anon_sym_void] = ACTIONS(487),
    [anon_sym_delete] = ACTIONS(487),
    [anon_sym_PLUS_PLUS] = ACTIONS(493),
    [anon_sym_DASH_DASH] = ACTIONS(493),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(495),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(497),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(475),
    [anon_sym_get] = ACTIONS(475),
    [anon_sym_set] = ACTIONS(475),
    [sym_html_comment] = ACTIONS(5),
  },
  [172] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(867),
    [sym_primary_expression] = STATE(503),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1663),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1663),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(504),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1663),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(818),
    [anon_sym_export] = ACTIONS(820),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(820),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DOT] = ACTIONS(756),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(822),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(485),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(489),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(820),
    [anon_sym_get] = ACTIONS(820),
    [anon_sym_set] = ACTIONS(820),
    [sym_html_comment] = ACTIONS(5),
  },
  [173] = {
    [sym_import] = STATE(1272),
    [sym_statement_block] = STATE(558),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(587),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(754),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [174] = {
    [sym_import] = STATE(1232),
    [sym_statement_block] = STATE(625),
    [sym_parenthesized_expression] = STATE(487),
    [sym_expression] = STATE(690),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1708),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1708),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(487),
    [sym_subscript_expression] = STATE(487),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1708),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1709),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(419),
    [anon_sym_export] = ACTIONS(421),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(425),
    [anon_sym_yield] = ACTIONS(427),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(429),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(431),
    [anon_sym_PLUS] = ACTIONS(433),
    [anon_sym_DASH] = ACTIONS(433),
    [anon_sym_SLASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(433),
    [anon_sym_void] = ACTIONS(433),
    [anon_sym_delete] = ACTIONS(433),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(441),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(421),
    [anon_sym_get] = ACTIONS(421),
    [anon_sym_set] = ACTIONS(421),
    [sym_html_comment] = ACTIONS(5),
  },
  [175] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(673),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [176] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(862),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1663),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1663),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1663),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(445),
    [anon_sym_export] = ACTIONS(447),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(447),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(459),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(447),
    [anon_sym_get] = ACTIONS(447),
    [anon_sym_set] = ACTIONS(447),
    [sym_html_comment] = ACTIONS(5),
  },
  [177] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(858),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1663),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1663),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1663),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(445),
    [anon_sym_export] = ACTIONS(447),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(447),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(459),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(447),
    [anon_sym_get] = ACTIONS(447),
    [anon_sym_set] = ACTIONS(447),
    [sym_html_comment] = ACTIONS(5),
  },
  [178] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(666),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [179] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(609),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [180] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(821),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [181] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(611),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [182] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(684),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [183] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(687),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [184] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(859),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1663),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1663),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1015),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1663),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1655),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(445),
    [anon_sym_export] = ACTIONS(447),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(447),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(453),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(459),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(463),
    [anon_sym_void] = ACTIONS(463),
    [anon_sym_delete] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(469),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(447),
    [anon_sym_get] = ACTIONS(447),
    [anon_sym_set] = ACTIONS(447),
    [sym_html_comment] = ACTIONS(5),
  },
  [185] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(691),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [186] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(758),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [187] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(697),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [188] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(710),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [189] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(711),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [190] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(715),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [191] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(716),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [192] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(717),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [193] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(719),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [194] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(720),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [195] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(721),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [196] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(722),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [197] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(737),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1219),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1219),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1219),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(824),
    [anon_sym_export] = ACTIONS(826),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(826),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(828),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(830),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(826),
    [anon_sym_get] = ACTIONS(826),
    [anon_sym_set] = ACTIONS(826),
    [sym_html_comment] = ACTIONS(5),
  },
  [198] = {
    [sym_import] = STATE(1232),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(728),
    [sym_primary_expression] = STATE(614),
    [sym_yield_expression] = STATE(672),
    [sym_object] = STATE(677),
    [sym_object_pattern] = STATE(1644),
    [sym_array] = STATE(677),
    [sym_array_pattern] = STATE(1644),
    [sym_jsx_element] = STATE(672),
    [sym_jsx_opening_element] = STATE(1043),
    [sym_jsx_self_closing_element] = STATE(672),
    [sym_class] = STATE(677),
    [sym_function_expression] = STATE(677),
    [sym_generator_function] = STATE(677),
    [sym_arrow_function] = STATE(677),
    [sym_call_expression] = STATE(677),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(672),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(672),
    [sym__augmented_assignment_lhs] = STATE(1023),
    [sym_augmented_assignment_expression] = STATE(672),
    [sym__destructuring_pattern] = STATE(1644),
    [sym_ternary_expression] = STATE(672),
    [sym_binary_expression] = STATE(672),
    [sym_unary_expression] = STATE(672),
    [sym_update_expression] = STATE(672),
    [sym_string] = STATE(677),
    [sym_template_string] = STATE(677),
    [sym_regex] = STATE(677),
    [sym_meta_property] = STATE(677),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1623),
    [aux_sym_export_statement_repeat1] = STATE(1204),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_SQUOTE] = ACTIONS(63),
    [anon_sym_class] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(75),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(77),
    [anon_sym_typeof] = ACTIONS(73),
    [anon_sym_void] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(73),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [199] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(510),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [200] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(507),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [201] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(580),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [202] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(575),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [203] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(583),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [204] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(586),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [205] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(588),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [206] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(607),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [207] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(590),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [208] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(591),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(619),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_class] = ACTIONS(375),
    [anon_sym_async] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(379),
    [anon_sym_new] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [209] = {
    [sym_import] = STATE(1272),
    [sym_parenthesized_expression] = STATE(443),
    [sym_expression] = STATE(592),
    [sym_primary_expression] = STATE(509),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(523),
    [sym_object_pattern] = STATE(1649),
    [sym_array] = STATE(523),
    [sym_array_pattern] = STATE(1649),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_opening_element] = STATE(1037),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(523),
    [sym_function_expression] = STATE(523),
    [sym_generator_function] = STATE(523),
    [sym_arrow_function] = STATE(523),
    [sym_call_expression] = STATE(523),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(443),
    [sym_subscript_expression] = STATE(443),
    [sym_assignment_expression] = STATE(524),
    [sym__augmented_assignment_lhs] = STATE(1019),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym__destructuring_pattern] = STATE(1649),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(523),
    [sym_template_string] = STATE(523),
    [sym_regex] = STATE(523),
    [sym_meta_property] = STATE(523),
    [sym_decorator] = STATE(1006),
    [sym_formal_parameters] = STATE(1666),
    [aux_sym_export_statement_repeat1] = STATE(1253),
    [sym_identifier] = ACTIONS(347),
    [an