// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transfer

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateAccess = "CreateAccess"

// CreateAccessRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccess for more information on using the CreateAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAccessRequest method.
//    req, resp := client.CreateAccessRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateAccess
func (c *Transfer) CreateAccessRequest(input *CreateAccessInput) (req *request.Request, output *CreateAccessOutput) {
	op := &request.Operation{
		Name:       opCreateAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAccessInput{}
	}

	output = &CreateAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccess API operation for AWS Transfer Family.
//
// Used by administrators to choose which groups in the directory should have
// access to upload and download files over the enabled protocols using Amazon
// Web Services Transfer Family. For example, a Microsoft Active Directory might
// contain 50,000 users, but only a small fraction might need the ability to
// transfer files to the server. An administrator can use CreateAccess to limit
// the access to the correct set of users who need this ability.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation CreateAccess for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceExistsException
//   The requested resource does not exist.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateAccess
func (c *Transfer) CreateAccess(input *CreateAccessInput) (*CreateAccessOutput, error) {
	req, out := c.CreateAccessRequest(input)
	return out, req.Send()
}

// CreateAccessWithContext is the same as CreateAccess with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) CreateAccessWithContext(ctx aws.Context, input *CreateAccessInput, opts ...request.Option) (*CreateAccessOutput, error) {
	req, out := c.CreateAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateServer = "CreateServer"

// CreateServerRequest generates a "aws/request.Request" representing the
// client's request for the CreateServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateServer for more information on using the CreateServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateServerRequest method.
//    req, resp := client.CreateServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateServer
func (c *Transfer) CreateServerRequest(input *CreateServerInput) (req *request.Request, output *CreateServerOutput) {
	op := &request.Operation{
		Name:       opCreateServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateServerInput{}
	}

	output = &CreateServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateServer API operation for AWS Transfer Family.
//
// Instantiates an auto-scaling virtual server based on the selected file transfer
// protocol in Amazon Web Services. When you make updates to your file transfer
// protocol-enabled server or when you work with users, use the service-generated
// ServerId property that is assigned to the newly created server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation CreateServer for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceExistsException
//   The requested resource does not exist.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateServer
func (c *Transfer) CreateServer(input *CreateServerInput) (*CreateServerOutput, error) {
	req, out := c.CreateServerRequest(input)
	return out, req.Send()
}

// CreateServerWithContext is the same as CreateServer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) CreateServerWithContext(ctx aws.Context, input *CreateServerInput, opts ...request.Option) (*CreateServerOutput, error) {
	req, out := c.CreateServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUser for more information on using the CreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserRequest method.
//    req, resp := client.CreateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateUser
func (c *Transfer) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUser API operation for AWS Transfer Family.
//
// Creates a user and associates them with an existing file transfer protocol-enabled
// server. You can only create and associate users with servers that have the
// IdentityProviderType set to SERVICE_MANAGED. Using parameters for CreateUser,
// you can specify the user name, set the home directory, store the user's public
// key, and assign the user's Amazon Web Services Identity and Access Management
// (IAM) role. You can also optionally add a session policy, and assign metadata
// with tags that can be used to group and search for users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation CreateUser for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceExistsException
//   The requested resource does not exist.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateUser
func (c *Transfer) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	return out, req.Send()
}

// CreateUserWithContext is the same as CreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) CreateUserWithContext(ctx aws.Context, input *CreateUserInput, opts ...request.Option) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkflow = "CreateWorkflow"

// CreateWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkflow for more information on using the CreateWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWorkflowRequest method.
//    req, resp := client.CreateWorkflowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateWorkflow
func (c *Transfer) CreateWorkflowRequest(input *CreateWorkflowInput) (req *request.Request, output *CreateWorkflowOutput) {
	op := &request.Operation{
		Name:       opCreateWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkflowInput{}
	}

	output = &CreateWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkflow API operation for AWS Transfer Family.
//
// Allows you to create a workflow with specified steps and step details the
// workflow invokes after file transfer completes. After creating a workflow,
// you can associate the workflow created with any transfer servers by specifying
// the workflow-details field in CreateServer and UpdateServer operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation CreateWorkflow for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceExistsException
//   The requested resource does not exist.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateWorkflow
func (c *Transfer) CreateWorkflow(input *CreateWorkflowInput) (*CreateWorkflowOutput, error) {
	req, out := c.CreateWorkflowRequest(input)
	return out, req.Send()
}

// CreateWorkflowWithContext is the same as CreateWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) CreateWorkflowWithContext(ctx aws.Context, input *CreateWorkflowInput, opts ...request.Option) (*CreateWorkflowOutput, error) {
	req, out := c.CreateWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccess = "DeleteAccess"

// DeleteAccessRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccess for more information on using the DeleteAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAccessRequest method.
//    req, resp := client.DeleteAccessRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteAccess
func (c *Transfer) DeleteAccessRequest(input *DeleteAccessInput) (req *request.Request, output *DeleteAccessOutput) {
	op := &request.Operation{
		Name:       opDeleteAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAccessInput{}
	}

	output = &DeleteAccessOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAccess API operation for AWS Transfer Family.
//
// Allows you to delete the access specified in the ServerID and ExternalID
// parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation DeleteAccess for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteAccess
func (c *Transfer) DeleteAccess(input *DeleteAccessInput) (*DeleteAccessOutput, error) {
	req, out := c.DeleteAccessRequest(input)
	return out, req.Send()
}

// DeleteAccessWithContext is the same as DeleteAccess with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DeleteAccessWithContext(ctx aws.Context, input *DeleteAccessInput, opts ...request.Option) (*DeleteAccessOutput, error) {
	req, out := c.DeleteAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteServer = "DeleteServer"

// DeleteServerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteServer for more information on using the DeleteServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteServerRequest method.
//    req, resp := client.DeleteServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteServer
func (c *Transfer) DeleteServerRequest(input *DeleteServerInput) (req *request.Request, output *DeleteServerOutput) {
	op := &request.Operation{
		Name:       opDeleteServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServerInput{}
	}

	output = &DeleteServerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteServer API operation for AWS Transfer Family.
//
// Deletes the file transfer protocol-enabled server that you specify.
//
// No response returns from this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation DeleteServer for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteServer
func (c *Transfer) DeleteServer(input *DeleteServerInput) (*DeleteServerOutput, error) {
	req, out := c.DeleteServerRequest(input)
	return out, req.Send()
}

// DeleteServerWithContext is the same as DeleteServer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DeleteServerWithContext(ctx aws.Context, input *DeleteServerInput, opts ...request.Option) (*DeleteServerOutput, error) {
	req, out := c.DeleteServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSshPublicKey = "DeleteSshPublicKey"

// DeleteSshPublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSshPublicKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSshPublicKey for more information on using the DeleteSshPublicKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSshPublicKeyRequest method.
//    req, resp := client.DeleteSshPublicKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteSshPublicKey
func (c *Transfer) DeleteSshPublicKeyRequest(input *DeleteSshPublicKeyInput) (req *request.Request, output *DeleteSshPublicKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteSshPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSshPublicKeyInput{}
	}

	output = &DeleteSshPublicKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSshPublicKey API operation for AWS Transfer Family.
//
// Deletes a user's Secure Shell (SSH) public key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation DeleteSshPublicKey for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteSshPublicKey
func (c *Transfer) DeleteSshPublicKey(input *DeleteSshPublicKeyInput) (*DeleteSshPublicKeyOutput, error) {
	req, out := c.DeleteSshPublicKeyRequest(input)
	return out, req.Send()
}

// DeleteSshPublicKeyWithContext is the same as DeleteSshPublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSshPublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DeleteSshPublicKeyWithContext(ctx aws.Context, input *DeleteSshPublicKeyInput, opts ...request.Option) (*DeleteSshPublicKeyOutput, error) {
	req, out := c.DeleteSshPublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserRequest method.
//    req, resp := client.DeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteUser
func (c *Transfer) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUser API operation for AWS Transfer Family.
//
// Deletes the user belonging to a file transfer protocol-enabled server you
// specify.
//
// No response returns from this operation.
//
// When you delete a user from a server, the user's information is lost.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation DeleteUser for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteUser
func (c *Transfer) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkflow = "DeleteWorkflow"

// DeleteWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkflow for more information on using the DeleteWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWorkflowRequest method.
//    req, resp := client.DeleteWorkflowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteWorkflow
func (c *Transfer) DeleteWorkflowRequest(input *DeleteWorkflowInput) (req *request.Request, output *DeleteWorkflowOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWorkflowInput{}
	}

	output = &DeleteWorkflowOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkflow API operation for AWS Transfer Family.
//
// Deletes the specified workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation DeleteWorkflow for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteWorkflow
func (c *Transfer) DeleteWorkflow(input *DeleteWorkflowInput) (*DeleteWorkflowOutput, error) {
	req, out := c.DeleteWorkflowRequest(input)
	return out, req.Send()
}

// DeleteWorkflowWithContext is the same as DeleteWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DeleteWorkflowWithContext(ctx aws.Context, input *DeleteWorkflowInput, opts ...request.Option) (*DeleteWorkflowOutput, error) {
	req, out := c.DeleteWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccess = "DescribeAccess"

// DescribeAccessRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccess for more information on using the DescribeAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccessRequest method.
//    req, resp := client.DescribeAccessRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeAccess
func (c *Transfer) DescribeAccessRequest(input *DescribeAccessInput) (req *request.Request, output *DescribeAccessOutput) {
	op := &request.Operation{
		Name:       opDescribeAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccessInput{}
	}

	output = &DescribeAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccess API operation for AWS Transfer Family.
//
// Describes the access that is assigned to the specific file transfer protocol-enabled
// server, as identified by its ServerId property and its ExternalID.
//
// The response from this call returns the properties of the access that is
// associated with the ServerId value that was specified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation DescribeAccess for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeAccess
func (c *Transfer) DescribeAccess(input *DescribeAccessInput) (*DescribeAccessOutput, error) {
	req, out := c.DescribeAccessRequest(input)
	return out, req.Send()
}

// DescribeAccessWithContext is the same as DescribeAccess with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DescribeAccessWithContext(ctx aws.Context, input *DescribeAccessInput, opts ...request.Option) (*DescribeAccessOutput, error) {
	req, out := c.DescribeAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeExecution = "DescribeExecution"

// DescribeExecutionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeExecution for more information on using the DescribeExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeExecutionRequest method.
//    req, resp := client.DescribeExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeExecution
func (c *Transfer) DescribeExecutionRequest(input *DescribeExecutionInput) (req *request.Request, output *DescribeExecutionOutput) {
	op := &request.Operation{
		Name:       opDescribeExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExecutionInput{}
	}

	output = &DescribeExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExecution API operation for AWS Transfer Family.
//
// You can use DescribeExecution to check the details of the execution of the
// specified workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation DescribeExecution for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeExecution
func (c *Transfer) DescribeExecution(input *DescribeExecutionInput) (*DescribeExecutionOutput, error) {
	req, out := c.DescribeExecutionRequest(input)
	return out, req.Send()
}

// DescribeExecutionWithContext is the same as DescribeExecution with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DescribeExecutionWithContext(ctx aws.Context, input *DescribeExecutionInput, opts ...request.Option) (*DescribeExecutionOutput, error) {
	req, out := c.DescribeExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSecurityPolicy = "DescribeSecurityPolicy"

// DescribeSecurityPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSecurityPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSecurityPolicy for more information on using the DescribeSecurityPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSecurityPolicyRequest method.
//    req, resp := client.DescribeSecurityPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeSecurityPolicy
func (c *Transfer) DescribeSecurityPolicyRequest(input *DescribeSecurityPolicyInput) (req *request.Request, output *DescribeSecurityPolicyOutput) {
	op := &request.Operation{
		Name:       opDescribeSecurityPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSecurityPolicyInput{}
	}

	output = &DescribeSecurityPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSecurityPolicy API operation for AWS Transfer Family.
//
// Describes the security policy that is attached to your file transfer protocol-enabled
// server. The response contains a description of the security policy's properties.
// For more information about security policies, see Working with security policies
// (https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation DescribeSecurityPolicy for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeSecurityPolicy
func (c *Transfer) DescribeSecurityPolicy(input *DescribeSecurityPolicyInput) (*DescribeSecurityPolicyOutput, error) {
	req, out := c.DescribeSecurityPolicyRequest(input)
	return out, req.Send()
}

// DescribeSecurityPolicyWithContext is the same as DescribeSecurityPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSecurityPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DescribeSecurityPolicyWithContext(ctx aws.Context, input *DescribeSecurityPolicyInput, opts ...request.Option) (*DescribeSecurityPolicyOutput, error) {
	req, out := c.DescribeSecurityPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeServer = "DescribeServer"

// DescribeServerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeServer for more information on using the DescribeServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeServerRequest method.
//    req, resp := client.DescribeServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeServer
func (c *Transfer) DescribeServerRequest(input *DescribeServerInput) (req *request.Request, output *DescribeServerOutput) {
	op := &request.Operation{
		Name:       opDescribeServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeServerInput{}
	}

	output = &DescribeServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeServer API operation for AWS Transfer Family.
//
// Describes a file transfer protocol-enabled server that you specify by passing
// the ServerId parameter.
//
// The response contains a description of a server's properties. When you set
// EndpointType to VPC, the response will contain the EndpointDetails.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation DescribeServer for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeServer
func (c *Transfer) DescribeServer(input *DescribeServerInput) (*DescribeServerOutput, error) {
	req, out := c.DescribeServerRequest(input)
	return out, req.Send()
}

// DescribeServerWithContext is the same as DescribeServer with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DescribeServerWithContext(ctx aws.Context, input *DescribeServerInput, opts ...request.Option) (*DescribeServerOutput, error) {
	req, out := c.DescribeServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUser = "DescribeUser"

// DescribeUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUser for more information on using the DescribeUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserRequest method.
//    req, resp := client.DescribeUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeUser
func (c *Transfer) DescribeUserRequest(input *DescribeUserInput) (req *request.Request, output *DescribeUserOutput) {
	op := &request.Operation{
		Name:       opDescribeUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserInput{}
	}

	output = &DescribeUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUser API operation for AWS Transfer Family.
//
// Describes the user assigned to the specific file transfer protocol-enabled
// server, as identified by its ServerId property.
//
// The response from this call returns the properties of the user associated
// with the ServerId value that was specified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation DescribeUser for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeUser
func (c *Transfer) DescribeUser(input *DescribeUserInput) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	return out, req.Send()
}

// DescribeUserWithContext is the same as DescribeUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DescribeUserWithContext(ctx aws.Context, input *DescribeUserInput, opts ...request.Option) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkflow = "DescribeWorkflow"

// DescribeWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkflow for more information on using the DescribeWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkflowRequest method.
//    req, resp := client.DescribeWorkflowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeWorkflow
func (c *Transfer) DescribeWorkflowRequest(input *DescribeWorkflowInput) (req *request.Request, output *DescribeWorkflowOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkflowInput{}
	}

	output = &DescribeWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkflow API operation for AWS Transfer Family.
//
// Describes the specified workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation DescribeWorkflow for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeWorkflow
func (c *Transfer) DescribeWorkflow(input *DescribeWorkflowInput) (*DescribeWorkflowOutput, error) {
	req, out := c.DescribeWorkflowRequest(input)
	return out, req.Send()
}

// DescribeWorkflowWithContext is the same as DescribeWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DescribeWorkflowWithContext(ctx aws.Context, input *DescribeWorkflowInput, opts ...request.Option) (*DescribeWorkflowOutput, error) {
	req, out := c.DescribeWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportSshPublicKey = "ImportSshPublicKey"

// ImportSshPublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the ImportSshPublicKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportSshPublicKey for more information on using the ImportSshPublicKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportSshPublicKeyRequest method.
//    req, resp := client.ImportSshPublicKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ImportSshPublicKey
func (c *Transfer) ImportSshPublicKeyRequest(input *ImportSshPublicKeyInput) (req *request.Request, output *ImportSshPublicKeyOutput) {
	op := &request.Operation{
		Name:       opImportSshPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportSshPublicKeyInput{}
	}

	output = &ImportSshPublicKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportSshPublicKey API operation for AWS Transfer Family.
//
// Adds a Secure Shell (SSH) public key to a user account identified by a UserName
// value assigned to the specific file transfer protocol-enabled server, identified
// by ServerId.
//
// The response returns the UserName value, the ServerId value, and the name
// of the SshPublicKeyId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation ImportSshPublicKey for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceExistsException
//   The requested resource does not exist.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ImportSshPublicKey
func (c *Transfer) ImportSshPublicKey(input *ImportSshPublicKeyInput) (*ImportSshPublicKeyOutput, error) {
	req, out := c.ImportSshPublicKeyRequest(input)
	return out, req.Send()
}

// ImportSshPublicKeyWithContext is the same as ImportSshPublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See ImportSshPublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ImportSshPublicKeyWithContext(ctx aws.Context, input *ImportSshPublicKeyInput, opts ...request.Option) (*ImportSshPublicKeyOutput, error) {
	req, out := c.ImportSshPublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccesses = "ListAccesses"

// ListAccessesRequest generates a "aws/request.Request" representing the
// client's request for the ListAccesses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccesses for more information on using the ListAccesses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAccessesRequest method.
//    req, resp := client.ListAccessesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListAccesses
func (c *Transfer) ListAccessesRequest(input *ListAccessesInput) (req *request.Request, output *ListAccessesOutput) {
	op := &request.Operation{
		Name:       opListAccesses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccessesInput{}
	}

	output = &ListAccessesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccesses API operation for AWS Transfer Family.
//
// Lists the details for all the accesses you have on your server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation ListAccesses for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidNextTokenException
//   The NextToken parameter that was passed is invalid.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListAccesses
func (c *Transfer) ListAccesses(input *ListAccessesInput) (*ListAccessesOutput, error) {
	req, out := c.ListAccessesRequest(input)
	return out, req.Send()
}

// ListAccessesWithContext is the same as ListAccesses with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccesses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListAccessesWithContext(ctx aws.Context, input *ListAccessesInput, opts ...request.Option) (*ListAccessesOutput, error) {
	req, out := c.ListAccessesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccessesPages iterates over the pages of a ListAccesses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccesses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAccesses operation.
//    pageNum := 0
//    err := client.ListAccessesPages(params,
//        func(page *transfer.ListAccessesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Transfer) ListAccessesPages(input *ListAccessesInput, fn func(*ListAccessesOutput, bool) bool) error {
	return c.ListAccessesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccessesPagesWithContext same as ListAccessesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListAccessesPagesWithContext(ctx aws.Context, input *ListAccessesInput, fn func(*ListAccessesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccessesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccessesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccessesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListExecutions = "ListExecutions"

// ListExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExecutions for more information on using the ListExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListExecutionsRequest method.
//    req, resp := client.ListExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListExecutions
func (c *Transfer) ListExecutionsRequest(input *ListExecutionsInput) (req *request.Request, output *ListExecutionsOutput) {
	op := &request.Operation{
		Name:       opListExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExecutionsInput{}
	}

	output = &ListExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExecutions API operation for AWS Transfer Family.
//
// Lists all executions for the specified workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation ListExecutions for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidNextTokenException
//   The NextToken parameter that was passed is invalid.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListExecutions
func (c *Transfer) ListExecutions(input *ListExecutionsInput) (*ListExecutionsOutput, error) {
	req, out := c.ListExecutionsRequest(input)
	return out, req.Send()
}

// ListExecutionsWithContext is the same as ListExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListExecutionsWithContext(ctx aws.Context, input *ListExecutionsInput, opts ...request.Option) (*ListExecutionsOutput, error) {
	req, out := c.ListExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExecutionsPages iterates over the pages of a ListExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListExecutions operation.
//    pageNum := 0
//    err := client.ListExecutionsPages(params,
//        func(page *transfer.ListExecutionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Transfer) ListExecutionsPages(input *ListExecutionsInput, fn func(*ListExecutionsOutput, bool) bool) error {
	return c.ListExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExecutionsPagesWithContext same as ListExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListExecutionsPagesWithContext(ctx aws.Context, input *ListExecutionsInput, fn func(*ListExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSecurityPolicies = "ListSecurityPolicies"

// ListSecurityPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListSecurityPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSecurityPolicies for more information on using the ListSecurityPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSecurityPoliciesRequest method.
//    req, resp := client.ListSecurityPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListSecurityPolicies
func (c *Transfer) ListSecurityPoliciesRequest(input *ListSecurityPoliciesInput) (req *request.Request, output *ListSecurityPoliciesOutput) {
	op := &request.Operation{
		Name:       opListSecurityPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSecurityPoliciesInput{}
	}

	output = &ListSecurityPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSecurityPolicies API operation for AWS Transfer Family.
//
// Lists the security policies that are attached to your file transfer protocol-enabled
// servers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation ListSecurityPolicies for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidNextTokenException
//   The NextToken parameter that was passed is invalid.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListSecurityPolicies
func (c *Transfer) ListSecurityPolicies(input *ListSecurityPoliciesInput) (*ListSecurityPoliciesOutput, error) {
	req, out := c.ListSecurityPoliciesRequest(input)
	return out, req.Send()
}

// ListSecurityPoliciesWithContext is the same as ListSecurityPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListSecurityPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListSecurityPoliciesWithContext(ctx aws.Context, input *ListSecurityPoliciesInput, opts ...request.Option) (*ListSecurityPoliciesOutput, error) {
	req, out := c.ListSecurityPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSecurityPoliciesPages iterates over the pages of a ListSecurityPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSecurityPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSecurityPolicies operation.
//    pageNum := 0
//    err := client.ListSecurityPoliciesPages(params,
//        func(page *transfer.ListSecurityPoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Transfer) ListSecurityPoliciesPages(input *ListSecurityPoliciesInput, fn func(*ListSecurityPoliciesOutput, bool) bool) error {
	return c.ListSecurityPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSecurityPoliciesPagesWithContext same as ListSecurityPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListSecurityPoliciesPagesWithContext(ctx aws.Context, input *ListSecurityPoliciesInput, fn func(*ListSecurityPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSecurityPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSecurityPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSecurityPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServers = "ListServers"

// ListServersRequest generates a "aws/request.Request" representing the
// client's request for the ListServers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServers for more information on using the ListServers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListServersRequest method.
//    req, resp := client.ListServersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListServers
func (c *Transfer) ListServersRequest(input *ListServersInput) (req *request.Request, output *ListServersOutput) {
	op := &request.Operation{
		Name:       opListServers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServersInput{}
	}

	output = &ListServersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServers API operation for AWS Transfer Family.
//
// Lists the file transfer protocol-enabled servers that are associated with
// your Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation ListServers for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidNextTokenException
//   The NextToken parameter that was passed is invalid.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListServers
func (c *Transfer) ListServers(input *ListServersInput) (*ListServersOutput, error) {
	req, out := c.ListServersRequest(input)
	return out, req.Send()
}

// ListServersWithContext is the same as ListServers with the addition of
// the ability to pass a context and additional request options.
//
// See ListServers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListServersWithContext(ctx aws.Context, input *ListServersInput, opts ...request.Option) (*ListServersOutput, error) {
	req, out := c.ListServersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServersPages iterates over the pages of a ListServers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListServers operation.
//    pageNum := 0
//    err := client.ListServersPages(params,
//        func(page *transfer.ListServersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Transfer) ListServersPages(input *ListServersInput, fn func(*ListServersOutput, bool) bool) error {
	return c.ListServersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServersPagesWithContext same as ListServersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListServersPagesWithContext(ctx aws.Context, input *ListServersInput, fn func(*ListServersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListTagsForResource
func (c *Transfer) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Transfer Family.
//
// Lists all of the tags associated with the Amazon Resource Name (ARN) that
// you specify. The resource can be a user, server, or role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidNextTokenException
//   The NextToken parameter that was passed is invalid.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListTagsForResource
func (c *Transfer) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTagsForResource operation.
//    pageNum := 0
//    err := client.ListTagsForResourcePages(params,
//        func(page *transfer.ListTagsForResourceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Transfer) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUsersRequest method.
//    req, resp := client.ListUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListUsers
func (c *Transfer) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for AWS Transfer Family.
//
// Lists the users for a file transfer protocol-enabled server that you specify
// by passing the ServerId parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation ListUsers for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidNextTokenException
//   The NextToken parameter that was passed is invalid.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListUsers
func (c *Transfer) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUsersPages iterates over the pages of a ListUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUsers operation.
//    pageNum := 0
//    err := client.ListUsersPages(params,
//        func(page *transfer.ListUsersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Transfer) ListUsersPages(input *ListUsersInput, fn func(*ListUsersOutput, bool) bool) error {
	return c.ListUsersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUsersPagesWithContext same as ListUsersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListUsersPagesWithContext(ctx aws.Context, input *ListUsersInput, fn func(*ListUsersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUsersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUsersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUsersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkflows = "ListWorkflows"

// ListWorkflowsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkflows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkflows for more information on using the ListWorkflows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWorkflowsRequest method.
//    req, resp := client.ListWorkflowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListWorkflows
func (c *Transfer) ListWorkflowsRequest(input *ListWorkflowsInput) (req *request.Request, output *ListWorkflowsOutput) {
	op := &request.Operation{
		Name:       opListWorkflows,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkflowsInput{}
	}

	output = &ListWorkflowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkflows API operation for AWS Transfer Family.
//
// Lists all of your workflows.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation ListWorkflows for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidNextTokenException
//   The NextToken parameter that was passed is invalid.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListWorkflows
func (c *Transfer) ListWorkflows(input *ListWorkflowsInput) (*ListWorkflowsOutput, error) {
	req, out := c.ListWorkflowsRequest(input)
	return out, req.Send()
}

// ListWorkflowsWithContext is the same as ListWorkflows with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkflows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListWorkflowsWithContext(ctx aws.Context, input *ListWorkflowsInput, opts ...request.Option) (*ListWorkflowsOutput, error) {
	req, out := c.ListWorkflowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkflowsPages iterates over the pages of a ListWorkflows operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkflows method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWorkflows operation.
//    pageNum := 0
//    err := client.ListWorkflowsPages(params,
//        func(page *transfer.ListWorkflowsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Transfer) ListWorkflowsPages(input *ListWorkflowsInput, fn func(*ListWorkflowsOutput, bool) bool) error {
	return c.ListWorkflowsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkflowsPagesWithContext same as ListWorkflowsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListWorkflowsPagesWithContext(ctx aws.Context, input *ListWorkflowsInput, fn func(*ListWorkflowsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkflowsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkflowsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkflowsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSendWorkflowStepState = "SendWorkflowStepState"

// SendWorkflowStepStateRequest generates a "aws/request.Request" representing the
// client's request for the SendWorkflowStepState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendWorkflowStepState for more information on using the SendWorkflowStepState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendWorkflowStepStateRequest method.
//    req, resp := client.SendWorkflowStepStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/SendWorkflowStepState
func (c *Transfer) SendWorkflowStepStateRequest(input *SendWorkflowStepStateInput) (req *request.Request, output *SendWorkflowStepStateOutput) {
	op := &request.Operation{
		Name:       opSendWorkflowStepState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendWorkflowStepStateInput{}
	}

	output = &SendWorkflowStepStateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SendWorkflowStepState API operation for AWS Transfer Family.
//
// Sends a callback for asynchronous custom steps.
//
// The ExecutionId, WorkflowId, and Token are passed to the target resource
// during execution of a custom step of a workflow. You must include those with
// their callback as well as providing a status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation SendWorkflowStepState for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/SendWorkflowStepState
func (c *Transfer) SendWorkflowStepState(input *SendWorkflowStepStateInput) (*SendWorkflowStepStateOutput, error) {
	req, out := c.SendWorkflowStepStateRequest(input)
	return out, req.Send()
}

// SendWorkflowStepStateWithContext is the same as SendWorkflowStepState with the addition of
// the ability to pass a context and additional request options.
//
// See SendWorkflowStepState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) SendWorkflowStepStateWithContext(ctx aws.Context, input *SendWorkflowStepStateInput, opts ...request.Option) (*SendWorkflowStepStateOutput, error) {
	req, out := c.SendWorkflowStepStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartServer = "StartServer"

// StartServerRequest generates a "aws/request.Request" representing the
// client's request for the StartServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartServer for more information on using the StartServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartServerRequest method.
//    req, resp := client.StartServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StartServer
func (c *Transfer) StartServerRequest(input *StartServerInput) (req *request.Request, output *StartServerOutput) {
	op := &request.Operation{
		Name:       opStartServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartServerInput{}
	}

	output = &StartServerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartServer API operation for AWS Transfer Family.
//
// Changes the state of a file transfer protocol-enabled server from OFFLINE
// to ONLINE. It has no impact on a server that is already ONLINE. An ONLINE
// server can accept and process file transfer jobs.
//
// The state of STARTING indicates that the server is in an intermediate state,
// either not fully able to respond, or not fully online. The values of START_FAILED
// can indicate an error condition.
//
// No response is returned from this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation StartServer for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StartServer
func (c *Transfer) StartServer(input *StartServerInput) (*StartServerOutput, error) {
	req, out := c.StartServerRequest(input)
	return out, req.Send()
}

// StartServerWithContext is the same as StartServer with the addition of
// the ability to pass a context and additional request options.
//
// See StartServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) StartServerWithContext(ctx aws.Context, input *StartServerInput, opts ...request.Option) (*StartServerOutput, error) {
	req, out := c.StartServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopServer = "StopServer"

// StopServerRequest generates a "aws/request.Request" representing the
// client's request for the StopServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopServer for more information on using the StopServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopServerRequest method.
//    req, resp := client.StopServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StopServer
func (c *Transfer) StopServerRequest(input *StopServerInput) (req *request.Request, output *StopServerOutput) {
	op := &request.Operation{
		Name:       opStopServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopServerInput{}
	}

	output = &StopServerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopServer API operation for AWS Transfer Family.
//
// Changes the state of a file transfer protocol-enabled server from ONLINE
// to OFFLINE. An OFFLINE server cannot accept and process file transfer jobs.
// Information tied to your server, such as server and user properties, are
// not affected by stopping your server.
//
// Stopping the server will not reduce or impact your file transfer protocol
// endpoint billing; you must delete the server to stop being billed.
//
// The state of STOPPING indicates that the server is in an intermediate state,
// either not fully able to respond, or not fully offline. The values of STOP_FAILED
// can indicate an error condition.
//
// No response is returned from this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation StopServer for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StopServer
func (c *Transfer) StopServer(input *StopServerInput) (*StopServerOutput, error) {
	req, out := c.StopServerRequest(input)
	return out, req.Send()
}

// StopServerWithContext is the same as StopServer with the addition of
// the ability to pass a context and additional request options.
//
// See StopServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) StopServerWithContext(ctx aws.Context, input *StopServerInput, opts ...request.Option) (*StopServerOutput, error) {
	req, out := c.StopServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TagResource
func (c *Transfer) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Transfer Family.
//
// Attaches a key-value pair to a resource, as identified by its Amazon Resource
// Name (ARN). Resources are users, servers, roles, and other entities.
//
// There is no response returned from this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TagResource
func (c *Transfer) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestIdentityProvider = "TestIdentityProvider"

// TestIdentityProviderRequest generates a "aws/request.Request" representing the
// client's request for the TestIdentityProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestIdentityProvider for more information on using the TestIdentityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TestIdentityProviderRequest method.
//    req, resp := client.TestIdentityProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TestIdentityProvider
func (c *Transfer) TestIdentityProviderRequest(input *TestIdentityProviderInput) (req *request.Request, output *TestIdentityProviderOutput) {
	op := &request.Operation{
		Name:       opTestIdentityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestIdentityProviderInput{}
	}

	output = &TestIdentityProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestIdentityProvider API operation for AWS Transfer Family.
//
// If the IdentityProviderType of a file transfer protocol-enabled server is
// AWS_DIRECTORY_SERVICE or API_Gateway, tests whether your identity provider
// is set up successfully. We highly recommend that you call this operation
// to test your authentication method as soon as you create your server. By
// doing so, you can troubleshoot issues with the identity provider integration
// to ensure that your users can successfully use the service.
//
// The ServerId and UserName parameters are required. The ServerProtocol, SourceIp,
// and UserPassword are all optional.
//
// You cannot use TestIdentityProvider if the IdentityProviderType of your server
// is SERVICE_MANAGED.
//
//    * If you provide any incorrect values for any parameters, the Response
//    field is empty.
//
//    * If you provide a server ID for a server that uses service-managed users,
//    you get an error: An error occurred (InvalidRequestException) when calling
//    the TestIdentityProvider operation: s-server-ID not configured for external
//    auth
//
//    * If you enter a Server ID for the --server-id parameter that does not
//    identify an actual Transfer server, you receive the following error: An
//    error occurred (ResourceNotFoundException) when calling the TestIdentityProvider
//    operation: Unknown server
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation TestIdentityProvider for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TestIdentityProvider
func (c *Transfer) TestIdentityProvider(input *TestIdentityProviderInput) (*TestIdentityProviderOutput, error) {
	req, out := c.TestIdentityProviderRequest(input)
	return out, req.Send()
}

// TestIdentityProviderWithContext is the same as TestIdentityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See TestIdentityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) TestIdentityProviderWithContext(ctx aws.Context, input *TestIdentityProviderInput, opts ...request.Option) (*TestIdentityProviderOutput, error) {
	req, out := c.TestIdentityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UntagResource
func (c *Transfer) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Transfer Family.
//
// Detaches a key-value pair from a resource, as identified by its Amazon Resource
// Name (ARN). Resources are users, servers, roles, and other entities.
//
// No response is returned from this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UntagResource
func (c *Transfer) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccess = "UpdateAccess"

// UpdateAccessRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccess for more information on using the UpdateAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAccessRequest method.
//    req, resp := client.UpdateAccessRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateAccess
func (c *Transfer) UpdateAccessRequest(input *UpdateAccessInput) (req *request.Request, output *UpdateAccessOutput) {
	op := &request.Operation{
		Name:       opUpdateAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAccessInput{}
	}

	output = &UpdateAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccess API operation for AWS Transfer Family.
//
// Allows you to update parameters for the access specified in the ServerID
// and ExternalID parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation UpdateAccess for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceExistsException
//   The requested resource does not exist.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateAccess
func (c *Transfer) UpdateAccess(input *UpdateAccessInput) (*UpdateAccessOutput, error) {
	req, out := c.UpdateAccessRequest(input)
	return out, req.Send()
}

// UpdateAccessWithContext is the same as UpdateAccess with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) UpdateAccessWithContext(ctx aws.Context, input *UpdateAccessInput, opts ...request.Option) (*UpdateAccessOutput, error) {
	req, out := c.UpdateAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServer = "UpdateServer"

// UpdateServerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServer for more information on using the UpdateServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateServerRequest method.
//    req, resp := client.UpdateServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateServer
func (c *Transfer) UpdateServerRequest(input *UpdateServerInput) (req *request.Request, output *UpdateServerOutput) {
	op := &request.Operation{
		Name:       opUpdateServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServerInput{}
	}

	output = &UpdateServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateServer API operation for AWS Transfer Family.
//
// Updates the file transfer protocol-enabled server's properties after that
// server has been created.
//
// The UpdateServer call returns the ServerId of the server you updated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation UpdateServer for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * ConflictException
//   This exception is thrown when the UpdateServer is called for a file transfer
//   protocol-enabled server that has VPC as the endpoint type and the server's
//   VpcEndpointID is not in the available state.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceExistsException
//   The requested resource does not exist.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateServer
func (c *Transfer) UpdateServer(input *UpdateServerInput) (*UpdateServerOutput, error) {
	req, out := c.UpdateServerRequest(input)
	return out, req.Send()
}

// UpdateServerWithContext is the same as UpdateServer with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) UpdateServerWithContext(ctx aws.Context, input *UpdateServerInput, opts ...request.Option) (*UpdateServerOutput, error) {
	req, out := c.UpdateServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUser = "UpdateUser"

// UpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUser for more information on using the UpdateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserRequest method.
//    req, resp := client.UpdateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateUser
func (c *Transfer) UpdateUserRequest(input *UpdateUserInput) (req *request.Request, output *UpdateUserOutput) {
	op := &request.Operation{
		Name:       opUpdateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserInput{}
	}

	output = &UpdateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUser API operation for AWS Transfer Family.
//
// Assigns new properties to a user. Parameters you pass modify any or all of
// the following: the home directory, role, and policy for the UserName and
// ServerId you specify.
//
// The response returns the ServerId and the UserName for the updated user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer Family's
// API operation UpdateUser for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The request has failed because the Amazon Web ServicesTransfer Family service
//   is not available.
//
//   * InternalServiceError
//   This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
//   Family service.
//
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * ResourceNotFoundException
//   This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
//   Family service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateUser
func (c *Transfer) UpdateUser(input *UpdateUserInput) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	return out, req.Send()
}

// UpdateUserWithContext is the same as UpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) UpdateUserWithContext(ctx aws.Context, input *UpdateUserInput, opts ...request.Option) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the UpdateServer is called for a file transfer
// protocol-enabled server that has VPC as the endpoint type and the server's
// VpcEndpointID is not in the available state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Each step type has its own StepDetails structure.
type CopyStepDetails struct {
	_ struct{} `type:"structure"`

	// Specifies the location for the file being copied. Only applicable for Copy
	// type workflow steps. Use ${Transfer:username} in this field to parametrize
	// the destination prefix by username.
	DestinationFileLocation *InputFileLocation `type:"structure"`

	// The name of the step, used as an identifier.
	Name *string `type:"string"`

	// A flag that indicates whether or not to overwrite an existing file of the
	// same name. The default is FALSE.
	OverwriteExisting *string `type:"string" enum:"OverwriteExisting"`

	// Specifies which file to use as input to the workflow step: either the output
	// from the previous step, or the originally uploaded file for the workflow.
	//
	//    * Enter ${previous.file} to use the previous file as the input. In this
	//    case, this workflow step uses the output file from the previous workflow
	//    step as input. This is the default value.
	//
	//    * Enter ${original.file} to use the originally-uploaded file location
	//    as input for this step.
	SourceFileLocation *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyStepDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyStepDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyStepDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyStepDetails"}
	if s.DestinationFileLocation != nil {
		if err := s.DestinationFileLocation.Validate(); err != nil {
			invalidParams.AddNested("DestinationFileLocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationFileLocation sets the DestinationFileLocation field's value.
func (s *CopyStepDetails) SetDestinationFileLocation(v *InputFileLocation) *CopyStepDetails {
	s.DestinationFileLocation = v
	return s
}

// SetName sets the Name field's value.
func (s *CopyStepDetails) SetName(v string) *CopyStepDetails {
	s.Name = &v
	return s
}

// SetOverwriteExisting sets the OverwriteExisting field's value.
func (s *CopyStepDetails) SetOverwriteExisting(v string) *CopyStepDetails {
	s.OverwriteExisting = &v
	return s
}

// SetSourceFileLocation sets the SourceFileLocation field's value.
func (s *CopyStepDetails) SetSourceFileLocation(v string) *CopyStepDetails {
	s.SourceFileLocation = &v
	return s
}

type CreateAccessInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that is required to identify specific groups within your
	// directory. The users of the group that you associate have access to your
	// Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon
	// Web Services Transfer Family. If you know the group name, you can view the
	// SID values by running the following command using Windows PowerShell.
	//
	// Get-ADGroup -Filter {samAccountName -like "YourGroupName*"} -Properties *
	// | Select SamAccountName,ObjectSid
	//
	// In that command, replace YourGroupName with the name of your Active Directory
	// group.
	//
	// The regex used to validate this parameter is a string of characters consisting
	// of uppercase and lowercase alphanumeric characters with no spaces. You can
	// also include underscores or any of the following characters: =,.@:/-
	//
	// ExternalId is a required field
	ExternalId *string `min:"1" type:"string" required:"true"`

	// The landing directory (folder) for a user when they log in to the server
	// using the client.
	//
	// A HomeDirectory example is /bucket_name/home/mydirectory.
	HomeDirectory *string `type:"string"`

	// Logical directory mappings that specify what Amazon S3 or Amazon EFS paths
	// and keys should be visible to your user and how you want to make them visible.
	// You must specify the Entry and Target pair, where Entry shows how the path
	// is made visible and Target is the actual Amazon S3 or Amazon EFS path. If
	// you only specify a target, it is displayed as is. You also must ensure that
	// your Amazon Web Services Identity and Access Management (IAM) role provides
	// access to paths in Target. This value can only be set when HomeDirectoryType
	// is set to LOGICAL.
	//
	// The following is an Entry and Target pair example.
	//
	// [ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]
	//
	// In most cases, you can use this value instead of the session policy to lock
	// down your user to the designated home directory ("chroot"). To do this, you
	// can set Entry to / and set Target to the HomeDirectory parameter value.
	//
	// The following is an Entry and Target pair example for chroot.
	//
	// [ { "Entry": "/", "Target": "/bucket_name/home/mydirectory" } ]
	HomeDirectoryMappings []*HomeDirectoryMapEntry `min:"1" type:"list"`

	// The type of landing directory (folder) you want your users' home directory
	// to be when they log into the server. If you set it to PATH, the user will
	// see the absolute Amazon S3 bucket or EFS paths as is in their file transfer
	// protocol clients. If you set it LOGICAL, you need to provide mappings in
	// the HomeDirectoryMappings for how you want to make Amazon S3 or EFS paths
	// visible to your users.
	HomeDirectoryType *string `type:"string" enum:"HomeDirectoryType"`

	// A session policy for your user so that you can use the same IAM role across
	// multiple users. This policy scopes down user access to portions of their
	// Amazon S3 bucket. Variables that you can use inside this policy include ${Transfer:UserName},
	// ${Transfer:HomeDirectory}, and ${Transfer:HomeBucket}.
	//
	// This only applies when the domain of ServerId is S3. EFS does not use session
	// policies.
	//
	// For session policies, Amazon Web Services Transfer Family stores the policy
	// as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy.
	// You save the policy as a JSON blob and pass it in the Policy argument.
	//
	// For an example of a session policy, see Example session policy (https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html).
	//
	// For more information, see AssumeRole (https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html)
	// in the Amazon Web Services Security Token Service API Reference.
	Policy *string `type:"string"`

	// The full POSIX identity, including user ID (Uid), group ID (Gid), and any
	// secondary groups IDs (SecondaryGids), that controls your users' access to
	// your Amazon EFS file systems. The POSIX permissions that are set on files
	// and directories in your file system determine the level of access your users
	// get when transferring files into and out of your Amazon EFS file systems.
	PosixProfile *PosixProfile `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the IAM role that controls your
	// users' access to your Amazon S3 bucket or EFS file system. The policies attached
	// to this role determine the level of access that you want to provide your
	// users when transferring files into and out of your Amazon S3 bucket or EFS
	// file system. The IAM role should also contain a trust relationship that allows
	// the server to access your resources when servicing your users' transfer requests.
	//
	// Role is a required field
	Role *string `min:"20" type:"string" required:"true"`

	// A system-assigned unique identifier for a server instance. This is the specific
	// server that you added your user to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccessInput"}
	if s.ExternalId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalId"))
	}
	if s.ExternalId != nil && len(*s.ExternalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalId", 1))
	}
	if s.HomeDirectoryMappings != nil && len(s.HomeDirectoryMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HomeDirectoryMappings", 1))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Role != nil && len(*s.Role) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Role", 20))
	}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}
	if s.HomeDirectoryMappings != nil {
		for i, v := range s.HomeDirectoryMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HomeDirectoryMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PosixProfile != nil {
		if err := s.PosixProfile.Validate(); err != nil {
			invalidParams.AddNested("PosixProfile", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalId sets the ExternalId field's value.
func (s *CreateAccessInput) SetExternalId(v string) *CreateAccessInput {
	s.ExternalId = &v
	return s
}

// SetHomeDirectory sets the HomeDirectory field's value.
func (s *CreateAccessInput) SetHomeDirectory(v string) *CreateAccessInput {
	s.HomeDirectory = &v
	return s
}

// SetHomeDirectoryMappings sets the HomeDirectoryMappings field's value.
func (s *CreateAccessInput) SetHomeDirectoryMappings(v []*HomeDirectoryMapEntry) *CreateAccessInput {
	s.HomeDirectoryMappings = v
	return s
}

// SetHomeDirectoryType sets the HomeDirectoryType field's value.
func (s *CreateAccessInput) SetHomeDirectoryType(v string) *CreateAccessInput {
	s.HomeDirectoryType = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *CreateAccessInput) SetPolicy(v string) *CreateAccessInput {
	s.Policy = &v
	return s
}

// SetPosixProfile sets the PosixProfile field's value.
func (s *CreateAccessInput) SetPosixProfile(v *PosixProfile) *CreateAccessInput {
	s.PosixProfile = v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateAccessInput) SetRole(v string) *CreateAccessInput {
	s.Role = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *CreateAccessInput) SetServerId(v string) *CreateAccessInput {
	s.ServerId = &v
	return s
}

type CreateAccessOutput struct {
	_ struct{} `type:"structure"`

	// The external ID of the group whose users have access to your Amazon S3 or
	// Amazon EFS resources over the enabled protocols using Amazon Web Services
	// Transfer Family.
	//
	// ExternalId is a required field
	ExternalId *string `min:"1" type:"string" required:"true"`

	// The ID of the server that the user is attached to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessOutput) GoString() string {
	return s.String()
}

// SetExternalId sets the ExternalId field's value.
func (s *CreateAccessOutput) SetExternalId(v string) *CreateAccessOutput {
	s.ExternalId = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *CreateAccessOutput) SetServerId(v string) *CreateAccessOutput {
	s.ServerId = &v
	return s
}

type CreateServerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services Certificate Manager
	// (ACM) certificate. Required when Protocols is set to FTPS.
	//
	// To request a new public certificate, see Request a public certificate (https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html)
	// in the Amazon Web Services Certificate Manager User Guide.
	//
	// To import an existing certificate into ACM, see Importing certificates into
	// ACM (https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html)
	// in the Amazon Web Services Certificate Manager User Guide.
	//
	// To request a private certificate to use FTPS through private IP addresses,
	// see Request a private certificate (https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html)
	// in the Amazon Web Services Certificate Manager User Guide.
	//
	// Certificates with the following cryptographic algorithms and key sizes are
	// supported:
	//
	//    * 2048-bit RSA (RSA_2048)
	//
	//    * 4096-bit RSA (RSA_4096)
	//
	//    * Elliptic Prime Curve 256 bit (EC_prime256v1)
	//
	//    * Elliptic Prime Curve 384 bit (EC_secp384r1)
	//
	//    * Elliptic Prime Curve 521 bit (EC_secp521r1)
	//
	// The certificate must be a valid SSL/TLS X.509 version 3 certificate with
	// FQDN or IP address specified and information about the issuer.
	Certificate *string `type:"string"`

	// The domain of the storage system that is used for file transfers. There are
	// two domains available: Amazon Simple Storage Service (Amazon S3) and Amazon
	// Elastic File System (Amazon EFS). The default value is S3.
	//
	// After the server is created, the domain cannot be changed.
	Domain *string `type:"string" enum:"Domain"`

	// The virtual private cloud (VPC) endpoint settings that are configured for
	// your server. When you host your endpoint within your VPC, you can make it
	// accessible only to resources within your VPC, or you can attach Elastic IP
	// addresses and make it accessible to clients over the internet. Your VPC's
	// default security groups are automatically assigned to your endpoint.
	EndpointDetails *EndpointDetails `type:"structure"`

	// The type of endpoint that you want your server to use. You can choose to
	// make your server's endpoint publicly accessible (PUBLIC) or host it inside
	// your VPC. With an endpoint that is hosted in a VPC, you can restrict access
	// to your server and resources only within your VPC or choose to make it internet
	// facing by attaching Elastic IP addresses directly to it.
	//
	// After May 19, 2021, you won't be able to create a server using EndpointType=VPC_ENDPOINT
	// in your Amazon Web Services account if your account hasn't already done so
	// before May 19, 2021. If you have already created servers with EndpointType=VPC_ENDPOINT
	// in your Amazon Web Services account on or before May 19, 2021, you will not
	// be affected. After this date, use EndpointType=VPC.
	//
	// For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.
	//
	// It is recommended that you use VPC as the EndpointType. With this endpoint
	// type, you have the option to directly associate up to three Elastic IPv4
	// addresses (BYO IP included) with your server's endpoint and use VPC security
	// groups to restrict traffic by the client's public IP address. This is not
	// possible with EndpointType set to VPC_ENDPOINT.
	EndpointType *string `type:"string" enum:"EndpointType"`

	// The RSA private key as generated by the ssh-keygen -N "" -m PEM -f my-new-server-key
	// command.
	//
	// If you aren't planning to migrate existing users from an existing SFTP-enabled
	// server to a new server, don't update the host key. Accidentally changing
	// a server's host key can be disruptive.
	//
	// For more information, see Change the host key for your SFTP-enabled server
	// (https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key)
	// in the Amazon Web Services Transfer Family User Guide.
	//
	// HostKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateServerInput's
	// String and GoString methods.
	HostKey *string `type:"string" sensitive:"true"`

	// Required when IdentityProviderType is set to AWS_DIRECTORY_SERVICE or API_GATEWAY.
	// Accepts an array containing all of the information required to use a directory
	// in AWS_DIRECTORY_SERVICE or invoke a customer-supplied authentication API,
	// including the API Gateway URL. Not required when IdentityProviderType is
	// set to SERVICE_MANAGED.
	IdentityProviderDetails *IdentityProviderDetails `type:"structure"`

	// Specifies the mode of authentication for a server. The default value is SERVICE_MANAGED,
	// which allows you to store and access user credentials within the Amazon Web
	// Services Transfer Family service.
	//
	// Use AWS_DIRECTORY_SERVICE to provide access to Active Directory groups in
	// Amazon Web Services Managed Active Directory or Microsoft Active Directory
	// in your on-premises environment or in Amazon Web Services using AD Connectors.
	// This option also requires you to provide a Directory ID using the IdentityProviderDetails
	// parameter.
	//
	// Use the API_GATEWAY value to integrate with an identity provider of your
	// choosing. The API_GATEWAY setting requires you to provide an API Gateway
	// endpoint URL to call for authentication using the IdentityProviderDetails
	// parameter.
	//
	// Use the AWS_LAMBDA value to directly use a Lambda function as your identity
	// provider. If you choose this value, you must specify the ARN for the lambda
	// function in the Function parameter for the IdentityProviderDetails data type.
	IdentityProviderType *string `type:"string" enum:"IdentityProviderType"`

	// Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity
	// and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch
	// logging for Amazon S3 or Amazon EFS events. When set, user activity can be
	// viewed in your CloudWatch logs.
	LoggingRole *string `min:"20" type:"string"`

	// Specify a string to display when users connect to a server. This string is
	// displayed after the user authenticates.
	//
	// The SFTP protocol does not support post-authentication display banners.
	PostAuthenticationLoginBanner *string `type:"string"`

	// Specify a string to display when users connect to a server. This string is
	// displayed before the user authenticates. For example, the following banner
	// displays details about using the system.
	//
	// This system is for the use of authorized users only. Individuals using this
	// computer system without authority, or in excess of their authority, are subject
	// to having all of their activities on this system monitored and recorded by
	// system personnel.
	PreAuthenticationLoginBanner *string `type:"string"`

	// The protocol settings that are configured for your server.
	//
	//    * Use the PassiveIp parameter to indicate passive mode (for FTP and FTPS
	//    protocols). Enter a single dotted-quad IPv4 address, such as the external
	//    IP address of a firewall, router, or load balancer.
	//
	//    * Use the SetStatOption to ignore the error that is generated when the
	//    client attempts to use SETSTAT on a file you are uploading to an S3 bucket.
	//    Set the value to ENABLE_NO_OP to have the Transfer Family server ignore
	//    the SETSTAT command, and upload files without needing to make any changes
	//    to your SFTP client. Note that with SetStatOption set to ENABLE_NO_OP,
	//    Transfer generates a log entry to CloudWatch Logs, so you can determine
	//    when the client is making a SETSTAT call.
	//
	//    * Use the TlsSessionResumptionMode parameter to determine whether or not
	//    your Transfer server resumes recent, negotiated sessions through a unique
	//    session ID.
	ProtocolDetails *ProtocolDetails `type:"structure"`

	// Specifies the file transfer protocol or protocols over which your file transfer
	// protocol client can connect to your server's endpoint. The available protocols
	// are:
	//
	//    * SFTP (Secure Shell (SSH) File Transfer Protocol): File transfer over
	//    SSH
	//
	//    * FTPS (File Transfer Protocol Secure): File transfer with TLS encryption
	//
	//    * FTP (File Transfer Protocol): Unencrypted file transfer
	//
	// If you select FTPS, you must choose a certificate stored in Amazon Web Services
	// Certificate Manager (ACM) which is used to identify your server when clients
	// connect to it over FTPS.
	//
	// If Protocol includes either FTP or FTPS, then the EndpointType must be VPC
	// and the IdentityProviderType must be AWS_DIRECTORY_SERVICE or API_GATEWAY.
	//
	// If Protocol includes FTP, then AddressAllocationIds cannot be associated.
	//
	// If Protocol is set only to SFTP, the EndpointType can be set to PUBLIC and
	// the IdentityProviderType can be set to SERVICE_MANAGED.
	Protocols []*string `min:"1" type:"list" enum:"Protocol"`

	// Specifies the name of the security policy that is attached to the server.
	SecurityPolicyName *string `type:"string"`

	// Key-value pairs that can be used to group and search for servers.
	Tags []*Tag `min:"1" type:"list"`

	// Specifies the workflow ID for the workflow to assign and the execution role
	// used for executing the workflow.
	WorkflowDetails *WorkflowDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServerInput"}
	if s.LoggingRole != nil && len(*s.LoggingRole) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("LoggingRole", 20))
	}
	if s.Protocols != nil && len(s.Protocols) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Protocols", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.EndpointDetails != nil {
		if err := s.EndpointDetails.Validate(); err != nil {
			invalidParams.AddNested("EndpointDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.IdentityProviderDetails != nil {
		if err := s.IdentityProviderDetails.Validate(); err != nil {
			invalidParams.AddNested("IdentityProviderDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.WorkflowDetails != nil {
		if err := s.WorkflowDetails.Validate(); err != nil {
			invalidParams.AddNested("WorkflowDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificate sets the Certificate field's value.
func (s *CreateServerInput) SetCertificate(v string) *CreateServerInput {
	s.Certificate = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CreateServerInput) SetDomain(v string) *CreateServerInput {
	s.Domain = &v
	return s
}

// SetEndpointDetails sets the EndpointDetails field's value.
func (s *CreateServerInput) SetEndpointDetails(v *EndpointDetails) *CreateServerInput {
	s.EndpointDetails = v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *CreateServerInput) SetEndpointType(v string) *CreateServerInput {
	s.EndpointType = &v
	return s
}

// SetHostKey sets the HostKey field's value.
func (s *CreateServerInput) SetHostKey(v string) *CreateServerInput {
	s.HostKey = &v
	return s
}

// SetIdentityProviderDetails sets the IdentityProviderDetails field's value.
func (s *CreateServerInput) SetIdentityProviderDetails(v *IdentityProviderDetails) *CreateServerInput {
	s.IdentityProviderDetails = v
	return s
}

// SetIdentityProviderType sets the IdentityProviderType field's value.
func (s *CreateServerInput) SetIdentityProviderType(v string) *CreateServerInput {
	s.IdentityProviderType = &v
	return s
}

// SetLoggingRole sets the LoggingRole field's value.
func (s *CreateServerInput) SetLoggingRole(v string) *CreateServerInput {
	s.LoggingRole = &v
	return s
}

// SetPostAuthenticationLoginBanner sets the PostAuthenticationLoginBanner field's value.
func (s *CreateServerInput) SetPostAuthenticationLoginBanner(v string) *CreateServerInput {
	s.PostAuthenticationLoginBanner = &v
	return s
}

// SetPreAuthenticationLoginBanner sets the PreAuthenticationLoginBanner field's value.
func (s *CreateServerInput) SetPreAuthenticationLoginBanner(v string) *CreateServerInput {
	s.PreAuthenticationLoginBanner = &v
	return s
}

// SetProtocolDetails sets the ProtocolDetails field's value.
func (s *CreateServerInput) SetProtocolDetails(v *ProtocolDetails) *CreateServerInput {
	s.ProtocolDetails = v
	return s
}

// SetProtocols sets the Protocols field's value.
func (s *CreateServerInput) SetProtocols(v []*string) *CreateServerInput {
	s.Protocols = v
	return s
}

// SetSecurityPolicyName sets the SecurityPolicyName field's value.
func (s *CreateServerInput) SetSecurityPolicyName(v string) *CreateServerInput {
	s.SecurityPolicyName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateServerInput) SetTags(v []*Tag) *CreateServerInput {
	s.Tags = v
	return s
}

// SetWorkflowDetails sets the WorkflowDetails field's value.
func (s *CreateServerInput) SetWorkflowDetails(v *WorkflowDetails) *CreateServerInput {
	s.WorkflowDetails = v
	return s
}

type CreateServerOutput struct {
	_ struct{} `type:"structure"`

	// The service-assigned ID of the server that is created.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServerOutput) GoString() string {
	return s.String()
}

// SetServerId sets the ServerId field's value.
func (s *CreateServerOutput) SetServerId(v string) *CreateServerOutput {
	s.ServerId = &v
	return s
}

type CreateUserInput struct {
	_ struct{} `type:"structure"`

	// The landing directory (folder) for a user when they log in to the server
	// using the client.
	//
	// A HomeDirectory example is /bucket_name/home/mydirectory.
	HomeDirectory *string `type:"string"`

	// Logical directory mappings that specify what Amazon S3 or Amazon EFS paths
	// and keys should be visible to your user and how you want to make them visible.
	// You must specify the Entry and Target pair, where Entry shows how the path
	// is made visible and Target is the actual Amazon S3 or Amazon EFS path. If
	// you only specify a target, it is displayed as is. You also must ensure that
	// your Amazon Web Services Identity and Access Management (IAM) role provides
	// access to paths in Target. This value can only be set when HomeDirectoryType
	// is set to LOGICAL.
	//
	// The following is an Entry and Target pair example.
	//
	// [ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]
	//
	// In most cases, you can use this value instead of the session policy to lock
	// your user down to the designated home directory ("chroot"). To do this, you
	// can set Entry to / and set Target to the HomeDirectory parameter value.
	//
	// The following is an Entry and Target pair example for chroot.
	//
	// [ { "Entry": "/", "Target": "/bucket_name/home/mydirectory" } ]
	HomeDirectoryMappings []*HomeDirectoryMapEntry `min:"1" type:"list"`

	// The type of landing directory (folder) you want your users' home directory
	// to be when they log into the server. If you set it to PATH, the user will
	// see the absolute Amazon S3 bucket or EFS paths as is in their file transfer
	// protocol clients. If you set it LOGICAL, you need to provide mappings in
	// the HomeDirectoryMappings for how you want to make Amazon S3 or EFS paths
	// visible to your users.
	HomeDirectoryType *string `type:"string" enum:"HomeDirectoryType"`

	// A session policy for your user so that you can use the same IAM role across
	// multiple users. This policy scopes down user access to portions of their
	// Amazon S3 bucket. Variables that you can use inside this policy include ${Transfer:UserName},
	// ${Transfer:HomeDirectory}, and ${Transfer:HomeBucket}.
	//
	// This only applies when the domain of ServerId is S3. EFS does not use session
	// policies.
	//
	// For session policies, Amazon Web Services Transfer Family stores the policy
	// as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy.
	// You save the policy as a JSON blob and pass it in the Policy argument.
	//
	// For an example of a session policy, see Example session policy (https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html).
	//
	// For more information, see AssumeRole (https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html)
	// in the Amazon Web Services Security Token Service API Reference.
	Policy *string `type:"string"`

	// Specifies the full POSIX identity, including user ID (Uid), group ID (Gid),
	// and any secondary groups IDs (SecondaryGids), that controls your users' access
	// to your Amazon EFS file systems. The POSIX permissions that are set on files
	// and directories in Amazon EFS determine the level of access your users get
	// when transferring files into and out of your Amazon EFS file systems.
	PosixProfile *PosixProfile `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the IAM role that controls your
	// users' access to your Amazon S3 bucket or EFS file system. The policies attached
	// to this role determine the level of access that you want to provide your
	// users when transferring files into and out of your Amazon S3 bucket or EFS
	// file system. The IAM role should also contain a trust relationship that allows
	// the server to access your resources when servicing your users' transfer requests.
	//
	// Role is a required field
	Role *string `min:"20" type:"string" required:"true"`

	// A system-assigned unique identifier for a server instance. This is the specific
	// server that you added your user to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// The public portion of the Secure Shell (SSH) key used to authenticate the
	// user to the server.
	//
	// Currently, Transfer Family does not accept elliptical curve keys (keys beginning
	// with ecdsa).
	SshPublicKeyBody *string `type:"string"`

	// Key-value pairs that can be used to group and search for users. Tags are
	// metadata attached to users for any purpose.
	Tags []*Tag `min:"1" type:"list"`

	// A unique string that identifies a user and is associated with a ServerId.
	// This user name must be a minimum of 3 and a maximum of 100 characters long.
	// The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen
	// '-', period '.', and at sign '@'. The user name can't start with a hyphen,
	// period, or at sign.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserInput"}
	if s.HomeDirectoryMappings != nil && len(s.HomeDirectoryMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HomeDirectoryMappings", 1))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Role != nil && len(*s.Role) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Role", 20))
	}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 3))
	}
	if s.HomeDirectoryMappings != nil {
		for i, v := range s.HomeDirectoryMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HomeDirectoryMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PosixProfile != nil {
		if err := s.PosixProfile.Validate(); err != nil {
			invalidParams.AddNested("PosixProfile", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHomeDirectory sets the HomeDirectory field's value.
func (s *CreateUserInput) SetHomeDirectory(v string) *CreateUserInput {
	s.HomeDirectory = &v
	return s
}

// SetHomeDirectoryMappings sets the HomeDirectoryMappings field's value.
func (s *CreateUserInput) SetHomeDirectoryMappings(v []*HomeDirectoryMapEntry) *CreateUserInput {
	s.HomeDirectoryMappings = v
	return s
}

// SetHomeDirectoryType sets the HomeDirectoryType field's value.
func (s *CreateUserInput) SetHomeDirectoryType(v string) *CreateUserInput {
	s.HomeDirectoryType = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *CreateUserInput) SetPolicy(v string) *CreateUserInput {
	s.Policy = &v
	return s
}

// SetPosixProfile sets the PosixProfile field's value.
func (s *CreateUserInput) SetPosixProfile(v *PosixProfile) *CreateUserInput {
	s.PosixProfile = v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateUserInput) SetRole(v string) *CreateUserInput {
	s.Role = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *CreateUserInput) SetServerId(v string) *CreateUserInput {
	s.ServerId = &v
	return s
}

// SetSshPublicKeyBody sets the SshPublicKeyBody field's value.
func (s *CreateUserInput) SetSshPublicKeyBody(v string) *CreateUserInput {
	s.SshPublicKeyBody = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateUserInput) SetTags(v []*Tag) *CreateUserInput {
	s.Tags = v
	return s
}

// SetUserName sets the UserName field's value.
func (s *CreateUserInput) SetUserName(v string) *CreateUserInput {
	s.UserName = &v
	return s
}

type CreateUserOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the server that the user is attached to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// A unique string that identifies a user account associated with a server.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserOutput) GoString() string {
	return s.String()
}

// SetServerId sets the ServerId field's value.
func (s *CreateUserOutput) SetServerId(v string) *CreateUserOutput {
	s.ServerId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *CreateUserOutput) SetUserName(v string) *CreateUserOutput {
	s.UserName = &v
	return s
}

type CreateWorkflowInput struct {
	_ struct{} `type:"structure"`

	// A textual description for the workflow.
	Description *string `type:"string"`

	// Specifies the steps (actions) to take if errors are encountered during execution
	// of the workflow.
	//
	// For custom steps, the lambda function needs to send FAILURE to the call back
	// API to kick off the exception steps. Additionally, if the lambda does not
	// send SUCCESS before it times out, the exception steps are executed.
	OnExceptionSteps []*WorkflowStep `type:"list"`

	// Specifies the details for the steps that are in the specified workflow.
	//
	// The TYPE specifies which of the following actions is being taken for this
	// step.
	//
	//    * COPY: copy the file to another location
	//
	//    * CUSTOM: custom step with a lambda target
	//
	//    * DELETE: delete the file
	//
	//    * TAG: add a tag to the file
	//
	// Currently, copying and tagging are supported only on S3.
	//
	// For file location, you specify either the S3 bucket and key, or the EFS filesystem
	// ID and path.
	//
	// Steps is a required field
	Steps []*WorkflowStep `type:"list" required:"true"`

	// Key-value pairs that can be used to group and search for workflows. Tags
	// are metadata attached to workflows for any purpose.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkflowInput"}
	if s.Steps == nil {
		invalidParams.Add(request.NewErrParamRequired("Steps"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.OnExceptionSteps != nil {
		for i, v := range s.OnExceptionSteps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OnExceptionSteps", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Steps != nil {
		for i, v := range s.Steps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Steps", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateWorkflowInput) SetDescription(v string) *CreateWorkflowInput {
	s.Description = &v
	return s
}

// SetOnExceptionSteps sets the OnExceptionSteps field's value.
func (s *CreateWorkflowInput) SetOnExceptionSteps(v []*WorkflowStep) *CreateWorkflowInput {
	s.OnExceptionSteps = v
	return s
}

// SetSteps sets the Steps field's value.
func (s *CreateWorkflowInput) SetSteps(v []*WorkflowStep) *CreateWorkflowInput {
	s.Steps = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkflowInput) SetTags(v []*Tag) *CreateWorkflowInput {
	s.Tags = v
	return s
}

type CreateWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowOutput) GoString() string {
	return s.String()
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *CreateWorkflowOutput) SetWorkflowId(v string) *CreateWorkflowOutput {
	s.WorkflowId = &v
	return s
}

// Each step type has its own StepDetails structure.
type CustomStepDetails struct {
	_ struct{} `type:"structure"`

	// The name of the step, used as an identifier.
	Name *string `type:"string"`

	// Specifies which file to use as input to the workflow step: either the output
	// from the previous step, or the originally uploaded file for the workflow.
	//
	//    * Enter ${previous.file} to use the previous file as the input. In this
	//    case, this workflow step uses the output file from the previous workflow
	//    step as input. This is the default value.
	//
	//    * Enter ${original.file} to use the originally-uploaded file location
	//    as input for this step.
	SourceFileLocation *string `type:"string"`

	// The ARN for the lambda function that is being called.
	Target *string `type:"string"`

	// Timeout, in seconds, for the step.
	TimeoutSeconds *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomStepDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomStepDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomStepDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomStepDetails"}
	if s.TimeoutSeconds != nil && *s.TimeoutSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutSeconds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CustomStepDetails) SetName(v string) *CustomStepDetails {
	s.Name = &v
	return s
}

// SetSourceFileLocation sets the SourceFileLocation field's value.
func (s *CustomStepDetails) SetSourceFileLocation(v string) *CustomStepDetails {
	s.SourceFileLocation = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *CustomStepDetails) SetTarget(v string) *CustomStepDetails {
	s.Target = &v
	return s
}

// SetTimeoutSeconds sets the TimeoutSeconds field's value.
func (s *CustomStepDetails) SetTimeoutSeconds(v int64) *CustomStepDetails {
	s.TimeoutSeconds = &v
	return s
}

type DeleteAccessInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that is required to identify specific groups within your
	// directory. The users of the group that you associate have access to your
	// Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon
	// Web Services Transfer Family. If you know the group name, you can view the
	// SID values by running the following command using Windows PowerShell.
	//
	// Get-ADGroup -Filter {samAccountName -like "YourGroupName*"} -Properties *
	// | Select SamAccountName,ObjectSid
	//
	// In that command, replace YourGroupName with the name of your Active Directory
	// group.
	//
	// The regex used to validate this parameter is a string of characters consisting
	// of uppercase and lowercase alphanumeric characters with no spaces. You can
	// also include underscores or any of the following characters: =,.@:/-
	//
	// ExternalId is a required field
	ExternalId *string `min:"1" type:"string" required:"true"`

	// A system-assigned unique identifier for a server that has this user assigned.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessInput"}
	if s.ExternalId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalId"))
	}
	if s.ExternalId != nil && len(*s.ExternalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalId", 1))
	}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalId sets the ExternalId field's value.
func (s *DeleteAccessInput) SetExternalId(v string) *DeleteAccessInput {
	s.ExternalId = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *DeleteAccessInput) SetServerId(v string) *DeleteAccessInput {
	s.ServerId = &v
	return s
}

type DeleteAccessOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessOutput) GoString() string {
	return s.String()
}

type DeleteServerInput struct {
	_ struct{} `type:"structure"`

	// A unique system-assigned identifier for a server instance.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServerInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *DeleteServerInput) SetServerId(v string) *DeleteServerInput {
	s.ServerId = &v
	return s
}

type DeleteServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServerOutput) GoString() string {
	return s.String()
}

type DeleteSshPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a file transfer protocol-enabled
	// server instance that has the user assigned to it.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// A unique identifier used to reference your user's specific SSH key.
	//
	// SshPublicKeyId is a required field
	SshPublicKeyId *string `min:"21" type:"string" required:"true"`

	// A unique string that identifies a user whose public key is being deleted.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSshPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSshPublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSshPublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSshPublicKeyInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}
	if s.SshPublicKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("SshPublicKeyId"))
	}
	if s.SshPublicKeyId != nil && len(*s.SshPublicKeyId) < 21 {
		invalidParams.Add(request.NewErrParamMinLen("SshPublicKeyId", 21))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *DeleteSshPublicKeyInput) SetServerId(v string) *DeleteSshPublicKeyInput {
	s.ServerId = &v
	return s
}

// SetSshPublicKeyId sets the SshPublicKeyId field's value.
func (s *DeleteSshPublicKeyInput) SetSshPublicKeyId(v string) *DeleteSshPublicKeyInput {
	s.SshPublicKeyId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DeleteSshPublicKeyInput) SetUserName(v string) *DeleteSshPublicKeyInput {
	s.UserName = &v
	return s
}

type DeleteSshPublicKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSshPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSshPublicKeyOutput) GoString() string {
	return s.String()
}

// The name of the step, used to identify the delete step.
type DeleteStepDetails struct {
	_ struct{} `type:"structure"`

	// The name of the step, used as an identifier.
	Name *string `type:"string"`

	// Specifies which file to use as input to the workflow step: either the output
	// from the previous step, or the originally uploaded file for the workflow.
	//
	//    * Enter ${previous.file} to use the previous file as the input. In this
	//    case, this workflow step uses the output file from the previous workflow
	//    step as input. This is the default value.
	//
	//    * Enter ${original.file} to use the originally-uploaded file location
	//    as input for this step.
	SourceFileLocation *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStepDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStepDetails) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DeleteStepDetails) SetName(v string) *DeleteStepDetails {
	s.Name = &v
	return s
}

// SetSourceFileLocation sets the SourceFileLocation field's value.
func (s *DeleteStepDetails) SetSourceFileLocation(v string) *DeleteStepDetails {
	s.SourceFileLocation = &v
	return s
}

type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a server instance that has the user
	// assigned to it.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// A unique string that identifies a user that is being deleted from a server.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *DeleteUserInput) SetServerId(v string) *DeleteUserInput {
	s.ServerId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DeleteUserInput) SetUserName(v string) *DeleteUserInput {
	s.UserName = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

type DeleteWorkflowInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkflowInput"}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *DeleteWorkflowInput) SetWorkflowId(v string) *DeleteWorkflowInput {
	s.WorkflowId = &v
	return s
}

type DeleteWorkflowOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowOutput) GoString() string {
	return s.String()
}

type DescribeAccessInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that is required to identify specific groups within your
	// directory. The users of the group that you associate have access to your
	// Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon
	// Web Services Transfer Family. If you know the group name, you can view the
	// SID values by running the following command using Windows PowerShell.
	//
	// Get-ADGroup -Filter {samAccountName -like "YourGroupName*"} -Properties *
	// | Select SamAccountName,ObjectSid
	//
	// In that command, replace YourGroupName with the name of your Active Directory
	// group.
	//
	// The regex used to validate this parameter is a string of characters consisting
	// of uppercase and lowercase alphanumeric characters with no spaces. You can
	// also include underscores or any of the following characters: =,.@:/-
	//
	// ExternalId is a required field
	ExternalId *string `min:"1" type:"string" required:"true"`

	// A system-assigned unique identifier for a server that has this access assigned.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccessInput"}
	if s.ExternalId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalId"))
	}
	if s.ExternalId != nil && len(*s.ExternalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalId", 1))
	}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalId sets the ExternalId field's value.
func (s *DescribeAccessInput) SetExternalId(v string) *DescribeAccessInput {
	s.ExternalId = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *DescribeAccessInput) SetServerId(v string) *DescribeAccessInput {
	s.ServerId = &v
	return s
}

type DescribeAccessOutput struct {
	_ struct{} `type:"structure"`

	// The external ID of the server that the access is attached to.
	//
	// Access is a required field
	Access *DescribedAccess `type:"structure" required:"true"`

	// A system-assigned unique identifier for a server that has this access assigned.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccessOutput) GoString() string {
	return s.String()
}

// SetAccess sets the Access field's value.
func (s *DescribeAccessOutput) SetAccess(v *DescribedAccess) *DescribeAccessOutput {
	s.Access = v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *DescribeAccessOutput) SetServerId(v string) *DescribeAccessOutput {
	s.ServerId = &v
	return s
}

type DescribeExecutionInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the execution of a workflow.
	//
	// ExecutionId is a required field
	ExecutionId *string `min:"36" type:"string" required:"true"`

	// A unique identifier for the workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeExecutionInput"}
	if s.ExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionId"))
	}
	if s.ExecutionId != nil && len(*s.ExecutionId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionId", 36))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExecutionId sets the ExecutionId field's value.
func (s *DescribeExecutionInput) SetExecutionId(v string) *DescribeExecutionInput {
	s.ExecutionId = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *DescribeExecutionInput) SetWorkflowId(v string) *DescribeExecutionInput {
	s.WorkflowId = &v
	return s
}

type DescribeExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The structure that contains the details of the workflow' execution.
	//
	// Execution is a required field
	Execution *DescribedExecution `type:"structure" required:"true"`

	// A unique identifier for the workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExecutionOutput) GoString() string {
	return s.String()
}

// SetExecution sets the Execution field's value.
func (s *DescribeExecutionOutput) SetExecution(v *DescribedExecution) *DescribeExecutionOutput {
	s.Execution = v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *DescribeExecutionOutput) SetWorkflowId(v string) *DescribeExecutionOutput {
	s.WorkflowId = &v
	return s
}

type DescribeSecurityPolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the security policy that is attached to the server.
	//
	// SecurityPolicyName is a required field
	SecurityPolicyName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSecurityPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSecurityPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSecurityPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSecurityPolicyInput"}
	if s.SecurityPolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityPolicyName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityPolicyName sets the SecurityPolicyName field's value.
func (s *DescribeSecurityPolicyInput) SetSecurityPolicyName(v string) *DescribeSecurityPolicyInput {
	s.SecurityPolicyName = &v
	return s
}

type DescribeSecurityPolicyOutput struct {
	_ struct{} `type:"structure"`

	// An array containing the properties of the security policy.
	//
	// SecurityPolicy is a required field
	SecurityPolicy *DescribedSecurityPolicy `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSecurityPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSecurityPolicyOutput) GoString() string {
	return s.String()
}

// SetSecurityPolicy sets the SecurityPolicy field's value.
func (s *DescribeSecurityPolicyOutput) SetSecurityPolicy(v *DescribedSecurityPolicy) *DescribeSecurityPolicyOutput {
	s.SecurityPolicy = v
	return s
}

type DescribeServerInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a server.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeServerInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *DescribeServerInput) SetServerId(v string) *DescribeServerInput {
	s.ServerId = &v
	return s
}

type DescribeServerOutput struct {
	_ struct{} `type:"structure"`

	// An array containing the properties of a server with the ServerID you specified.
	//
	// Server is a required field
	Server *DescribedServer `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServerOutput) GoString() string {
	return s.String()
}

// SetServer sets the Server field's value.
func (s *DescribeServerOutput) SetServer(v *DescribedServer) *DescribeServerOutput {
	s.Server = v
	return s
}

type DescribeUserInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a server that has this user assigned.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// The name of the user assigned to one or more servers. User names are part
	// of the sign-in credentials to use the Amazon Web Services Transfer Family
	// service and perform file transfer tasks.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *DescribeUserInput) SetServerId(v string) *DescribeUserInput {
	s.ServerId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DescribeUserInput) SetUserName(v string) *DescribeUserInput {
	s.UserName = &v
	return s
}

type DescribeUserOutput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a server that has this user assigned.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// An array containing the properties of the user account for the ServerID value
	// that you specified.
	//
	// User is a required field
	User *DescribedUser `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserOutput) GoString() string {
	return s.String()
}

// SetServerId sets the ServerId field's value.
func (s *DescribeUserOutput) SetServerId(v string) *DescribeUserOutput {
	s.ServerId = &v
	return s
}

// SetUser sets the User field's value.
func (s *DescribeUserOutput) SetUser(v *DescribedUser) *DescribeUserOutput {
	s.User = v
	return s
}

type DescribeWorkflowInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkflowInput"}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *DescribeWorkflowInput) SetWorkflowId(v string) *DescribeWorkflowInput {
	s.WorkflowId = &v
	return s
}

type DescribeWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// The structure that contains the details of the workflow.
	//
	// Workflow is a required field
	Workflow *DescribedWorkflow `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkflowOutput) GoString() string {
	return s.String()
}

// SetWorkflow sets the Workflow field's value.
func (s *DescribeWorkflowOutput) SetWorkflow(v *DescribedWorkflow) *DescribeWorkflowOutput {
	s.Workflow = v
	return s
}

// Describes the properties of the access that was specified.
type DescribedAccess struct {
	_ struct{} `type:"structure"`

	// A unique identifier that is required to identify specific groups within your
	// directory. The users of the group that you associate have access to your
	// Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon
	// Web Services Transfer Family. If you know the group name, you can view the
	// SID values by running the following command using Windows PowerShell.
	//
	// Get-ADGroup -Filter {samAccountName -like "YourGroupName*"} -Properties *
	// | Select SamAccountName,ObjectSid
	//
	// In that command, replace YourGroupName with the name of your Active Directory
	// group.
	//
	// The regex used to validate this parameter is a string of characters consisting
	// of uppercase and lowercase alphanumeric characters with no spaces. You can
	// also include underscores or any of the following characters: =,.@:/-
	ExternalId *string `min:"1" type:"string"`

	// The landing directory (folder) for a user when they log in to the server
	// using the client.
	//
	// A HomeDirectory example is /bucket_name/home/mydirectory.
	HomeDirectory *string `type:"string"`

	// Logical directory mappings that specify what Amazon S3 or Amazon EFS paths
	// and keys should be visible to your user and how you want to make them visible.
	// You must specify the Entry and Target pair, where Entry shows how the path
	// is made visible and Target is the actual Amazon S3 or Amazon EFS path. If
	// you only specify a target, it is displayed as is. You also must ensure that
	// your Amazon Web Services Identity and Access Management (IAM) role provides
	// access to paths in Target. This value can only be set when HomeDirectoryType
	// is set to LOGICAL.
	//
	// In most cases, you can use this value instead of the session policy to lock
	// down the associated access to the designated home directory ("chroot"). To
	// do this, you can set Entry to '/' and set Target to the HomeDirectory parameter
	// value.
	HomeDirectoryMappings []*HomeDirectoryMapEntry `min:"1" type:"list"`

	// The type of landing directory (folder) you want your users' home directory
	// to be when they log into the server. If you set it to PATH, the user will
	// see the absolute Amazon S3 bucket or EFS paths as is in their file transfer
	// protocol clients. If you set it LOGICAL, you need to provide mappings in
	// the HomeDirectoryMappings for how you want to make Amazon S3 or EFS paths
	// visible to your users.
	HomeDirectoryType *string `type:"string" enum:"HomeDirectoryType"`

	// A session policy for your user so that you can use the same IAM role across
	// multiple users. This policy scopes down user access to portions of their
	// Amazon S3 bucket. Variables that you can use inside this policy include ${Transfer:UserName},
	// ${Transfer:HomeDirectory}, and ${Transfer:HomeBucket}.
	Policy *string `type:"string"`

	// The full POSIX identity, including user ID (Uid), group ID (Gid), and any
	// secondary groups IDs (SecondaryGids), that controls your users' access to
	// your Amazon EFS file systems. The POSIX permissions that are set on files
	// and directories in your file system determine the level of access your users
	// get when transferring files into and out of your Amazon EFS file systems.
	PosixProfile *PosixProfile `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the IAM role that controls your
	// users' access to your Amazon S3 bucket or EFS file system. The policies attached
	// to this role determine the level of access that you want to provide your
	// users when transferring files into and out of your Amazon S3 bucket or EFS
	// file system. The IAM role should also contain a trust relationship that allows
	// the server to access your resources when servicing your users' transfer requests.
	Role *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribedAccess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribedAccess) GoString() string {
	return s.String()
}

// SetExternalId sets the ExternalId field's value.
func (s *DescribedAccess) SetExternalId(v string) *DescribedAccess {
	s.ExternalId = &v
	return s
}

// SetHomeDirectory sets the HomeDirectory field's value.
func (s *DescribedAccess) SetHomeDirectory(v string) *DescribedAccess {
	s.HomeDirectory = &v
	return s
}

// SetHomeDirectoryMappings sets the HomeDirectoryMappings field's value.
func (s *DescribedAccess) SetHomeDirectoryMappings(v []*HomeDirectoryMapEntry) *DescribedAccess {
	s.HomeDirectoryMappings = v
	return s
}

// SetHomeDirectoryType sets the HomeDirectoryType field's value.
func (s *DescribedAccess) SetHomeDirectoryType(v string) *DescribedAccess {
	s.HomeDirectoryType = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *DescribedAccess) SetPolicy(v string) *DescribedAccess {
	s.Policy = &v
	return s
}

// SetPosixProfile sets the PosixProfile field's value.
func (s *DescribedAccess) SetPosixProfile(v *PosixProfile) *DescribedAccess {
	s.PosixProfile = v
	return s
}

// SetRole sets the Role field's value.
func (s *DescribedAccess) SetRole(v string) *DescribedAccess {
	s.Role = &v
	return s
}

// The details for an execution object.
type DescribedExecution struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the execution of a workflow.
	ExecutionId *string `min:"36" type:"string"`

	// The IAM role associated with the execution.
	ExecutionRole *string `min:"20" type:"string"`

	// A structure that describes the Amazon S3 or EFS file location. This is the
	// file location when the execution begins: if the file is being copied, this
	// is the initial (as opposed to destination) file location.
	InitialFileLocation *FileLocation `type:"structure"`

	// The IAM logging role associated with the execution.
	LoggingConfiguration *LoggingConfiguration `type:"structure"`

	// The full POSIX identity, including user ID (Uid), group ID (Gid), and any
	// secondary groups IDs (SecondaryGids), that controls your users' access to
	// your Amazon EFS file systems. The POSIX permissions that are set on files
	// and directories in your file system determine the level of access your users
	// get when transferring files into and out of your Amazon EFS file systems.
	PosixProfile *PosixProfile `type:"structure"`

	// A structure that describes the execution results. This includes a list of
	// the steps along with the details of each step, error type and message (if
	// any), and the OnExceptionSteps structure.
	Results *ExecutionResults `type:"structure"`

	// A container object for the session details associated with a workflow.
	ServiceMetadata *ServiceMetadata `type:"structure"`

	// The status is one of the execution. Can be in progress, completed, exception
	// encountered, or handling the exception.
	Status *string `type:"string" enum:"ExecutionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribedExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribedExecution) GoString() string {
	return s.String()
}

// SetExecutionId sets the ExecutionId field's value.
func (s *DescribedExecution) SetExecutionId(v string) *DescribedExecution {
	s.ExecutionId = &v
	return s
}

// SetExecutionRole sets the ExecutionRole field's value.
func (s *DescribedExecution) SetExecutionRole(v string) *DescribedExecution {
	s.ExecutionRole = &v
	return s
}

// SetInitialFileLocation sets the InitialFileLocation field's value.
func (s *DescribedExecution) SetInitialFileLocation(v *FileLocation) *DescribedExecution {
	s.InitialFileLocation = v
	return s
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *DescribedExecution) SetLoggingConfiguration(v *LoggingConfiguration) *DescribedExecution {
	s.LoggingConfiguration = v
	return s
}

// SetPosixProfile sets the PosixProfile field's value.
func (s *DescribedExecution) SetPosixProfile(v *PosixProfile) *DescribedExecution {
	s.PosixProfile = v
	return s
}

// SetResults sets the Results field's value.
func (s *DescribedExecution) SetResults(v *ExecutionResults) *DescribedExecution {
	s.Results = v
	return s
}

// SetServiceMetadata sets the ServiceMetadata field's value.
func (s *DescribedExecution) SetServiceMetadata(v *ServiceMetadata) *DescribedExecution {
	s.ServiceMetadata = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribedExecution) SetStatus(v string) *DescribedExecution {
	s.Status = &v
	return s
}

// Describes the properties of a security policy that was specified. For more
// information about security policies, see Working with security policies (https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html).
type DescribedSecurityPolicy struct {
	_ struct{} `type:"structure"`

	// Specifies whether this policy enables Federal Information Processing Standards
	// (FIPS).
	Fips *bool `type:"boolean"`

	// Specifies the name of the security policy that is attached to the server.
	//
	// SecurityPolicyName is a required field
	SecurityPolicyName *string `type:"string" required:"true"`

	// Specifies the enabled Secure Shell (SSH) cipher encryption algorithms in
	// the security policy that is attached to the server.
	SshCiphers []*string `type:"list"`

	// Specifies the enabled SSH key exchange (KEX) encryption algorithms in the
	// security policy that is attached to the server.
	SshKexs []*string `type:"list"`

	// Specifies the enabled SSH message authentication code (MAC) encryption algorithms
	// in the security policy that is attached to the server.
	SshMacs []*string `type:"list"`

	// Specifies the enabled Transport Layer Security (TLS) cipher encryption algorithms
	// in the security policy that is attached to the server.
	TlsCiphers []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribedSecurityPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribedSecurityPolicy) GoString() string {
	return s.String()
}

// SetFips sets the Fips field's value.
func (s *DescribedSecurityPolicy) SetFips(v bool) *DescribedSecurityPolicy {
	s.Fips = &v
	return s
}

// SetSecurityPolicyName sets the SecurityPolicyName field's value.
func (s *DescribedSecurityPolicy) SetSecurityPolicyName(v string) *DescribedSecurityPolicy {
	s.SecurityPolicyName = &v
	return s
}

// SetSshCiphers sets the SshCiphers field's value.
func (s *DescribedSecurityPolicy) SetSshCiphers(v []*string) *DescribedSecurityPolicy {
	s.SshCiphers = v
	return s
}

// SetSshKexs sets the SshKexs field's value.
func (s *DescribedSecurityPolicy) SetSshKexs(v []*string) *DescribedSecurityPolicy {
	s.SshKexs = v
	return s
}

// SetSshMacs sets the SshMacs field's value.
func (s *DescribedSecurityPolicy) SetSshMacs(v []*string) *DescribedSecurityPolicy {
	s.SshMacs = v
	return s
}

// SetTlsCiphers sets the TlsCiphers field's value.
func (s *DescribedSecurityPolicy) SetTlsCiphers(v []*string) *DescribedSecurityPolicy {
	s.TlsCiphers = v
	return s
}

// Describes the properties of a file transfer protocol-enabled server that
// was specified.
type DescribedServer struct {
	_ struct{} `type:"structure"`

	// Specifies the unique Amazon Resource Name (ARN) of the server.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// Specifies the ARN of the Amazon Web ServicesCertificate Manager (ACM) certificate.
	// Required when Protocols is set to FTPS.
	Certificate *string `type:"string"`

	// Specifies the domain of the storage system that is used for file transfers.
	Domain *string `type:"string" enum:"Domain"`

	// The virtual private cloud (VPC) endpoint settings that are configured for
	// your server. When you host your endpoint within your VPC, you can make it
	// accessible only to resources within your VPC, or you can attach Elastic IP
	// addresses and make it accessible to clients over the internet. Your VPC's
	// default security groups are automatically assigned to your endpoint.
	EndpointDetails *EndpointDetails `type:"structure"`

	// Defines the type of endpoint that your server is connected to. If your server
	// is connected to a VPC endpoint, your server isn't accessible over the public
	// internet.
	EndpointType *string `type:"string" enum:"EndpointType"`

	// Specifies the Base64-encoded SHA256 fingerprint of the server's host key.
	// This value is equivalent to the output of the ssh-keygen -l -f my-new-server-key
	// command.
	HostKeyFingerprint *string `type:"string"`

	// Specifies information to call a customer-supplied authentication API. This
	// field is not populated when the IdentityProviderType of a server is AWS_DIRECTORY_SERVICE
	// or SERVICE_MANAGED.
	IdentityProviderDetails *IdentityProviderDetails `type:"structure"`

	// Specifies the mode of authentication for a server. The default value is SERVICE_MANAGED,
	// which allows you to store and access user credentials within the Amazon Web
	// Services Transfer Family service.
	//
	// Use AWS_DIRECTORY_SERVICE to provide access to Active Directory groups in
	// Amazon Web Services Managed Active Directory or Microsoft Active Directory
	// in your on-premises environment or in Amazon Web Services using AD Connectors.
	// This option also requires you to provide a Directory ID using the IdentityProviderDetails
	// parameter.
	//
	// Use the API_GATEWAY value to integrate with an identity provider of your
	// choosing. The API_GATEWAY setting requires you to provide an API Gateway
	// endpoint URL to call for authentication using the IdentityProviderDetails
	// parameter.
	//
	// Use the AWS_LAMBDA value to directly use a Lambda function as your identity
	// provider. If you choose this value, you must specify the ARN for the lambda
	// function in the Function parameter for the IdentityProviderDetails data type.
	IdentityProviderType *string `type:"string" enum:"IdentityProviderType"`

	// Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity
	// and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch
	// logging for Amazon S3 or Amazon EFS events. When set, user activity can be
	// viewed in your CloudWatch logs.
	LoggingRole *string `min:"20" type:"string"`

	// Specify a string to display when users connect to a server. This string is
	// displayed after the user authenticates.
	//
	// The SFTP protocol does not support post-authentication display banners.
	PostAuthenticationLoginBanner *string `type:"string"`

	// Specify a string to display when users connect to a server. This string is
	// displayed before the user authenticates. For example, the following banner
	// displays details about using the system.
	//
	// This system is for the use of authorized users only. Individuals using this
	// computer system without authority, or in excess of their authority, are subject
	// to having all of their activities on this system monitored and recorded by
	// system personnel.
	PreAuthenticationLoginBanner *string `type:"string"`

	// The protocol settings that are configured for your server.
	//
	// Use the PassiveIp parameter to indicate passive mode. Enter a single dotted-quad
	// IPv4 address, such as the external IP address of a firewall, router, or load
	// balancer.
	ProtocolDetails *ProtocolDetails `type:"structure"`

	// Specifies the file transfer protocol or protocols over which your file transfer
	// protocol client can connect to your server's endpoint. The available protocols
	// are:
	//
	//    * SFTP (Secure Shell (SSH) File Transfer Protocol): File transfer over
	//    SSH
	//
	//    * FTPS (File Transfer Protocol Secure): File transfer with TLS encryption
	//
	//    * FTP (File Transfer Protocol): Unencrypted file transfer
	Protocols []*string `min:"1" type:"list" enum:"Protocol"`

	// Specifies the name of the security policy that is attached to the server.
	SecurityPolicyName *string `type:"string"`

	// Specifies the unique system-assigned identifier for a server that you instantiate.
	ServerId *string `min:"19" type:"string"`

	// Specifies the condition of a server for the server that was described. A
	// value of ONLINE indicates that the server can accept jobs and transfer files.
	// A State value of OFFLINE means that the server cannot perform file transfer
	// operations.
	//
	// The states of STARTING and STOPPING indicate that the server is in an intermediate
	// state, either not fully able to respond, or not fully offline. The values
	// of START_FAILED or STOP_FAILED can indicate an error condition.
	State *string `type:"string" enum:"State"`

	// Specifies the key-value pairs that you can use to search for and group servers
	// that were assigned to the server that was described.
	Tags []*Tag `min:"1" type:"list"`

	// Specifies the number of users that are assigned to a server you specified
	// with the ServerId.
	UserCount *int64 `type:"integer"`

	// Specifies the workflow ID for the workflow to assign and the execution role
	// used for executing the workflow.
	WorkflowDetails *WorkflowDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribedServer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribedServer) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribedServer) SetArn(v string) *DescribedServer {
	s.Arn = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *DescribedServer) SetCertificate(v string) *DescribedServer {
	s.Certificate = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DescribedServer) SetDomain(v string) *DescribedServer {
	s.Domain = &v
	return s
}

// SetEndpointDetails sets the EndpointDetails field's value.
func (s *DescribedServer) SetEndpointDetails(v *EndpointDetails) *DescribedServer {
	s.EndpointDetails = v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *DescribedServer) SetEndpointType(v string) *DescribedServer {
	s.EndpointType = &v
	return s
}

// SetHostKeyFingerprint sets the HostKeyFingerprint field's value.
func (s *DescribedServer) SetHostKeyFingerprint(v string) *DescribedServer {
	s.HostKeyFingerprint = &v
	return s
}

// SetIdentityProviderDetails sets the IdentityProviderDetails field's value.
func (s *DescribedServer) SetIdentityProviderDetails(v *IdentityProviderDetails) *DescribedServer {
	s.IdentityProviderDetails = v
	return s
}

// SetIdentityProviderType sets the IdentityProviderType field's value.
func (s *DescribedServer) SetIdentityProviderType(v string) *DescribedServer {
	s.IdentityProviderType = &v
	return s
}

// SetLoggingRole sets the LoggingRole field's value.
func (s *DescribedServer) SetLoggingRole(v string) *DescribedServer {
	s.LoggingRole = &v
	return s
}

// SetPostAuthenticationLoginBanner sets the PostAuthenticationLoginBanner field's value.
func (s *DescribedServer) SetPostAuthenticationLoginBanner(v string) *DescribedServer {
	s.PostAuthenticationLoginBanner = &v
	return s
}

// SetPreAuthenticationLoginBanner sets the PreAuthenticationLoginBanner field's value.
func (s *DescribedServer) SetPreAuthenticationLoginBanner(v string) *DescribedServer {
	s.PreAuthenticationLoginBanner = &v
	return s
}

// SetProtocolDetails sets the ProtocolDetails field's value.
func (s *DescribedServer) SetProtocolDetails(v *ProtocolDetails) *DescribedServer {
	s.ProtocolDetails = v
	return s
}

// SetProtocols sets the Protocols field's value.
func (s *DescribedServer) SetProtocols(v []*string) *DescribedServer {
	s.Protocols = v
	return s
}

// SetSecurityPolicyName sets the SecurityPolicyName field's value.
func (s *DescribedServer) SetSecurityPolicyName(v string) *DescribedServer {
	s.SecurityPolicyName = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *DescribedServer) SetServerId(v string) *DescribedServer {
	s.ServerId = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribedServer) SetState(v string) *DescribedServer {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribedServer) SetTags(v []*Tag) *DescribedServer {
	s.Tags = v
	return s
}

// SetUserCount sets the UserCount field's value.
func (s *DescribedServer) SetUserCount(v int64) *DescribedServer {
	s.UserCount = &v
	return s
}

// SetWorkflowDetails sets the WorkflowDetails field's value.
func (s *DescribedServer) SetWorkflowDetails(v *WorkflowDetails) *DescribedServer {
	s.WorkflowDetails = v
	return s
}

// Describes the properties of a user that was specified.
type DescribedUser struct {
	_ struct{} `type:"structure"`

	// Specifies the unique Amazon Resource Name (ARN) for the user that was requested
	// to be described.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// The landing directory (folder) for a user when they log in to the server
	// using the client.
	//
	// A HomeDirectory example is /bucket_name/home/mydirectory.
	HomeDirectory *string `type:"string"`

	// Logical directory mappings that specify what Amazon S3 or Amazon EFS paths
	// and keys should be visible to your user and how you want to make them visible.
	// You must specify the Entry and Target pair, where Entry shows how the path
	// is made visible and Target is the actual Amazon S3 or Amazon EFS path. If
	// you only specify a target, it is displayed as is. You also must ensure that
	// your Amazon Web Services Identity and Access Management (IAM) role provides
	// access to paths in Target. This value can only be set when HomeDirectoryType
	// is set to LOGICAL.
	//
	// In most cases, you can use this value instead of the session policy to lock
	// your user down to the designated home directory ("chroot"). To do this, you
	// can set Entry to '/' and set Target to the HomeDirectory parameter value.
	HomeDirectoryMappings []*HomeDirectoryMapEntry `min:"1" type:"list"`

	// The type of landing directory (folder) you want your users' home directory
	// to be when they log into the server. If you set it to PATH, the user will
	// see the absolute Amazon S3 bucket or EFS paths as is in their file transfer
	// protocol clients. If you set it LOGICAL, you need to provide mappings in
	// the HomeDirectoryMappings for how you want to make Amazon S3 or EFS paths
	// visible to your users.
	HomeDirectoryType *string `type:"string" enum:"HomeDirectoryType"`

	// A session policy for your user so that you can use the same IAM role across
	// multiple users. This policy scopes down user access to portions of their
	// Amazon S3 bucket. Variables that you can use inside this policy include ${Transfer:UserName},
	// ${Transfer:HomeDirectory}, and ${Transfer:HomeBucket}.
	Policy *string `type:"string"`

	// Specifies the full POSIX identity, including user ID (Uid), group ID (Gid),
	// and any secondary groups IDs (SecondaryGids), that controls your users' access
	// to your Amazon Elastic File System (Amazon EFS) file systems. The POSIX permissions
	// that are set on files and directories in your file system determine the level
	// of access your users get when transferring files into and out of your Amazon
	// EFS file systems.
	PosixProfile *PosixProfile `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the IAM role that controls your
	// users' access to your Amazon S3 bucket or EFS file system. The policies attached
	// to this role determine the level of access that you want to provide your
	// users when transferring files into and out of your Amazon S3 bucket or EFS
	// file system. The IAM role should also contain a trust relationship that allows
	// the server to access your resources when servicing your users' transfer requests.
	Role *string `min:"20" type:"string"`

	// Specifies the public key portion of the Secure Shell (SSH) keys stored for
	// the described user.
	SshPublicKeys []*SshPublicKey `type:"list"`

	// Specifies the key-value pairs for the user requested. Tag can be used to
	// search for and group users for a variety of purposes.
	Tags []*Tag `min:"1" type:"list"`

	// Specifies the name of the user that was requested to be described. User names
	// are used for authentication purposes. This is the string that will be used
	// by your user when they log in to your server.
	UserName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribedUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribedUser) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribedUser) SetArn(v string) *DescribedUser {
	s.Arn = &v
	return s
}

// SetHomeDirectory sets the HomeDirectory field's value.
func (s *DescribedUser) SetHomeDirectory(v string) *DescribedUser {
	s.HomeDirectory = &v
	return s
}

// SetHomeDirectoryMappings sets the HomeDirectoryMappings field's value.
func (s *DescribedUser) SetHomeDirectoryMappings(v []*HomeDirectoryMapEntry) *DescribedUser {
	s.HomeDirectoryMappings = v
	return s
}

// SetHomeDirectoryType sets the HomeDirectoryType field's value.
func (s *DescribedUser) SetHomeDirectoryType(v string) *DescribedUser {
	s.HomeDirectoryType = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *DescribedUser) SetPolicy(v string) *DescribedUser {
	s.Policy = &v
	return s
}

// SetPosixProfile sets the PosixProfile field's value.
func (s *DescribedUser) SetPosixProfile(v *PosixProfile) *DescribedUser {
	s.PosixProfile = v
	return s
}

// SetRole sets the Role field's value.
func (s *DescribedUser) SetRole(v string) *DescribedUser {
	s.Role = &v
	return s
}

// SetSshPublicKeys sets the SshPublicKeys field's value.
func (s *DescribedUser) SetSshPublicKeys(v []*SshPublicKey) *DescribedUser {
	s.SshPublicKeys = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribedUser) SetTags(v []*Tag) *DescribedUser {
	s.Tags = v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DescribedUser) SetUserName(v string) *DescribedUser {
	s.UserName = &v
	return s
}

// Describes the properties of the specified workflow
type DescribedWorkflow struct {
	_ struct{} `type:"structure"`

	// Specifies the unique Amazon Resource Name (ARN) for the workflow.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// Specifies the text description for the workflow.
	Description *string `type:"string"`

	// Specifies the steps (actions) to take if errors are encountered during execution
	// of the workflow.
	OnExceptionSteps []*WorkflowStep `type:"list"`

	// Specifies the details for the steps that are in the specified workflow.
	Steps []*WorkflowStep `type:"list"`

	// Key-value pairs that can be used to group and search for workflows. Tags
	// are metadata attached to workflows for any purpose.
	Tags []*Tag `min:"1" type:"list"`

	// A unique identifier for the workflow.
	WorkflowId *string `min:"19" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribedWorkflow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribedWorkflow) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribedWorkflow) SetArn(v string) *DescribedWorkflow {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribedWorkflow) SetDescription(v string) *DescribedWorkflow {
	s.Description = &v
	return s
}

// SetOnExceptionSteps sets the OnExceptionSteps field's value.
func (s *DescribedWorkflow) SetOnExceptionSteps(v []*WorkflowStep) *DescribedWorkflow {
	s.OnExceptionSteps = v
	return s
}

// SetSteps sets the Steps field's value.
func (s *DescribedWorkflow) SetSteps(v []*WorkflowStep) *DescribedWorkflow {
	s.Steps = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribedWorkflow) SetTags(v []*Tag) *DescribedWorkflow {
	s.Tags = v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *DescribedWorkflow) SetWorkflowId(v string) *DescribedWorkflow {
	s.WorkflowId = &v
	return s
}

// Reserved for future use.
type EfsFileLocation struct {
	_ struct{} `type:"structure"`

	// The ID of the file system, assigned by Amazon EFS.
	FileSystemId *string `type:"string"`

	// The pathname for the folder being used by a workflow.
	Path *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EfsFileLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EfsFileLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EfsFileLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EfsFileLocation"}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Path", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *EfsFileLocation) SetFileSystemId(v string) *EfsFileLocation {
	s.FileSystemId = &v
	return s
}

// SetPath sets the Path field's value.
func (s *EfsFileLocation) SetPath(v string) *EfsFileLocation {
	s.Path = &v
	return s
}

// The virtual private cloud (VPC) endpoint settings that are configured for
// your file transfer protocol-enabled server. With a VPC endpoint, you can
// restrict access to your server and resources only within your VPC. To control
// incoming internet traffic, invoke the UpdateServer API and attach an Elastic
// IP address to your server's endpoint.
//
// After May 19, 2021, you won't be able to create a server using EndpointType=VPC_ENDPOINT
// in your Amazon Web Servicesaccount if your account hasn't already done so
// before May 19, 2021. If you have already created servers with EndpointType=VPC_ENDPOINT
// in your Amazon Web Servicesaccount on or before May 19, 2021, you will not
// be affected. After this date, use EndpointType=VPC.
//
// For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.
type EndpointDetails struct {
	_ struct{} `type:"structure"`

	// A list of address allocation IDs that are required to attach an Elastic IP
	// address to your server's endpoint.
	//
	// This property can only be set when EndpointType is set to VPC and it is only
	// valid in the UpdateServer API.
	AddressAllocationIds []*string `type:"list"`

	// A list of security groups IDs that are available to attach to your server's
	// endpoint.
	//
	// This property can only be set when EndpointType is set to VPC.
	//
	// You can edit the SecurityGroupIds property in the UpdateServer (https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html)
	// API only if you are changing the EndpointType from PUBLIC or VPC_ENDPOINT
	// to VPC. To change security groups associated with your server's VPC endpoint
	// after creation, use the Amazon EC2 ModifyVpcEndpoint (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html)
	// API.
	SecurityGroupIds []*string `type:"list"`

	// A list of subnet IDs that are required to host your server endpoint in your
	// VPC.
	//
	// This property can only be set when EndpointType is set to VPC.
	SubnetIds []*string `type:"list"`

	// The ID of the VPC endpoint.
	//
	// This property can only be set when EndpointType is set to VPC_ENDPOINT.
	//
	// For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.
	VpcEndpointId *string `min:"22" type:"string"`

	// The VPC ID of the VPC in which a server's endpoint will be hosted.
	//
	// This property can only be set when EndpointType is set to VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EndpointDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EndpointDetails"}
	if s.VpcEndpointId != nil && len(*s.VpcEndpointId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("VpcEndpointId", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressAllocationIds sets the AddressAllocationIds field's value.
func (s *EndpointDetails) SetAddressAllocationIds(v []*string) *EndpointDetails {
	s.AddressAllocationIds = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *EndpointDetails) SetSecurityGroupIds(v []*string) *EndpointDetails {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *EndpointDetails) SetSubnetIds(v []*string) *EndpointDetails {
	s.SubnetIds = v
	return s
}

// SetVpcEndpointId sets the VpcEndpointId field's value.
func (s *EndpointDetails) SetVpcEndpointId(v string) *EndpointDetails {
	s.VpcEndpointId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *EndpointDetails) SetVpcId(v string) *EndpointDetails {
	s.VpcId = &v
	return s
}

// Specifies the error message and type, for an error that occurs during the
// execution of the workflow.
type ExecutionError struct {
	_ struct{} `type:"structure"`

	// Specifies the descriptive message that corresponds to the ErrorType.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// Specifies the error type.
	//
	//    * ALREADY_EXISTS: occurs for a copy step, if the overwrite option is not
	//    selected and a file with the same name already exists in the target location.
	//
	//    * BAD_REQUEST: a general bad request: for example, a step that attempts
	//    to tag an EFS file returns BAD_REQUEST, as only S3 files can be tagged.
	//
	//    * CUSTOM_STEP_FAILED: occurs when the custom step provided a callback
	//    that indicates failure.
	//
	//    * INTERNAL_SERVER_ERROR: a catch-all error that can occur for a variety
	//    of reasons.
	//
	//    * NOT_FOUND: occurs when a requested entity, for example a source file
	//    for a copy step, does not exist.
	//
	//    * PERMISSION_DENIED: occurs if your policy does not contain the correct
	//    permissions to complete one or more of the steps in the workflow.
	//
	//    * TIMEOUT: occurs when the execution times out. You can set the TimeoutSeconds
	//    for a custom step, anywhere from 1 second to 1800 seconds (30 minutes).
	//
	//    * THROTTLED: occurs if you exceed the new execution refill rate of one
	//    workflow per second.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ExecutionErrorType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionError) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ExecutionError) SetMessage(v string) *ExecutionError {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *ExecutionError) SetType(v string) *ExecutionError {
	s.Type = &v
	return s
}

// Specifies the steps in the workflow, as well as the steps to execute in case
// of any errors during workflow execution.
type ExecutionResults struct {
	_ struct{} `type:"structure"`

	// Specifies the steps (actions) to take if errors are encountered during execution
	// of the workflow.
	OnExceptionSteps []*ExecutionStepResult `min:"1" type:"list"`

	// Specifies the details for the steps that are in the specified workflow.
	Steps []*ExecutionStepResult `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionResults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionResults) GoString() string {
	return s.String()
}

// SetOnExceptionSteps sets the OnExceptionSteps field's value.
func (s *ExecutionResults) SetOnExceptionSteps(v []*ExecutionStepResult) *ExecutionResults {
	s.OnExceptionSteps = v
	return s
}

// SetSteps sets the Steps field's value.
func (s *ExecutionResults) SetSteps(v []*ExecutionStepResult) *ExecutionResults {
	s.Steps = v
	return s
}

// Specifies the following details for the step: error (if any), outputs (if
// any), and the step type.
type ExecutionStepResult struct {
	_ struct{} `type:"structure"`

	// Specifies the details for an error, if it occurred during execution of the
	// specified workfow step.
	Error *ExecutionError `type:"structure"`

	// The values for the key/value pair applied as a tag to the file. Only applicable
	// if the step type is TAG.
	Outputs *string `type:"string"`

	// One of the available step types.
	//
	//    * COPY: copy the file to another location
	//
	//    * CUSTOM: custom step with a lambda target
	//
	//    * DELETE: delete the file
	//
	//    * TAG: add a tag to the file
	StepType *string `type:"string" enum:"WorkflowStepType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionStepResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionStepResult) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *ExecutionStepResult) SetError(v *ExecutionError) *ExecutionStepResult {
	s.Error = v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *ExecutionStepResult) SetOutputs(v string) *ExecutionStepResult {
	s.Outputs = &v
	return s
}

// SetStepType sets the StepType field's value.
func (s *ExecutionStepResult) SetStepType(v string) *ExecutionStepResult {
	s.StepType = &v
	return s
}

// Specifies the Amazon S3 or EFS file details to be used in the step.
type FileLocation struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon EFS ID and the path for the file being used.
	EfsFileLocation *EfsFileLocation `type:"structure"`

	// Specifies the S3 details for the file being used, such as bucket, Etag, and
	// so forth.
	S3FileLocation *S3FileLocation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileLocation) GoString() string {
	return s.String()
}

// SetEfsFileLocation sets the EfsFileLocation field's value.
func (s *FileLocation) SetEfsFileLocation(v *EfsFileLocation) *FileLocation {
	s.EfsFileLocation = v
	return s
}

// SetS3FileLocation sets the S3FileLocation field's value.
func (s *FileLocation) SetS3FileLocation(v *S3FileLocation) *FileLocation {
	s.S3FileLocation = v
	return s
}

// Represents an object that contains entries and targets for HomeDirectoryMappings.
//
// The following is an Entry and Target pair example for chroot.
//
// [ { "Entry": "/", "Target": "/bucket_name/home/mydirectory" } ]
type HomeDirectoryMapEntry struct {
	_ struct{} `type:"structure"`

	// Represents an entry for HomeDirectoryMappings.
	//
	// Entry is a required field
	Entry *string `type:"string" required:"true"`

	// Represents the map target that is used in a HomeDirectorymapEntry.
	//
	// Target is a required field
	Target *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HomeDirectoryMapEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HomeDirectoryMapEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HomeDirectoryMapEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HomeDirectoryMapEntry"}
	if s.Entry == nil {
		invalidParams.Add(request.NewErrParamRequired("Entry"))
	}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntry sets the Entry field's value.
func (s *HomeDirectoryMapEntry) SetEntry(v string) *HomeDirectoryMapEntry {
	s.Entry = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *HomeDirectoryMapEntry) SetTarget(v string) *HomeDirectoryMapEntry {
	s.Target = &v
	return s
}

// Returns information related to the type of user authentication that is in
// use for a file transfer protocol-enabled server's users. A server can have
// only one method of authentication.
type IdentityProviderDetails struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Web Services Directory Service directory that
	// you want to stop sharing.
	DirectoryId *string `min:"12" type:"string"`

	// The ARN for a lambda function to use for the Identity provider.
	Function *string `min:"1" type:"string"`

	// Provides the type of InvocationRole used to authenticate the user account.
	InvocationRole *string `min:"20" type:"string"`

	// Provides the location of the service endpoint used to authenticate users.
	Url *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProviderDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProviderDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IdentityProviderDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IdentityProviderDetails"}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryId", 12))
	}
	if s.Function != nil && len(*s.Function) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Function", 1))
	}
	if s.InvocationRole != nil && len(*s.InvocationRole) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("InvocationRole", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *IdentityProviderDetails) SetDirectoryId(v string) *IdentityProviderDetails {
	s.DirectoryId = &v
	return s
}

// SetFunction sets the Function field's value.
func (s *IdentityProviderDetails) SetFunction(v string) *IdentityProviderDetails {
	s.Function = &v
	return s
}

// SetInvocationRole sets the InvocationRole field's value.
func (s *IdentityProviderDetails) SetInvocationRole(v string) *IdentityProviderDetails {
	s.InvocationRole = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *IdentityProviderDetails) SetUrl(v string) *IdentityProviderDetails {
	s.Url = &v
	return s
}

type ImportSshPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a server.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// The public key portion of an SSH key pair.
	//
	// SshPublicKeyBody is a required field
	SshPublicKeyBody *string `type:"string" required:"true"`

	// The name of the user account that is assigned to one or more servers.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportSshPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportSshPublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportSshPublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportSshPublicKeyInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}
	if s.SshPublicKeyBody == nil {
		invalidParams.Add(request.NewErrParamRequired("SshPublicKeyBody"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *ImportSshPublicKeyInput) SetServerId(v string) *ImportSshPublicKeyInput {
	s.ServerId = &v
	return s
}

// SetSshPublicKeyBody sets the SshPublicKeyBody field's value.
func (s *ImportSshPublicKeyInput) SetSshPublicKeyBody(v string) *ImportSshPublicKeyInput {
	s.SshPublicKeyBody = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ImportSshPublicKeyInput) SetUserName(v string) *ImportSshPublicKeyInput {
	s.UserName = &v
	return s
}

// Identifies the user, the server they belong to, and the identifier of the
// SSH public key associated with that user. A user can have more than one key
// on each server that they are associated with.
type ImportSshPublicKeyOutput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a server.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// The name given to a public key by the system that was imported.
	//
	// SshPublicKeyId is a required field
	SshPublicKeyId *string `min:"21" type:"string" required:"true"`

	// A user name assigned to the ServerID value that you specified.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportSshPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportSshPublicKeyOutput) GoString() string {
	return s.String()
}

// SetServerId sets the ServerId field's value.
func (s *ImportSshPublicKeyOutput) SetServerId(v string) *ImportSshPublicKeyOutput {
	s.ServerId = &v
	return s
}

// SetSshPublicKeyId sets the SshPublicKeyId field's value.
func (s *ImportSshPublicKeyOutput) SetSshPublicKeyId(v string) *ImportSshPublicKeyOutput {
	s.SshPublicKeyId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ImportSshPublicKeyOutput) SetUserName(v string) *ImportSshPublicKeyOutput {
	s.UserName = &v
	return s
}

// Specifies the location for the file being copied. Only applicable for the
// Copy type of workflow steps.
type InputFileLocation struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	EfsFileLocation *EfsFileLocation `type:"structure"`

	// Specifies the details for the S3 file being copied.
	S3FileLocation *S3InputFileLocation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputFileLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputFileLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputFileLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputFileLocation"}
	if s.EfsFileLocation != nil {
		if err := s.EfsFileLocation.Validate(); err != nil {
			invalidParams.AddNested("EfsFileLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.S3FileLocation != nil {
		if err := s.S3FileLocation.Validate(); err != nil {
			invalidParams.AddNested("S3FileLocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEfsFileLocation sets the EfsFileLocation field's value.
func (s *InputFileLocation) SetEfsFileLocation(v *EfsFileLocation) *InputFileLocation {
	s.EfsFileLocation = v
	return s
}

// SetS3FileLocation sets the S3FileLocation field's value.
func (s *InputFileLocation) SetS3FileLocation(v *S3InputFileLocation) *InputFileLocation {
	s.S3FileLocation = v
	return s
}

// This exception is thrown when an error occurs in the Amazon Web ServicesTransfer
// Family service.
type InternalServiceError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceError) GoString() string {
	return s.String()
}

func newErrorInternalServiceError(v protocol.ResponseMetadata) error {
	return &InternalServiceError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceError) Code() string {
	return "InternalServiceError"
}

// Message returns the exception's message.
func (s *InternalServiceError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceError) OrigErr() error {
	return nil
}

func (s *InternalServiceError) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceError) RequestID() string {
	return s.RespMetadata.RequestID
}

// The NextToken parameter that was passed is invalid.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the client submits a malformed request.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAccessesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the maximum number of access SIDs to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// When you can get additional results from the ListAccesses call, a NextToken
	// parameter is returned in the output. You can then pass in a subsequent command
	// to the NextToken parameter to continue listing additional accesses.
	NextToken *string `min:"1" type:"string"`

	// A system-assigned unique identifier for a server that has users assigned
	// to it.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccessesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccessesInput) SetMaxResults(v int64) *ListAccessesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessesInput) SetNextToken(v string) *ListAccessesInput {
	s.NextToken = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *ListAccessesInput) SetServerId(v string) *ListAccessesInput {
	s.ServerId = &v
	return s
}

type ListAccessesOutput struct {
	_ struct{} `type:"structure"`

	// Returns the accesses and their properties for the ServerId value that you
	// specify.
	//
	// Accesses is a required field
	Accesses []*ListedAccess `type:"list" required:"true"`

	// When you can get additional results from the ListAccesses call, a NextToken
	// parameter is returned in the output. You can then pass in a subsequent command
	// to the NextToken parameter to continue listing additional accesses.
	NextToken *string `min:"1" type:"string"`

	// A system-assigned unique identifier for a server that has users assigned
	// to it.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessesOutput) GoString() string {
	return s.String()
}

// SetAccesses sets the Accesses field's value.
func (s *ListAccessesOutput) SetAccesses(v []*ListedAccess) *ListAccessesOutput {
	s.Accesses = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessesOutput) SetNextToken(v string) *ListAccessesOutput {
	s.NextToken = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *ListAccessesOutput) SetServerId(v string) *ListAccessesOutput {
	s.ServerId = &v
	return s
}

type ListExecutionsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the aximum number of executions to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// ListExecutions returns the NextToken parameter in the output. You can then
	// pass the NextToken parameter in a subsequent command to continue listing
	// additional executions.
	//
	// This is useful for pagination, for instance. If you have 100 executions for
	// a workflow, you might only want to list first 10. If so, callthe API by specifing
	// the max-results:
	//
	// aws transfer list-executions --max-results 10
	//
	// This returns details for the first 10 executions, as well as the pointer
	// (NextToken) to the eleventh execution. You can now call the API again, suppling
	// the NextToken value you received:
	//
	// aws transfer list-executions --max-results 10 --next-token $somePointerReturnedFromPreviousListResult
	//
	// This call returns the next 10 executions, the 11th through the 20th. You
	// can then repeat the call until the details for all 100 executions have been
	// returned.
	NextToken *string `min:"1" type:"string"`

	// A unique identifier for the workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExecutionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListExecutionsInput) SetMaxResults(v int64) *ListExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExecutionsInput) SetNextToken(v string) *ListExecutionsInput {
	s.NextToken = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *ListExecutionsInput) SetWorkflowId(v string) *ListExecutionsInput {
	s.WorkflowId = &v
	return s
}

type ListExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// Returns the details for each execution.
	//
	//    * NextToken: returned from a call to several APIs, you can use pass it
	//    to a subsequent command to continue listing additional executions.
	//
	//    * StartTime: timestamp indicating when the execution began.
	//
	//    * Executions: details of the execution, including the execution ID, initial
	//    file location, and Service metadata.
	//
	//    * Status: one of the following values: IN_PROGRESS, COMPLETED, EXCEPTION,
	//    HANDLING_EXEPTION.
	//
	// Executions is a required field
	Executions []*ListedExecution `type:"list" required:"true"`

	// ListExecutions returns the NextToken parameter in the output. You can then
	// pass the NextToken parameter in a subsequent command to continue listing
	// additional executions.
	NextToken *string `min:"1" type:"string"`

	// A unique identifier for the workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExecutionsOutput) GoString() string {
	return s.String()
}

// SetExecutions sets the Executions field's value.
func (s *ListExecutionsOutput) SetExecutions(v []*ListedExecution) *ListExecutionsOutput {
	s.Executions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExecutionsOutput) SetNextToken(v string) *ListExecutionsOutput {
	s.NextToken = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *ListExecutionsOutput) SetWorkflowId(v string) *ListExecutionsOutput {
	s.WorkflowId = &v
	return s
}

type ListSecurityPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of security policies to return as a response to the
	// ListSecurityPolicies query.
	MaxResults *int64 `min:"1" type:"integer"`

	// When additional results are obtained from the ListSecurityPolicies command,
	// a NextToken parameter is returned in the output. You can then pass the NextToken
	// parameter in a subsequent command to continue listing additional security
	// policies.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecurityPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecurityPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSecurityPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSecurityPoliciesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSecurityPoliciesInput) SetMaxResults(v int64) *ListSecurityPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecurityPoliciesInput) SetNextToken(v string) *ListSecurityPoliciesInput {
	s.NextToken = &v
	return s
}

type ListSecurityPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// When you can get additional results from the ListSecurityPolicies operation,
	// a NextToken parameter is returned in the output. In a following command,
	// you can pass in the NextToken parameter to continue listing security policies.
	NextToken *string `min:"1" type:"string"`

	// An array of security policies that were listed.
	//
	// SecurityPolicyNames is a required field
	SecurityPolicyNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecurityPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecurityPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecurityPoliciesOutput) SetNextToken(v string) *ListSecurityPoliciesOutput {
	s.NextToken = &v
	return s
}

// SetSecurityPolicyNames sets the SecurityPolicyNames field's value.
func (s *ListSecurityPoliciesOutput) SetSecurityPolicyNames(v []*string) *ListSecurityPoliciesOutput {
	s.SecurityPolicyNames = v
	return s
}

type ListServersInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of servers to return as a response to the ListServers
	// query.
	MaxResults *int64 `min:"1" type:"integer"`

	// When additional results are obtained from the ListServers command, a NextToken
	// parameter is returned in the output. You can then pass the NextToken parameter
	// in a subsequent command to continue listing additional servers.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServersInput) SetMaxResults(v int64) *ListServersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServersInput) SetNextToken(v string) *ListServersInput {
	s.NextToken = &v
	return s
}

type ListServersOutput struct {
	_ struct{} `type:"structure"`

	// When you can get additional results from the ListServers operation, a NextToken
	// parameter is returned in the output. In a following command, you can pass
	// in the NextToken parameter to continue listing additional servers.
	NextToken *string `min:"1" type:"string"`

	// An array of servers that were listed.
	//
	// Servers is a required field
	Servers []*ListedServer `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServersOutput) SetNextToken(v string) *ListServersOutput {
	s.NextToken = &v
	return s
}

// SetServers sets the Servers field's value.
func (s *ListServersOutput) SetServers(v []*ListedServer) *ListServersOutput {
	s.Servers = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Requests the tags associated with a particular Amazon Resource Name (ARN).
	// An ARN is an identifier for a specific Amazon Web Services resource, such
	// as a server, user, or role.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// Specifies the number of tags to return as a response to the ListTagsForResource
	// request.
	MaxResults *int64 `min:"1" type:"integer"`

	// When you request additional results from the ListTagsForResource operation,
	// a NextToken parameter is returned in the input. You can then pass in a subsequent
	// command to the NextToken parameter to continue listing additional tags.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListTagsForResourceInput) SetArn(v string) *ListTagsForResourceInput {
	s.Arn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN you specified to list the tags of.
	Arn *string `min:"20" type:"string"`

	// When you can get additional results from the ListTagsForResource call, a
	// NextToken parameter is returned in the output. You can then pass in a subsequent
	// command to the NextToken parameter to continue listing additional tags.
	NextToken *string `min:"1" type:"string"`

	// Key-value pairs that are assigned to a resource, usually for the purpose
	// of grouping and searching for items. Tags are metadata that you define.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListTagsForResourceOutput) SetArn(v string) *ListTagsForResourceOutput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListUsersInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of users to return as a response to the ListUsers request.
	MaxResults *int64 `min:"1" type:"integer"`

	// When you can get additional results from the ListUsers call, a NextToken
	// parameter is returned in the output. You can then pass in a subsequent command
	// to the NextToken parameter to continue listing additional users.
	NextToken *string `min:"1" type:"string"`

	// A system-assigned unique identifier for a server that has users assigned
	// to it.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUsersInput) SetMaxResults(v int64) *ListUsersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersInput) SetNextToken(v string) *ListUsersInput {
	s.NextToken = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *ListUsersInput) SetServerId(v string) *ListUsersInput {
	s.ServerId = &v
	return s
}

type ListUsersOutput struct {
	_ struct{} `type:"structure"`

	// When you can get additional results from the ListUsers call, a NextToken
	// parameter is returned in the output. You can then pass in a subsequent command
	// to the NextToken parameter to continue listing additional users.
	NextToken *string `min:"1" type:"string"`

	// A system-assigned unique identifier for a server that the users are assigned
	// to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// Returns the user accounts and their properties for the ServerId value that
	// you specify.
	//
	// Users is a required field
	Users []*ListedUser `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersOutput) SetNextToken(v string) *ListUsersOutput {
	s.NextToken = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *ListUsersOutput) SetServerId(v string) *ListUsersOutput {
	s.ServerId = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *ListUsersOutput) SetUsers(v []*ListedUser) *ListUsersOutput {
	s.Users = v
	return s
}

type ListWorkflowsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the maximum number of workflows to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// ListWorkflows returns the NextToken parameter in the output. You can then
	// pass the NextToken parameter in a subsequent command to continue listing
	// additional workflows.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkflowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkflowsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkflowsInput) SetMaxResults(v int64) *ListWorkflowsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkflowsInput) SetNextToken(v string) *ListWorkflowsInput {
	s.NextToken = &v
	return s
}

type ListWorkflowsOutput struct {
	_ struct{} `type:"structure"`

	// ListWorkflows returns the NextToken parameter in the output. You can then
	// pass the NextToken parameter in a subsequent command to continue listing
	// additional workflows.
	NextToken *string `min:"1" type:"string"`

	// Returns the Arn, WorkflowId, and Description for each workflow.
	//
	// Workflows is a required field
	Workflows []*ListedWorkflow `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkflowsOutput) SetNextToken(v string) *ListWorkflowsOutput {
	s.NextToken = &v
	return s
}

// SetWorkflows sets the Workflows field's value.
func (s *ListWorkflowsOutput) SetWorkflows(v []*ListedWorkflow) *ListWorkflowsOutput {
	s.Workflows = v
	return s
}

// Lists the properties for one or more specified associated accesses.
type ListedAccess struct {
	_ struct{} `type:"structure"`

	// A unique identifier that is required to identify specific groups within your
	// directory. The users of the group that you associate have access to your
	// Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon
	// Web Services Transfer Family. If you know the group name, you can view the
	// SID values by running the following command using Windows PowerShell.
	//
	// Get-ADGroup -Filter {samAccountName -like "YourGroupName*"} -Properties *
	// | Select SamAccountName,ObjectSid
	//
	// In that command, replace YourGroupName with the name of your Active Directory
	// group.
	//
	// The regex used to validate this parameter is a string of characters consisting
	// of uppercase and lowercase alphanumeric characters with no spaces. You can
	// also include underscores or any of the following characters: =,.@:/-
	ExternalId *string `min:"1" type:"string"`

	// The landing directory (folder) for a user when they log in to the server
	// using the client.
	//
	// A HomeDirectory example is /bucket_name/home/mydirectory.
	HomeDirectory *string `type:"string"`

	// The type of landing directory (folder) you want your users' home directory
	// to be when they log into the server. If you set it to PATH, the user will
	// see the absolute Amazon S3 bucket or EFS paths as is in their file transfer
	// protocol clients. If you set it LOGICAL, you need to provide mappings in
	// the HomeDirectoryMappings for how you want to make Amazon S3 or EFS paths
	// visible to your users.
	HomeDirectoryType *string `type:"string" enum:"HomeDirectoryType"`

	// Specifies the Amazon Resource Name (ARN) of the IAM role that controls your
	// users' access to your Amazon S3 bucket or EFS file system. The policies attached
	// to this role determine the level of access that you want to provide your
	// users when transferring files into and out of your Amazon S3 bucket or EFS
	// file system. The IAM role should also contain a trust relationship that allows
	// the server to access your resources when servicing your users' transfer requests.
	Role *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedAccess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedAccess) GoString() string {
	return s.String()
}

// SetExternalId sets the ExternalId field's value.
func (s *ListedAccess) SetExternalId(v string) *ListedAccess {
	s.ExternalId = &v
	return s
}

// SetHomeDirectory sets the HomeDirectory field's value.
func (s *ListedAccess) SetHomeDirectory(v string) *ListedAccess {
	s.HomeDirectory = &v
	return s
}

// SetHomeDirectoryType sets the HomeDirectoryType field's value.
func (s *ListedAccess) SetHomeDirectoryType(v string) *ListedAccess {
	s.HomeDirectoryType = &v
	return s
}

// SetRole sets the Role field's value.
func (s *ListedAccess) SetRole(v string) *ListedAccess {
	s.Role = &v
	return s
}

// Returns properties of the execution that is specified.
type ListedExecution struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the execution of a workflow.
	ExecutionId *string `min:"36" type:"string"`

	// A structure that describes the Amazon S3 or EFS file location. This is the
	// file location when the execution begins: if the file is being copied, this
	// is the initial (as opposed to destination) file location.
	InitialFileLocation *FileLocation `type:"structure"`

	// A container object for the session details associated with a workflow.
	ServiceMetadata *ServiceMetadata `type:"structure"`

	// The status is one of the execution. Can be in progress, completed, exception
	// encountered, or handling the exception.
	Status *string `type:"string" enum:"ExecutionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedExecution) GoString() string {
	return s.String()
}

// SetExecutionId sets the ExecutionId field's value.
func (s *ListedExecution) SetExecutionId(v string) *ListedExecution {
	s.ExecutionId = &v
	return s
}

// SetInitialFileLocation sets the InitialFileLocation field's value.
func (s *ListedExecution) SetInitialFileLocation(v *FileLocation) *ListedExecution {
	s.InitialFileLocation = v
	return s
}

// SetServiceMetadata sets the ServiceMetadata field's value.
func (s *ListedExecution) SetServiceMetadata(v *ServiceMetadata) *ListedExecution {
	s.ServiceMetadata = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListedExecution) SetStatus(v string) *ListedExecution {
	s.Status = &v
	return s
}

// Returns properties of a file transfer protocol-enabled server that was specified.
type ListedServer struct {
	_ struct{} `type:"structure"`

	// Specifies the unique Amazon Resource Name (ARN) for a server to be listed.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// Specifies the domain of the storage system that is used for file transfers.
	Domain *string `type:"string" enum:"Domain"`

	// Specifies the type of VPC endpoint that your server is connected to. If your
	// server is connected to a VPC endpoint, your server isn't accessible over
	// the public internet.
	EndpointType *string `type:"string" enum:"EndpointType"`

	// Specifies the mode of authentication for a server. The default value is SERVICE_MANAGED,
	// which allows you to store and access user credentials within the Amazon Web
	// Services Transfer Family service.
	//
	// Use AWS_DIRECTORY_SERVICE to provide access to Active Directory groups in
	// Amazon Web Services Managed Active Directory or Microsoft Active Directory
	// in your on-premises environment or in Amazon Web Services using AD Connectors.
	// This option also requires you to provide a Directory ID using the IdentityProviderDetails
	// parameter.
	//
	// Use the API_GATEWAY value to integrate with an identity provider of your
	// choosing. The API_GATEWAY setting requires you to provide an API Gateway
	// endpoint URL to call for authentication using the IdentityProviderDetails
	// parameter.
	//
	// Use the AWS_LAMBDA value to directly use a Lambda function as your identity
	// provider. If you choose this value, you must specify the ARN for the lambda
	// function in the Function parameter for the IdentityProviderDetails data type.
	IdentityProviderType *string `type:"string" enum:"IdentityProviderType"`

	// Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity
	// and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch
	// logging for Amazon S3 or Amazon EFS events. When set, user activity can be
	// viewed in your CloudWatch logs.
	LoggingRole *string `min:"20" type:"string"`

	// Specifies the unique system assigned identifier for the servers that were
	// listed.
	ServerId *string `min:"19" type:"string"`

	// Specifies the condition of a server for the server that was described. A
	// value of ONLINE indicates that the server can accept jobs and transfer files.
	// A State value of OFFLINE means that the server cannot perform file transfer
	// operations.
	//
	// The states of STARTING and STOPPING indicate that the server is in an intermediate
	// state, either not fully able to respond, or not fully offline. The values
	// of START_FAILED or STOP_FAILED can indicate an error condition.
	State *string `type:"string" enum:"State"`

	// Specifies the number of users that are assigned to a server you specified
	// with the ServerId.
	UserCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedServer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedServer) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListedServer) SetArn(v string) *ListedServer {
	s.Arn = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *ListedServer) SetDomain(v string) *ListedServer {
	s.Domain = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *ListedServer) SetEndpointType(v string) *ListedServer {
	s.EndpointType = &v
	return s
}

// SetIdentityProviderType sets the IdentityProviderType field's value.
func (s *ListedServer) SetIdentityProviderType(v string) *ListedServer {
	s.IdentityProviderType = &v
	return s
}

// SetLoggingRole sets the LoggingRole field's value.
func (s *ListedServer) SetLoggingRole(v string) *ListedServer {
	s.LoggingRole = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *ListedServer) SetServerId(v string) *ListedServer {
	s.ServerId = &v
	return s
}

// SetState sets the State field's value.
func (s *ListedServer) SetState(v string) *ListedServer {
	s.State = &v
	return s
}

// SetUserCount sets the UserCount field's value.
func (s *ListedServer) SetUserCount(v int64) *ListedServer {
	s.UserCount = &v
	return s
}

// Returns properties of the user that you specify.
type ListedUser struct {
	_ struct{} `type:"structure"`

	// Provides the unique Amazon Resource Name (ARN) for the user that you want
	// to learn about.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// The landing directory (folder) for a user when they log in to the server
	// using the client.
	//
	// A HomeDirectory example is /bucket_name/home/mydirectory.
	HomeDirectory *string `type:"string"`

	// The type of landing directory (folder) you want your users' home directory
	// to be when they log into the server. If you set it to PATH, the user will
	// see the absolute Amazon S3 bucket or EFS paths as is in their file transfer
	// protocol clients. If you set it LOGICAL, you need to provide mappings in
	// the HomeDirectoryMappings for how you want to make Amazon S3 or EFS paths
	// visible to your users.
	HomeDirectoryType *string `type:"string" enum:"HomeDirectoryType"`

	// Specifies the Amazon Resource Name (ARN) of the IAM role that controls your
	// users' access to your Amazon S3 bucket or EFS file system. The policies attached
	// to this role determine the level of access that you want to provide your
	// users when transferring files into and out of your Amazon S3 bucket or EFS
	// file system. The IAM role should also contain a trust relationship that allows
	// the server to access your resources when servicing your users' transfer requests.
	//
	// The IAM role that controls your users' access to your Amazon S3 bucket for
	// servers with Domain=S3, or your EFS file system for servers with Domain=EFS.
	//
	// The policies attached to this role determine the level of access you want
	// to provide your users when transferring files into and out of your S3 buckets
	// or EFS file systems.
	Role *string `min:"20" type:"string"`

	// Specifies the number of SSH public keys stored for the user you specified.
	SshPublicKeyCount *int64 `type:"integer"`

	// Specifies the name of the user whose ARN was specified. User names are used
	// for authentication purposes.
	UserName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedUser) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListedUser) SetArn(v string) *ListedUser {
	s.Arn = &v
	return s
}

// SetHomeDirectory sets the HomeDirectory field's value.
func (s *ListedUser) SetHomeDirectory(v string) *ListedUser {
	s.HomeDirectory = &v
	return s
}

// SetHomeDirectoryType sets the HomeDirectoryType field's value.
func (s *ListedUser) SetHomeDirectoryType(v string) *ListedUser {
	s.HomeDirectoryType = &v
	return s
}

// SetRole sets the Role field's value.
func (s *ListedUser) SetRole(v string) *ListedUser {
	s.Role = &v
	return s
}

// SetSshPublicKeyCount sets the SshPublicKeyCount field's value.
func (s *ListedUser) SetSshPublicKeyCount(v int64) *ListedUser {
	s.SshPublicKeyCount = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ListedUser) SetUserName(v string) *ListedUser {
	s.UserName = &v
	return s
}

// Contains the ID, text description, and Amazon Resource Name (ARN) for the
// workflow.
type ListedWorkflow struct {
	_ struct{} `type:"structure"`

	// Specifies the unique Amazon Resource Name (ARN) for the workflow.
	Arn *string `min:"20" type:"string"`

	// Specifies the text description for the workflow.
	Description *string `type:"string"`

	// A unique identifier for the workflow.
	WorkflowId *string `min:"19" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedWorkflow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedWorkflow) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListedWorkflow) SetArn(v string) *ListedWorkflow {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ListedWorkflow) SetDescription(v string) *ListedWorkflow {
	s.Description = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *ListedWorkflow) SetWorkflowId(v string) *ListedWorkflow {
	s.WorkflowId = &v
	return s
}

// Consists of the logging role and the log group name.
type LoggingConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the CloudWatch logging group for the Amazon Web Services Transfer
	// server to which this workflow belongs.
	LogGroupName *string `min:"1" type:"string"`

	// Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity
	// and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch
	// logging for Amazon S3 or Amazon EFS events. When set, user activity can be
	// viewed in your CloudWatch logs.
	LoggingRole *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfiguration) GoString() string {
	return s.String()
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *LoggingConfiguration) SetLogGroupName(v string) *LoggingConfiguration {
	s.LogGroupName = &v
	return s
}

// SetLoggingRole sets the LoggingRole field's value.
func (s *LoggingConfiguration) SetLoggingRole(v string) *LoggingConfiguration {
	s.LoggingRole = &v
	return s
}

// The full POSIX identity, including user ID (Uid), group ID (Gid), and any
// secondary groups IDs (SecondaryGids), that controls your users' access to
// your Amazon EFS file systems. The POSIX permissions that are set on files
// and directories in your file system determine the level of access your users
// get when transferring files into and out of your Amazon EFS file systems.
type PosixProfile struct {
	_ struct{} `type:"structure"`

	// The POSIX group ID used for all EFS operations by this user.
	//
	// Gid is a required field
	Gid *int64 `type:"long" required:"true"`

	// The secondary POSIX group IDs used for all EFS operations by this user.
	SecondaryGids []*int64 `type:"list"`

	// The POSIX user ID used for all EFS operations by this user.
	//
	// Uid is a required field
	Uid *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PosixProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PosixProfile) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PosixProfile) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PosixProfile"}
	if s.Gid == nil {
		invalidParams.Add(request.NewErrParamRequired("Gid"))
	}
	if s.Uid == nil {
		invalidParams.Add(request.NewErrParamRequired("Uid"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGid sets the Gid field's value.
func (s *PosixProfile) SetGid(v int64) *PosixProfile {
	s.Gid = &v
	return s
}

// SetSecondaryGids sets the SecondaryGids field's value.
func (s *PosixProfile) SetSecondaryGids(v []*int64) *PosixProfile {
	s.SecondaryGids = v
	return s
}

// SetUid sets the Uid field's value.
func (s *PosixProfile) SetUid(v int64) *PosixProfile {
	s.Uid = &v
	return s
}

// The protocol settings that are configured for your server.
type ProtocolDetails struct {
	_ struct{} `type:"structure"`

	// Indicates passive mode, for FTP and FTPS protocols. Enter a single dotted-quad
	// IPv4 address, such as the external IP address of a firewall, router, or load
	// balancer. For example:
	//
	// aws transfer update-server --protocol-details PassiveIp=0.0.0.0
	//
	// Replace 0.0.0.0 in the example above with the actual IP address you want
	// to use.
	//
	// If you change the PassiveIp value, you must stop and then restart your Transfer
	// server for the change to take effect. For details on using Passive IP (PASV)
	// in a NAT environment, see Configuring your FTPS server behind a firewall
	// or NAT with Amazon Web Services Transfer Family (http://aws.amazon.com/blogs/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/).
	PassiveIp *string `type:"string"`

	// Use the SetStatOption to ignore the error that is generated when the client
	// attempts to use SETSTAT on a file you are uploading to an S3 bucket.
	//
	// Some SFTP file transfer clients can attempt to change the attributes of remote
	// files, including timestamp and permissions, using commands, such as SETSTAT
	// when uploading the file. However, these commands are not compatible with
	// object storage systems, such as Amazon S3. Due to this incompatibility, file
	// uploads from these clients can result in errors even when the file is otherwise
	// successfully uploaded.
	//
	// Set the value to ENABLE_NO_OP to have the Transfer Family server ignore the
	// SETSTAT command, and upload files without needing to make any changes to
	// your SFTP client. While the SetStatOption ENABLE_NO_OP setting ignores the
	// error, it does generate a log entry in CloudWatch Logs, so you can determine
	// when the client is making a SETSTAT call.
	//
	// If you want to preserve the original timestamp for your file, and modify
	// other file attributes using SETSTAT, you can use Amazon EFS as backend storage
	// with Transfer Family.
	SetStatOption *string `type:"string" enum:"SetStatOption"`

	// A property used with Transfer servers that use the FTPS protocol. TLS Session
	// Resumption provides a mechanism to resume or share a negotiated secret key
	// between the control and data connection for an FTPS session. TlsSessionResumptionMode
	// determines whether or not the server resumes recent, negotiated sessions
	// through a unique session ID. This property is available during CreateServer
	// and UpdateServer calls. If a TlsSessionResumptionMode value is not specified
	// during CreateServer, it is set to ENFORCED by default.
	//
	//    * DISABLED: the server does not process TLS session resumption client
	//    requests and creates a new TLS session for each request.
	//
	//    * ENABLED: the server processes and accepts clients that are performing
	//    TLS session resumption. The server doesn't reject client data connections
	//    that do not perform the TLS session resumption client processing.
	//
	//    * ENFORCED: the server processes and accepts clients that are performing
	//    TLS session resumption. The server rejects client data connections that
	//    do not perform the TLS session resumption client processing. Before you
	//    set the value to ENFORCED, test your clients. Not all FTPS clients perform
	//    TLS session resumption. So, if you choose to enforce TLS session resumption,
	//    you prevent any connections from FTPS clients that don't perform the protocol
	//    negotiation. To determine whether or not you can use the ENFORCED value,
	//    you need to test your clients.
	TlsSessionResumptionMode *string `type:"string" enum:"TlsSessionResumptionMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtocolDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtocolDetails) GoString() string {
	return s.String()
}

// SetPassiveIp sets the PassiveIp field's value.
func (s *ProtocolDetails) SetPassiveIp(v string) *ProtocolDetails {
	s.PassiveIp = &v
	return s
}

// SetSetStatOption sets the SetStatOption field's value.
func (s *ProtocolDetails) SetSetStatOption(v string) *ProtocolDetails {
	s.SetStatOption = &v
	return s
}

// SetTlsSessionResumptionMode sets the TlsSessionResumptionMode field's value.
func (s *ProtocolDetails) SetTlsSessionResumptionMode(v string) *ProtocolDetails {
	s.TlsSessionResumptionMode = &v
	return s
}

// The requested resource does not exist.
type ResourceExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Resource is a required field
	Resource *string `type:"string" required:"true"`

	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceExistsException) GoString() string {
	return s.String()
}

func newErrorResourceExistsException(v protocol.ResponseMetadata) error {
	return &ResourceExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceExistsException) Code() string {
	return "ResourceExistsException"
}

// Message returns the exception's message.
func (s *ResourceExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceExistsException) OrigErr() error {
	return nil
}

func (s *ResourceExistsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer
// Family service.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Resource is a required field
	Resource *string `type:"string" required:"true"`

	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies the details for the file location for the file being used in the
// workflow. Only applicable if you are using S3 storage.
type S3FileLocation struct {
	_ struct{} `type:"structure"`

	// Specifies the S3 bucket that contains the file being used.
	Bucket *string `min:"3" type:"string"`

	// The entity tag is a hash of the object. The ETag reflects changes only to
	// the contents of an object, not its metadata.
	Etag *string `min:"1" type:"string"`

	// The name assigned to the file when it was created in S3. You use the object
	// key to retrieve the object.
	Key *string `type:"string"`

	// Specifies the file version.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3FileLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3FileLocation) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *S3FileLocation) SetBucket(v string) *S3FileLocation {
	s.Bucket = &v
	return s
}

// SetEtag sets the Etag field's value.
func (s *S3FileLocation) SetEtag(v string) *S3FileLocation {
	s.Etag = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3FileLocation) SetKey(v string) *S3FileLocation {
	s.Key = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *S3FileLocation) SetVersionId(v string) *S3FileLocation {
	s.VersionId = &v
	return s
}

// Specifies the customer input S3 file location. If it is used inside copyStepDetails.DestinationFileLocation,
// it should be the S3 copy destination.
//
// You need to provide the bucket and key. The key can represent either a path
// or a file. This is determined by whether or not you end the key value with
// the forward slash (/) character. If the final character is "/", then your
// file is copied to the folder, and its name does not change. If, rather, the
// final character is alphanumeric, your uploaded file is renamed to the path
// value. In this case, if a file with that name already exists, it is overwritten.
//
// For example, if your path is shared-files/bob/, your uploaded files are copied
// to the shared-files/bob/, folder. If your path is shared-files/today, each
// uploaded file is copied to the shared-files folder and named today: each
// upload overwrites the previous version of the bob file.
type S3InputFileLocation struct {
	_ struct{} `type:"structure"`

	// Specifies the S3 bucket for the customer input file.
	Bucket *string `min:"3" type:"string"`

	// The name assigned to the file when it was created in S3. You use the object
	// key to retrieve the object.
	Key *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3InputFileLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3InputFileLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3InputFileLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3InputFileLocation"}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3InputFileLocation) SetBucket(v string) *S3InputFileLocation {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3InputFileLocation) SetKey(v string) *S3InputFileLocation {
	s.Key = &v
	return s
}

// Specifies the key-value pair that are assigned to a file during the execution
// of a Tagging step.
type S3Tag struct {
	_ struct{} `type:"structure"`

	// The name assigned to the tag that you create.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value that corresponds to the key.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *S3Tag) SetKey(v string) *S3Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *S3Tag) SetValue(v string) *S3Tag {
	s.Value = &v
	return s
}

type SendWorkflowStepStateInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the execution of a workflow.
	//
	// ExecutionId is a required field
	ExecutionId *string `min:"36" type:"string" required:"true"`

	// Indicates whether the specified step succeeded or failed.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"CustomStepStatus"`

	// Used to distinguish between multiple callbacks for multiple Lambda steps
	// within the same execution.
	//
	// Token is a required field
	Token *string `min:"1" type:"string" required:"true"`

	// A unique identifier for the workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendWorkflowStepStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendWorkflowStepStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendWorkflowStepStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendWorkflowStepStateInput"}
	if s.ExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionId"))
	}
	if s.ExecutionId != nil && len(*s.ExecutionId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionId", 36))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.Token == nil {
		invalidParams.Add(request.NewErrParamRequired("Token"))
	}
	if s.Token != nil && len(*s.Token) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Token", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExecutionId sets the ExecutionId field's value.
func (s *SendWorkflowStepStateInput) SetExecutionId(v string) *SendWorkflowStepStateInput {
	s.ExecutionId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SendWorkflowStepStateInput) SetStatus(v string) *SendWorkflowStepStateInput {
	s.Status = &v
	return s
}

// SetToken sets the Token field's value.
func (s *SendWorkflowStepStateInput) SetToken(v string) *SendWorkflowStepStateInput {
	s.Token = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *SendWorkflowStepStateInput) SetWorkflowId(v string) *SendWorkflowStepStateInput {
	s.WorkflowId = &v
	return s
}

type SendWorkflowStepStateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendWorkflowStepStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendWorkflowStepStateOutput) GoString() string {
	return s.String()
}

// A container object for the session details associated with a workflow.
type ServiceMetadata struct {
	_ struct{} `type:"structure"`

	// The Server ID (ServerId), Session ID (SessionId) and user (UserName) make
	// up the UserDetails.
	//
	// UserDetails is a required field
	UserDetails *UserDetails `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceMetadata) GoString() string {
	return s.String()
}

// SetUserDetails sets the UserDetails field's value.
func (s *ServiceMetadata) SetUserDetails(v *UserDetails) *ServiceMetadata {
	s.UserDetails = v
	return s
}

// The request has failed because the Amazon Web ServicesTransfer Family service
// is not available.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information about the public Secure Shell (SSH) key that is associated
// with a user account for the specific file transfer protocol-enabled server
// (as identified by ServerId). The information returned includes the date the
// key was imported, the public key contents, and the public key ID. A user
// can store more than one SSH public key associated with their user name on
// a specific server.
type SshPublicKey struct {
	_ struct{} `type:"structure"`

	// Specifies the date that the public key was added to the user account.
	//
	// DateImported is a required field
	DateImported *time.Time `type:"timestamp" required:"true"`

	// Specifies the content of the SSH public key as specified by the PublicKeyId.
	//
	// SshPublicKeyBody is a required field
	SshPublicKeyBody *string `type:"string" required:"true"`

	// Specifies the SshPublicKeyId parameter contains the identifier of the public
	// key.
	//
	// SshPublicKeyId is a required field
	SshPublicKeyId *string `min:"21" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SshPublicKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SshPublicKey) GoString() string {
	return s.String()
}

// SetDateImported sets the DateImported field's value.
func (s *SshPublicKey) SetDateImported(v time.Time) *SshPublicKey {
	s.DateImported = &v
	return s
}

// SetSshPublicKeyBody sets the SshPublicKeyBody field's value.
func (s *SshPublicKey) SetSshPublicKeyBody(v string) *SshPublicKey {
	s.SshPublicKeyBody = &v
	return s
}

// SetSshPublicKeyId sets the SshPublicKeyId field's value.
func (s *SshPublicKey) SetSshPublicKeyId(v string) *SshPublicKey {
	s.SshPublicKeyId = &v
	return s
}

type StartServerInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a server that you start.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartServerInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *StartServerInput) SetServerId(v string) *StartServerInput {
	s.ServerId = &v
	return s
}

type StartServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartServerOutput) GoString() string {
	return s.String()
}

type StopServerInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a server that you stopped.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopServerInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *StopServerInput) SetServerId(v string) *StopServerInput {
	s.ServerId = &v
	return s
}

type StopServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopServerOutput) GoString() string {
	return s.String()
}

// Creates a key-value pair for a specific resource. Tags are metadata that
// you can use to search for and group a resource for various purposes. You
// can apply tags to servers, users, and roles. A tag key can take more than
// one value. For example, to group servers for accounting purposes, you might
// create a tag called Group and assign the values Research and Accounting to
// that group.
type Tag struct {
	_ struct{} `type:"structure"`

	// The name assigned to the tag that you create.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// Contains one or more values that you assigned to the key name you create.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) for a specific Amazon Web Services resource,
	// such as a server, user, or role.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// Key-value pairs assigned to ARNs that you can use to group and search for
	// resources by type. You can attach this metadata to user accounts for any
	// purpose.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *TagResourceInput) SetArn(v string) *TagResourceInput {
	s.Arn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Each step type has its own StepDetails structure.
//
// The key/value pairs used to tag a file during the execution of a workflow
// step.
type TagStepDetails struct {
	_ struct{} `type:"structure"`

	// The name of the step, used as an identifier.
	Name *string `type:"string"`

	// Specifies which file to use as input to the workflow step: either the output
	// from the previous step, or the originally uploaded file for the workflow.
	//
	//    * Enter ${previous.file} to use the previous file as the input. In this
	//    case, this workflow step uses the output file from the previous workflow
	//    step as input. This is the default value.
	//
	//    * Enter ${original.file} to use the originally-uploaded file location
	//    as input for this step.
	SourceFileLocation *string `type:"string"`

	// Array that contains from 1 to 10 key/value pairs.
	Tags []*S3Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagStepDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagStepDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagStepDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagStepDetails"}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *TagStepDetails) SetName(v string) *TagStepDetails {
	s.Name = &v
	return s
}

// SetSourceFileLocation sets the SourceFileLocation field's value.
func (s *TagStepDetails) SetSourceFileLocation(v string) *TagStepDetails {
	s.SourceFileLocation = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagStepDetails) SetTags(v []*S3Tag) *TagStepDetails {
	s.Tags = v
	return s
}

type TestIdentityProviderInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned identifier for a specific server. That server's user authentication
	// method is tested with a user name and password.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// The type of file transfer protocol to be tested.
	//
	// The available protocols are:
	//
	//    * Secure Shell (SSH) File Transfer Protocol (SFTP)
	//
	//    * File Transfer Protocol Secure (FTPS)
	//
	//    * File Transfer Protocol (FTP)
	ServerProtocol *string `type:"string" enum:"Protocol"`

	// The source IP address of the user account to be tested.
	SourceIp *string `type:"string"`

	// The name of the user account to be tested.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`

	// The password of the user account to be tested.
	//
	// UserPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TestIdentityProviderInput's
	// String and GoString methods.
	UserPassword *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestIdentityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestIdentityProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestIdentityProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestIdentityProviderInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *TestIdentityProviderInput) SetServerId(v string) *TestIdentityProviderInput {
	s.ServerId = &v
	return s
}

// SetServerProtocol sets the ServerProtocol field's value.
func (s *TestIdentityProviderInput) SetServerProtocol(v string) *TestIdentityProviderInput {
	s.ServerProtocol = &v
	return s
}

// SetSourceIp sets the SourceIp field's value.
func (s *TestIdentityProviderInput) SetSourceIp(v string) *TestIdentityProviderInput {
	s.SourceIp = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *TestIdentityProviderInput) SetUserName(v string) *TestIdentityProviderInput {
	s.UserName = &v
	return s
}

// SetUserPassword sets the UserPassword field's value.
func (s *TestIdentityProviderInput) SetUserPassword(v string) *TestIdentityProviderInput {
	s.UserPassword = &v
	return s
}

type TestIdentityProviderOutput struct {
	_ struct{} `type:"structure"`

	// A message that indicates whether the test was successful or not.
	//
	// If an empty string is returned, the most likely cause is that the authentication
	// failed due to an incorrect username or password.
	Message *string `type:"string"`

	// The response that is returned from your API Gateway.
	Response *string `type:"string"`

	// The HTTP status code that is the response from your API Gateway.
	//
	// StatusCode is a required field
	StatusCode *int64 `type:"integer" required:"true"`

	// The endpoint of the service used to authenticate a user.
	//
	// Url is a required field
	Url *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestIdentityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestIdentityProviderOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *TestIdentityProviderOutput) SetMessage(v string) *TestIdentityProviderOutput {
	s.Message = &v
	return s
}

// SetResponse sets the Response field's value.
func (s *TestIdentityProviderOutput) SetResponse(v string) *TestIdentityProviderOutput {
	s.Response = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *TestIdentityProviderOutput) SetStatusCode(v int64) *TestIdentityProviderOutput {
	s.StatusCode = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *TestIdentityProviderOutput) SetUrl(v string) *TestIdentityProviderOutput {
	s.Url = &v
	return s
}

// The request was denied due to request throttling.
//
// HTTP Status Code: 400
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	RetryAfterSeconds *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The value of the resource that will have the tag removed. An Amazon Resource
	// Name (ARN) is an identifier for a specific Amazon Web Services resource,
	// such as a server, user, or role.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// TagKeys are key-value pairs assigned to ARNs that can be used to group and
	// search for resources by type. This metadata can be attached to resources
	// for any purpose.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UntagResourceInput) SetArn(v string) *UntagResourceInput {
	s.Arn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAccessInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that is required to identify specific groups within your
	// directory. The users of the group that you associate have access to your
	// Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon
	// Web Services Transfer Family. If you know the group name, you can view the
	// SID values by running the following command using Windows PowerShell.
	//
	// Get-ADGroup -Filter {samAccountName -like "YourGroupName*"} -Properties *
	// | Select SamAccountName,ObjectSid
	//
	// In that command, replace YourGroupName with the name of your Active Directory
	// group.
	//
	// The regex used to validate this parameter is a string of characters consisting
	// of uppercase and lowercase alphanumeric characters with no spaces. You can
	// also include underscores or any of the following characters: =,.@:/-
	//
	// ExternalId is a required field
	ExternalId *string `min:"1" type:"string" required:"true"`

	// The landing directory (folder) for a user when they log in to the server
	// using the client.
	//
	// A HomeDirectory example is /bucket_name/home/mydirectory.
	HomeDirectory *string `type:"string"`

	// Logical directory mappings that specify what Amazon S3 or Amazon EFS paths
	// and keys should be visible to your user and how you want to make them visible.
	// You must specify the Entry and Target pair, where Entry shows how the path
	// is made visible and Target is the actual Amazon S3 or Amazon EFS path. If
	// you only specify a target, it is displayed as is. You also must ensure that
	// your Amazon Web Services Identity and Access Management (IAM) role provides
	// access to paths in Target. This value can only be set when HomeDirectoryType
	// is set to LOGICAL.
	//
	// The following is an Entry and Target pair example.
	//
	// [ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]
	//
	// In most cases, you can use this value instead of the session policy to lock
	// down your user to the designated home directory ("chroot"). To do this, you
	// can set Entry to / and set Target to the HomeDirectory parameter value.
	//
	// The following is an Entry and Target pair example for chroot.
	//
	// [ { "Entry": "/", "Target": "/bucket_name/home/mydirectory" } ]
	HomeDirectoryMappings []*HomeDirectoryMapEntry `min:"1" type:"list"`

	// The type of landing directory (folder) you want your users' home directory
	// to be when they log into the server. If you set it to PATH, the user will
	// see the absolute Amazon S3 bucket or EFS paths as is in their file transfer
	// protocol clients. If you set it LOGICAL, you need to provide mappings in
	// the HomeDirectoryMappings for how you want to make Amazon S3 or EFS paths
	// visible to your users.
	HomeDirectoryType *string `type:"string" enum:"HomeDirectoryType"`

	// A session policy for your user so that you can use the same IAM role across
	// multiple users. This policy scopes down user access to portions of their
	// Amazon S3 bucket. Variables that you can use inside this policy include ${Transfer:UserName},
	// ${Transfer:HomeDirectory}, and ${Transfer:HomeBucket}.
	//
	// This only applies when the domain of ServerId is S3. EFS does not use session
	// policies.
	//
	// For session policies, Amazon Web Services Transfer Family stores the policy
	// as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy.
	// You save the policy as a JSON blob and pass it in the Policy argument.
	//
	// For an example of a session policy, see Example session policy (https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html).
	//
	// For more information, see AssumeRole (https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html)
	// in the Amazon Web ServicesSecurity Token Service API Reference.
	Policy *string `type:"string"`

	// The full POSIX identity, including user ID (Uid), group ID (Gid), and any
	// secondary groups IDs (SecondaryGids), that controls your users' access to
	// your Amazon EFS file systems. The POSIX permissions that are set on files
	// and directories in your file system determine the level of access your users
	// get when transferring files into and out of your Amazon EFS file systems.
	PosixProfile *PosixProfile `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the IAM role that controls your
	// users' access to your Amazon S3 bucket or EFS file system. The policies attached
	// to this role determine the level of access that you want to provide your
	// users when transferring files into and out of your Amazon S3 bucket or EFS
	// file system. The IAM role should also contain a trust relationship that allows
	// the server to access your resources when servicing your users' transfer requests.
	Role *string `min:"20" type:"string"`

	// A system-assigned unique identifier for a server instance. This is the specific
	// server that you added your user to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAccessInput"}
	if s.ExternalId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalId"))
	}
	if s.ExternalId != nil && len(*s.ExternalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalId", 1))
	}
	if s.HomeDirectoryMappings != nil && len(s.HomeDirectoryMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HomeDirectoryMappings", 1))
	}
	if s.Role != nil && len(*s.Role) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Role", 20))
	}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}
	if s.HomeDirectoryMappings != nil {
		for i, v := range s.HomeDirectoryMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HomeDirectoryMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PosixProfile != nil {
		if err := s.PosixProfile.Validate(); err != nil {
			invalidParams.AddNested("PosixProfile", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalId sets the ExternalId field's value.
func (s *UpdateAccessInput) SetExternalId(v string) *UpdateAccessInput {
	s.ExternalId = &v
	return s
}

// SetHomeDirectory sets the HomeDirectory field's value.
func (s *UpdateAccessInput) SetHomeDirectory(v string) *UpdateAccessInput {
	s.HomeDirectory = &v
	return s
}

// SetHomeDirectoryMappings sets the HomeDirectoryMappings field's value.
func (s *UpdateAccessInput) SetHomeDirectoryMappings(v []*HomeDirectoryMapEntry) *UpdateAccessInput {
	s.HomeDirectoryMappings = v
	return s
}

// SetHomeDirectoryType sets the HomeDirectoryType field's value.
func (s *UpdateAccessInput) SetHomeDirectoryType(v string) *UpdateAccessInput {
	s.HomeDirectoryType = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *UpdateAccessInput) SetPolicy(v string) *UpdateAccessInput {
	s.Policy = &v
	return s
}

// SetPosixProfile sets the PosixProfile field's value.
func (s *UpdateAccessInput) SetPosixProfile(v *PosixProfile) *UpdateAccessInput {
	s.PosixProfile = v
	return s
}

// SetRole sets the Role field's value.
func (s *UpdateAccessInput) SetRole(v string) *UpdateAccessInput {
	s.Role = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *UpdateAccessInput) SetServerId(v string) *UpdateAccessInput {
	s.ServerId = &v
	return s
}

type UpdateAccessOutput struct {
	_ struct{} `type:"structure"`

	// The external ID of the group whose users have access to your Amazon S3 or
	// Amazon EFS resources over the enabled protocols using Amazon Web ServicesTransfer
	// Family.
	//
	// ExternalId is a required field
	ExternalId *string `min:"1" type:"string" required:"true"`

	// The ID of the server that the user is attached to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessOutput) GoString() string {
	return s.String()
}

// SetExternalId sets the ExternalId field's value.
func (s *UpdateAccessOutput) SetExternalId(v string) *UpdateAccessOutput {
	s.ExternalId = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *UpdateAccessOutput) SetServerId(v string) *UpdateAccessOutput {
	s.ServerId = &v
	return s
}

type UpdateServerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Web ServicesCertificate Manager
	// (ACM) certificate. Required when Protocols is set to FTPS.
	//
	// To request a new public certificate, see Request a public certificate (https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html)
	// in the Amazon Web ServicesCertificate Manager User Guide.
	//
	// To import an existing certificate into ACM, see Importing certificates into
	// ACM (https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html)
	// in the Amazon Web ServicesCertificate Manager User Guide.
	//
	// To request a private certificate to use FTPS through private IP addresses,
	// see Request a private certificate (https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html)
	// in the Amazon Web ServicesCertificate Manager User Guide.
	//
	// Certificates with the following cryptographic algorithms and key sizes are
	// supported:
	//
	//    * 2048-bit RSA (RSA_2048)
	//
	//    * 4096-bit RSA (RSA_4096)
	//
	//    * Elliptic Prime Curve 256 bit (EC_prime256v1)
	//
	//    * Elliptic Prime Curve 384 bit (EC_secp384r1)
	//
	//    * Elliptic Prime Curve 521 bit (EC_secp521r1)
	//
	// The certificate must be a valid SSL/TLS X.509 version 3 certificate with
	// FQDN or IP address specified and information about the issuer.
	Certificate *string `type:"string"`

	// The virtual private cloud (VPC) endpoint settings that are configured for
	// your server. When you host your endpoint within your VPC, you can make it
	// accessible only to resources within your VPC, or you can attach Elastic IP
	// addresses and make it accessible to clients over the internet. Your VPC's
	// default security groups are automatically assigned to your endpoint.
	EndpointDetails *EndpointDetails `type:"structure"`

	// The type of endpoint that you want your server to use. You can choose to
	// make your server's endpoint publicly accessible (PUBLIC) or host it inside
	// your VPC. With an endpoint that is hosted in a VPC, you can restrict access
	// to your server and resources only within your VPC or choose to make it internet
	// facing by attaching Elastic IP addresses directly to it.
	//
	// After May 19, 2021, you won't be able to create a server using EndpointType=VPC_ENDPOINT
	// in your Amazon Web Servicesaccount if your account hasn't already done so
	// before May 19, 2021. If you have already created servers with EndpointType=VPC_ENDPOINT
	// in your Amazon Web Servicesaccount on or before May 19, 2021, you will not
	// be affected. After this date, use EndpointType=VPC.
	//
	// For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.
	//
	// It is recommended that you use VPC as the EndpointType. With this endpoint
	// type, you have the option to directly associate up to three Elastic IPv4
	// addresses (BYO IP included) with your server's endpoint and use VPC security
	// groups to restrict traffic by the client's public IP address. This is not
	// possible with EndpointType set to VPC_ENDPOINT.
	EndpointType *string `type:"string" enum:"EndpointType"`

	// The RSA private key as generated by ssh-keygen -N "" -m PEM -f my-new-server-key.
	//
	// If you aren't planning to migrate existing users from an existing server
	// to a new server, don't update the host key. Accidentally changing a server's
	// host key can be disruptive.
	//
	// For more information, see Change the host key for your SFTP-enabled server
	// (https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key)
	// in the Amazon Web ServicesTransfer Family User Guide.
	//
	// HostKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateServerInput's
	// String and GoString methods.
	HostKey *string `type:"string" sensitive:"true"`

	// An array containing all of the information required to call a customer's
	// authentication API method.
	IdentityProviderDetails *IdentityProviderDetails `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity
	// and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch
	// logging for Amazon S3 or Amazon EFS events. When set, user activity can be
	// viewed in your CloudWatch logs.
	LoggingRole *string `type:"string"`

	// Specify a string to display when users connect to a server. This string is
	// displayed after the user authenticates.
	//
	// The SFTP protocol does not support post-authentication display banners.
	PostAuthenticationLoginBanner *string `type:"string"`

	// Specify a string to display when users connect to a server. This string is
	// displayed before the user authenticates. For example, the following banner
	// displays details about using the system.
	//
	// This system is for the use of authorized users only. Individuals using this
	// computer system without authority, or in excess of their authority, are subject
	// to having all of their activities on this system monitored and recorded by
	// system personnel.
	PreAuthenticationLoginBanner *string `type:"string"`

	// The protocol settings that are configured for your server.
	//
	//    * Use the PassiveIp parameter to indicate passive mode (for FTP and FTPS
	//    protocols). Enter a single dotted-quad IPv4 address, such as the external
	//    IP address of a firewall, router, or load balancer.
	//
	//    * Use the SetStatOption to ignore the error that is generated when the
	//    client attempts to use SETSTAT on a file you are uploading to an S3 bucket.
	//    Set the value to ENABLE_NO_OP to have the Transfer Family server ignore
	//    the SETSTAT command, and upload files without needing to make any changes
	//    to your SFTP client. Note that with SetStatOption set to ENABLE_NO_OP,
	//    Transfer generates a log entry to CloudWatch Logs, so you can determine
	//    when the client is making a SETSTAT call.
	//
	//    * Use the TlsSessionResumptionMode parameter to determine whether or not
	//    your Transfer server resumes recent, negotiated sessions through a unique
	//    session ID.
	ProtocolDetails *ProtocolDetails `type:"structure"`

	// Specifies the file transfer protocol or protocols over which your file transfer
	// protocol client can connect to your server's endpoint. The available protocols
	// are:
	//
	//    * Secure Shell (SSH) File Transfer Protocol (SFTP): File transfer over
	//    SSH
	//
	//    * File Transfer Protocol Secure (FTPS): File transfer with TLS encryption
	//
	//    * File Transfer Protocol (FTP): Unencrypted file transfer
	//
	// If you select FTPS, you must choose a certificate stored in Amazon Web ServicesCertificate
	// Manager (ACM) which will be used to identify your server when clients connect
	// to it over FTPS.
	//
	// If Protocol includes either FTP or FTPS, then the EndpointType must be VPC
	// and the IdentityProviderType must be AWS_DIRECTORY_SERVICE or API_GATEWAY.
	//
	// If Protocol includes FTP, then AddressAllocationIds cannot be associated.
	//
	// If Protocol is set only to SFTP, the EndpointType can be set to PUBLIC and
	// the IdentityProviderType can be set to SERVICE_MANAGED.
	Protocols []*string `min:"1" type:"list" enum:"Protocol"`

	// Specifies the name of the security policy that is attached to the server.
	SecurityPolicyName *string `type:"string"`

	// A system-assigned unique identifier for a server instance that the user account
	// is assigned to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// Specifies the workflow ID for the workflow to assign and the execution role
	// used for executing the workflow.
	//
	// To remove an associated workflow from a server, you can provide an empty
	// OnUpload object, as in the following example.
	//
	// aws transfer update-server --server-id s-01234567890abcdef --workflow-details
	// '{"OnUpload":[]}'
	WorkflowDetails *WorkflowDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServerInput"}
	if s.Protocols != nil && len(s.Protocols) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Protocols", 1))
	}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}
	if s.EndpointDetails != nil {
		if err := s.EndpointDetails.Validate(); err != nil {
			invalidParams.AddNested("EndpointDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.IdentityProviderDetails != nil {
		if err := s.IdentityProviderDetails.Validate(); err != nil {
			invalidParams.AddNested("IdentityProviderDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.WorkflowDetails != nil {
		if err := s.WorkflowDetails.Validate(); err != nil {
			invalidParams.AddNested("WorkflowDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificate sets the Certificate field's value.
func (s *UpdateServerInput) SetCertificate(v string) *UpdateServerInput {
	s.Certificate = &v
	return s
}

// SetEndpointDetails sets the EndpointDetails field's value.
func (s *UpdateServerInput) SetEndpointDetails(v *EndpointDetails) *UpdateServerInput {
	s.EndpointDetails = v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *UpdateServerInput) SetEndpointType(v string) *UpdateServerInput {
	s.EndpointType = &v
	return s
}

// SetHostKey sets the HostKey field's value.
func (s *UpdateServerInput) SetHostKey(v string) *UpdateServerInput {
	s.HostKey = &v
	return s
}

// SetIdentityProviderDetails sets the IdentityProviderDetails field's value.
func (s *UpdateServerInput) SetIdentityProviderDetails(v *IdentityProviderDetails) *UpdateServerInput {
	s.IdentityProviderDetails = v
	return s
}

// SetLoggingRole sets the LoggingRole field's value.
func (s *UpdateServerInput) SetLoggingRole(v string) *UpdateServerInput {
	s.LoggingRole = &v
	return s
}

// SetPostAuthenticationLoginBanner sets the PostAuthenticationLoginBanner field's value.
func (s *UpdateServerInput) SetPostAuthenticationLoginBanner(v string) *UpdateServerInput {
	s.PostAuthenticationLoginBanner = &v
	return s
}

// SetPreAuthenticationLoginBanner sets the PreAuthenticationLoginBanner field's value.
func (s *UpdateServerInput) SetPreAuthenticationLoginBanner(v string) *UpdateServerInput {
	s.PreAuthenticationLoginBanner = &v
	return s
}

// SetProtocolDetails sets the ProtocolDetails field's value.
func (s *UpdateServerInput) SetProtocolDetails(v *ProtocolDetails) *UpdateServerInput {
	s.ProtocolDetails = v
	return s
}

// SetProtocols sets the Protocols field's value.
func (s *UpdateServerInput) SetProtocols(v []*string) *UpdateServerInput {
	s.Protocols = v
	return s
}

// SetSecurityPolicyName sets the SecurityPolicyName field's value.
func (s *UpdateServerInput) SetSecurityPolicyName(v string) *UpdateServerInput {
	s.SecurityPolicyName = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *UpdateServerInput) SetServerId(v string) *UpdateServerInput {
	s.ServerId = &v
	return s
}

// SetWorkflowDetails sets the WorkflowDetails field's value.
func (s *UpdateServerInput) SetWorkflowDetails(v *WorkflowDetails) *UpdateServerInput {
	s.WorkflowDetails = v
	return s
}

type UpdateServerOutput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a server that the user account is
	// assigned to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServerOutput) GoString() string {
	return s.String()
}

// SetServerId sets the ServerId field's value.
func (s *UpdateServerOutput) SetServerId(v string) *UpdateServerOutput {
	s.ServerId = &v
	return s
}

type UpdateUserInput struct {
	_ struct{} `type:"structure"`

	// The landing directory (folder) for a user when they log in to the server
	// using the client.
	//
	// A HomeDirectory example is /bucket_name/home/mydirectory.
	HomeDirectory *string `type:"string"`

	// Logical directory mappings that specify what Amazon S3 or Amazon EFS paths
	// and keys should be visible to your user and how you want to make them visible.
	// You must specify the Entry and Target pair, where Entry shows how the path
	// is made visible and Target is the actual Amazon S3 or Amazon EFS path. If
	// you only specify a target, it is displayed as is. You also must ensure that
	// your Amazon Web Services Identity and Access Management (IAM) role provides
	// access to paths in Target. This value can only be set when HomeDirectoryType
	// is set to LOGICAL.
	//
	// The following is an Entry and Target pair example.
	//
	// [ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]
	//
	// In most cases, you can use this value instead of the session policy to lock
	// down your user to the designated home directory ("chroot"). To do this, you
	// can set Entry to '/' and set Target to the HomeDirectory parameter value.
	//
	// The following is an Entry and Target pair example for chroot.
	//
	// [ { "Entry": "/", "Target": "/bucket_name/home/mydirectory" } ]
	HomeDirectoryMappings []*HomeDirectoryMapEntry `min:"1" type:"list"`

	// The type of landing directory (folder) you want your users' home directory
	// to be when they log into the server. If you set it to PATH, the user will
	// see the absolute Amazon S3 bucket or EFS paths as is in their file transfer
	// protocol clients. If you set it LOGICAL, you need to provide mappings in
	// the HomeDirectoryMappings for how you want to make Amazon S3 or EFS paths
	// visible to your users.
	HomeDirectoryType *string `type:"string" enum:"HomeDirectoryType"`

	// A session policy for your user so that you can use the same IAM role across
	// multiple users. This policy scopes down user access to portions of their
	// Amazon S3 bucket. Variables that you can use inside this policy include ${Transfer:UserName},
	// ${Transfer:HomeDirectory}, and ${Transfer:HomeBucket}.
	//
	// This only applies when the domain of ServerId is S3. EFS does not use session
	// policies.
	//
	// For session policies, Amazon Web Services Transfer Family stores the policy
	// as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy.
	// You save the policy as a JSON blob and pass it in the Policy argument.
	//
	// For an example of a session policy, see Creating a session policy (https://docs.aws.amazon.com/transfer/latest/userguide/session-policy).
	//
	// For more information, see AssumeRole (https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html)
	// in the Amazon Web Services Security Token Service API Reference.
	Policy *string `type:"string"`

	// Specifies the full POSIX identity, including user ID (Uid), group ID (Gid),
	// and any secondary groups IDs (SecondaryGids), that controls your users' access
	// to your Amazon Elastic File Systems (Amazon EFS). The POSIX permissions that
	// are set on files and directories in your file system determines the level
	// of access your users get when transferring files into and out of your Amazon
	// EFS file systems.
	PosixProfile *PosixProfile `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the IAM role that controls your
	// users' access to your Amazon S3 bucket or EFS file system. The policies attached
	// to this role determine the level of access that you want to provide your
	// users when transferring files into and out of your Amazon S3 bucket or EFS
	// file system. The IAM role should also contain a trust relationship that allows
	// the server to access your resources when servicing your users' transfer requests.
	Role *string `min:"20" type:"string"`

	// A system-assigned unique identifier for a server instance that the user account
	// is assigned to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// A unique string that identifies a user and is associated with a server as
	// specified by the ServerId. This user name must be a minimum of 3 and a maximum
	// of 100 characters long. The following are valid characters: a-z, A-Z, 0-9,
	// underscore '_', hyphen '-', period '.', and at sign '@'. The user name can't
	// start with a hyphen, period, or at sign.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserInput"}
	if s.HomeDirectoryMappings != nil && len(s.HomeDirectoryMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HomeDirectoryMappings", 1))
	}
	if s.Role != nil && len(*s.Role) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Role", 20))
	}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ServerId", 19))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 3))
	}
	if s.HomeDirectoryMappings != nil {
		for i, v := range s.HomeDirectoryMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HomeDirectoryMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PosixProfile != nil {
		if err := s.PosixProfile.Validate(); err != nil {
			invalidParams.AddNested("PosixProfile", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHomeDirectory sets the HomeDirectory field's value.
func (s *UpdateUserInput) SetHomeDirectory(v string) *UpdateUserInput {
	s.HomeDirectory = &v
	return s
}

// SetHomeDirectoryMappings sets the HomeDirectoryMappings field's value.
func (s *UpdateUserInput) SetHomeDirectoryMappings(v []*HomeDirectoryMapEntry) *UpdateUserInput {
	s.HomeDirectoryMappings = v
	return s
}

// SetHomeDirectoryType sets the HomeDirectoryType field's value.
func (s *UpdateUserInput) SetHomeDirectoryType(v string) *UpdateUserInput {
	s.HomeDirectoryType = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *UpdateUserInput) SetPolicy(v string) *UpdateUserInput {
	s.Policy = &v
	return s
}

// SetPosixProfile sets the PosixProfile field's value.
func (s *UpdateUserInput) SetPosixProfile(v *PosixProfile) *UpdateUserInput {
	s.PosixProfile = v
	return s
}

// SetRole sets the Role field's value.
func (s *UpdateUserInput) SetRole(v string) *UpdateUserInput {
	s.Role = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *UpdateUserInput) SetServerId(v string) *UpdateUserInput {
	s.ServerId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UpdateUserInput) SetUserName(v string) *UpdateUserInput {
	s.UserName = &v
	return s
}

// UpdateUserResponse returns the user name and identifier for the request to
// update a user's properties.
type UpdateUserOutput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a server instance that the user account
	// is assigned to.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// The unique identifier for a user that is assigned to a server instance that
	// was specified in the request.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserOutput) GoString() string {
	return s.String()
}

// SetServerId sets the ServerId field's value.
func (s *UpdateUserOutput) SetServerId(v string) *UpdateUserOutput {
	s.ServerId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UpdateUserOutput) SetUserName(v string) *UpdateUserOutput {
	s.UserName = &v
	return s
}

// Specifies the user name, server ID, and session ID for a workflow.
type UserDetails struct {
	_ struct{} `type:"structure"`

	// The system-assigned unique identifier for a Transfer server instance.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// The system-assigned unique identifier for a session that corresponds to the
	// workflow.
	SessionId *string `min:"3" type:"string"`

	// A unique string that identifies a user account associated with a server.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserDetails) GoString() string {
	return s.String()
}

// SetServerId sets the ServerId field's value.
func (s *UserDetails) SetServerId(v string) *UserDetails {
	s.ServerId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *UserDetails) SetSessionId(v string) *UserDetails {
	s.SessionId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UserDetails) SetUserName(v string) *UserDetails {
	s.UserName = &v
	return s
}

// Specifies the workflow ID for the workflow to assign and the execution role
// used for executing the workflow.
type WorkflowDetail struct {
	_ struct{} `type:"structure"`

	// Includes the necessary permissions for S3, EFS, and Lambda operations that
	// Transfer can assume, so that all workflow steps can operate on the required
	// resources
	//
	// ExecutionRole is a required field
	ExecutionRole *string `min:"20" type:"string" required:"true"`

	// A unique identifier for the workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowDetail) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkflowDetail) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkflowDetail"}
	if s.ExecutionRole == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionRole"))
	}
	if s.ExecutionRole != nil && len(*s.ExecutionRole) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRole", 20))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExecutionRole sets the ExecutionRole field's value.
func (s *WorkflowDetail) SetExecutionRole(v string) *WorkflowDetail {
	s.ExecutionRole = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *WorkflowDetail) SetWorkflowId(v string) *WorkflowDetail {
	s.WorkflowId = &v
	return s
}

// Container for the WorkflowDetail data type. It is used by actions that trigger
// a workflow to begin execution.
type WorkflowDetails struct {
	_ struct{} `type:"structure"`

	// A trigger that starts a workflow: the workflow begins to execute after a
	// file is uploaded.
	//
	// To remove an associated workflow from a server, you can provide an empty
	// OnUpload object, as in the following example.
	//
	// aws transfer update-server --server-id s-01234567890abcdef --workflow-details
	// '{"OnUpload":[]}'
	//
	// OnUpload is a required field
	OnUpload []*WorkflowDetail `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkflowDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkflowDetails"}
	if s.OnUpload == nil {
		invalidParams.Add(request.NewErrParamRequired("OnUpload"))
	}
	if s.OnUpload != nil {
		for i, v := range s.OnUpload {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OnUpload", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOnUpload sets the OnUpload field's value.
func (s *WorkflowDetails) SetOnUpload(v []*WorkflowDetail) *WorkflowDetails {
	s.OnUpload = v
	return s
}

// The basic building block of a workflow.
type WorkflowStep struct {
	_ struct{} `type:"structure"`

	// Details for a step that performs a file copy.
	//
	// Consists of the following values:
	//
	//    * A description
	//
	//    * An S3 location for the destination of the file copy.
	//
	//    * A flag that indicates whether or not to overwrite an existing file of
	//    the same name. The default is FALSE.
	CopyStepDetails *CopyStepDetails `type:"structure"`

	// Details for a step that invokes a lambda function.
	//
	// Consists of the lambda function name, target, and timeout (in seconds).
	CustomStepDetails *CustomStepDetails `type:"structure"`

	// Details for a step that deletes the file.
	DeleteStepDetails *DeleteStepDetails `type:"structure"`

	// Details for a step that creates one or more tags.
	//
	// You specify one or more tags: each tag contains a key/value pair.
	TagStepDetails *TagStepDetails `type:"structure"`

	// Currently, the following step types are supported.
	//
	//    * COPY: copy the file to another location
	//
	//    * CUSTOM: custom step with a lambda target
	//
	//    * DELETE: delete the file
	//
	//    * TAG: add a tag to the file
	Type *string `type:"string" enum:"WorkflowStepType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowStep) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowStep) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkflowStep) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkflowStep"}
	if s.CopyStepDetails != nil {
		if err := s.CopyStepDetails.Validate(); err != nil {
			invalidParams.AddNested("CopyStepDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.CustomStepDetails != nil {
		if err := s.CustomStepDetails.Validate(); err != nil {
			invalidParams.AddNested("CustomStepDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.TagStepDetails != nil {
		if err := s.TagStepDetails.Validate(); err != nil {
			invalidParams.AddNested("TagStepDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCopyStepDetails sets the CopyStepDetails field's value.
func (s *WorkflowStep) SetCopyStepDetails(v *CopyStepDetails) *WorkflowStep {
	s.CopyStepDetails = v
	return s
}

// SetCustomStepDetails sets the CustomStepDetails field's value.
func (s *WorkflowStep) SetCustomStepDetails(v *CustomStepDetails) *WorkflowStep {
	s.CustomStepDetails = v
	return s
}

// SetDeleteStepDetails sets the DeleteStepDetails field's value.
func (s *WorkflowStep) SetDeleteStepDetails(v *DeleteStepDetails) *WorkflowStep {
	s.DeleteStepDetails = v
	return s
}

// SetTagStepDetails sets the TagStepDetails field's value.
func (s *WorkflowStep) SetTagStepDetails(v *TagStepDetails) *WorkflowStep {
	s.TagStepDetails = v
	return s
}

// SetType sets the Type field's value.
func (s *WorkflowStep) SetType(v string) *WorkflowStep {
	s.Type = &v
	return s
}

const (
	// CustomStepStatusSuccess is a CustomStepStatus enum value
	CustomStepStatusSuccess = "SUCCESS"

	// CustomStepStatusFailure is a CustomStepStatus enum value
	CustomStepStatusFailure = "FAILURE"
)

// CustomStepStatus_Values returns all elements of the CustomStepStatus enum
func CustomStepStatus_Values() []string {
	return []string{
		CustomStepStatusSuccess,
		CustomStepStatusFailure,
	}
}

const (
	// DomainS3 is a Domain enum value
	DomainS3 = "S3"

	// DomainEfs is a Domain enum value
	DomainEfs = "EFS"
)

// Domain_Values returns all elements of the Domain enum
func Domain_Values() []string {
	return []string{
		DomainS3,
		DomainEfs,
	}
}

const (
	// EndpointTypePublic is a EndpointType enum value
	EndpointTypePublic = "PUBLIC"

	// EndpointTypeVpc is a EndpointType enum value
	EndpointTypeVpc = "VPC"

	// EndpointTypeVpcEndpoint is a EndpointType enum value
	EndpointTypeVpcEndpoint = "VPC_ENDPOINT"
)

// EndpointType_Values returns all elements of the EndpointType enum
func EndpointType_Values() []string {
	return []string{
		EndpointTypePublic,
		EndpointTypeVpc,
		EndpointTypeVpcEndpoint,
	}
}

const (
	// ExecutionErrorTypePermissionDenied is a ExecutionErrorType enum value
	ExecutionErrorTypePermissionDenied = "PERMISSION_DENIED"

	// ExecutionErrorTypeCustomStepFailed is a ExecutionErrorType enum value
	ExecutionErrorTypeCustomStepFailed = "CUSTOM_STEP_FAILED"

	// ExecutionErrorTypeThrottled is a ExecutionErrorType enum value
	ExecutionErrorTypeThrottled = "THROTTLED"

	// ExecutionErrorTypeAlreadyExists is a ExecutionErrorType enum value
	ExecutionErrorTypeAlreadyExists = "ALREADY_EXISTS"

	// ExecutionErrorTypeNotFound is a ExecutionErrorType enum value
	ExecutionErrorTypeNotFound = "NOT_FOUND"

	// ExecutionErrorTypeBadRequest is a ExecutionErrorType enum value
	ExecutionErrorTypeBadRequest = "BAD_REQUEST"

	// ExecutionErrorTypeTimeout is a ExecutionErrorType enum value
	ExecutionErrorTypeTimeout = "TIMEOUT"

	// ExecutionErrorTypeInternalServerError is a ExecutionErrorType enum value
	ExecutionErrorTypeInternalServerError = "INTERNAL_SERVER_ERROR"
)

// ExecutionErrorType_Values returns all elements of the ExecutionErrorType enum
func ExecutionErrorType_Values() []string {
	return []string{
		ExecutionErrorTypePermissionDenied,
		ExecutionErrorTypeCustomStepFailed,
		ExecutionErrorTypeThrottled,
		ExecutionErrorTypeAlreadyExists,
		ExecutionErrorTypeNotFound,
		ExecutionErrorTypeBadRequest,
		ExecutionErrorTypeTimeout,
		ExecutionErrorTypeInternalServerError,
	}
}

const (
	// ExecutionStatusInProgress is a ExecutionStatus enum value
	ExecutionStatusInProgress = "IN_PROGRESS"

	// ExecutionStatusCompleted is a ExecutionStatus enum value
	ExecutionStatusCompleted = "COMPLETED"

	// ExecutionStatusException is a ExecutionStatus enum value
	ExecutionStatusException = "EXCEPTION"

	// ExecutionStatusHandlingException is a ExecutionStatus enum value
	ExecutionStatusHandlingException = "HANDLING_EXCEPTION"
)

// ExecutionStatus_Values returns all elements of the ExecutionStatus enum
func ExecutionStatus_Values() []string {
	return []string{
		ExecutionStatusInProgress,
		ExecutionStatusCompleted,
		ExecutionStatusException,
		ExecutionStatusHandlingException,
	}
}

const (
	// HomeDirectoryTypePath is a HomeDirectoryType enum value
	HomeDirectoryTypePath = "PATH"

	// HomeDirectoryTypeLogical is a HomeDirectoryType enum value
	HomeDirectoryTypeLogical = "LOGICAL"
)

// HomeDirectoryType_Values returns all elements of the HomeDirectoryType enum
func HomeDirectoryType_Values() []string {
	return []string{
		HomeDirectoryTypePath,
		HomeDirectoryTypeLogical,
	}
}

// Returns information related to the type of user authentication that is in
// use for a file transfer protocol-enabled server's users. For AWS_DIRECTORY_SERVICE
// or SERVICE_MANAGED authentication, the Secure Shell (SSH) public keys are
// stored with a user on the server instance. For API_GATEWAY authentication,
// your custom authentication method is implemented by using an API call. The
// server can have only one method of authentication.
const (
	// IdentityProviderTypeServiceManaged is a IdentityProviderType enum value
	IdentityProviderTypeServiceManaged = "SERVICE_MANAGED"

	// IdentityProviderTypeApiGateway is a IdentityProviderType enum value
	IdentityProviderTypeApiGateway = "API_GATEWAY"

	// IdentityProviderTypeAwsDirectoryService is a IdentityProviderType enum value
	IdentityProviderTypeAwsDirectoryService = "AWS_DIRECTORY_SERVICE"

	// IdentityProviderTypeAwsLambda is a IdentityProviderType enum value
	IdentityProviderTypeAwsLambda = "AWS_LAMBDA"
)

// IdentityProviderType_Values returns all elements of the IdentityProviderType enum
func IdentityProviderType_Values() []string {
	return []string{
		IdentityProviderTypeServiceManaged,
		IdentityProviderTypeApiGateway,
		IdentityProviderTypeAwsDirectoryService,
		IdentityProviderTypeAwsLambda,
	}
}

const (
	// OverwriteExistingTrue is a OverwriteExisting enum value
	OverwriteExistingTrue = "TRUE"

	// OverwriteExistingFalse is a OverwriteExisting enum value
	OverwriteExistingFalse = "FALSE"
)

// OverwriteExisting_Values returns all elements of the OverwriteExisting enum
func OverwriteExisting_Values() []string {
	return []string{
		OverwriteExistingTrue,
		OverwriteExistingFalse,
	}
}

const (
	// ProtocolSftp is a Protocol enum value
	ProtocolSftp = "SFTP"

	// ProtocolFtp is a Protocol enum value
	ProtocolFtp = "FTP"

	// ProtocolFtps is a Protocol enum value
	ProtocolFtps = "FTPS"
)

// Protocol_Values returns all elements of the Protocol enum
func Protocol_Values() []string {
	return []string{
		ProtocolSftp,
		ProtocolFtp,
		ProtocolFtps,
	}
}

const (
	// SetStatOptionDefault is a SetStatOption enum value
	SetStatOptionDefault = "DEFAULT"

	// SetStatOptionEnableNoOp is a SetStatOption enum value
	SetStatOptionEnableNoOp = "ENABLE_NO_OP"
)

// SetStatOption_Values returns all elements of the SetStatOption enum
func SetStatOption_Values() []string {
	return []string{
		SetStatOptionDefault,
		SetStatOptionEnableNoOp,
	}
}

// Describes the condition of a file transfer protocol-enabled server with respect
// to its ability to perform file operations. There are six possible states:
// OFFLINE, ONLINE, STARTING, STOPPING, START_FAILED, and STOP_FAILED.
//
// OFFLINE indicates that the server exists, but that it is not available for
// file operations. ONLINE indicates that the server is available to perform
// file operations. STARTING indicates that the server's was instantiated, but
// the server is not yet available to perform file operations. Under normal
// conditions, it can take a couple of minutes for the server to be completely
// operational. Both START_FAILED and STOP_FAILED are error conditions.
const (
	// StateOffline is a State enum value
	StateOffline = "OFFLINE"

	// StateOnline is a State enum value
	StateOnline = "ONLINE"

	// StateStarting is a State enum value
	StateStarting = "STARTING"

	// StateStopping is a State enum value
	StateStopping = "STOPPING"

	// StateStartFailed is a State enum value
	StateStartFailed = "START_FAILED"

	// StateStopFailed is a State enum value
	StateStopFailed = "STOP_FAILED"
)

// State_Values returns all elements of the State enum
func State_Values() []string {
	return []string{
		StateOffline,
		StateOnline,
		StateStarting,
		StateStopping,
		StateStartFailed,
		StateStopFailed,
	}
}

const (
	// TlsSessionResumptionModeDisabled is a TlsSessionResumptionMode enum value
	TlsSessionResumptionModeDisabled = "DISABLED"

	// TlsSessionResumptionModeEnabled is a TlsSessionResumptionMode enum value
	TlsSessionResumptionModeEnabled = "ENABLED"

	// TlsSessionResumptionModeEnforced is a TlsSessionResumptionMode enum value
	TlsSessionResumptionModeEnforced = "ENFORCED"
)

// TlsSessionResumptionMode_Values returns all elements of the TlsSessionResumptionMode enum
func TlsSessionResumptionMode_Values() []string {
	return []string{
		TlsSessionResumptionModeDisabled,
		TlsSessionResumptionModeEnabled,
		TlsSessionResumptionModeEnforced,
	}
}

const (
	// WorkflowStepTypeCopy is a WorkflowStepType enum value
	WorkflowStepTypeCopy = "COPY"

	// WorkflowStepTypeCustom is a WorkflowStepType enum value
	WorkflowStepTypeCustom = "CUSTOM"

	// WorkflowStepTypeTag is a WorkflowStepType enum value
	WorkflowStepTypeTag = "TAG"

	// WorkflowStepTypeDelete is a WorkflowStepType enum value
	WorkflowStepTypeDelete = "DELETE"
)

// WorkflowStepType_Values returns all elements of the WorkflowStepType enum
func WorkflowStepType_Values() []string {
	return []string{
		WorkflowStepTypeCopy,
		WorkflowStepTypeCustom,
		WorkflowStepTypeTag,
		WorkflowStepTypeDelete,
	}
}
