/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1alpha1 "k8s.io/api/resource/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	resourcev1alpha1 "k8s.io/client-go/applyconfigurations/resource/v1alpha1"
	testing "k8s.io/client-go/testing"
)

// FakeResourceClaims implements ResourceClaimInterface
type FakeResourceClaims struct {
	Fake *FakeResourceV1alpha1
	ns   string
}

var resourceclaimsResource = schema.GroupVersionResource{Group: "resource.k8s.io", Version: "v1alpha1", Resource: "resourceclaims"}

var resourceclaimsKind = schema.GroupVersionKind{Group: "resource.k8s.io", Version: "v1alpha1", Kind: "ResourceClaim"}

// Get takes name of the resourceClaim, and returns the corresponding resourceClaim object, and an error if there is any.
func (c *FakeResourceClaims) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.ResourceClaim, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(resourceclaimsResource, c.ns, name), &v1alpha1.ResourceClaim{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ResourceClaim), err
}

// List takes label and field selectors, and returns the list of ResourceClaims that match those selectors.
func (c *FakeResourceClaims) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.ResourceClaimList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(resourceclaimsResource, resourceclaimsKind, c.ns, opts), &v1alpha1.ResourceClaimList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.ResourceClaimList{ListMeta: obj.(*v1alpha1.ResourceClaimList).ListMeta}
	for _, item := range obj.(*v1alpha1.ResourceClaimList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested resourceClaims.
func (c *FakeResourceClaims) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(resourceclaimsResource, c.ns, opts))

}

// Create takes the representation of a resourceClaim and creates it.  Returns the server's representation of the resourceClaim, and an error, if there is any.
func (c *FakeResourceClaims) Create(ctx context.Context, resourceClaim *v1alpha1.ResourceClaim, opts v1.CreateOptions) (result *v1alpha1.ResourceClaim, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(resourceclaimsResource, c.ns, resourceClaim), &v1alpha1.ResourceClaim{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ResourceClaim), err
}

// Update takes the representation of a resourceClaim and updates it. Returns the server's representation of the resourceClaim, and an error, if there is any.
func (c *FakeResourceClaims) Update(ctx context.Context, resourceClaim *v1alpha1.ResourceClaim, opts v1.UpdateOptions) (result *v1alpha1.ResourceClaim, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(resourceclaimsResource, c.ns, resourceClaim), &v1alpha1.ResourceClaim{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ResourceClaim), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeResourceClaims) UpdateStatus(ctx context.Context, resourceClaim *v1alpha1.ResourceClaim, opts v1.UpdateOptions) (*v1alpha1.ResourceClaim, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(resourceclaimsResource, "status", c.ns, resourceClaim), &v1alpha1.ResourceClaim{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ResourceClaim), err
}

// Delete takes name of the resourceClaim and deletes it. Returns an error if one occurs.
func (c *FakeResourceClaims) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(resourceclaimsResource, c.ns, name, opts), &v1alpha1.ResourceClaim{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeResourceClaims) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(resourceclaimsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.ResourceClaimList{})
	return err
}

// Patch applies the patch and returns the patched resourceClaim.
func (c *FakeResourceClaims) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ResourceClaim, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(resourceclaimsResource, c.ns, name, pt, data, subresources...), &v1alpha1.ResourceClaim{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ResourceClaim), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied resourceClaim.
func (c *FakeResourceClaims) Apply(ctx context.Context, resourceClaim *resourcev1alpha1.ResourceClaimApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.ResourceClaim, err error) {
	if resourceClaim == nil {
		return nil, fmt.Errorf("resourceClaim provided to Apply must not be nil")
	}
	data, err := json.Marshal(resourceClaim)
	if err != nil {
		return nil, err
	}
	name := resourceClaim.Name
	if name == nil {
		return nil, fmt.Errorf("resourceClaim.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(resourceclaimsResource, c.ns, *name, types.ApplyPatchType, data), &v1alpha1.ResourceClaim{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ResourceClaim), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeResourceClaims) ApplyStatus(ctx context.Context, resourceClaim *resourcev1alpha1.ResourceClaimApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.ResourceClaim, err error) {
	if resourceClaim == nil {
		return nil, fmt.Errorf("resourceClaim provided to Apply must not be nil")
	}
	data, err := json.Marshal(resourceClaim)
	if err != nil {
		return nil, err
	}
	name := resourceClaim.Name
	if name == nil {
		return nil, fmt.Errorf("resourceClaim.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(resourceclaimsResource, c.ns, *name, types.ApplyPatchType, data, "status"), &v1alpha1.ResourceClaim{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.ResourceClaim), err
}
