// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// MetricsData represents the metrics data that can be stored in a persistent storage,
// OR can be embedded by other protocols that transfer OTLP metrics data but do not
// implement the OTLP protocol..
type MetricsData struct {
	ResourceMetrics []*ResourceMetrics
}

var (
	protoPoolMetricsData = sync.Pool{
		New: func() any {
			return &MetricsData{}
		},
	}
)

func NewMetricsData() *MetricsData {
	if !UseProtoPooling.IsEnabled() {
		return &MetricsData{}
	}
	return protoPoolMetricsData.Get().(*MetricsData)
}

func DeleteMetricsData(orig *MetricsData, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	for i := range orig.ResourceMetrics {
		DeleteResourceMetrics(orig.ResourceMetrics[i], true)
	}
	orig.Reset()
	if nullable {
		protoPoolMetricsData.Put(orig)
	}
}

func CopyMetricsData(dest, src *MetricsData) *MetricsData {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewMetricsData()
	}
	dest.ResourceMetrics = CopyResourceMetricsPtrSlice(dest.ResourceMetrics, src.ResourceMetrics)

	return dest
}

func CopyMetricsDataSlice(dest, src []MetricsData) []MetricsData {
	var newDest []MetricsData
	if cap(dest) < len(src) {
		newDest = make([]MetricsData, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteMetricsData(&dest[i], false)
		}
	}
	for i := range src {
		CopyMetricsData(&newDest[i], &src[i])
	}
	return newDest
}

func CopyMetricsDataPtrSlice(dest, src []*MetricsData) []*MetricsData {
	var newDest []*MetricsData
	if cap(dest) < len(src) {
		newDest = make([]*MetricsData, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewMetricsData()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteMetricsData(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewMetricsData()
		}
	}
	for i := range src {
		CopyMetricsData(newDest[i], src[i])
	}
	return newDest
}

func (orig *MetricsData) Reset() {
	*orig = MetricsData{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *MetricsData) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.ResourceMetrics) > 0 {
		dest.WriteObjectField("resourceMetrics")
		dest.WriteArrayStart()
		orig.ResourceMetrics[0].MarshalJSON(dest)
		for i := 1; i < len(orig.ResourceMetrics); i++ {
			dest.WriteMore()
			orig.ResourceMetrics[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *MetricsData) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "resourceMetrics", "resource_metrics":
			for iter.ReadArray() {
				orig.ResourceMetrics = append(orig.ResourceMetrics, NewResourceMetrics())
				orig.ResourceMetrics[len(orig.ResourceMetrics)-1].UnmarshalJSON(iter)
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *MetricsData) SizeProto() int {
	var n int
	var l int
	_ = l
	for i := range orig.ResourceMetrics {
		l = orig.ResourceMetrics[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *MetricsData) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.ResourceMetrics) - 1; i >= 0; i-- {
		l = orig.ResourceMetrics[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	return len(buf) - pos
}

func (orig *MetricsData) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceMetrics", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.ResourceMetrics = append(orig.ResourceMetrics, NewResourceMetrics())
			err = orig.ResourceMetrics[len(orig.ResourceMetrics)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestMetricsData() *MetricsData {
	orig := NewMetricsData()
	orig.ResourceMetrics = []*ResourceMetrics{{}, GenTestResourceMetrics()}
	return orig
}

func GenTestMetricsDataPtrSlice() []*MetricsData {
	orig := make([]*MetricsData, 5)
	orig[0] = NewMetricsData()
	orig[1] = GenTestMetricsData()
	orig[2] = NewMetricsData()
	orig[3] = GenTestMetricsData()
	orig[4] = NewMetricsData()
	return orig
}

func GenTestMetricsDataSlice() []MetricsData {
	orig := make([]MetricsData, 5)
	orig[1] = *GenTestMetricsData()
	orig[3] = *GenTestMetricsData()
	return orig
}
