// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// Resource is a message representing the resource information.
type Resource struct {
	Attributes             []KeyValue
	EntityRefs             []*EntityRef
	DroppedAttributesCount uint32
}

var (
	protoPoolResource = sync.Pool{
		New: func() any {
			return &Resource{}
		},
	}
)

func NewResource() *Resource {
	if !UseProtoPooling.IsEnabled() {
		return &Resource{}
	}
	return protoPoolResource.Get().(*Resource)
}

func DeleteResource(orig *Resource, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	for i := range orig.Attributes {
		DeleteKeyValue(&orig.Attributes[i], false)
	}

	for i := range orig.EntityRefs {
		DeleteEntityRef(orig.EntityRefs[i], true)
	}
	orig.Reset()
	if nullable {
		protoPoolResource.Put(orig)
	}
}

func CopyResource(dest, src *Resource) *Resource {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewResource()
	}
	dest.Attributes = CopyKeyValueSlice(dest.Attributes, src.Attributes)

	dest.DroppedAttributesCount = src.DroppedAttributesCount
	dest.EntityRefs = CopyEntityRefPtrSlice(dest.EntityRefs, src.EntityRefs)

	return dest
}

func CopyResourceSlice(dest, src []Resource) []Resource {
	var newDest []Resource
	if cap(dest) < len(src) {
		newDest = make([]Resource, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteResource(&dest[i], false)
		}
	}
	for i := range src {
		CopyResource(&newDest[i], &src[i])
	}
	return newDest
}

func CopyResourcePtrSlice(dest, src []*Resource) []*Resource {
	var newDest []*Resource
	if cap(dest) < len(src) {
		newDest = make([]*Resource, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewResource()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteResource(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewResource()
		}
	}
	for i := range src {
		CopyResource(newDest[i], src[i])
	}
	return newDest
}

func (orig *Resource) Reset() {
	*orig = Resource{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *Resource) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		orig.Attributes[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			orig.Attributes[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.DroppedAttributesCount != uint32(0) {
		dest.WriteObjectField("droppedAttributesCount")
		dest.WriteUint32(orig.DroppedAttributesCount)
	}
	if len(orig.EntityRefs) > 0 {
		dest.WriteObjectField("entityRefs")
		dest.WriteArrayStart()
		orig.EntityRefs[0].MarshalJSON(dest)
		for i := 1; i < len(orig.EntityRefs); i++ {
			dest.WriteMore()
			orig.EntityRefs[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *Resource) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "attributes":
			for iter.ReadArray() {
				orig.Attributes = append(orig.Attributes, KeyValue{})
				orig.Attributes[len(orig.Attributes)-1].UnmarshalJSON(iter)
			}

		case "droppedAttributesCount", "dropped_attributes_count":
			orig.DroppedAttributesCount = iter.ReadUint32()
		case "entityRefs", "entity_refs":
			for iter.ReadArray() {
				orig.EntityRefs = append(orig.EntityRefs, NewEntityRef())
				orig.EntityRefs[len(orig.EntityRefs)-1].UnmarshalJSON(iter)
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *Resource) SizeProto() int {
	var n int
	var l int
	_ = l
	for i := range orig.Attributes {
		l = orig.Attributes[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.DroppedAttributesCount != uint32(0) {
		n += 1 + proto.Sov(uint64(orig.DroppedAttributesCount))
	}
	for i := range orig.EntityRefs {
		l = orig.EntityRefs[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *Resource) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.Attributes) - 1; i >= 0; i-- {
		l = orig.Attributes[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	if orig.DroppedAttributesCount != uint32(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DroppedAttributesCount))
		pos--
		buf[pos] = 0x10
	}
	for i := len(orig.EntityRefs) - 1; i >= 0; i-- {
		l = orig.EntityRefs[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	return len(buf) - pos
}

func (orig *Resource) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Attributes = append(orig.Attributes, KeyValue{})
			err = orig.Attributes[len(orig.Attributes)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.DroppedAttributesCount = uint32(num)

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field EntityRefs", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.EntityRefs = append(orig.EntityRefs, NewEntityRef())
			err = orig.EntityRefs[len(orig.EntityRefs)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestResource() *Resource {
	orig := NewResource()
	orig.Attributes = []KeyValue{{}, *GenTestKeyValue()}
	orig.DroppedAttributesCount = uint32(13)
	orig.EntityRefs = []*EntityRef{{}, GenTestEntityRef()}
	return orig
}

func GenTestResourcePtrSlice() []*Resource {
	orig := make([]*Resource, 5)
	orig[0] = NewResource()
	orig[1] = GenTestResource()
	orig[2] = NewResource()
	orig[3] = GenTestResource()
	orig[4] = NewResource()
	return orig
}

func GenTestResourceSlice() []Resource {
	orig := make([]Resource, 5)
	orig[1] = *GenTestResource()
	orig[3] = *GenTestResource()
	return orig
}
