/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.tests;

import org.cachebench.reportgenerators.CsvSessionSimlatorReportGenerator;
import org.cachebench.tests.results.BaseTestResult;

public class SessionSimulatorTestResult
extends BaseTestResult {
    long readCount;
    long writeCount;
    long durration;
    long bytesRead;
    long bytesWritten;
    long replicationDelayMillis = -1L;

    public SessionSimulatorTestResult(long readCount, long writeCount, long durration, long bytesRead, long bytesWritten) {
        this.readCount = readCount;
        this.writeCount = writeCount;
        this.durration = durration;
        this.bytesRead = bytesRead;
        this.bytesWritten = bytesWritten;
    }

    public long getTotalOperationCount() {
        return this.readCount + this.writeCount;
    }

    public long getReadCount() {
        return this.readCount;
    }

    public long getWriteCount() {
        return this.writeCount;
    }

    public double getNoRequestPerSec() {
        return (double)this.getTotalOperationCount() / ((double)this.durration / 1000.0);
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public long getDurration() {
        return this.durration;
    }

    public String getReportGeneratorClassName() {
        return CsvSessionSimlatorReportGenerator.class.getName();
    }

    public long getReplicationDelayMillis() {
        return this.replicationDelayMillis;
    }

    public void setReplicationDelayMillis(long replicationDelayMillis) {
        this.replicationDelayMillis = replicationDelayMillis;
    }

    public boolean registeredReplicationDelays() {
        return this.replicationDelayMillis != -1L;
    }

    public void setReadCount(long readCount) {
        this.readCount = readCount;
    }

    public void setWriteCount(long writeCount) {
        this.writeCount = writeCount;
    }

    public void setDurration(long durration) {
        this.durration = durration;
    }

    public void setBytesRead(long bytesRead) {
        this.bytesRead = bytesRead;
    }

    public void setBytesWritten(long bytesWritten) {
        this.bytesWritten = bytesWritten;
    }
}

