/*
 * Decompiled with CFR 0.152.
 */
package yy_purify;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class YYPurify {
    public static void main(String[] args) throws IOException {
        if (3 != args.length) {
            System.err.println("Number of given parameters is inappropriate.\nSyntax:\n-(c|p) in_file out_file\n,where\n-c to cut semantics\n-p to purify grammar");
            return;
        }
        String flag = args[0];
        String inFileName = args[1];
        String outFileName = args[2];
        Mode mode = Mode.mUnknown;
        if (flag.equals("-c")) {
            mode = Mode.mCutSemantics;
        } else if (flag.equals("-p")) {
            mode = Mode.mPurifyGrammar;
        }
        switch (mode) {
            case mCutSemantics: {
                System.out.print("Cut semantics: ");
                break;
            }
            case mPurifyGrammar: {
                System.out.print("Purify grammar: ");
                break;
            }
            case mUnknown: {
                System.err.println("Unknown flag given (" + flag + ").\n" + "-c to cut semantics\n" + "-p to purify grammar");
                return;
            }
        }
        System.out.print(args[1]);
        System.out.print(" -> ");
        System.out.println(args[2]);
        File input = new File(args[1]);
        FileInputStream is = new FileInputStream(input);
        File output = new File(args[2]);
        FileOutputStream os = new FileOutputStream(output);
        byte[] content = new byte[(int)input.length()];
        ((InputStream)is).read(content, 0, content.length);
        switch (mode) {
            case mCutSemantics: {
                YYPurify.cutSemantics(is, os, content);
                break;
            }
            case mPurifyGrammar: {
                YYPurify.purifyGrammar(is, os, content);
            }
        }
        ((InputStream)is).close();
        ((OutputStream)os).close();
    }

    public static void cutSemantics(InputStream is, OutputStream os, byte[] content) throws IOException {
        int textDepth = 0;
        boolean ignoreNext = false;
        for (int i = 0; i < content.length; ++i) {
            byte b = content[i];
            if (b == 13 || b == 10) {
                os.write(b);
            } else if (!ignoreNext && b == 123) {
                if (++textDepth == 1) {
                    os.write(b);
                }
            } else if (!ignoreNext && b == 125) {
                if (--textDepth == 0) {
                    os.write(b);
                }
            } else if (textDepth == 0) {
                os.write(b);
            }
            ignoreNext = b == 39;
        }
    }

    public static void purifyGrammar(InputStream is, OutputStream os, byte[] content) throws IOException {
        int textDepth = 0;
        boolean ignoreNext = false;
        int lastSymbol = 32;
        for (int i = 0; i < content.length; ++i) {
            int b = content[i];
            switch (b) {
                case 123: {
                    if (ignoreNext) break;
                    ++textDepth;
                    break;
                }
                case 125: {
                    if (ignoreNext) break;
                    --textDepth;
                    break;
                }
                default: {
                    if (0 != textDepth) break;
                    os.write(b);
                }
            }
            if (37 == lastSymbol && 37 == b) {
                os.write(10);
                os.write(10);
                YYPurify.purifyRulesSection(is, os, content, i);
                break;
            }
            lastSymbol = b;
            ignoreNext = b == 39;
        }
    }

    public static void purifyRulesSection(InputStream is, OutputStream os, byte[] content, int i) throws IOException {
        int textDepth = 0;
        boolean ignoreNext = false;
        boolean commentSection = false;
        boolean symbol_processed = false;
        int lastSymbol = 32;
        int maxI = content.length - 1;
        ++i;
        while (i < content.length) {
            int b = content[i];
            if (!commentSection) {
                boolean bl = symbol_processed = !ignoreNext;
                if (!ignoreNext) {
                    switch (b) {
                        case 123: {
                            ++textDepth;
                            break;
                        }
                        case 125: {
                            --textDepth;
                            break;
                        }
                        case 47: {
                            if (i < maxI && 42 == content[i + 1]) {
                                commentSection = true;
                                ++i;
                                break;
                            }
                        }
                        default: {
                            symbol_processed = false;
                        }
                    }
                }
                if (!symbol_processed && 0 == textDepth) {
                    boolean bl2 = symbol_processed = !ignoreNext;
                    if (!ignoreNext) {
                        switch (b) {
                            case 59: {
                                os.write(b);
                                os.write(10);
                                os.write(10);
                                break;
                            }
                            case 58: {
                                os.write(b);
                                os.write(10);
                                os.write(32);
                                break;
                            }
                            case 124: {
                                os.write(10);
                                os.write(b);
                                break;
                            }
                            default: {
                                symbol_processed = false;
                            }
                        }
                    }
                    if (!symbol_processed) {
                        switch (b) {
                            case 9: 
                            case 10: 
                            case 13: 
                            case 32: {
                                break;
                            }
                            default: {
                                if (9 == lastSymbol || 32 == lastSymbol) {
                                    os.write(32);
                                }
                                os.write(b);
                            }
                        }
                    }
                }
                lastSymbol = b;
                ignoreNext = 39 == b;
            } else if (42 == b && i > 0 && 47 == content[i + 1]) {
                commentSection = false;
                ++i;
            }
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        mUnknown,
        mCutSemantics,
        mPurifyGrammar;

    }
}

