/* MoleInvasion - Copyright (C) - Guillaume Chambraud (linuxprocess@free.fr)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version. */

# include "edit_keys.h"

void draw_key_config(char action)
{	static myList * keys;
	static mySprite question, yesno;
	static mySprite * text=NULL;
	static mySprite * value=NULL;
	int i;

	if(action==DO_INIT)
	{	keys = get_current_config();
		if(keys)
			for(i=0;i<keys->size;i++)
			{	key_config_desc * info =  GetPosList(keys ,i);
				text=(mySprite *)realloc(text,sizeof(mySprite)*(i+1));
				value=(mySprite *)realloc(value,sizeof(mySprite)*(i+1));
				text[i]=font_long_text(info->txt_id,0,0);
				value[i]=font_text(info->txt_key,0,0);
/*				printf("%d (%s %s)\n",i,info->txt_id,info->txt_key);*/
			}
		question=font_long_text("[AGREE_KEY_CONFIG]",0,0);
		yesno=font_long_text("[YESNO]",0,0);
	}
	else if(action==DO_FREE)
	{	for(i=0;i<keys->size;i++)
		{	FreeImgSprite(text[i]);
			FreeImgSprite(value[i]);
		}
		free(text);text=NULL;
		free(value);value=NULL;
		FreeList(keys);keys=NULL;
		FreeImgSprite(question);
		FreeImgSprite(yesno);
	}
	else if(action==DO_DRAW)
	{	int pos=520, decalX=200;

		displaySprite(question,g_SDL_screen,g_SDL_screen->w/2 - question.imgW/2, pos);
		pos-=question.imgH+40;
		if(keys)
			for(i=0;i<keys->size;i++)
			{	displaySprite(text[i],g_SDL_screen,g_SDL_screen->w/2 - 10 - text[i].imgW + decalX ,pos);
				displaySprite(value[i],g_SDL_screen,g_SDL_screen->w/2 + 10 + decalX ,pos);
				pos-=text[i].imgH+10;
			}
		pos-=40;
		displaySprite(yesno,g_SDL_screen,g_SDL_screen->w/2 - yesno.imgW/2, pos);
	}
}

void reconfigure_keys(mySprite * background)
{	int i,pos;
	myList * keys=get_current_config();
	mySprite question,key;
	
	for(i=0;i<keys->size;i++)
	{	key_config_desc * info =  GetPosList(keys ,i);
	
		question=font_long_text("[PRESSKEY]",0,0);
		key=font_long_text(info->txt_id,0,0);

		pos=420;
		draw_backgrnd(DO_DRAW,background);
		displaySprite(question,g_SDL_screen,g_SDL_screen->w/2 - question.imgW/2, pos);
		pos-=question.imgH+10;
		displaySprite(key,g_SDL_screen,g_SDL_screen->w/2 - key.imgW/2, pos);

		/* envoi au hard */
		My_Flip();

		change_key_config(i);

		SDL_FreeSurface(question.image);
		SDL_FreeSurface(key.image);
	}
	save_keyconfig();
	FreeList(keys);
}

int main_edit_keys(Uint8 show_FPS)
{
	int action;
	mySprite * background;
	
	/* font initialisation */
	SDL_Color myText_bg={255,255,255};
	SDL_Color myText_fg={255,20,20};
	font_select(FONT_NAME,40,myText_fg,myText_bg,180);

	/* r-init des vnements */
	events_init();

	background=draw_backgrnd(DO_INIT,"gfx/ihm/beach.jpg");
	draw_key_config(DO_INIT);

	while(1)
	{	draw_backgrnd(DO_DRAW,background);
		draw_key_config(DO_DRAW);

		/* envoi au hard */
		My_Flip();

		/* on bloque  30 FPS */
		coef_frame_rate(show_FPS);

		action=process_yesno_events();
		if(action==0 || action==2)
			break;
		if(action==1)
		{	reconfigure_keys(background);
			draw_key_config(DO_FREE);
			draw_key_config(DO_INIT);
		}
	}

	draw_key_config(DO_FREE);
	draw_backgrnd(DO_FREE,background);

	return 0;
}

/* */

void draw_joy_config(char action)
{	static myList * keys;
	static mySprite question, yesno;
	static mySprite * text=NULL;
	static int * joyvalue;
	static int nb_but;
	int i;

	if(action==DO_INIT)
	{	keys = get_current_config();
		if(keys)
			for(i=0,nb_but=0;i<keys->size;i++)
			{	key_config_desc * info =  GetPosList(keys ,i);

				/* les directions ne sont pas configurables */
				if(info->joycode<0)
					continue;

				text=(mySprite *)realloc(text,sizeof(mySprite)*(nb_but+1));
				joyvalue=(int *)realloc(joyvalue,sizeof(int)*(nb_but+1));
				text[nb_but]=font_long_text(info->txt_id,0,0);
				joyvalue[nb_but]=info->joycode;
/*				printf("%d (%s %d)\n",nb_but,info->txt_id,info->joycode);*/
				nb_but++;
			}
		question=font_long_text("[AGREE_JOY_CONFIG]",0,0);
		yesno=font_long_text("[YESNO]",0,0);
	}
	else if(action==DO_FREE)
	{	for(i=0;i<nb_but;i++)
		{	FreeImgSprite(text[i]);
		}
		free(text);text=NULL;
		free(joyvalue);joyvalue=NULL;
		FreeList(keys);keys=NULL;
		FreeImgSprite(question);
		FreeImgSprite(yesno);
	}
	else if(action==DO_DRAW)
	{	int pos=500, decalX=200;

		displaySprite(question,g_SDL_screen,g_SDL_screen->w/2 - question.imgW/2, pos);
		pos-=question.imgH+40;
		if(keys)
			for(i=0;i<nb_but;i++)
			{	displaySprite(text[i],g_SDL_screen,g_SDL_screen->w/2 - 10 - text[i].imgW + decalX ,pos);
				font_render_integer(joyvalue[i],g_SDL_screen->w/2 + 10 + decalX ,pos);
				pos-=text[i].imgH+10;
			}
		pos-=40;
		displaySprite(yesno,g_SDL_screen,g_SDL_screen->w/2 - yesno.imgW/2, pos);
	}
}

void reconfigure_joy(mySprite * background)
{	int i,pos;
	myList * keys=get_current_config();
	mySprite question,key;
	

	if(!test_joystick())
	{
		question=font_long_text("[NOJOYDETECTED]",0,0);

		pos=420;

		/* r-init des vnements */
		events_init();
		while(!any_event_found())
		{	all_events_status events;
		
			draw_backgrnd(DO_DRAW,background);
			displaySprite(question,g_SDL_screen,g_SDL_screen->w/2 - question.imgW/2, pos);

			/* envoi au hard */
			My_Flip();

			/* on bloque  30 FPS */
			coef_frame_rate(0);

			events=events_get_all();	
			if(events.f_kp)
			{	SDL_WM_ToggleFullScreen(g_SDL_screen);
				events_init();
			}
		}

		SDL_FreeSurface(question.image);
	}
	else
		for(i=0;i<keys->size;i++)
		{	key_config_desc * info =  GetPosList(keys ,i);

			/* les directions ne sont pas configurables */
			if(info->joycode<0)
				continue;
			
			question=font_long_text("[PRESSBUTTON]",0,0);
			key=font_long_text(info->txt_id,0,0);
	
			pos=420;
			draw_backgrnd(DO_DRAW,background);
			displaySprite(question,g_SDL_screen,g_SDL_screen->w/2 - question.imgW/2, pos);
			pos-=question.imgH+10;
			displaySprite(key,g_SDL_screen,g_SDL_screen->w/2 - key.imgW/2, pos);
	
			/* envoi au hard */
			My_Flip();
	
			change_joy_config(i);
	
			SDL_FreeSurface(question.image);
			SDL_FreeSurface(key.image);
		}

	save_keyconfig();
	FreeList(keys);
}

int main_edit_joy(Uint8 show_FPS)
{
	int action;
	mySprite * background;
	
	/* font initialisation */
	SDL_Color myText_bg={255,255,255};
	SDL_Color myText_fg={255,20,20};
	font_select(FONT_NAME,40,myText_fg,myText_bg,180);

	/* r-init des vnements */
	events_init();

	background=draw_backgrnd(DO_INIT,"gfx/ihm/beach.jpg");
	draw_joy_config(DO_INIT);

	while(1)
	{	draw_backgrnd(DO_DRAW,background);
		draw_joy_config(DO_DRAW);

		/* envoi au hard */
		My_Flip();

		/* on bloque  30 FPS */
		coef_frame_rate(show_FPS);

		action=process_yesno_events();
		if(action==0 || action==2)
			break;
		if(action==1)
		{	reconfigure_joy(background);
			draw_joy_config(DO_FREE);
			draw_joy_config(DO_INIT);
		}
	}

	draw_joy_config(DO_FREE);
	draw_backgrnd(DO_FREE,background);

	return 0;
}
