// Package bluetoothemulation provides the Chrome DevTools Protocol
// commands, types, and events for the BluetoothEmulation domain.
//
// This domain allows configuring virtual Bluetooth devices to test the
// web-bluetooth API.
//
// Generated by the cdproto-gen command.
package bluetoothemulation

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"context"

	"github.com/chromedp/cdproto/cdp"
)

// EnableParams enable the BluetoothEmulation domain.
type EnableParams struct {
	State       CentralState `json:"state"`       // State of the simulated central.
	LeSupported bool         `json:"leSupported"` // If the simulated central supports low-energy.
}

// Enable enable the BluetoothEmulation domain.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-enable
//
// parameters:
//
//	state - State of the simulated central.
//	leSupported - If the simulated central supports low-energy.
func Enable(state CentralState, leSupported bool) *EnableParams {
	return &EnableParams{
		State:       state,
		LeSupported: leSupported,
	}
}

// Do executes BluetoothEmulation.enable against the provided context.
func (p *EnableParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandEnable, p, nil)
}

// SetSimulatedCentralStateParams set the state of the simulated central.
type SetSimulatedCentralStateParams struct {
	State CentralState `json:"state"` // State of the simulated central.
}

// SetSimulatedCentralState set the state of the simulated central.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-setSimulatedCentralState
//
// parameters:
//
//	state - State of the simulated central.
func SetSimulatedCentralState(state CentralState) *SetSimulatedCentralStateParams {
	return &SetSimulatedCentralStateParams{
		State: state,
	}
}

// Do executes BluetoothEmulation.setSimulatedCentralState against the provided context.
func (p *SetSimulatedCentralStateParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetSimulatedCentralState, p, nil)
}

// DisableParams disable the BluetoothEmulation domain.
type DisableParams struct{}

// Disable disable the BluetoothEmulation domain.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-disable
func Disable() *DisableParams {
	return &DisableParams{}
}

// Do executes BluetoothEmulation.disable against the provided context.
func (p *DisableParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandDisable, nil, nil)
}

// SimulatePreconnectedPeripheralParams simulates a peripheral with
// |address|, |name| and |knownServiceUuids| that has already been connected to
// the system.
type SimulatePreconnectedPeripheralParams struct {
	Address           string              `json:"address"`
	Name              string              `json:"name"`
	ManufacturerData  []*ManufacturerData `json:"manufacturerData"`
	KnownServiceUUIDs []string            `json:"knownServiceUuids"`
}

// SimulatePreconnectedPeripheral simulates a peripheral with |address|,
// |name| and |knownServiceUuids| that has already been connected to the system.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-simulatePreconnectedPeripheral
//
// parameters:
//
//	address
//	name
//	manufacturerData
//	knownServiceUUIDs
func SimulatePreconnectedPeripheral(address string, name string, manufacturerData []*ManufacturerData, knownServiceUUIDs []string) *SimulatePreconnectedPeripheralParams {
	return &SimulatePreconnectedPeripheralParams{
		Address:           address,
		Name:              name,
		ManufacturerData:  manufacturerData,
		KnownServiceUUIDs: knownServiceUUIDs,
	}
}

// Do executes BluetoothEmulation.simulatePreconnectedPeripheral against the provided context.
func (p *SimulatePreconnectedPeripheralParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSimulatePreconnectedPeripheral, p, nil)
}

// SimulateAdvertisementParams simulates an advertisement packet described in
// |entry| being received by the central.
type SimulateAdvertisementParams struct {
	Entry *ScanEntry `json:"entry"`
}

// SimulateAdvertisement simulates an advertisement packet described in
// |entry| being received by the central.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-simulateAdvertisement
//
// parameters:
//
//	entry
func SimulateAdvertisement(entry *ScanEntry) *SimulateAdvertisementParams {
	return &SimulateAdvertisementParams{
		Entry: entry,
	}
}

// Do executes BluetoothEmulation.simulateAdvertisement against the provided context.
func (p *SimulateAdvertisementParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSimulateAdvertisement, p, nil)
}

// SimulateGATTOperationResponseParams simulates the response code from the
// peripheral with |address| for a GATT operation of |type|. The |code| value
// follows the HCI Error Codes from Bluetooth Core Specification Vol 2 Part D
// 1.3 List Of Error Codes.
type SimulateGATTOperationResponseParams struct {
	Address string            `json:"address"`
	Type    GATTOperationType `json:"type"`
	Code    int64             `json:"code"`
}

// SimulateGATTOperationResponse simulates the response code from the
// peripheral with |address| for a GATT operation of |type|. The |code| value
// follows the HCI Error Codes from Bluetooth Core Specification Vol 2 Part D
// 1.3 List Of Error Codes.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-simulateGATTOperationResponse
//
// parameters:
//
//	address
//	type
//	code
func SimulateGATTOperationResponse(address string, typeVal GATTOperationType, code int64) *SimulateGATTOperationResponseParams {
	return &SimulateGATTOperationResponseParams{
		Address: address,
		Type:    typeVal,
		Code:    code,
	}
}

// Do executes BluetoothEmulation.simulateGATTOperationResponse against the provided context.
func (p *SimulateGATTOperationResponseParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSimulateGATTOperationResponse, p, nil)
}

// AddServiceParams adds a service with |serviceUuid| to the peripheral with
// |address|.
type AddServiceParams struct {
	Address     string `json:"address"`
	ServiceUUID string `json:"serviceUuid"`
}

// AddService adds a service with |serviceUuid| to the peripheral with
// |address|.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-addService
//
// parameters:
//
//	address
//	serviceUUID
func AddService(address string, serviceUUID string) *AddServiceParams {
	return &AddServiceParams{
		Address:     address,
		ServiceUUID: serviceUUID,
	}
}

// AddServiceReturns return values.
type AddServiceReturns struct {
	ServiceID string `json:"serviceId,omitempty,omitzero"` // An identifier that uniquely represents this service.
}

// Do executes BluetoothEmulation.addService against the provided context.
//
// returns:
//
//	serviceID - An identifier that uniquely represents this service.
func (p *AddServiceParams) Do(ctx context.Context) (serviceID string, err error) {
	// execute
	var res AddServiceReturns
	err = cdp.Execute(ctx, CommandAddService, p, &res)
	if err != nil {
		return "", err
	}

	return res.ServiceID, nil
}

// RemoveServiceParams removes the service respresented by |serviceId| from
// the peripheral with |address|.
type RemoveServiceParams struct {
	Address   string `json:"address"`
	ServiceID string `json:"serviceId"`
}

// RemoveService removes the service respresented by |serviceId| from the
// peripheral with |address|.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-removeService
//
// parameters:
//
//	address
//	serviceID
func RemoveService(address string, serviceID string) *RemoveServiceParams {
	return &RemoveServiceParams{
		Address:   address,
		ServiceID: serviceID,
	}
}

// Do executes BluetoothEmulation.removeService against the provided context.
func (p *RemoveServiceParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandRemoveService, p, nil)
}

// AddCharacteristicParams adds a characteristic with |characteristicUuid|
// and |properties| to the service represented by |serviceId| in the peripheral
// with |address|.
type AddCharacteristicParams struct {
	Address            string                    `json:"address"`
	ServiceID          string                    `json:"serviceId"`
	CharacteristicUUID string                    `json:"characteristicUuid"`
	Properties         *CharacteristicProperties `json:"properties"`
}

// AddCharacteristic adds a characteristic with |characteristicUuid| and
// |properties| to the service represented by |serviceId| in the peripheral with
// |address|.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-addCharacteristic
//
// parameters:
//
//	address
//	serviceID
//	characteristicUUID
//	properties
func AddCharacteristic(address string, serviceID string, characteristicUUID string, properties *CharacteristicProperties) *AddCharacteristicParams {
	return &AddCharacteristicParams{
		Address:            address,
		ServiceID:          serviceID,
		CharacteristicUUID: characteristicUUID,
		Properties:         properties,
	}
}

// AddCharacteristicReturns return values.
type AddCharacteristicReturns struct {
	CharacteristicID string `json:"characteristicId,omitempty,omitzero"` // An identifier that uniquely represents this characteristic.
}

// Do executes BluetoothEmulation.addCharacteristic against the provided context.
//
// returns:
//
//	characteristicID - An identifier that uniquely represents this characteristic.
func (p *AddCharacteristicParams) Do(ctx context.Context) (characteristicID string, err error) {
	// execute
	var res AddCharacteristicReturns
	err = cdp.Execute(ctx, CommandAddCharacteristic, p, &res)
	if err != nil {
		return "", err
	}

	return res.CharacteristicID, nil
}

// RemoveCharacteristicParams removes the characteristic respresented by
// |characteristicId| from the service respresented by |serviceId| in the
// peripheral with |address|.
type RemoveCharacteristicParams struct {
	Address          string `json:"address"`
	ServiceID        string `json:"serviceId"`
	CharacteristicID string `json:"characteristicId"`
}

// RemoveCharacteristic removes the characteristic respresented by
// |characteristicId| from the service respresented by |serviceId| in the
// peripheral with |address|.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-removeCharacteristic
//
// parameters:
//
//	address
//	serviceID
//	characteristicID
func RemoveCharacteristic(address string, serviceID string, characteristicID string) *RemoveCharacteristicParams {
	return &RemoveCharacteristicParams{
		Address:          address,
		ServiceID:        serviceID,
		CharacteristicID: characteristicID,
	}
}

// Do executes BluetoothEmulation.removeCharacteristic against the provided context.
func (p *RemoveCharacteristicParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandRemoveCharacteristic, p, nil)
}

// AddDescriptorParams adds a descriptor with |descriptorUuid| to the
// characteristic respresented by |characteristicId| in the service represented
// by |serviceId| of the peripheral with |address|.
type AddDescriptorParams struct {
	Address          string `json:"address"`
	ServiceID        string `json:"serviceId"`
	CharacteristicID string `json:"characteristicId"`
	DescriptorUUID   string `json:"descriptorUuid"`
}

// AddDescriptor adds a descriptor with |descriptorUuid| to the
// characteristic respresented by |characteristicId| in the service represented
// by |serviceId| of the peripheral with |address|.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-addDescriptor
//
// parameters:
//
//	address
//	serviceID
//	characteristicID
//	descriptorUUID
func AddDescriptor(address string, serviceID string, characteristicID string, descriptorUUID string) *AddDescriptorParams {
	return &AddDescriptorParams{
		Address:          address,
		ServiceID:        serviceID,
		CharacteristicID: characteristicID,
		DescriptorUUID:   descriptorUUID,
	}
}

// AddDescriptorReturns return values.
type AddDescriptorReturns struct {
	DescriptorID string `json:"descriptorId,omitempty,omitzero"` // An identifier that uniquely represents this descriptor.
}

// Do executes BluetoothEmulation.addDescriptor against the provided context.
//
// returns:
//
//	descriptorID - An identifier that uniquely represents this descriptor.
func (p *AddDescriptorParams) Do(ctx context.Context) (descriptorID string, err error) {
	// execute
	var res AddDescriptorReturns
	err = cdp.Execute(ctx, CommandAddDescriptor, p, &res)
	if err != nil {
		return "", err
	}

	return res.DescriptorID, nil
}

// RemoveDescriptorParams removes the descriptor with |descriptorId| from the
// characteristic respresented by |characteristicId| in the service represented
// by |serviceId| of the peripheral with |address|.
type RemoveDescriptorParams struct {
	Address          string `json:"address"`
	ServiceID        string `json:"serviceId"`
	CharacteristicID string `json:"characteristicId"`
	DescriptorID     string `json:"descriptorId"`
}

// RemoveDescriptor removes the descriptor with |descriptorId| from the
// characteristic respresented by |characteristicId| in the service represented
// by |serviceId| of the peripheral with |address|.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/BluetoothEmulation#method-removeDescriptor
//
// parameters:
//
//	address
//	serviceID
//	characteristicID
//	descriptorID
func RemoveDescriptor(address string, serviceID string, characteristicID string, descriptorID string) *RemoveDescriptorParams {
	return &RemoveDescriptorParams{
		Address:          address,
		ServiceID:        serviceID,
		CharacteristicID: characteristicID,
		DescriptorID:     descriptorID,
	}
}

// Do executes BluetoothEmulation.removeDescriptor against the provided context.
func (p *RemoveDescriptorParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandRemoveDescriptor, p, nil)
}

// Command names.
const (
	CommandEnable                         = "BluetoothEmulation.enable"
	CommandSetSimulatedCentralState       = "BluetoothEmulation.setSimulatedCentralState"
	CommandDisable                        = "BluetoothEmulation.disable"
	CommandSimulatePreconnectedPeripheral = "BluetoothEmulation.simulatePreconnectedPeripheral"
	CommandSimulateAdvertisement          = "BluetoothEmulation.simulateAdvertisement"
	CommandSimulateGATTOperationResponse  = "BluetoothEmulation.simulateGATTOperationResponse"
	CommandAddService                     = "BluetoothEmulation.addService"
	CommandRemoveService                  = "BluetoothEmulation.removeService"
	CommandAddCharacteristic              = "BluetoothEmulation.addCharacteristic"
	CommandRemoveCharacteristic           = "BluetoothEmulation.removeCharacteristic"
	CommandAddDescriptor                  = "BluetoothEmulation.addDescriptor"
	CommandRemoveDescriptor               = "BluetoothEmulation.removeDescriptor"
)
