/*
 * edge.h
 *
 *  Created on: Jul 23, 2016
 *      Author: cedric
 */

#ifndef REDUZE_EDGE_H_
#define REDUZE_EDGE_H_

#include <ostream>
#include "ginac/ginac.h"
#include <vector>
#include <set>

namespace YAML {
class Node;
class Emitter;
}

namespace Reduze {

/// edge
struct Edge {
	Edge(int from, int to, int id) :
			from(from), to(to), id(id) {
	}
	Edge() :
			from(-1), to(-1), id(-1) {
	}
	int opposite(int node) const;
	void reverse();
	bool is_self_loop() const;
	/// returns true if this edge connects a and b
	bool is_between(int a, int b) const;
	/// compares this with other edge ignoring their direction and id
	int compare_undirected(const Edge& other) const;
	/// compares ids
	bool operator<(const Edge& other) const;
	/// compares ids
	bool operator==(const Edge& other) const;
	friend std::ostream& operator<<(std::ostream&, const Edge&);
	int from, to, id;
};

/// colored multi edge, a color can represent a mass or anything else specific to the edge
class colored_multi_edge {
public:
	// empty multi edge with space for edges of 'num_colors' different color numbers
	colored_multi_edge(int num_colors);
	colored_multi_edge(const YAML::Node& yn);

	bool is_zero() const;
	void increment_at(int pos);
	colored_multi_edge& operator+=(const colored_multi_edge& other);

	bool operator<(const colored_multi_edge& other) const;
	bool operator==(const colored_multi_edge& other) const;
	bool operator!=(const colored_multi_edge& other) const;

	friend YAML::Emitter& operator<<(YAML::Emitter&, const colored_multi_edge&);
	friend std::ostream& operator<<(std::ostream&, const colored_multi_edge&);

private:
	colored_multi_edge() {
	}
	// the numbers of edges with color number of their position
	std::vector<int> num_edges_of_color_;
};

struct mass_is_less {
	bool operator()(const GiNaC::ex& e1, const GiNaC::ex& e2) const;
};

class edge_attributes {
public:
	GiNaC::lst masses_;
	std::set<int> propagator_types_;

	bool operator<(const edge_attributes&) const;
	bool operator==(const edge_attributes&) const;
	bool operator!=(const edge_attributes&) const;

	friend std::ostream& operator<<(std::ostream&, const edge_attributes&);
	friend YAML::Emitter& operator<<(YAML::Emitter&, const edge_attributes&);
	void read(const YAML::Node&, const GiNaC::lst&);

	void swap(edge_attributes& other);

private:
	int compare(const edge_attributes& other) const;
};

} // namespace Reduze

#endif /* REDUZE_EDGE_H_ */
