"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isUIAnalyticsEvent = exports.default = void 0;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _AnalyticsEvent2 = _interopRequireDefault(require("./AnalyticsEvent"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, o, e, r) { var p = (0, _get2.default)((0, _getPrototypeOf2.default)(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; } /// <reference types="node" />
var isUIAnalyticsEvent = exports.isUIAnalyticsEvent = function isUIAnalyticsEvent(obj) {
  var _obj$constructor;
  return obj instanceof UIAnalyticsEvent || !!(obj !== null && obj !== void 0 && obj._isUIAnalyticsEvent) ||
  // Backwards compatibility with older analytics-next packages
  (obj === null || obj === void 0 || (_obj$constructor = obj.constructor) === null || _obj$constructor === void 0 ? void 0 : _obj$constructor.name) === 'UIAnalyticsEvent';
};
var UIAnalyticsEvent = exports.default = /*#__PURE__*/function (_AnalyticsEvent) {
  function UIAnalyticsEvent(props) {
    var _this;
    (0, _classCallCheck2.default)(this, UIAnalyticsEvent);
    _this = _callSuper(this, UIAnalyticsEvent, [props]);
    (0, _defineProperty2.default)(_this, "_isUIAnalyticsEvent", true);
    (0, _defineProperty2.default)(_this, "clone", function () {
      if (_this.hasFired) {
        if (process.env.NODE_ENV !== 'production' && !process.env.CI) {
          // eslint-disable-next-line no-console
          console.warn("Cannot clone an event after it's been fired.");
        }
        return null;
      }
      var context = (0, _toConsumableArray2.default)(_this.context);
      var handlers = (0, _toConsumableArray2.default)(_this.handlers);

      /**
       * A hacky "deep clone" of the object. This is limited in that it wont
       * support functions, regexs, Maps, Sets, etc, but none of those need to
       * be represented in our payload.
       */
      var payload = JSON.parse(JSON.stringify(_this.payload));
      return new UIAnalyticsEvent({
        context: context,
        handlers: handlers,
        payload: payload
      });
    });
    (0, _defineProperty2.default)(_this, "fire", function (channel) {
      if (_this.hasFired) {
        if (process.env.NODE_ENV !== 'production' && !process.env.CI) {
          // eslint-disable-next-line no-console
          console.warn('Cannot fire an event twice.');
        }
        return;
      }
      _this.handlers.forEach(function (handler) {
        return handler(_this, channel);
      });
      _this.hasFired = true;
    });
    _this.context = props.context || [];
    _this.handlers = props.handlers || [];
    _this.hasFired = false;
    return _this;
  }
  (0, _inherits2.default)(UIAnalyticsEvent, _AnalyticsEvent);
  return (0, _createClass2.default)(UIAnalyticsEvent, [{
    key: "update",
    value: function update(updater) {
      if (this.hasFired) {
        if (process.env.NODE_ENV !== 'production' && !process.env.CI) {
          // eslint-disable-next-line no-console
          console.warn("Cannot update an event after it's been fired.");
        }
        return this;
      }
      return _superPropGet(UIAnalyticsEvent, "update", this, 3)([updater]);
    }
  }]);
}(_AnalyticsEvent2.default);