/// <reference types="react" />
/**
 * Get the scrollbar width of the container that the ref is assigned.
 *
 * ```js
 * const { width, ref } = useScrollbarWidth();
 * ```
 *
 * @returns Scrollbar width of the container and the element ref.
 */
export default function useScrollbarWidth(): {
    width: number;
    ref: import("react").MutableRefObject<HTMLDivElement | null>;
};
