export type THTML<C extends keyof JSX.IntrinsicElements> = JSX.IntrinsicElements[C];
export type TPaging = {
    index: number;
    size: number;
    totalDisplayableResults: number;
    totalResults?: number;
};
export type TSelection = {
    selected: string[];
    select: (id: string, ids: string[]) => void;
    selectAll: (allSelected: boolean, ids: string[]) => void;
    clearSelected: () => void;
};
export declare enum ESortDirection {
    ASC = "asc",
    DESC = "desc",
    NONE = "none"
}
export type TSorting = {
    column: string;
    direction: ESortDirection;
};
export type Modify<T, R> = Omit<T, keyof R> & R;
export declare enum EStatus {
    SUCCESS = "success",
    INFO = "info",
    WARNING = "warning",
    ERROR = "error"
}
//# sourceMappingURL=genericTypes.d.ts.map