/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.jfr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import javax.management.openmbean.CompositeData;
import jdk.jfr.EventType;
import jdk.jfr.SettingDescriptor;
import jdk.management.jfr.SettingDescriptorInfo;
import jdk.management.jfr.Stringifier;

public final class EventTypeInfo {
    private final List<SettingDescriptorInfo> settings;
    private final long id;
    private final String name;
    private final String description;
    private final String label;
    private final List<String> categoryNames;

    EventTypeInfo(EventType eventType) {
        this.settings = EventTypeInfo.creatingSettingDescriptorInfos(eventType);
        this.id = eventType.getId();
        this.name = eventType.getName();
        this.label = eventType.getLabel();
        this.description = eventType.getDescription();
        this.categoryNames = eventType.getCategoryNames();
    }

    private EventTypeInfo(CompositeData compositeData) {
        this.settings = EventTypeInfo.createSettings(compositeData.get("settings"));
        this.id = (Long)compositeData.get("id");
        this.name = (String)compositeData.get("name");
        this.label = (String)compositeData.get("label");
        this.description = (String)compositeData.get("description");
        this.categoryNames = EventTypeInfo.createCategoryNames((Object[])compositeData.get("category"));
    }

    private static List<String> createCategoryNames(Object[] objectArray) {
        ArrayList<String> arrayList = new ArrayList<String>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add((String)objectArray[i]);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static List<SettingDescriptorInfo> creatingSettingDescriptorInfos(EventType eventType) {
        List<SettingDescriptor> list = eventType.getSettingDescriptors();
        ArrayList<SettingDescriptorInfo> arrayList = new ArrayList<SettingDescriptorInfo>(list.size());
        for (SettingDescriptor settingDescriptor : list) {
            arrayList.add(new SettingDescriptorInfo(settingDescriptor));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static List<SettingDescriptorInfo> createSettings(Object object) {
        if (object != null && object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            ArrayList<SettingDescriptorInfo> arrayList = new ArrayList<SettingDescriptorInfo>(objectArray.length);
            for (Object object2 : objectArray) {
                if (!(object2 instanceof CompositeData)) continue;
                arrayList.add(SettingDescriptorInfo.from((CompositeData)object2));
            }
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getCategoryNames() {
        return this.categoryNames;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<SettingDescriptorInfo> getSettingDescriptors() {
        return this.settings;
    }

    public String toString() {
        Stringifier stringifier = new Stringifier();
        stringifier.add("id", this.id);
        stringifier.add("name", this.name);
        stringifier.add("label", this.label);
        stringifier.add("description", this.description);
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        for (String string : this.categoryNames) {
            stringJoiner.add(string);
        }
        stringifier.add("category", stringJoiner.toString());
        return stringifier.toString();
    }

    public static EventTypeInfo from(CompositeData compositeData) {
        if (compositeData == null) {
            return null;
        }
        return new EventTypeInfo(compositeData);
    }
}

