/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.container;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Vector;

import javax.swing.tree.DefaultMutableTreeNode;

/**
 * TransferableNode
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class TransferableNode implements Transferable {

  public static final DataFlavor NODE_FLAVOR = new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType, "Node");
  public static final DataFlavor EXPANDED_STATE_FLAVOR = new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType, "Vector");
  private DefaultMutableTreeNode node;
  private Vector expandedStates;
  private DataFlavor[] flavors = { NODE_FLAVOR, EXPANDED_STATE_FLAVOR };
  public static BufferedImage image = null; // buff image
  public static DefaultMutableTreeNode draggedNode = null;

  public TransferableNode(DefaultMutableTreeNode nd, Vector es) {
    node = nd;
    expandedStates = es;
    draggedNode = node;
  }

  public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
    if (flavor == NODE_FLAVOR) {
      return node;
    } else if (flavor == EXPANDED_STATE_FLAVOR) {
      return expandedStates;
    } else {
      throw new UnsupportedFlavorException(flavor);
    }
  }

  public DataFlavor[] getTransferDataFlavors() {
    return flavors;
  }

  public boolean isDataFlavorSupported(DataFlavor flavor) {
    return Arrays.asList(flavors).contains(flavor);
  }
}
