/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.actions;

import java.awt.event.ActionEvent;
import java.util.Enumeration;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import de.renier.vdr.channel.ChannelElement;
import de.renier.vdr.channel.editor.ChannelEditor;
import de.renier.vdr.channel.editor.Messages;
import de.renier.vdr.channel.editor.util.Utils;

/**
 * MultiRenameAction
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class MultiRenameAction extends AbstractAction {

  private static final long serialVersionUID = -1060977673989725823L;

  public MultiRenameAction() {
    super(Messages.getString("MultiRenameAction.0"), new ImageIcon(OpenAction.class //$NON-NLS-1$
        .getResource("/org/javalobby/icons/20x20/DocumentDraw.gif"))); //$NON-NLS-1$
    this.setEnabled(false);
  }

  /*
   * (non-Javadoc)
   * 
   * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
   */
  public void actionPerformed(ActionEvent e) {
    TreePath treePath = ChannelEditor.application.getChannelListingPanel().getLeadSelectionPath();
    if (treePath != null) {
      // open input dialog to get category name
      String namePrefix = JOptionPane
          .showInputDialog(
                           ChannelEditor.application,
                           Messages.getString("MultiRenameAction.2"), //$NON-NLS-1$
                           Messages.getString("MultiRenameAction.3"), JOptionPane.QUESTION_MESSAGE); //$NON-NLS-1$
      if (!Utils.isEmpty(namePrefix)) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode) treePath.getLastPathComponent();
        // if we are root do rename on all subnodes as well
        if (node.isRoot()) {
          Enumeration enumer = node.children();
          while (enumer.hasMoreElements()) {
            doRename((DefaultMutableTreeNode) enumer.nextElement(), namePrefix);
          }
          doRename(node, namePrefix);
        } else {
          doRename(node, namePrefix);
        }
        // notify structure change
        ChannelEditor.application.getChannelListingPanel().treeNodeStructureChanged(node);
      }
    }
  }

  /**
   * @param node
   */
  private void doRename(DefaultMutableTreeNode node, String prefix) {
    Enumeration enumer = node.children();
    while (enumer.hasMoreElements()) {
      DefaultMutableTreeNode renameNode = (DefaultMutableTreeNode) enumer.nextElement();
      ChannelElement channelElement = (ChannelElement) renameNode.getUserObject();
      if (channelElement.isRadioOrTelevisionOrService()) {
        channelElement.setName(prefix + channelElement.getName());
      }
    }
  }

}
